#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 Mopi
set -o errexit

###
# Symphony
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220206.2

# Set game-specific variables

GAME_ID='symphony'
GAME_NAME='Symphony'

# This installer used to be available for free from Humble Bundle,
# during some time-limited event.
ARCHIVE_BASE_0='Symphony-Linux-2014-07-15.sh'
ARCHIVE_BASE_0_MD5='9218c0b803baf90c34bed2ac1501efa6'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='410000'
ARCHIVE_BASE_0_VERSION='2014.07.15-humble1'

CONTENT_PATH_DEFAULT='data/noarch'
ARCHIVE_DOC_DATA_FILES='
README.linux'
ARCHIVE_GAME_BIN32_PATH='data/x86'
ARCHIVE_GAME_BIN32_FILES='
lib/libfmodex-4.44.20.so
Symphony.bin.x86'
ARCHIVE_GAME_BIN64_PATH='data/x86_64'
ARCHIVE_GAME_BIN64_FILES='
lib64/libfmodex-4.44.20.so
Symphony.bin.x86_64'
ARCHIVE_GAME_DATA_FILES='
*.mdf
*.mtc
Symphony.png
Symphony?soundtrack'

APP_MAIN_TYPE='native'
APP_MAIN_EXE_BIN32='Symphony.bin.x86'
APP_MAIN_EXE_BIN64='Symphony.bin.x86_64'
APP_MAIN_ICON='Symphony.png'

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN32_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6 libGL.so.1 libSDL2-2.0.so.0"

PKG_BIN64_ARCH='64'
PKG_BIN64_DEPS="$PKG_BIN32_DEPS"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	launchers_write 'APP_MAIN'
done

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
