/*
 *	choiceKeyFrameDialog.h - Keyframe selection for optioned properties
 *	Copyright (C) 2018, D Haley 

 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.

 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.

 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
// -*- C++ -*- generated by wxGlade 0.6.5 on Sun Sep 23 22:52:41 2012

#include <wx/wx.h>
// begin wxGlade: ::dependencies
// end wxGlade

#include <vector>

#ifndef CHOICEKEYFRAMEDIALOG_H
#define CHOICEKEYFRAMEDIALOG_H


// begin wxGlade: ::extracode
enum
{
	ID_TEXT_FRAME,
	ID_COMBO_CHOICE
};
// end wxGlade


class ChoiceKeyFrameDialog: public wxDialog {
public:
	// begin wxGlade: ChoiceKeyFrameDialog::ids
	// end wxGlade

	ChoiceKeyFrameDialog(wxWindow* parent, int id, const wxString& title, const wxPoint& pos=wxDefaultPosition, const wxSize& size=wxDefaultSize, long style=wxDEFAULT_DIALOG_STYLE);

	//Set the choices that are allowed to be selected
	void setChoices(const std::vector<std::string> &choices,size_t defaultChoice=0);

	//Obtain the choice from the user
	size_t getChoiceIndex() const { return choice;};
	
	std::string getChoice() const { return choiceStrings[choice];};

	size_t getStartFrame() const { return startFrame;}
private:
	// begin wxGlade: ChoiceKeyFrameDialog::methods
	void set_properties();
	void do_layout();
	// end wxGlade

	//List of choices that can go into the combo box
	std::vector<std::string> choiceStrings;

	//Drop-down value chosen by user
	size_t choice;

	//True if the start frame entered by user is valid
	bool startFrameOK;

	//Current start frame
	size_t startFrame;

	//enable or disable the OK button based upon validation results
	void updateOKButton();

	//build up the combo box items
	void buildCombo(size_t defaultChoice);
protected:
	// begin wxGlade: ChoiceKeyFrameDialog::attributes
	wxStaticText* labelFrame;
	wxTextCtrl* textFrame;
	wxStaticText* labelSelection;
	wxComboBox* comboChoice;
	wxButton* btnCancel;
	wxButton* btnOK;
	// end wxGlade

	DECLARE_EVENT_TABLE();

public:
	virtual void OnChoiceCombo(wxCommandEvent &event); // wxGlade: <event_handler>
	virtual void OnFrameText(wxCommandEvent &event); // wxGlade: <event_handler>
}; // wxGlade: end class


#endif // CHOICEKEYFRAMEDIALOG_H
