# 11 What is the myth of "Natural Law"?

Natural Law, and the related concept of Natural Rights, play an important part
in Libertarian and "anarcho"-capitalist ideology. Right-libertarians are not
alone in claiming that their particular ideology is based on the "law of
nature". Hitler, for one, claimed the same thing for Nazi ideology. So do
numerous other demagogues, religious fanatics, and political philosophers.
However, each likes to claim that only **their** "natural law" is the "real"
one, all the others being subjective impositions. We will ignore these
assertions (they are not arguments) and concentrate on explaining why natural
law, in all its forms, is a myth. In addition, we will indicate its
authoritarian implications.

Instead of such myths anarchists urge people to "work it out for themselves"
and realise that any ethical code is subjective and not a law of nature. If
its a good "code", then others will become convinced of it by your arguments
and their intellect. There is no need to claim its a function of "man's
nature"!

The following books discuss the subject of "Natural Law" in greater depth and
are recommended for a fuller discussion of the issues raised in this section:

Robert Anton Wilson, **Natural Law** and L.A. Rollins, **The Myth of Natural
Law**.

We should note that these books are written by people associated, to some
degree, with right-libertarianism and, of course, we should point out that not
all right-libertarians subscribe to "natural law" theories (David Friedman,
for example, does not). However, such a position seems to be the minority in
right-Libertarianism (Ayn Rand, Robert Nozick and Murray Rothbard, among
others, did subscribe to it). We should also point out that the Individualist
Anarchist Lysander Spooner also subscribed to "natural laws" (which shows
that, as we noted above, the concept is not limited to one particular theory
or ideology). We present a short critique of Spooner's ideas on this subject
in section [G.7](secG7.md).

Lastly, it could be maintained that it is a common "straw man" to maintain
that supporters of Natural Law argue that their Laws are like the laws of
physics (and so are capable of stopping people's actions just as the law of
gravity automatically stops people flying from the Earth). But that is the
whole point -- using the term "Natural Law" implies that the moral rights and
laws that its supporters argue for are to be considered just like the law of
gravity (although they acknowledge, of course, that unlike gravity, **their**
_"natural laws"_ **can be violated in nature**). Far from saying that the
rights they support are just that (i.e. rights **they** think are good) they
try to associate them with universal facts. For example, Lysander Spooner
(who, we must stress, used the concept of "Natural law" to **oppose** the
transformation of America into a capitalist society, unlike Rand, Nozick and
Rothbard who use it to defend capitalism) stated that:

> _"the true definition of law is, that it is a fixed, immutable, natural
principle; and not anything that man ever made, or can make, unmake, or alter.
Thus we speak of the laws of matter, and the laws of mind; of the laws of
gravitation, the laws of light, heat, and electricity. . .etc., etc. . . . The
law of justice is just as supreme and universal in the moral world, as these
others are in the mental or physical world; and is as unalterable as are these
by any human power. And it is just as false and absurd to talk of anybody's
having the power to abolish the law of justice, and set up their own in its
stead, as it would be to talk of their having the power to abolish the law of
gravitation, or any other natural laws of the universe, and set up their own
will in the place of them."_ [**A Letter to Grover Cleveland**, p. 88]

Rothbard and other capitalist supporters of "Natural Law" make the same sort
of claims (as we will see). Now, why, if they are aware of the fact that
unlike gravity their "Natural Laws" can be violated, do they use the term at
all? Benjamin Tucker said that "Natural Law" was a _"religious"_ concept --
and this provides a clue. To say "Do not violate these rights, otherwise I
will get cross" does not have **quite** the same power as "Do not violate
these rights, they are facts of natural and you are violating nature" (compare
to "Do not violate these laws, or you will go to hell"). So to point out that
"Natural Law" is **not** the same as the law of gravity (because it has to be
enforced by humans) is not attacking some kind of "straw man" -- it is
exposing the fact that these "Natural Laws" are just the personal prejudices
of those who hold them. If they do not want then to be exposed as such then
they should call their laws what they are -- personal ethical laws -- rather
than compare them to the facts of nature.

## 11.1 Why the term "Natural Law" in the first place?

Murray Rothbard claims that _"Natural Law theory rests on the insight. . .
that each entity has distinct and specific properties, a distinct 'nature,'
which can be investigated by man's reason"_ [**For a New Liberty**, p. 25] and
that _"man has rights because they are **natural** rights. They are grounded
in the nature of man."_ [**The Ethics of Liberty**, p. 155]

To put it bluntly, this form of "analysis" was originated by Aristotle and has
not been used by science for centuries. Science investigates by proposing
theories and hypotheses to explain empirical observations, testing and
refining them by experiment. In stark contrast, Rothbard **invents**
definitions (_"distinct" "natures"_) and then draws conclusions from them.
Such a method was last used by the medieval Church and is devoid of any
scientific method. It is, of course, a fiction. It attempts to deduce the
nature of a "natural" society from _a priori_ considerations of the "innate"
nature of human beings, which just means that the assumptions necessary to
reach the desired conclusions have been built into the definition of "human
nature." In other words, Rothbard defines humans as having the "distinct and
specific properties" that, given his assumptions, will allow his dogma
(private state capitalism) to be inferred as the "natural" society for humans.

Rothbard claims that _"if A, B, C, etc., have differing attributes, it follows
that they have different **natures.**"_ [**The Ethics of Liberty**, p. 9] Does
this means that as every individual is unique (have different attributes),
they have different natures? Skin and hair colour are different attributes,
does this mean that red haired people have different natures than blondes?
That black people have different natures than white (and such a "theory" of
"natural law" was used to justify slavery -- yes, slaves **are** human but
they have "different natures" than their masters and so slavery is okay). Of
course Rothbard aggregates "attributes" to species level, but why not higher?
Humans are primates, does that mean we have the same natures are monkeys or
gorillas? We are also mammals as well, we share many of the same attributes as
whales and dogs. Do we have similar natures?

But this is by the way. To continue we find that after defining certain
"natures," Rothbard attempts to derive _"Natural Rights and Laws"_ from them.
However, these _"Natural Laws"_ are quite strange, as they can be violated in
nature! Real natural laws (like the law of gravity) **cannot** be violated and
therefore do not need to be enforced. The "Natural Laws" the "Libertarian"
desires to foist upon us are not like this. They need to be enforced by humans
and the institutions they create. Hence, Libertarian "Natural Laws" are more
akin to moral prescriptions or juridical laws. However, this does not stop
Rothbard explicitly _"plac[ing]"_ his _"Natural Laws" "alongside physical or
'scientific' natural laws."_ [**The Ethics of Liberty**, p. 42]

So why do so many Libertarians use the term "Natural Law?" Simply, it gives
them the means by which to elevate their opinions, dogmas, and prejudices to a
metaphysical level where nobody will dare to criticise or even think about
them. The term smacks of religion, where "Natural Law" has replaced "God's
Law." The latter fiction gave the priest power over believers. "Natural Law"
is designed to give the Libertarian ideologist power over the people that he
or she wants to rule.

How can one be against a "Natural Law" or a "Natural Right"? It is impossible.
How can one argue against gravity? If private property, for example, is
elevated to such a level, who would dare argue against it? Ayn Rand listed
having landlords and employers along with _"the laws of nature."_ They are
**not** similar: the first two are social relationships which have to be
imposed by the state; the _"laws of nature"_ (like gravity, needing food,
etc.) are **facts** which do not need to be imposed. Rothbard claims that
_"the natural fact is that labour service **is** indeed a commodity."_ [**Op.
Cit.**, p. 40] However, this is complete nonsense -- labour service as a
commodity is a **social** fact, dependent on the distribution of property
within society, its social customs and so forth. It is only "natural" in the
sense that it exists within a given society (the state is also "natural" as it
also exists within nature at a given time). But neither wage slavery or the
state is "natural" in the sense that gravity is natural or a human having two
arms is. Indeed, workers at the dawn of capitalism, faced with selling their
labour services to another, considered it as decidedly "unnatural" and used
the term "wage slavery" to describe it!

Thus, where and when a "fact" appears is essential. For example, Rothbard
claims that _"[a]n apple, let fall, will drop to the ground; this we all
observe and acknowledge to be **in the nature** of the apple."_ [**The Ethics
of Liberty**, p. 9] Actually, we do not "acknowledge" anything of the kind. We
acknowledge that the apple was subject to the force of gravity and that is why
it fell. The same apple, "let fall" in a space ship would **not** drop to the
floor. Has the "nature" of the apple changed? No, but the situation it is in
has. Thus any attempt to generate abstract "natures" requires you to ignore
reality in favour of ideals.

Because of the confusion its usage creates, we are tempted to think that the
use of "Natural Law" dogma is an attempt to **stop** thinking, to restrict
analysis, to force certain aspects of society off the political agenda by
giving them a divine, everlasting quality.

Moreover, such an "individualist" account of the origins of rights will always
turn on a muddled distinction between individual rationality and some vague
notion of rationality associated with membership of the human species. How are
we to determine what is rational for an individual **as and individual** and
what is rational for that same individual **as a human being**? It is hard to
see that we can make such a distinction for _"[i]f I violently interfere with
Murray Rothbard's freedom, this may violate the 'natural law' of Murray
Rothbard's needs, but it doesn't violate the 'natural law' of **my** needs."_
[L.A. Rollins, **The Myth of Natural Rights**, p. 28] Both parties, after all,
are human and if such interference is, as Rothbard claims, _"antihuman"_ then
why? _"If it helps me, a human, to advance my life, then how can it be
unequivocally 'antihuman'?"_ [L. A. Rollins, **Op. Cit.**, p. 27] Thus
"natural law" is contradictory as it is well within the bounds of human nature
to violate it.

This means that in order to support the dogma of "Natural Law," the cultists
**must** ignore reality. Ayn Rand claims that _"the source of man's rights is.
. .the law of identity. A is A -- and Man is Man."_ But Rand (like Rothbard)
**defines** _"Man"_ as an _"entity of a specific kind -- a rational being"_
[**The Virtue of Selfishness**, pp. 94-95]. Therefore she cannot account for
**irrational** human behaviours (such as those that violate "Natural Laws"),
which are also products of our "nature." To assert that such behaviours are
not human is to assert that A can be not-A, thus contradicting the law of
identity. Her ideology cannot even meet its own test.

## 11.2 But "Natural Law" provides protection for individual rights from
violation by the State. Those who are against Natural Law desire total rule by
the state.

The second statement represents a common "Libertarian" tactic. Instead of
addressing the issues, they accuse an opponent of being a "totalitarian" (or
the less sinister "statist"). In this way, they hope to distract attention
from, and so avoid discussing, the issue at hand (while at the same time
smearing their opponent). We can therefore ignore the second statement.

Regarding the first, "Natural Law" has **never** stopped the rights of
individuals from being violated by the state. Such "laws" are as much use as a
chocolate fire-guard. If "Natural Rights" could protect one from the power of
the state, the Nazis would not have been able to murder six million Jews. The
only thing that stops the state from attacking people's rights is individual
(and social) power -- the ability and desire to protect oneself and what one
considers to be right and fair. As the anarchist Rudolf Rocker pointed out:

> _"Political [or individual] rights do not exist because they have been
legally set down on a piece of paper, but only when they have become the
ingrown habit of a people, and when any attempt to impair them will be meet
with the violent resistance of the populace. . . .One compels respect from
others when he knows how to defend his dignity as a human being. . . .The
people owe all the political rights and privileges which we enjoy today, in
greater or lesser measure, not to the good will of their governments, but to
their own strength."_ [**Anarcho-Syndicalism**, p. 64]

Of course, if is there are no "Natural Rights," then the state has no "right"
to murder you or otherwise take away what are commonly regarded as human
rights. One can object to state power without believing in "Natural Law."

## 11.3 Why is "Natural Law" authoritarian?

Rights, far from being fixed, are the product of social evolution and human
action, thought and emotions. What is acceptable now may become unacceptable
in the future. Slavery, for example, was long considered "natural." In fact,
John Locke, the "father" of "Natural Rights," was heavily involved in the
slave trade. He made a fortune in violating what is today regarded as a basic
human right: not to be enslaved. Many in Locke's day claimed that slavery was
a "Natural Law." Few would say so now.

Thomas Jefferson indicates exactly why "Natural Law" is authoritarian when he
wrote _"[s]ome men look at constitutions with sanctimonious reverence, and
deem them like the ark of the Covenant, too sacred to be touched. They ascribe
to the men of the preceding age a wisdom more than human, and suppose what
they did to be beyond amendment. . .laws and institutions must go hand in hand
with the progress of the human mind. . . as that becomes more developed, more
enlightened, as new discoveries are made, institutions must advance also, to
keep pace with the times. . . We might as well require a man to wear still the
coat which fitted him when a boy as civilised society to remain forever under
the regimen of their barbarous ancestors."_

The "Natural Law" cult desires to stop the evolutionary process by which new
rights are recognised. Instead they wish to fix social life into what **they**
think is good and right, using a form of argument that tries to raise their
ideology above critique or thought. Such a wish is opposed to the fundamental
feature of liberty: the ability to think for oneself. Michael Bakunin writes
_"the liberty of man consists solely in this: that he obeys natural laws
because he has **himself** recognised them as such, and not because they have
been externally imposed upon him by any extrinsic will whatever, divine or
human, collective or individual."_ [**Bakunin on Anarchism**, p. 227]

Thus anarchism, in contrast to the "natural law" cult, recognises that
"natural laws" (like society) are the product of individual evaluation of
reality and social life and are, therefore, subject to change in the light of
new information and ideas (Society _"progresses slowly through the moving
power of individual initiative"_ [Bakunin, **The Political Philosophy of
Bakunin**, p. 166] and so, obviously, do social rights and customs). Ethical
or moral "laws" (which is what the "Natural Law" cult is actually about) is
not a product of "human nature" or abstract individuals. Rather, it is a
**social** fact, a creation of society and human interaction. In Bakunin's
words, _"moral law is not an individual but a social fact, a creation of
society"_ and any _"natural laws"_ are _"inherent in the social body"_ (and
so, we must add, not floating abstractions existing in "man's nature").
[**Ibid.**, p. 125, p. 166]

The case for liberty and a free society is based on the argument that, since
every individual is unique, everyone can contribute something that no one else
has noticed or thought about. It is the free interaction of individuals which
allows them, along with society and its customs and rights, to evolve, change
and develop. "Natural Law," like the state, tries to arrest this evolution. It
replaces creative inquiry with dogma, making people subject to yet another
god, destroying critical thought with a new rule book.

In addition, if these "Natural Laws" are really what they are claimed to be,
they are necessarily applicable to **all** of humanity (Rothbard explicitly
acknowledges this when he wrote that _"one of the notable attributes of
natural law"_ is _"its applicability to all men, regardless of time or place"_
[**The Ethics of Liberty**, p. 42]). In other words, every other law code
**must** (by definition) be "against nature" and there exists **one** way of
life (the "natural" one). The authoritarian implications of such arrogance is
clear. That the Dogma of Natural Law was only invented a few hundred years
ago, in one part of the planet, does not seem to bother its advocates. Nor
does the fact that for the vast majority of human existence, people have lived
in societies which violated almost **all** of their so-called "Natural Laws"
To take one example, before the late Neolithic, most societies were based on
usufruct, or free access to communally held land and other resources [see
Murray Bookchin, **The Ecology of Freedom**]. Thus for millennia, all human
beings lived in violation of the supposed "Natural Law" of private property --
perhaps the chief "law" in the "Libertarian" universe.

If "Natural Law" did exist, then all people would have discovered these "true"
laws years ago. To the contrary, however, the debate is still going on, with
(for example) fascists and "Libertarians" each claiming "the laws of nature"
(and socio-biology) as their own.

## 11.4 Does "Natural Law" actually provides protection for individual
liberty?

But, it seems fair to ask, does "natural law" actually respect individuals and
their rights (i.e. liberty)? We think not. Why?

According to Rothbard, _"the natural law ethic states that for man, goodness
or badness can be determined by what fulfils or thwarts what is best for man's
nature."_ [**The Ethics of Liberty**, p. 10] But, of course, what may be
"good" for "man" may be decidedly **bad** for men (and women). If we take the
example of the sole oasis in a desert (see section
[4.2](append134.md#secf42)) then, according to Rothbard, the property owner
having the power of life and death over others is "good" while, if the
dispossessed revolt and refuse to recognise his "property", this is "bad"! In
other words, Rothbard's "natural law" is good for **some** people (namely
property owners) while it can be bad for others (namely the working class). In
more general terms, this means that a system which results in extensive
hierarchy (i.e. **archy**, power) is "good" (even though it restricts liberty
for the many) while attempts to **remove** power (such as revolution and the
democratisation of property rights) is "bad". Somewhat strange logic, we feel.

However such a position fails to understand **why** we consider coercion to be
wrong/unethical. Coercion is wrong because it subjects an individual to the
will of another. It is clear that the victim of coercion is lacking the
freedom that the philosopher Isaiah Berlin describes in the following terms:

> _"I wish my life and decisions to depend on myself, not on external forces
of whatever kind. I wish to be an instrument of my own, not of other men's,
acts of will. I wish to be a subject, not an object; to be moved by reasons,
by conscious purposes, which are my own, not by causes which affect me, as it
were, from outside. I wish to be somebody, not nobody; a doer -- deciding, not
being decided for, self-directed and not acted upon by external nature or by
other mean as if I were a thing, or an animal, or a slave incapable of playing
a human role, that is, of conceiving goals and policies of my own and
realising them."_ [**Four Essays on Liberty**, p. 131]

Or, as Alan Haworth points out, _"we have to view coercion as a violation of
what Berlin calls **positive** freedom."_ [**Anti-Libertarianism**, p. 48]

Thus, if a system results in the violation of (positive) liberty by its very
nature -- namely, subject a class of people to the will of another class (the
worker is subject to the will of their boss and is turned into an order-taker)
-- then it is justified to end that system. Yes, it is "coercion" is
dispossess the property owner -- but "coercion" exists only for as long as
they desire to exercise power over others. In other words, it is not
domination to remove domination! And remember it is the domination that exists
in coercion which fuels our hatred of it, thus "coercion" to free ourselves
from domination is a necessary evil in order to stop far greater evils
occurring (as, for example, in the clear-cut case of the oasis monopoliser).

Perhaps it will be argued that domination is only bad when it is involuntary,
which means that it is only the involuntary nature of coercion that makes it
bad, not the domination it involves. By this argument wage slavery is not
domination as workers voluntarily agree to work for a capitalist (after all,
no one puts a gun to their heads) and any attempt to overthrow capitalist
domination is coercion and so wrong. However, this argument ignores that fact
that **circumstances** force workers to sell their liberty and so violence on
behalf of property owners is not (usually) required -- market forces ensure
that physical force is purely "defensive" in nature. And as we argued in
section [2.2](append132.md#secf22), even Rothbard recognised that the
economic power associated with one class of people being dispossessed and
another empowered by this fact results in relations of domination which cannot
be considered "voluntary" by any stretch of the imagination (although, of
course, Rothbard refuses to see the economic power associated with capitalism
-- when its capitalism, he cannot see the wood for the trees -- and we are
ignoring the fact that capitalism was created by extensive use of coercion and
violence -- see section [8](append138.md)).

Thus, "Natural law" and attempts to protect individuals rights/liberty and see
a world in which people are free to shape their own lives are fatally flawed
if they do not recognise that private property is incompatible with these
goals. This is because the existence of capitalist property smuggles in power
and so domination (the restriction of liberty, the conversion of some into
order-givers and the many into order-takers) and so Natural Law does not
fulfil its promise that each person is free to pursue their own goals. The
unqualified right of property will lead to the domination and degradation of
large numbers of people (as the oasis monopoliser so graphically illustrates).

And we stress that anarchists have no desire to harm individuals, only to
change institutions. If a workplace is taken over by its workers, the owners
are not harmed physically. If the oasis is taken from the monopoliser, the ex-
monopoliser becomes like other users of the oasis (although probably
**disliked** by others). Thus anarchists desire to treat people as fairly as
possible and not replace one form of coercion and domination with another --
individuals must **never** be treated as abstractions (if they have power over
you, destroy what creates the relation of domination, **not** the individual,
in other words! And if this power can be removed without resorting to force,
so much the better -- a point which social and individualist anarchists
disagree on, namely whether capitalism can be reformed away or not comes
directly from this. As the Individualists think it can, they oppose the use of
force. Most social anarchists think it cannot, and so support revolution).

This argument may be considered as "utilitarian" (the greatest good for the
greatest number) and so treats people not as "ends in themselves" but as
"means to an end". Thus, it could be argued, "natural law" is required to
ensure that **all** (as opposed to some, or many, or the majority of)
individuals are free and have their rights protected.

However, it is clear that "natural law" can easily result in a minority having
their freedom and rights respected, while the majority are forced by
circumstances (created by the rights/laws produced by applying "natural law"
we must note) to sell their liberty and rights in order to survive. If it is
wrong to treat anyone as a "means to an end", then it is equally wrong to
support a theory or economic system that results in people having to negate
themselves in order to live. A respect for persons -- to treat them as ends
and never as means -- is not compatible with private property.

The simple fact is that **there are no easy answers** \-- we need to weight up
our options and act on what we think is best. Yes, such subjectivism lacks the
"elegance" and simplicity of "natural law" but it reflects real life and
freedom far better. All in all, we must always remember that what is "good"
for man need not be good for people. "Natural law" fails to do this and stands
condemned.

## 11.5 But Natural Law was discovered, not invented!

This statement truly shows the religious nature of the Natural Law cult. To
see why its notion of "discovery" is confused, let us consider the Law of
Gravity. Newton did not "discover" the law of gravity, he invented a theory
which explained certain observed phenomena in the physical world. Later
Einstein updated Newton's theories in ways that allowed for a better
explanation of physical reality. Thus, unlike "Natural Law," scientific laws
can be updated and changed as our knowledge changes and grows. As we have
already noted, however, "Natural Laws" cannot be updated because they are
derived from fixed definitions (Rothbard is pretty clear on this, he states
that it is _"[v]ery true"_ that natural law is _"universal, fixed and
immutable"_ and so are _"'absolute' principles of justice"_ and that they are
_"independent of time and place"_ [**The Ethics of Liberty**, p. 19]).
However, what he fails to understand is that what the "Natural Law" cultists
are "discovering" are simply the implications of their own definitions, which
in turn simply reflect their own prejudices and preferences.

Since "Natural Laws" are thus "unchanging" and are said to have been
"discovered" centuries ago, it's no wonder that many of its followers look for
support in socio-biology, claiming that their "laws" are part of the genetic
structure of humanity. But socio-biology has dubious scientific credentials
for many of its claims. Also, it has authoritarian implications **exactly**
like Natural Law. Murray Bookchin rightly characterises socio-biology as
_"suffocatingly rigid; it not only impedes action with the autocracy of a
genetic tyrant but it closes the door to any action that is not biochemically
defined by its own configuration. When freedom is nothing more than the
recognition of necessity. . .we discover the gene's tyranny over the greater
totality of life. . .when knowledge becomes dogma (and few movements are more
dogmatic than socio-biology) freedom is ultimately denied."_ [_"Socio-biology
or Social Ecology"_, in **Which way for the Ecology Movement?** pp. 49 - 75,
p. 60]

In conclusion the doctrine of Natural Law, far from supporting individual
freedom, is one of its greatest enemies. By locating individual rights within
"Man's Nature," it becomes an unchanging set of dogmas. Do we really know
enough about humanity to say what are "Natural" and universal Laws, applicable
forever? Is it not a rejection of critical thinking and thus individual
freedom to do so?

## 11.6 Why is the notion of "discovery" contradictory?

Ayn Rand indicates the illogical and contradictory nature of the concepts of
"discovering" "natural law" and the "natural rights" this "discovery" argument
creates when she stated that her theory was _"objective."_ Her "Objectivist"
political theory _"holds that good is neither an attribute of 'things in
themselves' nor man's emotional state, but **an evaluation** of the facts of
reality by man's consciousness according to a rational standard of value. . .
The objective theory holds that **the good is an aspect of reality in relation
to man** \- and that it must be discovered, not invented, by man."_
[**Capitalism: The Unknown Ideal**, p. 22]

However, this is playing with words. If something is "discovered" then it has
always been there and so is an intrinsic part of it. If "good" **is**
"discovered" by "man" then "good" exists independently of people -- it is
waiting to be "discovered." In other words, "good" is an attribute of _"man as
man,"_ of _"things in themselves"_ (in addition, such a theory also implies
that there is just **one** possible interpretation of what is "good" for all
humanity). This can be seen when Rand talks about her system of "objective"
values and rights.

When discussing the difference between _"subjective,"_ _"intrinsic"_ and
_"objective"_ values Rand noted that _"intrinsic"_ and _"subjective"_ theories
_"make it possible for a man to believe what is good is independent of man's
mind and can be achieved by physical force."_ [**Op. Cit.**, p. 22] In other
words, intrinsic and subjective values justify tyranny. However, her
_"objective"_ values are placed squarely in _"Man's Nature"_ \-- she states
that _"[i]ndividual rights are the means of subordinating society to moral
law"_ and that _"the source of man's rights is man's nature."_ [**Op. Cit.**,
p. 320, p. 322]

She argues that the _"**intrinsic** theory holds that the good is inherent in
certain things or actions, as such, regardless of their context and
consequences, regardless of any benefit or injury they may cause to the actors
and subjects involved."_ [**Op. Cit.**, p. 21] According to the **Concise
Oxford Dictionary**, _"intrinsic"_ is defined as _"inherent,"_ _"essential,"_
_"belonging naturally"_ and defines _"nature"_ as _"a thing's, or person's,
innate or essential qualities or character."_ In other words, if, as Rand
maintains, man's rights **are** the product of _"man's nature"_ then such
rights are **intrinsic**! And if, as Rand maintains, such rights are the
_"extension of morality into the social system"_ then morality itself is also
intrinsic.

Again, her ideology fails to meet its own tests -- and opens the way for
tyranny. This can be seen by her whole hearted support for wage slavery and
her total lack of concern how it, and concentrations of wealth and power,
affect the individuals subjected to them. For, after all, what is "good" is
"inherent" in capitalism, regardless of the context, consequences, benefits or
injuries it may cause to the actors and subjects involved.

The key to understanding her contradictory and illogical ideology lies in her
contradictory use of the word "man." Sometimes she uses it to describe
individuals but usually it is used to describe the human race collectively
(_"man's nature," "man's consciousness"_). But "Man" does not have a
consciousness, only individuals do. Man is an abstraction, it is individuals
who live and think, not "Man." Such "Man worship" -- like Natural Law -- has
all the markings of a religion.

As Max Stirner argues _"liberalism is a religion because it separates my
essence from me and sets it above me, because it exalts 'Man' to the same
extent as any other religion does to God. . . it sets me beneath Man."_ [**The
Ego and Its Own**, p. 176] Indeed, he _"who is infatuated with **Man** leaves
persons out of account so far as that infatuation extends, and floats in an
ideal, sacred interest. **Man**, you see, is not a person, but an ideal, a
spook."_ [**Op. Cit.**, p.79]

Rand argues that we must evaluate _"the facts of reality by man's
consciousness according to a rational standard of value"_ but who determines
that value? She states that _"[v]alues are not determined by fiat nor by
majority vote"_ [p. 24] but, however, neither can they be determined by "man"
or "man's consciousness" because "man" does not exist. Individuals exist and
have consciousness and because they are unique have different values (but as
we argued in section [A.2.19](secA2.md#seca219), being social creatures
these values are generalised across individuals into social, i.e. objective,
values). So, the abstraction "man" does not exist and because of this we see
the healthy sight of different individuals convincing others of their ideas
and theories by discussion, presenting facts and rational debate. This can be
best seen in scientific debate.

The aim of the scientific method is to invent theories that explain facts, the
theories are not part of the facts but created by the individual's mind in
order to explain those facts. Such scientific "laws" can and do change in
light of new information and new thought. In other words, the scientific
method is the creation of subjective theories that explain the objective
facts. Rand's method is the opposite - she assumes "man's nature," "discovers"
what is "good" from those assumptions and draws her theories by deduction from
that. This is the **exact** opposite of the scientific method and, as we noted
above, comes to us straight from the Roman Catholic church.

It is the subjective revolt by individuals against what is considered
"objective" fact or "common sense" which creates progress and develops ethics
(what is considered "good" and "right") and society. This, in turn, becomes
"accepted fact" until the next free thinker comes along and changes how we
view the world by presenting **new** evidence, re-evaluating old ideas and
facts or exposing the evil effects associated with certain ideas (and the
social relationships they reflect) by argument, fact and passion. Attempts to
impose _"an evaluation of the facts of reality by man's consciousness"_ would
be a death blow to this process of critical thought, development and
evaluation of the facts of reality by individual's consciousness. Human
thought would be subsumed by dogma.

[‹ 10 Would laissez-faire capitalism be stable?](append1310.md "Go to
previous page" ) [up](append13.md "Go to parent page" ) [Appendix - The
Symbols of Anarchy ›](append2.md "Go to next page" )

