MACRO(CONFIGURE_WINDOWS_FRONTEND _NAME_TARGET _ONLY_DEFINES)
    SET(PREVIOUS_INVOCATION ${CONFIGURE_WINDOWS_FRONTEND_INVOKED_PREVIOUSLY})
    IF(NOT _ONLY_DEFINES)
        IF(NOT PREVIOUS_INVOCATION)
            ADD_LIBRARY(OurWindowsZLib SHARED IMPORTED)
            SET_TARGET_PROPERTIES(OurWindowsZLib PROPERTIES IMPORTED_IMPLIB "${CMAKE_CURRENT_SOURCE_DIR}/src/win/lib/zlib.lib")
            TARGET_INCLUDE_DIRECTORIES(OurWindowsZLib INTERFACE "${CMAKE_CURRENT_SOURCE_DIR}/src/win/include")
            ADD_LIBRARY(OurWindowsPNGLib SHARED IMPORTED)
            SET_TARGET_PROPERTIES(OurWindowsPNGLib PROPERTIES IMPORTED_IMPLIB "${CMAKE_CURRENT_SOURCE_DIR}/src/win/lib/libpng.lib")
            TARGET_INCLUDE_DIRECTORIES(OurWindowsPNGLib INTERFACE "${CMAKE_CURRENT_SOURCE_DIR}/src/win/include")
        ENDIF()
        TARGET_LINK_LIBRARIES(${_NAME_TARGET} PRIVATE OurWindowsZLib OurWindowsPNGLib msimg32 winmm)
        SET_TARGET_PROPERTIES(${_NAME_TARGET} PROPERTIES WIN32_EXECUTABLE ON)
    ENDIF()
    TARGET_COMPILE_DEFINITIONS(${_NAME_TARGET} PRIVATE -D USE_WIN)
    TARGET_COMPILE_DEFINITIONS(${_NAME_TARGET} PRIVATE -D USE_PRIVATE_PATHS)
    TARGET_COMPILE_DEFINITIONS(${_NAME_TARGET} PRIVATE -D SOUND)
    TARGET_COMPILE_DEFINITIONS(${_NAME_TARGET} PRIVATE -D WINDOWS)
    TARGET_COMPILE_DEFINITIONS(${_NAME_TARGET} PRIVATE -D _CRT_SECURE_NO_WARNINGS)
    IF(NOT PREVIOUS_INVOCATION)
        MESSAGE(STATUS "Support for Windows front end - Ready")
    ENDIF()
    SET(CONFIGURE_WINDOWS_FRONTEND_INVOKED_PREVIOUSLY YES CACHE
        INTERNAL "Mark if CONFIGURE_WINDOWS_FRONTEND called successfully" FORCE)
ENDMACRO()
