/* Copyright (C) 2013-2016, The Regents of The University of Michigan.
All rights reserved.
This software was developed in the APRIL Robotics Lab under the
direction of Edwin Olson, ebolson@umich.edu. This software may be
available under alternative licensing terms; contact the address above.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the Regents of The University of Michigan.
*/

#include <stdlib.h>
#include "apriltag.h"

apriltag_family_t *tagCustom48h12_create()
{
   apriltag_family_t *tf = calloc(1, sizeof(apriltag_family_t));
   tf->name = strdup("tagCustom48h12");
   tf->h = 12;
   tf->ncodes = 42211;
   tf->codes = calloc(42211, sizeof(uint64_t));
   tf->codes[0] = 0x0000d6c8ae76dff0UL;
   tf->codes[1] = 0x0000d6c8e905e5b5UL;
   tf->codes[2] = 0x0000d6c92394eb7aUL;
   tf->codes[3] = 0x0000d6c95e23f13fUL;
   tf->codes[4] = 0x0000d6c998b2f704UL;
   tf->codes[5] = 0x0000d6c9d341fcc9UL;
   tf->codes[6] = 0x0000d6ca0dd1028eUL;
   tf->codes[7] = 0x0000d6ca48600853UL;
   tf->codes[8] = 0x0000d6ca82ef0e18UL;
   tf->codes[9] = 0x0000d6cabd7e13ddUL;
   tf->codes[10] = 0x0000d6caf80d19a2UL;
   tf->codes[11] = 0x0000d6cb329c1f67UL;
   tf->codes[12] = 0x0000d6cb6d2b252cUL;
   tf->codes[13] = 0x0000d6cba7ba2af1UL;
   tf->codes[14] = 0x0000d6cc1cd8367bUL;
   tf->codes[15] = 0x0000d6cc57673c40UL;
   tf->codes[16] = 0x0000d6cc91f64205UL;
   tf->codes[17] = 0x0000d6cccc8547caUL;
   tf->codes[18] = 0x0000d6cd41a35354UL;
   tf->codes[19] = 0x0000d6cdb6c15edeUL;
   tf->codes[20] = 0x0000d6cdf15064a3UL;
   tf->codes[21] = 0x0000d6ce2bdf6a68UL;
   tf->codes[22] = 0x0000d6ce666e702dUL;
   tf->codes[23] = 0x0000d6cea0fd75f2UL;
   tf->codes[24] = 0x0000d6cedb8c7bb7UL;
   tf->codes[25] = 0x0000d6cf161b817cUL;
   tf->codes[26] = 0x0000d6cf50aa8741UL;
   tf->codes[27] = 0x0000d6cf8b398d06UL;
   tf->codes[28] = 0x0000d6cfc5c892cbUL;
   tf->codes[29] = 0x0000d6d000579890UL;
   tf->codes[30] = 0x0000d6d03ae69e55UL;
   tf->codes[31] = 0x0000d6d07575a41aUL;
   tf->codes[32] = 0x0000d6d0b004a9dfUL;
   tf->codes[33] = 0x0000d6d0ea93afa4UL;
   tf->codes[34] = 0x0000d6d12522b569UL;
   tf->codes[35] = 0x0000d6d19a40c0f3UL;
   tf->codes[36] = 0x0000d6d1d4cfc6b8UL;
   tf->codes[37] = 0x0000d6d249edd242UL;
   tf->codes[38] = 0x0000d6d2f99ae391UL;
   tf->codes[39] = 0x0000d6d33429e956UL;
   tf->codes[40] = 0x0000d6d36eb8ef1bUL;
   tf->codes[41] = 0x0000d6d3a947f4e0UL;
   tf->codes[42] = 0x0000d6d3e3d6faa5UL;
   tf->codes[43] = 0x0000d6d41e66006aUL;
   tf->codes[44] = 0x0000d6d458f5062fUL;
   tf->codes[45] = 0x0000d6d493840bf4UL;
   tf->codes[46] = 0x0000d6d4ce1311b9UL;
   tf->codes[47] = 0x0000d6d543311d43UL;
   tf->codes[48] = 0x0000d6d57dc02308UL;
   tf->codes[49] = 0x0000d6d5f2de2e92UL;
   tf->codes[50] = 0x0000d6d62d6d3457UL;
   tf->codes[51] = 0x0000d6d667fc3a1cUL;
   tf->codes[52] = 0x0000d6d6dd1a45a6UL;
   tf->codes[53] = 0x0000d6d717a94b6bUL;
   tf->codes[54] = 0x0000d6d752385130UL;
   tf->codes[55] = 0x0000d6d7c7565cbaUL;
   tf->codes[56] = 0x0000d6d801e5627fUL;
   tf->codes[57] = 0x0000d6d83c746844UL;
   tf->codes[58] = 0x0000d6d8b19273ceUL;
   tf->codes[59] = 0x0000d6d8ec217993UL;
   tf->codes[60] = 0x0000d6d9d65d90a7UL;
   tf->codes[61] = 0x0000d6da10ec966cUL;
   tf->codes[62] = 0x0000d6da4b7b9c31UL;
   tf->codes[63] = 0x0000d6dac099a7bbUL;
   tf->codes[64] = 0x0000d6dafb28ad80UL;
   tf->codes[65] = 0x0000d6db35b7b345UL;
   tf->codes[66] = 0x0000d6db7046b90aUL;
   tf->codes[67] = 0x0000d6dbaad5becfUL;
   tf->codes[68] = 0x0000d6dbe564c494UL;
   tf->codes[69] = 0x0000d6dc1ff3ca59UL;
   tf->codes[70] = 0x0000d6dc9511d5e3UL;
   tf->codes[71] = 0x0000d6dd7f4decf7UL;
   tf->codes[72] = 0x0000d6ddb9dcf2bcUL;
   tf->codes[73] = 0x0000d6de2efafe46UL;
   tf->codes[74] = 0x0000d6de698a040bUL;
   tf->codes[75] = 0x0000d6dea41909d0UL;
   tf->codes[76] = 0x0000d6df1937155aUL;
   tf->codes[77] = 0x0000d6df8e5520e4UL;
   tf->codes[78] = 0x0000d6e003732c6eUL;
   tf->codes[79] = 0x0000d6e0789137f8UL;
   tf->codes[80] = 0x0000d6e0b3203dbdUL;
   tf->codes[81] = 0x0000d6e1283e4947UL;
   tf->codes[82] = 0x0000d6e162cd4f0cUL;
   tf->codes[83] = 0x0000d6e19d5c54d1UL;
   tf->codes[84] = 0x0000d6e1d7eb5a96UL;
   tf->codes[85] = 0x0000d6e2127a605bUL;
   tf->codes[86] = 0x0000d6e2c22771aaUL;
   tf->codes[87] = 0x0000d6e2fcb6776fUL;
   tf->codes[88] = 0x0000d6e337457d34UL;
   tf->codes[89] = 0x0000d6e3ac6388beUL;
   tf->codes[90] = 0x0000d6e3e6f28e83UL;
   tf->codes[91] = 0x0000d6e421819448UL;
   tf->codes[92] = 0x0000d6e45c109a0dUL;
   tf->codes[93] = 0x0000d6e4969f9fd2UL;
   tf->codes[94] = 0x0000d6e4d12ea597UL;
   tf->codes[95] = 0x0000d6e50bbdab5cUL;
   tf->codes[96] = 0x0000d6e5464cb121UL;
   tf->codes[97] = 0x0000d6e580dbb6e6UL;
   tf->codes[98] = 0x0000d6e5f5f9c270UL;
   tf->codes[99] = 0x0000d6e63088c835UL;
   tf->codes[100] = 0x0000d6e66b17cdfaUL;
   tf->codes[101] = 0x0000d6e6e035d984UL;
   tf->codes[102] = 0x0000d6e71ac4df49UL;
   tf->codes[103] = 0x0000d6e75553e50eUL;
   tf->codes[104] = 0x0000d6e7ca71f098UL;
   tf->codes[105] = 0x0000d6e8b4ae07acUL;
   tf->codes[106] = 0x0000d6e8ef3d0d71UL;
   tf->codes[107] = 0x0000d6e929cc1336UL;
   tf->codes[108] = 0x0000d6e9645b18fbUL;
   tf->codes[109] = 0x0000d6ea14082a4aUL;
   tf->codes[110] = 0x0000d6ea892635d4UL;
   tf->codes[111] = 0x0000d6eac3b53b99UL;
   tf->codes[112] = 0x0000d6eafe44415eUL;
   tf->codes[113] = 0x0000d6eb73624ce8UL;
   tf->codes[114] = 0x0000d6ec5d9e63fcUL;
   tf->codes[115] = 0x0000d6ec982d69c1UL;
   tf->codes[116] = 0x0000d6ed0d4b754bUL;
   tf->codes[117] = 0x0000d6ed47da7b10UL;
   tf->codes[118] = 0x0000d6ed826980d5UL;
   tf->codes[119] = 0x0000d6edf7878c5fUL;
   tf->codes[120] = 0x0000d6ee32169224UL;
   tf->codes[121] = 0x0000d6eee1c3a373UL;
   tf->codes[122] = 0x0000d6ef56e1aefdUL;
   tf->codes[123] = 0x0000d6efcbffba87UL;
   tf->codes[124] = 0x0000d6f0411dc611UL;
   tf->codes[125] = 0x0000d6f07baccbd6UL;
   tf->codes[126] = 0x0000d6f0b63bd19bUL;
   tf->codes[127] = 0x0000d6f0f0cad760UL;
   tf->codes[128] = 0x0000d6f12b59dd25UL;
   tf->codes[129] = 0x0000d6f1db06ee74UL;
   tf->codes[130] = 0x0000d6f28ab3ffc3UL;
   tf->codes[131] = 0x0000d6f2c5430588UL;
   tf->codes[132] = 0x0000d6f2ffd20b4dUL;
   tf->codes[133] = 0x0000d6f33a611112UL;
   tf->codes[134] = 0x0000d6f3ea0e2261UL;
   tf->codes[135] = 0x0000d6f4249d2826UL;
   tf->codes[136] = 0x0000d6f45f2c2debUL;
   tf->codes[137] = 0x0000d6f499bb33b0UL;
   tf->codes[138] = 0x0000d6f5496844ffUL;
   tf->codes[139] = 0x0000d6f5be865089UL;
   tf->codes[140] = 0x0000d6f5f915564eUL;
   tf->codes[141] = 0x0000d6f633a45c13UL;
   tf->codes[142] = 0x0000d6f6a8c2679dUL;
   tf->codes[143] = 0x0000d6f7586f78ecUL;
   tf->codes[144] = 0x0000d6f7cd8d8476UL;
   tf->codes[145] = 0x0000d6f842ab9000UL;
   tf->codes[146] = 0x0000d6f87d3a95c5UL;
   tf->codes[147] = 0x0000d6f8b7c99b8aUL;
   tf->codes[148] = 0x0000d6f92ce7a714UL;
   tf->codes[149] = 0x0000d6f96776acd9UL;
   tf->codes[150] = 0x0000d6f9dc94b863UL;
   tf->codes[151] = 0x0000d6fa1723be28UL;
   tf->codes[152] = 0x0000d6fa51b2c3edUL;
   tf->codes[153] = 0x0000d6fac6d0cf77UL;
   tf->codes[154] = 0x0000d6fbb10ce68bUL;
   tf->codes[155] = 0x0000d6fbeb9bec50UL;
   tf->codes[156] = 0x0000d6fc9b48fd9fUL;
   tf->codes[157] = 0x0000d6fd10670929UL;
   tf->codes[158] = 0x0000d6fdc0141a78UL;
   tf->codes[159] = 0x0000d6fdfaa3203dUL;
   tf->codes[160] = 0x0000d6ff1f6e3d16UL;
   tf->codes[161] = 0x0000d6ff948c48a0UL;
   tf->codes[162] = 0x0000d70009aa542aUL;
   tf->codes[163] = 0x0000d700443959efUL;
   tf->codes[164] = 0x0000d7007ec85fb4UL;
   tf->codes[165] = 0x0000d700b9576579UL;
   tf->codes[166] = 0x0000d700f3e66b3eUL;
   tf->codes[167] = 0x0000d7012e757103UL;
   tf->codes[168] = 0x0000d701690476c8UL;
   tf->codes[169] = 0x0000d701a3937c8dUL;
   tf->codes[170] = 0x0000d701de228252UL;
   tf->codes[171] = 0x0000d70218b18817UL;
   tf->codes[172] = 0x0000d70253408ddcUL;
   tf->codes[173] = 0x0000d7028dcf93a1UL;
   tf->codes[174] = 0x0000d702c85e9966UL;
   tf->codes[175] = 0x0000d70302ed9f2bUL;
   tf->codes[176] = 0x0000d7033d7ca4f0UL;
   tf->codes[177] = 0x0000d703780baab5UL;
   tf->codes[178] = 0x0000d703b29ab07aUL;
   tf->codes[179] = 0x0000d703ed29b63fUL;
   tf->codes[180] = 0x0000d70427b8bc04UL;
   tf->codes[181] = 0x0000d7046247c1c9UL;
   tf->codes[182] = 0x0000d704d765cd53UL;
   tf->codes[183] = 0x0000d70511f4d318UL;
   tf->codes[184] = 0x0000d7054c83d8ddUL;
   tf->codes[185] = 0x0000d7058712dea2UL;
   tf->codes[186] = 0x0000d705c1a1e467UL;
   tf->codes[187] = 0x0000d705fc30ea2cUL;
   tf->codes[188] = 0x0000d70636bfeff1UL;
   tf->codes[189] = 0x0000d706714ef5b6UL;
   tf->codes[190] = 0x0000d706abddfb7bUL;
   tf->codes[191] = 0x0000d70720fc0705UL;
   tf->codes[192] = 0x0000d7075b8b0ccaUL;
   tf->codes[193] = 0x0000d707961a128fUL;
   tf->codes[194] = 0x0000d707d0a91854UL;
   tf->codes[195] = 0x0000d7080b381e19UL;
   tf->codes[196] = 0x0000d70845c723deUL;
   tf->codes[197] = 0x0000d708805629a3UL;
   tf->codes[198] = 0x0000d708bae52f68UL;
   tf->codes[199] = 0x0000d708f574352dUL;
   tf->codes[200] = 0x0000d7096a9240b7UL;
   tf->codes[201] = 0x0000d709a521467cUL;
   tf->codes[202] = 0x0000d709dfb04c41UL;
   tf->codes[203] = 0x0000d70a1a3f5206UL;
   tf->codes[204] = 0x0000d70a54ce57cbUL;
   tf->codes[205] = 0x0000d70a8f5d5d90UL;
   tf->codes[206] = 0x0000d70ac9ec6355UL;
   tf->codes[207] = 0x0000d70b047b691aUL;
   tf->codes[208] = 0x0000d70b3f0a6edfUL;
   tf->codes[209] = 0x0000d70b799974a4UL;
   tf->codes[210] = 0x0000d70bb4287a69UL;
   tf->codes[211] = 0x0000d70beeb7802eUL;
   tf->codes[212] = 0x0000d70c294685f3UL;
   tf->codes[213] = 0x0000d70c63d58bb8UL;
   tf->codes[214] = 0x0000d70cd8f39742UL;
   tf->codes[215] = 0x0000d70d13829d07UL;
   tf->codes[216] = 0x0000d70d4e11a2ccUL;
   tf->codes[217] = 0x0000d70d88a0a891UL;
   tf->codes[218] = 0x0000d70dc32fae56UL;
   tf->codes[219] = 0x0000d70dfdbeb41bUL;
   tf->codes[220] = 0x0000d70e72dcbfa5UL;
   tf->codes[221] = 0x0000d70ead6bc56aUL;
   tf->codes[222] = 0x0000d70ee7facb2fUL;
   tf->codes[223] = 0x0000d70f2289d0f4UL;
   tf->codes[224] = 0x0000d70f5d18d6b9UL;
   tf->codes[225] = 0x0000d70f97a7dc7eUL;
   tf->codes[226] = 0x0000d71081e3f392UL;
   tf->codes[227] = 0x0000d710bc72f957UL;
   tf->codes[228] = 0x0000d711319104e1UL;
   tf->codes[229] = 0x0000d711a6af106bUL;
   tf->codes[230] = 0x0000d711e13e1630UL;
   tf->codes[231] = 0x0000d712565c21baUL;
   tf->codes[232] = 0x0000d71290eb277fUL;
   tf->codes[233] = 0x0000d71306093309UL;
   tf->codes[234] = 0x0000d713409838ceUL;
   tf->codes[235] = 0x0000d7137b273e93UL;
   tf->codes[236] = 0x0000d713b5b64458UL;
   tf->codes[237] = 0x0000d713f0454a1dUL;
   tf->codes[238] = 0x0000d7142ad44fe2UL;
   tf->codes[239] = 0x0000d714656355a7UL;
   tf->codes[240] = 0x0000d7149ff25b6cUL;
   tf->codes[241] = 0x0000d714da816131UL;
   tf->codes[242] = 0x0000d715151066f6UL;
   tf->codes[243] = 0x0000d7154f9f6cbbUL;
   tf->codes[244] = 0x0000d715ff4c7e0aUL;
   tf->codes[245] = 0x0000d71639db83cfUL;
   tf->codes[246] = 0x0000d716746a8994UL;
   tf->codes[247] = 0x0000d716e988951eUL;
   tf->codes[248] = 0x0000d71724179ae3UL;
   tf->codes[249] = 0x0000d7175ea6a0a8UL;
   tf->codes[250] = 0x0000d7179935a66dUL;
   tf->codes[251] = 0x0000d717d3c4ac32UL;
   tf->codes[252] = 0x0000d71848e2b7bcUL;
   tf->codes[253] = 0x0000d7188371bd81UL;
   tf->codes[254] = 0x0000d718f88fc90bUL;
   tf->codes[255] = 0x0000d719331eced0UL;
   tf->codes[256] = 0x0000d7196dadd495UL;
   tf->codes[257] = 0x0000d719a83cda5aUL;
   tf->codes[258] = 0x0000d71a57e9eba9UL;
   tf->codes[259] = 0x0000d71a9278f16eUL;
   tf->codes[260] = 0x0000d71acd07f733UL;
   tf->codes[261] = 0x0000d71b422602bdUL;
   tf->codes[262] = 0x0000d71bb7440e47UL;
   tf->codes[263] = 0x0000d71c66f11f96UL;
   tf->codes[264] = 0x0000d71cdc0f2b20UL;
   tf->codes[265] = 0x0000d71d169e30e5UL;
   tf->codes[266] = 0x0000d71d512d36aaUL;
   tf->codes[267] = 0x0000d71d8bbc3c6fUL;
   tf->codes[268] = 0x0000d71dc64b4234UL;
   tf->codes[269] = 0x0000d71e3b694dbeUL;
   tf->codes[270] = 0x0000d71eeb165f0dUL;
   tf->codes[271] = 0x0000d71f9ac3705cUL;
   tf->codes[272] = 0x0000d7204a7081abUL;
   tf->codes[273] = 0x0000d72084ff8770UL;
   tf->codes[274] = 0x0000d720bf8e8d35UL;
   tf->codes[275] = 0x0000d720fa1d92faUL;
   tf->codes[276] = 0x0000d72134ac98bfUL;
   tf->codes[277] = 0x0000d721a9caa449UL;
   tf->codes[278] = 0x0000d7221ee8afd3UL;
   tf->codes[279] = 0x0000d7225977b598UL;
   tf->codes[280] = 0x0000d7229406bb5dUL;
   tf->codes[281] = 0x0000d7230924c6e7UL;
   tf->codes[282] = 0x0000d7242defe3c0UL;
   tf->codes[283] = 0x0000d725c7d90c23UL;
   tf->codes[284] = 0x0000d7263cf717adUL;
   tf->codes[285] = 0x0000d72677861d72UL;
   tf->codes[286] = 0x0000d726b2152337UL;
   tf->codes[287] = 0x0000d726eca428fcUL;
   tf->codes[288] = 0x0000d72727332ec1UL;
   tf->codes[289] = 0x0000d7279c513a4bUL;
   tf->codes[290] = 0x0000d728116f45d5UL;
   tf->codes[291] = 0x0000d7284bfe4b9aUL;
   tf->codes[292] = 0x0000d728868d515fUL;
   tf->codes[293] = 0x0000d728fbab5ce9UL;
   tf->codes[294] = 0x0000d729363a62aeUL;
   tf->codes[295] = 0x0000d72a9594854cUL;
   tf->codes[296] = 0x0000d72c2f7dadafUL;
   tf->codes[297] = 0x0000d72ca49bb939UL;
   tf->codes[298] = 0x0000d72d19b9c4c3UL;
   tf->codes[299] = 0x0000d72d5448ca88UL;
   tf->codes[300] = 0x0000d72dc966d612UL;
   tf->codes[301] = 0x0000d72e03f5dbd7UL;
   tf->codes[302] = 0x0000d72e3e84e19cUL;
   tf->codes[303] = 0x0000d72e7913e761UL;
   tf->codes[304] = 0x0000d72fd86e09ffUL;
   tf->codes[305] = 0x0000d73012fd0fc4UL;
   tf->codes[306] = 0x0000d7304d8c1589UL;
   tf->codes[307] = 0x0000d730fd3926d8UL;
   tf->codes[308] = 0x0000d73137c82c9dUL;
   tf->codes[309] = 0x0000d7325c934976UL;
   tf->codes[310] = 0x0000d73297224f3bUL;
   tf->codes[311] = 0x0000d732d1b15500UL;
   tf->codes[312] = 0x0000d7330c405ac5UL;
   tf->codes[313] = 0x0000d733815e664fUL;
   tf->codes[314] = 0x0000d7346b9a7d63UL;
   tf->codes[315] = 0x0000d734a6298328UL;
   tf->codes[316] = 0x0000d73555d69477UL;
   tf->codes[317] = 0x0000d7360583a5c6UL;
   tf->codes[318] = 0x0000d7364012ab8bUL;
   tf->codes[319] = 0x0000d736b530b715UL;
   tf->codes[320] = 0x0000d736efbfbcdaUL;
   tf->codes[321] = 0x0000d7372a4ec29fUL;
   tf->codes[322] = 0x0000d73764ddc864UL;
   tf->codes[323] = 0x0000d73889a8e53dUL;
   tf->codes[324] = 0x0000d739ae740216UL;
   tf->codes[325] = 0x0000d739e90307dbUL;
   tf->codes[326] = 0x0000d73a23920da0UL;
   tf->codes[327] = 0x0000d73a5e211365UL;
   tf->codes[328] = 0x0000d73b0dce24b4UL;
   tf->codes[329] = 0x0000d73b485d2a79UL;
   tf->codes[330] = 0x0000d73bbd7b3603UL;
   tf->codes[331] = 0x0000d73bf80a3bc8UL;
   tf->codes[332] = 0x0000d73c3299418dUL;
   tf->codes[333] = 0x0000d73c6d284752UL;
   tf->codes[334] = 0x0000d73ca7b74d17UL;
   tf->codes[335] = 0x0000d73d1cd558a1UL;
   tf->codes[336] = 0x0000d73d91f3642bUL;
   tf->codes[337] = 0x0000d73e07116fb5UL;
   tf->codes[338] = 0x0000d73e7c2f7b3fUL;
   tf->codes[339] = 0x0000d73ef14d86c9UL;
   tf->codes[340] = 0x0000d73f666b9253UL;
   tf->codes[341] = 0x0000d73fdb899dddUL;
   tf->codes[342] = 0x0000d7408b36af2cUL;
   tf->codes[343] = 0x0000d740c5c5b4f1UL;
   tf->codes[344] = 0x0000d7417572c640UL;
   tf->codes[345] = 0x0000d741ea90d1caUL;
   tf->codes[346] = 0x0000d742251fd78fUL;
   tf->codes[347] = 0x0000d7425faedd54UL;
   tf->codes[348] = 0x0000d7429a3de319UL;
   tf->codes[349] = 0x0000d742d4cce8deUL;
   tf->codes[350] = 0x0000d74434270b7cUL;
   tf->codes[351] = 0x0000d7446eb61141UL;
   tf->codes[352] = 0x0000d744a9451706UL;
   tf->codes[353] = 0x0000d744e3d41ccbUL;
   tf->codes[354] = 0x0000d746089f39a4UL;
   tf->codes[355] = 0x0000d746432e3f69UL;
   tf->codes[356] = 0x0000d7467dbd452eUL;
   tf->codes[357] = 0x0000d746b84c4af3UL;
   tf->codes[358] = 0x0000d746f2db50b8UL;
   tf->codes[359] = 0x0000d7472d6a567dUL;
   tf->codes[360] = 0x0000d747a2886207UL;
   tf->codes[361] = 0x0000d74817a66d91UL;
   tf->codes[362] = 0x0000d74901e284a5UL;
   tf->codes[363] = 0x0000d7493c718a6aUL;
   tf->codes[364] = 0x0000d749ec1e9bb9UL;
   tf->codes[365] = 0x0000d74a26ada17eUL;
   tf->codes[366] = 0x0000d74a613ca743UL;
   tf->codes[367] = 0x0000d74a9bcbad08UL;
   tf->codes[368] = 0x0000d74b10e9b892UL;
   tf->codes[369] = 0x0000d74d950ef809UL;
   tf->codes[370] = 0x0000d74e44bc0958UL;
   tf->codes[371] = 0x0000d74e7f4b0f1dUL;
   tf->codes[372] = 0x0000d74eb9da14e2UL;
   tf->codes[373] = 0x0000d74ef4691aa7UL;
   tf->codes[374] = 0x0000d74f69872631UL;
   tf->codes[375] = 0x0000d74fa4162bf6UL;
   tf->codes[376] = 0x0000d74fdea531bbUL;
   tf->codes[377] = 0x0000d75019343780UL;
   tf->codes[378] = 0x0000d7508e52430aUL;
   tf->codes[379] = 0x0000d750c8e148cfUL;
   tf->codes[380] = 0x0000d75103704e94UL;
   tf->codes[381] = 0x0000d751788e5a1eUL;
   tf->codes[382] = 0x0000d751b31d5fe3UL;
   tf->codes[383] = 0x0000d752283b6b6dUL;
   tf->codes[384] = 0x0000d7534d068846UL;
   tf->codes[385] = 0x0000d753c22493d0UL;
   tf->codes[386] = 0x0000d753fcb39995UL;
   tf->codes[387] = 0x0000d75437429f5aUL;
   tf->codes[388] = 0x0000d755217eb66eUL;
   tf->codes[389] = 0x0000d7555c0dbc33UL;
   tf->codes[390] = 0x0000d755969cc1f8UL;
   tf->codes[391] = 0x0000d7560bbacd82UL;
   tf->codes[392] = 0x0000d75680d8d90cUL;
   tf->codes[393] = 0x0000d7576b14f020UL;
   tf->codes[394] = 0x0000d75855510734UL;
   tf->codes[395] = 0x0000d7588fe00cf9UL;
   tf->codes[396] = 0x0000d75904fe1883UL;
   tf->codes[397] = 0x0000d7593f8d1e48UL;
   tf->codes[398] = 0x0000d7597a1c240dUL;
   tf->codes[399] = 0x0000d759ef3a2f97UL;
   tf->codes[400] = 0x0000d75a64583b21UL;
   tf->codes[401] = 0x0000d75a9ee740e6UL;
   tf->codes[402] = 0x0000d75ad97646abUL;
   tf->codes[403] = 0x0000d75bc3b25dbfUL;
   tf->codes[404] = 0x0000d75bfe416384UL;
   tf->codes[405] = 0x0000d75d5d9b8622UL;
   tf->codes[406] = 0x0000d75f6ca2ba0fUL;
   tf->codes[407] = 0x0000d760916dd6e8UL;
   tf->codes[408] = 0x0000d760cbfcdcadUL;
   tf->codes[409] = 0x0000d761068be272UL;
   tf->codes[410] = 0x0000d761411ae837UL;
   tf->codes[411] = 0x0000d7617ba9edfcUL;
   tf->codes[412] = 0x0000d761b638f3c1UL;
   tf->codes[413] = 0x0000d761f0c7f986UL;
   tf->codes[414] = 0x0000d762a0750ad5UL;
   tf->codes[415] = 0x0000d7631593165fUL;
   tf->codes[416] = 0x0000d76350221c24UL;
   tf->codes[417] = 0x0000d7638ab121e9UL;
   tf->codes[418] = 0x0000d7643a5e3338UL;
   tf->codes[419] = 0x0000d764ea0b4487UL;
   tf->codes[420] = 0x0000d765249a4a4cUL;
   tf->codes[421] = 0x0000d7655f295011UL;
   tf->codes[422] = 0x0000d76649656725UL;
   tf->codes[423] = 0x0000d766be8372afUL;
   tf->codes[424] = 0x0000d766f9127874UL;
   tf->codes[425] = 0x0000d767e34e8f88UL;
   tf->codes[426] = 0x0000d768586c9b12UL;
   tf->codes[427] = 0x0000d768cd8aa69cUL;
   tf->codes[428] = 0x0000d7697d37b7ebUL;
   tf->codes[429] = 0x0000d76a6773ceffUL;
   tf->codes[430] = 0x0000d76aa202d4c4UL;
   tf->codes[431] = 0x0000d76cb10a08b1UL;
   tf->codes[432] = 0x0000d76ceb990e76UL;
   tf->codes[433] = 0x0000d76d2628143bUL;
   tf->codes[434] = 0x0000d76d60b71a00UL;
   tf->codes[435] = 0x0000d76d9b461fc5UL;
   tf->codes[436] = 0x0000d76dd5d5258aUL;
   tf->codes[437] = 0x0000d76e4af33114UL;
   tf->codes[438] = 0x0000d76ec0113c9eUL;
   tf->codes[439] = 0x0000d76efaa04263UL;
   tf->codes[440] = 0x0000d77109a77650UL;
   tf->codes[441] = 0x0000d7717ec581daUL;
   tf->codes[442] = 0x0000d771b954879fUL;
   tf->codes[443] = 0x0000d772de1fa478UL;
   tf->codes[444] = 0x0000d7738dccb5c7UL;
   tf->codes[445] = 0x0000d77402eac151UL;
   tf->codes[446] = 0x0000d7747808ccdbUL;
   tf->codes[447] = 0x0000d77527b5de2aUL;
   tf->codes[448] = 0x0000d7759cd3e9b4UL;
   tf->codes[449] = 0x0000d77611f1f53eUL;
   tf->codes[450] = 0x0000d77736bd1217UL;
   tf->codes[451] = 0x0000d777e66a2366UL;
   tf->codes[452] = 0x0000d7790b35403fUL;
   tf->codes[453] = 0x0000d77980534bc9UL;
   tf->codes[454] = 0x0000d779bae2518eUL;
   tf->codes[455] = 0x0000d77a30005d18UL;
   tf->codes[456] = 0x0000d77a6a8f62ddUL;
   tf->codes[457] = 0x0000d77aa51e68a2UL;
   tf->codes[458] = 0x0000d77adfad6e67UL;
   tf->codes[459] = 0x0000d77cb4259c8fUL;
   tf->codes[460] = 0x0000d77d2943a819UL;
   tf->codes[461] = 0x0000d77e889dcab7UL;
   tf->codes[462] = 0x0000d77ec32cd07cUL;
   tf->codes[463] = 0x0000d77f384adc06UL;
   tf->codes[464] = 0x0000d78097a4fea4UL;
   tf->codes[465] = 0x0000d780d2340469UL;
   tf->codes[466] = 0x0000d78147520ff3UL;
   tf->codes[467] = 0x0000d78181e115b8UL;
   tf->codes[468] = 0x0000d781f6ff2142UL;
   tf->codes[469] = 0x0000d7826c1d2cccUL;
   tf->codes[470] = 0x0000d782a6ac3291UL;
   tf->codes[471] = 0x0000d783565943e0UL;
   tf->codes[472] = 0x0000d78390e849a5UL;
   tf->codes[473] = 0x0000d783cb774f6aUL;
   tf->codes[474] = 0x0000d7840606552fUL;
   tf->codes[475] = 0x0000d78440955af4UL;
   tf->codes[476] = 0x0000d7847b2460b9UL;
   tf->codes[477] = 0x0000d7859fef7d92UL;
   tf->codes[478] = 0x0000d786150d891cUL;
   tf->codes[479] = 0x0000d7864f9c8ee1UL;
   tf->codes[480] = 0x0000d7868a2b94a6UL;
   tf->codes[481] = 0x0000d786ff49a030UL;
   tf->codes[482] = 0x0000d7877467abbaUL;
   tf->codes[483] = 0x0000d7890e50d41dUL;
   tf->codes[484] = 0x0000d789836edfa7UL;
   tf->codes[485] = 0x0000d789bdfde56cUL;
   tf->codes[486] = 0x0000d78aa839fc80UL;
   tf->codes[487] = 0x0000d78ae2c90245UL;
   tf->codes[488] = 0x0000d78b57e70dcfUL;
   tf->codes[489] = 0x0000d78b92761394UL;
   tf->codes[490] = 0x0000d78bcd051959UL;
   tf->codes[491] = 0x0000d78c422324e3UL;
   tf->codes[492] = 0x0000d78ddc0c4d46UL;
   tf->codes[493] = 0x0000d78ec648645aUL;
   tf->codes[494] = 0x0000d79060318cbdUL;
   tf->codes[495] = 0x0000d790d54f9847UL;
   tf->codes[496] = 0x0000d7910fde9e0cUL;
   tf->codes[497] = 0x0000d79184fca996UL;
   tf->codes[498] = 0x0000d791bf8baf5bUL;
   tf->codes[499] = 0x0000d791fa1ab520UL;
   tf->codes[500] = 0x0000d79234a9bae5UL;
   tf->codes[501] = 0x0000d7926f38c0aaUL;
   tf->codes[502] = 0x0000d792a9c7c66fUL;
   tf->codes[503] = 0x0000d7931ee5d1f9UL;
   tf->codes[504] = 0x0000d7935974d7beUL;
   tf->codes[505] = 0x0000d7939403dd83UL;
   tf->codes[506] = 0x0000d7940921e90dUL;
   tf->codes[507] = 0x0000d79443b0eed2UL;
   tf->codes[508] = 0x0000d7947e3ff497UL;
   tf->codes[509] = 0x0000d7952ded05e6UL;
   tf->codes[510] = 0x0000d795687c0babUL;
   tf->codes[511] = 0x0000d795dd9a1735UL;
   tf->codes[512] = 0x0000d7970265340eUL;
   tf->codes[513] = 0x0000d7973cf439d3UL;
   tf->codes[514] = 0x0000d797eca14b22UL;
   tf->codes[515] = 0x0000d7994bfb6dc0UL;
   tf->codes[516] = 0x0000d79a363784d4UL;
   tf->codes[517] = 0x0000d79aab55905eUL;
   tf->codes[518] = 0x0000d79ae5e49623UL;
   tf->codes[519] = 0x0000d79b9591a772UL;
   tf->codes[520] = 0x0000d79c453eb8c1UL;
   tf->codes[521] = 0x0000d79cba5cc44bUL;
   tf->codes[522] = 0x0000d79e5445ecaeUL;
   tf->codes[523] = 0x0000d79ec963f838UL;
   tf->codes[524] = 0x0000d79f3e8203c2UL;
   tf->codes[525] = 0x0000d79f79110987UL;
   tf->codes[526] = 0x0000d79fee2f1511UL;
   tf->codes[527] = 0x0000d7a0d86b2c25UL;
   tf->codes[528] = 0x0000d7a1c2a74339UL;
   tf->codes[529] = 0x0000d7a1fd3648feUL;
   tf->codes[530] = 0x0000d7a272545488UL;
   tf->codes[531] = 0x0000d7a2e7726012UL;
   tf->codes[532] = 0x0000d7a3220165d7UL;
   tf->codes[533] = 0x0000d7a35c906b9cUL;
   tf->codes[534] = 0x0000d7a3971f7161UL;
   tf->codes[535] = 0x0000d7a3d1ae7726UL;
   tf->codes[536] = 0x0000d7a4815b8875UL;
   tf->codes[537] = 0x0000d7a4bbea8e3aUL;
   tf->codes[538] = 0x0000d7a5310899c4UL;
   tf->codes[539] = 0x0000d7a5e0b5ab13UL;
   tf->codes[540] = 0x0000d7a69062bc62UL;
   tf->codes[541] = 0x0000d7a7400fcdb1UL;
   tf->codes[542] = 0x0000d7a7efbcdf00UL;
   tf->codes[543] = 0x0000d7a89f69f04fUL;
   tf->codes[544] = 0x0000d7a9fec412edUL;
   tf->codes[545] = 0x0000d7aa395318b2UL;
   tf->codes[546] = 0x0000d7aaae71243cUL;
   tf->codes[547] = 0x0000d7aae9002a01UL;
   tf->codes[548] = 0x0000d7ab5e1e358bUL;
   tf->codes[549] = 0x0000d7ac485a4c9fUL;
   tf->codes[550] = 0x0000d7acbd785829UL;
   tf->codes[551] = 0x0000d7ade2437502UL;
   tf->codes[552] = 0x0000d7ae91f08651UL;
   tf->codes[553] = 0x0000d7b06668b479UL;
   tf->codes[554] = 0x0000d7b0a0f7ba3eUL;
   tf->codes[555] = 0x0000d7b18b33d152UL;
   tf->codes[556] = 0x0000d7b23ae0e2a1UL;
   tf->codes[557] = 0x0000d7b40f5910c9UL;
   tf->codes[558] = 0x0000d7b4bf062218UL;
   tf->codes[559] = 0x0000d7b534242da2UL;
   tf->codes[560] = 0x0000d7b56eb33367UL;
   tf->codes[561] = 0x0000d7b5a942392cUL;
   tf->codes[562] = 0x0000d7b5e3d13ef1UL;
   tf->codes[563] = 0x0000d7b7432b618fUL;
   tf->codes[564] = 0x0000d7b7b8496d19UL;
   tf->codes[565] = 0x0000d7b7f2d872deUL;
   tf->codes[566] = 0x0000d7b867f67e68UL;
   tf->codes[567] = 0x0000d7b8a285842dUL;
   tf->codes[568] = 0x0000d7b917a38fb7UL;
   tf->codes[569] = 0x0000d7b9c750a106UL;
   tf->codes[570] = 0x0000d7bab18cb81aUL;
   tf->codes[571] = 0x0000d7bb6139c969UL;
   tf->codes[572] = 0x0000d7bb9bc8cf2eUL;
   tf->codes[573] = 0x0000d7bcfb22f1ccUL;
   tf->codes[574] = 0x0000d7be5a7d146aUL;
   tf->codes[575] = 0x0000d7bf7f483143UL;
   tf->codes[576] = 0x0000d7c1193159a6UL;
   tf->codes[577] = 0x0000d7c1c8de6af5UL;
   tf->codes[578] = 0x0000d7c2b31a8209UL;
   tf->codes[579] = 0x0000d7c2eda987ceUL;
   tf->codes[580] = 0x0000d7c41274a4a7UL;
   tf->codes[581] = 0x0000d7c48792b031UL;
   tf->codes[582] = 0x0000d7c4fcb0bbbbUL;
   tf->codes[583] = 0x0000d7c5373fc180UL;
   tf->codes[584] = 0x0000d7c5ac5dcd0aUL;
   tf->codes[585] = 0x0000d7c6d128e9e3UL;
   tf->codes[586] = 0x0000d7c7f5f406bcUL;
   tf->codes[587] = 0x0000d7c86b121246UL;
   tf->codes[588] = 0x0000d7c8a5a1180bUL;
   tf->codes[589] = 0x0000d7c98fdd2f1fUL;
   tf->codes[590] = 0x0000d7c9ca6c34e4UL;
   tf->codes[591] = 0x0000d7ca3f8a406eUL;
   tf->codes[592] = 0x0000d7ca7a194633UL;
   tf->codes[593] = 0x0000d7cb64555d47UL;
   tf->codes[594] = 0x0000d7cbd97368d1UL;
   tf->codes[595] = 0x0000d7ccfe3e85aaUL;
   tf->codes[596] = 0x0000d7cf0d45b997UL;
   tf->codes[597] = 0x0000d7cf8263c521UL;
   tf->codes[598] = 0x0000d7d03210d670UL;
   tf->codes[599] = 0x0000d7d0a72ee1faUL;
   tf->codes[600] = 0x0000d7d156dbf349UL;
   tf->codes[601] = 0x0000d7d1916af90eUL;
   tf->codes[602] = 0x0000d7d206890498UL;
   tf->codes[603] = 0x0000d7d241180a5dUL;
   tf->codes[604] = 0x0000d7d27ba71022UL;
   tf->codes[605] = 0x0000d7d4501f3e4aUL;
   tf->codes[606] = 0x0000d7d53a5b555eUL;
   tf->codes[607] = 0x0000d7d6d4447dc1UL;
   tf->codes[608] = 0x0000d7d7be8094d5UL;
   tf->codes[609] = 0x0000d7d8339ea05fUL;
   tf->codes[610] = 0x0000d7d86e2da624UL;
   tf->codes[611] = 0x0000d7d8a8bcabe9UL;
   tf->codes[612] = 0x0000d7d8e34bb1aeUL;
   tf->codes[613] = 0x0000d7da7d34da11UL;
   tf->codes[614] = 0x0000d7daf252e59bUL;
   tf->codes[615] = 0x0000d7dbdc8efcafUL;
   tf->codes[616] = 0x0000d7dfc00e5ec4UL;
   tf->codes[617] = 0x0000d7e0aa4a75d8UL;
   tf->codes[618] = 0x0000d7e0e4d97b9dUL;
   tf->codes[619] = 0x0000d7e1cf1592b1UL;
   tf->codes[620] = 0x0000d7e209a49876UL;
   tf->codes[621] = 0x0000d7e27ec2a400UL;
   tf->codes[622] = 0x0000d7e32e6fb54fUL;
   tf->codes[623] = 0x0000d7e368febb14UL;
   tf->codes[624] = 0x0000d7e3a38dc0d9UL;
   tf->codes[625] = 0x0000d7e3de1cc69eUL;
   tf->codes[626] = 0x0000d7e5b294f4c6UL;
   tf->codes[627] = 0x0000d7e5ed23fa8bUL;
   tf->codes[628] = 0x0000d7e6d760119fUL;
   tf->codes[629] = 0x0000d7e74c7e1d29UL;
   tf->codes[630] = 0x0000d7e7870d22eeUL;
   tf->codes[631] = 0x0000d7e7fc2b2e78UL;
   tf->codes[632] = 0x0000d7ea45c1682aUL;
   tf->codes[633] = 0x0000d7eb6a8c8503UL;
   tf->codes[634] = 0x0000d7ebdfaa908dUL;
   tf->codes[635] = 0x0000d7ec54c89c17UL;
   tf->codes[636] = 0x0000d7ec8f57a1dcUL;
   tf->codes[637] = 0x0000d7edb422beb5UL;
   tf->codes[638] = 0x0000d7edeeb1c47aUL;
   tf->codes[639] = 0x0000d7ef4e0be718UL;
   tf->codes[640] = 0x0000d7f197a220caUL;
   tf->codes[641] = 0x0000d7f1d231268fUL;
   tf->codes[642] = 0x0000d7f2f6fc4368UL;
   tf->codes[643] = 0x0000d7f36c1a4ef2UL;
   tf->codes[644] = 0x0000d7f456566606UL;
   tf->codes[645] = 0x0000d7f540927d1aUL;
   tf->codes[646] = 0x0000d7f5b5b088a4UL;
   tf->codes[647] = 0x0000d7f6655d99f3UL;
   tf->codes[648] = 0x0000d7f78a28b6ccUL;
   tf->codes[649] = 0x0000d7f8e982d96aUL;
   tf->codes[650] = 0x0000d7f9992feab9UL;
   tf->codes[651] = 0x0000d7fa48dcfc08UL;
   tf->codes[652] = 0x0000d7fa836c01cdUL;
   tf->codes[653] = 0x0000d7faf88a0d57UL;
   tf->codes[654] = 0x0000d7fb3319131cUL;
   tf->codes[655] = 0x0000d7fb6da818e1UL;
   tf->codes[656] = 0x0000d7fba8371ea6UL;
   tf->codes[657] = 0x0000d7fc927335baUL;
   tf->codes[658] = 0x0000d7fd42204709UL;
   tf->codes[659] = 0x0000d7ffc6458680UL;
   tf->codes[660] = 0x0000d80000d48c45UL;
   tf->codes[661] = 0x0000d8003b63920aUL;
   tf->codes[662] = 0x0000d80075f297cfUL;
   tf->codes[663] = 0x0000d800b0819d94UL;
   tf->codes[664] = 0x0000d800eb10a359UL;
   tf->codes[665] = 0x0000d801259fa91eUL;
   tf->codes[666] = 0x0000d801602eaee3UL;
   tf->codes[667] = 0x0000d8019abdb4a8UL;
   tf->codes[668] = 0x0000d801d54cba6dUL;
   tf->codes[669] = 0x0000d8024a6ac5f7UL;
   tf->codes[670] = 0x0000d80284f9cbbcUL;
   tf->codes[671] = 0x0000d802bf88d181UL;
   tf->codes[672] = 0x0000d802fa17d746UL;
   tf->codes[673] = 0x0000d80334a6dd0bUL;
   tf->codes[674] = 0x0000d8036f35e2d0UL;
   tf->codes[675] = 0x0000d803a9c4e895UL;
   tf->codes[676] = 0x0000d803e453ee5aUL;
   tf->codes[677] = 0x0000d8045971f9e4UL;
   tf->codes[678] = 0x0000d8049400ffa9UL;
   tf->codes[679] = 0x0000d805091f0b33UL;
   tf->codes[680] = 0x0000d80543ae10f8UL;
   tf->codes[681] = 0x0000d8057e3d16bdUL;
   tf->codes[682] = 0x0000d805b8cc1c82UL;
   tf->codes[683] = 0x0000d8062dea280cUL;
   tf->codes[684] = 0x0000d806a3083396UL;
   tf->codes[685] = 0x0000d80718263f20UL;
   tf->codes[686] = 0x0000d80752b544e5UL;
   tf->codes[687] = 0x0000d8078d444aaaUL;
   tf->codes[688] = 0x0000d80802625634UL;
   tf->codes[689] = 0x0000d8083cf15bf9UL;
   tf->codes[690] = 0x0000d808b20f6783UL;
   tf->codes[691] = 0x0000d808ec9e6d48UL;
   tf->codes[692] = 0x0000d80961bc78d2UL;
   tf->codes[693] = 0x0000d8099c4b7e97UL;
   tf->codes[694] = 0x0000d809d6da845cUL;
   tf->codes[695] = 0x0000d80a11698a21UL;
   tf->codes[696] = 0x0000d80a868795abUL;
   tf->codes[697] = 0x0000d80ac1169b70UL;
   tf->codes[698] = 0x0000d80afba5a135UL;
   tf->codes[699] = 0x0000d80b70c3acbfUL;
   tf->codes[700] = 0x0000d80bab52b284UL;
   tf->codes[701] = 0x0000d80be5e1b849UL;
   tf->codes[702] = 0x0000d80c5affc3d3UL;
   tf->codes[703] = 0x0000d80c958ec998UL;
   tf->codes[704] = 0x0000d80cd01dcf5dUL;
   tf->codes[705] = 0x0000d80d453bdae7UL;
   tf->codes[706] = 0x0000d80d7fcae0acUL;
   tf->codes[707] = 0x0000d80e2f77f1fbUL;
   tf->codes[708] = 0x0000d80edf25034aUL;
   tf->codes[709] = 0x0000d80f54430ed4UL;
   tf->codes[710] = 0x0000d80f8ed21499UL;
   tf->codes[711] = 0x0000d810790e2badUL;
   tf->codes[712] = 0x0000d810b39d3172UL;
   tf->codes[713] = 0x0000d810ee2c3737UL;
   tf->codes[714] = 0x0000d81128bb3cfcUL;
   tf->codes[715] = 0x0000d811634a42c1UL;
   tf->codes[716] = 0x0000d811d8684e4bUL;
   tf->codes[717] = 0x0000d8124d8659d5UL;
   tf->codes[718] = 0x0000d81288155f9aUL;
   tf->codes[719] = 0x0000d812c2a4655fUL;
   tf->codes[720] = 0x0000d812fd336b24UL;
   tf->codes[721] = 0x0000d813725176aeUL;
   tf->codes[722] = 0x0000d813ace07c73UL;
   tf->codes[723] = 0x0000d813e76f8238UL;
   tf->codes[724] = 0x0000d814d1ab994cUL;
   tf->codes[725] = 0x0000d815bbe7b060UL;
   tf->codes[726] = 0x0000d815f676b625UL;
   tf->codes[727] = 0x0000d8163105bbeaUL;
   tf->codes[728] = 0x0000d8166b94c1afUL;
   tf->codes[729] = 0x0000d816a623c774UL;
   tf->codes[730] = 0x0000d81755d0d8c3UL;
   tf->codes[731] = 0x0000d818057dea12UL;
   tf->codes[732] = 0x0000d8187a9bf59cUL;
   tf->codes[733] = 0x0000d818b52afb61UL;
   tf->codes[734] = 0x0000d818efba0126UL;
   tf->codes[735] = 0x0000d81964d80cb0UL;
   tf->codes[736] = 0x0000d819d9f6183aUL;
   tf->codes[737] = 0x0000d81a89a32989UL;
   tf->codes[738] = 0x0000d81ac4322f4eUL;
   tf->codes[739] = 0x0000d81afec13513UL;
   tf->codes[740] = 0x0000d81b73df409dUL;
   tf->codes[741] = 0x0000d81bae6e4662UL;
   tf->codes[742] = 0x0000d81be8fd4c27UL;
   tf->codes[743] = 0x0000d81d82e6748aUL;
   tf->codes[744] = 0x0000d81df8048014UL;
   tf->codes[745] = 0x0000d81ea7b19163UL;
   tf->codes[746] = 0x0000d81ee2409728UL;
   tf->codes[747] = 0x0000d81f1ccf9cedUL;
   tf->codes[748] = 0x0000d81f91eda877UL;
   tf->codes[749] = 0x0000d820419ab9c6UL;
   tf->codes[750] = 0x0000d8207c29bf8bUL;
   tf->codes[751] = 0x0000d820b6b8c550UL;
   tf->codes[752] = 0x0000d820f147cb15UL;
   tf->codes[753] = 0x0000d8212bd6d0daUL;
   tf->codes[754] = 0x0000d821db83e229UL;
   tf->codes[755] = 0x0000d8221612e7eeUL;
   tf->codes[756] = 0x0000d824251a1bdbUL;
   tf->codes[757] = 0x0000d8245fa921a0UL;
   tf->codes[758] = 0x0000d8249a382765UL;
   tf->codes[759] = 0x0000d824d4c72d2aUL;
   tf->codes[760] = 0x0000d8250f5632efUL;
   tf->codes[761] = 0x0000d825bf03443eUL;
   tf->codes[762] = 0x0000d8271e5d66dcUL;
   tf->codes[763] = 0x0000d827937b7266UL;
   tf->codes[764] = 0x0000d827ce0a782bUL;
   tf->codes[765] = 0x0000d828432883b5UL;
   tf->codes[766] = 0x0000d829a282a653UL;
   tf->codes[767] = 0x0000d829dd11ac18UL;
   tf->codes[768] = 0x0000d82a17a0b1ddUL;
   tf->codes[769] = 0x0000d82bb189da40UL;
   tf->codes[770] = 0x0000d82bec18e005UL;
   tf->codes[771] = 0x0000d82c26a7e5caUL;
   tf->codes[772] = 0x0000d82dfb2013f2UL;
   tf->codes[773] = 0x0000d82e35af19b7UL;
   tf->codes[774] = 0x0000d82eaacd2541UL;
   tf->codes[775] = 0x0000d82f1feb30cbUL;
   tf->codes[776] = 0x0000d82f5a7a3690UL;
   tf->codes[777] = 0x0000d82f95093c55UL;
   tf->codes[778] = 0x0000d82fcf98421aUL;
   tf->codes[779] = 0x0000d8307f455369UL;
   tf->codes[780] = 0x0000d8328e4c8756UL;
   tf->codes[781] = 0x0000d832c8db8d1bUL;
   tf->codes[782] = 0x0000d8333df998a5UL;
   tf->codes[783] = 0x0000d83378889e6aUL;
   tf->codes[784] = 0x0000d833b317a42fUL;
   tf->codes[785] = 0x0000d8342835afb9UL;
   tf->codes[786] = 0x0000d83462c4b57eUL;
   tf->codes[787] = 0x0000d8349d53bb43UL;
   tf->codes[788] = 0x0000d8354d00cc92UL;
   tf->codes[789] = 0x0000d835fcaddde1UL;
   tf->codes[790] = 0x0000d83671cbe96bUL;
   tf->codes[791] = 0x0000d836e6e9f4f5UL;
   tf->codes[792] = 0x0000d8372178fabaUL;
   tf->codes[793] = 0x0000d837d1260c09UL;
   tf->codes[794] = 0x0000d8380bb511ceUL;
   tf->codes[795] = 0x0000d83846441793UL;
   tf->codes[796] = 0x0000d838bb62231dUL;
   tf->codes[797] = 0x0000d838f5f128e2UL;
   tf->codes[798] = 0x0000d839a59e3a31UL;
   tf->codes[799] = 0x0000d83a1abc45bbUL;
   tf->codes[800] = 0x0000d83a554b4b80UL;
   tf->codes[801] = 0x0000d83b7a166859UL;
   tf->codes[802] = 0x0000d83bb4a56e1eUL;
   tf->codes[803] = 0x0000d83c64527f6dUL;
   tf->codes[804] = 0x0000d83cd9708af7UL;
   tf->codes[805] = 0x0000d83d891d9c46UL;
   tf->codes[806] = 0x0000d83dc3aca20bUL;
   tf->codes[807] = 0x0000d83e7359b35aUL;
   tf->codes[808] = 0x0000d83ee877bee4UL;
   tf->codes[809] = 0x0000d8400d42dbbdUL;
   tf->codes[810] = 0x0000d840f77ef2d1UL;
   tf->codes[811] = 0x0000d841320df896UL;
   tf->codes[812] = 0x0000d8416c9cfe5bUL;
   tf->codes[813] = 0x0000d842cbf720f9UL;
   tf->codes[814] = 0x0000d843068626beUL;
   tf->codes[815] = 0x0000d84341152c83UL;
   tf->codes[816] = 0x0000d8437ba43248UL;
   tf->codes[817] = 0x0000d8442b514397UL;
   tf->codes[818] = 0x0000d844dafe54e6UL;
   tf->codes[819] = 0x0000d8458aab6635UL;
   tf->codes[820] = 0x0000d845c53a6bfaUL;
   tf->codes[821] = 0x0000d846af76830eUL;
   tf->codes[822] = 0x0000d846ea0588d3UL;
   tf->codes[823] = 0x0000d8475f23945dUL;
   tf->codes[824] = 0x0000d8480ed0a5acUL;
   tf->codes[825] = 0x0000d84883eeb136UL;
   tf->codes[826] = 0x0000d8496e2ac84aUL;
   tf->codes[827] = 0x0000d84a5866df5eUL;
   tf->codes[828] = 0x0000d84a92f5e523UL;
   tf->codes[829] = 0x0000d84b0813f0adUL;
   tf->codes[830] = 0x0000d84cdc8c1ed5UL;
   tf->codes[831] = 0x0000d84d171b249aUL;
   tf->codes[832] = 0x0000d84d8c393024UL;
   tf->codes[833] = 0x0000d84dc6c835e9UL;
   tf->codes[834] = 0x0000d84e76754738UL;
   tf->codes[835] = 0x0000d84eb1044cfdUL;
   tf->codes[836] = 0x0000d84fd5cf69d6UL;
   tf->codes[837] = 0x0000d850105e6f9bUL;
   tf->codes[838] = 0x0000d850c00b80eaUL;
   tf->codes[839] = 0x0000d850fa9a86afUL;
   tf->codes[840] = 0x0000d85135298c74UL;
   tf->codes[841] = 0x0000d8516fb89239UL;
   tf->codes[842] = 0x0000d851aa4797feUL;
   tf->codes[843] = 0x0000d851e4d69dc3UL;
   tf->codes[844] = 0x0000d8521f65a388UL;
   tf->codes[845] = 0x0000d85259f4a94dUL;
   tf->codes[846] = 0x0000d8529483af12UL;
   tf->codes[847] = 0x0000d852cf12b4d7UL;
   tf->codes[848] = 0x0000d85309a1ba9cUL;
   tf->codes[849] = 0x0000d853b94ecbebUL;
   tf->codes[850] = 0x0000d854de19e8c4UL;
   tf->codes[851] = 0x0000d8558dc6fa13UL;
   tf->codes[852] = 0x0000d856ed211cb1UL;
   tf->codes[853] = 0x0000d85727b02276UL;
   tf->codes[854] = 0x0000d857623f283bUL;
   tf->codes[855] = 0x0000d857d75d33c5UL;
   tf->codes[856] = 0x0000d85811ec398aUL;
   tf->codes[857] = 0x0000d858c1994ad9UL;
   tf->codes[858] = 0x0000d858fc28509eUL;
   tf->codes[859] = 0x0000d85936b75663UL;
   tf->codes[860] = 0x0000d859abd561edUL;
   tf->codes[861] = 0x0000d85a5b82733cUL;
   tf->codes[862] = 0x0000d85a96117901UL;
   tf->codes[863] = 0x0000d85b0b2f848bUL;
   tf->codes[864] = 0x0000d85b804d9015UL;
   tf->codes[865] = 0x0000d85bf56b9b9fUL;
   tf->codes[866] = 0x0000d85cdfa7b2b3UL;
   tf->codes[867] = 0x0000d85d8f54c402UL;
   tf->codes[868] = 0x0000d85dc9e3c9c7UL;
   tf->codes[869] = 0x0000d85eb41fe0dbUL;
   tf->codes[870] = 0x0000d85f9e5bf7efUL;
   tf->codes[871] = 0x0000d85fd8eafdb4UL;
   tf->codes[872] = 0x0000d860137a0379UL;
   tf->codes[873] = 0x0000d8604e09093eUL;
   tf->codes[874] = 0x0000d860fdb61a8dUL;
   tf->codes[875] = 0x0000d86138452052UL;
   tf->codes[876] = 0x0000d861ad632bdcUL;
   tf->codes[877] = 0x0000d861e7f231a1UL;
   tf->codes[878] = 0x0000d86222813766UL;
   tf->codes[879] = 0x0000d8625d103d2bUL;
   tf->codes[880] = 0x0000d862d22e48b5UL;
   tf->codes[881] = 0x0000d863f6f9658eUL;
   tf->codes[882] = 0x0000d8646c177118UL;
   tf->codes[883] = 0x0000d866408f9f40UL;
   tf->codes[884] = 0x0000d8667b1ea505UL;
   tf->codes[885] = 0x0000d867da78c7a3UL;
   tf->codes[886] = 0x0000d868c4b4deb7UL;
   tf->codes[887] = 0x0000d869e97ffb90UL;
   tf->codes[888] = 0x0000d86a240f0155UL;
   tf->codes[889] = 0x0000d86b836923f3UL;
   tf->codes[890] = 0x0000d86bf8872f7dUL;
   tf->codes[891] = 0x0000d86ca83440ccUL;
   tf->codes[892] = 0x0000d86d1d524c56UL;
   tf->codes[893] = 0x0000d86fdc069192UL;
   tf->codes[894] = 0x0000d87051249d1cUL;
   tf->codes[895] = 0x0000d87100d1ae6bUL;
   tf->codes[896] = 0x0000d872259ccb44UL;
   tf->codes[897] = 0x0000d872602bd109UL;
   tf->codes[898] = 0x0000d872d549dc93UL;
   tf->codes[899] = 0x0000d8746f3304f6UL;
   tf->codes[900] = 0x0000d874a9c20abbUL;
   tf->codes[901] = 0x0000d874e4511080UL;
   tf->codes[902] = 0x0000d87593fe21cfUL;
   tf->codes[903] = 0x0000d875ce8d2794UL;
   tf->codes[904] = 0x0000d8767e3a38e3UL;
   tf->codes[905] = 0x0000d87768764ff7UL;
   tf->codes[906] = 0x0000d877a30555bcUL;
   tf->codes[907] = 0x0000d87852b2670bUL;
   tf->codes[908] = 0x0000d8788d416cd0UL;
   tf->codes[909] = 0x0000d879025f785aUL;
   tf->codes[910] = 0x0000d879777d83e4UL;
   tf->codes[911] = 0x0000d87a272a9533UL;
   tf->codes[912] = 0x0000d87a9c48a0bdUL;
   tf->codes[913] = 0x0000d87bfba2c35bUL;
   tf->codes[914] = 0x0000d87cab4fd4aaUL;
   tf->codes[915] = 0x0000d87e0aa9f748UL;
   tf->codes[916] = 0x0000d87f2f751421UL;
   tf->codes[917] = 0x0000d87f6a0419e6UL;
   tf->codes[918] = 0x0000d87fa4931fabUL;
   tf->codes[919] = 0x0000d87fdf222570UL;
   tf->codes[920] = 0x0000d88019b12b35UL;
   tf->codes[921] = 0x0000d880544030faUL;
   tf->codes[922] = 0x0000d880c95e3c84UL;
   tf->codes[923] = 0x0000d881790b4dd3UL;
   tf->codes[924] = 0x0000d881b39a5398UL;
   tf->codes[925] = 0x0000d881ee29595dUL;
   tf->codes[926] = 0x0000d882d8657071UL;
   tf->codes[927] = 0x0000d883881281c0UL;
   tf->codes[928] = 0x0000d883c2a18785UL;
   tf->codes[929] = 0x0000d883fd308d4aUL;
   tf->codes[930] = 0x0000d884724e98d4UL;
   tf->codes[931] = 0x0000d884acdd9e99UL;
   tf->codes[932] = 0x0000d884e76ca45eUL;
   tf->codes[933] = 0x0000d8860c37c137UL;
   tf->codes[934] = 0x0000d886f673d84bUL;
   tf->codes[935] = 0x0000d8873102de10UL;
   tf->codes[936] = 0x0000d887a620e99aUL;
   tf->codes[937] = 0x0000d887e0afef5fUL;
   tf->codes[938] = 0x0000d8881b3ef524UL;
   tf->codes[939] = 0x0000d888905d00aeUL;
   tf->codes[940] = 0x0000d888caec0673UL;
   tf->codes[941] = 0x0000d8897a9917c2UL;
   tf->codes[942] = 0x0000d889efb7234cUL;
   tf->codes[943] = 0x0000d88a2a462911UL;
   tf->codes[944] = 0x0000d88a9f64349bUL;
   tf->codes[945] = 0x0000d88b14824025UL;
   tf->codes[946] = 0x0000d88bfebe5739UL;
   tf->codes[947] = 0x0000d88d98a77f9cUL;
   tf->codes[948] = 0x0000d88dd3368561UL;
   tf->codes[949] = 0x0000d88e0dc58b26UL;
   tf->codes[950] = 0x0000d88e485490ebUL;
   tf->codes[951] = 0x0000d88ef801a23aUL;
   tf->codes[952] = 0x0000d88f3290a7ffUL;
   tf->codes[953] = 0x0000d8901cccbf13UL;
   tf->codes[954] = 0x0000d89091eaca9dUL;
   tf->codes[955] = 0x0000d890cc79d062UL;
   tf->codes[956] = 0x0000d8914197dbecUL;
   tf->codes[957] = 0x0000d8917c26e1b1UL;
   tf->codes[958] = 0x0000d89316100a14UL;
   tf->codes[959] = 0x0000d893509f0fd9UL;
   tf->codes[960] = 0x0000d893c5bd1b63UL;
   tf->codes[961] = 0x0000d894004c2128UL;
   tf->codes[962] = 0x0000d894ea88383cUL;
   tf->codes[963] = 0x0000d8955fa643c6UL;
   tf->codes[964] = 0x0000d8959a35498bUL;
   tf->codes[965] = 0x0000d89649e25adaUL;
   tf->codes[966] = 0x0000d8968471609fUL;
   tf->codes[967] = 0x0000d897341e71eeUL;
   tf->codes[968] = 0x0000d8981e5a8902UL;
   tf->codes[969] = 0x0000d89a2d61bcefUL;
   tf->codes[970] = 0x0000d89a67f0c2b4UL;
   tf->codes[971] = 0x0000d89aa27fc879UL;
   tf->codes[972] = 0x0000d89add0ece3eUL;
   tf->codes[973] = 0x0000d89b179dd403UL;
   tf->codes[974] = 0x0000d89b8cbbdf8dUL;
   tf->codes[975] = 0x0000d89cb186fc66UL;
   tf->codes[976] = 0x0000d89d26a507f0UL;
   tf->codes[977] = 0x0000d89d61340db5UL;
   tf->codes[978] = 0x0000d89e10e11f04UL;
   tf->codes[979] = 0x0000d89ec08e3053UL;
   tf->codes[980] = 0x0000d89f35ac3bddUL;
   tf->codes[981] = 0x0000d89fe5594d2cUL;
   tf->codes[982] = 0x0000d8a01fe852f1UL;
   tf->codes[983] = 0x0000d8a095065e7bUL;
   tf->codes[984] = 0x0000d8a0cf956440UL;
   tf->codes[985] = 0x0000d8a10a246a05UL;
   tf->codes[986] = 0x0000d8a144b36fcaUL;
   tf->codes[987] = 0x0000d8a17f42758fUL;
   tf->codes[988] = 0x0000d8a1f4608119UL;
   tf->codes[989] = 0x0000d8a2a40d9268UL;
   tf->codes[990] = 0x0000d8a40367b506UL;
   tf->codes[991] = 0x0000d8a4b314c655UL;
   tf->codes[992] = 0x0000d8a6fcab0007UL;
   tf->codes[993] = 0x0000d8a7373a05ccUL;
   tf->codes[994] = 0x0000d8a771c90b91UL;
   tf->codes[995] = 0x0000d8a7e6e7171bUL;
   tf->codes[996] = 0x0000d8a821761ce0UL;
   tf->codes[997] = 0x0000d8a85c0522a5UL;
   tf->codes[998] = 0x0000d8a89694286aUL;
   tf->codes[999] = 0x0000d8a8d1232e2fUL;
   tf->codes[1000] = 0x0000d8a90bb233f4UL;
   tf->codes[1001] = 0x0000d8a9f5ee4b08UL;
   tf->codes[1002] = 0x0000d8aae02a621cUL;
   tf->codes[1003] = 0x0000d8ac3f8484baUL;
   tf->codes[1004] = 0x0000d8acef319609UL;
   tf->codes[1005] = 0x0000d8ae13fcb2e2UL;
   tf->codes[1006] = 0x0000d8ae891abe6cUL;
   tf->codes[1007] = 0x0000d8aec3a9c431UL;
   tf->codes[1008] = 0x0000d8aefe38c9f6UL;
   tf->codes[1009] = 0x0000d8afe874e10aUL;
   tf->codes[1010] = 0x0000d8b0d2b0f81eUL;
   tf->codes[1011] = 0x0000d8b10d3ffde3UL;
   tf->codes[1012] = 0x0000d8b1f77c14f7UL;
   tf->codes[1013] = 0x0000d8b2320b1abcUL;
   tf->codes[1014] = 0x0000d8b2a7292646UL;
   tf->codes[1015] = 0x0000d8b441124ea9UL;
   tf->codes[1016] = 0x0000d8b4b6305a33UL;
   tf->codes[1017] = 0x0000d8b5a06c7147UL;
   tf->codes[1018] = 0x0000d8b5dafb770cUL;
   tf->codes[1019] = 0x0000d8b650198296UL;
   tf->codes[1020] = 0x0000d8b68aa8885bUL;
   tf->codes[1021] = 0x0000d8b6ffc693e5UL;
   tf->codes[1022] = 0x0000d8b7ea02aaf9UL;
   tf->codes[1023] = 0x0000d8b983ebd35cUL;
   tf->codes[1024] = 0x0000d8bb58640184UL;
   tf->codes[1025] = 0x0000d8bb92f30749UL;
   tf->codes[1026] = 0x0000d8bc7d2f1e5dUL;
   tf->codes[1027] = 0x0000d8bcf24d29e7UL;
   tf->codes[1028] = 0x0000d8bddc8940fbUL;
   tf->codes[1029] = 0x0000d8bfb1016f23UL;
   tf->codes[1030] = 0x0000d8c0261f7aadUL;
   tf->codes[1031] = 0x0000d8c09b3d8637UL;
   tf->codes[1032] = 0x0000d8c1c008a310UL;
   tf->codes[1033] = 0x0000d8c23526ae9aUL;
   tf->codes[1034] = 0x0000d8c4099edcc2UL;
   tf->codes[1035] = 0x0000d8c4442de287UL;
   tf->codes[1036] = 0x0000d8c568f8ff60UL;
   tf->codes[1037] = 0x0000d8c5a3880525UL;
   tf->codes[1038] = 0x0000d8c5de170aeaUL;
   tf->codes[1039] = 0x0000d8c618a610afUL;
   tf->codes[1040] = 0x0000d8c702e227c3UL;
   tf->codes[1041] = 0x0000d8c827ad449cUL;
   tf->codes[1042] = 0x0000d8c8623c4a61UL;
   tf->codes[1043] = 0x0000d8c911e95bb0UL;
   tf->codes[1044] = 0x0000d8caabd28413UL;
   tf->codes[1045] = 0x0000d8cb960e9b27UL;
   tf->codes[1046] = 0x0000d8cc45bbac76UL;
   tf->codes[1047] = 0x0000d8cc804ab23bUL;
   tf->codes[1048] = 0x0000d8cda515cf14UL;
   tf->codes[1049] = 0x0000d8ce1a33da9eUL;
   tf->codes[1050] = 0x0000d8cf046ff1b2UL;
   tf->codes[1051] = 0x0000d8cf798dfd3cUL;
   tf->codes[1052] = 0x0000d8d14e062b64UL;
   tf->codes[1053] = 0x0000d8d1c32436eeUL;
   tf->codes[1054] = 0x0000d8d238424278UL;
   tf->codes[1055] = 0x0000d8d2ad604e02UL;
   tf->codes[1056] = 0x0000d8d2e7ef53c7UL;
   tf->codes[1057] = 0x0000d8d3227e598cUL;
   tf->codes[1058] = 0x0000d8d3d22b6adbUL;
   tf->codes[1059] = 0x0000d8d4bc6781efUL;
   tf->codes[1060] = 0x0000d8d5e1329ec8UL;
   tf->codes[1061] = 0x0000d8d77b1bc72bUL;
   tf->codes[1062] = 0x0000d8d86557de3fUL;
   tf->codes[1063] = 0x0000d8d98a22fb18UL;
   tf->codes[1064] = 0x0000d8d9c4b200ddUL;
   tf->codes[1065] = 0x0000d8d9ff4106a2UL;
   tf->codes[1066] = 0x0000d8db240c237bUL;
   tf->codes[1067] = 0x0000d8dc83664619UL;
   tf->codes[1068] = 0x0000d8dcbdf54bdeUL;
   tf->codes[1069] = 0x0000d8dcf88451a3UL;
   tf->codes[1070] = 0x0000d8dda83162f2UL;
   tf->codes[1071] = 0x0000d8dde2c068b7UL;
   tf->codes[1072] = 0x0000d8deccfc7fcbUL;
   tf->codes[1073] = 0x0000d8df421a8b55UL;
   tf->codes[1074] = 0x0000d8dfb73896dfUL;
   tf->codes[1075] = 0x0000d8e02c56a269UL;
   tf->codes[1076] = 0x0000d8e066e5a82eUL;
   tf->codes[1077] = 0x0000d8e0dc03b3b8UL;
   tf->codes[1078] = 0x0000d8e11692b97dUL;
   tf->codes[1079] = 0x0000d8e15121bf42UL;
   tf->codes[1080] = 0x0000d8e200ced091UL;
   tf->codes[1081] = 0x0000d8e2b07be1e0UL;
   tf->codes[1082] = 0x0000d8e32599ed6aUL;
   tf->codes[1083] = 0x0000d8e39ab7f8f4UL;
   tf->codes[1084] = 0x0000d8e4bf8315cdUL;
   tf->codes[1085] = 0x0000d8e56f30271cUL;
   tf->codes[1086] = 0x0000d8e5a9bf2ce1UL;
   tf->codes[1087] = 0x0000d8e5e44e32a6UL;
   tf->codes[1088] = 0x0000d8e7b8c660ceUL;
   tf->codes[1089] = 0x0000d8e7f3556693UL;
   tf->codes[1090] = 0x0000d8e91820836cUL;
   tf->codes[1091] = 0x0000d8e952af8931UL;
   tf->codes[1092] = 0x0000d8e98d3e8ef6UL;
   tf->codes[1093] = 0x0000d8eb2727b759UL;
   tf->codes[1094] = 0x0000d8eb61b6bd1eUL;
   tf->codes[1095] = 0x0000d8eb9c45c2e3UL;
   tf->codes[1096] = 0x0000d8edab4cf6d0UL;
   tf->codes[1097] = 0x0000d8ee5afa081fUL;
   tf->codes[1098] = 0x0000d8efba542abdUL;
   tf->codes[1099] = 0x0000d8f1543d5320UL;
   tf->codes[1100] = 0x0000d8f23e796a34UL;
   tf->codes[1101] = 0x0000d8f328b58148UL;
   tf->codes[1102] = 0x0000d8f36344870dUL;
   tf->codes[1103] = 0x0000d8f39dd38cd2UL;
   tf->codes[1104] = 0x0000d8f3d8629297UL;
   tf->codes[1105] = 0x0000d8f4fd2daf70UL;
   tf->codes[1106] = 0x0000d8f5e769c684UL;
   tf->codes[1107] = 0x0000d8f65c87d20eUL;
   tf->codes[1108] = 0x0000d8f746c3e922UL;
   tf->codes[1109] = 0x0000d8f78152eee7UL;
   tf->codes[1110] = 0x0000d8f86b8f05fbUL;
   tf->codes[1111] = 0x0000d8f8a61e0bc0UL;
   tf->codes[1112] = 0x0000d8f955cb1d0fUL;
   tf->codes[1113] = 0x0000d8f9cae92899UL;
   tf->codes[1114] = 0x0000d8fab5253fadUL;
   tf->codes[1115] = 0x0000d8faefb44572UL;
   tf->codes[1116] = 0x0000d8fb2a434b37UL;
   tf->codes[1117] = 0x0000d8fbd9f05c86UL;
   tf->codes[1118] = 0x0000d8fcfebb795fUL;
   tf->codes[1119] = 0x0000d8fe5e159bfdUL;
   tf->codes[1120] = 0x0000d8fe98a4a1c2UL;
   tf->codes[1121] = 0x0000d8fed333a787UL;
   tf->codes[1122] = 0x0000d900328dca25UL;
   tf->codes[1123] = 0x0000d9011cc9e139UL;
   tf->codes[1124] = 0x0000d901cc76f288UL;
   tf->codes[1125] = 0x0000d9024194fe12UL;
   tf->codes[1126] = 0x0000d9027c2403d7UL;
   tf->codes[1127] = 0x0000d90366601aebUL;
   tf->codes[1128] = 0x0000d903a0ef20b0UL;
   tf->codes[1129] = 0x0000d903db7e2675UL;
   tf->codes[1130] = 0x0000d904509c31ffUL;
   tf->codes[1131] = 0x0000d9069a326bb1UL;
   tf->codes[1132] = 0x0000d9070f50773bUL;
   tf->codes[1133] = 0x0000d907846e82c5UL;
   tf->codes[1134] = 0x0000d908a9399f9eUL;
   tf->codes[1135] = 0x0000d9091e57ab28UL;
   tf->codes[1136] = 0x0000d90958e6b0edUL;
   tf->codes[1137] = 0x0000d909ce04bc77UL;
   tf->codes[1138] = 0x0000d90af2cfd950UL;
   tf->codes[1139] = 0x0000d90ba27cea9fUL;
   tf->codes[1140] = 0x0000d90c179af629UL;
   tf->codes[1141] = 0x0000d90c8cb901b3UL;
   tf->codes[1142] = 0x0000d90d76f518c7UL;
   tf->codes[1143] = 0x0000d90e61312fdbUL;
   tf->codes[1144] = 0x0000d90e9bc035a0UL;
   tf->codes[1145] = 0x0000d90f4b6d46efUL;
   tf->codes[1146] = 0x0000d90ffb1a583eUL;
   tf->codes[1147] = 0x0000d91035a95e03UL;
   tf->codes[1148] = 0x0000d910703863c8UL;
   tf->codes[1149] = 0x0000d911950380a1UL;
   tf->codes[1150] = 0x0000d91244b091f0UL;
   tf->codes[1151] = 0x0000d912f45da33fUL;
   tf->codes[1152] = 0x0000d913697baec9UL;
   tf->codes[1153] = 0x0000d913a40ab48eUL;
   tf->codes[1154] = 0x0000d9141928c018UL;
   tf->codes[1155] = 0x0000d915b311e87bUL;
   tf->codes[1156] = 0x0000d915eda0ee40UL;
   tf->codes[1157] = 0x0000d916282ff405UL;
   tf->codes[1158] = 0x0000d91662bef9caUL;
   tf->codes[1159] = 0x0000d917126c0b19UL;
   tf->codes[1160] = 0x0000d9174cfb10deUL;
   tf->codes[1161] = 0x0000d917878a16a3UL;
   tf->codes[1162] = 0x0000d917fca8222dUL;
   tf->codes[1163] = 0x0000d91921733f06UL;
   tf->codes[1164] = 0x0000d91abb5c6769UL;
   tf->codes[1165] = 0x0000d91b307a72f3UL;
   tf->codes[1166] = 0x0000d91be0278442UL;
   tf->codes[1167] = 0x0000d91c1ab68a07UL;
   tf->codes[1168] = 0x0000d91cca639b56UL;
   tf->codes[1169] = 0x0000d91f4e88dacdUL;
   tf->codes[1170] = 0x0000d920e8720330UL;
   tf->codes[1171] = 0x0000d921230108f5UL;
   tf->codes[1172] = 0x0000d921d2ae1a44UL;
   tf->codes[1173] = 0x0000d9220d3d2009UL;
   tf->codes[1174] = 0x0000d92247cc25ceUL;
   tf->codes[1175] = 0x0000d922bcea3158UL;
   tf->codes[1176] = 0x0000d9236c9742a7UL;
   tf->codes[1177] = 0x0000d923a726486cUL;
   tf->codes[1178] = 0x0000d923e1b54e31UL;
   tf->codes[1179] = 0x0000d92456d359bbUL;
   tf->codes[1180] = 0x0000d92491625f80UL;
   tf->codes[1181] = 0x0000d92506806b0aUL;
   tf->codes[1182] = 0x0000d925410f70cfUL;
   tf->codes[1183] = 0x0000d925f0bc821eUL;
   tf->codes[1184] = 0x0000d9262b4b87e3UL;
   tf->codes[1185] = 0x0000d9275016a4bcUL;
   tf->codes[1186] = 0x0000d927c534b046UL;
   tf->codes[1187] = 0x0000d9283a52bbd0UL;
   tf->codes[1188] = 0x0000d929248ed2e4UL;
   tf->codes[1189] = 0x0000d9295f1dd8a9UL;
   tf->codes[1190] = 0x0000d92999acde6eUL;
   tf->codes[1191] = 0x0000d929d43be433UL;
   tf->codes[1192] = 0x0000d92a0ecae9f8UL;
   tf->codes[1193] = 0x0000d92af907010cUL;
   tf->codes[1194] = 0x0000d92b6e250c96UL;
   tf->codes[1195] = 0x0000d92ba8b4125bUL;
   tf->codes[1196] = 0x0000d92be3431820UL;
   tf->codes[1197] = 0x0000d92ccd7f2f34UL;
   tf->codes[1198] = 0x0000d92db7bb4648UL;
   tf->codes[1199] = 0x0000d92df24a4c0dUL;
   tf->codes[1200] = 0x0000d92edc866321UL;
   tf->codes[1201] = 0x0000d92f171568e6UL;
   tf->codes[1202] = 0x0000d92f51a46eabUL;
   tf->codes[1203] = 0x0000d931261c9cd3UL;
   tf->codes[1204] = 0x0000d9319b3aa85dUL;
   tf->codes[1205] = 0x0000d931d5c9ae22UL;
   tf->codes[1206] = 0x0000d9324ae7b9acUL;
   tf->codes[1207] = 0x0000d932fa94cafbUL;
   tf->codes[1208] = 0x0000d933aa41dc4aUL;
   tf->codes[1209] = 0x0000d93459eeed99UL;
   tf->codes[1210] = 0x0000d935442b04adUL;
   tf->codes[1211] = 0x0000d9362e671bc1UL;
   tf->codes[1212] = 0x0000d936de142d10UL;
   tf->codes[1213] = 0x0000d93718a332d5UL;
   tf->codes[1214] = 0x0000d9375332389aUL;
   tf->codes[1215] = 0x0000d937c8504424UL;
   tf->codes[1216] = 0x0000d9383d6e4faeUL;
   tf->codes[1217] = 0x0000d938b28c5b38UL;
   tf->codes[1218] = 0x0000d9399cc8724cUL;
   tf->codes[1219] = 0x0000d939d7577811UL;
   tf->codes[1220] = 0x0000d93a11e67dd6UL;
   tf->codes[1221] = 0x0000d93ac1938f25UL;
   tf->codes[1222] = 0x0000d93b7140a074UL;
   tf->codes[1223] = 0x0000d93ea512f13aUL;
   tf->codes[1224] = 0x0000d93f1a30fcc4UL;
   tf->codes[1225] = 0x0000d940046d13d8UL;
   tf->codes[1226] = 0x0000d9403efc199dUL;
   tf->codes[1227] = 0x0000d940798b1f62UL;
   tf->codes[1228] = 0x0000d940eea92aecUL;
   tf->codes[1229] = 0x0000d941d8e54200UL;
   tf->codes[1230] = 0x0000d942137447c5UL;
   tf->codes[1231] = 0x0000d9428892534fUL;
   tf->codes[1232] = 0x0000d942c3215914UL;
   tf->codes[1233] = 0x0000d943383f649eUL;
   tf->codes[1234] = 0x0000d94372ce6a63UL;
   tf->codes[1235] = 0x0000d944227b7bb2UL;
   tf->codes[1236] = 0x0000d9449799873cUL;
   tf->codes[1237] = 0x0000d944d2288d01UL;
   tf->codes[1238] = 0x0000d9454746988bUL;
   tf->codes[1239] = 0x0000d945f6f3a9daUL;
   tf->codes[1240] = 0x0000d9466c11b564UL;
   tf->codes[1241] = 0x0000d947564dcc78UL;
   tf->codes[1242] = 0x0000d94790dcd23dUL;
   tf->codes[1243] = 0x0000d9484089e38cUL;
   tf->codes[1244] = 0x0000d9492ac5faa0UL;
   tf->codes[1245] = 0x0000d94a150211b4UL;
   tf->codes[1246] = 0x0000d94aff3e28c8UL;
   tf->codes[1247] = 0x0000d94b745c3452UL;
   tf->codes[1248] = 0x0000d94c9927512bUL;
   tf->codes[1249] = 0x0000d94df88173c9UL;
   tf->codes[1250] = 0x0000d94ea82e8518UL;
   tf->codes[1251] = 0x0000d94f57db9667UL;
   tf->codes[1252] = 0x0000d950f1c4becaUL;
   tf->codes[1253] = 0x0000d9512c53c48fUL;
   tf->codes[1254] = 0x0000d95166e2ca54UL;
   tf->codes[1255] = 0x0000d9528bade72dUL;
   tf->codes[1256] = 0x0000d952c63cecf2UL;
   tf->codes[1257] = 0x0000d95460261555UL;
   tf->codes[1258] = 0x0000d954d54420dfUL;
   tf->codes[1259] = 0x0000d9550fd326a4UL;
   tf->codes[1260] = 0x0000d955fa0f3db8UL;
   tf->codes[1261] = 0x0000d9566f2d4942UL;
   tf->codes[1262] = 0x0000d9571eda5a91UL;
   tf->codes[1263] = 0x0000d95759696056UL;
   tf->codes[1264] = 0x0000d958f35288b9UL;
   tf->codes[1265] = 0x0000d959a2ff9a08UL;
   tf->codes[1266] = 0x0000d95a52acab57UL;
   tf->codes[1267] = 0x0000d95a8d3bb11cUL;
   tf->codes[1268] = 0x0000d95b3ce8c26bUL;
   tf->codes[1269] = 0x0000d95bec95d3baUL;
   tf->codes[1270] = 0x0000d95d867efc1dUL;
   tf->codes[1271] = 0x0000d95e70bb1331UL;
   tf->codes[1272] = 0x0000d95f20682480UL;
   tf->codes[1273] = 0x0000d95f9586300aUL;
   tf->codes[1274] = 0x0000d96219ab6f81UL;
   tf->codes[1275] = 0x0000d962543a7546UL;
   tf->codes[1276] = 0x0000d96303e78695UL;
   tf->codes[1277] = 0x0000d9633e768c5aUL;
   tf->codes[1278] = 0x0000d9637905921fUL;
   tf->codes[1279] = 0x0000d963b39497e4UL;
   tf->codes[1280] = 0x0000d963ee239da9UL;
   tf->codes[1281] = 0x0000d96428b2a36eUL;
   tf->codes[1282] = 0x0000d9646341a933UL;
   tf->codes[1283] = 0x0000d9649dd0aef8UL;
   tf->codes[1284] = 0x0000d965880cc60cUL;
   tf->codes[1285] = 0x0000d965c29bcbd1UL;
   tf->codes[1286] = 0x0000d96637b9d75bUL;
   tf->codes[1287] = 0x0000d9696b8c2821UL;
   tf->codes[1288] = 0x0000d969a61b2de6UL;
   tf->codes[1289] = 0x0000d96b05755084UL;
   tf->codes[1290] = 0x0000d96b40045649UL;
   tf->codes[1291] = 0x0000d96bb52261d3UL;
   tf->codes[1292] = 0x0000d96c2a406d5dUL;
   tf->codes[1293] = 0x0000d96d147c8471UL;
   tf->codes[1294] = 0x0000d96dc42995c0UL;
   tf->codes[1295] = 0x0000d96f2383b85eUL;
   tf->codes[1296] = 0x0000d96fd330c9adUL;
   tf->codes[1297] = 0x0000d97082dddafcUL;
   tf->codes[1298] = 0x0000d9721cc7035fUL;
   tf->codes[1299] = 0x0000d97257560924UL;
   tf->codes[1300] = 0x0000d97291e50ee9UL;
   tf->codes[1301] = 0x0000d9737c2125fdUL;
   tf->codes[1302] = 0x0000d973b6b02bc2UL;
   tf->codes[1303] = 0x0000d9742bce374cUL;
   tf->codes[1304] = 0x0000d974a0ec42d6UL;
   tf->codes[1305] = 0x0000d974db7b489bUL;
   tf->codes[1306] = 0x0000d975160a4e60UL;
   tf->codes[1307] = 0x0000d9758b2859eaUL;
   tf->codes[1308] = 0x0000d9772511824dUL;
   tf->codes[1309] = 0x0000d9779a2f8dd7UL;
   tf->codes[1310] = 0x0000d9780f4d9961UL;
   tf->codes[1311] = 0x0000d97849dc9f26UL;
   tf->codes[1312] = 0x0000d9796ea7bbffUL;
   tf->codes[1313] = 0x0000d97bb83df5b1UL;
   tf->codes[1314] = 0x0000d97c2d5c013bUL;
   tf->codes[1315] = 0x0000d97c67eb0700UL;
   tf->codes[1316] = 0x0000d97e3c633528UL;
   tf->codes[1317] = 0x0000d97eb18140b2UL;
   tf->codes[1318] = 0x0000d97f9bbd57c6UL;
   tf->codes[1319] = 0x0000d98010db6350UL;
   tf->codes[1320] = 0x0000d981aac48bb3UL;
   tf->codes[1321] = 0x0000d981e5539178UL;
   tf->codes[1322] = 0x0000d9821fe2973dUL;
   tf->codes[1323] = 0x0000d9829500a2c7UL;
   tf->codes[1324] = 0x0000d982cf8fa88cUL;
   tf->codes[1325] = 0x0000d98344adb416UL;
   tf->codes[1326] = 0x0000d983b9cbbfa0UL;
   tf->codes[1327] = 0x0000d9842ee9cb2aUL;
   tf->codes[1328] = 0x0000d984de96dc79UL;
   tf->codes[1329] = 0x0000d98553b4e803UL;
   tf->codes[1330] = 0x0000d986788004dcUL;
   tf->codes[1331] = 0x0000d986ed9e1066UL;
   tf->codes[1332] = 0x0000d987282d162bUL;
   tf->codes[1333] = 0x0000d987d7da277aUL;
   tf->codes[1334] = 0x0000d98812692d3fUL;
   tf->codes[1335] = 0x0000d989ac5255a2UL;
   tf->codes[1336] = 0x0000d98a968e6cb6UL;
   tf->codes[1337] = 0x0000d98b463b7e05UL;
   tf->codes[1338] = 0x0000d98bf5e88f54UL;
   tf->codes[1339] = 0x0000d98eb49cd490UL;
   tf->codes[1340] = 0x0000d98f29bae01aUL;
   tf->codes[1341] = 0x0000d990fe330e42UL;
   tf->codes[1342] = 0x0000d99138c21407UL;
   tf->codes[1343] = 0x0000d991735119ccUL;
   tf->codes[1344] = 0x0000d9925d8d30e0UL;
   tf->codes[1345] = 0x0000d992981c36a5UL;
   tf->codes[1346] = 0x0000d9930d3a422fUL;
   tf->codes[1347] = 0x0000d99382584db9UL;
   tf->codes[1348] = 0x0000d996067d8d30UL;
   tf->codes[1349] = 0x0000d996410c92f5UL;
   tf->codes[1350] = 0x0000d996f0b9a444UL;
   tf->codes[1351] = 0x0000d99765d7afceUL;
   tf->codes[1352] = 0x0000d997a066b593UL;
   tf->codes[1353] = 0x0000d997daf5bb58UL;
   tf->codes[1354] = 0x0000d9985013c6e2UL;
   tf->codes[1355] = 0x0000d999af6de980UL;
   tf->codes[1356] = 0x0000d99ad4390659UL;
   tf->codes[1357] = 0x0000d99c6e222ebcUL;
   tf->codes[1358] = 0x0000d99ca8b13481UL;
   tf->codes[1359] = 0x0000d99d1dcf400bUL;
   tf->codes[1360] = 0x0000d99e080b571fUL;
   tf->codes[1361] = 0x0000d99e429a5ce4UL;
   tf->codes[1362] = 0x0000d99f676579bdUL;
   tf->codes[1363] = 0x0000d99fdc838547UL;
   tf->codes[1364] = 0x0000d9a051a190d1UL;
   tf->codes[1365] = 0x0000d9a1b0fbb36fUL;
   tf->codes[1366] = 0x0000d9a29b37ca83UL;
   tf->codes[1367] = 0x0000d9a2d5c6d048UL;
   tf->codes[1368] = 0x0000d9a3fa91ed21UL;
   tf->codes[1369] = 0x0000d9a4e4ce0435UL;
   tf->codes[1370] = 0x0000d9a51f5d09faUL;
   tf->codes[1371] = 0x0000d9a6442826d3UL;
   tf->codes[1372] = 0x0000d9a6b946325dUL;
   tf->codes[1373] = 0x0000d9a8c84d664aUL;
   tf->codes[1374] = 0x0000d9a902dc6c0fUL;
   tf->codes[1375] = 0x0000d9a93d6b71d4UL;
   tf->codes[1376] = 0x0000d9a9b2897d5eUL;
   tf->codes[1377] = 0x0000d9aa62368eadUL;
   tf->codes[1378] = 0x0000d9aad7549a37UL;
   tf->codes[1379] = 0x0000d9ae8044f687UL;
   tf->codes[1380] = 0x0000d9afa5101360UL;
   tf->codes[1381] = 0x0000d9b01a2e1eeaUL;
   tf->codes[1382] = 0x0000d9b1b417474dUL;
   tf->codes[1383] = 0x0000d9b2293552d7UL;
   tf->codes[1384] = 0x0000d9b3137169ebUL;
   tf->codes[1385] = 0x0000d9b3888f7575UL;
   tf->codes[1386] = 0x0000d9b3c31e7b3aUL;
   tf->codes[1387] = 0x0000d9b4e7e99813UL;
   tf->codes[1388] = 0x0000d9b60cb4b4ecUL;
   tf->codes[1389] = 0x0000d9b64743bab1UL;
   tf->codes[1390] = 0x0000d9b6bc61c63bUL;
   tf->codes[1391] = 0x0000d9b7317fd1c5UL;
   tf->codes[1392] = 0x0000d9b76c0ed78aUL;
   tf->codes[1393] = 0x0000d9b8564aee9eUL;
   tf->codes[1394] = 0x0000d9b9b5a5113cUL;
   tf->codes[1395] = 0x0000d9ba6552228bUL;
   tf->codes[1396] = 0x0000d9bb14ff33daUL;
   tf->codes[1397] = 0x0000d9bb4f8e399fUL;
   tf->codes[1398] = 0x0000d9bbc4ac4529UL;
   tf->codes[1399] = 0x0000d9bbff3b4aeeUL;
   tf->codes[1400] = 0x0000d9bd99247351UL;
   tf->codes[1401] = 0x0000d9c09267be52UL;
   tf->codes[1402] = 0x0000d9c1b732db2bUL;
   tf->codes[1403] = 0x0000d9c3511c038eUL;
   tf->codes[1404] = 0x0000d9c38bab0953UL;
   tf->codes[1405] = 0x0000d9c3c63a0f18UL;
   tf->codes[1406] = 0x0000d9c4b076262cUL;
   tf->codes[1407] = 0x0000d9c5259431b6UL;
   tf->codes[1408] = 0x0000d9c59ab23d40UL;
   tf->codes[1409] = 0x0000d9c6bf7d5a19UL;
   tf->codes[1410] = 0x0000d9c6fa0c5fdeUL;
   tf->codes[1411] = 0x0000d9c7a9b9712dUL;
   tf->codes[1412] = 0x0000d9c893f58841UL;
   tf->codes[1413] = 0x0000d9c9091393cbUL;
   tf->codes[1414] = 0x0000d9c9f34faadfUL;
   tf->codes[1415] = 0x0000d9cb181ac7b8UL;
   tf->codes[1416] = 0x0000d9cc0256deccUL;
   tf->codes[1417] = 0x0000d9cd61b1016aUL;
   tf->codes[1418] = 0x0000d9cf36292f92UL;
   tf->codes[1419] = 0x0000d9cfe5d640e1UL;
   tf->codes[1420] = 0x0000d9d05af44c6bUL;
   tf->codes[1421] = 0x0000d9d2df198be2UL;
   tf->codes[1422] = 0x0000d9d3c955a2f6UL;
   tf->codes[1423] = 0x0000d9d403e4a8bbUL;
   tf->codes[1424] = 0x0000d9d612ebdca8UL;
   tf->codes[1425] = 0x0000d9d68809e832UL;
   tf->codes[1426] = 0x0000d9d77245ff46UL;
   tf->codes[1427] = 0x0000d9d7e7640ad0UL;
   tf->codes[1428] = 0x0000d9d85c82165aUL;
   tf->codes[1429] = 0x0000d9d8d1a021e4UL;
   tf->codes[1430] = 0x0000d9d90c2f27a9UL;
   tf->codes[1431] = 0x0000d9dbcae36ce5UL;
   tf->codes[1432] = 0x0000d9de4f08ac5cUL;
   tf->codes[1433] = 0x0000d9de8997b221UL;
   tf->codes[1434] = 0x0000d9dec426b7e6UL;
   tf->codes[1435] = 0x0000d9defeb5bdabUL;
   tf->codes[1436] = 0x0000d9e05e0fe049UL;
   tf->codes[1437] = 0x0000d9e10dbcf198UL;
   tf->codes[1438] = 0x0000d9e1484bf75dUL;
   tf->codes[1439] = 0x0000d9e182dafd22UL;
   tf->codes[1440] = 0x0000d9e1bd6a02e7UL;
   tf->codes[1441] = 0x0000d9e232880e71UL;
   tf->codes[1442] = 0x0000d9e2a7a619fbUL;
   tf->codes[1443] = 0x0000d9e2e2351fc0UL;
   tf->codes[1444] = 0x0000d9e47c1e4823UL;
   tf->codes[1445] = 0x0000d9e4f13c53adUL;
   tf->codes[1446] = 0x0000d9e5665a5f37UL;
   tf->codes[1447] = 0x0000d9e70043879aUL;
   tf->codes[1448] = 0x0000d9e7ea7f9eaeUL;
   tf->codes[1449] = 0x0000d9e89a2caffdUL;
   tf->codes[1450] = 0x0000d9eae3c2e9afUL;
   tf->codes[1451] = 0x0000d9ec431d0c4dUL;
   tf->codes[1452] = 0x0000d9ecb83b17d7UL;
   tf->codes[1453] = 0x0000d9ee5224403aUL;
   tf->codes[1454] = 0x0000d9eec7424bc4UL;
   tf->codes[1455] = 0x0000d9ef3c60574eUL;
   tf->codes[1456] = 0x0000d9efb17e62d8UL;
   tf->codes[1457] = 0x0000d9efec0d689dUL;
   tf->codes[1458] = 0x0000d9f14b678b3bUL;
   tf->codes[1459] = 0x0000d9f2aac1add9UL;
   tf->codes[1460] = 0x0000d9f444aad63cUL;
   tf->codes[1461] = 0x0000d9f56975f315UL;
   tf->codes[1462] = 0x0000d9f619230464UL;
   tf->codes[1463] = 0x0000d9f68e410feeUL;
   tf->codes[1464] = 0x0000d9f6c8d015b3UL;
   tf->codes[1465] = 0x0000d9f7787d2702UL;
   tf->codes[1466] = 0x0000d9f7ed9b328cUL;
   tf->codes[1467] = 0x0000d9f8282a3851UL;
   tf->codes[1468] = 0x0000d9f862b93e16UL;
   tf->codes[1469] = 0x0000d9f89d4843dbUL;
   tf->codes[1470] = 0x0000d9f9c21360b4UL;
   tf->codes[1471] = 0x0000d9fb216d8352UL;
   tf->codes[1472] = 0x0000d9fb968b8edcUL;
   tf->codes[1473] = 0x0000d9fbd11a94a1UL;
   tf->codes[1474] = 0x0000d9fc80c7a5f0UL;
   tf->codes[1475] = 0x0000da0029b80240UL;
   tf->codes[1476] = 0x0000da00d965138fUL;
   tf->codes[1477] = 0x0000da0113f41954UL;
   tf->codes[1478] = 0x0000da01c3a12aa3UL;
   tf->codes[1479] = 0x0000da02734e3bf2UL;
   tf->codes[1480] = 0x0000da035d8a5306UL;
   tf->codes[1481] = 0x0000da03981958cbUL;
   tf->codes[1482] = 0x0000da03d2a85e90UL;
   tf->codes[1483] = 0x0000da04bce475a4UL;
   tf->codes[1484] = 0x0000da053202812eUL;
   tf->codes[1485] = 0x0000da061c3e9842UL;
   tf->codes[1486] = 0x0000da0656cd9e07UL;
   tf->codes[1487] = 0x0000da06915ca3ccUL;
   tf->codes[1488] = 0x0000da07067aaf56UL;
   tf->codes[1489] = 0x0000da07f0b6c66aUL;
   tf->codes[1490] = 0x0000da082b45cc2fUL;
   tf->codes[1491] = 0x0000da09ffbdfa57UL;
   tf->codes[1492] = 0x0000da0a3a4d001cUL;
   tf->codes[1493] = 0x0000da0b5f181cf5UL;
   tf->codes[1494] = 0x0000da0b99a722baUL;
   tf->codes[1495] = 0x0000da0cbe723f93UL;
   tf->codes[1496] = 0x0000da0da8ae56a7UL;
   tf->codes[1497] = 0x0000da0de33d5c6cUL;
   tf->codes[1498] = 0x0000da0e585b67f6UL;
   tf->codes[1499] = 0x0000da0e92ea6dbbUL;
   tf->codes[1500] = 0x0000da0f08087945UL;
   tf->codes[1501] = 0x0000da0f42977f0aUL;
   tf->codes[1502] = 0x0000da0fb7b58a94UL;
   tf->codes[1503] = 0x0000da10a1f1a1a8UL;
   tf->codes[1504] = 0x0000da10dc80a76dUL;
   tf->codes[1505] = 0x0000da12014bc446UL;
   tf->codes[1506] = 0x0000da13d5c3f26eUL;
   tf->codes[1507] = 0x0000da141052f833UL;
   tf->codes[1508] = 0x0000da14c0000982UL;
   tf->codes[1509] = 0x0000da14fa8f0f47UL;
   tf->codes[1510] = 0x0000da161f5a2c20UL;
   tf->codes[1511] = 0x0000da16947837aaUL;
   tf->codes[1512] = 0x0000da17442548f9UL;
   tf->codes[1513] = 0x0000da17b9435483UL;
   tf->codes[1514] = 0x0000da17f3d25a48UL;
   tf->codes[1515] = 0x0000da1868f065d2UL;
   tf->codes[1516] = 0x0000da18de0e715cUL;
   tf->codes[1517] = 0x0000da19189d7721UL;
   tf->codes[1518] = 0x0000da19c84a8870UL;
   tf->codes[1519] = 0x0000da1a3d6893faUL;
   tf->codes[1520] = 0x0000da1b27a4ab0eUL;
   tf->codes[1521] = 0x0000da1b6233b0d3UL;
   tf->codes[1522] = 0x0000da1c86fecdacUL;
   tf->codes[1523] = 0x0000da1cc18dd371UL;
   tf->codes[1524] = 0x0000da1d713ae4c0UL;
   tf->codes[1525] = 0x0000da1de658f04aUL;
   tf->codes[1526] = 0x0000da1f0b240d23UL;
   tf->codes[1527] = 0x0000da1f45b312e8UL;
   tf->codes[1528] = 0x0000da1ff5602437UL;
   tf->codes[1529] = 0x0000da20df9c3b4bUL;
   tf->codes[1530] = 0x0000da211a2b4110UL;
   tf->codes[1531] = 0x0000da2154ba46d5UL;
   tf->codes[1532] = 0x0000da22798563aeUL;
   tf->codes[1533] = 0x0000da22b4146973UL;
   tf->codes[1534] = 0x0000da239e508087UL;
   tf->codes[1535] = 0x0000da253839a8eaUL;
   tf->codes[1536] = 0x0000da25ad57b474UL;
   tf->codes[1537] = 0x0000da25e7e6ba39UL;
   tf->codes[1538] = 0x0000da26d222d14dUL;
   tf->codes[1539] = 0x0000da270cb1d712UL;
   tf->codes[1540] = 0x0000da28e12a053aUL;
   tf->codes[1541] = 0x0000da291bb90affUL;
   tf->codes[1542] = 0x0000da29cb661c4eUL;
   tf->codes[1543] = 0x0000da2a408427d8UL;
   tf->codes[1544] = 0x0000da2b2ac03eecUL;
   tf->codes[1545] = 0x0000da2b654f44b1UL;
   tf->codes[1546] = 0x0000da2b9fde4a76UL;
   tf->codes[1547] = 0x0000da2c14fc5600UL;
   tf->codes[1548] = 0x0000da2d39c772d9UL;
   tf->codes[1549] = 0x0000da2e5e928fb2UL;
   tf->codes[1550] = 0x0000da2f48cea6c6UL;
   tf->codes[1551] = 0x0000da2ff87bb815UL;
   tf->codes[1552] = 0x0000da306d99c39fUL;
   tf->codes[1553] = 0x0000da30a828c964UL;
   tf->codes[1554] = 0x0000da319264e078UL;
   tf->codes[1555] = 0x0000da31ccf3e63dUL;
   tf->codes[1556] = 0x0000da32f1bf0316UL;
   tf->codes[1557] = 0x0000da332c4e08dbUL;
   tf->codes[1558] = 0x0000da34c637313eUL;
   tf->codes[1559] = 0x0000da3500c63703UL;
   tf->codes[1560] = 0x0000da353b553cc8UL;
   tf->codes[1561] = 0x0000da3575e4428dUL;
   tf->codes[1562] = 0x0000da374a5c70b5UL;
   tf->codes[1563] = 0x0000da37bf7a7c3fUL;
   tf->codes[1564] = 0x0000da38e4459918UL;
   tf->codes[1565] = 0x0000da391ed49eddUL;
   tf->codes[1566] = 0x0000da395963a4a2UL;
   tf->codes[1567] = 0x0000da3a0910b5f1UL;
   tf->codes[1568] = 0x0000da3c8d35f568UL;
   tf->codes[1569] = 0x0000da3d3ce306b7UL;
   tf->codes[1570] = 0x0000da40362651b8UL;
   tf->codes[1571] = 0x0000da4070b5577dUL;
   tf->codes[1572] = 0x0000da42452d85a5UL;
   tf->codes[1573] = 0x0000da43a487a843UL;
   tf->codes[1574] = 0x0000da448ec3bf57UL;
   tf->codes[1575] = 0x0000da44c952c51cUL;
   tf->codes[1576] = 0x0000da4628ace7baUL;
   tf->codes[1577] = 0x0000da4712e8feceUL;
   tf->codes[1578] = 0x0000da474d780493UL;
   tf->codes[1579] = 0x0000da4837b41ba7UL;
   tf->codes[1580] = 0x0000da4921f032bbUL;
   tf->codes[1581] = 0x0000da4a46bb4f94UL;
   tf->codes[1582] = 0x0000da4af66860e3UL;
   tf->codes[1583] = 0x0000da4ba6157232UL;
   tf->codes[1584] = 0x0000da4c55c28381UL;
   tf->codes[1585] = 0x0000da4f1476c8bdUL;
   tf->codes[1586] = 0x0000da4fc423da0cUL;
   tf->codes[1587] = 0x0000da50ae5ff120UL;
   tf->codes[1588] = 0x0000da515e0d026fUL;
   tf->codes[1589] = 0x0000da53e23241e6UL;
   tf->codes[1590] = 0x0000da54cc6e58faUL;
   tf->codes[1591] = 0x0000da55418c6484UL;
   tf->codes[1592] = 0x0000da562bc87b98UL;
   tf->codes[1593] = 0x0000da57160492acUL;
   tf->codes[1594] = 0x0000da578b229e36UL;
   tf->codes[1595] = 0x0000da599a29d223UL;
   tf->codes[1596] = 0x0000da59d4b8d7e8UL;
   tf->codes[1597] = 0x0000da5abef4eefcUL;
   tf->codes[1598] = 0x0000da5b3412fa86UL;
   tf->codes[1599] = 0x0000da5ba9310610UL;
   tf->codes[1600] = 0x0000da5be3c00bd5UL;
   tf->codes[1601] = 0x0000da5c1e4f119aUL;
   tf->codes[1602] = 0x0000da5e2d564587UL;
   tf->codes[1603] = 0x0000da5ea2745111UL;
   tf->codes[1604] = 0x0000da5edd0356d6UL;
   tf->codes[1605] = 0x0000da5f52216260UL;
   tf->codes[1606] = 0x0000da60b17b84feUL;
   tf->codes[1607] = 0x0000da60ec0a8ac3UL;
   tf->codes[1608] = 0x0000da616128964dUL;
   tf->codes[1609] = 0x0000da62fb11beb0UL;
   tf->codes[1610] = 0x0000da63702fca3aUL;
   tf->codes[1611] = 0x0000da6494fae713UL;
   tf->codes[1612] = 0x0000da662ee40f76UL;
   tf->codes[1613] = 0x0000da666973153bUL;
   tf->codes[1614] = 0x0000da66a4021b00UL;
   tf->codes[1615] = 0x0000da671920268aUL;
   tf->codes[1616] = 0x0000da6753af2c4fUL;
   tf->codes[1617] = 0x0000da683deb4363UL;
   tf->codes[1618] = 0x0000da68ed9854b2UL;
   tf->codes[1619] = 0x0000da6afc9f889fUL;
   tf->codes[1620] = 0x0000da6d80c4c816UL;
   tf->codes[1621] = 0x0000da6e3071d965UL;
   tf->codes[1622] = 0x0000da6ee01eeab4UL;
   tf->codes[1623] = 0x0000da6f553cf63eUL;
   tf->codes[1624] = 0x0000da6fca5b01c8UL;
   tf->codes[1625] = 0x0000da7129b52466UL;
   tf->codes[1626] = 0x0000da74d2a580b6UL;
   tf->codes[1627] = 0x0000da750d34867bUL;
   tf->codes[1628] = 0x0000da7582529205UL;
   tf->codes[1629] = 0x0000da76a71daedeUL;
   tf->codes[1630] = 0x0000da76e1acb4a3UL;
   tf->codes[1631] = 0x0000da7756cac02dUL;
   tf->codes[1632] = 0x0000da78f0b3e890UL;
   tf->codes[1633] = 0x0000da7a8a9d10f3UL;
   tf->codes[1634] = 0x0000da7ac52c16b8UL;
   tf->codes[1635] = 0x0000da7c24863956UL;
   tf->codes[1636] = 0x0000da7d0ec2506aUL;
   tf->codes[1637] = 0x0000da7df8fe677eUL;
   tf->codes[1638] = 0x0000da7ea8ab78cdUL;
   tf->codes[1639] = 0x0000da8008059b6bUL;
   tf->codes[1640] = 0x0000da807d23a6f5UL;
   tf->codes[1641] = 0x0000da81675fbe09UL;
   tf->codes[1642] = 0x0000da81a1eec3ceUL;
   tf->codes[1643] = 0x0000da82519bd51dUL;
   tf->codes[1644] = 0x0000da849b320ecfUL;
   tf->codes[1645] = 0x0000da854adf201eUL;
   tf->codes[1646] = 0x0000da85bffd2ba8UL;
   tf->codes[1647] = 0x0000da86351b3732UL;
   tf->codes[1648] = 0x0000da866faa3cf7UL;
   tf->codes[1649] = 0x0000da86aa3942bcUL;
   tf->codes[1650] = 0x0000da86e4c84881UL;
   tf->codes[1651] = 0x0000da87947559d0UL;
   tf->codes[1652] = 0x0000da887eb170e4UL;
   tf->codes[1653] = 0x0000da892e5e8233UL;
   tf->codes[1654] = 0x0000da8ac847aa96UL;
   tf->codes[1655] = 0x0000da8b3d65b620UL;
   tf->codes[1656] = 0x0000da8e36a90121UL;
   tf->codes[1657] = 0x0000da8e713806e6UL;
   tf->codes[1658] = 0x0000da8f20e51835UL;
   tf->codes[1659] = 0x0000da9045b0350eUL;
   tf->codes[1660] = 0x0000da90803f3ad3UL;
   tf->codes[1661] = 0x0000da9304647a4aUL;
   tf->codes[1662] = 0x0000da95136bae37UL;
   tf->codes[1663] = 0x0000da954dfab3fcUL;
   tf->codes[1664] = 0x0000da972272e224UL;
   tf->codes[1665] = 0x0000da98473dfefdUL;
   tf->codes[1666] = 0x0000da9bf02e5b4dUL;
   tf->codes[1667] = 0x0000da9c654c66d7UL;
   tf->codes[1668] = 0x0000da9dff358f3aUL;
   tf->codes[1669] = 0x0000da9eaee2a089UL;
   tf->codes[1670] = 0x0000daa048cbc8ecUL;
   tf->codes[1671] = 0x0000daa16d96e5c5UL;
   tf->codes[1672] = 0x0000daa21d43f714UL;
   tf->codes[1673] = 0x0000daa257d2fcd9UL;
   tf->codes[1674] = 0x0000daa307800e28UL;
   tf->codes[1675] = 0x0000daa3420f13edUL;
   tf->codes[1676] = 0x0000daa37c9e19b2UL;
   tf->codes[1677] = 0x0000daa4dbf83c50UL;
   tf->codes[1678] = 0x0000daa5511647daUL;
   tf->codes[1679] = 0x0000daa600c35929UL;
   tf->codes[1680] = 0x0000daa79aac818cUL;
   tf->codes[1681] = 0x0000daa7d53b8751UL;
   tf->codes[1682] = 0x0000daa884e898a0UL;
   tf->codes[1683] = 0x0000daa8bf779e65UL;
   tf->codes[1684] = 0x0000daa9a9b3b579UL;
   tf->codes[1685] = 0x0000daaa5960c6c8UL;
   tf->codes[1686] = 0x0000daaace7ed252UL;
   tf->codes[1687] = 0x0000daab090dd817UL;
   tf->codes[1688] = 0x0000daae02512318UL;
   tf->codes[1689] = 0x0000daae776f2ea2UL;
   tf->codes[1690] = 0x0000daaf271c3ff1UL;
   tf->codes[1691] = 0x0000dab0fb946e19UL;
   tf->codes[1692] = 0x0000dab1362373deUL;
   tf->codes[1693] = 0x0000dab2d00c9c41UL;
   tf->codes[1694] = 0x0000dab3ba48b355UL;
   tf->codes[1695] = 0x0000dab42f66bedfUL;
   tf->codes[1696] = 0x0000dab519a2d5f3UL;
   tf->codes[1697] = 0x0000dab8fd223808UL;
   tf->codes[1698] = 0x0000dab937b13dcdUL;
   tf->codes[1699] = 0x0000daba5c7c5aa6UL;
   tf->codes[1700] = 0x0000daba970b606bUL;
   tf->codes[1701] = 0x0000dabad19a6630UL;
   tf->codes[1702] = 0x0000dabb0c296bf5UL;
   tf->codes[1703] = 0x0000dabb46b871baUL;
   tf->codes[1704] = 0x0000dabc30f488ceUL;
   tf->codes[1705] = 0x0000dabc6b838e93UL;
   tf->codes[1706] = 0x0000dabeb519c845UL;
   tf->codes[1707] = 0x0000dabf2a37d3cfUL;
   tf->codes[1708] = 0x0000dac01473eae3UL;
   tf->codes[1709] = 0x0000dac08991f66dUL;
   tf->codes[1710] = 0x0000dac1ae5d1346UL;
   tf->codes[1711] = 0x0000dac2237b1ed0UL;
   tf->codes[1712] = 0x0000dac4a7a05e47UL;
   tf->codes[1713] = 0x0000dac606fa80e5UL;
   tf->codes[1714] = 0x0000dac6418986aaUL;
   tf->codes[1715] = 0x0000dac67c188c6fUL;
   tf->codes[1716] = 0x0000dac76654a383UL;
   tf->codes[1717] = 0x0000dac85090ba97UL;
   tf->codes[1718] = 0x0000dac88b1fc05cUL;
   tf->codes[1719] = 0x0000dac8c5aec621UL;
   tf->codes[1720] = 0x0000dac9003dcbe6UL;
   tf->codes[1721] = 0x0000daca9a26f449UL;
   tf->codes[1722] = 0x0000dacdcdf9450fUL;
   tf->codes[1723] = 0x0000dace43175099UL;
   tf->codes[1724] = 0x0000daceb8355c23UL;
   tf->codes[1725] = 0x0000dacf67e26d72UL;
   tf->codes[1726] = 0x0000dacfdd0078fcUL;
   tf->codes[1727] = 0x0000dad0178f7ec1UL;
   tf->codes[1728] = 0x0000dad0c73c9010UL;
   tf->codes[1729] = 0x0000dad26125b873UL;
   tf->codes[1730] = 0x0000dad2d643c3fdUL;
   tf->codes[1731] = 0x0000dad3c07fdb11UL;
   tf->codes[1732] = 0x0000dad3fb0ee0d6UL;
   tf->codes[1733] = 0x0000dad4e54af7eaUL;
   tf->codes[1734] = 0x0000dad8191d48b0UL;
   tf->codes[1735] = 0x0000dad88e3b543aUL;
   tf->codes[1736] = 0x0000dada28247c9dUL;
   tf->codes[1737] = 0x0000dada9d428827UL;
   tf->codes[1738] = 0x0000dadb126093b1UL;
   tf->codes[1739] = 0x0000dadbfc9caac5UL;
   tf->codes[1740] = 0x0000dadcac49bc14UL;
   tf->codes[1741] = 0x0000dadf6afe0150UL;
   tf->codes[1742] = 0x0000dae0553a1864UL;
   tf->codes[1743] = 0x0000dae104e729b3UL;
   tf->codes[1744] = 0x0000dae17a05353dUL;
   tf->codes[1745] = 0x0000dae229b2468cUL;
   tf->codes[1746] = 0x0000dae3890c692aUL;
   tf->codes[1747] = 0x0000dae3fe2a74b4UL;
   tf->codes[1748] = 0x0000dae522f5918dUL;
   tf->codes[1749] = 0x0000dae5d2a2a2dcUL;
   tf->codes[1750] = 0x0000dae60d31a8a1UL;
   tf->codes[1751] = 0x0000dae8cbe5edddUL;
   tf->codes[1752] = 0x0000dae97b92ff2cUL;
   tf->codes[1753] = 0x0000daea2b40107bUL;
   tf->codes[1754] = 0x0000daeaa05e1c05UL;
   tf->codes[1755] = 0x0000daeb8a9a3319UL;
   tf->codes[1756] = 0x0000daebffb83ea3UL;
   tf->codes[1757] = 0x0000daec3a474468UL;
   tf->codes[1758] = 0x0000daee0ebf7290UL;
   tf->codes[1759] = 0x0000daefa8a89af3UL;
   tf->codes[1760] = 0x0000daf560a02b30UL;
   tf->codes[1761] = 0x0000daf59b2f30f5UL;
   tf->codes[1762] = 0x0000daf6104d3c7fUL;
   tf->codes[1763] = 0x0000daf909908780UL;
   tf->codes[1764] = 0x0000daf97eae930aUL;
   tf->codes[1765] = 0x0000daf9f3cc9e94UL;
   tf->codes[1766] = 0x0000dafa2e5ba459UL;
   tf->codes[1767] = 0x0000dafdd74c00a9UL;
   tf->codes[1768] = 0x0000daffe6533496UL;
   tf->codes[1769] = 0x0000db00960045e5UL;
   tf->codes[1770] = 0x0000db010b1e516fUL;
   tf->codes[1771] = 0x0000db01bacb62beUL;
   tf->codes[1772] = 0x0000db01f55a6883UL;
   tf->codes[1773] = 0x0000db026a78740dUL;
   tf->codes[1774] = 0x0000db0354b48b21UL;
   tf->codes[1775] = 0x0000db043ef0a235UL;
   tf->codes[1776] = 0x0000db04ee9db384UL;
   tf->codes[1777] = 0x0000db059e4ac4d3UL;
   tf->codes[1778] = 0x0000db07ad51f8c0UL;
   tf->codes[1779] = 0x0000db082270044aUL;
   tf->codes[1780] = 0x0000db08d21d1599UL;
   tf->codes[1781] = 0x0000db090cac1b5eUL;
   tf->codes[1782] = 0x0000db0a6c063dfcUL;
   tf->codes[1783] = 0x0000db0aa69543c1UL;
   tf->codes[1784] = 0x0000db0b1bb34f4bUL;
   tf->codes[1785] = 0x0000db0b56425510UL;
   tf->codes[1786] = 0x0000db0e8a14a5d6UL;
   tf->codes[1787] = 0x0000db11f875fc61UL;
   tf->codes[1788] = 0x0000db131d41193aUL;
   tf->codes[1789] = 0x0000db13925f24c4UL;
   tf->codes[1790] = 0x0000db147c9b3bd8UL;
   tf->codes[1791] = 0x0000db14b72a419dUL;
   tf->codes[1792] = 0x0000db14f1b94762UL;
   tf->codes[1793] = 0x0000db15dbf55e76UL;
   tf->codes[1794] = 0x0000db161684643bUL;
   tf->codes[1795] = 0x0000db17eafc9263UL;
   tf->codes[1796] = 0x0000db18258b9828UL;
   tf->codes[1797] = 0x0000db18d538a977UL;
   tf->codes[1798] = 0x0000db194a56b501UL;
   tf->codes[1799] = 0x0000db1984e5bac6UL;
   tf->codes[1800] = 0x0000db1a3492cc15UL;
   tf->codes[1801] = 0x0000db1b595de8eeUL;
   tf->codes[1802] = 0x0000db1c090afa3dUL;
   tf->codes[1803] = 0x0000db20d6c67366UL;
   tf->codes[1804] = 0x0000db2236209604UL;
   tf->codes[1805] = 0x0000db22e5cda753UL;
   tf->codes[1806] = 0x0000db24ba45d57bUL;
   tf->codes[1807] = 0x0000db252f63e105UL;
   tf->codes[1808] = 0x0000db26199ff819UL;
   tf->codes[1809] = 0x0000db27b389207cUL;
   tf->codes[1810] = 0x0000db28633631cbUL;
   tf->codes[1811] = 0x0000db28d8543d55UL;
   tf->codes[1812] = 0x0000db2988014ea4UL;
   tf->codes[1813] = 0x0000db2bd1978856UL;
   tf->codes[1814] = 0x0000db2cf662a52fUL;
   tf->codes[1815] = 0x0000db2f0569d91cUL;
   tf->codes[1816] = 0x0000db2fefa5f030UL;
   tf->codes[1817] = 0x0000db30d9e20744UL;
   tf->codes[1818] = 0x0000db31898f1893UL;
   tf->codes[1819] = 0x0000db3273cb2fa7UL;
   tf->codes[1820] = 0x0000db340db4580aUL;
   tf->codes[1821] = 0x0000db377c15ae95UL;
   tf->codes[1822] = 0x0000db386651c5a9UL;
   tf->codes[1823] = 0x0000db38db6fd133UL;
   tf->codes[1824] = 0x0000db3da92b4a5cUL;
   tf->codes[1825] = 0x0000db3e1e4955e6UL;
   tf->codes[1826] = 0x0000db3f08856cfaUL;
   tf->codes[1827] = 0x0000db3f7da37884UL;
   tf->codes[1828] = 0x0000db3ff2c1840eUL;
   tf->codes[1829] = 0x0000db41178ca0e7UL;
   tf->codes[1830] = 0x0000db42b175c94aUL;
   tf->codes[1831] = 0x0000db42ec04cf0fUL;
   tf->codes[1832] = 0x0000db436122da99UL;
   tf->codes[1833] = 0x0000db439bb1e05eUL;
   tf->codes[1834] = 0x0000db45aab9144bUL;
   tf->codes[1835] = 0x0000db465a66259aUL;
   tf->codes[1836] = 0x0000db477f314273UL;
   tf->codes[1837] = 0x0000db4a035681eaUL;
   tf->codes[1838] = 0x0000db4cc20ac726UL;
   tf->codes[1839] = 0x0000db4d3728d2b0UL;
   tf->codes[1840] = 0x0000db4de6d5e3ffUL;
   tf->codes[1841] = 0x0000db4e9682f54eUL;
   tf->codes[1842] = 0x0000db4fbb4e1227UL;
   tf->codes[1843] = 0x0000db506afb2376UL;
   tf->codes[1844] = 0x0000db539ecd743cUL;
   tf->codes[1845] = 0x0000db54fe2796daUL;
   tf->codes[1846] = 0x0000db55add4a829UL;
   tf->codes[1847] = 0x0000db55e863adeeUL;
   tf->codes[1848] = 0x0000db569810bf3dUL;
   tf->codes[1849] = 0x0000db5747bdd08cUL;
   tf->codes[1850] = 0x0000db58e1a6f8efUL;
   tf->codes[1851] = 0x0000db5a41011b8dUL;
   tf->codes[1852] = 0x0000db5bdaea43f0UL;
   tf->codes[1853] = 0x0000db5d3a44668eUL;
   tf->codes[1854] = 0x0000db5fbe69a605UL;
   tf->codes[1855] = 0x0000db5ff8f8abcaUL;
   tf->codes[1856] = 0x0000db60e334c2deUL;
   tf->codes[1857] = 0x0000db6192e1d42dUL;
   tf->codes[1858] = 0x0000db61cd70d9f2UL;
   tf->codes[1859] = 0x0000db62428ee57cUL;
   tf->codes[1860] = 0x0000db62b7acf106UL;
   tf->codes[1861] = 0x0000db62f23bf6cbUL;
   tf->codes[1862] = 0x0000db632ccafc90UL;
   tf->codes[1863] = 0x0000db66260e4791UL;
   tf->codes[1864] = 0x0000db6785686a2fUL;
   tf->codes[1865] = 0x0000db67bff76ff4UL;
   tf->codes[1866] = 0x0000db6835157b7eUL;
   tf->codes[1867] = 0x0000db691f519292UL;
   tf->codes[1868] = 0x0000db6959e09857UL;
   tf->codes[1869] = 0x0000db69946f9e1cUL;
   tf->codes[1870] = 0x0000db6ab93abaf5UL;
   tf->codes[1871] = 0x0000db6b68e7cc44UL;
   tf->codes[1872] = 0x0000db6c5323e358UL;
   tf->codes[1873] = 0x0000db6c8db2e91dUL;
   tf->codes[1874] = 0x0000db6e9cba1d0aUL;
   tf->codes[1875] = 0x0000db6f4c672e59UL;
   tf->codes[1876] = 0x0000db720b1b7395UL;
   tf->codes[1877] = 0x0000db72bac884e4UL;
   tf->codes[1878] = 0x0000db73a5049bf8UL;
   tf->codes[1879] = 0x0000db73df93a1bdUL;
   tf->codes[1880] = 0x0000db7454b1ad47UL;
   tf->codes[1881] = 0x0000db75045ebe96UL;
   tf->codes[1882] = 0x0000db771365f283UL;
   tf->codes[1883] = 0x0000db7838310f5cUL;
   tf->codes[1884] = 0x0000db78ad4f1ae6UL;
   tf->codes[1885] = 0x0000db79d21a37bfUL;
   tf->codes[1886] = 0x0000db7af6e55498UL;
   tf->codes[1887] = 0x0000db7b31745a5dUL;
   tf->codes[1888] = 0x0000db80744ddf10UL;
   tf->codes[1889] = 0x0000db80aedce4d5UL;
   tf->codes[1890] = 0x0000db815e89f624UL;
   tf->codes[1891] = 0x0000db82bde418c2UL;
   tf->codes[1892] = 0x0000db83a8202fd6UL;
   tf->codes[1893] = 0x0000db85b72763c3UL;
   tf->codes[1894] = 0x0000db86a1637ad7UL;
   tf->codes[1895] = 0x0000db86dbf2809cUL;
   tf->codes[1896] = 0x0000db88b06aaec4UL;
   tf->codes[1897] = 0x0000db89d535cb9dUL;
   tf->codes[1898] = 0x0000db8a4a53d727UL;
   tf->codes[1899] = 0x0000db8b348fee3bUL;
   tf->codes[1900] = 0x0000db8be43cff8aUL;
   tf->codes[1901] = 0x0000db8cce79169eUL;
   tf->codes[1902] = 0x0000db8db8b52db2UL;
   tf->codes[1903] = 0x0000db8e2dd3393cUL;
   tf->codes[1904] = 0x0000db8f180f5050UL;
   tf->codes[1905] = 0x0000db90ec877e78UL;
   tf->codes[1906] = 0x0000db912716843dUL;
   tf->codes[1907] = 0x0000db9161a58a02UL;
   tf->codes[1908] = 0x0000db9211529b51UL;
   tf->codes[1909] = 0x0000db924be1a116UL;
   tf->codes[1910] = 0x0000db93361db82aUL;
   tf->codes[1911] = 0x0000db9370acbdefUL;
   tf->codes[1912] = 0x0000db945ae8d503UL;
   tf->codes[1913] = 0x0000db94d006e08dUL;
   tf->codes[1914] = 0x0000db97199d1a3fUL;
   tf->codes[1915] = 0x0000db978ebb25c9UL;
   tf->codes[1916] = 0x0000db97c94a2b8eUL;
   tf->codes[1917] = 0x0000db983e683718UL;
   tf->codes[1918] = 0x0000db9878f73cddUL;
   tf->codes[1919] = 0x0000db98b38642a2UL;
   tf->codes[1920] = 0x0000db98ee154867UL;
   tf->codes[1921] = 0x0000db99d8515f7bUL;
   tf->codes[1922] = 0x0000db9a12e06540UL;
   tf->codes[1923] = 0x0000db9a4d6f6b05UL;
   tf->codes[1924] = 0x0000db9a87fe70caUL;
   tf->codes[1925] = 0x0000db9ac28d768fUL;
   tf->codes[1926] = 0x0000db9afd1c7c54UL;
   tf->codes[1927] = 0x0000db9b723a87deUL;
   tf->codes[1928] = 0x0000db9c5c769ef2UL;
   tf->codes[1929] = 0x0000db9cd194aa7cUL;
   tf->codes[1930] = 0x0000db9dbbd0c190UL;
   tf->codes[1931] = 0x0000db9e30eecd1aUL;
   tf->codes[1932] = 0x0000dba0efa31256UL;
   tf->codes[1933] = 0x0000dba12a32181bUL;
   tf->codes[1934] = 0x0000dba164c11de0UL;
   tf->codes[1935] = 0x0000dba2c41b407eUL;
   tf->codes[1936] = 0x0000dba339394c08UL;
   tf->codes[1937] = 0x0000dba5f7ed9144UL;
   tf->codes[1938] = 0x0000dba66d0b9cceUL;
   tf->codes[1939] = 0x0000dba87c12d0bbUL;
   tf->codes[1940] = 0x0000dbaa8b1a04a8UL;
   tf->codes[1941] = 0x0000dbaac5a90a6dUL;
   tf->codes[1942] = 0x0000dbae340a60f8UL;
   tf->codes[1943] = 0x0000dbaf1e46780cUL;
   tf->codes[1944] = 0x0000dbb21789c30dUL;
   tf->codes[1945] = 0x0000dbb42690f6faUL;
   tf->codes[1946] = 0x0000dbb4611ffcbfUL;
   tf->codes[1947] = 0x0000dbb54b5c13d3UL;
   tf->codes[1948] = 0x0000dbb5c07a1f5dUL;
   tf->codes[1949] = 0x0000dbb6aab63671UL;
   tf->codes[1950] = 0x0000dbb6e5453c36UL;
   tf->codes[1951] = 0x0000dbb75a6347c0UL;
   tf->codes[1952] = 0x0000dbb7cf81534aUL;
   tf->codes[1953] = 0x0000dbb8f44c7023UL;
   tf->codes[1954] = 0x0000dbbbed8fbb24UL;
   tf->codes[1955] = 0x0000dbc00b9e22feUL;
   tf->codes[1956] = 0x0000dbc080bc2e88UL;
   tf->codes[1957] = 0x0000dbc255345cb0UL;
   tf->codes[1958] = 0x0000dbc2ca52683aUL;
   tf->codes[1959] = 0x0000dbc4643b909dUL;
   tf->codes[1960] = 0x0000dbc638b3bec5UL;
   tf->codes[1961] = 0x0000dbc6add1ca4fUL;
   tf->codes[1962] = 0x0000dbc6e860d014UL;
   tf->codes[1963] = 0x0000dbca1c3320daUL;
   tf->codes[1964] = 0x0000dbca91512c64UL;
   tf->codes[1965] = 0x0000dbcacbe03229UL;
   tf->codes[1966] = 0x0000dbcb7b8d4378UL;
   tf->codes[1967] = 0x0000dbcbb61c493dUL;
   tf->codes[1968] = 0x0000dbcbf0ab4f02UL;
   tf->codes[1969] = 0x0000dbcc65c95a8cUL;
   tf->codes[1970] = 0x0000dbcfd42ab117UL;
   tf->codes[1971] = 0x0000dbd1e331e504UL;
   tf->codes[1972] = 0x0000dbd3b7aa132cUL;
   tf->codes[1973] = 0x0000dbd3f23918f1UL;
   tf->codes[1974] = 0x0000dbd4dc753005UL;
   tf->codes[1975] = 0x0000dbd5170435caUL;
   tf->codes[1976] = 0x0000dbd6765e5868UL;
   tf->codes[1977] = 0x0000dbd7260b69b7UL;
   tf->codes[1978] = 0x0000dbd7609a6f7cUL;
   tf->codes[1979] = 0x0000dbd8bff4921aUL;
   tf->codes[1980] = 0x0000dbd96fa1a369UL;
   tf->codes[1981] = 0x0000dbd9e4bfaef3UL;
   tf->codes[1982] = 0x0000dbda1f4eb4b8UL;
   tf->codes[1983] = 0x0000dbda946cc042UL;
   tf->codes[1984] = 0x0000dbdeb27b281cUL;
   tf->codes[1985] = 0x0000dbe0fc1161ceUL;
   tf->codes[1986] = 0x0000dbe295fa8a31UL;
   tf->codes[1987] = 0x0000dbe2d0898ff6UL;
   tf->codes[1988] = 0x0000dbe3bac5a70aUL;
   tf->codes[1989] = 0x0000dbe3f554accfUL;
   tf->codes[1990] = 0x0000dbe6b408f20bUL;
   tf->codes[1991] = 0x0000dbe79e45091fUL;
   tf->codes[1992] = 0x0000dbea226a4896UL;
   tf->codes[1993] = 0x0000dbead21759e5UL;
   tf->codes[1994] = 0x0000dbeb0ca65faaUL;
   tf->codes[1995] = 0x0000dbeb4735656fUL;
   tf->codes[1996] = 0x0000dbed1bad9397UL;
   tf->codes[1997] = 0x0000dbedcb5aa4e6UL;
   tf->codes[1998] = 0x0000dbee4078b070UL;
   tf->codes[1999] = 0x0000dbef6543cd49UL;
   tf->codes[2000] = 0x0000dbf014f0de98UL;
   tf->codes[2001] = 0x0000dbf139bbfb71UL;
   tf->codes[2002] = 0x0000dbf1744b0136UL;
   tf->codes[2003] = 0x0000dbf1e9690cc0UL;
   tf->codes[2004] = 0x0000dbf299161e0fUL;
   tf->codes[2005] = 0x0000dbf30e342999UL;
   tf->codes[2006] = 0x0000dbf642067a5fUL;
   tf->codes[2007] = 0x0000dbf6b72485e9UL;
   tf->codes[2008] = 0x0000dbf6f1b38baeUL;
   tf->codes[2009] = 0x0000dbf766d19738UL;
   tf->codes[2010] = 0x0000dbf8c62bb9d6UL;
   tf->codes[2011] = 0x0000dbfa2585dc74UL;
   tf->codes[2012] = 0x0000dbfa6014e239UL;
   tf->codes[2013] = 0x0000dbfa9aa3e7feUL;
   tf->codes[2014] = 0x0000dbfb4a50f94dUL;
   tf->codes[2015] = 0x0000dc008d2a7e00UL;
   tf->codes[2016] = 0x0000dc010248898aUL;
   tf->codes[2017] = 0x0000dc022713a663UL;
   tf->codes[2018] = 0x0000dc029c31b1edUL;
   tf->codes[2019] = 0x0000dc03c0fccec6UL;
   tf->codes[2020] = 0x0000dc052056f164UL;
   tf->codes[2021] = 0x0000dc055ae5f729UL;
   tf->codes[2022] = 0x0000dc05d00402b3UL;
   tf->codes[2023] = 0x0000dc0645220e3dUL;
   tf->codes[2024] = 0x0000dc067fb11402UL;
   tf->codes[2025] = 0x0000dc06ba4019c7UL;
   tf->codes[2026] = 0x0000dc072f5e2551UL;
   tf->codes[2027] = 0x0000dc0769ed2b16UL;
   tf->codes[2028] = 0x0000dc07a47c30dbUL;
   tf->codes[2029] = 0x0000dc085429422aUL;
   tf->codes[2030] = 0x0000dc088eb847efUL;
   tf->codes[2031] = 0x0000dc0903d65379UL;
   tf->codes[2032] = 0x0000dc093e65593eUL;
   tf->codes[2033] = 0x0000dc0a28a17052UL;
   tf->codes[2034] = 0x0000dc0ad84e81a1UL;
   tf->codes[2035] = 0x0000dc0b87fb92f0UL;
   tf->codes[2036] = 0x0000dc0bc28a98b5UL;
   tf->codes[2037] = 0x0000dc0d5c73c118UL;
   tf->codes[2038] = 0x0000dc0e0c20d267UL;
   tf->codes[2039] = 0x0000dc0f30ebef40UL;
   tf->codes[2040] = 0x0000dc0fe099008fUL;
   tf->codes[2041] = 0x0000dc10904611deUL;
   tf->codes[2042] = 0x0000dc117a8228f2UL;
   tf->codes[2043] = 0x0000dc129f4d45cbUL;
   tf->codes[2044] = 0x0000dc13146b5155UL;
   tf->codes[2045] = 0x0000dc134efa571aUL;
   tf->codes[2046] = 0x0000dc1439366e2eUL;
   tf->codes[2047] = 0x0000dc155e018b07UL;
   tf->codes[2048] = 0x0000dc15989090ccUL;
   tf->codes[2049] = 0x0000dc16f7eab36aUL;
   tf->codes[2050] = 0x0000dc173279b92fUL;
   tf->codes[2051] = 0x0000dc176d08bef4UL;
   tf->codes[2052] = 0x0000dc185744d608UL;
   tf->codes[2053] = 0x0000dc194180ed1cUL;
   tf->codes[2054] = 0x0000dc1b8b1726ceUL;
   tf->codes[2055] = 0x0000dc1c00353258UL;
   tf->codes[2056] = 0x0000dc1cea71496cUL;
   tf->codes[2057] = 0x0000dc1f3407831eUL;
   tf->codes[2058] = 0x0000dc1fa9258ea8UL;
   tf->codes[2059] = 0x0000dc20cdf0ab81UL;
   tf->codes[2060] = 0x0000dc21b82cc295UL;
   tf->codes[2061] = 0x0000dc222d4ace1fUL;
   tf->codes[2062] = 0x0000dc231786e533UL;
   tf->codes[2063] = 0x0000dc23c733f682UL;
   tf->codes[2064] = 0x0000dc2476e107d1UL;
   tf->codes[2065] = 0x0000dc25268e1920UL;
   tf->codes[2066] = 0x0000dc25611d1ee5UL;
   tf->codes[2067] = 0x0000dc26c0774183UL;
   tf->codes[2068] = 0x0000dc27aab35897UL;
   tf->codes[2069] = 0x0000dc29449c80faUL;
   tf->codes[2070] = 0x0000dc2a69679dd3UL;
   tf->codes[2071] = 0x0000dc2aa3f6a398UL;
   tf->codes[2072] = 0x0000dc2b53a3b4e7UL;
   tf->codes[2073] = 0x0000dc2bc8c1c071UL;
   tf->codes[2074] = 0x0000dc2e4ce6ffe8UL;
   tf->codes[2075] = 0x0000dc2fac412286UL;
   tf->codes[2076] = 0x0000dc305bee33d5UL;
   tf->codes[2077] = 0x0000dc30967d399aUL;
   tf->codes[2078] = 0x0000dc310b9b4524UL;
   tf->codes[2079] = 0x0000dc31bb485673UL;
   tf->codes[2080] = 0x0000dc32e013734cUL;
   tf->codes[2081] = 0x0000dc3479fc9bafUL;
   tf->codes[2082] = 0x0000dc34b48ba174UL;
   tf->codes[2083] = 0x0000dc37733fe6b0UL;
   tf->codes[2084] = 0x0000dc390d290f13UL;
   tf->codes[2085] = 0x0000dc40247ac1eeUL;
   tf->codes[2086] = 0x0000dc405f09c7b3UL;
   tf->codes[2087] = 0x0000dc414945dec7UL;
   tf->codes[2088] = 0x0000dc41be63ea51UL;
   tf->codes[2089] = 0x0000dc426e10fba0UL;
   tf->codes[2090] = 0x0000dc42a8a00165UL;
   tf->codes[2091] = 0x0000dc431dbe0cefUL;
   tf->codes[2092] = 0x0000dc43584d12b4UL;
   tf->codes[2093] = 0x0000dc44f2363b17UL;
   tf->codes[2094] = 0x0000dc45675446a1UL;
   tf->codes[2095] = 0x0000dc45a1e34c66UL;
   tf->codes[2096] = 0x0000dc45dc72522bUL;
   tf->codes[2097] = 0x0000dc4826088bddUL;
   tf->codes[2098] = 0x0000dc48609791a2UL;
   tf->codes[2099] = 0x0000dc4ae4bcd119UL;
   tf->codes[2100] = 0x0000dc4cb934ff41UL;
   tf->codes[2101] = 0x0000dc4cf3c40506UL;
   tf->codes[2102] = 0x0000dc4dde001c1aUL;
   tf->codes[2103] = 0x0000dc4e188f21dfUL;
   tf->codes[2104] = 0x0000dc4f3d5a3eb8UL;
   tf->codes[2105] = 0x0000dc4fb2784a42UL;
   tf->codes[2106] = 0x0000dc5062255b91UL;
   tf->codes[2107] = 0x0000dc509cb46156UL;
   tf->codes[2108] = 0x0000dc51fc0e83f4UL;
   tf->codes[2109] = 0x0000dc535b68a692UL;
   tf->codes[2110] = 0x0000dc53d086b21cUL;
   tf->codes[2111] = 0x0000dc540b15b7e1UL;
   tf->codes[2112] = 0x0000dc54bac2c930UL;
   tf->codes[2113] = 0x0000dc552fe0d4baUL;
   tf->codes[2114] = 0x0000dc556a6fda7fUL;
   tf->codes[2115] = 0x0000dc5654abf193UL;
   tf->codes[2116] = 0x0000dc57045902e2UL;
   tf->codes[2117] = 0x0000dc57b4061431UL;
   tf->codes[2118] = 0x0000dc59c30d481eUL;
   tf->codes[2119] = 0x0000dc59fd9c4de3UL;
   tf->codes[2120] = 0x0000dc5a72ba596dUL;
   tf->codes[2121] = 0x0000dc5b22676abcUL;
   tf->codes[2122] = 0x0000dc5c0ca381d0UL;
   tf->codes[2123] = 0x0000dc5e90c8c147UL;
   tf->codes[2124] = 0x0000dc5f4075d296UL;
   tf->codes[2125] = 0x0000dc5ff022e3e5UL;
   tf->codes[2126] = 0x0000dc61c49b120dUL;
   tf->codes[2127] = 0x0000dc6399134035UL;
   tf->codes[2128] = 0x0000dc6532fc6898UL;
   tf->codes[2129] = 0x0000dc65a81a7422UL;
   tf->codes[2130] = 0x0000dc66cce590fbUL;
   tf->codes[2131] = 0x0000dc68a15dbf23UL;
   tf->codes[2132] = 0x0000dc69510ad072UL;
   tf->codes[2133] = 0x0000dc6a3b46e786UL;
   tf->codes[2134] = 0x0000dc6b6012045fUL;
   tf->codes[2135] = 0x0000dc6c4a4e1b73UL;
   tf->codes[2136] = 0x0000dc6e59554f60UL;
   tf->codes[2137] = 0x0000dc6f43916674UL;
   tf->codes[2138] = 0x0000dc6ff33e77c3UL;
   tf->codes[2139] = 0x0000dc72ec81c2c4UL;
   tf->codes[2140] = 0x0000dc74866aeb27UL;
   tf->codes[2141] = 0x0000dc75ab360800UL;
   tf->codes[2142] = 0x0000dc76d00124d9UL;
   tf->codes[2143] = 0x0000dc7b289e9278UL;
   tf->codes[2144] = 0x0000dc7cfd16c0a0UL;
   tf->codes[2145] = 0x0000dc7e5c70e33eUL;
   tf->codes[2146] = 0x0000dc7ed18eeec8UL;
   tf->codes[2147] = 0x0000dc811b25287aUL;
   tf->codes[2148] = 0x0000dc81cad239c9UL;
   tf->codes[2149] = 0x0000dc827a7f4b18UL;
   tf->codes[2150] = 0x0000dc86236fa768UL;
   tf->codes[2151] = 0x0000dc886d05e11aUL;
   tf->codes[2152] = 0x0000dc891cb2f269UL;
   tf->codes[2153] = 0x0000dc8a417e0f42UL;
   tf->codes[2154] = 0x0000dc8ab69c1accUL;
   tf->codes[2155] = 0x0000dc8bdb6737a5UL;
   tf->codes[2156] = 0x0000dc8e9a1b7ce1UL;
   tf->codes[2157] = 0x0000dc8f49c88e30UL;
   tf->codes[2158] = 0x0000dc903404a544UL;
   tf->codes[2159] = 0x0000dc90a922b0ceUL;
   tf->codes[2160] = 0x0000dc911e40bc58UL;
   tf->codes[2161] = 0x0000dc9417840759UL;
   tf->codes[2162] = 0x0000dc9452130d1eUL;
   tf->codes[2163] = 0x0000dc9501c01e6dUL;
   tf->codes[2164] = 0x0000dc953c4f2432UL;
   tf->codes[2165] = 0x0000dc95ebfc3581UL;
   tf->codes[2166] = 0x0000dc96268b3b46UL;
   tf->codes[2167] = 0x0000dc96d6384c95UL;
   tf->codes[2168] = 0x0000dc9835926f33UL;
   tf->codes[2169] = 0x0000dc98e53f8082UL;
   tf->codes[2170] = 0x0000dc991fce8647UL;
   tf->codes[2171] = 0x0000dc995a5d8c0cUL;
   tf->codes[2172] = 0x0000dc9af446b46fUL;
   tf->codes[2173] = 0x0000dc9b2ed5ba34UL;
   tf->codes[2174] = 0x0000dc9c8e2fdcd2UL;
   tf->codes[2175] = 0x0000dc9e62a80afaUL;
   tf->codes[2176] = 0x0000dc9f4ce4220eUL;
   tf->codes[2177] = 0x0000dca0e6cd4a71UL;
   tf->codes[2178] = 0x0000dca1967a5bc0UL;
   tf->codes[2179] = 0x0000dca1d1096185UL;
   tf->codes[2180] = 0x0000dca2f5d47e5eUL;
   tf->codes[2181] = 0x0000dca330638423UL;
   tf->codes[2182] = 0x0000dca3e0109572UL;
   tf->codes[2183] = 0x0000dca4552ea0fcUL;
   tf->codes[2184] = 0x0000dca579f9bdd5UL;
   tf->codes[2185] = 0x0000dca66435d4e9UL;
   tf->codes[2186] = 0x0000dca7fe1efd4cUL;
   tf->codes[2187] = 0x0000dca8733d08d6UL;
   tf->codes[2188] = 0x0000dca95d791feaUL;
   tf->codes[2189] = 0x0000dcaa0d263139UL;
   tf->codes[2190] = 0x0000dcaa47b536feUL;
   tf->codes[2191] = 0x0000dcab6c8053d7UL;
   tf->codes[2192] = 0x0000dcaba70f599cUL;
   tf->codes[2193] = 0x0000dcac914b70b0UL;
   tf->codes[2194] = 0x0000dcb19995ef9eUL;
   tf->codes[2195] = 0x0000dcb20eb3fb28UL;
   tf->codes[2196] = 0x0000dcb2f8f0123cUL;
   tf->codes[2197] = 0x0000dcb3a89d238bUL;
   tf->codes[2198] = 0x0000dcb3e32c2950UL;
   tf->codes[2199] = 0x0000dcb6675168c7UL;
   tf->codes[2200] = 0x0000dcb716fe7a16UL;
   tf->codes[2201] = 0x0000dcb7c6ab8b65UL;
   tf->codes[2202] = 0x0000dcb8013a912aUL;
   tf->codes[2203] = 0x0000dcb8b0e7a279UL;
   tf->codes[2204] = 0x0000dcb8eb76a83eUL;
   tf->codes[2205] = 0x0000dcb96094b3c8UL;
   tf->codes[2206] = 0x0000dcbb350ce1f0UL;
   tf->codes[2207] = 0x0000dcbd7ea31ba2UL;
   tf->codes[2208] = 0x0000dcbdf3c1272cUL;
   tf->codes[2209] = 0x0000dcbe68df32b6UL;
   tf->codes[2210] = 0x0000dcc1279377f2UL;
   tf->codes[2211] = 0x0000dcc162227db7UL;
   tf->codes[2212] = 0x0000dcc2c17ca055UL;
   tf->codes[2213] = 0x0000dcc420d6c2f3UL;
   tf->codes[2214] = 0x0000dcc495f4ce7dUL;
   tf->codes[2215] = 0x0000dcc4d083d442UL;
   tf->codes[2216] = 0x0000dcc5f54ef11bUL;
   tf->codes[2217] = 0x0000dcc83ee52acdUL;
   tf->codes[2218] = 0x0000dcc8b4033657UL;
   tf->codes[2219] = 0x0000dcca4dec5ebaUL;
   tf->codes[2220] = 0x0000dcca887b647fUL;
   tf->codes[2221] = 0x0000dccbad468158UL;
   tf->codes[2222] = 0x0000dccc9782986cUL;
   tf->codes[2223] = 0x0000dcccd2119e31UL;
   tf->codes[2224] = 0x0000dcce316bc0cfUL;
   tf->codes[2225] = 0x0000dccee118d21eUL;
   tf->codes[2226] = 0x0000dcd04072f4bcUL;
   tf->codes[2227] = 0x0000dcd24f7a28a9UL;
   tf->codes[2228] = 0x0000dcd2ff2739f8UL;
   tf->codes[2229] = 0x0000dcd339b63fbdUL;
   tf->codes[2230] = 0x0000dcd3e963510cUL;
   tf->codes[2231] = 0x0000dcd49910625bUL;
   tf->codes[2232] = 0x0000dcd4d39f6820UL;
   tf->codes[2233] = 0x0000dcd5f86a84f9UL;
   tf->codes[2234] = 0x0000dcd6e2a69c0dUL;
   tf->codes[2235] = 0x0000dcd7cce2b321UL;
   tf->codes[2236] = 0x0000dcd8b71eca35UL;
   tf->codes[2237] = 0x0000dcd8f1adcffaUL;
   tf->codes[2238] = 0x0000dcd92c3cd5bfUL;
   tf->codes[2239] = 0x0000dcdac625fe22UL;
   tf->codes[2240] = 0x0000dcddbf694923UL;
   tf->codes[2241] = 0x0000dcdee43465fcUL;
   tf->codes[2242] = 0x0000dce0b8ac9424UL;
   tf->codes[2243] = 0x0000dce12dca9faeUL;
   tf->codes[2244] = 0x0000dce3b1efdf25UL;
   tf->codes[2245] = 0x0000dce3ec7ee4eaUL;
   tf->codes[2246] = 0x0000dce4619cf074UL;
   tf->codes[2247] = 0x0000dce54bd90788UL;
   tf->codes[2248] = 0x0000dce586680d4dUL;
   tf->codes[2249] = 0x0000dce75ae03b75UL;
   tf->codes[2250] = 0x0000dce92f58699dUL;
   tf->codes[2251] = 0x0000dcea199480b1UL;
   tf->codes[2252] = 0x0000dceac9419200UL;
   tf->codes[2253] = 0x0000dceb78eea34fUL;
   tf->codes[2254] = 0x0000dcefd18c10eeUL;
   tf->codes[2255] = 0x0000dcf00c1b16b3UL;
   tf->codes[2256] = 0x0000dcf08139223dUL;
   tf->codes[2257] = 0x0000dcf0bbc82802UL;
   tf->codes[2258] = 0x0000dcf21b224aa0UL;
   tf->codes[2259] = 0x0000dcf33fed6779UL;
   tf->codes[2260] = 0x0000dcf42a297e8dUL;
   tf->codes[2261] = 0x0000dcf464b88452UL;
   tf->codes[2262] = 0x0000dcf49f478a17UL;
   tf->codes[2263] = 0x0000dcf58983a12bUL;
   tf->codes[2264] = 0x0000dcf5c412a6f0UL;
   tf->codes[2265] = 0x0000dcf7988ad518UL;
   tf->codes[2266] = 0x0000dcf80da8e0a2UL;
   tf->codes[2267] = 0x0000dcf882c6ec2cUL;
   tf->codes[2268] = 0x0000dcf8f7e4f7b6UL;
   tf->codes[2269] = 0x0000dcfbf12842b7UL;
   tf->codes[2270] = 0x0000dcfc2bb7487cUL;
   tf->codes[2271] = 0x0000dcfca0d55406UL;
   tf->codes[2272] = 0x0000dd008454b61bUL;
   tf->codes[2273] = 0x0000dd021e3dde7eUL;
   tf->codes[2274] = 0x0000dd034308fb57UL;
   tf->codes[2275] = 0x0000dd03f2b60ca6UL;
   tf->codes[2276] = 0x0000dd084b537a45UL;
   tf->codes[2277] = 0x0000dd0885e2800aUL;
   tf->codes[2278] = 0x0000dd09358f9159UL;
   tf->codes[2279] = 0x0000dd0ca3f0e7e4UL;
   tf->codes[2280] = 0x0000dd0e034b0a82UL;
   tf->codes[2281] = 0x0000dd104ce14434UL;
   tf->codes[2282] = 0x0000dd10c1ff4fbeUL;
   tf->codes[2283] = 0x0000dd125be87821UL;
   tf->codes[2284] = 0x0000dd143060a649UL;
   tf->codes[2285] = 0x0000dd15ca49ceacUL;
   tf->codes[2286] = 0x0000dd17d9510299UL;
   tf->codes[2287] = 0x0000dd184e6f0e23UL;
   tf->codes[2288] = 0x0000dd19adc930c1UL;
   tf->codes[2289] = 0x0000dd19e8583686UL;
   tf->codes[2290] = 0x0000dd1a22e73c4bUL;
   tf->codes[2291] = 0x0000dd1a980547d5UL;
   tf->codes[2292] = 0x0000dd1c31ee7038UL;
   tf->codes[2293] = 0x0000dd1ca70c7bc2UL;
   tf->codes[2294] = 0x0000dd1d1c2a874cUL;
   tf->codes[2295] = 0x0000dd1e40f5a425UL;
   tf->codes[2296] = 0x0000dd213a38ef26UL;
   tf->codes[2297] = 0x0000dd2174c7f4ebUL;
   tf->codes[2298] = 0x0000dd251db8513bUL;
   tf->codes[2299] = 0x0000dd26b7a1799eUL;
   tf->codes[2300] = 0x0000dd272cbf8528UL;
   tf->codes[2301] = 0x0000dd27dc6c9677UL;
   tf->codes[2302] = 0x0000dd28518aa201UL;
   tf->codes[2303] = 0x0000dd2ad5afe178UL;
   tf->codes[2304] = 0x0000dd2c350a0416UL;
   tf->codes[2305] = 0x0000dd2e0982323eUL;
   tf->codes[2306] = 0x0000dd301889662bUL;
   tf->codes[2307] = 0x0000dd30c836777aUL;
   tf->codes[2308] = 0x0000dd32621f9fddUL;
   tf->codes[2309] = 0x0000dd329caea5a2UL;
   tf->codes[2310] = 0x0000dd33c179c27bUL;
   tf->codes[2311] = 0x0000dd36459f01f2UL;
   tf->codes[2312] = 0x0000dd388f353ba4UL;
   tf->codes[2313] = 0x0000dd39ee8f5e42UL;
   tf->codes[2314] = 0x0000dd3a63ad69ccUL;
   tf->codes[2315] = 0x0000dd3bfd96922fUL;
   tf->codes[2316] = 0x0000dd3ce7d2a943UL;
   tf->codes[2317] = 0x0000dd3dd20ec057UL;
   tf->codes[2318] = 0x0000dd3e0c9dc61cUL;
   tf->codes[2319] = 0x0000dd3e472ccbe1UL;
   tf->codes[2320] = 0x0000dd41b58e226cUL;
   tf->codes[2321] = 0x0000dd41f01d2831UL;
   tf->codes[2322] = 0x0000dd42653b33bbUL;
   tf->codes[2323] = 0x0000dd438a065094UL;
   tf->codes[2324] = 0x0000dd4439b361e3UL;
   tf->codes[2325] = 0x0000dd460e2b900bUL;
   tf->codes[2326] = 0x0000dd47e2a3be33UL;
   tf->codes[2327] = 0x0000dd49076edb0cUL;
   tf->codes[2328] = 0x0000dd4b8b941a83UL;
   tf->codes[2329] = 0x0000dd4bc6232048UL;
   tf->codes[2330] = 0x0000dd4ceaee3d21UL;
   tf->codes[2331] = 0x0000dd4dd52a5435UL;
   tf->codes[2332] = 0x0000dd5108fca4fbUL;
   tf->codes[2333] = 0x0000dd51438baac0UL;
   tf->codes[2334] = 0x0000dd535292deadUL;
   tf->codes[2335] = 0x0000dd54023feffcUL;
   tf->codes[2336] = 0x0000dd543ccef5c1UL;
   tf->codes[2337] = 0x0000dd559c29185fUL;
   tf->codes[2338] = 0x0000dd55d6b81e24UL;
   tf->codes[2339] = 0x0000dd5770a14687UL;
   tf->codes[2340] = 0x0000dd59451974afUL;
   tf->codes[2341] = 0x0000dd5a69e49188UL;
   tf->codes[2342] = 0x0000dd5aa473974dUL;
   tf->codes[2343] = 0x0000dd5b5420a89cUL;
   tf->codes[2344] = 0x0000dd5bc93eb426UL;
   tf->codes[2345] = 0x0000dd610c1838d9UL;
   tf->codes[2346] = 0x0000dd6181364463UL;
   tf->codes[2347] = 0x0000dd6230e355b2UL;
   tf->codes[2348] = 0x0000dd62e0906701UL;
   tf->codes[2349] = 0x0000dd63cacc7e15UL;
   tf->codes[2350] = 0x0000dd652a26a0b3UL;
   tf->codes[2351] = 0x0000dd65d9d3b202UL;
   tf->codes[2352] = 0x0000dd66c40fc916UL;
   tf->codes[2353] = 0x0000dd6773bcda65UL;
   tf->codes[2354] = 0x0000dd690da602c8UL;
   tf->codes[2355] = 0x0000dd694835088dUL;
   tf->codes[2356] = 0x0000dd6aa78f2b2bUL;
   tf->codes[2357] = 0x0000dd6ae21e30f0UL;
   tf->codes[2358] = 0x0000dd6f002c98caUL;
   tf->codes[2359] = 0x0000dd709a15c12dUL;
   tf->codes[2360] = 0x0000dd7149c2d27cUL;
   tf->codes[2361] = 0x0000dd731e3b00a4UL;
   tf->codes[2362] = 0x0000dd7393590c2eUL;
   tf->codes[2363] = 0x0000dd747d952342UL;
   tf->codes[2364] = 0x0000dd74f2b32eccUL;
   tf->codes[2365] = 0x0000dd75a260401bUL;
   tf->codes[2366] = 0x0000dd7701ba62b9UL;
   tf->codes[2367] = 0x0000dd77ebf679cdUL;
   tf->codes[2368] = 0x0000dd794b509c6bUL;
   tf->codes[2369] = 0x0000dd7ae539c4ceUL;
   tf->codes[2370] = 0x0000dd7ec8b926e3UL;
   tf->codes[2371] = 0x0000dd7fb2f53df7UL;
   tf->codes[2372] = 0x0000dd8062a24f46UL;
   tf->codes[2373] = 0x0000dd8271a98333UL;
   tf->codes[2374] = 0x0000dd839674a00cUL;
   tf->codes[2375] = 0x0000dd865528e548UL;
   tf->codes[2376] = 0x0000dd8779f40221UL;
   tf->codes[2377] = 0x0000dd88d94e24bfUL;
   tf->codes[2378] = 0x0000dd89fe194198UL;
   tf->codes[2379] = 0x0000dd8b5d736436UL;
   tf->codes[2380] = 0x0000dd8b980269fbUL;
   tf->codes[2381] = 0x0000dd8e56b6af37UL;
   tf->codes[2382] = 0x0000dd9065bde324UL;
   tf->codes[2383] = 0x0000dd91156af473UL;
   tf->codes[2384] = 0x0000dd918a88fffdUL;
   tf->codes[2385] = 0x0000dd923a36114cUL;
   tf->codes[2386] = 0x0000dd9324722860UL;
   tf->codes[2387] = 0x0000dd93999033eaUL;
   tf->codes[2388] = 0x0000dd94493d4539UL;
   tf->codes[2389] = 0x0000dd94f8ea5688UL;
   tf->codes[2390] = 0x0000dd9658447926UL;
   tf->codes[2391] = 0x0000dd96cd6284b0UL;
   tf->codes[2392] = 0x0000dd977d0f95ffUL;
   tf->codes[2393] = 0x0000dd97f22da189UL;
   tf->codes[2394] = 0x0000dd9a0134d576UL;
   tf->codes[2395] = 0x0000dd9b608ef814UL;
   tf->codes[2396] = 0x0000dd9c103c0963UL;
   tf->codes[2397] = 0x0000dd9cfa782077UL;
   tf->codes[2398] = 0x0000dd9f440e5a29UL;
   tf->codes[2399] = 0x0000dd9ff3bb6b78UL;
   tf->codes[2400] = 0x0000dda118868851UL;
   tf->codes[2401] = 0x0000dda23d51a52aUL;
   tf->codes[2402] = 0x0000dda39cabc7c8UL;
   tf->codes[2403] = 0x0000dda4fc05ea66UL;
   tf->codes[2404] = 0x0000dda57123f5f0UL;
   tf->codes[2405] = 0x0000dda6d07e188eUL;
   tf->codes[2406] = 0x0000dda86a6740f1UL;
   tf->codes[2407] = 0x0000dda91a145240UL;
   tf->codes[2408] = 0x0000ddab291b862dUL;
   tf->codes[2409] = 0x0000ddab9e3991b7UL;
   tf->codes[2410] = 0x0000ddac8875a8cbUL;
   tf->codes[2411] = 0x0000ddacc304ae90UL;
   tf->codes[2412] = 0x0000ddacfd93b455UL;
   tf->codes[2413] = 0x0000ddaf81b8f3ccUL;
   tf->codes[2414] = 0x0000ddb03166051bUL;
   tf->codes[2415] = 0x0000ddb190c027b9UL;
   tf->codes[2416] = 0x0000ddb32aa9501cUL;
   tf->codes[2417] = 0x0000ddb48a0372baUL;
   tf->codes[2418] = 0x0000ddb4c492787fUL;
   tf->codes[2419] = 0x0000ddb70e28b231UL;
   tf->codes[2420] = 0x0000ddb7f864c945UL;
   tf->codes[2421] = 0x0000ddb86d82d4cfUL;
   tf->codes[2422] = 0x0000ddb9924df1a8UL;
   tf->codes[2423] = 0x0000ddbab7190e81UL;
   tf->codes[2424] = 0x0000ddbcc620426eUL;
   tf->codes[2425] = 0x0000ddbe257a650cUL;
   tf->codes[2426] = 0x0000ddbed527765bUL;
   tf->codes[2427] = 0x0000ddbf0fb67c20UL;
   tf->codes[2428] = 0x0000ddc06f109ebeUL;
   tf->codes[2429] = 0x0000ddc208f9c721UL;
   tf->codes[2430] = 0x0000ddc4529000d3UL;
   tf->codes[2431] = 0x0000ddc48d1f0698UL;
   tf->codes[2432] = 0x0000ddc5ec792936UL;
   tf->codes[2433] = 0x0000ddc7c0f1575eUL;
   tf->codes[2434] = 0x0000ddc8ab2d6e72UL;
   tf->codes[2435] = 0x0000ddc9cff88b4bUL;
   tf->codes[2436] = 0x0000ddcaba34a25fUL;
   tf->codes[2437] = 0x0000ddcaf4c3a824UL;
   tf->codes[2438] = 0x0000ddcdee06f325UL;
   tf->codes[2439] = 0x0000ddcf4d6115c3UL;
   tf->codes[2440] = 0x0000ddcffd0e2712UL;
   tf->codes[2441] = 0x0000ddd0722c329cUL;
   tf->codes[2442] = 0x0000ddd0e74a3e26UL;
   tf->codes[2443] = 0x0000ddd1d186553aUL;
   tf->codes[2444] = 0x0000ddd246a460c4UL;
   tf->codes[2445] = 0x0000ddd3e08d8927UL;
   tf->codes[2446] = 0x0000ddd4903a9a76UL;
   tf->codes[2447] = 0x0000ddd57a76b18aUL;
   tf->codes[2448] = 0x0000ddd62a23c2d9UL;
   tf->codes[2449] = 0x0000ddd8ae490250UL;
   tf->codes[2450] = 0x0000ddd95df6139fUL;
   tf->codes[2451] = 0x0000ddd998851964UL;
   tf->codes[2452] = 0x0000dddd06e66fefUL;
   tf->codes[2453] = 0x0000ddde6640928dUL;
   tf->codes[2454] = 0x0000dde00029baf0UL;
   tf->codes[2455] = 0x0000dde124f4d7c9UL;
   tf->codes[2456] = 0x0000dde20f30eeddUL;
   tf->codes[2457] = 0x0000dde41e3822caUL;
   tf->codes[2458] = 0x0000dde458c7288fUL;
   tf->codes[2459] = 0x0000dde57d924568UL;
   tf->codes[2460] = 0x0000dde5b8214b2dUL;
   tf->codes[2461] = 0x0000dde6a25d6241UL;
   tf->codes[2462] = 0x0000dde7520a7390UL;
   tf->codes[2463] = 0x0000dde801b784dfUL;
   tf->codes[2464] = 0x0000dde92682a1b8UL;
   tf->codes[2465] = 0x0000ddeb7018db6aUL;
   tf->codes[2466] = 0x0000ddedf43e1ae1UL;
   tf->codes[2467] = 0x0000ddee695c266bUL;
   tf->codes[2468] = 0x0000ddeea3eb2c30UL;
   tf->codes[2469] = 0x0000ddef190937baUL;
   tf->codes[2470] = 0x0000ddf2124c82bbUL;
   tf->codes[2471] = 0x0000ddf3ac35ab1eUL;
   tf->codes[2472] = 0x0000ddf3e6c4b0e3UL;
   tf->codes[2473] = 0x0000ddf42153b6a8UL;
   tf->codes[2474] = 0x0000ddf45be2bc6dUL;
   tf->codes[2475] = 0x0000ddf4d100c7f7UL;
   tf->codes[2476] = 0x0000ddf879f12447UL;
   tf->codes[2477] = 0x0000ddfafe1663beUL;
   tf->codes[2478] = 0x0000ddff56b3d15dUL;
   tf->codes[2479] = 0x0000ddff9142d722UL;
   tf->codes[2480] = 0x0000de000660e2acUL;
   tf->codes[2481] = 0x0000de0040efe871UL;
   tf->codes[2482] = 0x0000de028a862223UL;
   tf->codes[2483] = 0x0000de03e9e044c1UL;
   tf->codes[2484] = 0x0000de04246f4a86UL;
   tf->codes[2485] = 0x0000de05493a675fUL;
   tf->codes[2486] = 0x0000de05be5872e9UL;
   tf->codes[2487] = 0x0000de066e058438UL;
   tf->codes[2488] = 0x0000de06e3238fc2UL;
   tf->codes[2489] = 0x0000de096748cf39UL;
   tf->codes[2490] = 0x0000de09dc66dac3UL;
   tf->codes[2491] = 0x0000de0b0131f79cUL;
   tf->codes[2492] = 0x0000de0b76500326UL;
   tf->codes[2493] = 0x0000de0beb6e0eb0UL;
   tf->codes[2494] = 0x0000de0cd5aa25c4UL;
   tf->codes[2495] = 0x0000de0e6f934e27UL;
   tf->codes[2496] = 0x0000de0f1f405f76UL;
   tf->codes[2497] = 0x0000de0f59cf653bUL;
   tf->codes[2498] = 0x0000de0f945e6b00UL;
   tf->codes[2499] = 0x0000de107e9a8214UL;
   tf->codes[2500] = 0x0000de154c55fb3dUL;
   tf->codes[2501] = 0x0000de15fc030c8cUL;
   tf->codes[2502] = 0x0000de16abb01ddbUL;
   tf->codes[2503] = 0x0000de16e63f23a0UL;
   tf->codes[2504] = 0x0000de19a4f368dcUL;
   tf->codes[2505] = 0x0000de1b796b9704UL;
   tf->codes[2506] = 0x0000de1bb3fa9cc9UL;
   tf->codes[2507] = 0x0000de1c2918a853UL;
   tf->codes[2508] = 0x0000de1e72aee205UL;
   tf->codes[2509] = 0x0000de216bf22d06UL;
   tf->codes[2510] = 0x0000de21a68132cbUL;
   tf->codes[2511] = 0x0000de21e1103890UL;
   tf->codes[2512] = 0x0000de22562e441aUL;
   tf->codes[2513] = 0x0000de23b58866b8UL;
   tf->codes[2514] = 0x0000de24da538391UL;
   tf->codes[2515] = 0x0000de25ff1ea06aUL;
   tf->codes[2516] = 0x0000de2723e9bd43UL;
   tf->codes[2517] = 0x0000de279907c8cdUL;
   tf->codes[2518] = 0x0000de2848b4da1cUL;
   tf->codes[2519] = 0x0000de28f861eb6bUL;
   tf->codes[2520] = 0x0000de2932f0f130UL;
   tf->codes[2521] = 0x0000de2a1d2d0844UL;
   tf->codes[2522] = 0x0000de2bf1a5366cUL;
   tf->codes[2523] = 0x0000de2c2c343c31UL;
   tf->codes[2524] = 0x0000de30f9efb55aUL;
   tf->codes[2525] = 0x0000de31347ebb1fUL;
   tf->codes[2526] = 0x0000de342dc20620UL;
   tf->codes[2527] = 0x0000de358d1c28beUL;
   tf->codes[2528] = 0x0000de36ec764b5cUL;
   tf->codes[2529] = 0x0000de3811416835UL;
   tf->codes[2530] = 0x0000de39ab2a9098UL;
   tf->codes[2531] = 0x0000de3bf4c0ca4aUL;
   tf->codes[2532] = 0x0000de3eee04154bUL;
   tf->codes[2533] = 0x0000de404d5e37e9UL;
   tf->codes[2534] = 0x0000de40fd0b4938UL;
   tf->codes[2535] = 0x0000de41722954c2UL;
   tf->codes[2536] = 0x0000de43813088afUL;
   tf->codes[2537] = 0x0000de4555a8b6d7UL;
   tf->codes[2538] = 0x0000de49392818ecUL;
   tf->codes[2539] = 0x0000de4a98823b8aUL;
   tf->codes[2540] = 0x0000de4ad311414fUL;
   tf->codes[2541] = 0x0000de4ce218753cUL;
   tf->codes[2542] = 0x0000de4d1ca77b01UL;
   tf->codes[2543] = 0x0000de4d573680c6UL;
   tf->codes[2544] = 0x0000de4e06e39215UL;
   tf->codes[2545] = 0x0000de4e417297daUL;
   tf->codes[2546] = 0x0000de4e7c019d9fUL;
   tf->codes[2547] = 0x0000de4f2baeaeeeUL;
   tf->codes[2548] = 0x0000de513ab5e2dbUL;
   tf->codes[2549] = 0x0000de551e3544f0UL;
   tf->codes[2550] = 0x0000de559353507aUL;
   tf->codes[2551] = 0x0000de5608715c04UL;
   tf->codes[2552] = 0x0000de56f2ad7318UL;
   tf->codes[2553] = 0x0000de5767cb7ea2UL;
   tf->codes[2554] = 0x0000de5817788ff1UL;
   tf->codes[2555] = 0x0000de5a9b9dcf68UL;
   tf->codes[2556] = 0x0000de5bfaf7f206UL;
   tf->codes[2557] = 0x0000de5ef43b3d07UL;
   tf->codes[2558] = 0x0000de608e24656aUL;
   tf->codes[2559] = 0x0000de61b2ef8243UL;
   tf->codes[2560] = 0x0000de631249a4e1UL;
   tf->codes[2561] = 0x0000de63c1f6b630UL;
   tf->codes[2562] = 0x0000de64e6c1d309UL;
   tf->codes[2563] = 0x0000de652150d8ceUL;
   tf->codes[2564] = 0x0000de6c38a28ba9UL;
   tf->codes[2565] = 0x0000de6d22dea2bdUL;
   tf->codes[2566] = 0x0000de6e8238c55bUL;
   tf->codes[2567] = 0x0000de6f31e5d6aaUL;
   tf->codes[2568] = 0x0000de70913ff948UL;
   tf->codes[2569] = 0x0000de71f09a1be6UL;
   tf->codes[2570] = 0x0000de722b2921abUL;
   tf->codes[2571] = 0x0000de738a834449UL;
   tf->codes[2572] = 0x0000de755efb7271UL;
   tf->codes[2573] = 0x0000de75d4197dfbUL;
   tf->codes[2574] = 0x0000de76f8e49ad4UL;
   tf->codes[2575] = 0x0000de776e02a65eUL;
   tf->codes[2576] = 0x0000de77e320b1e8UL;
   tf->codes[2577] = 0x0000de781dafb7adUL;
   tf->codes[2578] = 0x0000de79427ad486UL;
   tf->codes[2579] = 0x0000de7a2cb6eb9aUL;
   tf->codes[2580] = 0x0000de7adc63fce9UL;
   tf->codes[2581] = 0x0000de7e4ac55374UL;
   tf->codes[2582] = 0x0000de8059cc8761UL;
   tf->codes[2583] = 0x0000de80ceea92ebUL;
   tf->codes[2584] = 0x0000de81f3b5afc4UL;
   tf->codes[2585] = 0x0000de822e44b589UL;
   tf->codes[2586] = 0x0000de8268d3bb4eUL;
   tf->codes[2587] = 0x0000de831880cc9dUL;
   tf->codes[2588] = 0x0000de83c82dddecUL;
   tf->codes[2589] = 0x0000de843d4be976UL;
   tf->codes[2590] = 0x0000de87711e3a3cUL;
   tf->codes[2591] = 0x0000de885b5a5150UL;
   tf->codes[2592] = 0x0000de88d0785cdaUL;
   tf->codes[2593] = 0x0000de8945966864UL;
   tf->codes[2594] = 0x0000de8980256e29UL;
   tf->codes[2595] = 0x0000de8aa4f08b02UL;
   tf->codes[2596] = 0x0000de8b1a0e968cUL;
   tf->codes[2597] = 0x0000de8b8f2ca216UL;
   tf->codes[2598] = 0x0000de8c7968b92aUL;
   tf->codes[2599] = 0x0000de8efd8df8a1UL;
   tf->codes[2600] = 0x0000de9231604967UL;
   tf->codes[2601] = 0x0000de92e10d5ab6UL;
   tf->codes[2602] = 0x0000de9689fdb706UL;
   tf->codes[2603] = 0x0000de98d393f0b8UL;
   tf->codes[2604] = 0x0000de9948b1fc42UL;
   tf->codes[2605] = 0x0000de99bdd007ccUL;
   tf->codes[2606] = 0x0000de9a32ee1356UL;
   tf->codes[2607] = 0x0000de9cf1a25892UL;
   tf->codes[2608] = 0x0000de9e8b8b80f5UL;
   tf->codes[2609] = 0x0000dea06003af1dUL;
   tf->codes[2610] = 0x0000dea10fb0c06cUL;
   tf->codes[2611] = 0x0000dea393d5ffe3UL;
   tf->codes[2612] = 0x0000dea408f40b6dUL;
   tf->codes[2613] = 0x0000dea443831132UL;
   tf->codes[2614] = 0x0000dea47e1216f7UL;
   tf->codes[2615] = 0x0000dea5684e2e0bUL;
   tf->codes[2616] = 0x0000dea86191790cUL;
   tf->codes[2617] = 0x0000dea89c207ed1UL;
   tf->codes[2618] = 0x0000deaa3609a734UL;
   tf->codes[2619] = 0x0000deaa7098acf9UL;
   tf->codes[2620] = 0x0000deacba2ee6abUL;
   tf->codes[2621] = 0x0000deafb37231acUL;
   tf->codes[2622] = 0x0000deb028903d36UL;
   tf->codes[2623] = 0x0000deb112cc544aUL;
   tf->codes[2624] = 0x0000deb14d5b5a0fUL;
   tf->codes[2625] = 0x0000deb1fd086b5eUL;
   tf->codes[2626] = 0x0000deb2e7448272UL;
   tf->codes[2627] = 0x0000deb61b16d338UL;
   tf->codes[2628] = 0x0000deb73fe1f011UL;
   tf->codes[2629] = 0x0000deb77a70f5d6UL;
   tf->codes[2630] = 0x0000deb82a1e0725UL;
   tf->codes[2631] = 0x0000deb9145a1e39UL;
   tf->codes[2632] = 0x0000deb9897829c3UL;
   tf->codes[2633] = 0x0000debb23615226UL;
   tf->codes[2634] = 0x0000debfb68dc58aUL;
   tf->codes[2635] = 0x0000dec115e7e828UL;
   tf->codes[2636] = 0x0000dec275420ac6UL;
   tf->codes[2637] = 0x0000dec61e326716UL;
   tf->codes[2638] = 0x0000dec7f2aa953eUL;
   tf->codes[2639] = 0x0000dec98c93bda1UL;
   tf->codes[2640] = 0x0000decc10b8fd18UL;
   tf->codes[2641] = 0x0000decd358419f1UL;
   tf->codes[2642] = 0x0000decf09fc4819UL;
   tf->codes[2643] = 0x0000ded830552ee1UL;
   tf->codes[2644] = 0x0000dedaef09741dUL;
   tf->codes[2645] = 0x0000dedf47a6e1bcUL;
   tf->codes[2646] = 0x0000dee031e2f8d0UL;
   tf->codes[2647] = 0x0000dee11c1f0fe4UL;
   tf->codes[2648] = 0x0000dee27b793282UL;
   tf->codes[2649] = 0x0000dee32b2643d1UL;
   tf->codes[2650] = 0x0000dee3a0444f5bUL;
   tf->codes[2651] = 0x0000dee3dad35520UL;
   tf->codes[2652] = 0x0000dee6d416a021UL;
   tf->codes[2653] = 0x0000dee70ea5a5e6UL;
   tf->codes[2654] = 0x0000dee83370c2bfUL;
   tf->codes[2655] = 0x0000dee86dffc884UL;
   tf->codes[2656] = 0x0000deeaf22507fbUL;
   tf->codes[2657] = 0x0000deeb67431385UL;
   tf->codes[2658] = 0x0000deebdc611f0fUL;
   tf->codes[2659] = 0x0000deec16f024d4UL;
   tf->codes[2660] = 0x0000deeed5a46a10UL;
   tf->codes[2661] = 0x0000deef85517b5fUL;
   tf->codes[2662] = 0x0000def3a35fe339UL;
   tf->codes[2663] = 0x0000def502ba05d7UL;
   tf->codes[2664] = 0x0000def5b2671726UL;
   tf->codes[2665] = 0x0000def6278522b0UL;
   tf->codes[2666] = 0x0000defba4edad28UL;
   tf->codes[2667] = 0x0000defbdf7cb2edUL;
   tf->codes[2668] = 0x0000defc1a0bb8b2UL;
   tf->codes[2669] = 0x0000df00381a208cUL;
   tf->codes[2670] = 0x0000df0247215479UL;
   tf->codes[2671] = 0x0000df0456288866UL;
   tf->codes[2672] = 0x0000df074f6bd367UL;
   tf->codes[2673] = 0x0000df0a48af1e68UL;
   tf->codes[2674] = 0x0000df0c57b65255UL;
   tf->codes[2675] = 0x0000df119a8fd708UL;
   tf->codes[2676] = 0x0000df1543803358UL;
   tf->codes[2677] = 0x0000df16684b5031UL;
   tf->codes[2678] = 0x0000df178d166d0aUL;
   tf->codes[2679] = 0x0000df1a4bcab246UL;
   tf->codes[2680] = 0x0000df1afb77c395UL;
   tf->codes[2681] = 0x0000df1f19862b6fUL;
   tf->codes[2682] = 0x0000df2078e04e0dUL;
   tf->codes[2683] = 0x0000df23e741a498UL;
   tf->codes[2684] = 0x0000df2421d0aa5dUL;
   tf->codes[2685] = 0x0000df250c0cc171UL;
   tf->codes[2686] = 0x0000df29d9c83a9aUL;
   tf->codes[2687] = 0x0000df2ac40451aeUL;
   tf->codes[2688] = 0x0000df2afe935773UL;
   tf->codes[2689] = 0x0000df2f1ca1bf4dUL;
   tf->codes[2690] = 0x0000df312ba8f33aUL;
   tf->codes[2691] = 0x0000df3250741013UL;
   tf->codes[2692] = 0x0000df3300212162UL;
   tf->codes[2693] = 0x0000df39a254c8b3UL;
   tf->codes[2694] = 0x0000df3a1772d43dUL;
   tf->codes[2695] = 0x0000df3a5201da02UL;
   tf->codes[2696] = 0x0000df3b01aeeb51UL;
   tf->codes[2697] = 0x0000df47d0f82e69UL;
   tf->codes[2698] = 0x0000df4bef069643UL;
   tf->codes[2699] = 0x0000df55c50c8e5aUL;
   tf->codes[2700] = 0x0000df575ef5b6bdUL;
   tf->codes[2701] = 0x0000df57d413c247UL;
   tf->codes[2702] = 0x0000df596dfceaaaUL;
   tf->codes[2703] = 0x0000df5a583901beUL;
   tf->codes[2704] = 0x0000df5cdc5e4135UL;
   tf->codes[2705] = 0x0000df5f608380acUL;
   tf->codes[2706] = 0x0000df5f9b128671UL;
   tf->codes[2707] = 0x0000df60fa6ca90fUL;
   tf->codes[2708] = 0x0000df6134fbaed4UL;
   tf->codes[2709] = 0x0000df621f37c5e8UL;
   tf->codes[2710] = 0x0000df637e91e886UL;
   tf->codes[2711] = 0x0000df64ddec0b24UL;
   tf->codes[2712] = 0x0000df65187b10e9UL;
   tf->codes[2713] = 0x0000df663d462dc2UL;
   tf->codes[2714] = 0x0000df67278244d6UL;
   tf->codes[2715] = 0x0000df6762114a9bUL;
   tf->codes[2716] = 0x0000df6b4590acb0UL;
   tf->codes[2717] = 0x0000df6eb3f2033bUL;
   tf->codes[2718] = 0x0000df70c2f93728UL;
   tf->codes[2719] = 0x0000df7172a64877UL;
   tf->codes[2720] = 0x0000df73bc3c8229UL;
   tf->codes[2721] = 0x0000df77da4aea03UL;
   tf->codes[2722] = 0x0000df7974341266UL;
   tf->codes[2723] = 0x0000df7ad38e3504UL;
   tf->codes[2724] = 0x0000df7bf85951ddUL;
   tf->codes[2725] = 0x0000df7e41ef8b8fUL;
   tf->codes[2726] = 0x0000df7f66baa868UL;
   tf->codes[2727] = 0x0000df82d51bfef3UL;
   tf->codes[2728] = 0x0000df846f052756UL;
   tf->codes[2729] = 0x0000df86f32a66cdUL;
   tf->codes[2730] = 0x0000df8902319abaUL;
   tf->codes[2731] = 0x0000df893cc0a07fUL;
   tf->codes[2732] = 0x0000df8a618bbd58UL;
   tf->codes[2733] = 0x0000df8b4bc7d46cUL;
   tf->codes[2734] = 0x0000df8cab21f70aUL;
   tf->codes[2735] = 0x0000df8f69d63c46UL;
   tf->codes[2736] = 0x0000df90c9305ee4UL;
   tf->codes[2737] = 0x0000df913e4e6a6eUL;
   tf->codes[2738] = 0x0000df955c5cd248UL;
   tf->codes[2739] = 0x0000df98902f230eUL;
   tf->codes[2740] = 0x0000df99054d2e98UL;
   tf->codes[2741] = 0x0000df9a64a75136UL;
   tf->codes[2742] = 0x0000df9b14546285UL;
   tf->codes[2743] = 0x0000df9e4826b34bUL;
   tf->codes[2744] = 0x0000df9f3262ca5fUL;
   tf->codes[2745] = 0x0000dfa524e96061UL;
   tf->codes[2746] = 0x0000dfa90868c276UL;
   tf->codes[2747] = 0x0000dfaadce0f09eUL;
   tf->codes[2748] = 0x0000dfab8c8e01edUL;
   tf->codes[2749] = 0x0000dfacb1591ec6UL;
   tf->codes[2750] = 0x0000dfacebe8248bUL;
   tf->codes[2751] = 0x0000dfad61063015UL;
   tf->codes[2752] = 0x0000dfae10b34164UL;
   tf->codes[2753] = 0x0000dfb01fba7551UL;
   tf->codes[2754] = 0x0000dfb3c8aad1a1UL;
   tf->codes[2755] = 0x0000dfb56293fa04UL;
   tf->codes[2756] = 0x0000dfbcb474b2a4UL;
   tf->codes[2757] = 0x0000dfbec37be691UL;
   tf->codes[2758] = 0x0000dfbf3899f21bUL;
   tf->codes[2759] = 0x0000dfbfe847036aUL;
   tf->codes[2760] = 0x0000dfc0d2831a7eUL;
   tf->codes[2761] = 0x0000dfc10d122043UL;
   tf->codes[2762] = 0x0000dfc2e18a4e6bUL;
   tf->codes[2763] = 0x0000dfc440e47109UL;
   tf->codes[2764] = 0x0000dfcb583623e4UL;
   tf->codes[2765] = 0x0000dfcd673d57d1UL;
   tf->codes[2766] = 0x0000dfcddc5b635bUL;
   tf->codes[2767] = 0x0000dfd40970ff22UL;
   tf->codes[2768] = 0x0000dfd47e8f0aacUL;
   tf->codes[2769] = 0x0000dfd4b91e1071UL;
   tf->codes[2770] = 0x0000dfd568cb21c0UL;
   tf->codes[2771] = 0x0000dfd61878330fUL;
   tf->codes[2772] = 0x0000dfd702b44a23UL;
   tf->codes[2773] = 0x0000dfde8f240888UL;
   tf->codes[2774] = 0x0000dfdec9b30e4dUL;
   tf->codes[2775] = 0x0000dfdf79601f9cUL;
   tf->codes[2776] = 0x0000dfe0d8ba423aUL;
   tf->codes[2777] = 0x0000dfe1c2f6594eUL;
   tf->codes[2778] = 0x0000dfe5e104c128UL;
   tf->codes[2779] = 0x0000dfe82a9afadaUL;
   tf->codes[2780] = 0x0000dfec48a962b4UL;
   tf->codes[2781] = 0x0000dfecbdc76e3eUL;
   tf->codes[2782] = 0x0000dfee57b096a1UL;
   tf->codes[2783] = 0x0000dfeff199bf04UL;
   tf->codes[2784] = 0x0000dff484c63268UL;
   tf->codes[2785] = 0x0000dff61eaf5acbUL;
   tf->codes[2786] = 0x0000dff6593e6090UL;
   tf->codes[2787] = 0x0000dffaec6ad3f4UL;
   tf->codes[2788] = 0x0000dffb26f9d9b9UL;
   tf->codes[2789] = 0x0000e001c92d810aUL;
   tf->codes[2790] = 0x0000e00203bc86cfUL;
   tf->codes[2791] = 0x0000e0023e4b8c94UL;
   tf->codes[2792] = 0x0000e002edf89de3UL;
   tf->codes[2793] = 0x0000e0032887a3a8UL;
   tf->codes[2794] = 0x0000e0039da5af32UL;
   tf->codes[2795] = 0x0000e003d834b4f7UL;
   tf->codes[2796] = 0x0000e00412c3babcUL;
   tf->codes[2797] = 0x0000e00696e8fa33UL;
   tf->codes[2798] = 0x0000e006d177fff8UL;
   tf->codes[2799] = 0x0000e00746960b82UL;
   tf->codes[2800] = 0x0000e007bbb4170cUL;
   tf->codes[2801] = 0x0000e008e07f33e5UL;
   tf->codes[2802] = 0x0000e009559d3f6fUL;
   tf->codes[2803] = 0x0000e00a7a685c48UL;
   tf->codes[2804] = 0x0000e00aef8667d2UL;
   tf->codes[2805] = 0x0000e00b64a4735cUL;
   tf->codes[2806] = 0x0000e00e5de7be5dUL;
   tf->codes[2807] = 0x0000e00e9876c422UL;
   tf->codes[2808] = 0x0000e00f82b2db36UL;
   tf->codes[2809] = 0x0000e0106ceef24aUL;
   tf->codes[2810] = 0x0000e011cc4914e8UL;
   tf->codes[2811] = 0x0000e01241672072UL;
   tf->codes[2812] = 0x0000e0127bf62637UL;
   tf->codes[2813] = 0x0000e012b6852bfcUL;
   tf->codes[2814] = 0x0000e012f11431c1UL;
   tf->codes[2815] = 0x0000e0132ba33786UL;
   tf->codes[2816] = 0x0000e01366323d4bUL;
   tf->codes[2817] = 0x0000e013a0c14310UL;
   tf->codes[2818] = 0x0000e013db5048d5UL;
   tf->codes[2819] = 0x0000e014506e545fUL;
   tf->codes[2820] = 0x0000e015001b65aeUL;
   tf->codes[2821] = 0x0000e0153aaa6b73UL;
   tf->codes[2822] = 0x0000e01624e68287UL;
   tf->codes[2823] = 0x0000e0165f75884cUL;
   tf->codes[2824] = 0x0000e0169a048e11UL;
   tf->codes[2825] = 0x0000e016d49393d6UL;
   tf->codes[2826] = 0x0000e0170f22999bUL;
   tf->codes[2827] = 0x0000e0178440a525UL;
   tf->codes[2828] = 0x0000e017f95eb0afUL;
   tf->codes[2829] = 0x0000e01833edb674UL;
   tf->codes[2830] = 0x0000e0186e7cbc39UL;
   tf->codes[2831] = 0x0000e018a90bc1feUL;
   tf->codes[2832] = 0x0000e01a0865e49cUL;
   tf->codes[2833] = 0x0000e01b2d310175UL;
   tf->codes[2834] = 0x0000e01c176d1889UL;
   tf->codes[2835] = 0x0000e020357b8063UL;
   tf->codes[2836] = 0x0000e020700a8628UL;
   tf->codes[2837] = 0x0000e020aa998bedUL;
   tf->codes[2838] = 0x0000e0211fb79777UL;
   tf->codes[2839] = 0x0000e021cf64a8c6UL;
   tf->codes[2840] = 0x0000e0224482b450UL;
   tf->codes[2841] = 0x0000e0227f11ba15UL;
   tf->codes[2842] = 0x0000e022f42fc59fUL;
   tf->codes[2843] = 0x0000e023de6bdcb3UL;
   tf->codes[2844] = 0x0000e0253dc5ff51UL;
   tf->codes[2845] = 0x0000e02578550516UL;
   tf->codes[2846] = 0x0000e02628021665UL;
   tf->codes[2847] = 0x0000e0274ccd333eUL;
   tf->codes[2848] = 0x0000e027c1eb3ec8UL;
   tf->codes[2849] = 0x0000e02837094a52UL;
   tf->codes[2850] = 0x0000e028e6b65ba1UL;
   tf->codes[2851] = 0x0000e02e641ee619UL;
   tf->codes[2852] = 0x0000e02e9eadebdeUL;
   tf->codes[2853] = 0x0000e02f88ea02f2UL;
   tf->codes[2854] = 0x0000e02fc37908b7UL;
   tf->codes[2855] = 0x0000e02ffe080e7cUL;
   tf->codes[2856] = 0x0000e03122d32b55UL;
   tf->codes[2857] = 0x0000e0315d62311aUL;
   tf->codes[2858] = 0x0000e032822d4df3UL;
   tf->codes[2859] = 0x0000e032f74b597dUL;
   tf->codes[2860] = 0x0000e0336c696507UL;
   tf->codes[2861] = 0x0000e033a6f86accUL;
   tf->codes[2862] = 0x0000e03456a57c1bUL;
   tf->codes[2863] = 0x0000e036a03bb5cdUL;
   tf->codes[2864] = 0x0000e036dacabb92UL;
   tf->codes[2865] = 0x0000e037ff95d86bUL;
   tf->codes[2866] = 0x0000e039997f00ceUL;
   tf->codes[2867] = 0x0000e039d40e0693UL;
   tf->codes[2868] = 0x0000e03a492c121dUL;
   tf->codes[2869] = 0x0000e03a83bb17e2UL;
   tf->codes[2870] = 0x0000e03ccd515194UL;
   tf->codes[2871] = 0x0000e040b0d0b3a9UL;
   tf->codes[2872] = 0x0000e040eb5fb96eUL;
   tf->codes[2873] = 0x0000e041607dc4f8UL;
   tf->codes[2874] = 0x0000e041d59bd082UL;
   tf->codes[2875] = 0x0000e0428548e1d1UL;
   tf->codes[2876] = 0x0000e042fa66ed5bUL;
   tf->codes[2877] = 0x0000e043aa13feaaUL;
   tf->codes[2878] = 0x0000e043e4a3046fUL;
   tf->codes[2879] = 0x0000e0441f320a34UL;
   tf->codes[2880] = 0x0000e04753045afaUL;
   tf->codes[2881] = 0x0000e047c8226684UL;
   tf->codes[2882] = 0x0000e04a4c47a5fbUL;
   tf->codes[2883] = 0x0000e04b7112c2d4UL;
   tf->codes[2884] = 0x0000e04baba1c899UL;
   tf->codes[2885] = 0x0000e04be630ce5eUL;
   tf->codes[2886] = 0x0000e04c20bfd423UL;
   tf->codes[2887] = 0x0000e04c5b4ed9e8UL;
   tf->codes[2888] = 0x0000e04dbaa8fc86UL;
   tf->codes[2889] = 0x0000e04ea4e5139aUL;
   tf->codes[2890] = 0x0000e04f8f212aaeUL;
   tf->codes[2891] = 0x0000e051290a5311UL;
   tf->codes[2892] = 0x0000e051639958d6UL;
   tf->codes[2893] = 0x0000e0519e285e9bUL;
   tf->codes[2894] = 0x0000e051d8b76460UL;
   tf->codes[2895] = 0x0000e052c2f37b74UL;
   tf->codes[2896] = 0x0000e053381186feUL;
   tf->codes[2897] = 0x0000e053ad2f9288UL;
   tf->codes[2898] = 0x0000e0554718baebUL;
   tf->codes[2899] = 0x0000e05581a7c0b0UL;
   tf->codes[2900] = 0x0000e055f6c5cc3aUL;
   tf->codes[2901] = 0x0000e0563154d1ffUL;
   tf->codes[2902] = 0x0000e05790aef49dUL;
   tf->codes[2903] = 0x0000e0587aeb0bb1UL;
   tf->codes[2904] = 0x0000e058b57a1176UL;
   tf->codes[2905] = 0x0000e058f009173bUL;
   tf->codes[2906] = 0x0000e059652722c5UL;
   tf->codes[2907] = 0x0000e059da452e4fUL;
   tf->codes[2908] = 0x0000e05a89f23f9eUL;
   tf->codes[2909] = 0x0000e05aff104b28UL;
   tf->codes[2910] = 0x0000e05b399f50edUL;
   tf->codes[2911] = 0x0000e05d48a684daUL;
   tf->codes[2912] = 0x0000e05e32e29beeUL;
   tf->codes[2913] = 0x0000e0612c25e6efUL;
   tf->codes[2914] = 0x0000e0633b2d1adcUL;
   tf->codes[2915] = 0x0000e063b04b2666UL;
   tf->codes[2916] = 0x0000e063eada2c2bUL;
   tf->codes[2917] = 0x0000e064256931f0UL;
   tf->codes[2918] = 0x0000e066347065ddUL;
   tf->codes[2919] = 0x0000e066e41d772cUL;
   tf->codes[2920] = 0x0000e0671eac7cf1UL;
   tf->codes[2921] = 0x0000e067593b82b6UL;
   tf->codes[2922] = 0x0000e0692db3b0deUL;
   tf->codes[2923] = 0x0000e0696842b6a3UL;
   tf->codes[2924] = 0x0000e06a8d0dd37cUL;
   tf->codes[2925] = 0x0000e06ac79cd941UL;
   tf->codes[2926] = 0x0000e06bec67f61aUL;
   tf->codes[2927] = 0x0000e06f9558526aUL;
   tf->codes[2928] = 0x0000e0700a765df4UL;
   tf->codes[2929] = 0x0000e072197d91e1UL;
   tf->codes[2930] = 0x0000e072c92aa330UL;
   tf->codes[2931] = 0x0000e073b366ba44UL;
   tf->codes[2932] = 0x0000e0749da2d158UL;
   tf->codes[2933] = 0x0000e074d831d71dUL;
   tf->codes[2934] = 0x0000e07512c0dce2UL;
   tf->codes[2935] = 0x0000e0754d4fe2a7UL;
   tf->codes[2936] = 0x0000e078bbb13932UL;
   tf->codes[2937] = 0x0000e07a559a6195UL;
   tf->codes[2938] = 0x0000e07bb4f48433UL;
   tf->codes[2939] = 0x0000e07c2a128fbdUL;
   tf->codes[2940] = 0x0000e07c64a19582UL;
   tf->codes[2941] = 0x0000e07e3919c3aaUL;
   tf->codes[2942] = 0x0000e07ee8c6d4f9UL;
   tf->codes[2943] = 0x0000e07f9873e648UL;
   tf->codes[2944] = 0x0000e08082affd5cUL;
   tf->codes[2945] = 0x0000e080f7ce08e6UL;
   tf->codes[2946] = 0x0000e081a77b1a35UL;
   tf->codes[2947] = 0x0000e08257282b84UL;
   tf->codes[2948] = 0x0000e082cc46370eUL;
   tf->codes[2949] = 0x0000e084662f5f71UL;
   tf->codes[2950] = 0x0000e084db4d6afbUL;
   tf->codes[2951] = 0x0000e088becccd10UL;
   tf->codes[2952] = 0x0000e08933ead89aUL;
   tf->codes[2953] = 0x0000e08a1e26efaeUL;
   tf->codes[2954] = 0x0000e08a9344fb38UL;
   tf->codes[2955] = 0x0000e08c2d2e239bUL;
   tf->codes[2956] = 0x0000e08c67bd2960UL;
   tf->codes[2957] = 0x0000e08dc7174bfeUL;
   tf->codes[2958] = 0x0000e08e3c355788UL;
   tf->codes[2959] = 0x0000e08eebe268d7UL;
   tf->codes[2960] = 0x0000e09010ad85b0UL;
   tf->codes[2961] = 0x0000e090fae99cc4UL;
   tf->codes[2962] = 0x0000e093447fd676UL;
   tf->codes[2963] = 0x0000e0937f0edc3bUL;
   tf->codes[2964] = 0x0000e093f42ce7c5UL;
   tf->codes[2965] = 0x0000e094a3d9f914UL;
   tf->codes[2966] = 0x0000e09518f8049eUL;
   tf->codes[2967] = 0x0000e09553870a63UL;
   tf->codes[2968] = 0x0000e096ed7032c6UL;
   tf->codes[2969] = 0x0000e0979d1d4415UL;
   tf->codes[2970] = 0x0000e097d7ac49daUL;
   tf->codes[2971] = 0x0000e098fc7766b3UL;
   tf->codes[2972] = 0x0000e0997195723dUL;
   tf->codes[2973] = 0x0000e09a2142838cUL;
   tf->codes[2974] = 0x0000e09b460da065UL;
   tf->codes[2975] = 0x0000e09b809ca62aUL;
   tf->codes[2976] = 0x0000e09bf5bab1b4UL;
   tf->codes[2977] = 0x0000e09fd93a13c9UL;
   tf->codes[2978] = 0x0000e0a013c9198eUL;
   tf->codes[2979] = 0x0000e0a04e581f53UL;
   tf->codes[2980] = 0x0000e0a0c3762addUL;
   tf->codes[2981] = 0x0000e0a0fe0530a2UL;
   tf->codes[2982] = 0x0000e0a173233c2cUL;
   tf->codes[2983] = 0x0000e0a222d04d7bUL;
   tf->codes[2984] = 0x0000e0a25d5f5340UL;
   tf->codes[2985] = 0x0000e0a2d27d5ecaUL;
   tf->codes[2986] = 0x0000e0a3822a7019UL;
   tf->codes[2987] = 0x0000e0a556a29e41UL;
   tf->codes[2988] = 0x0000e0a67b6dbb1aUL;
   tf->codes[2989] = 0x0000e0a6b5fcc0dfUL;
   tf->codes[2990] = 0x0000e0a765a9d22eUL;
   tf->codes[2991] = 0x0000e0a7a038d7f3UL;
   tf->codes[2992] = 0x0000e0a93a220056UL;
   tf->codes[2993] = 0x0000e0aad40b28b9UL;
   tf->codes[2994] = 0x0000e0ab49293443UL;
   tf->codes[2995] = 0x0000e0ae7cfb8509UL;
   tf->codes[2996] = 0x0000e0af67379c1dUL;
   tf->codes[2997] = 0x0000e0b05173b331UL;
   tf->codes[2998] = 0x0000e0b0c691bebbUL;
   tf->codes[2999] = 0x0000e0b13bafca45UL;
   tf->codes[3000] = 0x0000e0b2607ae71eUL;
   tf->codes[3001] = 0x0000e0b31027f86dUL;
   tf->codes[3002] = 0x0000e0b34ab6fe32UL;
   tf->codes[3003] = 0x0000e0b3854603f7UL;
   tf->codes[3004] = 0x0000e0b3fa640f81UL;
   tf->codes[3005] = 0x0000e0b46f821b0bUL;
   tf->codes[3006] = 0x0000e0b4aa1120d0UL;
   tf->codes[3007] = 0x0000e0b6096b436eUL;
   tf->codes[3008] = 0x0000e0b6f3a75a82UL;
   tf->codes[3009] = 0x0000e0b7a3546bd1UL;
   tf->codes[3010] = 0x0000e0b81872775bUL;
   tf->codes[3011] = 0x0000e0b93d3d9434UL;
   tf->codes[3012] = 0x0000e0b977cc99f9UL;
   tf->codes[3013] = 0x0000e0bbc162d3abUL;
   tf->codes[3014] = 0x0000e0be0af90d5dUL;
   tf->codes[3015] = 0x0000e0bef5352471UL;
   tf->codes[3016] = 0x0000e0bf6a532ffbUL;
   tf->codes[3017] = 0x0000e0c29e2580c1UL;
   tf->codes[3018] = 0x0000e0c3fd7fa35fUL;
   tf->codes[3019] = 0x0000e0c4380ea924UL;
   tf->codes[3020] = 0x0000e0c4729daee9UL;
   tf->codes[3021] = 0x0000e0c4ad2cb4aeUL;
   tf->codes[3022] = 0x0000e0c681a4e2d6UL;
   tf->codes[3023] = 0x0000e0c6f6c2ee60UL;
   tf->codes[3024] = 0x0000e0c73151f425UL;
   tf->codes[3025] = 0x0000e0c890ac16c3UL;
   tf->codes[3026] = 0x0000e0c8cb3b1c88UL;
   tf->codes[3027] = 0x0000e0c9f0063961UL;
   tf->codes[3028] = 0x0000e0ca652444ebUL;
   tf->codes[3029] = 0x0000e0cada425075UL;
   tf->codes[3030] = 0x0000e0cb89ef61c4UL;
   tf->codes[3031] = 0x0000e0cbc47e6789UL;
   tf->codes[3032] = 0x0000e0ccaeba7e9dUL;
   tf->codes[3033] = 0x0000e0cce9498462UL;
   tf->codes[3034] = 0x0000e0d057aadaedUL;
   tf->codes[3035] = 0x0000e0d0ccc8e677UL;
   tf->codes[3036] = 0x0000e0d141e6f201UL;
   tf->codes[3037] = 0x0000e0d4b048488cUL;
   tf->codes[3038] = 0x0000e0d64a3170efUL;
   tf->codes[3039] = 0x0000e0d7e41a9952UL;
   tf->codes[3040] = 0x0000e0d893c7aaa1UL;
   tf->codes[3041] = 0x0000e0d94374bbf0UL;
   tf->codes[3042] = 0x0000e0da2db0d304UL;
   tf->codes[3043] = 0x0000e0daa2cede8eUL;
   tf->codes[3044] = 0x0000e0db527befddUL;
   tf->codes[3045] = 0x0000e0dcec651840UL;
   tf->codes[3046] = 0x0000e0de11303519UL;
   tf->codes[3047] = 0x0000e0e05ac66ecbUL;
   tf->codes[3048] = 0x0000e0e403b6cb1bUL;
   tf->codes[3049] = 0x0000e0e478d4d6a5UL;
   tf->codes[3050] = 0x0000e0e4b363dc6aUL;
   tf->codes[3051] = 0x0000e0e612bdff08UL;
   tf->codes[3052] = 0x0000e0e8d1724444UL;
   tf->codes[3053] = 0x0000e0eaa5ea726cUL;
   tf->codes[3054] = 0x0000e0eae0797831UL;
   tf->codes[3055] = 0x0000e0eb559783bbUL;
   tf->codes[3056] = 0x0000e0eb90268980UL;
   tf->codes[3057] = 0x0000e0ec0544950aUL;
   tf->codes[3058] = 0x0000e0ecb4f1a659UL;
   tf->codes[3059] = 0x0000e0ee144bc8f7UL;
   tf->codes[3060] = 0x0000e0ee8969d481UL;
   tf->codes[3061] = 0x0000e0f10d8f13f8UL;
   tf->codes[3062] = 0x0000e0f1bd3c2547UL;
   tf->codes[3063] = 0x0000e0f1f7cb2b0cUL;
   tf->codes[3064] = 0x0000e0f2325a30d1UL;
   tf->codes[3065] = 0x0000e0f31c9647e5UL;
   tf->codes[3066] = 0x0000e0f3cc435934UL;
   tf->codes[3067] = 0x0000e0f6506898abUL;
   tf->codes[3068] = 0x0000e0f6c586a435UL;
   tf->codes[3069] = 0x0000e0f70015a9faUL;
   tf->codes[3070] = 0x0000e0f73aa4afbfUL;
   tf->codes[3071] = 0x0000e0f899fed25dUL;
   tf->codes[3072] = 0x0000e0f8d48dd822UL;
   tf->codes[3073] = 0x0000e0f949abe3acUL;
   tf->codes[3074] = 0x0000e0f9843ae971UL;
   tf->codes[3075] = 0x0000e0fa6e770085UL;
   tf->codes[3076] = 0x0000e0faa906064aUL;
   tf->codes[3077] = 0x0000e0fbcdd12323UL;
   tf->codes[3078] = 0x0000e0fc42ef2eadUL;
   tf->codes[3079] = 0x0000e1009b8c9c4cUL;
   tf->codes[3080] = 0x0000e10110aaa7d6UL;
   tf->codes[3081] = 0x0000e101fae6beeaUL;
   tf->codes[3082] = 0x0000e1023575c4afUL;
   tf->codes[3083] = 0x0000e102aa93d039UL;
   tf->codes[3084] = 0x0000e1031fb1dbc3UL;
   tf->codes[3085] = 0x0000e1035a40e188UL;
   tf->codes[3086] = 0x0000e10394cfe74dUL;
   tf->codes[3087] = 0x0000e104b99b0426UL;
   tf->codes[3088] = 0x0000e10618f526c4UL;
   tf->codes[3089] = 0x0000e1068e13324eUL;
   tf->codes[3090] = 0x0000e108628b6076UL;
   tf->codes[3091] = 0x0000e108d7a96c00UL;
   tf->codes[3092] = 0x0000e10aac219a28UL;
   tf->codes[3093] = 0x0000e10b213fa5b2UL;
   tf->codes[3094] = 0x0000e10b5bceab77UL;
   tf->codes[3095] = 0x0000e10b965db13cUL;
   tf->codes[3096] = 0x0000e11064192a65UL;
   tf->codes[3097] = 0x0000e111c3734d03UL;
   tf->codes[3098] = 0x0000e111fe0252c8UL;
   tf->codes[3099] = 0x0000e112adaf6417UL;
   tf->codes[3100] = 0x0000e112e83e69dcUL;
   tf->codes[3101] = 0x0000e11322cd6fa1UL;
   tf->codes[3102] = 0x0000e113d27a80f0UL;
   tf->codes[3103] = 0x0000e1140d0986b5UL;
   tf->codes[3104] = 0x0000e1156c63a953UL;
   tf->codes[3105] = 0x0000e115a6f2af18UL;
   tf->codes[3106] = 0x0000e1161c10baa2UL;
   tf->codes[3107] = 0x0000e116912ec62cUL;
   tf->codes[3108] = 0x0000e116cbbdcbf1UL;
   tf->codes[3109] = 0x0000e1194fe30b68UL;
   tf->codes[3110] = 0x0000e11a3a1f227cUL;
   tf->codes[3111] = 0x0000e11a74ae2841UL;
   tf->codes[3112] = 0x0000e11b9979451aUL;
   tf->codes[3113] = 0x0000e11c83b55c2eUL;
   tf->codes[3114] = 0x0000e11d6df17342UL;
   tf->codes[3115] = 0x0000e11e582d8a56UL;
   tf->codes[3116] = 0x0000e1206734be43UL;
   tf->codes[3117] = 0x0000e120a1c3c408UL;
   tf->codes[3118] = 0x0000e120dc52c9cdUL;
   tf->codes[3119] = 0x0000e1215170d557UL;
   tf->codes[3120] = 0x0000e1218bffdb1cUL;
   tf->codes[3121] = 0x0000e12325e9037fUL;
   tf->codes[3122] = 0x0000e12360780944UL;
   tf->codes[3123] = 0x0000e1239b070f09UL;
   tf->codes[3124] = 0x0000e123d59614ceUL;
   tf->codes[3125] = 0x0000e1244ab42058UL;
   tf->codes[3126] = 0x0000e1261f2c4e80UL;
   tf->codes[3127] = 0x0000e12659bb5445UL;
   tf->codes[3128] = 0x0000e12743f76b59UL;
   tf->codes[3129] = 0x0000e127b91576e3UL;
   tf->codes[3130] = 0x0000e12a3d3ab65aUL;
   tf->codes[3131] = 0x0000e12aece7c7a9UL;
   tf->codes[3132] = 0x0000e12b6205d333UL;
   tf->codes[3133] = 0x0000e12c4c41ea47UL;
   tf->codes[3134] = 0x0000e12ff5324697UL;
   tf->codes[3135] = 0x0000e1306a505221UL;
   tf->codes[3136] = 0x0000e13119fd6370UL;
   tf->codes[3137] = 0x0000e1318f1b6efaUL;
   tf->codes[3138] = 0x0000e131c9aa74bfUL;
   tf->codes[3139] = 0x0000e1327957860eUL;
   tf->codes[3140] = 0x0000e132b3e68bd3UL;
   tf->codes[3141] = 0x0000e1339e22a2e7UL;
   tf->codes[3142] = 0x0000e133d8b1a8acUL;
   tf->codes[3143] = 0x0000e134fd7cc585UL;
   tf->codes[3144] = 0x0000e135380bcb4aUL;
   tf->codes[3145] = 0x0000e135729ad10fUL;
   tf->codes[3146] = 0x0000e136d1f4f3adUL;
   tf->codes[3147] = 0x0000e137bc310ac1UL;
   tf->codes[3148] = 0x0000e138a66d21d5UL;
   tf->codes[3149] = 0x0000e138e0fc279aUL;
   tf->codes[3150] = 0x0000e13ab57455c2UL;
   tf->codes[3151] = 0x0000e13b2a92614cUL;
   tf->codes[3152] = 0x0000e13b9fb06cd6UL;
   tf->codes[3153] = 0x0000e13bda3f729bUL;
   tf->codes[3154] = 0x0000e13f0e11c361UL;
   tf->codes[3155] = 0x0000e1411d18f74eUL;
   tf->codes[3156] = 0x0000e141923702d8UL;
   tf->codes[3157] = 0x0000e141ccc6089dUL;
   tf->codes[3158] = 0x0000e142b7021fb1UL;
   tf->codes[3159] = 0x0000e1432c202b3bUL;
   tf->codes[3160] = 0x0000e143a13e36c5UL;
   tf->codes[3161] = 0x0000e144c609539eUL;
   tf->codes[3162] = 0x0000e14575b664edUL;
   tf->codes[3163] = 0x0000e146d510878bUL;
   tf->codes[3164] = 0x0000e1470f9f8d50UL;
   tf->codes[3165] = 0x0000e1474a2e9315UL;
   tf->codes[3166] = 0x0000e14784bd98daUL;
   tf->codes[3167] = 0x0000e147bf4c9e9fUL;
   tf->codes[3168] = 0x0000e148a988b5b3UL;
   tf->codes[3169] = 0x0000e148e417bb78UL;
   tf->codes[3170] = 0x0000e1491ea6c13dUL;
   tf->codes[3171] = 0x0000e14993c4ccc7UL;
   tf->codes[3172] = 0x0000e14a08e2d851UL;
   tf->codes[3173] = 0x0000e14b683cfaefUL;
   tf->codes[3174] = 0x0000e14e618045f0UL;
   tf->codes[3175] = 0x0000e14e9c0f4bb5UL;
   tf->codes[3176] = 0x0000e14f112d573fUL;
   tf->codes[3177] = 0x0000e14f4bbc5d04UL;
   tf->codes[3178] = 0x0000e14ffb696e53UL;
   tf->codes[3179] = 0x0000e150708779ddUL;
   tf->codes[3180] = 0x0000e15120348b2cUL;
   tf->codes[3181] = 0x0000e151955296b6UL;
   tf->codes[3182] = 0x0000e152ba1db38fUL;
   tf->codes[3183] = 0x0000e153a459caa3UL;
   tf->codes[3184] = 0x0000e15578d1f8cbUL;
   tf->codes[3185] = 0x0000e155b360fe90UL;
   tf->codes[3186] = 0x0000e156287f0a1aUL;
   tf->codes[3187] = 0x0000e156630e0fdfUL;
   tf->codes[3188] = 0x0000e156d82c1b69UL;
   tf->codes[3189] = 0x0000e15af63a8343UL;
   tf->codes[3190] = 0x0000e15c1b05a01cUL;
   tf->codes[3191] = 0x0000e15ccab2b16bUL;
   tf->codes[3192] = 0x0000e15d3fd0bcf5UL;
   tf->codes[3193] = 0x0000e162481b3be3UL;
   tf->codes[3194] = 0x0000e16282aa41a8UL;
   tf->codes[3195] = 0x0000e162bd39476dUL;
   tf->codes[3196] = 0x0000e163a7755e81UL;
   tf->codes[3197] = 0x0000e1666629a3bdUL;
   tf->codes[3198] = 0x0000e1675065bad1UL;
   tf->codes[3199] = 0x0000e1678af4c096UL;
   tf->codes[3200] = 0x0000e167c583c65bUL;
   tf->codes[3201] = 0x0000e168afbfdd6fUL;
   tf->codes[3202] = 0x0000e168ea4ee334UL;
   tf->codes[3203] = 0x0000e1695f6ceebeUL;
   tf->codes[3204] = 0x0000e169d48afa48UL;
   tf->codes[3205] = 0x0000e16a84380b97UL;
   tf->codes[3206] = 0x0000e16abec7115cUL;
   tf->codes[3207] = 0x0000e16af9561721UL;
   tf->codes[3208] = 0x0000e16ba9032870UL;
   tf->codes[3209] = 0x0000e16c1e2133faUL;
   tf->codes[3210] = 0x0000e17076bea199UL;
   tf->codes[3211] = 0x0000e171266bb2e8UL;
   tf->codes[3212] = 0x0000e172fae3e110UL;
   tf->codes[3213] = 0x0000e1745a3e03aeUL;
   tf->codes[3214] = 0x0000e17494cd0973UL;
   tf->codes[3215] = 0x0000e175b998264cUL;
   tf->codes[3216] = 0x0000e1762eb631d6UL;
   tf->codes[3217] = 0x0000e177c89f5a39UL;
   tf->codes[3218] = 0x0000e17a4cc499b0UL;
   tf->codes[3219] = 0x0000e17afc71aaffUL;
   tf->codes[3220] = 0x0000e17b718fb689UL;
   tf->codes[3221] = 0x0000e17c213cc7d8UL;
   tf->codes[3222] = 0x0000e17edff10d14UL;
   tf->codes[3223] = 0x0000e17f550f189eUL;
   tf->codes[3224] = 0x0000e18004bc29edUL;
   tf->codes[3225] = 0x0000e181298746c6UL;
   tf->codes[3226] = 0x0000e182fdff74eeUL;
   tf->codes[3227] = 0x0000e183adac863dUL;
   tf->codes[3228] = 0x0000e183e83b8c02UL;
   tf->codes[3229] = 0x0000e18422ca91c7UL;
   tf->codes[3230] = 0x0000e184d277a316UL;
   tf->codes[3231] = 0x0000e186a6efd13eUL;
   tf->codes[3232] = 0x0000e186e17ed703UL;
   tf->codes[3233] = 0x0000e187569ce28dUL;
   tf->codes[3234] = 0x0000e1892b1510b5UL;
   tf->codes[3235] = 0x0000e189dac22204UL;
   tf->codes[3236] = 0x0000e18ac4fe3918UL;
   tf->codes[3237] = 0x0000e18baf3a502cUL;
   tf->codes[3238] = 0x0000e18d0e9472caUL;
   tf->codes[3239] = 0x0000e18d4923788fUL;
   tf->codes[3240] = 0x0000e18ee30ca0f2UL;
   tf->codes[3241] = 0x0000e1907cf5c955UL;
   tf->codes[3242] = 0x0000e190f213d4dfUL;
   tf->codes[3243] = 0x0000e1912ca2daa4UL;
   tf->codes[3244] = 0x0000e19460752b6aUL;
   tf->codes[3245] = 0x0000e19510223cb9UL;
   tf->codes[3246] = 0x0000e196aa0b651cUL;
   tf->codes[3247] = 0x0000e19759b8766bUL;
   tf->codes[3248] = 0x0000e198b9129909UL;
   tf->codes[3249] = 0x0000e19968bfaa58UL;
   tf->codes[3250] = 0x0000e19b02a8d2bbUL;
   tf->codes[3251] = 0x0000e19cd72100e3UL;
   tf->codes[3252] = 0x0000e19dc15d17f7UL;
   tf->codes[3253] = 0x0000e19e367b2381UL;
   tf->codes[3254] = 0x0000e1a2c9a796e5UL;
   tf->codes[3255] = 0x0000e1a304369caaUL;
   tf->codes[3256] = 0x0000e1a3ee72b3beUL;
   tf->codes[3257] = 0x0000e1a42901b983UL;
   tf->codes[3258] = 0x0000e1a49e1fc50dUL;
   tf->codes[3259] = 0x0000e1a4d8aecad2UL;
   tf->codes[3260] = 0x0000e1a5133dd097UL;
   tf->codes[3261] = 0x0000e1a6ad26f8faUL;
   tf->codes[3262] = 0x0000e1ac2a8f8372UL;
   tf->codes[3263] = 0x0000e1aee943c8aeUL;
   tf->codes[3264] = 0x0000e1b1e28713afUL;
   tf->codes[3265] = 0x0000e1b21d161974UL;
   tf->codes[3266] = 0x0000e1b2923424feUL;
   tf->codes[3267] = 0x0000e1b2ccc32ac3UL;
   tf->codes[3268] = 0x0000e1b3f18e479cUL;
   tf->codes[3269] = 0x0000e1b4a13b58ebUL;
   tf->codes[3270] = 0x0000e1b63b24814eUL;
   tf->codes[3271] = 0x0000e1b6b0428cd8UL;
   tf->codes[3272] = 0x0000e1b75fef9e27UL;
   tf->codes[3273] = 0x0000e1b84a2bb53bUL;
   tf->codes[3274] = 0x0000e1b9a985d7d9UL;
   tf->codes[3275] = 0x0000e1bace50f4b2UL;
   tf->codes[3276] = 0x0000e1bb436f003cUL;
   tf->codes[3277] = 0x0000e1bf26ee6251UL;
   tf->codes[3278] = 0x0000e1c1e5a2a78dUL;
   tf->codes[3279] = 0x0000e1c25ac0b317UL;
   tf->codes[3280] = 0x0000e1c3f4a9db7aUL;
   tf->codes[3281] = 0x0000e1c4a456ecc9UL;
   tf->codes[3282] = 0x0000e1c51974f853UL;
   tf->codes[3283] = 0x0000e1c603b10f67UL;
   tf->codes[3284] = 0x0000e1c63e40152cUL;
   tf->codes[3285] = 0x0000e1c678cf1af1UL;
   tf->codes[3286] = 0x0000e1cb468a941aUL;
   tf->codes[3287] = 0x0000e1cbf637a569UL;
   tf->codes[3288] = 0x0000e1ce053ed956UL;
   tf->codes[3289] = 0x0000e1cfd9b7077eUL;
   tf->codes[3290] = 0x0000e1d0896418cdUL;
   tf->codes[3291] = 0x0000e1d173a02fe1UL;
   tf->codes[3292] = 0x0000e1d2234d4130UL;
   tf->codes[3293] = 0x0000e1d3bd366993UL;
   tf->codes[3294] = 0x0000e1d4a77280a7UL;
   tf->codes[3295] = 0x0000e1d5571f91f6UL;
   tf->codes[3296] = 0x0000e1d72b97c01eUL;
   tf->codes[3297] = 0x0000e1d88af1e2bcUL;
   tf->codes[3298] = 0x0000e1d93a9ef40bUL;
   tf->codes[3299] = 0x0000e1da99f916a9UL;
   tf->codes[3300] = 0x0000e1e0c70eb270UL;
   tf->codes[3301] = 0x0000e1e29b86e098UL;
   tf->codes[3302] = 0x0000e1e2d615e65dUL;
   tf->codes[3303] = 0x0000e1e55a3b25d4UL;
   tf->codes[3304] = 0x0000e1e67f0642adUL;
   tf->codes[3305] = 0x0000e1e6b9954872UL;
   tf->codes[3306] = 0x0000e1e7de60654bUL;
   tf->codes[3307] = 0x0000e1ea27f69efdUL;
   tf->codes[3308] = 0x0000e1eb1232b611UL;
   tf->codes[3309] = 0x0000e1ece6aae439UL;
   tf->codes[3310] = 0x0000e1ee80940c9cUL;
   tf->codes[3311] = 0x0000e1eef5b21826UL;
   tf->codes[3312] = 0x0000e1f0ca2a464eUL;
   tf->codes[3313] = 0x0000e1f264136eb1UL;
   tf->codes[3314] = 0x0000e1f3c36d914fUL;
   tf->codes[3315] = 0x0000e1f76c5ded9fUL;
   tf->codes[3316] = 0x0000e1f891290a78UL;
   tf->codes[3317] = 0x0000e1f97b65218cUL;
   tf->codes[3318] = 0x0000e1f9f0832d16UL;
   tf->codes[3319] = 0x0000e1faa0303e65UL;
   tf->codes[3320] = 0x0000e1fcaf377252UL;
   tf->codes[3321] = 0x0000e2005827cea2UL;
   tf->codes[3322] = 0x0000e200cd45da2cUL;
   tf->codes[3323] = 0x0000e20401182af2UL;
   tf->codes[3324] = 0x0000e2047636367cUL;
   tf->codes[3325] = 0x0000e20525e347cbUL;
   tf->codes[3326] = 0x0000e206853d6a69UL;
   tf->codes[3327] = 0x0000e20734ea7bb8UL;
   tf->codes[3328] = 0x0000e2081f2692ccUL;
   tf->codes[3329] = 0x0000e20859b59891UL;
   tf->codes[3330] = 0x0000e2090962a9e0UL;
   tf->codes[3331] = 0x0000e209b90fbb2fUL;
   tf->codes[3332] = 0x0000e20a2e2dc6b9UL;
   tf->codes[3333] = 0x0000e20a68bccc7eUL;
   tf->codes[3334] = 0x0000e20aa34bd243UL;
   tf->codes[3335] = 0x0000e20cb2530630UL;
   tf->codes[3336] = 0x0000e20ec15a3a1dUL;
   tf->codes[3337] = 0x0000e21020b45cbbUL;
   tf->codes[3338] = 0x0000e2105b436280UL;
   tf->codes[3339] = 0x0000e211800e7f59UL;
   tf->codes[3340] = 0x0000e2140433bed0UL;
   tf->codes[3341] = 0x0000e215638de16eUL;
   tf->codes[3342] = 0x0000e2159e1ce733UL;
   tf->codes[3343] = 0x0000e216133af2bdUL;
   tf->codes[3344] = 0x0000e21738060f96UL;
   tf->codes[3345] = 0x0000e2177295155bUL;
   tf->codes[3346] = 0x0000e217e7b320e5UL;
   tf->codes[3347] = 0x0000e21b1b8571abUL;
   tf->codes[3348] = 0x0000e21b56147770UL;
   tf->codes[3349] = 0x0000e21e14c8bcacUL;
   tf->codes[3350] = 0x0000e21eff04d3c0UL;
   tf->codes[3351] = 0x0000e220d37d01e8UL;
   tf->codes[3352] = 0x0000e2226d662a4bUL;
   tf->codes[3353] = 0x0000e222a7f53010UL;
   tf->codes[3354] = 0x0000e22392314724UL;
   tf->codes[3355] = 0x0000e224074f52aeUL;
   tf->codes[3356] = 0x0000e2247c6d5e38UL;
   tf->codes[3357] = 0x0000e2252c1a6f87UL;
   tf->codes[3358] = 0x0000e2273b21a374UL;
   tf->codes[3359] = 0x0000e22775b0a939UL;
   tf->codes[3360] = 0x0000e227b03faefeUL;
   tf->codes[3361] = 0x0000e228255dba88UL;
   tf->codes[3362] = 0x0000e228d50acbd7UL;
   tf->codes[3363] = 0x0000e2290f99d19cUL;
   tf->codes[3364] = 0x0000e2294a28d761UL;
   tf->codes[3365] = 0x0000e229bf46e2ebUL;
   tf->codes[3366] = 0x0000e22b1ea10589UL;
   tf->codes[3367] = 0x0000e22bce4e16d8UL;
   tf->codes[3368] = 0x0000e22d2da83976UL;
   tf->codes[3369] = 0x0000e22e5273564fUL;
   tf->codes[3370] = 0x0000e22ec79161d9UL;
   tf->codes[3371] = 0x0000e22fb1cd78edUL;
   tf->codes[3372] = 0x0000e23111279b8bUL;
   tf->codes[3373] = 0x0000e231fb63b29fUL;
   tf->codes[3374] = 0x0000e232e59fc9b3UL;
   tf->codes[3375] = 0x0000e2335abdd53dUL;
   tf->codes[3376] = 0x0000e2340a6ae68cUL;
   tf->codes[3377] = 0x0000e235dee314b4UL;
   tf->codes[3378] = 0x0000e236c91f2bc8UL;
   tf->codes[3379] = 0x0000e237b35b42dcUL;
   tf->codes[3380] = 0x0000e237edea48a1UL;
   tf->codes[3381] = 0x0000e23828794e66UL;
   tf->codes[3382] = 0x0000e238d8265fb5UL;
   tf->codes[3383] = 0x0000e23a720f8818UL;
   tf->codes[3384] = 0x0000e23da5e1d8deUL;
   tf->codes[3385] = 0x0000e23e558eea2dUL;
   tf->codes[3386] = 0x0000e2402a071855UL;
   tf->codes[3387] = 0x0000e2409f2523dfUL;
   tf->codes[3388] = 0x0000e24114432f69UL;
   tf->codes[3389] = 0x0000e24189613af3UL;
   tf->codes[3390] = 0x0000e241fe7f467dUL;
   tf->codes[3391] = 0x0000e242390e4c42UL;
   tf->codes[3392] = 0x0000e243234a6356UL;
   tf->codes[3393] = 0x0000e2440d867a6aUL;
   tf->codes[3394] = 0x0000e2444815802fUL;
   tf->codes[3395] = 0x0000e245e1fea892UL;
   tf->codes[3396] = 0x0000e2477be7d0f5UL;
   tf->codes[3397] = 0x0000e24aafba21bbUL;
   tf->codes[3398] = 0x0000e24f08578f5aUL;
   tf->codes[3399] = 0x0000e2523c29e020UL;
   tf->codes[3400] = 0x0000e2532665f734UL;
   tf->codes[3401] = 0x0000e2539b8402beUL;
   tf->codes[3402] = 0x0000e25a3db7aa0fUL;
   tf->codes[3403] = 0x0000e25aed64bb5eUL;
   tf->codes[3404] = 0x0000e25b27f3c123UL;
   tf->codes[3405] = 0x0000e25b6282c6e8UL;
   tf->codes[3406] = 0x0000e25e21370c24UL;
   tf->codes[3407] = 0x0000e25e965517aeUL;
   tf->codes[3408] = 0x0000e25f0b732338UL;
   tf->codes[3409] = 0x0000e25ff5af3a4cUL;
   tf->codes[3410] = 0x0000e26204b66e39UL;
   tf->codes[3411] = 0x0000e26329818b12UL;
   tf->codes[3412] = 0x0000e26622c4d613UL;
   tf->codes[3413] = 0x0000e267821ef8b1UL;
   tf->codes[3414] = 0x0000e268a6ea158aUL;
   tf->codes[3415] = 0x0000e2691c082114UL;
   tf->codes[3416] = 0x0000e26a7b6243b2UL;
   tf->codes[3417] = 0x0000e26ab5f14977UL;
   tf->codes[3418] = 0x0000e26bdabc6650UL;
   tf->codes[3419] = 0x0000e26cc4f87d64UL;
   tf->codes[3420] = 0x0000e26d3a1688eeUL;
   tf->codes[3421] = 0x0000e26e9970ab8cUL;
   tf->codes[3422] = 0x0000e26ed3ffb151UL;
   tf->codes[3423] = 0x0000e26f491dbcdbUL;
   tf->codes[3424] = 0x0000e271cd42fc52UL;
   tf->codes[3425] = 0x0000e272426107dcUL;
   tf->codes[3426] = 0x0000e273672c24b5UL;
   tf->codes[3427] = 0x0000e2748bf7418eUL;
   tf->codes[3428] = 0x0000e275763358a2UL;
   tf->codes[3429] = 0x0000e278aa05a968UL;
   tf->codes[3430] = 0x0000e278e494af2dUL;
   tf->codes[3431] = 0x0000e27959b2bab7UL;
   tf->codes[3432] = 0x0000e27b2e2ae8dfUL;
   tf->codes[3433] = 0x0000e27ba348f469UL;
   tf->codes[3434] = 0x0000e27e61fd39a5UL;
   tf->codes[3435] = 0x0000e27e9c8c3f6aUL;
   tf->codes[3436] = 0x0000e2815b4084a6UL;
   tf->codes[3437] = 0x0000e282457c9bbaUL;
   tf->codes[3438] = 0x0000e282ba9aa744UL;
   tf->codes[3439] = 0x0000e2836a47b893UL;
   tf->codes[3440] = 0x0000e284c9a1db31UL;
   tf->codes[3441] = 0x0000e2869e1a0959UL;
   tf->codes[3442] = 0x0000e287133814e3UL;
   tf->codes[3443] = 0x0000e288380331bcUL;
   tf->codes[3444] = 0x0000e289223f48d0UL;
   tf->codes[3445] = 0x0000e28abc287133UL;
   tf->codes[3446] = 0x0000e28ba6648847UL;
   tf->codes[3447] = 0x0000e28d404db0aaUL;
   tf->codes[3448] = 0x0000e29074200170UL;
   tf->codes[3449] = 0x0000e290aeaf0735UL;
   tf->codes[3450] = 0x0000e290e93e0cfaUL;
   tf->codes[3451] = 0x0000e291d37a240eUL;
   tf->codes[3452] = 0x0000e292f84540e7UL;
   tf->codes[3453] = 0x0000e294ccbd6f0fUL;
   tf->codes[3454] = 0x0000e295074c74d4UL;
   tf->codes[3455] = 0x0000e297c600ba10UL;
   tf->codes[3456] = 0x0000e298b03cd124UL;
   tf->codes[3457] = 0x0000e29a84b4ff4cUL;
   tf->codes[3458] = 0x0000e29b3462109bUL;
   tf->codes[3459] = 0x0000e29be40f21eaUL;
   tf->codes[3460] = 0x0000e29e68346161UL;
   tf->codes[3461] = 0x0000e29f52707875UL;
   tf->codes[3462] = 0x0000e2a0773b954eUL;
   tf->codes[3463] = 0x0000e2a126e8a69dUL;
   tf->codes[3464] = 0x0000e2a16177ac62UL;
   tf->codes[3465] = 0x0000e2a1d695b7ecUL;
   tf->codes[3466] = 0x0000e2a24bb3c376UL;
   tf->codes[3467] = 0x0000e2a62f33258bUL;
   tf->codes[3468] = 0x0000e2a7196f3c9fUL;
   tf->codes[3469] = 0x0000e2a753fe4264UL;
   tf->codes[3470] = 0x0000e2a78e8d4829UL;
   tf->codes[3471] = 0x0000e2aac25f98efUL;
   tf->codes[3472] = 0x0000e2ad0bf5d2a1UL;
   tf->codes[3473] = 0x0000e2af558c0c53UL;
   tf->codes[3474] = 0x0000e2af901b1218UL;
   tf->codes[3475] = 0x0000e2b0b4e62ef1UL;
   tf->codes[3476] = 0x0000e2b12a043a7bUL;
   tf->codes[3477] = 0x0000e2b164934040UL;
   tf->codes[3478] = 0x0000e2b1d9b14bcaUL;
   tf->codes[3479] = 0x0000e2b45dd68b41UL;
   tf->codes[3480] = 0x0000e2b71c8ad07dUL;
   tf->codes[3481] = 0x0000e2b791a8dc07UL;
   tf->codes[3482] = 0x0000e2b966210a2fUL;
   tf->codes[3483] = 0x0000e2ba8aec2708UL;
   tf->codes[3484] = 0x0000e2bb3a993857UL;
   tf->codes[3485] = 0x0000e2bbafb743e1UL;
   tf->codes[3486] = 0x0000e2bc5f645530UL;
   tf->codes[3487] = 0x0000e2bd49a06c44UL;
   tf->codes[3488] = 0x0000e2c12d1fce59UL;
   tf->codes[3489] = 0x0000e2c251eaeb32UL;
   tf->codes[3490] = 0x0000e2c28c79f0f7UL;
   tf->codes[3491] = 0x0000e2c2c708f6bcUL;
   tf->codes[3492] = 0x0000e2c460f21f1fUL;
   tf->codes[3493] = 0x0000e2c5c04c41bdUL;
   tf->codes[3494] = 0x0000e2c6aa8858d1UL;
   tf->codes[3495] = 0x0000e2c71fa6645bUL;
   tf->codes[3496] = 0x0000e2c92ead9848UL;
   tf->codes[3497] = 0x0000e2ca18e9af5cUL;
   tf->codes[3498] = 0x0000e2ca8e07bae6UL;
   tf->codes[3499] = 0x0000e2cb0325c670UL;
   tf->codes[3500] = 0x0000e2cbb2d2d7bfUL;
   tf->codes[3501] = 0x0000e2cee6a52885UL;
   tf->codes[3502] = 0x0000e2cf21342e4aUL;
   tf->codes[3503] = 0x0000e2d0808e50e8UL;
   tf->codes[3504] = 0x0000e2d304b3905fUL;
   tf->codes[3505] = 0x0000e2d4640db2fdUL;
   tf->codes[3506] = 0x0000e2d6ada3ecafUL;
   tf->codes[3507] = 0x0000e2d6e832f274UL;
   tf->codes[3508] = 0x0000e2d7d26f0988UL;
   tf->codes[3509] = 0x0000e2d8478d1512UL;
   tf->codes[3510] = 0x0000e2d931c92c26UL;
   tf->codes[3511] = 0x0000e2da1c05433aUL;
   tf->codes[3512] = 0x0000e2dbb5ee6b9dUL;
   tf->codes[3513] = 0x0000e2dca02a82b1UL;
   tf->codes[3514] = 0x0000e2dd15488e3bUL;
   tf->codes[3515] = 0x0000e2deaf31b69eUL;
   tf->codes[3516] = 0x0000e2e0be38ea8bUL;
   tf->codes[3517] = 0x0000e2e16de5fbdaUL;
   tf->codes[3518] = 0x0000e2e1a875019fUL;
   tf->codes[3519] = 0x0000e2e1e3040764UL;
   tf->codes[3520] = 0x0000e2e21d930d29UL;
   tf->codes[3521] = 0x0000e2e3425e2a02UL;
   tf->codes[3522] = 0x0000e2e4672946dbUL;
   tf->codes[3523] = 0x0000e2e84aa8a8f0UL;
   tf->codes[3524] = 0x0000e2e88537aeb5UL;
   tf->codes[3525] = 0x0000e2e8fa55ba3fUL;
   tf->codes[3526] = 0x0000e2ec2e280b05UL;
   tf->codes[3527] = 0x0000e2f011a76d1aUL;
   tf->codes[3528] = 0x0000e2f220aea107UL;
   tf->codes[3529] = 0x0000e2f25b3da6ccUL;
   tf->codes[3530] = 0x0000e2f3f526cf2fUL;
   tf->codes[3531] = 0x0000e2f42fb5d4f4UL;
   tf->codes[3532] = 0x0000e2f63ebd08e1UL;
   tf->codes[3533] = 0x0000e2f6794c0ea6UL;
   tf->codes[3534] = 0x0000e2f79e172b7fUL;
   tf->codes[3535] = 0x0000e2f9380053e2UL;
   tf->codes[3536] = 0x0000e2fa223c6af6UL;
   tf->codes[3537] = 0x0000e301741d2396UL;
   tf->codes[3538] = 0x0000e30298e8406fUL;
   tf->codes[3539] = 0x0000e309b039f34aUL;
   tf->codes[3540] = 0x0000e30d1e9b49d5UL;
   tf->codes[3541] = 0x0000e30e436666aeUL;
   tf->codes[3542] = 0x0000e30eb8847238UL;
   tf->codes[3543] = 0x0000e30ef31377fdUL;
   tf->codes[3544] = 0x0000e3108cfca060UL;
   tf->codes[3545] = 0x0000e311b1c7bd39UL;
   tf->codes[3546] = 0x0000e311ec56c2feUL;
   tf->codes[3547] = 0x0000e315202913c4UL;
   tf->codes[3548] = 0x0000e3167f833662UL;
   tf->codes[3549] = 0x0000e316ba123c27UL;
   tf->codes[3550] = 0x0000e316f4a141ecUL;
   tf->codes[3551] = 0x0000e31903a875d9UL;
   tf->codes[3552] = 0x0000e3193e377b9eUL;
   tf->codes[3553] = 0x0000e31a287392b2UL;
   tf->codes[3554] = 0x0000e31a63029877UL;
   tf->codes[3555] = 0x0000e31ce727d7eeUL;
   tf->codes[3556] = 0x0000e32055892e79UL;
   tf->codes[3557] = 0x0000e320caa73a03UL;
   tf->codes[3558] = 0x0000e323895b7f3fUL;
   tf->codes[3559] = 0x0000e326480fc47bUL;
   tf->codes[3560] = 0x0000e326829eca40UL;
   tf->codes[3561] = 0x0000e327a769e719UL;
   tf->codes[3562] = 0x0000e3281c87f2a3UL;
   tf->codes[3563] = 0x0000e328cc3503f2UL;
   tf->codes[3564] = 0x0000e329f10020cbUL;
   tf->codes[3565] = 0x0000e32a2b8f2690UL;
   tf->codes[3566] = 0x0000e32cea436bccUL;
   tf->codes[3567] = 0x0000e32e0f0e88a5UL;
   tf->codes[3568] = 0x0000e331b7fee4f5UL;
   tf->codes[3569] = 0x0000e33317590793UL;
   tf->codes[3570] = 0x0000e3338c77131dUL;
   tf->codes[3571] = 0x0000e33476b32a31UL;
   tf->codes[3572] = 0x0000e3385a328c46UL;
   tf->codes[3573] = 0x0000e3397efda91fUL;
   tf->codes[3574] = 0x0000e33b18e6d182UL;
   tf->codes[3575] = 0x0000e33bc893e2d1UL;
   tf->codes[3576] = 0x0000e33efc663397UL;
   tf->codes[3577] = 0x0000e341bb1a78d3UL;
   tf->codes[3578] = 0x0000e3426ac78a22UL;
   tf->codes[3579] = 0x0000e342dfe595acUL;
   tf->codes[3580] = 0x0000e3435503a136UL;
   tf->codes[3581] = 0x0000e345d928e0adUL;
   tf->codes[3582] = 0x0000e3464e46ec37UL;
   tf->codes[3583] = 0x0000e346c364f7c1UL;
   tf->codes[3584] = 0x0000e348d26c2baeUL;
   tf->codes[3585] = 0x0000e3490cfb3173UL;
   tf->codes[3586] = 0x0000e34b56916b25UL;
   tf->codes[3587] = 0x0000e34cf07a9388UL;
   tf->codes[3588] = 0x0000e34f749fd2ffUL;
   tf->codes[3589] = 0x0000e353581f3514UL;
   tf->codes[3590] = 0x0000e353cd3d409eUL;
   tf->codes[3591] = 0x0000e354425b4c28UL;
   tf->codes[3592] = 0x0000e354b77957b2UL;
   tf->codes[3593] = 0x0000e354f2085d77UL;
   tf->codes[3594] = 0x0000e3573b9e9729UL;
   tf->codes[3595] = 0x0000e3589af8b9c7UL;
   tf->codes[3596] = 0x0000e358d587bf8cUL;
   tf->codes[3597] = 0x0000e3594aa5cb16UL;
   tf->codes[3598] = 0x0000e359bfc3d6a0UL;
   tf->codes[3599] = 0x0000e359fa52dc65UL;
   tf->codes[3600] = 0x0000e35a6f70e7efUL;
   tf->codes[3601] = 0x0000e35b943c04c8UL;
   tf->codes[3602] = 0x0000e35c095a1052UL;
   tf->codes[3603] = 0x0000e35cf3962766UL;
   tf->codes[3604] = 0x0000e35f3d2c6118UL;
   tf->codes[3605] = 0x0000e360d715897bUL;
   tf->codes[3606] = 0x0000e361fbe0a654UL;
   tf->codes[3607] = 0x0000e363d058d47cUL;
   tf->codes[3608] = 0x0000e3648005e5cbUL;
   tf->codes[3609] = 0x0000e364ba94eb90UL;
   tf->codes[3610] = 0x0000e364f523f155UL;
   tf->codes[3611] = 0x0000e3652fb2f71aUL;
   tf->codes[3612] = 0x0000e366547e13f3UL;
   tf->codes[3613] = 0x0000e367042b2542UL;
   tf->codes[3614] = 0x0000e367ee673c56UL;
   tf->codes[3615] = 0x0000e36c0c75a430UL;
   tf->codes[3616] = 0x0000e36f4047f4f6UL;
   tf->codes[3617] = 0x0000e36feff50645UL;
   tf->codes[3618] = 0x0000e372aea94b81UL;
   tf->codes[3619] = 0x0000e372e9385146UL;
   tf->codes[3620] = 0x0000e37398e56295UL;
   tf->codes[3621] = 0x0000e373d374685aUL;
   tf->codes[3622] = 0x0000e374489273e4UL;
   tf->codes[3623] = 0x0000e374f83f8533UL;
   tf->codes[3624] = 0x0000e37532ce8af8UL;
   tf->codes[3625] = 0x0000e377b6f3ca6fUL;
   tf->codes[3626] = 0x0000e37a008a0421UL;
   tf->codes[3627] = 0x0000e37c84af4398UL;
   tf->codes[3628] = 0x0000e37e592771c0UL;
   tf->codes[3629] = 0x0000e37f436388d4UL;
   tf->codes[3630] = 0x0000e3818cf9c286UL;
   tf->codes[3631] = 0x0000e3823ca6d3d5UL;
   tf->codes[3632] = 0x0000e382b1c4df5fUL;
   tf->codes[3633] = 0x0000e383d68ffc38UL;
   tf->codes[3634] = 0x0000e384111f01fdUL;
   tf->codes[3635] = 0x0000e3844bae07c2UL;
   tf->codes[3636] = 0x0000e3865ab53bafUL;
   tf->codes[3637] = 0x0000e387ba0f5e4dUL;
   tf->codes[3638] = 0x0000e38869bc6f9cUL;
   tf->codes[3639] = 0x0000e389196980ebUL;
   tf->codes[3640] = 0x0000e389c916923aUL;
   tf->codes[3641] = 0x0000e38b2870b4d8UL;
   tf->codes[3642] = 0x0000e38bd81dc627UL;
   tf->codes[3643] = 0x0000e38e5c43059eUL;
   tf->codes[3644] = 0x0000e390e0684515UL;
   tf->codes[3645] = 0x0000e3915586509fUL;
   tf->codes[3646] = 0x0000e3927a516d78UL;
   tf->codes[3647] = 0x0000e392ef6f7902UL;
   tf->codes[3648] = 0x0000e393648d848cUL;
   tf->codes[3649] = 0x0000e393d9ab9016UL;
   tf->codes[3650] = 0x0000e394fe76acefUL;
   tf->codes[3651] = 0x0000e3962341c9c8UL;
   tf->codes[3652] = 0x0000e396d2eedb17UL;
   tf->codes[3653] = 0x0000e398a767093fUL;
   tf->codes[3654] = 0x0000e39a415031a2UL;
   tf->codes[3655] = 0x0000e39b661b4e7bUL;
   tf->codes[3656] = 0x0000e39ba0aa5440UL;
   tf->codes[3657] = 0x0000e39ed47ca506UL;
   tf->codes[3658] = 0x0000e3a06e65cd69UL;
   tf->codes[3659] = 0x0000e3a0a8f4d32eUL;
   tf->codes[3660] = 0x0000e3a158a1e47dUL;
   tf->codes[3661] = 0x0000e3a27d6d0156UL;
   tf->codes[3662] = 0x0000e3a2f28b0ce0UL;
   tf->codes[3663] = 0x0000e3a48c743543UL;
   tf->codes[3664] = 0x0000e3a53c214692UL;
   tf->codes[3665] = 0x0000e3a785b78044UL;
   tf->codes[3666] = 0x0000e3a7fad58bceUL;
   tf->codes[3667] = 0x0000e3aa446bc580UL;
   tf->codes[3668] = 0x0000e3aaf418d6cfUL;
   tf->codes[3669] = 0x0000e3ab2ea7dc94UL;
   tf->codes[3670] = 0x0000e3aba3c5e81eUL;
   tf->codes[3671] = 0x0000e3ae9d09331fUL;
   tf->codes[3672] = 0x0000e3b0ac10670cUL;
   tf->codes[3673] = 0x0000e3b1212e7296UL;
   tf->codes[3674] = 0x0000e3b1964c7e20UL;
   tf->codes[3675] = 0x0000e3b2bb179af9UL;
   tf->codes[3676] = 0x0000e3b2f5a6a0beUL;
   tf->codes[3677] = 0x0000e3b33035a683UL;
   tf->codes[3678] = 0x0000e3b45500c35cUL;
   tf->codes[3679] = 0x0000e3b504add4abUL;
   tf->codes[3680] = 0x0000e3b66407f749UL;
   tf->codes[3681] = 0x0000e3b8ad9e30fbUL;
   tf->codes[3682] = 0x0000e3b8e82d36c0UL;
   tf->codes[3683] = 0x0000e3b922bc3c85UL;
   tf->codes[3684] = 0x0000e3b95d4b424aUL;
   tf->codes[3685] = 0x0000e3baf7346aadUL;
   tf->codes[3686] = 0x0000e3c1244a0674UL;
   tf->codes[3687] = 0x0000e3c15ed90c39UL;
   tf->codes[3688] = 0x0000e3c24915234dUL;
   tf->codes[3689] = 0x0000e3c283a42912UL;
   tf->codes[3690] = 0x0000e3c2be332ed7UL;
   tf->codes[3691] = 0x0000e3c3e2fe4bb0UL;
   tf->codes[3692] = 0x0000e3c4581c573aUL;
   tf->codes[3693] = 0x0000e3c62c948562UL;
   tf->codes[3694] = 0x0000e3c716d09c76UL;
   tf->codes[3695] = 0x0000e3c7515fa23bUL;
   tf->codes[3696] = 0x0000e3c8eb48ca9eUL;
   tf->codes[3697] = 0x0000e3cb6f6e0a15UL;
   tf->codes[3698] = 0x0000e3cba9fd0fdaUL;
   tf->codes[3699] = 0x0000e3cc943926eeUL;
   tf->codes[3700] = 0x0000e3cd43e6383dUL;
   tf->codes[3701] = 0x0000e3d19c83a5dcUL;
   tf->codes[3702] = 0x0000e3d45b37eb18UL;
   tf->codes[3703] = 0x0000e3d6df5d2a8fUL;
   tf->codes[3704] = 0x0000e3d719ec3054UL;
   tf->codes[3705] = 0x0000e3d8b3d558b7UL;
   tf->codes[3706] = 0x0000e3da4dbe811aUL;
   tf->codes[3707] = 0x0000e3da884d86dfUL;
   tf->codes[3708] = 0x0000e3dd0c72c656UL;
   tf->codes[3709] = 0x0000e3e1651033f5UL;
   tf->codes[3710] = 0x0000e3e498e284bbUL;
   tf->codes[3711] = 0x0000e3e4d3718a80UL;
   tf->codes[3712] = 0x0000e3e9a12d03a9UL;
   tf->codes[3713] = 0x0000e3eb3b162c0cUL;
   tf->codes[3714] = 0x0000e3ec25524320UL;
   tf->codes[3715] = 0x0000e3ecd4ff546fUL;
   tf->codes[3716] = 0x0000e3f0f30dbc49UL;
   tf->codes[3717] = 0x0000e3f1682bc7d3UL;
   tf->codes[3718] = 0x0000e3f25267dee7UL;
   tf->codes[3719] = 0x0000e3f4d68d1e5eUL;
   tf->codes[3720] = 0x0000e3f5111c2423UL;
   tf->codes[3721] = 0x0000e3f5863a2fadUL;
   tf->codes[3722] = 0x0000e3f6e594524bUL;
   tf->codes[3723] = 0x0000e3f80a5f6f24UL;
   tf->codes[3724] = 0x0000e3f8ba0c8073UL;
   tf->codes[3725] = 0x0000e3fac913b460UL;
   tf->codes[3726] = 0x0000e3fb3e31bfeaUL;
   tf->codes[3727] = 0x0000e3fbb34fcb74UL;
   tf->codes[3728] = 0x0000e3ff21b121ffUL;
   tf->codes[3729] = 0x0000e4016b475bb1UL;
   tf->codes[3730] = 0x0000e401a5d66176UL;
   tf->codes[3731] = 0x0000e401e065673bUL;
   tf->codes[3732] = 0x0000e402558372c5UL;
   tf->codes[3733] = 0x0000e4029012788aUL;
   tf->codes[3734] = 0x0000e40305308414UL;
   tf->codes[3735] = 0x0000e405fe73cf15UL;
   tf->codes[3736] = 0x0000e406ae20e064UL;
   tf->codes[3737] = 0x0000e407d2ebfd3dUL;
   tf->codes[3738] = 0x0000e408480a08c7UL;
   tf->codes[3739] = 0x0000e408bd281451UL;
   tf->codes[3740] = 0x0000e40a91a04279UL;
   tf->codes[3741] = 0x0000e40b414d53c8UL;
   tf->codes[3742] = 0x0000e40c2b896adcUL;
   tf->codes[3743] = 0x0000e40cdb367c2bUL;
   tf->codes[3744] = 0x0000e40d505487b5UL;
   tf->codes[3745] = 0x0000e40e3a909ec9UL;
   tf->codes[3746] = 0x0000e411a8f1f554UL;
   tf->codes[3747] = 0x0000e412589f06a3UL;
   tf->codes[3748] = 0x0000e41467a63a90UL;
   tf->codes[3749] = 0x0000e41551e251a4UL;
   tf->codes[3750] = 0x0000e41760e98591UL;
   tf->codes[3751] = 0x0000e4193561b3b9UL;
   tf->codes[3752] = 0x0000e41acf4adc1cUL;
   tf->codes[3753] = 0x0000e41c6934047fUL;
   tf->codes[3754] = 0x0000e42345f6b195UL;
   tf->codes[3755] = 0x0000e4238085b75aUL;
   tf->codes[3756] = 0x0000e4246ac1ce6eUL;
   tf->codes[3757] = 0x0000e42813b22abeUL;
   tf->codes[3758] = 0x0000e42a22b95eabUL;
   tf->codes[3759] = 0x0000e42a5d486470UL;
   tf->codes[3760] = 0x0000e42bbca2870eUL;
   tf->codes[3761] = 0x0000e42dcba9bafbUL;
   tf->codes[3762] = 0x0000e4308a5e0037UL;
   tf->codes[3763] = 0x0000e431e9b822d5UL;
   tf->codes[3764] = 0x0000e438c67acfebUL;
   tf->codes[3765] = 0x0000e4393b98db75UL;
   tf->codes[3766] = 0x0000e439b0b6e6ffUL;
   tf->codes[3767] = 0x0000e43a6063f84eUL;
   tf->codes[3768] = 0x0000e43b852f1527UL;
   tf->codes[3769] = 0x0000e43bbfbe1aecUL;
   tf->codes[3770] = 0x0000e43bfa4d20b1UL;
   tf->codes[3771] = 0x0000e43f2e1f7177UL;
   tf->codes[3772] = 0x0000e44052ea8e50UL;
   tf->codes[3773] = 0x0000e441b244b0eeUL;
   tf->codes[3774] = 0x0000e4434c2dd951UL;
   tf->codes[3775] = 0x0000e444e61701b4UL;
   tf->codes[3776] = 0x0000e44595c41303UL;
   tf->codes[3777] = 0x0000e4476a3c412bUL;
   tf->codes[3778] = 0x0000e4490425698eUL;
   tf->codes[3779] = 0x0000e44979437518UL;
   tf->codes[3780] = 0x0000e449b3d27addUL;
   tf->codes[3781] = 0x0000e44a28f08667UL;
   tf->codes[3782] = 0x0000e44b4dbba340UL;
   tf->codes[3783] = 0x0000e44bfd68b48fUL;
   tf->codes[3784] = 0x0000e44c7286c019UL;
   tf->codes[3785] = 0x0000e44d2233d168UL;
   tf->codes[3786] = 0x0000e44fe0e816a4UL;
   tf->codes[3787] = 0x0000e45140423942UL;
   tf->codes[3788] = 0x0000e452da2b61a5UL;
   tf->codes[3789] = 0x0000e454aea38fcdUL;
   tf->codes[3790] = 0x0000e454e9329592UL;
   tf->codes[3791] = 0x0000e4555e50a11cUL;
   tf->codes[3792] = 0x0000e457e275e093UL;
   tf->codes[3793] = 0x0000e4589222f1e2UL;
   tf->codes[3794] = 0x0000e45b16483159UL;
   tf->codes[3795] = 0x0000e45b8b663ce3UL;
   tf->codes[3796] = 0x0000e45fe403aa82UL;
   tf->codes[3797] = 0x0000e467707368e7UL;
   tf->codes[3798] = 0x0000e467e5917471UL;
   tf->codes[3799] = 0x0000e468cfcd8b85UL;
   tf->codes[3800] = 0x0000e4697f7a9cd4UL;
   tf->codes[3801] = 0x0000e46a2f27ae23UL;
   tf->codes[3802] = 0x0000e46aa445b9adUL;
   tf->codes[3803] = 0x0000e46ec2542187UL;
   tf->codes[3804] = 0x0000e46f37722d11UL;
   tf->codes[3805] = 0x0000e46fac90389bUL;
   tf->codes[3806] = 0x0000e4705c3d49eaUL;
   tf->codes[3807] = 0x0000e472e0628961UL;
   tf->codes[3808] = 0x0000e473558094ebUL;
   tf->codes[3809] = 0x0000e4747a4bb1c4UL;
   tf->codes[3810] = 0x0000e4759f16ce9dUL;
   tf->codes[3811] = 0x0000e4768952e5b1UL;
   tf->codes[3812] = 0x0000e477e8ad084fUL;
   tf->codes[3813] = 0x0000e47b919d649fUL;
   tf->codes[3814] = 0x0000e47fea3ad23eUL;
   tf->codes[3815] = 0x0000e48099e7e38dUL;
   tf->codes[3816] = 0x0000e4826e6011b5UL;
   tf->codes[3817] = 0x0000e4852d1456f1UL;
   tf->codes[3818] = 0x0000e487b1399668UL;
   tf->codes[3819] = 0x0000e4882657a1f2UL;
   tf->codes[3820] = 0x0000e4891093b906UL;
   tf->codes[3821] = 0x0000e489c040ca55UL;
   tf->codes[3822] = 0x0000e48ae50be72eUL;
   tf->codes[3823] = 0x0000e48b1f9aecf3UL;
   tf->codes[3824] = 0x0000e48b94b8f87dUL;
   tf->codes[3825] = 0x0000e48cf4131b1bUL;
   tf->codes[3826] = 0x0000e48f78385a92UL;
   tf->codes[3827] = 0x0000e491122182f5UL;
   tf->codes[3828] = 0x0000e4914cb088baUL;
   tf->codes[3829] = 0x0000e4939646c26cUL;
   tf->codes[3830] = 0x0000e494bb11df45UL;
   tf->codes[3831] = 0x0000e494f5a0e50aUL;
   tf->codes[3832] = 0x0000e4956abef094UL;
   tf->codes[3833] = 0x0000e496ca191332UL;
   tf->codes[3834] = 0x0000e49704a818f7UL;
   tf->codes[3835] = 0x0000e497b4552a46UL;
   tf->codes[3836] = 0x0000e4989e91415aUL;
   tf->codes[3837] = 0x0000e498d920471fUL;
   tf->codes[3838] = 0x0000e499fdeb63f8UL;
   tf->codes[3839] = 0x0000e49b5d458696UL;
   tf->codes[3840] = 0x0000e49cf72eaef9UL;
   tf->codes[3841] = 0x0000e49e5688d197UL;
   tf->codes[3842] = 0x0000e4a0daae110eUL;
   tf->codes[3843] = 0x0000e4a1c4ea2822UL;
   tf->codes[3844] = 0x0000e4a324444ac0UL;
   tf->codes[3845] = 0x0000e4a39962564aUL;
   tf->codes[3846] = 0x0000e4a4f8bc78e8UL;
   tf->codes[3847] = 0x0000e4a5a8698a37UL;
   tf->codes[3848] = 0x0000e4a6cd34a710UL;
   tf->codes[3849] = 0x0000e4a77ce1b85fUL;
   tf->codes[3850] = 0x0000e4a7f1ffc3e9UL;
   tf->codes[3851] = 0x0000e4abd57f25feUL;
   tf->codes[3852] = 0x0000e4ac852c374dUL;
   tf->codes[3853] = 0x0000e4af7e6f824eUL;
   tf->codes[3854] = 0x0000e4aff38d8dd8UL;
   tf->codes[3855] = 0x0000e4b02e1c939dUL;
   tf->codes[3856] = 0x0000e4b068ab9962UL;
   tf->codes[3857] = 0x0000e4b0a33a9f27UL;
   tf->codes[3858] = 0x0000e4b18d76b63bUL;
   tf->codes[3859] = 0x0000e4b3275fde9eUL;
   tf->codes[3860] = 0x0000e4b4119bf5b2UL;
   tf->codes[3861] = 0x0000e4b65b322f64UL;
   tf->codes[3862] = 0x0000e4b7f51b57c7UL;
   tf->codes[3863] = 0x0000e4b86a396351UL;
   tf->codes[3864] = 0x0000e4b8a4c86916UL;
   tf->codes[3865] = 0x0000e4baee5ea2c8UL;
   tf->codes[3866] = 0x0000e4bb9e0bb417UL;
   tf->codes[3867] = 0x0000e4bc1329bfa1UL;
   tf->codes[3868] = 0x0000e4bc4db8c566UL;
   tf->codes[3869] = 0x0000e4c03138277bUL;
   tf->codes[3870] = 0x0000e4c11b743e8fUL;
   tf->codes[3871] = 0x0000e4c156034454UL;
   tf->codes[3872] = 0x0000e4c2403f5b68UL;
   tf->codes[3873] = 0x0000e4c2b55d66f2UL;
   tf->codes[3874] = 0x0000e4c32a7b727cUL;
   tf->codes[3875] = 0x0000e4c3650a7841UL;
   tf->codes[3876] = 0x0000e4c44f468f55UL;
   tf->codes[3877] = 0x0000e4c4c4649adfUL;
   tf->codes[3878] = 0x0000e4c86d54f72fUL;
   tf->codes[3879] = 0x0000e4c8a7e3fcf4UL;
   tf->codes[3880] = 0x0000e4ca7c5c2b1cUL;
   tf->codes[3881] = 0x0000e4cb66984230UL;
   tf->codes[3882] = 0x0000e4cc1645537fUL;
   tf->codes[3883] = 0x0000e4cd00816a93UL;
   tf->codes[3884] = 0x0000e4d1ce3ce3bcUL;
   tf->codes[3885] = 0x0000e4d2b878fad0UL;
   tf->codes[3886] = 0x0000e4d2f3080095UL;
   tf->codes[3887] = 0x0000e4d3a2b511e4UL;
   tf->codes[3888] = 0x0000e4d3dd4417a9UL;
   tf->codes[3889] = 0x0000e4d5020f3482UL;
   tf->codes[3890] = 0x0000e4d5772d400cUL;
   tf->codes[3891] = 0x0000e4d5b1bc45d1UL;
   tf->codes[3892] = 0x0000e4d69bf85ce5UL;
   tf->codes[3893] = 0x0000e4d6d68762aaUL;
   tf->codes[3894] = 0x0000e4d7fb527f83UL;
   tf->codes[3895] = 0x0000e4d8aaff90d2UL;
   tf->codes[3896] = 0x0000e4d8e58e9697UL;
   tf->codes[3897] = 0x0000e4d95aaca221UL;
   tf->codes[3898] = 0x0000e4daf495ca84UL;
   tf->codes[3899] = 0x0000e4df12a4325eUL;
   tf->codes[3900] = 0x0000e4df4d333823UL;
   tf->codes[3901] = 0x0000e4dfc25143adUL;
   tf->codes[3902] = 0x0000e4e071fe54fcUL;
   tf->codes[3903] = 0x0000e4e196c971d5UL;
   tf->codes[3904] = 0x0000e4e246768324UL;
   tf->codes[3905] = 0x0000e4e2bb948eaeUL;
   tf->codes[3906] = 0x0000e4e330b29a38UL;
   tf->codes[3907] = 0x0000e4e69f13f0c3UL;
   tf->codes[3908] = 0x0000e4e7fe6e1361UL;
   tf->codes[3909] = 0x0000e4ea0d75474eUL;
   tf->codes[3910] = 0x0000e4ea829352d8UL;
   tf->codes[3911] = 0x0000e4eabd22589dUL;
   tf->codes[3912] = 0x0000e4ee6612b4edUL;
   tf->codes[3913] = 0x0000e4f4cdb75679UL;
   tf->codes[3914] = 0x0000e4f508465c3eUL;
   tf->codes[3915] = 0x0000e4f5f2827352UL;
   tf->codes[3916] = 0x0000e4f6dcbe8a66UL;
   tf->codes[3917] = 0x0000e4f8b136b88eUL;
   tf->codes[3918] = 0x0000e4f960e3c9ddUL;
   tf->codes[3919] = 0x0000e4f99b72cfa2UL;
   tf->codes[3920] = 0x0000e4fa4b1fe0f1UL;
   tf->codes[3921] = 0x0000e4fea3bd4e90UL;
   tf->codes[3922] = 0x0000e5019d009991UL;
   tf->codes[3923] = 0x0000e502121ea51bUL;
   tf->codes[3924] = 0x0000e502873cb0a5UL;
   tf->codes[3925] = 0x0000e5037178c7b9UL;
   tf->codes[3926] = 0x0000e503e696d343UL;
   tf->codes[3927] = 0x0000e5042125d908UL;
   tf->codes[3928] = 0x0000e50545f0f5e1UL;
   tf->codes[3929] = 0x0000e506302d0cf5UL;
   tf->codes[3930] = 0x0000e5083f3440e2UL;
   tf->codes[3931] = 0x0000e509d91d6945UL;
   tf->codes[3932] = 0x0000e50a4e3b74cfUL;
   tf->codes[3933] = 0x0000e50b730691a8UL;
   tf->codes[3934] = 0x0000e50d820dc595UL;
   tf->codes[3935] = 0x0000e510f06f1c20UL;
   tf->codes[3936] = 0x0000e5112afe21e5UL;
   tf->codes[3937] = 0x0000e5124fc93ebeUL;
   tf->codes[3938] = 0x0000e513e9b26721UL;
   tf->codes[3939] = 0x0000e515490c89bfUL;
   tf->codes[3940] = 0x0000e519671af199UL;
   tf->codes[3941] = 0x0000e51ac6751437UL;
   tf->codes[3942] = 0x0000e51b76222586UL;
   tf->codes[3943] = 0x0000e51ee4837c11UL;
   tf->codes[3944] = 0x0000e520094e98eaUL;
   tf->codes[3945] = 0x0000e521a337c14dUL;
   tf->codes[3946] = 0x0000e5228d73d861UL;
   tf->codes[3947] = 0x0000e52461ec0689UL;
   tf->codes[3948] = 0x0000e5249c7b0c4eUL;
   tf->codes[3949] = 0x0000e524d70a1213UL;
   tf->codes[3950] = 0x0000e5292fa77fb2UL;
   tf->codes[3951] = 0x0000e52cd897dc02UL;
   tf->codes[3952] = 0x0000e52ee79f0fefUL;
   tf->codes[3953] = 0x0000e530bc173e17UL;
   tf->codes[3954] = 0x0000e531313549a1UL;
   tf->codes[3955] = 0x0000e5321b7160b5UL;
   tf->codes[3956] = 0x0000e5337acb8353UL;
   tf->codes[3957] = 0x0000e5349f96a02cUL;
   tf->codes[3958] = 0x0000e53514b4abb6UL;
   tf->codes[3959] = 0x0000e53883160241UL;
   tf->codes[3960] = 0x0000e538bda50806UL;
   tf->codes[3961] = 0x0000e53ca1246a1bUL;
   tf->codes[3962] = 0x0000e53f9a67b51cUL;
   tf->codes[3963] = 0x0000e540bf32d1f5UL;
   tf->codes[3964] = 0x0000e541a96ee909UL;
   tf->codes[3965] = 0x0000e542591bfa58UL;
   tf->codes[3966] = 0x0000e543f30522bbUL;
   tf->codes[3967] = 0x0000e547d68484d0UL;
   tf->codes[3968] = 0x0000e549e58bb8bdUL;
   tf->codes[3969] = 0x0000e54bba03e6e5UL;
   tf->codes[3970] = 0x0000e54c69b0f834UL;
   tf->codes[3971] = 0x0000e550c24e65d3UL;
   tf->codes[3972] = 0x0000e551ac8a7ce7UL;
   tf->codes[3973] = 0x0000e551e71982acUL;
   tf->codes[3974] = 0x0000e553bb91b0d4UL;
   tf->codes[3975] = 0x0000e554a5cdc7e8UL;
   tf->codes[3976] = 0x0000e555557ad937UL;
   tf->codes[3977] = 0x0000e555ca98e4c1UL;
   tf->codes[3978] = 0x0000e556ef64019aUL;
   tf->codes[3979] = 0x0000e558142f1e73UL;
   tf->codes[3980] = 0x0000e55973894111UL;
   tf->codes[3981] = 0x0000e55b829074feUL;
   tf->codes[3982] = 0x0000e56015bce862UL;
   tf->codes[3983] = 0x0000e5613a88053bUL;
   tf->codes[3984] = 0x0000e563498f3928UL;
   tf->codes[3985] = 0x0000e563f93c4a77UL;
   tf->codes[3986] = 0x0000e56642d28429UL;
   tf->codes[3987] = 0x0000e5667d6189eeUL;
   tf->codes[3988] = 0x0000e566f27f9578UL;
   tf->codes[3989] = 0x0000e567679da102UL;
   tf->codes[3990] = 0x0000e5690186c965UL;
   tf->codes[3991] = 0x0000e56b4b1d0317UL;
   tf->codes[3992] = 0x0000e56bc03b0ea1UL;
   tf->codes[3993] = 0x0000e57053678205UL;
   tf->codes[3994] = 0x0000e5755bb200f3UL;
   tf->codes[3995] = 0x0000e576f59b2956UL;
   tf->codes[3996] = 0x0000e57b4e3896f5UL;
   tf->codes[3997] = 0x0000e57d97ced0a7UL;
   tf->codes[3998] = 0x0000e57f31b7f90aUL;
   tf->codes[3999] = 0x0000e580cba1216dUL;
   tf->codes[4000] = 0x0000e58106302732UL;
   tf->codes[4001] = 0x0000e5817b4e32bcUL;
   tf->codes[4002] = 0x0000e581b5dd3881UL;
   tf->codes[4003] = 0x0000e58315375b1fUL;
   tf->codes[4004] = 0x0000e5843a0277f8UL;
   tf->codes[4005] = 0x0000e5864909abe5UL;
   tf->codes[4006] = 0x0000e586be27b76fUL;
   tf->codes[4007] = 0x0000e588cd2eeb5cUL;
   tf->codes[4008] = 0x0000e58b51542ad3UL;
   tf->codes[4009] = 0x0000e58efa448723UL;
   tf->codes[4010] = 0x0000e58fa9f19872UL;
   tf->codes[4011] = 0x0000e592a334e373UL;
   tf->codes[4012] = 0x0000e593c800004cUL;
   tf->codes[4013] = 0x0000e59477ad119bUL;
   tf->codes[4014] = 0x0000e595275a22eaUL;
   tf->codes[4015] = 0x0000e59686b44588UL;
   tf->codes[4016] = 0x0000e596c1434b4dUL;
   tf->codes[4017] = 0x0000e597e60e6826UL;
   tf->codes[4018] = 0x0000e59a6a33a79dUL;
   tf->codes[4019] = 0x0000e59f37ef20c6UL;
   tf->codes[4020] = 0x0000e59fad0d2c50UL;
   tf->codes[4021] = 0x0000e59fe79c3215UL;
   tf->codes[4022] = 0x0000e5a146f654b3UL;
   tf->codes[4023] = 0x0000e5a1bc14603dUL;
   tf->codes[4024] = 0x0000e5a1f6a36602UL;
   tf->codes[4025] = 0x0000e5a231326bc7UL;
   tf->codes[4026] = 0x0000e5a31b6e82dbUL;
   tf->codes[4027] = 0x0000e5a3908c8e65UL;
   tf->codes[4028] = 0x0000e5a4efe6b103UL;
   tf->codes[4029] = 0x0000e5a6feede4f0UL;
   tf->codes[4030] = 0x0000e5a9f8312ff1UL;
   tf->codes[4031] = 0x0000e5aa6d4f3b7bUL;
   tf->codes[4032] = 0x0000e5ab1cfc4ccaUL;
   tf->codes[4033] = 0x0000e5af007baedfUL;
   tf->codes[4034] = 0x0000e5afeab7c5f3UL;
   tf->codes[4035] = 0x0000e5b10f82e2ccUL;
   tf->codes[4036] = 0x0000e5b359191c7eUL;
   tf->codes[4037] = 0x0000e5b393a82243UL;
   tf->codes[4038] = 0x0000e5b3ce372808UL;
   tf->codes[4039] = 0x0000e5b443553392UL;
   tf->codes[4040] = 0x0000e5b5dd3e5bf5UL;
   tf->codes[4041] = 0x0000e5b6525c677fUL;
   tf->codes[4042] = 0x0000e5b6c77a7309UL;
   tf->codes[4043] = 0x0000e5b94b9fb280UL;
   tf->codes[4044] = 0x0000e5b9862eb845UL;
   tf->codes[4045] = 0x0000e5bae588dae3UL;
   tf->codes[4046] = 0x0000e5bb2017e0a8UL;
   tf->codes[4047] = 0x0000e5bb9535ec32UL;
   tf->codes[4048] = 0x0000e5bcf4900ed0UL;
   tf->codes[4049] = 0x0000e5c14d2d7c6fUL;
   tf->codes[4050] = 0x0000e5c1c24b87f9UL;
   tf->codes[4051] = 0x0000e5c35c34b05cUL;
   tf->codes[4052] = 0x0000e5c396c3b621UL;
   tf->codes[4053] = 0x0000e5c3d152bbe6UL;
   tf->codes[4054] = 0x0000e5c4f61dd8bfUL;
   tf->codes[4055] = 0x0000e5c61ae8f598UL;
   tf->codes[4056] = 0x0000e5c690070122UL;
   tf->codes[4057] = 0x0000e5c9142c4099UL;
   tf->codes[4058] = 0x0000e5c9fe6857adUL;
   tf->codes[4059] = 0x0000e5ca73866337UL;
   tf->codes[4060] = 0x0000e5ccf7aba2aeUL;
   tf->codes[4061] = 0x0000e5ce5705c54cUL;
   tf->codes[4062] = 0x0000e5ce9194cb11UL;
   tf->codes[4063] = 0x0000e5d2afa332ebUL;
   tf->codes[4064] = 0x0000e5d2ea3238b0UL;
   tf->codes[4065] = 0x0000e5d35f50443aUL;
   tf->codes[4066] = 0x0000e5d4f9396c9dUL;
   tf->codes[4067] = 0x0000e5d6cdb19ac5UL;
   tf->codes[4068] = 0x0000e5d77d5eac14UL;
   tf->codes[4069] = 0x0000e5d7f27cb79eUL;
   tf->codes[4070] = 0x0000e5d8a229c8edUL;
   tf->codes[4071] = 0x0000e5de5a21592aUL;
   tf->codes[4072] = 0x0000e5dff40a818dUL;
   tf->codes[4073] = 0x0000e5e2782fc104UL;
   tf->codes[4074] = 0x0000e5e2b2bec6c9UL;
   tf->codes[4075] = 0x0000e5e65baf2319UL;
   tf->codes[4076] = 0x0000e5e86ab65706UL;
   tf->codes[4077] = 0x0000e5eb9e88a7ccUL;
   tf->codes[4078] = 0x0000e5ef820809e1UL;
   tf->codes[4079] = 0x0000e5f06c4420f5UL;
   tf->codes[4080] = 0x0000e5f1910f3dceUL;
   tf->codes[4081] = 0x0000e5f27b4b54e2UL;
   tf->codes[4082] = 0x0000e5f2f069606cUL;
   tf->codes[4083] = 0x0000e5f365876bf6UL;
   tf->codes[4084] = 0x0000e5f4ff709459UL;
   tf->codes[4085] = 0x0000e5f5748e9fe3UL;
   tf->codes[4086] = 0x0000e5f7be24d995UL;
   tf->codes[4087] = 0x0000e5f8e2eff66eUL;
   tf->codes[4088] = 0x0000e5fba1a43baaUL;
   tf->codes[4089] = 0x0000e5fc51514cf9UL;
   tf->codes[4090] = 0x0000e5fe25c97b21UL;
   tf->codes[4091] = 0x0000e5ff10059235UL;
   tf->codes[4092] = 0x0000e60034d0af0eUL;
   tf->codes[4093] = 0x0000e6027e66e8c0UL;
   tf->codes[4094] = 0x0000e60418501123UL;
   tf->codes[4095] = 0x0000e605b2393986UL;
   tf->codes[4096] = 0x0000e605ecc83f4bUL;
   tf->codes[4097] = 0x0000e6069c75509aUL;
   tf->codes[4098] = 0x0000e607fbcf7338UL;
   tf->codes[4099] = 0x0000e60870ed7ec2UL;
   tf->codes[4100] = 0x0000e6095b2995d6UL;
   tf->codes[4101] = 0x0000e60aba83b874UL;
   tf->codes[4102] = 0x0000e60b2fa1c3feUL;
   tf->codes[4103] = 0x0000e60c546ce0d7UL;
   tf->codes[4104] = 0x0000e60e637414c4UL;
   tf->codes[4105] = 0x0000e60ed892204eUL;
   tf->codes[4106] = 0x0000e6115cb75fc5UL;
   tf->codes[4107] = 0x0000e612bc118263UL;
   tf->codes[4108] = 0x0000e61455faaac6UL;
   tf->codes[4109] = 0x0000e6149089b08bUL;
   tf->codes[4110] = 0x0000e614cb18b650UL;
   tf->codes[4111] = 0x0000e6157ac5c79fUL;
   tf->codes[4112] = 0x0000e615b554cd64UL;
   tf->codes[4113] = 0x0000e61714aef002UL;
   tf->codes[4114] = 0x0000e618740912a0UL;
   tf->codes[4115] = 0x0000e61a8310468dUL;
   tf->codes[4116] = 0x0000e61c1cf96ef0UL;
   tf->codes[4117] = 0x0000e61d41c48bc9UL;
   tf->codes[4118] = 0x0000e61d7c53918eUL;
   tf->codes[4119] = 0x0000e61edbadb42cUL;
   tf->codes[4120] = 0x0000e620b025e254UL;
   tf->codes[4121] = 0x0000e623344b21cbUL;
   tf->codes[4122] = 0x0000e623a9692d55UL;
   tf->codes[4123] = 0x0000e624ce344a2eUL;
   tf->codes[4124] = 0x0000e6262d8e6cccUL;
   tf->codes[4125] = 0x0000e626a2ac7856UL;
   tf->codes[4126] = 0x0000e629d67ec91cUL;
   tf->codes[4127] = 0x0000e6387a403a5cUL;
   tf->codes[4128] = 0x0000e63b7383855dUL;
   tf->codes[4129] = 0x0000e63be8a190e7UL;
   tf->codes[4130] = 0x0000e6412b7b159aUL;
   tf->codes[4131] = 0x0000e64584188339UL;
   tf->codes[4132] = 0x0000e645f9368ec3UL;
   tf->codes[4133] = 0x0000e646a8e3a012UL;
   tf->codes[4134] = 0x0000e64ac6f207ecUL;
   tf->codes[4135] = 0x0000e64fcf3c86daUL;
   tf->codes[4136] = 0x0000e6507ee99829UL;
   tf->codes[4137] = 0x0000e650f407a3b3UL;
   tf->codes[4138] = 0x0000e65218d2c08cUL;
   tf->codes[4139] = 0x0000e653030ed7a0UL;
   tf->codes[4140] = 0x0000e653ed4aeeb4UL;
   tf->codes[4141] = 0x0000e654d78705c8UL;
   tf->codes[4142] = 0x0000e65671702e2bUL;
   tf->codes[4143] = 0x0000e65845e85c53UL;
   tf->codes[4144] = 0x0000e65a8f7e9605UL;
   tf->codes[4145] = 0x0000e65bb449b2deUL;
   tf->codes[4146] = 0x0000e65d4e32db41UL;
   tf->codes[4147] = 0x0000e65ee81c03a4UL;
   tf->codes[4148] = 0x0000e660bc9431ccUL;
   tf->codes[4149] = 0x0000e66340b97143UL;
   tf->codes[4150] = 0x0000e663f0668292UL;
   tf->codes[4151] = 0x0000e664a01393e1UL;
   tf->codes[4152] = 0x0000e66639fcbc44UL;
   tf->codes[4153] = 0x0000e6675ec7d91dUL;
   tf->codes[4154] = 0x0000e66a1d7c1e59UL;
   tf->codes[4155] = 0x0000e66d16bf695aUL;
   tf->codes[4156] = 0x0000e670bfafc5aaUL;
   tf->codes[4157] = 0x0000e670fa3ecb6fUL;
   tf->codes[4158] = 0x0000e6716f5cd6f9UL;
   tf->codes[4159] = 0x0000e67343d50521UL;
   tf->codes[4160] = 0x0000e675184d3349UL;
   tf->codes[4161] = 0x0000e67602894a5dUL;
   tf->codes[4162] = 0x0000e67d546a02fdUL;
   tf->codes[4163] = 0x0000e68172786ad7UL;
   tf->codes[4164] = 0x0000e683817f9ec4UL;
   tf->codes[4165] = 0x0000e683bc0ea489UL;
   tf->codes[4166] = 0x0000e684312cb013UL;
   tf->codes[4167] = 0x0000e684a64abb9dUL;
   tf->codes[4168] = 0x0000e685cb15d876UL;
   tf->codes[4169] = 0x0000e689e9244050UL;
   tf->codes[4170] = 0x0000e68b487e62eeUL;
   tf->codes[4171] = 0x0000e68ca7d8858cUL;
   tf->codes[4172] = 0x0000e68fdbaad652UL;
   tf->codes[4173] = 0x0000e690c5e6ed66UL;
   tf->codes[4174] = 0x0000e6929a5f1b8eUL;
   tf->codes[4175] = 0x0000e693849b32a2UL;
   tf->codes[4176] = 0x0000e693bf2a3867UL;
   tf->codes[4177] = 0x0000e69608c07219UL;
   tf->codes[4178] = 0x0000e696f2fc892dUL;
   tf->codes[4179] = 0x0000e6972d8b8ef2UL;
   tf->codes[4180] = 0x0000e697681a94b7UL;
   tf->codes[4181] = 0x0000e697dd38a041UL;
   tf->codes[4182] = 0x0000e69ad67beb42UL;
   tf->codes[4183] = 0x0000e6a08e737b7fUL;
   tf->codes[4184] = 0x0000e6a2d809b531UL;
   tf->codes[4185] = 0x0000e6a4ac81e359UL;
   tf->codes[4186] = 0x0000e6a6466b0bbcUL;
   tf->codes[4187] = 0x0000e6a76b362895UL;
   tf->codes[4188] = 0x0000e6a7e054341fUL;
   tf->codes[4189] = 0x0000e6a89001456eUL;
   tf->codes[4190] = 0x0000e6a93fae56bdUL;
   tf->codes[4191] = 0x0000e6ab8944906fUL;
   tf->codes[4192] = 0x0000e6ace89eb30dUL;
   tf->codes[4193] = 0x0000e6b01c7103d3UL;
   tf->codes[4194] = 0x0000e6b0918f0f5dUL;
   tf->codes[4195] = 0x0000e6b0cc1e1522UL;
   tf->codes[4196] = 0x0000e6b1413c20acUL;
   tf->codes[4197] = 0x0000e6b3fff065e8UL;
   tf->codes[4198] = 0x0000e6b43a7f6badUL;
   tf->codes[4199] = 0x0000e6b4750e7172UL;
   tf->codes[4200] = 0x0000e6ba67950774UL;
   tf->codes[4201] = 0x0000e6badcb312feUL;
   tf->codes[4202] = 0x0000e6c01f8c97b1UL;
   tf->codes[4203] = 0x0000e6c0cf39a900UL;
   tf->codes[4204] = 0x0000e6c3c87cf401UL;
   tf->codes[4205] = 0x0000e6c4ed4810daUL;
   tf->codes[4206] = 0x0000e6c68731393dUL;
   tf->codes[4207] = 0x0000e6c736de4a8cUL;
   tf->codes[4208] = 0x0000e6c7abfc5616UL;
   tf->codes[4209] = 0x0000e6c9bb038a03UL;
   tf->codes[4210] = 0x0000e6ca6ab09b52UL;
   tf->codes[4211] = 0x0000e6cc3f28c97aUL;
   tf->codes[4212] = 0x0000e6cc79b7cf3fUL;
   tf->codes[4213] = 0x0000e6ccb446d504UL;
   tf->codes[4214] = 0x0000e6cf386c147bUL;
   tf->codes[4215] = 0x0000e6cfad8a2005UL;
   tf->codes[4216] = 0x0000e6d10ce442a3UL;
   tf->codes[4217] = 0x0000e6d7af17e9f4UL;
   tf->codes[4218] = 0x0000e6d82435f57eUL;
   tf->codes[4219] = 0x0000e6d85ec4fb43UL;
   tf->codes[4220] = 0x0000e6d949011257UL;
   tf->codes[4221] = 0x0000e6dddc2d85bbUL;
   tf->codes[4222] = 0x0000e6e234caf35aUL;
   tf->codes[4223] = 0x0000e6e26f59f91fUL;
   tf->codes[4224] = 0x0000e6e2e47804a9UL;
   tf->codes[4225] = 0x0000e6e359961033UL;
   tf->codes[4226] = 0x0000e6e443d22747UL;
   tf->codes[4227] = 0x0000e6e861e08f21UL;
   tf->codes[4228] = 0x0000e6e89c6f94e6UL;
   tf->codes[4229] = 0x0000e6f0636e5910UL;
   tf->codes[4230] = 0x0000e6f1c2c87baeUL;
   tf->codes[4231] = 0x0000e6f237e68738UL;
   tf->codes[4232] = 0x0000e6f4817cc0eaUL;
   tf->codes[4233] = 0x0000e6f53129d239UL;
   tf->codes[4234] = 0x0000e6f7b54f11b0UL;
   tf->codes[4235] = 0x0000e6fecca0c48bUL;
   tf->codes[4236] = 0x0000e703253e322aUL;
   tf->codes[4237] = 0x0000e7040f7a493eUL;
   tf->codes[4238] = 0x0000e70917c4c82cUL;
   tf->codes[4239] = 0x0000e70c86261eb7UL;
   tf->codes[4240] = 0x0000e70e952d52a4UL;
   tf->codes[4241] = 0x0000e710a4348691UL;
   tf->codes[4242] = 0x0000e713d806d757UL;
   tf->codes[4243] = 0x0000e7141295dd1cUL;
   tf->codes[4244] = 0x0000e7144d24e2e1UL;
   tf->codes[4245] = 0x0000e714fcd1f430UL;
   tf->codes[4246] = 0x0000e715ac7f057fUL;
   tf->codes[4247] = 0x0000e7165c2c16ceUL;
   tf->codes[4248] = 0x0000e718e0515645UL;
   tf->codes[4249] = 0x0000e7198ffe6794UL;
   tf->codes[4250] = 0x0000e71a7a3a7ea8UL;
   tf->codes[4251] = 0x0000e71ab4c9846dUL;
   tf->codes[4252] = 0x0000e71b29e78ff7UL;
   tf->codes[4253] = 0x0000e71b647695bcUL;
   tf->codes[4254] = 0x0000e71f0d66f20cUL;
   tf->codes[4255] = 0x0000e720a7501a6fUL;
   tf->codes[4256] = 0x0000e7232b7559e6UL;
   tf->codes[4257] = 0x0000e723db226b35UL;
   tf->codes[4258] = 0x0000e724504076bfUL;
   tf->codes[4259] = 0x0000e72624b8a4e7UL;
   tf->codes[4260] = 0x0000e7274983c1c0UL;
   tf->codes[4261] = 0x0000e72b6792299aUL;
   tf->codes[4262] = 0x0000e72c173f3ae9UL;
   tf->codes[4263] = 0x0000e72fc02f9739UL;
   tf->codes[4264] = 0x0000e73418cd04d8UL;
   tf->codes[4265] = 0x0000e73578272776UL;
   tf->codes[4266] = 0x0000e73712104fd9UL;
   tf->codes[4267] = 0x0000e737872e5b63UL;
   tf->codes[4268] = 0x0000e737fc4c66edUL;
   tf->codes[4269] = 0x0000e739211783c6UL;
   tf->codes[4270] = 0x0000e73abb00ac29UL;
   tf->codes[4271] = 0x0000e73f139e19c8UL;
   tf->codes[4272] = 0x0000e74072f83c66UL;
   tf->codes[4273] = 0x0000e740e81647f0UL;
   tf->codes[4274] = 0x0000e7436c3b8767UL;
   tf->codes[4275] = 0x0000e7449106a440UL;
   tf->codes[4276] = 0x0000e7450624afcaUL;
   tf->codes[4277] = 0x0000e74ea19ba21cUL;
   tf->codes[4278] = 0x0000e752fa390fbbUL;
   tf->codes[4279] = 0x0000e7536f571b45UL;
   tf->codes[4280] = 0x0000e753e47526cfUL;
   tf->codes[4281] = 0x0000e755094043a8UL;
   tf->codes[4282] = 0x0000e756ddb871d0UL;
   tf->codes[4283] = 0x0000e7583d12946eUL;
   tf->codes[4284] = 0x0000e758ecbfa5bdUL;
   tf->codes[4285] = 0x0000e75ac137d3e5UL;
   tf->codes[4286] = 0x0000e75bab73eaf9UL;
   tf->codes[4287] = 0x0000e75c5b20fc48UL;
   tf->codes[4288] = 0x0000e75e6a283035UL;
   tf->codes[4289] = 0x0000e7624da7924aUL;
   tf->codes[4290] = 0x0000e7628836980fUL;
   tf->codes[4291] = 0x0000e76337e3a95eUL;
   tf->codes[4292] = 0x0000e763ad01b4e8UL;
   tf->codes[4293] = 0x0000e765bc08e8d5UL;
   tf->codes[4294] = 0x0000e768402e284cUL;
   tf->codes[4295] = 0x0000e76ac45367c3UL;
   tf->codes[4296] = 0x0000e76e6d43c413UL;
   tf->codes[4297] = 0x0000e76f920ee0ecUL;
   tf->codes[4298] = 0x0000e7712bf8094fUL;
   tf->codes[4299] = 0x0000e77166870f14UL;
   tf->codes[4300] = 0x0000e771a11614d9UL;
   tf->codes[4301] = 0x0000e773b01d48c6UL;
   tf->codes[4302] = 0x0000e7796814d903UL;
   tf->codes[4303] = 0x0000e77ee57d637bUL;
   tf->codes[4304] = 0x0000e7800a488054UL;
   tf->codes[4305] = 0x0000e7807f668bdeUL;
   tf->codes[4306] = 0x0000e78169a2a2f2UL;
   tf->codes[4307] = 0x0000e7833e1ad11aUL;
   tf->codes[4308] = 0x0000e783b338dca4UL;
   tf->codes[4309] = 0x0000e78846655008UL;
   tf->codes[4310] = 0x0000e788f6126157UL;
   tf->codes[4311] = 0x0000e78930a1671cUL;
   tf->codes[4312] = 0x0000e78aca8a8f7fUL;
   tf->codes[4313] = 0x0000e78dc3cdda80UL;
   tf->codes[4314] = 0x0000e78f5db702e3UL;
   tf->codes[4315] = 0x0000e790f7a02b46UL;
   tf->codes[4316] = 0x0000e794db1f8d5bUL;
   tf->codes[4317] = 0x0000e795503d98e5UL;
   tf->codes[4318] = 0x0000e797d462d85cUL;
   tf->codes[4319] = 0x0000e79d51cb62d4UL;
   tf->codes[4320] = 0x0000e79f9b619c86UL;
   tf->codes[4321] = 0x0000e7a0859db39aUL;
   tf->codes[4322] = 0x0000e7a1354ac4e9UL;
   tf->codes[4323] = 0x0000e7a25a15e1c2UL;
   tf->codes[4324] = 0x0000e7a294a4e787UL;
   tf->codes[4325] = 0x0000e7a34451f8d6UL;
   tf->codes[4326] = 0x0000e7a603063e12UL;
   tf->codes[4327] = 0x0000e7a97167949dUL;
   tf->codes[4328] = 0x0000e7abf58cd414UL;
   tf->codes[4329] = 0x0000e7ac301bd9d9UL;
   tf->codes[4330] = 0x0000e7aeb4411950UL;
   tf->codes[4331] = 0x0000e7b04e2a41b3UL;
   tf->codes[4332] = 0x0000e7b088b94778UL;
   tf->codes[4333] = 0x0000e7b1386658c7UL;
   tf->codes[4334] = 0x0000e7b5cb92cc2bUL;
   tf->codes[4335] = 0x0000e7b640b0d7b5UL;
   tf->codes[4336] = 0x0000e7b7a00afa53UL;
   tf->codes[4337] = 0x0000e7b97483287bUL;
   tf->codes[4338] = 0x0000e7bb48fb56a3UL;
   tf->codes[4339] = 0x0000e7bf6709be7dUL;
   tf->codes[4340] = 0x0000e7bfdc27ca07UL;
   tf->codes[4341] = 0x0000e7c0c663e11bUL;
   tf->codes[4342] = 0x0000e7c385182657UL;
   tf->codes[4343] = 0x0000e7c72e0882a7UL;
   tf->codes[4344] = 0x0000e7c76897886cUL;
   tf->codes[4345] = 0x0000e7c88d62a545UL;
   tf->codes[4346] = 0x0000e7ca61dad36dUL;
   tf->codes[4347] = 0x0000e7cb1187e4bcUL;
   tf->codes[4348] = 0x0000e7cb4c16ea81UL;
   tf->codes[4349] = 0x0000e7cb86a5f046UL;
   tf->codes[4350] = 0x0000e7cbfbc3fbd0UL;
   tf->codes[4351] = 0x0000e7cd208f18a9UL;
   tf->codes[4352] = 0x0000e7ce7fe93b47UL;
   tf->codes[4353] = 0x0000e7ceba78410cUL;
   tf->codes[4354] = 0x0000e7d731241685UL;
   tf->codes[4355] = 0x0000e7df32b1e074UL;
   tf->codes[4356] = 0x0000e7e0577cfd4dUL;
   tf->codes[4357] = 0x0000e7e0cc9b08d7UL;
   tf->codes[4358] = 0x0000e7e17c481a26UL;
   tf->codes[4359] = 0x0000e7e26684313aUL;
   tf->codes[4360] = 0x0000e7e350c0484eUL;
   tf->codes[4361] = 0x0000e7e8590ac73cUL;
   tf->codes[4362] = 0x0000e7e9b864e9daUL;
   tf->codes[4363] = 0x0000e7eadd3006b3UL;
   tf->codes[4364] = 0x0000e7f4edc5048fUL;
   tf->codes[4365] = 0x0000e7f5d8011ba3UL;
   tf->codes[4366] = 0x0000e7f687ae2cf2UL;
   tf->codes[4367] = 0x0000e7f6c23d32b7UL;
   tf->codes[4368] = 0x0000e7f7ac7949cbUL;
   tf->codes[4369] = 0x0000e7f896b560dfUL;
   tf->codes[4370] = 0x0000e7f8d14466a4UL;
   tf->codes[4371] = 0x0000e7fae04b9a91UL;
   tf->codes[4372] = 0x0000e7fcef52ce7eUL;
   tf->codes[4373] = 0x0000e80023251f44UL;
   tf->codes[4374] = 0x0000e8005db42509UL;
   tf->codes[4375] = 0x0000e80098432aceUL;
   tf->codes[4376] = 0x0000e800d2d23093UL;
   tf->codes[4377] = 0x0000e801bd0e47a7UL;
   tf->codes[4378] = 0x0000e802322c5331UL;
   tf->codes[4379] = 0x0000e8026cbb58f6UL;
   tf->codes[4380] = 0x0000e8031c686a45UL;
   tf->codes[4381] = 0x0000e8044133871eUL;
   tf->codes[4382] = 0x0000e8052b6f9e32UL;
   tf->codes[4383] = 0x0000e80565fea3f7UL;
   tf->codes[4384] = 0x0000e806503abb0bUL;
   tf->codes[4385] = 0x0000e8077505d7e4UL;
   tf->codes[4386] = 0x0000e809497e060cUL;
   tf->codes[4387] = 0x0000e80b1df63434UL;
   tf->codes[4388] = 0x0000e80bcda34583UL;
   tf->codes[4389] = 0x0000e80c42c1510dUL;
   tf->codes[4390] = 0x0000e811fab8e14aUL;
   tf->codes[4391] = 0x0000e8135a1303e8UL;
   tf->codes[4392] = 0x0000e814b96d2686UL;
   tf->codes[4393] = 0x0000e8152e8b3210UL;
   tf->codes[4394] = 0x0000e816c8745a73UL;
   tf->codes[4395] = 0x0000e81b2111c812UL;
   tf->codes[4396] = 0x0000e81b962fd39cUL;
   tf->codes[4397] = 0x0000e81cbafaf075UL;
   tf->codes[4398] = 0x0000e82063eb4cc5UL;
   tf->codes[4399] = 0x0000e8214e2763d9UL;
   tf->codes[4400] = 0x0000e82188b6699eUL;
   tf->codes[4401] = 0x0000e82397bd9d8bUL;
   tf->codes[4402] = 0x0000e82531a6c5eeUL;
   tf->codes[4403] = 0x0000e8282aea10efUL;
   tf->codes[4404] = 0x0000e8298a44338dUL;
   tf->codes[4405] = 0x0000e82cbe168453UL;
   tf->codes[4406] = 0x0000e8302c77dadeUL;
   tf->codes[4407] = 0x0000e8344a8642b8UL;
   tf->codes[4408] = 0x0000e836598d76a5UL;
   tf->codes[4409] = 0x0000e8386894aa92UL;
   tf->codes[4410] = 0x0000e838a323b057UL;
   tf->codes[4411] = 0x0000e838ddb2b61cUL;
   tf->codes[4412] = 0x0000e83b61d7f593UL;
   tf->codes[4413] = 0x0000e8439df4c547UL;
   tf->codes[4414] = 0x0000e843d883cb0cUL;
   tf->codes[4415] = 0x0000e8441312d0d1UL;
   tf->codes[4416] = 0x0000e846221a04beUL;
   tf->codes[4417] = 0x0000e847f69232e6UL;
   tf->codes[4418] = 0x0000e848312138abUL;
   tf->codes[4419] = 0x0000e84a059966d3UL;
   tf->codes[4420] = 0x0000e84ab5467822UL;
   tf->codes[4421] = 0x0000e84cc44dac0fUL;
   tf->codes[4422] = 0x0000e8527c453c4cUL;
   tf->codes[4423] = 0x0000e852f16347d6UL;
   tf->codes[4424] = 0x0000e853a1105925UL;
   tf->codes[4425] = 0x0000e85450bd6a74UL;
   tf->codes[4426] = 0x0000e8557588874dUL;
   tf->codes[4427] = 0x0000e8562535989cUL;
   tf->codes[4428] = 0x0000e858343ccc89UL;
   tf->codes[4429] = 0x0000e858e3e9ddd8UL;
   tf->codes[4430] = 0x0000e859ce25f4ecUL;
   tf->codes[4431] = 0x0000e85bdd2d28d9UL;
   tf->codes[4432] = 0x0000e85ed67073daUL;
   tf->codes[4433] = 0x0000e8615a95b351UL;
   tf->codes[4434] = 0x0000e862f47edbb4UL;
   tf->codes[4435] = 0x0000e86578a41b2bUL;
   tf->codes[4436] = 0x0000e8669d6f3804UL;
   tf->codes[4437] = 0x0000e867128d438eUL;
   tf->codes[4438] = 0x0000e86787ab4f18UL;
   tf->codes[4439] = 0x0000e86996b28305UL;
   tf->codes[4440] = 0x0000e86b6b2ab12dUL;
   tf->codes[4441] = 0x0000e86cca84d3cbUL;
   tf->codes[4442] = 0x0000e86db4c0eadfUL;
   tf->codes[4443] = 0x0000e8715db1472fUL;
   tf->codes[4444] = 0x0000e8775037dd31UL;
   tf->codes[4445] = 0x0000e87924b00b59UL;
   tf->codes[4446] = 0x0000e8807690c3f9UL;
   tf->codes[4447] = 0x0000e8819b5be0d2UL;
   tf->codes[4448] = 0x0000e8824b08f221UL;
   tf->codes[4449] = 0x0000e88335450935UL;
   tf->codes[4450] = 0x0000e883aa6314bfUL;
   tf->codes[4451] = 0x0000e883e4f21a84UL;
   tf->codes[4452] = 0x0000e88509bd375dUL;
   tf->codes[4453] = 0x0000e886691759fbUL;
   tf->codes[4454] = 0x0000e886de356585UL;
   tf->codes[4455] = 0x0000e88718c46b4aUL;
   tf->codes[4456] = 0x0000e8883d8f8823UL;
   tf->codes[4457] = 0x0000e888b2ad93adUL;
   tf->codes[4458] = 0x0000e88ac1b4c79aUL;
   tf->codes[4459] = 0x0000e890048e4c4dUL;
   tf->codes[4460] = 0x0000e89079ac57d7UL;
   tf->codes[4461] = 0x0000e891d9067a75UL;
   tf->codes[4462] = 0x0000e8921395803aUL;
   tf->codes[4463] = 0x0000e893ad7ea89dUL;
   tf->codes[4464] = 0x0000e895f714e24fUL;
   tf->codes[4465] = 0x0000e898b5c9278bUL;
   tf->codes[4466] = 0x0000e89be99b7851UL;
   tf->codes[4467] = 0x0000e89df8a2ac3eUL;
   tf->codes[4468] = 0x0000e89f928bd4a1UL;
   tf->codes[4469] = 0x0000e8a0b756f17aUL;
   tf->codes[4470] = 0x0000e8a3eb294240UL;
   tf->codes[4471] = 0x0000e8a425b84805UL;
   tf->codes[4472] = 0x0000e8a5fa30762dUL;
   tf->codes[4473] = 0x0000e8a66f4e81b7UL;
   tf->codes[4474] = 0x0000e8a7cea8a455UL;
   tf->codes[4475] = 0x0000e8aac7ebef56UL;
   tf->codes[4476] = 0x0000e8af20895cf5UL;
   tf->codes[4477] = 0x0000e8af95a7687fUL;
   tf->codes[4478] = 0x0000e8b00ac57409UL;
   tf->codes[4479] = 0x0000e8b12f9090e2UL;
   tf->codes[4480] = 0x0000e8b1df3da231UL;
   tf->codes[4481] = 0x0000e8b2c979b945UL;
   tf->codes[4482] = 0x0000e8b46362e1a8UL;
   tf->codes[4483] = 0x0000e8b96bad6096UL;
   tf->codes[4484] = 0x0000e8b9a63c665bUL;
   tf->codes[4485] = 0x0000e8bcda0eb721UL;
   tf->codes[4486] = 0x0000e8c082ff1371UL;
   tf->codes[4487] = 0x0000e8c1e259360fUL;
   tf->codes[4488] = 0x0000e8c29206475eUL;
   tf->codes[4489] = 0x0000e8c341b358adUL;
   tf->codes[4490] = 0x0000e8c4667e7586UL;
   tf->codes[4491] = 0x0000e8c4a10d7b4bUL;
   tf->codes[4492] = 0x0000e8c5c5d89824UL;
   tf->codes[4493] = 0x0000e8c600679de9UL;
   tf->codes[4494] = 0x0000e8c7d4dfcc11UL;
   tf->codes[4495] = 0x0000e8ca59050b88UL;
   tf->codes[4496] = 0x0000e8ca9394114dUL;
   tf->codes[4497] = 0x0000e8cb08b21cd7UL;
   tf->codes[4498] = 0x0000e8cbf2ee33ebUL;
   tf->codes[4499] = 0x0000e8ccdd2a4affUL;
   tf->codes[4500] = 0x0000e8cd17b950c4UL;
   tf->codes[4501] = 0x0000e8cf26c084b1UL;
   tf->codes[4502] = 0x0000e8cfd66d9600UL;
   tf->codes[4503] = 0x0000e8d1e574c9edUL;
   tf->codes[4504] = 0x0000e8d4a4290f29UL;
   tf->codes[4505] = 0x0000e8d7d7fb5fefUL;
   tf->codes[4506] = 0x0000e8deb4be0d05UL;
   tf->codes[4507] = 0x0000e8e089363b2dUL;
   tf->codes[4508] = 0x0000e8e30d5b7aa4UL;
   tf->codes[4509] = 0x0000e8e4a744a307UL;
   tf->codes[4510] = 0x0000e8e5cc0fbfe0UL;
   tf->codes[4511] = 0x0000e8e7db16f3cdUL;
   tf->codes[4512] = 0x0000e8e9af8f21f5UL;
   tf->codes[4513] = 0x0000e8e9ea1e27baUL;
   tf->codes[4514] = 0x0000e8ead45a3eceUL;
   tf->codes[4515] = 0x0000e8ef6786b232UL;
   tf->codes[4516] = 0x0000e8f051c2c946UL;
   tf->codes[4517] = 0x0000e8f435422b5bUL;
   tf->codes[4518] = 0x0000e8f46fd13120UL;
   tf->codes[4519] = 0x0000e8fa27c8c15dUL;
   tf->codes[4520] = 0x0000e8fbc1b1e9c0UL;
   tf->codes[4521] = 0x0000e906f7120475UL;
   tf->codes[4522] = 0x0000e907e14e1b89UL;
   tf->codes[4523] = 0x0000e90906193862UL;
   tf->codes[4524] = 0x0000e90940a83e27UL;
   tf->codes[4525] = 0x0000e90a65735b00UL;
   tf->codes[4526] = 0x0000e90aa00260c5UL;
   tf->codes[4527] = 0x0000e91107a70251UL;
   tf->codes[4528] = 0x0000e91142360816UL;
   tf->codes[4529] = 0x0000e9117cc50ddbUL;
   tf->codes[4530] = 0x0000e911b75413a0UL;
   tf->codes[4531] = 0x0000e914eb266466UL;
   tf->codes[4532] = 0x0000e91525b56a2bUL;
   tf->codes[4533] = 0x0000e9176f4ba3ddUL;
   tf->codes[4534] = 0x0000e91addacfa68UL;
   tf->codes[4535] = 0x0000e91b183c002dUL;
   tf->codes[4536] = 0x0000e91efbbb6242UL;
   tf->codes[4537] = 0x0000e92020867f1bUL;
   tf->codes[4538] = 0x0000e9205b1584e0UL;
   tf->codes[4539] = 0x0000e92095a48aa5UL;
   tf->codes[4540] = 0x0000e920d033906aUL;
   tf->codes[4541] = 0x0000e921ba6fa77eUL;
   tf->codes[4542] = 0x0000e921f4fead43UL;
   tf->codes[4543] = 0x0000e9247923ecbaUL;
   tf->codes[4544] = 0x0000e926882b20a7UL;
   tf->codes[4545] = 0x0000e926fd492c31UL;
   tf->codes[4546] = 0x0000e9305e3118beUL;
   tf->codes[4547] = 0x0000e93232a946e6UL;
   tf->codes[4548] = 0x0000e9326d384cabUL;
   tf->codes[4549] = 0x0000e93441b07ad3UL;
   tf->codes[4550] = 0x0000e9368b46b485UL;
   tf->codes[4551] = 0x0000e9370064c00fUL;
   tf->codes[4552] = 0x0000e937b011d15eUL;
   tf->codes[4553] = 0x0000e937eaa0d723UL;
   tf->codes[4554] = 0x0000e939f9a80b10UL;
   tf->codes[4555] = 0x0000e93a343710d5UL;
   tf->codes[4556] = 0x0000e93c7dcd4a87UL;
   tf->codes[4557] = 0x0000e93fb19f9b4dUL;
   tf->codes[4558] = 0x0000e9414b88c3b0UL;
   tf->codes[4559] = 0x0000e94235c4dac4UL;
   tf->codes[4560] = 0x0000e9468e624863UL;
   tf->codes[4561] = 0x0000e947edbc6b01UL;
   tf->codes[4562] = 0x0000e94b96acc751UL;
   tf->codes[4563] = 0x0000e94e8ff01252UL;
   tf->codes[4564] = 0x0000e94eca7f1817UL;
   tf->codes[4565] = 0x0000e94fef4a34f0UL;
   tf->codes[4566] = 0x0000e9506468407aUL;
   tf->codes[4567] = 0x0000e956917ddc41UL;
   tf->codes[4568] = 0x0000e9577bb9f355UL;
   tf->codes[4569] = 0x0000e958db1415f3UL;
   tf->codes[4570] = 0x0000e95e930ba630UL;
   tf->codes[4571] = 0x0000e9602cf4ce93UL;
   tf->codes[4572] = 0x0000e960dca1dfe2UL;
   tf->codes[4573] = 0x0000e962eba913cfUL;
   tf->codes[4574] = 0x0000e9677ed58733UL;
   tf->codes[4575] = 0x0000e9682e829882UL;
   tf->codes[4576] = 0x0000e969534db55bUL;
   tf->codes[4577] = 0x0000e96b27c5e383UL;
   tf->codes[4578] = 0x0000e96bd772f4d2UL;
   tf->codes[4579] = 0x0000e96cc1af0be6UL;
   tf->codes[4580] = 0x0000e972b435a1e8UL;
   tf->codes[4581] = 0x0000e97a06165a88UL;
   tf->codes[4582] = 0x0000e97a7b346612UL;
   tf->codes[4583] = 0x0000e97af052719cUL;
   tf->codes[4584] = 0x0000e97b9fff82ebUL;
   tf->codes[4585] = 0x0000e980332bf64fUL;
   tf->codes[4586] = 0x0000e98207a42477UL;
   tf->codes[4587] = 0x0000e982b75135c6UL;
   tf->codes[4588] = 0x0000e98834b9c03eUL;
   tf->codes[4589] = 0x0000e988e466d18dUL;
   tf->codes[4590] = 0x0000e9899413e2dcUL;
   tf->codes[4591] = 0x0000e989cea2e8a1UL;
   tf->codes[4592] = 0x0000e98af36e057aUL;
   tf->codes[4593] = 0x0000e98e9c5e61caUL;
   tf->codes[4594] = 0x0000e9915b12a706UL;
   tf->codes[4595] = 0x0000e99195a1accbUL;
   tf->codes[4596] = 0x0000e9920abfb855UL;
   tf->codes[4597] = 0x0000e992ba6cc9a4UL;
   tf->codes[4598] = 0x0000e995b3b014a5UL;
   tf->codes[4599] = 0x0000e996d87b317eUL;
   tf->codes[4600] = 0x0000e9a073f223d0UL;
   tf->codes[4601] = 0x0000e9a1d34c466eUL;
   tf->codes[4602] = 0x0000e9a4cc8f916fUL;
   tf->codes[4603] = 0x0000e9a5071e9734UL;
   tf->codes[4604] = 0x0000e9ac1e704a0fUL;
   tf->codes[4605] = 0x0000e9ad433b66e8UL;
   tf->codes[4606] = 0x0000e9b0ec2bc338UL;
   tf->codes[4607] = 0x0000e9b126bac8fdUL;
   tf->codes[4608] = 0x0000e9b45a8d19c3UL;
   tf->codes[4609] = 0x0000e9b9284892ecUL;
   tf->codes[4610] = 0x0000e9ba87a2b58aUL;
   tf->codes[4611] = 0x0000e9bbe6fcd828UL;
   tf->codes[4612] = 0x0000e9bc96a9e977UL;
   tf->codes[4613] = 0x0000e9bcd138ef3cUL;
   tf->codes[4614] = 0x0000e9c0ef475716UL;
   tf->codes[4615] = 0x0000e9c19ef46865UL;
   tf->codes[4616] = 0x0000e9c5bd02d03fUL;
   tf->codes[4617] = 0x0000e9c63220dbc9UL;
   tf->codes[4618] = 0x0000e9c8f0d52105UL;
   tf->codes[4619] = 0x0000e9c9db113819UL;
   tf->codes[4620] = 0x0000e9ca502f43a3UL;
   tf->codes[4621] = 0x0000e9cac54d4f2dUL;
   tf->codes[4622] = 0x0000e9cf5879c291UL;
   tf->codes[4623] = 0x0000e9d1dc9f0208UL;
   tf->codes[4624] = 0x0000e9d3b1173030UL;
   tf->codes[4625] = 0x0000e9d5c01e641dUL;
   tf->codes[4626] = 0x0000e9d9690ec06dUL;
   tf->codes[4627] = 0x0000e9da534ad781UL;
   tf->codes[4628] = 0x0000e9dac868e30bUL;
   tf->codes[4629] = 0x0000e9db3d86ee95UL;
   tf->codes[4630] = 0x0000e9df210650aaUL;
   tf->codes[4631] = 0x0000e9e00b4267beUL;
   tf->codes[4632] = 0x0000e9e1dfba95e6UL;
   tf->codes[4633] = 0x0000e9e28f67a735UL;
   tf->codes[4634] = 0x0000e9e2c9f6acfaUL;
   tf->codes[4635] = 0x0000e9e30485b2bfUL;
   tf->codes[4636] = 0x0000e9e3b432c40eUL;
   tf->codes[4637] = 0x0000e9e49e6edb22UL;
   tf->codes[4638] = 0x0000e9e588aaf236UL;
   tf->codes[4639] = 0x0000e9e672e7094aUL;
   tf->codes[4640] = 0x0000e9e7d2412be8UL;
   tf->codes[4641] = 0x0000e9e8bc7d42fcUL;
   tf->codes[4642] = 0x0000e9ec656d9f4cUL;
   tf->codes[4643] = 0x0000e9f1e2d629c4UL;
   tf->codes[4644] = 0x0000e9f2cd1240d8UL;
   tf->codes[4645] = 0x0000e9f466fb693bUL;
   tf->codes[4646] = 0x0000e9f4a18a6f00UL;
   tf->codes[4647] = 0x0000e9f79acdba01UL;
   tf->codes[4648] = 0x0000e9f84a7acb50UL;
   tf->codes[4649] = 0x0000e9f8bf98d6daUL;
   tf->codes[4650] = 0x0000e9fd18364479UL;
   tf->codes[4651] = 0x0000ea00c126a0c9UL;
   tf->codes[4652] = 0x0000ea06b3ad36cbUL;
   tf->codes[4653] = 0x0000ea079de94ddfUL;
   tf->codes[4654] = 0x0000ea07d87853a4UL;
   tf->codes[4655] = 0x0000ea0813075969UL;
   tf->codes[4656] = 0x0000ea08c2b46ab8UL;
   tf->codes[4657] = 0x0000ea08fd43707dUL;
   tf->codes[4658] = 0x0000ea0bf686bb7eUL;
   tf->codes[4659] = 0x0000ea1089b32ee2UL;
   tf->codes[4660] = 0x0000ea1139604031UL;
   tf->codes[4661] = 0x0000ea125e2b5d0aUL;
   tf->codes[4662] = 0x0000ea15576ea80bUL;
   tf->codes[4663] = 0x0000ea17a104e1bdUL;
   tf->codes[4664] = 0x0000ea1850b1f30cUL;
   tf->codes[4665] = 0x0000ea19ea9b1b6fUL;
   tf->codes[4666] = 0x0000ea22d664fc72UL;
   tf->codes[4667] = 0x0000ea2310f40237UL;
   tf->codes[4668] = 0x0000ea2435bf1f10UL;
   tf->codes[4669] = 0x0000ea260a374d38UL;
   tf->codes[4670] = 0x0000ea26b9e45e87UL;
   tf->codes[4671] = 0x0000ea272f026a11UL;
   tf->codes[4672] = 0x0000ea29037a9839UL;
   tf->codes[4673] = 0x0000ea2b4d10d1ebUL;
   tf->codes[4674] = 0x0000ea2bfcbde33aUL;
   tf->codes[4675] = 0x0000ea2d21890013UL;
   tf->codes[4676] = 0x0000ea2e0bc51727UL;
   tf->codes[4677] = 0x0000ea2fa5ae3f8aUL;
   tf->codes[4678] = 0x0000ea31b4b57377UL;
   tf->codes[4679] = 0x0000ea33140f9615UL;
   tf->codes[4680] = 0x0000ea33c3bca764UL;
   tf->codes[4681] = 0x0000ea33fe4bad29UL;
   tf->codes[4682] = 0x0000ea347369b8b3UL;
   tf->codes[4683] = 0x0000ea35d2c3db51UL;
   tf->codes[4684] = 0x0000ea37a73c0979UL;
   tf->codes[4685] = 0x0000ea3aa07f547aUL;
   tf->codes[4686] = 0x0000ea3b159d6004UL;
   tf->codes[4687] = 0x0000ea3b502c65c9UL;
   tf->codes[4688] = 0x0000ea4142b2fbcbUL;
   tf->codes[4689] = 0x0000ea422cef12dfUL;
   tf->codes[4690] = 0x0000ea42dc9c242eUL;
   tf->codes[4691] = 0x0000ea43172b29f3UL;
   tf->codes[4692] = 0x0000ea44b1145256UL;
   tf->codes[4693] = 0x0000ea44eba3581bUL;
   tf->codes[4694] = 0x0000ea46c01b8643UL;
   tf->codes[4695] = 0x0000ea481f75a8e1UL;
   tf->codes[4696] = 0x0000ea4b18b8f3e2UL;
   tf->codes[4697] = 0x0000ea4b5347f9a7UL;
   tf->codes[4698] = 0x0000ea4ced31220aUL;
   tf->codes[4699] = 0x0000ea510b3f89e4UL;
   tf->codes[4700] = 0x0000ea52a528b247UL;
   tf->codes[4701] = 0x0000ea540482d4e5UL;
   tf->codes[4702] = 0x0000ea54eebeebf9UL;
   tf->codes[4703] = 0x0000ea57e80236faUL;
   tf->codes[4704] = 0x0000ea59bc7a6522UL;
   tf->codes[4705] = 0x0000ea5a6c277671UL;
   tf->codes[4706] = 0x0000ea5ec4c4e410UL;
   tf->codes[4707] = 0x0000ea605eae0c73UL;
   tf->codes[4708] = 0x0000ea60993d1238UL;
   tf->codes[4709] = 0x0000ea60d3cc17fdUL;
   tf->codes[4710] = 0x0000ea61f89734d6UL;
   tf->codes[4711] = 0x0000ea626db54060UL;
   tf->codes[4712] = 0x0000ea67eb1dcad8UL;
   tf->codes[4713] = 0x0000ea69bf95f900UL;
   tf->codes[4714] = 0x0000ea6b1ef01b9eUL;
   tf->codes[4715] = 0x0000ea6cf36849c6UL;
   tf->codes[4716] = 0x0000ea71c123c2efUL;
   tf->codes[4717] = 0x0000ea735b0ceb52UL;
   tf->codes[4718] = 0x0000ea75df322ac9UL;
   tf->codes[4719] = 0x0000ea76c96e41ddUL;
   tf->codes[4720] = 0x0000ea773e8c4d67UL;
   tf->codes[4721] = 0x0000ea78d87575caUL;
   tf->codes[4722] = 0x0000ea7cf683dda4UL;
   tf->codes[4723] = 0x0000ea7fb53822e0UL;
   tf->codes[4724] = 0x0000ea8532a0ad58UL;
   tf->codes[4725] = 0x0000ea86cc89d5bbUL;
   tf->codes[4726] = 0x0000ea870718db80UL;
   tf->codes[4727] = 0x0000ea886672fe1eUL;
   tf->codes[4728] = 0x0000ea8b2527435aUL;
   tf->codes[4729] = 0x0000ea8b5fb6491fUL;
   tf->codes[4730] = 0x0000ea902d71c248UL;
   tf->codes[4731] = 0x0000ea94860f2fe7UL;
   tf->codes[4732] = 0x0000ea9535bc4136UL;
   tf->codes[4733] = 0x0000ea95704b46fbUL;
   tf->codes[4734] = 0x0000ea98a41d97c1UL;
   tf->codes[4735] = 0x0000ea9b2842d738UL;
   tf->codes[4736] = 0x0000ea9d374a0b25UL;
   tf->codes[4737] = 0x0000eaa86caa25daUL;
   tf->codes[4738] = 0x0000eaa8a7392b9fUL;
   tf->codes[4739] = 0x0000eaaa7bb159c7UL;
   tf->codes[4740] = 0x0000eaaba07c76a0UL;
   tf->codes[4741] = 0x0000eaae99bfc1a1UL;
   tf->codes[4742] = 0x0000eaaed44ec766UL;
   tf->codes[4743] = 0x0000eab576826eb7UL;
   tf->codes[4744] = 0x0000eab69b4d8b90UL;
   tf->codes[4745] = 0x0000eab95a01d0ccUL;
   tf->codes[4746] = 0x0000eabbde271043UL;
   tf->codes[4747] = 0x0000eac245cbb1cfUL;
   tf->codes[4748] = 0x0000eac3dfb4da32UL;
   tf->codes[4749] = 0x0000eac4c9f0f146UL;
   tf->codes[4750] = 0x0000eac5047ff70bUL;
   tf->codes[4751] = 0x0000eac5799e0295UL;
   tf->codes[4752] = 0x0000eac74e1630bdUL;
   tf->codes[4753] = 0x0000eac8385247d1UL;
   tf->codes[4754] = 0x0000eaca0cca75f9UL;
   tf->codes[4755] = 0x0000eacbe142a421UL;
   tf->codes[4756] = 0x0000eacfff510bfbUL;
   tf->codes[4757] = 0x0000ead1241c28d4UL;
   tf->codes[4758] = 0x0000ead283764b72UL;
   tf->codes[4759] = 0x0000ead2f89456fcUL;
   tf->codes[4760] = 0x0000ead333235cc1UL;
   tf->codes[4761] = 0x0000ead3a841684bUL;
   tf->codes[4762] = 0x0000ead75131c49bUL;
   tf->codes[4763] = 0x0000eadc597c4389UL;
   tf->codes[4764] = 0x0000eadd092954d8UL;
   tf->codes[4765] = 0x0000eadea3127d3bUL;
   tf->codes[4766] = 0x0000eae0b219b128UL;
   tf->codes[4767] = 0x0000eae19c55c83cUL;
   tf->codes[4768] = 0x0000eae21173d3c6UL;
   tf->codes[4769] = 0x0000eae28691df50UL;
   tf->codes[4770] = 0x0000eae2c120e515UL;
   tf->codes[4771] = 0x0000eae5ba643016UL;
   tf->codes[4772] = 0x0000eae803fa69c8UL;
   tf->codes[4773] = 0x0000eae8b3a77b17UL;
   tf->codes[4774] = 0x0000eae8ee3680dcUL;
   tf->codes[4775] = 0x0000eae99de3922bUL;
   tf->codes[4776] = 0x0000eaed46d3ee7bUL;
   tf->codes[4777] = 0x0000eaeee0bd16deUL;
   tf->codes[4778] = 0x0000eaef906a282dUL;
   tf->codes[4779] = 0x0000eaf04017397cUL;
   tf->codes[4780] = 0x0000eaf3e90795ccUL;
   tf->codes[4781] = 0x0000eaf45e25a156UL;
   tf->codes[4782] = 0x0000eafa161d3193UL;
   tf->codes[4783] = 0x0000eafac5ca42e2UL;
   tf->codes[4784] = 0x0000eafbea955fbbUL;
   tf->codes[4785] = 0x0000eafc25246580UL;
   tf->codes[4786] = 0x0000eb01dd1bf5bdUL;
   tf->codes[4787] = 0x0000eb0426b22f6fUL;
   tf->codes[4788] = 0x0000eb0635b9635cUL;
   tf->codes[4789] = 0x0000eb075a848035UL;
   tf->codes[4790] = 0x0000eb080a319184UL;
   tf->codes[4791] = 0x0000eb0844c09749UL;
   tf->codes[4792] = 0x0000eb08f46da898UL;
   tf->codes[4793] = 0x0000eb09698bb422UL;
   tf->codes[4794] = 0x0000eb0b3e03e24aUL;
   tf->codes[4795] = 0x0000eb11308a784cUL;
   tf->codes[4796] = 0x0000eb137a20b1feUL;
   tf->codes[4797] = 0x0000eb16e8820889UL;
   tf->codes[4798] = 0x0000eb18826b30ecUL;
   tf->codes[4799] = 0x0000eb1a1c54594fUL;
   tf->codes[4800] = 0x0000eb1acc016a9eUL;
   tf->codes[4801] = 0x0000eb1b7bae7bedUL;
   tf->codes[4802] = 0x0000eb2258712903UL;
   tf->codes[4803] = 0x0000eb2467785cf0UL;
   tf->codes[4804] = 0x0000eb24a20762b5UL;
   tf->codes[4805] = 0x0000eb24dc96687aUL;
   tf->codes[4806] = 0x0000eb263bf08b18UL;
   tf->codes[4807] = 0x0000eb26eb9d9c67UL;
   tf->codes[4808] = 0x0000eb28faa4d054UL;
   tf->codes[4809] = 0x0000eb296fc2dbdeUL;
   tf->codes[4810] = 0x0000eb3136c1a008UL;
   tf->codes[4811] = 0x0000eb33f575e544UL;
   tf->codes[4812] = 0x0000eb34a522f693UL;
   tf->codes[4813] = 0x0000eb3554d007e2UL;
   tf->codes[4814] = 0x0000eb3ca6b0c082UL;
   tf->codes[4815] = 0x0000eb472c63c9e8UL;
   tf->codes[4816] = 0x0000eb4b4a7231c2UL;
   tf->codes[4817] = 0x0000eb4bfa1f4311UL;
   tf->codes[4818] = 0x0000eb4c34ae48d6UL;
   tf->codes[4819] = 0x0000eb4ca9cc5460UL;
   tf->codes[4820] = 0x0000eb4ce45b5a25UL;
   tf->codes[4821] = 0x0000eb4ef3628e12UL;
   tf->codes[4822] = 0x0000eb50182daaebUL;
   tf->codes[4823] = 0x0000eb56454346b2UL;
   tf->codes[4824] = 0x0000eb56ba61523cUL;
   tf->codes[4825] = 0x0000eb576a0e638bUL;
   tf->codes[4826] = 0x0000eb5bc2abd12aUL;
   tf->codes[4827] = 0x0000eb61efc16cf1UL;
   tf->codes[4828] = 0x0000eb62d9fd8405UL;
   tf->codes[4829] = 0x0000eb63148c89caUL;
   tf->codes[4830] = 0x0000eb6598b1c941UL;
   tf->codes[4831] = 0x0000eb66bd7ce61aUL;
   tf->codes[4832] = 0x0000eb66f80bebdfUL;
   tf->codes[4833] = 0x0000eb6941a22591UL;
   tf->codes[4834] = 0x0000eb6ef999b5ceUL;
   tf->codes[4835] = 0x0000eb7267fb0c59UL;
   tf->codes[4836] = 0x0000eb72a28a121eUL;
   tf->codes[4837] = 0x0000eb759bcd5d1fUL;
   tf->codes[4838] = 0x0000eb789510a820UL;
   tf->codes[4839] = 0x0000eb790a2eb3aaUL;
   tf->codes[4840] = 0x0000eb79b9dbc4f9UL;
   tf->codes[4841] = 0x0000eb79f46acabeUL;
   tf->codes[4842] = 0x0000eb838fe1bd10UL;
   tf->codes[4843] = 0x0000eb859ee8f0fdUL;
   tf->codes[4844] = 0x0000eb8982685312UL;
   tf->codes[4845] = 0x0000eb8d2b58af62UL;
   tf->codes[4846] = 0x0000eb914967173cUL;
   tf->codes[4847] = 0x0000eb93586e4b29UL;
   tf->codes[4848] = 0x0000eb9392fd50eeUL;
   tf->codes[4849] = 0x0000eb947d396802UL;
   tf->codes[4850] = 0x0000eb94f257738cUL;
   tf->codes[4851] = 0x0000eb95a20484dbUL;
   tf->codes[4852] = 0x0000eb9617229065UL;
   tf->codes[4853] = 0x0000eb973bedad3eUL;
   tf->codes[4854] = 0x0000eb9fed28887cUL;
   tf->codes[4855] = 0x0000eba062469406UL;
   tf->codes[4856] = 0x0000eba18711b0dfUL;
   tf->codes[4857] = 0x0000eba35b89df07UL;
   tf->codes[4858] = 0x0000eba40b36f056UL;
   tf->codes[4859] = 0x0000eba4f573076aUL;
   tf->codes[4860] = 0x0000eba654cd2a08UL;
   tf->codes[4861] = 0x0000eba6c9eb3592UL;
   tf->codes[4862] = 0x0000eba9c32e8093UL;
   tf->codes[4863] = 0x0000ebac4753c00aUL;
   tf->codes[4864] = 0x0000ebae90e9f9bcUL;
   tf->codes[4865] = 0x0000ebb3993478aaUL;
   tf->codes[4866] = 0x0000ebb4f88e9b48UL;
   tf->codes[4867] = 0x0000ebb69277c3abUL;
   tf->codes[4868] = 0x0000ebb7b742e084UL;
   tf->codes[4869] = 0x0000ebb866eff1d3UL;
   tf->codes[4870] = 0x0000ebbaeb15314aUL;
   tf->codes[4871] = 0x0000ebbcfa1c6537UL;
   tf->codes[4872] = 0x0000ebbece94935fUL;
   tf->codes[4873] = 0x0000ebbfb8d0aa73UL;
   tf->codes[4874] = 0x0000ebc70ab16313UL;
   tf->codes[4875] = 0x0000ebc7ba5e7462UL;
   tf->codes[4876] = 0x0000ebc7f4ed7a27UL;
   tf->codes[4877] = 0x0000ebc8a49a8b76UL;
   tf->codes[4878] = 0x0000ebc9c965a84fUL;
   tf->codes[4879] = 0x0000ebcaee30c528UL;
   tf->codes[4880] = 0x0000ebd41489abf0UL;
   tf->codes[4881] = 0x0000ebd7bd7a0840UL;
   tf->codes[4882] = 0x0000ebded4cbbb1bUL;
   tf->codes[4883] = 0x0000ebe2432d11a6UL;
   tf->codes[4884] = 0x0000ebe835b3a7a8UL;
   tf->codes[4885] = 0x0000ebe8e560b8f7UL;
   tf->codes[4886] = 0x0000ebeaf467ece4UL;
   tf->codes[4887] = 0x0000ebeb2ef6f2a9UL;
   tf->codes[4888] = 0x0000ebef127654beUL;
   tf->codes[4889] = 0x0000ebefc223660dUL;
   tf->codes[4890] = 0x0000ebf20bb99fbfUL;
   tf->codes[4891] = 0x0000ebf2f5f5b6d3UL;
   tf->codes[4892] = 0x0000ebf4554fd971UL;
   tf->codes[4893] = 0x0000ebf4ca6de4fbUL;
   tf->codes[4894] = 0x0000ebf504fceac0UL;
   tf->codes[4895] = 0x0000ebf74e932472UL;
   tf->codes[4896] = 0x0000ebfa82657538UL;
   tf->codes[4897] = 0x0000ebffc53ef9ebUL;
   tf->codes[4898] = 0x0000ec02f9114ab1UL;
   tf->codes[4899] = 0x0000ec057d368a28UL;
   tf->codes[4900] = 0x0000ec06a201a701UL;
   tf->codes[4901] = 0x0000ec08eb97e0b3UL;
   tf->codes[4902] = 0x0000ec0960b5ec3dUL;
   tf->codes[4903] = 0x0000ec0d44354e52UL;
   tf->codes[4904] = 0x0000ec0f533c823fUL;
   tf->codes[4905] = 0x0000ec10ed25aaa2UL;
   tf->codes[4906] = 0x0000ec13e668f5a3UL;
   tf->codes[4907] = 0x0000ec199e6085e0UL;
   tf->codes[4908] = 0x0000ec1a4e0d972fUL;
   tf->codes[4909] = 0x0000ec207b2332f6UL;
   tf->codes[4910] = 0x0000ec23aef583bcUL;
   tf->codes[4911] = 0x0000ec2499319ad0UL;
   tf->codes[4912] = 0x0000ec2757e5e00cUL;
   tf->codes[4913] = 0x0000ec28b74002aaUL;
   tf->codes[4914] = 0x0000ec29a17c19beUL;
   tf->codes[4915] = 0x0000ec2b75f447e6UL;
   tf->codes[4916] = 0x0000ec2beb125370UL;
   tf->codes[4917] = 0x0000ec30f35cd25eUL;
   tf->codes[4918] = 0x0000ec3252b6f4fcUL;
   tf->codes[4919] = 0x0000ec35868945c2UL;
   tf->codes[4920] = 0x0000ec3cd869fe62UL;
   tf->codes[4921] = 0x0000ec43b52cab78UL;
   tf->codes[4922] = 0x0000ec449f68c28cUL;
   tf->codes[4923] = 0x0000ec47d33b1352UL;
   tf->codes[4924] = 0x0000ec4bb6ba7567UL;
   tf->codes[4925] = 0x0000ec52ce0c2842UL;
   tf->codes[4926] = 0x0000ec53432a33ccUL;
   tf->codes[4927] = 0x0000ec55523167b9UL;
   tf->codes[4928] = 0x0000ec58c092be44UL;
   tf->codes[4929] = 0x0000ec59e55ddb1dUL;
   tf->codes[4930] = 0x0000ec5e3dfb48bcUL;
   tf->codes[4931] = 0x0000ec5f28375fd0UL;
   tf->codes[4932] = 0x0000ec608791826eUL;
   tf->codes[4933] = 0x0000ec625c09b096UL;
   tf->codes[4934] = 0x0000ec629698b65bUL;
   tf->codes[4935] = 0x0000ec646b10e483UL;
   tf->codes[4936] = 0x0000ec6729c529bfUL;
   tf->codes[4937] = 0x0000ec68fe3d57e7UL;
   tf->codes[4938] = 0x0000ec6ad2b5860fUL;
   tf->codes[4939] = 0x0000ec6b0d448bd4UL;
   tf->codes[4940] = 0x0000ec6c320fa8adUL;
   tf->codes[4941] = 0x0000ec708aad164cUL;
   tf->codes[4942] = 0x0000ec730ed255c3UL;
   tf->codes[4943] = 0x0000ec77a1fec927UL;
   tf->codes[4944] = 0x0000ec77dc8dceecUL;
   tf->codes[4945] = 0x0000ec7f2e6e878cUL;
   tf->codes[4946] = 0x0000ec7fde1b98dbUL;
   tf->codes[4947] = 0x0000ec8a293f9c7cUL;
   tf->codes[4948] = 0x0000ec8b4e0ab955UL;
   tf->codes[4949] = 0x0000ec8bc328c4dfUL;
   tf->codes[4950] = 0x0000ec8f318a1b6aUL;
   tf->codes[4951] = 0x0000ec9056553843UL;
   tf->codes[4952] = 0x0000ec91b5af5ae1UL;
   tf->codes[4953] = 0x0000ec96836ad40aUL;
   tf->codes[4954] = 0x0000ec97e2c4f6a8UL;
   tf->codes[4955] = 0x0000ec99f1cc2a95UL;
   tf->codes[4956] = 0x0000ec9b51264d33UL;
   tf->codes[4957] = 0x0000ec9bc64458bdUL;
   tf->codes[4958] = 0x0000eca1b8caeebfUL;
   tf->codes[4959] = 0x0000eca31825115dUL;
   tf->codes[4960] = 0x0000eca352b41722UL;
   tf->codes[4961] = 0x0000eca8d01ca19aUL;
   tf->codes[4962] = 0x0000ecaa6a05c9fdUL;
   tf->codes[4963] = 0x0000ecab19b2db4cUL;
   tf->codes[4964] = 0x0000ecab5441e111UL;
   tf->codes[4965] = 0x0000ecab8ed0e6d6UL;
   tf->codes[4966] = 0x0000ecacee2b0974UL;
   tf->codes[4967] = 0x0000ecb10c39714eUL;
   tf->codes[4968] = 0x0000ecb181577cd8UL;
   tf->codes[4969] = 0x0000ecb689a1fbc6UL;
   tf->codes[4970] = 0x0000ecb8238b2429UL;
   tf->codes[4971] = 0x0000ecb948564102UL;
   tf->codes[4972] = 0x0000ecb9bd744c8cUL;
   tf->codes[4973] = 0x0000ecbbcc7b8079UL;
   tf->codes[4974] = 0x0000ecc10f55052cUL;
   tf->codes[4975] = 0x0000ecc776f9a6b8UL;
   tf->codes[4976] = 0x0000ecc94b71d4e0UL;
   tf->codes[4977] = 0x0000ecc9c08fe06aUL;
   tf->codes[4978] = 0x0000eccc0a261a1cUL;
   tf->codes[4979] = 0x0000eccd69803cbaUL;
   tf->codes[4980] = 0x0000ecd0283481f6UL;
   tf->codes[4981] = 0x0000ecd14cff9ecfUL;
   tf->codes[4982] = 0x0000ecd32177ccf7UL;
   tf->codes[4983] = 0x0000ecd44642e9d0UL;
   tf->codes[4984] = 0x0000ecd56b0e06a9UL;
   tf->codes[4985] = 0x0000ecd77a153a96UL;
   tf->codes[4986] = 0x0000ecd7ef334620UL;
   tf->codes[4987] = 0x0000ecd8645151aaUL;
   tf->codes[4988] = 0x0000ecd913fe62f9UL;
   tf->codes[4989] = 0x0000ecdb230596e6UL;
   tf->codes[4990] = 0x0000ecdb9823a270UL;
   tf->codes[4991] = 0x0000ecdcbceebf49UL;
   tf->codes[4992] = 0x0000ece0a06e215eUL;
   tf->codes[4993] = 0x0000ece1158c2ce8UL;
   tf->codes[4994] = 0x0000ece7b7bfd439UL;
   tf->codes[4995] = 0x0000ecf02e6ba9b2UL;
   tf->codes[4996] = 0x0000ecf3d75c0602UL;
   tf->codes[4997] = 0x0000ecf44c7a118cUL;
   tf->codes[4998] = 0x0000ecf4fc2722dbUL;
   tf->codes[4999] = 0x0000ecf536b628a0UL;
   tf->codes[5000] = 0x0000ecf5e66339efUL;
   tf->codes[5001] = 0x0000ecf7804c6252UL;
   tf->codes[5002] = 0x0000ecfb63cbc467UL;
   tf->codes[5003] = 0x0000ecfde7f103deUL;
   tf->codes[5004] = 0x0000ed04c4b3b0f4UL;
   tf->codes[5005] = 0x0000ed083315077fUL;
   tf->codes[5006] = 0x0000ed0c8bb2751eUL;
   tf->codes[5007] = 0x0000ed1034a2d16eUL;
   tf->codes[5008] = 0x0000ed106f31d733UL;
   tf->codes[5009] = 0x0000ed1193fcf40cUL;
   tf->codes[5010] = 0x0000ed1243aa055bUL;
   tf->codes[5011] = 0x0000ed1452b13948UL;
   tf->codes[5012] = 0x0000ed18e5ddacacUL;
   tf->codes[5013] = 0x0000ed19206cb271UL;
   tf->codes[5014] = 0x0000ed19d019c3c0UL;
   tf->codes[5015] = 0x0000ed2037be654cUL;
   tf->codes[5016] = 0x0000ed20724d6b11UL;
   tf->codes[5017] = 0x0000ed2455cccd26UL;
   tf->codes[5018] = 0x0000ed2714811262UL;
   tf->codes[5019] = 0x0000ed2a48536328UL;
   tf->codes[5020] = 0x0000ed2f160edc51UL;
   tf->codes[5021] = 0x0000ed307568feefUL;
   tf->codes[5022] = 0x0000ed319a341bc8UL;
   tf->codes[5023] = 0x0000ed32847032dcUL;
   tf->codes[5024] = 0x0000ed35f2d18967UL;
   tf->codes[5025] = 0x0000ed36a27e9ab6UL;
   tf->codes[5026] = 0x0000ed39d650eb7cUL;
   tf->codes[5027] = 0x0000ed3ac08d0290UL;
   tf->codes[5028] = 0x0000ed3d44b24207UL;
   tf->codes[5029] = 0x0000ed433738d809UL;
   tf->codes[5030] = 0x0000ed43e6e5e958UL;
   tf->codes[5031] = 0x0000ed45f5ed1d45UL;
   tf->codes[5032] = 0x0000ed48b4a16281UL;
   tf->codes[5033] = 0x0000ed49644e73d0UL;
   tf->codes[5034] = 0x0000ed4a4e8a8ae4UL;
   tf->codes[5035] = 0x0000ed4ac3a8966eUL;
   tf->codes[5036] = 0x0000ed4ea727f883UL;
   tf->codes[5037] = 0x0000ed50f0be3235UL;
   tf->codes[5038] = 0x0000ed52501854d3UL;
   tf->codes[5039] = 0x0000ed52ffc56622UL;
   tf->codes[5040] = 0x0000ed56e344c837UL;
   tf->codes[5041] = 0x0000ed58080fe510UL;
   tf->codes[5042] = 0x0000ed5c9b3c5874UL;
   tf->codes[5043] = 0x0000ed5f947fa375UL;
   tf->codes[5044] = 0x0000ed60b94ac04eUL;
   tf->codes[5045] = 0x0000ed6218a4e2ecUL;
   tf->codes[5046] = 0x0000ed63b28e0b4fUL;
   tf->codes[5047] = 0x0000ed654c7733b2UL;
   tf->codes[5048] = 0x0000ed65c1953f3cUL;
   tf->codes[5049] = 0x0000ed667142508bUL;
   tf->codes[5050] = 0x0000ed680b2b78eeUL;
   tf->codes[5051] = 0x0000ed68f5679002UL;
   tf->codes[5052] = 0x0000ed6b046ec3efUL;
   tf->codes[5053] = 0x0000ed6dc323092bUL;
   tf->codes[5054] = 0x0000ed6fd22a3d18UL;
   tf->codes[5055] = 0x0000ed70bc66542cUL;
   tf->codes[5056] = 0x0000ed70f6f559f1UL;
   tf->codes[5057] = 0x0000ed716c13657bUL;
   tf->codes[5058] = 0x0000ed737b1a9968UL;
   tf->codes[5059] = 0x0000ed746556b07cUL;
   tf->codes[5060] = 0x0000ed78f88323e0UL;
   tf->codes[5061] = 0x0000ed81e44d04e3UL;
   tf->codes[5062] = 0x0000ed8727268996UL;
   tf->codes[5063] = 0x0000ed8a2069d497UL;
   tf->codes[5064] = 0x0000ed9137bb8772UL;
   tf->codes[5065] = 0x0000ed91e76898c1UL;
   tf->codes[5066] = 0x0000ed930c33b59aUL;
   tf->codes[5067] = 0x0000ed946b8dd838UL;
   tf->codes[5068] = 0x0000ed94e0abe3c2UL;
   tf->codes[5069] = 0x0000ed96b52411eaUL;
   tf->codes[5070] = 0x0000ed984f0d3a4dUL;
   tf->codes[5071] = 0x0000ed98899c4012UL;
   tf->codes[5072] = 0x0000ed9939495161UL;
   tf->codes[5073] = 0x0000eda1aff526daUL;
   tf->codes[5074] = 0x0000eda1ea842c9fUL;
   tf->codes[5075] = 0x0000eda225133264UL;
   tf->codes[5076] = 0x0000eda5ce038eb4UL;
   tf->codes[5077] = 0x0000eda643219a3eUL;
   tf->codes[5078] = 0x0000eda7dd0ac2a1UL;
   tf->codes[5079] = 0x0000edabc08a24b6UL;
   tf->codes[5080] = 0x0000edac35a83040UL;
   tf->codes[5081] = 0x0000edacaac63bcaUL;
   tf->codes[5082] = 0x0000edaf697a8106UL;
   tf->codes[5083] = 0x0000edb13df2af2eUL;
   tf->codes[5084] = 0x0000edb262bdcc07UL;
   tf->codes[5085] = 0x0000edb55c011708UL;
   tf->codes[5086] = 0x0000edb680cc33e1UL;
   tf->codes[5087] = 0x0000edb76b084af5UL;
   tf->codes[5088] = 0x0000edb7e026567fUL;
   tf->codes[5089] = 0x0000edbbc3a5b894UL;
   tf->codes[5090] = 0x0000edbce870d56dUL;
   tf->codes[5091] = 0x0000edbf6c9614e4UL;
   tf->codes[5092] = 0x0000edbfe1b4206eUL;
   tf->codes[5093] = 0x0000edc1b62c4e96UL;
   tf->codes[5094] = 0x0000edc3c5338283UL;
   tf->codes[5095] = 0x0000edc3ffc28848UL;
   tf->codes[5096] = 0x0000edc5248da521UL;
   tf->codes[5097] = 0x0000edcadc85355eUL;
   tf->codes[5098] = 0x0000edcb17143b23UL;
   tf->codes[5099] = 0x0000edcb8c3246adUL;
   tf->codes[5100] = 0x0000edcbc6c14c72UL;
   tf->codes[5101] = 0x0000edcefa939d38UL;
   tf->codes[5102] = 0x0000edcf3522a2fdUL;
   tf->codes[5103] = 0x0000edcfe4cfb44cUL;
   tf->codes[5104] = 0x0000edd14429d6eaUL;
   tf->codes[5105] = 0x0000edd4ed1a333aUL;
   tf->codes[5106] = 0x0000edd98046a69eUL;
   tf->codes[5107] = 0x0000eddadfa0c93cUL;
   tf->codes[5108] = 0x0000eddb54bed4c6UL;
   tf->codes[5109] = 0x0000eddc3efaebdaUL;
   tf->codes[5110] = 0x0000eddcb418f764UL;
   tf->codes[5111] = 0x0000ede26c1087a1UL;
   tf->codes[5112] = 0x0000ede8240817deUL;
   tf->codes[5113] = 0x0000edea6d9e5190UL;
   tf->codes[5114] = 0x0000edeb1d4b62dfUL;
   tf->codes[5115] = 0x0000edebccf8742eUL;
   tf->codes[5116] = 0x0000edecb7348b42UL;
   tf->codes[5117] = 0x0000edefeb06dc08UL;
   tf->codes[5118] = 0x0000edf02595e1cdUL;
   tf->codes[5119] = 0x0000edf4091543e2UL;
   tf->codes[5120] = 0x0000edf443a449a7UL;
   tf->codes[5121] = 0x0000edf94beec895UL;
   tf->codes[5122] = 0x0000edfc7fc1195bUL;
   tf->codes[5123] = 0x0000edff7904645cUL;
   tf->codes[5124] = 0x0000edffee226fe6UL;
   tf->codes[5125] = 0x0000ee01fd29a3d3UL;
   tf->codes[5126] = 0x0000ee035c83c671UL;
   tf->codes[5127] = 0x0000ee03d1a1d1fbUL;
   tf->codes[5128] = 0x0000ee0530fbf499UL;
   tf->codes[5129] = 0x0000ee07057422c1UL;
   tf->codes[5130] = 0x0000ee09147b56aeUL;
   tf->codes[5131] = 0x0000ee0aae647f11UL;
   tf->codes[5132] = 0x0000ee0c484da774UL;
   tf->codes[5133] = 0x0000ee10db7a1ad8UL;
   tf->codes[5134] = 0x0000ee132510548aUL;
   tf->codes[5135] = 0x0000ee139a2e6014UL;
   tf->codes[5136] = 0x0000ee17b83cc7eeUL;
   tf->codes[5137] = 0x0000ee1c4b693b52UL;
   tf->codes[5138] = 0x0000ee1f0a1d808eUL;
   tf->codes[5139] = 0x0000ee28a59472e0UL;
   tf->codes[5140] = 0x0000ee28e02378a5UL;
   tf->codes[5141] = 0x0000ee291ab27e6aUL;
   tf->codes[5142] = 0x0000ee295541842fUL;
   tf->codes[5143] = 0x0000ee2b6448b81cUL;
   tf->codes[5144] = 0x0000ee2cfe31e07fUL;
   tf->codes[5145] = 0x0000ee306c93370aUL;
   tf->codes[5146] = 0x0000ee32410b6532UL;
   tf->codes[5147] = 0x0000ee32b62970bcUL;
   tf->codes[5148] = 0x0000ee32f0b87681UL;
   tf->codes[5149] = 0x0000ee36248ac747UL;
   tf->codes[5150] = 0x0000ee37f902f56fUL;
   tf->codes[5151] = 0x0000ee3bdc825784UL;
   tf->codes[5152] = 0x0000ee3fc001b999UL;
   tf->codes[5153] = 0x0000ee40351fc523UL;
   tf->codes[5154] = 0x0000ee40aa3dd0adUL;
   tf->codes[5155] = 0x0000ee4159eae1fcUL;
   tf->codes[5156] = 0x0000ee427eb5fed5UL;
   tf->codes[5157] = 0x0000ee432e631024UL;
   tf->codes[5158] = 0x0000ee43de102173UL;
   tf->codes[5159] = 0x0000ee44532e2cfdUL;
   tf->codes[5160] = 0x0000ee4627a65b25UL;
   tf->codes[5161] = 0x0000ee47c18f8388UL;
   tf->codes[5162] = 0x0000ee4c1a2cf127UL;
   tf->codes[5163] = 0x0000ee57c4ab1766UL;
   tf->codes[5164] = 0x0000ee59d3b24b53UL;
   tf->codes[5165] = 0x0000ee5be2b97f40UL;
   tf->codes[5166] = 0x0000ee5fc638e155UL;
   tf->codes[5167] = 0x0000ee60b074f869UL;
   tf->codes[5168] = 0x0000ee61602209b8UL;
   tf->codes[5169] = 0x0000ee6284ed2691UL;
   tf->codes[5170] = 0x0000ee66dd8a9430UL;
   tf->codes[5171] = 0x0000ee6961afd3a7UL;
   tf->codes[5172] = 0x0000ee6a4bebeabbUL;
   tf->codes[5173] = 0x0000ee6fc9547533UL;
   tf->codes[5174] = 0x0000ee703e7280bdUL;
   tf->codes[5175] = 0x0000ee72c297c034UL;
   tf->codes[5176] = 0x0000ee7421f1e2d2UL;
   tf->codes[5177] = 0x0000ee792a3c61c0UL;
   tf->codes[5178] = 0x0000ee7bae61a137UL;
   tf->codes[5179] = 0x0000ee80b6ac2025UL;
   tf->codes[5180] = 0x0000ee82c5b35412UL;
   tf->codes[5181] = 0x0000ee845f9c7c75UL;
   tf->codes[5182] = 0x0000ee849a2b823aUL;
   tf->codes[5183] = 0x0000ee90b9c7b403UL;
   tf->codes[5184] = 0x0000ee95126521a2UL;
   tf->codes[5185] = 0x0000ee954cf42767UL;
   tf->codes[5186] = 0x0000ee9a553ea655UL;
   tf->codes[5187] = 0x0000eea256cc7044UL;
   tf->codes[5188] = 0x0000eea341088758UL;
   tf->codes[5189] = 0x0000eea465d3a431UL;
   tf->codes[5190] = 0x0000eea5500fbb45UL;
   tf->codes[5191] = 0x0000eea58a9ec10aUL;
   tf->codes[5192] = 0x0000eeaf60a4b921UL;
   tf->codes[5193] = 0x0000eeb01051ca70UL;
   tf->codes[5194] = 0x0000eeb1351ce749UL;
   tf->codes[5195] = 0x0000eeb2cf060facUL;
   tf->codes[5196] = 0x0000eeb42e60324aUL;
   tf->codes[5197] = 0x0000eeb762328310UL;
   tf->codes[5198] = 0x0000eeb8fc1bab73UL;
   tf->codes[5199] = 0x0000eeb9abc8bcc2UL;
   tf->codes[5200] = 0x0000eebd1a2a134dUL;
   tf->codes[5201] = 0x0000eebd54b91912UL;
   tf->codes[5202] = 0x0000eec4e128d777UL;
   tf->codes[5203] = 0x0000eec6f0300b64UL;
   tf->codes[5204] = 0x0000eec7654e16eeUL;
   tf->codes[5205] = 0x0000eec88a1933c7UL;
   tf->codes[5206] = 0x0000eece7c9fc9c9UL;
   tf->codes[5207] = 0x0000eed2d53d3768UL;
   tf->codes[5208] = 0x0000eed5ce808269UL;
   tf->codes[5209] = 0x0000eed67e2d93b8UL;
   tf->codes[5210] = 0x0000eed81816bc1bUL;
   tf->codes[5211] = 0x0000eed852a5c1e0UL;
   tf->codes[5212] = 0x0000eee2633abfbcUL;
   tf->codes[5213] = 0x0000eee7a614446fUL;
   tf->codes[5214] = 0x0000eee9b51b785cUL;
   tf->codes[5215] = 0x0000eeeb14759afaUL;
   tf->codes[5216] = 0x0000eef1418b36c1UL;
   tf->codes[5217] = 0x0000eef4afec8d4cUL;
   tf->codes[5218] = 0x0000eef68464bb74UL;
   tf->codes[5219] = 0x0000eef90889faebUL;
   tf->codes[5220] = 0x0000eefdd6457414UL;
   tf->codes[5221] = 0x0000eeffaabda23cUL;
   tf->codes[5222] = 0x0000ef010a17c4daUL;
   tf->codes[5223] = 0x0000ef03c8cc0a16UL;
   tf->codes[5224] = 0x0000ef04035b0fdbUL;
   tf->codes[5225] = 0x0000ef04b308212aUL;
   tf->codes[5226] = 0x0000ef0562b53279UL;
   tf->codes[5227] = 0x0000ef0687804f52UL;
   tf->codes[5228] = 0x0000ef08d1168904UL;
   tf->codes[5229] = 0x0000ef0a6affb167UL;
   tf->codes[5230] = 0x0000ef0b553bc87bUL;
   tf->codes[5231] = 0x0000ef0c3f77df8fUL;
   tf->codes[5232] = 0x0000ef110d3358b8UL;
   tf->codes[5233] = 0x0000ef126c8d7b56UL;
   tf->codes[5234] = 0x0000ef140676a3b9UL;
   tf->codes[5235] = 0x0000ef17af670009UL;
   tf->codes[5236] = 0x0000ef194950286cUL;
   tf->codes[5237] = 0x0000ef19be6e33f6UL;
   tf->codes[5238] = 0x0000ef1aa8aa4b0aUL;
   tf->codes[5239] = 0x0000ef1cf24084bcUL;
   tf->codes[5240] = 0x0000ef1f7665c433UL;
   tf->codes[5241] = 0x0000ef20d5bfe6d1UL;
   tf->codes[5242] = 0x0000ef21104eec96UL;
   tf->codes[5243] = 0x0000ef23cf0331d2UL;
   tf->codes[5244] = 0x0000ef273d64885dUL;
   tf->codes[5245] = 0x0000ef294c6bbc4aUL;
   tf->codes[5246] = 0x0000ef2e54b63b38UL;
   tf->codes[5247] = 0x0000ef32ad53a8d7UL;
   tf->codes[5248] = 0x0000ef332271b461UL;
   tf->codes[5249] = 0x0000ef34473cd13aUL;
   tf->codes[5250] = 0x0000ef37b59e27c5UL;
   tf->codes[5251] = 0x0000ef398a1655edUL;
   tf->codes[5252] = 0x0000ef40a16808c8UL;
   tf->codes[5253] = 0x0000ef4200c22b66UL;
   tf->codes[5254] = 0x0000ef4275e036f0UL;
   tf->codes[5255] = 0x0000ef44fa057667UL;
   tf->codes[5256] = 0x0000ef4a776e00dfUL;
   tf->codes[5257] = 0x0000ef502f65911cUL;
   tf->codes[5258] = 0x0000ef5119a1a830UL;
   tf->codes[5259] = 0x0000ef55723f15cfUL;
   tf->codes[5260] = 0x0000ef56d199386dUL;
   tf->codes[5261] = 0x0000ef5746b743f7UL;
   tf->codes[5262] = 0x0000ef591b2f721fUL;
   tf->codes[5263] = 0x0000ef5c8990c8aaUL;
   tf->codes[5264] = 0x0000ef627c175eacUL;
   tf->codes[5265] = 0x0000ef62b6a66471UL;
   tf->codes[5266] = 0x0000ef648b1e9299UL;
   tf->codes[5267] = 0x0000ef669a25c686UL;
   tf->codes[5268] = 0x0000ef691e4b05fdUL;
   tf->codes[5269] = 0x0000ef6993691187UL;
   tf->codes[5270] = 0x0000ef6a08871d11UL;
   tf->codes[5271] = 0x0000ef6a431622d6UL;
   tf->codes[5272] = 0x0000ef6ba2704574UL;
   tf->codes[5273] = 0x0000ef70aabac462UL;
   tf->codes[5274] = 0x0000ef727f32f28aUL;
   tf->codes[5275] = 0x0000ef75b3054350UL;
   tf->codes[5276] = 0x0000ef7662b2549fUL;
   tf->codes[5277] = 0x0000ef7871b9888cUL;
   tf->codes[5278] = 0x0000ef795bf59fa0UL;
   tf->codes[5279] = 0x0000ef7ba58bd952UL;
   tf->codes[5280] = 0x0000ef862b3ee2b8UL;
   tf->codes[5281] = 0x0000ef8665cde87dUL;
   tf->codes[5282] = 0x0000ef87c5280b1bUL;
   tf->codes[5283] = 0x0000ef88e9f327f4UL;
   tf->codes[5284] = 0x0000ef8ccd728a09UL;
   tf->codes[5285] = 0x0000ef92104c0ebcUL;
   tf->codes[5286] = 0x0000ef92fa8825d0UL;
   tf->codes[5287] = 0x0000ef94cf0053f8UL;
   tf->codes[5288] = 0x0000ef95b93c6b0cUL;
   tf->codes[5289] = 0x0000ef9668e97c5bUL;
   tf->codes[5290] = 0x0000ef97c8439ef9UL;
   tf->codes[5291] = 0x0000ef98b27fb60dUL;
   tf->codes[5292] = 0x0000ef999cbbcd21UL;
   tf->codes[5293] = 0x0000ef9c95ff1822UL;
   tf->codes[5294] = 0x0000ef9f8f426323UL;
   tf->codes[5295] = 0x0000efa0797e7a37UL;
   tf->codes[5296] = 0x0000efa33832bf73UL;
   tf->codes[5297] = 0x0000efa581c8f925UL;
   tf->codes[5298] = 0x0000efa805ee389cUL;
   tf->codes[5299] = 0x0000efaa8a137813UL;
   tf->codes[5300] = 0x0000efb216833678UL;
   tf->codes[5301] = 0x0000efb66f20a417UL;
   tf->codes[5302] = 0x0000efb9a2f2f4ddUL;
   tf->codes[5303] = 0x0000efba8d2f0bf1UL;
   tf->codes[5304] = 0x0000efc0ba44a7b8UL;
   tf->codes[5305] = 0x0000efc1df0fc491UL;
   tf->codes[5306] = 0x0000efca1b2c9445UL;
   tf->codes[5307] = 0x0000efcc2a33c832UL;
   tf->codes[5308] = 0x0000efd58b1bb4bfUL;
   tf->codes[5309] = 0x0000efd5c5aaba84UL;
   tf->codes[5310] = 0x0000efda1e482823UL;
   tf->codes[5311] = 0x0000efda936633adUL;
   tf->codes[5312] = 0x0000efe17028e0c3UL;
   tf->codes[5313] = 0x0000efe2cf830361UL;
   tf->codes[5314] = 0x0000efe728207100UL;
   tf->codes[5315] = 0x0000efed1aa70702UL;
   tf->codes[5316] = 0x0000efef643d40b4UL;
   tf->codes[5317] = 0x0000eff1e862802bUL;
   tf->codes[5318] = 0x0000effce333951bUL;
   tf->codes[5319] = 0x0000f0005194eba6UL;
   tf->codes[5320] = 0x0000f0088db1bb5aUL;
   tf->codes[5321] = 0x0000f009b27cd833UL;
   tf->codes[5322] = 0x0000f00ad747f50cUL;
   tf->codes[5323] = 0x0000f0138882d04aUL;
   tf->codes[5324] = 0x0000f0155cfafe72UL;
   tf->codes[5325] = 0x0000f01681c61b4bUL;
   tf->codes[5326] = 0x0000f0181baf43aeUL;
   tf->codes[5327] = 0x0000f018cb5c54fdUL;
   tf->codes[5328] = 0x0000f01a9fd48325UL;
   tf->codes[5329] = 0x0000f01b14f28eafUL;
   tf->codes[5330] = 0x0000f01c39bdab88UL;
   tf->codes[5331] = 0x0000f021077924b1UL;
   tf->codes[5332] = 0x0000f0217c97303bUL;
   tf->codes[5333] = 0x0000f023510f5e63UL;
   tf->codes[5334] = 0x0000f028ce77e8dbUL;
   tf->codes[5335] = 0x0000f030d005b2caUL;
   tf->codes[5336] = 0x0000f0317fb2c419UL;
   tf->codes[5337] = 0x0000f032a47de0f2UL;
   tf->codes[5338] = 0x0000f032df0ce6b7UL;
   tf->codes[5339] = 0x0000f033542af241UL;
   tf->codes[5340] = 0x0000f034b38514dfUL;
   tf->codes[5341] = 0x0000f03528a32069UL;
   tf->codes[5342] = 0x0000f036c28c48ccUL;
   tf->codes[5343] = 0x0000f03737aa5456UL;
   tf->codes[5344] = 0x0000f03fae5629cfUL;
   tf->codes[5345] = 0x0000f041483f5232UL;
   tf->codes[5346] = 0x0000f0435746861fUL;
   tf->codes[5347] = 0x0000f04406f3976eUL;
   tf->codes[5348] = 0x0000f044b6a0a8bdUL;
   tf->codes[5349] = 0x0000f0452bbeb447UL;
   tf->codes[5350] = 0x0000f0470036e26fUL;
   tf->codes[5351] = 0x0000f049845c21e6UL;
   tf->codes[5352] = 0x0000f04cb82e72acUL;
   tf->codes[5353] = 0x0000f052702602e9UL;
   tf->codes[5354] = 0x0000f054b9bc3c9bUL;
   tf->codes[5355] = 0x0000f0568e346ac3UL;
   tf->codes[5356] = 0x0000f05e55332eedUL;
   tf->codes[5357] = 0x0000f06238b29102UL;
   tf->codes[5358] = 0x0000f063980cb3a0UL;
   tf->codes[5359] = 0x0000f0656c84e1c8UL;
   tf->codes[5360] = 0x0000f067066e0a2bUL;
   tf->codes[5361] = 0x0000f0677b8c15b5UL;
   tf->codes[5362] = 0x0000f0698a9349a2UL;
   tf->codes[5363] = 0x0000f06b5f0b77caUL;
   tf->codes[5364] = 0x0000f070dc740242UL;
   tf->codes[5365] = 0x0000f073609941b9UL;
   tf->codes[5366] = 0x0000f073d5b74d43UL;
   tf->codes[5367] = 0x0000f075e4be8130UL;
   tf->codes[5368] = 0x0000f076946b927fUL;
   tf->codes[5369] = 0x0000f079c83de345UL;
   tf->codes[5370] = 0x0000f080a500905bUL;
   tf->codes[5371] = 0x0000f08363b4d597UL;
   tf->codes[5372] = 0x0000f087473437acUL;
   tf->codes[5373] = 0x0000f087bc524336UL;
   tf->codes[5374] = 0x0000f08b2ab399c1UL;
   tf->codes[5375] = 0x0000f08b9fd1a54bUL;
   tf->codes[5376] = 0x0000f090a81c2439UL;
   tf->codes[5377] = 0x0000f091cce74112UL;
   tf->codes[5378] = 0x0000f092f1b25debUL;
   tf->codes[5379] = 0x0000f0953b48979dUL;
   tf->codes[5380] = 0x0000f09bdd7c3eeeUL;
   tf->codes[5381] = 0x0000f09c180b44b3UL;
   tf->codes[5382] = 0x0000f09e61a17e65UL;
   tf->codes[5383] = 0x0000f09ed6bf89efUL;
   tf->codes[5384] = 0x0000f0a03619ac8dUL;
   tf->codes[5385] = 0x0000f0a070a8b252UL;
   tf->codes[5386] = 0x0000f0a12055c3a1UL;
   tf->codes[5387] = 0x0000f0a454281467UL;
   tf->codes[5388] = 0x0000f0a6632f4854UL;
   tf->codes[5389] = 0x0000f0a69dbe4e19UL;
   tf->codes[5390] = 0x0000f0a8e75487cbUL;
   tf->codes[5391] = 0x0000f0a95c729355UL;
   tf->codes[5392] = 0x0000f0af89882f1cUL;
   tf->codes[5393] = 0x0000f0b03935406bUL;
   tf->codes[5394] = 0x0000f0b12371577fUL;
   tf->codes[5395] = 0x0000f0b36d079131UL;
   tf->codes[5396] = 0x0000f0b45743a845UL;
   tf->codes[5397] = 0x0000f0b9d4ac32bdUL;
   tf->codes[5398] = 0x0000f0bb6e955b20UL;
   tf->codes[5399] = 0x0000f0c71913815fUL;
   tf->codes[5400] = 0x0000f0c9281ab54cUL;
   tf->codes[5401] = 0x0000f0cbac3ff4c3UL;
   tf->codes[5402] = 0x0000f0ccd10b119cUL;
   tf->codes[5403] = 0x0000f0cea5833fc4UL;
   tf->codes[5404] = 0x0000f0d0b48a73b1UL;
   tf->codes[5405] = 0x0000f0d45d7ad001UL;
   tf->codes[5406] = 0x0000f0d66c8203eeUL;
   tf->codes[5407] = 0x0000f0d71c2f153dUL;
   tf->codes[5408] = 0x0000f0f672b92baaUL;
   tf->codes[5409] = 0x0000f0f75cf542beUL;
   tf->codes[5410] = 0x0000f0fb4074a4d3UL;
   tf->codes[5411] = 0x0000f0fb7b03aa98UL;
   tf->codes[5412] = 0x0000f0fbf021b622UL;
   tf->codes[5413] = 0x0000f0ff5e830cadUL;
   tf->codes[5414] = 0x0000f108bf6af93aUL;
   tf->codes[5415] = 0x0000f109348904c4UL;
   tf->codes[5416] = 0x0000f1096f180a89UL;
   tf->codes[5417] = 0x0000f10a5954219dUL;
   tf->codes[5418] = 0x0000f10b090132ecUL;
   tf->codes[5419] = 0x0000f110fb87c8eeUL;
   tf->codes[5420] = 0x0000f1158eb43c52UL;
   tf->codes[5421] = 0x0000f115c9434217UL;
   tf->codes[5422] = 0x0000f118c2868d18UL;
   tf->codes[5423] = 0x0000f118fd1592ddUL;
   tf->codes[5424] = 0x0000f11ad18dc105UL;
   tf->codes[5425] = 0x0000f11b813ad254UL;
   tf->codes[5426] = 0x0000f11e7a7e1d55UL;
   tf->codes[5427] = 0x0000f12089855142UL;
   tf->codes[5428] = 0x0000f12139326291UL;
   tf->codes[5429] = 0x0000f1230daa90b9UL;
   tf->codes[5430] = 0x0000f131b16c01f9UL;
   tf->codes[5431] = 0x0000f13435914170UL;
   tf->codes[5432] = 0x0000f136b9b680e7UL;
   tf->codes[5433] = 0x0000f1388e2eaf0fUL;
   tf->codes[5434] = 0x0000f13bfc90059aUL;
   tf->codes[5435] = 0x0000f1413f698a4dUL;
   tf->codes[5436] = 0x0000f141b48795d7UL;
   tf->codes[5437] = 0x0000f14388ffc3ffUL;
   tf->codes[5438] = 0x0000f1460d250376UL;
   tf->codes[5439] = 0x0000f148914a42edUL;
   tf->codes[5440] = 0x0000f14906684e77UL;
   tf->codes[5441] = 0x0000f149f0a4658bUL;
   tf->codes[5442] = 0x0000f14aa05176daUL;
   tf->codes[5443] = 0x0000f15526048040UL;
   tf->codes[5444] = 0x0000f15560938605UL;
   tf->codes[5445] = 0x0000f15610409754UL;
   tf->codes[5446] = 0x0000f157aa29bfb7UL;
   tf->codes[5447] = 0x0000f1594412e81aUL;
   tf->codes[5448] = 0x0000f15bc8382791UL;
   tf->codes[5449] = 0x0000f160d082a67fUL;
   tf->codes[5450] = 0x0000f161f54dc358UL;
   tf->codes[5451] = 0x0000f162a4fad4a7UL;
   tf->codes[5452] = 0x0000f1631a18e031UL;
   tf->codes[5453] = 0x0000f1673827480bUL;
   tf->codes[5454] = 0x0000f167e7d4595aUL;
   tf->codes[5455] = 0x0000f16b1ba6aa20UL;
   tf->codes[5456] = 0x0000f16f744417bfUL;
   tf->codes[5457] = 0x0000f171f8695736UL;
   tf->codes[5458] = 0x0000f17775d1e1aeUL;
   tf->codes[5459] = 0x0000f177b060e773UL;
   tf->codes[5460] = 0x0000f1811148d400UL;
   tf->codes[5461] = 0x0000f1840a8c1f01UL;
   tf->codes[5462] = 0x0000f1868eb15e78UL;
   tf->codes[5463] = 0x0000f1902a2850caUL;
   tf->codes[5464] = 0x0000f191c411792dUL;
   tf->codes[5465] = 0x0000f19273be8a7cUL;
   tf->codes[5466] = 0x0000f1944836b8a4UL;
   tf->codes[5467] = 0x0000f196cc5bf81bUL;
   tf->codes[5468] = 0x0000f197417a03a5UL;
   tf->codes[5469] = 0x0000f197b6980f2fUL;
   tf->codes[5470] = 0x0000f198a0d42643UL;
   tf->codes[5471] = 0x0000f19915f231cdUL;
   tf->codes[5472] = 0x0000f19aafdb5a30UL;
   tf->codes[5473] = 0x0000f19b24f965baUL;
   tf->codes[5474] = 0x0000f1a0a261f032UL;
   tf->codes[5475] = 0x0000f1a1520f0181UL;
   tf->codes[5476] = 0x0000f1a5701d695bUL;
   tf->codes[5477] = 0x0000f1a7b9b3a30dUL;
   tf->codes[5478] = 0x0000f1b0e00c89d5UL;
   tf->codes[5479] = 0x0000f1b70d22259cUL;
   tf->codes[5480] = 0x0000f1b91c295989UL;
   tf->codes[5481] = 0x0000f1b956b85f4eUL;
   tf->codes[5482] = 0x0000f1b991476513UL;
   tf->codes[5483] = 0x0000f1bf493ef550UL;
   tf->codes[5484] = 0x0000f1c0a89917eeUL;
   tf->codes[5485] = 0x0000f1c6d5aeb3b5UL;
   tf->codes[5486] = 0x0000f1c7855bc504UL;
   tf->codes[5487] = 0x0000f1c8aa26e1ddUL;
   tf->codes[5488] = 0x0000f1ca0981047bUL;
   tf->codes[5489] = 0x0000f1cb2e4c2154UL;
   tf->codes[5490] = 0x0000f1cfc17894b8UL;
   tf->codes[5491] = 0x0000f1d2459dd42fUL;
   tf->codes[5492] = 0x0000f1d2f54ae57eUL;
   tf->codes[5493] = 0x0000f1d50452196bUL;
   tf->codes[5494] = 0x0000f1da81baa3e3UL;
   tf->codes[5495] = 0x0000f1dba685c0bcUL;
   tf->codes[5496] = 0x0000f1dbe114c681UL;
   tf->codes[5497] = 0x0000f1dc1ba3cc46UL;
   tf->codes[5498] = 0x0000f1e15e7d50f9UL;
   tf->codes[5499] = 0x0000f1e248b9680dUL;
   tf->codes[5500] = 0x0000f1e3e2a29070UL;
   tf->codes[5501] = 0x0000f1ed7e1982c2UL;
   tf->codes[5502] = 0x0000f1efc7afbc74UL;
   tf->codes[5503] = 0x0000f1f7c93d8663UL;
   tf->codes[5504] = 0x0000f1fb379edceeUL;
   tf->codes[5505] = 0x0000f1fc21daf402UL;
   tf->codes[5506] = 0x0000f1ff55ad44c8UL;
   tf->codes[5507] = 0x0000f2050da4d505UL;
   tf->codes[5508] = 0x0000f206326ff1deUL;
   tf->codes[5509] = 0x0000f20ee3aacd1cUL;
   tf->codes[5510] = 0x0000f2100875e9f5UL;
   tf->codes[5511] = 0x0000f2107d93f57fUL;
   tf->codes[5512] = 0x0000f210f2b20109UL;
   tf->codes[5513] = 0x0000f2128c9b296cUL;
   tf->codes[5514] = 0x0000f218f43fcaf8UL;
   tf->codes[5515] = 0x0000f2192eced0bdUL;
   tf->codes[5516] = 0x0000f219695dd682UL;
   tf->codes[5517] = 0x0000f21ac8b7f920UL;
   tf->codes[5518] = 0x0000f21d124e32d2UL;
   tf->codes[5519] = 0x0000f222ca45c30fUL;
   tf->codes[5520] = 0x0000f225fe1813d5UL;
   tf->codes[5521] = 0x0000f22798013c38UL;
   tf->codes[5522] = 0x0000f230493c1776UL;
   tf->codes[5523] = 0x0000f2360133a7b3UL;
   tf->codes[5524] = 0x0000f2384ac9e165UL;
   tf->codes[5525] = 0x0000f2393505f879UL;
   tf->codes[5526] = 0x0000f23bb92b37f0UL;
   tf->codes[5527] = 0x0000f23cddf654c9UL;
   tf->codes[5528] = 0x0000f23fd7399fcaUL;
   tf->codes[5529] = 0x0000f2430b0bf090UL;
   tf->codes[5530] = 0x0000f243f54807a4UL;
   tf->codes[5531] = 0x0000f244a4f518f3UL;
   tf->codes[5532] = 0x0000f246044f3b91UL;
   tf->codes[5533] = 0x0000f24813566f7eUL;
   tf->codes[5534] = 0x0000f24b4728c044UL;
   tf->codes[5535] = 0x0000f252990978e4UL;
   tf->codes[5536] = 0x0000f2530e27846eUL;
   tf->codes[5537] = 0x0000f25557bdbe20UL;
   tf->codes[5538] = 0x0000f256076acf6fUL;
   tf->codes[5539] = 0x0000f259b05b2bbfUL;
   tf->codes[5540] = 0x0000f25a25793749UL;
   tf->codes[5541] = 0x0000f25b4a445422UL;
   tf->codes[5542] = 0x0000f25b84d359e7UL;
   tf->codes[5543] = 0x0000f25bf9f16571UL;
   tf->codes[5544] = 0x0000f260c7acde9aUL;
   tf->codes[5545] = 0x0000f264360e3525UL;
   tf->codes[5546] = 0x0000f2688eaba2c4UL;
   tf->codes[5547] = 0x0000f26ef6504450UL;
   tf->codes[5548] = 0x0000f276bd4f087aUL;
   tf->codes[5549] = 0x0000f27906e5422cUL;
   tf->codes[5550] = 0x0000f27a663f64caUL;
   tf->codes[5551] = 0x0000f27c3ab792f2UL;
   tf->codes[5552] = 0x0000f27d24f3aa06UL;
   tf->codes[5553] = 0x0000f283c7275157UL;
   tf->codes[5554] = 0x0000f2843c455ce1UL;
   tf->codes[5555] = 0x0000f285268173f5UL;
   tf->codes[5556] = 0x0000f285611079baUL;
   tf->codes[5557] = 0x0000f2909670946fUL;
   tf->codes[5558] = 0x0000f291461da5beUL;
   tf->codes[5559] = 0x0000f2931a95d3e6UL;
   tf->codes[5560] = 0x0000f29479eff684UL;
   tf->codes[5561] = 0x0000f295299d07d3UL;
   tf->codes[5562] = 0x0000f2990d1c69e8UL;
   tf->codes[5563] = 0x0000f2a392cf734eUL;
   tf->codes[5564] = 0x0000f2a47d0b8a62UL;
   tf->codes[5565] = 0x0000f2a89b19f23cUL;
   tf->codes[5566] = 0x0000f2a9fa7414daUL;
   tf->codes[5567] = 0x0000f2aa6f922064UL;
   tf->codes[5568] = 0x0000f2acb9285a16UL;
   tf->codes[5569] = 0x0000f2acf3b75fdbUL;
   tf->codes[5570] = 0x0000f2b02789b0a1UL;
   tf->codes[5571] = 0x0000f2b0d736c1f0UL;
   tf->codes[5572] = 0x0000f2b44598187bUL;
   tf->codes[5573] = 0x0000f2b4f54529caUL;
   tf->codes[5574] = 0x0000f2b7b3f96f06UL;
   tf->codes[5575] = 0x0000f2b8d8c48bdfUL;
   tf->codes[5576] = 0x0000f2bb5ce9cb56UL;
   tf->codes[5577] = 0x0000f2bb9778d11bUL;
   tf->codes[5578] = 0x0000f2bc81b4e82fUL;
   tf->codes[5579] = 0x0000f2c14f706158UL;
   tf->codes[5580] = 0x0000f2c399069b0aUL;
   tf->codes[5581] = 0x0000f2c3d395a0cfUL;
   tf->codes[5582] = 0x0000f2c532efc36dUL;
   tf->codes[5583] = 0x0000f2c866c21433UL;
   tf->codes[5584] = 0x0000f2c950fe2b47UL;
   tf->codes[5585] = 0x0000f2c9c61c36d1UL;
   tf->codes[5586] = 0x0000f2cc4a417648UL;
   tf->codes[5587] = 0x0000f2d361932923UL;
   tf->codes[5588] = 0x0000f2d39c222ee8UL;
   tf->codes[5589] = 0x0000f2d7ba3096c2UL;
   tf->codes[5590] = 0x0000f2d82f4ea24cUL;
   tf->codes[5591] = 0x0000f2da03c6d074UL;
   tf->codes[5592] = 0x0000f2dbd83efe9cUL;
   tf->codes[5593] = 0x0000f2dcfd0a1b75UL;
   tf->codes[5594] = 0x0000f2e27a72a5edUL;
   tf->codes[5595] = 0x0000f2e53926eb29UL;
   tf->codes[5596] = 0x0000f2e62363023dUL;
   tf->codes[5597] = 0x0000f2eaf11e7b66UL;
   tf->codes[5598] = 0x0000f2f0a9160ba3UL;
   tf->codes[5599] = 0x0000f2f32d3b4b1aUL;
   tf->codes[5600] = 0x0000f2f3dce85c69UL;
   tf->codes[5601] = 0x0000f2f4520667f3UL;
   tf->codes[5602] = 0x0000f2f576d184ccUL;
   tf->codes[5603] = 0x0000f2f6d62ba76aUL;
   tf->codes[5604] = 0x0000f2f74b49b2f4UL;
   tf->codes[5605] = 0x0000f2f8aaa3d592UL;
   tf->codes[5606] = 0x0000f2fba3e72093UL;
   tf->codes[5607] = 0x0000f2ff1248771eUL;
   tf->codes[5608] = 0x0000f2fffc848e32UL;
   tf->codes[5609] = 0x0000f300e6c0a546UL;
   tf->codes[5610] = 0x0000f3020b8bc21fUL;
   tf->codes[5611] = 0x0000f306299a29f9UL;
   tf->codes[5612] = 0x0000f30713d6410dUL;
   tf->codes[5613] = 0x0000f30af755a322UL;
   tf->codes[5614] = 0x0000f31199894a73UL;
   tf->codes[5615] = 0x0000f31249365bc2UL;
   tf->codes[5616] = 0x0000f315f226b812UL;
   tf->codes[5617] = 0x0000f3216215d88cUL;
   tf->codes[5618] = 0x0000f32211c2e9dbUL;
   tf->codes[5619] = 0x0000f32a886ebf54UL;
   tf->codes[5620] = 0x0000f3307af55556UL;
   tf->codes[5621] = 0x0000f33632ece593UL;
   tf->codes[5622] = 0x0000f338b712250aUL;
   tf->codes[5623] = 0x0000f34217fa1197UL;
   tf->codes[5624] = 0x0000f3428d181d21UL;
   tf->codes[5625] = 0x0000f34795629c0fUL;
   tf->codes[5626] = 0x0000f3480a80a799UL;
   tf->codes[5627] = 0x0000f34bee0009aeUL;
   tf->codes[5628] = 0x0000f34cd83c20c2UL;
   tf->codes[5629] = 0x0000f350bbbb82d7UL;
   tf->codes[5630] = 0x0000f3521b15a575UL;
   tf->codes[5631] = 0x0000f359a78563daUL;
   tf->codes[5632] = 0x0000f35eea5ee88dUL;
   tf->codes[5633] = 0x0000f3679b99c3cbUL;
   tf->codes[5634] = 0x0000f371ac2ec1a7UL;
   tf->codes[5635] = 0x0000f37380a6efcfUL;
   tf->codes[5636] = 0x0000f374e001126dUL;
   tf->codes[5637] = 0x0000f37813d36333UL;
   tf->codes[5638] = 0x0000f3784e6268f8UL;
   tf->codes[5639] = 0x0000f379732d85d1UL;
   tf->codes[5640] = 0x0000f37b8234b9beUL;
   tf->codes[5641] = 0x0000f3830ea47823UL;
   tf->codes[5642] = 0x0000f387dc5ff14cUL;
   tf->codes[5643] = 0x0000f38a608530c3UL;
   tf->codes[5644] = 0x0000f38caa1b6a75UL;
   tf->codes[5645] = 0x0000f390530bc6c5UL;
   tf->codes[5646] = 0x0000f394aba93464UL;
   tf->codes[5647] = 0x0000f394e6383a29UL;
   tf->codes[5648] = 0x0000f3972fce73dbUL;
   tf->codes[5649] = 0x0000f3993ed5a7c8UL;
   tf->codes[5650] = 0x0000f39b886be17aUL;
   tf->codes[5651] = 0x0000f3a105d46bf2UL;
   tf->codes[5652] = 0x0000f3a1f0108306UL;
   tf->codes[5653] = 0x0000f3a3c488b12eUL;
   tf->codes[5654] = 0x0000f3a857b52492UL;
   tf->codes[5655] = 0x0000f3a8ccd3301cUL;
   tf->codes[5656] = 0x0000f3ab166969ceUL;
   tf->codes[5657] = 0x0000f3b2684a226eUL;
   tf->codes[5658] = 0x0000f3b402334ad1UL;
   tf->codes[5659] = 0x0000f3b43cc25096UL;
   tf->codes[5660] = 0x0000f3bb1984fdacUL;
   tf->codes[5661] = 0x0000f3c2e083c1d6UL;
   tf->codes[5662] = 0x0000f3c3cabfd8eaUL;
   tf->codes[5663] = 0x0000f3c52a19fb88UL;
   tf->codes[5664] = 0x0000f3c564a9014dUL;
   tf->codes[5665] = 0x0000f3c61456129cUL;
   tf->codes[5666] = 0x0000f3c8235d4689UL;
   tf->codes[5667] = 0x0000f3cd6636cb3cUL;
   tf->codes[5668] = 0x0000f3d442f97852UL;
   tf->codes[5669] = 0x0000f3d567c4952bUL;
   tf->codes[5670] = 0x0000f3d5a2539af0UL;
   tf->codes[5671] = 0x0000f3d73c3cc353UL;
   tf->codes[5672] = 0x0000f3dc44874241UL;
   tf->codes[5673] = 0x0000f3dcb9a54dcbUL;
   tf->codes[5674] = 0x0000f3e18760c6f4UL;
   tf->codes[5675] = 0x0000f3e480a411f5UL;
   tf->codes[5676] = 0x0000f3e73f585731UL;
   tf->codes[5677] = 0x0000f3ebd284ca95UL;
   tf->codes[5678] = 0x0000f3f0a04043beUL;
   tf->codes[5679] = 0x0000f3f40ea19a49UL;
   tf->codes[5680] = 0x0000f3f98c0a24c1UL;
   tf->codes[5681] = 0x0000f3f9c6992a86UL;
   tf->codes[5682] = 0x0000f4002e3dcc12UL;
   tf->codes[5683] = 0x0000f40068ccd1d7UL;
   tf->codes[5684] = 0x0000f400a35bd79cUL;
   tf->codes[5685] = 0x0000f4039c9f229dUL;
   tf->codes[5686] = 0x0000f406d0717363UL;
   tf->codes[5687] = 0x0000f40a0443c429UL;
   tf->codes[5688] = 0x0000f40aee7fdb3dUL;
   tf->codes[5689] = 0x0000f412f00da52cUL;
   tf->codes[5690] = 0x0000f4144f67c7caUL;
   tf->codes[5691] = 0x0000f414ff14d919UL;
   tf->codes[5692] = 0x0000f41698fe017cUL;
   tf->codes[5693] = 0x0000f4186d762fa4UL;
   tf->codes[5694] = 0x0000f41b2c2a74e0UL;
   tf->codes[5695] = 0x0000f41ba148806aUL;
   tf->codes[5696] = 0x0000f4203474f3ceUL;
   tf->codes[5697] = 0x0000f425774e7881UL;
   tf->codes[5698] = 0x0000f4269c19955aUL;
   tf->codes[5699] = 0x0000f4271137a0e4UL;
   tf->codes[5700] = 0x0000f429203ed4d1UL;
   tf->codes[5701] = 0x0000f4295acdda96UL;
   tf->codes[5702] = 0x0000f42a0a7aebe5UL;
   tf->codes[5703] = 0x0000f42c54112597UL;
   tf->codes[5704] = 0x0000f4315c5ba485UL;
   tf->codes[5705] = 0x0000f4328126c15eUL;
   tf->codes[5706] = 0x0000f432bbb5c723UL;
   tf->codes[5707] = 0x0000f432f644cce8UL;
   tf->codes[5708] = 0x0000f433e080e3fcUL;
   tf->codes[5709] = 0x0000f437fe8f4bd6UL;
   tf->codes[5710] = 0x0000f438391e519bUL;
   tf->codes[5711] = 0x0000f439d30779feUL;
   tf->codes[5712] = 0x0000f43a82b48b4dUL;
   tf->codes[5713] = 0x0000f4403aac1b8aUL;
   tf->codes[5714] = 0x0000f44493498929UL;
   tf->codes[5715] = 0x0000f4462d32b18cUL;
   tf->codes[5716] = 0x0000f450ed74c0b7UL;
   tf->codes[5717] = 0x0000f45496651d07UL;
   tf->codes[5718] = 0x0000f455bb3039e0UL;
   tf->codes[5719] = 0x0000f4599eaf9bf5UL;
   tf->codes[5720] = 0x0000f459d93ea1baUL;
   tf->codes[5721] = 0x0000f45ac37ab8ceUL;
   tf->codes[5722] = 0x0000f45afe09be93UL;
   tf->codes[5723] = 0x0000f460f0905495UL;
   tf->codes[5724] = 0x0000f462155b716eUL;
   tf->codes[5725] = 0x0000f4624fea7733UL;
   tf->codes[5726] = 0x0000f46374b5940cUL;
   tf->codes[5727] = 0x0000f465f8dad383UL;
   tf->codes[5728] = 0x0000f4666df8df0dUL;
   tf->codes[5729] = 0x0000f467cd5301abUL;
   tf->codes[5730] = 0x0000f46842710d35UL;
   tf->codes[5731] = 0x0000f46b3bb45836UL;
   tf->codes[5732] = 0x0000f46d102c865eUL;
   tf->codes[5733] = 0x0000f4728d9510d6UL;
   tf->codes[5734] = 0x0000f4749c9c44c3UL;
   tf->codes[5735] = 0x0000f474d72b4a88UL;
   tf->codes[5736] = 0x0000f47720c1843aUL;
   tf->codes[5737] = 0x0000f47e72a23cdaUL;
   tf->codes[5738] = 0x0000f48131568216UL;
   tf->codes[5739] = 0x0000f48305ceb03eUL;
   tf->codes[5740] = 0x0000f48514d5e42bUL;
   tf->codes[5741] = 0x0000f4880e192f2cUL;
   tf->codes[5742] = 0x0000f489a802578fUL;
   tf->codes[5743] = 0x0000f48b41eb7ff2UL;
   tf->codes[5744] = 0x0000f48d8b81b9a4UL;
   tf->codes[5745] = 0x0000f48dc610bf69UL;
   tf->codes[5746] = 0x0000f48fd517f356UL;
   tf->codes[5747] = 0x0000f499ab1deb6dUL;
   tf->codes[5748] = 0x0000f49c69d230a9UL;
   tf->codes[5749] = 0x0000f4a3f641ef0eUL;
   tf->codes[5750] = 0x0000f4a8fe8c6dfcUL;
   tf->codes[5751] = 0x0000f4aca77cca4cUL;
   tf->codes[5752] = 0x0000f4ace20bd011UL;
   tf->codes[5753] = 0x0000f4ad5729db9bUL;
   tf->codes[5754] = 0x0000f4b015de20d7UL;
   tf->codes[5755] = 0x0000f4b1001a37ebUL;
   tf->codes[5756] = 0x0000f4b25f745a89UL;
   tf->codes[5757] = 0x0000f4b29a03604eUL;
   tf->codes[5758] = 0x0000f4b30f216bd8UL;
   tf->codes[5759] = 0x0000f4b6b811c828UL;
   tf->codes[5760] = 0x0000f4b93c37079fUL;
   tf->codes[5761] = 0x0000f4bb85cd4151UL;
   tf->codes[5762] = 0x0000f4c10335cbc9UL;
   tf->codes[5763] = 0x0000f4c29d1ef42cUL;
   tf->codes[5764] = 0x0000f4c3123cffb6UL;
   tf->codes[5765] = 0x0000f4c34ccc057bUL;
   tf->codes[5766] = 0x0000f4c4ac262819UL;
   tf->codes[5767] = 0x0000f4c855168469UL;
   tf->codes[5768] = 0x0000f4ca641db856UL;
   tf->codes[5769] = 0x0000f4d09133541dUL;
   tf->codes[5770] = 0x0000f4d22b1c7c80UL;
   tf->codes[5771] = 0x0000f4d265ab8245UL;
   tf->codes[5772] = 0x0000f4d6492ae45aUL;
   tf->codes[5773] = 0x0000f4d81da31282UL;
   tf->codes[5774] = 0x0000f4d8cd5023d1UL;
   tf->codes[5775] = 0x0000f4e1096cf385UL;
   tf->codes[5776] = 0x0000f4e22e38105eUL;
   tf->codes[5777] = 0x0000f4e268c71623UL;
   tf->codes[5778] = 0x0000f4e318742772UL;
   tf->codes[5779] = 0x0000f4e402b03e86UL;
   tf->codes[5780] = 0x0000f4e686d57dfdUL;
   tf->codes[5781] = 0x0000f4ea6a54e012UL;
   tf->codes[5782] = 0x0000f4eb5490f726UL;
   tf->codes[5783] = 0x0000f4f1bc3598b2UL;
   tf->codes[5784] = 0x0000f4f3561ec115UL;
   tf->codes[5785] = 0x0000f4f5da44008cUL;
   tf->codes[5786] = 0x0000f5005ff709f2UL;
   tf->codes[5787] = 0x0000f50393c95ab8UL;
   tf->codes[5788] = 0x0000f505684188e0UL;
   tf->codes[5789] = 0x0000f51864a067bfUL;
   tf->codes[5790] = 0x0000f518d9be7349UL;
   tf->codes[5791] = 0x0000f51c481fc9d4UL;
   tf->codes[5792] = 0x0000f5223aa65fd6UL;
   tf->codes[5793] = 0x0000f522afc46b60UL;
   tf->codes[5794] = 0x0000f524f95aa512UL;
   tf->codes[5795] = 0x0000f5298c871876UL;
   tf->codes[5796] = 0x0000f52a01a52400UL;
   tf->codes[5797] = 0x0000f52bd61d5228UL;
   tf->codes[5798] = 0x0000f5315385dca0UL;
   tf->codes[5799] = 0x0000f5323dc1f3b4UL;
   tf->codes[5800] = 0x0000f53537053eb5UL;
   tf->codes[5801] = 0x0000f536965f6153UL;
   tf->codes[5802] = 0x0000f5391a84a0caUL;
   tf->codes[5803] = 0x0000f5448a73c144UL;
   tf->codes[5804] = 0x0000f546245ce9a7UL;
   tf->codes[5805] = 0x0000f5470e9900bbUL;
   tf->codes[5806] = 0x0000f547be46120aUL;
   tf->codes[5807] = 0x0000f54a426b5181UL;
   tf->codes[5808] = 0x0000f54b2ca76895UL;
   tf->codes[5809] = 0x0000f54ffa62e1beUL;
   tf->codes[5810] = 0x0000f5532e353284UL;
   tf->codes[5811] = 0x0000f55368c43849UL;
   tf->codes[5812] = 0x0000f55920bbc886UL;
   tf->codes[5813] = 0x0000f560ad2b86ebUL;
   tf->codes[5814] = 0x0000f5657ae70014UL;
   tf->codes[5815] = 0x0000f565f0050b9eUL;
   tf->codes[5816] = 0x0000f568742a4b15UL;
   tf->codes[5817] = 0x0000f5695e666229UL;
   tf->codes[5818] = 0x0000f56c57a9ad2aUL;
   tf->codes[5819] = 0x0000f56d0756be79UL;
   tf->codes[5820] = 0x0000f56e66b0e117UL;
   tf->codes[5821] = 0x0000f573a98a65caUL;
   tf->codes[5822] = 0x0000f5812880ba31UL;
   tf->codes[5823] = 0x0000f58212bcd145UL;
   tf->codes[5824] = 0x0000f585468f220bUL;
   tf->codes[5825] = 0x0000f586e0784a6eUL;
   tf->codes[5826] = 0x0000f5871b075033UL;
   tf->codes[5827] = 0x0000f58cd2fee070UL;
   tf->codes[5828] = 0x0000f58d82abf1bfUL;
   tf->codes[5829] = 0x0000f58ea7770e98UL;
   tf->codes[5830] = 0x0000f5950f1bb024UL;
   tf->codes[5831] = 0x0000f596a904d887UL;
   tf->codes[5832] = 0x0000f59758b1e9d6UL;
   tf->codes[5833] = 0x0000f59c60fc68c4UL;
   tf->codes[5834] = 0x0000f5a8460994c8UL;
   tf->codes[5835] = 0x0000f5a9a563b766UL;
   tf->codes[5836] = 0x0000f5aa1a81c2f0UL;
   tf->codes[5837] = 0x0000f5ab04bdda04UL;
   tf->codes[5838] = 0x0000f5abeef9f118UL;
   tf->codes[5839] = 0x0000f5ae731f308fUL;
   tf->codes[5840] = 0x0000f5b21c0f8cdfUL;
   tf->codes[5841] = 0x0000f5b4a034cc56UL;
   tf->codes[5842] = 0x0000f5b5c4ffe92fUL;
   tf->codes[5843] = 0x0000f5b63a1df4b9UL;
   tf->codes[5844] = 0x0000f5b674acfa7eUL;
   tf->codes[5845] = 0x0000f5bca1c29645UL;
   tf->codes[5846] = 0x0000f5c21f2b20bdUL;
   tf->codes[5847] = 0x0000f5c259ba2682UL;
   tf->codes[5848] = 0x0000f5c58d8c7748UL;
   tf->codes[5849] = 0x0000f5c84c40bc84UL;
   tf->codes[5850] = 0x0000f5d25cd5ba60UL;
   tf->codes[5851] = 0x0000f5d381a0d739UL;
   tf->codes[5852] = 0x0000f5d640551c75UL;
   tf->codes[5853] = 0x0000f5d6b57327ffUL;
   tf->codes[5854] = 0x0000f5d7da3e44d8UL;
   tf->codes[5855] = 0x0000f5d8c47a5becUL;
   tf->codes[5856] = 0x0000f5da5e63844fUL;
   tf->codes[5857] = 0x0000f5dad3818fd9UL;
   tf->codes[5858] = 0x0000f5dca7f9be01UL;
   tf->codes[5859] = 0x0000f5e08b792016UL;
   tf->codes[5860] = 0x0000f5e13b263165UL;
   tf->codes[5861] = 0x0000f5e225624879UL;
   tf->codes[5862] = 0x0000f5e46ef8822bUL;
   tf->codes[5863] = 0x0000f5ebfb684090UL;
   tf->codes[5864] = 0x0000f5f08e94b3f4UL;
   tf->codes[5865] = 0x0000f5f13e41c543UL;
   tf->codes[5866] = 0x0000f5f6468c4431UL;
   tf->codes[5867] = 0x0000f5fa9f29b1d0UL;
   tf->codes[5868] = 0x0000f5ff32562534UL;
   tf->codes[5869] = 0x0000f6001c923c48UL;
   tf->codes[5870] = 0x0000f60091b047d2UL;
   tf->codes[5871] = 0x0000f601f10a6a70UL;
   tf->codes[5872] = 0x0000f602a0b77bbfUL;
   tf->codes[5873] = 0x0000f6060f18d24aUL;
   tf->codes[5874] = 0x0000f60649a7d80fUL;
   tf->codes[5875] = 0x0000f607a901faadUL;
   tf->codes[5876] = 0x0000f607e3910072UL;
   tf->codes[5877] = 0x0000f608933e11c1UL;
   tf->codes[5878] = 0x0000f6114478ecffUL;
   tf->codes[5879] = 0x0000f612de621562UL;
   tf->codes[5880] = 0x0000f61aa560d98cUL;
   tf->codes[5881] = 0x0000f61b8f9cf0a0UL;
   tf->codes[5882] = 0x0000f61c3f4a01efUL;
   tf->codes[5883] = 0x0000f61ec36f4166UL;
   tf->codes[5884] = 0x0000f61fadab587aUL;
   tf->codes[5885] = 0x0000f621822386a2UL;
   tf->codes[5886] = 0x0000f624f084dd2dUL;
   tf->codes[5887] = 0x0000f6252b13e2f2UL;
   tf->codes[5888] = 0x0000f625dac0f441UL;
   tf->codes[5889] = 0x0000f628d4043f42UL;
   tf->codes[5890] = 0x0000f62d6730b2a6UL;
   tf->codes[5891] = 0x0000f62e516cc9baUL;
   tf->codes[5892] = 0x0000f6347e826581UL;
   tf->codes[5893] = 0x0000f63a7108fb83UL;
   tf->codes[5894] = 0x0000f63c458129abUL;
   tf->codes[5895] = 0x0000f6439761e24bUL;
   tf->codes[5896] = 0x0000f64705c338d6UL;
   tf->codes[5897] = 0x0000f655a984aa16UL;
   tf->codes[5898] = 0x0000f6565931bb65UL;
   tf->codes[5899] = 0x0000f65b9c0b4018UL;
   tf->codes[5900] = 0x0000f6602f37b37cUL;
   tf->codes[5901] = 0x0000f66203afe1a4UL;
   tf->codes[5902] = 0x0000f67d3c2b9037UL;
   tf->codes[5903] = 0x0000f67d76ba95fcUL;
   tf->codes[5904] = 0x0000f6815a39f811UL;
   tf->codes[5905] = 0x0000f68209e70960UL;
   tf->codes[5906] = 0x0000f690e8378065UL;
   tf->codes[5907] = 0x0000f6915d558befUL;
   tf->codes[5908] = 0x0000f69fc687f76aUL;
   tf->codes[5909] = 0x0000f6a19b002592UL;
   tf->codes[5910] = 0x0000f6a2101e311cUL;
   tf->codes[5911] = 0x0000f6a802a4c71eUL;
   tf->codes[5912] = 0x0000f6aa4c3b00d0UL;
   tf->codes[5913] = 0x0000f6b3e7b1f322UL;
   tf->codes[5914] = 0x0000f6b5bc2a214aUL;
   tf->codes[5915] = 0x0000f6c2c6026a27UL;
   tf->codes[5916] = 0x0000f6c3b03e813bUL;
   tf->codes[5917] = 0x0000f6c8b8890029UL;
   tf->codes[5918] = 0x0000f6d07f87c453UL;
   tf->codes[5919] = 0x0000f6d0ba16ca18UL;
   tf->codes[5920] = 0x0000f6d33e3c098fUL;
   tf->codes[5921] = 0x0000f6da558dbc6aUL;
   tf->codes[5922] = 0x0000f6df23493593UL;
   tf->codes[5923] = 0x0000f6e291aa8c1eUL;
   tf->codes[5924] = 0x0000f6e515cfcb95UL;
   tf->codes[5925] = 0x0000f6e5505ed15aUL;
   tf->codes[5926] = 0x0000f6e6000be2a9UL;
   tf->codes[5927] = 0x0000f6e6afb8f3f8UL;
   tf->codes[5928] = 0x0000f6ebf29278abUL;
   tf->codes[5929] = 0x0000f6f0c04df1d4UL;
   tf->codes[5930] = 0x0000f6f6b2d487d6UL;
   tf->codes[5931] = 0x0000f6f84cbdb039UL;
   tf->codes[5932] = 0x0000f7004e4b7a28UL;
   tf->codes[5933] = 0x0000f7059124fedbUL;
   tf->codes[5934] = 0x0000f70606430a65UL;
   tf->codes[5935] = 0x0000f70974a460f0UL;
   tf->codes[5936] = 0x0000f7134aaa5907UL;
   tf->codes[5937] = 0x0000f718c812e37fUL;
   tf->codes[5938] = 0x0000f71977bff4ceUL;
   tf->codes[5939] = 0x0000f71b86c728bbUL;
   tf->codes[5940] = 0x0000f71c36743a0aUL;
   tf->codes[5941] = 0x0000f7260c7a3221UL;
   tf->codes[5942] = 0x0000f7322c1663eaUL;
   tf->codes[5943] = 0x0000f7338b708688UL;
   tf->codes[5944] = 0x0000f734008e9212UL;
   tf->codes[5945] = 0x0000f73684b3d189UL;
   tf->codes[5946] = 0x0000f737e40df427UL;
   tf->codes[5947] = 0x0000f73aa2c23963UL;
   tf->codes[5948] = 0x0000f73b526f4ab2UL;
   tf->codes[5949] = 0x0000f7443e392bb5UL;
   tf->codes[5950] = 0x0000f745287542c9UL;
   tf->codes[5951] = 0x0000f74ec3ec351bUL;
   tf->codes[5952] = 0x0000f74fe8b751f4UL;
   tf->codes[5953] = 0x0000f75148117492UL;
   tf->codes[5954] = 0x0000f752324d8ba6UL;
   tf->codes[5955] = 0x0000f757000904cfUL;
   tf->codes[5956] = 0x0000f758d48132f7UL;
   tf->codes[5957] = 0x0000f75aa8f9611fUL;
   tf->codes[5958] = 0x0000f760d60efce6UL;
   tf->codes[5959] = 0x0000f7735d4fd03bUL;
   tf->codes[5960] = 0x0000f778dab85ab3UL;
   tf->codes[5961] = 0x0000f77f07cdf67aUL;
   tf->codes[5962] = 0x0000f783606b6419UL;
   tf->codes[5963] = 0x0000f786943db4dfUL;
   tf->codes[5964] = 0x0000f78e5b3c7909UL;
   tf->codes[5965] = 0x0000f795ad1d31a9UL;
   tf->codes[5966] = 0x0000f799909c93beUL;
   tf->codes[5967] = 0x0000f79ab567b097UL;
   tf->codes[5968] = 0x0000f7a366a28bd5UL;
   tf->codes[5969] = 0x0000f7a9ce472d61UL;
   tf->codes[5970] = 0x0000f7adec55953bUL;
   tf->codes[5971] = 0x0000f7b69d907079UL;
   tf->codes[5972] = 0x0000f7b8377998dcUL;
   tf->codes[5973] = 0x0000f7b95c44b5b5UL;
   tf->codes[5974] = 0x0000f7ba810fd28eUL;
   tf->codes[5975] = 0x0000f7c2480e96b8UL;
   tf->codes[5976] = 0x0000f7c4cc33d62fUL;
   tf->codes[5977] = 0x0000f7c6db3b0a1cUL;
   tf->codes[5978] = 0x0000f7d5f41a86e6UL;
   tf->codes[5979] = 0x0000f7d80321bad3UL;
   tf->codes[5980] = 0x0000f7d8783fc65dUL;
   tf->codes[5981] = 0x0000f7ebe9bcb0c6UL;
   tf->codes[5982] = 0x0000f7f3b0bb74f0UL;
   tf->codes[5983] = 0x0000f7fc61f6502eUL;
   tf->codes[5984] = 0x0000f802547ce630UL;
   tf->codes[5985] = 0x0000f8028f0bebf5UL;
   tf->codes[5986] = 0x0000f802c99af1baUL;
   tf->codes[5987] = 0x0000f80bb564d2bdUL;
   tf->codes[5988] = 0x0000f81341d49122UL;
   tf->codes[5989] = 0x0000f8137c6396e7UL;
   tf->codes[5990] = 0x0000f8163b17dc23UL;
   tf->codes[5991] = 0x0000f81bf30f6c60UL;
   tf->codes[5992] = 0x0000f81c682d77eaUL;
   tf->codes[5993] = 0x0000f81eb1c3b19cUL;
   tf->codes[5994] = 0x0000f82135e8f113UL;
   tf->codes[5995] = 0x0000f821e5960262UL;
   tf->codes[5996] = 0x0000f82220250827UL;
   tf->codes[5997] = 0x0000f824a44a479eUL;
   tf->codes[5998] = 0x0000f825c9156477UL;
   tf->codes[5999] = 0x0000f8293776bb02UL;
   tf->codes[6000] = 0x0000f82a5c41d7dbUL;
   tf->codes[6001] = 0x0000f831e8b19640UL;
   tf->codes[6002] = 0x0000f833f7b8ca2dUL;
   tf->codes[6003] = 0x0000f83c33d599e1UL;
   tf->codes[6004] = 0x0000f8408c730780UL;
   tf->codes[6005] = 0x0000f84385b65281UL;
   tf->codes[6006] = 0x0000f844aa816f5aUL;
   tf->codes[6007] = 0x0000f8472ea6aed1UL;
   tf->codes[6008] = 0x0000f847de53c020UL;
   tf->codes[6009] = 0x0000f84a9d08055cUL;
   tf->codes[6010] = 0x0000f84bc1d32235UL;
   tf->codes[6011] = 0x0000f85522bb0ec2UL;
   tf->codes[6012] = 0x0000f85c3a0cc19dUL;
   tf->codes[6013] = 0x0000f861f20451daUL;
   tf->codes[6014] = 0x0000f8668530c53eUL;
   tf->codes[6015] = 0x0000f867a9fbe217UL;
   tf->codes[6016] = 0x0000f86b8d7b442cUL;
   tf->codes[6017] = 0x0000f87020a7b790UL;
   tf->codes[6018] = 0x0000f871f51fe5b8UL;
   tf->codes[6019] = 0x0000f873547a0856UL;
   tf->codes[6020] = 0x0000f8747945252fUL;
   tf->codes[6021] = 0x0000f8764dbd5357UL;
   tf->codes[6022] = 0x0000f876fd6a64a6UL;
   tf->codes[6023] = 0x0000f87fe93445a9UL;
   tf->codes[6024] = 0x0000f88441d1b348UL;
   tf->codes[6025] = 0x0000f88775a4040eUL;
   tf->codes[6026] = 0x0000f88a6ee74f0fUL;
   tf->codes[6027] = 0x0000f88fec4fd987UL;
   tf->codes[6028] = 0x0000f891863901eaUL;
   tf->codes[6029] = 0x0000f891fb570d74UL;
   tf->codes[6030] = 0x0000f892707518feUL;
   tf->codes[6031] = 0x0000f892e5932488UL;
   tf->codes[6032] = 0x0000f8935ab13012UL;
   tf->codes[6033] = 0x0000f89778bf97ecUL;
   tf->codes[6034] = 0x0000f89c467b1115UL;
   tf->codes[6035] = 0x0000f89f7a4d61dbUL;
   tf->codes[6036] = 0x0000f8a029fa732aUL;
   tf->codes[6037] = 0x0000f8a0648978efUL;
   tf->codes[6038] = 0x0000f8a706bd2040UL;
   tf->codes[6039] = 0x0000f8ae589dd8e0UL;
   tf->codes[6040] = 0x0000f8b4fad18031UL;
   tf->codes[6041] = 0x0000f8b9c88cf95aUL;
   tf->codes[6042] = 0x0000f8bb627621bdUL;
   tf->codes[6043] = 0x0000f8bff5a29521UL;
   tf->codes[6044] = 0x0000f8c154fcb7bfUL;
   tf->codes[6045] = 0x0000f8c65d4736adUL;
   tf->codes[6046] = 0x0000f8c697d63c72UL;
   tf->codes[6047] = 0x0000f8c9568a81aeUL;
   tf->codes[6048] = 0x0000f8d416cc90d9UL;
   tf->codes[6049] = 0x0000f8d48bea9c63UL;
   tf->codes[6050] = 0x0000f8db2e1e43b4UL;
   tf->codes[6051] = 0x0000f8ded70ea004UL;
   tf->codes[6052] = 0x0000f8e120a4d9b6UL;
   tf->codes[6053] = 0x0000f8e628ef58a4UL;
   tf->codes[6054] = 0x0000f8ec5604f46bUL;
   tf->codes[6055] = 0x0000f8fc59208849UL;
   tf->codes[6056] = 0x0000f916e1ef258dUL;
   tf->codes[6057] = 0x0000f9192b855f3fUL;
   tf->codes[6058] = 0x0000f91bea39a47bUL;
   tf->codes[6059] = 0x0000f91f589afb06UL;
   tf->codes[6060] = 0x0000f920f2842369UL;
   tf->codes[6061] = 0x0000f922c6fc5191UL;
   tf->codes[6062] = 0x0000f923018b5756UL;
   tf->codes[6063] = 0x0000f927cf46d07fUL;
   tf->codes[6064] = 0x0000f9292ea0f31dUL;
   tf->codes[6065] = 0x0000f931a54cc896UL;
   tf->codes[6066] = 0x0000f935c35b3070UL;
   tf->codes[6067] = 0x0000f93c2affd1fcUL;
   tf->codes[6068] = 0x0000f93d8a59f49aUL;
   tf->codes[6069] = 0x0000f93e74960baeUL;
   tf->codes[6070] = 0x0000f943b76f9061UL;
   tf->codes[6071] = 0x0000f945c676c44eUL;
   tf->codes[6072] = 0x0000f947d57df83bUL;
   tf->codes[6073] = 0x0000f94acec1433cUL;
   tf->codes[6074] = 0x0000f94b7e6e548bUL;
   tf->codes[6075] = 0x0000f94d18577ceeUL;
   tf->codes[6076] = 0x0000f950c147d93eUL;
   tf->codes[6077] = 0x0000f953456d18b5UL;
   tf->codes[6078] = 0x0000f957637b808fUL;
   tf->codes[6079] = 0x0000f958132891deUL;
   tf->codes[6080] = 0x0000f95a5cbecb90UL;
   tf->codes[6081] = 0x0000f9604f456192UL;
   tf->codes[6082] = 0x0000f969759e485aUL;
   tf->codes[6083] = 0x0000f96bf9c387d1UL;
   tf->codes[6084] = 0x0000f96d591daa6fUL;
   tf->codes[6085] = 0x0000f971b1bb180eUL;
   tf->codes[6086] = 0x0000f97386334636UL;
   tf->codes[6087] = 0x0000f97b4d320a60UL;
   tf->codes[6088] = 0x0000f984ae19f6edUL;
   tf->codes[6089] = 0x0000f988570a533dUL;
   tf->codes[6090] = 0x0000f996108fad69UL;
   tf->codes[6091] = 0x0000f997aa78d5ccUL;
   tf->codes[6092] = 0x0000f99a2e9e1543UL;
   tf->codes[6093] = 0x0000f9a59e8d35bdUL;
   tf->codes[6094] = 0x0000f9a5d91c3b82UL;
   tf->codes[6095] = 0x0000f9ab5684c5faUL;
   tf->codes[6096] = 0x0000f9c0275bd301UL;
   tf->codes[6097] = 0x0000f9cd6bc321a3UL;
   tf->codes[6098] = 0x0000f9d02a7766dfUL;
   tf->codes[6099] = 0x0000f9d5a7dff157UL;
   tf->codes[6100] = 0x0000f9d8dbb2421dUL;
   tf->codes[6101] = 0x0000f9d950d04da7UL;
   tf->codes[6102] = 0x0000f9dd344fafbcUL;
   tf->codes[6103] = 0x0000f9e1c77c2320UL;
   tf->codes[6104] = 0x0000f9f36480df61UL;
   tf->codes[6105] = 0x0000f9f39f0fe526UL;
   tf->codes[6106] = 0x0000f9fdea33e8c7UL;
   tf->codes[6107] = 0x0000f9ff841d112aUL;
   tf->codes[6108] = 0x0000fa041749848eUL;
   tf->codes[6109] = 0x0000fa07c039e0deUL;
   tf->codes[6110] = 0x0000fa0bde4848b8UL;
   tf->codes[6111] = 0x0000fa1663fb521eUL;
   tf->codes[6112] = 0x0000fa187302860bUL;
   tf->codes[6113] = 0x0000fa1922af975aUL;
   tf->codes[6114] = 0x0000fa1be163dc96UL;
   tf->codes[6115] = 0x0000fa215ecc670eUL;
   tf->codes[6116] = 0x0000fa2507bcc35eUL;
   tf->codes[6117] = 0x0000fa2925cb2b38UL;
   tf->codes[6118] = 0x0000fa319c7700b1UL;
   tf->codes[6119] = 0x0000fa33e60d3a63UL;
   tf->codes[6120] = 0x0000fa37546e90eeUL;
   tf->codes[6121] = 0x0000fa424f3fa5deUL;
   tf->codes[6122] = 0x0000fa43ae99c87cUL;
   tf->codes[6123] = 0x0000fa48f1734d2fUL;
   tf->codes[6124] = 0x0000fa4a50cd6fcdUL;
   tf->codes[6125] = 0x0000fa4e344cd1e2UL;
   tf->codes[6126] = 0x0000fa5a8e780970UL;
   tf->codes[6127] = 0x0000fa65142b12d6UL;
   tf->codes[6128] = 0x0000fa6dfff4f3d9UL;
   tf->codes[6129] = 0x0000fa70bea93915UL;
   tf->codes[6130] = 0x0000fa7e782e9341UL;
   tf->codes[6131] = 0x0000fa801217bba4UL;
   tf->codes[6132] = 0x0000fa804ca6c169UL;
   tf->codes[6133] = 0x0000fa80c1c4ccf3UL;
   tf->codes[6134] = 0x0000fa8ef06832a9UL;
   tf->codes[6135] = 0x0000fa94a85fc2e6UL;
   tf->codes[6136] = 0x0000fa951d7dce70UL;
   tf->codes[6137] = 0x0000fa95929bd9faUL;
   tf->codes[6138] = 0x0000fa964248eb49UL;
   tf->codes[6139] = 0x0000fa9767140822UL;
   tf->codes[6140] = 0x0000fa9f68a1d211UL;
   tf->codes[6141] = 0x0000faa08d6ceeeaUL;
   tf->codes[6142] = 0x0000faa13d1a0039UL;
   tf->codes[6143] = 0x0000faa6f5119076UL;
   tf->codes[6144] = 0x0000faa76a2f9c00UL;
   tf->codes[6145] = 0x0000faa9b3c5d5b2UL;
   tf->codes[6146] = 0x0000faad974537c7UL;
   tf->codes[6147] = 0x0000fab140359417UL;
   tf->codes[6148] = 0x0000fab6830f18caUL;
   tf->codes[6149] = 0x0000fac317c9561dUL;
   tf->codes[6150] = 0x0000facc03933720UL;
   tf->codes[6151] = 0x0000fad2e055e436UL;
   tf->codes[6152] = 0x0000fad47a3f0c99UL;
   tf->codes[6153] = 0x0000fad8232f68e9UL;
   tf->codes[6154] = 0x0000fad85dbe6eaeUL;
   tf->codes[6155] = 0x0000fadbcc1fc539UL;
   tf->codes[6156] = 0x0000fadcf0eae212UL;
   tf->codes[6157] = 0x0000fadddb26f926UL;
   tf->codes[6158] = 0x0000fade504504b0UL;
   tf->codes[6159] = 0x0000fae05f4c389dUL;
   tf->codes[6160] = 0x0000fae184175576UL;
   tf->codes[6161] = 0x0000faec445964a1UL;
   tf->codes[6162] = 0x0000faef030da9ddUL;
   tf->codes[6163] = 0x0000faf236dffaa3UL;
   tf->codes[6164] = 0x0000faf8296690a5UL;
   tf->codes[6165] = 0x0000faf988c0b343UL;
   tf->codes[6166] = 0x0000fb0aeb3669bfUL;
   tf->codes[6167] = 0x0000fb11184c0586UL;
   tf->codes[6168] = 0x0000fb1486ad5c11UL;
   tf->codes[6169] = 0x0000fb15e6077eafUL;
   tf->codes[6170] = 0x0000fb1f46ef6b3cUL;
   tf->codes[6171] = 0x0000fb206bba8815UL;
   tf->codes[6172] = 0x0000fb219085a4eeUL;
   tf->codes[6173] = 0x0000fb253976013eUL;
   tf->codes[6174] = 0x0000fb26d35f29a1UL;
   tf->codes[6175] = 0x0000fb3577209ae1UL;
   tf->codes[6176] = 0x0000fb42bb87e983UL;
   tf->codes[6177] = 0x0000fb495dbb90d4UL;
   tf->codes[6178] = 0x0000fb515f495ac3UL;
   tf->codes[6179] = 0x0000fb57c6edfc4fUL;
   tf->codes[6180] = 0x0000fb599b662a77UL;
   tf->codes[6181] = 0x0000fb5b354f52daUL;
   tf->codes[6182] = 0x0000fb658073567bUL;
   tf->codes[6183] = 0x0000fb65f5916205UL;
   tf->codes[6184] = 0x0000fb750e70decfUL;
   tf->codes[6185] = 0x0000fb7548ffe494UL;
   tf->codes[6186] = 0x0000fb77cd25240bUL;
   tf->codes[6187] = 0x0000fb7e6f58cb5cUL;
   tf->codes[6188] = 0x0000fb84d6fd6ce8UL;
   tf->codes[6189] = 0x0000fb85118c72adUL;
   tf->codes[6190] = 0x0000fb8ac98402eaUL;
   tf->codes[6191] = 0x0000fb8f22217089UL;
   tf->codes[6192] = 0x0000fb90bc0a98ecUL;
   tf->codes[6193] = 0x0000fb91e0d5b5c5UL;
   tf->codes[6194] = 0x0000fb980deb518cUL;
   tf->codes[6195] = 0x0000fb98f82768a0UL;
   tf->codes[6196] = 0x0000fb996d45742aUL;
   tf->codes[6197] = 0x0000fb9a92109103UL;
   tf->codes[6198] = 0x0000fb9b7c4ca817UL;
   tf->codes[6199] = 0x0000fb9d1635d07aUL;
   tf->codes[6200] = 0x0000fb9f9a5b0ff1UL;
   tf->codes[6201] = 0x0000fba3b86977cbUL;
   tf->codes[6202] = 0x0000fba42d878355UL;
   tf->codes[6203] = 0x0000fba4dd3494a4UL;
   tf->codes[6204] = 0x0000fba81106e56aUL;
   tf->codes[6205] = 0x0000fba8fb42fc7eUL;
   tf->codes[6206] = 0x0000fba9aaf00dcdUL;
   tf->codes[6207] = 0x0000fba9e57f1392UL;
   tf->codes[6208] = 0x0000fbaa952c24e1UL;
   tf->codes[6209] = 0x0000fbb1ac7dd7bcUL;
   tf->codes[6210] = 0x0000fbb430a31733UL;
   tf->codes[6211] = 0x0000fbb7647567f9UL;
   tf->codes[6212] = 0x0000fbb9ae0ba1abUL;
   tf->codes[6213] = 0x0000fbbbf7a1db5dUL;
   tf->codes[6214] = 0x0000fbc46e4db0d6UL;
   tf->codes[6215] = 0x0000fbc76790fbd7UL;
   tf->codes[6216] = 0x0000fbc9017a243aUL;
   tf->codes[6217] = 0x0000fbd2626210c7UL;
   tf->codes[6218] = 0x0000fbd55ba55bc8UL;
   tf->codes[6219] = 0x0000fbdad90de640UL;
   tf->codes[6220] = 0x0000fbe2da9bb02fUL;
   tf->codes[6221] = 0x0000fbe7a8572958UL;
   tf->codes[6222] = 0x0000fbeaa19a7459UL;
   tf->codes[6223] = 0x0000fbf3184649d2UL;
   tf->codes[6224] = 0x0000fbf64c189a98UL;
   tf->codes[6225] = 0x0000fbfa6a270272UL;
   tf->codes[6226] = 0x0000fbfaa4b60837UL;
   tf->codes[6227] = 0x0000fc005cad9874UL;
   tf->codes[6228] = 0x0000fc13ce2a82ddUL;
   tf->codes[6229] = 0x0000fc1fedc6b4a6UL;
   tf->codes[6230] = 0x0000fc29893da6f8UL;
   tf->codes[6231] = 0x0000fc29fe5bb282UL;
   tf->codes[6232] = 0x0000fc2da74c0ed2UL;
   tf->codes[6233] = 0x0000fc31c55a76acUL;
   tf->codes[6234] = 0x0000fc42b2b2219eUL;
   tf->codes[6235] = 0x0000fc47f58ba651UL;
   tf->codes[6236] = 0x0000fc4ab43feb8dUL;
   tf->codes[6237] = 0x0000fc4bd90b0866UL;
   tf->codes[6238] = 0x0000fc557481fab8UL;
   tf->codes[6239] = 0x0000fc55af11007dUL;
   tf->codes[6240] = 0x0000fc5ffa35041eUL;
   tf->codes[6241] = 0x0000fc671186b6f9UL;
   tf->codes[6242] = 0x0000fc67c133c848UL;
   tf->codes[6243] = 0x0000fc6c19d135e7UL;
   tf->codes[6244] = 0x0000fc6d040d4cfbUL;
   tf->codes[6245] = 0x0000fc6d792b5885UL;
   tf->codes[6246] = 0x0000fc6ffd5097fcUL;
   tf->codes[6247] = 0x0000fc741b5effd6UL;
   tf->codes[6248] = 0x0000fc7ccc99db14UL;
   tf->codes[6249] = 0x0000fc7f50bf1a8bUL;
   tf->codes[6250] = 0x0000fc841e7a93b4UL;
   tf->codes[6251] = 0x0000fc854345b08dUL;
   tf->codes[6252] = 0x0000fc88b1a70718UL;
   tf->codes[6253] = 0x0000fc8a110129b6UL;
   tf->codes[6254] = 0x0000fc97ca8683e2UL;
   tf->codes[6255] = 0x0000fc9bae05e5f7UL;
   tf->codes[6256] = 0x0000fc9d0d600895UL;
   tf->codes[6257] = 0x0000fca04132595bUL;
   tf->codes[6258] = 0x0000fca2c55798d2UL;
   tf->codes[6259] = 0x0000fca633b8ef5dUL;
   tf->codes[6260] = 0x0000fca7931311fbUL;
   tf->codes[6261] = 0x0000fcab76927410UL;
   tf->codes[6262] = 0x0000fcc3061dc653UL;
   tf->codes[6263] = 0x0000fcc340accc18UL;
   tf->codes[6264] = 0x0000fcc37b3bd1ddUL;
   tf->codes[6265] = 0x0000fcc51524fa40UL;
   tf->codes[6266] = 0x0000fcc7994a39b7UL;
   tf->codes[6267] = 0x0000fcc8be155690UL;
   tf->codes[6268] = 0x0000fcc93333621aUL;
   tf->codes[6269] = 0x0000fcd00ff60f30UL;
   tf->codes[6270] = 0x0000fcd085141abaUL;
   tf->codes[6271] = 0x0000fcd309395a31UL;
   tf->codes[6272] = 0x0000fcd6779ab0bcUL;
   tf->codes[6273] = 0x0000fcd8c130ea6eUL;
   tf->codes[6274] = 0x0000fcdbf5033b34UL;
   tf->codes[6275] = 0x0000fcdeee468635UL;
   tf->codes[6276] = 0x0000fce84f2e72c2UL;
   tf->codes[6277] = 0x0000fcea23a6a0eaUL;
   tf->codes[6278] = 0x0000fcec32add4d7UL;
   tf->codes[6279] = 0x0000fceca7cbe061UL;
   tf->codes[6280] = 0x0000fcf17587598aUL;
   tf->codes[6281] = 0x0000fcfad66f4617UL;
   tf->codes[6282] = 0x0000fd06f60b77e0UL;
   tf->codes[6283] = 0x0000fd090512abcdUL;
   tf->codes[6284] = 0x0000fd093fa1b192UL;
   tf->codes[6285] = 0x0000fd0e0d5d2abbUL;
   tf->codes[6286] = 0x0000fd1265fa985aUL;
   tf->codes[6287] = 0x0000fd143a72c682UL;
   tf->codes[6288] = 0x0000fd1733b61183UL;
   tf->codes[6289] = 0x0000fd197d4c4b35UL;
   tf->codes[6290] = 0x0000fd1a67886249UL;
   tf->codes[6291] = 0x0000fd20cf2d03d5UL;
   tf->codes[6292] = 0x0000fd24ed3b6bafUL;
   tf->codes[6293] = 0x0000fd28210dbc75UL;
   tf->codes[6294] = 0x0000fd290b49d389UL;
   tf->codes[6295] = 0x0000fd2bc9fe18c5UL;
   tf->codes[6296] = 0x0000fd2ceec9359eUL;
   tf->codes[6297] = 0x0000fd310cd79d78UL;
   tf->codes[6298] = 0x0000fd3565750b17UL;
   tf->codes[6299] = 0x0000fd3d6702d506UL;
   tf->codes[6300] = 0x0000fd3e8bcdf1dfUL;
   tf->codes[6301] = 0x0000fd3f760a08f3UL;
   tf->codes[6302] = 0x0000fd409ad525ccUL;
   tf->codes[6303] = 0x0000fd4652ccb609UL;
   tf->codes[6304] = 0x0000fd4c0ac44646UL;
   tf->codes[6305] = 0x0000fd506361b3e5UL;
   tf->codes[6306] = 0x0000fd53973404abUL;
   tf->codes[6307] = 0x0000fd589f7e8399UL;
   tf->codes[6308] = 0x0000fd59c449a072UL;
   tf->codes[6309] = 0x0000fd62eaa2873aUL;
   tf->codes[6310] = 0x0000fd6e9520ad79UL;
   tf->codes[6311] = 0x0000fd723e1109c9UL;
   tf->codes[6312] = 0x0000fd7487a7437bUL;
   tf->codes[6313] = 0x0000fd7621906bdeUL;
   tf->codes[6314] = 0x0000fd7c4ea607a5UL;
   tf->codes[6315] = 0x0000fd83db15c60aUL;
   tf->codes[6316] = 0x0000fd932e844899UL;
   tf->codes[6317] = 0x0000fd94534f6572UL;
   tf->codes[6318] = 0x0000fd971203aaaeUL;
   tf->codes[6319] = 0x0000fd995b99e460UL;
   tf->codes[6320] = 0x0000fd9a0b46f5afUL;
   tf->codes[6321] = 0x0000fd9bdfbf23d7UL;
   tf->codes[6322] = 0x0000fda24763c563UL;
   tf->codes[6323] = 0x0000fda281f2cb28UL;
   tf->codes[6324] = 0x0000fdb24a7f5941UL;
   tf->codes[6325] = 0x0000fdb4941592f3UL;
   tf->codes[6326] = 0x0000fdb509339e7dUL;
   tf->codes[6327] = 0x0000fdb7183ad26aUL;
   tf->codes[6328] = 0x0000fdbc5b14571dUL;
   tf->codes[6329] = 0x0000fdc24d9aed1fUL;
   tf->codes[6330] = 0x0000fdc2c2b8f8a9UL;
   tf->codes[6331] = 0x0000fdcfcc914186UL;
   tf->codes[6332] = 0x0000fdd3b010a39bUL;
   tf->codes[6333] = 0x0000fdd50f6ac639UL;
   tf->codes[6334] = 0x0000fde0f477f23dUL;
   tf->codes[6335] = 0x0000fde219430f16UL;
   tf->codes[6336] = 0x0000fde4284a4303UL;
   tf->codes[6337] = 0x0000fde512865a17UL;
   tf->codes[6338] = 0x0000fde96b23c7b6UL;
   tf->codes[6339] = 0x0000fded14142406UL;
   tf->codes[6340] = 0x0000fdefd2c86942UL;
   tf->codes[6341] = 0x0000fdf515a1edf5UL;
   tf->codes[6342] = 0x0000fdfacd997e32UL;
   tf->codes[6343] = 0x0000fdff2636ebd1UL;
   tf->codes[6344] = 0x0000fe146c2c0462UL;
   tf->codes[6345] = 0x0000fe179ffe5528UL;
   tf->codes[6346] = 0x0000fe22d55e6fddUL;
   tf->codes[6347] = 0x0000fe2bc12850e0UL;
   tf->codes[6348] = 0x0000fe2e454d9057UL;
   tf->codes[6349] = 0x0000fe2eba6b9be1UL;
   tf->codes[6350] = 0x0000fe31b3aee6e2UL;
   tf->codes[6351] = 0x0000fe32d87a03bbUL;
   tf->codes[6352] = 0x0000fe360c4c5481UL;
   tf->codes[6353] = 0x0000fe40cc8e63acUL;
   tf->codes[6354] = 0x0000fe41f1598085UL;
   tf->codes[6355] = 0x0000fe440060b472UL;
   tf->codes[6356] = 0x0000fe45252bd14bUL;
   tf->codes[6357] = 0x0000fe468485f3e9UL;
   tf->codes[6358] = 0x0000fe4734330538UL;
   tf->codes[6359] = 0x0000fe48938d27d6UL;
   tf->codes[6360] = 0x0000fe605da77fdeUL;
   tf->codes[6361] = 0x0000fe74b960815bUL;
   tf->codes[6362] = 0x0000fe75690d92aaUL;
   tf->codes[6363] = 0x0000fe773d85c0d2UL;
   tf->codes[6364] = 0x0000fe7b5b9428acUL;
   tf->codes[6365] = 0x0000fe8188a9c473UL;
   tf->codes[6366] = 0x0000fe856c292688UL;
   tf->codes[6367] = 0x0000fe8f07a018daUL;
   tf->codes[6368] = 0x0000fe9e207f95a4UL;
   tf->codes[6369] = 0x0000fea119c2e0a5UL;
   tf->codes[6370] = 0x0000fea8e0c1a4cfUL;
   tf->codes[6371] = 0x0000feb7f9a12199UL;
   tf->codes[6372] = 0x0000feb8a94e32e8UL;
   tf->codes[6373] = 0x0000febffb2eeb88UL;
   tf->codes[6374] = 0x0000fec11ffa0861UL;
   tf->codes[6375] = 0x0000fecd05073465UL;
   tf->codes[6376] = 0x0000fed57bb309deUL;
   tf->codes[6377] = 0x0000fedaf91b9456UL;
   tf->codes[6378] = 0x0000fedb33aa9a1bUL;
   tf->codes[6379] = 0x0000fedd7d40d3cdUL;
   tf->codes[6380] = 0x0000fee36fc769cfUL;
   tf->codes[6381] = 0x0000fee4cf218c6dUL;
   tf->codes[6382] = 0x0000fee509b09232UL;
   tf->codes[6383] = 0x0000fee6a399ba95UL;
   tf->codes[6384] = 0x0000fee75346cbe4UL;
   tf->codes[6385] = 0x0000feeb715533beUL;
   tf->codes[6386] = 0x0000fef4d23d204bUL;
   tf->codes[6387] = 0x0000fef5f7083d24UL;
   tf->codes[6388] = 0x0000fef66c2648aeUL;
   tf->codes[6389] = 0x0000fef8409e76d6UL;
   tf->codes[6390] = 0x0000fefc993be475UL;
   tf->codes[6391] = 0x0000ff0b3cfd55b5UL;
   tf->codes[6392] = 0x0000ff12c96d141aUL;
   tf->codes[6393] = 0x0000ff1b0589e3ceUL;
   tf->codes[6394] = 0x0000ff1cda0211f6UL;
   tf->codes[6395] = 0x0000ff1d4f201d80UL;
   tf->codes[6396] = 0x0000ff216d2e855aUL;
   tf->codes[6397] = 0x0000ff2341a6b382UL;
   tf->codes[6398] = 0x0000ff2b43347d71UL;
   tf->codes[6399] = 0x0000ff2b7dc38336UL;
   tf->codes[6400] = 0x0000ff2ca28ea00fUL;
   tf->codes[6401] = 0x0000ff321ff72a87UL;
   tf->codes[6402] = 0x0000ff36edb2a3b0UL;
   tf->codes[6403] = 0x0000ff43826ce103UL;
   tf->codes[6404] = 0x0000ff4a24a08854UL;
   tf->codes[6405] = 0x0000ff508c4529e0UL;
   tf->codes[6406] = 0x0000ff5260bd5808UL;
   tf->codes[6407] = 0x0000ff59b29e10a8UL;
   tf->codes[6408] = 0x0000ff59ed2d166dUL;
   tf->codes[6409] = 0x0000ff76bf91ed63UL;
   tf->codes[6410] = 0x0000ff77a9ce0477UL;
   tf->codes[6411] = 0x0000ff797e46329fUL;
   tf->codes[6412] = 0x0000ff7a688249b3UL;
   tf->codes[6413] = 0x0000ff8528c458deUL;
   tf->codes[6414] = 0x0000ff890c43baf3UL;
   tf->codes[6415] = 0x0000ff8d64e12892UL;
   tf->codes[6416] = 0x0000ff90d3427f1dUL;
   tf->codes[6417] = 0x0000ff947c32db6dUL;
   tf->codes[6418] = 0x0000ff97b0052c33UL;
   tf->codes[6419] = 0x0000ffab5c111c61UL;
   tf->codes[6420] = 0x0000ffade0365bd8UL;
   tf->codes[6421] = 0x0000ffb40d4bf79fUL;
   tf->codes[6422] = 0x0000ffc4faa3a291UL;
   tf->codes[6423] = 0x0000ffcc4c845b31UL;
   tf->codes[6424] = 0x0000ffcde66d8394UL;
   tf->codes[6425] = 0x0000ffd4c33030aaUL;
   tf->codes[6426] = 0x0000ffdc1510e94aUL;
   tf->codes[6427] = 0x0000ffe06dae56e9UL;
   tf->codes[6428] = 0x0000ffe7bf8f0f89UL;
   tf->codes[6429] = 0x0000fff0ab58f08cUL;
   tf->codes[6430] = 0x0000fff1959507a0UL;
   tf->codes[6431] = 0x0000fff74d8c97ddUL;
   tf->codes[6432] = 0x00000006db8a2031UL;
   tf->codes[6433] = 0x00000007161925f6UL;
   tf->codes[6434] = 0x0000000b6eb69395UL;
   tf->codes[6435] = 0x0000000ba945995aUL;
   tf->codes[6436] = 0x00000011613d2997UL;
   tf->codes[6437] = 0x00000012c0974c35UL;
   tf->codes[6438] = 0x00000012fb2651faUL;
   tf->codes[6439] = 0x000000166987a885UL;
   tf->codes[6440] = 0x00000018edace7fcUL;
   tf->codes[6441] = 0x000000207a1ca661UL;
   tf->codes[6442] = 0x00000020ef3ab1ebUL;
   tf->codes[6443] = 0x000000228923da4eUL;
   tf->codes[6444] = 0x00000022fe41e5d8UL;
   tf->codes[6445] = 0x000000263214369eUL;
   tf->codes[6446] = 0x000000266ca33c63UL;
   tf->codes[6447] = 0x0000002c5f29d265UL;
   tf->codes[6448] = 0x00000033767b8540UL;
   tf->codes[6449] = 0x00000036352fca7cUL;
   tf->codes[6450] = 0x00000036aa4dd606UL;
   tf->codes[6451] = 0x00000038b95509f3UL;
   tf->codes[6452] = 0x0000003969021b42UL;
   tf->codes[6453] = 0x000000437997191eUL;
   tf->codes[6454] = 0x00000048f6ffa396UL;
   tf->codes[6455] = 0x00000055512adb24UL;
   tf->codes[6456] = 0x000000596f3942feUL;
   tf->codes[6457] = 0x0000005ace93659cUL;
   tf->codes[6458] = 0x0000005d52b8a513UL;
   tf->codes[6459] = 0x00000061ab5612b2UL;
   tf->codes[6460] = 0x0000006519b7693dUL;
   tf->codes[6461] = 0x00000067634da2efUL;
   tf->codes[6462] = 0x00000068fd36cb52UL;
   tf->codes[6463] = 0x0000006a5c90edf0UL;
   tf->codes[6464] = 0x0000006bf67a1653UL;
   tf->codes[6465] = 0x0000007a9a3b8793UL;
   tf->codes[6466] = 0x00000080523317d0UL;
   tf->codes[6467] = 0x00000090ca6cb738UL;
   tf->codes[6468] = 0x00000093c3b00239UL;
   tf->codes[6469] = 0x00000095230a24d7UL;
   tf->codes[6470] = 0x0000009598283061UL;
   tf->codes[6471] = 0x00000097321158c4UL;
   tf->codes[6472] = 0x00000098916b7b62UL;
   tf->codes[6473] = 0x00000099068986ecUL;
   tf->codes[6474] = 0x0000009a2b54a3c5UL;
   tf->codes[6475] = 0x0000009b501fc09eUL;
   tf->codes[6476] = 0x0000009caf79e33cUL;
   tf->codes[6477] = 0x000000a1081750dbUL;
   tf->codes[6478] = 0x000000a38c3c9052UL;
   tf->codes[6479] = 0x000000ab533b547cUL;
   tf->codes[6480] = 0x000000b05b85d36aUL;
   tf->codes[6481] = 0x000000b1f56efbcdUL;
   tf->codes[6482] = 0x000000b479943b44UL;
   tf->codes[6483] = 0x000000b4eeb246ceUL;
   tf->codes[6484] = 0x000000b64e0c696cUL;
   tf->codes[6485] = 0x000000b7ad668c0aUL;
   tf->codes[6486] = 0x000000b7e7f591cfUL;
   tf->codes[6487] = 0x000000bc7b220533UL;
   tf->codes[6488] = 0x000000c26da89b35UL;
   tf->codes[6489] = 0x000000c2a837a0faUL;
   tf->codes[6490] = 0x000000c2e2c6a6bfUL;
   tf->codes[6491] = 0x000000c44220c95dUL;
   tf->codes[6492] = 0x000000c6c64608d4UL;
   tf->codes[6493] = 0x000000c700d50e99UL;
   tf->codes[6494] = 0x000000c8d54d3cc1UL;
   tf->codes[6495] = 0x000000c9fa18599aUL;
   tf->codes[6496] = 0x000000cc43ae934cUL;
   tf->codes[6497] = 0x000000cc7e3d9911UL;
   tf->codes[6498] = 0x000000cddd97bbafUL;
   tf->codes[6499] = 0x000000d40aad5776UL;
   tf->codes[6500] = 0x000000d73e7fa83cUL;
   tf->codes[6501] = 0x000000d7b39db3c6UL;
   tf->codes[6502] = 0x000000d8634ac515UL;
   tf->codes[6503] = 0x000000e5e241197cUL;
   tf->codes[6504] = 0x000000fa788920beUL;
   tf->codes[6505] = 0x00000100e02dc24aUL;
   tf->codes[6506] = 0x00000101554bcdd4UL;
   tf->codes[6507] = 0x00000101ca69d95eUL;
   tf->codes[6508] = 0x000001044e8f18d5UL;
   tf->codes[6509] = 0x00000104fe3c2a24UL;
   tf->codes[6510] = 0x000001086c9d80afUL;
   tf->codes[6511] = 0x0000010af0c2c026UL;
   tf->codes[6512] = 0x00000110a8ba5063UL;
   tf->codes[6513] = 0x00000113676e959fUL;
   tf->codes[6514] = 0x000001219611fb55UL;
   tf->codes[6515] = 0x000001241a373accUL;
   tf->codes[6516] = 0x000001248f554656UL;
   tf->codes[6517] = 0x00000125b420632fUL;
   tf->codes[6518] = 0x0000012c1bc504bbUL;
   tf->codes[6519] = 0x0000012e9fea4432UL;
   tf->codes[6520] = 0x00000131240f83a9UL;
   tf->codes[6521] = 0x00000131d3bc94f8UL;
   tf->codes[6522] = 0x00000132f887b1d1UL;
   tf->codes[6523] = 0x00000133a834c320UL;
   tf->codes[6524] = 0x000001349270da34UL;
   tf->codes[6525] = 0x000001378bb42535UL;
   tf->codes[6526] = 0x00000138eb0e47d3UL;
   tf->codes[6527] = 0x000001419c492311UL;
   tf->codes[6528] = 0x00000142fba345afUL;
   tf->codes[6529] = 0x0000014336324b74UL;
   tf->codes[6530] = 0x00000144206e6288UL;
   tf->codes[6531] = 0x000001483e7cca62UL;
   tf->codes[6532] = 0x0000014928b8e176UL;
   tf->codes[6533] = 0x000001496347e73bUL;
   tf->codes[6534] = 0x0000015a509f922dUL;
   tf->codes[6535] = 0x0000015bea88ba90UL;
   tf->codes[6536] = 0x00000164d6529b93UL;
   tf->codes[6537] = 0x000001675a77db0aUL;
   tf->codes[6538] = 0x0000016ee6e7996fUL;
   tf->codes[6539] = 0x000001725548effaUL;
   tf->codes[6540] = 0x00000175fe394c4aUL;
   tf->codes[6541] = 0x000001775d936ee8UL;
   tf->codes[6542] = 0x00000180f90a613aUL;
   tf->codes[6543] = 0x00000182cd828f62UL;
   tf->codes[6544] = 0x0000018308119527UL;
   tf->codes[6545] = 0x000001837d2fa0b1UL;
   tf->codes[6546] = 0x00000189352730eeUL;
   tf->codes[6547] = 0x00000191714400a2UL;
   tf->codes[6548] = 0x00000191abd30667UL;
   tf->codes[6549] = 0x00000192d09e2340UL;
   tf->codes[6550] = 0x00000193f5694019UL;
   tf->codes[6551] = 0x00000197293b90dfUL;
   tf->codes[6552] = 0x000001988895b37dUL;
   tf->codes[6553] = 0x0000019e7b1c497fUL;
   tf->codes[6554] = 0x000001a0c4b28331UL;
   tf->codes[6555] = 0x000001a4a831e546UL;
   tf->codes[6556] = 0x000001b1777b285eUL;
   tf->codes[6557] = 0x000001b3fba067d5UL;
   tf->codes[6558] = 0x000001b470be735fUL;
   tf->codes[6559] = 0x000001b60aa79bc2UL;
   tf->codes[6560] = 0x000001b7df1fc9eaUL;
   tf->codes[6561] = 0x000001b8543dd574UL;
   tf->codes[6562] = 0x000001b97908f24dUL;
   tf->codes[6563] = 0x000001c0905aa528UL;
   tf->codes[6564] = 0x000001c10578b0b2UL;
   tf->codes[6565] = 0x000001cc0049c5a2UL;
   tf->codes[6566] = 0x000001d2a27d6cf3UL;
   tf->codes[6567] = 0x000001d4ec13a6a5UL;
   tf->codes[6568] = 0x000001d526a2ac6aUL;
   tf->codes[6569] = 0x000001d56131b22fUL;
   tf->codes[6570] = 0x000001d6fb1ada92UL;
   tf->codes[6571] = 0x000001d8cf9308baUL;
   tf->codes[6572] = 0x000001db1929426cUL;
   tf->codes[6573] = 0x000001e4ef2f3a83UL;
   tf->codes[6574] = 0x000001eae1b5d085UL;
   tf->codes[6575] = 0x000001f1f9078360UL;
   tf->codes[6576] = 0x000001f233968925UL;
   tf->codes[6577] = 0x000001f3cd7fb188UL;
   tf->codes[6578] = 0x000001f56768d9ebUL;
   tf->codes[6579] = 0x000001f5dc86e575UL;
   tf->codes[6580] = 0x000001f776700dd8UL;
   tf->codes[6581] = 0x000001f7eb8e1962UL;
   tf->codes[6582] = 0x000002068f4f8aa2UL;
   tf->codes[6583] = 0x00000209fdb0e12dUL;
   tf->codes[6584] = 0x00000211c4afa557UL;
   tf->codes[6585] = 0x00000211ff3eab1cUL;
   tf->codes[6586] = 0x0000021239cdb0e1UL;
   tf->codes[6587] = 0x000002132409c7f5UL;
   tf->codes[6588] = 0x000002156da001a7UL;
   tf->codes[6589] = 0x00000216ccfa2445UL;
   tf->codes[6590] = 0x0000021a3b5b7ad0UL;
   tf->codes[6591] = 0x0000021b259791e4UL;
   tf->codes[6592] = 0x0000021bd544a333UL;
   tf->codes[6593] = 0x00000224c10e8436UL;
   tf->codes[6594] = 0x0000022b28b325c2UL;
   tf->codes[6595] = 0x0000022bd8603711UL;
   tf->codes[6596] = 0x0000022e5c857688UL;
   tf->codes[6597] = 0x000002320575d2d8UL;
   tf->codes[6598] = 0x00000232efb1e9ecUL;
   tf->codes[6599] = 0x00000234899b124fUL;
   tf->codes[6600] = 0x000002353948239eUL;
   tf->codes[6601] = 0x00000235e8f534edUL;
   tf->codes[6602] = 0x00000238328b6e9fUL;
   tf->codes[6603] = 0x0000023af13fb3dbUL;
   tf->codes[6604] = 0x000002427daf7240UL;
   tf->codes[6605] = 0x00000247c088f6f3UL;
   tf->codes[6606] = 0x0000025280cb061eUL;
   tf->codes[6607] = 0x00000253a59622f7UL;
   tf->codes[6608] = 0x00000253e02528bcUL;
   tf->codes[6609] = 0x000002557a0e511fUL;
   tf->codes[6610] = 0x00000257fe339096UL;
   tf->codes[6611] = 0x00000258e86fa7aaUL;
   tf->codes[6612] = 0x0000025af776db97UL;
   tf->codes[6613] = 0x0000025b3205e15cUL;
   tf->codes[6614] = 0x0000025e2b492c5dUL;
   tf->codes[6615] = 0x000002633393ab4bUL;
   tf->codes[6616] = 0x000002636e22b110UL;
   tf->codes[6617] = 0x00000263a8b1b6d5UL;
   tf->codes[6618] = 0x00000265b7b8eac2UL;
   tf->codes[6619] = 0x00000269261a414dUL;
   tf->codes[6620] = 0x0000026960a94712UL;
   tf->codes[6621] = 0x0000026a857463ebUL;
   tf->codes[6622] = 0x0000026baa3f80c4UL;
   tf->codes[6623] = 0x0000026c947b97d8UL;
   tf->codes[6624] = 0x00000274d098678cUL;
   tf->codes[6625] = 0x000002824f8ebbf3UL;
   tf->codes[6626] = 0x00000283e977e456UL;
   tf->codes[6627] = 0x000002849924f5a5UL;
   tf->codes[6628] = 0x0000028b3b589cf6UL;
   tf->codes[6629] = 0x0000029302576120UL;
   tf->codes[6630] = 0x00000295115e950dUL;
   tf->codes[6631] = 0x00000298f4ddf722UL;
   tf->codes[6632] = 0x0000029a19a913fbUL;
   tf->codes[6633] = 0x0000029e37b77bd5UL;
   tf->codes[6634] = 0x000002a16b89cc9bUL;
   tf->codes[6635] = 0x000002a30572f4feUL;
   tf->codes[6636] = 0x000002a42a3e11d7UL;
   tf->codes[6637] = 0x000002a6ae63514eUL;
   tf->codes[6638] = 0x000002a80dbd73ecUL;
   tf->codes[6639] = 0x000002a8484c79b1UL;
   tf->codes[6640] = 0x000002a9a7a69c4fUL;
   tf->codes[6641] = 0x000002ab7c1eca77UL;
   tf->codes[6642] = 0x000002b134165ab4UL;
   tf->codes[6643] = 0x000002b3b83b9a2bUL;
   tf->codes[6644] = 0x000002b55224c28eUL;
   tf->codes[6645] = 0x000002b58cb3c853UL;
   tf->codes[6646] = 0x000002b935a424a3UL;
   tf->codes[6647] = 0x000002bca4057b2eUL;
   tf->codes[6648] = 0x000002bd53b28c7dUL;
   tf->codes[6649] = 0x000002c1ac4ffa1cUL;
   tf->codes[6650] = 0x000002c2216e05a6UL;
   tf->codes[6651] = 0x000002c2968c1130UL;
   tf->codes[6652] = 0x000002c34639227fUL;
   tf->codes[6653] = 0x000002c55540566cUL;
   tf->codes[6654] = 0x000002c8fe30b2bcUL;
   tf->codes[6655] = 0x000002ca9819db1fUL;
   tf->codes[6656] = 0x000002d299a7a50eUL;
   tf->codes[6657] = 0x000002d6f24512adUL;
   tf->codes[6658] = 0x000002e227a52d62UL;
   tf->codes[6659] = 0x000002ea9e5102dbUL;
   tf->codes[6660] = 0x000002f056489318UL;
   tf->codes[6661] = 0x000002f0cb669ea2UL;
   tf->codes[6662] = 0x000002f14084aa2cUL;
   tf->codes[6663] = 0x000002f7e2b8517dUL;
   tf->codes[6664] = 0x00000304b2019495UL;
   tf->codes[6665] = 0x0000030561aea5e4UL;
   tf->codes[6666] = 0x00000307ab44df96UL;
   tf->codes[6667] = 0x000003090a9f0234UL;
   tf->codes[6668] = 0x0000031146bbd1e8UL;
   tf->codes[6669] = 0x00000314b51d2873UL;
   tf->codes[6670] = 0x00000318d32b904dUL;
   tf->codes[6671] = 0x0000031aa7a3be75UL;
   tf->codes[6672] = 0x0000032234137cdaUL;
   tf->codes[6673] = 0x00000327ec0b0d17UL;
   tf->codes[6674] = 0x000003289bb81e66UL;
   tf->codes[6675] = 0x0000032c0a1974f1UL;
   tf->codes[6676] = 0x0000032c44a87ab6UL;
   tf->codes[6677] = 0x0000032cf4558c05UL;
   tf->codes[6678] = 0x000003309d45e855UL;
   tf->codes[6679] = 0x00000333d118391bUL;
   tf->codes[6680] = 0x00000334463644a5UL;
   tf->codes[6681] = 0x00000337b4979b30UL;
   tf->codes[6682] = 0x0000033b9816fd45UL;
   tf->codes[6683] = 0x0000033c0d3508cfUL;
   tf->codes[6684] = 0x0000033e1c3c3cbcUL;
   tf->codes[6685] = 0x00000341ffbb9ed1UL;
   tf->codes[6686] = 0x00000342af68b020UL;
   tf->codes[6687] = 0x0000034742952384UL;
   tf->codes[6688] = 0x0000034a7667744aUL;
   tf->codes[6689] = 0x000003518db92725UL;
   tf->codes[6690] = 0x0000035954b7eb4fUL;
   tf->codes[6691] = 0x0000035a79830828UL;
   tf->codes[6692] = 0x000003615645b53eUL;
   tf->codes[6693] = 0x00000365e97228a2UL;
   tf->codes[6694] = 0x000003670e3d457bUL;
   tf->codes[6695] = 0x0000036ba169b8dfUL;
   tf->codes[6696] = 0x00000372b8bb6bbaUL;
   tf->codes[6697] = 0x0000037452a4941dUL;
   tf->codes[6698] = 0x00000378ab4201bcUL;
   tf->codes[6699] = 0x0000037a452b2a1fUL;
   tf->codes[6700] = 0x00000380e75ed170UL;
   tf->codes[6701] = 0x00000385056d394aUL;
   tf->codes[6702] = 0x000003857a8b44d4UL;
   tf->codes[6703] = 0x000003895e0aa6e9UL;
   tf->codes[6704] = 0x0000039249d487ecUL;
   tf->codes[6705] = 0x00000395f2c4e43cUL;
   tf->codes[6706] = 0x00000396dd00fb50UL;
   tf->codes[6707] = 0x000003a2877f218fUL;
   tf->codes[6708] = 0x000003a3ac4a3e68UL;
   tf->codes[6709] = 0x000003a5463366cbUL;
   tf->codes[6710] = 0x000003a7553a9ab8UL;
   tf->codes[6711] = 0x000003a8ef23c31bUL;
   tf->codes[6712] = 0x000003ab73490292UL;
   tf->codes[6713] = 0x000003ac5d8519a6UL;
   tf->codes[6714] = 0x000003b33a47c6bcUL;
   tf->codes[6715] = 0x000003b42483ddd0UL;
   tf->codes[6716] = 0x000003b5f8fc0bf8UL;
   tf->codes[6717] = 0x000003b6338b11bdUL;
   tf->codes[6718] = 0x000003bee4c5ecfbUL;
   tf->codes[6719] = 0x000003c07eaf155eUL;
   tf->codes[6720] = 0x000003c33d635a9aUL;
   tf->codes[6721] = 0x000003c3b2816624UL;
   tf->codes[6722] = 0x000003c4d74c82fdUL;
   tf->codes[6723] = 0x000003c5fc179fd6UL;
   tf->codes[6724] = 0x000003c6e653b6eaUL;
   tf->codes[6725] = 0x000003cc63bc4162UL;
   tf->codes[6726] = 0x000003cfd21d97edUL;
   tf->codes[6727] = 0x000003d16c06c050UL;
   tf->codes[6728] = 0x000003d290d1dd29UL;
   tf->codes[6729] = 0x000003d4da6816dbUL;
   tf->codes[6730] = 0x000003dca166db05UL;
   tf->codes[6731] = 0x000003e134934e69UL;
   tf->codes[6732] = 0x000003e3439a8256UL;
   tf->codes[6733] = 0x000003ea957b3af6UL;
   tf->codes[6734] = 0x000003f346b61634UL;
   tf->codes[6735] = 0x000003f72a357849UL;
   tf->codes[6736] = 0x000003f8c41ea0acUL;
   tf->codes[6737] = 0x000003f9ae5ab7c0UL;
   tf->codes[6738] = 0x000003fb0db4da5eUL;
   tf->codes[6739] = 0x000003fce22d0886UL;
   tf->codes[6740] = 0x00000404a92bccb0UL;
   tf->codes[6741] = 0x000004051e49d83aUL;
   tf->codes[6742] = 0x000004064314f513UL;
   tf->codes[6743] = 0x000004072d510c27UL;
   tf->codes[6744] = 0x0000041053a9f2efUL;
   tf->codes[6745] = 0x00000413125e382bUL;
   tf->codes[6746] = 0x00000417e019b154UL;
   tf->codes[6747] = 0x000004185537bcdeUL;
   tf->codes[6748] = 0x000004193f73d3f2UL;
   tf->codes[6749] = 0x00000419ef20e541UL;
   tf->codes[6750] = 0x0000041ad95cfc55UL;
   tf->codes[6751] = 0x00000421b61fa96bUL;
   tf->codes[6752] = 0x00000422a05bc07fUL;
   tf->codes[6753] = 0x00000422daeac644UL;
   tf->codes[6754] = 0x00000425d42e1145UL;
   tf->codes[6755] = 0x00000426494c1ccfUL;
   tf->codes[6756] = 0x00000426be6a2859UL;
   tf->codes[6757] = 0x00000427a8a63f6dUL;
   tf->codes[6758] = 0x00000428585350bcUL;
   tf->codes[6759] = 0x00000429b7ad735aUL;
   tf->codes[6760] = 0x0000042a675a84a9UL;
   tf->codes[6761] = 0x0000043686f6b672UL;
   tf->codes[6762] = 0x0000043945aafbaeUL;
   tf->codes[6763] = 0x0000043adf942411UL;
   tf->codes[6764] = 0x0000043f72c09775UL;
   tf->codes[6765] = 0x00000444f02921edUL;
   tf->codes[6766] = 0x0000044c077ad4c8UL;
   tf->codes[6767] = 0x0000044f3b4d258eUL;
   tf->codes[6768] = 0x00000454f344b5cbUL;
   tf->codes[6769] = 0x00000456180fd2a4UL;
   tf->codes[6770] = 0x0000045bd00762e1UL;
   tf->codes[6771] = 0x0000045cba4379f5UL;
   tf->codes[6772] = 0x0000046237ac046dUL;
   tf->codes[6773] = 0x000004635c772146UL;
   tf->codes[6774] = 0x000004689f50a5f9UL;
   tf->codes[6775] = 0x0000046f41844d4aUL;
   tf->codes[6776] = 0x000004739a21bae9UL;
   tf->codes[6777] = 0x00000475340ae34cUL;
   tf->codes[6778] = 0x0000047bd63e8a9dUL;
   tf->codes[6779] = 0x0000047cfb09a776UL;
   tf->codes[6780] = 0x0000047f449fe128UL;
   tf->codes[6781] = 0x00000480de89098bUL;
   tf->codes[6782] = 0x000004844cea6016UL;
   tf->codes[6783] = 0x00000484fc977165UL;
   tf->codes[6784] = 0x000004853726772aUL;
   tf->codes[6785] = 0x0000048b643c12f1UL;
   tf->codes[6786] = 0x0000048c13e92440UL;
   tf->codes[6787] = 0x0000048e980e63b7UL;
   tf->codes[6788] = 0x000004906c8691dfUL;
   tf->codes[6789] = 0x000004911c33a32eUL;
   tf->codes[6790] = 0x0000049ab7aa9580UL;
   tf->codes[6791] = 0x0000049f1048031fUL;
   tf->codes[6792] = 0x000004a3a3747683UL;
   tf->codes[6793] = 0x000004a66228bbbfUL;
   tf->codes[6794] = 0x000004b2bc53f34dUL;
   tf->codes[6795] = 0x000004b4cb5b273aUL;
   tf->codes[6796] = 0x000004bf167f2adbUL;
   tf->codes[6797] = 0x000004c0b068533eUL;
   tf->codes[6798] = 0x000004c36f1c987aUL;
   tf->codes[6799] = 0x000004d0b383e71cUL;
   tf->codes[6800] = 0x000004d128a1f2a6UL;
   tf->codes[6801] = 0x000004d2fd1a20ceUL;
   tf->codes[6802] = 0x000004d5f65d6bcfUL;
   tf->codes[6803] = 0x000004d8b511b10bUL;
   tf->codes[6804] = 0x000004d92a2fbc95UL;
   tf->codes[6805] = 0x000004da146bd3a9UL;
   tf->codes[6806] = 0x000004dac418e4f8UL;
   tf->codes[6807] = 0x000004dafea7eabdUL;
   tf->codes[6808] = 0x000004e50f3ce899UL;
   tf->codes[6809] = 0x000004eeaab3daebUL;
   tf->codes[6810] = 0x000004eee542e0b0UL;
   tf->codes[6811] = 0x000004f1de862bb1UL;
   tf->codes[6812] = 0x000004f3786f5414UL;
   tf->codes[6813] = 0x000004f462ab6b28UL;
   tf->codes[6814] = 0x000004f880b9d302UL;
   tf->codes[6815] = 0x000004fbb48c23c8UL;
   tf->codes[6816] = 0x0000050047b8972cUL;
   tf->codes[6817] = 0x00000503f0a8f37cUL;
   tf->codes[6818] = 0x0000051010452545UL;
   tf->codes[6819] = 0x000005137ea67bd0UL;
   tf->codes[6820] = 0x000005172796d820UL;
   tf->codes[6821] = 0x000005225cf6f2d5UL;
   tf->codes[6822] = 0x0000052590c9439bUL;
   tf->codes[6823] = 0x0000052bf86de527UL;
   tf->codes[6824] = 0x00000532601286b3UL;
   tf->codes[6825] = 0x00000532d530923dUL;
   tf->codes[6826] = 0x00000534348ab4dbUL;
   tf->codes[6827] = 0x0000053a27114addUL;
   tf->codes[6828] = 0x00000544e7535a08UL;
   tf->codes[6829] = 0x00000547e096a509UL;
   tf->codes[6830] = 0x0000054d988e3546UL;
   tf->codes[6831] = 0x00000553c5a3d10dUL;
   tf->codes[6832] = 0x0000055734052798UL;
   tf->codes[6833] = 0x0000055cb16db210UL;
   tf->codes[6834] = 0x000005617f292b39UL;
   tf->codes[6835] = 0x00000561f44736c3UL;
   tf->codes[6836] = 0x000005710d26b38dUL;
   tf->codes[6837] = 0x00000572e19ee1b5UL;
   tf->codes[6838] = 0x00000574f0a615a2UL;
   tf->codes[6839] = 0x000005752b351b67UL;
   tf->codes[6840] = 0x0000057774cb5519UL;
   tf->codes[6841] = 0x00000579f8f09490UL;
   tf->codes[6842] = 0x0000057a337f9a55UL;
   tf->codes[6843] = 0x0000057a6e0ea01aUL;
   tf->codes[6844] = 0x0000057ddc6ff6a5UL;
   tf->codes[6845] = 0x000005806095361cUL;
   tf->codes[6846] = 0x0000058ae6483f82UL;
   tf->codes[6847] = 0x000005940ca1264aUL;
   tf->codes[6848] = 0x00000595e1195472UL;
   tf->codes[6849] = 0x0000059914eba538UL;
   tf->codes[6850] = 0x000005998a09b0c2UL;
   tf->codes[6851] = 0x0000059bd39fea74UL;
   tf->codes[6852] = 0x000005a5a9a5e28bUL;
   tf->codes[6853] = 0x000005a65952f3daUL;
   tf->codes[6854] = 0x000005a77e1e10b3UL;
   tf->codes[6855] = 0x000005a7f33c1c3dUL;
   tf->codes[6856] = 0x000005a8dd783351UL;
   tf->codes[6857] = 0x000005ab619d72c8UL;
   tf->codes[6858] = 0x000005acfb869b2bUL;
   tf->codes[6859] = 0x000005afba3ae067UL;
   tf->codes[6860] = 0x000005b2b37e2b68UL;
   tf->codes[6861] = 0x000005b4c2855f55UL;
   tf->codes[6862] = 0x000005bab50bf557UL;
   tf->codes[6863] = 0x000005c11cb096e3UL;
   tf->codes[6864] = 0x000005c36646d095UL;
   tf->codes[6865] = 0x000005c45082e7a9UL;
   tf->codes[6866] = 0x000005c7f97343f9UL;
   tf->codes[6867] = 0x000005cab8278935UL;
   tf->codes[6868] = 0x000005d0701f1972UL;
   tf->codes[6869] = 0x000005d369626473UL;
   tf->codes[6870] = 0x000005d71252c0c3UL;
   tf->codes[6871] = 0x000005d871ace361UL;
   tf->codes[6872] = 0x000005da80b4174eUL;
   tf->codes[6873] = 0x000005ddb4866814UL;
   tf->codes[6874] = 0x000005dfc38d9c01UL;
   tf->codes[6875] = 0x000005e6a0504917UL;
   tf->codes[6876] = 0x000005ec5847d954UL;
   tf->codes[6877] = 0x000005efc6a92fdfUL;
   tf->codes[6878] = 0x000005f07656412eUL;
   tf->codes[6879] = 0x000005f3350a866aUL;
   tf->codes[6880] = 0x000005f7c836f9ceUL;
   tf->codes[6881] = 0x000005fbe64561a8UL;
   tf->codes[6882] = 0x000005fedf88aca9UL;
   tf->codes[6883] = 0x00000610f1ab7474UL;
   tf->codes[6884] = 0x000006112c3a7a39UL;
   tf->codes[6885] = 0x00000618b8aa389eUL;
   tf->codes[6886] = 0x0000061bec7c8964UL;
   tf->codes[6887] = 0x00000622c93f367aUL;
   tf->codes[6888] = 0x00000624d8466a67UL;
   tf->codes[6889] = 0x00000627d189b568UL;
   tf->codes[6890] = 0x000006280c18bb2dUL;
   tf->codes[6891] = 0x00000628f654d241UL;
   tf->codes[6892] = 0x000006321cadb909UL;
   tf->codes[6893] = 0x000006346643f2bbUL;
   tf->codes[6894] = 0x00000639a91d776eUL;
   tf->codes[6895] = 0x000006430a0563fbUL;
   tf->codes[6896] = 0x00000648c1fcf438UL;
   tf->codes[6897] = 0x0000064f9ebfa14eUL;
   tf->codes[6898] = 0x00000650fe19c3ecUL;
   tf->codes[6899] = 0x000006546c7b1a77UL;
   tf->codes[6900] = 0x00000654e1992601UL;
   tf->codes[6901] = 0x00000661013557caUL;
   tf->codes[6902] = 0x00000663fa78a2cbUL;
   tf->codes[6903] = 0x0000066559d2c569UL;
   tf->codes[6904] = 0x0000066902c321b9UL;
   tf->codes[6905] = 0x00000671796ef732UL;
   tf->codes[6906] = 0x00000673fd9436a9UL;
   tf->codes[6907] = 0x00000675225f5382UL;
   tf->codes[6908] = 0x00000675d20c64d1UL;
   tf->codes[6909] = 0x000006859a98f2eaUL;
   tf->codes[6910] = 0x000006876f112112UL;
   tf->codes[6911] = 0x00000697722cb4f0UL;
   tf->codes[6912] = 0x00000697e74ac07aUL;
   tf->codes[6913] = 0x0000069b55ac1705UL;
   tf->codes[6914] = 0x0000069c05592854UL;
   tf->codes[6915] = 0x000006a02367902eUL;
   tf->codes[6916] = 0x000006a14832ad07UL;
   tf->codes[6917] = 0x000006a1bd50b891UL;
   tf->codes[6918] = 0x000006a73ab94309UL;
   tf->codes[6919] = 0x000006ab1e38a51eUL;
   tf->codes[6920] = 0x000006b0d630355bUL;
   tf->codes[6921] = 0x000006b110bf3b20UL;
   tf->codes[6922] = 0x000006b394e47a97UL;
   tf->codes[6923] = 0x000006b9876b1099UL;
   tf->codes[6924] = 0x000006bf3f62a0d6UL;
   tf->codes[6925] = 0x000006c14e69d4c3UL;
   tf->codes[6926] = 0x000006c1fe16e612UL;
   tf->codes[6927] = 0x000006c27334f19cUL;
   tf->codes[6928] = 0x000006cb998dd864UL;
   tf->codes[6929] = 0x000006d27650857aUL;
   tf->codes[6930] = 0x000006d4fa75c4f1UL;
   tf->codes[6931] = 0x000006d61f40e1caUL;
   tf->codes[6932] = 0x000006d77e9b0468UL;
   tf->codes[6933] = 0x000006d8a3662141UL;
   tf->codes[6934] = 0x000006d9c8313e1aUL;
   tf->codes[6935] = 0x000006db278b60b8UL;
   tf->codes[6936] = 0x000006dc11c777ccUL;
   tf->codes[6937] = 0x000006e4fd9158cfUL;
   tf->codes[6938] = 0x000006e6977a8132UL;
   tf->codes[6939] = 0x000006ec4f72116fUL;
   tf->codes[6940] = 0x000006f20769a1acUL;
   tf->codes[6941] = 0x000006f2f1a5b8c0UL;
   tf->codes[6942] = 0x000006fc528da54dUL;
   tf->codes[6943] = 0x00000700709c0d27UL;
   tf->codes[6944] = 0x0000070245143b4fUL;
   tf->codes[6945] = 0x000007066322a329UL;
   tf->codes[6946] = 0x0000070abbc010c8UL;
   tf->codes[6947] = 0x0000070af64f168dUL;
   tf->codes[6948] = 0x000007120da0c968UL;
   tf->codes[6949] = 0x000007157c021ff3UL;
   tf->codes[6950] = 0x00000716db5c4291UL;
   tf->codes[6951] = 0x0000071715eb4856UL;
   tf->codes[6952] = 0x0000071800275f6aUL;
   tf->codes[6953] = 0x000007183ab6652fUL;
   tf->codes[6954] = 0x00000718afd470b9UL;
   tf->codes[6955] = 0x0000071ba917bbbaUL;
   tf->codes[6956] = 0x00000721d62d5781UL;
   tf->codes[6957] = 0x0000072dbb3a8385UL;
   tf->codes[6958] = 0x0000072ea5769a99UL;
   tf->codes[6959] = 0x0000073b3a30d7ecUL;
   tf->codes[6960] = 0x00000746aa1ff866UL;
   tf->codes[6961] = 0x00000749a3634367UL;
   tf->codes[6962] = 0x0000074a531054b6UL;
   tf->codes[6963] = 0x0000074c621788a3UL;
   tf->codes[6964] = 0x000007504596eab8UL;
   tf->codes[6965] = 0x00000752c9bc2a2fUL;
   tf->codes[6966] = 0x0000075a562be894UL;
   tf->codes[6967] = 0x0000075c2aa416bcUL;
   tf->codes[6968] = 0x000007637c84cf5cUL;
   tf->codes[6969] = 0x00000764a14fec35UL;
   tf->codes[6970] = 0x0000076725752bacUL;
   tf->codes[6971] = 0x000007696f0b655eUL;
   tf->codes[6972] = 0x0000076a1eb876adUL;
   tf->codes[6973] = 0x0000076bf330a4d5UL;
   tf->codes[6974] = 0x0000076f6191fb60UL;
   tf->codes[6975] = 0x00000771ab283512UL;
   tf->codes[6976] = 0x0000078ef2ab1792UL;
   tf->codes[6977] = 0x000007955a4fb91eUL;
   tf->codes[6978] = 0x000007976956ed0bUL;
   tf->codes[6979] = 0x000007a29eb707c0UL;
   tf->codes[6980] = 0x000007a8cbcca387UL;
   tf->codes[6981] = 0x000007aa2b26c625UL;
   tf->codes[6982] = 0x000007abff9ef44dUL;
   tf->codes[6983] = 0x000007b38c0eb2b2UL;
   tf->codes[6984] = 0x000007bcecf69f3fUL;
   tf->codes[6985] = 0x000007c26a5f29b7UL;
   tf->codes[6986] = 0x000007c38f2a4690UL;
   tf->codes[6987] = 0x000007cc406521ceUL;
   tf->codes[6988] = 0x000007cec48a6145UL;
   tf->codes[6989] = 0x000007d0d3919532UL;
   tf->codes[6990] = 0x000007d2a809c35aUL;
   tf->codes[6991] = 0x000007d357b6d4a9UL;
   tf->codes[6992] = 0x000007d39245da6eUL;
   tf->codes[6993] = 0x000007d4f19ffd0cUL;
   tf->codes[6994] = 0x000007d700a730f9UL;
   tf->codes[6995] = 0x000007e09c1e234bUL;
   tf->codes[6996] = 0x000007e5def7a7feUL;
   tf->codes[6997] = 0x000007e65415b388UL;
   tf->codes[6998] = 0x000007e778e0d061UL;
   tf->codes[6999] = 0x000007e8d83af2ffUL;
   tf->codes[7000] = 0x000007ecf6495ad9UL;
   tf->codes[7001] = 0x000007f0d9c8bceeUL;
   tf->codes[7002] = 0x00000800a2554b07UL;
   tf->codes[7003] = 0x0000080485d4ad1cUL;
   tf->codes[7004] = 0x000008057010c430UL;
   tf->codes[7005] = 0x00000806cf6ae6ceUL;
   tf->codes[7006] = 0x00000808de721abbUL;
   tf->codes[7007] = 0x000008098e1f2c0aUL;
   tf->codes[7008] = 0x00000809c8ae31cfUL;
   tf->codes[7009] = 0x0000080b2808546dUL;
   tf->codes[7010] = 0x0000080b9d265ff7UL;
   tf->codes[7011] = 0x0000080fbb34c7d1UL;
   tf->codes[7012] = 0x00000815389d5249UL;
   tf->codes[7013] = 0x0000081cff9c1673UL;
   tf->codes[7014] = 0x000008206dfd6cfeUL;
   tf->codes[7015] = 0x00000823a1cfbdc4UL;
   tf->codes[7016] = 0x000008269b1308c5UL;
   tf->codes[7017] = 0x000008286f8b36edUL;
   tf->codes[7018] = 0x0000082ba35d87b3UL;
   tf->codes[7019] = 0x0000082d3d46b016UL;
   tf->codes[7020] = 0x000008336a5c4bddUL;
   tf->codes[7021] = 0x00000837886ab3b7UL;
   tf->codes[7022] = 0x0000083872a6cacbUL;
   tf->codes[7023] = 0x0000083ccb44386aUL;
   tf->codes[7024] = 0x0000083f4f6977e1UL;
   tf->codes[7025] = 0x000008462c2c24f7UL;
   tf->codes[7026] = 0x0000084b6f05a9aaUL;
   tf->codes[7027] = 0x000008519c1b4571UL;
   tf->codes[7028] = 0x00000852c0e6624aUL;
   tf->codes[7029] = 0x000008550a7c9bfcUL;
   tf->codes[7030] = 0x000008575412d5aeUL;
   tf->codes[7031] = 0x00000857c930e138UL;
   tf->codes[7032] = 0x00000858b36cf84cUL;
   tf->codes[7033] = 0x0000086373af0777UL;
   tf->codes[7034] = 0x00000867572e698cUL;
   tf->codes[7035] = 0x00000868f11791efUL;
   tf->codes[7036] = 0x00000869a0c4a33eUL;
   tf->codes[7037] = 0x0000086a5071b48dUL;
   tf->codes[7038] = 0x0000086ea90f222cUL;
   tf->codes[7039] = 0x00000870b8165619UL;
   tf->codes[7040] = 0x000008746106b269UL;
   tf->codes[7041] = 0x0000087510b3c3b8UL;
   tf->codes[7042] = 0x0000087969513157UL;
   tf->codes[7043] = 0x0000087ac8ab53f5UL;
   tf->codes[7044] = 0x0000088080a2e432UL;
   tf->codes[7045] = 0x00000880bb31e9f7UL;
   tf->codes[7046] = 0x000008816adefb46UL;
   tf->codes[7047] = 0x0000088513cf5796UL;
   tf->codes[7048] = 0x000008854e5e5d5bUL;
   tf->codes[7049] = 0x0000088bf09204acUL;
   tf->codes[7050] = 0x0000088eaf4649e8UL;
   tf->codes[7051] = 0x000008942caed460UL;
   tf->codes[7052] = 0x0000089725f21f61UL;
   tf->codes[7053] = 0x0000089760812526UL;
   tf->codes[7054] = 0x000008984abd3c3aUL;
   tf->codes[7055] = 0x000008ab471c1b19UL;
   tf->codes[7056] = 0x000008b46d7501e1UL;
   tf->codes[7057] = 0x000008b4a80407a6UL;
   tf->codes[7058] = 0x000008b51d221330UL;
   tf->codes[7059] = 0x000008b9b04e8694UL;
   tf->codes[7060] = 0x000008bb0fa8a932UL;
   tf->codes[7061] = 0x000008bb4a37aef7UL;
   tf->codes[7062] = 0x000008c08d1133aaUL;
   tf->codes[7063] = 0x000008c1ec6b5648UL;
   tf->codes[7064] = 0x000008c2618961d2UL;
   tf->codes[7065] = 0x000008c8540ff7d4UL;
   tf->codes[7066] = 0x000008c93e4c0ee8UL;
   tf->codes[7067] = 0x000008d0902cc788UL;
   tf->codes[7068] = 0x000008d1054ad312UL;
   tf->codes[7069] = 0x000008d4ae3b2f62UL;
   tf->codes[7070] = 0x000008d7e20d8028UL;
   tf->codes[7071] = 0x000008d8572b8bb2UL;
   tf->codes[7072] = 0x000008e6faecfcf2UL;
   tf->codes[7073] = 0x000008ea694e537dUL;
   tf->codes[7074] = 0x000008ec3dc681a5UL;
   tf->codes[7075] = 0x000008f1f5be11e2UL;
   tf->codes[7076] = 0x000008f5299062a8UL;
   tf->codes[7077] = 0x000008f5d93d73f7UL;
   tf->codes[7078] = 0x000008fb91350434UL;
   tf->codes[7079] = 0x000008ff74b46649UL;
   tf->codes[7080] = 0x00000903cd51d3e8UL;
   tf->codes[7081] = 0x00000904b78deafcUL;
   tf->codes[7082] = 0x00000905673afc4bUL;
   tf->codes[7083] = 0x00000906c6951ee9UL;
   tf->codes[7084] = 0x0000090e5304dd4eUL;
   tf->codes[7085] = 0x00000911c16633d9UL;
   tf->codes[7086] = 0x00000914458b7350UL;
   tf->codes[7087] = 0x0000091aad3014dcUL;
   tf->codes[7088] = 0x0000091fb57a93caUL;
   tf->codes[7089] = 0x0000092323dbea55UL;
   tf->codes[7090] = 0x0000092448a7072eUL;
   tf->codes[7091] = 0x00000928a14474cdUL;
   tf->codes[7092] = 0x0000092c0fa5cb58UL;
   tf->codes[7093] = 0x00000930dd614481UL;
   tf->codes[7094] = 0x00000932774a6ce4UL;
   tf->codes[7095] = 0x00000934fb6fac5bUL;
   tf->codes[7096] = 0x00000935ab1cbdaaUL;
   tf->codes[7097] = 0x0000093b9da353acUL;
   tf->codes[7098] = 0x0000093f8122b5c1UL;
   tf->codes[7099] = 0x0000093fbbb1bb86UL;
   tf->codes[7100] = 0x000009427a6600c2UL;
   tf->codes[7101] = 0x00000944896d34afUL;
   tf->codes[7102] = 0x0000094a4164c4ecUL;
   tf->codes[7103] = 0x000009506e7a60b3UL;
   tf->codes[7104] = 0x00000950a9096678UL;
   tf->codes[7105] = 0x0000095367bdabb4UL;
   tf->codes[7106] = 0x000009574b3d0dc9UL;
   tf->codes[7107] = 0x0000095785cc138eUL;
   tf->codes[7108] = 0x000009591fb53bf1UL;
   tf->codes[7109] = 0x0000095c8e16927cUL;
   tf->codes[7110] = 0x00000961214305e0UL;
   tf->codes[7111] = 0x00000962460e22b9UL;
   tf->codes[7112] = 0x00000965b46f7944UL;
   tf->codes[7113] = 0x0000096ba6f60f46UL;
   tf->codes[7114] = 0x0000096ea0395a47UL;
   tf->codes[7115] = 0x00000976a1c72436UL;
   tf->codes[7116] = 0x0000097be4a0a8e9UL;
   tf->codes[7117] = 0x0000098336816189UL;
   tf->codes[7118] = 0x00000985f535a6c5UL;
   tf->codes[7119] = 0x000009912a95c17aUL;
   tf->codes[7120] = 0x00000993742bfb2cUL;
   tf->codes[7121] = 0x00000993aebb00f1UL;
   tf->codes[7122] = 0x00000997923a6306UL;
   tf->codes[7123] = 0x0000099bb048cae0UL;
   tf->codes[7124] = 0x000009a2c79a7dbbUL;
   tf->codes[7125] = 0x000009a377478f0aUL;
   tf->codes[7126] = 0x000009a7cfe4fca9UL;
   tf->codes[7127] = 0x000009ab78d558f9UL;
   tf->codes[7128] = 0x000009b290270bd4UL;
   tf->codes[7129] = 0x000009b4d9bd4586UL;
   tf->codes[7130] = 0x000009b80d8f964cUL;
   tf->codes[7131] = 0x000009b8bd3ca79bUL;
   tf->codes[7132] = 0x000009b9a778beafUL;
   tf->codes[7133] = 0x000009c30860ab3cUL;
   tf->codes[7134] = 0x000009c58c85eab3UL;
   tf->codes[7135] = 0x000009c63c32fc02UL;
   tf->codes[7136] = 0x000009c7266f1316UL;
   tf->codes[7137] = 0x000009d3460b44dfUL;
   tf->codes[7138] = 0x000009d679dd95a5UL;
   tf->codes[7139] = 0x000009d76419acb9UL;
   tf->codes[7140] = 0x000009dce1823731UL;
   tf->codes[7141] = 0x000009e1e9ccb61fUL;
   tf->codes[7142] = 0x000009e2d408cd33UL;
   tf->codes[7143] = 0x000009e43362efd1UL;
   tf->codes[7144] = 0x000009ea9b07915dUL;
   tf->codes[7145] = 0x000009f4e62b94feUL;
   tf->codes[7146] = 0x000009f9ee7613ecUL;
   tf->codes[7147] = 0x000009fef6c092daUL;
   tf->codes[7148] = 0x00000a03ff0b11c8UL;
   tf->codes[7149] = 0x00000a0a2c20ad8fUL;
   tf->codes[7150] = 0x00000a14ec62bcbaUL;
   tf->codes[7151] = 0x00000a190a712494UL;
   tf->codes[7152] = 0x00000a1d287f8c6eUL;
   tf->codes[7153] = 0x00000a247a60450eUL;
   tf->codes[7154] = 0x00000a2a3257d54bUL;
   tf->codes[7155] = 0x00000a2b91b1f7e9UL;
   tf->codes[7156] = 0x00000a2c06d00373UL;
   tf->codes[7157] = 0x00000a2cb67d14c2UL;
   tf->codes[7158] = 0x00000a33933fc1d8UL;
   tf->codes[7159] = 0x00000a347d7bd8ecUL;
   tf->codes[7160] = 0x00000a38266c353cUL;
   tf->codes[7161] = 0x00000a3a35736929UL;
   tf->codes[7162] = 0x00000a3ae5207a78UL;
   tf->codes[7163] = 0x00000a3b1faf803dUL;
   tf->codes[7164] = 0x00000a3bcf5c918cUL;
   tf->codes[7165] = 0x00000a42719038ddUL;
   tf->codes[7166] = 0x00000a461a80952dUL;
   tf->codes[7167] = 0x00000a46ca2da67cUL;
   tf->codes[7168] = 0x00000a523a1cc6f6UL;
   tf->codes[7169] = 0x00000a5274abccbbUL;
   tf->codes[7170] = 0x00000a540e94f51eUL;
   tf->codes[7171] = 0x00000a561d9c290bUL;
   tf->codes[7172] = 0x00000a5bd593b948UL;
   tf->codes[7173] = 0x00000a5cfa5ed621UL;
   tf->codes[7174] = 0x00000a674582d9c2UL;
   tf->codes[7175] = 0x00000a67f52feb11UL;
   tf->codes[7176] = 0x00000a68df6c0225UL;
   tf->codes[7177] = 0x00000a6cfd7a69ffUL;
   tf->codes[7178] = 0x00000a7e9a7f2640UL;
   tf->codes[7179] = 0x00000a811ea465b7UL;
   tf->codes[7180] = 0x00000a8193c27141UL;
   tf->codes[7181] = 0x00000a81ce517706UL;
   tf->codes[7182] = 0x00000a8786490743UL;
   tf->codes[7183] = 0x00000a8ed829bfe3UL;
   tf->codes[7184] = 0x00000a92f63827bdUL;
   tf->codes[7185] = 0x00000a95053f5baaUL;
   tf->codes[7186] = 0x00000aa2bec4b5d6UL;
   tf->codes[7187] = 0x00000aa3e38fd2afUL;
   tf->codes[7188] = 0x00000aa41e1ed874UL;
   tf->codes[7189] = 0x00000ab50b768366UL;
   tf->codes[7190] = 0x00000ab7ca2ac8a2UL;
   tf->codes[7191] = 0x00000ab92984eb40UL;
   tf->codes[7192] = 0x00000ac12b12b52fUL;
   tf->codes[7193] = 0x00000ac2ff8ae357UL;
   tf->codes[7194] = 0x00000ac583b022ceUL;
   tf->codes[7195] = 0x00000acac689a781UL;
   tf->codes[7196] = 0x00000ad1a34c5497UL;
   tf->codes[7197] = 0x00000ad7d061f05eUL;
   tf->codes[7198] = 0x00000ada8f16359aUL;
   tf->codes[7199] = 0x00000ae49fab3376UL;
   tf->codes[7200] = 0x00000ae5c476504fUL;
   tf->codes[7201] = 0x00000ae67423619eUL;
   tf->codes[7202] = 0x00000af6773ef57cUL;
   tf->codes[7203] = 0x00000afa5abe5791UL;
   tf->codes[7204] = 0x00000afb7f89746aUL;
   tf->codes[7205] = 0x00000afdc91fae1cUL;
   tf->codes[7206] = 0x00000b030bf932cfUL;
   tf->codes[7207] = 0x00000b0346883894UL;
   tf->codes[7208] = 0x00000b063fcb8395UL;
   tf->codes[7209] = 0x00000b067a5a895aUL;
   tf->codes[7210] = 0x00000b0c32521997UL;
   tf->codes[7211] = 0x00000b0e7be85349UL;
   tf->codes[7212] = 0x00000b0f2b956498UL;
   tf->codes[7213] = 0x00000b14e38cf4d5UL;
   tf->codes[7214] = 0x00000b16b80522fdUL;
   tf->codes[7215] = 0x00000b193c2a6274UL;
   tf->codes[7216] = 0x00000b19ebd773c3UL;
   tf->codes[7217] = 0x00000b1b10a2909cUL;
   tf->codes[7218] = 0x00000b1b4b319661UL;
   tf->codes[7219] = 0x00000b20537c154fUL;
   tf->codes[7220] = 0x00000b21b2d637edUL;
   tf->codes[7221] = 0x00000b23fc6c719fUL;
   tf->codes[7222] = 0x00000b2c73184718UL;
   tf->codes[7223] = 0x00000b36be3c4ab9UL;
   tf->codes[7224] = 0x00000b3942618a30UL;
   tf->codes[7225] = 0x00000b4fe7b0c55fUL;
   tf->codes[7226] = 0x00000b55da375b61UL;
   tf->codes[7227] = 0x00000b609a796a8cUL;
   tf->codes[7228] = 0x00000b62346292efUL;
   tf->codes[7229] = 0x00000b626ef198b4UL;
   tf->codes[7230] = 0x00000b63ce4bbb52UL;
   tf->codes[7231] = 0x00000b656834e3b5UL;
   tf->codes[7232] = 0x00000b67773c17a2UL;
   tf->codes[7233] = 0x00000b6986434b8fUL;
   tf->codes[7234] = 0x00000b6c7f869690UL;
   tf->codes[7235] = 0x00000b735c4943a6UL;
   tf->codes[7236] = 0x00000b7a390bf0bcUL;
   tf->codes[7237] = 0x00000b7aae29fc46UL;
   tf->codes[7238] = 0x00000b7b9866135aUL;
   tf->codes[7239] = 0x00000b823a99baabUL;
   tf->codes[7240] = 0x00000b827528c070UL;
   tf->codes[7241] = 0x00000b8867af5672UL;
   tf->codes[7242] = 0x00000b94874b883bUL;
   tf->codes[7243] = 0x00000b95e6a5aad9UL;
   tf->codes[7244] = 0x00000b9bd92c40dbUL;
   tf->codes[7245] = 0x00000ba3daba0acaUL;
   tf->codes[7246] = 0x00000ba6996e5006UL;
   tf->codes[7247] = 0x00000bab6729c92fUL;
   tf->codes[7248] = 0x00000bb7c15500bdUL;
   tf->codes[7249] = 0x00000bb8ab9117d1UL;
   tf->codes[7250] = 0x00000bba800945f9UL;
   tf->codes[7251] = 0x00000bbe6388a80eUL;
   tf->codes[7252] = 0x00000bc20c79045eUL;
   tf->codes[7253] = 0x00000bc74f528911UL;
   tf->codes[7254] = 0x00000bc8741da5eaUL;
   tf->codes[7255] = 0x00000bc998e8c2c3UL;
   tf->codes[7256] = 0x00000bd125588128UL;
   tf->codes[7257] = 0x00000bd15fe786edUL;
   tf->codes[7258] = 0x00000bd284b2a3c6UL;
   tf->codes[7259] = 0x00000bd3345fb515UL;
   tf->codes[7260] = 0x00000bd54366e902UL;
   tf->codes[7261] = 0x00000bd6683205dbUL;
   tf->codes[7262] = 0x00000bdc20299618UL;
   tf->codes[7263] = 0x00000be19d922090UL;
   tf->codes[7264] = 0x00000be3e7285a42UL;
   tf->codes[7265] = 0x00000beafe7a0d1dUL;
   tf->codes[7266] = 0x00000bf12b8fa8e4UL;
   tf->codes[7267] = 0x00000bf5842d1683UL;
   tf->codes[7268] = 0x00000c012eab3cc2UL;
   tf->codes[7269] = 0x00000c0303236aeaUL;
   tf->codes[7270] = 0x00000c0b3f403a9eUL;
   tf->codes[7271] = 0x00000c116c55d665UL;
   tf->codes[7272] = 0x00000c11e173e1efUL;
   tf->codes[7273] = 0x00000c1cdc44f6dfUL;
   tf->codes[7274] = 0x00000c20101747a5UL;
   tf->codes[7275] = 0x00000c284c341759UL;
   tf->codes[7276] = 0x00000c3b4892f638UL;
   tf->codes[7277] = 0x00000c455927f414UL;
   tf->codes[7278] = 0x00000c52d81e487bUL;
   tf->codes[7279] = 0x00000c60cc32a86cUL;
   tf->codes[7280] = 0x00000c66842a38a9UL;
   tf->codes[7281] = 0x00000c6a67a99abeUL;
   tf->codes[7282] = 0x00000c71b98a535eUL;
   tf->codes[7283] = 0x00000c74783e989aUL;
   tf->codes[7284] = 0x00000c847b5a2c78UL;
   tf->codes[7285] = 0x00000c856596438cUL;
   tf->codes[7286] = 0x00000c91101469cbUL;
   tf->codes[7287] = 0x00000c9185327555UL;
   tf->codes[7288] = 0x00000c94f393cbe0UL;
   tf->codes[7289] = 0x00000c95ddcfe2f4UL;
   tf->codes[7290] = 0x00000ca397553d20UL;
   tf->codes[7291] = 0x00000ca914bdc798UL;
   tf->codes[7292] = 0x00000cb53459f961UL;
   tf->codes[7293] = 0x00000cb65925163aUL;
   tf->codes[7294] = 0x00000cb82d9d4462UL;
   tf->codes[7295] = 0x00000cbab1c283d9UL;
   tf->codes[7296] = 0x00000ccbd9a93490UL;
   tf->codes[7297] = 0x00000ccc14383a55UL;
   tf->codes[7298] = 0x00000cd784275acfUL;
   tf->codes[7299] = 0x00000cd9589f88f7UL;
   tf->codes[7300] = 0x00000ce9964a229aUL;
   tf->codes[7301] = 0x00000cf28214039dUL;
   tf->codes[7302] = 0x00000cf2bca30962UL;
   tf->codes[7303] = 0x00000cf4cbaa3d4fUL;
   tf->codes[7304] = 0x00000cf83a0b93daUL;
   tf->codes[7305] = 0x00000cf92447aaeeUL;
   tf->codes[7306] = 0x00000d02852f977bUL;
   tf->codes[7307] = 0x00000d041f18bfdeUL;
   tf->codes[7308] = 0x00000d12884b2b59UL;
   tf->codes[7309] = 0x00000d17cb24b00cUL;
   tf->codes[7310] = 0x00000d1baea41221UL;
   tf->codes[7311] = 0x00000d1e32c95198UL;
   tf->codes[7312] = 0x00000d1fccb279fbUL;
   tf->codes[7313] = 0x00000d21a12aa823UL;
   tf->codes[7314] = 0x00000d28f30b60c3UL;
   tf->codes[7315] = 0x00000d2cd68ac2d8UL;
   tf->codes[7316] = 0x00000d2ee591f6c5UL;
   tf->codes[7317] = 0x00000d32c91158daUL;
   tf->codes[7318] = 0x00000d36ac90baefUL;
   tf->codes[7319] = 0x00000d384679e352UL;
   tf->codes[7320] = 0x00000d41e1f0d5a4UL;
   tf->codes[7321] = 0x00000d43414af842UL;
   tf->codes[7322] = 0x00000d46ea3b5492UL;
   tf->codes[7323] = 0x00000d5085b246e4UL;
   tf->codes[7324] = 0x00000d50fad0526eUL;
   tf->codes[7325] = 0x00000d56ed56e870UL;
   tf->codes[7326] = 0x00000d5812220549UL;
   tf->codes[7327] = 0x00000d5f2973b824UL;
   tf->codes[7328] = 0x00000d61387aec11UL;
   tf->codes[7329] = 0x00000d672b018213UL;
   tf->codes[7330] = 0x00000d67659087d8UL;
   tf->codes[7331] = 0x00000d68ff79b03bUL;
   tf->codes[7332] = 0x00000d793d2449deUL;
   tf->codes[7333] = 0x00000d7ce614a62eUL;
   tf->codes[7334] = 0x00000d81b3d01f57UL;
   tf->codes[7335] = 0x00000d88cb21d232UL;
   tf->codes[7336] = 0x00000d976ee34372UL;
   tf->codes[7337] = 0x00000d9908cc6bd5UL;
   tf->codes[7338] = 0x00000d9aa2b59438UL;
   tf->codes[7339] = 0x00000d9fe58f18ebUL;
   tf->codes[7340] = 0x00000da05aad2475UL;
   tf->codes[7341] = 0x00000da64d33ba77UL;
   tf->codes[7342] = 0x00000db3570c0354UL;
   tf->codes[7343] = 0x00000db4b66625f2UL;
   tf->codes[7344] = 0x00000db5db3142cbUL;
   tf->codes[7345] = 0x00000dc2355c7a59UL;
   tf->codes[7346] = 0x00000dc5692ecb1fUL;
   tf->codes[7347] = 0x00000dccbb0f83bfUL;
   tf->codes[7348] = 0x00000dd02970da4aUL;
   tf->codes[7349] = 0x00000dd2730713fcUL;
   tf->codes[7350] = 0x00000dd35d432b10UL;
   tf->codes[7351] = 0x00000dd77b5192eaUL;
   tf->codes[7352] = 0x00000dda7494ddebUL;
   tf->codes[7353] = 0x00000de325cfb929UL;
   tf->codes[7354] = 0x00000de7f38b3252UL;
   tf->codes[7355] = 0x00000df5ad108c7eUL;
   tf->codes[7356] = 0x00000df746f9b4e1UL;
   tf->codes[7357] = 0x00000df9cb1ef458UL;
   tf->codes[7358] = 0x00000dfbda262845UL;
   tf->codes[7359] = 0x00000e01578eb2bdUL;
   tf->codes[7360] = 0x00000e03dbb3f234UL;
   tf->codes[7361] = 0x00000e05b02c205cUL;
   tf->codes[7362] = 0x00000e0ba2b2b65eUL;
   tf->codes[7363] = 0x00000e0cc77dd337UL;
   tf->codes[7364] = 0x00000e10e58c3b11UL;
   tf->codes[7365] = 0x00000e18376cf3b1UL;
   tf->codes[7366] = 0x00000e22f7af02dcUL;
   tf->codes[7367] = 0x00000e262b8153a2UL;
   tf->codes[7368] = 0x00000e2715bd6ab6UL;
   tf->codes[7369] = 0x00000e28ea3598deUL;
   tf->codes[7370] = 0x00000e29d471aff2UL;
   tf->codes[7371] = 0x00000e341f95b393UL;
   tf->codes[7372] = 0x00000e35b97edbf6UL;
   tf->codes[7373] = 0x00000e35f40de1bbUL;
   tf->codes[7374] = 0x00000e3878332132UL;
   tf->codes[7375] = 0x00000e466c478123UL;
   tf->codes[7376] = 0x00000e49a019d1e9UL;
   tf->codes[7377] = 0x00000e4baf2105d6UL;
   tf->codes[7378] = 0x00000e5425ccdb4fUL;
   tf->codes[7379] = 0x00000e55bfb603b2UL;
   tf->codes[7380] = 0x00000e571f102650UL;
   tf->codes[7381] = 0x00000e65fd609d55UL;
   tf->codes[7382] = 0x00000e716d4fbdcfUL;
   tf->codes[7383] = 0x00000e784a126ae5UL;
   tf->codes[7384] = 0x00000e842f1f96e9UL;
   tf->codes[7385] = 0x00000e97db2b8717UL;
   tf->codes[7386] = 0x00000e9a5f50c68eUL;
   tf->codes[7387] = 0x00000e9b841be367UL;
   tf->codes[7388] = 0x00000ea2264f8ab8UL;
   tf->codes[7389] = 0x00000eace69199e3UL;
   tf->codes[7390] = 0x00000eb29e892a20UL;
   tf->codes[7391] = 0x00000eb3fde34cbeUL;
   tf->codes[7392] = 0x00000eb4e81f63d2UL;
   tf->codes[7393] = 0x00000eb522ae6997UL;
   tf->codes[7394] = 0x00000eb85680ba5dUL;
   tf->codes[7395] = 0x00000ebe4907505fUL;
   tf->codes[7396] = 0x00000ec107bb959bUL;
   tf->codes[7397] = 0x00000ec22c86b274UL;
   tf->codes[7398] = 0x00000ec4eb3af7b0UL;
   tf->codes[7399] = 0x00000ec8942b5400UL;
   tf->codes[7400] = 0x00000ecc77aab615UL;
   tf->codes[7401] = 0x00000ed0d04823b4UL;
   tf->codes[7402] = 0x00000ed2df4f57a1UL;
   tf->codes[7403] = 0x00000ed3546d632bUL;
   tf->codes[7404] = 0x00000ed59e039cddUL;
   tf->codes[7405] = 0x00000edbcb1938a4UL;
   tf->codes[7406] = 0x00000ee35788f709UL;
   tf->codes[7407] = 0x00000ee73b08591eUL;
   tf->codes[7408] = 0x00000eeb1e87bb33UL;
   tf->codes[7409] = 0x00000eeb5916c0f8UL;
   tf->codes[7410] = 0x00000eef772528d2UL;
   tf->codes[7411] = 0x00000ef14b9d56faUL;
   tf->codes[7412] = 0x00000ef94d2b20e9UL;
   tf->codes[7413] = 0x00000efae714494cUL;
   tf->codes[7414] = 0x00000f011429e513UL;
   tf->codes[7415] = 0x00000f07b65d8c64UL;
   tf->codes[7416] = 0x00000f0bd46bf43eUL;
   tf->codes[7417] = 0x00000f0cbea80b52UL;
   tf->codes[7418] = 0x00000f13264cacdeUL;
   tf->codes[7419] = 0x00000f1918d342e0UL;
   tf->codes[7420] = 0x00000f1a782d657eUL;
   tf->codes[7421] = 0x00000f1aed4b7108UL;
   tf->codes[7422] = 0x00000f1d36e1aabaUL;
   tf->codes[7423] = 0x00000f22049d23e3UL;
   tf->codes[7424] = 0x00000f24c351691fUL;
   tf->codes[7425] = 0x00000f28a6d0cb34UL;
   tf->codes[7426] = 0x00000f2a40b9f397UL;
   tf->codes[7427] = 0x00000f2c153221bfUL;
   tf->codes[7428] = 0x00000f332c83d49aUL;
   tf->codes[7429] = 0x00000f33dc30e5e9UL;
   tf->codes[7430] = 0x00000f3a7e648d3aUL;
   tf->codes[7431] = 0x00000f41d04545daUL;
   tf->codes[7432] = 0x00000f495cb5043fUL;
   tf->codes[7433] = 0x00000f52487ee542UL;
   tf->codes[7434] = 0x00000f62110b735bUL;
   tf->codes[7435] = 0x00000f6544ddc421UL;
   tf->codes[7436] = 0x00000f750d6a523aUL;
   tf->codes[7437] = 0x00000f7757008becUL;
   tf->codes[7438] = 0x00000f7cd4691664UL;
   tf->codes[7439] = 0x00000f9254ed34baUL;
   tf->codes[7440] = 0x00000f94d9127431UL;
   tf->codes[7441] = 0x00000f95c34e8b45UL;
   tf->codes[7442] = 0x00000f98bc91d646UL;
   tf->codes[7443] = 0x00000f9fd3e38921UL;
   tf->codes[7444] = 0x00000fa307b5d9e7UL;
   tf->codes[7445] = 0x00000fa37cd3e571UL;
   tf->codes[7446] = 0x00000fa934cb75aeUL;
   tf->codes[7447] = 0x00000fb0fbca39d8UL;
   tf->codes[7448] = 0x00000fb6b3c1ca15UL;
   tf->codes[7449] = 0x00000fc1ae92df05UL;
   tf->codes[7450] = 0x00000fc97591a32fUL;
   tf->codes[7451] = 0x00000fd38626a10bUL;
   tf->codes[7452] = 0x00000fd3c0b5a6d0UL;
   tf->codes[7453] = 0x00000fdcac7f87d3UL;
   tf->codes[7454] = 0x00000fe4ae0d51c2UL;
   tf->codes[7455] = 0x00000fe6bd1485afUL;
   tf->codes[7456] = 0x00000fe7a7509cc3UL;
   tf->codes[7457] = 0x00000fea2b75dc3aUL;
   tf->codes[7458] = 0x00000feef9315563UL;
   tf->codes[7459] = 0x00000fefe36d6c77UL;
   tf->codes[7460] = 0x00000ff2a221b1b3UL;
   tf->codes[7461] = 0x00000ff944555904UL;
   tf->codes[7462] = 0x00000ffa692075ddUL;
   tf->codes[7463] = 0x00000ffb18cd872cUL;
   tf->codes[7464] = 0x00000ffced45b554UL;
   tf->codes[7465] = 0x00001004b444797eUL;
   tf->codes[7466] = 0x00001009bc8ef86cUL;
   tf->codes[7467] = 0x0000100d657f54bcUL;
   tf->codes[7468] = 0x00001018605069acUL;
   tf->codes[7469] = 0x000010256a28b289UL;
   tf->codes[7470] = 0x00001027b3beec3bUL;
   tf->codes[7471] = 0x0000102b5caf488bUL;
   tf->codes[7472] = 0x0000102bd1cd5415UL;
   tf->codes[7473] = 0x0000102f059fa4dbUL;
   tf->codes[7474] = 0x0000103189c4e452UL;
   tf->codes[7475] = 0x0000103483082f53UL;
   tf->codes[7476] = 0x00001034bd973518UL;
   tf->codes[7477] = 0x00001040a2a4611cUL;
   tf->codes[7478] = 0x00001045e57de5cfUL;
   tf->codes[7479] = 0x0000104919503695UL;
   tf->codes[7480] = 0x0000104c4d22875bUL;
   tf->codes[7481] = 0x0000104ff612e3abUL;
   tf->codes[7482] = 0x00001050a5bff4faUL;
   tf->codes[7483] = 0x00001052051a1798UL;
   tf->codes[7484] = 0x00001053d99245c0UL;
   tf->codes[7485] = 0x000010591c6bca73UL;
   tf->codes[7486] = 0x000010599189d5fdUL;
   tf->codes[7487] = 0x0000105ba09109eaUL;
   tf->codes[7488] = 0x000010627d53b700UL;
   tf->codes[7489] = 0x00001068354b473dUL;
   tf->codes[7490] = 0x00001080e9a1b659UL;
   tf->codes[7491] = 0x0000108a8518a8abUL;
   tf->codes[7492] = 0x0000108d093de822UL;
   tf->codes[7493] = 0x0000109370e289aeUL;
   tf->codes[7494] = 0x00001098ee4b1426UL;
   tf->codes[7495] = 0x000010a548764bb4UL;
   tf->codes[7496] = 0x000010a8f166a804UL;
   tf->codes[7497] = 0x000010b2c76ca01bUL;
   tf->codes[7498] = 0x000010b46155c87eUL;
   tf->codes[7499] = 0x000010bbb336811eUL;
   tf->codes[7500] = 0x000010c1a5bd1720UL;
   tf->codes[7501] = 0x000010c2ca8833f9UL;
   tf->codes[7502] = 0x000010c5141e6dabUL;
   tf->codes[7503] = 0x000010c8f79dcfc0UL;
   tf->codes[7504] = 0x000010ceaf955ffdUL;
   tf->codes[7505] = 0x000010cf24b36b87UL;
   tf->codes[7506] = 0x000010d342c1d361UL;
   tf->codes[7507] = 0x000010d676942427UL;
   tf->codes[7508] = 0x000010e7d909daa3UL;
   tf->codes[7509] = 0x000010e93863fd41UL;
   tf->codes[7510] = 0x000010f2994be9ceUL;
   tf->codes[7511] = 0x000010f67ccb4be3UL;
   tf->codes[7512] = 0x000010f6b75a51a8UL;
   tf->codes[7513] = 0x000010fad568b982UL;
   tf->codes[7514] = 0x00001101ecba6c5dUL;
   tf->codes[7515] = 0x0000110311858936UL;
   tf->codes[7516] = 0x000011064557d9fcUL;
   tf->codes[7517] = 0x00001109b3b93087UL;
   tf->codes[7518] = 0x000011129f83118aUL;
   tf->codes[7519] = 0x000011155e3756c6UL;
   tf->codes[7520] = 0x00001117a7cd9078UL;
   tf->codes[7521] = 0x0000111ef9ae4918UL;
   tf->codes[7522] = 0x000011222d8099deUL;
   tf->codes[7523] = 0x0000112b8e68866bUL;
   tf->codes[7524] = 0x00001132a5ba3946UL;
   tf->codes[7525] = 0x0000113aa7480335UL;
   tf->codes[7526] = 0x0000114a35458b89UL;
   tf->codes[7527] = 0x00001152abf16102UL;
   tf->codes[7528] = 0x00001161ff5fe391UL;
   tf->codes[7529] = 0x0000116533323457UL;
   tf->codes[7530] = 0x0000116742396844UL;
   tf->codes[7531] = 0x0000117361d59a0dUL;
   tf->codes[7532] = 0x00001175364dc835UL;
   tf->codes[7533] = 0x00001175ab6bd3bfUL;
   tf->codes[7534] = 0x00001177ba7307acUL;
   tf->codes[7535] = 0x000011827ab516d7UL;
   tf->codes[7536] = 0x000011832a622826UL;
   tf->codes[7537] = 0x000011895777c3edUL;
   tf->codes[7538] = 0x0000118e5fc242dbUL;
   tf->codes[7539] = 0x00001191939493a1UL;
   tf->codes[7540] = 0x000011924341a4f0UL;
   tf->codes[7541] = 0x00001193a29bc78eUL;
   tf->codes[7542] = 0x0000119ba429917dUL;
   tf->codes[7543] = 0x000011aaf798140cUL;
   tf->codes[7544] = 0x000011b0ea1eaa0eUL;
   tf->codes[7545] = 0x000011b1d45ac122UL;
   tf->codes[7546] = 0x000011c83f1af68cUL;
   tf->codes[7547] = 0x000011cbad7c4d17UL;
   tf->codes[7548] = 0x000011d24faff468UL;
   tf->codes[7549] = 0x000011d4d3d533dfUL;
   tf->codes[7550] = 0x000011d757fa7356UL;
   tf->codes[7551] = 0x000011e6364aea5bUL;
   tf->codes[7552] = 0x000011e6ab68f5e5UL;
   tf->codes[7553] = 0x000011e75b160734UL;
   tf->codes[7554] = 0x000011f1a63a0ad5UL;
   tf->codes[7555] = 0x000011ff9a4e6ac6UL;
   tf->codes[7556] = 0x00001200bf19879fUL;
   tf->codes[7557] = 0x000012029391b5c7UL;
   tf->codes[7558] = 0x00001210c2351b7dUL;
   tf->codes[7559] = 0x0000121137532707UL;
   tf->codes[7560] = 0x00001213bb78667eUL;
   tf->codes[7561] = 0x00001216ef4ab744UL;
   tf->codes[7562] = 0x000012181415d41dUL;
   tf->codes[7563] = 0x00001219e88e0245UL;
   tf->codes[7564] = 0x0000122174fdc0aaUL;
   tf->codes[7565] = 0x00001221af8cc66fUL;
   tf->codes[7566] = 0x0000122224aad1f9UL;
   tf->codes[7567] = 0x00001227678456acUL;
   tf->codes[7568] = 0x000012288c4f7385UL;
   tf->codes[7569] = 0x0000122bc021c44bUL;
   tf->codes[7570] = 0x0000123ce8087502UL;
   tf->codes[7571] = 0x000012455eb44a7bUL;
   tf->codes[7572] = 0x00001249b751b81aUL;
   tf->codes[7573] = 0x0000124c3b76f791UL;
   tf->codes[7574] = 0x000012531839a4a7UL;
   tf->codes[7575] = 0x0000126bcc9013c3UL;
   tf->codes[7576] = 0x0000126c7c3d2512UL;
   tf->codes[7577] = 0x000012752d780050UL;
   tf->codes[7578] = 0x000012902b64a91eUL;
   tf->codes[7579] = 0x0000129324a7f41fUL;
   tf->codes[7580] = 0x000012935f36f9e4UL;
   tf->codes[7581] = 0x0000129708275634UL;
   tf->codes[7582] = 0x000012982cf2730dUL;
   tf->codes[7583] = 0x000012a327c387fdUL;
   tf->codes[7584] = 0x000012a4c1acb060UL;
   tf->codes[7585] = 0x000012a536cabbeaUL;
   tf->codes[7586] = 0x000012a65b95d8c3UL;
   tf->codes[7587] = 0x000012a86a9d0cb0UL;
   tf->codes[7588] = 0x000012b27b320a8cUL;
   tf->codes[7589] = 0x000012c243be98a5UL;
   tf->codes[7590] = 0x000012c53d01e3a6UL;
   tf->codes[7591] = 0x000012c7c127231dUL;
   tf->codes[7592] = 0x000012d2f6873dd2UL;
   tf->codes[7593] = 0x000012d36ba5495cUL;
   tf->codes[7594] = 0x000012e0b00c97feUL;
   tf->codes[7595] = 0x000012e1252aa388UL;
   tf->codes[7596] = 0x000012e2f9a2d1b0UL;
   tf->codes[7597] = 0x000012e6dd2233c5UL;
   tf->codes[7598] = 0x000012ef193f0379UL;
   tf->codes[7599] = 0x000012f2c22f5fc9UL;
   tf->codes[7600] = 0x000012f6e03dc7a3UL;
   tf->codes[7601] = 0x000012fb736a3b07UL;
   tf->codes[7602] = 0x00001301db0edc93UL;
   tf->codes[7603] = 0x0000130499c321cfUL;
   tf->codes[7604] = 0x000013087d4283e4UL;
   tf->codes[7605] = 0x00001315c1a9d286UL;
   tf->codes[7606] = 0x000013213198f300UL;
   tf->codes[7607] = 0x00001321e146044fUL;
   tf->codes[7608] = 0x00001327d3cc9a51UL;
   tf->codes[7609] = 0x00001332597fa3b7UL;
   tf->codes[7610] = 0x0000133e791bd580UL;
   tf->codes[7611] = 0x0000134bf81229e7UL;
   tf->codes[7612] = 0x0000134ef15574e8UL;
   tf->codes[7613] = 0x00001350c5cda310UL;
   tf->codes[7614] = 0x000013530f63dcc2UL;
   tf->codes[7615] = 0x0000135ce569d4d9UL;
   tf->codes[7616] = 0x0000136471d9933eUL;
   tf->codes[7617] = 0x00001365d133b5dcUL;
   tf->codes[7618] = 0x00001367e03ae9c9UL;
   tf->codes[7619] = 0x00001368ca7700ddUL;
   tf->codes[7620] = 0x000013693f950c67UL;
   tf->codes[7621] = 0x00001369b4b317f1UL;
   tf->codes[7622] = 0x00001372a07cf8f4UL;
   tf->codes[7623] = 0x00001374af842ce1UL;
   tf->codes[7624] = 0x00001377a8c777e2UL;
   tf->codes[7625] = 0x0000137d60bf081fUL;
   tf->codes[7626] = 0x00001380949158e5UL;
   tf->codes[7627] = 0x00001387e6721185UL;
   tf->codes[7628] = 0x0000138f3852ca25UL;
   tf->codes[7629] = 0x00001393566131ffUL;
   tf->codes[7630] = 0x00001397746f99d9UL;
   tf->codes[7631] = 0x0000139ae2d0f064UL;
   tf->codes[7632] = 0x0000139c7cba18c7UL;
   tf->codes[7633] = 0x0000139f00df583eUL;
   tf->codes[7634] = 0x000013a3ce9ad167UL;
   tf->codes[7635] = 0x000013a91174561aUL;
   tf->codes[7636] = 0x000013aa363f72f3UL;
   tf->codes[7637] = 0x000013b481637694UL;
   tf->codes[7638] = 0x000013b5311087e3UL;
   tf->codes[7639] = 0x000013bc0dd334f9UL;
   tf->codes[7640] = 0x000013becc877a35UL;
   tf->codes[7641] = 0x000013c20059cafbUL;
   tf->codes[7642] = 0x000013c2b006dc4aUL;
   tf->codes[7643] = 0x000013c32524e7d4UL;
   tf->codes[7644] = 0x000013c39a42f35eUL;
   tf->codes[7645] = 0x000013c8a28d724cUL;
   tf->codes[7646] = 0x000013d328407bb2UL;
   tf->codes[7647] = 0x000013d39d5e873cUL;
   tf->codes[7648] = 0x000013ddadf38518UL;
   tf->codes[7649] = 0x000013e5ea1054ccUL;
   tf->codes[7650] = 0x000013e7496a776aUL;
   tf->codes[7651] = 0x000013f7c1a416d2UL;
   tf->codes[7652] = 0x00001403a6b142d6UL;
   tf->codes[7653] = 0x0000141c9596b7b7UL;
   tf->codes[7654] = 0x00001422fd3b5943UL;
   tf->codes[7655] = 0x00001426310daa09UL;
   tf->codes[7656] = 0x000014350f5e210eUL;
   tf->codes[7657] = 0x00001441dea76426UL;
   tf->codes[7658] = 0x000014458797c076UL;
   tf->codes[7659] = 0x00001453068e14ddUL;
   tf->codes[7660] = 0x000014542b5931b6UL;
   tf->codes[7661] = 0x000014616fc08058UL;
   tf->codes[7662] = 0x00001465533fe26dUL;
   tf->codes[7663] = 0x00001466b29a050bUL;
   tf->codes[7664] = 0x00001472d23636d4UL;
   tf->codes[7665] = 0x00001475565b764bUL;
   tf->codes[7666] = 0x00001477da80b5c2UL;
   tf->codes[7667] = 0x00001479e987e9afUL;
   tf->codes[7668] = 0x0000148609241b78UL;
   tf->codes[7669] = 0x00001491ee31477cUL;
   tf->codes[7670] = 0x0000149312fc6455UL;
   tf->codes[7671] = 0x0000149bfec64558UL;
   tf->codes[7672] = 0x0000149c73e450e2UL;
   tf->codes[7673] = 0x000014a5d4cc3d6fUL;
   tf->codes[7674] = 0x000014ab5234c7e7UL;
   tf->codes[7675] = 0x000014b6c223e861UL;
   tf->codes[7676] = 0x000014b73741f3ebUL;
   tf->codes[7677] = 0x000014b90bba2213UL;
   tf->codes[7678] = 0x000014c52b5653dcUL;
   tf->codes[7679] = 0x000014c615926af0UL;
   tf->codes[7680] = 0x000014c6c53f7c3fUL;
   tf->codes[7681] = 0x000014cec6cd462eUL;
   tf->codes[7682] = 0x000014d09b457456UL;
   tf->codes[7683] = 0x000014d2aa4ca843UL;
   tf->codes[7684] = 0x000014d94c804f94UL;
   tf->codes[7685] = 0x000014da714b6c6dUL;
   tf->codes[7686] = 0x000014dae66977f7UL;
   tf->codes[7687] = 0x000014dcf570abe4UL;
   tf->codes[7688] = 0x000014e14e0e1983UL;
   tf->codes[7689] = 0x000014e40cc25ebfUL;
   tf->codes[7690] = 0x000014e89feed223UL;
   tf->codes[7691] = 0x000014ecf88c3fc2UL;
   tf->codes[7692] = 0x000014efb74084feUL;
   tf->codes[7693] = 0x000014fa0264889fUL;
   tf->codes[7694] = 0x000015015445413fUL;
   tf->codes[7695] = 0x000015057253a919UL;
   tf->codes[7696] = 0x000015127c2bf1f6UL;
   tf->codes[7697] = 0x00001515ea8d4881UL;
   tf->codes[7698] = 0x0000151a089bb05bUL;
   tf->codes[7699] = 0x000015211fed6336UL;
   tf->codes[7700] = 0x00001523a412a2adUL;
   tf->codes[7701] = 0x00001529d1283e74UL;
   tf->codes[7702] = 0x0000152a0bb74439UL;
   tf->codes[7703] = 0x0000152b30826112UL;
   tf->codes[7704] = 0x0000152f4e90c8ecUL;
   tf->codes[7705] = 0x000015315d97fcd9UL;
   tf->codes[7706] = 0x0000153247d413edUL;
   tf->codes[7707] = 0x00001532826319b2UL;
   tf->codes[7708] = 0x0000153a0ed2d817UL;
   tf->codes[7709] = 0x0000154126248af2UL;
   tf->codes[7710] = 0x000015441f67d5f3UL;
   tf->codes[7711] = 0x0000154509a3ed07UL;
   tf->codes[7712] = 0x00001547c8583243UL;
   tf->codes[7713] = 0x00001555474e86aaUL;
   tf->codes[7714] = 0x00001561dc08c3fdUL;
   tf->codes[7715] = 0x00001570453b2f78UL;
   tf->codes[7716] = 0x0000157512f6a8a1UL;
   tf->codes[7717] = 0x0000158466652b30UL;
   tf->codes[7718] = 0x0000158b4327d846UL;
   tf->codes[7719] = 0x000015925a798b21UL;
   tf->codes[7720] = 0x000015937f44a7faUL;
   tf->codes[7721] = 0x0000159bbb6177aeUL;
   tf->codes[7722] = 0x000015a0891cf0d7UL;
   tf->codes[7723] = 0x000015a6b6328c9eUL;
   tf->codes[7724] = 0x000015b3857bcfb6UL;
   tf->codes[7725] = 0x000015b7a38a3790UL;
   tf->codes[7726] = 0x000015ba9ccd8291UL;
   tf->codes[7727] = 0x000015c179902fa7UL;
   tf->codes[7728] = 0x000015c7a6a5cb6eUL;
   tf->codes[7729] = 0x000015cb150721f9UL;
   tf->codes[7730] = 0x000015ccaef04a5cUL;
   tf->codes[7731] = 0x000015d5602b259aUL;
   tf->codes[7732] = 0x000015db52b1bb9cUL;
   tf->codes[7733] = 0x000015e22f7468b2UL;
   tf->codes[7734] = 0x000015eae0af43f0UL;
   tf->codes[7735] = 0x000015f5db8058e0UL;
   tf->codes[7736] = 0x00001614bcec63c3UL;
   tf->codes[7737] = 0x000016218c35a6dbUL;
   tf->codes[7738] = 0x000016277ebc3cddUL;
   tf->codes[7739] = 0x000016298dc370caUL;
   tf->codes[7740] = 0x00001634889485baUL;
   tf->codes[7741] = 0x0000163ed3b8895bUL;
   tf->codes[7742] = 0x000016411d4ec30dUL;
   tf->codes[7743] = 0x00001642b737eb70UL;
   tf->codes[7744] = 0x00001643dc030849UL;
   tf->codes[7745] = 0x00001647bf826a5eUL;
   tf->codes[7746] = 0x0000164993fa9886UL;
   tf->codes[7747] = 0x0000164c8d3de387UL;
   tf->codes[7748] = 0x000016532f718ad8UL;
   tf->codes[7749] = 0x000016566343db9eUL;
   tf->codes[7750] = 0x0000165c90597765UL;
   tf->codes[7751] = 0x00001664cc764719UL;
   tf->codes[7752] = 0x000016692513b4b8UL;
   tf->codes[7753] = 0x0000166be3c7f9f4UL;
   tf->codes[7754] = 0x000016737037b859UL;
   tf->codes[7755] = 0x00001678b3113d0cUL;
   tf->codes[7756] = 0x0000168129bd1285UL;
   tf->codes[7757] = 0x0000168289173523UL;
   tf->codes[7758] = 0x00001685825a8024UL;
   tf->codes[7759] = 0x00001685bce985e9UL;
   tf->codes[7760] = 0x0000168baf701bebUL;
   tf->codes[7761] = 0x0000168be9ff21b0UL;
   tf->codes[7762] = 0x00001690b7ba9ad9UL;
   tf->codes[7763] = 0x000016921714bd77UL;
   tf->codes[7764] = 0x00001698442a593eUL;
   tf->codes[7765] = 0x0000169a8dc092f0UL;
   tf->codes[7766] = 0x0000169fd09a17a3UL;
   tf->codes[7767] = 0x000016a0804728f2UL;
   tf->codes[7768] = 0x000016a513739c56UL;
   tf->codes[7769] = 0x000016a5fdafb36aUL;
   tf->codes[7770] = 0x000016ab4089381dUL;
   tf->codes[7771] = 0x000016b21d4be533UL;
   tf->codes[7772] = 0x000016bbf351dd4aUL;
   tf->codes[7773] = 0x000016bca2feee99UL;
   tf->codes[7774] = 0x000016bd52abffe8UL;
   tf->codes[7775] = 0x000016bfd6d13f5fUL;
   tf->codes[7776] = 0x000016c1362b61fdUL;
   tf->codes[7777] = 0x000016c220677911UL;
   tf->codes[7778] = 0x000016cb0c315a14UL;
   tf->codes[7779] = 0x000016d08999e48cUL;
   tf->codes[7780] = 0x000016d8c5b6b440UL;
   tf->codes[7781] = 0x000016da2510d6deUL;
   tf->codes[7782] = 0x000016e2269ea0cdUL;
   tf->codes[7783] = 0x000016e6b9cb1431UL;
   tf->codes[7784] = 0x000016e6f45a19f6UL;
   tf->codes[7785] = 0x000016e7de96310aUL;
   tf->codes[7786] = 0x000016ec71c2a46eUL;
   tf->codes[7787] = 0x000016f264493a70UL;
   tf->codes[7788] = 0x000016f2d96745faUL;
   tf->codes[7789] = 0x000016f313f64bbfUL;
   tf->codes[7790] = 0x000016f5d2aa90fbUL;
   tf->codes[7791] = 0x000017038c2feb27UL;
   tf->codes[7792] = 0x0000171ae12c37a5UL;
   tf->codes[7793] = 0x0000171dda6f82a6UL;
   tf->codes[7794] = 0x000017231d490759UL;
   tf->codes[7795] = 0x0000172ae447cb83UL;
   tf->codes[7796] = 0x0000172b1ed6d148UL;
   tf->codes[7797] = 0x0000172b5965d70dUL;
   tf->codes[7798] = 0x000017352f6bcf24UL;
   tf->codes[7799] = 0x000017373e730311UL;
   tf->codes[7800] = 0x00001746cc708b65UL;
   tf->codes[7801] = 0x00001749c5b3d666UL;
   tf->codes[7802] = 0x0000174b9a2c048eUL;
   tf->codes[7803] = 0x0000174c0f4a1018UL;
   tf->codes[7804] = 0x0000174cf986272cUL;
   tf->codes[7805] = 0x0000174fb83a6c68UL;
   tf->codes[7806] = 0x00001752b17db769UL;
   tf->codes[7807] = 0x00001753d648d442UL;
   tf->codes[7808] = 0x000017557031fca5UL;
   tf->codes[7809] = 0x00001757f4573c1cUL;
   tf->codes[7810] = 0x000017623f7b3fbdUL;
   tf->codes[7811] = 0x0000177660a53b75UL;
   tf->codes[7812] = 0x0000177994778c3bUL;
   tf->codes[7813] = 0x000017820b2361b4UL;
   tf->codes[7814] = 0x00001787136de0a2UL;
   tf->codes[7815] = 0x0000178b317c487cUL;
   tf->codes[7816] = 0x00001794ccf33aceUL;
   tf->codes[7817] = 0x000017999aaeb3f7UL;
   tf->codes[7818] = 0x0000179b6f26e21fUL;
   tf->codes[7819] = 0x000017ac970d92d6UL;
   tf->codes[7820] = 0x000017b164c90bffUL;
   tf->codes[7821] = 0x000017b87c1abedaUL;
   tf->codes[7822] = 0x000017b8b6a9c49fUL;
   tf->codes[7823] = 0x000017c2c73ec27bUL;
   tf->codes[7824] = 0x000017c794fa3ba4UL;
   tf->codes[7825] = 0x000017d3ef257332UL;
   tf->codes[7826] = 0x000017db0677260dUL;
   tf->codes[7827] = 0x000017dee9f68822UL;
   tf->codes[7828] = 0x000017df24858de7UL;
   tf->codes[7829] = 0x000017ea1f56a2d7UL;
   tf->codes[7830] = 0x000017ee02d604ecUL;
   tf->codes[7831] = 0x000017eeed121c00UL;
   tf->codes[7832] = 0x000017f04c6c3e9eUL;
   tf->codes[7833] = 0x000017f220e46cc6UL;
   tf->codes[7834] = 0x000017f3803e8f64UL;
   tf->codes[7835] = 0x000017f4df98b202UL;
   tf->codes[7836] = 0x000017f7292eebb4UL;
   tf->codes[7837] = 0x000017f8fda719dcUL;
   tf->codes[7838] = 0x000017fad21f4804UL;
   tf->codes[7839] = 0x00001801e970fadfUL;
   tf->codes[7840] = 0x0000180b4a58e76cUL;
   tf->codes[7841] = 0x000018160a9af697UL;
   tf->codes[7842] = 0x00001825d32784b0UL;
   tf->codes[7843] = 0x0000182b8b1f14edUL;
   tf->codes[7844] = 0x0000182bc5ae1ab2UL;
   tf->codes[7845] = 0x00001833521dd917UL;
   tf->codes[7846] = 0x000018352696073fUL;
   tf->codes[7847] = 0x0000184146323908UL;
   tf->codes[7848] = 0x0000184355396cf5UL;
   tf->codes[7849] = 0x000018459ecfa6a7UL;
   tf->codes[7850] = 0x000018568c275199UL;
   tf->codes[7851] = 0x00001859856a9c9aUL;
   tf->codes[7852] = 0x0000185f3d622cd7UL;
   tf->codes[7853] = 0x000018609cbc4f75UL;
   tf->codes[7854] = 0x00001874bde64b2dUL;
   tf->codes[7855] = 0x00001876925e7955UL;
   tf->codes[7856] = 0x00001883d6c5c7f7UL;
   tf->codes[7857] = 0x0000188e5c78d15dUL;
   tf->codes[7858] = 0x00001891904b2223UL;
   tf->codes[7859] = 0x000018927a873937UL;
   tf->codes[7860] = 0x0000189782d1b825UL;
   tf->codes[7861] = 0x0000189b66511a3aUL;
   tf->codes[7862] = 0x000018a4178bf578UL;
   tf->codes[7863] = 0x000018a4521afb3dUL;
   tf->codes[7864] = 0x000018a994f47ff0UL;
   tf->codes[7865] = 0x000018b53f72a62fUL;
   tf->codes[7866] = 0x000018b87344f6f5UL;
   tf->codes[7867] = 0x000018b8e863027fUL;
   tf->codes[7868] = 0x000018c4585222f9UL;
   tf->codes[7869] = 0x000018c5f23b4b5cUL;
   tf->codes[7870] = 0x000018c6675956e6UL;
   tf->codes[7871] = 0x000018cb6fa3d5d4UL;
   tf->codes[7872] = 0x000018d2fc139439UL;
   tf->codes[7873] = 0x000018da8883529eUL;
   tf->codes[7874] = 0x000018e0f027f42aUL;
   tf->codes[7875] = 0x000018e45e894ab5UL;
   tf->codes[7876] = 0x000018e50e365c04UL;
   tf->codes[7877] = 0x000018ec601714a4UL;
   tf->codes[7878] = 0x000018ef595a5fa5UL;
   tf->codes[7879] = 0x000018f1a2f09957UL;
   tf->codes[7880] = 0x000018f3ec86d309UL;
   tf->codes[7881] = 0x000018f8ba424c32UL;
   tf->codes[7882] = 0x00001900f65f1be6UL;
   tf->codes[7883] = 0x0000190290484449UL;
   tf->codes[7884] = 0x000019072374b7adUL;
   tf->codes[7885] = 0x0000190b7c12254cUL;
   tf->codes[7886] = 0x0000191eed8f0fb5UL;
   tf->codes[7887] = 0x000019204ce93253UL;
   tf->codes[7888] = 0x00001926ef1cd9a4UL;
   tf->codes[7889] = 0x0000192b47ba4743UL;
   tf->codes[7890] = 0x0000192e7b8c9809UL;
   tf->codes[7891] = 0x00001932247cf459UL;
   tf->codes[7892] = 0x00001933be661cbcUL;
   tf->codes[7893] = 0x00001934e3313995UL;
   tf->codes[7894] = 0x00001936428b5c33UL;
   tf->codes[7895] = 0x00001937dc748496UL;
   tf->codes[7896] = 0x000019455b6ad8fdUL;
   tf->codes[7897] = 0x00001947df901874UL;
   tf->codes[7898] = 0x000019488f3d29c3UL;
   tf->codes[7899] = 0x000019493eea3b12UL;
   tf->codes[7900] = 0x0000194cad4b919dUL;
   tf->codes[7901] = 0x00001953c49d4478UL;
   tf->codes[7902] = 0x0000195d25853105UL;
   tf->codes[7903] = 0x000019739045666fUL;
   tf->codes[7904] = 0x00001978988fe55dUL;
   tf->codes[7905] = 0x0000197f75529273UL;
   tf->codes[7906] = 0x00001984430e0b9cUL;
   tf->codes[7907] = 0x0000198a3594a19eUL;
   tf->codes[7908] = 0x00001993215e82a1UL;
   tf->codes[7909] = 0x00001994bb47ab04UL;
   tf->codes[7910] = 0x0000199779fbf040UL;
   tf->codes[7911] = 0x0000199a733f3b41UL;
   tf->codes[7912] = 0x000019b3d742bbacUL;
   tf->codes[7913] = 0x000019ba04585773UL;
   tf->codes[7914] = 0x000019c414ed554fUL;
   tf->codes[7915] = 0x000019c6991294c6UL;
   tf->codes[7916] = 0x000019d5b1f21190UL;
   tf->codes[7917] = 0x000019d8ab355c91UL;
   tf->codes[7918] = 0x000019e7c414d95bUL;
   tf->codes[7919] = 0x00001a14247738a5UL;
   tf->codes[7920] = 0x00001a150eb34fb9UL;
   tf->codes[7921] = 0x00001a184285a07fUL;
   tf->codes[7922] = 0x00001a192cc1b793UL;
   tf->codes[7923] = 0x00001a1c26050294UL;
   tf->codes[7924] = 0x00001a1e350c3681UL;
   tf->codes[7925] = 0x00001a1ee4b947d0UL;
   tf->codes[7926] = 0x00001a2c9e3ea1fcUL;
   tf->codes[7927] = 0x00001a4552951118UL;
   tf->codes[7928] = 0x00001a463cd1282cUL;
   tf->codes[7929] = 0x00001a493614732dUL;
   tf->codes[7930] = 0x00001a646e9021c0UL;
   tf->codes[7931] = 0x00001a65cdea445eUL;
   tf->codes[7932] = 0x00001a67a2627286UL;
   tf->codes[7933] = 0x00001a6b10c3c911UL;
   tf->codes[7934] = 0x00001a6c701debafUL;
   tf->codes[7935] = 0x00001a7228157becUL;
   tf->codes[7936] = 0x00001a881db7a5ccUL;
   tf->codes[7937] = 0x00001a8bc6a8021cUL;
   tf->codes[7938] = 0x00001a9adf877ee6UL;
   tf->codes[7939] = 0x00001aa390c25a24UL;
   tf->codes[7940] = 0x00001aa47afe7138UL;
   tf->codes[7941] = 0x00001aa77441bc39UL;
   tf->codes[7942] = 0x00001aab1d321889UL;
   tf->codes[7943] = 0x00001ab3594ee83dUL;
   tf->codes[7944] = 0x00001ab7023f448dUL;
   tf->codes[7945] = 0x00001ab86199672bUL;
   tf->codes[7946] = 0x00001abaab2fa0ddUL;
   tf->codes[7947] = 0x00001ac655adc71cUL;
   tf->codes[7948] = 0x00001ac6cacbd2a6UL;
   tf->codes[7949] = 0x00001acc48345d1eUL;
   tf->codes[7950] = 0x00001ad77d9477d3UL;
   tf->codes[7951] = 0x00001ae4fc8acc3aUL;
   tf->codes[7952] = 0x00001ae53719d1ffUL;
   tf->codes[7953] = 0x00001ae5e6c6e34eUL;
   tf->codes[7954] = 0x00001ae69673f49dUL;
   tf->codes[7955] = 0x00001aebd94d7950UL;
   tf->codes[7956] = 0x00001aed38a79beeUL;
   tf->codes[7957] = 0x00001af1cbd40f52UL;
   tf->codes[7958] = 0x00001af44ff94ec9UL;
   tf->codes[7959] = 0x00001af83378b0deUL;
   tf->codes[7960] = 0x00001afed5ac582fUL;
   tf->codes[7961] = 0x00001afffa777508UL;
   tf->codes[7962] = 0x00001b05b26f0545UL;
   tf->codes[7963] = 0x00001b115ced2b84UL;
   tf->codes[7964] = 0x00001b1281b8485dUL;
   tf->codes[7965] = 0x00001b13e1126afbUL;
   tf->codes[7966] = 0x00001b18aecde424UL;
   tf->codes[7967] = 0x00001b1abdd51811UL;
   tf->codes[7968] = 0x00001b2000ae9cc4UL;
   tf->codes[7969] = 0x00001b283ccb6c78UL;
   tf->codes[7970] = 0x00001b358132bb1aUL;
   tf->codes[7971] = 0x00001b41663fe71eUL;
   tf->codes[7972] = 0x00001b43ea652695UL;
   tf->codes[7973] = 0x00001b450f30436eUL;
   tf->codes[7974] = 0x00001b466e8a660cUL;
   tf->codes[7975] = 0x00001b47935582e5UL;
   tf->codes[7976] = 0x00001b51a3ea80c1UL;
   tf->codes[7977] = 0x00001b5a1a96563aUL;
   tf->codes[7978] = 0x00001b77278a32f5UL;
   tf->codes[7979] = 0x00001b78c1735b58UL;
   tf->codes[7980] = 0x00001b83472664beUL;
   tf->codes[7981] = 0x00001b8b48b42eadUL;
   tf->codes[7982] = 0x00001b9fa46d302aUL;
   tf->codes[7983] = 0x00001ba3c27b9804UL;
   tf->codes[7984] = 0x00001ba905551cb7UL;
   tf->codes[7985] = 0x00001bc2de76a8acUL;
   tf->codes[7986] = 0x00001bc5629be823UL;
   tf->codes[7987] = 0x00001bc7e6c1279aUL;
   tf->codes[7988] = 0x00001bd47b7b64edUL;
   tf->codes[7989] = 0x00001bd4f0997077UL;
   tf->codes[7990] = 0x00001bdb92cd17c8UL;
   tf->codes[7991] = 0x00001be31f3cd62dUL;
   tf->codes[7992] = 0x00001c018b8ad586UL;
   tf->codes[7993] = 0x00001c056f0a379bUL;
   tf->codes[7994] = 0x00001c0c113ddeecUL;
   tf->codes[7995] = 0x00001c10a46a5250UL;
   tf->codes[7996] = 0x00001c17f64b0af0UL;
   tf->codes[7997] = 0x00001c36d7b715d3UL;
   tf->codes[7998] = 0x00001c3abb3677e8UL;
   tf->codes[7999] = 0x00001c3ba5728efcUL;
   tf->codes[8000] = 0x00001c3cca3dabd5UL;
   tf->codes[8001] = 0x00001c462b259862UL;
   tf->codes[8002] = 0x00001c4b33701750UL;
   tf->codes[8003] = 0x00001c599ca282cbUL;
   tf->codes[8004] = 0x00001c5be638bc7dUL;
   tf->codes[8005] = 0x00001c633819751dUL;
   tf->codes[8006] = 0x00001c6422558c31UL;
   tf->codes[8007] = 0x00001c76e425654bUL;
   tf->codes[8008] = 0x00001c80f4ba6327UL;
   tf->codes[8009] = 0x00001c85c275dc50UL;
   tf->codes[8010] = 0x00001c86e740f929UL;
   tf->codes[8011] = 0x00001c8acac05b3eUL;
   tf->codes[8012] = 0x00001c942ba847cbUL;
   tf->codes[8013] = 0x00001c958b026a69UL;
   tf->codes[8014] = 0x00001c980f27a9e0UL;
   tf->codes[8015] = 0x00001c9a58bde392UL;
   tf->codes[8016] = 0x00001c9bf2a70bf5UL;
   tf->codes[8017] = 0x00001ca5c8ad040cUL;
   tf->codes[8018] = 0x00001ca6785a155bUL;
   tf->codes[8019] = 0x00001cb1389c2486UL;
   tf->codes[8020] = 0x00001cb4e18c80d6UL;
   tf->codes[8021] = 0x00001cb67b75a939UL;
   tf->codes[8022] = 0x00001cc51f371a79UL;
   tf->codes[8023] = 0x00001cca9c9fa4f1UL;
   tf->codes[8024] = 0x00001cda652c330aUL;
   tf->codes[8025] = 0x00001cda9fbb38cfUL;
   tf->codes[8026] = 0x00001cdada4a3e94UL;
   tf->codes[8027] = 0x00001cdc39a46132UL;
   tf->codes[8028] = 0x00001cf7e73e1b4fUL;
   tf->codes[8029] = 0x00001cfb902e779fUL;
   tf->codes[8030] = 0x00001d052ba569f1UL;
   tf->codes[8031] = 0x00001d1110b295f5UL;
   tf->codes[8032] = 0x00001d1394d7d56cUL;
   tf->codes[8033] = 0x00001d14b9a2f245UL;
   tf->codes[8034] = 0x00001d1703392bf7UL;
   tf->codes[8035] = 0x00001d17ed75430bUL;
   tf->codes[8036] = 0x00001d18d7b15a1fUL;
   tf->codes[8037] = 0x00001d240d1174d4UL;
   tf->codes[8038] = 0x00001d256c6b9772UL;
   tf->codes[8039] = 0x00001d29ff980ad6UL;
   tf->codes[8040] = 0x00001d3659c34264UL;
   tf->codes[8041] = 0x00001d37b91d6502UL;
   tf->codes[8042] = 0x00001d491b931b7eUL;
   tf->codes[8043] = 0x00001d4990b12708UL;
   tf->codes[8044] = 0x00001d6abbb36b9dUL;
   tf->codes[8045] = 0x00001d6c559c9400UL;
   tf->codes[8046] = 0x00001d72bd41358cUL;
   tf->codes[8047] = 0x00001d77c58bb47aUL;
   tf->codes[8048] = 0x00001d79d492e867UL;
   tf->codes[8049] = 0x00001d8509f3031cUL;
   tf->codes[8050] = 0x00001d85448208e1UL;
   tf->codes[8051] = 0x00001d92fe07630dUL;
   tf->codes[8052] = 0x00001d95bcbba849UL;
   tf->codes[8053] = 0x00001d99a03b0a5eUL;
   tf->codes[8054] = 0x00001d9be9d14410UL;
   tf->codes[8055] = 0x00001da33bb1fcb0UL;
   tf->codes[8056] = 0x00001da4d59b2513UL;
   tf->codes[8057] = 0x00001da5fa6641ecUL;
   tf->codes[8058] = 0x00001da759c0648aUL;
   tf->codes[8059] = 0x00001db1a4e4682bUL;
   tf->codes[8060] = 0x00001db33ecd908eUL;
   tf->codes[8061] = 0x00001db6729fe154UL;
   tf->codes[8062] = 0x00001dc63b2c6f6dUL;
   tf->codes[8063] = 0x00001dcbb894f9e5UL;
   tf->codes[8064] = 0x00001dcc68420b34UL;
   tf->codes[8065] = 0x00001dd9721a5411UL;
   tf->codes[8066] = 0x00001ddf2a11e44eUL;
   tf->codes[8067] = 0x00001de0896c06ecUL;
   tf->codes[8068] = 0x00001de3bd3e57b2UL;
   tf->codes[8069] = 0x00001de46ceb6901UL;
   tf->codes[8070] = 0x00001df22670c32dUL;
   tf->codes[8071] = 0x00001df3c059eb90UL;
   tf->codes[8072] = 0x00001df6f42c3c56UL;
   tf->codes[8073] = 0x00001df7de68536aUL;
   tf->codes[8074] = 0x00001df8c8a46a7eUL;
   tf->codes[8075] = 0x00001e00551428e3UL;
   tf->codes[8076] = 0x00001e101da0b6fcUL;
   tf->codes[8077] = 0x00001e28224a14c9UL;
   tf->codes[8078] = 0x00001e36165e74baUL;
   tf->codes[8079] = 0x00001e389a83b431UL;
   tf->codes[8080] = 0x00001e40d6a083e5UL;
   tf->codes[8081] = 0x00001e4703b61facUL;
   tf->codes[8082] = 0x00001e49fcf96aadUL;
   tf->codes[8083] = 0x00001e4bd17198d5UL;
   tf->codes[8084] = 0x00001e4cbbadafe9UL;
   tf->codes[8085] = 0x00001e5c49ab383dUL;
   tf->codes[8086] = 0x00001e6535751940UL;
   tf->codes[8087] = 0x00001e665a403619UL;
   tf->codes[8088] = 0x00001e6a03309269UL;
   tf->codes[8089] = 0x00001e7204be5c58UL;
   tf->codes[8090] = 0x00001e73d9368a80UL;
   tf->codes[8091] = 0x00001e7bdac4546fUL;
   tf->codes[8092] = 0x00001e82b7870185UL;
   tf->codes[8093] = 0x00001e82f216074aUL;
   tf->codes[8094] = 0x00001e83a1c31899UL;
   tf->codes[8095] = 0x00001e87bfd18073UL;
   tf->codes[8096] = 0x00001e915b4872c5UL;
   tf->codes[8097] = 0x00001e92458489d9UL;
   tf->codes[8098] = 0x00001e94c9a9c950UL;
   tf->codes[8099] = 0x00001ea99a80d657UL;
   tf->codes[8100] = 0x00001eb24bbbb195UL;
   tf->codes[8101] = 0x00001eb50a6ff6d1UL;
   tf->codes[8102] = 0x00001eb83e424797UL;
   tf->codes[8103] = 0x00001ebac267870eUL;
   tf->codes[8104] = 0x00001ebc21c1a9acUL;
   tf->codes[8105] = 0x00001ece6e73773cUL;
   tf->codes[8106] = 0x00001ed7cf5b63c9UL;
   tf->codes[8107] = 0x00001eeb0649486dUL;
   tf->codes[8108] = 0x00001eeca03270d0UL;
   tf->codes[8109] = 0x00001f1d93c1437eUL;
   tf->codes[8110] = 0x00001f1eb88c6057UL;
   tf->codes[8111] = 0x00001f2a287b80d1UL;
   tf->codes[8112] = 0x00001f2ad8289220UL;
   tf->codes[8113] = 0x00001f33144561d4UL;
   tf->codes[8114] = 0x00001f3389636d5eUL;
   tf->codes[8115] = 0x00001f33c3f27323UL;
   tf->codes[8116] = 0x00001f33fe8178e8UL;
   tf->codes[8117] = 0x00001f3b15d32bc3UL;
   tf->codes[8118] = 0x00001f40933bb63bUL;
   tf->codes[8119] = 0x00001f443c2c128bUL;
   tf->codes[8120] = 0x00001f5146045b68UL;
   tf->codes[8121] = 0x00001f52dfed83cbUL;
   tf->codes[8122] = 0x00001f6183aef50bUL;
   tf->codes[8123] = 0x00001f6776358b0dUL;
   tf->codes[8124] = 0x00001f898b73e6b6UL;
   tf->codes[8125] = 0x00001f8ece4d6b69UL;
   tf->codes[8126] = 0x00001f948644fba6UL;
   tf->codes[8127] = 0x00001f94c0d4016bUL;
   tf->codes[8128] = 0x00001f9ed168ff47UL;
   tf->codes[8129] = 0x00001fab66233c9aUL;
   tf->codes[8130] = 0x00001fb5019a2eecUL;
   tf->codes[8131] = 0x00001fbb2eafcab3UL;
   tf->codes[8132] = 0x00001fbe62821b79UL;
   tf->codes[8133] = 0x00001fc45508b17bUL;
   tf->codes[8134] = 0x00001fcd40d2927eUL;
   tf->codes[8135] = 0x00001fd333592880UL;
   tf->codes[8136] = 0x00001fd5b77e67f7UL;
   tf->codes[8137] = 0x00001fd9d58ccfd1UL;
   tf->codes[8138] = 0x00001fdf18665484UL;
   tf->codes[8139] = 0x00001fe83ebf3b4cUL;
   tf->codes[8140] = 0x00001ff3aeae5bc6UL;
   tf->codes[8141] = 0x000020033cabe41aUL;
   tf->codes[8142] = 0x00002007202b462fUL;
   tf->codes[8143] = 0x0000200f5c4815e3UL;
   tf->codes[8144] = 0x000020154eceabe5UL;
   tf->codes[8145] = 0x00002018f7bf0835UL;
   tf->codes[8146] = 0x0000202467ae28afUL;
   tf->codes[8147] = 0x00002029e516b327UL;
   tf->codes[8148] = 0x00002037297e01c9UL;
   tf->codes[8149] = 0x00002037640d078eUL;
   tf->codes[8150] = 0x00002039ada34140UL;
   tf->codes[8151] = 0x0000203a22c14ccaUL;
   tf->codes[8152] = 0x0000203d56939d90UL;
   tf->codes[8153] = 0x00002047dc46a6f6UL;
   tf->codes[8154] = 0x000020529c88b621UL;
   tf->codes[8155] = 0x00002059794b6337UL;
   tf->codes[8156] = 0x00002061b56832ebUL;
   tf->codes[8157] = 0x0000206b8b6e2b02UL;
   tf->codes[8158] = 0x0000206fa97c92dcUL;
   tf->codes[8159] = 0x000020847a539fe3UL;
   tf->codes[8160] = 0x00002089bd2d2496UL;
   tf->codes[8161] = 0x00002091499ce2fbUL;
   tf->codes[8162] = 0x0000209358a416e8UL;
   tf->codes[8163] = 0x0000209567ab4ad5UL;
   tf->codes[8164] = 0x0000209701947338UL;
   tf->codes[8165] = 0x000020989b7d9b9bUL;
   tf->codes[8166] = 0x0000209ae513d54dUL;
   tf->codes[8167] = 0x000020a35bbfaac6UL;
   tf->codes[8168] = 0x000020a61a73f002UL;
   tf->codes[8169] = 0x000020a65502f5c7UL;
   tf->codes[8170] = 0x000020aae82f692bUL;
   tf->codes[8171] = 0x000020b8a1b4c357UL;
   tf->codes[8172] = 0x000020b95161d4a6UL;
   tf->codes[8173] = 0x000020c068b38781UL;
   tf->codes[8174] = 0x000020c7f52345e6UL;
   tf->codes[8175] = 0x000020d1cb293dfdUL;
   tf->codes[8176] = 0x000020d8e27af0d8UL;
   tf->codes[8177] = 0x000020de5fe37b50UL;
   tf->codes[8178] = 0x000020df84ae9829UL;
   tf->codes[8179] = 0x000020e24362dd65UL;
   tf->codes[8180] = 0x000020edb351fddfUL;
   tf->codes[8181] = 0x000020f0ac9548e0UL;
   tf->codes[8182] = 0x000020f8e8b21894UL;
   tf->codes[8183] = 0x000020f923411e59UL;
   tf->codes[8184] = 0x000020ffc574c5aaUL;
   tf->codes[8185] = 0x0000210333d61c35UL;
   tf->codes[8186] = 0x000021036e6521faUL;
   tf->codes[8187] = 0x00002105084e4a5dUL;
   tf->codes[8188] = 0x0000210a1098c94bUL;
   tf->codes[8189] = 0x0000210d446b1a11UL;
   tf->codes[8190] = 0x00002114964bd2b1UL;
   tf->codes[8191] = 0x0000212b762a13a5UL;
   tf->codes[8192] = 0x0000212cd5843643UL;
   tf->codes[8193] = 0x00002132185dbaf6UL;
   tf->codes[8194] = 0x00002132c80acc45UL;
   tf->codes[8195] = 0x00002133b246e359UL;
   tf->codes[8196] = 0x00002138ba916247UL;
   tf->codes[8197] = 0x00002146aea5c238UL;
   tf->codes[8198] = 0x0000214bf17f46ebUL;
   tf->codes[8199] = 0x0000215fd81a3cdeUL;
   tf->codes[8200] = 0x000021604d384868UL;
   tf->codes[8201] = 0x0000216221b07690UL;
   tf->codes[8202] = 0x0000217384262d0cUL;
   tf->codes[8203] = 0x00002173f9443896UL;
   tf->codes[8204] = 0x0000217b1095eb71UL;
   tf->codes[8205] = 0x0000217b4b24f136UL;
   tf->codes[8206] = 0x0000217c3561084aUL;
   tf->codes[8207] = 0x0000217f2ea4534bUL;
   tf->codes[8208] = 0x00002185212ae94dUL;
   tf->codes[8209] = 0x000021888f8c3fd8UL;
   tf->codes[8210] = 0x00002192a0213db4UL;
   tf->codes[8211] = 0x000021a0cec4a36aUL;
   tf->codes[8212] = 0x000021a8d0526d59UL;
   tf->codes[8213] = 0x000021bb1d043ae9UL;
   tf->codes[8214] = 0x000021bbccb14c38UL;
   tf->codes[8215] = 0x000021c31e9204d8UL;
   tf->codes[8216] = 0x000021c65264559eUL;
   tf->codes[8217] = 0x000021cb953dda51UL;
   tf->codes[8218] = 0x000021d2ac8f8d2cUL;
   tf->codes[8219] = 0x000021d530b4cca3UL;
   tf->codes[8220] = 0x000021d89f16232eUL;
   tf->codes[8221] = 0x000021e77d669a33UL;
   tf->codes[8222] = 0x000021e8a231b70cUL;
   tf->codes[8223] = 0x0000220191172bedUL;
   tf->codes[8224] = 0x00002208334ad33eUL;
   tf->codes[8225] = 0x000022086dd9d903UL;
   tf->codes[8226] = 0x00002216275f332fUL;
   tf->codes[8227] = 0x0000221c5474cef6UL;
   tf->codes[8228] = 0x0000222a831834acUL;
   tf->codes[8229] = 0x00002232bf350460UL;
   tf->codes[8230] = 0x000022341e8f26feUL;
   tf->codes[8231] = 0x00002245bb93e33fUL;
   tf->codes[8232] = 0x0000224630b1eec9UL;
   tf->codes[8233] = 0x0000224afe6d67f2UL;
   tf->codes[8234] = 0x0000225499e45a44UL;
   tf->codes[8235] = 0x00002261a3bca321UL;
   tf->codes[8236] = 0x00002266e69627d4UL;
   tf->codes[8237] = 0x000022675bb4335eUL;
   tf->codes[8238] = 0x0000226c296fac87UL;
   tf->codes[8239] = 0x0000226c9e8db811UL;
   tf->codes[8240] = 0x00002273f06e70b1UL;
   tf->codes[8241] = 0x00002276af22b5edUL;
   tf->codes[8242] = 0x00002276e9b1bbb2UL;
   tf->codes[8243] = 0x0000227a92a21802UL;
   tf->codes[8244] = 0x000022979f95f4bdUL;
   tf->codes[8245] = 0x00002299e92c2e6fUL;
   tf->codes[8246] = 0x0000229bf833625cUL;
   tf->codes[8247] = 0x000022a3bf322686UL;
   tf->codes[8248] = 0x000022a97729b6c3UL;
   tf->codes[8249] = 0x000022abfb4ef63aUL;
   tf->codes[8250] = 0x000022b228649201UL;
   tf->codes[8251] = 0x000022b3c24dba64UL;
   tf->codes[8252] = 0x000022b97a454aa1UL;
   tf->codes[8253] = 0x000022c17bd31490UL;
   tf->codes[8254] = 0x000022d68739275cUL;
   tf->codes[8255] = 0x000022d9f59a7de7UL;
   tf->codes[8256] = 0x000022db1a659ac0UL;
   tf->codes[8257] = 0x000022e64fc5b575UL;
   tf->codes[8258] = 0x000022e7af1fd813UL;
   tf->codes[8259] = 0x000022ea3345178aUL;
   tf->codes[8260] = 0x000022f18525d02aUL;
   tf->codes[8261] = 0x0000230188416408UL;
   tf->codes[8262] = 0x000023061b6dd76cUL;
   tf->codes[8263] = 0x000023074038f445UL;
   tf->codes[8264] = 0x0000231325462049UL;
   tf->codes[8265] = 0x000023140f82375dUL;
   tf->codes[8266] = 0x00002315344d5436UL;
   tf->codes[8267] = 0x000023218e788bc4UL;
   tf->codes[8268] = 0x00002324c24adc8aUL;
   tf->codes[8269] = 0x000023286b3b38daUL;
   tf->codes[8270] = 0x000023411f91a7f6UL;
   tf->codes[8271] = 0x0000234c1a62bce6UL;
   tf->codes[8272] = 0x000023595eca0b88UL;
   tf->codes[8273] = 0x0000235a83952861UL;
   tf->codes[8274] = 0x00002365f38448dbUL;
   tf->codes[8275] = 0x00002369275699a1UL;
   tf->codes[8276] = 0x0000236d0ad5fbb6UL;
   tf->codes[8277] = 0x0000236ea4bf2419UL;
   tf->codes[8278] = 0x0000237c23b57880UL;
   tf->codes[8279] = 0x0000238a17c9d871UL;
   tf->codes[8280] = 0x00002391a43996d6UL;
   tf->codes[8281] = 0x0000239b7a3f8eedUL;
   tf->codes[8282] = 0x000023a21c73363eUL;
   tf->codes[8283] = 0x000023a2919141c8UL;
   tf->codes[8284] = 0x000023a88417d7caUL;
   tf->codes[8285] = 0x000023aacdae117cUL;
   tf->codes[8286] = 0x000023ab083d1741UL;
   tf->codes[8287] = 0x000023ac2d08341aUL;
   tf->codes[8288] = 0x000023c9af1a1c5fUL;
   tf->codes[8289] = 0x000023cbbe21504cUL;
   tf->codes[8290] = 0x000023d225c5f1d8UL;
   tf->codes[8291] = 0x000023d2d5730327UL;
   tf->codes[8292] = 0x000023d5ceb64e28UL;
   tf->codes[8293] = 0x000023d7a32e7c50UL;
   tf->codes[8294] = 0x000023e6817ef355UL;
   tf->codes[8295] = 0x000023e7a64a102eUL;
   tf->codes[8296] = 0x000023ec39768392UL;
   tf->codes[8297] = 0x000023f0cca2f6f6UL;
   tf->codes[8298] = 0x000023f734479882UL;
   tf->codes[8299] = 0x000023f893a1bb20UL;
   tf->codes[8300] = 0x0000240b5571943aUL;
   tf->codes[8301] = 0x0000240fe89e079eUL;
   tf->codes[8302] = 0x000024152b778c51UL;
   tf->codes[8303] = 0x00002416c560b4b4UL;
   tf->codes[8304] = 0x000024209b66accbUL;
   tf->codes[8305] = 0x0000242f79b723d0UL;
   tf->codes[8306] = 0x000024302964351fUL;
   tf->codes[8307] = 0x00002435a6ccbf97UL;
   tf->codes[8308] = 0x00002440dc2cda4cUL;
   tf->codes[8309] = 0x00002448ddbaa43bUL;
   tf->codes[8310] = 0x00002457f69a2105UL;
   tf->codes[8311] = 0x0000245b64fb7790UL;
   tf->codes[8312] = 0x0000246241be24a6UL;
   tf->codes[8313] = 0x000024627c4d2a6bUL;
   tf->codes[8314] = 0x000024632bfa3bbaUL;
   tf->codes[8315] = 0x0000247e6475ea4dUL;
   tf->codes[8316] = 0x0000247f89410726UL;
   tf->codes[8317] = 0x0000248715b0c58bUL;
   tf->codes[8318] = 0x00002487c55dd6daUL;
   tf->codes[8319] = 0x00002488750ae829UL;
   tf->codes[8320] = 0x0000248b6e4e332aUL;
   tf->codes[8321] = 0x00002494cf361fb7UL;
   tf->codes[8322] = 0x00002495b97236cbUL;
   tf->codes[8323] = 0x0000249a872daff4UL;
   tf->codes[8324] = 0x000024a03f254031UL;
   tf->codes[8325] = 0x000024a631abd633UL;
   tf->codes[8326] = 0x000024b4604f3be9UL;
   tf->codes[8327] = 0x000024b9a328c09cUL;
   tf->codes[8328] = 0x000024c9e0d35a3fUL;
   tf->codes[8329] = 0x000024d96ed0e293UL;
   tf->codes[8330] = 0x000024db434910bbUL;
   tf->codes[8331] = 0x000024e4a430fd48UL;
   tf->codes[8332] = 0x000024e84d215998UL;
   tf->codes[8333] = 0x000024fbf92d49c6UL;
   tf->codes[8334] = 0x000025051f86308eUL;
   tf->codes[8335] = 0x0000250594a43c18UL;
   tf->codes[8336] = 0x0000250d5ba30042UL;
   tf->codes[8337] = 0x00002524b09f4cc0UL;
   tf->codes[8338] = 0x0000252a6896dcfdUL;
   tf->codes[8339] = 0x000025322f95a127UL;
   tf->codes[8340] = 0x000025390c584e3dUL;
   tf->codes[8341] = 0x0000253b1b5f822aUL;
   tf->codes[8342] = 0x0000253c059b993eUL;
   tf->codes[8343] = 0x00002545668385cbUL;
   tf->codes[8344] = 0x00002547eaa8c542UL;
   tf->codes[8345] = 0x0000254aa95d0a7eUL;
   tf->codes[8346] = 0x000025511101ac0aUL;
   tf->codes[8347] = 0x000025589d716a6fUL;
   tf->codes[8348] = 0x0000255987ad8183UL;
   tf->codes[8349] = 0x0000257918c69db5UL;
   tf->codes[8350] = 0x000025886c352044UL;
   tf->codes[8351] = 0x0000258b65786b45UL;
   tf->codes[8352] = 0x00002598a9dfb9e7UL;
   tf->codes[8353] = 0x0000259b6893ff23UL;
   tf->codes[8354] = 0x000025a663651413UL;
   tf->codes[8355] = 0x000025b507268553UL;
   tf->codes[8356] = 0x000025b7162db940UL;
   tf->codes[8357] = 0x000025b78b4bc4caUL;
   tf->codes[8358] = 0x000025bf524a88f4UL;
   tf->codes[8359] = 0x000025c8edc17b46UL;
   tf->codes[8360] = 0x000025cac239a96eUL;
   tf->codes[8361] = 0x000025cf55661cd2UL;
   tf->codes[8362] = 0x000025d24ea967d3UL;
   tf->codes[8363] = 0x000025d3ae038a71UL;
   tf->codes[8364] = 0x000025db3a7348d6UL;
   tf->codes[8365] = 0x000025e16788e49dUL;
   tf->codes[8366] = 0x000025f2c9fe9b19UL;
   tf->codes[8367] = 0x000025f6e80d02f3UL;
   tf->codes[8368] = 0x000025fd4fb1a47fUL;
   tf->codes[8369] = 0x000025fdff5eb5ceUL;
   tf->codes[8370] = 0x000026046703575aUL;
   tf->codes[8371] = 0x00002608fa2fcabeUL;
   tf->codes[8372] = 0x0000260b0936feabUL;
   tf->codes[8373] = 0x0000260f27456685UL;
   tf->codes[8374] = 0x000026142f8fe573UL;
   tf->codes[8375] = 0x0000261f9f7f05edUL;
   tf->codes[8376] = 0x00002626b6d0b8c8UL;
   tf->codes[8377] = 0x00002636f47b526bUL;
   tf->codes[8378] = 0x00002655263a4bffUL;
   tf->codes[8379] = 0x0000265a2e84caedUL;
   tf->codes[8380] = 0x0000266688b0027bUL;
   tf->codes[8381] = 0x000026710e630be1UL;
   tf->codes[8382] = 0x000026747cc4626cUL;
   tf->codes[8383] = 0x000026844550f085UL;
   tf->codes[8384] = 0x0000268da638dd12UL;
   tf->codes[8385] = 0x000026909f7c2813UL;
   tf->codes[8386] = 0x00002694bd8a8fedUL;
   tf->codes[8387] = 0x0000269741afcf64UL;
   tf->codes[8388] = 0x000026a3614c012dUL;
   tf->codes[8389] = 0x000026b06b244a0aUL;
   tf->codes[8390] = 0x000026bc15a27049UL;
   tf->codes[8391] = 0x000026c1930afac1UL;
   tf->codes[8392] = 0x000026c8e4ebb361UL;
   tf->codes[8393] = 0x000026d7fdcb302bUL;
   tf->codes[8394] = 0x000026dabc7f7567UL;
   tf->codes[8395] = 0x000026df4fabe8cbUL;
   tf->codes[8396] = 0x000026e19942227dUL;
   tf->codes[8397] = 0x000026e2be0d3f56UL;
   tf->codes[8398] = 0x000026eb34b914cfUL;
   tf->codes[8399] = 0x000026f161ceb096UL;
   tf->codes[8400] = 0x000026f4d0300721UL;
   tf->codes[8401] = 0x000026fd0c4cd6d5UL;
   tf->codes[8402] = 0x00002706a7c3c927UL;
   tf->codes[8403] = 0x0000271510f634a2UL;
   tf->codes[8404] = 0x000027280d551381UL;
   tf->codes[8405] = 0x0000272acc0958bdUL;
   tf->codes[8406] = 0x0000272f99c4d1e6UL;
   tf->codes[8407] = 0x000027381070a75fUL;
   tf->codes[8408] = 0x0000273c690e14feUL;
   tf->codes[8409] = 0x000027525eb03edeUL;
   tf->codes[8410] = 0x00002755cd119569UL;
   tf->codes[8411] = 0x00002758c654e06aUL;
   tf->codes[8412] = 0x000027631178e40bUL;
   tf->codes[8413] = 0x00002764e5f11233UL;
   tf->codes[8414] = 0x00002771efc95b10UL;
   tf->codes[8415] = 0x00002776f813d9feUL;
   tf->codes[8416] = 0x000027a024a3e882UL;
   tf->codes[8417] = 0x000027a7eba2acacUL;
   tf->codes[8418] = 0x000027acf3ed2b9aUL;
   tf->codes[8419] = 0x000027b3d0afd8b0UL;
   tf->codes[8420] = 0x000027b4805ce9ffUL;
   tf->codes[8421] = 0x000027bb97ae9cdaUL;
   tf->codes[8422] = 0x000027c9c6520290UL;
   tf->codes[8423] = 0x000027dbd874ca5bUL;
   tf->codes[8424] = 0x000028015c147c8fUL;
   tf->codes[8425] = 0x00002806645efb7dUL;
   tf->codes[8426] = 0x0000280ba7388030UL;
   tf->codes[8427] = 0x00002812496c2781UL;
   tf->codes[8428] = 0x0000281458735b6eUL;
   tf->codes[8429] = 0x0000282002f181adUL;
   tf->codes[8430] = 0x000028203d808772UL;
   tf->codes[8431] = 0x00002820ed2d98c1UL;
   tf->codes[8432] = 0x00002823e670e3c2UL;
   tf->codes[8433] = 0x00002830409c1b50UL;
   tf->codes[8434] = 0x000028345eaa832aUL;
   tf->codes[8435] = 0x00002845869133e1UL;
   tf->codes[8436] = 0x00002846e5eb567fUL;
   tf->codes[8437] = 0x00002863433221ebUL;
   tf->codes[8438] = 0x0000286726b18400UL;
   tf->codes[8439] = 0x000028679bcf8f8aUL;
   tf->codes[8440] = 0x0000286a5a83d4c6UL;
   tf->codes[8441] = 0x0000287938d44bcbUL;
   tf->codes[8442] = 0x0000287fa078ed57UL;
   tf->codes[8443] = 0x0000288299bc3858UL;
   tf->codes[8444] = 0x0000288f2e7675abUL;
   tf->codes[8445] = 0x00002895d0aa1cfcUL;
   tf->codes[8446] = 0x000028a7e2cce4c7UL;
   tf->codes[8447] = 0x000028ab512e3b52UL;
   tf->codes[8448] = 0x000028c1815f6af7UL;
   tf->codes[8449] = 0x000028d8613dabebUL;
   tf->codes[8450] = 0x000028f56e3188a6UL;
   tf->codes[8451] = 0x000028fb262918e3UL;
   tf->codes[8452] = 0x000029091a3d78d4UL;
   tf->codes[8453] = 0x00002915e986bbecUL;
   tf->codes[8454] = 0x000029169933cd3bUL;
   tf->codes[8455] = 0x00002916d3c2d300UL;
   tf->codes[8456] = 0x0000291ab7423515UL;
   tf->codes[8457] = 0x0000291d3b67748cUL;
   tf->codes[8458] = 0x000029320c3e8193UL;
   tf->codes[8459] = 0x000029433425324aUL;
   tf->codes[8460] = 0x00002948b18dbcc2UL;
   tf->codes[8461] = 0x00002959645661efUL;
   tf->codes[8462] = 0x00002961db023768UL;
   tf->codes[8463] = 0x00002962ffcd5441UL;
   tf->codes[8464] = 0x000029645f2776dfUL;
   tf->codes[8465] = 0x000029780b33670dUL;
   tf->codes[8466] = 0x00002978f56f7e21UL;
   tf->codes[8467] = 0x0000297d4e0cebc0UL;
   tf->codes[8468] = 0x00002980475036c1UL;
   tf->codes[8469] = 0x00002995182743c8UL;
   tf->codes[8470] = 0x00002997272e77b5UL;
   tf->codes[8471] = 0x0000299b7fcbe554UL;
   tf->codes[8472] = 0x000029a2971d982fUL;
   tf->codes[8473] = 0x000029a72a4a0b93UL;
   tf->codes[8474] = 0x000029b1756e0f34UL;
   tf->codes[8475] = 0x000029b6f2d699acUL;
   tf->codes[8476] = 0x000029b817a1b685UL;
   tf->codes[8477] = 0x000029c38790d6ffUL;
   tf->codes[8478] = 0x000029d5d442a48fUL;
   tf->codes[8479] = 0x000029d683efb5deUL;
   tf->codes[8480] = 0x000029d9f2510c69UL;
   tf->codes[8481] = 0x000029e35338f8f6UL;
   tf->codes[8482] = 0x000029ecb420e583UL;
   tf->codes[8483] = 0x000029ffeb0eca27UL;
   tf->codes[8484] = 0x00002a068d427178UL;
   tf->codes[8485] = 0x00002a0702607d02UL;
   tf->codes[8486] = 0x00002a1e1ccdc3bbUL;
   tf->codes[8487] = 0x00002a274326aa83UL;
   tf->codes[8488] = 0x00002a277db5b048UL;
   tf->codes[8489] = 0x00002a34fcac04afUL;
   tf->codes[8490] = 0x00002a3cc3aac8d9UL;
   tf->codes[8491] = 0x00002a3f825f0e15UL;
   tf->codes[8492] = 0x00002a641bc2a935UL;
   tf->codes[8493] = 0x00002a65f03ad75dUL;
   tf->codes[8494] = 0x00002a68e97e225eUL;
   tf->codes[8495] = 0x00002a69992b33adUL;
   tf->codes[8496] = 0x00002a76687476c5UL;
   tf->codes[8497] = 0x00002a7afba0ea29UL;
   tf->codes[8498] = 0x00002a7dba552f65UL;
   tf->codes[8499] = 0x00002a87905b277cUL;
   tf->codes[8500] = 0x00002a94d4c2761eUL;
   tf->codes[8501] = 0x00002aa1697cb371UL;
   tf->codes[8502] = 0x00002aa42830f8adUL;
   tf->codes[8503] = 0x00002aa7217443aeUL;
   tf->codes[8504] = 0x00002aa9307b779bUL;
   tf->codes[8505] = 0x00002ab37b9f7b3cUL;
   tf->codes[8506] = 0x00002abbb7bc4af0UL;
   tf->codes[8507] = 0x00002acad09bc7baUL;
   tf->codes[8508] = 0x00002ad84f921c21UL;
   tf->codes[8509] = 0x00002ae0c63df19aUL;
   tf->codes[8510] = 0x00002ae9ec96d862UL;
   tf->codes[8511] = 0x00002af34d7ec4efUL;
   tf->codes[8512] = 0x00002b13c8d3f835UL;
   tf->codes[8513] = 0x00002b17ac535a4aUL;
   tf->codes[8514] = 0x00002b210d3b46d7UL;
   tf->codes[8515] = 0x00002b261585c5c5UL;
   tf->codes[8516] = 0x00002b33947c1a2cUL;
   tf->codes[8517] = 0x00002b3444292b7bUL;
   tf->codes[8518] = 0x00002b3568f44854UL;
   tf->codes[8519] = 0x00002b37ed1987cbUL;
   tf->codes[8520] = 0x00002b4915003882UL;
   tf->codes[8521] = 0x00002b55a9ba75d5UL;
   tf->codes[8522] = 0x00002b83de950347UL;
   tf->codes[8523] = 0x00002b8662ba42beUL;
   tf->codes[8524] = 0x00002b8b3075bbe7UL;
   tf->codes[8525] = 0x00002b915d8b57aeUL;
   tf->codes[8526] = 0x00002bab36ace3a3UL;
   tf->codes[8527] = 0x00002bc6a9b797fbUL;
   tf->codes[8528] = 0x00002bdbefacb08cUL;
   tf->codes[8529] = 0x00002be7250ccb41UL;
   tf->codes[8530] = 0x00002bff9ed43498UL;
   tf->codes[8531] = 0x00002bffd9633a5dUL;
   tf->codes[8532] = 0x00002c0347c490e8UL;
   tf->codes[8533] = 0x00002c0bbe706661UL;
   tf->codes[8534] = 0x00002c201a2967deUL;
   tf->codes[8535] = 0x00002c39090edcbfUL;
   tf->codes[8536] = 0x00002c3bc7c321fbUL;
   tf->codes[8537] = 0x00002c3c025227c0UL;
   tf->codes[8538] = 0x00002c3d61ac4a5eUL;
   tf->codes[8539] = 0x00002c3dd6ca55e8UL;
   tf->codes[8540] = 0x00002c5f3c5ba042UL;
   tf->codes[8541] = 0x00002c635a6a081cUL;
   tf->codes[8542] = 0x00002c73d2a3a784UL;
   tf->codes[8543] = 0x00002c7bd4317173UL;
   tf->codes[8544] = 0x00002c82eb83244eUL;
   tf->codes[8545] = 0x00002c906a7978b5UL;
   tf->codes[8546] = 0x00002c9ff8770109UL;
   tf->codes[8547] = 0x00002cad024f49e6UL;
   tf->codes[8548] = 0x00002cb27fb7d45eUL;
   tf->codes[8549] = 0x00002cb454300286UL;
   tf->codes[8550] = 0x00002cb69dc63c38UL;
   tf->codes[8551] = 0x00002cb8723e6a60UL;
   tf->codes[8552] = 0x00002cb997098739UL;
   tf->codes[8553] = 0x00002cba46b69888UL;
   tf->codes[8554] = 0x00002cc715ffdba0UL;
   tf->codes[8555] = 0x00002cd962b1a930UL;
   tf->codes[8556] = 0x00002cf4609e51feUL;
   tf->codes[8557] = 0x00002cf5bff8749cUL;
   tf->codes[8558] = 0x00002cf71f52973aUL;
   tf->codes[8559] = 0x00002d080caa422cUL;
   tf->codes[8560] = 0x00002d08473947f1UL;
   tf->codes[8561] = 0x00002d1884e3e194UL;
   tf->codes[8562] = 0x00002d1dc7bd6647UL;
   tf->codes[8563] = 0x00002d1eb1f97d5bUL;
   tf->codes[8564] = 0x00002d1f9c35946fUL;
   tf->codes[8565] = 0x00002d30feab4aebUL;
   tf->codes[8566] = 0x00002d367c13d563UL;
   tf->codes[8567] = 0x00002d388b1b0950UL;
   tf->codes[8568] = 0x00002d4644a0637cUL;
   tf->codes[8569] = 0x00002d5856c32b47UL;
   tf->codes[8570] = 0x00002d61428d0c4aUL;
   tf->codes[8571] = 0x00002d73c9cddf9fUL;
   tf->codes[8572] = 0x00002d75d8d5138cUL;
   tf->codes[8573] = 0x00002d78978958c8UL;
   tf->codes[8574] = 0x00002d7bcb5ba98eUL;
   tf->codes[8575] = 0x00002d7c7b08baddUL;
   tf->codes[8576] = 0x00002d947fb218aaUL;
   tf->codes[8577] = 0x00002da3237389eaUL;
   tf->codes[8578] = 0x00002db7449d85a2UL;
   tf->codes[8579] = 0x00002dbb281ce7b7UL;
   tf->codes[8580] = 0x00002dbcfc9515dfUL;
   tf->codes[8581] = 0x00002dc7bcd7250aUL;
   tf->codes[8582] = 0x00002dd91f4cdb86UL;
   tf->codes[8583] = 0x00002defc49c16b5UL;
   tf->codes[8584] = 0x00002df0e967338eUL;
   tf->codes[8585] = 0x00002df62c40b841UL;
   tf->codes[8586] = 0x00002df6a15ec3cbUL;
   tf->codes[8587] = 0x00002df83b47ec2eUL;
   tf->codes[8588] = 0x00002df9d5311491UL;
   tf->codes[8589] = 0x00002e062f5c4c1fUL;
   tf->codes[8590] = 0x00002e1373c39ac1UL;
   tf->codes[8591] = 0x00002e14988eb79aUL;
   tf->codes[8592] = 0x00002e175742fcd6UL;
   tf->codes[8593] = 0x00002e44dc7078f9UL;
   tf->codes[8594] = 0x00002e481042c9bfUL;
   tf->codes[8595] = 0x00002e488560d549UL;
   tf->codes[8596] = 0x00002e4b098614c0UL;
   tf->codes[8597] = 0x00002e6139b74465UL;
   tf->codes[8598] = 0x00002e6975d41419UL;
   tf->codes[8599] = 0x00002e89b69a419aUL;
   tf->codes[8600] = 0x00002e943c4d4b00UL;
   tf->codes[8601] = 0x00002e9a2ed3e102UL;
   tf->codes[8602] = 0x00002e9ced88263eUL;
   tf->codes[8603] = 0x00002e9d9d35378dUL;
   tf->codes[8604] = 0x00002ea4b486ea68UL;
   tf->codes[8605] = 0x00002ea56433fbb7UL;
   tf->codes[8606] = 0x00002eb47d137881UL;
   tf->codes[8607] = 0x00002eb5dc6d9b1fUL;
   tf->codes[8608] = 0x00002ec8291f68afUL;
   tf->codes[8609] = 0x00002ed448bb9a78UL;
   tf->codes[8610] = 0x00002ed7f1abf6c8UL;
   tf->codes[8611] = 0x00002edbd52b58ddUL;
   tf->codes[8612] = 0x00002ef41463bc6fUL;
   tf->codes[8613] = 0x00002efba0d37ad4UL;
   tf->codes[8614] = 0x00002f0501bb6761UL;
   tf->codes[8615] = 0x00002f08aaabc3b1UL;
   tf->codes[8616] = 0x00002f1a823f85b7UL;
   tf->codes[8617] = 0x00002f275188c8cfUL;
   tf->codes[8618] = 0x00002f3754a45cadUL;
   tf->codes[8619] = 0x00002f378f336272UL;
   tf->codes[8620] = 0x00002f4b3b3f52a0UL;
   tf->codes[8621] = 0x00002f5a198fc9a5UL;
   tf->codes[8622] = 0x00002f70f96e0a99UL;
   tf->codes[8623] = 0x00002f71e3aa21adUL;
   tf->codes[8624] = 0x00002f7b7f2113ffUL;
   tf->codes[8625] = 0x00002f84a579fac7UL;
   tf->codes[8626] = 0x00002f8a5d718b04UL;
   tf->codes[8627] = 0x00002f8bf75ab367UL;
   tf->codes[8628] = 0x00002f8ef09dfe68UL;
   tf->codes[8629] = 0x00002f94a8958ea5UL;
   tf->codes[8630] = 0x00002f976749d3e1UL;
   tf->codes[8631] = 0x00002f9d1f41641eUL;
   tf->codes[8632] = 0x00002fa60b0b4521UL;
   tf->codes[8633] = 0x00002fa88f308498UL;
   tf->codes[8634] = 0x00002fa8c9bf8a5dUL;
   tf->codes[8635] = 0x00002faa63a8b2c0UL;
   tf->codes[8636] = 0x00002fb76d80fb9dUL;
   tf->codes[8637] = 0x00002fb9b717354fUL;
   tf->codes[8638] = 0x00002fc2dd701c17UL;
   tf->codes[8639] = 0x00002fc47759447aUL;
   tf->codes[8640] = 0x00002fcd6323257dUL;
   tf->codes[8641] = 0x00002fcefd0c4de0UL;
   tf->codes[8642] = 0x00002fd26b6da46bUL;
   tf->codes[8643] = 0x00002fd6fe9a17cfUL;
   tf->codes[8644] = 0x00002fd9bd4e5d0bUL;
   tf->codes[8645] = 0x00002fe6c726a5e8UL;
   tf->codes[8646] = 0x00002ff6ca4239c6UL;
   tf->codes[8647] = 0x00002ff7b47e50daUL;
   tf->codes[8648] = 0x00002ff8d9496db3UL;
   tf->codes[8649] = 0x0000300707ecd369UL;
   tf->codes[8650] = 0x0000300951830d1bUL;
   tf->codes[8651] = 0x0000301202bde859UL;
   tf->codes[8652] = 0x0000301b9e34daabUL;
   tf->codes[8653] = 0x0000301cc2fff784UL;
   tf->codes[8654] = 0x00003055f2ab99e6UL;
   tf->codes[8655] = 0x000030583c41d398UL;
   tf->codes[8656] = 0x0000306879ec6d3bUL;
   tf->codes[8657] = 0x000030712b274879UL;
   tf->codes[8658] = 0x0000307b764b4c1aUL;
   tf->codes[8659] = 0x0000307d4ac37a42UL;
   tf->codes[8660] = 0x0000307e6f8e971bUL;
   tf->codes[8661] = 0x000030854c514431UL;
   tf->codes[8662] = 0x00003092cb479898UL;
   tf->codes[8663] = 0x000030a00faee73aUL;
   tf->codes[8664] = 0x000030abba2d0d79UL;
   tf->codes[8665] = 0x000030ae3e524cf0UL;
   tf->codes[8666] = 0x000030b3bbbad768UL;
   tf->codes[8667] = 0x000030cf69549185UL;
   tf->codes[8668] = 0x000030e1f09564daUL;
   tf->codes[8669] = 0x000030f771198330UL;
   tf->codes[8670] = 0x000031059fbce8e6UL;
   tf->codes[8671] = 0x00003109833c4afbUL;
   tf->codes[8672] = 0x00003115684976ffUL;
   tf->codes[8673] = 0x000031439d240471UL;
   tf->codes[8674] = 0x00003148dffd8924UL;
   tf->codes[8675] = 0x0000315bdc5c6803UL;
   tf->codes[8676] = 0x0000317e2c29c971UL;
   tf->codes[8677] = 0x0000318a865500ffUL;
   tf->codes[8678] = 0x0000319be8cab77bUL;
   tf->codes[8679] = 0x000031a2506f5907UL;
   tf->codes[8680] = 0x000031b009f4b333UL;
   tf->codes[8681] = 0x000031b6e6b76049UL;
   tf->codes[8682] = 0x000031b7d0f3775dUL;
   tf->codes[8683] = 0x000031d5187659ddUL;
   tf->codes[8684] = 0x000031e3bc37cb1dUL;
   tf->codes[8685] = 0x000031efdbd3fce6UL;
   tf->codes[8686] = 0x000031f8527fd25fUL;
   tf->codes[8687] = 0x00003205d17626c6UL;
   tf->codes[8688] = 0x0000322821438834UL;
   tf->codes[8689] = 0x00003229f5bbb65cUL;
   tf->codes[8690] = 0x000032339132a8aeUL;
   tf->codes[8691] = 0x00003237af411088UL;
   tf->codes[8692] = 0x00003239be484475UL;
   tf->codes[8693] = 0x0000323d2ca99b00UL;
   tf->codes[8694] = 0x00003255a6710457UL;
   tf->codes[8695] = 0x00003261c60d3620UL;
   tf->codes[8696] = 0x0000326a3cb90b99UL;
   tf->codes[8697] = 0x00003279cab693edUL;
   tf->codes[8698] = 0x000032a2bcb79cacUL;
   tf->codes[8699] = 0x000032aa49275b11UL;
   tf->codes[8700] = 0x000032aaf8d46c60UL;
   tf->codes[8701] = 0x000032ac582e8efeUL;
   tf->codes[8702] = 0x000032af5171d9ffUL;
   tf->codes[8703] = 0x000032b57e8775c6UL;
   tf->codes[8704] = 0x000032ba4c42eeefUL;
   tf->codes[8705] = 0x000032c5f6c1152eUL;
   tf->codes[8706] = 0x000032cf57a901bbUL;
   tf->codes[8707] = 0x000032d75936cbaaUL;
   tf->codes[8708] = 0x000032f96e752753UL;
   tf->codes[8709] = 0x000032fb7d7c5b40UL;
   tf->codes[8710] = 0x000032ffd619c8dfUL;
   tf->codes[8711] = 0x00003300c055dff3UL;
   tf->codes[8712] = 0x000033088754a41dUL;
   tf->codes[8713] = 0x0000330c6ad40632UL;
   tf->codes[8714] = 0x0000331b83b382fcUL;
   tf->codes[8715] = 0x00003321b0c91ec3UL;
   tf->codes[8716] = 0x000033246f7d63ffUL;
   tf->codes[8717] = 0x0000332d5b474502UL;
   tf->codes[8718] = 0x000033381b89542dUL;
   tf->codes[8719] = 0x00003346bf4ac56dUL;
   tf->codes[8720] = 0x0000335ae074c125UL;
   tf->codes[8721] = 0x0000336391af9c63UL;
   tf->codes[8722] = 0x0000336615d4dbdaUL;
   tf->codes[8723] = 0x0000336c7d797d66UL;
   tf->codes[8724] = 0x000033791233bab9UL;
   tf->codes[8725] = 0x0000337feef667cfUL;
   tf->codes[8726] = 0x00003394fa5c7a9bUL;
   tf->codes[8727] = 0x0000339bd71f27b1UL;
   tf->codes[8728] = 0x000033b91ea20a31UL;
   tf->codes[8729] = 0x000033d20d877f12UL;
   tf->codes[8730] = 0x000033d6db42f83bUL;
   tf->codes[8731] = 0x000033dd7d769f8cUL;
   tf->codes[8732] = 0x000033f422c5dabbUL;
   tf->codes[8733] = 0x000033f5f73e08e3UL;
   tf->codes[8734] = 0x000033faff8887d1UL;
   tf->codes[8735] = 0x000033fdbe3ccd0dUL;
   tf->codes[8736] = 0x00003413b3def6edUL;
   tf->codes[8737] = 0x0000341f98ec22f1UL;
   tf->codes[8738] = 0x0000343c30c1f422UL;
   tf->codes[8739] = 0x0000344e7d73c1b2UL;
   tf->codes[8740] = 0x000034508c7af59fUL;
   tf->codes[8741] = 0x0000345176b70cb3UL;
   tf->codes[8742] = 0x000034534b2f3adbUL;
   tf->codes[8743] = 0x00003456447285dcUL;
   tf->codes[8744] = 0x0000345a9d0ff37bUL;
   tf->codes[8745] = 0x0000345d213532f2UL;
   tf->codes[8746] = 0x00003466821d1f7fUL;
   tf->codes[8747] = 0x00003466bcac2544UL;
   tf->codes[8748] = 0x000034689124536cUL;
   tf->codes[8749] = 0x00003477e492d5fbUL;
   tf->codes[8750] = 0x00003484794d134eUL;
   tf->codes[8751] = 0x00003488223d6f9eUL;
   tf->codes[8752] = 0x0000348cb569e302UL;
   tf->codes[8753] = 0x0000349c43676b56UL;
   tf->codes[8754] = 0x000034a1c0cff5ceUL;
   tf->codes[8755] = 0x000034a3202a186cUL;
   tf->codes[8756] = 0x000034ab21b7e25bUL;
   tf->codes[8757] = 0x000034b4f7bdda72UL;
   tf->codes[8758] = 0x000034c1175a0c3bUL;
   tf->codes[8759] = 0x000034daf07b9830UL;
   tf->codes[8760] = 0x000034e50110960cUL;
   tf->codes[8761] = 0x000034f5042c29eaUL;
   tf->codes[8762] = 0x000034f788516961UL;
   tf->codes[8763] = 0x000034f8e7ab8bffUL;
   tf->codes[8764] = 0x000034ff14c127c6UL;
   tf->codes[8765] = 0x00003511d69100e0UL;
   tf->codes[8766] = 0x0000352a50586a37UL;
   tf->codes[8767] = 0x00003535c0478ab1UL;
   tf->codes[8768] = 0x00003542ca1fd38eUL;
   tf->codes[8769] = 0x0000354bf078ba56UL;
   tf->codes[8770] = 0x00003556010db832UL;
   tf->codes[8771] = 0x0000355d185f6b0dUL;
   tf->codes[8772] = 0x0000357174186c8aUL;
   tf->codes[8773] = 0x00003594e8b0ead1UL;
   tf->codes[8774] = 0x000035981c833b97UL;
   tf->codes[8775] = 0x000035a894bcdaffUL;
   tf->codes[8776] = 0x000035abc88f2bc5UL;
   tf->codes[8777] = 0x000035b10b68b078UL;
   tf->codes[8778] = 0x000035b404abfb79UL;
   tf->codes[8779] = 0x000035e4f83ace27UL;
   tf->codes[8780] = 0x000035eb9a6e7578UL;
   tf->codes[8781] = 0x000036070d7929d0UL;
   tf->codes[8782] = 0x0000360a414b7a96UL;
   tf->codes[8783] = 0x000036174b23c373UL;
   tf->codes[8784] = 0x00003626d9214bc7UL;
   tf->codes[8785] = 0x0000363ccec375a7UL;
   tf->codes[8786] = 0x000036445b33340cUL;
   tf->codes[8787] = 0x000036519f9a82aeUL;
   tf->codes[8788] = 0x000036524f4793fdUL;
   tf->codes[8789] = 0x00003660f309053dUL;
   tf->codes[8790] = 0x00003664d6886752UL;
   tf->codes[8791] = 0x00003677d2e74631UL;
   tf->codes[8792] = 0x00003679a75f7459UL;
   tf->codes[8793] = 0x0000367d15c0cae4UL;
   tf->codes[8794] = 0x0000369813ad73b2UL;
   tf->codes[8795] = 0x0000369888cb7f3cUL;
   tf->codes[8796] = 0x000036a6b76ee4f2UL;
   tf->codes[8797] = 0x000036a9eb4135b8UL;
   tf->codes[8798] = 0x000036aa605f4142UL;
   tf->codes[8799] = 0x000036aad57d4cccUL;
   tf->codes[8800] = 0x000036b76a378a1fUL;
   tf->codes[8801] = 0x000036dcb348368eUL;
   tf->codes[8802] = 0x000036ec06b6b91dUL;
   tf->codes[8803] = 0x000036f68c69c283UL;
   tf->codes[8804] = 0x000037073f3267b0UL;
   tf->codes[8805] = 0x0000370cf729f7edUL;
   tf->codes[8806] = 0x000037161d82deb5UL;
   tf->codes[8807] = 0x00003727ba879af6UL;
   tf->codes[8808] = 0x00003728df52b7cfUL;
   tf->codes[8809] = 0x0000372c13250895UL;
   tf->codes[8810] = 0x00003738e26e4badUL;
   tf->codes[8811] = 0x00003740a96d0fd7UL;
   tf->codes[8812] = 0x00003749cfc5f69fUL;
   tf->codes[8813] = 0x0000374af4911378UL;
   tf->codes[8814] = 0x00003757c3da5690UL;
   tf->codes[8815] = 0x000037595dc37ef3UL;
   tf->codes[8816] = 0x0000375c5706c9f4UL;
   tf->codes[8817] = 0x0000376e692991bfUL;
   tf->codes[8818] = 0x00003771626cdcc0UL;
   tf->codes[8819] = 0x000037750b5d3910UL;
   tf->codes[8820] = 0x00003786a861f551UL;
   tf->codes[8821] = 0x0000378b3b8e68b5UL;
   tf->codes[8822] = 0x0000379043d8e7a3UL;
   tf->codes[8823] = 0x000037a37ac6cc47UL;
   tf->codes[8824] = 0x000037abf172a1c0UL;
   tf->codes[8825] = 0x000037b5c77899d7UL;
   tf->codes[8826] = 0x000037b67725ab26UL;
   tf->codes[8827] = 0x000037b8c0bbe4d8UL;
   tf->codes[8828] = 0x000037c79f0c5bddUL;
   tf->codes[8829] = 0x000037c8894872f1UL;
   tf->codes[8830] = 0x000037d433c69930UL;
   tf->codes[8831] = 0x000037d7dcb6f580UL;
   tf->codes[8832] = 0x000037f55ec8ddc5UL;
   tf->codes[8833] = 0x00003807ab7aab55UL;
   tf->codes[8834] = 0x0000381355f8d194UL;
   tf->codes[8835] = 0x0000381b57869b83UL;
   tf->codes[8836] = 0x00003822a9675423UL;
   tf->codes[8837] = 0x00003825dd39a4e9UL;
   tf->codes[8838] = 0x00003833d14e04daUL;
   tf->codes[8839] = 0x00003835e05538c7UL;
   tf->codes[8840] = 0x0000383bd2dbcec9UL;
   tf->codes[8841] = 0x0000384cc03379bbUL;
   tf->codes[8842] = 0x0000386d3b88ad01UL;
   tf->codes[8843] = 0x0000387995b3e48fUL;
   tf->codes[8844] = 0x0000389493a08d5dUL;
   tf->codes[8845] = 0x000038978ce3d85eUL;
   tf->codes[8846] = 0x000038b33a7d927bUL;
   tf->codes[8847] = 0x000038b66e4fe341UL;
   tf->codes[8848] = 0x000038b7588bfa55UL;
   tf->codes[8849] = 0x000038b8f27522b8UL;
   tf->codes[8850] = 0x000038c0b973e6e2UL;
   tf->codes[8851] = 0x000038d340b4ba37UL;
   tf->codes[8852] = 0x000038e761deb5efUL;
   tf->codes[8853] = 0x000038eb455e1804UL;
   tf->codes[8854] = 0x000038ef636c7fdeUL;
   tf->codes[8855] = 0x000038fad35ba058UL;
   tf->codes[8856] = 0x000038fd1cf1da0aUL;
   tf->codes[8857] = 0x0000390b4b953fc0UL;
   tf->codes[8858] = 0x0000390ce57e6823UL;
   tf->codes[8859] = 0x000039108e6ec473UL;
   tf->codes[8860] = 0x00003913fcd01afeUL;
   tf->codes[8861] = 0x00003914ac7d2c4dUL;
   tf->codes[8862] = 0x00003914e70c3212UL;
   tf->codes[8863] = 0x00003920918a5851UL;
   tf->codes[8864] = 0x0000392599d4d73fUL;
   tf->codes[8865] = 0x0000393d29602982UL;
   tf->codes[8866] = 0x000039468a48160fUL;
   tf->codes[8867] = 0x0000394c7cceac11UL;
   tf->codes[8868] = 0x0000395cba7945b4UL;
   tf->codes[8869] = 0x00003979524f16e5UL;
   tf->codes[8870] = 0x0000397aec383f48UL;
   tf->codes[8871] = 0x0000397daaec8484UL;
   tf->codes[8872] = 0x0000398a7a35c79cUL;
   tf->codes[8873] = 0x0000398cfe5b0713UL;
   tf->codes[8874] = 0x0000398f47f140c5UL;
   tf->codes[8875] = 0x000039a32e8c36b8UL;
   tf->codes[8876] = 0x000039a95ba1d27fUL;
   tf->codes[8877] = 0x000039c62e06a975UL;
   tf->codes[8878] = 0x000039d6a64048ddUL;
   tf->codes[8879] = 0x000039d6e0cf4ea2UL;
   tf->codes[8880] = 0x000039e49a54a8ceUL;
   tf->codes[8881] = 0x000039e54a01ba1dUL;
   tf->codes[8882] = 0x000039e84345051eUL;
   tf->codes[8883] = 0x000039f3b3342598UL;
   tf->codes[8884] = 0x000039f462e136e7UL;
   tf->codes[8885] = 0x000039f721957c23UL;
   tf->codes[8886] = 0x00003a0c678a94b4UL;
   tf->codes[8887] = 0x00003a13444d41caUL;
   tf->codes[8888] = 0x00003a14a3a76468UL;
   tf->codes[8889] = 0x00003a1b806a117eUL;
   tf->codes[8890] = 0x00003a284fb35496UL;
   tf->codes[8891] = 0x00003a2c6dc1bc70UL;
   tf->codes[8892] = 0x00003a330ff563c1UL;
   tf->codes[8893] = 0x00003a47311f5f79UL;
   tf->codes[8894] = 0x00003a65d7fc6497UL;
   tf->codes[8895] = 0x00003a6b5564ef0fUL;
   tf->codes[8896] = 0x00003a74b64cdb9cUL;
   tf->codes[8897] = 0x00003a889ce7d18fUL;
   tf->codes[8898] = 0x00003a9865745fa8UL;
   tf->codes[8899] = 0x00003a9bd3d5b633UL;
   tf->codes[8900] = 0x00003aa952cc0a9aUL;
   tf->codes[8901] = 0x00003ab23e95eb9dUL;
   tf->codes[8902] = 0x00003acf4b89c858UL;
   tf->codes[8903] = 0x00003ad0e572f0bbUL;
   tf->codes[8904] = 0x00003ad5b32e69e4UL;
   tf->codes[8905] = 0x00003ad9d13cd1beUL;
   tf->codes[8906] = 0x00003adba5b4ffe6UL;
   tf->codes[8907] = 0x00003ae1d2ca9badUL;
   tf->codes[8908] = 0x00003ae78ac22beaUL;
   tf->codes[8909] = 0x00003ae8af8d48c3UL;
   tf->codes[8910] = 0x00003af87819d6dcUL;
   tf->codes[8911] = 0x00003af8b2a8dca1UL;
   tf->codes[8912] = 0x00003afe6aa06cdeUL;
   tf->codes[8913] = 0x00003b1a8d583285UL;
   tf->codes[8914] = 0x00003b24d87c3626UL;
   tf->codes[8915] = 0x00003b2a1b55bad9UL;
   tf->codes[8916] = 0x00003b30f81867efUL;
   tf->codes[8917] = 0x00003b55917c030fUL;
   tf->codes[8918] = 0x00003b5bf920a49bUL;
   tf->codes[8919] = 0x00003b651f798b63UL;
   tf->codes[8920] = 0x00003b6609b5a277UL;
   tf->codes[8921] = 0x00003b6c715a4403UL;
   tf->codes[8922] = 0x00003b78cb857b91UL;
   tf->codes[8923] = 0x00003b7940a3871bUL;
   tf->codes[8924] = 0x00003b8b18374921UL;
   tf->codes[8925] = 0x00003b998169b49cUL;
   tf->codes[8926] = 0x00003b9c401df9d8UL;
   tf->codes[8927] = 0x00003bbc0bc61bcfUL;
   tf->codes[8928] = 0x00003bc9c54b75fbUL;
   tf->codes[8929] = 0x00003bd65a05b34eUL;
   tf->codes[8930] = 0x00003be39e6d01f0UL;
   tf->codes[8931] = 0x00003bf6603cdb0aUL;
   tf->codes[8932] = 0x00003c036a1523e7UL;
   tf->codes[8933] = 0x00003c0d058c1639UL;
   tf->codes[8934] = 0x00003c21614517b6UL;
   tf->codes[8935] = 0x00003c2d465243baUL;
   tf->codes[8936] = 0x00003c2ea5ac6658UL;
   tf->codes[8937] = 0x00003c35bcfe1933UL;
   tf->codes[8938] = 0x00003c3ac5489821UL;
   tf->codes[8939] = 0x00003c49a3990f26UL;
   tf->codes[8940] = 0x00003c4b02f331c4UL;
   tf->codes[8941] = 0x00003c5f993b3906UL;
   tf->codes[8942] = 0x00003c6466f6b22fUL;
   tf->codes[8943] = 0x00003c7bf6820472UL;
   tf->codes[8944] = 0x00003c8d1e68b529UL;
   tf->codes[8945] = 0x00003ca3fe46f61dUL;
   tf->codes[8946] = 0x00003cab8ab6b482UL;
   tf->codes[8947] = 0x00003cccb5b8f917UL;
   tf->codes[8948] = 0x00003ce445444b5aUL;
   tf->codes[8949] = 0x00003ce9c2acd5d2UL;
   tf->codes[8950] = 0x00003cf0d9fe88adUL;
   tf->codes[8951] = 0x00003cf1fec9a586UL;
   tf->codes[8952] = 0x00003cfb9a4097d8UL;
   tf->codes[8953] = 0x00003d0ab32014a2UL;
   tf->codes[8954] = 0x00003d0fbb6a9390UL;
   tf->codes[8955] = 0x00003d1cffd1e232UL;
   tf->codes[8956] = 0x00003d26262ac8faUL;
   tf->codes[8957] = 0x00003d38384d90c5UL;
   tf->codes[8958] = 0x00003d43331ea5b5UL;
   tf->codes[8959] = 0x00003d4abf8e641aUL;
   tf->codes[8960] = 0x00003d4ea30dc62fUL;
   tf->codes[8961] = 0x00003d51273305a6UL;
   tf->codes[8962] = 0x00003d82ca6ee9a3UL;
   tf->codes[8963] = 0x00003d8c2b56d630UL;
   tf->codes[8964] = 0x00003d92cd8a7d81UL;
   tf->codes[8965] = 0x00003d99352f1f0dUL;
   tf->codes[8966] = 0x00003db30e50ab02UL;
   tf->codes[8967] = 0x00003db59275ea79UL;
   tf->codes[8968] = 0x00003dbd1ee5a8deUL;
   tf->codes[8969] = 0x00003dd8cc7f62fbUL;
   tf->codes[8970] = 0x00003ddadb8696e8UL;
   tf->codes[8971] = 0x00003df6c3af56caUL;
   tf->codes[8972] = 0x00003df947d49641UL;
   tf->codes[8973] = 0x00003e02a8bc82ceUL;
   tf->codes[8974] = 0x00003e07eb960781UL;
   tf->codes[8975] = 0x00003e0aaa4a4cbdUL;
   tf->codes[8976] = 0x00003e21ff46993bUL;
   tf->codes[8977] = 0x00003e24836bd8b2UL;
   tf->codes[8978] = 0x00003e2866eb3ac7UL;
   tf->codes[8979] = 0x00003e3919b3dff4UL;
   tf->codes[8980] = 0x00003e3a03eff708UL;
   tf->codes[8981] = 0x00003e50a93f3237UL;
   tf->codes[8982] = 0x00003e58e55c01ebUL;
   tf->codes[8983] = 0x00003e6ba72bdb05UL;
   tf->codes[8984] = 0x00003e745866b643UL;
   tf->codes[8985] = 0x00003e819cce04e5UL;
   tf->codes[8986] = 0x00003e8d474c2b24UL;
   tf->codes[8987] = 0x00003e8df6f93c73UL;
   tf->codes[8988] = 0x00003e9b00d18550UL;
   tf->codes[8989] = 0x00003ea7206db719UL;
   tf->codes[8990] = 0x00003eaf5c8a86cdUL;
   tf->codes[8991] = 0x00003ebacc79a747UL;
   tf->codes[8992] = 0x00003ebb7c26b896UL;
   tf->codes[8993] = 0x00003ebbf144c420UL;
   tf->codes[8994] = 0x00003eca5a772f9bUL;
   tf->codes[8995] = 0x00003ecd192b74d7UL;
   tf->codes[8996] = 0x00003ed55548448bUL;
   tf->codes[8997] = 0x00003eeb85797430UL;
   tf->codes[8998] = 0x00003efc3842195dUL;
   tf->codes[8999] = 0x00003f16c110b6a1UL;
   tf->codes[9000] = 0x00003f2405780543UL;
   tf->codes[9001] = 0x00003f3408939921UL;
   tf->codes[9002] = 0x00003f37b183f571UL;
   tf->codes[9003] = 0x00003f468fd46c76UL;
   tf->codes[9004] = 0x00003f48644c9a9eUL;
   tf->codes[9005] = 0x00003f5399acb553UL;
   tf->codes[9006] = 0x00003f6cfdb035beUL;
   tf->codes[9007] = 0x00003f736554d74aUL;
   tf->codes[9008] = 0x00003f9c91e4e5ceUL;
   tf->codes[9009] = 0x00003f9f50992b0aUL;
   tf->codes[9010] = 0x00003fa2846b7bd0UL;
   tf->codes[9011] = 0x00003fa7c7450083UL;
   tf->codes[9012] = 0x00003fd49cc56b57UL;
   tf->codes[9013] = 0x00003fd845b5c7a7UL;
   tf->codes[9014] = 0x00003fdd137140d0UL;
   tf->codes[9015] = 0x00003ff936290677UL;
   tf->codes[9016] = 0x00003ffb0aa1349fUL;
   tf->codes[9017] = 0x00003ffc69fb573dUL;
   tf->codes[9018] = 0x00004004a61826f1UL;
   tf->codes[9019] = 0x0000400ad32dc2b8UL;
   tf->codes[9020] = 0x00004016b83aeebcUL;
   tf->codes[9021] = 0x0000401ce5508a83UL;
   tf->codes[9022] = 0x000040229d481ac0UL;
   tf->codes[9023] = 0x00004024e6de5472UL;
   tf->codes[9024] = 0x00004025d11a6b86UL;
   tf->codes[9025] = 0x000040288fceb0c2UL;
   tf->codes[9026] = 0x00004056c4a93e34UL;
   tf->codes[9027] = 0x00004062e4456ffdUL;
   tf->codes[9028] = 0x000040670253d7d7UL;
   tf->codes[9029] = 0x00004073d19d1aefUL;
   tf->codes[9030] = 0x0000409412634870UL;
   tf->codes[9031] = 0x00004096216a7c5dUL;
   tf->codes[9032] = 0x00004096968887e7UL;
   tf->codes[9033] = 0x000040970ba69371UL;
   tf->codes[9034] = 0x00004097bb53a4c0UL;
   tf->codes[9035] = 0x00004098a58fbbd4UL;
   tf->codes[9036] = 0x0000409aef25f586UL;
   tf->codes[9037] = 0x0000409c13f1125fUL;
   tf->codes[9038] = 0x0000409e5d874c11UL;
   tf->codes[9039] = 0x000040a32b42c53aUL;
   tf->codes[9040] = 0x000040bc54b73fe0UL;
   tf->codes[9041] = 0x000040bc8f4645a5UL;
   tf->codes[9042] = 0x000040d3a9b38c5eUL;
   tf->codes[9043] = 0x000040e7904e8251UL;
   tf->codes[9044] = 0x000040f87da62d43UL;
   tf->codes[9045] = 0x00004107d114afd2UL;
   tf->codes[9046] = 0x0000410b3f76065dUL;
   tf->codes[9047] = 0x0000410c9ed028fbUL;
   tf->codes[9048] = 0x000041279cbcd1c9UL;
   tf->codes[9049] = 0x00004136f02b5458UL;
   tf->codes[9050] = 0x0000413a5e8caae3UL;
   tf->codes[9051] = 0x0000413ca822e495UL;
   tf->codes[9052] = 0x0000414fa481c374UL;
   tf->codes[9053] = 0x0000415437ae36d8UL;
   tf->codes[9054] = 0x00004164ea76dc05UL;
   tf->codes[9055] = 0x00004169b832552eUL;
   tf->codes[9056] = 0x0000416bc739891bUL;
   tf->codes[9057] = 0x00004172de8b3bf6UL;
   tf->codes[9058] = 0x000041773728a995UL;
   tf->codes[9059] = 0x00004177ac46b51fUL;
   tf->codes[9060] = 0x0000417d29af3f97UL;
   tf->codes[9061] = 0x000041839153e123UL;
   tf->codes[9062] = 0x0000418983da7725UL;
   tf->codes[9063] = 0x0000418c07ffb69cUL;
   tf->codes[9064] = 0x0000418c428ebc61UL;
   tf->codes[9065] = 0x0000419cbac85bc9UL;
   tf->codes[9066] = 0x000041a35cfc031aUL;
   tf->codes[9067] = 0x000041bde5caa05eUL;
   tf->codes[9068] = 0x000041c069efdfd5UL;
   tf->codes[9069] = 0x000041d993645a7bUL;
   tf->codes[9070] = 0x000041eba5872246UL;
   tf->codes[9071] = 0x000041ec1aa52dd0UL;
   tf->codes[9072] = 0x000041ecca523f1fUL;
   tf->codes[9073] = 0x000041f4cbe0090eUL;
   tf->codes[9074] = 0x000041fbe331bbe9UL;
   tf->codes[9075] = 0x000042062e55bf8aUL;
   tf->codes[9076] = 0x00004213ad4c13f1UL;
   tf->codes[9077] = 0x0000421497882b05UL;
   tf->codes[9078] = 0x0000421581c44219UL;
   tf->codes[9079] = 0x000042246014b91eUL;
   tf->codes[9080] = 0x00004229dd7d4396UL;
   tf->codes[9081] = 0x0000423b7a81ffd7UL;
   tf->codes[9082] = 0x000042421cb5a728UL;
   tf->codes[9083] = 0x0000426347b7ebbdUL;
   tf->codes[9084] = 0x00004269af5c8d49UL;
   tf->codes[9085] = 0x0000426b4945b5acUL;
   tf->codes[9086] = 0x0000427f6a6fb164UL;
   tf->codes[9087] = 0x0000428681c1643fUL;
   tf->codes[9088] = 0x00004289b593b505UL;
   tf->codes[9089] = 0x0000429909023794UL;
   tf->codes[9090] = 0x000042997e20431eUL;
   tf->codes[9091] = 0x000042ab90430ae9UL;
   tf->codes[9092] = 0x000042b984576adaUL;
   tf->codes[9093] = 0x000042c1c0743a8eUL;
   tf->codes[9094] = 0x000042ee95f4a562UL;
   tf->codes[9095] = 0x000042f7472f80a0UL;
   tf->codes[9096] = 0x000042f95636b48dUL;
   tf->codes[9097] = 0x000042faf01fdcf0UL;
   tf->codes[9098] = 0x000043095952486bUL;
   tf->codes[9099] = 0x0000430d0242a4bbUL;
   tf->codes[9100] = 0x0000430d3cd1aa80UL;
   tf->codes[9101] = 0x00004319d18be7d3UL;
   tf->codes[9102] = 0x0000433126883451UL;
   tf->codes[9103] = 0x00004333358f683eUL;
   tf->codes[9104] = 0x000043387868ecf1UL;
   tf->codes[9105] = 0x000043466c7d4ce2UL;
   tf->codes[9106] = 0x0000434b3a38c60bUL;
   tf->codes[9107] = 0x00004368472ca2c6UL;
   tf->codes[9108] = 0x00004371e2a39518UL;
   tf->codes[9109] = 0x000043863e5c9695UL;
   tf->codes[9110] = 0x0000439815f0589bUL;
   tf->codes[9111] = 0x000043a72ecfd565UL;
   tf->codes[9112] = 0x000043c4eb70c36fUL;
   tf->codes[9113] = 0x000043d4796e4bc3UL;
   tf->codes[9114] = 0x000043d688757fb0UL;
   tf->codes[9115] = 0x000043dfe95d6c3dUL;
   tf->codes[9116] = 0x000043e0990a7d8cUL;
   tf->codes[9117] = 0x000043e89a98477bUL;
   tf->codes[9118] = 0x000043ebce6a9841UL;
   tf->codes[9119] = 0x000043f7ee06ca0aUL;
   tf->codes[9120] = 0x000043fae74a150bUL;
   tf->codes[9121] = 0x00004401145fb0d2UL;
   tf->codes[9122] = 0x00004401897dbc5cUL;
   tf->codes[9123] = 0x000044040da2fbd3UL;
   tf->codes[9124] = 0x0000440b9a12ba38UL;
   tf->codes[9125] = 0x00004423299e0c7bUL;
   tf->codes[9126] = 0x0000442f493a3e44UL;
   tf->codes[9127] = 0x0000442f83c94409UL;
   tf->codes[9128] = 0x00004432427d8945UL;
   tf->codes[9129] = 0x00004437fa751982UL;
   tf->codes[9130] = 0x00004449225bca39UL;
   tf->codes[9131] = 0x000044528343b6c6UL;
   tf->codes[9132] = 0x00004457c61d3b79UL;
   tf->codes[9133] = 0x000044792bae85d3UL;
   tf->codes[9134] = 0x0000449a1c21c4a3UL;
   tf->codes[9135] = 0x000044a88554301eUL;
   tf->codes[9136] = 0x000044a8fa723ba8UL;
   tf->codes[9137] = 0x000044bbf6d11a87UL;
   tf->codes[9138] = 0x000044cf684e04f0UL;
   tf->codes[9139] = 0x000044d3113e6140UL;
   tf->codes[9140] = 0x000044e7a7866882UL;
   tf->codes[9141] = 0x000044f22d3971e8UL;
   tf->codes[9142] = 0x000044f3177588fcUL;
   tf->codes[9143] = 0x000044f59b9ac873UL;
   tf->codes[9144] = 0x000044fc785d7589UL;
   tf->codes[9145] = 0x00004506c381792aUL;
   tf->codes[9146] = 0x00004519103346baUL;
   tf->codes[9147] = 0x0000452111c110a9UL;
   tf->codes[9148] = 0x00004526549a955cUL;
   tf->codes[9149] = 0x0000453448aef54dUL;
   tf->codes[9150] = 0x0000453cbf5acac6UL;
   tf->codes[9151] = 0x000045418d1643efUL;
   tf->codes[9152] = 0x000045482f49eb40UL;
   tf->codes[9153] = 0x0000456367c599d3UL;
   tf->codes[9154] = 0x00004567c0630772UL;
   tf->codes[9155] = 0x00004568701018c1UL;
   tf->codes[9156] = 0x0000457abcc1e651UL;
   tf->codes[9157] = 0x0000458d4402b9a6UL;
   tf->codes[9158] = 0x000045924c4d3894UL;
   tf->codes[9159] = 0x0000459545908395UL;
   tf->codes[9160] = 0x000045b80a7bf08dUL;
   tf->codes[9161] = 0x000045c3b4fa16ccUL;
   tf->codes[9162] = 0x000045c42a182256UL;
   tf->codes[9163] = 0x000045c5897244f4UL;
   tf->codes[9164] = 0x000045d4a251c1beUL;
   tf->codes[9165] = 0x000045d5176fcd48UL;
   tf->codes[9166] = 0x000045d8c0602998UL;
   tf->codes[9167] = 0x000045d9357e3522UL;
   tf->codes[9168] = 0x000045e729929513UL;
   tf->codes[9169] = 0x000045e813ceac27UL;
   tf->codes[9170] = 0x00004626fb71dec6UL;
   tf->codes[9171] = 0x0000462a69d33551UL;
   tf->codes[9172] = 0x0000462ec270a2f0UL;
   tf->codes[9173] = 0x00004632e07f0acaUL;
   tf->codes[9174] = 0x0000463564a44a41UL;
   tf->codes[9175] = 0x0000463cf11408a6UL;
   tf->codes[9176] = 0x000046482674235bUL;
   tf->codes[9177] = 0x0000464ec8a7caacUL;
   tf->codes[9178] = 0x0000465779e2a5eaUL;
   tf->codes[9179] = 0x0000466b607d9bddUL;
   tf->codes[9180] = 0x00004684ff10220dUL;
   tf->codes[9181] = 0x0000468748a65bbfUL;
   tf->codes[9182] = 0x00004696d6a3e413UL;
   tf->codes[9183] = 0x0000469835fe06b1UL;
   tf->codes[9184] = 0x0000469ba45f5d3cUL;
   tf->codes[9185] = 0x0000469f12c0b3c7UL;
   tf->codes[9186] = 0x000046bc5a439647UL;
   tf->codes[9187] = 0x000046c4966065fbUL;
   tf->codes[9188] = 0x000046e6ab9ec1a4UL;
   tf->codes[9189] = 0x000046ec29074c1cUL;
   tf->codes[9190] = 0x000046f305c9f932UL;
   tf->codes[9191] = 0x000046f6e9495b47UL;
   tf->codes[9192] = 0x000046fbf193da35UL;
   tf->codes[9193] = 0x00004704dd5dbb38UL;
   tf->codes[9194] = 0x000047079c120074UL;
   tf->codes[9195] = 0x000047146b5b438cUL;
   tf->codes[9196] = 0x0000471b481df0a2UL;
   tf->codes[9197] = 0x0000471fdb4a6406UL;
   tf->codes[9198] = 0x00004726f29c16e1UL;
   tf->codes[9199] = 0x00004731784f2047UL;
   tf->codes[9200] = 0x00004733123848aaUL;
   tf->codes[9201] = 0x00004739b46beffbUL;
   tf->codes[9202] = 0x0000473f31d47a73UL;
   tf->codes[9203] = 0x0000475268c25f17UL;
   tf->codes[9204] = 0x00004755d723b5a2UL;
   tf->codes[9205] = 0x000047685e6488f7UL;
   tf->codes[9206] = 0x0000476ae289c86eUL;
   tf->codes[9207] = 0x000047744371b4fbUL;
   tf->codes[9208] = 0x0000477c7f8e84afUL;
   tf->codes[9209] = 0x0000479449a8dcb7UL;
   tf->codes[9210] = 0x00004796933f1669UL;
   tf->codes[9211] = 0x00004799176455e0UL;
   tf->codes[9212] = 0x000047ac4e523a84UL;
   tf->codes[9213] = 0x000047b48a6f0a38UL;
   tf->codes[9214] = 0x000047b70e9449afUL;
   tf->codes[9215] = 0x000047c243f46464UL;
   tf->codes[9216] = 0x000047c27e836a29UL;
   tf->codes[9217] = 0x000047d95e61ab1dUL;
   tf->codes[9218] = 0x000047dba7f7e4cfUL;
   tf->codes[9219] = 0x000047f7caafaa76UL;
   tf->codes[9220] = 0x000047fbe8be1250UL;
   tf->codes[9221] = 0x000048012b979703UL;
   tf->codes[9222] = 0x0000481462857ba7UL;
   tf->codes[9223] = 0x000048180b75d7f7UL;
   tf->codes[9224] = 0x0000483c6a4a6d52UL;
   tf->codes[9225] = 0x0000483d54868466UL;
   tf->codes[9226] = 0x0000483f638db853UL;
   tf->codes[9227] = 0x000048425cd10354UL;
   tf->codes[9228] = 0x0000484f66a94c31UL;
   tf->codes[9229] = 0x00004859773e4a0dUL;
   tf->codes[9230] = 0x000048622879254bUL;
   tf->codes[9231] = 0x00004866bba598afUL;
   tf->codes[9232] = 0x000048697a59ddebUL;
   tf->codes[9233] = 0x0000486a9f24fac4UL;
   tf->codes[9234] = 0x000048701c8d853cUL;
   tf->codes[9235] = 0x000048714158a215UL;
   tf->codes[9236] = 0x00004884ed649243UL;
   tf->codes[9237] = 0x000048931c07f7f9UL;
   tf->codes[9238] = 0x00004899491d93c0UL;
   tf->codes[9239] = 0x000048a652f5dc9dUL;
   tf->codes[9240] = 0x000048a777c0f976UL;
   tf->codes[9241] = 0x000048b6cb2f7c05UL;
   tf->codes[9242] = 0x000048c5e40ef8cfUL;
   tf->codes[9243] = 0x000048c61e9dfe94UL;
   tf->codes[9244] = 0x000048c6592d0459UL;
   tf->codes[9245] = 0x000048c743691b6dUL;
   tf->codes[9246] = 0x000048db64931725UL;
   tf->codes[9247] = 0x000048eb2d1fa53eUL;
   tf->codes[9248] = 0x000048f8ac15f9a5UL;
   tf->codes[9249] = 0x0000491fc99ed43cUL;
   tf->codes[9250] = 0x00004920ee69f115UL;
   tf->codes[9251] = 0x000049299fa4cc53UL;
   tf->codes[9252] = 0x0000492cd3771d19UL;
   tf->codes[9253] = 0x0000494c6490394bUL;
   tf->codes[9254] = 0x0000496518e6a867UL;
   tf->codes[9255] = 0x000049704e46c31cUL;
   tf->codes[9256] = 0x000049713882da30UL;
   tf->codes[9257] = 0x000049717311dff5UL;
   tf->codes[9258] = 0x00004977dab68181UL;
   tf->codes[9259] = 0x0000497bf8c4e95bUL;
   tf->codes[9260] = 0x0000498768b409d5UL;
   tf->codes[9261] = 0x0000498ce61c944dUL;
   tf->codes[9262] = 0x000049934dc135d9UL;
   tf->codes[9263] = 0x00004996f6b19229UL;
   tf->codes[9264] = 0x000049a52554f7dfUL;
   tf->codes[9265] = 0x000049a60f910ef3UL;
   tf->codes[9266] = 0x000049d5de54c4c8UL;
   tf->codes[9267] = 0x000049da36f23267UL;
   tf->codes[9268] = 0x000049e3d26924b9UL;
   tf->codes[9269] = 0x000049ecf8c20b81UL;
   tf->codes[9270] = 0x000049f4bfc0cfabUL;
   tf->codes[9271] = 0x000049f61f1af249UL;
   tf->codes[9272] = 0x000049fb61f476fcUL;
   tf->codes[9273] = 0x000049fbd7128286UL;
   tf->codes[9274] = 0x00004a08a65bc59eUL;
   tf->codes[9275] = 0x00004a1bdd49aa42UL;
   tf->codes[9276] = 0x00004a32f7b6f0fbUL;
   tf->codes[9277] = 0x00004a3924cc8cc2UL;
   tf->codes[9278] = 0x00004a3be380d1feUL;
   tf->codes[9279] = 0x00004a3c1e0fd7c3UL;
   tf->codes[9280] = 0x00004a4718e0ecb3UL;
   tf->codes[9281] = 0x00004a4a8742433eUL;
   tf->codes[9282] = 0x00004a4be69c65dcUL;
   tf->codes[9283] = 0x00004a4c9649772bUL;
   tf->codes[9284] = 0x00004a512975ea8fUL;
   tf->codes[9285] = 0x00004a78f6abd675UL;
   tf->codes[9286] = 0x00004a875fde41f0UL;
   tf->codes[9287] = 0x00004a879a6d47b5UL;
   tf->codes[9288] = 0x00004a8bf30ab554UL;
   tf->codes[9289] = 0x00004a9469b68acdUL;
   tf->codes[9290] = 0x00004a9519639c1cUL;
   tf->codes[9291] = 0x00004a97d817e158UL;
   tf->codes[9292] = 0x00004abb4cb05f9fUL;
   tf->codes[9293] = 0x00004abf302fc1b4UL;
   tf->codes[9294] = 0x00004ac5d2636905UL;
   tf->codes[9295] = 0x00004ac8cba6b406UL;
   tf->codes[9296] = 0x00004acb4fcbf37dUL;
   tf->codes[9297] = 0x00004ad3c677c8f6UL;
   tf->codes[9298] = 0x00004afec78005a2UL;
   tf->codes[9299] = 0x00004b04f495a169UL;
   tf->codes[9300] = 0x00004b061960be42UL;
   tf->codes[9301] = 0x00004b1532403b0cUL;
   tf->codes[9302] = 0x00004b16919a5daaUL;
   tf->codes[9303] = 0x00004b1cf93eff36UL;
   tf->codes[9304] = 0x00004b21c6fa785fUL;
   tf->codes[9305] = 0x00004b23d601ac4cUL;
   tf->codes[9306] = 0x00004b55041f84bfUL;
   tf->codes[9307] = 0x00004b745aa99b2cUL;
   tf->codes[9308] = 0x00004b7878b80306UL;
   tf->codes[9309] = 0x00004b9008435549UL;
   tf->codes[9310] = 0x00004b93b133b199UL;
   tf->codes[9311] = 0x00004b9ee693cc4eUL;
   tf->codes[9312] = 0x00004bc88841e65cUL;
   tf->codes[9313] = 0x00004bddce36feedUL;
   tf->codes[9314] = 0x00004be4e588b1c8UL;
   tf->codes[9315] = 0x00004be67f71da2bUL;
   tf->codes[9316] = 0x00004bf6f7ab7993UL;
   tf->codes[9317] = 0x00004bfb5048e732UL;
   tf->codes[9318] = 0x00004bffe3755a96UL;
   tf->codes[9319] = 0x00004c022d0b9448UL;
   tf->codes[9320] = 0x00004c040183c270UL;
   tf->codes[9321] = 0x00004c0dd789ba87UL;
   tf->codes[9322] = 0x00004c126ab62debUL;
   tf->codes[9323] = 0x00004c159e887eb1UL;
   tf->codes[9324] = 0x00004c1f39ff7103UL;
   tf->codes[9325] = 0x00004c4657884b9aUL;
   tf->codes[9326] = 0x00004c58dec91eefUL;
   tf->codes[9327] = 0x00004c648947452eUL;
   tf->codes[9328] = 0x00004c75b12df5e5UL;
   tf->codes[9329] = 0x00004c80e68e109aUL;
   tf->codes[9330] = 0x00004c815bac1c24UL;
   tf->codes[9331] = 0x00004c97514e4604UL;
   tf->codes[9332] = 0x00004c9800fb5753UL;
   tf->codes[9333] = 0x00004c9c9427cab7UL;
   tf->codes[9334] = 0x00004caafd5a3632UL;
   tf->codes[9335] = 0x00004cb005a4b520UL;
   tf->codes[9336] = 0x00004cb9668ca1adUL;
   tf->codes[9337] = 0x00004cc795300763UL;
   tf->codes[9338] = 0x00004cd5fe6272deUL;
   tf->codes[9339] = 0x00004cdf99d96530UL;
   tf->codes[9340] = 0x00004d152094ab42UL;
   tf->codes[9341] = 0x00004d17df48f07eUL;
   tf->codes[9342] = 0x00004d1b88394cceUL;
   tf->codes[9343] = 0x00004d2c0072ec36UL;
   tf->codes[9344] = 0x00004d51498398a5UL;
   tf->codes[9345] = 0x00004d56c6ec231dUL;
   tf->codes[9346] = 0x00004d58264645bbUL;
   tf->codes[9347] = 0x00004d5cb972b91fUL;
   tf->codes[9348] = 0x00004d78a19b7901UL;
   tf->codes[9349] = 0x00004d7916b9848bUL;
   tf->codes[9350] = 0x00004d8a3ea03542UL;
   tf->codes[9351] = 0x00004d8f46eab430UL;
   tf->codes[9352] = 0x00004da95a9b45eaUL;
   tf->codes[9353] = 0x00004dabdec08561UL;
   tf->codes[9354] = 0x00004db53fa871eeUL;
   tf->codes[9355] = 0x00004dc15f44a3b7UL;
   tf->codes[9356] = 0x00004dc41df8e8f3UL;
   tf->codes[9357] = 0x00004ddc22a246c0UL;
   tf->codes[9358] = 0x00004de92c7a8f9dUL;
   tf->codes[9359] = 0x00004df4d6f8b5dcUL;
   tf->codes[9360] = 0x00004df9a4b42f05UL;
   tf->codes[9361] = 0x00004e1726c6174aUL;
   tf->codes[9362] = 0x00004e1b7f6384e9UL;
   tf->codes[9363] = 0x00004e1ca42ea1c2UL;
   tf->codes[9364] = 0x00004e58928e8960UL;
   tf->codes[9365] = 0x00004e6352d0988bUL;
   tf->codes[9366] = 0x00004e6b545e627aUL;
   tf->codes[9367] = 0x00004e731b5d26a4UL;
   tf->codes[9368] = 0x00004e8cb9efacd4UL;
   tf->codes[9369] = 0x00004eab9b5bb7b7UL;
   tf->codes[9370] = 0x00004ec44fb226d3UL;
   tf->codes[9371] = 0x00004ed0e46c6426UL;
   tf->codes[9372] = 0x00004ed5ecb6e314UL;
   tf->codes[9373] = 0x00004ee3e0cb4305UL;
   tf->codes[9374] = 0x00004ef9614f615bUL;
   tf->codes[9375] = 0x00004efa10fc72aaUL;
   tf->codes[9376] = 0x00004eff53d5f75dUL;
   tf->codes[9377] = 0x00004f00edbf1fc0UL;
   tf->codes[9378] = 0x00004f083f9fd860UL;
   tf->codes[9379] = 0x00004f4761d210c4UL;
   tf->codes[9380] = 0x00004f5ef15d6307UL;
   tf->codes[9381] = 0x00004f6817b649cfUL;
   tf->codes[9382] = 0x00004f74e6ff8ce7UL;
   tf->codes[9383] = 0x00004f8733b15a77UL;
   tf->codes[9384] = 0x00004f8f353f2466UL;
   tf->codes[9385] = 0x00004fa89942a4d1UL;
   tf->codes[9386] = 0x00004fc4816b64b3UL;
   tf->codes[9387] = 0x00004fcf41ad73deUL;
   tf->codes[9388] = 0x00004fe8e03ffa0eUL;
   tf->codes[9389] = 0x0000500e2950a67dUL;
   tf->codes[9390] = 0x0000502be5f19487UL;
   tf->codes[9391] = 0x0000502d0abcb160UL;
   tf->codes[9392] = 0x00005038b53ad79fUL;
   tf->codes[9393] = 0x0000503be90d2865UL;
   tf->codes[9394] = 0x000050500a37241dUL;
   tf->codes[9395] = 0x000050528e5c6394UL;
   tf->codes[9396] = 0x0000505796a6e282UL;
   tf->codes[9397] = 0x00005064a07f2b5fUL;
   tf->codes[9398] = 0x00005083475c307dUL;
   tf->codes[9399] = 0x000050851bd45ea5UL;
   tf->codes[9400] = 0x000050897471cc44UL;
   tf->codes[9401] = 0x0000508a993ce91dUL;
   tf->codes[9402] = 0x0000508f2c695c81UL;
   tf->codes[9403] = 0x0000509b11768885UL;
   tf->codes[9404] = 0x000050ab4f212228UL;
   tf->codes[9405] = 0x000050b7e3db5f7bUL;
   tf->codes[9406] = 0x000050c6879cd0bbUL;
   tf->codes[9407] = 0x000050d9496ca9d5UL;
   tf->codes[9408] = 0x000050dddc991d39UL;
   tf->codes[9409] = 0x000050e185897989UL;
   tf->codes[9410] = 0x000050e9c1a6493dUL;
   tf->codes[9411] = 0x000050ee8f61c266UL;
   tf->codes[9412] = 0x000050f0d8f7fc18UL;
   tf->codes[9413] = 0x000051077e473747UL;
   tf->codes[9414] = 0x000051136354634bUL;
   tf->codes[9415] = 0x000051139de36910UL;
   tf->codes[9416] = 0x0000511c4f1e444eUL;
   tf->codes[9417] = 0x000051248b3b1402UL;
   tf->codes[9418] = 0x0000512a4332a43fUL;
   tf->codes[9419] = 0x00005142826b07d1UL;
   tf->codes[9420] = 0x0000514abe87d785UL;
   tf->codes[9421] = 0x00005159d767544fUL;
   tf->codes[9422] = 0x0000516129480cefUL;
   tf->codes[9423] = 0x00005164d238693fUL;
   tf->codes[9424] = 0x0000517300dbcef5UL;
   tf->codes[9425] = 0x00005178f36264f7UL;
   tf->codes[9426] = 0x00005191329ac889UL;
   tf->codes[9427] = 0x000051af29cabc58UL;
   tf->codes[9428] = 0x000051b51c51525aUL;
   tf->codes[9429] = 0x000051b556e0581fUL;
   tf->codes[9430] = 0x000051c1eb9a9572UL;
   tf->codes[9431] = 0x000051c7de212b74UL;
   tf->codes[9432] = 0x000051cd5b89b5ecUL;
   tf->codes[9433] = 0x000051d29e633a9fUL;
   tf->codes[9434] = 0x000051dd24164405UL;
   tf->codes[9435] = 0x000051e1b742b769UL;
   tf->codes[9436] = 0x000051e81ee758f5UL;
   tf->codes[9437] = 0x0000520b1e61cbb2UL;
   tf->codes[9438] = 0x000052327679ac0eUL;
   tf->codes[9439] = 0x0000523a3d787038UL;
   tf->codes[9440] = 0x0000523b9cd292d6UL;
   tf->codes[9441] = 0x00005248a6aadbb3UL;
   tf->codes[9442] = 0x00005248e139e178UL;
   tf->codes[9443] = 0x000052495657ed02UL;
   tf->codes[9444] = 0x0000524af0411565UL;
   tf->codes[9445] = 0x0000525b687ab4cdUL;
   tf->codes[9446] = 0x0000525fc118226cUL;
   tf->codes[9447] = 0x0000526a46cb2bd2UL;
   tf->codes[9448] = 0x0000526e9f689971UL;
   tf->codes[9449] = 0x0000527e67f5278aUL;
   tf->codes[9450] = 0x00005283703fa678UL;
   tf->codes[9451] = 0x000052841fecb7c7UL;
   tf->codes[9452] = 0x00005288788a2566UL;
   tf->codes[9453] = 0x00005288b3192b2bUL;
   tf->codes[9454] = 0x00005295f78079cdUL;
   tf->codes[9455] = 0x0000529ac53bf2f6UL;
   tf->codes[9456] = 0x000052a37676ce34UL;
   tf->codes[9457] = 0x000052a79485360eUL;
   tf->codes[9458] = 0x000052c7259e5240UL;
   tf->codes[9459] = 0x000052d55441b7f6UL;
   tf->codes[9460] = 0x000052d6790cd4cfUL;
   tf->codes[9461] = 0x000052e298a90698UL;
   tf->codes[9462] = 0x000052e72bd579fcUL;
   tf->codes[9463] = 0x000052e9ea89bf38UL;
   tf->codes[9464] = 0x000052ebbf01ed60UL;
   tf->codes[9465] = 0x000052f903693c02UL;
   tf->codes[9466] = 0x000053005549f4a2UL;
   tf->codes[9467] = 0x00005307320ca1b8UL;
   tf->codes[9468] = 0x0000530bc539151cUL;
   tf->codes[9469] = 0x0000530c74e6266bUL;
   tf->codes[9470] = 0x0000531b18a797abUL;
   tf->codes[9471] = 0x00005328d22cf1d7UL;
   tf->codes[9472] = 0x0000534027293e55UL;
   tf->codes[9473] = 0x0000534b5c89590aUL;
   tf->codes[9474] = 0x00005359160eb336UL;
   tf->codes[9475] = 0x000053770d3ea705UL;
   tf->codes[9476] = 0x000053a0745dbb4eUL;
   tf->codes[9477] = 0x000053a960279c51UL;
   tf->codes[9478] = 0x000053bb37bb5e57UL;
   tf->codes[9479] = 0x000053d0b83f7cadUL;
   tf->codes[9480] = 0x000053d8b9cd469cUL;
   tf->codes[9481] = 0x000053da53b66effUL;
   tf->codes[9482] = 0x000053e0463d0501UL;
   tf->codes[9483] = 0x000053e80d3bc92bUL;
   tf->codes[9484] = 0x000053f6766e34a6UL;
   tf->codes[9485] = 0x000054051a2fa5e6UL;
   tf->codes[9486] = 0x0000540ca69f644bUL;
   tf->codes[9487] = 0x00005411745add74UL;
   tf->codes[9488] = 0x00005416f1c367ecUL;
   tf->codes[9489] = 0x00005433147b2d93UL;
   tf->codes[9490] = 0x0000543473d55031UL;
   tf->codes[9491] = 0x0000543c00450e96UL;
   tf->codes[9492] = 0x0000544894ff4be9UL;
   tf->codes[9493] = 0x0000545e15836a3fUL;
   tf->codes[9494] = 0x00005463cd7afa7cUL;
   tf->codes[9495] = 0x00005475df9dc247UL;
   tf->codes[9496] = 0x0000548b9ab0e662UL;
   tf->codes[9497] = 0x0000549cc2979719UL;
   tf->codes[9498] = 0x000054a7484aa07fUL;
   tf->codes[9499] = 0x000054b95a6d684aUL;
   tf->codes[9500] = 0x000054c1216c2c74UL;
   tf->codes[9501] = 0x000054c53f7a944eUL;
   tf->codes[9502] = 0x000054ca0d360d77UL;
   tf->codes[9503] = 0x000054d960a49006UL;
   tf->codes[9504] = 0x000054dd0994ec56UL;
   tf->codes[9505] = 0x000054e83ef5070bUL;
   tf->codes[9506] = 0x000054ec979274aaUL;
   tf->codes[9507] = 0x000054f2ff371636UL;
   tf->codes[9508] = 0x000054ff93f15389UL;
   tf->codes[9509] = 0x0000550e7241ca8eUL;
   tf->codes[9510] = 0x0000551046b9f8b6UL;
   tf->codes[9511] = 0x0000552552200b82UL;
   tf->codes[9512] = 0x00005527d6454af9UL;
   tf->codes[9513] = 0x0000553d91586f14UL;
   tf->codes[9514] = 0x00005547dc7c72b5UL;
   tf->codes[9515] = 0x00005550c84653b8UL;
   tf->codes[9516] = 0x00005563c4a53297UL;
   tf->codes[9517] = 0x00005569f1bace5eUL;
   tf->codes[9518] = 0x00005574024fcc3aUL;
   tf->codes[9519] = 0x000055caee9c5ca6UL;
   tf->codes[9520] = 0x000055dd75dd2ffbUL;
   tf->codes[9521] = 0x000055eed852e677UL;
   tf->codes[9522] = 0x000055f037ad0915UL;
   tf->codes[9523] = 0x000056015f93b9ccUL;
   tf->codes[9524] = 0x0000560a4b5d9acfUL;
   tf->codes[9525] = 0x0000560b7028b7a8UL;
   tf->codes[9526] = 0x0000561804e2f4fbUL;
   tf->codes[9527] = 0x00005636e64effdeUL;
   tf->codes[9528] = 0x0000563c63b78a56UL;
   tf->codes[9529] = 0x00005646e96a93bcUL;
   tf->codes[9530] = 0x00005662d193539eUL;
   tf->codes[9531] = 0x0000567ce543e558UL;
   tf->codes[9532] = 0x000056aa6a71617bUL;
   tf->codes[9533] = 0x000056af72bbe069UL;
   tf->codes[9534] = 0x000056eab16eb6b8UL;
   tf->codes[9535] = 0x000056fcc3917e83UL;
   tf->codes[9536] = 0x000057048a9042adUL;
   tf->codes[9537] = 0x00005738ec806be6UL;
   tf->codes[9538] = 0x00005741632c415fUL;
   tf->codes[9539] = 0x00005746e094cbd7UL;
   tf->codes[9540] = 0x0000574dbd5778edUL;
   tf->codes[9541] = 0x0000575c9ba7eff2UL;
   tf->codes[9542] = 0x000057a4a9a40959UL;
   tf->codes[9543] = 0x000057bb89824a4dUL;
   tf->codes[9544] = 0x000057bfa790b227UL;
   tf->codes[9545] = 0x000057db8fb97209UL;
   tf->codes[9546] = 0x000057e231ed195aUL;
   tf->codes[9547] = 0x000058161ebf3709UL;
   tf->codes[9548] = 0x00005826d187dc36UL;
   tf->codes[9549] = 0x000058391e39a9c6UL;
   tf->codes[9550] = 0x0000583d3c4811a0UL;
   tf->codes[9551] = 0x00005849d1024ef3UL;
   tf->codes[9552] = 0x00005878b589edb4UL;
   tf->codes[9553] = 0x0000587d0e275b53UL;
   tf->codes[9554] = 0x0000588ee5bb1d59UL;
   tf->codes[9555] = 0x000058c8c513d10aUL;
   tf->codes[9556] = 0x000058d1b0ddb20dUL;
   tf->codes[9557] = 0x000058e263a6573aUL;
   tf->codes[9558] = 0x000058e64725b94fUL;
   tf->codes[9559] = 0x000058ea9fc326eeUL;
   tf->codes[9560] = 0x000059439b16eb47UL;
   tf->codes[9561] = 0x0000596d3cc50555UL;
   tf->codes[9562] = 0x00005987c593a299UL;
   tf->codes[9563] = 0x000059933582c313UL;
   tf->codes[9564] = 0x000059d21d25f5b2UL;
   tf->codes[9565] = 0x000059db437edc7aUL;
   tf->codes[9566] = 0x000059e3ba2ab1f3UL;
   tf->codes[9567] = 0x000059e51984d491UL;
   tf->codes[9568] = 0x000059f76636a221UL;
   tf->codes[9569] = 0x00005a0818ff474eUL;
   tf->codes[9570] = 0x00005a305b533ebeUL;
   tf->codes[9571] = 0x00005a338f258f84UL;
   tf->codes[9572] = 0x00005a3a6be83c9aUL;
   tf->codes[9573] = 0x00005a3b90b35973UL;
   tf->codes[9574] = 0x00005a3d2a9c81d6UL;
   tf->codes[9575] = 0x00005a6448255c6dUL;
   tf->codes[9576] = 0x00005a6aafc9fdf9UL;
   tf->codes[9577] = 0x00005a70a25093fbUL;
   tf->codes[9578] = 0x00005a75e52a18aeUL;
   tf->codes[9579] = 0x00005a8329916750UL;
   tf->codes[9580] = 0x00005aa9d1fc365dUL;
   tf->codes[9581] = 0x00005aaa471a41e7UL;
   tf->codes[9582] = 0x00005ab541eb56d7UL;
   tf->codes[9583] = 0x00005ac928864ccaUL;
   tf->codes[9584] = 0x00005ada506cfd81UL;
   tf->codes[9585] = 0x00005ae9de6a85d5UL;
   tf->codes[9586] = 0x00005aea8e179724UL;
   tf->codes[9587] = 0x00005af54e59a64fUL;
   tf->codes[9588] = 0x00005b016df5d818UL;
   tf->codes[9589] = 0x00005b0467392319UL;
   tf->codes[9590] = 0x00005b331131bc15UL;
   tf->codes[9591] = 0x00005b57aa955735UL;
   tf->codes[9592] = 0x00005b6d65a87b50UL;
   tf->codes[9593] = 0x00005b82367f8857UL;
   tf->codes[9594] = 0x00005b84baa4c7ceUL;
   tf->codes[9595] = 0x00005b97b703a6adUL;
   tf->codes[9596] = 0x00005bb6986fb190UL;
   tf->codes[9597] = 0x00005bcbde64ca21UL;
   tf->codes[9598] = 0x00005bd0e6af490fUL;
   tf->codes[9599] = 0x00005bd36ad48886UL;
   tf->codes[9600] = 0x00005bd7fe00fbeaUL;
   tf->codes[9601] = 0x00005bd8731f0774UL;
   tf->codes[9602] = 0x00005beabfd0d504UL;
   tf->codes[9603] = 0x00005bebaa0cec18UL;
   tf->codes[9604] = 0x00005c079235abfaUL;
   tf->codes[9605] = 0x00005c0e6ef85910UL;
   tf->codes[9606] = 0x00005c0f59347024UL;
   tf->codes[9607] = 0x00005c16708622ffUL;
   tf->codes[9608] = 0x00005c48c36f184bUL;
   tf->codes[9609] = 0x00005c49731c299aUL;
   tf->codes[9610] = 0x00005c5ad591e016UL;
   tf->codes[9611] = 0x00005c5bbfcdf72aUL;
   tf->codes[9612] = 0x00005c7090a50431UL;
   tf->codes[9613] = 0x00005c7fa98480fbUL;
   tf->codes[9614] = 0x00005c9355907129UL;
   tf->codes[9615] = 0x00005c994817072bUL;
   tf->codes[9616] = 0x00005c9aa77129c9UL;
   tf->codes[9617] = 0x00005ce3da386009UL;
   tf->codes[9618] = 0x00005d11d483e7b6UL;
   tf->codes[9619] = 0x00005d521b813cf3UL;
   tf->codes[9620] = 0x00005d52561042b8UL;
   tf->codes[9621] = 0x00005d549fa67c6aUL;
   tf->codes[9622] = 0x00005d600f959ce4UL;
   tf->codes[9623] = 0x00005d65526f2197UL;
   tf->codes[9624] = 0x00005d66773a3e70UL;
   tf->codes[9625] = 0x00005d9436f6c058UL;
   tf->codes[9626] = 0x00005db2a344bfb1UL;
   tf->codes[9627] = 0x00005deecc33ad14UL;
   tf->codes[9628] = 0x00005df02b8dcfb2UL;
   tf->codes[9629] = 0x00005df7f28c93dcUL;
   tf->codes[9630] = 0x00005e057182e843UL;
   tf->codes[9631] = 0x00005e0b297a7880UL;
   tf->codes[9632] = 0x00005e0cfdf2a6a8UL;
   tf->codes[9633] = 0x00005e12b5ea36e5UL;
   tf->codes[9634] = 0x00005e15749e7c21UL;
   tf->codes[9635] = 0x00005e5496d0b485UL;
   tf->codes[9636] = 0x00005e904aa1965eUL;
   tf->codes[9637] = 0x00005e96ecd53dafUL;
   tf->codes[9638] = 0x00005e979c824efeUL;
   tf->codes[9639] = 0x00005ec97a4d38c0UL;
   tf->codes[9640] = 0x00005efda1ae5c34UL;
   tf->codes[9641] = 0x00005f470f049839UL;
   tf->codes[9642] = 0x00005f4a7d65eec4UL;
   tf->codes[9643] = 0x00005f741f1408d2UL;
   tf->codes[9644] = 0x00005f89da272cedUL;
   tf->codes[9645] = 0x00005f8c98db7229UL;
   tf->codes[9646] = 0x00005f9584a5532cUL;
   tf->codes[9647] = 0x00005f9bec49f4b8UL;
   tf->codes[9648] = 0x00005fbeebc46775UL;
   tf->codes[9649] = 0x00005fcf63fe06ddUL;
   tf->codes[9650] = 0x00005fd84fc7e7e0UL;
   tf->codes[9651] = 0x00005fed5b2dfaacUL;
   tf->codes[9652] = 0x00006008591aa37aUL;
   tf->codes[9653] = 0x0000600893a9a93fUL;
   tf->codes[9654] = 0x0000601478b6d543UL;
   tf->codes[9655] = 0x0000601aa5cc710aUL;
   tf->codes[9656] = 0x000060abe68fc0b1UL;
   tf->codes[9657] = 0x000060ac5badcc3bUL;
   tf->codes[9658] = 0x000060d0ba826196UL;
   tf->codes[9659] = 0x000060e75fd19cc5UL;
   tf->codes[9660] = 0x0000610591909659UL;
   tf->codes[9661] = 0x0000610815b5d5d0UL;
   tf->codes[9662] = 0x00006109ea2e03f8UL;
   tf->codes[9663] = 0x000061255d38b850UL;
   tf->codes[9664] = 0x0000615650c78afeUL;
   tf->codes[9665] = 0x000061577592a7d7UL;
   tf->codes[9666] = 0x000061590f7bd03aUL;
   tf->codes[9667] = 0x0000615c434e2100UL;
   tf->codes[9668] = 0x00006168d8085e53UL;
   tf->codes[9669] = 0x00006185aa6d3549UL;
   tf->codes[9670] = 0x0000618694a94c5dUL;
   tf->codes[9671] = 0x0000618ff59138eaUL;
   tf->codes[9672] = 0x00006197f71f02d9UL;
   tf->codes[9673] = 0x0000619ff8acccc8UL;
   tf->codes[9674] = 0x000061bccb11a3beUL;
   tf->codes[9675] = 0x000061c6a1179bd5UL;
   tf->codes[9676] = 0x000061c7c5e2b8aeUL;
   tf->codes[9677] = 0x000061e45db889dfUL;
   tf->codes[9678] = 0x0000621725bf8ab5UL;
   tf->codes[9679] = 0x000062255462f06bUL;
   tf->codes[9680] = 0x00006239006ee099UL;
   tf->codes[9681] = 0x0000624226c7c761UL;
   tf->codes[9682] = 0x0000624d2198dc51UL;
   tf->codes[9683] = 0x00006260cda4cc7fUL;
   tf->codes[9684] = 0x000062956a23fb7dUL;
   tf->codes[9685] = 0x000062a323a955a9UL;
   tf->codes[9686] = 0x000062b7b9f15cebUL;
   tf->codes[9687] = 0x000062b98e698b13UL;
   tf->codes[9688] = 0x000062c06b2c3829UL;
   tf->codes[9689] = 0x000062c69841d3f0UL;
   tf->codes[9690] = 0x000062d91f82a745UL;
   tf->codes[9691] = 0x000062dab96bcfa8UL;
   tf->codes[9692] = 0x000062dc5354f80bUL;
   tf->codes[9693] = 0x000062ef4fb3d6eaUL;
   tf->codes[9694] = 0x000063045b19e9b6UL;
   tf->codes[9695] = 0x0000631a8b4b195bUL;
   tf->codes[9696] = 0x000063372320ea8cUL;
   tf->codes[9697] = 0x0000634bf3f7f793UL;
   tf->codes[9698] = 0x00006363be124f9bUL;
   tf->codes[9699] = 0x0000636a25b6f127UL;
   tf->codes[9700] = 0x0000636e43c55901UL;
   tf->codes[9701] = 0x0000638090772691UL;
   tf->codes[9702] = 0x000063885775eabbUL;
   tf->codes[9703] = 0x0000638e848b8682UL;
   tf->codes[9704] = 0x0000639adeb6be10UL;
   tf->codes[9705] = 0x0000639d284cf7c2UL;
   tf->codes[9706] = 0x000063b099c9e22bUL;
   tf->codes[9707] = 0x000063d14fae1b36UL;
   tf->codes[9708] = 0x000063d98bcaeaeaUL;
   tf->codes[9709] = 0x0000642d09b624cbUL;
   tf->codes[9710] = 0x000064471d66b685UL;
   tf->codes[9711] = 0x00006447cd13c7d4UL;
   tf->codes[9712] = 0x00006448f1dee4adUL;
   tf->codes[9713] = 0x0000647bb9e5e583UL;
   tf->codes[9714] = 0x0000647cdeb1025cUL;
   tf->codes[9715] = 0x000064830bc69e23UL;
   tf->codes[9716] = 0x000064925f3520b2UL;
   tf->codes[9717] = 0x0000649a60c2eaa1UL;
   tf->codes[9718] = 0x000064ac3856aca7UL;
   tf->codes[9719] = 0x000064cdd876fcc6UL;
   tf->codes[9720] = 0x000064e68ccd6be2UL;
   tf->codes[9721] = 0x000064f062d363f9UL;
   tf->codes[9722] = 0x000065069304939eUL;
   tf->codes[9723] = 0x0000650f7ece74a1UL;
   tf->codes[9724] = 0x0000651954d46cb8UL;
   tf->codes[9725] = 0x00006530a9d0b936UL;
   tf->codes[9726] = 0x0000655b7049f01dUL;
   tf->codes[9727] = 0x0000655c95150cf6UL;
   tf->codes[9728] = 0x000065775872afffUL;
   tf->codes[9729] = 0x0000657fcf1e8578UL;
   tf->codes[9730] = 0x00006588805960b6UL;
   tf->codes[9731] = 0x0000659131943bf4UL;
   tf->codes[9732] = 0x000065ad19bcfbd6UL;
   tf->codes[9733] = 0x000065bb0dd15bc7UL;
   tf->codes[9734] = 0x000065c3847d3140UL;
   tf->codes[9735] = 0x000065d9ef3d66aaUL;
   tf->codes[9736] = 0x00006609be011c7fUL;
   tf->codes[9737] = 0x0000660c07975631UL;
   tf->codes[9738] = 0x0000661cf4ef0123UL;
   tf->codes[9739] = 0x0000663693818753UL;
   tf->codes[9740] = 0x0000664e230cd996UL;
   tf->codes[9741] = 0x000066511c502497UL;
   tf->codes[9742] = 0x000066724752692cUL;
   tf->codes[9743] = 0x0000667f8bb9b7ceUL;
   tf->codes[9744] = 0x000066d5533b2b61UL;
   tf->codes[9745] = 0x000066e8150b047bUL;
   tf->codes[9746] = 0x000066eca83777dfUL;
   tf->codes[9747] = 0x000066f93cf1b532UL;
   tf->codes[9748] = 0x000066ffa49656beUL;
   tf->codes[9749] = 0x00006709057e434bUL;
   tf->codes[9750] = 0x000067181e5dc015UL;
   tf->codes[9751] = 0x0000674b5b82cc75UL;
   tf->codes[9752] = 0x0000674e54c61776UL;
   tf->codes[9753] = 0x0000676693fe7b08UL;
   tf->codes[9754] = 0x000067827c273aeaUL;
   tf->codes[9755] = 0x00006784509f6912UL;
   tf->codes[9756] = 0x0000678a0896f94fUL;
   tf->codes[9757] = 0x0000678ba28021b2UL;
   tf->codes[9758] = 0x000067a78aa8e194UL;
   tf->codes[9759] = 0x000067b8b28f924bUL;
   tf->codes[9760] = 0x000067c0eeac61ffUL;
   tf->codes[9761] = 0x000067c6e132f801UL;
   tf->codes[9762] = 0x000067ca4f944e8cUL;
   tf->codes[9763] = 0x0000681b83e94ebbUL;
   tf->codes[9764] = 0x000068459ab57453UL;
   tf->codes[9765] = 0x00006845d5447a18UL;
   tf->codes[9766] = 0x00006848ce87c519UL;
   tf->codes[9767] = 0x00006869f98a09aeUL;
   tf->codes[9768] = 0x0000687912698678UL;
   tf->codes[9769] = 0x0000687b968ec5efUL;
   tf->codes[9770] = 0x0000687c463bd73eUL;
   tf->codes[9771] = 0x0000689535214c1fUL;
   tf->codes[9772] = 0x0000689cc1910a84UL;
   tf->codes[9773] = 0x0000689ed0983e71UL;
   tf->codes[9774] = 0x000068a9564b47d7UL;
   tf->codes[9775] = 0x000068acff3ba427UL;
   tf->codes[9776] = 0x000068b11d4a0c01UL;
   tf->codes[9777] = 0x000068b9ce84e73fUL;
   tf->codes[9778] = 0x000068c27fbfc27dUL;
   tf->codes[9779] = 0x000068c95c826f93UL;
   tf->codes[9780] = 0x000068dd088e5fc1UL;
   tf->codes[9781] = 0x000068e1269cc79bUL;
   tf->codes[9782] = 0x000068f6e1afebb6UL;
   tf->codes[9783] = 0x000069087eb4a7f7UL;
   tf->codes[9784] = 0x000069280fcdc429UL;
   tf->codes[9785] = 0x0000692d52a748dcUL;
   tf->codes[9786] = 0x0000694b84664270UL;
   tf->codes[9787] = 0x0000696b8a9d6a2cUL;
   tf->codes[9788] = 0x0000696f338dc67cUL;
   tf->codes[9789] = 0x000069947c9e72ebUL;
   tf->codes[9790] = 0x000069c5aabc4b5eUL;
   tf->codes[9791] = 0x000069cb2824d5d6UL;
   tf->codes[9792] = 0x000069d1553a719dUL;
   tf->codes[9793] = 0x000069d4fe2acdedUL;
   tf->codes[9794] = 0x000069daf0b163efUL;
   tf->codes[9795] = 0x000069ff4f85f94aUL;
   tf->codes[9796] = 0x00006a19d854968eUL;
   tf->codes[9797] = 0x00006a28b6a50d93UL;
   tf->codes[9798] = 0x00006a30b832d782UL;
   tf->codes[9799] = 0x00006a3167dfe8d1UL;
   tf->codes[9800] = 0x00006a35fb0c5c35UL;
   tf->codes[9801] = 0x00006a625b6ebb7fUL;
   tf->codes[9802] = 0x00006aa9449fb80dUL;
   tf->codes[9803] = 0x00006ab947bb4bebUL;
   tf->codes[9804] = 0x00006aba31f762ffUL;
   tf->codes[9805] = 0x00006abc40fe96ecUL;
   tf->codes[9806] = 0x00006ac73bcfabdcUL;
   tf->codes[9807] = 0x00006ae114f137d1UL;
   tf->codes[9808] = 0x00006aeaeaf72fe8UL;
   tf->codes[9809] = 0x00006af8a47c8a14UL;
   tf->codes[9810] = 0x00006b0c8b178007UL;
   tf->codes[9811] = 0x00006b3249463800UL;
   tf->codes[9812] = 0x00006b34cd6b7777UL;
   tf->codes[9813] = 0x00006b3ccef94166UL;
   tf->codes[9814] = 0x00006b450b16111aUL;
   tf->codes[9815] = 0x00006b48ee95732fUL;
   tf->codes[9816] = 0x00006b4a887e9b92UL;
   tf->codes[9817] = 0x00006b4b382bace1UL;
   tf->codes[9818] = 0x00006b4c5cf6c9baUL;
   tf->codes[9819] = 0x00006b6720546cc3UL;
   tf->codes[9820] = 0x00006b7464bbbb65UL;
   tf->codes[9821] = 0x00006b77d31d11f0UL;
   tf->codes[9822] = 0x00006b837d9b382fUL;
   tf->codes[9823] = 0x00006b8a5a5de545UL;
   tf->codes[9824] = 0x00006b934627c648UL;
   tf->codes[9825] = 0x00006b9ad29784adUL;
   tf->codes[9826] = 0x00006bab856029daUL;
   tf->codes[9827] = 0x00006bc1b591597fUL;
   tf->codes[9828] = 0x00006bd4ec7f3e23UL;
   tf->codes[9829] = 0x00006bd5d6bb5537UL;
   tf->codes[9830] = 0x00006bdd632b139cUL;
   tf->codes[9831] = 0x00006be8d31a3416UL;
   tf->codes[9832] = 0x00006becb699962bUL;
   tf->codes[9833] = 0x00006c161db8aa74UL;
   tf->codes[9834] = 0x00006c3a41fe3a0aUL;
   tf->codes[9835] = 0x00006c3a7c8d3fcfUL;
   tf->codes[9836] = 0x00006c3e9a9ba7a9UL;
   tf->codes[9837] = 0x00006c56d9d40b3bUL;
   tf->codes[9838] = 0x00006c59236a44edUL;
   tf->codes[9839] = 0x00006c8165be3c5dUL;
   tf->codes[9840] = 0x00006c8c26004b88UL;
   tf->codes[9841] = 0x00006cbf632557e8UL;
   tf->codes[9842] = 0x00006cc1722c8bd5UL;
   tf->codes[9843] = 0x00006cf1f09d52f9UL;
   tf->codes[9844] = 0x00006d017e9adb4dUL;
   tf->codes[9845] = 0x00006d3396f4cad4UL;
   tf->codes[9846] = 0x00006d3cbd4db19cUL;
   tf->codes[9847] = 0x00006d4b26801d17UL;
   tf->codes[9848] = 0x00006d53d7baf855UL;
   tf->codes[9849] = 0x00006d5aef0cab30UL;
   tf->codes[9850] = 0x00006d774c53769cUL;
   tf->codes[9851] = 0x00006d820c9585c7UL;
   tf->codes[9852] = 0x00006d8a83415b40UL;
   tf->codes[9853] = 0x00006dbac7231c9fUL;
   tf->codes[9854] = 0x00006dcdc381fb7eUL;
   tf->codes[9855] = 0x00006df6b583043dUL;
   tf->codes[9856] = 0x00006e17e08548d2UL;
   tf->codes[9857] = 0x00006e1c3922b671UL;
   tf->codes[9858] = 0x00006e2a67c61c27UL;
   tf->codes[9859] = 0x00006e2c3c3e4a4fUL;
   tf->codes[9860] = 0x00006e322ec4e051UL;
   tf->codes[9861] = 0x00006e3562973117UL;
   tf->codes[9862] = 0x00006e468a7de1ceUL;
   tf->codes[9863] = 0x00006e5b5b54eed5UL;
   tf->codes[9864] = 0x00006e6c48ac99c7UL;
   tf->codes[9865] = 0x00006e7200a42a04UL;
   tf->codes[9866] = 0x00006e9749b4d673UL;
   tf->codes[9867] = 0x00006ea99666a403UL;
   tf->codes[9868] = 0x00006eb9d4113da6UL;
   tf->codes[9869] = 0x00006ed790b22bb0UL;
   tf->codes[9870] = 0x00006ef6378f30ceUL;
   tf->codes[9871] = 0x00006f0466329684UL;
   tf->codes[9872] = 0x00006f07d493ed0fUL;
   tf->codes[9873] = 0x00006f23479ea167UL;
   tf->codes[9874] = 0x00006f36f3aa9195UL;
   tf->codes[9875] = 0x00006f3b4c47ff34UL;
   tf->codes[9876] = 0x00006f4856204811UL;
   tf->codes[9877] = 0x00006f576effc4dbUL;
   tf->codes[9878] = 0x00006f5d9c1560a2UL;
   tf->codes[9879] = 0x00006f6d64a1eebbUL;
   tf->codes[9880] = 0x00006f77afc5f25cUL;
   tf->codes[9881] = 0x00006f9d6df4aa55UL;
   tf->codes[9882] = 0x00006fa1c69217f4UL;
   tf->codes[9883] = 0x00006fac11b61b95UL;
   tf->codes[9884] = 0x00006faf80177220UL;
   tf->codes[9885] = 0x00006fcdec657179UL;
   tf->codes[9886] = 0x00006fdffe883944UL;
   tf->codes[9887] = 0x0000701cd72437f6UL;
   tf->codes[9888] = 0x00007022548cc26eUL;
   tf->codes[9889] = 0x000070249e22fc20UL;
   tf->codes[9890] = 0x00007038bf4cf7d8UL;
   tf->codes[9891] = 0x00007047630e6918UL;
   tf->codes[9892] = 0x0000706176befad2UL;
   tf->codes[9893] = 0x0000706a6288dbd5UL;
   tf->codes[9894] = 0x00007078cbbb4750UL;
   tf->codes[9895] = 0x000070943ec5fba8UL;
   tf->codes[9896] = 0x0000709c05c4bfd2UL;
   tf->codes[9897] = 0x000070a90f9d08afUL;
   tf->codes[9898] = 0x000070b14bb9d863UL;
   tf->codes[9899] = 0x000070d86942b2faUL;
   tf->codes[9900] = 0x000070f4516b72dcUL;
   tf->codes[9901] = 0x0000710b3149b3d0UL;
   tf->codes[9902] = 0x0000711074233883UL;
   tf->codes[9903] = 0x0000711541deb1acUL;
   tf->codes[9904] = 0x00007126a4546828UL;
   tf->codes[9905] = 0x00007134234abc8fUL;
   tf->codes[9906] = 0x000071350d86d3a3UL;
   tf->codes[9907] = 0x00007137571d0d55UL;
   tf->codes[9908] = 0x0000714dfc6c4884UL;
   tf->codes[9909] = 0x00007163b77f6c9fUL;
   tf->codes[9910] = 0x00007164a1bb83b3UL;
   tf->codes[9911] = 0x0000719978c9b876UL;
   tf->codes[9912] = 0x000071aebebed107UL;
   tf->codes[9913] = 0x000071f189e165bbUL;
   tf->codes[9914] = 0x00007202b1c81672UL;
   tf->codes[9915] = 0x0000720d377b1fd8UL;
   tf->codes[9916] = 0x00007221cdc3271aUL;
   tf->codes[9917] = 0x00007222f28e43f3UL;
   tf->codes[9918] = 0x00007223a23b5542UL;
   tf->codes[9919] = 0x0000722994c1eb44UL;
   tf->codes[9920] = 0x00007249d58818c5UL;
   tf->codes[9921] = 0x0000725928f69b54UL;
   tf->codes[9922] = 0x000072671d0afb45UL;
   tf->codes[9923] = 0x00007280bb9d8175UL;
   tf->codes[9924] = 0x0000728130bb8cffUL;
   tf->codes[9925] = 0x00007286ae241777UL;
   tf->codes[9926] = 0x0000729a5a3007a5UL;
   tf->codes[9927] = 0x000072b43351939aUL;
   tf->codes[9928] = 0x000072cf6bcd422dUL;
   tf->codes[9929] = 0x000072da669e571dUL;
   tf->codes[9930] = 0x000072daa12d5ce2UL;
   tf->codes[9931] = 0x000072eb8e8507d4UL;
   tf->codes[9932] = 0x000072f39012d1c3UL;
   tf->codes[9933] = 0x000072f6fe74284eUL;
   tf->codes[9934] = 0x000072fa32467914UL;
   tf->codes[9935] = 0x0000730b1f9e2406UL;
   tf->codes[9936] = 0x00007322749a7084UL;
   tf->codes[9937] = 0x00007334119f2cc5UL;
   tf->codes[9938] = 0x000073465e50fa55UL;
   tf->codes[9939] = 0x0000738c5d45dfcfUL;
   tf->codes[9940] = 0x000073c7d687bbe3UL;
   tf->codes[9941] = 0x000073c935e1de81UL;
   tf->codes[9942] = 0x000073e015c01f75UL;
   tf->codes[9943] = 0x000073f8ca168e91UL;
   tf->codes[9944] = 0x0000740056864cf6UL;
   tf->codes[9945] = 0x00007404af23ba95UL;
   tf->codes[9946] = 0x0000742614b504efUL;
   tf->codes[9947] = 0x0000745115bd419bUL;
   tf->codes[9948] = 0x00007474ff73cb6cUL;
   tf->codes[9949] = 0x0000748cc98e2374UL;
   tf->codes[9950] = 0x00007492f6a3bf3bUL;
   tf->codes[9951] = 0x0000749998d7668cUL;
   tf->codes[9952] = 0x000074ba4ebb9f97UL;
   tf->codes[9953] = 0x000074c92d0c169cUL;
   tf->codes[9954] = 0x000074f16f600e0cUL;
   tf->codes[9955] = 0x000074f42e145348UL;
   tf->codes[9956] = 0x000074fa209ae94aUL;
   tf->codes[9957] = 0x0000750889cd54c5UL;
   tf->codes[9958] = 0x000075229d7de67fUL;
   tf->codes[9959] = 0x00007526466e42cfUL;
   tf->codes[9960] = 0x000075322b7b6ed3UL;
   tf->codes[9961] = 0x000075381e0204d5UL;
   tf->codes[9962] = 0x0000757655f82625UL;
   tf->codes[9963] = 0x00007577b55248c3UL;
   tf->codes[9964] = 0x0000757864ff5a12UL;
   tf->codes[9965] = 0x0000757b5e42a513UL;
   tf->codes[9966] = 0x0000758bd67c447bUL;
   tf->codes[9967] = 0x000075bb6ab0f48bUL;
   tf->codes[9968] = 0x000075c49109db53UL;
   tf->codes[9969] = 0x000075dd45604a6fUL;
   tf->codes[9970] = 0x000075e3e793f1c0UL;
   tf->codes[9971] = 0x000075ef5783123aUL;
   tf->codes[9972] = 0x000075f4253e8b63UL;
   tf->codes[9973] = 0x000075fc26cc5552UL;
   tf->codes[9974] = 0x00007608bb8692a5UL;
   tf->codes[9975] = 0x00007637a00e3166UL;
   tf->codes[9976] = 0x0000765646eb3684UL;
   tf->codes[9977] = 0x000076794665a941UL;
   tf->codes[9978] = 0x00007682a74d95ceUL;
   tf->codes[9979] = 0x000076885f45260bUL;
   tf->codes[9980] = 0x0000769394a540c0UL;
   tf->codes[9981] = 0x000076973d959d10UL;
   tf->codes[9982] = 0x000076bb274c26e1UL;
   tf->codes[9983] = 0x000076ce23ab05c0UL;
   tf->codes[9984] = 0x000076ea0bd3c5a2UL;
   tf->codes[9985] = 0x000076f78aca1a09UL;
   tf->codes[9986] = 0x000077087821c4fbUL;
   tf->codes[9987] = 0x0000771be99eaf64UL;
   tf->codes[9988] = 0x0000776815a930a5UL;
   tf->codes[9989] = 0x0000776fdca7f4cfUL;
   tf->codes[9990] = 0x000077ac0596e232UL;
   tf->codes[9991] = 0x000077c9128abeedUL;
   tf->codes[9992] = 0x000077db5f3c8c7dUL;
   tf->codes[9993] = 0x000077dd33b4baa5UL;
   tf->codes[9994] = 0x000077e485957345UL;
   tf->codes[9995] = 0x000077f7bc8357e9UL;
   tf->codes[9996] = 0x0000780e9c6198ddUL;
   tf->codes[9997] = 0x00007835f4797939UL;
   tf->codes[9998] = 0x00007853eba96d08UL;
   tf->codes[9999] = 0x0000785b3d8a25a8UL;
   tf->codes[10000] = 0x000078675d265771UL;
   tf->codes[10001] = 0x00007873f1e094c4UL;
   tf->codes[10002] = 0x0000787c688c6a3dUL;
   tf->codes[10003] = 0x00007895cc8feaa8UL;
   tf->codes[10004] = 0x00007896f15b0781UL;
   tf->codes[10005] = 0x00007897a10818d0UL;
   tf->codes[10006] = 0x000078a6b9e7959aUL;
   tf->codes[10007] = 0x000078c4016a781aUL;
   tf->codes[10008] = 0x000078ca2e8013e1UL;
   tf->codes[10009] = 0x000078cade2d2530UL;
   tf->codes[10010] = 0x000078cb18bc2af5UL;
   tf->codes[10011] = 0x000078f73e8f847aUL;
   tf->codes[10012] = 0x000078fbd1bbf7deUL;
   tf->codes[10013] = 0x00007910dd220aaaUL;
   tf->codes[10014] = 0x0000791d374d4238UL;
   tf->codes[10015] = 0x0000793fc1a9a96bUL;
   tf->codes[10016] = 0x0000795f52c2c59dUL;
   tf->codes[10017] = 0x0000797c25279c93UL;
   tf->codes[10018] = 0x0000798d127f4785UL;
   tf->codes[10019] = 0x000079b4dfb5336bUL;
   tf->codes[10020] = 0x00007a2c81e5fce2UL;
   tf->codes[10021] = 0x00007a332419a433UL;
   tf->codes[10022] = 0x00007a4aee33fc3bUL;
   tf->codes[10023] = 0x00007a9d0cc5137eUL;
   tf->codes[10024] = 0x00007ab302673d5eUL;
   tf->codes[10025] = 0x00007ad3089e651aUL;
   tf->codes[10026] = 0x00007ad9e5611230UL;
   tf->codes[10027] = 0x00007aee7ba91972UL;
   tf->codes[10028] = 0x00007af60818d7d7UL;
   tf->codes[10029] = 0x00007b0bc32bfbf2UL;
   tf->codes[10030] = 0x00007b114094866aUL;
   tf->codes[10031] = 0x00007b13ff48cba6UL;
   tf->codes[10032] = 0x00007b20940308f9UL;
   tf->codes[10033] = 0x00007b2143b01a48UL;
   tf->codes[10034] = 0x00007b2a2f79fb4bUL;
   tf->codes[10035] = 0x00007b4c7f475cb9UL;
   tf->codes[10036] = 0x00007b7571486578UL;
   tf->codes[10037] = 0x00007b7b63cefb7aUL;
   tf->codes[10038] = 0x00007b824091a890UL;
   tf->codes[10039] = 0x00007b8a421f727fUL;
   tf->codes[10040] = 0x00007b95ec9d98beUL;
   tf->codes[10041] = 0x00007ba1d1aac4c2UL;
   tf->codes[10042] = 0x00007bba860133deUL;
   tf->codes[10043] = 0x00007bc7ca688280UL;
   tf->codes[10044] = 0x00007be720f298edUL;
   tf->codes[10045] = 0x00007c0518228cbcUL;
   tf->codes[10046] = 0x00007c0552b19281UL;
   tf->codes[10047] = 0x00007c1b4853bc61UL;
   tf->codes[10048] = 0x00007c3b8919e9e2UL;
   tf->codes[10049] = 0x00007c3d5d92180aUL;
   tf->codes[10050] = 0x00007c4474e3cae5UL;
   tf->codes[10051] = 0x00007c452490dc34UL;
   tf->codes[10052] = 0x00007c4599aee7beUL;
   tf->codes[10053] = 0x00007c538dc347afUL;
   tf->codes[10054] = 0x00007c54b28e6488UL;
   tf->codes[10055] = 0x00007c6f75ec0791UL;
   tf->codes[10056] = 0x00007c814d7fc997UL;
   tf->codes[10057] = 0x00007c8c0dc1d8c2UL;
   tf->codes[10058] = 0x00007c9daac69503UL;
   tf->codes[10059] = 0x00007ca1c8d4fcddUL;
   tf->codes[10060] = 0x00007cbe60aace0eUL;
   tf->codes[10061] = 0x00007cc2099b2a5eUL;
   tf->codes[10062] = 0x00007cca45b7fa12UL;
   tf->codes[10063] = 0x00007ced45326ccfUL;
   tf->codes[10064] = 0x00007cf0ee22c91fUL;
   tf->codes[10065] = 0x00007cf19dcfda6eUL;
   tf->codes[10066] = 0x00007cf3e7661420UL;
   tf->codes[10067] = 0x00007d3bbad327c2UL;
   tf->codes[10068] = 0x00007d59777415ccUL;
   tf->codes[10069] = 0x00007d71b6ac795eUL;
   tf->codes[10070] = 0x00007d97af6a371cUL;
   tf->codes[10071] = 0x00007dbf42111d3dUL;
   tf->codes[10072] = 0x00007dcdab4388b8UL;
   tf->codes[10073] = 0x00007dd746ba7b0aUL;
   tf->codes[10074] = 0x00007df244a723d8UL;
   tf->codes[10075] = 0x00007e12fa8b5ce3UL;
   tf->codes[10076] = 0x00007e1b36a82c97UL;
   tf->codes[10077] = 0x00007e250cae24aeUL;
   tf->codes[10078] = 0x00007e39a2f62bf0UL;
   tf->codes[10079] = 0x00007e4c9f550acfUL;
   tf->codes[10080] = 0x00007e534188b220UL;
   tf->codes[10081] = 0x00007e679d41b39dUL;
   tf->codes[10082] = 0x00007e6bbb501b77UL;
   tf->codes[10083] = 0x00007e885325eca8UL;
   tf->codes[10084] = 0x00007e8902d2fdf7UL;
   tf->codes[10085] = 0x00007e981bb27ac1UL;
   tf->codes[10086] = 0x00007eb10a97efa2UL;
   tf->codes[10087] = 0x00007eb22f630c7bUL;
   tf->codes[10088] = 0x00007eb2a4811805UL;
   tf->codes[10089] = 0x00007ed31fd64b4bUL;
   tf->codes[10090] = 0x00007ed82820ca39UL;
   tf->codes[10091] = 0x00007ee40d2df63dUL;
   tf->codes[10092] = 0x00007ef918940909UL;
   tf->codes[10093] = 0x00007f20361ce3a0UL;
   tf->codes[10094] = 0x00007f253e67628eUL;
   tf->codes[10095] = 0x00007f48b2ffe0d5UL;
   tf->codes[10096] = 0x00007f7254adfae3UL;
   tf->codes[10097] = 0x00007f79a68eb383UL;
   tf->codes[10098] = 0x00007f87258507eaUL;
   tf->codes[10099] = 0x00007fa6b69e241cUL;
   tf->codes[10100] = 0x00007fb853a2e05dUL;
   tf->codes[10101] = 0x00007fcb5001bf3cUL;
   tf->codes[10102] = 0x00007fe59e4156bbUL;
   tf->codes[10103] = 0x00007fe6fd9b7959UL;
   tf->codes[10104] = 0x00007fecb5930996UL;
   tf->codes[10105] = 0x00007ff825822a10UL;
   tf->codes[10106] = 0x00008001866a169dUL;
   tf->codes[10107] = 0x0000801b5f8ba292UL;
   tf->codes[10108] = 0x0000802b62a73670UL;
   tf->codes[10109] = 0x0000802ff5d3a9d4UL;
   tf->codes[10110] = 0x0000803f0eb3269eUL;
   tf->codes[10111] = 0x00008044518cab51UL;
   tf->codes[10112] = 0x0000804a44134153UL;
   tf->codes[10113] = 0x0000804fc17bcbcbUL;
   tf->codes[10114] = 0x0000807c5c6d30daUL;
   tf->codes[10115] = 0x0000807fcace8765UL;
   tf->codes[10116] = 0x0000808ac59f9c55UL;
   tf->codes[10117] = 0x000080b9aa273b16UL;
   tf->codes[10118] = 0x000080bd53179766UL;
   tf->codes[10119] = 0x000080e5956b8ed6UL;
   tf->codes[10120] = 0x000080f5d3162879UL;
   tf->codes[10121] = 0x00008103520c7ce0UL;
   tf->codes[10122] = 0x0000811529a03ee6UL;
   tf->codes[10123] = 0x0000813c4729197dUL;
   tf->codes[10124] = 0x0000814a3b3d796eUL;
   tf->codes[10125] = 0x0000815b28952460UL;
   tf->codes[10126] = 0x0000816ba0cec3c8UL;
   tf->codes[10127] = 0x0000818f8a854d99UL;
   tf->codes[10128] = 0x00008195b79ae960UL;
   tf->codes[10129] = 0x0000819abfe5684eUL;
   tf->codes[10130] = 0x0000819c1f3f8aecUL;
   tf->codes[10131] = 0x000081a162190f9fUL;
   tf->codes[10132] = 0x000081d75df2613bUL;
   tf->codes[10133] = 0x000081d96cf99528UL;
   tf->codes[10134] = 0x000081e1a91664dcUL;
   tf->codes[10135] = 0x0000821ebc416953UL;
   tf->codes[10136] = 0x0000821ef6d06f18UL;
   tf->codes[10137] = 0x0000824564ac3860UL;
   tf->codes[10138] = 0x000082547d8bb52aUL;
   tf->codes[10139] = 0x00008254b81abaefUL;
   tf->codes[10140] = 0x00008264f5c55492UL;
   tf->codes[10141] = 0x0000826cf7531e81UL;
   tf->codes[10142] = 0x00008273d415cb97UL;
   tf->codes[10143] = 0x0000829205d4c52bUL;
   tf->codes[10144] = 0x0000829cc616d456UL;
   tf->codes[10145] = 0x000082ba4828bc9bUL;
   tf->codes[10146] = 0x000082d78fab9f1bUL;
   tf->codes[10147] = 0x000082de6c6e4c31UL;
   tf->codes[10148] = 0x0000830a57b29ff1UL;
   tf->codes[10149] = 0x0000830a9241a5b6UL;
   tf->codes[10150] = 0x0000830bb70cc28fUL;
   tf->codes[10151] = 0x00008312594069e0UL;
   tf->codes[10152] = 0x00008328fe8fa50fUL;
   tf->codes[10153] = 0x0000833ce52a9b02UL;
   tf->codes[10154] = 0x00008342d7b13104UL;
   tf->codes[10155] = 0x000083594271666eUL;
   tf->codes[10156] = 0x0000835bc696a5e5UL;
   tf->codes[10157] = 0x0000837da145fbc9UL;
   tf->codes[10158] = 0x000083826f0174f2UL;
   tf->codes[10159] = 0x00008389fb713357UL;
   tf->codes[10160] = 0x0000838d69d289e2UL;
   tf->codes[10161] = 0x00008392e73b145aUL;
   tf->codes[10162] = 0x000083a2afc7a273UL;
   tf->codes[10163] = 0x000083a9c719554eUL;
   tf->codes[10164] = 0x000083bcfe0739f2UL;
   tf->codes[10165] = 0x000083c156a4a791UL;
   tf->codes[10166] = 0x000083e9d387a4c6UL;
   tf->codes[10167] = 0x000083eccccaefc7UL;
   tf->codes[10168] = 0x0000844b45873e98UL;
   tf->codes[10169] = 0x0000844fd8b3b1fcUL;
   tf->codes[10170] = 0x00008459399b9e89UL;
   tf->codes[10171] = 0x00008466b891f2f0UL;
   tf->codes[10172] = 0x00008474aca652e1UL;
   tf->codes[10173] = 0x000084755c536430UL;
   tf->codes[10174] = 0x0000847ce8c32295UL;
   tf->codes[10175] = 0x000084843aa3db35UL;
   tf->codes[10176] = 0x000084c1fd7bf0fbUL;
   tf->codes[10177] = 0x0000850fc36f9a9fUL;
   tf->codes[10178] = 0x00008510731cabeeUL;
   tf->codes[10179] = 0x000085554d46748fUL;
   tf->codes[10180] = 0x0000855930c5d6a4UL;
   tf->codes[10181] = 0x000085a05485d8f7UL;
   tf->codes[10182] = 0x000085a85613a2e6UL;
   tf->codes[10183] = 0x000085f4bcad29ecUL;
   tf->codes[10184] = 0x0000861b2a88f334UL;
   tf->codes[10185] = 0x0000862c8cfea9b0UL;
   tf->codes[10186] = 0x0000865c213359c0UL;
   tf->codes[10187] = 0x0000865f1a76a4c1UL;
   tf->codes[10188] = 0x0000867a52f25354UL;
   tf->codes[10189] = 0x0000867f5b3cd242UL;
   tf->codes[10190] = 0x0000868b05baf881UL;
   tf->codes[10191] = 0x000086a5c9189b8aUL;
   tf->codes[10192] = 0x000086abbb9f318cUL;
   tf->codes[10193] = 0x000086dd244c0fc4UL;
   tf->codes[10194] = 0x000086df335343b1UL;
   tf->codes[10195] = 0x000086e1f20788edUL;
   tf->codes[10196] = 0x000086e4eb4ad3eeUL;
   tf->codes[10197] = 0x000086e81f1d24b4UL;
   tf->codes[10198] = 0x0000871d30ba5f3cUL;
   tf->codes[10199] = 0x000087339b7a94a6UL;
   tf->codes[10200] = 0x0000874d3a0d1ad6UL;
   tf->codes[10201] = 0x00008765042772deUL;
   tf->codes[10202] = 0x000087653eb678a3UL;
   tf->codes[10203] = 0x0000877c93b2c521UL;
   tf->codes[10204] = 0x00008785ba0babe9UL;
   tf->codes[10205] = 0x000087b49e934aaaUL;
   tf->codes[10206] = 0x000087b7d2659b70UL;
   tf->codes[10207] = 0x000087da5cc202a3UL;
   tf->codes[10208] = 0x000087e3831ae96bUL;
   tf->codes[10209] = 0x000087e7a1295145UL;
   tf->codes[10210] = 0x000087f102113dd2UL;
   tf->codes[10211] = 0x000087f4ab019a22UL;
   tf->codes[10212] = 0x000087f978bd134bUL;
   tf->codes[10213] = 0x000088031434059dUL;
   tf->codes[10214] = 0x0000881b8dfb6ef4UL;
   tf->codes[10215] = 0x0000882613ae785aUL;
   tf->codes[10216] = 0x0000882897d3b7d1UL;
   tf->codes[10217] = 0x0000882cb5e21fabUL;
   tf->codes[10218] = 0x00008846c992b165UL;
   tf->codes[10219] = 0x0000889454f75544UL;
   tf->codes[10220] = 0x0000889b31ba025aUL;
   tf->codes[10221] = 0x0000889fff757b83UL;
   tf->codes[10222] = 0x000088a0e9b19297UL;
   tf->codes[10223] = 0x000088a925ce624bUL;
   tf->codes[10224] = 0x000088ac1f11ad4cUL;
   tf->codes[10225] = 0x000088e3ef632d10UL;
   tf->codes[10226] = 0x000088f885ab3452UL;
   tf->codes[10227] = 0x0000892f6bc09d02UL;
   tf->codes[10228] = 0x0000894820170c1eUL;
   tf->codes[10229] = 0x000089547a4243acUL;
   tf->codes[10230] = 0x0000895e15b935feUL;
   tf->codes[10231] = 0x0000897445ea65a3UL;
   tf->codes[10232] = 0x000089918d6d4823UL;
   tf->codes[10233] = 0x000089941192879aUL;
   tf->codes[10234] = 0x000089aa41c3b73fUL;
   tf->codes[10235] = 0x000089b32d8d9842UL;
   tf->codes[10236] = 0x000089c87382b0d3UL;
   tf->codes[10237] = 0x000089e71a5fb5f1UL;
   tf->codes[10238] = 0x00008a22ce3097caUL;
   tf->codes[10239] = 0x00008a4bfac0a64eUL;
   tf->codes[10240] = 0x00008a7efd56ace9UL;
   tf->codes[10241] = 0x00008a952d87dc8eUL;
   tf->codes[10242] = 0x00008a994b964468UL;
   tf->codes[10243] = 0x00008aa187b3141cUL;
   tf->codes[10244] = 0x00008aa7ef57b5a8UL;
   tf->codes[10245] = 0x00008aa8d993ccbcUL;
   tf->codes[10246] = 0x00008abfb9720db0UL;
   tf->codes[10247] = 0x00008ac4fc4b9263UL;
   tf->codes[10248] = 0x00008aea7feb4497UL;
   tf->codes[10249] = 0x00008b43b5ce0eb5UL;
   tf->codes[10250] = 0x00008b60c2c1eb70UL;
   tf->codes[10251] = 0x00008b9cebb0d8d3UL;
   tf->codes[10252] = 0x00008bb231a5f164UL;
   tf->codes[10253] = 0x00008bd397373bbeUL;
   tf->codes[10254] = 0x00008bd61b5c7b35UL;
   tf->codes[10255] = 0x00008be7b8613776UL;
   tf->codes[10256] = 0x00008becfb3abc29UL;
   tf->codes[10257] = 0x00008bfb646d27a4UL;
   tf->codes[10258] = 0x00008bfe23216ce0UL;
   tf->codes[10259] = 0x00008c065f3e3c94UL;
   tf->codes[10260] = 0x00008c2331a3138aUL;
   tf->codes[10261] = 0x00008c274fb17b64UL;
   tf->codes[10262] = 0x00008c51a10ca6c1UL;
   tf->codes[10263] = 0x00008c5f952106b2UL;
   tf->codes[10264] = 0x00008c7515a52508UL;
   tf->codes[10265] = 0x00008c79e3609e31UL;
   tf->codes[10266] = 0x00008cc6f9a73686UL;
   tf->codes[10267] = 0x00008ccb5244a425UL;
   tf->codes[10268] = 0x00008cd7e6fee178UL;
   tf->codes[10269] = 0x00008ce05daab6f1UL;
   tf->codes[10270] = 0x00008d17b8de2b2bUL;
   tf->codes[10271] = 0x00008d1952c7538eUL;
   tf->codes[10272] = 0x00008d1b61ce877bUL;
   tf->codes[10273] = 0x00008d1cfbb7afdeUL;
   tf->codes[10274] = 0x00008d20a4a80c2eUL;
   tf->codes[10275] = 0x00008d2fbd8788f8UL;
   tf->codes[10276] = 0x00008d837601c89eUL;
   tf->codes[10277] = 0x00008d8759812ab3UL;
   tf->codes[10278] = 0x00008dacdd20dce7UL;
   tf->codes[10279] = 0x00008db3f4728fc2UL;
   tf->codes[10280] = 0x00008de438545121UL;
   tf->codes[10281] = 0x00008dece98f2c5fUL;
   tf->codes[10282] = 0x00008dfcb21bba78UL;
   tf->codes[10283] = 0x00008e0737cec3deUL;
   tf->codes[10284] = 0x00008e0a6ba114a4UL;
   tf->codes[10285] = 0x00008e0e149170f4UL;
   tf->codes[10286] = 0x00008e1098b6b06bUL;
   tf->codes[10287] = 0x00008e12329fd8ceUL;
   tf->codes[10288] = 0x00008e152be323cfUL;
   tf->codes[10289] = 0x00008e185fb57495UL;
   tf->codes[10290] = 0x00008e1b58f8bf96UL;
   tf->codes[10291] = 0x00008e1da28ef948UL;
   tf->codes[10292] = 0x00008e4b624b7b30UL;
   tf->codes[10293] = 0x00008e53294a3f5aUL;
   tf->codes[10294] = 0x00008e9370479497UL;
   tf->codes[10295] = 0x00008e98037407fbUL;
   tf->codes[10296] = 0x00008eabaf7ff829UL;
   tf->codes[10297] = 0x00008ec797a8b80bUL;
   tf->codes[10298] = 0x00008eead1b2308dUL;
   tf->codes[10299] = 0x00008f0853c418d2UL;
   tf->codes[10300] = 0x00008f105551e2c1UL;
   tf->codes[10301] = 0x00008f36c32dac09UL;
   tf->codes[10302] = 0x00008f3897a5da31UL;
   tf->codes[10303] = 0x00008f3c40963681UL;
   tf->codes[10304] = 0x00008f57b3a0ead9UL;
   tf->codes[10305] = 0x00008f69c5c3b2a4UL;
   tf->codes[10306] = 0x00008f6a7570c3f3UL;
   tf->codes[10307] = 0x00008f8cffcd2b26UL;
   tf->codes[10308] = 0x00008f957679009fUL;
   tf->codes[10309] = 0x00008fa1d0a4382dUL;
   tf->codes[10310] = 0x00008faaf6fd1ef5UL;
   tf->codes[10311] = 0x00008fcb7252523bUL;
   tf->codes[10312] = 0x000090179e5cd37cUL;
   tf->codes[10313] = 0x0000901fda79a330UL;
   tf->codes[10314] = 0x000090313cef59acUL;
   tf->codes[10315] = 0x00009044e8fb49daUL;
   tf->codes[10316] = 0x0000904598a85b29UL;
   tf->codes[10317] = 0x000090590a254592UL;
   tf->codes[10318] = 0x0000907bcf10b28aUL;
   tf->codes[10319] = 0x000090873effd304UL;
   tf->codes[10320] = 0x00009087798ed8c9UL;
   tf->codes[10321] = 0x000090894e0706f1UL;
   tf->codes[10322] = 0x0000908c474a51f2UL;
   tf->codes[10323] = 0x000090a0dd925934UL;
   tf->codes[10324] = 0x000090a7ba55064aUL;
   tf->codes[10325] = 0x000090af46c4c4afUL;
   tf->codes[10326] = 0x000090bd004a1edbUL;
   tf->codes[10327] = 0x000090cbde9a95e0UL;
   tf->codes[10328] = 0x000090dabceb0ce5UL;
   tf->codes[10329] = 0x000090f545b9aa29UL;
   tf->codes[10330] = 0x00009107926b77b9UL;
   tf->codes[10331] = 0x0000910beb08e558UL;
   tf->codes[10332] = 0x00009114d6d2c65bUL;
   tf->codes[10333] = 0x0000911845341ce6UL;
   tf->codes[10334] = 0x0000913049dd7ab3UL;
   tf->codes[10335] = 0x0000913b7f3d9568UL;
   tf->codes[10336] = 0x000091404cf90e91UL;
   tf->codes[10337] = 0x000091576766554aUL;
   tf->codes[10338] = 0x000091776d9d7d06UL;
   tf->codes[10339] = 0x000091838d39aecfUL;
   tf->codes[10340] = 0x000091a5a2780a78UL;
   tf->codes[10341] = 0x000091acb9c9bd53UL;
   tf->codes[10342] = 0x000091b94e83faa6UL;
   tf->codes[10343] = 0x000091cc4ae2d985UL;
   tf->codes[10344] = 0x000091db9e515c14UL;
   tf->codes[10345] = 0x000091f50254dc7fUL;
   tf->codes[10346] = 0x0000921458def2ecUL;
   tf->codes[10347] = 0x0000923842957cbdUL;
   tf->codes[10348] = 0x0000923dbffe0735UL;
   tf->codes[10349] = 0x00009253f02f36daUL;
   tf->codes[10350] = 0x0000925accf1e3f0UL;
   tf->codes[10351] = 0x00009266ec8e15b9UL;
   tf->codes[10352] = 0x00009283bef2ecafUL;
   tf->codes[10353] = 0x0000928901cc7162UL;
   tf->codes[10354] = 0x000092a7a8a97680UL;
   tf->codes[10355] = 0x000092b5279fcae7UL;
   tf->codes[10356] = 0x000092dc7fb7ab43UL;
   tf->codes[10357] = 0x000092ede22d61bfUL;
   tf->codes[10358] = 0x000092f4f97f149aUL;
   tf->codes[10359] = 0x000092fd359be44eUL;
   tf->codes[10360] = 0x0000931833888d1cUL;
   tf->codes[10361] = 0x000093269cbaf897UL;
   tf->codes[10362] = 0x00009348b1f95440UL;
   tf->codes[10363] = 0x000093499c356b54UL;
   tf->codes[10364] = 0x0000935964c1f96dUL;
   tf->codes[10365] = 0x0000935a146f0abcUL;
   tf->codes[10366] = 0x0000936a5219a45fUL;
   tf->codes[10367] = 0x0000936d10cde99bUL;
   tf->codes[10368] = 0x000093758779bf14UL;
   tf->codes[10369] = 0x00009378f5db159fUL;
   tf->codes[10370] = 0x000093e8967e1527UL;
   tf->codes[10371] = 0x000094002609676aUL;
   tf->codes[10372] = 0x000094086226371eUL;
   tf->codes[10373] = 0x00009419ff2af35fUL;
   tf->codes[10374] = 0x0000941c835032d6UL;
   tf->codes[10375] = 0x0000943a05621b1bUL;
   tf->codes[10376] = 0x0000943b9f4b437eUL;
   tf->codes[10377] = 0x0000945c552f7c89UL;
   tf->codes[10378] = 0x00009467ffada2c8UL;
   tf->codes[10379] = 0x00009473350dbd7dUL;
   tf->codes[10380] = 0x0000947babb992f6UL;
   tf->codes[10381] = 0x0000949b0243a963UL;
   tf->codes[10382] = 0x000094aee8de9f56UL;
   tf->codes[10383] = 0x000094ea9caf812fUL;
   tf->codes[10384] = 0x000095382814250eUL;
   tf->codes[10385] = 0x00009542e8563439UL;
   tf->codes[10386] = 0x0000954706649c13UL;
   tf->codes[10387] = 0x00009559531669a3UL;
   tf->codes[10388] = 0x000095791ebe8b9aUL;
   tf->codes[10389] = 0x000095a7190a1347UL;
   tf->codes[10390] = 0x000095d8bc45f744UL;
   tf->codes[10391] = 0x000096067c02792cUL;
   tf->codes[10392] = 0x000096113c448857UL;
   tf->codes[10393] = 0x0000961bc1f791bdUL;
   tf->codes[10394] = 0x00009630583f98ffUL;
   tf->codes[10395] = 0x0000968201b2a4b8UL;
   tf->codes[10396] = 0x0000968cc1f4b3e3UL;
   tf->codes[10397] = 0x000096a8e4ac798aUL;
   tf->codes[10398] = 0x000096d8b3702f5fUL;
   tf->codes[10399] = 0x000096fc9d26b930UL;
   tf->codes[10400] = 0x0000970429967795UL;
   tf->codes[10401] = 0x0000971676484525UL;
   tf->codes[10402] = 0x00009720c16c48c6UL;
   tf->codes[10403] = 0x0000972f652dba06UL;
   tf->codes[10404] = 0x00009769f4337f06UL;
   tf->codes[10405] = 0x000097738faa7158UL;
   tf->codes[10406] = 0x0000979b976f6303UL;
   tf->codes[10407] = 0x000097c7bd42bc88UL;
   tf->codes[10408] = 0x000097cf49b27aedUL;
   tf->codes[10409] = 0x000097d4c71b0565UL;
   tf->codes[10410] = 0x000097ebe1884c1eUL;
   tf->codes[10411] = 0x000097f492c3275cUL;
   tf->codes[10412] = 0x000097f876428971UL;
   tf->codes[10413] = 0x000098187c79b12dUL;
   tf->codes[10414] = 0x0000982969d15c1fUL;
   tf->codes[10415] = 0x00009853bb2c877cUL;
   tf->codes[10416] = 0x00009854304a9306UL;
   tf->codes[10417] = 0x00009872277a86d5UL;
   tf->codes[10418] = 0x0000987b134467d8UL;
   tf->codes[10419] = 0x000098a47a637c21UL;
   tf->codes[10420] = 0x000098bc09eece64UL;
   tf->codes[10421] = 0x000098e202ac8c22UL;
   tf->codes[10422] = 0x000098e695d8ff86UL;
   tf->codes[10423] = 0x0000990bdee9abf5UL;
   tf->codes[10424] = 0x000099207531b337UL;
   tf->codes[10425] = 0x0000994d854123d0UL;
   tf->codes[10426] = 0x000099a0537f4c62UL;
   tf->codes[10427] = 0x000099b7a87b98e0UL;
   tf->codes[10428] = 0x000099c477c4dbf8UL;
   tf->codes[10429] = 0x000099d85e5fd1ebUL;
   tf->codes[10430] = 0x000099e617e52c17UL;
   tf->codes[10431] = 0x000099fb234b3ee3UL;
   tf->codes[10432] = 0x00009a45b56c97c1UL;
   tf->codes[10433] = 0x00009a5d0a68e43fUL;
   tf->codes[10434] = 0x00009a687a5804b9UL;
   tf->codes[10435] = 0x00009a6b739b4fbaUL;
   tf->codes[10436] = 0x00009a7549a147d1UL;
   tf->codes[10437] = 0x00009a787d739897UL;
   tf->codes[10438] = 0x00009a792d20a9e6UL;
   tf->codes[10439] = 0x00009aa63d301a7fUL;
   tf->codes[10440] = 0x00009aa761fb3758UL;
   tf->codes[10441] = 0x00009aabf527aabcUL;
   tf->codes[10442] = 0x00009ab605bca898UL;
   tf->codes[10443] = 0x00009ac050e0ac39UL;
   tf->codes[10444] = 0x00009ae14153eb09UL;
   tf->codes[10445] = 0x00009b21fd6f4bd0UL;
   tf->codes[10446] = 0x00009b3659284d4dUL;
   tf->codes[10447] = 0x00009b3f0a63288bUL;
   tf->codes[10448] = 0x00009b42ede28aa0UL;
   tf->codes[10449] = 0x00009b4a7a524905UL;
   tf->codes[10450] = 0x00009b5958a2c00aUL;
   tf->codes[10451] = 0x00009b6f4e44e9eaUL;
   tf->codes[10452] = 0x00009b783a0ecaedUL;
   tf->codes[10453] = 0x00009b93728a7980UL;
   tf->codes[10454] = 0x00009b94d1e49c1eUL;
   tf->codes[10455] = 0x00009b96a65cca46UL;
   tf->codes[10456] = 0x00009ba1dbbce4fbUL;
   tf->codes[10457] = 0x00009bc00d7bde8fUL;
   tf->codes[10458] = 0x00009bc3b66c3adfUL;
   tf->codes[10459] = 0x00009bc6ea3e8ba5UL;
   tf->codes[10460] = 0x00009bed1d8b4f28UL;
   tf->codes[10461] = 0x00009c2687c5f74fUL;
   tf->codes[10462] = 0x00009c39f942e1b8UL;
   tf->codes[10463] = 0x00009c42e50cc2bbUL;
   tf->codes[10464] = 0x00009c602c8fa53bUL;
   tf->codes[10465] = 0x00009c7831390308UL;
   tf->codes[10466] = 0x00009c7b9f9a5993UL;
   tf->codes[10467] = 0x00009c853b114be5UL;
   tf->codes[10468] = 0x00009c920a5a8efdUL;
   tf->codes[10469] = 0x00009cc75686cf4aUL;
   tf->codes[10470] = 0x00009ce219e47253UL;
   tf->codes[10471] = 0x00009d2bfc58b9e2UL;
   tf->codes[10472] = 0x00009d48599f854eUL;
   tf->codes[10473] = 0x00009d85e1e8954fUL;
   tf->codes[10474] = 0x00009d90dcb9aa3fUL;
   tf->codes[10475] = 0x00009d9cfc55dc08UL;
   tf->codes[10476] = 0x00009da9cb9f1f20UL;
   tf->codes[10477] = 0x00009dc1209b6b9eUL;
   tf->codes[10478] = 0x00009dc5b3c7df02UL;
   tf->codes[10479] = 0x00009dd248821c55UL;
   tf->codes[10480] = 0x00009dd3e26b44b8UL;
   tf->codes[10481] = 0x00009dd6a11f89f4UL;
   tf->codes[10482] = 0x00009df1647d2cfdUL;
   tf->codes[10483] = 0x00009df8b65de59dUL;
   tf->codes[10484] = 0x00009df9660af6ecUL;
   tf->codes[10485] = 0x00009dff1e028729UL;
   tf->codes[10486] = 0x00009e14296899f5UL;
   tf->codes[10487] = 0x00009e25514f4aacUL;
   tf->codes[10488] = 0x00009e3f2a70d6a1UL;
   tf->codes[10489] = 0x00009e4174071053UL;
   tf->codes[10490] = 0x00009e567f6d231fUL;
   tf->codes[10491] = 0x00009e634eb66637UL;
   tf->codes[10492] = 0x00009ebfb86b811bUL;
   tf->codes[10493] = 0x00009ec23c90c092UL;
   tf->codes[10494] = 0x00009edba09440fdUL;
   tf->codes[10495] = 0x00009eddea2a7aafUL;
   tf->codes[10496] = 0x00009ee2b7e5f3d8UL;
   tf->codes[10497] = 0x00009eff4fbbc509UL;
   tf->codes[10498] = 0x00009f199dfb5c88UL;
   tf->codes[10499] = 0x00009f35fb4227f4UL;
   tf->codes[10500] = 0x00009f3c2857c3bbUL;
   tf->codes[10501] = 0x00009f479846e435UL;
   tf->codes[10502] = 0x00009f51a8dbe211UL;
   tf->codes[10503] = 0x00009fb56471b595UL;
   tf->codes[10504] = 0x00009fb8d2d30c20UL;
   tf->codes[10505] = 0x00009fc94b0cab88UL;
   tf->codes[10506] = 0x00009fd4bafbcc02UL;
   tf->codes[10507] = 0x00009fdcf7189bb6UL;
   tf->codes[10508] = 0x00009ffab3b989c0UL;
   tf->codes[10509] = 0x0000a062183fb994UL;
   tf->codes[10510] = 0x0000a06c28d4b770UL;
   tf->codes[10511] = 0x0000a0b5d0b9f93aUL;
   tf->codes[10512] = 0x0000a0c94236e3a3UL;
   tf->codes[10513] = 0x0000a0ccb0983a2eUL;
   tf->codes[10514] = 0x0000a0e390767b22UL;
   tf->codes[10515] = 0x0000a0efb012acebUL;
   tf->codes[10516] = 0x0000a0fa7054bc16UL;
   tf->codes[10517] = 0x0000a110a085ebbbUL;
   tf->codes[10518] = 0x0000a122b2a8b386UL;
   tf->codes[10519] = 0x0000a13240a63bdaUL;
   tf->codes[10520] = 0x0000a14aba6da531UL;
   tf->codes[10521] = 0x0000a14c19c7c7cfUL;
   tf->codes[10522] = 0x0000a1733750a266UL;
   tf->codes[10523] = 0x0000a191a39ea1bfUL;
   tf->codes[10524] = 0x0000a19c2951ab25UL;
   tf->codes[10525] = 0x0000a1e8555c2c66UL;
   tf->codes[10526] = 0x0000a1eb4e9f7767UL;
   tf->codes[10527] = 0x0000a20318b9cf6fUL;
   tf->codes[10528] = 0x0000a2047813f20dUL;
   tf->codes[10529] = 0x0000a21390f36ed7UL;
   tf->codes[10530] = 0x0000a216c4c5bf9dUL;
   tf->codes[10531] = 0x0000a21fb08fa0a0UL;
   tf->codes[10532] = 0x0000a22c0abad82eUL;
   tf->codes[10533] = 0x0000a230635845cdUL;
   tf->codes[10534] = 0x0000a2314d945ce1UL;
   tf->codes[10535] = 0x0000a2377aa9f8a8UL;
   tf->codes[10536] = 0x0000a2391493210bUL;
   tf->codes[10537] = 0x0000a24917aeb4e9UL;
   tf->codes[10538] = 0x0000a24a01eacbfdUL;
   tf->codes[10539] = 0x0000a26f858a7e31UL;
   tf->codes[10540] = 0x0000a27db42de3e7UL;
   tf->codes[10541] = 0x0000a28be2d1499dUL;
   tf->codes[10542] = 0x0000a2a2882084ccUL;
   tf->codes[10543] = 0x0000a2a3e77aa76aUL;
   tf->codes[10544] = 0x0000a2aee24bbc5aUL;
   tf->codes[10545] = 0x0000a2b66ebb7abfUL;
   tf->codes[10546] = 0x0000a2c9a5a95f63UL;
   tf->codes[10547] = 0x0000a2cc29ce9edaUL;
   tf->codes[10548] = 0x0000a2e1aa52bd30UL;
   tf->codes[10549] = 0x0000a2f7da83ecd5UL;
   tf->codes[10550] = 0x0000a30b4c00d73eUL;
   tf->codes[10551] = 0x0000a3310a2f8f37UL;
   tf->codes[10552] = 0x0000a33a308875ffUL;
   tf->codes[10553] = 0x0000a3431c525702UL;
   tf->codes[10554] = 0x0000a34a33a409ddUL;
   tf->codes[10555] = 0x0000a34c42ab3dcaUL;
   tf->codes[10556] = 0x0000a34cb7c94954UL;
   tf->codes[10557] = 0x0000a39a432ded33UL;
   tf->codes[10558] = 0x0000a3bc586c48dcUL;
   tf->codes[10559] = 0x0000a3c802ea6f1bUL;
   tf->codes[10560] = 0x0000a3dc5ea37098UL;
   tf->codes[10561] = 0x0000a3e460313a87UL;
   tf->codes[10562] = 0x0000a3f9e0b558ddUL;
   tf->codes[10563] = 0x0000a40bb8491ae3UL;
   tf->codes[10564] = 0x0000a41762c74122UL;
   tf->codes[10565] = 0x0000a4179d5646e7UL;
   tf->codes[10566] = 0x0000a43051acb603UL;
   tf->codes[10567] = 0x0000a434aa4a23a2UL;
   tf->codes[10568] = 0x0000a43818ab7a2dUL;
   tf->codes[10569] = 0x0000a43b4c7dcaf3UL;
   tf->codes[10570] = 0x0000a4b154c56c07UL;
   tf->codes[10571] = 0x0000a4ca091bdb23UL;
   tf->codes[10572] = 0x0000a4cfc1136b60UL;
   tf->codes[10573] = 0x0000a4e0ae6b1652UL;
   tf->codes[10574] = 0x0000a4ebe3cb3107UL;
   tf->codes[10575] = 0x0000a4ed432553a5UL;
   tf->codes[10576] = 0x0000a5092b4e1387UL;
   tf->codes[10577] = 0x0000a539a9bedaabUL;
   tf->codes[10578] = 0x0000a54ad1a58b62UL;
   tf->codes[10579] = 0x0000a5755d8fbc84UL;
   tf->codes[10580] = 0x0000a5797b9e245eUL;
   tf->codes[10581] = 0x0000a58b18a2e09fUL;
   tf->codes[10582] = 0x0000a5a407885580UL;
   tf->codes[10583] = 0x0000a5a9fa0eeb82UL;
   tf->codes[10584] = 0x0000a5b40aa3e95eUL;
   tf->codes[10585] = 0x0000a5d2ec0ff441UL;
   tf->codes[10586] = 0x0000a5e0307742e3UL;
   tf->codes[10587] = 0x0000a5f626196cc3UL;
   tf->codes[10588] = 0x0000a606293500a1UL;
   tf->codes[10589] = 0x0000a622867bcc0dUL;
   tf->codes[10590] = 0x0000a62545301149UL;
   tf->codes[10591] = 0x0000a63b756140eeUL;
   tf->codes[10592] = 0x0000a6449bba27b6UL;
   tf->codes[10593] = 0x0000a6475a6e6cf2UL;
   tf->codes[10594] = 0x0000a649de93ac69UL;
   tf->codes[10595] = 0x0000a670c18d813bUL;
   tf->codes[10596] = 0x0000a697a487560dUL;
   tf->codes[10597] = 0x0000a6a439419360UL;
   tf->codes[10598] = 0x0000a6f1c4a6373fUL;
   tf->codes[10599] = 0x0000a70a3e6da096UL;
   tf->codes[10600] = 0x0000a71573cdbb4bUL;
   tf->codes[10601] = 0x0000a71e5f979c4eUL;
   tf->codes[10602] = 0x0000a724c73c3ddaUL;
   tf->codes[10603] = 0x0000a725ec075ab3UL;
   tf->codes[10604] = 0x0000a72c8e3b0204UL;
   tf->codes[10605] = 0x0000a737c39b1cb9UL;
   tf->codes[10606] = 0x0000a74074d5f7f7UL;
   tf->codes[10607] = 0x0000a743a8a848bdUL;
   tf->codes[10608] = 0x0000a77ac94cb732UL;
   tf->codes[10609] = 0x0000a77dc2900233UL;
   tf->codes[10610] = 0x0000a790beeee112UL;
   tf->codes[10611] = 0x0000a7ab824c841bUL;
   tf->codes[10612] = 0x0000a7b67d1d990bUL;
   tf->codes[10613] = 0x0000a7b6f23ba495UL;
   tf->codes[10614] = 0x0000a7eaa47ebc7fUL;
   tf->codes[10615] = 0x0000a7ef37ab2fe3UL;
   tf->codes[10616] = 0x0000a817b48e2d18UL;
   tf->codes[10617] = 0x0000a8527e22f7ddUL;
   tf->codes[10618] = 0x0000a86664bdedd0UL;
   tf->codes[10619] = 0x0000a8bf2582ac64UL;
   tf->codes[10620] = 0x0000a8c518094266UL;
   tf->codes[10621] = 0x0000a8d8c4153294UL;
   tf->codes[10622] = 0x0000a8dd5741a5f8UL;
   tf->codes[10623] = 0x0000a8e46e9358d3UL;
   tf->codes[10624] = 0x0000a91895f47c47UL;
   tf->codes[10625] = 0x0000a91c3ee4d897UL;
   tf->codes[10626] = 0x0000a939fb85c6a1UL;
   tf->codes[10627] = 0x0000a951c5a01ea9UL;
   tf->codes[10628] = 0x0000a97240f551efUL;
   tf->codes[10629] = 0x0000a97a7d1221a3UL;
   tf->codes[10630] = 0x0000a98786ea6a80UL;
   tf->codes[10631] = 0x0000a9b1d84595ddUL;
   tf->codes[10632] = 0x0000a9b7903d261aUL;
   tf->codes[10633] = 0x0000a9b87a793d2eUL;
   tf->codes[10634] = 0x0000a9c166431e31UL;
   tf->codes[10635] = 0x0000a9c66e8d9d1fUL;
   tf->codes[10636] = 0x0000a9dee8550676UL;
   tf->codes[10637] = 0x0000a9ea92d32cb5UL;
   tf->codes[10638] = 0x0000aa067afbec97UL;
   tf->codes[10639] = 0x0000aa113b3dfbc2UL;
   tf->codes[10640] = 0x0000aa25d1860304UL;
   tf->codes[10641] = 0x0000aa5cf22a7179UL;
   tf->codes[10642] = 0x0000aaa749bcc492UL;
   tf->codes[10643] = 0x0000aac4cbceacd7UL;
   tf->codes[10644] = 0x0000aad21035fb79UL;
   tf->codes[10645] = 0x0000aadedf7f3e91UL;
   tf->codes[10646] = 0x0000aaf92dbed610UL;
   tf->codes[10647] = 0x0000ab196e850391UL;
   tf->codes[10648] = 0x0000ab28124674d1UL;
   tf->codes[10649] = 0x0000ab3d1dac879dUL;
   tf->codes[10650] = 0x0000ab67a996b8bfUL;
   tf->codes[10651] = 0x0000abaaaf485338UL;
   tf->codes[10652] = 0x0000abc204449fb6UL;
   tf->codes[10653] = 0x0000abd241ef3959UL;
   tf->codes[10654] = 0x0000abd3a1495bf7UL;
   tf->codes[10655] = 0x0000abdd774f540eUL;
   tf->codes[10656] = 0x0000abf0391f2d28UL;
   tf->codes[10657] = 0x0000ac0285d0fab8UL;
   tf->codes[10658] = 0x0000ac0f1a8b380bUL;
   tf->codes[10659] = 0x0000ac18f0913022UL;
   tf->codes[10660] = 0x0000ac2376443988UL;
   tf->codes[10661] = 0x0000ac2d4c4a319fUL;
   tf->codes[10662] = 0x0000ac3fd38b04f4UL;
   tf->codes[10663] = 0x0000ac46eadcb7cfUL;
   tf->codes[10664] = 0x0000ac672ba2e550UL;
   tf->codes[10665] = 0x0000ac7ce6b6096bUL;
   tf->codes[10666] = 0x0000ac95607d72c2UL;
   tf->codes[10667] = 0x0000ac9a68c7f1b0UL;
   tf->codes[10668] = 0x0000acb566b49a7eUL;
   tf->codes[10669] = 0x0000acc445051183UL;
   tf->codes[10670] = 0x0000acc47f941748UL;
   tf->codes[10671] = 0x0000ace201a5ff8dUL;
   tf->codes[10672] = 0x0000ad0b68c513d6UL;
   tf->codes[10673] = 0x0000ad37c9277320UL;
   tf->codes[10674] = 0x0000ad6847983a44UL;
   tf->codes[10675] = 0x0000ad6d1553b36dUL;
   tf->codes[10676] = 0x0000adbf33e4cab0UL;
   tf->codes[10677] = 0x0000adcd62883066UL;
   tf->codes[10678] = 0x0000add613c30ba4UL;
   tf->codes[10679] = 0x0000ade4b7847ce4UL;
   tf->codes[10680] = 0x0000ae17f4a98944UL;
   tf->codes[10681] = 0x0000ae332d2537d7UL;
   tf->codes[10682] = 0x0000ae3ab994f63cUL;
   tf->codes[10683] = 0x0000ae3f4cc169a0UL;
   tf->codes[10684] = 0x0000ae4d40d5c991UL;
   tf->codes[10685] = 0x0000ae6a4dc9a64cUL;
   tf->codes[10686] = 0x0000ae6b7294c325UL;
   tf->codes[10687] = 0x0000ae96ae2c0596UL;
   tf->codes[10688] = 0x0000aea810a1bc12UL;
   tf->codes[10689] = 0x0000aeb38090dc8cUL;
   tf->codes[10690] = 0x0000aebd1c07cedeUL;
   tf->codes[10691] = 0x0000aec97633066cUL;
   tf->codes[10692] = 0x0000aef8202b9f68UL;
   tf->codes[10693] = 0x0000af01f631977fUL;
   tf->codes[10694] = 0x0000af04b4e5dcbbUL;
   tf->codes[10695] = 0x0000af3cbfc66244UL;
   tf->codes[10696] = 0x0000af418d81db6dUL;
   tf->codes[10697] = 0x0000af42029fe6f7UL;
   tf->codes[10698] = 0x0000af4c4dc3ea98UL;
   tf->codes[10699] = 0x0000af527ad9865fUL;
   tf->codes[10700] = 0x0000af52b5688c24UL;
   tf->codes[10701] = 0x0000af5623c9e2afUL;
   tf->codes[10702] = 0x0000af74caa6e7cdUL;
   tf->codes[10703] = 0x0000af857d6f8cfaUL;
   tf->codes[10704] = 0x0000afa2ff81753fUL;
   tf->codes[10705] = 0x0000afbac99bcd47UL;
   tf->codes[10706] = 0x0000afdc2f2d17a1UL;
   tf->codes[10707] = 0x0000b0197ce721ddUL;
   tf->codes[10708] = 0x0000b0431e953bebUL;
   tf->codes[10709] = 0x0000b06867a5e85aUL;
   tf->codes[10710] = 0x0000b0a246fe9c0bUL;
   tf->codes[10711] = 0x0000b0d66e5fbf7fUL;
   tf->codes[10712] = 0x0000b0deaa7c8f33UL;
   tf->codes[10713] = 0x0000b0f131bd6288UL;
   tf->codes[10714] = 0x0000b104ddc952b6UL;
   tf->codes[10715] = 0x0000b1079c7d97f2UL;
   tf->codes[10716] = 0x0000b174094e46b4UL;
   tf->codes[10717] = 0x0000b1a412a1024eUL;
   tf->codes[10718] = 0x0000b1d15d3f78acUL;
   tf->codes[10719] = 0x0000b1df5153d89dUL;
   tf->codes[10720] = 0x0000b22b7d5e59deUL;
   tf->codes[10721] = 0x0000b2b6cb9b1383UL;
   tf->codes[10722] = 0x0000b2d537e912dcUL;
   tf->codes[10723] = 0x0000b2d6222529f0UL;
   tf->codes[10724] = 0x0000b30c588d8151UL;
   tf->codes[10725] = 0x0000b336e477b273UL;
   tf->codes[10726] = 0x0000b338f37ee660UL;
   tf->codes[10727] = 0x0000b343b3c0f58bUL;
   tf->codes[10728] = 0x0000b387691fa153UL;
   tf->codes[10729] = 0x0000b3929e7fbc08UL;
   tf->codes[10730] = 0x0000b3aa689a1410UL;
   tf->codes[10731] = 0x0000b404139ae9b8UL;
   tf->codes[10732] = 0x0000b40c1528b3a7UL;
   tf->codes[10733] = 0x0000b43123aa5a51UL;
   tf->codes[10734] = 0x0000b44001fad156UL;
   tf->codes[10735] = 0x0000b4d6fab5b13aUL;
   tf->codes[10736] = 0x0000b4f6c65dd331UL;
   tf->codes[10737] = 0x0000b519162b349fUL;
   tf->codes[10738] = 0x0000b51b2532688cUL;
   tf->codes[10739] = 0x0000b533d988d7a8UL;
   tf->codes[10740] = 0x0000b55fff5c312dUL;
   tf->codes[10741] = 0x0000b58beaa084edUL;
   tf->codes[10742] = 0x0000b5bf27c5914dUL;
   tf->codes[10743] = 0x0000b5c43010103bUL;
   tf->codes[10744] = 0x0000b5d51d67bb2dUL;
   tf->codes[10745] = 0x0000b5eb4d98ead2UL;
   tf->codes[10746] = 0x0000b5f892003974UL;
   tf->codes[10747] = 0x0000b611bb74b41aUL;
   tf->codes[10748] = 0x0000b61ae1cd9ae2UL;
   tf->codes[10749] = 0x0000b61ec54cfcf7UL;
   tf->codes[10750] = 0x0000b62099c52b1fUL;
   tf->codes[10751] = 0x0000b6440e5da966UL;
   tf->codes[10752] = 0x0000b6753c7b81d9UL;
   tf->codes[10753] = 0x0000b6799518ef78UL;
   tf->codes[10754] = 0x0000b6c0b8d8f1cbUL;
   tf->codes[10755] = 0x0000b6c218331469UL;
   tf->codes[10756] = 0x0000b6d5c43f0497UL;
   tf->codes[10757] = 0x0000b6e76143c0d8UL;
   tf->codes[10758] = 0x0000b7025f3069a6UL;
   tf->codes[10759] = 0x0000b703be8a8c44UL;
   tf->codes[10760] = 0x0000b704a8c6a358UL;
   tf->codes[10761] = 0x0000b70c6fc56782UL;
   tf->codes[10762] = 0x0000b70fde26be0dUL;
   tf->codes[10763] = 0x0000b719eebbbbe9UL;
   tf->codes[10764] = 0x0000b7229ff69727UL;
   tf->codes[10765] = 0x0000b72e8503c32bUL;
   tf->codes[10766] = 0x0000b736c12092dfUL;
   tf->codes[10767] = 0x0000b74689ad20f8UL;
   tf->codes[10768] = 0x0000b74b1cd9945cUL;
   tf->codes[10769] = 0x0000b77bd5d96145UL;
   tf->codes[10770] = 0x0000b78cc3310c37UL;
   tf->codes[10771] = 0x0000b7a627348ca2UL;
   tf->codes[10772] = 0x0000b7bbe247b0bdUL;
   tf->codes[10773] = 0x0000b7dcd2baef8dUL;
   tf->codes[10774] = 0x0000b7e215947440UL;
   tf->codes[10775] = 0x0000b7e6e34fed69UL;
   tf->codes[10776] = 0x0000b7e8081b0a42UL;
   tf->codes[10777] = 0x0000b7f587115ea9UL;
   tf->codes[10778] = 0x0000b7fc9e631184UL;
   tf->codes[10779] = 0x0000b80d512bb6b1UL;
   tf->codes[10780] = 0x0000b81a95930553UL;
   tf->codes[10781] = 0x0000b81f28bf78b7UL;
   tf->codes[10782] = 0x0000b83767f7dc49UL;
   tf->codes[10783] = 0x0000b853c53ea7b5UL;
   tf->codes[10784] = 0x0000b86b8f58ffbdUL;
   tf->codes[10785] = 0x0000b883597357c5UL;
   tf->codes[10786] = 0x0000b88fb39e8f53UL;
   tf->codes[10787] = 0x0000b89028bc9addUL;
   tf->codes[10788] = 0x0000b894815a087cUL;
   tf->codes[10789] = 0x0000b8a4f993a7e4UL;
   tf->codes[10790] = 0x0000b8ac10e55abfUL;
   tf->codes[10791] = 0x0000b8c7be7f14dcUL;
   tf->codes[10792] = 0x0000b916341fcfcfUL;
   tf->codes[10793] = 0x0000b96ad6d62689UL;
   tf->codes[10794] = 0x0000b9755c892fefUL;
   tf->codes[10795] = 0x0000b97b4f0fc5f1UL;
   tf->codes[10796] = 0x0000b9876eabf7baUL;
   tf->codes[10797] = 0x0000b99d644e219aUL;
   tf->codes[10798] = 0x0000b9d86871f224UL;
   tf->codes[10799] = 0x0000b9fa7db04dcdUL;
   tf->codes[10800] = 0x0000ba01cf91066dUL;
   tf->codes[10801] = 0x0000ba16daf71939UL;
   tf->codes[10802] = 0x0000ba3baee9ba1eUL;
   tf->codes[10803] = 0x0000ba804e847cfaUL;
   tf->codes[10804] = 0x0000ba90c6be1c62UL;
   tf->codes[10805] = 0x0000ba9260a744c5UL;
   tf->codes[10806] = 0x0000bb35ee1c61fcUL;
   tf->codes[10807] = 0x0000bb59d7d2ebcdUL;
   tf->codes[10808] = 0x0000bb645d85f533UL;
   tf->codes[10809] = 0x0000bb8dff340f41UL;
   tf->codes[10810] = 0x0000bb9a595f46cfUL;
   tf->codes[10811] = 0x0000bbc88e39d441UL;
   tf->codes[10812] = 0x0000bbc93de6e590UL;
   tf->codes[10813] = 0x0000bbe7aa34e4e9UL;
   tf->codes[10814] = 0x0000bc010e386554UL;
   tf->codes[10815] = 0x0000bc2de3b8d028UL;
   tf->codes[10816] = 0x0000bc34c07b7d3eUL;
   tf->codes[10817] = 0x0000bc6c1baef178UL;
   tf->codes[10818] = 0x0000bc79d5344ba4UL;
   tf->codes[10819] = 0x0000bca92ed9f5efUL;
   tf->codes[10820] = 0x0000bcb25532dcb7UL;
   tf->codes[10821] = 0x0000bcbbf0a9cf09UL;
   tf->codes[10822] = 0x0000bcfc37a72446UL;
   tf->codes[10823] = 0x0000bd2f74cc30a6UL;
   tf->codes[10824] = 0x0000bd61c7b525f2UL;
   tf->codes[10825] = 0x0000bd91215ad03dUL;
   tf->codes[10826] = 0x0000bd953f693817UL;
   tf->codes[10827] = 0x0000bdd33cd053a2UL;
   tf->codes[10828] = 0x0000bde3055ce1bbUL;
   tf->codes[10829] = 0x0000be04e00c379fUL;
   tf->codes[10830] = 0x0000be0938a9a53eUL;
   tf->codes[10831] = 0x0000be0bf75dea7aUL;
   tf->codes[10832] = 0x0000be104ffb5819UL;
   tf->codes[10833] = 0x0000be1d1f449b31UL;
   tf->codes[10834] = 0x0000be2311cb3133UL;
   tf->codes[10835] = 0x0000be326539b3c2UL;
   tf->codes[10836] = 0x0000be360e2a1012UL;
   tf->codes[10837] = 0x0000be38ccde554eUL;
   tf->codes[10838] = 0x0000bed667ccdc83UL;
   tf->codes[10839] = 0x0000bf38145b7c1aUL;
   tf->codes[10840] = 0x0000bf38897987a4UL;
   tf->codes[10841] = 0x0000bf3ce216f543UL;
   tf->codes[10842] = 0x0000bf581a92a3d6UL;
   tf->codes[10843] = 0x0000bf5904cebaeaUL;
   tf->codes[10844] = 0x0000bf74b2687507UL;
   tf->codes[10845] = 0x0000bf790b05e2a6UL;
   tf->codes[10846] = 0x0000bf885e746535UL;
   tf->codes[10847] = 0x0000bf92a99868d6UL;
   tf->codes[10848] = 0x0000bfa4bbbb30a1UL;
   tf->codes[10849] = 0x0000bfa655a45904UL;
   tf->codes[10850] = 0x0000c0119da9eaedUL;
   tf->codes[10851] = 0x0000c022c5909ba4UL;
   tf->codes[10852] = 0x0000c0349d245daaUL;
   tf->codes[10853] = 0x0000c0463a2919ebUL;
   tf->codes[10854] = 0x0000c07bfb7365c2UL;
   tf->codes[10855] = 0x0000c089b4f8bfeeUL;
   tf->codes[10856] = 0x0000c08b8970ee16UL;
   tf->codes[10857] = 0x0000c091f1158fa2UL;
   tf->codes[10858] = 0x0000c0a94611dc20UL;
   tf->codes[10859] = 0x0000c0ab8fa815d2UL;
   tf->codes[10860] = 0x0000c0b47b71f6d5UL;
   tf->codes[10861] = 0x0000c0c4096f7f29UL;
   tf->codes[10862] = 0x0000c14a4f61b9e0UL;
   tf->codes[10863] = 0x0000c156a98cf16eUL;
   tf->codes[10864] = 0x0000c156e41bf733UL;
   tf->codes[10865] = 0x0000c17c2d2ca3a2UL;
   tf->codes[10866] = 0x0000c1804b3b0b7cUL;
   tf->codes[10867] = 0x0000c1858e14902fUL;
   tf->codes[10868] = 0x0000c1afdf6fbb8cUL;
   tf->codes[10869] = 0x0000c1c7a98a1394UL;
   tf->codes[10870] = 0x0000c1e05de082b0UL;
   tf->codes[10871] = 0x0000c1e182ab9f89UL;
   tf->codes[10872] = 0x0000c1e7afc13b50UL;
   tf->codes[10873] = 0x0000c20482261246UL;
   tf->codes[10874] = 0x0000c2386ef82ff5UL;
   tf->codes[10875] = 0x0000c239ce525293UL;
   tf->codes[10876] = 0x0000c24d3fcf3cfcUL;
   tf->codes[10877] = 0x0000c2595f6b6ec5UL;
   tf->codes[10878] = 0x0000c25edcd3f93dUL;
   tf->codes[10879] = 0x0000c265f425ac18UL;
   tf->codes[10880] = 0x0000c2b2954e38e3UL;
   tf->codes[10881] = 0x0000c2cc6e6fc4d8UL;
   tf->codes[10882] = 0x0000c2d51faaa016UL;
   tf->codes[10883] = 0x0000c309f6b8d4d9UL;
   tf->codes[10884] = 0x0000c30ae0f4ebedUL;
   tf->codes[10885] = 0x0000c31ddd53caccUL;
   tf->codes[10886] = 0x0000c3439b8282c5UL;
   tf->codes[10887] = 0x0000c3d84aa728f7UL;
   tf->codes[10888] = 0x0000c3e1e61e1b49UL;
   tf->codes[10889] = 0x0000c4326ac60a29UL;
   tf->codes[10890] = 0x0000c43ae171dfa2UL;
   tf->codes[10891] = 0x0000c45de0ec525fUL;
   tf->codes[10892] = 0x0000c4f9a762ab6cUL;
   tf->codes[10893] = 0x0000c5255817f967UL;
   tf->codes[10894] = 0x0000c52ce487b7ccUL;
   tf->codes[10895] = 0x0000c531ecd236baUL;
   tf->codes[10896] = 0x0000c53ce7a34baaUL;
   tf->codes[10897] = 0x0000c552a2b66fc5UL;
   tf->codes[10898] = 0x0000c55944ea1716UL;
   tf->codes[10899] = 0x0000c55d62f87ef0UL;
   tf->codes[10900] = 0x0000c5b539812670UL;
   tf->codes[10901] = 0x0000c5daf7afde69UL;
   tf->codes[10902] = 0x0000c5ef18d9da21UL;
   tf->codes[10903] = 0x0000c6066dd6269fUL;
   tf->codes[10904] = 0x0000c61ead0e8a31UL;
   tf->codes[10905] = 0x0000c61f974aa145UL;
   tf->codes[10906] = 0x0000c639aafb32ffUL;
   tf->codes[10907] = 0x0000c6530efeb36aUL;
   tf->codes[10908] = 0x0000c67b5152aadaUL;
   tf->codes[10909] = 0x0000c67ebfb40165UL;
   tf->codes[10910] = 0x0000c6cd3554bc58UL;
   tf->codes[10911] = 0x0000c70b6d4adda8UL;
   tf->codes[10912] = 0x0000c7684c1e0416UL;
   tf->codes[10913] = 0x0000c78fdec4ea37UL;
   tf->codes[10914] = 0x0000c7bb8f7a3832UL;
   tf->codes[10915] = 0x0000c7d9fbc8378bUL;
   tf->codes[10916] = 0x0000c7eaae90dcb8UL;
   tf->codes[10917] = 0x0000c808e04fd64cUL;
   tf->codes[10918] = 0x0000c8215a173fa3UL;
   tf->codes[10919] = 0x0000c8315d32d381UL;
   tf->codes[10920] = 0x0000c85cd3591bb7UL;
   tf->codes[10921] = 0x0000c85fcc9c66b8UL;
   tf->codes[10922] = 0x0000c86ac76d7ba8UL;
   tf->codes[10923] = 0x0000c89e79b09392UL;
   tf->codes[10924] = 0x0000c8dfaae9ffe3UL;
   tf->codes[10925] = 0x0000c944c5d9f605UL;
   tf->codes[10926] = 0x0000c9a9311cdad8UL;
   tf->codes[10927] = 0x0000c9b9a9567a40UL;
   tf->codes[10928] = 0x0000c9ea27c74164UL;
   tf->codes[10929] = 0x0000c9eb12035878UL;
   tf->codes[10930] = 0x0000c9ff332d5430UL;
   tf->codes[10931] = 0x0000ca8f89b48cc3UL;
   tf->codes[10932] = 0x0000ca96667739d9UL;
   tf->codes[10933] = 0x0000ca99252b7f15UL;
   tf->codes[10934] = 0x0000cb1c71da6ecbUL;
   tf->codes[10935] = 0x0000cb459e6a7d4fUL;
   tf->codes[10936] = 0x0000cb609c57261dUL;
   tf->codes[10937] = 0x0000cb66544eb65aUL;
   tf->codes[10938] = 0x0000cb8fbb6dcaa3UL;
   tf->codes[10939] = 0x0000cb906b1adbf2UL;
   tf->codes[10940] = 0x0000cb9f83fa58bcUL;
   tf->codes[10941] = 0x0000cbca0fe489deUL;
   tf->codes[10942] = 0x0000cc08f787bc7dUL;
   tf->codes[10943] = 0x0000cc184af63f0cUL;
   tf->codes[10944] = 0x0000cc2ef0457a3bUL;
   tf->codes[10945] = 0x0000cc388bbc6c8dUL;
   tf->codes[10946] = 0x0000cc53fec720e5UL;
   tf->codes[10947] = 0x0000cc64b18fc612UL;
   tf->codes[10948] = 0x0000cc6a2ef8508aUL;
   tf->codes[10949] = 0x0000cc6cb31d9001UL;
   tf->codes[10950] = 0x0000cc74ef3a5fb5UL;
   tf->codes[10951] = 0x0000cc76fe4193a2UL;
   tf->codes[10952] = 0x0000cc961a3ca44aUL;
   tf->codes[10953] = 0x0000cca40e51043bUL;
   tf->codes[10954] = 0x0000cd2b03f05041UL;
   tf->codes[10955] = 0x0000cd584e8ec69fUL;
   tf->codes[10956] = 0x0000cd8aa177bbebUL;
   tf->codes[10957] = 0x0000ce5c63c76694UL;
   tf->codes[10958] = 0x0000ce88feb8cba3UL;
   tf->codes[10959] = 0x0000ce988cb653f7UL;
   tf->codes[10960] = 0x0000cee777751a74UL;
   tf->codes[10961] = 0x0000cef5e0a785efUL;
   tf->codes[10962] = 0x0000cf082d59537fUL;
   tf->codes[10963] = 0x0000cf1a7a0b210fUL;
   tf->codes[10964] = 0x0000cf24ffbe2a75UL;
   tf->codes[10965] = 0x0000cf2699a752d8UL;
   tf->codes[10966] = 0x0000cf2e9b351cc7UL;
   tf->codes[10967] = 0x0000cf4714fc861eUL;
   tf->codes[10968] = 0x0000cf833deb7381UL;
   tf->codes[10969] = 0x0000cf95157f3587UL;
   tf->codes[10970] = 0x0000cf9cdc7df9b1UL;
   tf->codes[10971] = 0x0000cfba5e8fe1f6UL;
   tf->codes[10972] = 0x0000cfeadd00a91aUL;
   tf->codes[10973] = 0x0000d000d2a2d2faUL;
   tf->codes[10974] = 0x0000d006ffb86ec1UL;
   tf->codes[10975] = 0x0000d024473b5141UL;
   tf->codes[10976] = 0x0000d06be0195f1eUL;
   tf->codes[10977] = 0x0000d09631748a7bUL;
   tf->codes[10978] = 0x0000d0a54a540745UL;
   tf->codes[10979] = 0x0000d0a968626f1fUL;
   tf->codes[10980] = 0x0000d0ad8670d6f9UL;
   tf->codes[10981] = 0x0000d0c8f97b8b51UL;
   tf->codes[10982] = 0x0000d10a6543fd67UL;
   tf->codes[10983] = 0x0000d1739e425b63UL;
   tf->codes[10984] = 0x0000d1a666495c39UL;
   tf->codes[10985] = 0x0000d1ac1e40ec76UL;
   tf->codes[10986] = 0x0000d1f29253dd7aUL;
   tf->codes[10987] = 0x0000d20136154ebaUL;
   tf->codes[10988] = 0x0000d204a476a545UL;
   tf->codes[10989] = 0x0000d20887f6075aUL;
   tf->codes[10990] = 0x0000d2326433272dUL;
   tf->codes[10991] = 0x0000d25bcb523b76UL;
   tf->codes[10992] = 0x0000d2afbe5b80e1UL;
   tf->codes[10993] = 0x0000d2fc24f507e7UL;
   tf->codes[10994] = 0x0000d322cd5fd6f4UL;
   tf->codes[10995] = 0x0000d3722d3ca8fbUL;
   tf->codes[10996] = 0x0000d37d280dbdebUL;
   tf->codes[10997] = 0x0000d3838fb25f77UL;
   tf->codes[10998] = 0x0000d3a2e63c75e4UL;
   tf->codes[10999] = 0x0000d417c9b8fa1fUL;
   tf->codes[11000] = 0x0000d466b477c09cUL;
   tf->codes[11001] = 0x0000d47fddec3b42UL;
   tf->codes[11002] = 0x0000d4f4fbf7c542UL;
   tf->codes[11003] = 0x0000d548b47204e8UL;
   tf->codes[11004] = 0x0000d57eeada5c49UL;
   tf->codes[11005] = 0x0000d588fb6f5a25UL;
   tf->codes[11006] = 0x0000d6182d2b75dfUL;
   tf->codes[11007] = 0x0000d668ec626a84UL;
   tf->codes[11008] = 0x0000d6ba95d5763dUL;
   tf->codes[11009] = 0x0000d7a004311114UL;
   tf->codes[11010] = 0x0000d7cc9f227623UL;
   tf->codes[11011] = 0x0000d86531c67e6aUL;
   tf->codes[11012] = 0x0000d8f72236df60UL;
   tf->codes[11013] = 0x0000d96f3985b461UL;
   tf->codes[11014] = 0x0000d9b7f72edf17UL;
   tf->codes[11015] = 0x0000dad98e796751UL;
   tf->codes[11016] = 0x0000dba264ff30f7UL;
   tf->codes[11017] = 0x0000dbc4ef5b982aUL;
   tf->codes[11018] = 0x0000dd3c13988e32UL;
   tf->codes[11019] = 0x0000dd53ddb2e63aUL;
   tf->codes[11020] = 0x0000dd5c545ebbb3UL;
   tf->codes[11021] = 0x0000dd7a861db547UL;
   tf->codes[11022] = 0x0000de7deba943edUL;
   tf->codes[11023] = 0x0000de9197b5341bUL;
   tf->codes[11024] = 0x0000deff9e6f0b40UL;
   tf->codes[11025] = 0x0000df2a2a593c62UL;
   tf->codes[11026] = 0x0000df3a2d74d040UL;
   tf->codes[11027] = 0x0000df6d6a99dca0UL;
   tf->codes[11028] = 0x0000dfbc5558a31dUL;
   tf->codes[11029] = 0x0000dfc4cc047896UL;
   tf->codes[11030] = 0x0000dfff207b37d1UL;
   tf->codes[11031] = 0x0000e0f5b6bd835fUL;
   tf->codes[11032] = 0x0000e1584d883a0aUL;
   tf->codes[11033] = 0x0000e2b3c42b75f5UL;
   tf->codes[11034] = 0x0000e2fc0cb69521UL;
   tf->codes[11035] = 0x0000e309c63bef4dUL;
   tf->codes[11036] = 0x0000e38c9dccd379UL;
   tf->codes[11037] = 0x0000e482f9801942UL;
   tf->codes[11038] = 0x0000e4c290d05d30UL;
   tf->codes[11039] = 0x0000e4c3f02a7fceUL;
   tf->codes[11040] = 0x0000e52aa5039e53UL;
   tf->codes[11041] = 0x0000e579ca516a95UL;
   tf->codes[11042] = 0x0000e5b5b8b15233UL;
   tf->codes[11043] = 0x0000e5be2f5d27acUL;
   tf->codes[11044] = 0x0000e6004ad2ab11UL;
   tf->codes[11045] = 0x0000e6cd04d7d6ccUL;
   tf->codes[11046] = 0x0000e70c619914f5UL;
   tf->codes[11047] = 0x0000e71587f1fbbdUL;
   tf->codes[11048] = 0x0000e73f29a015cbUL;
   tf->codes[11049] = 0x0000e75d20d0099aUL;
   tf->codes[11050] = 0x0000e775d52678b6UL;
   tf->codes[11051] = 0x0000e788d1855795UL;
   tf->codes[11052] = 0x0000e78e897ce7d2UL;
   tf->codes[11053] = 0x0000e823e84e9f53UL;
   tf->codes[11054] = 0x0000e83ee63b4821UL;
   tf->codes[11055] = 0x0000e8433ed8b5c0UL;
   tf->codes[11056] = 0x0000e889785ca0ffUL;
   tf->codes[11057] = 0x0000e894adbcbbb4UL;
   tf->codes[11058] = 0x0000e8a092c9e7b8UL;
   tf->codes[11059] = 0x0000e8a610327230UL;
   tf->codes[11060] = 0x0000e904fe0ccc8bUL;
   tf->codes[11061] = 0x0000e90c8a7c8af0UL;
   tf->codes[11062] = 0x0000ea20dd5fc488UL;
   tf->codes[11063] = 0x0000eaaf5f6ecef3UL;
   tf->codes[11064] = 0x0000eb7ffcf35cc3UL;
   tf->codes[11065] = 0x0000eb8281189c3aUL;
   tf->codes[11066] = 0x0000eb8839102c77UL;
   tf->codes[11067] = 0x0000ebdbb6fb6658UL;
   tf->codes[11068] = 0x0000ebf84ed13789UL;
   tf->codes[11069] = 0x0000ec117845b22fUL;
   tf->codes[11070] = 0x0000ec13c1dbebe1UL;
   tf->codes[11071] = 0x0000ecb6da32fd8eUL;
   tf->codes[11072] = 0x0000ecfeada01130UL;
   tf->codes[11073] = 0x0000ed4103a49a5aUL;
   tf->codes[11074] = 0x0000ed9b23c37b8cUL;
   tf->codes[11075] = 0x0000ed9f7c60e92bUL;
   tf->codes[11076] = 0x0000ee5ca8688c92UL;
   tf->codes[11077] = 0x0000ee6d5b3131bfUL;
   tf->codes[11078] = 0x0000eea6c56bd9e6UL;
   tf->codes[11079] = 0x0000ef1b33ca5297UL;
   tf->codes[11080] = 0x0000ef75c9073f53UL;
   tf->codes[11081] = 0x0000efab8a518b2aUL;
   tf->codes[11082] = 0x0000efc2a4bed1e3UL;
   tf->codes[11083] = 0x0000f00b27d8f6d4UL;
   tf->codes[11084] = 0x0000f07794a9a596UL;
   tf->codes[11085] = 0x0000f0880ce344feUL;
   tf->codes[11086] = 0x0000f0c644d9664eUL;
   tf->codes[11087] = 0x0000f0def92fd56aUL;
   tf->codes[11088] = 0x0000f13a78a8d93aUL;
   tf->codes[11089] = 0x0000f16454e5f90dUL;
   tf->codes[11090] = 0x0000f1d2962ed5f7UL;
   tf->codes[11091] = 0x0000f23fb2ac9608UL;
   tf->codes[11092] = 0x0000f24ae80cb0bdUL;
   tf->codes[11093] = 0x0000f24f40aa1e5cUL;
   tf->codes[11094] = 0x0000f26919cbaa51UL;
   tf->codes[11095] = 0x0000f28af47b0035UL;
   tf->codes[11096] = 0x0000f2aa85941c67UL;
   tf->codes[11097] = 0x0000f2ac5a0c4a8fUL;
   tf->codes[11098] = 0x0000f2b754dd5f7fUL;
   tf->codes[11099] = 0x0000f2ebf15c8e7dUL;
   tf->codes[11100] = 0x0000f2f3b85b52a7UL;
   tf->codes[11101] = 0x0000f2fd19433f34UL;
   tf->codes[11102] = 0x0000f3338a3a9c5aUL;
   tf->codes[11103] = 0x0000f35bcc8e93caUL;
   tf->codes[11104] = 0x0000f384f91ea24eUL;
   tf->codes[11105] = 0x0000f3bfc2b36d13UL;
   tf->codes[11106] = 0x0000f3c1d1baa100UL;
   tf->codes[11107] = 0x0000f3cccc8bb5f0UL;
   tf->codes[11108] = 0x0000f3ea140e9870UL;
   tf->codes[11109] = 0x0000f3ec5da4d222UL;
   tf->codes[11110] = 0x0000f40c294cf419UL;
   tf->codes[11111] = 0x0000f435906c0862UL;
   tf->codes[11112] = 0x0000f4a2725ac2aeUL;
   tf->codes[11113] = 0x0000f4a61b4b1efeUL;
   tf->codes[11114] = 0x0000f4a740163bd7UL;
   tf->codes[11115] = 0x0000f4b200584b02UL;
   tf->codes[11116] = 0x0000f4b4bf0c903eUL;
   tf->codes[11117] = 0x0000f4de262ba487UL;
   tf->codes[11118] = 0x0000f502bf8f3fa7UL;
   tf->codes[11119] = 0x0000f5083cf7ca1fUL;
   tf->codes[11120] = 0x0000f52f1ff19ef1UL;
   tf->codes[11121] = 0x0000f535c2254642UL;
   tf->codes[11122] = 0x0000f584725506faUL;
   tf->codes[11123] = 0x0000f5a2a414008eUL;
   tf->codes[11124] = 0x0000f5ba339f52d1UL;
   tf->codes[11125] = 0x0000f5ba6e2e5896UL;
   tf->codes[11126] = 0x0000f5c1fa9e16fbUL;
   tf->codes[11127] = 0x0000f5cf79946b62UL;
   tf->codes[11128] = 0x0000f5d23848b09eUL;
   tf->codes[11129] = 0x0000f5dff1ce0acaUL;
   tf->codes[11130] = 0x0000f5ec116a3c93UL;
   tf->codes[11131] = 0x0000f5fa057e9c84UL;
   tf->codes[11132] = 0x0000f605affcc2c3UL;
   tf->codes[11133] = 0x0000f638b292c95eUL;
   tf->codes[11134] = 0x0000f640b420934dUL;
   tf->codes[11135] = 0x0000f6654d842e6dUL;
   tf->codes[11136] = 0x0000f689373ab83eUL;
   tf->codes[11137] = 0x0000f6abfc262536UL;
   tf->codes[11138] = 0x0000f6c9091a01f1UL;
   tf->codes[11139] = 0x0000f6d2a490f443UL;
   tf->codes[11140] = 0x0000f722eea9dd5eUL;
   tf->codes[11141] = 0x0000f755f13fe3f9UL;
   tf->codes[11142] = 0x0000f766de978eebUL;
   tf->codes[11143] = 0x0000f7771c42288eUL;
   tf->codes[11144] = 0x0000f7900b279d6fUL;
   tf->codes[11145] = 0x0000f7a2ccf77689UL;
   tf->codes[11146] = 0x0000f7a675e7d2d9UL;
   tf->codes[11147] = 0x0000f7a79ab2efb2UL;
   tf->codes[11148] = 0x0000f7a9a9ba239fUL;
   tf->codes[11149] = 0x0000f7f560a69956UL;
   tf->codes[11150] = 0x0000f8147ca1a9feUL;
   tf->codes[11151] = 0x0000f8c5fe2b2726UL;
   tf->codes[11152] = 0x0000f91473cbe219UL;
   tf->codes[11153] = 0x0000f924ec058181UL;
   tf->codes[11154] = 0x0000f96239bf8bbdUL;
   tf->codes[11155] = 0x0000f9a789075fe8UL;
   tf->codes[11156] = 0x0000f9a838b47137UL;
   tf->codes[11157] = 0x0000f9e7d004b525UL;
   tf->codes[11158] = 0x0000f9fc2bbdb6a2UL;
   tf->codes[11159] = 0x0000fa31b278fcb4UL;
   tf->codes[11160] = 0x0000fa9c10427789UL;
   tf->codes[11161] = 0x0000fab6991114cdUL;
   tf->codes[11162] = 0x0000fac2438f3b0cUL;
   tf->codes[11163] = 0x0000facd3e604ffcUL;
   tf->codes[11164] = 0x0000fadea0d60678UL;
   tf->codes[11165] = 0x0000fb02ffaa9bd3UL;
   tf->codes[11166] = 0x0000fb1bb4010aefUL;
   tf->codes[11167] = 0x0000fb2290c3b805UL;
   tf->codes[11168] = 0x0000fb5ce53a7740UL;
   tf->codes[11169] = 0x0000fb74e9e3d50dUL;
   tf->codes[11170] = 0x0000fbb6caca52adUL;
   tf->codes[11171] = 0x0000fbcc10bf6b3eUL;
   tf->codes[11172] = 0x0000fbd5ac365d90UL;
   tf->codes[11173] = 0x0000fbfcc9bf3827UL;
   tf->codes[11174] = 0x0000fc45124a5753UL;
   tf->codes[11175] = 0x0000fc5256b1a5f5UL;
   tf->codes[11176] = 0x0000fc580ea93632UL;
   tf->codes[11177] = 0x0000fc5f9b18f497UL;
   tf->codes[11178] = 0x0000fc62ceeb455dUL;
   tf->codes[11179] = 0x0000fc6bf5442c25UL;
   tf->codes[11180] = 0x0000fc86f330d4f3UL;
   tf->codes[11181] = 0x0000fca6f967fcafUL;
   tf->codes[11182] = 0x0000fcb85bddb32bUL;
   tf->codes[11183] = 0x0000fcc022dc7755UL;
   tf->codes[11184] = 0x0000fcc1f754a57dUL;
   tf->codes[11185] = 0x0000fd0a7a6eca6eUL;
   tf->codes[11186] = 0x0000fd136638ab71UL;
   tf->codes[11187] = 0x0000fd350658fb90UL;
   tf->codes[11188] = 0x0000fd4d45915f22UL;
   tf->codes[11189] = 0x0000fd74631a39b9UL;
   tf->codes[11190] = 0x0000fda8ff9968b7UL;
   tf->codes[11191] = 0x0000fdccaec0ecc3UL;
   tf->codes[11192] = 0x0000fe0185cf2186UL;
   tf->codes[11193] = 0x0000fe06538a9aafUL;
   tf->codes[11194] = 0x0000fe66a0bf17a8UL;
   tf->codes[11195] = 0x0000fe81298db4ecUL;
   tf->codes[11196] = 0x0000fea6380f5b96UL;
   tf->codes[11197] = 0x0000feba5939574eUL;
   tf->codes[11198] = 0x0000febe3cb8b963UL;
   tf->codes[11199] = 0x0000fee101a4265bUL;
   tf->codes[11200] = 0x0000ff91d3809234UL;
   tf->codes[11201] = 0x0000ff9cce51a724UL;
   tf->codes[11202] = 0x0000ffb5bd371c05UL;
   tf->codes[11203] = 0x00000026481632a1UL;
   tf->codes[11204] = 0x000000afc1dabe1eUL;
   tf->codes[11205] = 0x000001597c65771cUL;
   tf->codes[11206] = 0x0000015c75a8c21dUL;
   tf->codes[11207] = 0x00000175d9ac4288UL;
   tf->codes[11208] = 0x00000189c047387bUL;
   tf->codes[11209] = 0x000001e5b4de47d5UL;
   tf->codes[11210] = 0x0000023932c981b6UL;
   tf->codes[11211] = 0x000002396d58877bUL;
   tf->codes[11212] = 0x00000281f072ac6cUL;
   tf->codes[11213] = 0x0000028efa4af549UL;
   tf->codes[11214] = 0x000002f240c2bd43UL;
   tf->codes[11215] = 0x00000317c4626f77UL;
   tf->codes[11216] = 0x00000324591caccaUL;
   tf->codes[11217] = 0x0000034b3c16819cUL;
   tf->codes[11218] = 0x00000354626f6864UL;
   tf->codes[11219] = 0x0000039bfb4d7641UL;
   tf->codes[11220] = 0x000003ab4ebbf8d0UL;
   tf->codes[11221] = 0x000003c2de474b13UL;
   tf->codes[11222] = 0x000003d9f8b491ccUL;
   tf->codes[11223] = 0x0000045d45638182UL;
   tf->codes[11224] = 0x00000462c2cc0bfaUL;
   tf->codes[11225] = 0x0000046c98d20411UL;
   tf->codes[11226] = 0x000004854d28732dUL;
   tf->codes[11227] = 0x0000048bb4cd14b9UL;
   tf->codes[11228] = 0x000004a9716e02c3UL;
   tf->codes[11229] = 0x000004b67b464ba0UL;
   tf->codes[11230] = 0x000004ce7fefa96dUL;
   tf->codes[11231] = 0x000004f31953448dUL;
   tf->codes[11232] = 0x0000054a059fd4f9UL;
   tf->codes[11233] = 0x00000551cc9e9923UL;
   tf->codes[11234] = 0x000005b254621be1UL;
   tf->codes[11235] = 0x0000060472f33324UL;
   tf->codes[11236] = 0x00000614760ec702UL;
   tf->codes[11237] = 0x0000065d6e46f77dUL;
   tf->codes[11238] = 0x00000674139632acUL;
   tf->codes[11239] = 0x000006c5bd093e65UL;
   tf->codes[11240] = 0x000006e9a6bfc836UL;
   tf->codes[11241] = 0x0000077ae78317ddUL;
   tf->codes[11242] = 0x000007898b44891dUL;
   tf->codes[11243] = 0x000007b9cf264a7cUL;
   tf->codes[11244] = 0x000007f582f72c55UL;
   tf->codes[11245] = 0x0000082a949466ddUL;
   tf->codes[11246] = 0x0000082ca39b9acaUL;
   tf->codes[11247] = 0x000008488bc45aacUL;
   tf->codes[11248] = 0x0000085a9de72277UL;
   tf->codes[11249] = 0x000008a9fdc3f47eUL;
   tf->codes[11250] = 0x000008c152c040fcUL;
   tf->codes[11251] = 0x000008fb3218f4adUL;
   tf->codes[11252] = 0x000009a90ab21585UL;
   tf->codes[11253] = 0x000009b52a4e474eUL;
   tf->codes[11254] = 0x000009da38cfedf8UL;
   tf->codes[11255] = 0x000009f78052d078UL;
   tf->codes[11256] = 0x00000a0b2c5ec0a6UL;
   tf->codes[11257] = 0x00000a0c8bb8e344UL;
   tf->codes[11258] = 0x00000ae8d3bb9753UL;
   tf->codes[11259] = 0x00000afa36314dcfUL;
   tf->codes[11260] = 0x00000b04bbe45735UL;
   tf->codes[11261] = 0x00000b650918d42eUL;
   tf->codes[11262] = 0x00000ba8be777ff6UL;
   tf->codes[11263] = 0x00000bb4de13b1bfUL;
   tf->codes[11264] = 0x00000bbbbad65ed5UL;
   tf->codes[11265] = 0x00000bdc70ba97e0UL;
   tf->codes[11266] = 0x00000c1f014e26cfUL;
   tf->codes[11267] = 0x00000c4275e6a516UL;
   tf->codes[11268] = 0x00000c5412eb6157UL;
   tf->codes[11269] = 0x00000c77fca1eb28UL;
   tf->codes[11270] = 0x00000c80734dc0a1UL;
   tf->codes[11271] = 0x00000cb42590d88bUL;
   tf->codes[11272] = 0x00000cdbb837beacUL;
   tf->codes[11273] = 0x00000ce63deac812UL;
   tf->codes[11274] = 0x00000d00519b59ccUL;
   tf->codes[11275] = 0x00000d0b4c6c6ebcUL;
   tf->codes[11276] = 0x00000d6e1dc62b2cUL;
   tf->codes[11277] = 0x00000d73d5bdbb69UL;
   tf->codes[11278] = 0x00000d93dbf4e325UL;
   tf->codes[11279] = 0x00000da7c28fd918UL;
   tf->codes[11280] = 0x00000e2a5f91b77fUL;
   tf->codes[11281] = 0x00000e3c71b47f4aUL;
   tf->codes[11282] = 0x00000e9f430e3bbaUL;
   tf->codes[11283] = 0x00000f112d4774f4UL;
   tf->codes[11284] = 0x00000f1e71aec396UL;
   tf->codes[11285] = 0x00000f3c2e4fb1a0UL;
   tf->codes[11286] = 0x00000f479e3ed21aUL;
   tf->codes[11287] = 0x00000f9180b319a9UL;
   tf->codes[11288] = 0x00000fa9103e6becUL;
   tf->codes[11289] = 0x00000fbb5cf0397cUL;
   tf->codes[11290] = 0x00000fd570a0cb36UL;
   tf->codes[11291] = 0x00000fdb9db666fdUL;
   tf->codes[11292] = 0x00001067d62f37b6UL;
   tf->codes[11293] = 0x000010c9482ed188UL;
   tf->codes[11294] = 0x000010da35867c7aUL;
   tf->codes[11295] = 0x000010e73f5ec557UL;
   tf->codes[11296] = 0x000012419136e469UL;
   tf->codes[11297] = 0x000012c811b824e5UL;
   tf->codes[11298] = 0x000012d4e10167fdUL;
   tf->codes[11299] = 0x000012ec35fdb47bUL;
   tf->codes[11300] = 0x000012efa45f0b06UL;
   tf->codes[11301] = 0x000012fcae3753e3UL;
   tf->codes[11302] = 0x00001311447f5b25UL;
   tf->codes[11303] = 0x0000132b92bef2a4UL;
   tf->codes[11304] = 0x0000136069cd2767UL;
   tf->codes[11305] = 0x0000136dae347609UL;
   tf->codes[11306] = 0x000013732b9d0081UL;
   tf->codes[11307] = 0x000013b1639321d1UL;
   tf->codes[11308] = 0x000013e849a88a81UL;
   tf->codes[11309] = 0x000014b62878d315UL;
   tf->codes[11310] = 0x000014cc58aa02baUL;
   tf->codes[11311] = 0x000014d6a3ce065bUL;
   tf->codes[11312] = 0x0000150b7adc3b1eUL;
   tf->codes[11313] = 0x00001525c91bd29dUL;
   tf->codes[11314] = 0x0000155522c17ce8UL;
   tf->codes[11315] = 0x00001579bc251808UL;
   tf->codes[11316] = 0x000015c06ac70ed1UL;
   tf->codes[11317] = 0x000015c39e995f97UL;
   tf->codes[11318] = 0x000015f24891f893UL;
   tf->codes[11319] = 0x0000164acec7b162UL;
   tf->codes[11320] = 0x0000165a223633f1UL;
   tf->codes[11321] = 0x0000165d560884b7UL;
   tf->codes[11322] = 0x000016838955483aUL;
   tf->codes[11323] = 0x00001688919fc728UL;
   tf->codes[11324] = 0x00001697e50e49b7UL;
   tf->codes[11325] = 0x0000170785b1493fUL;
   tf->codes[11326] = 0x0000170d3da8d97cUL;
   tf->codes[11327] = 0x00001743aea036a2UL;
   tf->codes[11328] = 0x0000176a919a0b74UL;
   tf->codes[11329] = 0x0000177b4462b0a1UL;
   tf->codes[11330] = 0x000017e4b7f01462UL;
   tf->codes[11331] = 0x000017ec445fd2c7UL;
   tf->codes[11332] = 0x0000181ab3c965feUL;
   tf->codes[11333] = 0x0000183208c5b27cUL;
   tf->codes[11334] = 0x0000185d445cf4edUL;
   tf->codes[11335] = 0x000018e5d3e56956UL;
   tf->codes[11336] = 0x000018e8580aa8cdUL;
   tf->codes[11337] = 0x00001915681a1966UL;
   tf->codes[11338] = 0x00001940de40619cUL;
   tf->codes[11339] = 0x00001963689cc8cfUL;
   tf->codes[11340] = 0x000019a1db21efe4UL;
   tf->codes[11341] = 0x000019b1a3ae7dfdUL;
   tf->codes[11342] = 0x000019b6e68802b0UL;
   tf->codes[11343] = 0x000019bcd90e98b2UL;
   tf->codes[11344] = 0x000019ca5804ed19UL;
   tf->codes[11345] = 0x00001a718e6a66a0UL;
   tf->codes[11346] = 0x00001b2ef5010fccUL;
   tf->codes[11347] = 0x00001b4350ba1149UL;
   tf->codes[11348] = 0x00001b4efb383788UL;
   tf->codes[11349] = 0x00001b690ee8c942UL;
   tf->codes[11350] = 0x00001bea4c90850bUL;
   tf->codes[11351] = 0x00001bebabeaa7a9UL;
   tf->codes[11352] = 0x00001c00b750ba75UL;
   tf->codes[11353] = 0x00001c2257710a94UL;
   tf->codes[11354] = 0x00001c75d55c4475UL;
   tf->codes[11355] = 0x00001c910dd7f308UL;
   tf->codes[11356] = 0x00001cab96a6904cUL;
   tf->codes[11357] = 0x00001cc709b144a4UL;
   tf->codes[11358] = 0x00001cd53854aa5aUL;
   tf->codes[11359] = 0x00001ce5eb1d4f87UL;
   tf->codes[11360] = 0x00001d307d3ea865UL;
   tf->codes[11361] = 0x00001d5a940acdfdUL;
   tf->codes[11362] = 0x00001d7173e90ef1UL;
   tf->codes[11363] = 0x00001d7641a4881aUL;
   tf->codes[11364] = 0x00001dc31d5c1aaaUL;
   tf->codes[11365] = 0x00001dd94d8d4a4fUL;
   tf->codes[11366] = 0x00001e0a7bab22c2UL;
   tf->codes[11367] = 0x00001e5f1e61797cUL;
   tf->codes[11368] = 0x00001e7eea099b73UL;
   tf->codes[11369] = 0x00001e8b09a5cd3cUL;
   tf->codes[11370] = 0x00001e8f27b43516UL;
   tf->codes[11371] = 0x00001eea6c9e3321UL;
   tf->codes[11372] = 0x00001f18dc07c658UL;
   tf->codes[11373] = 0x00001f253632fde6UL;
   tf->codes[11374] = 0x00001f55b4a3c50aUL;
   tf->codes[11375] = 0x00001fbc697ce38fUL;
   tf->codes[11376] = 0x00001fce7b9fab5aUL;
   tf->codes[11377] = 0x00001fe645ba0362UL;
   tf->codes[11378] = 0x000020185e13f2e9UL;
   tf->codes[11379] = 0x000020231e560214UL;
   tf->codes[11380] = 0x000020314cf967caUL;
   tf->codes[11381] = 0x0000204b9b38ff49UL;
   tf->codes[11382] = 0x00002062b5a64602UL;
   tf->codes[11383] = 0x00002098ec0e9d63UL;
   tf->codes[11384] = 0x000020c75b78309aUL;
   tf->codes[11385] = 0x0000210fde92558bUL;
   tf->codes[11386] = 0x000021a41898f033UL;
   tf->codes[11387] = 0x000022276547dfe9UL;
   tf->codes[11388] = 0x0000224387ffa590UL;
   tf->codes[11389] = 0x0000228cbac6dbd0UL;
   tf->codes[11390] = 0x000022b2ee139f53UL;
   tf->codes[11391] = 0x000022bbd9dd8056UL;
   tf->codes[11392] = 0x0000230cd3a37ac0UL;
   tf->codes[11393] = 0x00002366098644deUL;
   tf->codes[11394] = 0x000023943e60d250UL;
   tf->codes[11395] = 0x000023aec72f6f94UL;
   tf->codes[11396] = 0x000023cc83d05d9eUL;
   tf->codes[11397] = 0x000023fdec7d3bd6UL;
   tf->codes[11398] = 0x0000243b74c64bd7UL;
   tf->codes[11399] = 0x00002469e42fdf0eUL;
   tf->codes[11400] = 0x00002489ea6706caUL;
   tf->codes[11401] = 0x000024caa6826791UL;
   tf->codes[11402] = 0x000024e8d8416125UL;
   tf->codes[11403] = 0x0000254a4a40faf7UL;
   tf->codes[11404] = 0x000025cd96efeaadUL;
   tf->codes[11405] = 0x0000264364a885fcUL;
   tf->codes[11406] = 0x0000266c91389480UL;
   tf->codes[11407] = 0x000026cb4483e916UL;
   tf->codes[11408] = 0x000026cf9d2156b5UL;
   tf->codes[11409] = 0x000026f520c108e9UL;
   tf->codes[11410] = 0x0000270b166332c9UL;
   tf->codes[11411] = 0x000027c8426ad630UL;
   tf->codes[11412] = 0x00002803f63bb809UL;
   tf->codes[11413] = 0x00002846c15e4cbdUL;
   tf->codes[11414] = 0x000028564f5bd511UL;
   tf->codes[11415] = 0x000028da8646dbdbUL;
   tf->codes[11416] = 0x0000292e3ec11b81UL;
   tf->codes[11417] = 0x000029384f56195dUL;
   tf->codes[11418] = 0x000029d4c57983b9UL;
   tf->codes[11419] = 0x000029e1cf51cc96UL;
   tf->codes[11420] = 0x000029e921328536UL;
   tf->codes[11421] = 0x000029ea808ca7d4UL;
   tf->codes[11422] = 0x00002a1337feaaceUL;
   tf->codes[11423] = 0x00002a44a0ab8906UL;
   tf->codes[11424] = 0x00002a546938171fUL;
   tf->codes[11425] = 0x00002a9e863b6473UL;
   tf->codes[11426] = 0x00002ab94999077cUL;
   tf->codes[11427] = 0x00002ab9f94618cbUL;
   tf->codes[11428] = 0x00002ad35d499936UL;
   tf->codes[11429] = 0x00002ae659a87815UL;
   tf->codes[11430] = 0x00002b127f7bd19aUL;
   tf->codes[11431] = 0x00002b4c24457f86UL;
   tf->codes[11432] = 0x00002b55fa4b779dUL;
   tf->codes[11433] = 0x00002b9606b9c715UL;
   tf->codes[11434] = 0x00002ba6b9826c42UL;
   tf->codes[11435] = 0x00002beb1e8e2959UL;
   tf->codes[11436] = 0x00002c24c357d745UL;
   tf->codes[11437] = 0x00002c2956844aa9UL;
   tf->codes[11438] = 0x00002c45041e04c6UL;
   tf->codes[11439] = 0x00002c48727f5b51UL;
   tf->codes[11440] = 0x00002c5750cfd256UL;
   tf->codes[11441] = 0x00002c5f17ce9680UL;
   tf->codes[11442] = 0x00002c742334a94cUL;
   tf->codes[11443] = 0x00002c78b6611cb0UL;
   tf->codes[11444] = 0x00002ce5984fd6fcUL;
   tf->codes[11445] = 0x00002ceadb295bafUL;
   tf->codes[11446] = 0x00002d0d6585c2e2UL;
   tf->codes[11447] = 0x00002d191003e921UL;
   tf->codes[11448] = 0x00002d25a4be2674UL;
   tf->codes[11449] = 0x00002d5d3a80a073UL;
   tf->codes[11450] = 0x00002dd4dcb169eaUL;
   tf->codes[11451] = 0x00002e23525224ddUL;
   tf->codes[11452] = 0x00002e54f58e08daUL;
   tf->codes[11453] = 0x00002e8489c2b8eaUL;
   tf->codes[11454] = 0x00002ea7fe5b3731UL;
   tf->codes[11455] = 0x00002f2bfab73836UL;
   tf->codes[11456] = 0x00002f44e99cad17UL;
   tf->codes[11457] = 0x00002f6a32ad5986UL;
   tf->codes[11458] = 0x00002f75680d743bUL;
   tf->codes[11459] = 0x00002fc74c0f85b9UL;
   tf->codes[11460] = 0x00002fe57dce7f4dUL;
   tf->codes[11461] = 0x0000303b0ac0ed1bUL;
   tf->codes[11462] = 0x000030cd35c053d6UL;
   tf->codes[11463] = 0x0000313250b049f8UL;
   tf->codes[11464] = 0x0000316e04812bd1UL;
   tf->codes[11465] = 0x0000319dd344e1a6UL;
   tf->codes[11466] = 0x000031b4b323229aUL;
   tf->codes[11467] = 0x000031e2ad6eaa47UL;
   tf->codes[11468] = 0x000031f5a9cd8926UL;
   tf->codes[11469] = 0x0000321af2de3595UL;
   tf->codes[11470] = 0x0000324cd0a91f57UL;
   tf->codes[11471] = 0x0000326c61c23b89UL;
   tf->codes[11472] = 0x000032942ef8276fUL;
   tf->codes[11473] = 0x000032b9b297d9a3UL;
   tf->codes[11474] = 0x000032d76f38c7adUL;
   tf->codes[11475] = 0x0000332918abd366UL;
   tf->codes[11476] = 0x000033548ed21b9cUL;
   tf->codes[11477] = 0x000033887ba4394bUL;
   tf->codes[11478] = 0x000033c0fba2ca5eUL;
   tf->codes[11479] = 0x0000349a0fd32da7UL;
   tf->codes[11480] = 0x000034f011e3a6ffUL;
   tf->codes[11481] = 0x00003509b0762d2fUL;
   tf->codes[11482] = 0x0000357fb8bdce43UL;
   tf->codes[11483] = 0x000035811817f0e1UL;
   tf->codes[11484] = 0x000035bc56cac730UL;
   tf->codes[11485] = 0x000035ca1050215cUL;
   tf->codes[11486] = 0x000035f2c7c22456UL;
   tf->codes[11487] = 0x0000365c00c08252UL;
   tf->codes[11488] = 0x0000369c0d2ed1caUL;
   tf->codes[11489] = 0x0000369e56c50b7cUL;
   tf->codes[11490] = 0x000036ae946fa51fUL;
   tf->codes[11491] = 0x000036e5efa31959UL;
   tf->codes[11492] = 0x000036fac07a2660UL;
   tf->codes[11493] = 0x00003706306946daUL;
   tf->codes[11494] = 0x00003722189206bcUL;
   tf->codes[11495] = 0x0000374d199a4368UL;
   tf->codes[11496] = 0x0000376a268e2023UL;
   tf->codes[11497] = 0x0000376a9bac2badUL;
   tf->codes[11498] = 0x000037cecc600abbUL;
   tf->codes[11499] = 0x000037d2ea6e7295UL;
   tf->codes[11500] = 0x000037e1c8bee99aUL;
   tf->codes[11501] = 0x0000382334875bb0UL;
   tf->codes[11502] = 0x000038658a8be4daUL;
   tf->codes[11503] = 0x000038843168e9f8UL;
   tf->codes[11504] = 0x000038d5dadbf5b1UL;
   tf->codes[11505] = 0x00003922b6938841UL;
   tf->codes[11506] = 0x0000393244911095UL;
   tf->codes[11507] = 0x0000397b3cc94110UL;
   tf->codes[11508] = 0x0000399d52079cb9UL;
   tf->codes[11509] = 0x000039c8530fd965UL;
   tf->codes[11510] = 0x000039f85c6294ffUL;
   tf->codes[11511] = 0x00003a21fe10af0dUL;
   tf->codes[11512] = 0x00003a5ffb77ca98UL;
   tf->codes[11513] = 0x00003a6454153837UL;
   tf->codes[11514] = 0x00003a6ffe935e76UL;
   tf->codes[11515] = 0x00003b92baa90389UL;
   tf->codes[11516] = 0x00003b9ba672e48cUL;
   tf->codes[11517] = 0x00003babe41d7e2fUL;
   tf->codes[11518] = 0x00003bd167bd3063UL;
   tf->codes[11519] = 0x00003bdc27ff3f8eUL;
   tf->codes[11520] = 0x00003be75d5f5a43UL;
   tf->codes[11521] = 0x00003be797ee6008UL;
   tf->codes[11522] = 0x00003c65a1c3cb0bUL;
   tf->codes[11523] = 0x00003c95e5a58c6aUL;
   tf->codes[11524] = 0x00003cb74b36d6c4UL;
   tf->codes[11525] = 0x00003cbfc1e2ac3dUL;
   tf->codes[11526] = 0x00003cf8f18e4e9fUL;
   tf->codes[11527] = 0x00003d31e6aaeb3cUL;
   tf->codes[11528] = 0x00003d35ca2a4d51UL;
   tf->codes[11529] = 0x00003d39388ba3dcUL;
   tf->codes[11530] = 0x00003d5ef6ba5bd5UL;
   tf->codes[11531] = 0x00003d67a7f53713UL;
   tf->codes[11532] = 0x00003d7f720f8f1bUL;
   tf->codes[11533] = 0x00003da1122fdf3aUL;
   tf->codes[11534] = 0x00003dcb638b0a97UL;
   tf->codes[11535] = 0x00003e0b356a544aUL;
   tf->codes[11536] = 0x00003e2792b11fb6UL;
   tf->codes[11537] = 0x00003e6764906969UL;
   tf->codes[11538] = 0x00003e7c35677670UL;
   tf->codes[11539] = 0x00003e93ff81ce78UL;
   tf->codes[11540] = 0x00003eb31b7cdf20UL;
   tf->codes[11541] = 0x00003ec1f9cd5625UL;
   tf->codes[11542] = 0x00003ed112acd2efUL;
   tf->codes[11543] = 0x00003ed396d21266UL;
   tf->codes[11544] = 0x00003f0b2c948c65UL;
   tf->codes[11545] = 0x00003f0cc67db4c8UL;
   tf->codes[11546] = 0x00003f17c14ec9b8UL;
   tf->codes[11547] = 0x00003f18ab8ae0ccUL;
   tf->codes[11548] = 0x00003f2c9225d6bfUL;
   tf->codes[11549] = 0x00003f4d0d7b0a05UL;
   tf->codes[11550] = 0x00003f93818dfb09UL;
   tf->codes[11551] = 0x00003fb521ae4b28UL;
   tf->codes[11552] = 0x00003fcbc6fd8657UL;
   tf->codes[11553] = 0x00003fdfad987c4aUL;
   tf->codes[11554] = 0x00003fe39117de5fUL;
   tf->codes[11555] = 0x00003fe5daae1811UL;
   tf->codes[11556] = 0x0000403c51dc9cf3UL;
   tf->codes[11557] = 0x0000404c1a692b0cUL;
   tf->codes[11558] = 0x00004057ff765710UL;
   tf->codes[11559] = 0x0000409b3fb6f74eUL;
   tf->codes[11560] = 0x000040bbbb0c2a94UL;
   tf->codes[11561] = 0x000040d0c6723d60UL;
   tf->codes[11562] = 0x0000411775143429UL;
   tf->codes[11563] = 0x00004119f93973a0UL;
   tf->codes[11564] = 0x000041377b4b5be5UL;
   tf->codes[11565] = 0x0000415f488147cbUL;
   tf->codes[11566] = 0x0000419afc5229a4UL;
   tf->codes[11567] = 0x000041d16d4986caUL;
   tf->codes[11568] = 0x000041d1e2679254UL;
   tf->codes[11569] = 0x000041e7d809bc34UL;
   tf->codes[11570] = 0x00004238d1cfb69eUL;
   tf->codes[11571] = 0x0000426029e796faUL;
   tf->codes[11572] = 0x00004268db227238UL;
   tf->codes[11573] = 0x000042774454ddb3UL;
   tf->codes[11574] = 0x00004293670ca35aUL;
   tf->codes[11575] = 0x000042953b84d182UL;
   tf->codes[11576] = 0x000042ae64f94c28UL;
   tf->codes[11577] = 0x0000431a973af525UL;
   tf->codes[11578] = 0x0000433bfccc3f7fUL;
   tf->codes[11579] = 0x000043547693a8d6UL;
   tf->codes[11580] = 0x00004356c029e288UL;
   tf->codes[11581] = 0x000043789ad9386cUL;
   tf->codes[11582] = 0x000043ac128d4a91UL;
   tf->codes[11583] = 0x000043cd3d8f8f26UL;
   tf->codes[11584] = 0x00004438fab32c99UL;
   tf->codes[11585] = 0x0000445607a70954UL;
   tf->codes[11586] = 0x0000445ef370ea57UL;
   tf->codes[11587] = 0x00004466ba6fae81UL;
   tf->codes[11588] = 0x0000446dd1c1615cUL;
   tf->codes[11589] = 0x00004499f794bae1UL;
   tf->codes[11590] = 0x000044d23d04462fUL;
   tf->codes[11591] = 0x000044e65e2e41e7UL;
   tf->codes[11592] = 0x00004557d3496f97UL;
   tf->codes[11593] = 0x00004576b4b57a7aUL;
   tf->codes[11594] = 0x0000458b858c8781UL;
   tf->codes[11595] = 0x000045b2a3156218UL;
   tf->codes[11596] = 0x000045ce8b3e21faUL;
   tf->codes[11597] = 0x000045e1fcbb0c63UL;
   tf->codes[11598] = 0x000045fcfaa7b531UL;
   tf->codes[11599] = 0x0000462452bf958dUL;
   tf->codes[11600] = 0x00004646dd1bfcc0UL;
   tf->codes[11601] = 0x000046780b39d533UL;
   tf->codes[11602] = 0x0000467bb42a3183UL;
   tf->codes[11603] = 0x000046abf80bf2e2UL;
   tf->codes[11604] = 0x000046bad65c69e7UL;
   tf->codes[11605] = 0x000046d4ea0cfba1UL;
   tf->codes[11606] = 0x000046f899347fadUL;
   tf->codes[11607] = 0x0000471b98aef26aUL;
   tf->codes[11608] = 0x00004769d3c0a798UL;
   tf->codes[11609] = 0x0000478c238e0906UL;
   tf->codes[11610] = 0x000047a80bb6c8e8UL;
   tf->codes[11611] = 0x000047b8be7f6e15UL;
   tf->codes[11612] = 0x000047d72acd6d6eUL;
   tf->codes[11613] = 0x000047e434a5b64bUL;
   tf->codes[11614] = 0x000047e818251860UL;
   tf->codes[11615] = 0x0000483a71453568UL;
   tf->codes[11616] = 0x000048494f95ac6dUL;
   tf->codes[11617] = 0x0000485693fcfb0fUL;
   tf->codes[11618] = 0x0000485ff4e4e79cUL;
   tf->codes[11619] = 0x000048bee2bf41f7UL;
   tf->codes[11620] = 0x000048c4d545d7f9UL;
   tf->codes[11621] = 0x000048d28ecb3225UL;
   tf->codes[11622] = 0x000048d3b3964efeUL;
   tf->codes[11623] = 0x000048d79715b113UL;
   tf->codes[11624] = 0x000049051c432d36UL;
   tf->codes[11625] = 0x0000493cb205a735UL;
   tf->codes[11626] = 0x0000495775634a3eUL;
   tf->codes[11627] = 0x00004958d4bd6cdcUL;
   tf->codes[11628] = 0x00004994fdac5a3fUL;
   tf->codes[11629] = 0x000049b2ba4d4849UL;
   tf->codes[11630] = 0x000049c666593877UL;
   tf->codes[11631] = 0x000049ddbb5584f5UL;
   tf->codes[11632] = 0x00004a028f4825daUL;
   tf->codes[11633] = 0x00004a0e745551deUL;
   tf->codes[11634] = 0x00004a2d1b3256fcUL;
   tf->codes[11635] = 0x00004a38509271b1UL;
   tf->codes[11636] = 0x00004a5b157ddea9UL;
   tf->codes[11637] = 0x00004a68cf0338d5UL;
   tf->codes[11638] = 0x00004aaff2c33b28UL;
   tf->codes[11639] = 0x00004ab4c07eb451UL;
   tf->codes[11640] = 0x00004ab953ab27b5UL;
   tf->codes[11641] = 0x00004ad7856a2149UL;
   tf->codes[11642] = 0x00004ade279dc89aUL;
   tf->codes[11643] = 0x00004b1423771a36UL;
   tf->codes[11644] = 0x00004b23b174a28aUL;
   tf->codes[11645] = 0x00004b3c2b3c0be1UL;
   tf->codes[11646] = 0x00004b437d1cc481UL;
   tf->codes[11647] = 0x00004b84ae5630d2UL;
   tf->codes[11648] = 0x00004bdcbf6dde17UL;
   tf->codes[11649] = 0x00004c2be4bbaa59UL;
   tf->codes[11650] = 0x00004c32fc0d5d34UL;
   tf->codes[11651] = 0x00004c4a8b98af77UL;
   tf->codes[11652] = 0x00004c575ae1f28fUL;
   tf->codes[11653] = 0x00004ca9ee91155cUL;
   tf->codes[11654] = 0x00004cecb9b3aa10UL;
   tf->codes[11655] = 0x00004cff40f47d65UL;
   tf->codes[11656] = 0x00004d27bdd77a9aUL;
   tf->codes[11657] = 0x00004d32f337954fUL;
   tf->codes[11658] = 0x00004d49d315d643UL;
   tf->codes[11659] = 0x00004d7a51869d67UL;
   tf->codes[11660] = 0x00004d8b044f4294UL;
   tf->codes[11661] = 0x00004d8c63a96532UL;
   tf->codes[11662] = 0x00004d9ca153fed5UL;
   tf->codes[11663] = 0x00004dd10344280eUL;
   tf->codes[11664] = 0x00004e13ce66bcc2UL;
   tf->codes[11665] = 0x00004e4ff755aa25UL;
   tf->codes[11666] = 0x00004e62f3b48904UL;
   tf->codes[11667] = 0x00004e7839a9a195UL;
   tf->codes[11668] = 0x00004e9bae421fdcUL;
   tf->codes[11669] = 0x00004ed5187cc803UL;
   tf->codes[11670] = 0x00004ee4315c44cdUL;
   tf->codes[11671] = 0x00004f11416bb566UL;
   tf->codes[11672] = 0x00004f54f6ca612eUL;
   tf->codes[11673] = 0x00004fb8ecef3a77UL;
   tf->codes[11674] = 0x00004fc21348213fUL;
   tf->codes[11675] = 0x00004fccd38a306aUL;
   tf->codes[11676] = 0x00004fe6acabbc5fUL;
   tf->codes[11677] = 0x00004fe84694e4c2UL;
   tf->codes[11678] = 0x00004ff96e7b9579UL;
   tf->codes[11679] = 0x00004ffd51faf78eUL;
   tf->codes[11680] = 0x0000500ca5697a1dUL;
   tf->codes[11681] = 0x0000502c71119c14UL;
   tf->codes[11682] = 0x000050431660d743UL;
   tf->codes[11683] = 0x000050585c55efd4UL;
   tf->codes[11684] = 0x000050747f0db57bUL;
   tf->codes[11685] = 0x0000508865a8ab6eUL;
   tf->codes[11686] = 0x000050894fe4c282UL;
   tf->codes[11687] = 0x000050a4c2ef76daUL;
   tf->codes[11688] = 0x000050e285c78ca0UL;
   tf->codes[11689] = 0x00005102c68dba21UL;
   tf->codes[11690] = 0x000051054ab2f998UL;
   tf->codes[11691] = 0x00005168569bbbcdUL;
   tf->codes[11692] = 0x000051b11444e683UL;
   tf->codes[11693] = 0x000051be58ac3525UL;
   tf->codes[11694] = 0x000051fc90a25675UL;
   tf->codes[11695] = 0x00005221d9b302e4UL;
   tf->codes[11696] = 0x000052a64b2d0f73UL;
   tf->codes[11697] = 0x000052b5640c8c3dUL;
   tf->codes[11698] = 0x000052b897dedd03UL;
   tf->codes[11699] = 0x000052cec8100ca8UL;
   tf->codes[11700] = 0x000052e14f50dffdUL;
   tf->codes[11701] = 0x000052fed162c842UL;
   tf->codes[11702] = 0x00005303648f3ba6UL;
   tf->codes[11703] = 0x0000531660ee1a85UL;
   tf->codes[11704] = 0x000053879b7a4270UL;
   tf->codes[11705] = 0x000053e64ec59706UL;
   tf->codes[11706] = 0x00005442f309b7afUL;
   tf->codes[11707] = 0x00005444c781e5d7UL;
   tf->codes[11708] = 0x0000544f4d34ef3dUL;
   tf->codes[11709] = 0x0000545b6cd12106UL;
   tf->codes[11710] = 0x00005473ac098498UL;
   tf->codes[11711] = 0x000054912e1b6cddUL;
   tf->codes[11712] = 0x000054a5c463741fUL;
   tf->codes[11713] = 0x000054b4dd42f0e9UL;
   tf->codes[11714] = 0x0000551823bab8e3UL;
   tf->codes[11715] = 0x0000557ed893d768UL;
   tf->codes[11716] = 0x000055b842ce7f8fUL;
   tf->codes[11717] = 0x000055ca8f804d1fUL;
   tf->codes[11718] = 0x000055dca1a314eaUL;
   tf->codes[11719] = 0x00005628cdad962bUL;
   tf->codes[11720] = 0x000056ba838ef15cUL;
   tf->codes[11721] = 0x000056d8b54deaf0UL;
   tf->codes[11722] = 0x000056f33e1c8834UL;
   tf->codes[11723] = 0x0000572431ab5ae2UL;
   tf->codes[11724] = 0x000057284fb9c2bcUL;
   tf->codes[11725] = 0x0000576f7379c50fUL;
   tf->codes[11726] = 0x0000577cf2701976UL;
   tf->codes[11727] = 0x000057b69739c762UL;
   tf->codes[11728] = 0x000057dd051590aaUL;
   tf->codes[11729] = 0x0000582f98c4b377UL;
   tf->codes[11730] = 0x000058396ecaab8eUL;
   tf->codes[11731] = 0x00005849ac754531UL;
   tf->codes[11732] = 0x000058838bcdf8e2UL;
   tf->codes[11733] = 0x0000589ec449a775UL;
   tf->codes[11734] = 0x000058d709b932c3UL;
   tf->codes[11735] = 0x000058f4513c1543UL;
   tf->codes[11736] = 0x000058fc183ad96dUL;
   tf->codes[11737] = 0x00005910ae82e0afUL;
   tf->codes[11738] = 0x0000593f587b79abUL;
   tf->codes[11739] = 0x00005953b4347b28UL;
   tf->codes[11740] = 0x0000597b46db6149UL;
   tf->codes[11741] = 0x000059c31a4874ebUL;
   tf->codes[11742] = 0x000059dc43bcef91UL;
   tf->codes[11743] = 0x000059fcbf1222d7UL;
   tf->codes[11744] = 0x00005a30e673464bUL;
   tf->codes[11745] = 0x00005a8b7bb03307UL;
   tf->codes[11746] = 0x00005aae409b9fffUL;
   tf->codes[11747] = 0x00005ab88bbfa3a0UL;
   tf->codes[11748] = 0x00005ac34c01b2cbUL;
   tf->codes[11749] = 0x00005b3c4d8c9ee0UL;
   tf->codes[11750] = 0x00005ba87fce47ddUL;
   tf->codes[11751] = 0x00005c18d01e58b4UL;
   tf->codes[11752] = 0x00005c2146ca2e2dUL;
   tf->codes[11753] = 0x00005c38613774e6UL;
   tf->codes[11754] = 0x00005cd54c78eaccUL;
   tf->codes[11755] = 0x00005cd8f569471cUL;
   tf->codes[11756] = 0x00005cfbba54b414UL;
   tf->codes[11757] = 0x00005d188cb98b0aUL;
   tf->codes[11758] = 0x00005d789f5f023eUL;
   tf->codes[11759] = 0x00005d8c4b6af26cUL;
   tf->codes[11760] = 0x00005dc87459dfcfUL;
   tf->codes[11761] = 0x00005dd802576823UL;
   tf->codes[11762] = 0x00005dec238163dbUL;
   tf->codes[11763] = 0x00005e3556489a1bUL;
   tf->codes[11764] = 0x00005e7144a881b9UL;
   tf->codes[11765] = 0x00005e84b6256c22UL;
   tf->codes[11766] = 0x00005e9777f5453cUL;
   tf->codes[11767] = 0x00005ec0df145985UL;
   tf->codes[11768] = 0x00005ee9d1156244UL;
   tf->codes[11769] = 0x00005eeed95fe132UL;
   tf->codes[11770] = 0x00005ef0e867151fUL;
   tf->codes[11771] = 0x00005ef874d6d384UL;
   tf->codes[11772] = 0x00005f0d803ce650UL;
   tf->codes[11773] = 0x00005f1581cab03fUL;
   tf->codes[11774] = 0x00005f18f02c06caUL;
   tf->codes[11775] = 0x00005f28090b8394UL;
   tf->codes[11776] = 0x00005f5553a9f9f2UL;
   tf->codes[11777] = 0x00005f73fa86ff10UL;
   tf->codes[11778] = 0x00005fab9049790fUL;
   tf->codes[11779] = 0x00005fb949ced33bUL;
   tf->codes[11780] = 0x0000603ea584f6deUL;
   tf->codes[11781] = 0x0000604a8a9222e2UL;
   tf->codes[11782] = 0x00006053765c03e5UL;
   tf->codes[11783] = 0x0000606ee966b83dUL;
   tf->codes[11784] = 0x0000607bb8affb55UL;
   tf->codes[11785] = 0x0000607c2dce06dfUL;
   tf->codes[11786] = 0x00006081e5c5971cUL;
   tf->codes[11787] = 0x000060901468fcd2UL;
   tf->codes[11788] = 0x0000609bbee72311UL;
   tf->codes[11789] = 0x000060dd653e9aecUL;
   tf->codes[11790] = 0x000060f94d675aceUL;
   tf->codes[11791] = 0x0000614b31696c4cUL;
   tf->codes[11792] = 0x0000614ccb5294afUL;
   tf->codes[11793] = 0x000061599a9bd7c7UL;
   tf->codes[11794] = 0x0000617b3abc27e6UL;
   tf->codes[11795] = 0x00006182177ed4fcUL;
   tf->codes[11796] = 0x000061a4674c366aUL;
   tf->codes[11797] = 0x000061c4e2a169b0UL;
   tf->codes[11798] = 0x000061cbbf6416c6UL;
   tf->codes[11799] = 0x000061e264b351f5UL;
   tf->codes[11800] = 0x000062306536015eUL;
   tf->codes[11801] = 0x00006274ca41be75UL;
   tf->codes[11802] = 0x000062b0f330abd8UL;
   tf->codes[11803] = 0x000063b6a2527430UL;
   tf->codes[11804] = 0x000063b751ff857fUL;
   tf->codes[11805] = 0x000063f37aee72e2UL;
   tf->codes[11806] = 0x00006405528234e8UL;
   tf->codes[11807] = 0x0000642b85cef86bUL;
   tf->codes[11808] = 0x0000644091350b37UL;
   tf->codes[11809] = 0x000064522e39c778UL;
   tf->codes[11810] = 0x0000646d66b5760bUL;
   tf->codes[11811] = 0x0000647861868afbUL;
   tf->codes[11812] = 0x0000648b5de569daUL;
   tf->codes[11813] = 0x000064c4187300b2UL;
   tf->codes[11814] = 0x0000651beefba832UL;
   tf->codes[11815] = 0x000065479fb0f62dUL;
   tf->codes[11816] = 0x0000654814cf01b7UL;
   tf->codes[11817] = 0x0000666f9ea01ff3UL;
   tf->codes[11818] = 0x00006679e9c42394UL;
   tf->codes[11819] = 0x0000668cab93fcaeUL;
   tf->codes[11820] = 0x000066b896d8506eUL;
   tf->codes[11821] = 0x000067127c682bdbUL;
   tf->codes[11822] = 0x00006724c919f96bUL;
   tf->codes[11823] = 0x0000673ccdc35738UL;
   tf->codes[11824] = 0x00006758b5ec171aUL;
   tf->codes[11825] = 0x00006782ccb83cb2UL;
   tf->codes[11826] = 0x000067958e8815ccUL;
   tf->codes[11827] = 0x000067a3480d6ff8UL;
   tf->codes[11828] = 0x000067a72b8cd20dUL;
   tf->codes[11829] = 0x00006809c25788b8UL;
   tf->codes[11830] = 0x00006883ae1e8be1UL;
   tf->codes[11831] = 0x00006885bd25bfceUL;
   tf->codes[11832] = 0x00006892c6fe08abUL;
   tf->codes[11833] = 0x000068b76061a3cbUL;
   tf->codes[11834] = 0x000068c5547603bcUL;
   tf->codes[11835] = 0x000068e72f2559a0UL;
   tf->codes[11836] = 0x0000690f36ea4b4bUL;
   tf->codes[11837] = 0x000069389e095f94UL;
   tf->codes[11838] = 0x00006947b6e8dc5eUL;
   tf->codes[11839] = 0x00006976d5ff80e4UL;
   tf->codes[11840] = 0x000069c75aa76fc4UL;
   tf->codes[11841] = 0x000069f25bafac70UL;
   tf->codes[11842] = 0x000069fbbc9798fdUL;
   tf->codes[11843] = 0x00006a03be2562ecUL;
   tf->codes[11844] = 0x00006a61fc52abf8UL;
   tf->codes[11845] = 0x00006a6e910ce94bUL;
   tf->codes[11846] = 0x00006a76cd29b8ffUL;
   tf->codes[11847] = 0x00006aaaf48adc73UL;
   tf->codes[11848] = 0x00006ac2498728f1UL;
   tf->codes[11849] = 0x00006b12ce2f17d1UL;
   tf->codes[11850] = 0x00006b1cdec415adUL;
   tf->codes[11851] = 0x00006b30ffee1165UL;
   tf->codes[11852] = 0x00006b534fbb72d3UL;
   tf->codes[11853] = 0x00006be36bb3a5a1UL;
   tf->codes[11854] = 0x00006c07ca883afcUL;
   tf->codes[11855] = 0x00006c087a354c4bUL;
   tf->codes[11856] = 0x00006c9d2959f27dUL;
   tf->codes[11857] = 0x00006cc40c53c74fUL;
   tf->codes[11858] = 0x00006d25f3716cabUL;
   tf->codes[11859] = 0x00006d5044cc9808UL;
   tf->codes[11860] = 0x00006d86b5c3f52eUL;
   tf->codes[11861] = 0x00006d8e7cc2b958UL;
   tf->codes[11862] = 0x00006d9ce5f524d3UL;
   tf->codes[11863] = 0x00006dd5a082bbabUL;
   tf->codes[11864] = 0x00006e16972d2237UL;
   tf->codes[11865] = 0x00006e6be9908a40UL;
   tf->codes[11866] = 0x00006e74d55a6b43UL;
   tf->codes[11867] = 0x00006ec72e7a884bUL;
   tf->codes[11868] = 0x00006eca27bdd34cUL;
   tf->codes[11869] = 0x00006ef61302270cUL;
   tf->codes[11870] = 0x00006f0e8cc99063UL;
   tf->codes[11871] = 0x00006f8c969efb66UL;
   tf->codes[11872] = 0x00006fdb0c3fb659UL;
   tf->codes[11873] = 0x00006ff6f468763bUL;
   tf->codes[11874] = 0x000070210b349bd3UL;
   tf->codes[11875] = 0x00007026fdbb31d5UL;
   tf->codes[11876] = 0x0000704b2200c16bUL;
   tf->codes[11877] = 0x00007069c8ddc689UL;
   tf->codes[11878] = 0x0000707ed443d955UL;
   tf->codes[11879] = 0x0000709fff461deaUL;
   tf->codes[11880] = 0x000070afc7d2ac03UL;
   tf->codes[11881] = 0x000070b2fba4fcc9UL;
   tf->codes[11882] = 0x000070df969661d8UL;
   tf->codes[11883] = 0x000070e8826042dbUL;
   tf->codes[11884] = 0x000070ec2b509f2bUL;
   tf->codes[11885] = 0x000070f96fb7edcdUL;
   tf->codes[11886] = 0x000070f9e4d5f957UL;
   tf->codes[11887] = 0x0000717b227db520UL;
   tf->codes[11888] = 0x000071bfc21877fcUL;
   tf->codes[11889] = 0x000071f28a1f78d2UL;
   tf->codes[11890] = 0x000071f92c532023UL;
   tf->codes[11891] = 0x000071fee44ab060UL;
   tf->codes[11892] = 0x000071ff5968bbeaUL;
   tf->codes[11893] = 0x000072351ab307c1UL;
   tf->codes[11894] = 0x00007267e2ba0897UL;
   tf->codes[11895] = 0x00007288989e41a2UL;
   tf->codes[11896] = 0x0000728d6659bacbUL;
   tf->codes[11897] = 0x000072be1f5987b4UL;
   tf->codes[11898] = 0x000072ce5d042157UL;
   tf->codes[11899] = 0x000072e193f205fbUL;
   tf->codes[11900] = 0x00007308ec09e657UL;
   tf->codes[11901] = 0x00007351e44216d2UL;
   tf->codes[11902] = 0x0000739adc7a474dUL;
   tf->codes[11903] = 0x000073d864c3574eUL;
   tf->codes[11904] = 0x000073e1c5ab43dbUL;
   tf->codes[11905] = 0x000073e39a237203UL;
   tf->codes[11906] = 0x000073f70ba05c6cUL;
   tf->codes[11907] = 0x0000740b67595de9UL;
   tf->codes[11908] = 0x000074399c33eb5bUL;
   tf->codes[11909] = 0x0000745758d4d965UL;
   tf->codes[11910] = 0x000074580881eab4UL;
   tf->codes[11911] = 0x0000746a5533b844UL;
   tf->codes[11912] = 0x00007487622794ffUL;
   tf->codes[11913] = 0x0000752b2a2bb7fbUL;
   tf->codes[11914] = 0x00007563aa2a490eUL;
   tf->codes[11915] = 0x0000756ac17bfbe9UL;
   tf->codes[11916] = 0x0000758b776034f4UL;
   tf->codes[11917] = 0x000075cd92d5b859UL;
   tf->codes[11918] = 0x000075e97afe783bUL;
   tf->codes[11919] = 0x000075eb4f76a663UL;
   tf->codes[11920] = 0x000075fd270a6869UL;
   tf->codes[11921] = 0x0000763740f221dfUL;
   tf->codes[11922] = 0x0000763aaf53786aUL;
   tf->codes[11923] = 0x0000768506e5cb83UL;
   tf->codes[11924] = 0x00007696de798d89UL;
   tf->codes[11925] = 0x000076ba1883060bUL;
   tf->codes[11926] = 0x000076f30d9fa2a8UL;
   tf->codes[11927] = 0x000076f9ea624fbeUL;
   tf->codes[11928] = 0x000077181c214952UL;
   tf->codes[11929] = 0x0000772c02bc3f45UL;
   tf->codes[11930] = 0x00007780e0019bc4UL;
   tf->codes[11931] = 0x000077974ac1d12eUL;
   tf->codes[11932] = 0x000077a53ed6311fUL;
   tf->codes[11933] = 0x000077aa0c91aa48UL;
   tf->codes[11934] = 0x000077c5450d58dbUL;
   tf->codes[11935] = 0x000077ee370e619aUL;
   tf->codes[11936] = 0x000077f13051ac9bUL;
   tf->codes[11937] = 0x000078259241d5d4UL;
   tf->codes[11938] = 0x0000782a5ffd4efdUL;
   tf->codes[11939] = 0x0000787bcee154f1UL;
   tf->codes[11940] = 0x000078a4865357ebUL;
   tf->codes[11941] = 0x000078a4fb716375UL;
   tf->codes[11942] = 0x000078c8e527ed46UL;
   tf->codes[11943] = 0x000078db6c68c09bUL;
   tf->codes[11944] = 0x00007951af3f6774UL;
   tf->codes[11945] = 0x0000795bbfd46550UL;
   tf->codes[11946] = 0x00007967df709719UL;
   tf->codes[11947] = 0x00007974aeb9da31UL;
   tf->codes[11948] = 0x000079afed6cb080UL;
   tf->codes[11949] = 0x000079bcbcb5f398UL;
   tf->codes[11950] = 0x000079e91d1852e2UL;
   tf->codes[11951] = 0x00007a1baa904df3UL;
   tf->codes[11952] = 0x00007a48ba9fbe8cUL;
   tf->codes[11953] = 0x00007a5f5feef9bbUL;
   tf->codes[11954] = 0x00007a7a234c9cc4UL;
   tf->codes[11955] = 0x00007ab686ca8fecUL;
   tf->codes[11956] = 0x00007ac3cb31de8eUL;
   tf->codes[11957] = 0x00007b55f6314549UL;
   tf->codes[11958] = 0x00007b78bb1cb241UL;
   tf->codes[11959] = 0x00007b8674a20c6dUL;
   tf->codes[11960] = 0x00007bf1bca79e56UL;
   tf->codes[11961] = 0x00007c850c7221eaUL;
   tf->codes[11962] = 0x00007c8a4f4ba69dUL;
   tf->codes[11963] = 0x00007ce1eb454858UL;
   tf->codes[11964] = 0x00007ced95c36e97UL;
   tf->codes[11965] = 0x00007d48daad6ca2UL;
   tf->codes[11966] = 0x00007d5743dfd81dUL;
   tf->codes[11967] = 0x00007d83ded13d2cUL;
   tf->codes[11968] = 0x00007dcfd04cb8a8UL;
   tf->codes[11969] = 0x00007dfb0be3fb19UL;
   tf->codes[11970] = 0x00007e276c465a63UL;
   tf->codes[11971] = 0x00007e29f06b99daUL;
   tf->codes[11972] = 0x00007e6320173c3cUL;
   tf->codes[11973] = 0x00007e8f80799b86UL;
   tf->codes[11974] = 0x00007e94c3532039UL;
   tf->codes[11975] = 0x00007e9ba015cd4fUL;
   tf->codes[11976] = 0x00007ebdb55428f8UL;
   tf->codes[11977] = 0x00007ec49216d60eUL;
   tf->codes[11978] = 0x00007f07d257764cUL;
   tf->codes[11979] = 0x00007f1aceb6552bUL;
   tf->codes[11980] = 0x00007f5856ff652cUL;
   tf->codes[11981] = 0x00007f60588d2f1bUL;
   tf->codes[11982] = 0x00007f6351d07a1cUL;
   tf->codes[11983] = 0x00007f7e8a4c28afUL;
   tf->codes[11984] = 0x00007fa4f827f1f7UL;
   tf->codes[11985] = 0x00007faff2f906e7UL;
   tf->codes[11986] = 0x00007fb7f486d0d6UL;
   tf->codes[11987] = 0x00007fdf4c9eb132UL;
   tf->codes[11988] = 0x00007ffabfa9658aUL;
   tf->codes[11989] = 0x00008038bd108115UL;
   tf->codes[11990] = 0x0000804d53588857UL;
   tf->codes[11991] = 0x000080b233b978b4UL;
   tf->codes[11992] = 0x00008117141a6911UL;
   tf->codes[11993] = 0x0000819050345aebUL;
   tf->codes[11994] = 0x00008190c5526675UL;
   tf->codes[11995] = 0x000081972cf70801UL;
   tf->codes[11996] = 0x0000819c354186efUL;
   tf->codes[11997] = 0x000081e826bd026bUL;
   tf->codes[11998] = 0x000081f14d15e933UL;
   tf->codes[11999] = 0x0000820fb963e88cUL;
   tf->codes[12000] = 0x00008232f36d610eUL;
   tf->codes[12001] = 0x000082412210c6c4UL;
   tf->codes[12002] = 0x000082e8cd944bd5UL;
   tf->codes[12003] = 0x000082eb172a8587UL;
   tf->codes[12004] = 0x000082f35347553bUL;
   tf->codes[12005] = 0x0000832ae909cf3aUL;
   tf->codes[12006] = 0x0000832c0dd4ec13UL;
   tf->codes[12007] = 0x000083f59407c708UL;
   tf->codes[12008] = 0x00008486251e0560UL;
   tf->codes[12009] = 0x00008499217ce43fUL;
   tf->codes[12010] = 0x000084a7502049f5UL;
   tf->codes[12011] = 0x000084d4602fba8eUL;
   tf->codes[12012] = 0x00008539b5aeb675UL;
   tf->codes[12013] = 0x0000854a68775ba2UL;
   tf->codes[12014] = 0x00008567004d2cd3UL;
   tf->codes[12015] = 0x000085aa7b1cd2d6UL;
   tf->codes[12016] = 0x000085ac1505fb39UL;
   tf->codes[12017] = 0x000085b1ccfd8b76UL;
   tf->codes[12018] = 0x000085bd025da62bUL;
   tf->codes[12019] = 0x000085c503eb701aUL;
   tf->codes[12020] = 0x000085e0b1852a37UL;
   tf->codes[12021] = 0x00008619e130cc99UL;
   tf->codes[12022] = 0x0000862725981b3bUL;
   tf->codes[12023] = 0x0000862bf3539464UL;
   tf->codes[12024] = 0x000086df49553fb4UL;
   tf->codes[12025] = 0x000087178ec4cb02UL;
   tf->codes[12026] = 0x0000873c62b76be7UL;
   tf->codes[12027] = 0x00008771e972b1f9UL;
   tf->codes[12028] = 0x000087daad53046bUL;
   tf->codes[12029] = 0x0000888b44a06a7fUL;
   tf->codes[12030] = 0x0000889ca71620fbUL;
   tf->codes[12031] = 0x000088d0595938e5UL;
   tf->codes[12032] = 0x000088e26b7c00b0UL;
   tf->codes[12033] = 0x000088f149cc77b5UL;
   tf->codes[12034] = 0x000088f9fb0752f3UL;
   tf->codes[12035] = 0x00008909fe22e6d1UL;
   tf->codes[12036] = 0x000089186755524cUL;
   tf->codes[12037] = 0x0000892c1361427aUL;
   tf->codes[12038] = 0x000089cb82c7f7d7UL;
   tf->codes[12039] = 0x000089cca79314b0UL;
   tf->codes[12040] = 0x00008a0059d62c9aUL;
   tf->codes[12041] = 0x00008a16ff2567c9UL;
   tf->codes[12042] = 0x00008a3c0da70e73UL;
   tf->codes[12043] = 0x00008a5412506c40UL;
   tf->codes[12044] = 0x00008a7af54a4112UL;
   tf->codes[12045] = 0x00008a7c1a155debUL;
   tf->codes[12046] = 0x00008a9284d59355UL;
   tf->codes[12047] = 0x00008aba8c9a8500UL;
   tf->codes[12048] = 0x00008ac9305bf640UL;
   tf->codes[12049] = 0x00008b2a67cc8a4dUL;
   tf->codes[12050] = 0x00008b30cf712bd9UL;
   tf->codes[12051] = 0x00008b6481b443c3UL;
   tf->codes[12052] = 0x00008ba4190487b1UL;
   tf->codes[12053] = 0x00008bacca3f62efUL;
   tf->codes[12054] = 0x00008c3ce63795bdUL;
   tf->codes[12055] = 0x00008c8061073bc0UL;
   tf->codes[12056] = 0x00008c889d240b74UL;
   tf->codes[12057] = 0x00008cc11d229c87UL;
   tf->codes[12058] = 0x00008ccd022fc88bUL;
   tf->codes[12059] = 0x00008cdd054b5c69UL;
   tf->codes[12060] = 0x00008cf8ed741c4bUL;
   tf->codes[12061] = 0x00008d3d527fd962UL;
   tf->codes[12062] = 0x00008d7b1557ef28UL;
   tf->codes[12063] = 0x00008d81426d8aefUL;
   tf->codes[12064] = 0x00008dbe9027952bUL;
   tf->codes[12065] = 0x00008dc1c3f9e5f1UL;
   tf->codes[12066] = 0x00008df11d9f903cUL;
   tf->codes[12067] = 0x00008e2e6b599a78UL;
   tf->codes[12068] = 0x00008e5429885271UL;
   tf->codes[12069] = 0x00008ec38f9c4c34UL;
   tf->codes[12070] = 0x00008eee1b867d56UL;
   tf->codes[12071] = 0x00008f148962469eUL;
   tf->codes[12072] = 0x00008f2f1230e3e2UL;
   tf->codes[12073] = 0x00008f4df39ceec5UL;
   tf->codes[12074] = 0x00008f52c15867eeUL;
   tf->codes[12075] = 0x00008f9b44728cdfUL;
   tf->codes[12076] = 0x00008fcfe0f1bbddUL;
   tf->codes[12077] = 0x00009015dfe6a157UL;
   tf->codes[12078] = 0x0000901e569276d0UL;
   tf->codes[12079] = 0x0000902c4aa6d6c1UL;
   tf->codes[12080] = 0x000090499229b941UL;
   tf->codes[12081] = 0x000090878f90d4ccUL;
   tf->codes[12082] = 0x000090b0f6afe915UL;
   tf->codes[12083] = 0x000090f262785b2bUL;
   tf->codes[12084] = 0x00009100568cbb1cUL;
   tf->codes[12085] = 0x0000911aa4cc529bUL;
   tf->codes[12086] = 0x000091c793295c5fUL;
   tf->codes[12087] = 0x0000920b48880827UL;
   tf->codes[12088] = 0x00009237a8ea6771UL;
   tf->codes[12089] = 0x000092464cabd8b1UL;
   tf->codes[12090] = 0x00009249f59c3501UL;
   tf->codes[12091] = 0x000092714db4155dUL;
   tf->codes[12092] = 0x000092b6d78aef4dUL;
   tf->codes[12093] = 0x000092d4942bdd57UL;
   tf->codes[12094] = 0x000092e631309998UL;
   tf->codes[12095] = 0x000092e8b555d90fUL;
   tf->codes[12096] = 0x0000931f264d3635UL;
   tf->codes[12097] = 0x000093493d195bcdUL;
   tf->codes[12098] = 0x000093b6ceb52768UL;
   tf->codes[12099] = 0x000093f15dbaec68UL;
   tf->codes[12100] = 0x00009419da9de99dUL;
   tf->codes[12101] = 0x0000943a908222a8UL;
   tf->codes[12102] = 0x0000948b4fb9174dUL;
   tf->codes[12103] = 0x000094917cceb314UL;
   tf->codes[12104] = 0x000094aec4519594UL;
   tf->codes[12105] = 0x000094cd309f94edUL;
   tf->codes[12106] = 0x000095011d71b29cUL;
   tf->codes[12107] = 0x00009529d4e3b596UL;
   tf->codes[12108] = 0x00009535f47fe75fUL;
   tf->codes[12109] = 0x0000955794a0377eUL;
   tf->codes[12110] = 0x0000956931a4f3bfUL;
   tf->codes[12111] = 0x0000957f61d62364UL;
   tf->codes[12112] = 0x000095e148f3c8c0UL;
   tf->codes[12113] = 0x000095e7eb277011UL;
   tf->codes[12114] = 0x0000961cfcc4aa99UL;
   tf->codes[12115] = 0x000096291c60dc62UL;
   tf->codes[12116] = 0x00009640e67b346aUL;
   tf->codes[12117] = 0x0000964b319f380bUL;
   tf->codes[12118] = 0x00009652f89dfc35UL;
   tf->codes[12119] = 0x0000973448eb2f32UL;
   tf->codes[12120] = 0x000097544f2256eeUL;
   tf->codes[12121] = 0x000097d0847f93c9UL;
   tf->codes[12122] = 0x000097db7f50a8b9UL;
   tf->codes[12123] = 0x000097f6081f45fdUL;
   tf->codes[12124] = 0x0000984ae564a27cUL;
   tf->codes[12125] = 0x00009870a3935a75UL;
   tf->codes[12126] = 0x0000989b6a0c915cUL;
   tf->codes[12127] = 0x000098ec9e61918bUL;
   tf->codes[12128] = 0x0000999aec18bdedUL;
   tf->codes[12129] = 0x000099ea4bf58ff4UL;
   tf->codes[12130] = 0x00009b8e45b2f0d0UL;
   tf->codes[12131] = 0x00009bca6ea1de33UL;
   tf->codes[12132] = 0x00009c1c1814e9ecUL;
   tf->codes[12133] = 0x00009c580674d18aUL;
   tf->codes[12134] = 0x00009c7672c2d0e3UL;
   tf->codes[12135] = 0x00009cc3c3986efdUL;
   tf->codes[12136] = 0x00009d370d2bcad5UL;
   tf->codes[12137] = 0x00009dc04c61508dUL;
   tf->codes[12138] = 0x00009eb9dbe6e71cUL;
   tf->codes[12139] = 0x00009ef7d94e02a7UL;
   tf->codes[12140] = 0x00009f459f41ac4bUL;
   tf->codes[12141] = 0x00009f6988f8361cUL;
   tf->codes[12142] = 0x00009fabdefcbf46UL;
   tf->codes[12143] = 0x00009fde31e5b492UL;
   tf->codes[12144] = 0x0000a07a6d7a1929UL;
   tf->codes[12145] = 0x0000a088618e791aUL;
   tf->codes[12146] = 0x0000a0ed41ef6977UL;
   tf->codes[12147] = 0x0000a12b3f568502UL;
   tf->codes[12148] = 0x0000a12f97f3f2a1UL;
   tf->codes[12149] = 0x0000a13dc6975857UL;
   tf->codes[12150] = 0x0000a147277f44e4UL;
   tf->codes[12151] = 0x0000a188cdd6bcbfUL;
   tf->codes[12152] = 0x0000a1d5347043c5UL;
   tf->codes[12153] = 0x0000a1ee2355b8a6UL;
   tf->codes[12154] = 0x0000a224944d15ccUL;
   tf->codes[12155] = 0x0000a25b054472f2UL;
   tf->codes[12156] = 0x0000a26306d23ce1UL;
   tf->codes[12157] = 0x0000a272cf5ecafaUL;
   tf->codes[12158] = 0x0000a27cdff3c8d6UL;
   tf->codes[12159] = 0x0000a2a1795763f6UL;
   tf->codes[12160] = 0x0000a31990a638f7UL;
   tf->codes[12161] = 0x0000a319cb353ebcUL;
   tf->codes[12162] = 0x0000a33a0bfb6c3dUL;
   tf->codes[12163] = 0x0000a350019d961dUL;
   tf->codes[12164] = 0x0000a35285c2d594UL;
   tf->codes[12165] = 0x0000a386e7b2fecdUL;
   tf->codes[12166] = 0x0000a3e5606f4d9eUL;
   tf->codes[12167] = 0x0000a4abb2cfd7cdUL;
   tf->codes[12168] = 0x0000a516fad569b6UL;
   tf->codes[12169] = 0x0000a5ed505187c3UL;
   tf->codes[12170] = 0x0000a5f6ebc87a15UL;
   tf->codes[12171] = 0x0000a5f9aa7cbf51UL;
   tf->codes[12172] = 0x0000a66985aec49eUL;
   tf->codes[12173] = 0x0000a67c0cef97f3UL;
   tf->codes[12174] = 0x0000a708456868acUL;
   tf->codes[12175] = 0x0000a73221a5887fUL;
   tf->codes[12176] = 0x0000a74c6fe51ffeUL;
   tf->codes[12177] = 0x0000a7ed3ea5f7f9UL;
   tf->codes[12178] = 0x0000a8199f085743UL;
   tf->codes[12179] = 0x0000a8888ffe457cUL;
   tf->codes[12180] = 0x0000a92d07af79c7UL;
   tf->codes[12181] = 0x0000a934ceae3df1UL;
   tf->codes[12182] = 0x0000a93afbc3d9b8UL;
   tf->codes[12183] = 0x0000a969309e672aUL;
   tf->codes[12184] = 0x0000a9b8cb0a3ef6UL;
   tf->codes[12185] = 0x0000a9d144d1a84dUL;
   tf->codes[12186] = 0x0000a9d478a3f913UL;
   tf->codes[12187] = 0x0000a9ec7d4d56e0UL;
   tf->codes[12188] = 0x0000aa97d1c13841UL;
   tf->codes[12189] = 0x0000ab8198ba40b7UL;
   tf->codes[12190] = 0x0000aba24e9e79c2UL;
   tf->codes[12191] = 0x0000aba965f02c9dUL;
   tf->codes[12192] = 0x0000abc75d20206cUL;
   tf->codes[12193] = 0x0000ac28cf1fba3eUL;
   tf->codes[12194] = 0x0000ac385d1d4292UL;
   tf->codes[12195] = 0x0000ac431d5f51bdUL;
   tf->codes[12196] = 0x0000ac7b62cedd0bUL;
   tf->codes[12197] = 0x0000ad51f2da00ddUL;
   tf->codes[12198] = 0x0000add1d1279a08UL;
   tf->codes[12199] = 0x0000ae1c9dd7f8abUL;
   tf->codes[12200] = 0x0000ae2f9a36d78aUL;
   tf->codes[12201] = 0x0000aeba735585a5UL;
   tf->codes[12202] = 0x0000aee91d4e1ea1UL;
   tf->codes[12203] = 0x0000aeec51206f67UL;
   tf->codes[12204] = 0x0000af47d0997337UL;
   tf->codes[12205] = 0x0000af57d3b50715UL;
   tf->codes[12206] = 0x0000af6ca48c141cUL;
   tf->codes[12207] = 0x0000af8901d2df88UL;
   tf->codes[12208] = 0x0000af91ed9cc08bUL;
   tf->codes[12209] = 0x0000afc2e12b9339UL;
   tf->codes[12210] = 0x0000afecbd68b30cUL;
   tf->codes[12211] = 0x0000aff2ea7e4ed3UL;
   tf->codes[12212] = 0x0000aff3d4ba65e7UL;
   tf->codes[12213] = 0x0000b0524d76b4b8UL;
   tf->codes[12214] = 0x0000b0566b851c92UL;
   tf->codes[12215] = 0x0000b05c237caccfUL;
   tf->codes[12216] = 0x0000b07e734a0e3dUL;
   tf->codes[12217] = 0x0000b08291587617UL;
   tf->codes[12218] = 0x0000b088f8fd17a3UL;
   tf->codes[12219] = 0x0000b0c97a8972a5UL;
   tf->codes[12220] = 0x0000b12e957968c7UL;
   tf->codes[12221] = 0x0000b13c146fbd2eUL;
   tf->codes[12222] = 0x0000b182fda0b9bcUL;
   tf->codes[12223] = 0x0000b1c469692bd2UL;
   tf->codes[12224] = 0x0000b1d9af5e4463UL;
   tf->codes[12225] = 0x0000b222a79674deUL;
   tf->codes[12226] = 0x0000b23f3f6c460fUL;
   tf->codes[12227] = 0x0000b25c11d11d05UL;
   tf->codes[12228] = 0x0000b28ffea33ab4UL;
   tf->codes[12229] = 0x0000b29a0f383890UL;
   tf->codes[12230] = 0x0000b2f2cffcf724UL;
   tf->codes[12231] = 0x0000b3526d8462ceUL;
   tf->codes[12232] = 0x0000b373d315ad28UL;
   tf->codes[12233] = 0x0000b3756cfed58bUL;
   tf->codes[12234] = 0x0000b3ff5be16c92UL;
   tf->codes[12235] = 0x0000b4601e33f515UL;
   tf->codes[12236] = 0x0000b4977967694fUL;
   tf->codes[12237] = 0x0000b4c190338ee7UL;
   tf->codes[12238] = 0x0000b4d48c926dc6UL;
   tf->codes[12239] = 0x0000b4e0e6bda554UL;
   tf->codes[12240] = 0x0000b5437d885bffUL;
   tf->codes[12241] = 0x0000b564a88aa094UL;
   tf->codes[12242] = 0x0000b56607e4c332UL;
   tf->codes[12243] = 0x0000b5755b5345c1UL;
   tf->codes[12244] = 0x0000b58fe421e305UL;
   tf->codes[12245] = 0x0000b59adef2f7f5UL;
   tf->codes[12246] = 0x0000b5b8d622ebc4UL;
   tf->codes[12247] = 0x0000b6078652ac7cUL;
   tf->codes[12248] = 0x0000b60a4506f1b8UL;
   tf->codes[12249] = 0x0000b61873aa576eUL;
   tf->codes[12250] = 0x0000b624cdd58efcUL;
   tf->codes[12251] = 0x0000b667d3872975UL;
   tf->codes[12252] = 0x0000b6913aa63dbeUL;
   tf->codes[12253] = 0x0000b6b5245cc78fUL;
   tf->codes[12254] = 0x0000b6c3c81e38cfUL;
   tf->codes[12255] = 0x0000b6e70227b151UL;
   tf->codes[12256] = 0x0000b76496df10caUL;
   tf->codes[12257] = 0x0000b7a42e2f54b8UL;
   tf->codes[12258] = 0x0000b7c9b1cf06ecUL;
   tf->codes[12259] = 0x0000b7fceef4134cUL;
   tf->codes[12260] = 0x0000b8687188aafaUL;
   tf->codes[12261] = 0x0000b86a808fdee7UL;
   tf->codes[12262] = 0x0000b876659d0aebUL;
   tf->codes[12263] = 0x0000b8e17313970fUL;
   tf->codes[12264] = 0x0000b8e59121fee9UL;
   tf->codes[12265] = 0x0000b93406c2b9dcUL;
   tf->codes[12266] = 0x0000b9c6e16f31e6UL;
   tf->codes[12267] = 0x0000b9d1dc4046d6UL;
   tf->codes[12268] = 0x0000b9df5b369b3dUL;
   tf->codes[12269] = 0x0000b9fd17d78947UL;
   tf->codes[12270] = 0x0000ba030a5e1f49UL;
   tf->codes[12271] = 0x0000ba037f7c2ad3UL;
   tf->codes[12272] = 0x0000ba1a24cb6602UL;
   tf->codes[12273] = 0x0000ba50d051c8edUL;
   tf->codes[12274] = 0x0000ba7a3770dd36UL;
   tf->codes[12275] = 0x0000bb1a5684a3e2UL;
   tf->codes[12276] = 0x0000bb4c6ede9369UL;
   tf->codes[12277] = 0x0000bb773557ca50UL;
   tf->codes[12278] = 0x0000bbbf7de2e97cUL;
   tf->codes[12279] = 0x0000bbd832395898UL;
   tf->codes[12280] = 0x0000bbe576a0a73aUL;
   tf->codes[12281] = 0x0000bbe69b6bc413UL;
   tf->codes[12282] = 0x0000bbe95a20094fUL;
   tf->codes[12283] = 0x0000bc1ac2cce787UL;
   tf->codes[12284] = 0x0000bc1afd5bed4cUL;
   tf->codes[12285] = 0x0000bc3969a9eca5UL;
   tf->codes[12286] = 0x0000bc730e739a91UL;
   tf->codes[12287] = 0x0000bcabc9013169UL;
   tf->codes[12288] = 0x0000bce0a00f662cUL;
   tf->codes[12289] = 0x0000bd90fccdc67bUL;
   tf->codes[12290] = 0x0000bda9b1243597UL;
   tf->codes[12291] = 0x0000be5664f23996UL;
   tf->codes[12292] = 0x0000be69d66f23ffUL;
   tf->codes[12293] = 0x0000becbbd8cc95bUL;
   tf->codes[12294] = 0x0000bed050b93cbfUL;
   tf->codes[12295] = 0x0000bf46ce1ee95dUL;
   tf->codes[12296] = 0x0000bf7fc33b85faUL;
   tf->codes[12297] = 0x0000bfd6ea171c2bUL;
   tf->codes[12298] = 0x0000bfdeb115e055UL;
   tf->codes[12299] = 0x0000bff0fdc7ade5UL;
   tf->codes[12300] = 0x0000c03269901ffbUL;
   tf->codes[12301] = 0x0000c063228fece4UL;
   tf->codes[12302] = 0x0000c08f48634669UL;
   tf->codes[12303] = 0x0000c0c66907b4deUL;
   tf->codes[12304] = 0x0000c12815965475UL;
   tf->codes[12305] = 0x0000c17fec1efbf5UL;
   tf->codes[12306] = 0x0000c1d95c90cbd8UL;
   tf->codes[12307] = 0x0000c2463e7f8624UL;
   tf->codes[12308] = 0x0000c24ce0b32d75UL;
   tf->codes[12309] = 0x0000c28b8dc75a4fUL;
   tf->codes[12310] = 0x0000c2a4421dc96bUL;
   tf->codes[12311] = 0x0000c2d98e4a09b8UL;
   tf->codes[12312] = 0x0000c2df464199f5UL;
   tf->codes[12313] = 0x0000c3157ca9f156UL;
   tf->codes[12314] = 0x0000c332147fc287UL;
   tf->codes[12315] = 0x0000c33a8b2b9800UL;
   tf->codes[12316] = 0x0000c357981f74bbUL;
   tf->codes[12317] = 0x0000c3a60dc02faeUL;
   tf->codes[12318] = 0x0000c3a857566960UL;
   tf->codes[12319] = 0x0000c47252a74fdfUL;
   tf->codes[12320] = 0x0000c4b9eb855dbcUL;
   tf->codes[12321] = 0x0000c4e318156c40UL;
   tf->codes[12322] = 0x0000c5562719c253UL;
   tf->codes[12323] = 0x0000c5692378a132UL;
   tf->codes[12324] = 0x0000c5d93939ac44UL;
   tf->codes[12325] = 0x0000c5fdd29d4764UL;
   tf->codes[12326] = 0x0000c62ae2acb7fdUL;
   tf->codes[12327] = 0x0000c65e94efcfe7UL;
   tf->codes[12328] = 0x0000c6cb01c07ea9UL;
   tf->codes[12329] = 0x0000c6f2cef66a8fUL;
   tf->codes[12330] = 0x0000c7213e5ffdc6UL;
   tf->codes[12331] = 0x0000c7661889c667UL;
   tf->codes[12332] = 0x0000c87c05562862UL;
   tf->codes[12333] = 0x0000c90c5bdd60f5UL;
   tf->codes[12334] = 0x0000c90c966c66baUL;
   tf->codes[12335] = 0x0000c9287e95269cUL;
   tf->codes[12336] = 0x0000c9354dde69b4UL;
   tf->codes[12337] = 0x0000c940f85c8ff3UL;
   tf->codes[12338] = 0x0000c948bf5b541dUL;
   tf->codes[12339] = 0x0000c9bb1eb298e1UL;
   tf->codes[12340] = 0x0000c9c40a7c79e4UL;
   tf->codes[12341] = 0x0000ca1120c31239UL;
   tf->codes[12342] = 0x0000ca79e4a364abUL;
   tf->codes[12343] = 0x0000caa34bc278f4UL;
   tf->codes[12344] = 0x0000cab7325d6ee7UL;
   tf->codes[12345] = 0x0000cb520e97b0e0UL;
   tf->codes[12346] = 0x0000cb5c944aba46UL;
   tf->codes[12347] = 0x0000cb61d7243ef9UL;
   tf->codes[12348] = 0x0000cbc6f214351bUL;
   tf->codes[12349] = 0x0000cc4c88595e83UL;
   tf->codes[12350] = 0x0000cc68ab11242aUL;
   tf->codes[12351] = 0x0000cc7c91ac1a1dUL;
   tf->codes[12352] = 0x0000ccc08199cbaaUL;
   tf->codes[12353] = 0x0000ccdd196f9cdbUL;
   tf->codes[12354] = 0x0000cce7d9b1ac06UL;
   tf->codes[12355] = 0x0000ccfa9b818520UL;
   tf->codes[12356] = 0x0000ccfbc04ca1f9UL;
   tf->codes[12357] = 0x0000ccff693cfe49UL;
   tf->codes[12358] = 0x0000cd06f5acbcaeUL;
   tf->codes[12359] = 0x0000cd27ab90f5b9UL;
   tf->codes[12360] = 0x0000cd3f3b1c47fcUL;
   tf->codes[12361] = 0x0000cd55a5dc7d66UL;
   tf->codes[12362] = 0x0000cd6c85babe5aUL;
   tf->codes[12363] = 0x0000ce5b54fe45beUL;
   tf->codes[12364] = 0x0000ce71bfbe7b28UL;
   tf->codes[12365] = 0x0000ce81884b0941UL;
   tf->codes[12366] = 0x0000ce8272872055UL;
   tf->codes[12367] = 0x0000cea9ca9f00b1UL;
   tf->codes[12368] = 0x0000cef9da28e407UL;
   tf->codes[12369] = 0x0000cf07ce3d43f8UL;
   tf->codes[12370] = 0x0000cf087dea5547UL;
   tf->codes[12371] = 0x0000cf09dd4477e5UL;
   tf->codes[12372] = 0x0000cf0bb1bca60dUL;
   tf->codes[12373] = 0x0000cf2306b8f28bUL;
   tf->codes[12374] = 0x0000cf84edd697e7UL;
   tf->codes[12375] = 0x0000cfc2eb3db372UL;
   tf->codes[12376] = 0x0000cfc44a97d610UL;
   tf->codes[12377] = 0x0000d015b97bdc04UL;
   tf->codes[12378] = 0x0000d05f61611dceUL;
   tf->codes[12379] = 0x0000d07c6e54fa89UL;
   tf->codes[12380] = 0x0000d09054eff07cUL;
   tf->codes[12381] = 0x0000d0b59e009cebUL;
   tf->codes[12382] = 0x0000d0c2e267eb8dUL;
   tf->codes[12383] = 0x0000d0d70391e745UL;
   tf->codes[12384] = 0x0000d10488bf6368UL;
   tf->codes[12385] = 0x0000d141615b621aUL;
   tf->codes[12386] = 0x0000d1675a191fd8UL;
   tf->codes[12387] = 0x0000d179e159f32dUL;
   tf->codes[12388] = 0x0000d20ae78e3d0fUL;
   tf->codes[12389] = 0x0000d2462641135eUL;
   tf->codes[12390] = 0x0000d275ba75c36eUL;
   tf->codes[12391] = 0x0000d2ab41310980UL;
   tf->codes[12392] = 0x0000d2bb444c9d5eUL;
   tf->codes[12393] = 0x0000d2c6048eac89UL;
   tf->codes[12394] = 0x0000d332715f5b4bUL;
   tf->codes[12395] = 0x0000d56c3f0c7f32UL;
   tf->codes[12396] = 0x0000d573565e320dUL;
   tf->codes[12397] = 0x0000d6358ab05462UL;
   tf->codes[12398] = 0x0000d676bbe9c0b3UL;
   tf->codes[12399] = 0x0000d6a10d44ec10UL;
   tf->codes[12400] = 0x0000d90a6f26c007UL;
   tf->codes[12401] = 0x0000d91703e0fd5aUL;
   tf->codes[12402] = 0x0000d9cf9cbc2d5dUL;
   tf->codes[12403] = 0x0000da190a126962UL;
   tf->codes[12404] = 0x0000da34b7ac237fUL;
   tf->codes[12405] = 0x0000da5c84e20f65UL;
   tf->codes[12406] = 0x0000db45270ffb02UL;
   tf->codes[12407] = 0x0000dbe50b94bbe9UL;
   tf->codes[12408] = 0x0000dc3d1cac692eUL;
   tf->codes[12409] = 0x0000dd58fbff612bUL;
   tf->codes[12410] = 0x0000dd61e7c9422eUL;
   tf->codes[12411] = 0x0000dd8d2360849fUL;
   tf->codes[12412] = 0x0000dd94002331b5UL;
   tf->codes[12413] = 0x0000de95cbc597f8UL;
   tf->codes[12414] = 0x0000deb6bc38d6c8UL;
   tf->codes[12415] = 0x0000dec94379aa1dUL;
   tf->codes[12416] = 0x0000df35b04a58dfUL;
   tf->codes[12417] = 0x0000df4035fd6245UL;
   tf->codes[12418] = 0x0000df849b091f5cUL;
   tf->codes[12419] = 0x0000dfa42c223b8eUL;
   tf->codes[12420] = 0x0000dfc85067cb24UL;
   tf->codes[12421] = 0x0000dff525e835f8UL;
   tf->codes[12422] = 0x0000dffa2e32b4e6UL;
   tf->codes[12423] = 0x0000e00e4f5cb09eUL;
   tf->codes[12424] = 0x0000e04b6287b515UL;
   tf->codes[12425] = 0x0000e0df61ff49f8UL;
   tf->codes[12426] = 0x0000e1ba4aa7db69UL;
   tf->codes[12427] = 0x0000e1bb6f72f842UL;
   tf->codes[12428] = 0x0000e1d5f8419586UL;
   tf->codes[12429] = 0x0000e263901488ddUL;
   tf->codes[12430] = 0x0000e32b07402fe5UL;
   tf->codes[12431] = 0x0000e3a0d4f8cb34UL;
   tf->codes[12432] = 0x0000e42fcc25e129UL;
   tf->codes[12433] = 0x0000e4b64ca721a5UL;
   tf->codes[12434] = 0x0000e50e984dd4afUL;
   tf->codes[12435] = 0x0000e57cd996b199UL;
   tf->codes[12436] = 0x0000e5ba2750bbd5UL;
   tf->codes[12437] = 0x0000e748db190420UL;
   tf->codes[12438] = 0x0000e7820ac4a682UL;
   tf->codes[12439] = 0x0000e893d982a0a3UL;
   tf->codes[12440] = 0x0000e8c9d55bf23fUL;
   tf->codes[12441] = 0x0000e92679a012e8UL;
   tf->codes[12442] = 0x0000e9555e27b1a9UL;
   tf->codes[12443] = 0x0000e9785da22466UL;
   tf->codes[12444] = 0x0000ea0afdbf96abUL;
   tf->codes[12445] = 0x0000ea4258f30ae5UL;
   tf->codes[12446] = 0x0000ea4601e36735UL;
   tf->codes[12447] = 0x0000ea9a2f7bb265UL;
   tf->codes[12448] = 0x0000eb42158e3d3bUL;
   tf->codes[12449] = 0x0000eb763cef60afUL;
   tf->codes[12450] = 0x0000eca08574c427UL;
   tf->codes[12451] = 0x0000ecaf29363567UL;
   tf->codes[12452] = 0x0000ecd3fd28d64cUL;
   tf->codes[12453] = 0x0000ed11fa8ff1d7UL;
   tf->codes[12454] = 0x0000eddf29b3291cUL;
   tf->codes[12455] = 0x0000ee243e6bf782UL;
   tf->codes[12456] = 0x0000ee6ab27ee886UL;
   tf->codes[12457] = 0x0000ee72045fa126UL;
   tf->codes[12458] = 0x0000ee77bc573163UL;
   tf->codes[12459] = 0x0000ee93df0ef70aUL;
   tf->codes[12460] = 0x0000eea457489672UL;
   tf->codes[12461] = 0x0000eef96f1cf8b6UL;
   tf->codes[12462] = 0x0000ef151cb6b2d3UL;
   tf->codes[12463] = 0x0000ef2ce6d10adbUL;
   tf->codes[12464] = 0x0000ef34e85ed4caUL;
   tf->codes[12465] = 0x0000ef814ef85bd0UL;
   tf->codes[12466] = 0x0000ef877c0df797UL;
   tf->codes[12467] = 0x0000efceda5cffafUL;
   tf->codes[12468] = 0x0000efd074462812UL;
   tf->codes[12469] = 0x0000f03bf6dabfc0UL;
   tf->codes[12470] = 0x0000f0db2bb26f58UL;
   tf->codes[12471] = 0x0000f103e3247252UL;
   tf->codes[12472] = 0x0000f14046a2657aUL;
   tf->codes[12473] = 0x0000f14673b80141UL;
   tf->codes[12474] = 0x0000f15f9d2c7be7UL;
   tf->codes[12475] = 0x0000f175cd5dab8cUL;
   tf->codes[12476] = 0x0000f22ea0c7e154UL;
   tf->codes[12477] = 0x0000f2716bea7608UL;
   tf->codes[12478] = 0x0000f3182d31e405UL;
   tf->codes[12479] = 0x0000f36c5aca2f35UL;
   tf->codes[12480] = 0x0000f3724d50c537UL;
   tf->codes[12481] = 0x0000f390b99ec490UL;
   tf->codes[12482] = 0x0000f39d4e5901e3UL;
   tf->codes[12483] = 0x0000f3df2f3f7f83UL;
   tf->codes[12484] = 0x0000f3efa7791eebUL;
   tf->codes[12485] = 0x0000f42fb3e76e63UL;
   tf->codes[12486] = 0x0000f46c8c836d15UL;
   tf->codes[12487] = 0x0000f470aa91d4efUL;
   tf->codes[12488] = 0x0000f4907639f6e6UL;
   tf->codes[12489] = 0x0000f492fa5f365dUL;
   tf->codes[12490] = 0x0000f49edf6c6261UL;
   tf->codes[12491] = 0x0000f5138859e0d7UL;
   tf->codes[12492] = 0x0000f51f6d670cdbUL;
   tf->codes[12493] = 0x0000f52475b18bc9UL;
   tf->codes[12494] = 0x0000f5c57f016989UL;
   tf->codes[12495] = 0x0000f6408f93898bUL;
   tf->codes[12496] = 0x0000f68e1af82d6aUL;
   tf->codes[12497] = 0x0000f6a117570c49UL;
   tf->codes[12498] = 0x0000f6bcff7fcc2bUL;
   tf->codes[12499] = 0x0000f6d8e7a88c0dUL;
   tf->codes[12500] = 0x0000f71809dac471UL;
   tf->codes[12501] = 0x0000f74d560704beUL;
   tf->codes[12502] = 0x0000f782dcc24ad0UL;
   tf->codes[12503] = 0x0000f7e06b42828dUL;
   tf->codes[12504] = 0x0000f7ecc56dba1bUL;
   tf->codes[12505] = 0x0000f891eccbffb5UL;
   tf->codes[12506] = 0x0000f89311971c8eUL;
   tf->codes[12507] = 0x0000f8ecbc97f236UL;
   tf->codes[12508] = 0x0000f9d0910a64aaUL;
   tf->codes[12509] = 0x0000f9e94560d3c6UL;
   tf->codes[12510] = 0x0000fa20a0944800UL;
   tf->codes[12511] = 0x0000fadf668513caUL;
   tf->codes[12512] = 0x0000fb0b173a61c5UL;
   tf->codes[12513] = 0x0000fb86625b878cUL;
   tf->codes[12514] = 0x0000fbe21c639121UL;
   tf->codes[12515] = 0x0000fcdd0b434a4eUL;
   tf->codes[12516] = 0x0000fcebaf04bb8eUL;
   tf->codes[12517] = 0x0000fd1ace1b6014UL;
   tf->codes[12518] = 0x0000fd7946d7aee5UL;
   tf->codes[12519] = 0x0000fdc91bd28c76UL;
   tf->codes[12520] = 0x0000fe0c218426efUL;
   tf->codes[12521] = 0x0000fe0e6b1a60a1UL;
   tf->codes[12522] = 0x0000fe12140abcf1UL;
   tf->codes[12523] = 0x0000fee8dea4e688UL;
   tf->codes[12524] = 0x0000ffb97c297458UL;
   tf->codes[12525] = 0x0000ffcf373c9873UL;
   tf->codes[12526] = 0x0000ffdb1c49c477UL;
   tf->codes[12527] = 0x00000022efb6d819UL;
   tf->codes[12528] = 0x000000d34c753868UL;
   tf->codes[12529] = 0x00000107e8f46766UL;
   tf->codes[12530] = 0x0000013f0998d5dbUL;
   tf->codes[12531] = 0x00000185f2c9d269UL;
   tf->codes[12532] = 0x0000036d2cc7d383UL;
   tf->codes[12533] = 0x000003ba7d9d719dUL;
   tf->codes[12534] = 0x00000401a15d73f0UL;
   tf->codes[12535] = 0x000004b70666532dUL;
   tf->codes[12536] = 0x000005c1f861a038UL;
   tf->codes[12537] = 0x0000067ee9da3ddaUL;
   tf->codes[12538] = 0x000007583899a6e8UL;
   tf->codes[12539] = 0x000007b21e298255UL;
   tf->codes[12540] = 0x000007fe84c3095bUL;
   tf->codes[12541] = 0x00000805d6a3c1fbUL;
   tf->codes[12542] = 0x0000084ab0cd8a9cUL;
   tf->codes[12543] = 0x00000868e28c8430UL;
   tf->codes[12544] = 0x0000088a82acd44fUL;
   tf->codes[12545] = 0x0000088f8af7533dUL;
   tf->codes[12546] = 0x000008c511b2994fUL;
   tf->codes[12547] = 0x000009756e70f99eUL;
   tf->codes[12548] = 0x00000af5f395dc33UL;
   tf->codes[12549] = 0x00000b207f800d55UL;
   tf->codes[12550] = 0x00000b20ba0f131aUL;
   tf->codes[12551] = 0x00000b267206a357UL;
   tf->codes[12552] = 0x00000b3724cf4884UL;
   tf->codes[12553] = 0x00000becfef6334bUL;
   tf->codes[12554] = 0x00000ced30af712bUL;
   tf->codes[12555] = 0x00000d53aaf989ebUL;
   tf->codes[12556] = 0x00000d6b3a84dc2eUL;
   tf->codes[12557] = 0x00000ed46aad7245UL;
   tf->codes[12558] = 0x00000ee3f8aafa99UL;
   tf->codes[12559] = 0x00000ef1b23054c5UL;
   tf->codes[12560] = 0x00000f0732b4731bUL;
   tf->codes[12561] = 0x00000fe2cb0a15dbUL;
   tf->codes[12562] = 0x00001048d0362311UL;
   tf->codes[12563] = 0x000010526bad1563UL;
   tf->codes[12564] = 0x0000107ff0da9186UL;
   tf->codes[12565] = 0x000010ad3b7907e4UL;
   tf->codes[12566] = 0x000011bb9bd5ab7aUL;
   tf->codes[12567] = 0x000011e9d0b038ecUL;
   tf->codes[12568] = 0x000012184019cc23UL;
   tf->codes[12569] = 0x000012c0d5d96848UL;
   tf->codes[12570] = 0x000012f572589746UL;
   tf->codes[12571] = 0x000012fa05850aaaUL;
   tf->codes[12572] = 0x0000133927b7430eUL;
   tf->codes[12573] = 0x0000136a90642146UL;
   tf->codes[12574] = 0x0000137f26ac2888UL;
   tf->codes[12575] = 0x000013d5634ba7a5UL;
   tf->codes[12576] = 0x000013ed2d65ffadUL;
   tf->codes[12577] = 0x00001446d866d555UL;
   tf->codes[12578] = 0x00001585b734400fUL;
   tf->codes[12579] = 0x000015a9665bc41bUL;
   tf->codes[12580] = 0x000015c0bb581099UL;
   tf->codes[12581] = 0x0000161c3ad11469UL;
   tf->codes[12582] = 0x0000165863c001ccUL;
   tf->codes[12583] = 0x000016870db89ac8UL;
   tf->codes[12584] = 0x000016b4cd751cb0UL;
   tf->codes[12585] = 0x00001714a58b8e1fUL;
   tf->codes[12586] = 0x000017329cbb81eeUL;
   tf->codes[12587] = 0x000017a8a5032302UL;
   tf->codes[12588] = 0x00001816712df462UL;
   tf->codes[12589] = 0x00001838fb8a5b95UL;
   tf->codes[12590] = 0x0000184e7c0e79ebUL;
   tf->codes[12591] = 0x00001861786d58caUL;
   tf->codes[12592] = 0x00001886fc0d0afeUL;
   tf->codes[12593] = 0x000018cf7f272fefUL;
   tf->codes[12594] = 0x000018fcc9c5a64dUL;
   tf->codes[12595] = 0x00001983bf64f253UL;
   tf->codes[12596] = 0x00001988529165b7UL;
   tf->codes[12597] = 0x0000199263266393UL;
   tf->codes[12598] = 0x0000199e82c2955cUL;
   tf->codes[12599] = 0x00001a3a4938ee69UL;
   tf->codes[12600] = 0x00001a4d0b08c783UL;
   tf->codes[12601] = 0x00001b0fb478f562UL;
   tf->codes[12602] = 0x00001bd9afc9dbe1UL;
   tf->codes[12603] = 0x00001c5744813b5aUL;
   tf->codes[12604] = 0x00001ca8b365414eUL;
   tf->codes[12605] = 0x00001cf086d254f0UL;
   tf->codes[12606] = 0x00001d2389685b8bUL;
   tf->codes[12607] = 0x00001d44b46aa020UL;
   tf->codes[12608] = 0x00001db280957180UL;
   tf->codes[12609] = 0x00001dbc1c0c63d2UL;
   tf->codes[12610] = 0x00001e51effc26ddUL;
   tf->codes[12611] = 0x00001ecbdbc32a06UL;
   tf->codes[12612] = 0x00001fa5651198d9UL;
   tf->codes[12613] = 0x00001fef4785e068UL;
   tf->codes[12614] = 0x0000201d41d16815UL;
   tf->codes[12615] = 0x00002089aea216d7UL;
   tf->codes[12616] = 0x000021039a691a00UL;
   tf->codes[12617] = 0x0000210a020dbb8cUL;
   tf->codes[12618] = 0x0000217cd6830bdaUL;
   tf->codes[12619] = 0x000022a376181302UL;
   tf->codes[12620] = 0x000022a3b0a718c7UL;
   tf->codes[12621] = 0x0000237cc4d77c10UL;
   tf->codes[12622] = 0x000023969df90805UL;
   tf->codes[12623] = 0x0000249326c1e995UL;
   tf->codes[12624] = 0x00002513ef4b99d4UL;
   tf->codes[12625] = 0x0000258d2b658baeUL;
   tf->codes[12626] = 0x000025b4f89b7794UL;
   tf->codes[12627] = 0x000025e710f5671bUL;
   tf->codes[12628] = 0x000027292395229bUL;
   tf->codes[12629] = 0x0000278ca49bf05aUL;
   tf->codes[12630] = 0x000027c55f298732UL;
   tf->codes[12631] = 0x000028202ef579b3UL;
   tf->codes[12632] = 0x0000285874650501UL;
   tf->codes[12633] = 0x00002982f7796e3eUL;
   tf->codes[12634] = 0x000029c54d7df768UL;
   tf->codes[12635] = 0x00002a3c0572a9cbUL;
   tf->codes[12636] = 0x00002a514b67c25cUL;
   tf->codes[12637] = 0x00002a62addd78d8UL;
   tf->codes[12638] = 0x00002a9db2014962UL;
   tf->codes[12639] = 0x00002a9ffb978314UL;
   tf->codes[12640] = 0x00002b1ca612cb79UL;
   tf->codes[12641] = 0x00002b2173ce44a2UL;
   tf->codes[12642] = 0x00002b37a3ff7447UL;
   tf->codes[12643] = 0x00002b4522f5c8aeUL;
   tf->codes[12644] = 0x00002b7f024e7c5fUL;
   tf->codes[12645] = 0x00002be41d3e7281UL;
   tf->codes[12646] = 0x00002be62c45a66eUL;
   tf->codes[12647] = 0x00002c46797a2367UL;
   tf->codes[12648] = 0x00002ccc84dd5859UL;
   tf->codes[12649] = 0x00002d0280b6a9f5UL;
   tf->codes[12650] = 0x00002d0f4fffed0dUL;
   tf->codes[12651] = 0x00002d0fffacfe5cUL;
   tf->codes[12652] = 0x00002d542a29b5aeUL;
   tf->codes[12653] = 0x00002dcfea68e6ffUL;
   tf->codes[12654] = 0x00002e1f0fb6b341UL;
   tf->codes[12655] = 0x00002e269c2671a6UL;
   tf->codes[12656] = 0x00002e50b2f2973eUL;
   tf->codes[12657] = 0x00002e66a894c11eUL;
   tf->codes[12658] = 0x00002e854f71c63cUL;
   tf->codes[12659] = 0x00002e90bf60e6b6UL;
   tf->codes[12660] = 0x00002ecc38a2c2caUL;
   tf->codes[12661] = 0x00002f291775e938UL;
   tf->codes[12662] = 0x00002f4a42782dcdUL;
   tf->codes[12663] = 0x00002f5abab1cd35UL;
   tf->codes[12664] = 0x000030c8f324e23aUL;
   tf->codes[12665] = 0x0000312905ca596eUL;
   tf->codes[12666] = 0x00003319a0b04715UL;
   tf->codes[12667] = 0x000033855dd3e488UL;
   tf->codes[12668] = 0x000033aa6c558b32UL;
   tf->codes[12669] = 0x00003405019277eeUL;
   tf->codes[12670] = 0x000034399e11a6ecUL;
   tf->codes[12671] = 0x00003461a5d69897UL;
   tf->codes[12672] = 0x0000346639030bfbUL;
   tf->codes[12673] = 0x00003487d9235c1aUL;
   tf->codes[12674] = 0x000034a22762f399UL;
   tf->codes[12675] = 0x000034a4366a2786UL;
   tf->codes[12676] = 0x000034f1c1cecb65UL;
   tf->codes[12677] = 0x00003565f59e3e51UL;
   tf->codes[12678] = 0x000035bb0d72a095UL;
   tf->codes[12679] = 0x000035d93f319a29UL;
   tf->codes[12680] = 0x000035f6c143826eUL;
   tf->codes[12681] = 0x00003624f61e0fe0UL;
   tf->codes[12682] = 0x0000368c201539efUL;
   tf->codes[12683] = 0x0000368ea43a7966UL;
   tf->codes[12684] = 0x000036fc70654ac6UL;
   tf->codes[12685] = 0x0000378415b1a81bUL;
   tf->codes[12686] = 0x000038313e9db7a4UL;
   tf->codes[12687] = 0x000038455fc7b35cUL;
   tf->codes[12688] = 0x0000384f35cdab73UL;
   tf->codes[12689] = 0x000039543542627cUL;
   tf->codes[12690] = 0x00003a1ac231f270UL;
   tf->codes[12691] = 0x00003ad4ba674511UL;
   tf->codes[12692] = 0x00003b77d2be56beUL;
   tf->codes[12693] = 0x00003b881068f061UL;
   tf->codes[12694] = 0x00003b9f2ad6371aUL;
   tf->codes[12695] = 0x00003bbcace81f5fUL;
   tf->codes[12696] = 0x00003be5645a2259UL;
   tf->codes[12697] = 0x00003c7d47511951UL;
   tf->codes[12698] = 0x00003cb84b74e9dbUL;
   tf->codes[12699] = 0x00003cd7a1ff0048UL;
   tf->codes[12700] = 0x00003cfceb0facb7UL;
   tf->codes[12701] = 0x00003dd42ac7e1d8UL;
   tf->codes[12702] = 0x00003e08c74710d6UL;
   tf->codes[12703] = 0x00003e201c435d54UL;
   tf->codes[12704] = 0x00003e29f249556bUL;
   tf->codes[12705] = 0x00003e3fad5c7986UL;
   tf->codes[12706] = 0x00003e5c45324ab7UL;
   tf->codes[12707] = 0x00003ea5b28886bcUL;
   tf->codes[12708] = 0x00003ee5f985dbf9UL;
   tf->codes[12709] = 0x00003ee8b83a2135UL;
   tf->codes[12710] = 0x00003f26b5a13cc0UL;
   tf->codes[12711] = 0x00003f48905092a4UL;
   tf->codes[12712] = 0x000040b94ce8e720UL;
   tf->codes[12713] = 0x000040d8a372fd8dUL;
   tf->codes[12714] = 0x00004122c0764ae1UL;
   tf->codes[12715] = 0x00004146350ec928UL;
   tf->codes[12716] = 0x000043369565b10aUL;
   tf->codes[12717] = 0x0000438c22581ed8UL;
   tf->codes[12718] = 0x000043b5fe953eabUL;
   tf->codes[12719] = 0x000043c3086d8788UL;
   tf->codes[12720] = 0x000043ca1fbf3a63UL;
   tf->codes[12721] = 0x00004457b7922dbaUL;
   tf->codes[12722] = 0x0000445a3bb76d31UL;
   tf->codes[12723] = 0x0000447031599711UL;
   tf->codes[12724] = 0x00004513beceb448UL;
   tf->codes[12725] = 0x0000456aab1b44b4UL;
   tf->codes[12726] = 0x00004623f3a38606UL;
   tf->codes[12727] = 0x00004689f8cf933cUL;
   tf->codes[12728] = 0x000046a40c8024f6UL;
   tf->codes[12729] = 0x000046dd3c2bc758UL;
   tf->codes[12730] = 0x0000471ac474d759UL;
   tf->codes[12731] = 0x00004749e38b7bdfUL;
   tf->codes[12732] = 0x0000482af949a917UL;
   tf->codes[12733] = 0x00004836a3c7cf56UL;
   tf->codes[12734] = 0x00004853762ca64cUL;
   tf->codes[12735] = 0x000048946cd70cd8UL;
   tf->codes[12736] = 0x000048abc1d35956UL;
   tf->codes[12737] = 0x000048ff3fbe9337UL;
   tf->codes[12738] = 0x000049d13c9d43a5UL;
   tf->codes[12739] = 0x00004a01f59d108eUL;
   tf->codes[12740] = 0x00004a5c8ad9fd4aUL;
   tf->codes[12741] = 0x00004aa498d616b1UL;
   tf->codes[12742] = 0x00004aa5f830394fUL;
   tf->codes[12743] = 0x00004b109088b9e9UL;
   tf->codes[12744] = 0x00004b32e0561b57UL;
   tf->codes[12745] = 0x00004ba74eb49408UL;
   tf->codes[12746] = 0x00004c13f614488fUL;
   tf->codes[12747] = 0x00004c5b8ef2566cUL;
   tf->codes[12748] = 0x00004c6564f84e83UL;
   tf->codes[12749] = 0x00004c8c0d631d90UL;
   tf->codes[12750] = 0x00004ce0758a6e85UL;
   tf->codes[12751] = 0x00004ce7524d1b9bUL;
   tf->codes[12752] = 0x00004d0a17388893UL;
   tf->codes[12753] = 0x00004d7cb11ed31cUL;
   tf->codes[12754] = 0x00004eafaadf11d2UL;
   tf->codes[12755] = 0x00004f04fd4279dbUL;
   tf->codes[12756] = 0x00004f153aed137eUL;
   tf->codes[12757] = 0x00004f23deae84beUL;
   tf->codes[12758] = 0x00004f6375fec8acUL;
   tf->codes[12759] = 0x00004f733e8b56c5UL;
   tf->codes[12760] = 0x00004f858b3d2455UL;
   tf->codes[12761] = 0x00004fa51c564087UL;
   tf->codes[12762] = 0x00004fb3c017b1c7UL;
   tf->codes[12763] = 0x000050161c5362adUL;
   tf->codes[12764] = 0x000050469ac429d1UL;
   tf->codes[12765] = 0x000050c6b3a0c8c1UL;
   tf->codes[12766] = 0x000050d3bd79119eUL;
   tf->codes[12767] = 0x000050e7a4140791UL;
   tf->codes[12768] = 0x0000517242a3afe7UL;
   tf->codes[12769] = 0x00005208512278b7UL;
   tf->codes[12770] = 0x0000524a3208f657UL;
   tf->codes[12771] = 0x00005297bd6d9a36UL;
   tf->codes[12772] = 0x000052a8e5544aedUL;
   tf->codes[12773] = 0x0000533fde0f2ad1UL;
   tf->codes[12774] = 0x000053a4be701b2eUL;
   tf->codes[12775] = 0x000053ac1050d3ceUL;
   tf->codes[12776] = 0x000053cbdbf8f5c5UL;
   tf->codes[12777] = 0x000053d11ed27a78UL;
   tf->codes[12778] = 0x00005473fc9a8660UL;
   tf->codes[12779] = 0x000054a10ca9f6f9UL;
   tf->codes[12780] = 0x000055303e6612b3UL;
   tf->codes[12781] = 0x0000556a1dbec664UL;
   tf->codes[12782] = 0x000055a90561f903UL;
   tf->codes[12783] = 0x000055eaabb970deUL;
   tf->codes[12784] = 0x000055eb20d77c68UL;
   tf->codes[12785] = 0x0000564e2cc03e9dUL;
   tf->codes[12786] = 0x000056e4eaec18bcUL;
   tf->codes[12787] = 0x000056f56325b824UL;
   tf->codes[12788] = 0x00005765b375c8fbUL;
   tf->codes[12789] = 0x000057cca2dded45UL;
   tf->codes[12790] = 0x000057e08978e338UL;
   tf->codes[12791] = 0x000058181f3b5d37UL;
   tf->codes[12792] = 0x000058d28c8ebb62UL;
   tf->codes[12793] = 0x000058e1dffd3df1UL;
   tf->codes[12794] = 0x000059bb2ebca6ffUL;
   tf->codes[12795] = 0x000059e754900084UL;
   tf->codes[12796] = 0x000059f498f74f26UL;
   tf->codes[12797] = 0x00005a6e4a2f4c8aUL;
   tf->codes[12798] = 0x00005a8d2b9b576dUL;
   tf->codes[12799] = 0x00005abaeb57d955UL;
   tf->codes[12800] = 0x00005ae0a986914eUL;
   tf->codes[12801] = 0x00005b349c8fd6b9UL;
   tf->codes[12802] = 0x00005b7bc04fd90cUL;
   tf->codes[12803] = 0x00005bab5484891cUL;
   tf->codes[12804] = 0x00005bd5e06eba3eUL;
   tf->codes[12805] = 0x00005bf8a55a2736UL;
   tf->codes[12806] = 0x00005c05e9c175d8UL;
   tf->codes[12807] = 0x00005c43377b8014UL;
   tf->codes[12808] = 0x00005ca34a20f748UL;
   tf->codes[12809] = 0x00005cf4f3940301UL;
   tf->codes[12810] = 0x00005d45b2caf7a6UL;
   tf->codes[12811] = 0x00005d996b45374cUL;
   tf->codes[12812] = 0x00005de1b3d05678UL;
   tf->codes[12813] = 0x00005e73a440b76eUL;
   tf->codes[12814] = 0x00005eb33b90fb5cUL;
   tf->codes[12815] = 0x00005f1fa861aa1eUL;
   tf->codes[12816] = 0x00005f6447fc6cfaUL;
   tf->codes[12817] = 0x00005fc544ddfb42UL;
   tf->codes[12818] = 0x00005fca87b77ff5UL;
   tf->codes[12819] = 0x000060a4c0b30017UL;
   tf->codes[12820] = 0x000060e83b82a61aUL;
   tf->codes[12821] = 0x0000611bb336b83fUL;
   tf->codes[12822] = 0x00006185615321c5UL;
   tf->codes[12823] = 0x000061e832acde35UL;
   tf->codes[12824] = 0x000062b8d0316c05UL;
   tf->codes[12825] = 0x00006331220f46cbUL;
   tf->codes[12826] = 0x000063633a693652UL;
   tf->codes[12827] = 0x000063d474f55e3dUL;
   tf->codes[12828] = 0x0000642b26b2e8e4UL;
   tf->codes[12829] = 0x00006434879ad571UL;
   tf->codes[12830] = 0x000064669ff4c4f8UL;
   tf->codes[12831] = 0x0000647668815311UL;
   tf->codes[12832] = 0x000064af5d9defaeUL;
   tf->codes[12833] = 0x000064e97785a924UL;
   tf->codes[12834] = 0x0000650400544668UL;
   tf->codes[12835] = 0x00006532352ed3daUL;
   tf->codes[12836] = 0x0000654de2c88df7UL;
   tf->codes[12837] = 0x000065bd836b8d7fUL;
   tf->codes[12838] = 0x000065bf1d54b5e2UL;
   tf->codes[12839] = 0x0000666c4640c56bUL;
   tf->codes[12840] = 0x000066a7bf82a17fUL;
   tf->codes[12841] = 0x00006730feb82737UL;
   tf->codes[12842] = 0x000068b701459444UL;
   tf->codes[12843] = 0x0000696290487b6aUL;
   tf->codes[12844] = 0x00006976b1727722UL;
   tf->codes[12845] = 0x0000699592de8205UL;
   tf->codes[12846] = 0x00006a628772b385UL;
   tf->codes[12847] = 0x00006a9a57c43349UL;
   tf->codes[12848] = 0x00006aae3e5f293cUL;
   tf->codes[12849] = 0x00006ae056b918c3UL;
   tf->codes[12850] = 0x00006ae81db7dcedUL;
   tf->codes[12851] = 0x00006b2028986276UL;
   tf->codes[12852] = 0x00006b335f86471aUL;
   tf->codes[12853] = 0x00006b36cde79da5UL;
   tf->codes[12854] = 0x00006b8c5ada0b73UL;
   tf->codes[12855] = 0x00006cfacddc263dUL;
   tf->codes[12856] = 0x00006dacc483aeefUL;
   tf->codes[12857] = 0x00006e27d515cef1UL;
   tf->codes[12858] = 0x00006eb691b3df21UL;
   tf->codes[12859] = 0x00006fe398ed87d5UL;
   tf->codes[12860] = 0x00007050effa4dabUL;
   tf->codes[12861] = 0x00007061a2c2f2d8UL;
   tf->codes[12862] = 0x0000707e7527c9ceUL;
   tf->codes[12863] = 0x000070afa345a241UL;
   tf->codes[12864] = 0x000070d7ab0a93ecUL;
   tf->codes[12865] = 0x0000718a8bee33b2UL;
   tf->codes[12866] = 0x00007250de4ebde1UL;
   tf->codes[12867] = 0x00007281974e8acaUL;
   tf->codes[12868] = 0x0000734feb3cdee8UL;
   tf->codes[12869] = 0x0000738990068cd4UL;
   tf->codes[12870] = 0x0000739d3c127d02UL;
   tf->codes[12871] = 0x000073ca86b0f360UL;
   tf->codes[12872] = 0x000073d4d1d4f701UL;
   tf->codes[12873] = 0x0000740e01809963UL;
   tf->codes[12874] = 0x00007431b0a81d6fUL;
   tf->codes[12875] = 0x000074390288d60fUL;
   tf->codes[12876] = 0x000074460c611eecUL;
   tf->codes[12877] = 0x0000744ada1c9815UL;
   tf->codes[12878] = 0x000074e8ea292ad4UL;
   tf->codes[12879] = 0x00007557a0901348UL;
   tf->codes[12880] = 0x0000757e0e6bdc90UL;
   tf->codes[12881] = 0x0000758400f27292UL;
   tf->codes[12882] = 0x000075dc120a1fd7UL;
   tf->codes[12883] = 0x000075f7fa32dfb9UL;
   tf->codes[12884] = 0x000075fe9c66870aUL;
   tf->codes[12885] = 0x0000767ca63bf20dUL;
   tf->codes[12886] = 0x000076ac3a70a21dUL;
   tf->codes[12887] = 0x0000779acf2523bcUL;
   tf->codes[12888] = 0x0000783a3e8bd919UL;
   tf->codes[12889] = 0x00007847486421f6UL;
   tf->codes[12890] = 0x000078b34016c52eUL;
   tf->codes[12891] = 0x000079dd137e1d1cUL;
   tf->codes[12892] = 0x00007ab06fb6f028UL;
   tf->codes[12893] = 0x00007adc958a49adUL;
   tf->codes[12894] = 0x00007b9185751d60UL;
   tf->codes[12895] = 0x00007bbb9c4142f8UL;
   tf->codes[12896] = 0x00007bde9bbbb5b5UL;
   tf->codes[12897] = 0x00007bf8af6c476fUL;
   tf->codes[12898] = 0x00007c793d66f1e9UL;
   tf->codes[12899] = 0x00007c81b412c762UL;
   tf->codes[12900] = 0x00007c9d271d7bbaUL;
   tf->codes[12901] = 0x00007d13a4832858UL;
   tf->codes[12902] = 0x00007d7e776aaeb7UL;
   tf->codes[12903] = 0x00007d9dcdf4c524UL;
   tf->codes[12904] = 0x00007e05e2280647UL;
   tf->codes[12905] = 0x00007f0e4ffe13dbUL;
   tf->codes[12906] = 0x00007f268f36776dUL;
   tf->codes[12907] = 0x00007f68701cf50dUL;
   tf->codes[12908] = 0x00007fc046a59c8dUL;
   tf->codes[12909] = 0x00007ffa608d5603UL;
   tf->codes[12910] = 0x00008233096f5d11UL;
   tf->codes[12911] = 0x000082d91b09b9bfUL;
   tf->codes[12912] = 0x000082d95598bf84UL;
   tf->codes[12913] = 0x0000830b6df2af0bUL;
   tf->codes[12914] = 0x00008391b3e4e9c2UL;
   tf->codes[12915] = 0x000083b5d82a7958UL;
   tf->codes[12916] = 0x000083c9bec56f4bUL;
   tf->codes[12917] = 0x000084248e9161ccUL;
   tf->codes[12918] = 0x0000843a84338bacUL;
   tf->codes[12919] = 0x000084d7e4930d1cUL;
   tf->codes[12920] = 0x00008502ab0c4403UL;
   tf->codes[12921] = 0x0000850395485b17UL;
   tf->codes[12922] = 0x000085e6f49cc201UL;
   tf->codes[12923] = 0x000086038c729332UL;
   tf->codes[12924] = 0x0000863654799408UL;
   tf->codes[12925] = 0x0000867ed793b8f9UL;
   tf->codes[12926] = 0x0000868922b7bc9aUL;
   tf->codes[12927] = 0x0000868e2b023b88UL;
   tf->codes[12928] = 0x000086d2557ef2daUL;
   tf->codes[12929] = 0x0000872dd4f7f6aaUL;
   tf->codes[12930] = 0x00008765a549766eUL;
   tf->codes[12931] = 0x000087fd4db167a1UL;
   tf->codes[12932] = 0x0000880d50ccfb7fUL;
   tf->codes[12933] = 0x0000881343539181UL;
   tf->codes[12934] = 0x0000892fd2539acdUL;
   tf->codes[12935] = 0x00008943f37d9685UL;
   tf->codes[12936] = 0x0000896a61595fcdUL;
   tf->codes[12937] = 0x0000897bfe5e1c0eUL;
   tf->codes[12938] = 0x00008a1f16b52dbbUL;
   tf->codes[12939] = 0x00008a316366fb4bUL;
   tf->codes[12940] = 0x00008ad899cc74d2UL;
   tf->codes[12941] = 0x00008b0b61d375a8UL;
   tf->codes[12942] = 0x00008b6288af0bd9UL;
   tf->codes[12943] = 0x00008bb1736dd256UL;
   tf->codes[12944] = 0x00008bf1ba6b2793UL;
   tf->codes[12945] = 0x00008c1ae6fb3617UL;
   tf->codes[12946] = 0x00008c1b5c1941a1UL;
   tf->codes[12947] = 0x00008d02645e04dbUL;
   tf->codes[12948] = 0x00008d477916d341UL;
   tf->codes[12949] = 0x00008e1607942d24UL;
   tf->codes[12950] = 0x00008e16422332e9UL;
   tf->codes[12951] = 0x00008e37a7b47d43UL;
   tf->codes[12952] = 0x00008ebc192e89d2UL;
   tf->codes[12953] = 0x00008f02c7d0809bUL;
   tf->codes[12954] = 0x00008f4e7ebcf652UL;
   tf->codes[12955] = 0x00008fa829bdcbfaUL;
   tf->codes[12956] = 0x00008fc82ff4f3b6UL;
   tf->codes[12957] = 0x00008ff998a1d1eeUL;
   tf->codes[12958] = 0x00008ffaf7fbf48cUL;
   tf->codes[12959] = 0x000090f6216ab37eUL;
   tf->codes[12960] = 0x0000911920e5263bUL;
   tf->codes[12961] = 0x000091345960d4ceUL;
   tf->codes[12962] = 0x0000917d51990549UL;
   tf->codes[12963] = 0x000091bc393c37e8UL;
   tf->codes[12964] = 0x000091c9431480c5UL;
   tf->codes[12965] = 0x00009201fda2179dUL;
   tf->codes[12966] = 0x0000924f4e77b5b7UL;
   tf->codes[12967] = 0x0000925750057fa6UL;
   tf->codes[12968] = 0x00009281a160ab03UL;
   tf->codes[12969] = 0x000092bce0138152UL;
   tf->codes[12970] = 0x00009324b9b7bcb0UL;
   tf->codes[12971] = 0x00009335a70f67a2UL;
   tf->codes[12972] = 0x000093511a1a1bfaUL;
   tf->codes[12973] = 0x000093569782a672UL;
   tf->codes[12974] = 0x0000936366cbe98aUL;
   tf->codes[12975] = 0x00009405cf75e9e8UL;
   tf->codes[12976] = 0x0000948155261574UL;
   tf->codes[12977] = 0x0000948697ff9a27UL;
   tf->codes[12978] = 0x000094ac1b9f4c5bUL;
   tf->codes[12979] = 0x000094c5ba31d28bUL;
   tf->codes[12980] = 0x000094d7cc549a56UL;
   tf->codes[12981] = 0x0000950f62171455UL;
   tf->codes[12982] = 0x00009551b81b9d7fUL;
   tf->codes[12983] = 0x0000956ae1901825UL;
   tf->codes[12984] = 0x0000960498ff3d45UL;
   tf->codes[12985] = 0x00009619def455d6UL;
   tf->codes[12986] = 0x00009642966658d0UL;
   tf->codes[12987] = 0x0000966ef6c8b81aUL;
   tf->codes[12988] = 0x0000967aa146de59UL;
   tf->codes[12989] = 0x000096ae5389f643UL;
   tf->codes[12990] = 0x000097492fc4383cUL;
   tf->codes[12991] = 0x000098dc019ae861UL;
   tf->codes[12992] = 0x00009967ff84b355UL;
   tf->codes[12993] = 0x0000997752f335e4UL;
   tf->codes[12994] = 0x000099ac2a016aa7UL;
   tf->codes[12995] = 0x000099d088d60002UL;
   tf->codes[12996] = 0x00009a202341d7ceUL;
   tf->codes[12997] = 0x00009a7834598513UL;
   tf->codes[12998] = 0x00009aa509d9efe7UL;
   tf->codes[12999] = 0x00009afeb4dac58fUL;
   tf->codes[13000] = 0x00009b0ce37e2b45UL;
   tf->codes[13001] = 0x00009b1c717bb399UL;
   tf->codes[13002] = 0x00009b69c25151b3UL;
   tf->codes[13003] = 0x00009b9c153a46ffUL;
   tf->codes[13004] = 0x00009c2c313279cdUL;
   tf->codes[13005] = 0x00009c9395b8a9a1UL;
   tf->codes[13006] = 0x00009cdffc5230a7UL;
   tf->codes[13007] = 0x00009d1b75940cbbUL;
   tf->codes[13008] = 0x00009d5a5d373f5aUL;
   tf->codes[13009] = 0x00009d6607b56599UL;
   tf->codes[13010] = 0x00009da1bb864772UL;
   tf->codes[13011] = 0x00009dfc8b5239f3UL;
   tf->codes[13012] = 0x00009e93840d19d7UL;
   tf->codes[13013] = 0x00009eb0cb8ffc57UL;
   tf->codes[13014] = 0x00009f5926c092b7UL;
   tf->codes[13015] = 0x00009f6496afb331UL;
   tf->codes[13016] = 0x00009f6a4ea7436eUL;
   tf->codes[13017] = 0x00009f9e760866e2UL;
   tf->codes[13018] = 0x0000a03e5a8d27c9UL;
   tf->codes[13019] = 0x0000a07d42305a68UL;
   tf->codes[13020] = 0x0000a08334b6f06aUL;
   tf->codes[13021] = 0x0000a0e222914ac5UL;
   tf->codes[13022] = 0x0000a12efe48dd55UL;
   tf->codes[13023] = 0x0000a1c0eeb93e4bUL;
   tf->codes[13024] = 0x0000a1d50fe33a03UL;
   tf->codes[13025] = 0x0000a2a06a8e4320UL;
   tf->codes[13026] = 0x0000a2fd83f06f53UL;
   tf->codes[13027] = 0x0000a3258bb560feUL;
   tf->codes[13028] = 0x0000a339acdf5cb6UL;
   tf->codes[13029] = 0x0000a3c18cbabfd0UL;
   tf->codes[13030] = 0x0000a3e451a62cc8UL;
   tf->codes[13031] = 0x0000a3e6d5cb6c3fUL;
   tf->codes[13032] = 0x0000a4028365265cUL;
   tf->codes[13033] = 0x0000a437cf9166a9UL;
   tf->codes[13034] = 0x0000a44513f8b54bUL;
   tf->codes[13035] = 0x0000a456b0fd718cUL;
   tf->codes[13036] = 0x0000a4625b7b97cbUL;
   tf->codes[13037] = 0x0000a4ccf3d41865UL;
   tf->codes[13038] = 0x0000a4cf3d6a5217UL;
   tf->codes[13039] = 0x0000a51a44a9b67fUL;
   tf->codes[13040] = 0x0000a51ed7d629e3UL;
   tf->codes[13041] = 0x0000a523e020a8d1UL;
   tf->codes[13042] = 0x0000a52838be1670UL;
   tf->codes[13043] = 0x0000a530af69ebe9UL;
   tf->codes[13044] = 0x0000a62118969bb0UL;
   tf->codes[13045] = 0x0000a6386d92e82eUL;
   tf->codes[13046] = 0x0000a6c7d9de09adUL;
   tf->codes[13047] = 0x0000a6d13ac5f63aUL;
   tf->codes[13048] = 0x0000a77c1a1bcc11UL;
   tf->codes[13049] = 0x0000a7b0b69afb0fUL;
   tf->codes[13050] = 0x0000a7cee859f4a3UL;
   tf->codes[13051] = 0x0000a7f3472e89feUL;
   tf->codes[13052] = 0x0000a7f8c4971476UL;
   tf->codes[13053] = 0x0000a834ed8601d9UL;
   tf->codes[13054] = 0x0000a8f2c93ab68fUL;
   tf->codes[13055] = 0x0000a965d83f0ca2UL;
   tf->codes[13056] = 0x0000a991c3836062UL;
   tf->codes[13057] = 0x0000a99c0ea76403UL;
   tf->codes[13058] = 0x0000a9a410352df2UL;
   tf->codes[13059] = 0x0000a9e8afcff0ceUL;
   tf->codes[13060] = 0x0000aa19ddedc941UL;
   tf->codes[13061] = 0x0000aa3675c39a72UL;
   tf->codes[13062] = 0x0000aad151fddc6bUL;
   tf->codes[13063] = 0x0000ab67607ca53bUL;
   tf->codes[13064] = 0x0000abd8d597d2ebUL;
   tf->codes[13065] = 0x0000abf7f192e393UL;
   tf->codes[13066] = 0x0000ac687c71fa2fUL;
   tf->codes[13067] = 0x0000acb8c68ae34aUL;
   tf->codes[13068] = 0x0000acfb1c8f6c74UL;
   tf->codes[13069] = 0x0000ad6d06c8a5aeUL;
   tf->codes[13070] = 0x0000adbaccbc4f52UL;
   tf->codes[13071] = 0x0000ae21f6b37961UL;
   tf->codes[13072] = 0x0000ae79581e1557UL;
   tf->codes[13073] = 0x0000aec215c7400dUL;
   tf->codes[13074] = 0x0000aeceaa817d60UL;
   tf->codes[13075] = 0x0000af5aa86b4854UL;
   tf->codes[13076] = 0x0000afc6daacf151UL;
   tf->codes[13077] = 0x0000b01c2d10595aUL;
   tf->codes[13078] = 0x0000b02ad0d1ca9aUL;
   tf->codes[13079] = 0x0000b038c4e62a8bUL;
   tf->codes[13080] = 0x0000b085660eb756UL;
   tf->codes[13081] = 0x0000b08cb7ef6ff6UL;
   tf->codes[13082] = 0x0000b0e1cfc3d23aUL;
   tf->codes[13083] = 0x0000b109d788c3e5UL;
   tf->codes[13084] = 0x0000b10f1a624898UL;
   tf->codes[13085] = 0x0000b130ba8298b7UL;
   tf->codes[13086] = 0x0000b13f23b50432UL;
   tf->codes[13087] = 0x0000b157d80b734eUL;
   tf->codes[13088] = 0x0000b189b5d65d10UL;
   tf->codes[13089] = 0x0000b1abcb14b8b9UL;
   tf->codes[13090] = 0x0000b1c987b5a6c3UL;
   tf->codes[13091] = 0x0000b1da750d51b5UL;
   tf->codes[13092] = 0x0000b1fff8ad03e9UL;
   tf->codes[13093] = 0x0000b228b01f06e3UL;
   tf->codes[13094] = 0x0000b384d66f541dUL;
   tf->codes[13095] = 0x0000b3b3f585f8a3UL;
   tf->codes[13096] = 0x0000b40da086ce4bUL;
   tf->codes[13097] = 0x0000b412a8d14d39UL;
   tf->codes[13098] = 0x0000b485b7d5a34cUL;
   tf->codes[13099] = 0x0000b4978f696552UL;
   tf->codes[13100] = 0x0000b49963e1937aUL;
   tf->codes[13101] = 0x0000b4d63c7d922cUL;
   tf->codes[13102] = 0x0000b4eb8272aabdUL;
   tf->codes[13103] = 0x0000b546c75ca8c8UL;
   tf->codes[13104] = 0x0000b5635f3279f9UL;
   tf->codes[13105] = 0x0000b599959ad15aUL;
   tf->codes[13106] = 0x0000b5e009adc25eUL;
   tf->codes[13107] = 0x0000b616efc32b0eUL;
   tf->codes[13108] = 0x0000b6317891c852UL;
   tf->codes[13109] = 0x0000b64d60ba8834UL;
   tf->codes[13110] = 0x0000b6647b27ceedUL;
   tf->codes[13111] = 0x0000b6b06ca34a69UL;
   tf->codes[13112] = 0x0000b6e57e4084f1UL;
   tf->codes[13113] = 0x0000b7534a6b5651UL;
   tf->codes[13114] = 0x0000b76b4f14b41eUL;
   tf->codes[13115] = 0x0000b78771cc79c5UL;
   tf->codes[13116] = 0x0000b7a1fa9b1709UL;
   tf->codes[13117] = 0x0000b7d7f67468a5UL;
   tf->codes[13118] = 0x0000b801d2b18878UL;
   tf->codes[13119] = 0x0000b8d7ed9ea0c0UL;
   tf->codes[13120] = 0x0000b8fcfc20476aUL;
   tf->codes[13121] = 0x0000b931989f7668UL;
   tf->codes[13122] = 0x0000b976383a3944UL;
   tf->codes[13123] = 0x0000b9dade0c23dcUL;
   tf->codes[13124] = 0x0000ba244b625fe1UL;
   tf->codes[13125] = 0x0000ba7cd19818b0UL;
   tf->codes[13126] = 0x0000ba8c25069b3fUL;
   tf->codes[13127] = 0x0000babaceff343bUL;
   tf->codes[13128] = 0x0000bae3c1003cfaUL;
   tf->codes[13129] = 0x0000bb0108831f7aUL;
   tf->codes[13130] = 0x0000bb1c066fc848UL;
   tf->codes[13131] = 0x0000bb1effb31349UL;
   tf->codes[13132] = 0x0000bc24e963e166UL;
   tf->codes[13133] = 0x0000bc50d4a83526UL;
   tf->codes[13134] = 0x0000bcca4b512cc5UL;
   tf->codes[13135] = 0x0000bccc1fc95aedUL;
   tf->codes[13136] = 0x0000bd279f425ebdUL;
   tf->codes[13137] = 0x0000bd2ce21be370UL;
   tf->codes[13138] = 0x0000bd2eb6941198UL;
   tf->codes[13139] = 0x0000bd8fb3759fe0UL;
   tf->codes[13140] = 0x0000bdca7d0a6aa5UL;
   tf->codes[13141] = 0x0000bdebe29bb4ffUL;
   tf->codes[13142] = 0x0000bded41f5d79dUL;
   tf->codes[13143] = 0x0000bdf2f9ed67daUL;
   tf->codes[13144] = 0x0000be49abaaf281UL;
   tf->codes[13145] = 0x0000beee987a3256UL;
   tf->codes[13146] = 0x0000bf9e458b8156UL;
   tf->codes[13147] = 0x0000bfabff10db82UL;
   tf->codes[13148] = 0x0000c0d76c615bd3UL;
   tf->codes[13149] = 0x0000c116c92299fcUL;
   tf->codes[13150] = 0x0000c11bd16d18eaUL;
   tf->codes[13151] = 0x0000c1e4a7f2e290UL;
   tf->codes[13152] = 0x0000c21267af6478UL;
   tf->codes[13153] = 0x0000c2a3e301b9e4UL;
   tf->codes[13154] = 0x0000c319eb495af8UL;
   tf->codes[13155] = 0x0000c356fe745f6fUL;
   tf->codes[13156] = 0x0000c3c121aed47fUL;
   tf->codes[13157] = 0x0000c42d196177b7UL;
   tf->codes[13158] = 0x0000c436052b58baUL;
   tf->codes[13159] = 0x0000c490254a39ecUL;
   tf->codes[13160] = 0x0000c4a481033b69UL;
   tf->codes[13161] = 0x0000c551a9ef4af2UL;
   tf->codes[13162] = 0x0000c55cdf4f65a7UL;
   tf->codes[13163] = 0x0000c57902072b4eUL;
   tf->codes[13164] = 0x0000c5da7406c520UL;
   tf->codes[13165] = 0x0000c69606254024UL;
   tf->codes[13166] = 0x0000c6d478aa6739UL;
   tf->codes[13167] = 0x0000c724fd525619UL;
   tf->codes[13168] = 0x0000c7b3f47f6c0eUL;
   tf->codes[13169] = 0x0000c8361c633eebUL;
   tf->codes[13170] = 0x0000c842ebac8203UL;
   tf->codes[13171] = 0x0000c984c3bd37beUL;
   tf->codes[13172] = 0x0000cb4604fd7b1aUL;
   tf->codes[13173] = 0x0000cba0d4c96d9bUL;
   tf->codes[13174] = 0x0000cbaf788adedbUL;
   tf->codes[13175] = 0x0000cc2ac3ac04a2UL;
   tf->codes[13176] = 0x0000cc521bc3e4feUL;
   tf->codes[13177] = 0x0000cc54da782a3aUL;
   tf->codes[13178] = 0x0000cc6d543f9391UL;
   tf->codes[13179] = 0x0000cd8933928b8eUL;
   tf->codes[13180] = 0x0000cdbb115d7550UL;
   tf->codes[13181] = 0x0000cdc08ec5ffc8UL;
   tf->codes[13182] = 0x0000ce0cbad08109UL;
   tf->codes[13183] = 0x0000ce86317978a8UL;
   tf->codes[13184] = 0x0000d02a2b36d984UL;
   tf->codes[13185] = 0x0000d0338c1ec611UL;
   tf->codes[13186] = 0x0000d0a32cc1c599UL;
   tf->codes[13187] = 0x0000d0b8ad45e3efUL;
   tf->codes[13188] = 0x0000d19e5630848bUL;
   tf->codes[13189] = 0x0000d1f0af50a193UL;
   tf->codes[13190] = 0x0000d1f1246ead1dUL;
   tf->codes[13191] = 0x0000d22eacb7bd1eUL;
   tf->codes[13192] = 0x0000d3107222fba5UL;
   tf->codes[13193] = 0x0000d3d31b932984UL;
   tf->codes[13194] = 0x0000d427492b74b4UL;
   tf->codes[13195] = 0x0000d594d1f1786aUL;
   tf->codes[13196] = 0x0000d5e606467899UL;
   tf->codes[13197] = 0x0000d6431fa8a4ccUL;
   tf->codes[13198] = 0x0000d670a4d620efUL;
   tf->codes[13199] = 0x0000d686d5075094UL;
   tf->codes[13200] = 0x0000d6cd0e8b3bd3UL;
   tf->codes[13201] = 0x0000d6feb1c71fd0UL;
   tf->codes[13202] = 0x0000d71b0f0deb3cUL;
   tf->codes[13203] = 0x0000d749b9068438UL;
   tf->codes[13204] = 0x0000d7a9568defe2UL;
   tf->codes[13205] = 0x0000d7c070fb369bUL;
   tf->codes[13206] = 0x0000d8bc4a1706dcUL;
   tf->codes[13207] = 0x0000d8d414315ee4UL;
   tf->codes[13208] = 0x0000d930f3048552UL;
   tf->codes[13209] = 0x0000da9d56ff6c2fUL;
   tf->codes[13210] = 0x0000db933d94a66eUL;
   tf->codes[13211] = 0x0000dbc79f84cfa7UL;
   tf->codes[13212] = 0x0000dc314da1392dUL;
   tf->codes[13213] = 0x0000dc7d79abba6eUL;
   tf->codes[13214] = 0x0000dc8839edc999UL;
   tf->codes[13215] = 0x0000dc945989fb62UL;
   tf->codes[13216] = 0x0000dd051ef817c3UL;
   tf->codes[13217] = 0x0000dd3b55606f24UL;
   tf->codes[13218] = 0x0000dfa6512b6b7eUL;
   tf->codes[13219] = 0x0000e00f150bbdf0UL;
   tf->codes[13220] = 0x0000e0ab50a02287UL;
   tf->codes[13221] = 0x0000e0db9481e3e6UL;
   tf->codes[13222] = 0x0000e151623a7f35UL;
   tf->codes[13223] = 0x0000e1c1ed1995d1UL;
   tf->codes[13224] = 0x0000e2047dad24c0UL;
   tf->codes[13225] = 0x0000e283e6dcb261UL;
   tf->codes[13226] = 0x0000e314b281f67eUL;
   tf->codes[13227] = 0x0000e3fa95fb9cdfUL;
   tf->codes[13228] = 0x0000e4490b9c57d2UL;
   tf->codes[13229] = 0x0000e4aab82af769UL;
   tf->codes[13230] = 0x0000e54768dd678aUL;
   tf->codes[13231] = 0x0000e587754bb702UL;
   tf->codes[13232] = 0x0000e74bafcf455fUL;
   tf->codes[13233] = 0x0000e76acbca5607UL;
   tf->codes[13234] = 0x0000e7a13cc1b32dUL;
   tf->codes[13235] = 0x0000e8182f456b55UL;
   tf->codes[13236] = 0x0000e98249aa1880UL;
   tf->codes[13237] = 0x0000e982bec8240aUL;
   tf->codes[13238] = 0x0000e9fc35711ba9UL;
   tf->codes[13239] = 0x0000ea577a5b19b4UL;
   tf->codes[13240] = 0x0000eb2ce59b20adUL;
   tf->codes[13241] = 0x0000eb2fa44f65e9UL;
   tf->codes[13242] = 0x0000eb3103a98887UL;
   tf->codes[13243] = 0x0000ec4d581a8c0eUL;
   tf->codes[13244] = 0x0000ec69b561577aUL;
   tf->codes[13245] = 0x0000edc31cfd5f78UL;
   tf->codes[13246] = 0x0000ede5323bbb21UL;
   tf->codes[13247] = 0x0000ee50b4d052cfUL;
   tf->codes[13248] = 0x0000ee9e4034f6aeUL;
   tf->codes[13249] = 0x0000ef39918d4431UL;
   tf->codes[13250] = 0x0000ef541a5be175UL;
   tf->codes[13251] = 0x0000ef5af71e8e8bUL;
   tf->codes[13252] = 0x0000f064c44ebebdUL;
   tf->codes[13253] = 0x0000f1176aa358beUL;
   tf->codes[13254] = 0x0000f15910fad099UL;
   tf->codes[13255] = 0x0000f1a1cea3fb4fUL;
   tf->codes[13256] = 0x0000f1b122127ddeUL;
   tf->codes[13257] = 0x0000f362d55538e6UL;
   tf->codes[13258] = 0x0000f3985c107ef8UL;
   tf->codes[13259] = 0x0000f3a4b63bb686UL;
   tf->codes[13260] = 0x0000f47e3f8a2559UL;
   tf->codes[13261] = 0x0000f485916addf9UL;
   tf->codes[13262] = 0x0000f4b89400e494UL;
   tf->codes[13263] = 0x0000f4bc3cf140e4UL;
   tf->codes[13264] = 0x0000f50a7802f612UL;
   tf->codes[13265] = 0x0000f6a75a6ea413UL;
   tf->codes[13266] = 0x0000f70aa0e66c0dUL;
   tf->codes[13267] = 0x0000f72faf6812b7UL;
   tf->codes[13268] = 0x0000f89ab408d6f6UL;
   tf->codes[13269] = 0x0000f8b7114fa262UL;
   tf->codes[13270] = 0x0000f93b82c9aef1UL;
   tf->codes[13271] = 0x0000f98d66cbc06fUL;
   tf->codes[13272] = 0x0000f99ae5c214d6UL;
   tf->codes[13273] = 0x0000f9dc518a86ecUL;
   tf->codes[13274] = 0x0000f9ee63ad4eb7UL;
   tf->codes[13275] = 0x0000fa28f2b313b7UL;
   tf->codes[13276] = 0x0000faa6c1f978f5UL;
   tf->codes[13277] = 0x0000fad11354a452UL;
   tf->codes[13278] = 0x0000fb08a9171e51UL;
   tf->codes[13279] = 0x0000fb1f88f55f45UL;
   tf->codes[13280] = 0x0000fb450c951179UL;
   tf->codes[13281] = 0x0000fb7515e7cd13UL;
   tf->codes[13282] = 0x0000fba594589437UL;
   tf->codes[13283] = 0x0000fbf91243ce18UL;
   tf->codes[13284] = 0x0000fcb3f4b537cdUL;
   tf->codes[13285] = 0x0000fd7a81a4c7c1UL;
   tf->codes[13286] = 0x0000fd95ba207654UL;
   tf->codes[13287] = 0x0000fdaa8af7835bUL;
   tf->codes[13288] = 0x0000fdb0f29c24e7UL;
   tf->codes[13289] = 0x0000fdd885430b08UL;
   tf->codes[13290] = 0x0000fe0a9d9cfa8fUL;
   tf->codes[13291] = 0x0000fe3c7b67e451UL;
   tf->codes[13292] = 0x0000fea922c798d8UL;
   tf->codes[13293] = 0x0000fed1da399bd2UL;
   tf->codes[13294] = 0x0000fef046879b2bUL;
   tf->codes[13295] = 0x0000fffb7311edfbUL;
   tf->codes[13296] = 0x0000012ee1f0383bUL;
   tf->codes[13297] = 0x0000023abe279c5aUL;
   tf->codes[13298] = 0x000002592a759bb3UL;
   tf->codes[13299] = 0x000002bb4c2246d4UL;
   tf->codes[13300] = 0x0000032ab2364097UL;
   tf->codes[13301] = 0x000003a588395ad4UL;
   tf->codes[13302] = 0x00000580a29b2a25UL;
   tf->codes[13303] = 0x0000060b412ad27bUL;
   tf->codes[13304] = 0x000006393b765a28UL;
   tf->codes[13305] = 0x000006aece9fefb2UL;
   tf->codes[13306] = 0x000006ff5347de92UL;
   tf->codes[13307] = 0x00000803dd9e8a11UL;
   tf->codes[13308] = 0x0000081a0dcfb9b6UL;
   tf->codes[13309] = 0x00000838ef3bc499UL;
   tf->codes[13310] = 0x0000083a1406e172UL;
   tf->codes[13311] = 0x000008faae6fdb64UL;
   tf->codes[13312] = 0x000009faa59a137fUL;
   tf->codes[13313] = 0x00000aa300caa9dfUL;
   tf->codes[13314] = 0x00000b24b3907132UL;
   tf->codes[13315] = 0x00000b2688089f5aUL;
   tf->codes[13316] = 0x00000bbc5bf86265UL;
   tf->codes[13317] = 0x00000c3ebe6b3b07UL;
   tf->codes[13318] = 0x00000ca204e30301UL;
   tf->codes[13319] = 0x00000cd4925afe12UL;
   tf->codes[13320] = 0x00000d74ebfdca83UL;
   tf->codes[13321] = 0x00000d78cf7d2c98UL;
   tf->codes[13322] = 0x00000e6938a9dc5fUL;
   tf->codes[13323] = 0x00000f086d818bf7UL;
   tf->codes[13324] = 0x00000f295df4cac7UL;
   tf->codes[13325] = 0x00000f86ec750284UL;
   tf->codes[13326] = 0x00000fd9bab32b16UL;
   tf->codes[13327] = 0x000011f556a15569UL;
   tf->codes[13328] = 0x0000140bafb5fb09UL;
   tf->codes[13329] = 0x000014717a53027aUL;
   tf->codes[13330] = 0x000014e23fc11edbUL;
   tf->codes[13331] = 0x000015048f8e8049UL;
   tf->codes[13332] = 0x000015a89221a90aUL;
   tf->codes[13333] = 0x000015e35bb673cfUL;
   tf->codes[13334] = 0x00001734fc53b7a3UL;
   tf->codes[13335] = 0x0000175a45646412UL;
   tf->codes[13336] = 0x0000179e3552159fUL;
   tf->codes[13337] = 0x000017c3b8f1c7d3UL;
   tf->codes[13338] = 0x0000190fa1977b6aUL;
   tf->codes[13339] = 0x00001911760fa992UL;
   tf->codes[13340] = 0x00001924e78c93fbUL;
   tf->codes[13341] = 0x00001a6107a5b979UL;
   tf->codes[13342] = 0x00001aed401e8a32UL;
   tf->codes[13343] = 0x00001bc09c575d3eUL;
   tf->codes[13344] = 0x00001be695151afcUL;
   tf->codes[13345] = 0x00001c183850fef9UL;
   tf->codes[13346] = 0x00001c349597ca65UL;
   tf->codes[13347] = 0x00001c7f62482908UL;
   tf->codes[13348] = 0x00001d3c1931c0e5UL;
   tf->codes[13349] = 0x00001d4246475cacUL;
   tf->codes[13350] = 0x00001e3399b02387UL;
   tf->codes[13351] = 0x00001ed1349eaabcUL;
   tf->codes[13352] = 0x00001f2945b65801UL;
   tf->codes[13353] = 0x00001f4393f5ef80UL;
   tf->codes[13354] = 0x00001faa835e13caUL;
   tf->codes[13355] = 0x00001fb24a5cd7f4UL;
   tf->codes[13356] = 0x00001fc71b33e4fbUL;
   tf->codes[13357] = 0x000020151bb69464UL;
   tf->codes[13358] = 0x000020cd04e4b318UL;
   tf->codes[13359] = 0x0000211c64c1851fUL;
   tf->codes[13360] = 0x00002175d5335502UL;
   tf->codes[13361] = 0x000021fc90439b43UL;
   tf->codes[13362] = 0x000022500e2ed524UL;
   tf->codes[13363] = 0x0000228c71acc84cUL;
   tf->codes[13364] = 0x0000236b7863c197UL;
   tf->codes[13365] = 0x0000246d440627daUL;
   tf->codes[13366] = 0x000024a80d9af29fUL;
   tf->codes[13367] = 0x00002532719b9530UL;
   tf->codes[13368] = 0x0000255a04427b51UL;
   tf->codes[13369] = 0x000025ef9da33897UL;
   tf->codes[13370] = 0x0000264e165f8768UL;
   tf->codes[13371] = 0x0000268c4e55a8b8UL;
   tf->codes[13372] = 0x000026cd7f8f1509UL;
   tf->codes[13373] = 0x00002746bba906e3UL;
   tf->codes[13374] = 0x000027ade5a030f2UL;
   tf->codes[13375] = 0x0000298ce3816258UL;
   tf->codes[13376] = 0x00002a3b31388ebaUL;
   tf->codes[13377] = 0x00002abca96f5048UL;
   tf->codes[13378] = 0x00002ac26166e085UL;
   tf->codes[13379] = 0x00002b71d3e929c0UL;
   tf->codes[13380] = 0x00002d72375ba580UL;
   tf->codes[13381] = 0x00002da240ae611aUL;
   tf->codes[13382] = 0x00002df92cfaf186UL;
   tf->codes[13383] = 0x00002fbd677e7fe3UL;
   tf->codes[13384] = 0x00003032c0190fa8UL;
   tf->codes[13385] = 0x00003040799e69d4UL;
   tf->codes[13386] = 0x0000305b3cfc0cddUL;
   tf->codes[13387] = 0x000030e182ee4794UL;
   tf->codes[13388] = 0x00003116cf1a87e1UL;
   tf->codes[13389] = 0x0000319f5ea2fc4aUL;
   tf->codes[13390] = 0x000031a30793589aUL;
   tf->codes[13391] = 0x00003213cd0174fbUL;
   tf->codes[13392] = 0x000032311484577bUL;
   tf->codes[13393] = 0x00003373d6d1244aUL;
   tf->codes[13394] = 0x000033b3a8b06dfdUL;
   tf->codes[13395] = 0x000033ce6c0e1106UL;
   tf->codes[13396] = 0x000033f9328747edUL;
   tf->codes[13397] = 0x000034705f9a05daUL;
   tf->codes[13398] = 0x000034f496850ca4UL;
   tf->codes[13399] = 0x0000350499a0a082UL;
   tf->codes[13400] = 0x00003548c41d57d4UL;
   tf->codes[13401] = 0x00003570cbe2497fUL;
   tf->codes[13402] = 0x000035fcc9cc1473UL;
   tf->codes[13403] = 0x0000369b4ef6b2bcUL;
   tf->codes[13404] = 0x00003793b9b12c72UL;
   tf->codes[13405] = 0x000037cb8a02ac36UL;
   tf->codes[13406] = 0x00003a740e16b891UL;
   tf->codes[13407] = 0x00003c9611a98470UL;
   tf->codes[13408] = 0x00003d6849173aa3UL;
   tf->codes[13409] = 0x00003d6a581e6e90UL;
   tf->codes[13410] = 0x00003dbefad4c54aUL;
   tf->codes[13411] = 0x00003dfc831dd54bUL;
   tf->codes[13412] = 0x00003e88f625abc9UL;
   tf->codes[13413] = 0x00003e93b667baf4UL;
   tf->codes[13414] = 0x00003f43637909f4UL;
   tf->codes[13415] = 0x00003f9dbe26f0ebUL;
   tf->codes[13416] = 0x00003fc884a027d2UL;
   tf->codes[13417] = 0x00003ff51f918ce1UL;
   tf->codes[13418] = 0x00004010580d3b74UL;
   tf->codes[13419] = 0x0000407e5ec71299UL;
   tf->codes[13420] = 0x000041918cdf2f58UL;
   tf->codes[13421] = 0x000041b50177ad9fUL;
   tf->codes[13422] = 0x00004224678ba762UL;
   tf->codes[13423] = 0x000042dc50b9c616UL;
   tf->codes[13424] = 0x000042f196aedea7UL;
   tf->codes[13425] = 0x00004323e997d3f3UL;
   tf->codes[13426] = 0x0000438312013413UL;
   tf->codes[13427] = 0x000044183643e5cfUL;
   tf->codes[13428] = 0x0000443afb2f52c7UL;
   tf->codes[13429] = 0x0000446ac9f3089cUL;
   tf->codes[13430] = 0x00004477993c4bb4UL;
   tf->codes[13431] = 0x0000447a1d618b2bUL;
   tf->codes[13432] = 0x000044b08e58e851UL;
   tf->codes[13433] = 0x000045784013951eUL;
   tf->codes[13434] = 0x000046277806d894UL;
   tf->codes[13435] = 0x000046394f9a9a9aUL;
   tf->codes[13436] = 0x0000473b905b0c67UL;
   tf->codes[13437] = 0x0000477c4c766d2eUL;
   tf->codes[13438] = 0x000047a1d0161f62UL;
   tf->codes[13439] = 0x000047da5014b075UL;
   tf->codes[13440] = 0x0000485c77f88352UL;
   tf->codes[13441] = 0x000048e83b534881UL;
   tf->codes[13442] = 0x00004938fa8a3d26UL;
   tf->codes[13443] = 0x0000495900c164e2UL;
   tf->codes[13444] = 0x0000496f30f29487UL;
   tf->codes[13445] = 0x000049781cbc758aUL;
   tf->codes[13446] = 0x00004978cc6986d9UL;
   tf->codes[13447] = 0x000049b4bac96e77UL;
   tf->codes[13448] = 0x000049ef845e393cUL;
   tf->codes[13449] = 0x00004a0838b4a858UL;
   tf->codes[13450] = 0x00004a120ebaa06fUL;
   tf->codes[13451] = 0x00004a5acc63cb25UL;
   tf->codes[13452] = 0x00004aa7e2aa637aUL;
   tf->codes[13453] = 0x00004abcb3817081UL;
   tf->codes[13454] = 0x00004acae224d637UL;
   tf->codes[13455] = 0x00004b232dcb8941UL;
   tf->codes[13456] = 0x00004b8eeaef26b4UL;
   tf->codes[13457] = 0x00004b93b8aa9fddUL;
   tf->codes[13458] = 0x00004cebfb7b8b02UL;
   tf->codes[13459] = 0x00004d03c595e30aUL;
   tf->codes[13460] = 0x00004d1353936b5eUL;
   tf->codes[13461] = 0x00004d4d6d7b24d4UL;
   tf->codes[13462] = 0x00004d9d7d05082aUL;
   tf->codes[13463] = 0x00004daf8f27cff5UL;
   tf->codes[13464] = 0x00004dfdca398523UL;
   tf->codes[13465] = 0x00004e38593f4a23UL;
   tf->codes[13466] = 0x00004e5824e76c1aUL;
   tf->codes[13467] = 0x00004e5bcdd7c86aUL;
   tf->codes[13468] = 0x00004f1a93c89434UL;
   tf->codes[13469] = 0x00004f3f67bb3519UL;
   tf->codes[13470] = 0x00004f92ab176935UL;
   tf->codes[13471] = 0x00004fa4f7c936c5UL;
   tf->codes[13472] = 0x000050c7794fd613UL;
   tf->codes[13473] = 0x0000510d0326b003UL;
   tf->codes[13474] = 0x0000511a821d046aUL;
   tf->codes[13475] = 0x00005135457aa773UL;
   tf->codes[13476] = 0x00005147ccbb7ac8UL;
   tf->codes[13477] = 0x0000518b821a2690UL;
   tf->codes[13478] = 0x00005206cd3b4c57UL;
   tf->codes[13479] = 0x0000523c8e85982eUL;
   tf->codes[13480] = 0x0000530cb6ec1a74UL;
   tf->codes[13481] = 0x00005314435bd8d9UL;
   tf->codes[13482] = 0x0000543e5152368cUL;
   tf->codes[13483] = 0x0000545c83113020UL;
   tf->codes[13484] = 0x0000547696c1c1daUL;
   tf->codes[13485] = 0x0000548833c67e1bUL;
   tf->codes[13486] = 0x00005524a9e9e877UL;
   tf->codes[13487] = 0x00005534e794821aUL;
   tf->codes[13488] = 0x0000556356fe1551UL;
   tf->codes[13489] = 0x00005615fd52af52UL;
   tf->codes[13490] = 0x000056472b7087c5UL;
   tf->codes[13491] = 0x000056838eee7aedUL;
   tf->codes[13492] = 0x0000569cb862f593UL;
   tf->codes[13493] = 0x000056c18c559678UL;
   tf->codes[13494] = 0x000056e48bd00935UL;
   tf->codes[13495] = 0x0000572d497933ebUL;
   tf->codes[13496] = 0x0000577e7dce341aUL;
   tf->codes[13497] = 0x000057a2a213c3b0UL;
   tf->codes[13498] = 0x000058e85da3db80UL;
   tf->codes[13499] = 0x000058fc7ecdd738UL;
   tf->codes[13500] = 0x0000593205891d4aUL;
   tf->codes[13501] = 0x000059649301185bUL;
   tf->codes[13502] = 0x00005a07ab582a08UL;
   tf->codes[13503] = 0x00005ab808168a57UL;
   tf->codes[13504] = 0x00005ac8f56e3549UL;
   tf->codes[13505] = 0x00005b0dcf97fdeaUL;
   tf->codes[13506] = 0x00005b364c7afb1fUL;
   tf->codes[13507] = 0x00005ba9960e56f7UL;
   tf->codes[13508] = 0x00005c0b7d2bfc53UL;
   tf->codes[13509] = 0x00005c59431fa5f7UL;
   tf->codes[13510] = 0x00005c82aa3eba40UL;
   tf->codes[13511] = 0x00005d45191fe25aUL;
   tf->codes[13512] = 0x00005d66f3cf383eUL;
   tf->codes[13513] = 0x00005dcc0ebf2e60UL;
   tf->codes[13514] = 0x00005dded08f077aUL;
   tf->codes[13515] = 0x00005de4888697b7UL;
   tf->codes[13516] = 0x00005e0c1b2d7dd8UL;
   tf->codes[13517] = 0x00005e0e64c3b78aUL;
   tf->codes[13518] = 0x00005e79acc94973UL;
   tf->codes[13519] = 0x00005e9594f20955UL;
   tf->codes[13520] = 0x00005fafda5bd8efUL;
   tf->codes[13521] = 0x00005fd9f127fe87UL;
   tf->codes[13522] = 0x0000601d31689ec5UL;
   tf->codes[13523] = 0x000060ed59cf210bUL;
   tf->codes[13524] = 0x0000619196f14f91UL;
   tf->codes[13525] = 0x00006242ddebc6f4UL;
   tf->codes[13526] = 0x00006252a678550dUL;
   tf->codes[13527] = 0x00006279fe903569UL;
   tf->codes[13528] = 0x00006328fbf4731aUL;
   tf->codes[13529] = 0x000064171b8ae92fUL;
   tf->codes[13530] = 0x000064542eb5eda6UL;
   tf->codes[13531] = 0x0000645d8f9dda33UL;
   tf->codes[13532] = 0x000064bc085a2904UL;
   tf->codes[13533] = 0x00006583ba14d5d1UL;
   tf->codes[13534] = 0x000065e1f8421eddUL;
   tf->codes[13535] = 0x000065f778c63d33UL;
   tf->codes[13536] = 0x0000662a7b5c43ceUL;
   tf->codes[13537] = 0x000066c432cb68eeUL;
   tf->codes[13538] = 0x0000671c7e721bf8UL;
   tf->codes[13539] = 0x00006791d70cabbdUL;
   tf->codes[13540] = 0x00006a0633bf94a4UL;
   tf->codes[13541] = 0x00006a57a2a39a98UL;
   tf->codes[13542] = 0x00006a90d24f3cfaUL;
   tf->codes[13543] = 0x00006a93cb9287fbUL;
   tf->codes[13544] = 0x00006ad571e9ffd6UL;
   tf->codes[13545] = 0x00006b23e78abac9UL;
   tf->codes[13546] = 0x00006b5f60cc96ddUL;
   tf->codes[13547] = 0x00006c1ab85c0c1cUL;
   tf->codes[13548] = 0x00006c1c5245347fUL;
   tf->codes[13549] = 0x00006c3f8c4ead01UL;
   tf->codes[13550] = 0x00006c76726415b1UL;
   tf->codes[13551] = 0x00006cbd21060c7aUL;
   tf->codes[13552] = 0x00006cdc779022e7UL;
   tf->codes[13553] = 0x00006cec058dab3bUL;
   tf->codes[13554] = 0x00006cf2e2505851UL;
   tf->codes[13555] = 0x00006d269493703bUL;
   tf->codes[13556] = 0x00006d7ee03a2345UL;
   tf->codes[13557] = 0x00006fa6d6538526UL;
   tf->codes[13558] = 0x00006fcfc8548de5UL;
   tf->codes[13559] = 0x0000705bc63e58d9UL;
   tf->codes[13560] = 0x0000707faff4e2aaUL;
   tf->codes[13561] = 0x0000708985fadac1UL;
   tf->codes[13562] = 0x000070a115862d04UL;
   tf->codes[13563] = 0x000071066b0528ebUL;
   tf->codes[13564] = 0x0000719d9e4f0e94UL;
   tf->codes[13565] = 0x000071b14a5afec2UL;
   tf->codes[13566] = 0x0000723ac41f8a3fUL;
   tf->codes[13567] = 0x000072a387ffdcb1UL;
   tf->codes[13568] = 0x000072d2e1a586fcUL;
   tf->codes[13569] = 0x000072eddf922fcaUL;
   tf->codes[13570] = 0x000073139dc0e7c3UL;
   tf->codes[13571] = 0x00007317bbcf4f9dUL;
   tf->codes[13572] = 0x00007328a926fa8fUL;
   tf->codes[13573] = 0x0000736b39ba897eUL;
   tf->codes[13574] = 0x00007394664a9802UL;
   tf->codes[13575] = 0x000073975f8de303UL;
   tf->codes[13576] = 0x000073cc369c17c6UL;
   tf->codes[13577] = 0x00007448a6885a66UL;
   tf->codes[13578] = 0x0000751b1885165eUL;
   tf->codes[13579] = 0x000076334ee7b20bUL;
   tf->codes[13580] = 0x000076939c1c2f04UL;
   tf->codes[13581] = 0x000077fa481f85a4UL;
   tf->codes[13582] = 0x0000785e3e445eedUL;
   tf->codes[13583] = 0x0000788646095098UL;
   tf->codes[13584] = 0x000078959977d327UL;
   tf->codes[13585] = 0x000078b739982346UL;
   tf->codes[13586] = 0x000078ca35f70225UL;
   tf->codes[13587] = 0x000078d77a5e50c7UL;
   tf->codes[13588] = 0x00007923e0f7d7cdUL;
   tf->codes[13589] = 0x000079487a5b72edUL;
   tf->codes[13590] = 0x00007a0ff18719f5UL;
   tf->codes[13591] = 0x00007a6d45784bedUL;
   tf->codes[13592] = 0x00007afd26e178f6UL;
   tf->codes[13593] = 0x00007b2f04ac62b8UL;
   tf->codes[13594] = 0x00007b35e16f0fceUL;
   tf->codes[13595] = 0x00007b3740c9326cUL;
   tf->codes[13596] = 0x00007bbc27614a85UL;
   tf->codes[13597] = 0x00007be519625344UL;
   tf->codes[13598] = 0x00007bf2233a9c21UL;
   tf->codes[13599] = 0x00007c426d53853cUL;
   tf->codes[13600] = 0x00007c89cba28d54UL;
   tf->codes[13601] = 0x00007ce9a3b8fec3UL;
   tf->codes[13602] = 0x00007cf54e372502UL;
   tf->codes[13603] = 0x00007d2ad4f26b14UL;
   tf->codes[13604] = 0x00007d4d5f4ed247UL;
   tf->codes[13605] = 0x00007d54ebbe90acUL;
   tf->codes[13606] = 0x00007de3a85ca0dcUL;
   tf->codes[13607] = 0x00007dfa4dabdc0bUL;
   tf->codes[13608] = 0x000080b5938fc180UL;
   tf->codes[13609] = 0x000080c9050cabe9UL;
   tf->codes[13610] = 0x0000810b95a03ad8UL;
   tf->codes[13611] = 0x0000811f41ac2b06UL;
   tf->codes[13612] = 0x0000817d0abb6888UL;
   tf->codes[13613] = 0x00008182fd41fe8aUL;
   tf->codes[13614] = 0x0000819f1ff9c431UL;
   tf->codes[13615] = 0x000081d88a346c58UL;
   tf->codes[13616] = 0x000081ffe24c4cb4UL;
   tf->codes[13617] = 0x000082122efe1a44UL;
   tf->codes[13618] = 0x00008212a41c25ceUL;
   tf->codes[13619] = 0x000082941c52e75cUL;
   tf->codes[13620] = 0x000082b0b428b88dUL;
   tf->codes[13621] = 0x000082fb0bbb0ba6UL;
   tf->codes[13622] = 0x000082fd1ac23f93UL;
   tf->codes[13623] = 0x0000835cf2d8b102UL;
   tf->codes[13624] = 0x0000835ec750df2aUL;
   tf->codes[13625] = 0x00008367eda9c5f2UL;
   tf->codes[13626] = 0x000083a7fa18156aUL;
   tf->codes[13627] = 0x000083d03c6c0cdaUL;
   tf->codes[13628] = 0x00008467aa44f848UL;
   tf->codes[13629] = 0x00008493d01851cdUL;
   tf->codes[13630] = 0x0000854e02dcaa33UL;
   tf->codes[13631] = 0x000086a520e2787fUL;
   tf->codes[13632] = 0x000086c6c102c89eUL;
   tf->codes[13633] = 0x000086faadd4e64dUL;
   tf->codes[13634] = 0x0000873193ea4efdUL;
   tf->codes[13635] = 0x000087d01914ed46UL;
   tf->codes[13636] = 0x000087eb51909bd9UL;
   tf->codes[13637] = 0x0000884b9ec518d2UL;
   tf->codes[13638] = 0x00008a2c711e7860UL;
   tf->codes[13639] = 0x00008a39b585c702UL;
   tf->codes[13640] = 0x00008a59f64bf483UL;
   tf->codes[13641] = 0x00008b2600a40eefUL;
   tf->codes[13642] = 0x00008bc694d5e125UL;
   tf->codes[13643] = 0x00008bd9cbc3c5c9UL;
   tf->codes[13644] = 0x00008cba6c63e777UL;
   tf->codes[13645] = 0x00008cd9fd7d03a9UL;
   tf->codes[13646] = 0x00008d46df6bbdf5UL;
   tf->codes[13647] = 0x00008d612dab5574UL;
   tf->codes[13648] = 0x00008e1cbfc9d078UL;
   tf->codes[13649] = 0x00008e57c3eda102UL;
   tf->codes[13650] = 0x00008ec8143db1d9UL;
   tf->codes[13651] = 0x00008f4115c89deeUL;
   tf->codes[13652] = 0x00008f8714bd8368UL;
   tf->codes[13653] = 0x000090573d2405aeUL;
   tf->codes[13654] = 0x0000913977ad4fbfUL;
   tf->codes[13655] = 0x0000913e7ff7ceadUL;
   tf->codes[13656] = 0x0000914ada23063bUL;
   tf->codes[13657] = 0x0000915350cedbb4UL;
   tf->codes[13658] = 0x000092bc80f771cbUL;
   tf->codes[13659] = 0x000093e619cfc3f4UL;
   tf->codes[13660] = 0x00009523d3d211d5UL;
   tf->codes[13661] = 0x000095899e6f1946UL;
   tf->codes[13662] = 0x000095dd1c5a5327UL;
   tf->codes[13663] = 0x000095e642b339efUL;
   tf->codes[13664] = 0x0000961e4d93bf78UL;
   tf->codes[13665] = 0x00009676241c66f8UL;
   tf->codes[13666] = 0x000097b57807dd3cUL;
   tf->codes[13667] = 0x0000980eadeaa75aUL;
   tf->codes[13668] = 0x000098ccfebd679aUL;
   tf->codes[13669] = 0x000098d99377a4edUL;
   tf->codes[13670] = 0x00009a721d45e54fUL;
   tf->codes[13671] = 0x00009a8bf6677144UL;
   tf->codes[13672] = 0x00009ad563bdad49UL;
   tf->codes[13673] = 0x00009af988033cdfUL;
   tf->codes[13674] = 0x00009b81a26da5beUL;
   tf->codes[13675] = 0x00009bb7d8d5fd1fUL;
   tf->codes[13676] = 0x00009d6cfa7a0eb2UL;
   tf->codes[13677] = 0x00009d969c2828c0UL;
   tf->codes[13678] = 0x00009df290bf381aUL;
   tf->codes[13679] = 0x00009f51eae1d61aUL;
   tf->codes[13680] = 0x00009f7aa253d914UL;
   tf->codes[13681] = 0x00009ffd79e4bd40UL;
   tf->codes[13682] = 0x0000a008af44d7f5UL;
   tf->codes[13683] = 0x0000a064a3dbe74fUL;
   tf->codes[13684] = 0x0000a0d1c059a760UL;
   tf->codes[13685] = 0x0000a1378af6aed1UL;
   tf->codes[13686] = 0x0000a1ff3cb15b9eUL;
   tf->codes[13687] = 0x0000a2ba9440d0ddUL;
   tf->codes[13688] = 0x0000a4155b36fb79UL;
   tf->codes[13689] = 0x0000a4668f8bfba8UL;
   tf->codes[13690] = 0x0000a471ff7b1c22UL;
   tf->codes[13691] = 0x0000a535cdb666daUL;
   tf->codes[13692] = 0x0000a56611982839UL;
   tf->codes[13693] = 0x0000a5acfac924c7UL;
   tf->codes[13694] = 0x0000a67b4eb778e5UL;
   tf->codes[13695] = 0x0000a6ac42464b93UL;
   tf->codes[13696] = 0x0000a73755f3ff73UL;
   tf->codes[13697] = 0x0000a74e35d24067UL;
   tf->codes[13698] = 0x0000a7b5253a64b1UL;
   tf->codes[13699] = 0x0000a8039adb1fa4UL;
   tf->codes[13700] = 0x0000a852107bda97UL;
   tf->codes[13701] = 0x0000a8e0cd19eac7UL;
   tf->codes[13702] = 0x0000a8eaddaee8a3UL;
   tf->codes[13703] = 0x0000a94747640387UL;
   tf->codes[13704] = 0x0000a9d937d4647dUL;
   tf->codes[13705] = 0x0000aa17353b8008UL;
   tf->codes[13706] = 0x0000aa65e56b40c0UL;
   tf->codes[13707] = 0x0000ab2b881eb9a0UL;
   tf->codes[13708] = 0x0000ab60249de89eUL;
   tf->codes[13709] = 0x0000ac48171ec2ecUL;
   tf->codes[13710] = 0x0000ad16a59c1ccfUL;
   tf->codes[13711] = 0x0000adc0d544e157UL;
   tf->codes[13712] = 0x0000addc484f95afUL;
   tf->codes[13713] = 0x0000ae27ff3c0b66UL;
   tf->codes[13714] = 0x0000aeac36271230UL;
   tf->codes[13715] = 0x0000af871ecfa3a1UL;
   tf->codes[13716] = 0x0000afacdcfe5b9aUL;
   tf->codes[13717] = 0x0000afca5f1043dfUL;
   tf->codes[13718] = 0x0000b080ae553a30UL;
   tf->codes[13719] = 0x0000b0b251911e2dUL;
   tf->codes[13720] = 0x0000b0c881c24dd2UL;
   tf->codes[13721] = 0x0000b1f33f65bcd4UL;
   tf->codes[13722] = 0x0000b22174404a46UL;
   tf->codes[13723] = 0x0000b2355adb4039UL;
   tf->codes[13724] = 0x0000b2a1528de371UL;
   tf->codes[13725] = 0x0000b2dc56b1b3fbUL;
   tf->codes[13726] = 0x0000b2e5427b94feUL;
   tf->codes[13727] = 0x0000b31b03c5e0d5UL;
   tf->codes[13728] = 0x0000b38477534496UL;
   tf->codes[13729] = 0x0000b3926b67a487UL;
   tf->codes[13730] = 0x0000b4f324e46525UL;
   tf->codes[13731] = 0x0000b4fa76c51dc5UL;
   tf->codes[13732] = 0x0000b507f5bb722cUL;
   tf->codes[13733] = 0x0000b6954a2997d9UL;
   tf->codes[13734] = 0x0000b6f2638bc40cUL;
   tf->codes[13735] = 0x0000b70c021e4a3cUL;
   tf->codes[13736] = 0x0000b72b9337666eUL;
   tf->codes[13737] = 0x0000b7314b2ef6abUL;
   tf->codes[13738] = 0x0000b767bc2653d1UL;
   tf->codes[13739] = 0x0000b770a7f034d4UL;
   tf->codes[13740] = 0x0000b7f2cfd407b1UL;
   tf->codes[13741] = 0x0000b7fb467fdd2aUL;
   tf->codes[13742] = 0x0000b8b24571e4caUL;
   tf->codes[13743] = 0x0000b8dbac90f913UL;
   tf->codes[13744] = 0x0000b9c20528aafeUL;
   tf->codes[13745] = 0x0000babaaa722a79UL;
   tf->codes[13746] = 0x0000bbc59c6d7784UL;
   tf->codes[13747] = 0x0000bc3f4da574e8UL;
   tf->codes[13748] = 0x0000bc48396f55ebUL;
   tf->codes[13749] = 0x0000bca72749b046UL;
   tf->codes[13750] = 0x0000bd4a0511bc2eUL;
   tf->codes[13751] = 0x0000bda07c404110UL;
   tf->codes[13752] = 0x0000bdafcfaec39fUL;
   tf->codes[13753] = 0x0000bdcc678494d0UL;
   tf->codes[13754] = 0x0000be2737508751UL;
   tf->codes[13755] = 0x0000c18470c0619aUL;
   tf->codes[13756] = 0x0000c218aac6fc42UL;
   tf->codes[13757] = 0x0000c2b29cc52727UL;
   tf->codes[13758] = 0x0000c39377f44e9aUL;
   tf->codes[13759] = 0x0000c41181c9b99dUL;
   tf->codes[13760] = 0x0000c427776be37dUL;
   tf->codes[13761] = 0x0000c468e3345593UL;
   tf->codes[13762] = 0x0000c4b6a927ff37UL;
   tf->codes[13763] = 0x0000c518cad4aa58UL;
   tf->codes[13764] = 0x0000c64d23ef0bacUL;
   tf->codes[13765] = 0x0000c6bb6537e896UL;
   tf->codes[13766] = 0x0000c6dc903a2d2bUL;
   tf->codes[13767] = 0x0000c8083819b341UL;
   tf->codes[13768] = 0x0000c859a6fdb935UL;
   tf->codes[13769] = 0x0000c9687c786855UL;
   tf->codes[13770] = 0x0000c98f9a0142ecUL;
   tf->codes[13771] = 0x0000c9c102ae2124UL;
   tf->codes[13772] = 0x0000ca218a71a3e2UL;
   tf->codes[13773] = 0x0000ca339c946badUL;
   tf->codes[13774] = 0x0000ca6714487dd2UL;
   tf->codes[13775] = 0x0000ca75b809ef12UL;
   tf->codes[13776] = 0x0000cae13a9e86c0UL;
   tf->codes[13777] = 0x0000cb68a55bde50UL;
   tf->codes[13778] = 0x0000cb6a79d40c78UL;
   tf->codes[13779] = 0x0000cba33461a350UL;
   tf->codes[13780] = 0x0000cbd845feddd8UL;
   tf->codes[13781] = 0x0000cce3728930a8UL;
   tf->codes[13782] = 0x0000cd46b900f8a2UL;
   tf->codes[13783] = 0x0000cd809859ac53UL;
   tf->codes[13784] = 0x0000ce054462bea7UL;
   tf->codes[13785] = 0x0000ce1a4fc8d173UL;
   tf->codes[13786] = 0x0000cead9f935507UL;
   tf->codes[13787] = 0x0000ced82b7d8629UL;
   tf->codes[13788] = 0x0000cf93f82b06f2UL;
   tf->codes[13789] = 0x0000cfbc3a7efe62UL;
   tf->codes[13790] = 0x0000cfcbc87c86b6UL;
   tf->codes[13791] = 0x0000cff5a4b9a689UL;
   tf->codes[13792] = 0x0000d0766d4356c8UL;
   tf->codes[13793] = 0x0000d07a50c2b8ddUL;
   tf->codes[13794] = 0x0000d0975db69598UL;
   tf->codes[13795] = 0x0000d158a7cca0d9UL;
   tf->codes[13796] = 0x0000d1da95216df1UL;
   tf->codes[13797] = 0x0000d1e5ca8188a6UL;
   tf->codes[13798] = 0x0000d1ea231ef645UL;
   tf->codes[13799] = 0x0000d211f054e22bUL;
   tf->codes[13800] = 0x0000d23feaa069d8UL;
   tf->codes[13801] = 0x0000d2815668dbeeUL;
   tf->codes[13802] = 0x0000d3a70bc1cc02UL;
   tf->codes[13803] = 0x0000d449aefad225UL;
   tf->codes[13804] = 0x0000d4a235308af4UL;
   tf->codes[13805] = 0x0000d4d7815ccb41UL;
   tf->codes[13806] = 0x0000d53c272eb5d9UL;
   tf->codes[13807] = 0x0000d563b9d59bfaUL;
   tf->codes[13808] = 0x0000d5c2e23efc1aUL;
   tf->codes[13809] = 0x0000d5e865deae4eUL;
   tf->codes[13810] = 0x0000d6191ede7b37UL;
   tf->codes[13811] = 0x0000daaa76d9b10fUL;
   tf->codes[13812] = 0x0000dafafb819fefUL;
   tf->codes[13813] = 0x0000db1b01b8c7abUL;
   tf->codes[13814] = 0x0000dc61e213fc54UL;
   tf->codes[13815] = 0x0000dc71701184a8UL;
   tf->codes[13816] = 0x0000dc8eb7946728UL;
   tf->codes[13817] = 0x0000ddc4aa97f0dfUL;
   tf->codes[13818] = 0x0000ddf6c2f1e066UL;
   tf->codes[13819] = 0x0000de6df0049e53UL;
   tf->codes[13820] = 0x0000dedfda3dd78dUL;
   tf->codes[13821] = 0x0000df4c819d8c14UL;
   tf->codes[13822] = 0x0000df6b630996f7UL;
   tf->codes[13823] = 0x0000e09e223acfe8UL;
   tf->codes[13824] = 0x0000e0b6d6913f04UL;
   tf->codes[13825] = 0x0000e0c99861181eUL;
   tf->codes[13826] = 0x0000e165d3f57cb5UL;
   tf->codes[13827] = 0x0000e518d4e6ca91UL;
   tf->codes[13828] = 0x0000e5fe43426568UL;
   tf->codes[13829] = 0x0000e681ca805ae3UL;
   tf->codes[13830] = 0x0000e691587de337UL;
   tf->codes[13831] = 0x0000e6ba0fefe631UL;
   tf->codes[13832] = 0x0000e7982c6ac868UL;
   tf->codes[13833] = 0x0000e7e5b7cf6c47UL;
   tf->codes[13834] = 0x0000e7e92630c2d2UL;
   tf->codes[13835] = 0x0000e858c6d3c25aUL;
   tf->codes[13836] = 0x0000e8d6961a2798UL;
   tf->codes[13837] = 0x0000e8fa4541aba4UL;
   tf->codes[13838] = 0x0000e91493814323UL;
   tf->codes[13839] = 0x0000e92371d1ba28UL;
   tf->codes[13840] = 0x0000e940b9549ca8UL;
   tf->codes[13841] = 0x0000e9f02bd6e5e3UL;
   tf->codes[13842] = 0x0000eb553df11420UL;
   tf->codes[13843] = 0x0000ec45a71dc3e7UL;
   tf->codes[13844] = 0x0000ecdeaedfd7b8UL;
   tf->codes[13845] = 0x0000edbe9fd2e817UL;
   tf->codes[13846] = 0x0000ee1b441708c0UL;
   tf->codes[13847] = 0x0000ee3bf9fb41cbUL;
   tf->codes[13848] = 0x0000ee9a38288ad7UL;
   tf->codes[13849] = 0x0000efb39356435dUL;
   tf->codes[13850] = 0x0000efdab0df1df4UL;
   tf->codes[13851] = 0x0000f15284c9254bUL;
   tf->codes[13852] = 0x0000f187d0f56598UL;
   tf->codes[13853] = 0x0000f2653dc33680UL;
   tf->codes[13854] = 0x0000f2c0bd3c3a50UL;
   tf->codes[13855] = 0x0000f2d0fae6d3f3UL;
   tf->codes[13856] = 0x0000f3194371f31fUL;
   tf->codes[13857] = 0x0000f333cc409063UL;
   tf->codes[13858] = 0x0000f37cc478c0deUL;
   tf->codes[13859] = 0x0000f3e63806249fUL;
   tf->codes[13860] = 0x0000f42d5bc626f2UL;
   tf->codes[13861] = 0x0000f431eef29a56UL;
   tf->codes[13862] = 0x0000f4773e3a6e81UL;
   tf->codes[13863] = 0x0000f499c896d5b4UL;
   tf->codes[13864] = 0x0000f52c2e254234UL;
   tf->codes[13865] = 0x0000f619637fa135UL;
   tf->codes[13866] = 0x0000f686ba8c670bUL;
   tf->codes[13867] = 0x0000f8ca5e3f8309UL;
   tf->codes[13868] = 0x0000f960e1dc5763UL;
   tf->codes[13869] = 0x0000f96958882cdcUL;
   tf->codes[13870] = 0x0000f9eb45dcf9f4UL;
   tf->codes[13871] = 0x0000fa0b86a32775UL;
   tf->codes[13872] = 0x0000fa3771e77b35UL;
   tf->codes[13873] = 0x0000fa7cfbbe5525UL;
   tf->codes[13874] = 0x0000faf0ba6fbc87UL;
   tf->codes[13875] = 0x0000fb99ffdc69fbUL;
   tf->codes[13876] = 0x0000fbdfc44249b0UL;
   tf->codes[13877] = 0x0000fde89e609ae9UL;
   tf->codes[13878] = 0x0000feb383ed987cUL;
   tf->codes[13879] = 0x0000ff240eccaf18UL;
   tf->codes[13880] = 0x0000ffc8fb9beeedUL;
   tf->codes[13881] = 0x000000b19dc9da8aUL;
   tf->codes[13882] = 0x000003d064b48dbeUL;
   tf->codes[13883] = 0x00000433e5bb5b7dUL;
   tf->codes[13884] = 0x000004f7b3f6a635UL;
   tf->codes[13885] = 0x000006e3bbb02078UL;
   tf->codes[13886] = 0x0000072686d2b52cUL;
   tf->codes[13887] = 0x000007778098af96UL;
   tf->codes[13888] = 0x00000812d1f0fd19UL;
   tf->codes[13889] = 0x0000084c019c9f7bUL;
   tf->codes[13890] = 0x0000093b0b6f2ca4UL;
   tf->codes[13891] = 0x00000976bf400e7dUL;
   tf->codes[13892] = 0x000009e6d501198fUL;
   tf->codes[13893] = 0x000009ec17da9e42UL;
   tf->codes[13894] = 0x00000a53b6efd3dbUL;
   tf->codes[13895] = 0x00000aaec14acc21UL;
   tf->codes[13896] = 0x00000afd36eb8714UL;
   tf->codes[13897] = 0x00000c88f170845eUL;
   tf->codes[13898] = 0x00000d31c1bf2648UL;
   tf->codes[13899] = 0x00000d75771dd210UL;
   tf->codes[13900] = 0x00000da71a59b60dUL;
   tf->codes[13901] = 0x00000e25994d2c9aUL;
   tf->codes[13902] = 0x00000ed162df1985UL;
   tf->codes[13903] = 0x00000ef427ca867dUL;
   tf->codes[13904] = 0x00000f08838387faUL;
   tf->codes[13905] = 0x00000f18869f1bd8UL;
   tf->codes[13906] = 0x00000f6aa530331bUL;
   tf->codes[13907] = 0x0000106e7fd9cd4bUL;
   tf->codes[13908] = 0x000010ec89af384eUL;
   tf->codes[13909] = 0x000011c319ba5c20UL;
   tf->codes[13910] = 0x0000125c5c0b75b6UL;
   tf->codes[13911] = 0x0000126b3a5becbbUL;
   tf->codes[13912] = 0x0000131061ba3255UL;
   tf->codes[13913] = 0x000015188c2b723fUL;
   tf->codes[13914] = 0x00001608803a167cUL;
   tf->codes[13915] = 0x0000164b10cda56bUL;
   tf->codes[13916] = 0x000016a94efaee77UL;
   tf->codes[13917] = 0x0000180415f11913UL;
   tf->codes[13918] = 0x00001849da56f8c8UL;
   tf->codes[13919] = 0x0000188ad1015f54UL;
   tf->codes[13920] = 0x0000193157b9c78cUL;
   tf->codes[13921] = 0x000019c7a0c79621UL;
   tf->codes[13922] = 0x000019c9afceca0eUL;
   tf->codes[13923] = 0x00001ac8822de550UL;
   tf->codes[13924] = 0x00001b2f7196099aUL;
   tf->codes[13925] = 0x00001bec9d9dad01UL;
   tf->codes[13926] = 0x00001bf255953d3eUL;
   tf->codes[13927] = 0x00001d17d05f278dUL;
   tf->codes[13928] = 0x00001d985e59d207UL;
   tf->codes[13929] = 0x00001da184b2b8cfUL;
   tf->codes[13930] = 0x00001ddfbca8da1fUL;
   tf->codes[13931] = 0x00001decc68122fcUL;
   tf->codes[13932] = 0x00001ea350551f12UL;
   tf->codes[13933] = 0x00001f16d47780afUL;
   tf->codes[13934] = 0x00001f2ffdebfb55UL;
   tf->codes[13935] = 0x00001f7f9857d321UL;
   tf->codes[13936] = 0x00001fa222b43a54UL;
   tf->codes[13937] = 0x00001fbfa4c62299UL;
   tf->codes[13938] = 0x0000207f54f30577UL;
   tf->codes[13939] = 0x00002124b6e050d6UL;
   tf->codes[13940] = 0x0000214bd4692b6dUL;
   tf->codes[13941] = 0x000021a0b1ae87ecUL;
   tf->codes[13942] = 0x0000222264744f3fUL;
   tf->codes[13943] = 0x0000227b9a57195dUL;
   tf->codes[13944] = 0x0000229364717165UL;
   tf->codes[13945] = 0x000022df1b5de71cUL;
   tf->codes[13946] = 0x000022fb0386a6feUL;
   tf->codes[13947] = 0x00002378983e0677UL;
   tf->codes[13948] = 0x0000238651c360a3UL;
   tf->codes[13949] = 0x000023e95dac22d8UL;
   tf->codes[13950] = 0x000024ebd8fb9a6aUL;
   tf->codes[13951] = 0x000025533d81ca3eUL;
   tf->codes[13952] = 0x000026750f5b583dUL;
   tf->codes[13953] = 0x0000271911ee80feUL;
   tf->codes[13954] = 0x00002763de9edfa1UL;
   tf->codes[13955] = 0x000027d7d7df4cc8UL;
   tf->codes[13956] = 0x000027fbc195d699UL;
   tf->codes[13957] = 0x0000280caeed818bUL;
   tf->codes[13958] = 0x00002832a7ab3f49UL;
   tf->codes[13959] = 0x0000283b1e5714c2UL;
   tf->codes[13960] = 0x000029030aa0c754UL;
   tf->codes[13961] = 0x00002906b39123a4UL;
   tf->codes[13962] = 0x0000297cf667ca7dUL;
   tf->codes[13963] = 0x000029b11dc8edf1UL;
   tf->codes[13964] = 0x000029dea2f66a14UL;
   tf->codes[13965] = 0x00002a13b493a49cUL;
   tf->codes[13966] = 0x00002a1c65ce7fdaUL;
   tf->codes[13967] = 0x00002abc4a5340c1UL;
   tf->codes[13968] = 0x00002aed78711934UL;
   tf->codes[13969] = 0x00002ba736176610UL;
   tf->codes[13970] = 0x00002c8ca47300e7UL;
   tf->codes[13971] = 0x00002d0cbd4f9fd7UL;
   tf->codes[13972] = 0x00002d75bbbef80eUL;
   tf->codes[13973] = 0x00002d7a897a7137UL;
   tf->codes[13974] = 0x00002d8549bc8062UL;
   tf->codes[13975] = 0x00002e8f16ecb094UL;
   tf->codes[13976] = 0x00002eb634758b2bUL;
   tf->codes[13977] = 0x00002f694fe830b6UL;
   tf->codes[13978] = 0x00002f891b9052adUL;
   tf->codes[13979] = 0x0000304d5ee9a8efUL;
   tf->codes[13980] = 0x000030a918f1b284UL;
   tf->codes[13981] = 0x000030d8ad266294UL;
   tf->codes[13982] = 0x0000317cea48911aUL;
   tf->codes[13983] = 0x0000318f7189646fUL;
   tf->codes[13984] = 0x000031bd6bd4ec1cUL;
   tf->codes[13985] = 0x000031ca008f296fUL;
   tf->codes[13986] = 0x00003358b45771baUL;
   tf->codes[13987] = 0x0000335bad9abcbbUL;
   tf->codes[13988] = 0x000034c5c7ff69e6UL;
   tf->codes[13989] = 0x000034f13e25b21cUL;
   tf->codes[13990] = 0x0000353b95b80535UL;
   tf->codes[13991] = 0x000036f49adb78ddUL;
   tf->codes[13992] = 0x000039c90a33d8f8UL;
   tf->codes[13993] = 0x00003b678688af5cUL;
   tf->codes[13994] = 0x00003b8961380540UL;
   tf->codes[13995] = 0x00003bdb453a16beUL;
   tf->codes[13996] = 0x00003c029d51f71aUL;
   tf->codes[13997] = 0x00003c8ed5cac7d3UL;
   tf->codes[13998] = 0x00003caa48d57c2bUL;
   tf->codes[13999] = 0x00003cfd51a2aa82UL;
   tf->codes[14000] = 0x00003d4faac2c78aUL;
   tf->codes[14001] = 0x00003d8aaee69814UL;
   tf->codes[14002] = 0x00003dbcc740879bUL;
   tf->codes[14003] = 0x00003f5675d9e4d6UL;
   tf->codes[14004] = 0x000040c7e21f4aa1UL;
   tf->codes[14005] = 0x0000417a1355d918UL;
   tf->codes[14006] = 0x000042a0b2eae040UL;
   tf->codes[14007] = 0x000042f7d9c67671UL;
   tf->codes[14008] = 0x0000432b517a8896UL;
   tf->codes[14009] = 0x0000439e9b0de46eUL;
   tf->codes[14010] = 0x00004410bfd6236dUL;
   tf->codes[14011] = 0x000044208862b186UL;
   tf->codes[14012] = 0x00004532cc3eb731UL;
   tf->codes[14013] = 0x000046b5d588d93dUL;
   tf->codes[14014] = 0x000046cd65142b80UL;
   tf->codes[14015] = 0x00004735ee65782dUL;
   tf->codes[14016] = 0x0000475669baab73UL;
   tf->codes[14017] = 0x0000484ba0a2d463UL;
   tf->codes[14018] = 0x000048b638fb54fdUL;
   tf->codes[14019] = 0x000048c8c03c2852UL;
   tf->codes[14020] = 0x000048cb09d26204UL;
   tf->codes[14021] = 0x000048d0873aec7cUL;
   tf->codes[14022] = 0x00004916fb4ddd80UL;
   tf->codes[14023] = 0x00004a6ae5815b06UL;
   tf->codes[14024] = 0x00004b0427d2749cUL;
   tf->codes[14025] = 0x00004b172431537bUL;
   tf->codes[14026] = 0x00004c34d7fc79a0UL;
   tf->codes[14027] = 0x00004c54a3a49b97UL;
   tf->codes[14028] = 0x00004c5f63e6aac2UL;
   tf->codes[14029] = 0x00004c7b4c0f6aa4UL;
   tf->codes[14030] = 0x00004cc110754a59UL;
   tf->codes[14031] = 0x00004d169d67b827UL;
   tf->codes[14032] = 0x00004d7b7dc8a884UL;
   tf->codes[14033] = 0x00004dbc74730f10UL;
   tf->codes[14034] = 0x00004dc859803b14UL;
   tf->codes[14035] = 0x00004dd6c2b2a68fUL;
   tf->codes[14036] = 0x00004e33a185ccfdUL;
   tf->codes[14037] = 0x00004ea30799c6c0UL;
   tf->codes[14038] = 0x00004ef1081c7629UL;
   tf->codes[14039] = 0x00004f79d233f057UL;
   tf->codes[14040] = 0x00004fad0f58fcb7UL;
   tf->codes[14041] = 0x00004fc1a5a103f9UL;
   tf->codes[14042] = 0x00004feca6a940a5UL;
   tf->codes[14043] = 0x000050635e9df308UL;
   tf->codes[14044] = 0x000050a071c8f77fUL;
   tf->codes[14045] = 0x000050dd0fd5f06cUL;
   tf->codes[14046] = 0x0000510cde99a641UL;
   tf->codes[14047] = 0x000051ebaac199c7UL;
   tf->codes[14048] = 0x00005292e127134eUL;
   tf->codes[14049] = 0x000052d86afded3eUL;
   tf->codes[14050] = 0x0000536a5b6e4e34UL;
   tf->codes[14051] = 0x000053a81e4663faUL;
   tf->codes[14052] = 0x000055d25df5ff8dUL;
   tf->codes[14053] = 0x000055e978634646UL;
   tf->codes[14054] = 0x00005615d8c5a590UL;
   tf->codes[14055] = 0x00005657f43b28f5UL;
   tf->codes[14056] = 0x0000569541f53331UL;
   tf->codes[14057] = 0x000056fbbc3f4bf1UL;
   tf->codes[14058] = 0x0000573ced78b842UL;
   tf->codes[14059] = 0x0000573fac2cfd7eUL;
   tf->codes[14060] = 0x000057d1d72c6439UL;
   tf->codes[14061] = 0x000058351da42c33UL;
   tf->codes[14062] = 0x000058b18d906ed3UL;
   tf->codes[14063] = 0x0000592dfd7cb173UL;
   tf->codes[14064] = 0x00005946ec622654UL;
   tf->codes[14065] = 0x00005abd26630548UL;
   tf->codes[14066] = 0x00005acc04b37c4dUL;
   tf->codes[14067] = 0x00005b645cc87ecfUL;
   tf->codes[14068] = 0x00005b7c9c00e261UL;
   tf->codes[14069] = 0x00005c2da86c53ffUL;
   tf->codes[14070] = 0x00005c7666157eb5UL;
   tf->codes[14071] = 0x00005cc8bf359bbdUL;
   tf->codes[14072] = 0x00005cf3c03dd869UL;
   tf->codes[14073] = 0x00005dd12d0ba951UL;
   tf->codes[14074] = 0x00005e3389475a37UL;
   tf->codes[14075] = 0x00005e5e8a4f96e3UL;
   tf->codes[14076] = 0x00005e67eb378370UL;
   tf->codes[14077] = 0x00005ebb2e93b78cUL;
   tf->codes[14078] = 0x00005eebad047eb0UL;
   tf->codes[14079] = 0x00005f1ca093515eUL;
   tf->codes[14080] = 0x00005f3888bc1140UL;
   tf->codes[14081] = 0x00005f5f3126e04dUL;
   tf->codes[14082] = 0x00005fe74b91492cUL;
   tf->codes[14083] = 0x00005fef4d1f131bUL;
   tf->codes[14084] = 0x000060b64f2cae99UL;
   tf->codes[14085] = 0x000060ebd5e7f4abUL;
   tf->codes[14086] = 0x0000612be2564423UL;
   tf->codes[14087] = 0x0000613d7f5b0064UL;
   tf->codes[14088] = 0x00006157587c8c59UL;
   tf->codes[14089] = 0x0000618761cf47f3UL;
   tf->codes[14090] = 0x000061e0d24117d6UL;
   tf->codes[14091] = 0x000062569ff9b325UL;
   tf->codes[14092] = 0x000062e179186140UL;
   tf->codes[14093] = 0x000062f9f2dfca97UL;
   tf->codes[14094] = 0x0000635363519a7aUL;
   tf->codes[14095] = 0x000063b33b680be9UL;
   tf->codes[14096] = 0x000064c99d52796eUL;
   tf->codes[14097] = 0x000064ffd3bad0cfUL;
   tf->codes[14098] = 0x00006554eb8f3313UL;
   tf->codes[14099] = 0x0000656563c8d27bUL;
   tf->codes[14100] = 0x000065bc501562e7UL;
   tf->codes[14101] = 0x0000664c6c0d95b5UL;
   tf->codes[14102] = 0x0000666d5c80d485UL;
   tf->codes[14103] = 0x00006739a167f4b6UL;
   tf->codes[14104] = 0x000067d2a92a0887UL;
   tf->codes[14105] = 0x000067ede1a5b71aUL;
   tf->codes[14106] = 0x0000681fbf70a0dcUL;
   tf->codes[14107] = 0x000068f9bddd1b39UL;
   tf->codes[14108] = 0x00006a815a53b0a9UL;
   tf->codes[14109] = 0x00006a9f8c12aa3dUL;
   tf->codes[14110] = 0x00006b51bd4938b4UL;
   tf->codes[14111] = 0x00006b81517de8c4UL;
   tf->codes[14112] = 0x00006bedbe4e9786UL;
   tf->codes[14113] = 0x00006c8b93cc2480UL;
   tf->codes[14114] = 0x00006d7ad82db76eUL;
   tf->codes[14115] = 0x00006d95266d4eedUL;
   tf->codes[14116] = 0x00006e1579d8f3a2UL;
   tf->codes[14117] = 0x00006e9607d39e1cUL;
   tf->codes[14118] = 0x00006e9eb90e795aUL;
   tf->codes[14119] = 0x00006ee52d216a5eUL;
   tf->codes[14120] = 0x00006f450537dbcdUL;
   tf->codes[14121] = 0x000070fce590329cUL;
   tf->codes[14122] = 0x000071770be63b8aUL;
   tf->codes[14123] = 0x000072476edbc395UL;
   tf->codes[14124] = 0x00007290a1a2f9d5UL;
   tf->codes[14125] = 0x00007302514d2d4aUL;
   tf->codes[14126] = 0x0000736c39f89c95UL;
   tf->codes[14127] = 0x000073985fcbf61aUL;
   tf->codes[14128] = 0x000075018ff48c31UL;
   tf->codes[14129] = 0x000075b97922aae5UL;
   tf->codes[14130] = 0x000075df375162deUL;
   tf->codes[14131] = 0x00007601c1adca11UL;
   tf->codes[14132] = 0x000076b88610cbecUL;
   tf->codes[14133] = 0x000076c79ef048b6UL;
   tf->codes[14134] = 0x000076e387190898UL;
   tf->codes[14135] = 0x0000775327bc0820UL;
   tf->codes[14136] = 0x0000793cab5042ecUL;
   tf->codes[14137] = 0x000079d453b8341fUL;
   tf->codes[14138] = 0x00007a8c02574d0eUL;
   tf->codes[14139] = 0x00007ab8282aa693UL;
   tf->codes[14140] = 0x00007b4bed1335b1UL;
   tf->codes[14141] = 0x00007b9f306f69cdUL;
   tf->codes[14142] = 0x00007bd5a166c6f3UL;
   tf->codes[14143] = 0x00007c17824d4493UL;
   tf->codes[14144] = 0x00007de4337ca869UL;
   tf->codes[14145] = 0x00007e6bd8c905beUL;
   tf->codes[14146] = 0x00007f63ce6573eaUL;
   tf->codes[14147] = 0x00007f840f2ba16bUL;
   tf->codes[14148] = 0x00007fcf8b89115dUL;
   tf->codes[14149] = 0x00008034a679077fUL;
   tf->codes[14150] = 0x0000808440e4df4bUL;
   tf->codes[14151] = 0x00008158fc77d4f5UL;
   tf->codes[14152] = 0x00008236de63b167UL;
   tf->codes[14153] = 0x000083c432d1d714UL;
   tf->codes[14154] = 0x00008486dc4204f3UL;
   tf->codes[14155] = 0x000085e8ba89e26aUL;
   tf->codes[14156] = 0x0000861a5dc5c667UL;
   tf->codes[14157] = 0x00008772db25b751UL;
   tf->codes[14158] = 0x00008800e816b632UL;
   tf->codes[14159] = 0x000088150940b1eaUL;
   tf->codes[14160] = 0x0000885675092400UL;
   tf->codes[14161] = 0x000088a0577d6b8fUL;
   tf->codes[14162] = 0x000088ad6155b46cUL;
   tf->codes[14163] = 0x000088dcf58a647cUL;
   tf->codes[14164] = 0x000089b8c86f0d01UL;
   tf->codes[14165] = 0x000089f47c3feedaUL;
   tf->codes[14166] = 0x00008acf2a597a86UL;
   tf->codes[14167] = 0x00008bbbb006c838UL;
   tf->codes[14168] = 0x00008c56c6d00ff6UL;
   tf->codes[14169] = 0x00008caba4156c75UL;
   tf->codes[14170] = 0x00008cb2bb671f50UL;
   tf->codes[14171] = 0x00008d4c72d64470UL;
   tf->codes[14172] = 0x00008d7146c8e555UL;
   tf->codes[14173] = 0x00008d9446435812UL;
   tf->codes[14174] = 0x00008dd5025eb8d9UL;
   tf->codes[14175] = 0x00008e39a830a371UL;
   tf->codes[14176] = 0x00008ef65f1a3b4eUL;
   tf->codes[14177] = 0x000090191b2fe061UL;
   tf->codes[14178] = 0x000091052bbf2289UL;
   tf->codes[14179] = 0x000091235d7e1c1dUL;
   tf->codes[14180] = 0x0000920ef8ef52bbUL;
   tf->codes[14181] = 0x0000923e5294fd06UL;
   tf->codes[14182] = 0x000093129909e726UL;
   tf->codes[14183] = 0x00009380da52c410UL;
   tf->codes[14184] = 0x0000949a700f825bUL;
   tf->codes[14185] = 0x0000953a54944342UL;
   tf->codes[14186] = 0x0000953dc2f599cdUL;
   tf->codes[14187] = 0x000095467430750bUL;
   tf->codes[14188] = 0x0000955c2f439926UL;
   tf->codes[14189] = 0x00009560fcff124fUL;
   tf->codes[14190] = 0x000095651b0d7a29UL;
   tf->codes[14191] = 0x0000957ce527d231UL;
   tf->codes[14192] = 0x000095859662ad6fUL;
   tf->codes[14193] = 0x000096153d3cd4b3UL;
   tf->codes[14194] = 0x000096775ee97fd4UL;
   tf->codes[14195] = 0x0000968d548ba9b4UL;
   tf->codes[14196] = 0x000096cadcd4b9b5UL;
   tf->codes[14197] = 0x0000980a6b4f35beUL;
   tf->codes[14198] = 0x000099494a1ca078UL;
   tf->codes[14199] = 0x00009a08100d6c42UL;
   tf->codes[14200] = 0x00009ab44ebd64b7UL;
   tf->codes[14201] = 0x00009b7314ae3081UL;
   tf->codes[14202] = 0x00009b7dd4f03facUL;
   tf->codes[14203] = 0x00009c3bb0a4f462UL;
   tf->codes[14204] = 0x00009dc103855020UL;
   tf->codes[14205] = 0x00009e1cf81c5f7aUL;
   tf->codes[14206] = 0x00009e68e997daf6UL;
   tf->codes[14207] = 0x00009ef3130977c2UL;
   tf->codes[14208] = 0x00009f4b24212507UL;
   tf->codes[14209] = 0x00009f4d6db75eb9UL;
   tf->codes[14210] = 0x0000a1a35e1c4847UL;
   tf->codes[14211] = 0x0000a37acf8dbb48UL;
   tf->codes[14212] = 0x0000a3b6bdeda2e6UL;
   tf->codes[14213] = 0x0000a468ef24315dUL;
   tf->codes[14214] = 0x0000a6e1a47487e3UL;
   tf->codes[14215] = 0x0000a7556325ef45UL;
   tf->codes[14216] = 0x0000a8910e210939UL;
   tf->codes[14217] = 0x0000a8e32cb2207cUL;
   tf->codes[14218] = 0x0000a931a252db6fUL;
   tf->codes[14219] = 0x0000a9e61d1fa398UL;
   tf->codes[14220] = 0x0000aa0ed491a692UL;
   tf->codes[14221] = 0x0000aadb8e96d24dUL;
   tf->codes[14222] = 0x0000aaf860fba943UL;
   tf->codes[14223] = 0x0000ab2aee73a454UL;
   tf->codes[14224] = 0x0000ac627b60566eUL;
   tf->codes[14225] = 0x0000ac7c5481e263UL;
   tf->codes[14226] = 0x0000acad4810b511UL;
   tf->codes[14227] = 0x0000acef28f732b1UL;
   tf->codes[14228] = 0x0000ad34ed5d1266UL;
   tf->codes[14229] = 0x0000ae476bc81dd6UL;
   tf->codes[14230] = 0x0000af23ee59d7aaUL;
   tf->codes[14231] = 0x0000b000365c8bb9UL;
   tf->codes[14232] = 0x0000b042c6f01aa8UL;
   tf->codes[14233] = 0x0000b08d59117386UL;
   tf->codes[14234] = 0x0000b1186cbf2766UL;
   tf->codes[14235] = 0x0000b151274cbe3eUL;
   tf->codes[14236] = 0x0000b19258862a8fUL;
   tf->codes[14237] = 0x0000b1d732aff330UL;
   tf->codes[14238] = 0x0000b1e09397dfbdUL;
   tf->codes[14239] = 0x0000b2495778322fUL;
   tf->codes[14240] = 0x0000b28580671f92UL;
   tf->codes[14241] = 0x0000b2ae37d9228cUL;
   tf->codes[14242] = 0x0000b2e433b27428UL;
   tf->codes[14243] = 0x0000b3adb9e54f1dUL;
   tf->codes[14244] = 0x0000b46443b94b33UL;
   tf->codes[14245] = 0x0000b47e91f8e2b2UL;
   tf->codes[14246] = 0x0000b48917abec18UL;
   tf->codes[14247] = 0x0000b4c4cb7ccdf1UL;
   tf->codes[14248] = 0x0000b50d1407ed1dUL;
   tf->codes[14249] = 0x0000b5a6cb77123dUL;
   tf->codes[14250] = 0x0000b6584d008f65UL;
   tf->codes[14251] = 0x0000b6f7bc6744c2UL;
   tf->codes[14252] = 0x0000b83cc84a4b43UL;
   tf->codes[14253] = 0x0000b8745e0cc542UL;
   tf->codes[14254] = 0x0000b8d34be71f9dUL;
   tf->codes[14255] = 0x0000b936cceded5cUL;
   tf->codes[14256] = 0x0000b94ed1974b29UL;
   tf->codes[14257] = 0x0000b950a60f7951UL;
   tf->codes[14258] = 0x0000b9d97026f37fUL;
   tf->codes[14259] = 0x0000ba656e10be73UL;
   tf->codes[14260] = 0x0000bab8b16cf28fUL;
   tf->codes[14261] = 0x0000bb0518067995UL;
   tf->codes[14262] = 0x0000bb1b0da8a375UL;
   tf->codes[14263] = 0x0000bb5fad436651UL;
   tf->codes[14264] = 0x0000bba95528a81bUL;
   tf->codes[14265] = 0x0000bbd1d20ba550UL;
   tf->codes[14266] = 0x0000bbe6a2e2b257UL;
   tf->codes[14267] = 0x0000bc0cd62f75daUL;
   tf->codes[14268] = 0x0000bc5e45137bceUL;
   tf->codes[14269] = 0x0000bcb0d8c29e9bUL;
   tf->codes[14270] = 0x0000bd929e2ddd22UL;
   tf->codes[14271] = 0x0000bd9fe2952bc4UL;
   tf->codes[14272] = 0x0000bda4b050a4edUL;
   tf->codes[14273] = 0x0000bdfa3d4312bbUL;
   tf->codes[14274] = 0x0000be99aca9c818UL;
   tf->codes[14275] = 0x0000bf7e30c94bdbUL;
   tf->codes[14276] = 0x0000bf9510a78ccfUL;
   tf->codes[14277] = 0x0000c006c051c044UL;
   tf->codes[14278] = 0x0000c0427422a21dUL;
   tf->codes[14279] = 0x0000c083303e02e4UL;
   tf->codes[14280] = 0x0000c0e72662dc2dUL;
   tf->codes[14281] = 0x0000c166ca216f93UL;
   tf->codes[14282] = 0x0000c26094360be7UL;
   tf->codes[14283] = 0x0000c35d1cfeed77UL;
   tf->codes[14284] = 0x0000c3efbd1c5fbcUL;
   tf->codes[14285] = 0x0000c4b2668c8d9bUL;
   tf->codes[14286] = 0x0000c5241636c110UL;
   tf->codes[14287] = 0x0000c636cf30d245UL;
   tf->codes[14288] = 0x0000c651cd1d7b13UL;
   tf->codes[14289] = 0x0000c6783af9445bUL;
   tf->codes[14290] = 0x0000c79db5c32eaaUL;
   tf->codes[14291] = 0x0000c7ab6f4888d6UL;
   tf->codes[14292] = 0x0000c7bc5ca033c8UL;
   tf->codes[14293] = 0x0000c8293e8eee14UL;
   tf->codes[14294] = 0x0000ca6a98abd060UL;
   tf->codes[14295] = 0x0000ca9908156397UL;
   tf->codes[14296] = 0x0000cca42bc9ee82UL;
   tf->codes[14297] = 0x0000cd1b1e4da6aaUL;
   tf->codes[14298] = 0x0000cd22702e5f4aUL;
   tf->codes[14299] = 0x0000cd645114dceaUL;
   tf->codes[14300] = 0x0000cd9afc9b3fd5UL;
   tf->codes[14301] = 0x0000cdae6e182a3eUL;
   tf->codes[14302] = 0x0000ce231705a8b4UL;
   tf->codes[14303] = 0x0000cec370a87525UL;
   tf->codes[14304] = 0x0000cf53c72fadb8UL;
   tf->codes[14305] = 0x0000d069b3fc0fb3UL;
   tf->codes[14306] = 0x0000d081438761f6UL;
   tf->codes[14307] = 0x0000d28eeb612c58UL;
   tf->codes[14308] = 0x0000d2a1e7c00b37UL;
   tf->codes[14309] = 0x0000d2afdbd46b28UL;
   tf->codes[14310] = 0x0000d2b384c4c778UL;
   tf->codes[14311] = 0x0000d430d6175947UL;
   tf->codes[14312] = 0x0000d47c8d03cefeUL;
   tf->codes[14313] = 0x0000d495f1074f69UL;
   tf->codes[14314] = 0x0000d5eea8f64618UL;
   tf->codes[14315] = 0x0000d670964b1330UL;
   tf->codes[14316] = 0x0000d677e82bcbd0UL;
   tf->codes[14317] = 0x0000d723772eb2f6UL;
   tf->codes[14318] = 0x0000d7a85dc6cb0fUL;
   tf->codes[14319] = 0x0000d7cfb5deab6bUL;
   tf->codes[14320] = 0x0000d7dc4a98e8beUL;
   tf->codes[14321] = 0x0000da6e9e7bc574UL;
   tf->codes[14322] = 0x0000db4ddfc1c484UL;
   tf->codes[14323] = 0x0000dd5c3748a035UL;
   tf->codes[14324] = 0x0000de86ba5d0972UL;
   tf->codes[14325] = 0x0000de93fec45814UL;
   tf->codes[14326] = 0x0000e151c8cd7d00UL;
   tf->codes[14327] = 0x0000e1d8494ebd7cUL;
   tf->codes[14328] = 0x0000e1fb48c93039UL;
   tf->codes[14329] = 0x0000e28487feb5f1UL;
   tf->codes[14330] = 0x0000e348563a00a9UL;
   tf->codes[14331] = 0x0000e3b65cf3d7ceUL;
   tf->codes[14332] = 0x0000e3f7c8bc49e4UL;
   tf->codes[14333] = 0x0000e44d55aeb7b2UL;
   tf->codes[14334] = 0x0000e4cf7d928a8fUL;
   tf->codes[14335] = 0x0000e6480129a335UL;
   tf->codes[14336] = 0x0000e93106ca0a92UL;
   tf->codes[14337] = 0x0000e94612301d5eUL;
   tf->codes[14338] = 0x0000eab9185eab8cUL;
   tf->codes[14339] = 0x0000ebdb24c73f50UL;
   tf->codes[14340] = 0x0000ed1b285fc6e3UL;
   tf->codes[14341] = 0x0000ee477fec5e48UL;
   tf->codes[14342] = 0x0000ef0f6c3610daUL;
   tf->codes[14343] = 0x0000ef58d98c4cdfUL;
   tf->codes[14344] = 0x0000f1759a45940bUL;
   tf->codes[14345] = 0x0000f18ec3ba0eb1UL;
   tf->codes[14346] = 0x0000f20e2ce99c52UL;
   tf->codes[14347] = 0x0000f2b095939cb0UL;
   tf->codes[14348] = 0x0000f317fa19cc84UL;
   tf->codes[14349] = 0x0000f39ca622ded8UL;
   tf->codes[14350] = 0x0000f470b208c333UL;
   tf->codes[14351] = 0x0000f492179a0d8dUL;
   tf->codes[14352] = 0x0000f4d1aeea517bUL;
   tf->codes[14353] = 0x0000f5aafda9ba89UL;
   tf->codes[14354] = 0x0000f62fa9b2ccddUL;
   tf->codes[14355] = 0x0000f74ad958b38bUL;
   tf->codes[14356] = 0x0000f761b936f47fUL;
   tf->codes[14357] = 0x0000f779f86f5811UL;
   tf->codes[14358] = 0x0000f7a275525546UL;
   tf->codes[14359] = 0x0000f84d54a82b1dUL;
   tf->codes[14360] = 0x0000f93e32f2e66eUL;
   tf->codes[14361] = 0x0000f957d1856c9eUL;
   tf->codes[14362] = 0x0000fa8b05d4b119UL;
   tf->codes[14363] = 0x0000fa8fd3902a42UL;
   tf->codes[14364] = 0x0000faeaddeb2288UL;
   tf->codes[14365] = 0x0000fb1d30d417d4UL;
   tf->codes[14366] = 0x0000fc09f1106b4bUL;
   tf->codes[14367] = 0x0000fc3ae49f3df9UL;
   tf->codes[14368] = 0x0000fd8de496a46bUL;
   tf->codes[14369] = 0x0000fda2b56db172UL;
   tf->codes[14370] = 0x0000fe99863f02c5UL;
   tf->codes[14371] = 0x0000ff349d084a83UL;
   tf->codes[14372] = 0x0000ff9e85b3b9ceUL;
   tf->codes[14373] = 0x00000116cebbccafUL;
   tf->codes[14374] = 0x0000026b689c5b84UL;
   tf->codes[14375] = 0x0000043227452958UL;
   tf->codes[14376] = 0x00000452680b56d9UL;
   tf->codes[14377] = 0x0000045ec2368e67UL;
   tf->codes[14378] = 0x0000046689355291UL;
   tf->codes[14379] = 0x0000057aa1898664UL;
   tf->codes[14380] = 0x000005a149f45571UL;
   tf->codes[14381] = 0x000005f71175c904UL;
   tf->codes[14382] = 0x000006616f3f43d9UL;
   tf->codes[14383] = 0x0000067fdb8d4332UL;
   tf->codes[14384] = 0x0000082116965ed2UL;
   tf->codes[14385] = 0x000008aa55cbe48aUL;
   tf->codes[14386] = 0x00000b91c1832384UL;
   tf->codes[14387] = 0x00000cf574432f23UL;
   tf->codes[14388] = 0x00000d58babaf71dUL;
   tf->codes[14389] = 0x00000d72594d7d4dUL;
   tf->codes[14390] = 0x00000d72ce6b88d7UL;
   tf->codes[14391] = 0x00000fbf98778b9dUL;
   tf->codes[14392] = 0x00000fc6afc93e78UL;
   tf->codes[14393] = 0x00000fe93a25a5abUL;
   tf->codes[14394] = 0x00000fffdf74e0daUL;
   tf->codes[14395] = 0x0000100472a1543eUL;
   tf->codes[14396] = 0x000010f58b7b1554UL;
   tf->codes[14397] = 0x000011058e96a932UL;
   tf->codes[14398] = 0x000011ab2b12fa56UL;
   tf->codes[14399] = 0x000011cdb56f6189UL;
   tf->codes[14400] = 0x00001219a6eadd05UL;
   tf->codes[14401] = 0x0000130d095ad7cdUL;
   tf->codes[14402] = 0x00001377a1b35867UL;
   tf->codes[14403] = 0x000014b93f35085dUL;
   tf->codes[14404] = 0x000014c907c19676UL;
   tf->codes[14405] = 0x0000150187c02789UL;
   tf->codes[14406] = 0x0000158c60ded5a4UL;
   tf->codes[14407] = 0x000015a7243c78adUL;
   tf->codes[14408] = 0x000015e01959154aUL;
   tf->codes[14409] = 0x0000165f0d6a9761UL;
   tf->codes[14410] = 0x000016ea21184b41UL;
   tf->codes[14411] = 0x00001859b8e582e4UL;
   tf->codes[14412] = 0x0000191460c7e6d4UL;
   tf->codes[14413] = 0x000019f451baf733UL;
   tf->codes[14414] = 0x00001a5dc5485af4UL;
   tf->codes[14415] = 0x00001b93089ed35cUL;
   tf->codes[14416] = 0x00001c72f991e3bbUL;
   tf->codes[14417] = 0x00001c8ac3ac3bc3UL;
   tf->codes[14418] = 0x00001ebcca5a9b80UL;
   tf->codes[14419] = 0x00001f2c6afd9b08UL;
   tf->codes[14420] = 0x00001f5104613628UL;
   tf->codes[14421] = 0x00001f7f73cac95fUL;
   tf->codes[14422] = 0x000020c39571b8ccUL;
   tf->codes[14423] = 0x00002156358f2b11UL;
   tf->codes[14424] = 0x000021a903cd53a3UL;
   tf->codes[14425] = 0x000022bd1c218776UL;
   tf->codes[14426] = 0x000022f5619112c4UL;
   tf->codes[14427] = 0x000023436213c22dUL;
   tf->codes[14428] = 0x00002388b15b9658UL;
   tf->codes[14429] = 0x00002426c1682917UL;
   tf->codes[14430] = 0x000025084c4461d9UL;
   tf->codes[14431] = 0x0000253521c4ccadUL;
   tf->codes[14432] = 0x0000257b20b9b227UL;
   tf->codes[14433] = 0x000025f12901533bUL;
   tf->codes[14434] = 0x0000260fcfde5859UL;
   tf->codes[14435] = 0x00002683c91ec580UL;
   tf->codes[14436] = 0x000028896f6ac5f3UL;
   tf->codes[14437] = 0x0000294ab980d134UL;
   tf->codes[14438] = 0x000029ebfd5fb4b9UL;
   tf->codes[14439] = 0x00002a0bc907d6b0UL;
   tf->codes[14440] = 0x00002a4707baacffUL;
   tf->codes[14441] = 0x00002a486714cf9dUL;
   tf->codes[14442] = 0x00002aad0ce6ba35UL;
   tf->codes[14443] = 0x00002ad4da1ca61bUL;
   tf->codes[14444] = 0x00002ae84b999084UL;
   tf->codes[14445] = 0x00002b689f053539UL;
   tf->codes[14446] = 0x00002c4c7377a7adUL;
   tf->codes[14447] = 0x00002c52a08d4374UL;
   tf->codes[14448] = 0x00002c84f37638c0UL;
   tf->codes[14449] = 0x00002ea6475bf350UL;
   tf->codes[14450] = 0x000030d8137b4d48UL;
   tf->codes[14451] = 0x0000318af45eed0eUL;
   tf->codes[14452] = 0x00003263937144cdUL;
   tf->codes[14453] = 0x000032eea71ef8adUL;
   tf->codes[14454] = 0x000032f5be70ab88UL;
   tf->codes[14455] = 0x00003313408293cdUL;
   tf->codes[14456] = 0x0000336f3519a327UL;
   tf->codes[14457] = 0x00003655f123d0d2UL;
   tf->codes[14458] = 0x000036bb46a2ccb9UL;
   tf->codes[14459] = 0x000036cb844d665cUL;
   tf->codes[14460] = 0x000037423c4218bfUL;
   tf->codes[14461] = 0x000037a9db574e58UL;
   tf->codes[14462] = 0x000038452caf9bdbUL;
   tf->codes[14463] = 0x00003c91aa810912UL;
   tf->codes[14464] = 0x00003ccf32ca1913UL;
   tf->codes[14465] = 0x00003de55a2580d3UL;
   tf->codes[14466] = 0x00003e252c04ca86UL;
   tf->codes[14467] = 0x0000405523abf656UL;
   tf->codes[14468] = 0x0000422ac0a53b2fUL;
   tf->codes[14469] = 0x000042c611fd88b2UL;
   tf->codes[14470] = 0x0000430e9517ada3UL;
   tf->codes[14471] = 0x000043692a549a5fUL;
   tf->codes[14472] = 0x0000444b9f6cea35UL;
   tf->codes[14473] = 0x000044b4634d3ca7UL;
   tf->codes[14474] = 0x000045159abdd0b4UL;
   tf->codes[14475] = 0x000045ccd43ede19UL;
   tf->codes[14476] = 0x000045eb05fdd7adUL;
   tf->codes[14477] = 0x0000467c46c12754UL;
   tf->codes[14478] = 0x000046d199248f5dUL;
   tf->codes[14479] = 0x000047200ec54a50UL;
   tf->codes[14480] = 0x0000472b7eb46acaUL;
   tf->codes[14481] = 0x00004876f23c12d7UL;
   tf->codes[14482] = 0x000048ef098ae7d8UL;
   tf->codes[14483] = 0x0000491af4cf3b98UL;
   tf->codes[14484] = 0x000049972a2c7873UL;
   tf->codes[14485] = 0x000049e5da5c392bUL;
   tf->codes[14486] = 0x00004b8f16f31ebaUL;
   tf->codes[14487] = 0x00004bd42babed20UL;
   tf->codes[14488] = 0x00004c8ab57fe936UL;
   tf->codes[14489] = 0x00004cb6a0c43cf6UL;
   tf->codes[14490] = 0x00004da95387266fUL;
   tf->codes[14491] = 0x00004eb89e1fe119UL;
   tf->codes[14492] = 0x00004fb6c0d1eb0cUL;
   tf->codes[14493] = 0x000051420638dcccUL;
   tf->codes[14494] = 0x000051dca7e41900UL;
   tf->codes[14495] = 0x000051dce2731ec5UL;
   tf->codes[14496] = 0x000052c584a10a62UL;
   tf->codes[14497] = 0x000053798a4fc701UL;
   tf->codes[14498] = 0x000054e7c2c2dc06UL;
   tf->codes[14499] = 0x0000561579a99609UL;
   tf->codes[14500] = 0x000056375458ebedUL;
   tf->codes[14501] = 0x000056be84873db8UL;
   tf->codes[14502] = 0x0000571277908323UL;
   tf->codes[14503] = 0x00005738e56c4c6bUL;
   tf->codes[14504] = 0x0000584a799b40c7UL;
   tf->codes[14505] = 0x000058bc2945743cUL;
   tf->codes[14506] = 0x00005985af784f31UL;
   tf->codes[14507] = 0x0000598624965abbUL;
   tf->codes[14508] = 0x00005a00105d5de4UL;
   tf->codes[14509] = 0x00005a38905beef7UL;
   tf->codes[14510] = 0x00005b1930fc10a5UL;
   tf->codes[14511] = 0x00005b35c8d1e1d6UL;
   tf->codes[14512] = 0x00005cc4f1b835abUL;
   tf->codes[14513] = 0x00005e3d3ac0488cUL;
   tf->codes[14514] = 0x00005ebeb2f70a1aUL;
   tf->codes[14515] = 0x00005f9afaf9be29UL;
   tf->codes[14516] = 0x00005fbcd5a9140dUL;
   tf->codes[14517] = 0x000061b02f4346f0UL;
   tf->codes[14518] = 0x00006217ce587c89UL;
   tf->codes[14519] = 0x00006368bf48af0eUL;
   tf->codes[14520] = 0x000064904919cd4aUL;
   tf->codes[14521] = 0x000064daa0ac2063UL;
   tf->codes[14522] = 0x000065b16b4649faUL;
   tf->codes[14523] = 0x000065fb132b8bc4UL;
   tf->codes[14524] = 0x00006670313715c4UL;
   tf->codes[14525] = 0x000066f1344fcbc8UL;
   tf->codes[14526] = 0x000068bff486638bUL;
   tf->codes[14527] = 0x000068f491059289UL;
   tf->codes[14528] = 0x00006930f48385b1UL;
   tf->codes[14529] = 0x000069bc42c03f56UL;
   tf->codes[14530] = 0x00006a0b2d7f05d3UL;
   tf->codes[14531] = 0x00006aeb939021bcUL;
   tf->codes[14532] = 0x00006b3f4c0a6162UL;
   tf->codes[14533] = 0x00006bf1b7cff59eUL;
   tf->codes[14534] = 0x00006c3e58f88269UL;
   tf->codes[14535] = 0x00006c4ff5fd3eaaUL;
   tf->codes[14536] = 0x00006c63a2092ed8UL;
   tf->codes[14537] = 0x00006cd7d5d8a1c4UL;
   tf->codes[14538] = 0x00006dd8f1cdf6b8UL;
   tf->codes[14539] = 0x00006e37a5194b4eUL;
   tf->codes[14540] = 0x00006ecc8eccf745UL;
   tf->codes[14541] = 0x00006ed8ae69290eUL;
   tf->codes[14542] = 0x00006f41acd88145UL;
   tf->codes[14543] = 0x00006f5349dd3d86UL;
   tf->codes[14544] = 0x00006f8b54bdc30fUL;
   tf->codes[14545] = 0x00006fa94bedb6deUL;
   tf->codes[14546] = 0x00006fb4f66bdd1dUL;
   tf->codes[14547] = 0x00006fcf7f3a7a61UL;
   tf->codes[14548] = 0x00006ff6d7525abdUL;
   tf->codes[14549] = 0x000070e272c3915bUL;
   tf->codes[14550] = 0x00007129968393aeUL;
   tf->codes[14551] = 0x000071a0fe255760UL;
   tf->codes[14552] = 0x00007207786f7020UL;
   tf->codes[14553] = 0x0000727ea5822e0dUL;
   tf->codes[14554] = 0x0000730e86eb5b16UL;
   tf->codes[14555] = 0x00007342e8db844fUL;
   tf->codes[14556] = 0x0000738b6bf5a940UL;
   tf->codes[14557] = 0x00007482ec740be2UL;
   tf->codes[14558] = 0x0000748e96f23221UL;
   tf->codes[14559] = 0x00007490a5f9660eUL;
   tf->codes[14560] = 0x000074a6267d8464UL;
   tf->codes[14561] = 0x000074b1214e9954UL;
   tf->codes[14562] = 0x000075460b02454bUL;
   tf->codes[14563] = 0x00007589faeff6d8UL;
   tf->codes[14564] = 0x000075a0a03f3207UL;
   tf->codes[14565] = 0x000075ef15dfecfaUL;
   tf->codes[14566] = 0x000077a178cfb951UL;
   tf->codes[14567] = 0x00007999dab46b22UL;
   tf->codes[14568] = 0x000079d5c91452c0UL;
   tf->codes[14569] = 0x00007a03c35fda6dUL;
   tf->codes[14570] = 0x00007a14b0b7855fUL;
   tf->codes[14571] = 0x00007a3b1e934ea7UL;
   tf->codes[14572] = 0x00007a6cc1cf32a4UL;
   tf->codes[14573] = 0x00007b36bd201923UL;
   tf->codes[14574] = 0x00007b48cf42e0eeUL;
   tf->codes[14575] = 0x00007b6b1f10425cUL;
   tf->codes[14576] = 0x00007bdafa4247a9UL;
   tf->codes[14577] = 0x00007c12ca93c76dUL;
   tf->codes[14578] = 0x00007c1589480ca9UL;
   tf->codes[14579] = 0x00007c54365c3983UL;
   tf->codes[14580] = 0x00007ca9c34ea751UL;
   tf->codes[14581] = 0x00007d5a200d07a0UL;
   tf->codes[14582] = 0x00007ddbd2d2cef3UL;
   tf->codes[14583] = 0x00007e0cc661a1a1UL;
   tf->codes[14584] = 0x00007e3be5784627UL;
   tf->codes[14585] = 0x00007e5f1f81bea9UL;
   tf->codes[14586] = 0x00007e7a1d6e6777UL;
   tf->codes[14587] = 0x00007f094f2a8331UL;
   tf->codes[14588] = 0x0000801c42b39a2bUL;
   tf->codes[14589] = 0x000080b4603996e8UL;
   tf->codes[14590] = 0x000081e3767a7389UL;
   tf->codes[14591] = 0x000082a276fa4518UL;
   tf->codes[14592] = 0x000082fd0c3731d4UL;
   tf->codes[14593] = 0x0000835816922a1aUL;
   tf->codes[14594] = 0x000083b863c6a713UL;
   tf->codes[14595] = 0x000083d77fc1b7bbUL;
   tf->codes[14596] = 0x000084371d492365UL;
   tf->codes[14597] = 0x000084454bec891bUL;
   tf->codes[14598] = 0x0000851b2c4a9b9eUL;
   tf->codes[14599] = 0x0000853d4188f747UL;
   tf->codes[14600] = 0x00008712de823c20UL;
   tf->codes[14601] = 0x000087d219911374UL;
   tf->codes[14602] = 0x00008872adc2e5aaUL;
   tf->codes[14603] = 0x000089b98e1e1a53UL;
   tf->codes[14604] = 0x000089c413d123b9UL;
   tf->codes[14605] = 0x00008aa404c43418UL;
   tf->codes[14606] = 0x00008adb2568a28dUL;
   tf->codes[14607] = 0x00008ae2022b4fa3UL;
   tf->codes[14608] = 0x00008b324c4438beUL;
   tf->codes[14609] = 0x00008bc82033fbc9UL;
   tf->codes[14610] = 0x00008c1919f9f633UL;
   tf->codes[14611] = 0x00008df5ce44ede7UL;
   tf->codes[14612] = 0x00008e10cc3196b5UL;
   tf->codes[14613] = 0x00008ef5fffe2bc7UL;
   tf->codes[14614] = 0x00008f0469309742UL;
   tf->codes[14615] = 0x00008f694991879fUL;
   tf->codes[14616] = 0x0000907943d75398UL;
   tf->codes[14617] = 0x000091099a5e8c2bUL;
   tf->codes[14618] = 0x000091ecf9b2f315UL;
   tf->codes[14619] = 0x000092241a57618aUL;
   tf->codes[14620] = 0x000092a3be15f4f0UL;
   tf->codes[14621] = 0x000092f89b5b516fUL;
   tf->codes[14622] = 0x0000944a01698f7eUL;
   tf->codes[14623] = 0x00009463da8b1b73UL;
   tf->codes[14624] = 0x000094d8f896a573UL;
   tf->codes[14625] = 0x0000964388195e28UL;
   tf->codes[14626] = 0x000099e6fb0d23b0UL;
   tf->codes[14627] = 0x00009c44ecffd72dUL;
   tf->codes[14628] = 0x00009f132f429b81UL;
   tf->codes[14629] = 0x00009f383dc4422bUL;
   tf->codes[14630] = 0x00009f8a96e45f33UL;
   tf->codes[14631] = 0x0000a055f18f6850UL;
   tf->codes[14632] = 0x0000a14c87d1b3deUL;
   tf->codes[14633] = 0x0000a19a133657bdUL;
   tf->codes[14634] = 0x0000a23fea41aea6UL;
   tf->codes[14635] = 0x0000a337dfde1cd2UL;
   tf->codes[14636] = 0x0000a405841f5fa1UL;
   tf->codes[14637] = 0x0000a580514cb1f9UL;
   tf->codes[14638] = 0x0000a6bb8729c063UL;
   tf->codes[14639] = 0x0000a7014b8fa018UL;
   tf->codes[14640] = 0x0000a778b33163caUL;
   tf->codes[14641] = 0x0000a784983e8fceUL;
   tf->codes[14642] = 0x0000a793768f06d3UL;
   tf->codes[14643] = 0x0000a923c4407781UL;
   tf->codes[14644] = 0x0000a93cedb4f227UL;
   tf->codes[14645] = 0x0000aa388c41bca3UL;
   tf->codes[14646] = 0x0000aa664bfe3e8bUL;
   tf->codes[14647] = 0x0000aa98d976399cUL;
   tf->codes[14648] = 0x0000ab69ec18d2f6UL;
   tf->codes[14649] = 0x0000ab7730802198UL;
   tf->codes[14650] = 0x0000abbe8ecf29b0UL;
   tf->codes[14651] = 0x0000ac6799acd15fUL;
   tf->codes[14652] = 0x0000ae5a090aed2eUL;
   tf->codes[14653] = 0x0000ae87191a5dc7UL;
   tf->codes[14654] = 0x0000af1a2e55db96UL;
   tf->codes[14655] = 0x0000af5189894fd0UL;
   tf->codes[14656] = 0x0000af9be11ba2e9UL;
   tf->codes[14657] = 0x0000b02c7231e141UL;
   tf->codes[14658] = 0x0000b061f8ed2753UL;
   tf->codes[14659] = 0x0000b0dfc8338c91UL;
   tf->codes[14660] = 0x0000b1681d2cfb35UL;
   tf->codes[14661] = 0x0000b1a5e00510fbUL;
   tf->codes[14662] = 0x0000b1a6ca41280fUL;
   tf->codes[14663] = 0x0000b2003ab2f7f2UL;
   tf->codes[14664] = 0x0000b2a14402d5b2UL;
   tf->codes[14665] = 0x0000b4dce62827c1UL;
   tf->codes[14666] = 0x0000b50981198cd0UL;
   tf->codes[14667] = 0x0000b537f0832007UL;
   tf->codes[14668] = 0x0000b5c7975d474bUL;
   tf->codes[14669] = 0x0000b5dbb8874303UL;
   tf->codes[14670] = 0x0000b781119ec67dUL;
   tf->codes[14671] = 0x0000b81e71fe47edUL;
   tf->codes[14672] = 0x0000b86b1326d4b8UL;
   tf->codes[14673] = 0x0000b96726d1aabeUL;
   tf->codes[14674] = 0x0000bac31292f233UL;
   tf->codes[14675] = 0x0000bbc97161cbdaUL;
   tf->codes[14676] = 0x0000bd03f791c8f5UL;
   tf->codes[14677] = 0x0000bd402080b658UL;
   tf->codes[14678] = 0x0000bd464d96521fUL;
   tf->codes[14679] = 0x0000bd5da2929e9dUL;
   tf->codes[14680] = 0x0000bd8ed0b07710UL;
   tf->codes[14681] = 0x0000be94f4f04af2UL;
   tf->codes[14682] = 0x0000bed74af4d41cUL;
   tf->codes[14683] = 0x0000bf651d56cd38UL;
   tf->codes[14684] = 0x0000bff11b40982cUL;
   tf->codes[14685] = 0x0000c0378f538930UL;
   tf->codes[14686] = 0x0000c22655c148afUL;
   tf->codes[14687] = 0x0000c24696877630UL;
   tf->codes[14688] = 0x0000c2b2191c0ddeUL;
   tf->codes[14689] = 0x0000c2dbf5592db1UL;
   tf->codes[14690] = 0x0000c3aa494781cfUL;
   tf->codes[14691] = 0x0000c3f6ea700e9aUL;
   tf->codes[14692] = 0x0000c467754f2536UL;
   tf->codes[14693] = 0x0000c6955def1d19UL;
   tf->codes[14694] = 0x0000c6b180a6e2c0UL;
   tf->codes[14695] = 0x0000c6c1be517c63UL;
   tf->codes[14696] = 0x0000c7d59c16aa71UL;
   tf->codes[14697] = 0x0000c8d4e393d13dUL;
   tf->codes[14698] = 0x0000c9a078cde01fUL;
   tf->codes[14699] = 0x0000c9d3b5f2ec7fUL;
   tf->codes[14700] = 0x0000ca7c4bb288a4UL;
   tf->codes[14701] = 0x0000ca85ac9a7531UL;
   tf->codes[14702] = 0x0000cc396ee46426UL;
   tf->codes[14703] = 0x0000cd020adb2807UL;
   tf->codes[14704] = 0x0000cd387bd2852dUL;
   tf->codes[14705] = 0x0000cf28a19a674aUL;
   tf->codes[14706] = 0x0000d06a3f1c1740UL;
   tf->codes[14707] = 0x0000d06c13944568UL;
   tf->codes[14708] = 0x0000d177058f9273UL;
   tf->codes[14709] = 0x0000d1e92a57d172UL;
   tf->codes[14710] = 0x0000d286ffd55e6cUL;
   tf->codes[14711] = 0x0000d2ea464d2666UL;
   tf->codes[14712] = 0x0000d46cda793ce8UL;
   tf->codes[14713] = 0x0000d4a3c08ea598UL;
   tf->codes[14714] = 0x0000d5c6f1c25635UL;
   tf->codes[14715] = 0x0000d7618a97ca84UL;
   tf->codes[14716] = 0x0000d9aec9c1d8d4UL;
   tf->codes[14717] = 0x0000d9e3db5f135cUL;
   tf->codes[14718] = 0x0000dac5a0ca51e3UL;
   tf->codes[14719] = 0x0000dbb3faefcdbdUL;
   tf->codes[14720] = 0x0000dcadff936fd6UL;
   tf->codes[14721] = 0x0000dcefa5eae7b1UL;
   tf->codes[14722] = 0x0000dd706e7497f0UL;
   tf->codes[14723] = 0x0000ddac5cd47f8eUL;
   tf->codes[14724] = 0x0000de14ab96c676UL;
   tf->codes[14725] = 0x0000de4230c44299UL;
   tf->codes[14726] = 0x0000de4fea499cc5UL;
   tf->codes[14727] = 0x0000e06ce591e9b6UL;
   tf->codes[14728] = 0x0000e105ed53fd87UL;
   tf->codes[14729] = 0x0000e41bc874cfb8UL;
   tf->codes[14730] = 0x0000e487c02772f0UL;
   tf->codes[14731] = 0x0000e5497f5b89bbUL;
   tf->codes[14732] = 0x0000e56fed375303UL;
   tf->codes[14733] = 0x0000e5c2bb757b95UL;
   tf->codes[14734] = 0x0000e66e0fe95cf6UL;
   tf->codes[14735] = 0x0000e67d6357df85UL;
   tf->codes[14736] = 0x0000e6b4496d4835UL;
   tf->codes[14737] = 0x0000e7897a1e4969UL;
   tf->codes[14738] = 0x0000e7bfeb15a68fUL;
   tf->codes[14739] = 0x0000e7ec4b7805d9UL;
   tf->codes[14740] = 0x0000e814533cf784UL;
   tf->codes[14741] = 0x0000e8a4e45335dcUL;
   tf->codes[14742] = 0x0000e9812c55e9ebUL;
   tf->codes[14743] = 0x0000e98c9c450a65UL;
   tf->codes[14744] = 0x0000eb426d962d47UL;
   tf->codes[14745] = 0x0000ec8ecb59ec68UL;
   tf->codes[14746] = 0x0000ed9773beffc1UL;
   tf->codes[14747] = 0x0000edfed8452f95UL;
   tf->codes[14748] = 0x0000efc43793dacbUL;
   tf->codes[14749] = 0x0000f3313990432dUL;
   tf->codes[14750] = 0x0000f43cdb38a187UL;
   tf->codes[14751] = 0x0000f45bf733b22fUL;
   tf->codes[14752] = 0x0000f45ca6e0c37eUL;
   tf->codes[14753] = 0x0000f837af970305UL;
   tf->codes[14754] = 0x0000f8736367e4deUL;
   tf->codes[14755] = 0x0000f8e9e0cd917cUL;
   tf->codes[14756] = 0x0000fae5eba29f9dUL;
   tf->codes[14757] = 0x0000fc7b7c2d94feUL;
   tf->codes[14758] = 0x0000fdd3f98d85e8UL;
   tf->codes[14759] = 0x0000fded5d910653UL;
   tf->codes[14760] = 0x0000fedeb0f9cd2eUL;
   tf->codes[14761] = 0x0000fee6b287971dUL;
   tf->codes[14762] = 0x0000026dc8349139UL;
   tf->codes[14763] = 0x000003144eecf971UL;
   tf->codes[14764] = 0x00000372528b3cb8UL;
   tf->codes[14765] = 0x000003a58fb04918UL;
   tf->codes[14766] = 0x0000050091357979UL;
   tf->codes[14767] = 0x00000586d727b430UL;
   tf->codes[14768] = 0x00000732d272defbUL;
   tf->codes[14769] = 0x0000081e33550fd4UL;
   tf->codes[14770] = 0x000008dcbeb6d5d9UL;
   tf->codes[14771] = 0x000009199752d48bUL;
   tf->codes[14772] = 0x00000a43302b26b4UL;
   tf->codes[14773] = 0x00000b7ea0973ae3UL;
   tf->codes[14774] = 0x00000bc54f3931acUL;
   tf->codes[14775] = 0x00000bd811090ac6UL;
   tf->codes[14776] = 0x00000d80d881e4cbUL;
   tf->codes[14777] = 0x00000d889f80a8f5UL;
   tf->codes[14778] = 0x00000f3c273b9225UL;
   tf->codes[14779] = 0x0000105d0ed90910UL;
   tf->codes[14780] = 0x000010e2dfad383dUL;
   tf->codes[14781] = 0x000012fb8258178fUL;
   tf->codes[14782] = 0x000013c6a2741ae7UL;
   tf->codes[14783] = 0x0000145b5198c119UL;
   tf->codes[14784] = 0x0000185af3b29bc0UL;
   tf->codes[14785] = 0x000018e7dbd87dc8UL;
   tf->codes[14786] = 0x00001a8aeb59c790UL;
   tf->codes[14787] = 0x00001b0377c6a81bUL;
   tf->codes[14788] = 0x00001b7268bc9654UL;
   tf->codes[14789] = 0x00001f669ae75081UL;
   tf->codes[14790] = 0x000020222d05cb85UL;
   tf->codes[14791] = 0x000021334c16b457UL;
   tf->codes[14792] = 0x000021861a54dce9UL;
   tf->codes[14793] = 0x000021f78f700a99UL;
   tf->codes[14794] = 0x000022b7050de7b2UL;
   tf->codes[14795] = 0x000023b22e7ca6a4UL;
   tf->codes[14796] = 0x000024d81e649c7dUL;
   tf->codes[14797] = 0x0000254416173fb5UL;
   tf->codes[14798] = 0x00002559d12a63d0UL;
   tf->codes[14799] = 0x000025deb7c27be9UL;
   tf->codes[14800] = 0x00002632aacbc154UL;
   tf->codes[14801] = 0x0000265918a78a9cUL;
   tf->codes[14802] = 0x00002818fa8dab5aUL;
   tf->codes[14803] = 0x00002895df97f984UL;
   tf->codes[14804] = 0x0000295bf7697deeUL;
   tf->codes[14805] = 0x000029bd2eda11fbUL;
   tf->codes[14806] = 0x00002d51fe0c6643UL;
   tf->codes[14807] = 0x00002d8575c07868UL;
   tf->codes[14808] = 0x00002da78afed411UL;
   tf->codes[14809] = 0x00002dadb8146fd8UL;
   tf->codes[14810] = 0x00002edd43735803UL;
   tf->codes[14811] = 0x00002f2725e79f92UL;
   tf->codes[14812] = 0x0000307caa04457bUL;
   tf->codes[14813] = 0x00003133e38552e0UL;
   tf->codes[14814] = 0x000031c4e9b99cc2UL;
   tf->codes[14815] = 0x000032e93fb86a38UL;
   tf->codes[14816] = 0x0000345569244b50UL;
   tf->codes[14817] = 0x0000352c33be74e7UL;
   tf->codes[14818] = 0x0000356772714b36UL;
   tf->codes[14819] = 0x0000361f5b9f69eaUL;
   tf->codes[14820] = 0x000037f53327b488UL;
   tf->codes[14821] = 0x000038b299be5db4UL;
   tf->codes[14822] = 0x0000392aeb9c387aUL;
   tf->codes[14823] = 0x000039e767f6ca92UL;
   tf->codes[14824] = 0x00003a4aae6e928cUL;
   tf->codes[14825] = 0x00003a8ffdb666b7UL;
   tf->codes[14826] = 0x00003b067b1c1355UL;
   tf->codes[14827] = 0x00003b5983e941acUL;
   tf->codes[14828] = 0x00003bf9a2fd0858UL;
   tf->codes[14829] = 0x00003c38c52f40bcUL;
   tf->codes[14830] = 0x00003c8fb17bd128UL;
   tf->codes[14831] = 0x00003dd7b6a222aaUL;
   tf->codes[14832] = 0x00003e02f239651bUL;
   tf->codes[14833] = 0x00003f9a91cb8e69UL;
   tf->codes[14834] = 0x00003fac2ed04aaaUL;
   tf->codes[14835] = 0x000040b6e63c91f0UL;
   tf->codes[14836] = 0x00004184c50cda84UL;
   tf->codes[14837] = 0x00004186998508acUL;
   tf->codes[14838] = 0x000041e6719b7a1bUL;
   tf->codes[14839] = 0x0000423f326038afUL;
   tf->codes[14840] = 0x0000441b718d24d9UL;
   tf->codes[14841] = 0x00004427912956a2UL;
   tf->codes[14842] = 0x0000453cce48a74eUL;
   tf->codes[14843] = 0x0000455a15cb89ceUL;
   tf->codes[14844] = 0x0000460a37fae458UL;
   tf->codes[14845] = 0x00004786d9a064d8UL;
   tf->codes[14846] = 0x0000498f0411a4c2UL;
   tf->codes[14847] = 0x000049e36c38f5b7UL;
   tf->codes[14848] = 0x00004ad82e03131dUL;
   tf->codes[14849] = 0x00004b4c27438044UL;
   tf->codes[14850] = 0x00004b8f67842082UL;
   tf->codes[14851] = 0x00004bfecd981a45UL;
   tf->codes[14852] = 0x00004c118f67f35fUL;
   tf->codes[14853] = 0x00004c766fc8e3bcUL;
   tf->codes[14854] = 0x00004cb93aeb7870UL;
   tf->codes[14855] = 0x00004cd17a23dc02UL;
   tf->codes[14856] = 0x00004d094a755bc6UL;
   tf->codes[14857] = 0x00004d21c43cc51dUL;
   tf->codes[14858] = 0x00004e6aee2e3378UL;
   tf->codes[14859] = 0x00004f0938c9cbfcUL;
   tf->codes[14860] = 0x00004fa7f883700aUL;
   tf->codes[14861] = 0x000050d91dcb8098UL;
   tf->codes[14862] = 0x0000510493f1c8ceUL;
   tf->codes[14863] = 0x00005145157e23d0UL;
   tf->codes[14864] = 0x0000519b178e9d28UL;
   tf->codes[14865] = 0x000051e8a2f34107UL;
   tf->codes[14866] = 0x000053014e73e83eUL;
   tf->codes[14867] = 0x0000536bac3d6313UL;
   tf->codes[14868] = 0x000053e55d756077UL;
   tf->codes[14869] = 0x0000548be42dc8afUL;
   tf->codes[14870] = 0x00005495f4c2c68bUL;
   tf->codes[14871] = 0x000054bdfc87b836UL;
   tf->codes[14872] = 0x000054d4dc65f92aUL;
   tf->codes[14873] = 0x0000552c03418f5bUL;
   tf->codes[14874] = 0x0000555111c33605UL;
   tf->codes[14875] = 0x00005689c37b04f8UL;
   tf->codes[14876] = 0x0000578cee778dd9UL;
   tf->codes[14877] = 0x00005836a90246d7UL;
   tf->codes[14878] = 0x000058621f288f0dUL;
   tf->codes[14879] = 0x000058b3537d8f3cUL;
   tf->codes[14880] = 0x000058dbd0608c71UL;
   tf->codes[14881] = 0x00005a4784ae61ffUL;
   tf->codes[14882] = 0x00005a5a467e3b19UL;
   tf->codes[14883] = 0x00005bfc31346808UL;
   tf->codes[14884] = 0x00005d322437f1bfUL;
   tf->codes[14885] = 0x00005d5055f6eb53UL;
   tf->codes[14886] = 0x00005dcc50c52269UL;
   tf->codes[14887] = 0x00005e759631cfddUL;
   tf->codes[14888] = 0x000060a1aa599998UL;
   tf->codes[14889] = 0x000061265662abecUL;
   tf->codes[14890] = 0x000061d344bfb5b0UL;
   tf->codes[14891] = 0x000062222f7e7c2dUL;
   tf->codes[14892] = 0x000063d57caa5f98UL;
   tf->codes[14893] = 0x0000642dc85112a2UL;
   tf->codes[14894] = 0x00006562d1188545UL;
   tf->codes[14895] = 0x00006612f347dfcfUL;
   tf->codes[14896] = 0x000067a6af5aa708UL;
   tf->codes[14897] = 0x000067c55637ac26UL;
   tf->codes[14898] = 0x0000681b5848257eUL;
   tf->codes[14899] = 0x0000690f6a653195UL;
   tf->codes[14900] = 0x0000692560075b75UL;
   tf->codes[14901] = 0x000069d8b60906c5UL;
   tf->codes[14902] = 0x000069e92e42a62dUL;
   tf->codes[14903] = 0x00006adc1b94956bUL;
   tf->codes[14904] = 0x00006b254e5bcbabUL;
   tf->codes[14905] = 0x00006c2c5cd7b6a1UL;
   tf->codes[14906] = 0x00006db593377474UL;
   tf->codes[14907] = 0x00006df85e5a0928UL;
   tf->codes[14908] = 0x00006e327841c29eUL;
   tf->codes[14909] = 0x00006e979331b8c0UL;
   tf->codes[14910] = 0x00006f4c488d86aeUL;
   tf->codes[14911] = 0x00006f6f0d78f3a6UL;
   tf->codes[14912] = 0x00006f9f16cbaf40UL;
   tf->codes[14913] = 0x000070004e3c434dUL;
   tf->codes[14914] = 0x0000700d1d858665UL;
   tf->codes[14915] = 0x00007087094c898eUL;
   tf->codes[14916] = 0x000072af7483f6f9UL;
   tf->codes[14917] = 0x000072dc84936792UL;
   tf->codes[14918] = 0x000073851a5303b7UL;
   tf->codes[14919] = 0x000073a55b193138UL;
   tf->codes[14920] = 0x000074a935c2cb68UL;
   tf->codes[14921] = 0x000074f402732a0bUL;
   tf->codes[14922] = 0x000075820f6428ecUL;
   tf->codes[14923] = 0x0000758c5a882c8dUL;
   tf->codes[14924] = 0x00007671c8e3c764UL;
   tf->codes[14925] = 0x000076874967e5baUL;
   tf->codes[14926] = 0x000076da52351411UL;
   tf->codes[14927] = 0x00007730c96398f3UL;
   tf->codes[14928] = 0x00007759f5f3a777UL;
   tf->codes[14929] = 0x0000775a6b11b301UL;
   tf->codes[14930] = 0x0000794b05f7a0a8UL;
   tf->codes[14931] = 0x000079629582f2ebUL;
   tf->codes[14932] = 0x00007a524f029163UL;
   tf->codes[14933] = 0x00007afbcefe449cUL;
   tf->codes[14934] = 0x00007b9c633016d2UL;
   tf->codes[14935] = 0x00007c361a9f3bf2UL;
   tf->codes[14936] = 0x00007cd1a6868f3aUL;
   tf->codes[14937] = 0x00007d129d30f5c6UL;
   tf->codes[14938] = 0x00007d4181b89487UL;
   tf->codes[14939] = 0x00007e03b60ab6dcUL;
   tf->codes[14940] = 0x00007ed5033c55fbUL;
   tf->codes[14941] = 0x00007fa5db4fe990UL;
   tf->codes[14942] = 0x000080855724ee65UL;
   tf->codes[14943] = 0x0000809f30467a5aUL;
   tf->codes[14944] = 0x000080c529043818UL;
   tf->codes[14945] = 0x000080d5dbccdd45UL;
   tf->codes[14946] = 0x0000810cfc714bbaUL;
   tf->codes[14947] = 0x0000815cd16c294bUL;
   tf->codes[14948] = 0x000081b816562756UL;
   tf->codes[14949] = 0x000082d813b7872dUL;
   tf->codes[14950] = 0x000083d427625d33UL;
   tf->codes[14951] = 0x00008526028ea6ccUL;
   tf->codes[14952] = 0x000086d3d251ffbfUL;
   tf->codes[14953] = 0x000086de58050925UL;
   tf->codes[14954] = 0x000088d9b32d05f7UL;
   tf->codes[14955] = 0x0000893cbf15c82cUL;
   tf->codes[14956] = 0x000089523f99e682UL;
   tf->codes[14957] = 0x00008a30d132d443UL;
   tf->codes[14958] = 0x00008a343f942aceUL;
   tf->codes[14959] = 0x00008b9b9b4492bdUL;
   tf->codes[14960] = 0x00008c16abd6b2bfUL;
   tf->codes[14961] = 0x00008cd98fd5e663UL;
   tf->codes[14962] = 0x00008da6bef91da8UL;
   tf->codes[14963] = 0x00008de481d1336eUL;
   tf->codes[14964] = 0x0000904691d24ec5UL;
   tf->codes[14965] = 0x00009087135ea9c7UL;
   tf->codes[14966] = 0x000090983b455a7eUL;
   tf->codes[14967] = 0x000091874517e7a7UL;
   tf->codes[14968] = 0x0000922bf75821b7UL;
   tf->codes[14969] = 0x000092b02e432881UL;
   tf->codes[14970] = 0x0000937bc37d3763UL;
   tf->codes[14971] = 0x00009421d5179411UL;
   tf->codes[14972] = 0x00009570b70092a9UL;
   tf->codes[14973] = 0x000095f7ac9fdeafUL;
   tf->codes[14974] = 0x0000968160f36ff1UL;
   tf->codes[14975] = 0x000096a12c9b91e8UL;
   tf->codes[14976] = 0x0000970522c06b31UL;
   tf->codes[14977] = 0x0000979a0c741728UL;
   tf->codes[14978] = 0x000097ad4361fbccUL;
   tf->codes[14979] = 0x000097d07d6b744eUL;
   tf->codes[14980] = 0x000099756164ec3eUL;
   tf->codes[14981] = 0x000099ae568188dbUL;
   tf->codes[14982] = 0x000099b8dc349241UL;
   tf->codes[14983] = 0x00009a26e2ee6966UL;
   tf->codes[14984] = 0x00009a53b86ed43aUL;
   tf->codes[14985] = 0x00009ac6c7732a4dUL;
   tf->codes[14986] = 0x00009b483fa9ebdbUL;
   tf->codes[14987] = 0x00009b9c32b33146UL;
   tf->codes[14988] = 0x00009c5715249afbUL;
   tf->codes[14989] = 0x00009ce55ca49fa1UL;
   tf->codes[14990] = 0x00009d774d150097UL;
   tf->codes[14991] = 0x00009de9374e39d1UL;
   tf->codes[14992] = 0x00009e3efecfad64UL;
   tf->codes[14993] = 0x00009fd6d8f0dc77UL;
   tf->codes[14994] = 0x0000a1bec29beee0UL;
   tf->codes[14995] = 0x0000a22bdf19aef1UL;
   tf->codes[14996] = 0x0000a25be86c6a8bUL;
   tf->codes[14997] = 0x0000a3cf2929fe7eUL;
   tf->codes[14998] = 0x0000a523135d7c04UL;
   tf->codes[14999] = 0x0000a5e3e8557bbbUL;
   tf->codes[15000] = 0x0000a5e6e198c6bcUL;
   tf->codes[15001] = 0x0000a68232f1143fUL;
   tf->codes[15002] = 0x0000a6a482be75adUL;
   tf->codes[15003] = 0x0000a6b8a3e87165UL;
   tf->codes[15004] = 0x0000a6cf83c6b259UL;
   tf->codes[15005] = 0x0000a6ec1b9c838aUL;
   tf->codes[15006] = 0x0000a75b81b07d4dUL;
   tf->codes[15007] = 0x0000a90b25ec0468UL;
   tf->codes[15008] = 0x0000a9712b18119eUL;
   tf->codes[15009] = 0x0000a9dad9347b24UL;
   tf->codes[15010] = 0x0000aaad10a23157UL;
   tf->codes[15011] = 0x0000ab0a6493634fUL;
   tf->codes[15012] = 0x0000ad32201dbf6bUL;
   tf->codes[15013] = 0x0000af48ee507095UL;
   tf->codes[15014] = 0x0000afa2d3e04c02UL;
   tf->codes[15015] = 0x0000b069d5ede780UL;
   tf->codes[15016] = 0x0000b15d72ece80dUL;
   tf->codes[15017] = 0x0000b2390b428acdUL;
   tf->codes[15018] = 0x0000b265e0c2f5a1UL;
   tf->codes[15019] = 0x0000b274f9a2726bUL;
   tf->codes[15020] = 0x0000b2d2fd40b5b2UL;
   tf->codes[15021] = 0x0000b35cec234cb9UL;
   tf->codes[15022] = 0x0000b397f0471d43UL;
   tf->codes[15023] = 0x0000b4959ddb1bacUL;
   tf->codes[15024] = 0x0000b4d4c00d5410UL;
   tf->codes[15025] = 0x0000b5d9fa1110deUL;
   tf->codes[15026] = 0x0000b625b0fd8695UL;
   tf->codes[15027] = 0x0000b6c60aa05306UL;
   tf->codes[15028] = 0x0000b76922f764b3UL;
   tf->codes[15029] = 0x0000b7928a1678fcUL;
   tf->codes[15030] = 0x0000b84c824bcb9dUL;
   tf->codes[15031] = 0x0000b85c104953f1UL;
   tf->codes[15032] = 0x0000b9401f4acc2aUL;
   tf->codes[15033] = 0x0000b96c451e25afUL;
   tf->codes[15034] = 0x0000b9b920d5b83fUL;
   tf->codes[15035] = 0x0000bb6088f46fa6UL;
   tf->codes[15036] = 0x0000bcc1b78f3bceUL;
   tf->codes[15037] = 0x0000bd04f7cfdc0cUL;
   tf->codes[15038] = 0x0000bd348c048c1cUL;
   tf->codes[15039] = 0x0000bd6c21c7061bUL;
   tf->codes[15040] = 0x0000bfbac04b3709UL;
   tf->codes[15041] = 0x0000bfc1d79ce9e4UL;
   tf->codes[15042] = 0x0000c0f2c255f4adUL;
   tf->codes[15043] = 0x0000c223ad0eff76UL;
   tf->codes[15044] = 0x0000c285942ca4d2UL;
   tf->codes[15045] = 0x0000c36d4c1e795bUL;
   tf->codes[15046] = 0x0000c3c682014379UL;
   tf->codes[15047] = 0x0000c3d1b7615e2eUL;
   tf->codes[15048] = 0x0000c42151cd35faUL;
   tf->codes[15049] = 0x0000c52ae46e6067UL;
   tf->codes[15050] = 0x0000c54c49ffaac1UL;
   tf->codes[15051] = 0x0000c5a3e5f94c7cUL;
   tf->codes[15052] = 0x0000c67951395375UL;
   tf->codes[15053] = 0x0000c6b71411693bUL;
   tf->codes[15054] = 0x0000c7c3da84e46eUL;
   tf->codes[15055] = 0x0000c9fcbdf5f141UL;
   tf->codes[15056] = 0x0000ca0693fbe958UL;
   tf->codes[15057] = 0x0000ca3871c6d31aUL;
   tf->codes[15058] = 0x0000cae3c63ab47bUL;
   tf->codes[15059] = 0x0000cb3d36ac845eUL;
   tf->codes[15060] = 0x0000cc51898fbdf6UL;
   tf->codes[15061] = 0x0000cc8c189582f6UL;
   tf->codes[15062] = 0x0000cca6dbf325ffUL;
   tf->codes[15063] = 0x0000cdc15bebfb5eUL;
   tf->codes[15064] = 0x0000ce885df996dcUL;
   tf->codes[15065] = 0x0000d0879ca0f5c3UL;
   tf->codes[15066] = 0x0000d1678d940622UL;
   tf->codes[15067] = 0x0000d1c6065054f3UL;
   tf->codes[15068] = 0x0000d32316dcb941UL;
   tf->codes[15069] = 0x0000d51217d97e85UL;
   tf->codes[15070] = 0x0000d53eed59e959UL;
   tf->codes[15071] = 0x0000d542212c3a1fUL;
   tf->codes[15072] = 0x0000d54345f756f8UL;
   tf->codes[15073] = 0x0000d6ffb97c212bUL;
   tf->codes[15074] = 0x0000dababbfb38f6UL;
   tf->codes[15075] = 0x0000db393aeeaf83UL;
   tf->codes[15076] = 0x0000dc935237c8d0UL;
   tf->codes[15077] = 0x0000ddd3905f5628UL;
   tf->codes[15078] = 0x0000de3ffd3004eaUL;
   tf->codes[15079] = 0x0000df277a92d3aeUL;
   tf->codes[15080] = 0x0000e047b283394aUL;
   tf->codes[15081] = 0x0000e2c8696159bfUL;
   tf->codes[15082] = 0x0000e4793267fdb3UL;
   tf->codes[15083] = 0x0000e4dfe7411c38UL;
   tf->codes[15084] = 0x0000e4fcb9a5f32eUL;
   tf->codes[15085] = 0x0000e51b25f3f287UL;
   tf->codes[15086] = 0x0000e5783f561ebaUL;
   tf->codes[15087] = 0x0000e6f8c47b014fUL;
   tf->codes[15088] = 0x0000e706b88f6140UL;
   tf->codes[15089] = 0x0000e8f5f41b2c49UL;
   tf->codes[15090] = 0x0000e92c6512896fUL;
   tf->codes[15091] = 0x0000e97731c2e812UL;
   tf->codes[15092] = 0x0000eb6f1e898e59UL;
   tf->codes[15093] = 0x0000ecc468172e7dUL;
   tf->codes[15094] = 0x0000ef26781849d4UL;
   tf->codes[15095] = 0x0000ef66bf159f11UL;
   tf->codes[15096] = 0x0000efbc1179071aUL;
   tf->codes[15097] = 0x0000f070c6d4d508UL;
   tf->codes[15098] = 0x0000f1b5d2b7db89UL;
   tf->codes[15099] = 0x0000f3fd1f5b53d7UL;
   tf->codes[15100] = 0x0000f4c371bbde06UL;
   tf->codes[15101] = 0x0000f5eb70ab07ccUL;
   tf->codes[15102] = 0x0000f66437a6ee1cUL;
   tf->codes[15103] = 0x0000f6f74ce26bebUL;
   tf->codes[15104] = 0x0000f739dd75fadaUL;
   tf->codes[15105] = 0x0000f77b0eaf672bUL;
   tf->codes[15106] = 0x0000f889e42a164bUL;
   tf->codes[15107] = 0x0000fb1ef6c1383dUL;
   tf->codes[15108] = 0x0000fbe165a26057UL;
   tf->codes[15109] = 0x0000fc764f560c4eUL;
   tf->codes[15110] = 0x0000fd529758c05dUL;
   tf->codes[15111] = 0x0000fd81f0fe6aa8UL;
   tf->codes[15112] = 0x0000ff5509d2700aUL;
   tf->codes[15113] = 0x0000ffcfa5468482UL;
   tf->codes[15114] = 0x00000109413a6a89UL;
   tf->codes[15115] = 0x00000189cf351503UL;
   tf->codes[15116] = 0x00000208fdd59cdfUL;
   tf->codes[15117] = 0x0000024c3e163d1dUL;
   tf->codes[15118] = 0x0000043ead7458ecUL;
   tf->codes[15119] = 0x000004c68d4fbc06UL;
   tf->codes[15120] = 0x000008a2bad11866UL;
   tf->codes[15121] = 0x000008d373d0e54fUL;
   tf->codes[15122] = 0x0000097fb280ddc4UL;
   tf->codes[15123] = 0x00000ac3247abbe2UL;
   tf->codes[15124] = 0x00000b6308ff7cc9UL;
   tf->codes[15125] = 0x00000bb4b2728882UL;
   tf->codes[15126] = 0x00000c248da48dcfUL;
   tf->codes[15127] = 0x00000f07662f5965UL;
   tf->codes[15128] = 0x0000109b5cd12663UL;
   tf->codes[15129] = 0x0000114293369feaUL;
   tf->codes[15130] = 0x000011efbc22af73UL;
   tf->codes[15131] = 0x00001268f83ca14dUL;
   tf->codes[15132] = 0x00001297dcc4400eUL;
   tf->codes[15133] = 0x00001421c2d10f30UL;
   tf->codes[15134] = 0x000015765cb19e05UL;
   tf->codes[15135] = 0x000017505248507dUL;
   tf->codes[15136] = 0x00001778949c47edUL;
   tf->codes[15137] = 0x0000188819c4085cUL;
   tf->codes[15138] = 0x00001889ee3c3684UL;
   tf->codes[15139] = 0x000019044f214537UL;
   tf->codes[15140] = 0x0000199dcc016492UL;
   tf->codes[15141] = 0x00001b3cf8034c45UL;
   tf->codes[15142] = 0x00001be37ebbb47dUL;
   tf->codes[15143] = 0x00001c24ea842693UL;
   tf->codes[15144] = 0x00001cad3f7d9537UL;
   tf->codes[15145] = 0x00001e6f6af9efa7UL;
   tf->codes[15146] = 0x00001f03a5008a4fUL;
   tf->codes[15147] = 0x00001f8f685b4f7eUL;
   tf->codes[15148] = 0x00001feda688988aUL;
   tf->codes[15149] = 0x000020833fe955d0UL;
   tf->codes[15150] = 0x0000211c47ab69a1UL;
   tf->codes[15151] = 0x000021524384bb3dUL;
   tf->codes[15152] = 0x000021899eb82f77UL;
   tf->codes[15153] = 0x000021b8833fce38UL;
   tf->codes[15154] = 0x000021f64617e3feUL;
   tf->codes[15155] = 0x000022cd10b20d95UL;
   tf->codes[15156] = 0x0000254292301355UL;
   tf->codes[15157] = 0x0000256d58a94a3cUL;
   tf->codes[15158] = 0x000028a5f8b58965UL;
   tf->codes[15159] = 0x00002a647b418785UL;
   tf->codes[15160] = 0x00002ab5750781efUL;
   tf->codes[15161] = 0x00002b701ce9e5dfUL;
   tf->codes[15162] = 0x00002de772e019c7UL;
   tf->codes[15163] = 0x00002f0cb31afe51UL;
   tf->codes[15164] = 0x00003042e0ad8dcdUL;
   tf->codes[15165] = 0x000032e0a47f8afdUL;
   tf->codes[15166] = 0x000032f8340add40UL;
   tf->codes[15167] = 0x0000333aff2d71f4UL;
   tf->codes[15168] = 0x000033dae3b232dbUL;
   tf->codes[15169] = 0x0000360a663b5321UL;
   tf->codes[15170] = 0x000036ccd51c7b3bUL;
   tf->codes[15171] = 0x00003703bb31e3ebUL;
   tf->codes[15172] = 0x000037fac6923b03UL;
   tf->codes[15173] = 0x000038d7be420061UL;
   tf->codes[15174] = 0x000038e243f509c7UL;
   tf->codes[15175] = 0x000038e7fbec9a04UL;
   tf->codes[15176] = 0x000039396ad09ff8UL;
   tf->codes[15177] = 0x00003a5b021b2832UL;
   tf->codes[15178] = 0x00003c1b93ae5a3fUL;
   tf->codes[15179] = 0x00003d81557599cbUL;
   tf->codes[15180] = 0x00003ddb75947afdUL;
   tf->codes[15181] = 0x00003e12d0c7ef37UL;
   tf->codes[15182] = 0x00003e8bd252db4cUL;
   tf->codes[15183] = 0x00003f6ce8110884UL;
   tf->codes[15184] = 0x000040307bbd4d77UL;
   tf->codes[15185] = 0x000040d47e507638UL;
   tf->codes[15186] = 0x00004133e148dc1dUL;
   tf->codes[15187] = 0x00004197d76db566UL;
   tf->codes[15188] = 0x00004198c1a9cc7aUL;
   tf->codes[15189] = 0x000041aca844c26dUL;
   tf->codes[15190] = 0x0000427210693588UL;
   tf->codes[15191] = 0x000042ab0585d225UL;
   tf->codes[15192] = 0x0000433b969c107dUL;
   tf->codes[15193] = 0x00004392bd77a6aeUL;
   tf->codes[15194] = 0x0000442e495ef9f6UL;
   tf->codes[15195] = 0x000044e8f1415de6UL;
   tf->codes[15196] = 0x0000453bfa0e8c3dUL;
   tf->codes[15197] = 0x0000458f3d6ac059UL;
   tf->codes[15198] = 0x000045dfc212af39UL;
   tf->codes[15199] = 0x00004727521af531UL;
   tf->codes[15200] = 0x0000482699981bfdUL;
   tf->codes[15201] = 0x000048699f49b676UL;
   tf->codes[15202] = 0x0000497b3378aad2UL;
   tf->codes[15203] = 0x00004b43517b9b44UL;
   tf->codes[15204] = 0x00004b57e7c3a286UL;
   tf->codes[15205] = 0x00004b773e4db8f3UL;
   tf->codes[15206] = 0x00004ba86c6b9166UL;
   tf->codes[15207] = 0x00004bec5c5942f3UL;
   tf->codes[15208] = 0x00004ccb9d9f4203UL;
   tf->codes[15209] = 0x00004d11620521b8UL;
   tf->codes[15210] = 0x00004d45c3f54af1UL;
   tf->codes[15211] = 0x00004d51e3917cbaUL;
   tf->codes[15212] = 0x00004feebd2762d6UL;
   tf->codes[15213] = 0x0000506a7d669427UL;
   tf->codes[15214] = 0x000051c9626b269dUL;
   tf->codes[15215] = 0x00005264041662d1UL;
   tf->codes[15216] = 0x000053ec503a0990UL;
   tf->codes[15217] = 0x000054a7a7c97ecfUL;
   tf->codes[15218] = 0x0000558514974fb7UL;
   tf->codes[15219] = 0x000055b08abd97edUL;
   tf->codes[15220] = 0x00005681284225bdUL;
   tf->codes[15221] = 0x0000568c98314637UL;
   tf->codes[15222] = 0x000056bacd0bd3a9UL;
   tf->codes[15223] = 0x00005789d0a73916UL;
   tf->codes[15224] = 0x000057f7624304b1UL;
   tf->codes[15225] = 0x000058ad76f8f53dUL;
   tf->codes[15226] = 0x00005984b6b12a5eUL;
   tf->codes[15227] = 0x000059e32f6d792fUL;
   tf->codes[15228] = 0x00005b350a99c2c8UL;
   tf->codes[15229] = 0x00005c0657cb61e7UL;
   tf->codes[15230] = 0x00005c44ca5088fcUL;
   tf->codes[15231] = 0x00005c8a8eb668b1UL;
   tf->codes[15232] = 0x00005c8d12dba828UL;
   tf->codes[15233] = 0x00005d69cffc67c1UL;
   tf->codes[15234] = 0x00005dd084d58646UL;
   tf->codes[15235] = 0x00005e7a79ef4509UL;
   tf->codes[15236] = 0x00005f5269548b79UL;
   tf->codes[15237] = 0x000060517642ac80UL;
   tf->codes[15238] = 0x000061e657209092UL;
   tf->codes[15239] = 0x00006286eb5262c8UL;
   tf->codes[15240] = 0x000062e31a7877e7UL;
   tf->codes[15241] = 0x000062f0996ecc4eUL;
   tf->codes[15242] = 0x000063fa669efc80UL;
   tf->codes[15243] = 0x000064d37acf5fc9UL;
   tf->codes[15244] = 0x0000661eee5707d6UL;
   tf->codes[15245] = 0x00006711668aeb8aUL;
   tf->codes[15246] = 0x0000672dfe60bcbbUL;
   tf->codes[15247] = 0x000068487e59921aUL;
   tf->codes[15248] = 0x0000698ee996bb39UL;
   tf->codes[15249] = 0x00006a762c6a8438UL;
   tf->codes[15250] = 0x00006ac676836d53UL;
   tf->codes[15251] = 0x00006bad7ec8308dUL;
   tf->codes[15252] = 0x00006c9c137cb22cUL;
   tf->codes[15253] = 0x00006d7b54c2b13cUL;
   tf->codes[15254] = 0x00006dd95860f483UL;
   tf->codes[15255] = 0x00006e6347438b8aUL;
   tf->codes[15256] = 0x00006f33aa391395UL;
   tf->codes[15257] = 0x00006f5ac7c1ee2cUL;
   tf->codes[15258] = 0x00006fa3bffa1ea7UL;
   tf->codes[15259] = 0x000070c67c0fc3baUL;
   tf->codes[15260] = 0x0000734aa14f3abaUL;
   tf->codes[15261] = 0x00007431e42303b9UL;
   tf->codes[15262] = 0x00007585593875b5UL;
   tf->codes[15263] = 0x00007652fd79b884UL;
   tf->codes[15264] = 0x0000778c244f9301UL;
   tf->codes[15265] = 0x0000797fb878cba9UL;
   tf->codes[15266] = 0x00007cdaa8526c40UL;
   tf->codes[15267] = 0x00007de3c5d58b23UL;
   tf->codes[15268] = 0x00007f15603ba73bUL;
   tf->codes[15269] = 0x00007f4a3749dbfeUL;
   tf->codes[15270] = 0x00007fb6a41a8ac0UL;
   tf->codes[15271] = 0x00007fed1511e7e6UL;
   tf->codes[15272] = 0x000082f5e65a713aUL;
   tf->codes[15273] = 0x000084448db46a0dUL;
   tf->codes[15274] = 0x0000847964c29ed0UL;
   tf->codes[15275] = 0x000084f3c5a7ad83UL;
   tf->codes[15276] = 0x00008548dd7c0fc7UL;
   tf->codes[15277] = 0x00008550df09d9b6UL;
   tf->codes[15278] = 0x000085a790c7645dUL;
   tf->codes[15279] = 0x000085df6118e421UL;
   tf->codes[15280] = 0x00008692076d7e22UL;
   tf->codes[15281] = 0x000087ac124847f7UL;
   tf->codes[15282] = 0x000087b11a92c6e5UL;
   tf->codes[15283] = 0x0000883c68cf808aUL;
   tf->codes[15284] = 0x00008b05dd56cbb5UL;
   tf->codes[15285] = 0x00008b72f9d48bc6UL;
   tf->codes[15286] = 0x00008bbd5166dedfUL;
   tf->codes[15287] = 0x00008c88ac11e7fcUL;
   tf->codes[15288] = 0x00008d6f3f389facUL;
   tf->codes[15289] = 0x00008e840739e4ceUL;
   tf->codes[15290] = 0x0000900785a21264UL;
   tf->codes[15291] = 0x000090095a1a408cUL;
   tf->codes[15292] = 0x000090d2e04d1b81UL;
   tf->codes[15293] = 0x0000916b72f123c8UL;
   tf->codes[15294] = 0x000091fbc9785c5bUL;
   tf->codes[15295] = 0x0000920b9204ea74UL;
   tf->codes[15296] = 0x000093c84018ba6cUL;
   tf->codes[15297] = 0x00009434e7786ef3UL;
   tf->codes[15298] = 0x000094505a83234bUL;
   tf->codes[15299] = 0x000094e2c0118fcbUL;
   tf->codes[15300] = 0x000094ffcd056c86UL;
   tf->codes[15301] = 0x000095d53845737fUL;
   tf->codes[15302] = 0x000097a7dbfb6d57UL;
   tf->codes[15303] = 0x0000993d31f75cf3UL;
   tf->codes[15304] = 0x0000998edb6a68acUL;
   tf->codes[15305] = 0x00009a15215ca363UL;
   tf->codes[15306] = 0x00009c3a1e32ba43UL;
   tf->codes[15307] = 0x00009cc2adbb2eacUL;
   tf->codes[15308] = 0x00009f703a19b9f5UL;
   tf->codes[15309] = 0x0000a43c9638c057UL;
   tf->codes[15310] = 0x0000a4f778aa2a0cUL;
   tf->codes[15311] = 0x0000a54788340d62UL;
   tf->codes[15312] = 0x0000a570b4c41be6UL;
   tf->codes[15313] = 0x0000a5828c57ddecUL;
   tf->codes[15314] = 0x0000a6f7dc1ca5ccUL;
   tf->codes[15315] = 0x0000a71b50b52413UL;
   tf->codes[15316] = 0x0000a7da8bc3fb67UL;
   tf->codes[15317] = 0x0000a930fa1cb864UL;
   tf->codes[15318] = 0x0000a9593c70afd4UL;
   tf->codes[15319] = 0x0000a9b7057fed56UL;
   tf->codes[15320] = 0x0000a9c39a3a2aa9UL;
   tf->codes[15321] = 0x0000ab54227aa11cUL;
   tf->codes[15322] = 0x0000ac20dc7fccd7UL;
   tf->codes[15323] = 0x0000ac2b27a3d078UL;
   tf->codes[15324] = 0x0000ac4242111731UL;
   tf->codes[15325] = 0x0000ad414eff3838UL;
   tf->codes[15326] = 0x0000ad8a473768b3UL;
   tf->codes[15327] = 0x0000aef720505b1aUL;
   tf->codes[15328] = 0x0000af45d0801bd2UL;
   tf->codes[15329] = 0x0000afb9c9c088f9UL;
   tf->codes[15330] = 0x0000afd27e16f815UL;
   tf->codes[15331] = 0x0000b0c23796968dUL;
   tf->codes[15332] = 0x0000b2332ebdf0ceUL;
   tf->codes[15333] = 0x0000b30e51f58804UL;
   tf->codes[15334] = 0x0000b407e17b1e93UL;
   tf->codes[15335] = 0x0000b4540d859fd4UL;
   tf->codes[15336] = 0x0000b4b669c150baUL;
   tf->codes[15337] = 0x0000b59b286fda42UL;
   tf->codes[15338] = 0x0000b5c579cb059fUL;
   tf->codes[15339] = 0x0000b6e53c9d5fb1UL;
   tf->codes[15340] = 0x0000b78ad919b0d5UL;
   tf->codes[15341] = 0x0000b79bc6715bc7UL;
   tf->codes[15342] = 0x0000b7d028618500UL;
   tf->codes[15343] = 0x0000b90655f4147cUL;
   tf->codes[15344] = 0x0000b94f139d3f32UL;
   tf->codes[15345] = 0x0000ba0fe8953ee9UL;
   tf->codes[15346] = 0x0000ba5cfedbd73eUL;
   tf->codes[15347] = 0x0000ba8f51c4cc8aUL;
   tf->codes[15348] = 0x0000bb718c4e169bUL;
   tf->codes[15349] = 0x0000bb723bfb27eaUL;
   tf->codes[15350] = 0x0000bcf03cfacb08UL;
   tf->codes[15351] = 0x0000be0714034417UL;
   tf->codes[15352] = 0x0000be271a3a6bd3UL;
   tf->codes[15353] = 0x0000be8e443195e2UL;
   tf->codes[15354] = 0x0000bec8d3375ae2UL;
   tf->codes[15355] = 0x0000bf04c1974280UL;
   tf->codes[15356] = 0x0000bf5371c70338UL;
   tf->codes[15357] = 0x0000bfb6b83ecb32UL;
   tf->codes[15358] = 0x0000bfd01c424b9dUL;
   tf->codes[15359] = 0x0000c131104e1200UL;
   tf->codes[15360] = 0x0000c1a285693fb0UL;
   tf->codes[15361] = 0x0000c1b50caa1305UL;
   tf->codes[15362] = 0x0000c1ba4f8397b8UL;
   tf->codes[15363] = 0x0000c283d5b672adUL;
   tf->codes[15364] = 0x0000c48b8b09a70dUL;
   tf->codes[15365] = 0x0000c567987d5557UL;
   tf->codes[15366] = 0x0000c61cfd863494UL;
   tf->codes[15367] = 0x0000c63034741938UL;
   tf->codes[15368] = 0x0000c6c6f29ff357UL;
   tf->codes[15369] = 0x0000c918ff857ad0UL;
   tf->codes[15370] = 0x0000ca467bdd2f0eUL;
   tf->codes[15371] = 0x0000ca66f7326254UL;
   tf->codes[15372] = 0x0000ca9aa9757a3eUL;
   tf->codes[15373] = 0x0000cb97a75c6758UL;
   tf->codes[15374] = 0x0000cba7aa77fb36UL;
   tf->codes[15375] = 0x0000cc78828b8ecbUL;
   tf->codes[15376] = 0x0000cd1916bd6101UL;
   tf->codes[15377] = 0x0000ce53625e5857UL;
   tf->codes[15378] = 0x0000cebd4b09c7a2UL;
   tf->codes[15379] = 0x0000d0b8e0c0ca39UL;
   tf->codes[15380] = 0x0000d19b1b4a144aUL;
   tf->codes[15381] = 0x0000d27b815b3033UL;
   tf->codes[15382] = 0x0000d4e7dc804f2bUL;
   tf->codes[15383] = 0x0000d5786d968d83UL;
   tf->codes[15384] = 0x0000dad3c0e2a9daUL;
   tf->codes[15385] = 0x0000dad6f4b4faa0UL;
   tf->codes[15386] = 0x0000de2c2c970afaUL;
   tf->codes[15387] = 0x0000dfec0e7d2bb8UL;
   tf->codes[15388] = 0x0000e3648068b494UL;
   tf->codes[15389] = 0x0000e388df3d49efUL;
   tf->codes[15390] = 0x0000e53fd55989aaUL;
   tf->codes[15391] = 0x0000e5dc4b7cf406UL;
   tf->codes[15392] = 0x0000e651dea68990UL;
   tf->codes[15393] = 0x0000e68ce2ca5a1aUL;
   tf->codes[15394] = 0x0000e6b55fad574fUL;
   tf->codes[15395] = 0x0000e7603f032d26UL;
   tf->codes[15396] = 0x0000e81235aab5d8UL;
   tf->codes[15397] = 0x0000e95ecdfd7abeUL;
   tf->codes[15398] = 0x0000e9915b7575cfUL;
   tf->codes[15399] = 0x0000ec9892d4d6c0UL;
   tf->codes[15400] = 0x0000ed06d41db3aaUL;
   tf->codes[15401] = 0x0000edc091c40086UL;
   tf->codes[15402] = 0x0000effef29d97d1UL;
   tf->codes[15403] = 0x0000f17ec8156917UL;
   tf->codes[15404] = 0x0000f379ae1f5a5fUL;
   tf->codes[15405] = 0x0000f4e4783118d9UL;
   tf->codes[15406] = 0x0000f5acd998d6f5UL;
   tf->codes[15407] = 0x0000f6641319e45aUL;
   tf->codes[15408] = 0x0000f748221b5c93UL;
   tf->codes[15409] = 0x0000f8e838595b5aUL;
   tf->codes[15410] = 0x0000f8e997b37df8UL;
   tf->codes[15411] = 0x0000f96ca9d367e9UL;
   tf->codes[15412] = 0x0000f9d61d60cbaaUL;
   tf->codes[15413] = 0x0000fa68f80d43b4UL;
   tf->codes[15414] = 0x0000fab106095d1bUL;
   tf->codes[15415] = 0x0000fc2063478ef9UL;
   tf->codes[15416] = 0x0000fd0fa7a921e7UL;
   tf->codes[15417] = 0x0000fd4b20eafdfbUL;
   tf->codes[15418] = 0x0000fdd71ed4c8efUL;
   tf->codes[15419] = 0x0000ff33f4d22778UL;
   tf->codes[15420] = 0x0000ffdf83d50e9eUL;
   tf->codes[15421] = 0x00000016df0882d8UL;
   tf->codes[15422] = 0x0000007d59529b98UL;
   tf->codes[15423] = 0x000003f72a984712UL;
   tf->codes[15424] = 0x0000051d550f42b0UL;
   tf->codes[15425] = 0x00000616e494d93fUL;
   tf->codes[15426] = 0x0000082db2c78a69UL;
   tf->codes[15427] = 0x0000088b06b8bc61UL;
   tf->codes[15428] = 0x00000909faca3e78UL;
   tf->codes[15429] = 0x00000993748ec9f5UL;
   tf->codes[15430] = 0x00000f391f6d3965UL;
   tf->codes[15431] = 0x00000f42f573317cUL;
   tf->codes[15432] = 0x00000f7632983ddcUL;
   tf->codes[15433] = 0x00000f87950df458UL;
   tf->codes[15434] = 0x000010c5899f47feUL;
   tf->codes[15435] = 0x000011fca16dee8eUL;
   tf->codes[15436] = 0x000012130c2e23f8UL;
   tf->codes[15437] = 0x00001316372aacd9UL;
   tf->codes[15438] = 0x000013c7090718b2UL;
   tf->codes[15439] = 0x000013ec8ca6cae6UL;
   tf->codes[15440] = 0x0000147222ebf44eUL;
   tf->codes[15441] = 0x00001653a4f2652bUL;
   tf->codes[15442] = 0x0000166f8d1b250dUL;
   tf->codes[15443] = 0x00001a79053af7cbUL;
   tf->codes[15444] = 0x00001b825d4d1c73UL;
   tf->codes[15445] = 0x00001bbaa2bca7c1UL;
   tf->codes[15446] = 0x00001bbb8cf8bed5UL;
   tf->codes[15447] = 0x00001d8126d66fd0UL;
   tf->codes[15448] = 0x00001dbb40be2946UL;
   tf->codes[15449] = 0x00001e1aa3b68f2bUL;
   tf->codes[15450] = 0x00001f3264fb1f4eUL;
   tf->codes[15451] = 0x00001f877ccf8192UL;
   tf->codes[15452] = 0x00001fa9577ed776UL;
   tf->codes[15453] = 0x0000218d231b8205UL;
   tf->codes[15454] = 0x000021ec10f5dc60UL;
   tf->codes[15455] = 0x000022d6c22afbeaUL;
   tf->codes[15456] = 0x000024c7d22ef51bUL;
   tf->codes[15457] = 0x000025cb72498986UL;
   tf->codes[15458] = 0x00002698dbfbc690UL;
   tf->codes[15459] = 0x000028107556c822UL;
   tf->codes[15460] = 0x000028e989872b6bUL;
   tf->codes[15461] = 0x0000297b79f78c61UL;
   tf->codes[15462] = 0x00003157beb0cef2UL;
   tf->codes[15463] = 0x000032b24b17f3c9UL;
   tf->codes[15464] = 0x000032fcdd394ca7UL;
   tf->codes[15465] = 0x00003563f584e6ecUL;
   tf->codes[15466] = 0x0000359907222174UL;
   tf->codes[15467] = 0x000037073f953679UL;
   tf->codes[15468] = 0x0000376a10eef2e9UL;
   tf->codes[15469] = 0x000037b552bd5d16UL;
   tf->codes[15470] = 0x00003a57349dc220UL;
   tf->codes[15471] = 0x00003b3048ce2569UL;
   tf->codes[15472] = 0x00003b4c30f6e54bUL;
   tf->codes[15473] = 0x00003de1438e073dUL;
   tf->codes[15474] = 0x00003e2cfa7a7cf4UL;
   tf->codes[15475] = 0x00004071c2f8b5cbUL;
   tf->codes[15476] = 0x000043466ce01babUL;
   tf->codes[15477] = 0x0000453cbfbd998fUL;
   tf->codes[15478] = 0x000045a1658f8427UL;
   tf->codes[15479] = 0x0000463cf176d76fUL;
   tf->codes[15480] = 0x000047d0ad899ea8UL;
   tf->codes[15481] = 0x000047d5f063235bUL;
   tf->codes[15482] = 0x000047e3e477834cUL;
   tf->codes[15483] = 0x00004915f3fbaaeeUL;
   tf->codes[15484] = 0x00004981b11f4861UL;
   tf->codes[15485] = 0x00004ad909b41c72UL;
   tf->codes[15486] = 0x00004b1532a309d5UL;
   tf->codes[15487] = 0x00004bf10587b25aUL;
   tf->codes[15488] = 0x00004d3cee2d65f1UL;
   tf->codes[15489] = 0x00004d9539d418fbUL;
   tf->codes[15490] = 0x00004d96992e3b99UL;
   tf->codes[15491] = 0x00004dd8ef32c4c3UL;
   tf->codes[15492] = 0x00004e18868308b1UL;
   tf->codes[15493] = 0x00004ef5f350d999UL;
   tf->codes[15494] = 0x00004f66b8bef5faUL;
   tf->codes[15495] = 0x00004f817c1c9903UL;
   tf->codes[15496] = 0x00004fb6532acdc6UL;
   tf->codes[15497] = 0x000050c89706d371UL;
   tf->codes[15498] = 0x000050e270285f66UL;
   tf->codes[15499] = 0x000051419891bf86UL;
   tf->codes[15500] = 0x000051478b185588UL;
   tf->codes[15501] = 0x000051771f4d0598UL;
   tf->codes[15502] = 0x0000524413e13718UL;
   tf->codes[15503] = 0x000052683826c6aeUL;
   tf->codes[15504] = 0x000052c307f2b92fUL;
   tf->codes[15505] = 0x000052ce02c3ce1fUL;
   tf->codes[15506] = 0x0000539121520788UL;
   tf->codes[15507] = 0x0000539b31e70564UL;
   tf->codes[15508] = 0x000053e798808c6aUL;
   tf->codes[15509] = 0x00005431b583d9beUL;
   tf->codes[15510] = 0x0000543fe4273f74UL;
   tf->codes[15511] = 0x0000554558ba0207UL;
   tf->codes[15512] = 0x00005592e41ea5e6UL;
   tf->codes[15513] = 0x0000579a5ee2d481UL;
   tf->codes[15514] = 0x0000585a842dc2e9UL;
   tf->codes[15515] = 0x000058ec3a0f1e1aUL;
   tf->codes[15516] = 0x000059b5fad0fed4UL;
   tf->codes[15517] = 0x00005b95a85f4189UL;
   tf->codes[15518] = 0x00005bdabd180fefUL;
   tf->codes[15519] = 0x00005c18ba7f2b7aUL;
   tf->codes[15520] = 0x00005c64e689acbbUL;
   tf->codes[15521] = 0x00005d1f53dd0ae6UL;
   tf->codes[15522] = 0x00005e77218fea81UL;
   tf->codes[15523] = 0x00005edc770ee668UL;
   tf->codes[15524] = 0x00005fc135bd6ff0UL;
   tf->codes[15525] = 0x0000629ae7ef54beUL;
   tf->codes[15526] = 0x0000649bfb0ee1cdUL;
   tf->codes[15527] = 0x0000669be9635203UL;
   tf->codes[15528] = 0x000066d5190ef465UL;
   tf->codes[15529] = 0x000067fd8d1c29b5UL;
   tf->codes[15530] = 0x000069f53f53ca37UL;
   tf->codes[15531] = 0x00006af44c41eb3eUL;
   tf->codes[15532] = 0x00006b749fad8ff3UL;
   tf->codes[15533] = 0x00006c3d3ba453d4UL;
   tf->codes[15534] = 0x00006dc7d15e3445UL;
   tf->codes[15535] = 0x00006dd2cc2f4935UL;
   tf->codes[15536] = 0x00006ef0456b6995UL;
   tf->codes[15537] = 0x0000707e0ef79accUL;
   tf->codes[15538] = 0x000070fab972e331UL;
   tf->codes[15539] = 0x000071136dc9524dUL;
   tf->codes[15540] = 0x000072d81d6aec34UL;
   tf->codes[15541] = 0x0000731fb648fa11UL;
   tf->codes[15542] = 0x00007392502f449aUL;
   tf->codes[15543] = 0x0000750c6daf85a3UL;
   tf->codes[15544] = 0x0000768650a0c0e7UL;
   tf->codes[15545] = 0x000077e11796eb83UL;
   tf->codes[15546] = 0x00007834206419daUL;
   tf->codes[15547] = 0x000079bbf769b50fUL;
   tf->codes[15548] = 0x000079f43cd9405dUL;
   tf->codes[15549] = 0x00007a052a30eb4fUL;
   tf->codes[15550] = 0x00007a5414efb1ccUL;
   tf->codes[15551] = 0x00007a8d0a0c4e69UL;
   tf->codes[15552] = 0x00007b5d6d01d674UL;
   tf->codes[15553] = 0x00007b798fb99c1bUL;
   tf->codes[15554] = 0x00007bb19a9a21a4UL;
   tf->codes[15555] = 0x00007c4d61107ab1UL;
   tf->codes[15556] = 0x00007d513bba14e1UL;
   tf->codes[15557] = 0x00007d622911bfd3UL;
   tf->codes[15558] = 0x00007e141fb94885UL;
   tf->codes[15559] = 0x00007e19d7b0d8c2UL;
   tf->codes[15560] = 0x000080a1e06fb1d7UL;
   tf->codes[15561] = 0x000080d851670efdUL;
   tf->codes[15562] = 0x000081414fd66734UL;
   tf->codes[15563] = 0x0000823b547a094dUL;
   tf->codes[15564] = 0x000082869648737aUL;
   tf->codes[15565] = 0x00008392727fd799UL;
   tf->codes[15566] = 0x0000844cdfd335c4UL;
   tf->codes[15567] = 0x000084a4b65bdd44UL;
   tf->codes[15568] = 0x000084b4b9777122UL;
   tf->codes[15569] = 0x000084d4bfae98deUL;
   tf->codes[15570] = 0x000084e0a4bbc4e2UL;
   tf->codes[15571] = 0x0000853497c50a4dUL;
   tf->codes[15572] = 0x00008563f16ab498UL;
   tf->codes[15573] = 0x00008599ed440634UL;
   tf->codes[15574] = 0x000086758599a8f4UL;
   tf->codes[15575] = 0x000086d13fa1b289UL;
   tf->codes[15576] = 0x000086f26aa3f71eUL;
   tf->codes[15577] = 0x000087302d7c0ce4UL;
   tf->codes[15578] = 0x000088e255dcd376UL;
   tf->codes[15579] = 0x00008b2a179e574eUL;
   tf->codes[15580] = 0x00008ba319294363UL;
   tf->codes[15581] = 0x00008bce8f4f8b99UL;
   tf->codes[15582] = 0x00008be6ce87ef2bUL;
   tf->codes[15583] = 0x00008c70484c7aa8UL;
   tf->codes[15584] = 0x00008d0d338df08eUL;
   tf->codes[15585] = 0x00008e29fd1cff9fUL;
   tf->codes[15586] = 0x00008ef9b065765bUL;
   tf->codes[15587] = 0x00008f259ba9ca1bUL;
   tf->codes[15588] = 0x00008f4407f7c974UL;
   tf->codes[15589] = 0x000090a202c044d6UL;
   tf->codes[15590] = 0x000090a82fd5e09dUL;
   tf->codes[15591] = 0x000090c8360d0859UL;
   tf->codes[15592] = 0x000091384bce136bUL;
   tf->codes[15593] = 0x0000915bfaf59777UL;
   tf->codes[15594] = 0x000091e1913ac0dfUL;
   tf->codes[15595] = 0x0000924d13cf588dUL;
   tf->codes[15596] = 0x0000926811bc015bUL;
   tf->codes[15597] = 0x000092a59a05115cUL;
   tf->codes[15598] = 0x0000943f0e0f68d2UL;
   tf->codes[15599] = 0x0000944f4bba0275UL;
   tf->codes[15600] = 0x0000961f30bbb711UL;
   tf->codes[15601] = 0x0000980545ee9b52UL;
   tf->codes[15602] = 0x000098150e7b296bUL;
   tf->codes[15603] = 0x00009877dfd4e5dbUL;
   tf->codes[15604] = 0x000098881d7f7f7eUL;
   tf->codes[15605] = 0x00009891f3857795UL;
   tf->codes[15606] = 0x00009953b2b98e60UL;
   tf->codes[15607] = 0x000099d85ec2a0b4UL;
   tf->codes[15608] = 0x00009ae4b018105dUL;
   tf->codes[15609] = 0x00009d431728cf64UL;
   tf->codes[15610] = 0x00009e21a8c1bd25UL;
   tf->codes[15611] = 0x00009e52d6df9598UL;
   tf->codes[15612] = 0x00009ed9cc7ee19eUL;
   tf->codes[15613] = 0x00009edcc5c22c9fUL;
   tf->codes[15614] = 0x00009f5f62c40b06UL;
   tf->codes[15615] = 0x0000a0c599a9561cUL;
   tf->codes[15616] = 0x0000a1833acf050dUL;
   tf->codes[15617] = 0x0000a246595d3e76UL;
   tf->codes[15618] = 0x0000a3a921e13301UL;
   tf->codes[15619] = 0x0000a48aacbd6bc3UL;
   tf->codes[15620] = 0x0000a4b70d1fcb0dUL;
   tf->codes[15621] = 0x0000a57d5f80553cUL;
   tf->codes[15622] = 0x0000a5859b9d24f0UL;
   tf->codes[15623] = 0x0000a6312aa00c16UL;
   tf->codes[15624] = 0x0000a6badef39d58UL;
   tf->codes[15625] = 0x0000a77f224cf39aUL;
   tf->codes[15626] = 0x0000aac924cee93fUL;
   tf->codes[15627] = 0x0000ab5caf287298UL;
   tf->codes[15628] = 0x0000accc8184b000UL;
   tf->codes[15629] = 0x0000ad528ce7e4f2UL;
   tf->codes[15630] = 0x0000aeffe78d325bUL;
   tf->codes[15631] = 0x0000af69d038a1a6UL;
   tf->codes[15632] = 0x0000b19c4c050cedUL;
   tf->codes[15633] = 0x0000b3437994be8fUL;
   tf->codes[15634] = 0x0000b4f8261ac498UL;
   tf->codes[15635] = 0x0000b5406ea5e3c4UL;
   tf->codes[15636] = 0x0000b56a1053fdd2UL;
   tf->codes[15637] = 0x0000b5aa5751530fUL;
   tf->codes[15638] = 0x0000b5ca98178090UL;
   tf->codes[15639] = 0x0000b63b9814a2b6UL;
   tf->codes[15640] = 0x0000b7689f4e4b6aUL;
   tf->codes[15641] = 0x0000b844acc1f9b4UL;
   tf->codes[15642] = 0x0000b87e8c1aad65UL;
   tf->codes[15643] = 0x0000ba04198a0ee8UL;
   tf->codes[15644] = 0x0000bc07eb5de133UL;
   tf->codes[15645] = 0x0000bcf311b10c47UL;
   tf->codes[15646] = 0x0000bd77489c1311UL;
   tf->codes[15647] = 0x0000bdc583adc83fUL;
   tf->codes[15648] = 0x0000be226280eeadUL;
   tf->codes[15649] = 0x0000c2357617b3bdUL;
   tf->codes[15650] = 0x0000c4819076a534UL;
   tf->codes[15651] = 0x0000c4cf1bdb4913UL;
   tf->codes[15652] = 0x0000c4f21b55bbd0UL;
   tf->codes[15653] = 0x0000c506ec2cc8d7UL;
   tf->codes[15654] = 0x0000c547a848299eUL;
   tf->codes[15655] = 0x0000c91cbe77d323UL;
   tf->codes[15656] = 0x0000c9c679028c21UL;
   tf->codes[15657] = 0x0000ca2c7e2e9957UL;
   tf->codes[15658] = 0x0000cf90f7d39c76UL;
   tf->codes[15659] = 0x0000d091298cda56UL;
   tf->codes[15660] = 0x0000d0be399c4aefUL;
   tf->codes[15661] = 0x0000d10fa88050e3UL;
   tf->codes[15662] = 0x0000d2c83885b901UL;
   tf->codes[15663] = 0x0000d32e3db1c637UL;
   tf->codes[15664] = 0x0000d400751f7c6aUL;
   tf->codes[15665] = 0x0000d49a2c8ea18aUL;
   tf->codes[15666] = 0x0000d4a9f51b2fa3UL;
   tf->codes[15667] = 0x0000d4f7bb0ed947UL;
   tf->codes[15668] = 0x0000d55f94b314a5UL;
   tf->codes[15669] = 0x0000d63bdcb5c8b4UL;
   tf->codes[15670] = 0x0000da94ef41733eUL;
   tf->codes[15671] = 0x0000dbd4089de3bdUL;
   tf->codes[15672] = 0x0000de57b8bf4f33UL;
   tf->codes[15673] = 0x0000e0bde6ced264UL;
   tf->codes[15674] = 0x0000e1855dfa796cUL;
   tf->codes[15675] = 0x0000e2808769385eUL;
   tf->codes[15676] = 0x0000e40fb04f8c33UL;
   tf->codes[15677] = 0x0000e5e00a6f4c59UL;
   tf->codes[15678] = 0x0000e671c050a78aUL;
   tf->codes[15679] = 0x0000e6744475e701UL;
   tf->codes[15680] = 0x0000e7555a341439UL;
   tf->codes[15681] = 0x0000e87e08d04f4eUL;
   tf->codes[15682] = 0x0000e99296428eabUL;
   tf->codes[15683] = 0x0000eaa798d2d992UL;
   tf->codes[15684] = 0x0000ec531efff8d3UL;
   tf->codes[15685] = 0x0000ef8ad4d020e8UL;
   tf->codes[15686] = 0x0000effa3ae41aabUL;
   tf->codes[15687] = 0x0000f0583e825df2UL;
   tf->codes[15688] = 0x0000f15710e17934UL;
   tf->codes[15689] = 0x0000f1ef2e6775f1UL;
   tf->codes[15690] = 0x0000f25f09997b3eUL;
   tf->codes[15691] = 0x0000f28452aa27adUL;
   tf->codes[15692] = 0x0000f313bef5492cUL;
   tf->codes[15693] = 0x0000f321787aa358UL;
   tf->codes[15694] = 0x0000f4fc92dc72a9UL;
   tf->codes[15695] = 0x0000f5b4417b8b98UL;
   tf->codes[15696] = 0x0000f689722c8cccUL;
   tf->codes[15697] = 0x0000f8043f59df24UL;
   tf->codes[15698] = 0x0000f855391fd98eUL;
   tf->codes[15699] = 0x0000f94c7f0f366bUL;
   tf->codes[15700] = 0x0000f9ab325a8b01UL;
   tf->codes[15701] = 0x0000fa79112ad395UL;
   tf->codes[15702] = 0x0000fbbf41d8f6efUL;
   tf->codes[15703] = 0x0000fd0622342b98UL;
   tf->codes[15704] = 0x0000fd1784a9e214UL;
   tf->codes[15705] = 0x0000fd53ad98cf77UL;
   tf->codes[15706] = 0x0000fe135dc5b255UL;
   tf->codes[15707] = 0x0000feec37670fd9UL;
   tf->codes[15708] = 0x0000ff54110b4b37UL;
   tf->codes[15709] = 0x0000ffb3e921bca6UL;
   tf->codes[15710] = 0x0000ffcf96bb76c3UL;
   tf->codes[15711] = 0x000000176a288a65UL;
   tf->codes[15712] = 0x0000022b0488eac9UL;
   tf->codes[15713] = 0x000003f063d795ffUL;
   tf->codes[15714] = 0x0000040cc11e616bUL;
   tf->codes[15715] = 0x0000048c9f6bfa96UL;
   tf->codes[15716] = 0x00000506c5c20384UL;
   tf->codes[15717] = 0x000005bd4f95ff9aUL;
   tf->codes[15718] = 0x000005e298a6ac09UL;
   tf->codes[15719] = 0x000006a20e448922UL;
   tf->codes[15720] = 0x000006a7168f0810UL;
   tf->codes[15721] = 0x000006dd126859acUL;
   tf->codes[15722] = 0x000006e13076c186UL;
   tf->codes[15723] = 0x0000078448cdd333UL;
   tf->codes[15724] = 0x000008acf76a0e48UL;
   tf->codes[15725] = 0x000008dfbf710f1eUL;
   tf->codes[15726] = 0x000008ee9dc18623UL;
   tf->codes[15727] = 0x0000091f1c324d47UL;
   tf->codes[15728] = 0x000009bcf1afda41UL;
   tf->codes[15729] = 0x00000b975c649843UL;
   tf->codes[15730] = 0x00000bd34ac47fe1UL;
   tf->codes[15731] = 0x00000c68a9963762UL;
   tf->codes[15732] = 0x00000cc638166f1fUL;
   tf->codes[15733] = 0x000011d6f9413298UL;
   tf->codes[15734] = 0x00001300578a7efcUL;
   tf->codes[15735] = 0x000013389cfa0a4aUL;
   tf->codes[15736] = 0x0000140815b37b41UL;
   tf->codes[15737] = 0x0000142ce9a61c26UL;
   tf->codes[15738] = 0x0000151725bd3026UL;
   tf->codes[15739] = 0x000017c85b0c17bfUL;
   tf->codes[15740] = 0x000017e701e91cddUL;
   tf->codes[15741] = 0x000018e1411bc4bbUL;
   tf->codes[15742] = 0x000018fe4e0fa176UL;
   tf->codes[15743] = 0x00001b0971c42c61UL;
   tf->codes[15744] = 0x00001b0b80cb604eUL;
   tf->codes[15745] = 0x00001b57acd5e18fUL;
   tf->codes[15746] = 0x00001c2eb1ff10ebUL;
   tf->codes[15747] = 0x00001fb9e5ba72e1UL;
   tf->codes[15748] = 0x00001fc973b7fb35UL;
   tf->codes[15749] = 0x0000231c6203d1ddUL;
   tf->codes[15750] = 0x0000236d5bc9cc47UL;
   tf->codes[15751] = 0x000026a28d74b4e5UL;
   tf->codes[15752] = 0x00002785028d04bbUL;
   tf->codes[15753] = 0x0000289f0d67ce90UL;
   tf->codes[15754] = 0x00002a3d149e996aUL;
   tf->codes[15755] = 0x00002d06c3b4ea5aUL;
   tf->codes[15756] = 0x00002df0158fe746UL;
   tf->codes[15757] = 0x000030b8da6a2122UL;
   tf->codes[15758] = 0x000030f7877e4dfcUL;
   tf->codes[15759] = 0x0000311a86f8c0b9UL;
   tf->codes[15760] = 0x00003241d63ad930UL;
   tf->codes[15761] = 0x000033912d41e352UL;
   tf->codes[15762] = 0x00003398b9b1a1b7UL;
   tf->codes[15763] = 0x00003427764fb1e7UL;
   tf->codes[15764] = 0x0000349cceea41acUL;
   tf->codes[15765] = 0x0000354ae2126849UL;
   tf->codes[15766] = 0x000035ebb0d34044UL;
   tf->codes[15767] = 0x00003677aebd0b38UL;
   tf->codes[15768] = 0x000036c1cbc0588cUL;
   tf->codes[15769] = 0x0000371bb15033f9UL;
   tf->codes[15770] = 0x000037e4c2650364UL;
   tf->codes[15771] = 0x00003817ff8a0fc4UL;
   tf->codes[15772] = 0x000038e73db47af6UL;
   tf->codes[15773] = 0x00003a052c0ea6e0UL;
   tf->codes[15774] = 0x00003c7a386ea116UL;
   tf->codes[15775] = 0x00003d0586ab5abbUL;
   tf->codes[15776] = 0x00003e34d77b3d21UL;
   tf->codes[15777] = 0x00003e65907b0a0aUL;
   tf->codes[15778] = 0x00003eac79ac0698UL;
   tf->codes[15779] = 0x00003f00a74451c8UL;
   tf->codes[15780] = 0x00003fe7ea181ac7UL;
   tf->codes[15781] = 0x000040e1047fa5ccUL;
   tf->codes[15782] = 0x000041841cd6b779UL;
   tf->codes[15783] = 0x000041fb49e97566UL;
   tf->codes[15784] = 0x00004283d971e9cfUL;
   tf->codes[15785] = 0x000042e0f2d41602UL;
   tf->codes[15786] = 0x000043193843a150UL;
   tf->codes[15787] = 0x000043355afb66f7UL;
   tf->codes[15788] = 0x000043fee12e41ecUL;
   tf->codes[15789] = 0x0000441c9dcf2ff6UL;
   tf->codes[15790] = 0x00004433b83c76afUL;
   tf->codes[15791] = 0x000044a7ec0be99bUL;
   tf->codes[15792] = 0x0000464d45236d15UL;
   tf->codes[15793] = 0x000048ac5be13d6bUL;
   tf->codes[15794] = 0x000048e30767a056UL;
   tf->codes[15795] = 0x00004928913e7a46UL;
   tf->codes[15796] = 0x00004a2e7aef4863UL;
   tf->codes[15797] = 0x00004af9607c45f6UL;
   tf->codes[15798] = 0x00004b8683312dc3UL;
   tf->codes[15799] = 0x00004b97ab17de7aUL;
   tf->codes[15800] = 0x00004c1b6ce4d9baUL;
   tf->codes[15801] = 0x00004ce2a9817afdUL;
   tf->codes[15802] = 0x00004d9a92af99b1UL;
   tf->codes[15803] = 0x00004e778a5f5f0fUL;
   tf->codes[15804] = 0x00004eb9e063e839UL;
   tf->codes[15805] = 0x00004fc5bc9b4c58UL;
   tf->codes[15806] = 0x000050c15b2816d4UL;
   tf->codes[15807] = 0x00005274e2e30004UL;
   tf->codes[15808] = 0x000052c2a8d6a9a8UL;
   tf->codes[15809] = 0x000054e6f5ffaf39UL;
   tf->codes[15810] = 0x00005509f57a21f6UL;
   tf->codes[15811] = 0x0000557cc9ef7244UL;
   tf->codes[15812] = 0x00005597c7dc1b12UL;
   tf->codes[15813] = 0x0000583e0259edbbUL;
   tf->codes[15814] = 0x0000592669f8d393UL;
   tf->codes[15815] = 0x00005ae2dd7d9dc6UL;
   tf->codes[15816] = 0x00005b0f786f02d5UL;
   tf->codes[15817] = 0x00005baa54a944ceUL;
   tf->codes[15818] = 0x00005bdbf7e528cbUL;
   tf->codes[15819] = 0x00005c5533ff1aa5UL;
   tf->codes[15820] = 0x00005e42d5a1bd4bUL;
   tf->codes[15821] = 0x00005e868b006913UL;
   tf->codes[15822] = 0x00005ef715df7fafUL;
   tf->codes[15823] = 0x00006000a880aa1cUL;
   tf->codes[15824] = 0x00006157c6867868UL;
   tf->codes[15825] = 0x00006179dbc4d411UL;
   tf->codes[15826] = 0x0000618969c25c65UL;
   tf->codes[15827] = 0x000061dce7ad9646UL;
   tf->codes[15828] = 0x00006240ddd26f8fUL;
   tf->codes[15829] = 0x000062db7f7dabc3UL;
   tf->codes[15830] = 0x00006360a0a4c9a1UL;
   tf->codes[15831] = 0x0000643d23368375UL;
   tf->codes[15832] = 0x00006545567d8b44UL;
   tf->codes[15833] = 0x000065effb445b56UL;
   tf->codes[15834] = 0x00006872fbb8b57dUL;
   tf->codes[15835] = 0x000068de7e4d4d2bUL;
   tf->codes[15836] = 0x00006919bd00237aUL;
   tf->codes[15837] = 0x000069498bc3d94fUL;
   tf->codes[15838] = 0x00006a4146d141b6UL;
   tf->codes[15839] = 0x00006a48d341001bUL;
   tf->codes[15840] = 0x00006a4f7574a76cUL;
   tf->codes[15841] = 0x00006d4b0255e21eUL;
   tf->codes[15842] = 0x00006dfb99a34832UL;
   tf->codes[15843] = 0x00006ea8c28f57bbUL;
   tf->codes[15844] = 0x00006f4e999aaea4UL;
   tf->codes[15845] = 0x00006fe85109d3c4UL;
   tf->codes[15846] = 0x00006ffb87f7b868UL;
   tf->codes[15847] = 0x00007085b1695534UL;
   tf->codes[15848] = 0x000070cc600b4bfdUL;
   tf->codes[15849] = 0x0000724bc06511b9UL;
   tf->codes[15850] = 0x0000725d5d69cdfaUL;
   tf->codes[15851] = 0x000072bcfaf139a4UL;
   tf->codes[15852] = 0x0000730c203f05e6UL;
   tf->codes[15853] = 0x000076a19f1e6b7dUL;
   tf->codes[15854] = 0x000076b4265f3ed2UL;
   tf->codes[15855] = 0x00007809e50aea80UL;
   tf->codes[15856] = 0x000078290105fb28UL;
   tf->codes[15857] = 0x000079fdb3c328edUL;
   tf->codes[15858] = 0x00007a5f25c2c2bfUL;
   tf->codes[15859] = 0x00007c1ecd19ddb8UL;
   tf->codes[15860] = 0x00007c27f372c480UL;
   tf->codes[15861] = 0x00007c2ab22709bcUL;
   tf->codes[15862] = 0x00007d50677ff9d0UL;
   tf->codes[15863] = 0x00007d62eec0cd25UL;
   tf->codes[15864] = 0x00007ebc1bcdcf5eUL;
   tf->codes[15865] = 0x00007f38512b0c39UL;
   tf->codes[15866] = 0x00007fc32a49ba54UL;
   tf->codes[15867] = 0x00008182d1a0d54dUL;
   tf->codes[15868] = 0x0000842772357f93UL;
   tf->codes[15869] = 0x0000845e584ae843UL;
   tf->codes[15870] = 0x000085397b827f79UL;
   tf->codes[15871] = 0x0000871a886ae4ccUL;
   tf->codes[15872] = 0x0000873d4d5651c4UL;
   tf->codes[15873] = 0x000088b979ddc6baUL;
   tf->codes[15874] = 0x000088f2a989691cUL;
   tf->codes[15875] = 0x00008a0a303ef37aUL;
   tf->codes[15876] = 0x00008b7360678991UL;
   tf->codes[15877] = 0x00008c78254d3ad5UL;
   tf->codes[15878] = 0x00008cb697d261eaUL;
   tf->codes[15879] = 0x00008d0c5f53d57dUL;
   tf->codes[15880] = 0x00008ef5333afefaUL;
   tf->codes[15881] = 0x00008f68423f550dUL;
   tf->codes[15882] = 0x00008fec792a5bd7UL;
   tf->codes[15883] = 0x00009145a6375e10UL;
   tf->codes[15884] = 0x0000921a273b4df5UL;
   tf->codes[15885] = 0x000092898d4f47b8UL;
   tf->codes[15886] = 0x0000975a077cb5f4UL;
   tf->codes[15887] = 0x000099d15d72e9dcUL;
   tf->codes[15888] = 0x00009a31aaa766d5UL;
   tf->codes[15889] = 0x00009b166955f05dUL;
   tf->codes[15890] = 0x00009f5408d6e68fUL;
   tf->codes[15891] = 0x0000a09cf8394f25UL;
   tf->codes[15892] = 0x0000a26a1e86be85UL;
   tf->codes[15893] = 0x0000a31c8a4c52c1UL;
   tf->codes[15894] = 0x0000a34c59100896UL;
   tf->codes[15895] = 0x0000a474928e3821UL;
   tf->codes[15896] = 0x0000a4e51d6d4ebdUL;
   tf->codes[15897] = 0x0000a51c78a0c2f7UL;
   tf->codes[15898] = 0x0000a55f43c357abUL;
   tf->codes[15899] = 0x0000a736efc3d071UL;
   tf->codes[15900] = 0x0000a74e44c01cefUL;
   tf->codes[15901] = 0x0000a75ebcf9bc57UL;
   tf->codes[15902] = 0x0000a776fc321fe9UL;
   tf->codes[15903] = 0x0000a90a4326db98UL;
   tf->codes[15904] = 0x0000a91be02b97d9UL;
   tf->codes[15905] = 0x0000a9d946c24105UL;
   tf->codes[15906] = 0x0000ab08d2212930UL;
   tf->codes[15907] = 0x0000abdf622c4d02UL;
   tf->codes[15908] = 0x0000ae1511cb090fUL;
   tf->codes[15909] = 0x0000aec2ea6429e7UL;
   tf->codes[15910] = 0x0000af13347d1302UL;
   tf->codes[15911] = 0x0000af23e745b82fUL;
   tf->codes[15912] = 0x0000afe61b97da84UL;
   tf->codes[15913] = 0x0000b013a0c556a7UL;
   tf->codes[15914] = 0x0000b091700bbbe5UL;
   tf->codes[15915] = 0x0000b0fb58b72b30UL;
   tf->codes[15916] = 0x0000b11b997d58b1UL;
   tf->codes[15917] = 0x0000b1cbbbacb33bUL;
   tf->codes[15918] = 0x0000b1d975320d67UL;
   tf->codes[15919] = 0x0000b273a1bf3e11UL;
   tf->codes[15920] = 0x0000b2853ec3fa52UL;
   tf->codes[15921] = 0x0000b2b8f107123cUL;
   tf->codes[15922] = 0x0000b2ccd7a2082fUL;
   tf->codes[15923] = 0x0000b3181970725cUL;
   tf->codes[15924] = 0x0000b44b884ebc9cUL;
   tf->codes[15925] = 0x0000b45389dc868bUL;
   tf->codes[15926] = 0x0000b46944efaaa6UL;
   tf->codes[15927] = 0x0000b59e13281784UL;
   tf->codes[15928] = 0x0000b626dd3f91b2UL;
   tf->codes[15929] = 0x0000b8548b5083d0UL;
   tf->codes[15930] = 0x0000b99922157ec7UL;
   tf->codes[15931] = 0x0000ba7da635028aUL;
   tf->codes[15932] = 0x0000ba8da9509668UL;
   tf->codes[15933] = 0x0000bb1b7bb28f84UL;
   tf->codes[15934] = 0x0000bbfc1c52b132UL;
   tf->codes[15935] = 0x0000bd40eda6b1eeUL;
   tf->codes[15936] = 0x0000bd44d1261403UL;
   tf->codes[15937] = 0x0000bd55495fb36bUL;
   tf->codes[15938] = 0x0000be170893ca36UL;
   tf->codes[15939] = 0x0000be907f3cc1d5UL;
   tf->codes[15940] = 0x0000be90b9cbc79aUL;
   tf->codes[15941] = 0x0000be930362014cUL;
   tf->codes[15942] = 0x0000c0bba928747cUL;
   tf->codes[15943] = 0x0000c24fda59473fUL;
   tf->codes[15944] = 0x0000c30071a6ad53UL;
   tf->codes[15945] = 0x0000c32dbc4523b1UL;
   tf->codes[15946] = 0x0000c385583ec56cUL;
   tf->codes[15947] = 0x0000c4d9427242f2UL;
   tf->codes[15948] = 0x0000c50234734bb1UL;
   tf->codes[15949] = 0x0000c7668e0aa0baUL;
   tf->codes[15950] = 0x0000c7c3324ec163UL;
   tf->codes[15951] = 0x0000c7f1dc475a5fUL;
   tf->codes[15952] = 0x0000cad47a432030UL;
   tf->codes[15953] = 0x0000cbab0a4e4402UL;
   tf->codes[15954] = 0x0000cbac2f1960dbUL;
   tf->codes[15955] = 0x0000cc85b867cfaeUL;
   tf->codes[15956] = 0x0000cd52726cfb69UL;
   tf->codes[15957] = 0x0000cda7ff5f6937UL;
   tf->codes[15958] = 0x0000cdf550350751UL;
   tf->codes[15959] = 0x0000ce1172ecccf8UL;
   tf->codes[15960] = 0x0000cf1f98ba6ac9UL;
   tf->codes[15961] = 0x0000cf7fe5eee7c2UL;
   tf->codes[15962] = 0x0000d0157f4fa508UL;
   tf->codes[15963] = 0x0000d2148367fe2aUL;
   tf->codes[15964] = 0x0000d21a00d088a2UL;
   tf->codes[15965] = 0x0000d316feb775bcUL;
   tf->codes[15966] = 0x0000d34a014d7c57UL;
   tf->codes[15967] = 0x0000d37ba4896054UL;
   tf->codes[15968] = 0x0000d3bac6bb98b8UL;
   tf->codes[15969] = 0x0000d4698990d0a4UL;
   tf->codes[15970] = 0x0000d62930e7eb9dUL;
   tf->codes[15971] = 0x0000d7b64ac70b85UL;
   tf->codes[15972] = 0x0000dd1d48914e1bUL;
   tf->codes[15973] = 0x0000dd6c33501498UL;
   tf->codes[15974] = 0x0000df58007a8916UL;
   tf->codes[15975] = 0x0000dfb46a2fa3faUL;
   tf->codes[15976] = 0x0000e12526c7f876UL;
   tf->codes[15977] = 0x0000e269f81bf932UL;
   tf->codes[15978] = 0x0000e46a961d7ab7UL;
   tf->codes[15979] = 0x0000e643dc071be0UL;
   tf->codes[15980] = 0x0000ea96fc0c3068UL;
   tf->codes[15981] = 0x0000eaaaa8182096UL;
   tf->codes[15982] = 0x0000ed0406de60afUL;
   tf->codes[15983] = 0x0000ed7491bd774bUL;
   tf->codes[15984] = 0x0000ef19ead4fac5UL;
   tf->codes[15985] = 0x0000ef4c3dbdf011UL;
   tf->codes[15986] = 0x0000eff3aeb26f5dUL;
   tf->codes[15987] = 0x0000effb75b13387UL;
   tf->codes[15988] = 0x0000f1bec5f8aad0UL;
   tf->codes[15989] = 0x0000f21c8f07e852UL;
   tf->codes[15990] = 0x0000f30ae92d642cUL;
   tf->codes[15991] = 0x0000f482828865beUL;
   tf->codes[15992] = 0x0000f544072d76c4UL;
   tf->codes[15993] = 0x0000f5a1208fa2f7UL;
   tf->codes[15994] = 0x0000f65317372ba9UL;
   tf->codes[15995] = 0x0000f658949fb621UL;
   tf->codes[15996] = 0x0000f7ef0f66c296UL;
   tf->codes[15997] = 0x0000fa3153bfbbf6UL;
   tf->codes[15998] = 0x0000fb0943250266UL;
   tf->codes[15999] = 0x0000fd726a77d098UL;
   tf->codes[16000] = 0x0000fd8c090a56c8UL;
   tf->codes[16001] = 0x0000fe0495773753UL;
   tf->codes[16002] = 0x0000fe5c6bffded3UL;
   tf->codes[16003] = 0x0000fee536175901UL;
   tf->codes[16004] = 0x0000ff6cdb63b656UL;
   tf->codes[16005] = 0x0000ff79358eede4UL;
   tf->codes[16006] = 0x0000ffc59c2874eaUL;
   tf->codes[16007] = 0x0000015e25f6b54cUL;
   tf->codes[16008] = 0x0000042884ba178bUL;
   tf->codes[16009] = 0x0000042c683979a0UL;
   tf->codes[16010] = 0x000005808cfbfcebUL;
   tf->codes[16011] = 0x000007d55895c9a0UL;
   tf->codes[16012] = 0x000008b37510abd7UL;
   tf->codes[16013] = 0x00000b525dadc5e0UL;
   tf->codes[16014] = 0x00000ff293f972bdUL;
   tf->codes[16015] = 0x0000104527a8958aUL;
   tf->codes[16016] = 0x0000110a553e02e0UL;
   tf->codes[16017] = 0x0000127ce64e8584UL;
   tf->codes[16018] = 0x0000140bd4a5d394UL;
   tf->codes[16019] = 0x000014e1ef92ebdcUL;
   tf->codes[16020] = 0x00001507adc1a3d5UL;
   tf->codes[16021] = 0x000015bac9344960UL;
   tf->codes[16022] = 0x000017f87a60cf5cUL;
   tf->codes[16023] = 0x00001aa01438c4a3UL;
   tf->codes[16024] = 0x00001b1a751dd356UL;
   tf->codes[16025] = 0x00001b7e6b42ac9fUL;
   tf->codes[16026] = 0x00001c90e9adb80fUL;
   tf->codes[16027] = 0x00001ce133c6a12aUL;
   tf->codes[16028] = 0x00001f2f97bbcc53UL;
   tf->codes[16029] = 0x00002057218cea8fUL;
   tf->codes[16030] = 0x00002139d134402aUL;
   tf->codes[16031] = 0x000021ca27bb78bdUL;
   tf->codes[16032] = 0x0000221aac63679dUL;
   tf->codes[16033] = 0x000025d86d96c4a4UL;
   tf->codes[16034] = 0x0000269bc6b403d2UL;
   tf->codes[16035] = 0x000027a4348a1166UL;
   tf->codes[16036] = 0x0000293531e89363UL;
   tf->codes[16037] = 0x00002a7694db3d94UL;
   tf->codes[16038] = 0x00002a924274f7b1UL;
   tf->codes[16039] = 0x00002d0b325453fcUL;
   tf->codes[16040] = 0x00003062ee5ba3cdUL;
   tf->codes[16041] = 0x000030a3e5060a59UL;
   tf->codes[16042] = 0x000031d83e206badUL;
   tf->codes[16043] = 0x00003201a53f7ff6UL;
   tf->codes[16044] = 0x0000330f907e1802UL;
   tf->codes[16045] = 0x000033187c47f905UL;
   tf->codes[16046] = 0x000033f0a63c453aUL;
   tf->codes[16047] = 0x000033f8e25914eeUL;
   tf->codes[16048] = 0x000034d689b5eb9bUL;
   tf->codes[16049] = 0x000037b5f3df60a6UL;
   tf->codes[16050] = 0x00003a02bdeb636cUL;
   tf->codes[16051] = 0x00003b16269285f0UL;
   tf->codes[16052] = 0x00003b4963b79250UL;
   tf->codes[16053] = 0x00003b69a47dbfd1UL;
   tf->codes[16054] = 0x00003ccd573dcb70UL;
   tf->codes[16055] = 0x00003dc8bb3b9027UL;
   tf->codes[16056] = 0x00003dc9a577a73bUL;
   tf->codes[16057] = 0x00003f40549691b9UL;
   tf->codes[16058] = 0x0000400be9d0a09bUL;
   tf->codes[16059] = 0x00004109d1f3a4c9UL;
   tf->codes[16060] = 0x0000421ed483efb0UL;
   tf->codes[16061] = 0x000042d6bdb20e64UL;
   tf->codes[16062] = 0x0000439f9437d80aUL;
   tf->codes[16063] = 0x0000443dded3708eUL;
   tf->codes[16064] = 0x0000449fc5f115eaUL;
   tf->codes[16065] = 0x000047e4c0288ca1UL;
   tf->codes[16066] = 0x0000480a09393910UL;
   tf->codes[16067] = 0x0000481a46e3d2b3UL;
   tf->codes[16068] = 0x000048a595208c58UL;
   tf->codes[16069] = 0x00004972fed2c962UL;
   tf->codes[16070] = 0x000049b58f665851UL;
   tf->codes[16071] = 0x00004a15dc9ad54aUL;
   tf->codes[16072] = 0x00004c079c4bdfcaUL;
   tf->codes[16073] = 0x00004e1a4c70291aUL;
   tf->codes[16074] = 0x00004ea5601ddcfaUL;
   tf->codes[16075] = 0x00004f4210d04d1bUL;
   tf->codes[16076] = 0x000050261fd1c554UL;
   tf->codes[16077] = 0x000051198241c01cUL;
   tf->codes[16078] = 0x0000536895e3fc94UL;
   tf->codes[16079] = 0x000053c783be56efUL;
   tf->codes[16080] = 0x000053cc5179d018UL;
   tf->codes[16081] = 0x0000566c24530135UL;
   tf->codes[16082] = 0x00005730dcca6301UL;
   tf->codes[16083] = 0x000057ca59aa825cUL;
   tf->codes[16084] = 0x000059aed4f43e3aUL;
   tf->codes[16085] = 0x00005b500ffd59daUL;
   tf->codes[16086] = 0x00005bf2edc565c2UL;
   tf->codes[16087] = 0x00005d082ae4b66eUL;
   tf->codes[16088] = 0x00005f23c6d2e0c1UL;
   tf->codes[16089] = 0x00005fae65628917UL;
   tf->codes[16090] = 0x000062b90b234093UL;
   tf->codes[16091] = 0x00006348776e6212UL;
   tf->codes[16092] = 0x000063800d30dc11UL;
   tf->codes[16093] = 0x000063bad6c5a6d6UL;
   tf->codes[16094] = 0x000065e3076e0e7cUL;
   tf->codes[16095] = 0x00006682ebf2cf63UL;
   tf->codes[16096] = 0x0000673383403577UL;
   tf->codes[16097] = 0x000067d626793b9aUL;
   tf->codes[16098] = 0x000069cec2ecf330UL;
   tf->codes[16099] = 0x00006ae81e1aabb6UL;
   tf->codes[16100] = 0x00006af6874d1731UL;
   tf->codes[16101] = 0x00006b047b617722UL;
   tf->codes[16102] = 0x00006b88029f6c9dUL;
   tf->codes[16103] = 0x00006c21ba0e91bdUL;
   tf->codes[16104] = 0x00006d2a27e49f51UL;
   tf->codes[16105] = 0x00006d735aabd591UL;
   tf->codes[16106] = 0x00006f392f188c51UL;
   tf->codes[16107] = 0x000070c056711637UL;
   tf->codes[16108] = 0x000072226f47f973UL;
   tf->codes[16109] = 0x00007225a31a4a39UL;
   tf->codes[16110] = 0x0000732141a714b5UL;
   tf->codes[16111] = 0x0000733ae0399ae5UL;
   tf->codes[16112] = 0x0000743435302bafUL;
   tf->codes[16113] = 0x00007448565a2767UL;
   tf->codes[16114] = 0x000074b0dfab7414UL;
   tf->codes[16115] = 0x000075d77f407b3cUL;
   tf->codes[16116] = 0x0000791a6a70be06UL;
   tf->codes[16117] = 0x000079427235afb1UL;
   tf->codes[16118] = 0x000079c0417c14efUL;
   tf->codes[16119] = 0x000079db79f7c382UL;
   tf->codes[16120] = 0x00007a89c7aeefe4UL;
   tf->codes[16121] = 0x00007ae9da546718UL;
   tf->codes[16122] = 0x00007da60a7463a1UL;
   tf->codes[16123] = 0x00007e08dbce2011UL;
   tf->codes[16124] = 0x00007f76d9b22f51UL;
   tf->codes[16125] = 0x00007fbc63890941UL;
   tf->codes[16126] = 0x00007fe5901917c5UL;
   tf->codes[16127] = 0x000080cd0d7be689UL;
   tf->codes[16128] = 0x000082efc0bbc3b7UL;
   tf->codes[16129] = 0x000084946a2635e2UL;
   tf->codes[16130] = 0x000087394549e5edUL;
   tf->codes[16131] = 0x0000876271d9f471UL;
   tf->codes[16132] = 0x0000887ec64af7f8UL;
   tf->codes[16133] = 0x00008a64a0eed674UL;
   tf->codes[16134] = 0x00008bc6b9c5b9b0UL;
   tf->codes[16135] = 0x00008d9d40fb159dUL;
   tf->codes[16136] = 0x00008fac82be0862UL;
   tf->codes[16137] = 0x00008fc2b2ef3807UL;
   tf->codes[16138] = 0x0000917fd6211389UL;
   tf->codes[16139] = 0x0000927c5ee9f519UL;
   tf->codes[16140] = 0x000094a6640a8ae7UL;
   tf->codes[16141] = 0x0000950f6279e31eUL;
   tf->codes[16142] = 0x000095e3e37dd303UL;
   tf->codes[16143] = 0x000096a3ce39bba6UL;
   tf->codes[16144] = 0x000096c61e071d14UL;
   tf->codes[16145] = 0x00009a19bc00050bUL;
   tf->codes[16146] = 0x00009be87c369cceUL;
   tf->codes[16147] = 0x00009c5055dad82cUL;
   tf->codes[16148] = 0x0000a0085f16a4f6UL;
   tf->codes[16149] = 0x0000a0298a18e98bUL;
   tf->codes[16150] = 0x0000a0857eaff8e5UL;
   tf->codes[16151] = 0x0000a0db0ba266b3UL;
   tf->codes[16152] = 0x0000a1d71f4d3cb9UL;
   tf->codes[16153] = 0x0000a2547975966dUL;
   tf->codes[16154] = 0x0000a82efb623aa0UL;
   tf->codes[16155] = 0x0000aa024ec545c7UL;
   tf->codes[16156] = 0x0000aa2fd3f2c1eaUL;
   tf->codes[16157] = 0x0000abacb027482fUL;
   tf->codes[16158] = 0x0000ae4ecc96b2feUL;
   tf->codes[16159] = 0x0000b057e14409fcUL;
   tf->codes[16160] = 0x0000b1eb9d56d135UL;
   tf->codes[16161] = 0x0000b204171e3a8cUL;
   tf->codes[16162] = 0x0000b283f56bd3b7UL;
   tf->codes[16163] = 0x0000b33243230019UL;
   tf->codes[16164] = 0x0000b384d6d222e6UL;
   tf->codes[16165] = 0x0000b3f7ab477334UL;
   tf->codes[16166] = 0x0000b5b0b06ae6dcUL;
   tf->codes[16167] = 0x0000b5b12588f266UL;
   tf->codes[16168] = 0x0000b905adbdf171UL;
   tf->codes[16169] = 0x0000b90956ae4dc1UL;
   tf->codes[16170] = 0x0000b98eecf37729UL;
   tf->codes[16171] = 0x0000ba80b57a498eUL;
   tf->codes[16172] = 0x0000bcda4ecf8f6cUL;
   tf->codes[16173] = 0x0000bd2bf8429b25UL;
   tf->codes[16174] = 0x0000be3a932e4480UL;
   tf->codes[16175] = 0x0000be3eb13cac5aUL;
   tf->codes[16176] = 0x0000bf0c557def29UL;
   tf->codes[16177] = 0x0000bf9f6ab96cf8UL;
   tf->codes[16178] = 0x0000c37fb6493132UL;
   tf->codes[16179] = 0x0000c3b15985152fUL;
   tf->codes[16180] = 0x0000c50ac1211d2dUL;
   tf->codes[16181] = 0x0000c52f5a84b84dUL;
   tf->codes[16182] = 0x0000c59d613e8f72UL;
   tf->codes[16183] = 0x0000c65c61be6101UL;
   tf->codes[16184] = 0x0000c9ab31fbcfcfUL;
   tf->codes[16185] = 0x0000caf0b2fce1daUL;
   tf->codes[16186] = 0x0000cd0537995952UL;
   tf->codes[16187] = 0x0000cf85b3e87402UL;
   tf->codes[16188] = 0x0000cfc63574cf04UL;
   tf->codes[16189] = 0x0000d1142d21b688UL;
   tf->codes[16190] = 0x0000d14f6bd48cd7UL;
   tf->codes[16191] = 0x0000d2296a410734UL;
   tf->codes[16192] = 0x0000d35beee33a60UL;
   tf->codes[16193] = 0x0000d3867acd6b82UL;
   tf->codes[16194] = 0x0000d3de16c70d3dUL;
   tf->codes[16195] = 0x0000d53a028854b2UL;
   tf->codes[16196] = 0x0000d75897b9ca06UL;
   tf->codes[16197] = 0x0000d7e2c12b66d2UL;
   tf->codes[16198] = 0x0000dadb8f585c48UL;
   tf->codes[16199] = 0x0000dc335d0b3be3UL;
   tf->codes[16200] = 0x0000ddc4cf87c96aUL;
   tf->codes[16201] = 0x0000e0943695aa97UL;
   tf->codes[16202] = 0x0000e138e8d5e4a7UL;
   tf->codes[16203] = 0x0000e38d04c2a00dUL;
   tf->codes[16204] = 0x0000e4ee6dec71faUL;
   tf->codes[16205] = 0x0000e547a3cf3c18UL;
   tf->codes[16206] = 0x0000e717c35ff679UL;
   tf->codes[16207] = 0x0000e7908a5bdcc9UL;
   tf->codes[16208] = 0x0000edafe672499dUL;
   tf->codes[16209] = 0x0000effa2c590cecUL;
   tf->codes[16210] = 0x0000f0aac3a67300UL;
   tf->codes[16211] = 0x0000f171509602f4UL;
   tf->codes[16212] = 0x0000f1c41ed42b86UL;
   tf->codes[16213] = 0x0000f386bf6e9180UL;
   tf->codes[16214] = 0x0000f442c6ab180eUL;
   tf->codes[16215] = 0x0000f584d94ad38eUL;
   tf->codes[16216] = 0x0000f701b57f59d3UL;
   tf->codes[16217] = 0x0000f8a8a88005b0UL;
   tf->codes[16218] = 0x0000f9e5032830f3UL;
   tf->codes[16219] = 0x0000fedbeb316877UL;
   tf->codes[16220] = 0x000002edd9fd10aeUL;
   tf->codes[16221] = 0x00000322015e3422UL;
   tf->codes[16222] = 0x000009692aaa8cdcUL;
   tf->codes[16223] = 0x00000c3adb4ea7bbUL;
   tf->codes[16224] = 0x00000d379ea68f10UL;
   tf->codes[16225] = 0x00000febcd38c1aaUL;
   tf->codes[16226] = 0x0000111bcdb5b55fUL;
   tf->codes[16227] = 0x00001246163b18d7UL;
   tf->codes[16228] = 0x000015ccb6ca0769UL;
   tf->codes[16229] = 0x000016abf8100679UL;
   tf->codes[16230] = 0x000019589a327aaeUL;
   tf->codes[16231] = 0x00001a92e5d37204UL;
   tf->codes[16232] = 0x00001bd35e8a0521UL;
   tf->codes[16233] = 0x00001c3b72bd4644UL;
   tf->codes[16234] = 0x00001c5ac9475cb1UL;
   tf->codes[16235] = 0x00001c7acf7e846dUL;
   tf->codes[16236] = 0x00001d1ed211ad2eUL;
   tf->codes[16237] = 0x000020735a46ac39UL;
   tf->codes[16238] = 0x0000211bf006485eUL;
   tf->codes[16239] = 0x0000223b78499cabUL;
   tf->codes[16240] = 0x0000230f0f11757cUL;
   tf->codes[16241] = 0x000024a8f839d87cUL;
   tf->codes[16242] = 0x000024b7d68a4f81UL;
   tf->codes[16243] = 0x00002896c2bff11dUL;
   tf->codes[16244] = 0x000029b610743fa5UL;
   tf->codes[16245] = 0x00002acf3112f266UL;
   tf->codes[16246] = 0x00002d9cfe37ab30UL;
   tf->codes[16247] = 0x000031a8bfedb7a0UL;
   tf->codes[16248] = 0x00003360dad51434UL;
   tf->codes[16249] = 0x00003576843ca885UL;
   tf->codes[16250] = 0x000035a8d7259dd1UL;
   tf->codes[16251] = 0x00003610eb58def4UL;
   tf->codes[16252] = 0x000036a3c60556feUL;
   tf->codes[16253] = 0x0000376b02a1f841UL;
   tf->codes[16254] = 0x000037b7693b7f47UL;
   tf->codes[16255] = 0x000038fb15c4632aUL;
   tf->codes[16256] = 0x00003a188f00838aUL;
   tf->codes[16257] = 0x00003ac2841a424dUL;
   tf->codes[16258] = 0x00003b3433c475c2UL;
   tf->codes[16259] = 0x00003ce3d7fffcddUL;
   tf->codes[16260] = 0x00003dc05a91b6b1UL;
   tf->codes[16261] = 0x00003e77cea1c9dbUL;
   tf->codes[16262] = 0x000041030b32f3b6UL;
   tf->codes[16263] = 0x000042cff6f15d51UL;
   tf->codes[16264] = 0x0000430ccf8d5c03UL;
   tf->codes[16265] = 0x000045aa935f5933UL;
   tf->codes[16266] = 0x00004644103f788eUL;
   tf->codes[16267] = 0x0000497e84c3e5dfUL;
   tf->codes[16268] = 0x00004a21d7a9fd51UL;
   tf->codes[16269] = 0x00004cb1a7679a90UL;
   tf->codes[16270] = 0x00004cec366d5f90UL;
   tf->codes[16271] = 0x00004de4a127d946UL;
   tf->codes[16272] = 0x00004e09afa97ff0UL;
   tf->codes[16273] = 0x00004ee7cc246227UL;
   tf->codes[16274] = 0x00004eed498cec9fUL;
   tf->codes[16275] = 0x00004ff15ec58c94UL;
   tf->codes[16276] = 0x000050d11529972eUL;
   tf->codes[16277] = 0x000050d6cd21276bUL;
   tf->codes[16278] = 0x0000519a60cd6c5eUL;
   tf->codes[16279] = 0x000051e7ec32103dUL;
   tf->codes[16280] = 0x0000534b29d41052UL;
   tf->codes[16281] = 0x000054d04225664bUL;
   tf->codes[16282] = 0x00005627259c2ed2UL;
   tf->codes[16283] = 0x0000578d97107fadUL;
   tf->codes[16284] = 0x0000588e0358c352UL;
   tf->codes[16285] = 0x000058cb1683c7c9UL;
   tf->codes[16286] = 0x000059471151fedfUL;
   tf->codes[16287] = 0x00005acc9ec16062UL;
   tf->codes[16288] = 0x00005c8c46187b5bUL;
   tf->codes[16289] = 0x00005d15fa6c0c9dUL;
   tf->codes[16290] = 0x00006584df42c173UL;
   tf->codes[16291] = 0x0000663fc1b42b28UL;
   tf->codes[16292] = 0x000066837712d6f0UL;
   tf->codes[16293] = 0x000066e76d37b039UL;
   tf->codes[16294] = 0x00006708d2c8fa93UL;
   tf->codes[16295] = 0x00006a87ac5924fbUL;
   tf->codes[16296] = 0x00006bdc80c8b995UL;
   tf->codes[16297] = 0x00006c775d02fb8eUL;
   tf->codes[16298] = 0x00006cfa3493dfbaUL;
   tf->codes[16299] = 0x00006d799dc36d5bUL;
   tf->codes[16300] = 0x00006d97cf8266efUL;
   tf->codes[16301] = 0x00006f17df893dfaUL;
   tf->codes[16302] = 0x00006f2105e224c2UL;
   tf->codes[16303] = 0x000070b53712f785UL;
   tf->codes[16304] = 0x0000711bb15d1045UL;
   tf->codes[16305] = 0x000071b1bfdbd915UL;
   tf->codes[16306] = 0x000073aa21c08ae6UL;
   tf->codes[16307] = 0x00007561526bd066UL;
   tf->codes[16308] = 0x000075f81097aa85UL;
   tf->codes[16309] = 0x0000762ad89eab5bUL;
   tf->codes[16310] = 0x0000770a8f02b5f5UL;
   tf->codes[16311] = 0x00007d37df2d82baUL;
   tf->codes[16312] = 0x00007d43c43aaebeUL;
   tf->codes[16313] = 0x00007d856a922699UL;
   tf->codes[16314] = 0x000080ffb0f5dd9dUL;
   tf->codes[16315] = 0x00008105de0b7964UL;
   tf->codes[16316] = 0x00008222327c7cebUL;
   tf->codes[16317] = 0x000083dfcacc63f7UL;
   tf->codes[16318] = 0x000085c11243cf0fUL;
   tf->codes[16319] = 0x00008600e42318c2UL;
   tf->codes[16320] = 0x00008648b7902c64UL;
   tf->codes[16321] = 0x000086e6c79cbf23UL;
   tf->codes[16322] = 0x0000888afbe925c4UL;
   tf->codes[16323] = 0x000088c048156611UL;
   tf->codes[16324] = 0x00008b0bb2c74639UL;
   tf->codes[16325] = 0x00008b802125beeaUL;
   tf->codes[16326] = 0x00008c2bb028a610UL;
   tf->codes[16327] = 0x00008c4e3a850d43UL;
   tf->codes[16328] = 0x00008ca143523b9aUL;
   tf->codes[16329] = 0x000090e0f1da65b9UL;
   tf->codes[16330] = 0x00009128159a680cUL;
   tf->codes[16331] = 0x000091bc4fa102b4UL;
   tf->codes[16332] = 0x000091d837c9c296UL;
   tf->codes[16333] = 0x000091f9283d0166UL;
   tf->codes[16334] = 0x00009280586b5331UL;
   tf->codes[16335] = 0x000093275441c6f3UL;
   tf->codes[16336] = 0x0000937b0cbc0699UL;
   tf->codes[16337] = 0x000095f7306db3aaUL;
   tf->codes[16338] = 0x00009630d5376196UL;
   tf->codes[16339] = 0x00009802199338d0UL;
   tf->codes[16340] = 0x00009a76764621b7UL;
   tf->codes[16341] = 0x00009be26522fd0aUL;
   tf->codes[16342] = 0x00009f258ae24599UL;
   tf->codes[16343] = 0x00009ff2ba057cdeUL;
   tf->codes[16344] = 0x0000a0ab8d6fb2a6UL;
   tf->codes[16345] = 0x0000a2b9e4f68e57UL;
   tf->codes[16346] = 0x0000a3af1bdeb747UL;
   tf->codes[16347] = 0x0000a745fa183f7cUL;
   tf->codes[16348] = 0x0000a902a82c0f74UL;
   tf->codes[16349] = 0x0000a9fb880494b4UL;
   tf->codes[16350] = 0x0000abaf84dd896eUL;
   tf->codes[16351] = 0x0000ac8b925137b8UL;
   tf->codes[16352] = 0x0000afbeb4f4ec69UL;
   tf->codes[16353] = 0x0000b0949552feecUL;
   tf->codes[16354] = 0x0000b0b8f4279447UL;
   tf->codes[16355] = 0x0000b167f18bd1f8UL;
   tf->codes[16356] = 0x0000b1891c8e168dUL;
   tf->codes[16357] = 0x0000b2246de66410UL;
   tf->codes[16358] = 0x0000b31a547b9e4fUL;
   tf->codes[16359] = 0x0000b3b396ccb7e5UL;
   tf->codes[16360] = 0x0000b523a3b7fb12UL;
   tf->codes[16361] = 0x0000b814aae62c5eUL;
   tf->codes[16362] = 0x0000b8694d9c8318UL;
   tf->codes[16363] = 0x0000b8b8385b4995UL;
   tf->codes[16364] = 0x0000b99c0ccdbc09UL;
   tf->codes[16365] = 0x0000ba380dd31adbUL;
   tf->codes[16366] = 0x0000bb4b015c31d5UL;
   tf->codes[16367] = 0x0000bb86400f0824UL;
   tf->codes[16368] = 0x0000bd4069fd98a5UL;
   tf->codes[16369] = 0x0000bd841f5c446dUL;
   tf->codes[16370] = 0x0000bdb96b8884baUL;
   tf->codes[16371] = 0x0000befb090a34b0UL;
   tf->codes[16372] = 0x0000c18ce7cf05dcUL;
   tf->codes[16373] = 0x0000c2680b069d12UL;
   tf->codes[16374] = 0x0000c2b8ca3d91b7UL;
   tf->codes[16375] = 0x0000c392538c008aUL;
   tf->codes[16376] = 0x0000c3f091b94996UL;
   tf->codes[16377] = 0x0000c432729fc736UL;
   tf->codes[16378] = 0x0000c57c4c3e46e0UL;
   tf->codes[16379] = 0x0000c7b7b3d4932aUL;
   tf->codes[16380] = 0x0000c7c8dbbb43e1UL;
   tf->codes[16381] = 0x0000c82b7285fa8cUL;
   tf->codes[16382] = 0x0000c86467a29729UL;
   tf->codes[16383] = 0x0000c876eee36a7eUL;
   tf->codes[16384] = 0x0000c90aee5aff61UL;
   tf->codes[16385] = 0x0000ca4c514da992UL;
   tf->codes[16386] = 0x0000cb57f2f607ecUL;
   tf->codes[16387] = 0x0000cce9da90a0fdUL;
   tf->codes[16388] = 0x0000cd2220002c4bUL;
   tf->codes[16389] = 0x0000ce21dc9b5ea1UL;
   tf->codes[16390] = 0x0000cf0192ff693bUL;
   tf->codes[16391] = 0x0000cf2cce96abacUL;
   tf->codes[16392] = 0x0000d0cbfa98935fUL;
   tf->codes[16393] = 0x0000d334723e5042UL;
   tf->codes[16394] = 0x0000d33d23792b80UL;
   tf->codes[16395] = 0x0000d495664a16a5UL;
   tf->codes[16396] = 0x0000d525bcd14f38UL;
   tf->codes[16397] = 0x0000d97a76bf8c23UL;
   tf->codes[16398] = 0x0000daea0e8cc3c6UL;
   tf->codes[16399] = 0x0000ddfcb5db4531UL;
   tf->codes[16400] = 0x0000de8b37ea4f9cUL;
   tf->codes[16401] = 0x0000df1f71f0ea44UL;
   tf->codes[16402] = 0x0000e3148e57bb85UL;
   tf->codes[16403] = 0x0000e76982d4fe35UL;
   tf->codes[16404] = 0x0000e7aa797f64c1UL;
   tf->codes[16405] = 0x0000ea503edf2be0UL;
   tf->codes[16406] = 0x0000ed1bfcfcb0bdUL;
   tf->codes[16407] = 0x0000edebb0452779UL;
   tf->codes[16408] = 0x0000ee7bcc3d5a47UL;
   tf->codes[16409] = 0x0000eeb8df685ebeUL;
   tf->codes[16410] = 0x0000f0a312a9aad9UL;
   tf->codes[16411] = 0x0000f1ce456b2565UL;
   tf->codes[16412] = 0x0000f45f7482e542UL;
   tf->codes[16413] = 0x0000f46dddb550bdUL;
   tf->codes[16414] = 0x0000f4a1556962e2UL;
   tf->codes[16415] = 0x0000f5ce221405d1UL;
   tf->codes[16416] = 0x0000f5f196ac8418UL;
   tf->codes[16417] = 0x0000f9548813ee9eUL;
   tf->codes[16418] = 0x0000f9a1d8e98cb8UL;
   tf->codes[16419] = 0x0000fa7e5b7b468cUL;
   tf->codes[16420] = 0x0000facee023356cUL;
   tf->codes[16421] = 0x0000fb918993634bUL;
   tf->codes[16422] = 0x00000023913baa72UL;
   tf->codes[16423] = 0x000001af4bc0a7bcUL;
   tf->codes[16424] = 0x000002f8ead021a1UL;
   tf->codes[16425] = 0x000003530aef02d3UL;
   tf->codes[16426] = 0x0000073e514fdbfdUL;
   tf->codes[16427] = 0x000008246f588823UL;
   tf->codes[16428] = 0x00000ba67cbb0351UL;
   tf->codes[16429] = 0x00000d373f8a7f89UL;
   tf->codes[16430] = 0x00000de970c10e00UL;
   tf->codes[16431] = 0x00000e6655cb5c2aUL;
   tf->codes[16432] = 0x000013a6360cc429UL;
   tf->codes[16433] = 0x000013e51daff6c8UL;
   tf->codes[16434] = 0x000014b2fc803f5cUL;
   tf->codes[16435] = 0x000017ebd71b844aUL;
   tf->codes[16436] = 0x0000186c2a8728ffUL;
   tf->codes[16437] = 0x00001978f0faa432UL;
   tf->codes[16438] = 0x00001a6994b659beUL;
   tf->codes[16439] = 0x00001bafc5647d18UL;
   tf->codes[16440] = 0x00001bdb00fbbf89UL;
   tf->codes[16441] = 0x00001ccd041197b3UL;
   tf->codes[16442] = 0x00001ceb35d09147UL;
   tf->codes[16443] = 0x00001d351844d8d6UL;
   tf->codes[16444] = 0x00001ea9433e83ddUL;
   tf->codes[16445] = 0x00001f42c01ea338UL;
   tf->codes[16446] = 0x00001fea6ba22849UL;
   tf->codes[16447] = 0x0000214fb84b5c4bUL;
   tf->codes[16448] = 0x000022f8f4e241daUL;
   tf->codes[16449] = 0x000025bcec01028dUL;
   tf->codes[16450] = 0x00002607b8b16130UL;
   tf->codes[16451] = 0x0000281bc82fcd1eUL;
   tf->codes[16452] = 0x000029046a5db8bbUL;
   tf->codes[16453] = 0x0000299a03be7601UL;
   tf->codes[16454] = 0x00002a6314d3456cUL;
   tf->codes[16455] = 0x00002d0447069927UL;
   tf->codes[16456] = 0x00002d892d9eb140UL;
   tf->codes[16457] = 0x00002f60d99f2a06UL;
   tf->codes[16458] = 0x00002f70679cb25aUL;
   tf->codes[16459] = 0x0000310841bde16dUL;
   tf->codes[16460] = 0x000033b050b3e23eUL;
   tf->codes[16461] = 0x0000347e6a133097UL;
   tf->codes[16462] = 0x0000350a2d6df5c6UL;
   tf->codes[16463] = 0x000037659b3b69ccUL;
   tf->codes[16464] = 0x000037e713722b5aUL;
   tf->codes[16465] = 0x0000391838ba3be8UL;
   tf->codes[16466] = 0x0000393879806969UL;
   tf->codes[16467] = 0x00003951a2f4e40fUL;
   tf->codes[16468] = 0x0000396046b6554fUL;
   tf->codes[16469] = 0x00003db0a807249bUL;
   tf->codes[16470] = 0x0000429b70742a56UL;
   tf->codes[16471] = 0x000042fdccafdb3cUL;
   tf->codes[16472] = 0x000044a6ceb7bb06UL;
   tf->codes[16473] = 0x0000455b4984832fUL;
   tf->codes[16474] = 0x000045e3d90cf798UL;
   tf->codes[16475] = 0x000046c26aa5e559UL;
   tf->codes[16476] = 0x000046df027bb68aUL;
   tf->codes[16477] = 0x000047b816ac19d3UL;
   tf->codes[16478] = 0x0000489a16a65e1fUL;
   tf->codes[16479] = 0x0000493826b2f0deUL;
   tf->codes[16480] = 0x00004ada4bf82392UL;
   tf->codes[16481] = 0x00004bf999ac721aUL;
   tf->codes[16482] = 0x00004c31df1bfd68UL;
   tf->codes[16483] = 0x00004c9057d84c39UL;
   tf->codes[16484] = 0x00004d57cf03f341UL;
   tf->codes[16485] = 0x00004eecafe1d753UL;
   tf->codes[16486] = 0x0000504233fe7d3cUL;
   tf->codes[16487] = 0x000054a51c901fddUL;
   tf->codes[16488] = 0x000054d5d58fecc6UL;
   tf->codes[16489] = 0x000058021b70f461UL;
   tf->codes[16490] = 0x000059fcc6ebdfe4UL;
   tf->codes[16491] = 0x00005bba5f3bc6f0UL;
   tf->codes[16492] = 0x00005beec12bf029UL;
   tf->codes[16493] = 0x00005c3f45d3df09UL;
   tf->codes[16494] = 0x00005cdeefc99a2bUL;
   tf->codes[16495] = 0x00005d5ece173356UL;
   tf->codes[16496] = 0x00005e4a698869f4UL;
   tf->codes[16497] = 0x0000610c519ff6baUL;
   tf->codes[16498] = 0x0000616b3f7a5115UL;
   tf->codes[16499] = 0x000061b646b9b57dUL;
   tf->codes[16500] = 0x00006253a71936edUL;
   tf->codes[16501] = 0x000062a4db6e371cUL;
   tf->codes[16502] = 0x0000657c7e98e7fdUL;
   tf->codes[16503] = 0x0000680e22ceb364UL;
   tf->codes[16504] = 0x00006c9cbc15a400UL;
   tf->codes[16505] = 0x00006fd8ca8339b4UL;
   tf->codes[16506] = 0x000071ca8a344434UL;
   tf->codes[16507] = 0x00007587612b8a27UL;
   tf->codes[16508] = 0x0000786cbddb9534UL;
   tf->codes[16509] = 0x0000788bd9d6a5dcUL;
   tf->codes[16510] = 0x000078d0797168b8UL;
   tf->codes[16511] = 0x00007b35bd44d4d5UL;
   tf->codes[16512] = 0x00007c2a7f0ef23bUL;
   tf->codes[16513] = 0x00007d59cfded4a1UL;
   tf->codes[16514] = 0x00007f2b8958b765UL;
   tf->codes[16515] = 0x00007f96d15e494eUL;
   tf->codes[16516] = 0x000080e69d835efaUL;
   tf->codes[16517] = 0x00008278bfacfdd0UL;
   tf->codes[16518] = 0x000084c046df7be3UL;
   tf->codes[16519] = 0x000084d0f9a82110UL;
   tf->codes[16520] = 0x000087df0dca2f17UL;
   tf->codes[16521] = 0x000089357c22ec14UL;
   tf->codes[16522] = 0x00008a0ae762f30dUL;
   tf->codes[16523] = 0x00008a4ba37e53d4UL;
   tf->codes[16524] = 0x00008aa4d9611df2UL;
   tf->codes[16525] = 0x00008ad8c6333ba1UL;
   tf->codes[16526] = 0x00008b45e2b0fbb2UL;
   tf->codes[16527] = 0x00008c281d3a45c3UL;
   tf->codes[16528] = 0x00008cc2f97487bcUL;
   tf->codes[16529] = 0x00008f4ac7a45b0cUL;
   tf->codes[16530] = 0x0000916a0c82e1afUL;
   tf->codes[16531] = 0x0000927bdb40dbd0UL;
   tf->codes[16532] = 0x000093bb2f2c5214UL;
   tf->codes[16533] = 0x00009437d9a79a79UL;
   tf->codes[16534] = 0x0000952cd600bda4UL;
   tf->codes[16535] = 0x000095bda1a601c1UL;
   tf->codes[16536] = 0x0000966378b158aaUL;
   tf->codes[16537] = 0x0000966930a8e8e7UL;
   tf->codes[16538] = 0x0000985daf0e38a3UL;
   tf->codes[16539] = 0x0000994c0933b47dUL;
   tf->codes[16540] = 0x000099a9d242f1ffUL;
   tf->codes[16541] = 0x00009aacc2b0751bUL;
   tf->codes[16542] = 0x00009d2abada5054UL;
   tf->codes[16543] = 0x00009d8acd7fc788UL;
   tf->codes[16544] = 0x00009dd89373712cUL;
   tf->codes[16545] = 0x00009e32ee215823UL;
   tf->codes[16546] = 0x0000a0359b2a0d95UL;
   tf->codes[16547] = 0x0000a105fe1f95a0UL;
   tf->codes[16548] = 0x0000a194459f9a46UL;
   tf->codes[16549] = 0x0000a39d1fbdeb7fUL;
   tf->codes[16550] = 0x0000a545aca7bfbfUL;
   tf->codes[16551] = 0x0000a637afbd97e9UL;
   tf->codes[16552] = 0x0000a6c3ada762ddUL;
   tf->codes[16553] = 0x0000a93b78bba24fUL;
   tf->codes[16554] = 0x0000a98e0c6ac51cUL;
   tf->codes[16555] = 0x0000ae685c9e2b6fUL;
   tf->codes[16556] = 0x0000af9ae1405e9bUL;
   tf->codes[16557] = 0x0000b13a0d42464eUL;
   tf->codes[16558] = 0x0000b1f5d9efc717UL;
   tf->codes[16559] = 0x0000b2065229667fUL;
   tf->codes[16560] = 0x0000b26f8b27c47bUL;
   tf->codes[16561] = 0x0000b39d077f78b9UL;
   tf->codes[16562] = 0x0000b50c2a2ea4d2UL;
   tf->codes[16563] = 0x0000b6f39ebbabb1UL;
   tf->codes[16564] = 0x0000bc92e1f57995UL;
   tf->codes[16565] = 0x0000bdc90f880911UL;
   tf->codes[16566] = 0x0000be4cd1550451UL;
   tf->codes[16567] = 0x0000bec59850eaa1UL;
   tf->codes[16568] = 0x0000c1a95b17cd4bUL;
   tf->codes[16569] = 0x0000c1d8b4bd7796UL;
   tf->codes[16570] = 0x0000c350c33684b2UL;
   tf->codes[16571] = 0x0000c414cc00d52fUL;
   tf->codes[16572] = 0x0000c517bc6e584bUL;
   tf->codes[16573] = 0x0000c520a838394eUL;
   tf->codes[16574] = 0x0000c704ae63e9a2UL;
   tf->codes[16575] = 0x0000c7b077f5d68dUL;
   tf->codes[16576] = 0x0000c7e4d9e5ffc6UL;
   tf->codes[16577] = 0x0000c8e49681321cUL;
   tf->codes[16578] = 0x0000c947a269f451UL;
   tf->codes[16579] = 0x0000c9f038299076UL;
   tf->codes[16580] = 0x0000ca781804f390UL;
   tf->codes[16581] = 0x0000cba902bdfe59UL;
   tf->codes[16582] = 0x0000cc8376488440UL;
   tf->codes[16583] = 0x0000cdf67c77126eUL;
   tf->codes[16584] = 0x0000cead064b0e84UL;
   tf->codes[16585] = 0x0000d27f98557892UL;
   tf->codes[16586] = 0x0000d36c5891cc09UL;
   tf->codes[16587] = 0x0000d47b2e0c7b29UL;
   tf->codes[16588] = 0x0000d7901ef13646UL;
   tf->codes[16589] = 0x0000d947150d7601UL;
   tf->codes[16590] = 0x0000d9d2d8683b30UL;
   tf->codes[16591] = 0x0000d9d388154c7fUL;
   tf->codes[16592] = 0x0000dc088806f73dUL;
   tf->codes[16593] = 0x0000dcc2bacb4fa3UL;
   tf->codes[16594] = 0x0000dcc53ef08f1aUL;
   tf->codes[16595] = 0x0000ddbece7625a9UL;
   tf->codes[16596] = 0x0000e22d9c14f44eUL;
   tf->codes[16597] = 0x0000e52077bb53c2UL;
   tf->codes[16598] = 0x0000e6e2ddc6b3f7UL;
   tf->codes[16599] = 0x0000e8285ec7c602UL;
   tf->codes[16600] = 0x0000eb292e828567UL;
   tf->codes[16601] = 0x0000eb6a5fbbf1b8UL;
   tf->codes[16602] = 0x0000ed7ee4586930UL;
   tf->codes[16603] = 0x0000ee05d9f7b536UL;
   tf->codes[16604] = 0x0000ee444c7cdc4bUL;
   tf->codes[16605] = 0x0000ef74c217db8aUL;
   tf->codes[16606] = 0x0000ef7dade1bc8dUL;
   tf->codes[16607] = 0x0000f1ba74d22b75UL;
   tf->codes[16608] = 0x0000f288c8c07f93UL;
   tf->codes[16609] = 0x0000f386b0e383c1UL;
   tf->codes[16610] = 0x0000f52b94dcfbb1UL;
   tf->codes[16611] = 0x0000f57d78df0d2fUL;
   tf->codes[16612] = 0x0000f798da3e31bdUL;
   tf->codes[16613] = 0x0000f7c7bec5d07eUL;
   tf->codes[16614] = 0x0000f8688d86a879UL;
   tf->codes[16615] = 0x0000f96f9c02936fUL;
   tf->codes[16616] = 0x0000f9c737fc352aUL;
   tf->codes[16617] = 0x0000faace0e6d5c6UL;
   tf->codes[16618] = 0x0000ffe325b14b73UL;
   tf->codes[16619] = 0x0000001662d657d3UL;
   tf->codes[16620] = 0x000000b5d23d0d30UL;
   tf->codes[16621] = 0x000001f4b10a77eaUL;
   tf->codes[16622] = 0x00000444e977d13bUL;
   tf->codes[16623] = 0x000008386bf57a19UL;
   tf->codes[16624] = 0x000009644e6405f4UL;
   tf->codes[16625] = 0x000009774ac2e4d3UL;
   tf->codes[16626] = 0x000009fa2253c8ffUL;
   tf->codes[16627] = 0x00000c0a4e52d2d8UL;
   tf->codes[16628] = 0x00000f4aefecdbf0UL;
   tf->codes[16629] = 0x00000f4d398315a2UL;
   tf->codes[16630] = 0x00001006820b56f4UL;
   tf->codes[16631] = 0x0000118b253ea163UL;
   tf->codes[16632] = 0x000013684ea7a4a1UL;
   tf->codes[16633] = 0x000014672106bfe3UL;
   tf->codes[16634] = 0x0000177de663a928UL;
   tf->codes[16635] = 0x000018ea0fcf8a40UL;
   tf->codes[16636] = 0x00001bdceb75e9b4UL;
   tf->codes[16637] = 0x00001be8d08315b8UL;
   tf->codes[16638] = 0x00001d489fc3bf42UL;
   tf->codes[16639] = 0x00001d494f70d091UL;
   tf->codes[16640] = 0x00001e39b89d8058UL;
   tf->codes[16641] = 0x00001ef9a35968fbUL;
   tf->codes[16642] = 0x0000283457f93278UL;
   tf->codes[16643] = 0x00002b7150a2df40UL;
   tf->codes[16644] = 0x00002b8b9ee276bfUL;
   tf->codes[16645] = 0x00002d4b0baa8bf3UL;
   tf->codes[16646] = 0x00002f3d7b08a7c2UL;
   tf->codes[16647] = 0x000031d720cc3d18UL;
   tf->codes[16648] = 0x0000325cf1a06c45UL;
   tf->codes[16649] = 0x000033cbd9c09299UL;
   tf->codes[16650] = 0x000034681554f730UL;
   tf->codes[16651] = 0x0000348bff0b8101UL;
   tf->codes[16652] = 0x000034da3a1d362fUL;
   tf->codes[16653] = 0x000035830a6bd819UL;
   tf->codes[16654] = 0x000039b0a6d13a6dUL;
   tf->codes[16655] = 0x00003a71b6583fe9UL;
   tf->codes[16656] = 0x00003c19939502daUL;
   tf->codes[16657] = 0x00003ce22f8bc6bbUL;
   tf->codes[16658] = 0x00003d0e1ad01a7bUL;
   tf->codes[16659] = 0x00003f50d4471f65UL;
   tf->codes[16660] = 0x0000403224945262UL;
   tf->codes[16661] = 0x00004366a69229b1UL;
   tf->codes[16662] = 0x00004529472c8fabUL;
   tf->codes[16663] = 0x000046789e3399cdUL;
   tf->codes[16664] = 0x000048380afbaf01UL;
   tf->codes[16665] = 0x0000487851f9043eUL;
   tf->codes[16666] = 0x000049be82a72798UL;
   tf->codes[16667] = 0x00004a291affa832UL;
   tf->codes[16668] = 0x00004a5122c499ddUL;
   tf->codes[16669] = 0x00004b86a0aa180aUL;
   tf->codes[16670] = 0x00004fffb96cea50UL;
   tf->codes[16671] = 0x000051dbbe0ad0b5UL;
   tf->codes[16672] = 0x00005426ee2dab18UL;
   tf->codes[16673] = 0x00005509d8640678UL;
   tf->codes[16674] = 0x00005655115ca8c0UL;
   tf->codes[16675] = 0x000057203178ac18UL;
   tf->codes[16676] = 0x00005821c28c0c96UL;
   tf->codes[16677] = 0x00005846967ead7bUL;
   tf->codes[16678] = 0x000059bf8f33d1abUL;
   tf->codes[16679] = 0x00005c9857299f65UL;
   tf->codes[16680] = 0x00005dc6489f5f2dUL;
   tf->codes[16681] = 0x0000611d54f99dafUL;
   tf->codes[16682] = 0x000061f9626d4bf9UL;
   tf->codes[16683] = 0x000062693d9f5146UL;
   tf->codes[16684] = 0x000062b987b83a61UL;
   tf->codes[16685] = 0x000068dab846d55dUL;
   tf->codes[16686] = 0x000068e8e6ea3b13UL;
   tf->codes[16687] = 0x000069685019c8b4UL;
   tf->codes[16688] = 0x00006a1837ba1d79UL;
   tf->codes[16689] = 0x00006aabc213a6d2UL;
   tf->codes[16690] = 0x00006bb888872205UL;
   tf->codes[16691] = 0x00006cc8f7eaf988UL;
   tf->codes[16692] = 0x00006cdf281c292dUL;
   tf->codes[16693] = 0x00006e6b1d302c3cUL;
   tf->codes[16694] = 0x00006e6c076c4350UL;
   tf->codes[16695] = 0x00006ea7bb3d2529UL;
   tf->codes[16696] = 0x00006fb2e7c777f9UL;
   tf->codes[16697] = 0x00007245eb5765feUL;
   tf->codes[16698] = 0x0000741595ca14d5UL;
   tf->codes[16699] = 0x00007592376f9555UL;
   tf->codes[16700] = 0x000075bd3877d201UL;
   tf->codes[16701] = 0x0000768733c8b880UL;
   tf->codes[16702] = 0x0000791b5c23c35eUL;
   tf->codes[16703] = 0x00007b83d3c98041UL;
   tf->codes[16704] = 0x00007d46e981f1c5UL;
   tf->codes[16705] = 0x00007d7a613603eaUL;
   tf->codes[16706] = 0x00007d84e6e90d50UL;
   tf->codes[16707] = 0x00007edbca5fd5d7UL;
   tf->codes[16708] = 0x00007fb294f9ff6eUL;
   tf->codes[16709] = 0x00008052b40dc61aUL;
   tf->codes[16710] = 0x00008092fb0b1b57UL;
   tf->codes[16711] = 0x000081927d1747e8UL;
   tf->codes[16712] = 0x000082037d146a0eUL;
   tf->codes[16713] = 0x00008522f3ac2e91UL;
   tf->codes[16714] = 0x000087bd491cd536UL;
   tf->codes[16715] = 0x000087f5c91b6649UL;
   tf->codes[16716] = 0x00008995df596510UL;
   tf->codes[16717] = 0x000089dffc5cb264UL;
   tf->codes[16718] = 0x000089f2f8bb9143UL;
   tf->codes[16719] = 0x00008ab52d0db398UL;
   tf->codes[16720] = 0x00008b18e8a3871cUL;
   tf->codes[16721] = 0x00008c9c670bb4b2UL;
   tf->codes[16722] = 0x00008d1a365219f0UL;
   tf->codes[16723] = 0x00008fa95662a5e0UL;
   tf->codes[16724] = 0x00009549be67909dUL;
   tf->codes[16725] = 0x000095dac49bda7fUL;
   tf->codes[16726] = 0x00009a6f5069611dUL;
   tf->codes[16727] = 0x00009cc20cfbf9e5UL;
   tf->codes[16728] = 0x00009cd9d71651edUL;
   tf->codes[16729] = 0x00009d255373c1dfUL;
   tf->codes[16730] = 0x0000a09b06ab057fUL;
   tf->codes[16731] = 0x0000a103ca8b57f1UL;
   tf->codes[16732] = 0x0000a1b07e595bf0UL;
   tf->codes[16733] = 0x0000a23f3af76c20UL;
   tf->codes[16734] = 0x0000a4149d61ab34UL;
   tf->codes[16735] = 0x0000a5250cc582b7UL;
   tf->codes[16736] = 0x0000a70779080aa8UL;
   tf->codes[16737] = 0x0000a75872ce0512UL;
   tf->codes[16738] = 0x0000a7e85437321bUL;
   tf->codes[16739] = 0x0000a8a62febe6d1UL;
   tf->codes[16740] = 0x0000a918c9d2315aUL;
   tf->codes[16741] = 0x0000aa4c38b07b9aUL;
   tf->codes[16742] = 0x0000add1b4744d53UL;
   tf->codes[16743] = 0x0000add3c37b8140UL;
   tf->codes[16744] = 0x0000ae58aa139959UL;
   tf->codes[16745] = 0x0000b1856512ac7eUL;
   tf->codes[16746] = 0x0000b242cba955aaUL;
   tf->codes[16747] = 0x0000b27d202014e5UL;
   tf->codes[16748] = 0x0000b2b77496d420UL;
   tf->codes[16749] = 0x0000b3add04a19e9UL;
   tf->codes[16750] = 0x0000b434163c54a0UL;
   tf->codes[16751] = 0x0000b6c24c10c97cUL;
   tf->codes[16752] = 0x0000b6d45e339147UL;
   tf->codes[16753] = 0x0000b76529d8d564UL;
   tf->codes[16754] = 0x0000b796cd14b961UL;
   tf->codes[16755] = 0x0000b7bcc5d2771fUL;
   tf->codes[16756] = 0x0000b83468034096UL;
   tf->codes[16757] = 0x0000b86cad72cbe4UL;
   tf->codes[16758] = 0x0000b875241ea15dUL;
   tf->codes[16759] = 0x0000bbafd3321473UL;
   tf->codes[16760] = 0x0000bbc79d4c6c7bUL;
   tf->codes[16761] = 0x0000bcb50d35d141UL;
   tf->codes[16762] = 0x0000bdea508c49a9UL;
   tf->codes[16763] = 0x0000bf40f9740c6bUL;
   tf->codes[16764] = 0x0000c1c7dd67c8a7UL;
   tf->codes[16765] = 0x0000c1ff389b3ce1UL;
   tf->codes[16766] = 0x0000c38bdd5c513fUL;
   tf->codes[16767] = 0x0000c3a073a45881UL;
   tf->codes[16768] = 0x0000c3fcdd597365UL;
   tf->codes[16769] = 0x0000c5c326e435afUL;
   tf->codes[16770] = 0x0000cdf7f1d3310fUL;
   tf->codes[16771] = 0x0000d2cf0e34469cUL;
   tf->codes[16772] = 0x0000d365cc6020bbUL;
   tf->codes[16773] = 0x0000d3bc08ff9fd8UL;
   tf->codes[16774] = 0x0000d4e0246f6789UL;
   tf->codes[16775] = 0x0000dc8bb028dd31UL;
   tf->codes[16776] = 0x0000dd2567980251UL;
   tf->codes[16777] = 0x0000eafe7e0b4a83UL;
   tf->codes[16778] = 0x0000eb2267c1d454UL;
   tf->codes[16779] = 0x0000ec5c78d3c5e5UL;
   tf->codes[16780] = 0x0000edba390d3b82UL;
   tf->codes[16781] = 0x0000edbff104cbbfUL;
   tf->codes[16782] = 0x0000ef84a0a665a6UL;
   tf->codes[16783] = 0x0000f145a757a33dUL;
   tf->codes[16784] = 0x0000f4f3da8d77f0UL;
   tf->codes[16785] = 0x00000044e841e70dUL;
   tf->codes[16786] = 0x00000634b023a3d1UL;
   tf->codes[16787] = 0x0000094966795929UL;
   tf->codes[16788] = 0x00000993be0bac42UL;
   tf->codes[16789] = 0x00000aff725981d0UL;
   tf->codes[16790] = 0x00000be939528a46UL;
   tf->codes[16791] = 0x00000e2ca276a07fUL;
   tf->codes[16792] = 0x000010951a1c5d62UL;
   tf->codes[16793] = 0x000011dcaa24a35aUL;
   tf->codes[16794] = 0x0000122fed80d776UL;
   tf->codes[16795] = 0x0000125c135430fbUL;
   tf->codes[16796] = 0x00001492e7be09e1UL;
   tf->codes[16797] = 0x000016cc7adc2803UL;
   tf->codes[16798] = 0x00001793425abdbcUL;
   tf->codes[16799] = 0x00001807010c251eUL;
   tf->codes[16800] = 0x000019d586b3b71cUL;
   tf->codes[16801] = 0x00001b397402c880UL;
   tf->codes[16802] = 0x00001e5b3430c6b5UL;
   tf->codes[16803] = 0x000020181cd39c72UL;
   tf->codes[16804] = 0x0000217cf45ec4eaUL;
   tf->codes[16805] = 0x000025323ee64c78UL;
   tf->codes[16806] = 0x00002665adc496b8UL;
   tf->codes[16807] = 0x000027b3305372b2UL;
   tf->codes[16808] = 0x00002adae30806e9UL;
   tf->codes[16809] = 0x00002cc884aaa98fUL;
   tf->codes[16810] = 0x00002d874a9b7559UL;
   tf->codes[16811] = 0x00002dd87ef07588UL;
   tf->codes[16812] = 0x00002e5822af08eeUL;
   tf->codes[16813] = 0x00002ef0b5531135UL;
   tf->codes[16814] = 0x00002f05110c12b2UL;
   tf->codes[16815] = 0x00003118364e678cUL;
   tf->codes[16816] = 0x0000320a39643fb6UL;
   tf->codes[16817] = 0x000032fb523e00ccUL;
   tf->codes[16818] = 0x000039ad4e71dfe5UL;
   tf->codes[16819] = 0x00003da4eefdf09dUL;
   tf->codes[16820] = 0x00003ddb256647feUL;
   tf->codes[16821] = 0x00003e33367df543UL;
   tf->codes[16822] = 0x00003e908a6f273bUL;
   tf->codes[16823] = 0x000040114a230f95UL;
   tf->codes[16824] = 0x000040f2d4ff4857UL;
   tf->codes[16825] = 0x00004106467c32c0UL;
   tf->codes[16826] = 0x0000413b92a8730dUL;
   tf->codes[16827] = 0x0000414777b59f11UL;
   tf->codes[16828] = 0x00004493fe5cd42dUL;
   tf->codes[16829] = 0x00004817a5a877beUL;
   tf->codes[16830] = 0x00004a1a1822276bUL;
   tf->codes[16831] = 0x00004d1c4737096eUL;
   tf->codes[16832] = 0x00004d587025f6d1UL;
   tf->codes[16833] = 0x00005061b68c8bafUL;
   tf->codes[16834] = 0x0000530a3aa0980aUL;
   tf->codes[16835] = 0x00005346d8ad90f7UL;
   tf->codes[16836] = 0x0000550470fd7803UL;
   tf->codes[16837] = 0x000055b124cb7c02UL;
   tf->codes[16838] = 0x00005642daacd733UL;
   tf->codes[16839] = 0x000057f418d186b1UL;
   tf->codes[16840] = 0x0000581b70e9670dUL;
   tf->codes[16841] = 0x00005d0bb6bef740UL;
   tf->codes[16842] = 0x00005de8ae6ebc9eUL;
   tf->codes[16843] = 0x00005ed39a32e1edUL;
   tf->codes[16844] = 0x00005f3d82de5138UL;
   tf->codes[16845] = 0x00005ff1136f024dUL;
   tf->codes[16846] = 0x00005ff7f031af63UL;
   tf->codes[16847] = 0x000060beb7b0451cUL;
   tf->codes[16848] = 0x0000623cb8afe83aUL;
   tf->codes[16849] = 0x000062e49ec27310UL;
   tf->codes[16850] = 0x000063da1039a1c5UL;
   tf->codes[16851] = 0x00006547d38eab40UL;
   tf->codes[16852] = 0x0000661786d721fcUL;
   tf->codes[16853] = 0x000069bdf30e3285UL;
   tf->codes[16854] = 0x00006b092c06d4cdUL;
   tf->codes[16855] = 0x00006dd0cc15f1d0UL;
   tf->codes[16856] = 0x00006f2bcd9b2231UL;
   tf->codes[16857] = 0x0000702ce9907725UL;
   tf->codes[16858] = 0x000071759e63d9f6UL;
   tf->codes[16859] = 0x0000720a4d888028UL;
   tf->codes[16860] = 0x0000736c665f6364UL;
   tf->codes[16861] = 0x00007670a47b7954UL;
   tf->codes[16862] = 0x0000772977e5af1cUL;
   tf->codes[16863] = 0x0000778e58469f79UL;
   tf->codes[16864] = 0x00007794103e2fb6UL;
   tf->codes[16865] = 0x000078a1fb7cc7c2UL;
   tf->codes[16866] = 0x0000797641f1b1e2UL;
   tf->codes[16867] = 0x00007b671766a54eUL;
   tf->codes[16868] = 0x00007c294bb8c7a3UL;
   tf->codes[16869] = 0x00007c39144555bcUL;
   tf->codes[16870] = 0x00007d1fa76c0d6cUL;
   tf->codes[16871] = 0x00007d33c8960924UL;
   tf->codes[16872] = 0x00007e5893b2e224UL;
   tf->codes[16873] = 0x00007f7179c28f20UL;
   tf->codes[16874] = 0x000080972f1b7f34UL;
   tf->codes[16875] = 0x000080eae795bedaUL;
   tf->codes[16876] = 0x000080ff08bfba92UL;
   tf->codes[16877] = 0x0000828d0cdaf18eUL;
   tf->codes[16878] = 0x000082e0c5553134UL;
   tf->codes[16879] = 0x0000833a35c70117UL;
   tf->codes[16880] = 0x000083b6e042497cUL;
   tf->codes[16881] = 0x0000853172e0960fUL;
   tf->codes[16882] = 0x000086e0dc8d1765UL;
   tf->codes[16883] = 0x000087215e197267UL;
   tf->codes[16884] = 0x000088e0905281d6UL;
   tf->codes[16885] = 0x0000892b2273dab4UL;
   tf->codes[16886] = 0x0000897a47c1a6f6UL;
   tf->codes[16887] = 0x00008a97fb8ccd1bUL;
   tf->codes[16888] = 0x00008a99d004fb43UL;
   tf->codes[16889] = 0x00008b0d54275ce0UL;
   tf->codes[16890] = 0x00008eb6f430be2fUL;
   tf->codes[16891] = 0x000090105bccc62dUL;
   tf->codes[16892] = 0x000090e5c70ccd26UL;
   tf->codes[16893] = 0x000090ebb9936328UL;
   tf->codes[16894] = 0x00009202560cd672UL;
   tf->codes[16895] = 0x0000943fccaa56a9UL;
   tf->codes[16896] = 0x0000959a1e8275bbUL;
   tf->codes[16897] = 0x00009872abe93db0UL;
   tf->codes[16898] = 0x0000989cfd44690dUL;
   tf->codes[16899] = 0x00009c2cc42c3e67UL;
   tf->codes[16900] = 0x00009c7f1d4c5b6fUL;
   tf->codes[16901] = 0x00009cf3168cc896UL;
   tf->codes[16902] = 0x00009f3f6b7abfd2UL;
   tf->codes[16903] = 0x00009ff420d68dc0UL;
   tf->codes[16904] = 0x0000a05a9b20a680UL;
   tf->codes[16905] = 0x0000a066f54bde0eUL;
   tf->codes[16906] = 0x0000a1062a238da6UL;
   tf->codes[16907] = 0x0000a304f3ace103UL;
   tf->codes[16908] = 0x0000a596d271b22fUL;
   tf->codes[16909] = 0x0000a89d5a2401d1UL;
   tf->codes[16910] = 0x0000ab15d4e55292UL;
   tf->codes[16911] = 0x0000ac9e2108f951UL;
   tf->codes[16912] = 0x0000afc140911a24UL;
   tf->codes[16913] = 0x0000b1683391c601UL;
   tf->codes[16914] = 0x0000b1903b56b7acUL;
   tf->codes[16915] = 0x0000b1deeb867864UL;
   tf->codes[16916] = 0x0000b28830f325d8UL;
   tf->codes[16917] = 0x0000b2aaf5de92d0UL;
   tf->codes[16918] = 0x0000b2aba58ba41fUL;
   tf->codes[16919] = 0x0000b39c494759abUL;
   tf->codes[16920] = 0x0000b3f6de844667UL;
   tf->codes[16921] = 0x0000b554d94cc1c9UL;
   tf->codes[16922] = 0x0000b587dbe2c864UL;
   tf->codes[16923] = 0x0000b8ab35f9eefcUL;
   tf->codes[16924] = 0x0000b8ec67335b4dUL;
   tf->codes[16925] = 0x0000bbae89d9edd8UL;
   tf->codes[16926] = 0x0000bc169e0d2efbUL;
   tf->codes[16927] = 0x0000bc9d93ac7b01UL;
   tf->codes[16928] = 0x0000bd4c1bf2ad28UL;
   tf->codes[16929] = 0x0000bd8ac906da02UL;
   tf->codes[16930] = 0x0000bda21e032680UL;
   tf->codes[16931] = 0x0000bea424349288UL;
   tf->codes[16932] = 0x0000bff9a8513871UL;
   tf->codes[16933] = 0x0000c051b968e5b6UL;
   tf->codes[16934] = 0x0000c10549f996cbUL;
   tf->codes[16935] = 0x0000c13b0b43e2a2UL;
   tf->codes[16936] = 0x0000c220eebd8903UL;
   tf->codes[16937] = 0x0000c286f3e99639UL;
   tf->codes[16938] = 0x0000c2ccb84f75eeUL;
   tf->codes[16939] = 0x0000c37a56599101UL;
   tf->codes[16940] = 0x0000c398c2a7905aUL;
   tf->codes[16941] = 0x0000c535dfa24420UL;
   tf->codes[16942] = 0x0000c5611b398691UL;
   tf->codes[16943] = 0x0000c5f67a0b3e12UL;
   tf->codes[16944] = 0x0000c60050113629UL;
   tf->codes[16945] = 0x0000c68cfda8126cUL;
   tf->codes[16946] = 0x0000c7e1226a95b7UL;
   tf->codes[16947] = 0x0000c8c32264da03UL;
   tf->codes[16948] = 0x0000c9174ffd2533UL;
   tf->codes[16949] = 0x0000ca13d8c606c3UL;
   tf->codes[16950] = 0x0000cb1fb4fd6ae2UL;
   tf->codes[16951] = 0x0000cb64c9b63948UL;
   tf->codes[16952] = 0x0000cb73e295b612UL;
   tf->codes[16953] = 0x0000cba008690f97UL;
   tf->codes[16954] = 0x0000cc1058b9206eUL;
   tf->codes[16955] = 0x0000cf793ca720f6UL;
   tf->codes[16956] = 0x0000d0295ed67b80UL;
   tf->codes[16957] = 0x0000d0cefb52cca4UL;
   tf->codes[16958] = 0x0000d116cebfe046UL;
   tf->codes[16959] = 0x0000d11cc1467648UL;
   tf->codes[16960] = 0x0000d30cac7f52a0UL;
   tf->codes[16961] = 0x0000d487eecab082UL;
   tf->codes[16962] = 0x0000d4bbdb9cce31UL;
   tf->codes[16963] = 0x0000d59fb00f40a5UL;
   tf->codes[16964] = 0x0000d5a8d668276dUL;
   tf->codes[16965] = 0x0000d6813aeb7967UL;
   tf->codes[16966] = 0x0000d78f60b91738UL;
   tf->codes[16967] = 0x0000d9ec686fb3a1UL;
   tf->codes[16968] = 0x0000dbd501c7d759UL;
   tf->codes[16969] = 0x0000e11ad48fd55aUL;
   tf->codes[16970] = 0x0000e7991e809c89UL;
   tf->codes[16971] = 0x0000e86b1b5f4cf7UL;
   tf->codes[16972] = 0x0000ebab47db4a85UL;
   tf->codes[16973] = 0x0000ec240ed730d5UL;
   tf->codes[16974] = 0x0000ec5e634df010UL;
   tf->codes[16975] = 0x0000eda5f3563608UL;
   tf->codes[16976] = 0x0000ede1a72717e1UL;
   tf->codes[16977] = 0x0000f2123ccfc536UL;
   tf->codes[16978] = 0x0000f30e8b09a101UL;
   tf->codes[16979] = 0x0000f5a621c6026aUL;
   tf->codes[16980] = 0x0000f661b3e47d6eUL;
   tf->codes[16981] = 0x00000520add16c01UL;
   tf->codes[16982] = 0x000005e0d31c5a69UL;
   tf->codes[16983] = 0x00000849fa6f289bUL;
   tf->codes[16984] = 0x00000855a4ed4edaUL;
   tf->codes[16985] = 0x000008e6e5b09e81UL;
   tf->codes[16986] = 0x00000bf7f315f789UL;
   tf->codes[16987] = 0x00000ccd23c6f8bdUL;
   tf->codes[16988] = 0x00000ddfa232042dUL;
   tf->codes[16989] = 0x000011e1535312c1UL;
   tf->codes[16990] = 0x00001511b7428236UL;
   tf->codes[16991] = 0x0000151fab56e227UL;
   tf->codes[16992] = 0x0000182339c5e6c8UL;
   tf->codes[16993] = 0x00001b24f3bcbd41UL;
   tf->codes[16994] = 0x00001b3272b311a8UL;
   tf->codes[16995] = 0x00001b753dd5a65cUL;
   tf->codes[16996] = 0x00001c58629b0781UL;
   tf->codes[16997] = 0x00001d9e1e2b1f51UL;
   tf->codes[16998] = 0x000020bbc04ab5acUL;
   tf->codes[16999] = 0x000021b42b052f62UL;
   tf->codes[17000] = 0x000023aa4353a781UL;
   tf->codes[17001] = 0x000023e24e342d0aUL;
   tf->codes[17002] = 0x0000271d37d6a5e5UL;
   tf->codes[17003] = 0x0000291aa205d6a4UL;
   tf->codes[17004] = 0x0000298992fbc4ddUL;
   tf->codes[17005] = 0x00002e3d3ac45c23UL;
   tf->codes[17006] = 0x00002fdb076c2138UL;
   tf->codes[17007] = 0x00003197f00ef6f5UL;
   tf->codes[17008] = 0x0000328d26f71fe5UL;
   tf->codes[17009] = 0x000032c4822a941fUL;
   tf->codes[17010] = 0x000035f052ed9030UL;
   tf->codes[17011] = 0x000039860c5bfb8cUL;
   tf->codes[17012] = 0x000039a269a2c6f8UL;
   tf->codes[17013] = 0x00003dbdf3e56181UL;
   tf->codes[17014] = 0x00003e590aaea93fUL;
   tf->codes[17015] = 0x00003fb48151e52aUL;
   tf->codes[17016] = 0x00003ff2099af52bUL;
   tf->codes[17017] = 0x0000402a8999863eUL;
   tf->codes[17018] = 0x0000403b76f13130UL;
   tf->codes[17019] = 0x000041dd2718585aUL;
   tf->codes[17020] = 0x000042fd2479b831UL;
   tf->codes[17021] = 0x00004534337296dcUL;
   tf->codes[17022] = 0x0000463dc613c149UL;
   tf->codes[17023] = 0x00004643437c4bc1UL;
   tf->codes[17024] = 0x000046f992c14212UL;
   tf->codes[17025] = 0x000049e6f0ff170eUL;
   tf->codes[17026] = 0x00004b543f3614ffUL;
   tf->codes[17027] = 0x00004ca829699285UL;
   tf->codes[17028] = 0x00004e8761d9c9b0UL;
   tf->codes[17029] = 0x0000500562d96cceUL;
   tf->codes[17030] = 0x0000513aa62fe536UL;
   tf->codes[17031] = 0x000052a65a7dbac4UL;
   tf->codes[17032] = 0x000053175a7adceaUL;
   tf->codes[17033] = 0x00005463f2cda1d0UL;
   tf->codes[17034] = 0x0000559d19a37c4dUL;
   tf->codes[17035] = 0x000056cc6a735eb3UL;
   tf->codes[17036] = 0x00005887f3bc11d2UL;
   tf->codes[17037] = 0x00005952d9490f65UL;
   tf->codes[17038] = 0x0000597cb5862f38UL;
   tf->codes[17039] = 0x00005ad7b70b5f99UL;
   tf->codes[17040] = 0x00005b1455185886UL;
   tf->codes[17041] = 0x00005b1d40e23989UL;
   tf->codes[17042] = 0x00005cd1784a3408UL;
   tf->codes[17043] = 0x00005d707292dddbUL;
   tf->codes[17044] = 0x000061f44b97bf4cUL;
   tf->codes[17045] = 0x000062070d679866UL;
   tf->codes[17046] = 0x0000628fd77f1294UL;
   tf->codes[17047] = 0x000062a5929236afUL;
   tf->codes[17048] = 0x0000637d4768775aUL;
   tf->codes[17049] = 0x00006659f2dda729UL;
   tf->codes[17050] = 0x000067179403561aUL;
   tf->codes[17051] = 0x0000687e4006acbaUL;
   tf->codes[17052] = 0x0000687fd9efd51dUL;
   tf->codes[17053] = 0x000068cd2ac57337UL;
   tf->codes[17054] = 0x000069d906fcd756UL;
   tf->codes[17055] = 0x00006b69c9cc538eUL;
   tf->codes[17056] = 0x00006b6e2269c12dUL;
   tf->codes[17057] = 0x00006b76d3a49c6bUL;
   tf->codes[17058] = 0x00006c3c7658154bUL;
   tf->codes[17059] = 0x00006f7f26f95250UL;
   tf->codes[17060] = 0x00007047fd7f1bf6UL;
   tf->codes[17061] = 0x000070a292bc08b2UL;
   tf->codes[17062] = 0x000071669b86592fUL;
   tf->codes[17063] = 0x0000718074a7e524UL;
   tf->codes[17064] = 0x0000724651ea63c9UL;
   tf->codes[17065] = 0x000072cafdf3761dUL;
   tf->codes[17066] = 0x0000740b76aa093aUL;
   tf->codes[17067] = 0x0000756bf597c413UL;
   tf->codes[17068] = 0x000077e903858838UL;
   tf->codes[17069] = 0x000078482beee858UL;
   tf->codes[17070] = 0x000078dca08488c5UL;
   tf->codes[17071] = 0x00007bc1fd3493d2UL;
   tf->codes[17072] = 0x00007becfe3cd07eUL;
   tf->codes[17073] = 0x00007d4c92ee7443UL;
   tf->codes[17074] = 0x00007f8f86f47ef2UL;
   tf->codes[17075] = 0x0000802f30ea3a14UL;
   tf->codes[17076] = 0x0000813ad292986eUL;
   tf->codes[17077] = 0x000083d22ebff412UL;
   tf->codes[17078] = 0x000085dc2da96224UL;
   tf->codes[17079] = 0x000086870cff37fbUL;
   tf->codes[17080] = 0x00008ab3bf28833bUL;
   tf->codes[17081] = 0x00008ae4030a449aUL;
   tf->codes[17082] = 0x00008e4b879e2284UL;
   tf->codes[17083] = 0x000090592f77ece6UL;
   tf->codes[17084] = 0x0000906e3addffb2UL;
   tf->codes[17085] = 0x000090faade5d630UL;
   tf->codes[17086] = 0x00009277c4a9623aUL;
   tf->codes[17087] = 0x000092bd13f13665UL;
   tf->codes[17088] = 0x000092d79cbfd3a9UL;
   tf->codes[17089] = 0x000092fa61ab40a1UL;
   tf->codes[17090] = 0x00009448ce7633afUL;
   tf->codes[17091] = 0x000094647c0fedccUL;
   tf->codes[17092] = 0x00009549ea6b88a3UL;
   tf->codes[17093] = 0x000095effc05e551UL;
   tf->codes[17094] = 0x00009956965dac27UL;
   tf->codes[17095] = 0x00009bae95c9c9a2UL;
   tf->codes[17096] = 0x00009dce8a556194UL;
   tf->codes[17097] = 0x00009e1c50490b38UL;
   tf->codes[17098] = 0x00009fe642c429d2UL;
   tf->codes[17099] = 0x0000a08c8eed8c45UL;
   tf->codes[17100] = 0x0000a2116cafdc79UL;
   tf->codes[17101] = 0x0000a34a1e67ab6cUL;
   tf->codes[17102] = 0x0000a7a3a6116180UL;
   tf->codes[17103] = 0x0000a81b48422af7UL;
   tf->codes[17104] = 0x0000a8fea79691e1UL;
   tf->codes[17105] = 0x0000a90cd639f797UL;
   tf->codes[17106] = 0x0000ac2ed0f6fb91UL;
   tf->codes[17107] = 0x0000acb551783c0dUL;
   tf->codes[17108] = 0x0000ad7af42bb4edUL;
   tf->codes[17109] = 0x0000adcfd171116cUL;
   tf->codes[17110] = 0x0000ae0767338b6bUL;
   tf->codes[17111] = 0x0000b07fe1f4dc2cUL;
   tf->codes[17112] = 0x0000b141a128f2f7UL;
   tf->codes[17113] = 0x0000b15a1af05c4eUL;
   tf->codes[17114] = 0x0000b15c29f7903bUL;
   tf->codes[17115] = 0x0000b2e9b8f4bbadUL;
   tf->codes[17116] = 0x0000b37df2fb5655UL;
   tf->codes[17117] = 0x0000b7f830894574UL;
   tf->codes[17118] = 0x0000b8357e434fb0UL;
   tf->codes[17119] = 0x0000b9c138c84cfaUL;
   tf->codes[17120] = 0x0000baf30dbd6ed7UL;
   tf->codes[17121] = 0x0000bb101ab14b92UL;
   tf->codes[17122] = 0x0000bb63237e79e9UL;
   tf->codes[17123] = 0x0000bd3d19152c61UL;
   tf->codes[17124] = 0x0000be2162a5aa5fUL;
   tf->codes[17125] = 0x0000be872d42b1d0UL;
   tf->codes[17126] = 0x0000becb57bf6922UL;
   tf->codes[17127] = 0x0000c00911c1b703UL;
   tf->codes[17128] = 0x0000c0311986a8aeUL;
   tf->codes[17129] = 0x0000c142e844a2cfUL;
   tf->codes[17130] = 0x0000c1bc997ca033UL;
   tf->codes[17131] = 0x0000c1fc6b5be9e6UL;
   tf->codes[17132] = 0x0000c415f842e04cUL;
   tf->codes[17133] = 0x0000c4517184bc60UL;
   tf->codes[17134] = 0x0000c49cb353268dUL;
   tf->codes[17135] = 0x0000c57d19644276UL;
   tf->codes[17136] = 0x0000c69e761fc4ebUL;
   tf->codes[17137] = 0x0000c6b1ad0da98fUL;
   tf->codes[17138] = 0x0000c7444d2b1bd4UL;
   tf->codes[17139] = 0x0000c74dae130861UL;
   tf->codes[17140] = 0x0000c7be738124c2UL;
   tf->codes[17141] = 0x0000ca284a810443UL;
   tf->codes[17142] = 0x0000cb8052c2e9a3UL;
   tf->codes[17143] = 0x0000cba6c09eb2ebUL;
   tf->codes[17144] = 0x0000cd9c9e5e2545UL;
   tf->codes[17145] = 0x0000ce6deb8fc464UL;
   tf->codes[17146] = 0x0000cfcedf9b8ac7UL;
   tf->codes[17147] = 0x0000d097b621546dUL;
   tf->codes[17148] = 0x0000d0ba407dbba0UL;
   tf->codes[17149] = 0x0000d0db6b800035UL;
   tf->codes[17150] = 0x0000d1c35e00da83UL;
   tf->codes[17151] = 0x0000d3b383c8bca0UL;
   tf->codes[17152] = 0x0000d46873b39053UL;
   tf->codes[17153] = 0x0000d4beeae21535UL;
   tf->codes[17154] = 0x0000d6468758aaa5UL;
   tf->codes[17155] = 0x0000d667b25aef3aUL;
   tf->codes[17156] = 0x0000dd5b8f754bf3UL;
   tf->codes[17157] = 0x0000e7a2204c798fUL;
   tf->codes[17158] = 0x0000e8a167c9a05bUL;
   tf->codes[17159] = 0x0000ebce5d57b945UL;
   tf->codes[17160] = 0x0000ec3c9ea0962fUL;
   tf->codes[17161] = 0x0000ef7e6505bc20UL;
   tf->codes[17162] = 0x0000efd3f1f829eeUL;
   tf->codes[17163] = 0x0000f0edc243edfeUL;
   tf->codes[17164] = 0x0000f14ebf257c46UL;
   tf->codes[17165] = 0x0000f1661421c8c4UL;
   tf->codes[17166] = 0x0000fceb83c6611aUL;
   tf->codes[17167] = 0x0000fd7ed390e4aeUL;
   tf->codes[17168] = 0x0000fdc756ab099fUL;
   tf->codes[17169] = 0x0000ff7fac216bf8UL;
   tf->codes[17170] = 0x0000013751eabd02UL;
   tf->codes[17171] = 0x0000022412271079UL;
   tf->codes[17172] = 0x000002c4a658e2afUL;
   tf->codes[17173] = 0x00000bd1261e1ebaUL;
   tf->codes[17174] = 0x00000d4ace805439UL;
   tf->codes[17175] = 0x00000d8bc52abac5UL;
   tf->codes[17176] = 0x00000f83ec8066d1UL;
   tf->codes[17177] = 0x00001125d73693c0UL;
   tf->codes[17178] = 0x000012ac14530692UL;
   tf->codes[17179] = 0x000013a0d61d23f8UL;
   tf->codes[17180] = 0x000014b9bc2cd0f4UL;
   tf->codes[17181] = 0x0000155806c86978UL;
   tf->codes[17182] = 0x00001813fc59603cUL;
   tf->codes[17183] = 0x0000185d69af9c41UL;
   tf->codes[17184] = 0x0000190cdc31e57cUL;
   tf->codes[17185] = 0x00001a7f32b3625bUL;
   tf->codes[17186] = 0x00001b946fd2b307UL;
   tf->codes[17187] = 0x00001c0f0b46c77fUL;
   tf->codes[17188] = 0x00001cb900608642UL;
   tf->codes[17189] = 0x00001e45a5219aa0UL;
   tf->codes[17190] = 0x00001fbe6347b90bUL;
   tf->codes[17191] = 0x000020d5e9fd4369UL;
   tf->codes[17192] = 0x000021349d4897ffUL;
   tf->codes[17193] = 0x0000255c47276451UL;
   tf->codes[17194] = 0x0000260810b9513cUL;
   tf->codes[17195] = 0x0000263595e6cd5fUL;
   tf->codes[17196] = 0x0000274bf7d13ae4UL;
   tf->codes[17197] = 0x0000275349b1f384UL;
   tf->codes[17198] = 0x000027681a89008bUL;
   tf->codes[17199] = 0x000029d1074cc8f8UL;
   tf->codes[17200] = 0x00002a70ebd189dfUL;
   tf->codes[17201] = 0x00002b561f9e1ef1UL;
   tf->codes[17202] = 0x0000353bb393be45UL;
   tf->codes[17203] = 0x0000356380c9aa2bUL;
   tf->codes[17204] = 0x000035decbeacff2UL;
   tf->codes[17205] = 0x000038e7d7c25f0bUL;
   tf->codes[17206] = 0x0000391a2aab5457UL;
   tf->codes[17207] = 0x000039d45d6facbdUL;
   tf->codes[17208] = 0x00003bbfb57c15b1UL;
   tf->codes[17209] = 0x00003d75fbeb441dUL;
   tf->codes[17210] = 0x00003f0aa23a226aUL;
   tf->codes[17211] = 0x00003f48da3043baUL;
   tf->codes[17212] = 0x0000409a7acd878eUL;
   tf->codes[17213] = 0x0000416e1195605fUL;
   tf->codes[17214] = 0x0000427769a78507UL;
   tf->codes[17215] = 0x0000430d78264dd7UL;
   tf->codes[17216] = 0x0000439139f34917UL;
   tf->codes[17217] = 0x0000440a00ef2f67UL;
   tf->codes[17218] = 0x0000451826bccd38UL;
   tf->codes[17219] = 0x0000454ff70e4cfcUL;
   tf->codes[17220] = 0x00004af860a101a8UL;
   tf->codes[17221] = 0x00004b094df8ac9aUL;
   tf->codes[17222] = 0x00005148ead546efUL;
   tf->codes[17223] = 0x000051debec509faUL;
   tf->codes[17224] = 0x00005258aa8c0d23UL;
   tf->codes[17225] = 0x000052d4a55a4439UL;
   tf->codes[17226] = 0x0000537af183a6acUL;
   tf->codes[17227] = 0x0000541f6934daf7UL;
   tf->codes[17228] = 0x000055e9d0ce051bUL;
   tf->codes[17229] = 0x00005727c55f58c1UL;
   tf->codes[17230] = 0x000057fe1adb76ceUL;
   tf->codes[17231] = 0x0000585b343da301UL;
   tf->codes[17232] = 0x000059857cc30679UL;
   tf->codes[17233] = 0x000059a0b53eb50cUL;
   tf->codes[17234] = 0x00005d3a179d7cb8UL;
   tf->codes[17235] = 0x00006373c1f3810bUL;
   tf->codes[17236] = 0x000063860ea54e9bUL;
   tf->codes[17237] = 0x00006699dabeecdfUL;
   tf->codes[17238] = 0x00006885e2786722UL;
   tf->codes[17239] = 0x00006d2a36d27bd9UL;
   tf->codes[17240] = 0x00006e9500e43a53UL;
   tf->codes[17241] = 0x00006eb7c5cfa74bUL;
   tf->codes[17242] = 0x00007054e2ca5b11UL;
   tf->codes[17243] = 0x000071aadc050c84UL;
   tf->codes[17244] = 0x000077fa7bfd3ab7UL;
   tf->codes[17245] = 0x0000796cd27eb796UL;
   tf->codes[17246] = 0x00007ad8c15b92e9UL;
   tf->codes[17247] = 0x00007b16bec2ae74UL;
   tf->codes[17248] = 0x00007b24b2d70e65UL;
   tf->codes[17249] = 0x00007d07cec6a7a5UL;
   tf->codes[17250] = 0x00007e4ee9b0e213UL;
   tf->codes[17251] = 0x00007e6bf6a4beceUL;
   tf->codes[17252] = 0x00007e93894ba4efUL;
   tf->codes[17253] = 0x00007ecb599d24b3UL;
   tf->codes[17254] = 0x00007fcb8b566293UL;
   tf->codes[17255] = 0x00008113907cb415UL;
   tf->codes[17256] = 0x0000856bf35b4d50UL;
   tf->codes[17257] = 0x000085b092f6102cUL;
   tf->codes[17258] = 0x0000869eb28c8641UL;
   tf->codes[17259] = 0x000088dc63b90c3dUL;
   tf->codes[17260] = 0x000089877d9de7d9UL;
   tf->codes[17261] = 0x000089da866b1630UL;
   tf->codes[17262] = 0x00008ab02c3a22eeUL;
   tf->codes[17263] = 0x00008b12fd93df5eUL;
   tf->codes[17264] = 0x00008bc0d62d0036UL;
   tf->codes[17265] = 0x00008bf2044ad8a9UL;
   tf->codes[17266] = 0x00008dba224dc91bUL;
   tf->codes[17267] = 0x000091446bcd13fdUL;
   tf->codes[17268] = 0x000092bbca990fcaUL;
   tf->codes[17269] = 0x000094aa5677c984UL;
   tf->codes[17270] = 0x0000954c8492c41dUL;
   tf->codes[17271] = 0x000095fa5d2be4f5UL;
   tf->codes[17272] = 0x00009bc1330c98faUL;
   tf->codes[17273] = 0x00009dfcd531eb09UL;
   tf->codes[17274] = 0x00009e6bc627d942UL;
   tf->codes[17275] = 0x00009f1afe1b1cb8UL;
   tf->codes[17276] = 0x00009fc47e16cff1UL;
   tf->codes[17277] = 0x00009fc73ccb152dUL;
   tf->codes[17278] = 0x0000a16b71177bceUL;
   tf->codes[17279] = 0x0000a2a3adb13f37UL;
   tf->codes[17280] = 0x0000a3a2ba9f603eUL;
   tf->codes[17281] = 0x0000a465d92d99a7UL;
   tf->codes[17282] = 0x0000a557dc4371d1UL;
   tf->codes[17283] = 0x0000a69f31bcb204UL;
   tf->codes[17284] = 0x0000a7bad680a43cUL;
   tf->codes[17285] = 0x0000a80b95b798e1UL;
   tf->codes[17286] = 0x0000a90350c50148UL;
   tf->codes[17287] = 0x0000a96a402d2592UL;
   tf->codes[17288] = 0x0000aa58253495e2UL;
   tf->codes[17289] = 0x0000aad45a91d2bdUL;
   tf->codes[17290] = 0x0000af7331835cfcUL;
   tf->codes[17291] = 0x0000b0be6a7bff44UL;
   tf->codes[17292] = 0x0000b63cf7d1941dUL;
   tf->codes[17293] = 0x0000b99947055752UL;
   tf->codes[17294] = 0x0000ba96ba0a4ff6UL;
   tf->codes[17295] = 0x0000bb30e69780a0UL;
   tf->codes[17296] = 0x0000bcb21b697484UL;
   tf->codes[17297] = 0x0000bd933127a1bcUL;
   tf->codes[17298] = 0x0000be44ed4024a9UL;
   tf->codes[17299] = 0x0000bf1a930f3167UL;
   tf->codes[17300] = 0x0000bf60920416e1UL;
   tf->codes[17301] = 0x0000c1d1f573b4c7UL;
   tf->codes[17302] = 0x0000c25a0fde1da6UL;
   tf->codes[17303] = 0x0000c2f735ae9951UL;
   tf->codes[17304] = 0x0000c445a2798c5fUL;
   tf->codes[17305] = 0x0000c46a014e21baUL;
   tf->codes[17306] = 0x0000c48539c9d04dUL;
   tf->codes[17307] = 0x0000c5f3e75af0dcUL;
   tf->codes[17308] = 0x0000c62b428e6516UL;
   tf->codes[17309] = 0x0000c62d1706933eUL;
   tf->codes[17310] = 0x0000c6fd04de0fbfUL;
   tf->codes[17311] = 0x0000c74cd9d8ed50UL;
   tf->codes[17312] = 0x0000c7c7754d01c8UL;
   tf->codes[17313] = 0x0000c8a900293a8aUL;
   tf->codes[17314] = 0x0000c91ff2acf2b2UL;
   tf->codes[17315] = 0x0000c97b3796f0bdUL;
   tf->codes[17316] = 0x0000ca6cc58ebd5dUL;
   tf->codes[17317] = 0x0000cce15cd0ac09UL;
   tf->codes[17318] = 0x0000cf3453f24a96UL;
   tf->codes[17319] = 0x0000cfe7a9f3f5e6UL;
   tf->codes[17320] = 0x0000d21900f54454UL;
   tf->codes[17321] = 0x0000ddb6afd2403cUL;
   tf->codes[17322] = 0x0000e0b57085cbb4UL;
   tf->codes[17323] = 0x0000e2a5d0dcb396UL;
   tf->codes[17324] = 0x0000e2ab88d443d3UL;
   tf->codes[17325] = 0x0000e3e9b7f49d3eUL;
   tf->codes[17326] = 0x0000e3efaa7b3340UL;
   tf->codes[17327] = 0x0000e5618bdea495UL;
   tf->codes[17328] = 0x0000e8f44c09c4f0UL;
   tf->codes[17329] = 0x0000e94f5664bd36UL;
   tf->codes[17330] = 0x0000eaa42ad451d0UL;
   tf->codes[17331] = 0x0000ec159719b79bUL;
   tf->codes[17332] = 0x0000ef00abc152e5UL;
   tf->codes[17333] = 0x0000f0d1b58e245aUL;
   tf->codes[17334] = 0x0000f2582d399cf1UL;
   tf->codes[17335] = 0x0000f28ba4edaf16UL;
   tf->codes[17336] = 0x0000f2b0edfe5b85UL;
   tf->codes[17337] = 0x0000f4db2dadf718UL;
   tf->codes[17338] = 0x0000f4e837863ff5UL;
   tf->codes[17339] = 0x0000f51497e89f3fUL;
   tf->codes[17340] = 0x0000f5504bb98118UL;
   tf->codes[17341] = 0x0000f7a133d3ebb8UL;
   tf->codes[17342] = 0x0000f80b1c7f5b03UL;
   tf->codes[17343] = 0x0000fa714a8ede34UL;
   tf->codes[17344] = 0x0000fc020d5e5a6cUL;
   tf->codes[17345] = 0x00000298d1168af2UL;
   tf->codes[17346] = 0x00000865d40cdabeUL;
   tf->codes[17347] = 0x000009f23e3ee957UL;
   tf->codes[17348] = 0x00000b1868b5e4f5UL;
   tf->codes[17349] = 0x00000bca99ec736cUL;
   tf->codes[17350] = 0x00000c4cfc5f4c0eUL;
   tf->codes[17351] = 0x00000c5831bf66c3UL;
   tf->codes[17352] = 0x00000df5c3d82613UL;
   tf->codes[17353] = 0x00001069364ef7e6UL;
   tf->codes[17354] = 0x000011cb1496d55dUL;
   tf->codes[17355] = 0x00001400fec4972fUL;
   tf->codes[17356] = 0x000014e7cc7a54a4UL;
   tf->codes[17357] = 0x0000175302d456c3UL;
   tf->codes[17358] = 0x0000175f978e9416UL;
   tf->codes[17359] = 0x00001773f3479593UL;
   tf->codes[17360] = 0x0000182a07fd861fUL;
   tf->codes[17361] = 0x000018519aa46c40UL;
   tf->codes[17362] = 0x00001930a15b658bUL;
   tf->codes[17363] = 0x00001e9ef10660c1UL;
   tf->codes[17364] = 0x000021ab30b040a0UL;
   tf->codes[17365] = 0x000023d70a490496UL;
   tf->codes[17366] = 0x00002402f58d5856UL;
   tf->codes[17367] = 0x0000284cb4aa8051UL;
   tf->codes[17368] = 0x00002accf66a953cUL;
   tf->codes[17369] = 0x00002bf52fe8c4c7UL;
   tf->codes[17370] = 0x00003090235aecf1UL;
   tf->codes[17371] = 0x000032e8d2741bbbUL;
   tf->codes[17372] = 0x0000349f18e34a27UL;
   tf->codes[17373] = 0x000035243a0a6805UL;
   tf->codes[17374] = 0x000037d7f37e8f15UL;
   tf->codes[17375] = 0x0000382ac1bcb7a7UL;
   tf->codes[17376] = 0x000039942c745383UL;
   tf->codes[17377] = 0x00003b02da057412UL;
   tf->codes[17378] = 0x00003b17704d7b54UL;
   tf->codes[17379] = 0x00003bcc9ac754ccUL;
   tf->codes[17380] = 0x00003cb7116d6e91UL;
   tf->codes[17381] = 0x00003d581abd4c51UL;
   tf->codes[17382] = 0x000040e4e861d6aaUL;
   tf->codes[17383] = 0x0000413f7d9ec366UL;
   tf->codes[17384] = 0x000041b4268c41dcUL;
   tf->codes[17385] = 0x000041ebbc4ebbdbUL;
   tf->codes[17386] = 0x00004399c6a11a93UL;
   tf->codes[17387] = 0x00004455934e9b5cUL;
   tf->codes[17388] = 0x000045abc7185294UL;
   tf->codes[17389] = 0x0000466b3cb62fadUL;
   tf->codes[17390] = 0x00004688bec817f2UL;
   tf->codes[17391] = 0x000047c678ca65d3UL;
   tf->codes[17392] = 0x000047d3bd31b475UL;
   tf->codes[17393] = 0x000048e0be34356dUL;
   tf->codes[17394] = 0x00004a76fe6c3c1dUL;
   tf->codes[17395] = 0x00004ada7f7309dcUL;
   tf->codes[17396] = 0x00004c7ca4b83c90UL;
   tf->codes[17397] = 0x00004f20959fd587UL;
   tf->codes[17398] = 0x000051f629c3527bUL;
   tf->codes[17399] = 0x000053b5216d5c25UL;
   tf->codes[17400] = 0x000053c908085218UL;
   tf->codes[17401] = 0x000055c3ee124360UL;
   tf->codes[17402] = 0x00005768977cb58bUL;
   tf->codes[17403] = 0x00005818448e048bUL;
   tf->codes[17404] = 0x00005a60b5fc99b2UL;
   tf->codes[17405] = 0x00005b63314c1144UL;
   tf->codes[17406] = 0x00005d5f76b0252aUL;
   tf->codes[17407] = 0x00005edba3379a20UL;
   tf->codes[17408] = 0x00005ef5b6e82bdaUL;
   tf->codes[17409] = 0x00005f9351d6b30fUL;
   tf->codes[17410] = 0x00005ffd7511281fUL;
   tf->codes[17411] = 0x000062edcc92481cUL;
   tf->codes[17412] = 0x000063bafbb57f61UL;
   tf->codes[17413] = 0x00006429b21c67d5UL;
   tf->codes[17414] = 0x000064e4cf1cd74fUL;
   tf->codes[17415] = 0x0000659391f20f3bUL;
   tf->codes[17416] = 0x0000664b4091282aUL;
   tf->codes[17417] = 0x00006748ee252693UL;
   tf->codes[17418] = 0x0000678810575ef7UL;
   tf->codes[17419] = 0x00006791abce5149UL;
   tf->codes[17420] = 0x0000692aaaba9d35UL;
   tf->codes[17421] = 0x000069bd104909b5UL;
   tf->codes[17422] = 0x00006a2ebff33d2aUL;
   tf->codes[17423] = 0x00006a4feaf581bfUL;
   tf->codes[17424] = 0x00006bb3289781d4UL;
   tf->codes[17425] = 0x00006be506626b96UL;
   tf->codes[17426] = 0x00007156c46ebd57UL;
   tf->codes[17427] = 0x000077e670d53b02UL;
   tf->codes[17428] = 0x00007ada36b7b18aUL;
   tf->codes[17429] = 0x00008059e8d8633cUL;
   tf->codes[17430] = 0x0000809aa4f3c403UL;
   tf->codes[17431] = 0x000081951eb571a6UL;
   tf->codes[17432] = 0x0000836db4f20180UL;
   tf->codes[17433] = 0x0000838335761fd6UL;
   tf->codes[17434] = 0x0000847204b9a73aUL;
   tf->codes[17435] = 0x0000849e9fab0c49UL;
   tf->codes[17436] = 0x00008689f7b7753dUL;
   tf->codes[17437] = 0x00008894e0dcfa63UL;
   tf->codes[17438] = 0x0000895f16bce6a7UL;
   tf->codes[17439] = 0x000089b518cd5fffUL;
   tf->codes[17440] = 0x00008ccc534854ceUL;
   tf->codes[17441] = 0x00008e09230e8b9bUL;
   tf->codes[17442] = 0x00008e68fb24fd0aUL;
   tf->codes[17443] = 0x000090d7da6f5b79UL;
   tf->codes[17444] = 0x000091e9e3bc5b5fUL;
   tf->codes[17445] = 0x000095f73f5b9032UL;
   tf->codes[17446] = 0x000095fc823514e5UL;
   tf->codes[17447] = 0x000096ab0a7b470cUL;
   tf->codes[17448] = 0x0000999cc15689a7UL;
   tf->codes[17449] = 0x00009bc5dc3b0861UL;
   tf->codes[17450] = 0x00009bf23c9d67abUL;
   tf->codes[17451] = 0x00009f9d3c00eb98UL;
   tf->codes[17452] = 0x0000a42a3b5eb3d1UL;
   tf->codes[17453] = 0x0000a538612c51a2UL;
   tf->codes[17454] = 0x0000a77d29aa8a79UL;
   tf->codes[17455] = 0x0000ab91277d669dUL;
   tf->codes[17456] = 0x0000ac594e561ef4UL;
   tf->codes[17457] = 0x0000af22884e645aUL;
   tf->codes[17458] = 0x0000af888d7a7190UL;
   tf->codes[17459] = 0x0000b3fc6363bf23UL;
   tf->codes[17460] = 0x0000b49fb649d695UL;
   tf->codes[17461] = 0x0000b883e558fce4UL;
   tf->codes[17462] = 0x0000b9017a105c5dUL;
   tf->codes[17463] = 0x0000b937eb07b983UL;
   tf->codes[17464] = 0x0000babd3de81541UL;
   tf->codes[17465] = 0x0000bc3302cae8abUL;
   tf->codes[17466] = 0x0000bd2c57c17975UL;
   tf->codes[17467] = 0x0000c1e6a1bdb80cUL;
   tf->codes[17468] = 0x0000c277e28107b3UL;
   tf->codes[17469] = 0x0000c564cba0d125UL;
   tf->codes[17470] = 0x0000c6df23b017f3UL;
   tf->codes[17471] = 0x0000c899130fa2afUL;
   tf->codes[17472] = 0x0000c992dd243f03UL;
   tf->codes[17473] = 0x0000ca0b69911f8eUL;
   tf->codes[17474] = 0x0000ca9433a899bcUL;
   tf->codes[17475] = 0x0000cdc45d09036cUL;
   tf->codes[17476] = 0x0000d0cec83ab523UL;
   tf->codes[17477] = 0x0000d1315f056bceUL;
   tf->codes[17478] = 0x0000d141d73f0b36UL;
   tf->codes[17479] = 0x0000d1ebcc58c9f9UL;
   tf->codes[17480] = 0x0000d20aadc4d4dcUL;
   tf->codes[17481] = 0x0000d21b608d7a09UL;
   tf->codes[17482] = 0x0000d2411ebc3202UL;
   tf->codes[17483] = 0x0000d2574eed61a7UL;
   tf->codes[17484] = 0x0000d2c7d9cc7843UL;
   tf->codes[17485] = 0x0000d2f76e012853UL;
   tf->codes[17486] = 0x0000d394ce60a9c3UL;
   tf->codes[17487] = 0x0000d45c0afd4b06UL;
   tf->codes[17488] = 0x0000d770c153005eUL;
   tf->codes[17489] = 0x0000d9ad132563bcUL;
   tf->codes[17490] = 0x0000dc59b547d7f1UL;
   tf->codes[17491] = 0x0000ddcc80e7605aUL;
   tf->codes[17492] = 0x0000e55df8f04448UL;
   tf->codes[17493] = 0x0000e66e68541bcbUL;
   tf->codes[17494] = 0x0000ec4f17565bc5UL;
   tf->codes[17495] = 0x0000eea9d576be7cUL;
   tf->codes[17496] = 0x0000f03ad2d54079UL;
   tf->codes[17497] = 0x0000f3d13bf0bd24UL;
   tf->codes[17498] = 0x0000f78cee1ce63eUL;
   tf->codes[17499] = 0x0000f8e61b29e877UL;
   tf->codes[17500] = 0x0000fd24a4e6f5bdUL;
   tf->codes[17501] = 0x0000fd560d93d3f5UL;
   tf->codes[17502] = 0x0000fdb2022ae34fUL;
   tf->codes[17503] = 0x0000fe3eafc1bf92UL;
   tf->codes[17504] = 0x0000ffdbccbc7358UL;
   tf->codes[17505] = 0x000001efdc3adf46UL;
   tf->codes[17506] = 0x000002c7cba025b6UL;
   tf->codes[17507] = 0x00000814f048dc57UL;
   tf->codes[17508] = 0x00000cc9bcdc9076UL;
   tf->codes[17509] = 0x0000126ce395c06fUL;
   tf->codes[17510] = 0x00001531ff7f9dfbUL;
   tf->codes[17511] = 0x000015a1659397beUL;
   tf->codes[17512] = 0x000017c5b2bc9d4fUL;
   tf->codes[17513] = 0x0000185ad6ff4f0bUL;
   tf->codes[17514] = 0x00001a98c2badaccUL;
   tf->codes[17515] = 0x00001c2b94918af1UL;
   tf->codes[17516] = 0x00001d7c1063b1ecUL;
   tf->codes[17517] = 0x000022377f2b0d5cUL;
   tf->codes[17518] = 0x0000227f18091b39UL;
   tf->codes[17519] = 0x00002374fe9e5578UL;
   tf->codes[17520] = 0x00002486583e440fUL;
   tf->codes[17521] = 0x000024e1d7b747dfUL;
   tf->codes[17522] = 0x000025e32e3ba298UL;
   tf->codes[17523] = 0x000026fab4f12cf6UL;
   tf->codes[17524] = 0x000029da59a9a7c6UL;
   tf->codes[17525] = 0x00002a1aa0a6fd03UL;
   tf->codes[17526] = 0x00002d354983485dUL;
   tf->codes[17527] = 0x00002f95bf9b3b51UL;
   tf->codes[17528] = 0x00003107a0feaca6UL;
   tf->codes[17529] = 0x0000328c4431f715UL;
   tf->codes[17530] = 0x00003385d3b78da4UL;
   tf->codes[17531] = 0x000033b9c089ab53UL;
   tf->codes[17532] = 0x000035cce5cc002dUL;
   tf->codes[17533] = 0x0000392c2e430e63UL;
   tf->codes[17534] = 0x000039cff647315fUL;
   tf->codes[17535] = 0x00003b6a19fe9a24UL;
   tf->codes[17536] = 0x00003df7dab50376UL;
   tf->codes[17537] = 0x00003e060958692cUL;
   tf->codes[17538] = 0x00003e598743a30dUL;
   tf->codes[17539] = 0x00003eba0f0725cbUL;
   tf->codes[17540] = 0x00003f4ef8bad1c2UL;
   tf->codes[17541] = 0x00003fb2eedfab0bUL;
   tf->codes[17542] = 0x0000417763f23f2dUL;
   tf->codes[17543] = 0x000041a64879ddeeUL;
   tf->codes[17544] = 0x00004307ec32b5a0UL;
   tf->codes[17545] = 0x000044e42b5fa1caUL;
   tf->codes[17546] = 0x0000464644368506UL;
   tf->codes[17547] = 0x0000488d1bbbf1caUL;
   tf->codes[17548] = 0x0000488f65522b7cUL;
   tf->codes[17549] = 0x00004dff4ee64f15UL;
   tf->codes[17550] = 0x0000527cfad594bfUL;
   tf->codes[17551] = 0x000052806936eb4aUL;
   tf->codes[17552] = 0x000053401963ce28UL;
   tf->codes[17553] = 0x00005541671260fcUL;
   tf->codes[17554] = 0x000056e2678c76d7UL;
   tf->codes[17555] = 0x00005874c4451b72UL;
   tf->codes[17556] = 0x000058d80abce36cUL;
   tf->codes[17557] = 0x00005a25182db3dcUL;
   tf->codes[17558] = 0x00005bea777c5f12UL;
   tf->codes[17559] = 0x000060e333fdc4beUL;
   tf->codes[17560] = 0x000061546e89eca9UL;
   tf->codes[17561] = 0x000062c5dacf5274UL;
   tf->codes[17562] = 0x0000638d176bf3b7UL;
   tf->codes[17563] = 0x000064c17086550bUL;
   tf->codes[17564] = 0x00006712932fc570UL;
   tf->codes[17565] = 0x0000679c0cf450edUL;
   tf->codes[17566] = 0x00006c8416ad116cUL;
   tf->codes[17567] = 0x00006d008699540cUL;
   tf->codes[17568] = 0x00006f64308397c6UL;
   tf->codes[17569] = 0x00006fc9fb209f37UL;
   tf->codes[17570] = 0x00006fe658676aa3UL;
   tf->codes[17571] = 0x000071270bad0385UL;
   tf->codes[17572] = 0x000071b811e14d67UL;
   tf->codes[17573] = 0x0000740fd6be651dUL;
   tf->codes[17574] = 0x0000741d55b4b984UL;
   tf->codes[17575] = 0x000074e1d39d158bUL;
   tf->codes[17576] = 0x0000757c3ab94bfaUL;
   tf->codes[17577] = 0x000077462d346a94UL;
   tf->codes[17578] = 0x0000782200191319UL;
   tf->codes[17579] = 0x00007ab27f83c1a7UL;
   tf->codes[17580] = 0x00007add45fcf88eUL;
   tf->codes[17581] = 0x00007b142c12613eUL;
   tf->codes[17582] = 0x00007b7a6bcd7439UL;
   tf->codes[17583] = 0x00007cfcc56a84f6UL;
   tf->codes[17584] = 0x00007d6bb660732fUL;
   tf->codes[17585] = 0x00007e942a6da87fUL;
   tf->codes[17586] = 0x00007faa51c9103fUL;
   tf->codes[17587] = 0x000084de126e4675UL;
   tf->codes[17588] = 0x00008686d9e7207aUL;
   tf->codes[17589] = 0x00008918b8abf1a6UL;
   tf->codes[17590] = 0x00008b2c187d4c45UL;
   tf->codes[17591] = 0x00008d259f2d1aefUL;
   tf->codes[17592] = 0x000090501095f462UL;
   tf->codes[17593] = 0x0000935ba092c2f2UL;
   tf->codes[17594] = 0x00009525cd9ce751UL;
   tf->codes[17595] = 0x00009545d3d40f0dUL;
   tf->codes[17596] = 0x0000956ae255b5b7UL;
   tf->codes[17597] = 0x0000957234366e57UL;
   tf->codes[17598] = 0x000099e72eead8c3UL;
   tf->codes[17599] = 0x00009c34a8a3ecd8UL;
   tf->codes[17600] = 0x00009c7021e5c8ecUL;
   tf->codes[17601] = 0x00009cd1ce746883UL;
   tf->codes[17602] = 0x00009df4c519135bUL;
   tf->codes[17603] = 0x00009e1923eda8b6UL;
   tf->codes[17604] = 0x00009f562e42e548UL;
   tf->codes[17605] = 0x00009f6b39a8f814UL;
   tf->codes[17606] = 0x0000a28d3465fc0eUL;
   tf->codes[17607] = 0x0000a39aaa868890UL;
   tf->codes[17608] = 0x0000a4c56829f792UL;
   tf->codes[17609] = 0x0000a507be2e80bcUL;
   tf->codes[17610] = 0x0000a6265c35bdf5UL;
   tf->codes[17611] = 0x0000a65abe25e72eUL;
   tf->codes[17612] = 0x0000a7ea96b94c52UL;
   tf->codes[17613] = 0x0000aa3acf26a5a3UL;
   tf->codes[17614] = 0x0000aa484e1cfa0aUL;
   tf->codes[17615] = 0x0000aa79f158de07UL;
   tf->codes[17616] = 0x0000abc7e905c58bUL;
   tf->codes[17617] = 0x0000ac1f0fe15bbcUL;
   tf->codes[17618] = 0x0000ac7fd233e43fUL;
   tf->codes[17619] = 0x0000ac837b24408fUL;
   tf->codes[17620] = 0x0000aedb7a905e0aUL;
   tf->codes[17621] = 0x0000afae61ab258cUL;
   tf->codes[17622] = 0x0000b03ca92b2a32UL;
   tf->codes[17623] = 0x0000b0a691d6997dUL;
   tf->codes[17624] = 0x0000b23afd967205UL;
   tf->codes[17625] = 0x0000b246a8149844UL;
   tf->codes[17626] = 0x0000b2a55b5fecdaUL;
   tf->codes[17627] = 0x0000b32e25776708UL;
   tf->codes[17628] = 0x0000b42c0d9a6b36UL;
   tf->codes[17629] = 0x0000b4c291373f90UL;
   tf->codes[17630] = 0x0000b65612bb0104UL;
   tf->codes[17631] = 0x0000b90bdb365c01UL;
   tf->codes[17632] = 0x0000ba09fde865f4UL;
   tf->codes[17633] = 0x0000ba724caaacdcUL;
   tf->codes[17634] = 0x0000bbad47f8b581UL;
   tf->codes[17635] = 0x0000bbda1d792055UL;
   tf->codes[17636] = 0x0000bc6f41bbd211UL;
   tf->codes[17637] = 0x0000bcb62aecce9fUL;
   tf->codes[17638] = 0x0000bd1e049109fdUL;
   tf->codes[17639] = 0x0000bd61f47ebb8aUL;
   tf->codes[17640] = 0x0000be926a19bac9UL;
   tf->codes[17641] = 0x0000bf8f6800a7e3UL;
   tf->codes[17642] = 0x0000c23910dfd117UL;
   tf->codes[17643] = 0x0000c34268f1f5bfUL;
   tf->codes[17644] = 0x0000c3c6654df6c4UL;
   tf->codes[17645] = 0x0000c96b9b0e5aaaUL;
   tf->codes[17646] = 0x0000c98c50f293b5UL;
   tf->codes[17647] = 0x0000cb21e17d8916UL;
   tf->codes[17648] = 0x0000cc46ac9a6216UL;
   tf->codes[17649] = 0x0000d3c82187b226UL;
   tf->codes[17650] = 0x0000d6a800cf32bbUL;
   tf->codes[17651] = 0x0000ddca12c41ce6UL;
   tf->codes[17652] = 0x0000e1d684273aa5UL;
   tf->codes[17653] = 0x0000e2ce04a59d47UL;
   tf->codes[17654] = 0x0000e3a160de7053UL;
   tf->codes[17655] = 0x0000e63bf0de1cbdUL;
   tf->codes[17656] = 0x0000eaa6a06e8388UL;
   tf->codes[17657] = 0x0000ec1cda6f627cUL;
   tf->codes[17658] = 0x0000f0b71e347957UL;
   tf->codes[17659] = 0x0000f3af3cb45d7eUL;
   tf->codes[17660] = 0x0000f52660f15386UL;
   tf->codes[17661] = 0x0000f55dbc24c7c0UL;
   tf->codes[17662] = 0x0000f6595ab1923cUL;
   tf->codes[17663] = 0x0000f68ea6ddd289UL;
   tf->codes[17664] = 0x0000f8673d1a6263UL;
   tf->codes[17665] = 0x0000fa40f8220f16UL;
   tf->codes[17666] = 0x0000fbbd99c78f96UL;
   tf->codes[17667] = 0x0000fbd7e8072715UL;
   tf->codes[17668] = 0x0000fe844f9a9585UL;
   tf->codes[17669] = 0x00000182261209e9UL;
   tf->codes[17670] = 0x000001fc11d90d12UL;
   tf->codes[17671] = 0x00000239d4b122d8UL;
   tf->codes[17672] = 0x0000037f55b234e3UL;
   tf->codes[17673] = 0x00000503be56798dUL;
   tf->codes[17674] = 0x000007ab92bd7499UL;
   tf->codes[17675] = 0x000009766f74aa47UL;
   tf->codes[17676] = 0x00000a2029ff6345UL;
   tf->codes[17677] = 0x00000b9a820eaa13UL;
   tf->codes[17678] = 0x00000bc9dbb4545eUL;
   tf->codes[17679] = 0x00000c0a97cfb525UL;
   tf->codes[17680] = 0x00001476bdf224bfUL;
   tf->codes[17681] = 0x00001ac364a707f1UL;
   tf->codes[17682] = 0x00001e43d8205abcUL;
   tf->codes[17683] = 0x00001ecb7d6cb811UL;
   tf->codes[17684] = 0x000020a39e8b3c61UL;
   tf->codes[17685] = 0x000022307ddb5684UL;
   tf->codes[17686] = 0x0000226fa00d8ee8UL;
   tf->codes[17687] = 0x000022b7ae09a84fUL;
   tf->codes[17688] = 0x00002315b1a7eb96UL;
   tf->codes[17689] = 0x00002339264069ddUL;
   tf->codes[17690] = 0x000024cfa1077652UL;
   tf->codes[17691] = 0x000027605b012aa5UL;
   tf->codes[17692] = 0x0000294794ff2bbfUL;
   tf->codes[17693] = 0x00002aa4a58b900dUL;
   tf->codes[17694] = 0x00002c44f6589499UL;
   tf->codes[17695] = 0x00002ca78d234b44UL;
   tf->codes[17696] = 0x00002e9409fad111UL;
   tf->codes[17697] = 0x0000308813421543UL;
   tf->codes[17698] = 0x00003544e1639351UL;
   tf->codes[17699] = 0x00003659a964d873UL;
   tf->codes[17700] = 0x00003a7e948f5f89UL;
   tf->codes[17701] = 0x00003a8954d16eb4UL;
   tf->codes[17702] = 0x00003b1bba5fdb34UL;
   tf->codes[17703] = 0x00003c7b4f117ef9UL;
   tf->codes[17704] = 0x000043dfb70af24eUL;
   tf->codes[17705] = 0x000044e1f7cb641bUL;
   tf->codes[17706] = 0x000047d841d31a1aUL;
   tf->codes[17707] = 0x00004c4993972836UL;
   tf->codes[17708] = 0x00004dfc6ba50017UL;
   tf->codes[17709] = 0x00005113e0aefaabUL;
   tf->codes[17710] = 0x000051be1057bf33UL;
   tf->codes[17711] = 0x000053f8c840fa2eUL;
   tf->codes[17712] = 0x00005586cc5c312aUL;
   tf->codes[17713] = 0x000055f966427bb3UL;
   tf->codes[17714] = 0x00005609de7c1b1bUL;
   tf->codes[17715] = 0x00005730f32f2dcdUL;
   tf->codes[17716] = 0x00005b0818660b3fUL;
   tf->codes[17717] = 0x00005c217393c3c5UL;
   tf->codes[17718] = 0x00005c24e1f51a50UL;
   tf->codes[17719] = 0x00005c4bff7df4e7UL;
   tf->codes[17720] = 0x00005c9bd478d278UL;
   tf->codes[17721] = 0x00005df5b132e600UL;
   tf->codes[17722] = 0x00006016556b8f41UL;
   tf->codes[17723] = 0x00006091db1bbacdUL;
   tf->codes[17724] = 0x00006cd9f4308102UL;
   tf->codes[17725] = 0x000070ec581a34c3UL;
   tf->codes[17726] = 0x0000716cab85d978UL;
   tf->codes[17727] = 0x000073749b68139dUL;
   tf->codes[17728] = 0x000075af18c248d3UL;
   tf->codes[17729] = 0x000076e71acd0677UL;
   tf->codes[17730] = 0x00007913dea1e181UL;
   tf->codes[17731] = 0x00007956e4537bfaUL;
   tf->codes[17732] = 0x0000803874bc0b23UL;
   tf->codes[17733] = 0x000080649a8f64a8UL;
   tf->codes[17734] = 0x000080ad1da98999UL;
   tf->codes[17735] = 0x000083c03a16168eUL;
   tf->codes[17736] = 0x000083e7579ef125UL;
   tf->codes[17737] = 0x00008577dfdf6798UL;
   tf->codes[17738] = 0x0000857ef7311a73UL;
   tf->codes[17739] = 0x00008afc252c8caeUL;
   tf->codes[17740] = 0x00008e2cc3ab01e8UL;
   tf->codes[17741] = 0x00008f0e13f834e5UL;
   tf->codes[17742] = 0x0000908cc4a4e952UL;
   tf->codes[17743] = 0x000090a1957bf659UL;
   tf->codes[17744] = 0x000090a628a869bdUL;
   tf->codes[17745] = 0x000090ca125ef38eUL;
   tf->codes[17746] = 0x00009361a91b54f7UL;
   tf->codes[17747] = 0x000094415f7f5f91UL;
   tf->codes[17748] = 0x0000954783bf3373UL;
   tf->codes[17749] = 0x00009658dd5f220aUL;
   tf->codes[17750] = 0x000096941c11f859UL;
   tf->codes[17751] = 0x000096d2540819a9UL;
   tf->codes[17752] = 0x0000986cecdd8df8UL;
   tf->codes[17753] = 0x000099349e983ac5UL;
   tf->codes[17754] = 0x00009b4a0d70c951UL;
   tf->codes[17755] = 0x00009be4e9ab0b4aUL;
   tf->codes[17756] = 0x00009c2396bf3824UL;
   tf->codes[17757] = 0x00009c356e52fa2aUL;
   tf->codes[17758] = 0x00009cc25678dc32UL;
   tf->codes[17759] = 0x00009cf016355e1aUL;
   tf->codes[17760] = 0x00009d12db20cb12UL;
   tf->codes[17761] = 0x00009d19f2727dedUL;
   tf->codes[17762] = 0x00009de044d3081cUL;
   tf->codes[17763] = 0x00009f24a108fd4eUL;
   tf->codes[17764] = 0x00009fe0a84583dcUL;
   tf->codes[17765] = 0x0000a001d347c871UL;
   tf->codes[17766] = 0x0000a06519bf906bUL;
   tf->codes[17767] = 0x0000a110a8c27791UL;
   tf->codes[17768] = 0x0000a3cd4e007fa4UL;
   tf->codes[17769] = 0x0000a5f4946cd036UL;
   tf->codes[17770] = 0x0000a5f5098adbc0UL;
   tf->codes[17771] = 0x0000a6c2adcc1e8fUL;
   tf->codes[17772] = 0x0000a766eaee4d15UL;
   tf->codes[17773] = 0x0000a831d07b4aa8UL;
   tf->codes[17774] = 0x0000ab1ad61bb205UL;
   tf->codes[17775] = 0x0000ab791448fb11UL;
   tf->codes[17776] = 0x0000adf5e7a7b971UL;
   tf->codes[17777] = 0x0000af933f3172fcUL;
   tf->codes[17778] = 0x0000b0ac5fd025bdUL;
   tf->codes[17779] = 0x0000b144083816f0UL;
   tf->codes[17780] = 0x0000b22851c894eeUL;
   tf->codes[17781] = 0x0000b2f24d197b6dUL;
   tf->codes[17782] = 0x0000b53ccd8f4481UL;
   tf->codes[17783] = 0x0000b6dce3cd4348UL;
   tf->codes[17784] = 0x0000b8e374555acfUL;
   tf->codes[17785] = 0x0000bc02b05e198dUL;
   tf->codes[17786] = 0x0000bc4df22c83baUL;
   tf->codes[17787] = 0x0000bccd95eb1720UL;
   tf->codes[17788] = 0x0000bcd64725f25eUL;
   tf->codes[17789] = 0x0000bd1c461ad7d8UL;
   tf->codes[17790] = 0x0000c10960f3df2aUL;
   tf->codes[17791] = 0x0000c1ae885224c4UL;
   tf->codes[17792] = 0x0000c1f1c892c502UL;
   tf->codes[17793] = 0x0000c6c5b12189c9UL;
   tf->codes[17794] = 0x0000c9f231919729UL;
   tf->codes[17795] = 0x0000c9ffb087eb90UL;
   tf->codes[17796] = 0x0000cecb5cf9e0a3UL;
   tf->codes[17797] = 0x0000cfa7a4fc94b2UL;
   tf->codes[17798] = 0x0000d0e683c9ff6cUL;
   tf->codes[17799] = 0x0000d1a6e3a3f399UL;
   tf->codes[17800] = 0x0000d22aa570eed9UL;
   tf->codes[17801] = 0x0000d379123be1e7UL;
   tf->codes[17802] = 0x0000d4258b7ae021UL;
   tf->codes[17803] = 0x0000d589ede7fd0fUL;
   tf->codes[17804] = 0x0000d69813b59ae0UL;
   tf->codes[17805] = 0x0000de8a4e110751UL;
   tf->codes[17806] = 0x0000df2a3295c838UL;
   tf->codes[17807] = 0x0000df941b413783UL;
   tf->codes[17808] = 0x0000e6359f3b7734UL;
   tf->codes[17809] = 0x0000e8b6561997a9UL;
   tf->codes[17810] = 0x0000ea804894b643UL;
   tf->codes[17811] = 0x0000eb51d0555b27UL;
   tf->codes[17812] = 0x0000ed0607bd55a6UL;
   tf->codes[17813] = 0x0000ed297c55d3edUL;
   tf->codes[17814] = 0x0000f0ce4ea3bc13UL;
   tf->codes[17815] = 0x0000f1cce673d190UL;
   tf->codes[17816] = 0x0000f51b419334d4UL;
   tf->codes[17817] = 0x0000f5d0e12b19d6UL;
   tf->codes[17818] = 0x0000f67eb9c43aaeUL;
   tf->codes[17819] = 0x0000faff9985d11eUL;
   tf->codes[17820] = 0x0000fb66fe0c00f2UL;
   tf->codes[17821] = 0x0000fdd31ea21a25UL;
   tf->codes[17822] = 0x0000feccae27b0b4UL;
   tf->codes[17823] = 0x0000ffe852eba2ecUL;
   tf->codes[17824] = 0x000002f6a19cb6b8UL;
   tf->codes[17825] = 0x00000908b94bd4eaUL;
   tf->codes[17826] = 0x00000a041d4999a1UL;
   tf->codes[17827] = 0x00000c7a4e74b0b0UL;
   tf->codes[17828] = 0x00000cc17234b303UL;
   tf->codes[17829] = 0x00000e3fe85261abUL;
   tf->codes[17830] = 0x00001239d274ac15UL;
   tf->codes[17831] = 0x000012cbc2e50d0bUL;
   tf->codes[17832] = 0x0000136998629a05UL;
   tf->codes[17833] = 0x0000174d5253b4caUL;
   tf->codes[17834] = 0x00001b3773e9711bUL;
   tf->codes[17835] = 0x00001cb6d44336d7UL;
   tf->codes[17836] = 0x00001cf92a47c001UL;
   tf->codes[17837] = 0x0000222cb05df072UL;
   tf->codes[17838] = 0x000022fe72ad9b1bUL;
   tf->codes[17839] = 0x0000230a57bac71fUL;
   tf->codes[17840] = 0x0000280c75241958UL;
   tf->codes[17841] = 0x000028cb75a3eae7UL;
   tf->codes[17842] = 0x0000296b94b7b193UL;
   tf->codes[17843] = 0x00002bf412949632UL;
   tf->codes[17844] = 0x00002c2ccd222d0aUL;
   tf->codes[17845] = 0x00002c8f9e7be97aUL;
   tf->codes[17846] = 0x00002cbbfede48c4UL;
   tf->codes[17847] = 0x00002d79a003f7b5UL;
   tf->codes[17848] = 0x00002ecd151969b1UL;
   tf->codes[17849] = 0x00002fe5c09a10e8UL;
   tf->codes[17850] = 0x000030288bbca59cUL;
   tf->codes[17851] = 0x000035fbf65796f4UL;
   tf->codes[17852] = 0x00003651f868104cUL;
   tf->codes[17853] = 0x000036a86f96952eUL;
   tf->codes[17854] = 0x000038bb5a49e443UL;
   tf->codes[17855] = 0x000039ea708ac0e4UL;
   tf->codes[17856] = 0x00003b67fc6c5878UL;
   tf->codes[17857] = 0x0000401d3e1e1821UL;
   tf->codes[17858] = 0x000042161520d57cUL;
   tf->codes[17859] = 0x0000440550aca085UL;
   tf->codes[17860] = 0x00004519de1edfe2UL;
   tf->codes[17861] = 0x00004597ad654520UL;
   tf->codes[17862] = 0x000048c9e5cce2bdUL;
   tf->codes[17863] = 0x00004a69c17bdbbfUL;
   tf->codes[17864] = 0x00004ade6a695a35UL;
   tf->codes[17865] = 0x00004aea4f768639UL;
   tf->codes[17866] = 0x00004c61e8d187cbUL;
   tf->codes[17867] = 0x000050dfcf4fd33aUL;
   tf->codes[17868] = 0x0000510ca4d03e0eUL;
   tf->codes[17869] = 0x000052e5b02ad972UL;
   tf->codes[17870] = 0x000054880fff11ebUL;
   tf->codes[17871] = 0x000059fa7db874fbUL;
   tf->codes[17872] = 0x00005c88b38ce9d7UL;
   tf->codes[17873] = 0x00005e68d6393816UL;
   tf->codes[17874] = 0x000063323914f377UL;
   tf->codes[17875] = 0x0000655d6300a61eUL;
   tf->codes[17876] = 0x0000657aaa83889eUL;
   tf->codes[17877] = 0x00006631345784b4UL;
   tf->codes[17878] = 0x000066b7052bb3e1UL;
   tf->codes[17879] = 0x000067bd63fa8d88UL;
   tf->codes[17880] = 0x000067e989cde70dUL;
   tf->codes[17881] = 0x000067f35fd3df24UL;
   tf->codes[17882] = 0x000068ffb1294ecdUL;
   tf->codes[17883] = 0x00006da689a8a2fbUL;
   tf->codes[17884] = 0x0000733220d680b1UL;
   tf->codes[17885] = 0x000074d5a575d603UL;
   tf->codes[17886] = 0x00007f23c2bcc204UL;
   tf->codes[17887] = 0x00007fc7ffdef08aUL;
   tf->codes[17888] = 0x00007ff80931ac24UL;
   tf->codes[17889] = 0x000082ef3d757937UL;
   tf->codes[17890] = 0x000083650b2e1486UL;
   tf->codes[17891] = 0x000084a499a8908fUL;
   tf->codes[17892] = 0x000085b9d6c7e13bUL;
   tf->codes[17893] = 0x00008634accafb78UL;
   tf->codes[17894] = 0x000087634dedcc8fUL;
   tf->codes[17895] = 0x000087cc86ec2a8bUL;
   tf->codes[17896] = 0x000088c4f1a6a441UL;
   tf->codes[17897] = 0x000088f9c8b4d904UL;
   tf->codes[17898] = 0x00008c5cba1c438aUL;
   tf->codes[17899] = 0x0000905d46723545UL;
   tf->codes[17900] = 0x000091073b8bf408UL;
   tf->codes[17901] = 0x000093067a3352efUL;
   tf->codes[17902] = 0x000093f0b64a66efUL;
   tf->codes[17903] = 0x000095ba33a779ffUL;
   tf->codes[17904] = 0x00009675c5c5f503UL;
   tf->codes[17905] = 0x00009740ab52f296UL;
   tf->codes[17906] = 0x00009ba060124471UL;
   tf->codes[17907] = 0x00009c1afb8658e9UL;
   tf->codes[17908] = 0x00009ca17c079965UL;
   tf->codes[17909] = 0x0000a0d80436dcbcUL;
   tf->codes[17910] = 0x0000a20804b3d071UL;
   tf->codes[17911] = 0x0000a43f13acaf1cUL;
   tf->codes[17912] = 0x0000a5a6a9ec1cd0UL;
   tf->codes[17913] = 0x0000a7605ebca1c7UL;
   tf->codes[17914] = 0x0000a8149efa642bUL;
   tf->codes[17915] = 0x0000a8c02dfd4b51UL;
   tf->codes[17916] = 0x0000aa32847ec830UL;
   tf->codes[17917] = 0x0000aac2a076fafeUL;
   tf->codes[17918] = 0x0000ab4b6a8e752cUL;
   tf->codes[17919] = 0x0000ad5444acc665UL;
   tf->codes[17920] = 0x0000b0badf048d3bUL;
   tf->codes[17921] = 0x0000b175fc04fcb5UL;
   tf->codes[17922] = 0x0000b318214a2f69UL;
   tf->codes[17923] = 0x0000b55313c27029UL;
   tf->codes[17924] = 0x0000b5ed7adea698UL;
   tf->codes[17925] = 0x0000b71c1c0177afUL;
   tf->codes[17926] = 0x0000b91184a2de7fUL;
   tf->codes[17927] = 0x0000b91ae58acb0cUL;
   tf->codes[17928] = 0x0000bab543d13996UL;
   tf->codes[17929] = 0x0000bd16a425439eUL;
   tf->codes[17930] = 0x0000be341d6163feUL;
   tf->codes[17931] = 0x0000bf97959269d8UL;
   tf->codes[17932] = 0x0000c03f7ba4f4aeUL;
   tf->codes[17933] = 0x0000c0c4d75b1851UL;
   tf->codes[17934] = 0x0000c17c85fa3140UL;
   tf->codes[17935] = 0x0000c22d9265a2deUL;
   tf->codes[17936] = 0x0000c230168ae255UL;
   tf->codes[17937] = 0x0000c23cab451fa8UL;
   tf->codes[17938] = 0x0000c53195f2b309UL;
   tf->codes[17939] = 0x0000c5bc34825b5fUL;
   tf->codes[17940] = 0x0000c602e3245228UL;
   tf->codes[17941] = 0x0000c729482a538bUL;
   tf->codes[17942] = 0x0000c746551e3046UL;
   tf->codes[17943] = 0x0000c86393cb4ae1UL;
   tf->codes[17944] = 0x0000c871fcfdb65cUL;
   tf->codes[17945] = 0x0000c8e92a107449UL;
   tf->codes[17946] = 0x0000cb05eac9bb75UL;
   tf->codes[17947] = 0x0000cbc81f1bddcaUL;
   tf->codes[17948] = 0x0000cc3d77b66d8fUL;
   tf->codes[17949] = 0x0000cdaa50cf5ff6UL;
   tf->codes[17950] = 0x0000cdbdfcdb5024UL;
   tf->codes[17951] = 0x0000cdd79b6dd654UL;
   tf->codes[17952] = 0x0000d135bf19c7b1UL;
   tf->codes[17953] = 0x0000da78ea6566a7UL;
   tf->codes[17954] = 0x0000dc9fbbb3abafUL;
   tf->codes[17955] = 0x0000dd5a290709daUL;
   tf->codes[17956] = 0x0000e2d3e8a1258aUL;
   tf->codes[17957] = 0x0000e6c4374c7da2UL;
   tf->codes[17958] = 0x0000e9e965dbd262UL;
   tf->codes[17959] = 0x0000ed265e857f2aUL;
   tf->codes[17960] = 0x0000f09cfbf8d9deUL;
   tf->codes[17961] = 0x0000f1ae9027ce3aUL;
   tf->codes[17962] = 0x0000f1f32fc29116UL;
   tf->codes[17963] = 0x0000f2c86073924aUL;
   tf->codes[17964] = 0x0000f43deac75fefUL;
   tf->codes[17965] = 0x0000f743131f8cf3UL;
   tf->codes[17966] = 0x0000f76144de8687UL;
   tf->codes[17967] = 0x0000f8a5dba3817eUL;
   tf->codes[17968] = 0x0000f9fe1e746ca3UL;
   tf->codes[17969] = 0x0000faa4dfbbdaa0UL;
   tf->codes[17970] = 0x0000faf529d4c3bbUL;
   tf->codes[17971] = 0x0000fb14baeddfedUL;
   tf->codes[17972] = 0x0000fbe642ae84d1UL;
   tf->codes[17973] = 0x0000fcdf22870a11UL;
   tf->codes[17974] = 0x0000ff56787d3df9UL;
   tf->codes[17975] = 0x000001cca9a85508UL;
   tf->codes[17976] = 0x00000db6f9adddbbUL;
   tf->codes[17977] = 0x00000eefe5f4b273UL;
   tf->codes[17978] = 0x000011aff9941111UL;
   tf->codes[17979] = 0x00001293ce068385UL;
   tf->codes[17980] = 0x0000148f63bd861cUL;
   tf->codes[17981] = 0x000015a96e984ff1UL;
   tf->codes[17982] = 0x000019d9c9b1f781UL;
   tf->codes[17983] = 0x00001abe1342757fUL;
   tf->codes[17984] = 0x00001c62821de1e5UL;
   tf->codes[17985] = 0x000022e35033e88bUL;
   tf->codes[17986] = 0x00002622cd02d4caUL;
   tf->codes[17987] = 0x00002668cbf7ba44UL;
   tf->codes[17988] = 0x000028153c60f099UL;
   tf->codes[17989] = 0x00002928df9718e2UL;
   tf->codes[17990] = 0x00002d1c6214c1c0UL;
   tf->codes[17991] = 0x000032064045b067UL;
   tf->codes[17992] = 0x0000331d8c6c3500UL;
   tf->codes[17993] = 0x0000339778333829UL;
   tf->codes[17994] = 0x0000349734ce6a7fUL;
   tf->codes[17995] = 0x00003656dc258578UL;
   tf->codes[17996] = 0x00003a25502187acUL;
   tf->codes[17997] = 0x00003a308581a261UL;
   tf->codes[17998] = 0x00003ab65655d18eUL;
   tf->codes[17999] = 0x00003d33d961a13dUL;
   tf->codes[18000] = 0x00003f5ec8be4e1fUL;
   tf->codes[18001] = 0x0000419109fbb3a1UL;
   tf->codes[18002] = 0x000041acb7956dbeUL;
   tf->codes[18003] = 0x00004358785192c4UL;
   tf->codes[18004] = 0x00004404075479eaUL;
   tf->codes[18005] = 0x000044bb40d5874fUL;
   tf->codes[18006] = 0x000045c3e93a9aa8UL;
   tf->codes[18007] = 0x000045f308513f2eUL;
   tf->codes[18008] = 0x00004747dcc0d3c8UL;
   tf->codes[18009] = 0x00004863bc13cbc5UL;
   tf->codes[18010] = 0x000048ac3f2df0b6UL;
   tf->codes[18011] = 0x00004a83b09f63b7UL;
   tf->codes[18012] = 0x00004b5bda93afecUL;
   tf->codes[18013] = 0x00004c2f715b88bdUL;
   tf->codes[18014] = 0x00004c3f74771c9bUL;
   tf->codes[18015] = 0x00004e3a951013a8UL;
   tf->codes[18016] = 0x00005315cf7f910fUL;
   tf->codes[18017] = 0x000055cb97faec0cUL;
   tf->codes[18018] = 0x000057a58d919e84UL;
   tf->codes[18019] = 0x000057e7e39627aeUL;
   tf->codes[18020] = 0x000058bbef7c0c09UL;
   tf->codes[18021] = 0x00005aa11a72d936UL;
   tf->codes[18022] = 0x00005cf068a41b73UL;
   tf->codes[18023] = 0x00005e57fee38927UL;
   tf->codes[18024] = 0x00005f56d142a469UL;
   tf->codes[18025] = 0x00006296c32f9c32UL;
   tf->codes[18026] = 0x0000649885fc3a90UL;
   tf->codes[18027] = 0x00006599a1f18f84UL;
   tf->codes[18028] = 0x000067d1260879b9UL;
   tf->codes[18029] = 0x000067f12c3fa175UL;
   tf->codes[18030] = 0x00006ab891bfb8b3UL;
   tf->codes[18031] = 0x00006c214cca4340UL;
   tf->codes[18032] = 0x00006eef19eefc0aUL;
   tf->codes[18033] = 0x00006f86c256ed3dUL;
   tf->codes[18034] = 0x00006ff8e71f2c3cUL;
   tf->codes[18035] = 0x000072c345e28e7bUL;
   tf->codes[18036] = 0x00007581fa27ca7bUL;
   tf->codes[18037] = 0x0000796b31816fb8UL;
   tf->codes[18038] = 0x0000796df035b4f4UL;
   tf->codes[18039] = 0x00007c9f03d235b8UL;
   tf->codes[18040] = 0x00007d49337afa40UL;
   tf->codes[18041] = 0x00007d7a9c27d878UL;
   tf->codes[18042] = 0x00007f645a4b1909UL;
   tf->codes[18043] = 0x000082422a8b65b1UL;
   tf->codes[18044] = 0x0000873d6b320ad4UL;
   tf->codes[18045] = 0x00008f79fd1fca5eUL;
   tf->codes[18046] = 0x000091f3621d3233UL;
   tf->codes[18047] = 0x0000924be852eb02UL;
   tf->codes[18048] = 0x00009278f8625b9bUL;
   tf->codes[18049] = 0x00009350ad389c46UL;
   tf->codes[18050] = 0x000093fe4b42b759UL;
   tf->codes[18051] = 0x00009495f3aaa88cUL;
   tf->codes[18052] = 0x0000949be6313e8eUL;
   tf->codes[18053] = 0x00009557b2debf57UL;
   tf->codes[18054] = 0x0000958e98f42807UL;
   tf->codes[18055] = 0x0000961678cf8b21UL;
   tf->codes[18056] = 0x0000967ddd55baf5UL;
   tf->codes[18057] = 0x0000978a2eab2a9eUL;
   tf->codes[18058] = 0x000098a1b560b4fcUL;
   tf->codes[18059] = 0x000098df3da9c4fdUL;
   tf->codes[18060] = 0x00009a2533c8e292UL;
   tf->codes[18061] = 0x00009a9633c604b8UL;
   tf->codes[18062] = 0x00009d51048bdea3UL;
   tf->codes[18063] = 0x00009f53b1949415UL;
   tf->codes[18064] = 0x0000a057c6cd340aUL;
   tf->codes[18065] = 0x0000a270de961ee6UL;
   tf->codes[18066] = 0x0000a2b19ab17fadUL;
   tf->codes[18067] = 0x0000a324e444db85UL;
   tf->codes[18068] = 0x0000a49775555e29UL;
   tf->codes[18069] = 0x0000a5caa9a4a2a4UL;
   tf->codes[18070] = 0x0000a6099147d543UL;
   tf->codes[18071] = 0x0000aa0fd595573bUL;
   tf->codes[18072] = 0x0000aaf160718ffdUL;
   tf->codes[18073] = 0x0000acb1b775bc45UL;
   tf->codes[18074] = 0x0000acf0d9a7f4a9UL;
   tf->codes[18075] = 0x0000aebf99de8c6cUL;
   tf->codes[18076] = 0x0000af16c0ba229dUL;
   tf->codes[18077] = 0x0000b135cb09a37bUL;
   tf->codes[18078] = 0x0000b2c7b2a43c8cUL;
   tf->codes[18079] = 0x0000b3daa62d5386UL;
   tf->codes[18080] = 0x0000b4fb18acbee7UL;
   tf->codes[18081] = 0x0000b74b511a1838UL;
   tf->codes[18082] = 0x0000b92d483e949fUL;
   tf->codes[18083] = 0x0000b9542b386971UL;
   tf->codes[18084] = 0x0000bb7f1a951653UL;
   tf->codes[18085] = 0x0000bf822b104785UL;
   tf->codes[18086] = 0x0000c3bf5573322dUL;
   tf->codes[18087] = 0x0000c439b65840e0UL;
   tf->codes[18088] = 0x0000c469bfaafc7aUL;
   tf->codes[18089] = 0x0000c9ae6da7dda2UL;
   tf->codes[18090] = 0x0000ca2e86847c92UL;
   tf->codes[18091] = 0x0000cb6822786299UL;
   tf->codes[18092] = 0x0000cb86c95567b7UL;
   tf->codes[18093] = 0x0000cb9a756157e5UL;
   tf->codes[18094] = 0x0000cbcfc18d9832UL;
   tf->codes[18095] = 0x0000cda9f1b3506fUL;
   tf->codes[18096] = 0x0000ce1c510a9533UL;
   tf->codes[18097] = 0x0000ceb9b16a16a3UL;
   tf->codes[18098] = 0x0000d7b36f5f7994UL;
   tf->codes[18099] = 0x0000da0875884c0eUL;
   tf->codes[18100] = 0x0000da7c3439b370UL;
   tf->codes[18101] = 0x0000e5443d47a29aUL;
   tf->codes[18102] = 0x0000e77bfbed9294UL;
   tf->codes[18103] = 0x0000ece1d4ecb851UL;
   tf->codes[18104] = 0x0000f30798a7c6b1UL;
   tf->codes[18105] = 0x0000f404d11db990UL;
   tf->codes[18106] = 0x0000f625afe56896UL;
   tf->codes[18107] = 0x0000f6a21fd1ab36UL;
   tf->codes[18108] = 0x0000f7ffa57c1b0eUL;
   tf->codes[18109] = 0x0000f8d71fc355f4UL;
   tf->codes[18110] = 0x0000faff8afac35fUL;
   tf->codes[18111] = 0x0000fc6218efb225UL;
   tf->codes[18112] = 0x000003a1acf68495UL;
   tf->codes[18113] = 0x000004eb8695043fUL;
   tf->codes[18114] = 0x000005b71bcf1321UL;
   tf->codes[18115] = 0x000005fd5552fe60UL;
   tf->codes[18116] = 0x000007617d311589UL;
   tf->codes[18117] = 0x000007c27a12a3d1UL;
   tf->codes[18118] = 0x00000ac29a2051e7UL;
   tf->codes[18119] = 0x000010419c93f24aUL;
   tf->codes[18120] = 0x00001382eddb0cb1UL;
   tf->codes[18121] = 0x0000148fb44e87e4UL;
   tf->codes[18122] = 0x000015f4514aaa97UL;
   tf->codes[18123] = 0x00001706cfb5b607UL;
   tf->codes[18124] = 0x00001872497485d0UL;
   tf->codes[18125] = 0x0000200bfd9a3972UL;
   tf->codes[18126] = 0x000021db6d7de284UL;
   tf->codes[18127] = 0x00002678e5154a25UL;
   tf->codes[18128] = 0x00002c3cfc41b8eeUL;
   tf->codes[18129] = 0x00002e238692a8b9UL;
   tf->codes[18130] = 0x00002ecfc542a12eUL;
   tf->codes[18131] = 0x000030943a553550UL;
   tf->codes[18132] = 0x00003369595aa6baUL;
   tf->codes[18133] = 0x00003380e8e5f8fdUL;
   tf->codes[18134] = 0x000037433d45c968UL;
   tf->codes[18135] = 0x0000382b2fc6a3b6UL;
   tf->codes[18136] = 0x0000389f639616a2UL;
   tf->codes[18137] = 0x00003a1ec3efdc5eUL;
   tf->codes[18138] = 0x00003aa62ead33eeUL;
   tf->codes[18139] = 0x00003fd3128fbd0eUL;
   tf->codes[18140] = 0x00003feb17391adbUL;
   tf->codes[18141] = 0x000041d79410a0a8UL;
   tf->codes[18142] = 0x0000420bf600c9e1UL;
   tf->codes[18143] = 0x00004331e5e8bfbaUL;
   tf->codes[18144] = 0x00004397b085c72bUL;
   tf->codes[18145] = 0x000045187039af85UL;
   tf->codes[18146] = 0x0000479d0a97320fUL;
   tf->codes[18147] = 0x0000495b52942a6aUL;
   tf->codes[18148] = 0x000049659db82e0bUL;
   tf->codes[18149] = 0x00004aa023e82b26UL;
   tf->codes[18150] = 0x00004b54d943f914UL;
   tf->codes[18151] = 0x00004c8a91b87d06UL;
   tf->codes[18152] = 0x00004ed4628134cbUL;
   tf->codes[18153] = 0x00004fd83d2acefbUL;
   tf->codes[18154] = 0x00005148bf341db2UL;
   tf->codes[18155] = 0x000051f99110898bUL;
   tf->codes[18156] = 0x0000530189c88b95UL;
   tf->codes[18157] = 0x0000550f6c315bbcUL;
   tf->codes[18158] = 0x000055a037d69fd9UL;
   tf->codes[18159] = 0x000055f96db969f7UL;
   tf->codes[18160] = 0x00005a8ac5b49fcfUL;
   tf->codes[18161] = 0x00005ac60467761eUL;
   tf->codes[18162] = 0x00005b19f770bb89UL;
   tf->codes[18163] = 0x00005bceaccc8977UL;
   tf->codes[18164] = 0x000061a8447d1696UL;
   tf->codes[18165] = 0x00006444e383f6edUL;
   tf->codes[18166] = 0x0000661c8f846fb3UL;
   tf->codes[18167] = 0x000068da598d949fUL;
   tf->codes[18168] = 0x00006a29b0949ec1UL;
   tf->codes[18169] = 0x00006dca9f6324d2UL;
   tf->codes[18170] = 0x00006fb8f0b2d8c7UL;
   tf->codes[18171] = 0x00007066542dee15UL;
   tf->codes[18172] = 0x0000707f08845d31UL;
   tf->codes[18173] = 0x00007260156cc284UL;
   tf->codes[18174] = 0x000073b1b60a0658UL;
   tf->codes[18175] = 0x000078eba3c4d855UL;
   tf->codes[18176] = 0x00007c78716962aeUL;
   tf->codes[18177] = 0x00007ca8efda29d2UL;
   tf->codes[18178] = 0x00007ef8037c664aUL;
   tf->codes[18179] = 0x00007f11a20eec7aUL;
   tf->codes[18180] = 0x000083da8fcc9c51UL;
   tf->codes[18181] = 0x000086d3236a8c02UL;
   tf->codes[18182] = 0x000088892f4ab4a9UL;
   tf->codes[18183] = 0x00008b26b88dac14UL;
   tf->codes[18184] = 0x00008e4b376fef85UL;
   tf->codes[18185] = 0x00008f365dc31a99UL;
   tf->codes[18186] = 0x00008f8d0f80a540UL;
   tf->codes[18187] = 0x000090b3e9a4b22dUL;
   tf->codes[18188] = 0x000090dbf169a3d8UL;
   tf->codes[18189] = 0x0000974cf6f31c65UL;
   tf->codes[18190] = 0x000097d49c3f79baUL;
   tf->codes[18191] = 0x00009879fe2cc519UL;
   tf->codes[18192] = 0x00009a917c0c8792UL;
   tf->codes[18193] = 0x00009b3c20d357a4UL;
   tf->codes[18194] = 0x00009d1bce619a59UL;
   tf->codes[18195] = 0x0000a1224d3e2216UL;
   tf->codes[18196] = 0x0000a4efd6fe0d36UL;
   tf->codes[18197] = 0x0000b01aebf4be95UL;
   tf->codes[18198] = 0x0000b46f6b53f5bbUL;
   tf->codes[18199] = 0x0000b501213550ecUL;
   tf->codes[18200] = 0x0000b59bfd6f92e5UL;
   tf->codes[18201] = 0x0000b7e6f3036783UL;
   tf->codes[18202] = 0x0000bd52be892342UL;
   tf->codes[18203] = 0x0000be72f67988deUL;
   tf->codes[18204] = 0x0000bf69522ccea7UL;
   tf->codes[18205] = 0x0000bfa9240c185aUL;
   tf->codes[18206] = 0x0000c16d991eac7cUL;
   tf->codes[18207] = 0x0000c39554a90898UL;
   tf->codes[18208] = 0x0000c43364b59b57UL;
   tf->codes[18209] = 0x0000c4ef6bf221e5UL;
   tf->codes[18210] = 0x0000c6bea146c532UL;
   tf->codes[18211] = 0x0000c6c508eb66beUL;
   tf->codes[18212] = 0x0000c7773a21f535UL;
   tf->codes[18213] = 0x0000c920ebd6e64eUL;
   tf->codes[18214] = 0x0000cdac8bda8be9UL;
   tf->codes[18215] = 0x0000ce3590810bdcUL;
   tf->codes[18216] = 0x0000cfa10a3fdba5UL;
   tf->codes[18217] = 0x0000d118a39add37UL;
   tf->codes[18218] = 0x0000d226c9687b08UL;
   tf->codes[18219] = 0x0000d3a2f5efeffeUL;
   tf->codes[18220] = 0x0000d43f6c135a5aUL;
   tf->codes[18221] = 0x0000db1eb2e5afd1UL;
   tf->codes[18222] = 0x0000deb640cc4955UL;
   tf->codes[18223] = 0x0000dfe25dc9daf5UL;
   tf->codes[18224] = 0x0000e1e127532e52UL;
   tf->codes[18225] = 0x0000e5182d764518UL;
   tf->codes[18226] = 0x0000e76b5f26e96aUL;
   tf->codes[18227] = 0x0000e8ae5c02bbfeUL;
   tf->codes[18228] = 0x0000ed87124cf9eeUL;
   tf->codes[18229] = 0x0000edc968518318UL;
   tf->codes[18230] = 0x0000f1ec4474d641UL;
   tf->codes[18231] = 0x0000f288f5274662UL;
   tf->codes[18232] = 0x0000f298f842da40UL;
   tf->codes[18233] = 0x0000f6af051cea51UL;
   tf->codes[18234] = 0x0000f8e8983b0873UL;
   tf->codes[18235] = 0x0000fa3cf78c9183UL;
   tf->codes[18236] = 0x0000fade75fa7acdUL;
   tf->codes[18237] = 0x0000fc10857ea26fUL;
   tf->codes[18238] = 0x0000fc5649e48224UL;
   tf->codes[18239] = 0x0000fc5fe55b7476UL;
   tf->codes[18240] = 0x0000fc7f767490a8UL;
   tf->codes[18241] = 0x0000fe600e3eea71UL;
   tf->codes[18242] = 0x0000feca6c086546UL;
   tf->codes[18243] = 0x0000021bc06b138bUL;
   tf->codes[18244] = 0x00000a4c6d4ba711UL;
   tf->codes[18245] = 0x000013650cad14e5UL;
   tf->codes[18246] = 0x0000147506f2e0deUL;
   tf->codes[18247] = 0x0000154c46ab15ffUL;
   tf->codes[18248] = 0x00001d9ff3061c42UL;
   tf->codes[18249] = 0x00001f988f79d3d8UL;
   tf->codes[18250] = 0x000025fc509bfdc3UL;
   tf->codes[18251] = 0x0000279eb070363cUL;
   tf->codes[18252] = 0x0000289b393917ccUL;
   tf->codes[18253] = 0x00002f24b889f9b0UL;
   tf->codes[18254] = 0x000030ac1a71895bUL;
   tf->codes[18255] = 0x0000335acb9b317dUL;
   tf->codes[18256] = 0x0000338a5fcfe18dUL;
   tf->codes[18257] = 0x00003972d5d0e5b1UL;
   tf->codes[18258] = 0x000039cc0bb3afcfUL;
   tf->codes[18259] = 0x00003d3e50899ce4UL;
   tf->codes[18260] = 0x00004127fd014dabUL;
   tf->codes[18261] = 0x00004204450401baUL;
   tf->codes[18262] = 0x00004244c6905cbcUL;
   tf->codes[18263] = 0x0000427669cc40b9UL;
   tf->codes[18264] = 0x000045f45920540dUL;
   tf->codes[18265] = 0x0000473546f4f2b4UL;
   tf->codes[18266] = 0x0000475f5dc1184cUL;
   tf->codes[18267] = 0x00004a47ee43741fUL;
   tf->codes[18268] = 0x00004bb5ec27835fUL;
   tf->codes[18269] = 0x00004c1b41a67f46UL;
   tf->codes[18270] = 0x00004d41a6ac80a9UL;
   tf->codes[18271] = 0x00004d8b4e91c273UL;
   tf->codes[18272] = 0x000051c803d6a191UL;
   tf->codes[18273] = 0x00005344e00b27d6UL;
   tf->codes[18274] = 0x000053d8a4f3b6f4UL;
   tf->codes[18275] = 0x000055b4347391cfUL;
   tf->codes[18276] = 0x0000564f85cbdf52UL;
   tf->codes[18277] = 0x0000570266af7f18UL;
   tf->codes[18278] = 0x0000593bf9cd9d3aUL;
   tf->codes[18279] = 0x000059868beef618UL;
   tf->codes[18280] = 0x00005bfc0d6cfbd8UL;
   tf->codes[18281] = 0x000061630b373e6eUL;
   tf->codes[18282] = 0x000061de56586435UL;
   tf->codes[18283] = 0x0000653b553938b9UL;
   tf->codes[18284] = 0x000065c5f3c8e10fUL;
   tf->codes[18285] = 0x00006b26c47d87deUL;
   tf->codes[18286] = 0x00006dd15798c826UL;
   tf->codes[18287] = 0x00006ec6c90ff6dbUL;
   tf->codes[18288] = 0x00006f6513ab8f5fUL;
   tf->codes[18289] = 0x000071005c2e14fdUL;
   tf->codes[18290] = 0x000071147d5810b5UL;
   tf->codes[18291] = 0x00007249861f8358UL;
   tf->codes[18292] = 0x00007725e55a1d98UL;
   tf->codes[18293] = 0x000077ebfd2ba202UL;
   tf->codes[18294] = 0x000077fe49dd6f92UL;
   tf->codes[18295] = 0x00007940d19b369cUL;
   tf->codes[18296] = 0x00007982b281b43cUL;
   tf->codes[18297] = 0x00007a84b8b32044UL;
   tf->codes[18298] = 0x000085090c6263a6UL;
   tf->codes[18299] = 0x000085b87ee4ace1UL;
   tf->codes[18300] = 0x000087b8a7c822dcUL;
   tf->codes[18301] = 0x00008a9259fa07aaUL;
   tf->codes[18302] = 0x00008bf76c1435e7UL;
   tf->codes[18303] = 0x00008c064a64acecUL;
   tf->codes[18304] = 0x00008c67bc6446beUL;
   tf->codes[18305] = 0x00008ccf5b797c57UL;
   tf->codes[18306] = 0x00008da11dc92700UL;
   tf->codes[18307] = 0x000092df9eb06c61UL;
   tf->codes[18308] = 0x0000944fe62ab553UL;
   tf->codes[18309] = 0x0000948c49a8a87bUL;
   tf->codes[18310] = 0x000094dc1ea3860cUL;
   tf->codes[18311] = 0x000097ba9e90e403UL;
   tf->codes[18312] = 0x000098348a57e72cUL;
   tf->codes[18313] = 0x000099340c6413bdUL;
   tf->codes[18314] = 0x00009bb4139522e3UL;
   tf->codes[18315] = 0x0000a42960107945UL;
   tf->codes[18316] = 0x0000a95ef52ddda3UL;
   tf->codes[18317] = 0x0000ad11bb9025baUL;
   tf->codes[18318] = 0x0000b413c74de829UL;
   tf->codes[18319] = 0x0000b5f9dc80cc6aUL;
   tf->codes[18320] = 0x0000b7ad29acafd5UL;
   tf->codes[18321] = 0x0000b86c2a2c8164UL;
   tf->codes[18322] = 0x0000b93c1803fde5UL;
   tf->codes[18323] = 0x0000b9b011446b0cUL;
   tf->codes[18324] = 0x0000bdab954fddd9UL;
   tf->codes[18325] = 0x0000bf416069d8ffUL;
   tf->codes[18326] = 0x0000bf875f5ebe79UL;
   tf->codes[18327] = 0x0000c12fb1b98cf4UL;
   tf->codes[18328] = 0x0000c1c96928b214UL;
   tf->codes[18329] = 0x0000c463497b4d2fUL;
   tf->codes[18330] = 0x0000c5200064e50cUL;
   tf->codes[18331] = 0x0000c5cfad76340cUL;
   tf->codes[18332] = 0x0000c6abbae9e256UL;
   tf->codes[18333] = 0x0000c8389a39fc79UL;
   tf->codes[18334] = 0x0000c8ecda77beddUL;
   tf->codes[18335] = 0x0000c8edff42dbb6UL;
   tf->codes[18336] = 0x0000cd44531a4104UL;
   tf->codes[18337] = 0x0000cf677b7829bcUL;
   tf->codes[18338] = 0x0000d0894d51b7bbUL;
   tf->codes[18339] = 0x0000d287672df9c9UL;
   tf->codes[18340] = 0x0000d335053814dcUL;
   tf->codes[18341] = 0x0000d47be5934985UL;
   tf->codes[18342] = 0x0000d75d2434ecb8UL;
   tf->codes[18343] = 0x0000dee242129918UL;
   tf->codes[18344] = 0x0000e29ccf73a559UL;
   tf->codes[18345] = 0x0000e9473f37c60dUL;
   tf->codes[18346] = 0x0000eb48c7755ea6UL;
   tf->codes[18347] = 0x0000eba35cb24b62UL;
   tf->codes[18348] = 0x0000ec738518cda8UL;
   tf->codes[18349] = 0x0000edd4b3b399d0UL;
   tf->codes[18350] = 0x0000ef0c40a04beaUL;
   tf->codes[18351] = 0x0000f31ea489ffabUL;
   tf->codes[18352] = 0x0000f3a5250b4027UL;
   tf->codes[18353] = 0x0000f916e31791e8UL;
   tf->codes[18354] = 0x0000fb7a8d01d5a2UL;
   tf->codes[18355] = 0x0000fd385fe0c273UL;
   tf->codes[18356] = 0x00000096be1bb995UL;
   tf->codes[18357] = 0x00000652240d4d20UL;
   tf->codes[18358] = 0x000007266a823740UL;
   tf->codes[18359] = 0x00000929178aecb2UL;
   tf->codes[18360] = 0x00000d1164a87adbUL;
   tf->codes[18361] = 0x00000de411343c98UL;
   tf->codes[18362] = 0x00000f1202a9fc60UL;
   tf->codes[18363] = 0x00001456eb35e34dUL;
   tf->codes[18364] = 0x000016807b386d91UL;
   tf->codes[18365] = 0x000016ba5a912142UL;
   tf->codes[18366] = 0x00002081bcc7c702UL;
   tf->codes[18367] = 0x000020ae924831d6UL;
   tf->codes[18368] = 0x000021b984437ee1UL;
   tf->codes[18369] = 0x0000222f51fc1a30UL;
   tf->codes[18370] = 0x0000272c2c8be7b6UL;
   tf->codes[18371] = 0x00002e2a8f594dd5UL;
   tf->codes[18372] = 0x000030db4f8a29e4UL;
   tf->codes[18373] = 0x0000325a7554e9dbUL;
   tf->codes[18374] = 0x0000330ad2134a2aUL;
   tf->codes[18375] = 0x0000338cf9f71d07UL;
   tf->codes[18376] = 0x000038a87b63efabUL;
   tf->codes[18377] = 0x00003c0af7ad4ea7UL;
   tf->codes[18378] = 0x00003cbb546baef6UL;
   tf->codes[18379] = 0x00003fe082fb03b6UL;
   tf->codes[18380] = 0x0000425a5d167715UL;
   tf->codes[18381] = 0x0000471b49465cfdUL;
   tf->codes[18382] = 0x00004949e193662fUL;
   tf->codes[18383] = 0x0000498fe0884ba9UL;
   tf->codes[18384] = 0x00004be5965e2f72UL;
   tf->codes[18385] = 0x00004d4022c55449UL;
   tf->codes[18386] = 0x00004e4c741ac3f2UL;
   tf->codes[18387] = 0x00004f525dcb920fUL;
   tf->codes[18388] = 0x0000504fd0d08ab3UL;
   tf->codes[18389] = 0x00005148761a0a2eUL;
   tf->codes[18390] = 0x000051a08731b773UL;
   tf->codes[18391] = 0x0000525835d0d062UL;
   tf->codes[18392] = 0x00005745f781211eUL;
   tf->codes[18393] = 0x000061452a0946a2UL;
   tf->codes[18394] = 0x00006af5e6f0b133UL;
   tf->codes[18395] = 0x0000706177e7672dUL;
   tf->codes[18396] = 0x000070abcf79ba46UL;
   tf->codes[18397] = 0x00007171379e2d61UL;
   tf->codes[18398] = 0x000072d4002221ecUL;
   tf->codes[18399] = 0x000073ea277d89acUL;
   tf->codes[18400] = 0x000074a8ed6e5576UL;
   tf->codes[18401] = 0x000076777315e774UL;
   tf->codes[18402] = 0x00007b57b5cfe3c9UL;
   tf->codes[18403] = 0x00007d151390c510UL;
   tf->codes[18404] = 0x00007d18f7102725UL;
   tf->codes[18405] = 0x00007e8c37cdbb18UL;
   tf->codes[18406] = 0x00007eaefcb92810UL;
   tf->codes[18407] = 0x00007eee94096bfeUL;
   tf->codes[18408] = 0x0000801692f895c4UL;
   tf->codes[18409] = 0x000081289c4595aaUL;
   tf->codes[18410] = 0x00008447d84e5468UL;
   tf->codes[18411] = 0x000084de215c22fdUL;
   tf->codes[18412] = 0x000087954931a098UL;
   tf->codes[18413] = 0x000088ba144e7998UL;
   tf->codes[18414] = 0x000089782a923413UL;
   tf->codes[18415] = 0x00008a384fdd227bUL;
   tf->codes[18416] = 0x00008d8a195ddc4aUL;
   tf->codes[18417] = 0x00008ec5fee7fc03UL;
   tf->codes[18418] = 0x000090f19df1ba34UL;
   tf->codes[18419] = 0x000092c3cc89a882UL;
   tf->codes[18420] = 0x0000979c82d3e672UL;
   tf->codes[18421] = 0x000098d44a4f9e51UL;
   tf->codes[18422] = 0x0000991f8c1e087eUL;
   tf->codes[18423] = 0x0000a05d111da701UL;
   tf->codes[18424] = 0x0000a2f8163b5ef5UL;
   tf->codes[18425] = 0x0000a470d4617d60UL;
   tf->codes[18426] = 0x0000a65674765617UL;
   tf->codes[18427] = 0x0000b17828851ae9UL;
   tf->codes[18428] = 0x0000b2d5ae2f8ac1UL;
   tf->codes[18429] = 0x0000b78ff82bc958UL;
   tf->codes[18430] = 0x0000b8b781fce794UL;
   tf->codes[18431] = 0x0000b90df92b6c76UL;
   tf->codes[18432] = 0x0000badfb2a54f3aUL;
   tf->codes[18433] = 0x0000bf72a489ad75UL;
   tf->codes[18434] = 0x0000c2fb8eaed5b9UL;
   tf->codes[18435] = 0x0000c4ebb476b7d6UL;
   tf->codes[18436] = 0x0000c6dc89ebab42UL;
   tf->codes[18437] = 0x0000c7d09c08b759UL;
   tf->codes[18438] = 0x0000c826638a2aecUL;
   tf->codes[18439] = 0x0000c834579e8addUL;
   tf->codes[18440] = 0x0000ca27b138bdc0UL;
   tf->codes[18441] = 0x0000cb7115b931e0UL;
   tf->codes[18442] = 0x0000cbba48806820UL;
   tf->codes[18443] = 0x0000cc77e9a61711UL;
   tf->codes[18444] = 0x0000ccbb9f04c2d9UL;
   tf->codes[18445] = 0x0000d185b18d8f89UL;
   tf->codes[18446] = 0x0000d73950805eeaUL;
   tf->codes[18447] = 0x0000d786dbe502c9UL;
   tf->codes[18448] = 0x0000d9e78c8bfb82UL;
   tf->codes[18449] = 0x0000e0a7b7634051UL;
   tf->codes[18450] = 0x0000e123ecc07d2cUL;
   tf->codes[18451] = 0x0000e7e710db0cfcUL;
   tf->codes[18452] = 0x0000ea5540785a1cUL;
   tf->codes[18453] = 0x0000ee2bb602263fUL;
   tf->codes[18454] = 0x0000f51d0ef74381UL;
   tf->codes[18455] = 0x0000f6d9827c0db4UL;
   tf->codes[18456] = 0x0000f84536c9e342UL;
   tf->codes[18457] = 0x0000fc15f45c1f28UL;
   tf->codes[18458] = 0x0000feb810cb89f7UL;
   tf->codes[18459] = 0x0000ff83e0949e9eUL;
   tf->codes[18460] = 0x0000025d1da877e2UL;
   tf->codes[18461] = 0x000008bf44e1796aUL;
   tf->codes[18462] = 0x000009b05dbb3a80UL;
   tf->codes[18463] = 0x00000bdc71e3043bUL;
   tf->codes[18464] = 0x00001a9db5662c80UL;
   tf->codes[18465] = 0x00001da9ba81069aUL;
   tf->codes[18466] = 0x00001eeaa855a541UL;
   tf->codes[18467] = 0x00001f6f8eedbd5aUL;
   tf->codes[18468] = 0x000024aebf82140aUL;
   tf->codes[18469] = 0x00002637bb52cc18UL;
   tf->codes[18470] = 0x00002695f9801524UL;
   tf->codes[18471] = 0x0000270cb174c787UL;
   tf->codes[18472] = 0x000028146f9dc3ccUL;
   tf->codes[18473] = 0x00002875a70e57d9UL;
   tf->codes[18474] = 0x000028aba2e7a975UL;
   tf->codes[18475] = 0x0000294cac378735UL;
   tf->codes[18476] = 0x00002972df844ab8UL;
   tf->codes[18477] = 0x00002daa51efa523UL;
   tf->codes[18478] = 0x00003020bda9c1f7UL;
   tf->codes[18479] = 0x000031eaeab3e656UL;
   tf->codes[18480] = 0x000036fbabdea9cfUL;
   tf->codes[18481] = 0x000036fedfb0fa95UL;
   tf->codes[18482] = 0x000038825e19282bUL;
   tf->codes[18483] = 0x00003a56d647502bUL;
   tf->codes[18484] = 0x00003ec91247755bUL;
   tf->codes[18485] = 0x000040445492d33dUL;
   tf->codes[18486] = 0x00004163a24721c5UL;
   tf->codes[18487] = 0x0000419286cec086UL;
   tf->codes[18488] = 0x000042886d63fac5UL;
   tf->codes[18489] = 0x000043e19a70fcfeUL;
   tf->codes[18490] = 0x000048bc25336916UL;
   tf->codes[18491] = 0x00004ada0ab7cd1bUL;
   tf->codes[18492] = 0x00004c05b2975331UL;
   tf->codes[18493] = 0x000053383cc5dcc4UL;
   tf->codes[18494] = 0x0000544578576381UL;
   tf->codes[18495] = 0x00005e7ec4c7427bUL;
   tf->codes[18496] = 0x00005f922d6e64ffUL;
   tf->codes[18497] = 0x0000636952a54271UL;
   tf->codes[18498] = 0x0000674a13531235UL;
   tf->codes[18499] = 0x00006821187c4191UL;
   tf->codes[18500] = 0x000069df9b083fb1UL;
   tf->codes[18501] = 0x00006ad0ee71068cUL;
   tf->codes[18502] = 0x00006b7d2d20ff01UL;
   tf->codes[18503] = 0x00007049c3cf0b28UL;
   tf->codes[18504] = 0x000070a99be57c97UL;
   tf->codes[18505] = 0x0000714771630991UL;
   tf->codes[18506] = 0x000072f6db0f8ae7UL;
   tf->codes[18507] = 0x000074e4b7413352UL;
   tf->codes[18508] = 0x00007501fec415d2UL;
   tf->codes[18509] = 0x000075d34bf5b4f1UL;
   tf->codes[18510] = 0x000078c41894e078UL;
   tf->codes[18511] = 0x0000792d51933e74UL;
   tf->codes[18512] = 0x00007b4494e3fb28UL;
   tf->codes[18513] = 0x00007cf0cabe2bb8UL;
   tf->codes[18514] = 0x00007fed41db7d7eUL;
   tf->codes[18515] = 0x000085255b1e2153UL;
   tf->codes[18516] = 0x00008d36b1749e6cUL;
   tf->codes[18517] = 0x00008ea10668515cUL;
   tf->codes[18518] = 0x000091cfd06e986eUL;
   tf->codes[18519] = 0x0000932ce0fafcbcUL;
   tf->codes[18520] = 0x000093e3dfed045cUL;
   tf->codes[18521] = 0x000094608a684cc1UL;
   tf->codes[18522] = 0x000098f132b6714aUL;
   tf->codes[18523] = 0x00009cc599390980UL;
   tf->codes[18524] = 0x00009d0a7362d221UL;
   tf->codes[18525] = 0x00009d8f9489efffUL;
   tf->codes[18526] = 0x0000a2ccb61712c2UL;
   tf->codes[18527] = 0x0000a3a4a57c5932UL;
   tf->codes[18528] = 0x0000a4e558c1f214UL;
   tf->codes[18529] = 0x0000a6735cdd2910UL;
   tf->codes[18530] = 0x0000a6cba883dc1aUL;
   tf->codes[18531] = 0x0000a7c4fd7a6ce4UL;
   tf->codes[18532] = 0x0000aa32b7f9ae7aUL;
   tf->codes[18533] = 0x0000aa8302129795UL;
   tf->codes[18534] = 0x0000ab1a6feb8303UL;
   tf->codes[18535] = 0x0000acc1d80a3a6aUL;
   tf->codes[18536] = 0x0000adbf10802d49UL;
   tf->codes[18537] = 0x0000b22f78082451UL;
   tf->codes[18538] = 0x0000b3260e4a6fdfUL;
   tf->codes[18539] = 0x0000b32adc05e908UL;
   tf->codes[18540] = 0x0000b39ffa117308UL;
   tf->codes[18541] = 0x0000b79e3cd12b11UL;
   tf->codes[18542] = 0x0000b813204daf4cUL;
   tf->codes[18543] = 0x0000b8a301b6dc55UL;
   tf->codes[18544] = 0x0000bae9d93c4919UL;
   tf->codes[18545] = 0x0000bca318eec286UL;
   tf->codes[18546] = 0x0000bcb05d561128UL;
   tf->codes[18547] = 0x0000bde1480f1bf1UL;
   tf->codes[18548] = 0x0000c08af0ee4525UL;
   tf->codes[18549] = 0x0000c2b9141d42cdUL;
   tf->codes[18550] = 0x0000c3893c83c513UL;
   tf->codes[18551] = 0x0000c4de4b825f72UL;
   tf->codes[18552] = 0x0000c63c464adad4UL;
   tf->codes[18553] = 0x0000c93fd4b9df75UL;
   tf->codes[18554] = 0x0000ccdbbb3de698UL;
   tf->codes[18555] = 0x0000ceb242734285UL;
   tf->codes[18556] = 0x0000cfed785050efUL;
   tf->codes[18557] = 0x0000d04a1c947198UL;
   tf->codes[18558] = 0x0000d1c4e9c1c3f0UL;
   tf->codes[18559] = 0x0000d3206064ffdbUL;
   tf->codes[18560] = 0x0000d3e8121faca8UL;
   tf->codes[18561] = 0x0000d60f1dfcf775UL;
   tf->codes[18562] = 0x0000d98162d2e48aUL;
   tf->codes[18563] = 0x0000da09b7cc532eUL;
   tf->codes[18564] = 0x0000ddebd7d44590UL;
   tf->codes[18565] = 0x0000e71c06c105a7UL;
   tf->codes[18566] = 0x0000e92b4883f86cUL;
   tf->codes[18567] = 0x0000ed13d0308c5aUL;
   tf->codes[18568] = 0x0000ee518a32da3bUL;
   tf->codes[18569] = 0x0000f23cd093b365UL;
   tf->codes[18570] = 0x0000fdd8aaf88125UL;
   tf->codes[18571] = 0x0000ffe7b22c6e25UL;
   tf->codes[18572] = 0x0000019840a40c54UL;
   tf->codes[18573] = 0x000002f516a16addUL;
   tf->codes[18574] = 0x000005bec5b7bbcdUL;
   tf->codes[18575] = 0x000008dbf2b9469eUL;
   tf->codes[18576] = 0x00000cd0d491121aUL;
   tf->codes[18577] = 0x00000e58e625b314UL;
   tf->codes[18578] = 0x0000108c86bd3b34UL;
   tf->codes[18579] = 0x000010fa8d771259UL;
   tf->codes[18580] = 0x000017e1d5d731bfUL;
   tf->codes[18581] = 0x00001fde20c79c0cUL;
   tf->codes[18582] = 0x000025b2b02daa3dUL;
   tf->codes[18583] = 0x000028699d742213UL;
   tf->codes[18584] = 0x00002b0acfa775ceUL;
   tf->codes[18585] = 0x00002cf74c7efb9bUL;
   tf->codes[18586] = 0x00002d34251afa4dUL;
   tf->codes[18587] = 0x00002d42192f5a3eUL;
   tf->codes[18588] = 0x00002f6ba931e482UL;
   tf->codes[18589] = 0x0000304f43155131UL;
   tf->codes[18590] = 0x0000336349bdf53aUL;
   tf->codes[18591] = 0x0000342000a78d17UL;
   tf->codes[18592] = 0x0000397aa446981fUL;
   tf->codes[18593] = 0x00003a8f31b8d77cUL;
   tf->codes[18594] = 0x00003c1659116162UL;
   tf->codes[18595] = 0x00003e447c405f0aUL;
   tf->codes[18596] = 0x00003eaf89b6eb2eUL;
   tf->codes[18597] = 0x00003f2ca9503f1dUL;
   tf->codes[18598] = 0x000042f44089943bUL;
   tf->codes[18599] = 0x0000464c371fe9d1UL;
   tf->codes[18600] = 0x000047a897ff3cd0UL;
   tf->codes[18601] = 0x000049a9ab1ec9dfUL;
   tf->codes[18602] = 0x00004c840cfdbffcUL;
   tf->codes[18603] = 0x00004ca6975a272fUL;
   tf->codes[18604] = 0x00004d0fd058852bUL;
   tf->codes[18605] = 0x00005235625a55abUL;
   tf->codes[18606] = 0x0000526237dac07fUL;
   tf->codes[18607] = 0x00005844bb552ea1UL;
   tf->codes[18608] = 0x000058f3b8b96c52UL;
   tf->codes[18609] = 0x00005915cdf7c7fbUL;
   tf->codes[18610] = 0x000059840f40a4e5UL;
   tf->codes[18611] = 0x000059c9d3a6849aUL;
   tf->codes[18612] = 0x00005ac278f00415UL;
   tf->codes[18613] = 0x00005ad8e3b0397fUL;
   tf->codes[18614] = 0x00005b0fc9c5a22fUL;
   tf->codes[18615] = 0x00005b21a1596435UL;
   tf->codes[18616] = 0x00005b71765441c6UL;
   tf->codes[18617] = 0x00005bae897f463dUL;
   tf->codes[18618] = 0x00005e209c9bf572UL;
   tf->codes[18619] = 0x00005e9df6c44f26UL;
   tf->codes[18620] = 0x00005f9b69c947caUL;
   tf->codes[18621] = 0x000060ced8a7920aUL;
   tf->codes[18622] = 0x00006157dd4e11fdUL;
   tf->codes[18623] = 0x000062307c6069bcUL;
   tf->codes[18624] = 0x00006648d2d0b37fUL;
   tf->codes[18625] = 0x00006801284715d8UL;
   tf->codes[18626] = 0x0000690f1385ade4UL;
   tf->codes[18627] = 0x000069c10a2d3696UL;
   tf->codes[18628] = 0x00006b3c87079a3dUL;
   tf->codes[18629] = 0x00006c715540071bUL;
   tf->codes[18630] = 0x00006daa4186dbd3UL;
   tf->codes[18631] = 0x00006f0458cff520UL;
   tf->codes[18632] = 0x0000731b15571680UL;
   tf->codes[18633] = 0x000075d8a4d135a7UL;
   tf->codes[18634] = 0x0000775b38fd4c29UL;
   tf->codes[18635] = 0x00007b8616ae6941UL;
   tf->codes[18636] = 0x00007bacbf19384eUL;
   tf->codes[18637] = 0x00007c9cb327dc8bUL;
   tf->codes[18638] = 0x00007e82533cb542UL;
   tf->codes[18639] = 0x00007fd5c852273eUL;
   tf->codes[18640] = 0x00008095ed9d15a6UL;
   tf->codes[18641] = 0x0000812559e83725UL;
   tf->codes[18642] = 0x000081c27fb8b2d0UL;
   tf->codes[18643] = 0x000085dc701224f6UL;
   tf->codes[18644] = 0x000093774e8f4bd8UL;
   tf->codes[18645] = 0x00009576c7c5b084UL;
   tf->codes[18646] = 0x00009793fd9d033aUL;
   tf->codes[18647] = 0x00009a1aa701b9b1UL;
   tf->codes[18648] = 0x00009a82bb34fad4UL;
   tf->codes[18649] = 0x00009ad33fdce9b4UL;
   tf->codes[18650] = 0x00009dfb2d2083b0UL;
   tf->codes[18651] = 0x00009f2b682c7d2aUL;
   tf->codes[18652] = 0x0000a065793e6ebbUL;
   tf->codes[18653] = 0x0000a1dc285d5939UL;
   tf->codes[18654] = 0x0000a6365fb4209cUL;
   tf->codes[18655] = 0x0000a6369a432661UL;
   tf->codes[18656] = 0x0000a9188891dae3UL;
   tf->codes[18657] = 0x0000a9e3e33ce400UL;
   tf->codes[18658] = 0x0000ab5848c594ccUL;
   tf->codes[18659] = 0x0000ab6ad0066821UL;
   tf->codes[18660] = 0x0000acafdbe96ea2UL;
   tf->codes[18661] = 0x0000b0798229f7adUL;
   tf->codes[18662] = 0x0000b82d0f713744UL;
   tf->codes[18663] = 0x0000b8a38cd6e3e2UL;
   tf->codes[18664] = 0x0000ba4c19c0b822UL;
   tf->codes[18665] = 0x0000bc82790c857eUL;
   tf->codes[18666] = 0x0000be8b189bd0f2UL;
   tf->codes[18667] = 0x0000bf032feaa5f3UL;
   tf->codes[18668] = 0x0000bf254529019cUL;
   tf->codes[18669] = 0x0000bf8b4a550ed2UL;
   tf->codes[18670] = 0x0000c06b00b9196cUL;
   tf->codes[18671] = 0x0000c09a5a5ec3b7UL;
   tf->codes[18672] = 0x0000c2c12bad08bfUL;
   tf->codes[18673] = 0x0000c2fe796712fbUL;
   tf->codes[18674] = 0x0000c5e5aa8f4c30UL;
   tf->codes[18675] = 0x0000c82ecbaaf2a6UL;
   tf->codes[18676] = 0x0000cd8e77947c9cUL;
   tf->codes[18677] = 0x0000ce177c3afc8fUL;
   tf->codes[18678] = 0x0000ce34c3bddf0fUL;
   tf->codes[18679] = 0x0000ce987f53b293UL;
   tf->codes[18680] = 0x0000d041f6799de7UL;
   tf->codes[18681] = 0x0000d35c2a37ddb7UL;
   tf->codes[18682] = 0x0000d4d13f6d9fd2UL;
   tf->codes[18683] = 0x0000d7944c504971UL;
   tf->codes[18684] = 0x0000dd8ed4741560UL;
   tf->codes[18685] = 0x0000df8d28df5d33UL;
   tf->codes[18686] = 0x0000e2339dec35a1UL;
   tf->codes[18687] = 0x0000e3b338d50122UL;
   tf->codes[18688] = 0x0000e623025b76a5UL;
   tf->codes[18689] = 0x0000edda3893128cUL;
   tf->codes[18690] = 0x0000f2dbe0de593bUL;
   tf->codes[18691] = 0x0000f32dff6f707eUL;
   tf->codes[18692] = 0x0000f3597595b8b4UL;
   tf->codes[18693] = 0x0000f6fd23188401UL;
   tf->codes[18694] = 0x0000f7b19de54c2aUL;
   tf->codes[18695] = 0x0000f8844a710de7UL;
   tf->codes[18696] = 0x0000fc1a78fd84cdUL;
   tf->codes[18697] = 0x0000fe8fbfec84c8UL;
   tf->codes[18698] = 0x0000ff5b8fb5996fUL;
   tf->codes[18699] = 0x000002e38f9eaa9fUL;
   tf->codes[18700] = 0x0000059e9af38a4fUL;
   tf->codes[18701] = 0x00000675658db3e6UL;
   tf->codes[18702] = 0x00000de6d75f7018UL;
   tf->codes[18703] = 0x000012008d29dc79UL;
   tf->codes[18704] = 0x000012e1a2e809b1UL;
   tf->codes[18705] = 0x00001381c1fbd05dUL;
   tf->codes[18706] = 0x00001542538f026aUL;
   tf->codes[18707] = 0x000017e55a3a844dUL;
   tf->codes[18708] = 0x00001ce986ab0a73UL;
   tf->codes[18709] = 0x0000283dc831ca56UL;
   tf->codes[18710] = 0x00002941684c5ec1UL;
   tf->codes[18711] = 0x0000297b47a51272UL;
   tf->codes[18712] = 0x00002e42d6089fabUL;
   tf->codes[18713] = 0x00002ff205261b3cUL;
   tf->codes[18714] = 0x0000320aa7d0fa8eUL;
   tf->codes[18715] = 0x000034360c4bb2faUL;
   tf->codes[18716] = 0x00003449b857a328UL;
   tf->codes[18717] = 0x0000345353ce957aUL;
   tf->codes[18718] = 0x0000363dc19ee75aUL;
   tf->codes[18719] = 0x0000367ce3d11fbeUL;
   tf->codes[18720] = 0x000038f439c753a6UL;
   tf->codes[18721] = 0x000039247da91505UL;
   tf->codes[18722] = 0x00003d5acb495297UL;
   tf->codes[18723] = 0x00003f8a4dd272ddUL;
   tf->codes[18724] = 0x00004079ccc30b90UL;
   tf->codes[18725] = 0x000040f1a982daccUL;
   tf->codes[18726] = 0x000041957186fdc8UL;
   tf->codes[18727] = 0x00004489e716859fUL;
   tf->codes[18728] = 0x0000460145e2816cUL;
   tf->codes[18729] = 0x00004615a19b82e9UL;
   tf->codes[18730] = 0x000046a3ae8c81caUL;
   tf->codes[18731] = 0x0000496ad97d9343UL;
   tf->codes[18732] = 0x00004a26310d0882UL;
   tf->codes[18733] = 0x00004b2def3604c7UL;
   tf->codes[18734] = 0x00004ba8158c0db5UL;
   tf->codes[18735] = 0x00004ebea059f135UL;
   tf->codes[18736] = 0x000053653e4a3f9eUL;
   tf->codes[18737] = 0x000055798857b151UL;
   tf->codes[18738] = 0x00005656800776afUL;
   tf->codes[18739] = 0x0000571c5d49f554UL;
   tf->codes[18740] = 0x0000586f5d415bc6UL;
   tf->codes[18741] = 0x00005df4523b922bUL;
   tf->codes[18742] = 0x00005fa7d9f67b5bUL;
   tf->codes[18743] = 0x00006010d865d392UL;
   tf->codes[18744] = 0x000062870990eaa1UL;
   tf->codes[18745] = 0x000063ae936208ddUL;
   tf->codes[18746] = 0x00006501cde87514UL;
   tf->codes[18747] = 0x00006e231e84be26UL;
   tf->codes[18748] = 0x00006ec5fc4cca0eUL;
   tf->codes[18749] = 0x000071d56fc8fab3UL;
   tf->codes[18750] = 0x000073ae7b239617UL;
   tf->codes[18751] = 0x0000765cf1be3874UL;
   tf->codes[18752] = 0x000076f4d4b52f6cUL;
   tf->codes[18753] = 0x000078ea77e59c01UL;
   tf->codes[18754] = 0x00007b059eb5bacaUL;
   tf->codes[18755] = 0x00007bd6b1585424UL;
   tf->codes[18756] = 0x00007e6a9f24593dUL;
   tf->codes[18757] = 0x00008190f27ecad6UL;
   tf->codes[18758] = 0x00008388a4b66b58UL;
   tf->codes[18759] = 0x000084fb7055f3c1UL;
   tf->codes[18760] = 0x0000861197b15b81UL;
   tf->codes[18761] = 0x000089240470d727UL;
   tf->codes[18762] = 0x00008ad62cd19db9UL;
   tf->codes[18763] = 0x00008f08d1817efbUL;
   tf->codes[18764] = 0x000090326a59d124UL;
   tf->codes[18765] = 0x000095d2d25ebbe1UL;
   tf->codes[18766] = 0x0000960b525d4cf4UL;
   tf->codes[18767] = 0x0000999b1945224eUL;
   tf->codes[18768] = 0x00009af56b1d4160UL;
   tf->codes[18769] = 0x00009e2bc19346d7UL;
   tf->codes[18770] = 0x0000a38a48b1b3f4UL;
   tf->codes[18771] = 0x0000a46a39a4c453UL;
   tf->codes[18772] = 0x0000a7e89e16e331UL;
   tf->codes[18773] = 0x0000a92da9f9e9b2UL;
   tf->codes[18774] = 0x0000abbb6ab05304UL;
   tf->codes[18775] = 0x0000ac809845c05aUL;
   tf->codes[18776] = 0x0000acd0e25ea975UL;
   tf->codes[18777] = 0x0000af666a13d6f1UL;
   tf->codes[18778] = 0x0000b0356daf3c5eUL;
   tf->codes[18779] = 0x0000b1f515065757UL;
   tf->codes[18780] = 0x0000b213bbe35c75UL;
   tf->codes[18781] = 0x0000b27fb395ffadUL;
   tf->codes[18782] = 0x0000b365970fa60eUL;
   tf->codes[18783] = 0x0000b4abc7bdc968UL;
   tf->codes[18784] = 0x0000b7724301c992UL;
   tf->codes[18785] = 0x0000b7a127896853UL;
   tf->codes[18786] = 0x0000b85bcf6bcc43UL;
   tf->codes[18787] = 0x0000b8b20c0b4b60UL;
   tf->codes[18788] = 0x0000bd89286c60edUL;
   tf->codes[18789] = 0x0000bf7779bc14e2UL;
   tf->codes[18790] = 0x0000c187a5bb1ebbUL;
   tf->codes[18791] = 0x0000c599cf15ccb7UL;
   tf->codes[18792] = 0x0000ca51cf7bd19cUL;
   tf->codes[18793] = 0x0000ccdee085299fUL;
   tf->codes[18794] = 0x0000cee6d06763c4UL;
   tf->codes[18795] = 0x0000cf36dff1471aUL;
   tf->codes[18796] = 0x0000d30f6482472aUL;
   tf->codes[18797] = 0x0000d329ed50e46eUL;
   tf->codes[18798] = 0x0000d381fe6891b3UL;
   tf->codes[18799] = 0x0000d43b46f0d305UL;
   tf->codes[18800] = 0x0000d6cb513d7609UL;
   tf->codes[18801] = 0x0000df7a07f37492UL;
   tf->codes[18802] = 0x0000e417ba19e1f8UL;
   tf->codes[18803] = 0x0000e7c06fe72c33UL;
   tf->codes[18804] = 0x0000f07762b9fa70UL;
   tf->codes[18805] = 0x0000f1aeb517a6c5UL;
   tf->codes[18806] = 0x0000f349fd9a2c63UL;
   tf->codes[18807] = 0x0000f52f9daf051aUL;
   tf->codes[18808] = 0x0000f83366ad0f80UL;
   tf->codes[18809] = 0x0000f95155073b6aUL;
   tf->codes[18810] = 0x0000fad2c4683513UL;
   tf->codes[18811] = 0x0000fb0517512a5fUL;
   tf->codes[18812] = 0x0000fb21af26fb90UL;
   tf->codes[18813] = 0x0000feebca859025UL;
   tf->codes[18814] = 0x000001a835349273UL;
   tf->codes[18815] = 0x000001e5bd7da274UL;
   tf->codes[18816] = 0x00000420ea84e8f9UL;
   tf->codes[18817] = 0x00000b8b0a75ec8bUL;
   tf->codes[18818] = 0x00000f6bcb23bc4fUL;
   tf->codes[18819] = 0x0000135711849579UL;
   tf->codes[18820] = 0x000014c041ad2b90UL;
   tf->codes[18821] = 0x000017b61696d605UL;
   tf->codes[18822] = 0x00001b677d9efb7eUL;
   tf->codes[18823] = 0x00001de4166eb419UL;
   tf->codes[18824] = 0x00001fea6c67c5dbUL;
   tf->codes[18825] = 0x000020fe84bbf9aeUL;
   tf->codes[18826] = 0x0000221a297febe6UL;
   tf->codes[18827] = 0x0000231dc99a8051UL;
   tf->codes[18828] = 0x000025630736c4b2UL;
   tf->codes[18829] = 0x0000276b6c370a61UL;
   tf->codes[18830] = 0x00002be4fa17e831UL;
   tf->codes[18831] = 0x000032e94f6be452UL;
   tf->codes[18832] = 0x000033b3fa69dc20UL;
   tf->codes[18833] = 0x00003477c8a526d8UL;
   tf->codes[18834] = 0x000034fbff902da2UL;
   tf->codes[18835] = 0x000035c75a3b36bfUL;
   tf->codes[18836] = 0x000035ea59b5a97cUL;
   tf->codes[18837] = 0x000036e92c14c4beUL;
   tf->codes[18838] = 0x000038063032d994UL;
   tf->codes[18839] = 0x0000393d0d727a5fUL;
   tf->codes[18840] = 0x00004084a30716beUL;
   tf->codes[18841] = 0x000041091481234dUL;
   tf->codes[18842] = 0x00004462df8fa70bUL;
   tf->codes[18843] = 0x0000488b73aa8a71UL;
   tf->codes[18844] = 0x00004c7853f48bfeUL;
   tf->codes[18845] = 0x00004d0ba3bf0f92UL;
   tf->codes[18846] = 0x00004d60f622779bUL;
   tf->codes[18847] = 0x000051d15daa6ea3UL;
   tf->codes[18848] = 0x00005353b7477f60UL;
   tf->codes[18849] = 0x0000553a07096966UL;
   tf->codes[18850] = 0x0000559252b01c70UL;
   tf->codes[18851] = 0x000056dc66dda1dfUL;
   tf->codes[18852] = 0x0000580465cccba5UL;
   tf->codes[18853] = 0x00005baef0124408UL;
   tf->codes[18854] = 0x00005be352026d41UL;
   tf->codes[18855] = 0x00005dc6a8810c46UL;
   tf->codes[18856] = 0x00005dd7d067bcfdUL;
   tf->codes[18857] = 0x000060f06a3cd46aUL;
   tf->codes[18858] = 0x000061f4ba047a24UL;
   tf->codes[18859] = 0x000062dfe057a538UL;
   tf->codes[18860] = 0x00006865bf8df2b1UL;
   tf->codes[18861] = 0x00006b1bfd275938UL;
   tf->codes[18862] = 0x00006bc492e6f55dUL;
   tf->codes[18863] = 0x00006e549d339861UL;
   tf->codes[18864] = 0x000071b0b1d855d1UL;
   tf->codes[18865] = 0x0000804176eab6f2UL;
   tf->codes[18866] = 0x000081e0685d98e0UL;
   tf->codes[18867] = 0x000082048ca32876UL;
   tf->codes[18868] = 0x0000836a4e6a6802UL;
   tf->codes[18869] = 0x00008443d7b8d6d5UL;
   tf->codes[18870] = 0x00008731e5a3bd20UL;
   tf->codes[18871] = 0x0000888ad821b994UL;
   tf->codes[18872] = 0x0000896a53f6be69UL;
   tf->codes[18873] = 0x00008b1b578c6822UL;
   tf->codes[18874] = 0x00008ccb3656f502UL;
   tf->codes[18875] = 0x00008e5c6e447cc4UL;
   tf->codes[18876] = 0x0000923443286b85UL;
   tf->codes[18877] = 0x000095c89d3cb443UL;
   tf->codes[18878] = 0x000095db247d8798UL;
   tf->codes[18879] = 0x00009683451f1833UL;
   tf->codes[18880] = 0x000096a34b563fefUL;
   tf->codes[18881] = 0x000096c17d153983UL;
   tf->codes[18882] = 0x0000971410c45c50UL;
   tf->codes[18883] = 0x00009ac4530164f0UL;
   tf->codes[18884] = 0x00009b56b88fd170UL;
   tf->codes[18885] = 0x00009cb7ac9b97d3UL;
   tf->codes[18886] = 0x00009d0ff8424addUL;
   tf->codes[18887] = 0x0000a38b48efc70bUL;
   tf->codes[18888] = 0x0000a48f2399613bUL;
   tf->codes[18889] = 0x0000a70345bd445dUL;
   tf->codes[18890] = 0x0000a72a9dd524b9UL;
   tf->codes[18891] = 0x0000abd818882038UL;
   tf->codes[18892] = 0x0000acfbbed9dc5fUL;
   tf->codes[18893] = 0x0000ad0ad7b95929UL;
   tf->codes[18894] = 0x0000aef75490def6UL;
   tf->codes[18895] = 0x0000bd997c18f693UL;
   tf->codes[18896] = 0x0000bea7a1e69464UL;
   tf->codes[18897] = 0x0000bf6458d02c41UL;
   tf->codes[18898] = 0x0000bf9845a249f0UL;
   tf->codes[18899] = 0x0000c455c370d94dUL;
   tf->codes[18900] = 0x0000c7d8bb0f6b8fUL;
   tf->codes[18901] = 0x0000ca0a4c9fbfc2UL;
   tf->codes[18902] = 0x0000caefbafb5a99UL;
   tf->codes[18903] = 0x0000cd06fe4c174dUL;
   tf->codes[18904] = 0x0000cd8074f50eecUL;
   tf->codes[18905] = 0x0000ce8365629208UL;
   tf->codes[18906] = 0x0000d11d0b26275eUL;
   tf->codes[18907] = 0x0000d247c8c99660UL;
   tf->codes[18908] = 0x0000d42910410178UL;
   tf->codes[18909] = 0x0000d4d37a78cbc5UL;
   tf->codes[18910] = 0x0000dc982fa6bc13UL;
   tf->codes[18911] = 0x0000ddc7bb05a43eUL;
   tf->codes[18912] = 0x0000ddea7ff11136UL;
   tf->codes[18913] = 0x0000defde89833baUL;
   tf->codes[18914] = 0x0000eadaf4366dcbUL;
   tf->codes[18915] = 0x0000f286ba7ee938UL;
   tf->codes[18916] = 0x0000f2b6c3d1a4d2UL;
   tf->codes[18917] = 0x0000f3f2343db901UL;
   tf->codes[18918] = 0x0000f7e99a3ac3f4UL;
   tf->codes[18919] = 0x0000f8d65a77176bUL;
   tf->codes[18920] = 0x0000fd5d674e49a2UL;
   tf->codes[18921] = 0x0000fd6e54a5f494UL;
   tf->codes[18922] = 0x000001ab7f08df3cUL;
   tf->codes[18923] = 0x000001e6bdbbb58bUL;
   tf->codes[18924] = 0x000002503149194cUL;
   tf->codes[18925] = 0x000006b1ba80994fUL;
   tf->codes[18926] = 0x0000128b1d2e7710UL;
   tf->codes[18927] = 0x00001526976a3a8eUL;
   tf->codes[18928] = 0x000016005b47af26UL;
   tf->codes[18929] = 0x000019e86dd6378aUL;
   tf->codes[18930] = 0x00001ab094aeefe1UL;
   tf->codes[18931] = 0x00001b1af2786ab6UL;
   tf->codes[18932] = 0x00001c778de6c37aUL;
   tf->codes[18933] = 0x000020c480d63c3bUL;
   tf->codes[18934] = 0x0000240c7450fdf3UL;
   tf->codes[18935] = 0x0000268bcbd4fbcaUL;
   tf->codes[18936] = 0x0000278d22595683UL;
   tf->codes[18937] = 0x00002b9ab887911bUL;
   tf->codes[18938] = 0x00002d65953ec6c9UL;
   tf->codes[18939] = 0x0000310c7693e2dcUL;
   tf->codes[18940] = 0x00003a2082c8dd4cUL;
   tf->codes[18941] = 0x00003b834b4cd1d7UL;
   tf->codes[18942] = 0x00003bbcb58779feUL;
   tf->codes[18943] = 0x00003f3686cd2578UL;
   tf->codes[18944] = 0x00004648d035818aUL;
   tf->codes[18945] = 0x00004a0e92f6a880UL;
   tf->codes[18946] = 0x00004a1b623feb98UL;
   tf->codes[18947] = 0x00004c995a69c6d1UL;
   tf->codes[18948] = 0x00004cd63305c583UL;
   tf->codes[18949] = 0x000050a8ff9f3556UL;
   tf->codes[18950] = 0x0000510270110539UL;
   tf->codes[18951] = 0x0000590a657f95c5UL;
   tf->codes[18952] = 0x000059352bf8ccacUL;
   tf->codes[18953] = 0x00005af66d391008UL;
   tf->codes[18954] = 0x000066239136f554UL;
   tf->codes[18955] = 0x00006b2623be5317UL;
   tf->codes[18956] = 0x00006f51ebab8743UL;
   tf->codes[18957] = 0x000071aa9ac4b60dUL;
   tf->codes[18958] = 0x00007453ce85d3b7UL;
   tf->codes[18959] = 0x0000756c7a067aeeUL;
   tf->codes[18960] = 0x0000778fdcf3696bUL;
   tf->codes[18961] = 0x00007804c06feda6UL;
   tf->codes[18962] = 0x000079992c2fc62eUL;
   tf->codes[18963] = 0x000079fad8be65c5UL;
   tf->codes[18964] = 0x00007e18e7263fc5UL;
   tf->codes[18965] = 0x0000803de3fc56a5UL;
   tf->codes[18966] = 0x000081bede3f44c4UL;
   tf->codes[18967] = 0x0000862659fd5ac9UL;
   tf->codes[18968] = 0x00008b1490cbb70fUL;
   tf->codes[18969] = 0x00008ef63bb59de7UL;
   tf->codes[18970] = 0x0000902a94cfff3bUL;
   tf->codes[18971] = 0x000095aba64ad38bUL;
   tf->codes[18972] = 0x0000979cb64eccbcUL;
   tf->codes[18973] = 0x00009899b435b9d6UL;
   tf->codes[18974] = 0x000098de53d07cb2UL;
   tf->codes[18975] = 0x00009a0c45463c7aUL;
   tf->codes[18976] = 0x00009d0f24082fccUL;
   tf->codes[18977] = 0x0000a035ec80acefUL;
   tf->codes[18978] = 0x0000a0ed2601ba54UL;
   tf->codes[18979] = 0x0000a19b73b8e6b6UL;
   tf->codes[18980] = 0x0000a4b1144ab322UL;
   tf->codes[18981] = 0x0000a8f04db4d1b7UL;
   tf->codes[18982] = 0x0000a8fad367db1dUL;
   tf->codes[18983] = 0x0000a9ff232f80d7UL;
   tf->codes[18984] = 0x0000aaea0ef3a626UL;
   tf->codes[18985] = 0x0000b0e66b8fa03dUL;
   tf->codes[18986] = 0x0000b2b47c1926b1UL;
   tf->codes[18987] = 0x0000b33c5bf489cbUL;
   tf->codes[18988] = 0x0000b59cd20c7cbfUL;
   tf->codes[18989] = 0x0000b5a1da56fbadUL;
   tf->codes[18990] = 0x0000b97d92ba4c83UL;
   tf->codes[18991] = 0x0000ba2a46885082UL;
   tf->codes[18992] = 0x0000be831e84f547UL;
   tf->codes[18993] = 0x0000bf6f69a33d34UL;
   tf->codes[18994] = 0x0000c019d3db0781UL;
   tf->codes[18995] = 0x0000c33825a7af2bUL;
   tf->codes[18996] = 0x0000c37b65e84f69UL;
   tf->codes[18997] = 0x0000c3a3a83c46d9UL;
   tf->codes[18998] = 0x0000c404dfacdae6UL;
   tf->codes[18999] = 0x0000c5c70b293556UL;
   tf->codes[19000] = 0x0000c615f5e7fbd3UL;
   tf->codes[19001] = 0x0000c63720ea4068UL;
   tf->codes[19002] = 0x0000cac49566142bUL;
   tf->codes[19003] = 0x0000cc280d971a05UL;
   tf->codes[19004] = 0x0000cfb2571664e7UL;
   tf->codes[19005] = 0x0000d0ecdd466202UL;
   tf->codes[19006] = 0x0000d2f800faecedUL;
   tf->codes[19007] = 0x0000d95ad7e0ffc4UL;
   tf->codes[19008] = 0x0000ef5b74dbf4b4UL;
   tf->codes[19009] = 0x0000f16f49cb5addUL;
   tf->codes[19010] = 0x0000f2b246a72d71UL;
   tf->codes[19011] = 0x0000f350cbd1cbbaUL;
   tf->codes[19012] = 0x0000f798f105cb52UL;
   tf->codes[19013] = 0x0000f9d3a8ef064dUL;
   tf->codes[19014] = 0x0000fcc7a960829aUL;
   tf->codes[19015] = 0x000002f4846d43d5UL;
   tf->codes[19016] = 0x000006a0337dd911UL;
   tf->codes[19017] = 0x0000097084c7d152UL;
   tf->codes[19018] = 0x00000aa259bcf32fUL;
   tf->codes[19019] = 0x0000139f10f5a121UL;
   tf->codes[19020] = 0x000013c62e7e7bb8UL;
   tf->codes[19021] = 0x000016fe1edda992UL;
   tf->codes[19022] = 0x00001b617c8d57bdUL;
   tf->codes[19023] = 0x00001c2b02c032b2UL;
   tf->codes[19024] = 0x00001ff5933cd2d1UL;
   tf->codes[19025] = 0x000023103c191e2bUL;
   tf->codes[19026] = 0x000023b05b2ce4d7UL;
   tf->codes[19027] = 0x00002579636bec5dUL;
   tf->codes[19028] = 0x0000283f6991e0fdUL;
   tf->codes[19029] = 0x00002989f2dd71f6UL;
   tf->codes[19030] = 0x00002d957a0478a1UL;
   tf->codes[19031] = 0x00002ded15fe1a5cUL;
   tf->codes[19032] = 0x00002e1015788d19UL;
   tf->codes[19033] = 0x00002e19b0ef7f6bUL;
   tf->codes[19034] = 0x00002f46430b1c95UL;
   tf->codes[19035] = 0x000037f2759bdba7UL;
   tf->codes[19036] = 0x000038da2d8db030UL;
   tf->codes[19037] = 0x00003ade39f08840UL;
   tf->codes[19038] = 0x00004080014f959bUL;
   tf->codes[19039] = 0x000040d46976e690UL;
   tf->codes[19040] = 0x0000447174c60a8cUL;
   tf->codes[19041] = 0x0000450af1a629e7UL;
   tf->codes[19042] = 0x0000456720cc3f06UL;
   tf->codes[19043] = 0x000047fa5eeb32d0UL;
   tf->codes[19044] = 0x00004d93af9e6ab2UL;
   tf->codes[19045] = 0x00004e9197c16ee0UL;
   tf->codes[19046] = 0x00005b3bd282e036UL;
   tf->codes[19047] = 0x00005c3c3ecb23dbUL;
   tf->codes[19048] = 0x00005d4855918dbfUL;
   tf->codes[19049] = 0x000060ac31350f59UL;
   tf->codes[19050] = 0x00006239c0323acbUL;
   tf->codes[19051] = 0x000064fd4232eff4UL;
   tf->codes[19052] = 0x0000665809291a90UL;
   tf->codes[19053] = 0x00006e194ff5b453UL;
   tf->codes[19054] = 0x00007365c4f159a5UL;
   tf->codes[19055] = 0x00007385560a75d7UL;
   tf->codes[19056] = 0x0000755fc0bf33d9UL;
   tf->codes[19057] = 0x000078ac476668f5UL;
   tf->codes[19058] = 0x00008168f230c76fUL;
   tf->codes[19059] = 0x000082aa552371a0UL;
   tf->codes[19060] = 0x000083abe636d21eUL;
   tf->codes[19061] = 0x0000866766a9bd58UL;
   tf->codes[19062] = 0x000086ce5611e1a2UL;
   tf->codes[19063] = 0x0000888c28f0ce73UL;
   tf->codes[19064] = 0x00008c85d8841318UL;
   tf->codes[19065] = 0x00008e2c5666b36bUL;
   tf->codes[19066] = 0x00009150602aeb52UL;
   tf->codes[19067] = 0x000092f544246342UL;
   tf->codes[19068] = 0x00009785b1e38206UL;
   tf->codes[19069] = 0x00009c3d029c759cUL;
   tf->codes[19070] = 0x00009c78414f4bebUL;
   tf->codes[19071] = 0x00009cc014bc5f8dUL;
   tf->codes[19072] = 0x00009ccf2d9bdc57UL;
   tf->codes[19073] = 0x00009fb8333c43b4UL;
   tf->codes[19074] = 0x0000a0ac45594fcbUL;
   tf->codes[19075] = 0x0000a28849f73630UL;
   tf->codes[19076] = 0x0000b20dd0d3b4b7UL;
   tf->codes[19077] = 0x0000b4817dd98c4fUL;
   tf->codes[19078] = 0x0000b7d1ad711dbbUL;
   tf->codes[19079] = 0x0000b99a7b211f7cUL;
   tf->codes[19080] = 0x0000b9f71f654025UL;
   tf->codes[19081] = 0x0000ba7bcb6e5279UL;
   tf->codes[19082] = 0x0000bb9e4cf4f1c7UL;
   tf->codes[19083] = 0x0000bc81ac4958b1UL;
   tf->codes[19084] = 0x0000be2655b3cadcUL;
   tf->codes[19085] = 0x0000c222c3fb54bdUL;
   tf->codes[19086] = 0x0000c467175b820aUL;
   tf->codes[19087] = 0x0000c690a75e0c4eUL;
   tf->codes[19088] = 0x0000cc20d1b85d68UL;
   tf->codes[19089] = 0x0000cca19a420da7UL;
   tf->codes[19090] = 0x0000dbb02e9ad406UL;
   tf->codes[19091] = 0x0000df061629f5afUL;
   tf->codes[19092] = 0x0000e75186682c3eUL;
   tf->codes[19093] = 0x0000e86e8a864114UL;
   tf->codes[19094] = 0x0000ecfb14c5fdc3UL;
   tf->codes[19095] = 0x0000edd6e7aaa648UL;
   tf->codes[19096] = 0x0000efc3d9a0379fUL;
   tf->codes[19097] = 0x0000f6dba0711e29UL;
   tf->codes[19098] = 0x0000f78b4d826d29UL;
   tf->codes[19099] = 0x0000f8cd9ab12e6eUL;
   tf->codes[19100] = 0x0000fa80e7dd11d9UL;
   tf->codes[19101] = 0x0000fd3341f7164bUL;
   tf->codes[19102] = 0x0000fe846d764e95UL;
   tf->codes[19103] = 0x00000200fd703f4bUL;
   tf->codes[19104] = 0x00000280669fccecUL;
   tf->codes[19105] = 0x00000e6d003b8f51UL;
   tf->codes[19106] = 0x0000157698691025UL;
   tf->codes[19107] = 0x00001a5715b2123fUL;
   tf->codes[19108] = 0x00002307a0e03ef0UL;
   tf->codes[19109] = 0x000026f2379406cbUL;
   tf->codes[19110] = 0x0000272d3bb7d755UL;
   tf->codes[19111] = 0x00002756dd65f163UL;
   tf->codes[19112] = 0x0000299e64986f76UL;
   tf->codes[19113] = 0x000031f99d63341eUL;
   tf->codes[19114] = 0x000036691aaf1412UL;
   tf->codes[19115] = 0x0000370e7c9c5f71UL;
   tf->codes[19116] = 0x00003d0c38927c26UL;
   tf->codes[19117] = 0x00003d3c41e537c0UL;
   tf->codes[19118] = 0x00003d6c10a8ed95UL;
   tf->codes[19119] = 0x00003e7234e8c177UL;
   tf->codes[19120] = 0x00003ee78d83513cUL;
   tf->codes[19121] = 0x000040e40d766ae7UL;
   tf->codes[19122] = 0x00004226953431f1UL;
   tf->codes[19123] = 0x0000454ce88ea38aUL;
   tf->codes[19124] = 0x00004746e45c7dbeUL;
   tf->codes[19125] = 0x0000480485822cafUL;
   tf->codes[19126] = 0x000049d4dfa1ecd5UL;
   tf->codes[19127] = 0x00004b3314f96dfcUL;
   tf->codes[19128] = 0x00005032e8cc8683UL;
   tf->codes[19129] = 0x000050606dfa02a6UL;
   tf->codes[19130] = 0x000050d083bb0db8UL;
   tf->codes[19131] = 0x00005663a758a9d3UL;
   tf->codes[19132] = 0x00005a287fddb9b5UL;
   tf->codes[19133] = 0x00005a3bf15aa41eUL;
   tf->codes[19134] = 0x00005a6e09b493a5UL;
   tf->codes[19135] = 0x00005ebac21506a1UL;
   tf->codes[19136] = 0x00005f49b9421c96UL;
   tf->codes[19137] = 0x000062c056b5774aUL;
   tf->codes[19138] = 0x000063c84f6d7954UL;
   tf->codes[19139] = 0x0000645f82b75efdUL;
   tf->codes[19140] = 0x000065ff98f55dc4UL;
   tf->codes[19141] = 0x0000661fd9bb8b45UL;
   tf->codes[19142] = 0x00006a5a456a30b1UL;
   tf->codes[19143] = 0x00006a8a142de686UL;
   tf->codes[19144] = 0x000070e29feff5bcUL;
   tf->codes[19145] = 0x000077a9326bdc17UL;
   tf->codes[19146] = 0x00007ca85691e34fUL;
   tf->codes[19147] = 0x000080f6e36a8473UL;
   tf->codes[19148] = 0x0000821fcc95c54dUL;
   tf->codes[19149] = 0x00008815c18d1dd8UL;
   tf->codes[19150] = 0x000088c70887953bUL;
   tf->codes[19151] = 0x00008b3ab58d6cd3UL;
   tf->codes[19152] = 0x00008c2f3cc88474UL;
   tf->codes[19153] = 0x00008dd24c49ce3cUL;
   tf->codes[19154] = 0x00008dd6df7641a0UL;
   tf->codes[19155] = 0x00009070101bcb6cUL;
   tf->codes[19156] = 0x0000922fb772e665UL;
   tf->codes[19157] = 0x0000930263fea822UL;
   tf->codes[19158] = 0x00009884d4d39f10UL;
   tf->codes[19159] = 0x00009e307238a482UL;
   tf->codes[19160] = 0x0000a2b8a3daf392UL;
   tf->codes[19161] = 0x0000a810c354bf23UL;
   tf->codes[19162] = 0x0000a92ace2f88f8UL;
   tf->codes[19163] = 0x0000aa8e0bd1890dUL;
   tf->codes[19164] = 0x0000ae4d2c5f08b2UL;
   tf->codes[19165] = 0x0000b17dcadd7decUL;
   tf->codes[19166] = 0x0000b4f84bd03ab5UL;
   tf->codes[19167] = 0x0000b8c64aae315fUL;
   tf->codes[19168] = 0x0000b8ef3caf3a1eUL;
   tf->codes[19169] = 0x0000ba4e96d1d81eUL;
   tf->codes[19170] = 0x0000bba6d9a2c343UL;
   tf->codes[19171] = 0x0000be51e1dc0f15UL;
   tf->codes[19172] = 0x0000c22bc5c731c3UL;
   tf->codes[19173] = 0x0000c93264b16796UL;
   tf->codes[19174] = 0x0000cb66ef8506caUL;
   tf->codes[19175] = 0x0000cbc86184a09cUL;
   tf->codes[19176] = 0x0000cfa036688f5dUL;
   tf->codes[19177] = 0x0000d4907c3e1f90UL;
   tf->codes[19178] = 0x0000db819aa4370dUL;
   tf->codes[19179] = 0x0000dc31f762975cUL;
   tf->codes[19180] = 0x0000e26ba1b89bafUL;
   tf->codes[19181] = 0x0000e961c869321aUL;
   tf->codes[19182] = 0x0000e97f0fec149aUL;
   tf->codes[19183] = 0x0000ef026afd229cUL;
   tf->codes[19184] = 0x0000f4478e180f4eUL;
   tf->codes[19185] = 0x0000f6a83ebf0807UL;
   tf->codes[19186] = 0x0000f88b953da70cUL;
   tf->codes[19187] = 0x0000fc5207abdf51UL;
   tf->codes[19188] = 0x0000fcc6b0995dc7UL;
   tf->codes[19189] = 0x0000fd3c7e51f916UL;
   tf->codes[19190] = 0x000007ad25f54c4aUL;
   tf->codes[19191] = 0x0000119cca7fe97aUL;
   tf->codes[19192] = 0x0000125528cc13b8UL;
   tf->codes[19193] = 0x000017dc2ccd7e0aUL;
   tf->codes[19194] = 0x000018f7d1917042UL;
   tf->codes[19195] = 0x00001b120e2577f7UL;
   tf->codes[19196] = 0x00001e34437181b6UL;
   tf->codes[19197] = 0x00001f9fbd30517fUL;
   tf->codes[19198] = 0x000021ff0e7d279aUL;
   tf->codes[19199] = 0x000024a548fafa43UL;
   tf->codes[19200] = 0x00002697b8591612UL;
   tf->codes[19201] = 0x000027ded3435080UL;
   tf->codes[19202] = 0x00002f069d2fcae8UL;
   tf->codes[19203] = 0x000030666c707472UL;
   tf->codes[19204] = 0x000030c385d2a0a5UL;
   tf->codes[19205] = 0x0000310c08ecc596UL;
   tf->codes[19206] = 0x00003722ee575cf1UL;
   tf->codes[19207] = 0x00003869ceb2919aUL;
   tf->codes[19208] = 0x00003b94efc87c5cUL;
   tf->codes[19209] = 0x000042b7b16a77d6UL;
   tf->codes[19210] = 0x00004543d837b8c5UL;
   tf->codes[19211] = 0x000047d198ee2217UL;
   tf->codes[19212] = 0x00004ab34cadd0d4UL;
   tf->codes[19213] = 0x00004e559ad67983UL;
   tf->codes[19214] = 0x00004f66f476681aUL;
   tf->codes[19215] = 0x0000506d534541c1UL;
   tf->codes[19216] = 0x0000515630023323UL;
   tf->codes[19217] = 0x0000547c0e3e9932UL;
   tf->codes[19218] = 0x00005b09ab9de2f0UL;
   tf->codes[19219] = 0x00005bca8095e2a7UL;
   tf->codes[19220] = 0x00005c8b1afedc99UL;
   tf->codes[19221] = 0x00005d4a909cb9b2UL;
   tf->codes[19222] = 0x00005e070cf74bcaUL;
   tf->codes[19223] = 0x0000686b94fe6d35UL;
   tf->codes[19224] = 0x00006f0c2ebc95d2UL;
   tf->codes[19225] = 0x000070b1fcf224d6UL;
   tf->codes[19226] = 0x000076e3e04964ffUL;
   tf->codes[19227] = 0x00007959273864faUL;
   tf->codes[19228] = 0x00007a339ac2eae1UL;
   tf->codes[19229] = 0x00007a4a40122610UL;
   tf->codes[19230] = 0x00007ba92516b886UL;
   tf->codes[19231] = 0x00007c5563c6b0fbUL;
   tf->codes[19232] = 0x00007ca956cff666UL;
   tf->codes[19233] = 0x00007e4acc6817cbUL;
   tf->codes[19234] = 0x000084b68f180ba5UL;
   tf->codes[19235] = 0x000087a6ac0a25ddUL;
   tf->codes[19236] = 0x00008a325db95b42UL;
   tf->codes[19237] = 0x00008a54e815c275UL;
   tf->codes[19238] = 0x00008ebd889ef553UL;
   tf->codes[19239] = 0x000090923b5c2318UL;
   tf->codes[19240] = 0x00009771479f72caUL;
   tf->codes[19241] = 0x000099b6bfcabcf0UL;
   tf->codes[19242] = 0x00009abc345d7f83UL;
   tf->codes[19243] = 0x00009e759cf36eebUL;
   tf->codes[19244] = 0x00009facef511b40UL;
   tf->codes[19245] = 0x0000a032859644a8UL;
   tf->codes[19246] = 0x0000a1311d665a25UL;
   tf->codes[19247] = 0x0000a65f60a305e3UL;
   tf->codes[19248] = 0x0000a8e052102c1dUL;
   tf->codes[19249] = 0x0000ad45f95613faUL;
   tf->codes[19250] = 0x0000af741c8511a2UL;
   tf->codes[19251] = 0x0000b19361639845UL;
   tf->codes[19252] = 0x0000b33ee790b786UL;
   tf->codes[19253] = 0x0000b51a01f286d7UL;
   tf->codes[19254] = 0x0000b689d44ec43fUL;
   tf->codes[19255] = 0x0000b9b654bed19fUL;
   tf->codes[19256] = 0x0000bb428461da73UL;
   tf->codes[19257] = 0x0000bb5ea719a01aUL;
   tf->codes[19258] = 0x0000bb625009fc6aUL;
   tf->codes[19259] = 0x0000bdd8bbc4193eUL;
   tf->codes[19260] = 0x0000c6c65a1d4a66UL;
   tf->codes[19261] = 0x0000c74eaf16b90aUL;
   tf->codes[19262] = 0x0000c8d5d66f42f0UL;
   tf->codes[19263] = 0x0000cd275c8b2f15UL;
   tf->codes[19264] = 0x0000cd6d5b80148fUL;
   tf->codes[19265] = 0x0000cfe7359b87eeUL;
   tf->codes[19266] = 0x0000d0f6bac3485dUL;
   tf->codes[19267] = 0x0000d0febc51124cUL;
   tf->codes[19268] = 0x0000d4a981259074UL;
   tf->codes[19269] = 0x0000e665dc6be7e1UL;
   tf->codes[19270] = 0x0000e95fcf63fa30UL;
   tf->codes[19271] = 0x0000ebe812b1d90aUL;
   tf->codes[19272] = 0x0000ef8ad5f88d43UL;
   tf->codes[19273] = 0x0000f09f9df9d265UL;
   tf->codes[19274] = 0x0000f0fa6dc5c4e6UL;
   tf->codes[19275] = 0x0000f1f179261bfeUL;
   tf->codes[19276] = 0x0000f3159495e3afUL;
   tf->codes[19277] = 0x0000f53130840e02UL;
   tf->codes[19278] = 0x0000f635804bb3bcUL;
   tf->codes[19279] = 0x0000f6ebcf90aa0dUL;
   tf->codes[19280] = 0x0000f7a4a2fadfd5UL;
   tf->codes[19281] = 0x0000fc4c2b274552UL;
   tf->codes[19282] = 0x0000fd63774dc9ebUL;
   tf->codes[19283] = 0x0000fdfa7008a9cfUL;
   tf->codes[19284] = 0x0000ffc721380da5UL;
   tf->codes[19285] = 0x000002b89d844a7bUL;
   tf->codes[19286] = 0x0000082c6a97d029UL;
   tf->codes[19287] = 0x000008b82df29558UL;
   tf->codes[19288] = 0x00000b996c94388bUL;
   tf->codes[19289] = 0x00000d832ab7791cUL;
   tf->codes[19290] = 0x00000e5bc9c9d0dbUL;
   tf->codes[19291] = 0x000015c7f8c2085aUL;
   tf->codes[19292] = 0x000017b2a1215fffUL;
   tf->codes[19293] = 0x00001a318387524cUL;
   tf->codes[19294] = 0x00001c3d56e8ee86UL;
   tf->codes[19295] = 0x00001db7e9873b19UL;
   tf->codes[19296] = 0x00001fbeb49e5865UL;
   tf->codes[19297] = 0x000026b75f742e47UL;
   tf->codes[19298] = 0x0000293ad50693f8UL;
   tf->codes[19299] = 0x000029ea0cf9d76eUL;
   tf->codes[19300] = 0x00002a968638d5a8UL;
   tf->codes[19301] = 0x00002bc17e6b4a6fUL;
   tf->codes[19302] = 0x00002d4362ea4fa2UL;
   tf->codes[19303] = 0x00002e6b274a73a3UL;
   tf->codes[19304] = 0x0000300fd0b4e5ceUL;
   tf->codes[19305] = 0x0000311719bfd689UL;
   tf->codes[19306] = 0x0000318d2207779dUL;
   tf->codes[19307] = 0x000032b178064513UL;
   tf->codes[19308] = 0x0000331e59f4ff5fUL;
   tf->codes[19309] = 0x000038e6c9bedbc7UL;
   tf->codes[19310] = 0x00003ca53a9f4a1dUL;
   tf->codes[19311] = 0x00003ed706bea415UL;
   tf->codes[19312] = 0x000040b84e360f2dUL;
   tf->codes[19313] = 0x00004477e3e19a5cUL;
   tf->codes[19314] = 0x0000472a036c9909UL;
   tf->codes[19315] = 0x000047c7293d14b4UL;
   tf->codes[19316] = 0x000047e903ec6a98UL;
   tf->codes[19317] = 0x00004c10733c3125UL;
   tf->codes[19318] = 0x00004e7875c3e27eUL;
   tf->codes[19319] = 0x0000517fad23436fUL;
   tf->codes[19320] = 0x000053f8d791a57fUL;
   tf->codes[19321] = 0x0000556b2e13225eUL;
   tf->codes[19322] = 0x000059e14d92a9a3UL;
   tf->codes[19323] = 0x000059fcc09d5dfbUL;
   tf->codes[19324] = 0x00005a5128c4aef0UL;
   tf->codes[19325] = 0x00005f579ecb6ec8UL;
   tf->codes[19326] = 0x00005f876d8f249dUL;
   tf->codes[19327] = 0x00006025f2b9c2e6UL;
   tf->codes[19328] = 0x000061eaa25b5ccdUL;
   tf->codes[19329] = 0x0000628a4c5117efUL;
   tf->codes[19330] = 0x0000640b0c050049UL;
   tf->codes[19331] = 0x00006548165a3cdbUL;
   tf->codes[19332] = 0x000068aa92a39bd7UL;
   tf->codes[19333] = 0x00006c72d98a0244UL;
   tf->codes[19334] = 0x00006c776cb675a8UL;
   tf->codes[19335] = 0x00006f9c9b45ca68UL;
   tf->codes[19336] = 0x0000757e6f13273bUL;
   tf->codes[19337] = 0x0000774f03c1ed26UL;
   tf->codes[19338] = 0x00008205e4e92b99UL;
   tf->codes[19339] = 0x000082162293c53cUL;
   tf->codes[19340] = 0x000082c8c8e85f3dUL;
   tf->codes[19341] = 0x000083dc318f81c1UL;
   tf->codes[19342] = 0x0000860a8f4d852eUL;
   tf->codes[19343] = 0x000087463a489f22UL;
   tf->codes[19344] = 0x00008ab71fc46999UL;
   tf->codes[19345] = 0x00008dd7bb274af5UL;
   tf->codes[19346] = 0x0000909968afd1f6UL;
   tf->codes[19347] = 0x000097d6789164efUL;
   tf->codes[19348] = 0x0000993d99b2c719UL;
   tf->codes[19349] = 0x00009a087f3fc4acUL;
   tf->codes[19350] = 0x00009cefeaf703a6UL;
   tf->codes[19351] = 0x00009d6284dd4e2fUL;
   tf->codes[19352] = 0x00009d7c988ddfe9UL;
   tf->codes[19353] = 0x00009da51570dd1eUL;
   tf->codes[19354] = 0x00009eab743fb6c5UL;
   tf->codes[19355] = 0x0000a16435fe5cc3UL;
   tf->codes[19356] = 0x0000a1bc81a50fcdUL;
   tf->codes[19357] = 0x0000a7ce99542dffUL;
   tf->codes[19358] = 0x0000b70ed0e8d85bUL;
   tf->codes[19359] = 0x0000b7478b766f33UL;
   tf->codes[19360] = 0x0000b8c16e67aa77UL;
   tf->codes[19361] = 0x0000b9147734d8ceUL;
   tf->codes[19362] = 0x0000b9156170efe2UL;
   tf->codes[19363] = 0x0000bdf4f47ddae8UL;
   tf->codes[19364] = 0x0000c12b4af3e05fUL;
   tf->codes[19365] = 0x0000c333004714bfUL;
   tf->codes[19366] = 0x0000c4d1420ce55eUL;
   tf->codes[19367] = 0x0000c7782c37c956UL;
   tf->codes[19368] = 0x0000ccb46388d505UL;
   tf->codes[19369] = 0x0000d795960b3ed5UL;
   tf->codes[19370] = 0x0000df99e2897311UL;
   tf->codes[19371] = 0x0000e6f60e6616b2UL;
   tf->codes[19372] = 0x0000e83c79a33fd1UL;
   tf->codes[19373] = 0x0000e89cc6d7bccaUL;
   tf->codes[19374] = 0x0000e8f6ac679837UL;
   tf->codes[19375] = 0x0000ebc7ad5ea1c7UL;
   tf->codes[19376] = 0x0000ed1c473f309cUL;
   tf->codes[19377] = 0x0000ee0aa164ac76UL;
   tf->codes[19378] = 0x0000eecdbff2e5dfUL;
   tf->codes[19379] = 0x0000f39fd4097c7eUL;
   tf->codes[19380] = 0x0000f40cb5f836caUL;
   tf->codes[19381] = 0x0000f43b2561ca01UL;
   tf->codes[19382] = 0x0000f4ab3b22d513UL;
   tf->codes[19383] = 0x0000f7a986b85501UL;
   tf->codes[19384] = 0x0000fa7a4d2058ccUL;
   tf->codes[19385] = 0x0000fd016ba31acdUL;
   tf->codes[19386] = 0x0000fe0be8805c4eUL;
   tf->codes[19387] = 0x0000ffc3192ba1ceUL;
   tf->codes[19388] = 0x0000032a28a1742eUL;
   tf->codes[19389] = 0x000005b59fc1a3ceUL;
   tf->codes[19390] = 0x00000978de5d8b4dUL;
   tf->codes[19391] = 0x00000bb0d792810cUL;
   tf->codes[19392] = 0x00000c0f8addd5a2UL;
   tf->codes[19393] = 0x00000d70445a9640UL;
   tf->codes[19394] = 0x00000fda1b5a75c1UL;
   tf->codes[19395] = 0x000011890fe8eb8dUL;
   tf->codes[19396] = 0x0000150f3b59ce95UL;
   tf->codes[19397] = 0x0000175bcad6cb96UL;
   tf->codes[19398] = 0x00001784f766da1aUL;
   tf->codes[19399] = 0x0000196d90befdd2UL;
   tf->codes[19400] = 0x00001c6365a8a847UL;
   tf->codes[19401] = 0x00002037cc2b407dUL;
   tf->codes[19402] = 0x00002468d6f1f95cUL;
   tf->codes[19403] = 0x000024c3e14cf1a2UL;
   tf->codes[19404] = 0x00002724cc82f020UL;
   tf->codes[19405] = 0x00002b6e16820c91UL;
   tf->codes[19406] = 0x00002b873ff68737UL;
   tf->codes[19407] = 0x00002c62289f18a8UL;
   tf->codes[19408] = 0x00003a475eae92a3UL;
   tf->codes[19409] = 0x00003bf618ae02aaUL;
   tf->codes[19410] = 0x0000405b8564e4c2UL;
   tf->codes[19411] = 0x000044f603b90162UL;
   tf->codes[19412] = 0x0000480cc915eaa7UL;
   tf->codes[19413] = 0x00004893842630e8UL;
   tf->codes[19414] = 0x000048a8ca1b4979UL;
   tf->codes[19415] = 0x000048e4f30a36dcUL;
   tf->codes[19416] = 0x00004a93e798aca8UL;
   tf->codes[19417] = 0x00004ac257023fdfUL;
   tf->codes[19418] = 0x00005157bb604dc7UL;
   tf->codes[19419] = 0x000053ec936869f4UL;
   tf->codes[19420] = 0x000054b7ee137311UL;
   tf->codes[19421] = 0x000059cb33637601UL;
   tf->codes[19422] = 0x00005b0fca2870f8UL;
   tf->codes[19423] = 0x00005ed517cb8c64UL;
   tf->codes[19424] = 0x00006525dc8ed770UL;
   tf->codes[19425] = 0x00006b323c466565UL;
   tf->codes[19426] = 0x00006c5e93d2fccaUL;
   tf->codes[19427] = 0x00006fa38e0a7381UL;
   tf->codes[19428] = 0x000075a14a009036UL;
   tf->codes[19429] = 0x00007755f686963fUL;
   tf->codes[19430] = 0x00007dba6755d179UL;
   tf->codes[19431] = 0x000080db02b8b2d5UL;
   tf->codes[19432] = 0x000083ab1973a551UL;
   tf->codes[19433] = 0x00008d5de56243cfUL;
   tf->codes[19434] = 0x00009008787d8417UL;
   tf->codes[19435] = 0x0000906173d14870UL;
   tf->codes[19436] = 0x000091027d212630UL;
   tf->codes[19437] = 0x00009348a4f981a5UL;
   tf->codes[19438] = 0x000097f410a54937UL;
   tf->codes[19439] = 0x00009c0eb0abccacUL;
   tf->codes[19440] = 0x00009c489004805dUL;
   tf->codes[19441] = 0x00009e9e806969ebUL;
   tf->codes[19442] = 0x00009feb534b3496UL;
   tf->codes[19443] = 0x0000a14b97a9e9aaUL;
   tf->codes[19444] = 0x0000a3e74c74b2edUL;
   tf->codes[19445] = 0x0000a41ac428c512UL;
   tf->codes[19446] = 0x0000a6adc7b8b317UL;
   tf->codes[19447] = 0x0000a6fced067f59UL;
   tf->codes[19448] = 0x0000a98da70033acUL;
   tf->codes[19449] = 0x0000ab3d10acb502UL;
   tf->codes[19450] = 0x0000aeedc807c92cUL;
   tf->codes[19451] = 0x0000b03bfa43b675UL;
   tf->codes[19452] = 0x0000b045d049ae8cUL;
   tf->codes[19453] = 0x0000b3996e429683UL;
   tf->codes[19454] = 0x0000b42c837e1452UL;
   tf->codes[19455] = 0x0000b9b97a0614a6UL;
   tf->codes[19456] = 0x0000bb131c312269UL;
   tf->codes[19457] = 0x0000bb936f9cc71eUL;
   tf->codes[19458] = 0x0000bbd9a920b25dUL;
   tf->codes[19459] = 0x0000bbe63ddaefb0UL;
   tf->codes[19460] = 0x0000bf66ebe34840UL;
   tf->codes[19461] = 0x0000bfe94e5620e2UL;
   tf->codes[19462] = 0x0000bffb6078e8adUL;
   tf->codes[19463] = 0x0000c135e6a8e5c8UL;
   tf->codes[19464] = 0x0000c38b9c7ec991UL;
   tf->codes[19465] = 0x0000cb3c3082be27UL;
   tf->codes[19466] = 0x0000cf3cbcd8afe2UL;
   tf->codes[19467] = 0x0000d0c99c28ca05UL;
   tf->codes[19468] = 0x0000d2b73dcb6cabUL;
   tf->codes[19469] = 0x0000d5ce3db75bb5UL;
   tf->codes[19470] = 0x0000d9250f829472UL;
   tf->codes[19471] = 0x0000da8d556f1375UL;
   tf->codes[19472] = 0x0000dcf4332ba7f5UL;
   tf->codes[19473] = 0x0000ddd3af00accaUL;
   tf->codes[19474] = 0x0000e0c6158900b4UL;
   tf->codes[19475] = 0x0000e7a263180b2aUL;
   tf->codes[19476] = 0x0000eb104f508aa0UL;
   tf->codes[19477] = 0x0000ede150479430UL;
   tf->codes[19478] = 0x0000ef3624b728caUL;
   tf->codes[19479] = 0x0000efe8cb0bc2cbUL;
   tf->codes[19480] = 0x0000f1695030a560UL;
   tf->codes[19481] = 0x0000f954e8586a80UL;
   tf->codes[19482] = 0x0000fd27b4f1da53UL;
   tf->codes[19483] = 0x0000fdfe7f8c03eaUL;
   tf->codes[19484] = 0x0000fea7ff87b723UL;
   tf->codes[19485] = 0x000003177cd39717UL;
   tf->codes[19486] = 0x0000046ab75a034eUL;
   tf->codes[19487] = 0x000008ecbbe6b697UL;
   tf->codes[19488] = 0x0000113448a58b11UL;
   tf->codes[19489] = 0x00001331b2d4bbd0UL;
   tf->codes[19490] = 0x000015663da85b04UL;
   tf->codes[19491] = 0x000016c43870d666UL;
   tf->codes[19492] = 0x000016d56057871dUL;
   tf->codes[19493] = 0x00001b9945cab806UL;
   tf->codes[19494] = 0x00001ca3c2a7f987UL;
   tf->codes[19495] = 0x0000205b1c36b502UL;
   tf->codes[19496] = 0x0000208c0fc587b0UL;
   tf->codes[19497] = 0x000021ec8eb34289UL;
   tf->codes[19498] = 0x0000279e93bce987UL;
   tf->codes[19499] = 0x000028d23d2a398cUL;
   tf->codes[19500] = 0x00002adc3c13a79eUL;
   tf->codes[19501] = 0x00002c45a6cb437aUL;
   tf->codes[19502] = 0x00002cebf2f4a5edUL;
   tf->codes[19503] = 0x000030d59f6c56b4UL;
   tf->codes[19504] = 0x000033623b57a32dUL;
   tf->codes[19505] = 0x000034397b0fd84eUL;
   tf->codes[19506] = 0x0000354382cf0e45UL;
   tf->codes[19507] = 0x000035d279fc243aUL;
   tf->codes[19508] = 0x00004210bd0af258UL;
   tf->codes[19509] = 0x000043166c2cbab0UL;
   tf->codes[19510] = 0x000048f0ee195ee3UL;
   tf->codes[19511] = 0x00004bd735058104UL;
   tf->codes[19512] = 0x00004d252cb26888UL;
   tf->codes[19513] = 0x00004da754963b65UL;
   tf->codes[19514] = 0x0000503d5169746bUL;
   tf->codes[19515] = 0x00005081f1043747UL;
   tf->codes[19516] = 0x0000516515c9986cUL;
   tf->codes[19517] = 0x000051ce8956fc2dUL;
   tf->codes[19518] = 0x000052963b11a8faUL;
   tf->codes[19519] = 0x0000545741c2e691UL;
   tf->codes[19520] = 0x0000586d4e9cf6a2UL;
   tf->codes[19521] = 0x00005d1bb38c0935UL;
   tf->codes[19522] = 0x00005d88205cb7f7UL;
   tf->codes[19523] = 0x00006249471ba3a4UL;
   tf->codes[19524] = 0x00006834f0eef88eUL;
   tf->codes[19525] = 0x0000690c30a72dafUL;
   tf->codes[19526] = 0x00006c22f60416f4UL;
   tf->codes[19527] = 0x00006cafa39af337UL;
   tf->codes[19528] = 0x00007146ee1cbf11UL;
   tf->codes[19529] = 0x000077ebe078554dUL;
   tf->codes[19530] = 0x000079e31d91ea45UL;
   tf->codes[19531] = 0x00007c9f4db1e6ceUL;
   tf->codes[19532] = 0x00008041614b89b8UL;
   tf->codes[19533] = 0x0000820d9d5ce204UL;
   tf->codes[19534] = 0x0000828f8ab1af1cUL;
   tf->codes[19535] = 0x00008481bf80c526UL;
   tf->codes[19536] = 0x00008492e76775ddUL;
   tf->codes[19537] = 0x000085c5317aa344UL;
   tf->codes[19538] = 0x00008d7b08581c8dUL;
   tf->codes[19539] = 0x00009abb8c275c78UL;
   tf->codes[19540] = 0x00009c632ed519a4UL;
   tf->codes[19541] = 0x0000a13f18f1a85aUL;
   tf->codes[19542] = 0x0000b0bf9783a7f3UL;
   tf->codes[19543] = 0x0000b1dfcf740d8fUL;
   tf->codes[19544] = 0x0000b47eb8112798UL;
   tf->codes[19545] = 0x0000b77f12addb73UL;
   tf->codes[19546] = 0x0000b786d9ac9f9dUL;
   tf->codes[19547] = 0x0000ba667e651a6dUL;
   tf->codes[19548] = 0x0000bd073b7a629eUL;
   tf->codes[19549] = 0x0000c0d70ed08770UL;
   tf->codes[19550] = 0x0000c4418ca7b05bUL;
   tf->codes[19551] = 0x0000c6709a12c517UL;
   tf->codes[19552] = 0x0000c7249fc181b6UL;
   tf->codes[19553] = 0x0000c7b864aa10d4UL;
   tf->codes[19554] = 0x0000ca4fc0d76c78UL;
   tf->codes[19555] = 0x0000cd11a8eef93eUL;
   tf->codes[19556] = 0x0000cedab12e00c4UL;
   tf->codes[19557] = 0x0000d1c96ec5f85eUL;
   tf->codes[19558] = 0x0000d38064e23819UL;
   tf->codes[19559] = 0x0000d3a956e340d8UL;
   tf->codes[19560] = 0x0000d42e02ec532cUL;
   tf->codes[19561] = 0x0000dbbd6bee032dUL;
   tf->codes[19562] = 0x0000df87122e8c38UL;
   tf->codes[19563] = 0x0000e1c06abda495UL;
   tf->codes[19564] = 0x0000e205f4947e85UL;
   tf->codes[19565] = 0x0000e2917d603defUL;
   tf->codes[19566] = 0x0000ef0c23ecff35UL;
   tf->codes[19567] = 0x0000f1d34ede10aeUL;
   tf->codes[19568] = 0x0000f6876bc4b37eUL;
   tf->codes[19569] = 0x0000fdf275f1ce24UL;
   tf->codes[19570] = 0x0000061cf5bcc5e3UL;
   tf->codes[19571] = 0x0000065993c9bed0UL;
   tf->codes[19572] = 0x000009080a64612dUL;
   tf->codes[19573] = 0x00000ad56b40d652UL;
   tf->codes[19574] = 0x00000c1150caf60bUL;
   tf->codes[19575] = 0x00000e15d24bd9a5UL;
   tf->codes[19576] = 0x000013c936afa341UL;
   tf->codes[19577] = 0x00001935ec717614UL;
   tf->codes[19578] = 0x00001b7c4ed8d74eUL;
   tf->codes[19579] = 0x000023a534baa6aaUL;
   tf->codes[19580] = 0x000023a8a31bfd35UL;
   tf->codes[19581] = 0x000028d7d094c007UL;
   tf->codes[19582] = 0x00002de4392215e1UL;
   tf->codes[19583] = 0x00002ee3bb2e4272UL;
   tf->codes[19584] = 0x00002f91ce56690fUL;
   tf->codes[19585] = 0x0000300970873286UL;
   tf->codes[19586] = 0x0000304c3ba9c73aUL;
   tf->codes[19587] = 0x000038876e3d6426UL;
   tf->codes[19588] = 0x00003a315a815b04UL;
   tf->codes[19589] = 0x00003f119d3b5759UL;
   tf->codes[19590] = 0x000043b283341585UL;
   tf->codes[19591] = 0x0000445894ce7233UL;
   tf->codes[19592] = 0x00004c0c9733bd54UL;
   tf->codes[19593] = 0x0000542fc51dfc73UL;
   tf->codes[19594] = 0x000056f9aec35328UL;
   tf->codes[19595] = 0x000057143791f06cUL;
   tf->codes[19596] = 0x000059b73e3d724fUL;
   tf->codes[19597] = 0x00005d1cb3ca1c4cUL;
   tf->codes[19598] = 0x000060bf01f2c4fbUL;
   tf->codes[19599] = 0x000062ef3428f690UL;
   tf->codes[19600] = 0x0000662082547d19UL;
   tf->codes[19601] = 0x0000663727a3b848UL;
   tf->codes[19602] = 0x00006997cf74e91cUL;
   tf->codes[19603] = 0x00006a66d3104e89UL;
   tf->codes[19604] = 0x00006ab632ed2090UL;
   tf->codes[19605] = 0x00006e91763265dcUL;
   tf->codes[19606] = 0x000070a49b74bab6UL;
   tf->codes[19607] = 0x000073ca3f221b00UL;
   tf->codes[19608] = 0x000073eba4b3655aUL;
   tf->codes[19609] = 0x0000747f2f0ceeb3UL;
   tf->codes[19610] = 0x000075d7e6fbe562UL;
   tf->codes[19611] = 0x0000777af67d2f2aUL;
   tf->codes[19612] = 0x00007829b9526716UL;
   tf->codes[19613] = 0x00007a8352a7acf4UL;
   tf->codes[19614] = 0x00007acb9b32cc20UL;
   tf->codes[19615] = 0x00007f9d3a2b5735UL;
   tf->codes[19616] = 0x00007fe0054debe9UL;
   tf->codes[19617] = 0x00007fee33f1519fUL;
   tf->codes[19618] = 0x000081d18a6ff0a4UL;
   tf->codes[19619] = 0x0000822f8e0e33ebUL;
   tf->codes[19620] = 0x000084a8b87c95fbUL;
   tf->codes[19621] = 0x000085919539875dUL;
   tf->codes[19622] = 0x00008879760ed1e1UL;
   tf->codes[19623] = 0x00008bdeeb9b7bdeUL;
   tf->codes[19624] = 0x00008ca3dea1e36fUL;
   tf->codes[19625] = 0x00008d21735942e8UL;
   tf->codes[19626] = 0x00008e6d968dfc44UL;
   tf->codes[19627] = 0x000098cf5fe0d873UL;
   tf->codes[19628] = 0x00009c55c5e0c140UL;
   tf->codes[19629] = 0x00009e391c5f6045UL;
   tf->codes[19630] = 0x00009ec58f6736c3UL;
   tf->codes[19631] = 0x0000a3616d157601UL;
   tf->codes[19632] = 0x0000a4519bb32003UL;
   tf->codes[19633] = 0x0000a6b50b0e5df8UL;
   tf->codes[19634] = 0x0000a7552a2224a4UL;
   tf->codes[19635] = 0x0000aeb2b558eae3UL;
   tf->codes[19636] = 0x0000b8975f127323UL;
   tf->codes[19637] = 0x0000b8e3508dee9fUL;
   tf->codes[19638] = 0x0000b983aa30bb10UL;
   tf->codes[19639] = 0x0000bd2e6f053938UL;
   tf->codes[19640] = 0x0000bdf411b8b218UL;
   tf->codes[19641] = 0x0000bf9a8f9b526bUL;
   tf->codes[19642] = 0x0000c441681aa699UL;
   tf->codes[19643] = 0x0000c449a437764dUL;
   tf->codes[19644] = 0x0000c7ba4f243affUL;
   tf->codes[19645] = 0x0000ca9526213ca6UL;
   tf->codes[19646] = 0x0000cc1a79019864UL;
   tf->codes[19647] = 0x0000cc6c9792afa7UL;
   tf->codes[19648] = 0x0000cce34f87620aUL;
   tf->codes[19649] = 0x0000cd75efa4d44fUL;
   tf->codes[19650] = 0x0000ce3390ca8340UL;
   tf->codes[19651] = 0x0000d33d00148e19UL;
   tf->codes[19652] = 0x0000d6aa0210f67bUL;
   tf->codes[19653] = 0x0000dfed67eb9b36UL;
   tf->codes[19654] = 0x0000e5ef41f01fc5UL;
   tf->codes[19655] = 0x0000ea7d661904d7UL;
   tf->codes[19656] = 0x0000ebd115bd7c98UL;
   tf->codes[19657] = 0x0000f554880670cbUL;
   tf->codes[19658] = 0x0000f5e79d41ee9aUL;
   tf->codes[19659] = 0x0000f763c9c96390UL;
   tf->codes[19660] = 0x0000fbbb426be5b7UL;
   tf->codes[19661] = 0x0000fd0a9972efd9UL;
   tf->codes[19662] = 0x0000fdf54aa80f63UL;
   tf->codes[19663] = 0x000001239f904aebUL;
   tf->codes[19664] = 0x00000c24289ccb28UL;
   tf->codes[19665] = 0x000012033db5e2bfUL;
   tf->codes[19666] = 0x000012fe6724a1b1UL;
   tf->codes[19667] = 0x00001d62ef2bc31cUL;
   tf->codes[19668] = 0x00001d72080b3fe6UL;
   tf->codes[19669] = 0x00001ea1cdf92dd6UL;
   tf->codes[19670] = 0x000025c2bb22fb28UL;
   tf->codes[19671] = 0x00002937498f21efUL;
   tf->codes[19672] = 0x000029b553648cf2UL;
   tf->codes[19673] = 0x00002b14e81630b7UL;
   tf->codes[19674] = 0x000032a06d987ea3UL;
   tf->codes[19675] = 0x000032b1957f2f5aUL;
   tf->codes[19676] = 0x000035e910c051aaUL;
   tf->codes[19677] = 0x000036227afaf9d1UL;
   tf->codes[19678] = 0x00003adf0e8d721aUL;
   tf->codes[19679] = 0x00003b15f4a2dacaUL;
   tf->codes[19680] = 0x00004159af8ddcf9UL;
   tf->codes[19681] = 0x000042bec1a80b36UL;
   tf->codes[19682] = 0x0000433fc4c0c13aUL;
   tf->codes[19683] = 0x0000436339593f81UL;
   tf->codes[19684] = 0x000043c17786888dUL;
   tf->codes[19685] = 0x0000447baa4ae0f3UL;
   tf->codes[19686] = 0x000045e3b5a85a31UL;
   tf->codes[19687] = 0x00004703b309ba08UL;
   tf->codes[19688] = 0x00004f955ccbdbd6UL;
   tf->codes[19689] = 0x00005cfa79feb6e1UL;
   tf->codes[19690] = 0x00005d2072bc749fUL;
   tf->codes[19691] = 0x0000636bf4a63af8UL;
   tf->codes[19692] = 0x000063b5276d7138UL;
   tf->codes[19693] = 0x000066f469ad57b2UL;
   tf->codes[19694] = 0x000071c90775842fUL;
   tf->codes[19695] = 0x000073c8f5c9f465UL;
   tf->codes[19696] = 0x000073e259cd74d0UL;
   tf->codes[19697] = 0x00007506001f30f7UL;
   tf->codes[19698] = 0x000075e0e8c7c268UL;
   tf->codes[19699] = 0x000076b703b4dab0UL;
   tf->codes[19700] = 0x000079d3f6275fbcUL;
   tf->codes[19701] = 0x00007ad72123e89dUL;
   tf->codes[19702] = 0x00007b229d81588fUL;
   tf->codes[19703] = 0x00007f040ddc39a2UL;
   tf->codes[19704] = 0x00007f7582f76752UL;
   tf->codes[19705] = 0x000081e7d0a31c4cUL;
   tf->codes[19706] = 0x00008459e3bfcb81UL;
   tf->codes[19707] = 0x0000867c96ffa8afUL;
   tf->codes[19708] = 0x000087820b926b42UL;
   tf->codes[19709] = 0x00008d11863fab0dUL;
   tf->codes[19710] = 0x0000906599569e8eUL;
   tf->codes[19711] = 0x00009200322c12ddUL;
   tf->codes[19712] = 0x00009278be98f368UL;
   tf->codes[19713] = 0x00009c0591c9d428UL;
   tf->codes[19714] = 0x00009df283bf657fUL;
   tf->codes[19715] = 0x0000a043e0f7dba9UL;
   tf->codes[19716] = 0x0000a0c85271e838UL;
   tf->codes[19717] = 0x0000a19128f7b1deUL;
   tf->codes[19718] = 0x0000a33313addecdUL;
   tf->codes[19719] = 0x0000a4fa4774b82bUL;
   tf->codes[19720] = 0x0000a674da1304beUL;
   tf->codes[19721] = 0x0000a8fe7cbb0636UL;
   tf->codes[19722] = 0x0000a99e9bcecce2UL;
   tf->codes[19723] = 0x0000ac5080cac5caUL;
   tf->codes[19724] = 0x0000adb55855ee42UL;
   tf->codes[19725] = 0x0000b54411aa8cf4UL;
   tf->codes[19726] = 0x0000b891bd1cdee9UL;
   tf->codes[19727] = 0x0000ba59db1fcf5bUL;
   tf->codes[19728] = 0x0000bb0828d6fbbdUL;
   tf->codes[19729] = 0x0000bbae75005e30UL;
   tf->codes[19730] = 0x0000bc6489b64ebcUL;
   tf->codes[19731] = 0x0000bdbdf15256baUL;
   tf->codes[19732] = 0x0000bdcdb9dee4d3UL;
   tf->codes[19733] = 0x0000bf4518aae0a0UL;
   tf->codes[19734] = 0x0000c00996933ca7UL;
   tf->codes[19735] = 0x0000c01ea1f94f73UL;
   tf->codes[19736] = 0x0000c5890e24e894UL;
   tf->codes[19737] = 0x0000c75f955a4481UL;
   tf->codes[19738] = 0x0000cad66d5ca4faUL;
   tf->codes[19739] = 0x0000cc5d5a26291bUL;
   tf->codes[19740] = 0x0000cdb687332b54UL;
   tf->codes[19741] = 0x0000cde94f3a2c2aUL;
   tf->codes[19742] = 0x0000d28358703d40UL;
   tf->codes[19743] = 0x0000d4eb9586f45eUL;
   tf->codes[19744] = 0x0000d721f4d2c1baUL;
   tf->codes[19745] = 0x0000e8ab4d83128cUL;
   tf->codes[19746] = 0x0000ed7092506613UL;
   tf->codes[19747] = 0x0000f23352f87a23UL;
   tf->codes[19748] = 0x0000f7ba56f9e475UL;
   tf->codes[19749] = 0x0000fb1ee24a775eUL;
   tf->codes[19750] = 0x000007873c256b14UL;
   tf->codes[19751] = 0x000009729431d408UL;
   tf->codes[19752] = 0x00000b1e54edf90eUL;
   tf->codes[19753] = 0x00000c03139c8296UL;
   tf->codes[19754] = 0x00001935a3576290UL;
   tf->codes[19755] = 0x00001af07cf30460UL;
   tf->codes[19756] = 0x00001d6b06bb890eUL;
   tf->codes[19757] = 0x00001dabfd65ef9aUL;
   tf->codes[19758] = 0x00001f7edbaaef37UL;
   tf->codes[19759] = 0x000027d66b85578fUL;
   tf->codes[19760] = 0x0000293291d5a4c9UL;
   tf->codes[19761] = 0x000032014ec2cb0eUL;
   tf->codes[19762] = 0x00003542657adfb0UL;
   tf->codes[19763] = 0x0000358a7376f917UL;
   tf->codes[19764] = 0x00003955ee2fb04aUL;
   tf->codes[19765] = 0x000039dad4c7c863UL;
   tf->codes[19766] = 0x00003e4c268bd67fUL;
   tf->codes[19767] = 0x000040c3b711102cUL;
   tf->codes[19768] = 0x00004381468b2f53UL;
   tf->codes[19769] = 0x00004846c5e7889fUL;
   tf->codes[19770] = 0x00004c80bc782281UL;
   tf->codes[19771] = 0x00004c84da868a5bUL;
   tf->codes[19772] = 0x00004d344d08d396UL;
   tf->codes[19773] = 0x00005326990fcfd1UL;
   tf->codes[19774] = 0x000056898a773a57UL;
   tf->codes[19775] = 0x0000569534f56096UL;
   tf->codes[19776] = 0x000056c0708ca307UL;
   tf->codes[19777] = 0x00005d14de404a63UL;
   tf->codes[19778] = 0x00005d6e8941200bUL;
   tf->codes[19779] = 0x00005e685355bc5fUL;
   tf->codes[19780] = 0x00005e843b7e7c41UL;
   tf->codes[19781] = 0x000065581261b13eUL;
   tf->codes[19782] = 0x00006a9b26756a03UL;
   tf->codes[19783] = 0x00006ab4c507f033UL;
   tf->codes[19784] = 0x00006caa2da95703UL;
   tf->codes[19785] = 0x00006f294a9e4f15UL;
   tf->codes[19786] = 0x00007118fb4825a8UL;
   tf->codes[19787] = 0x00007588b3230b61UL;
   tf->codes[19788] = 0x0000758d464f7ec5UL;
   tf->codes[19789] = 0x00007886feb88b4fUL;
   tf->codes[19790] = 0x00007b58e9ebabf3UL;
   tf->codes[19791] = 0x00007d45a1523785UL;
   tf->codes[19792] = 0x00007e36ba2bf89bUL;
   tf->codes[19793] = 0x000081fc7ced1f91UL;
   tf->codes[19794] = 0x000088b8fed40810UL;
   tf->codes[19795] = 0x000089774fa6c850UL;
   tf->codes[19796] = 0x0000899c98b774bfUL;
   tf->codes[19797] = 0x00008a5a746c2975UL;
   tf->codes[19798] = 0x00008c9566e46a35UL;
   tf->codes[19799] = 0x00008d934f076e63UL;
   tf->codes[19800] = 0x00008de1c4a82956UL;
   tf->codes[19801] = 0x00008e248fcabe0aUL;
   tf->codes[19802] = 0x00008e42c189b79eUL;
   tf->codes[19803] = 0x00008f19c6b2e6faUL;
   tf->codes[19804] = 0x0000934b8126b128UL;
   tf->codes[19805] = 0x000096c21e9a0bdcUL;
   tf->codes[19806] = 0x0000991d8c677fe2UL;
   tf->codes[19807] = 0x00009a9c3d14344fUL;
   tf->codes[19808] = 0x00009c3bde34278cUL;
   tf->codes[19809] = 0x00009fba7d354c2fUL;
   tf->codes[19810] = 0x0000a265856e9801UL;
   tf->codes[19811] = 0x0000a43b9785e864UL;
   tf->codes[19812] = 0x0000a7b777d2c7cbUL;
   tf->codes[19813] = 0x0000a8b1f194756eUL;
   tf->codes[19814] = 0x0000a8b350ee980cUL;
   tf->codes[19815] = 0x0000ab51fefcac50UL;
   tf->codes[19816] = 0x0000acb69bf8cf03UL;
   tf->codes[19817] = 0x0000af50f16975a8UL;
   tf->codes[19818] = 0x0000b0b344cf5ea9UL;
   tf->codes[19819] = 0x0000b35b53c55f7aUL;
   tf->codes[19820] = 0x0000b5a892ef6dcaUL;
   tf->codes[19821] = 0x0000b8f29571636fUL;
   tf->codes[19822] = 0x0000be5ab806c2deUL;
   tf->codes[19823] = 0x0000c43bdc270e62UL;
   tf->codes[19824] = 0x0000c9ce5017992eUL;
   tf->codes[19825] = 0x0000ced9594acc6aUL;
   tf->codes[19826] = 0x0000d04b001f37faUL;
   tf->codes[19827] = 0x0000d638094caf82UL;
   tf->codes[19828] = 0x0000e0b495fd2ebaUL;
   tf->codes[19829] = 0x0000e191531dee53UL;
   tf->codes[19830] = 0x0000eb1cc6f4ac75UL;
   tf->codes[19831] = 0x0000eb3c1d7ec2e2UL;
   tf->codes[19832] = 0x0000eda50a428b4fUL;
   tf->codes[19833] = 0x0000f3715d8bc9ccUL;
   tf->codes[19834] = 0x0000f3f0519d4be3UL;
   tf->codes[19835] = 0x0000f65b4d68483dUL;
   tf->codes[19836] = 0x0000f78c72b058cbUL;
   tf->codes[19837] = 0x0000fc1b811554f1UL;
   tf->codes[19838] = 0x0000fc7fb1c933ffUL;
   tf->codes[19839] = 0x00000096e36e60e9UL;
   tf->codes[19840] = 0x000002d7534f2c21UL;
   tf->codes[19841] = 0x00000439a6b51522UL;
   tf->codes[19842] = 0x000009e33512e6a7UL;
   tf->codes[19843] = 0x000011442eab0371UL;
   tf->codes[19844] = 0x000013fcf069a96fUL;
   tf->codes[19845] = 0x000015f8c0afb1cbUL;
   tf->codes[19846] = 0x000018dcf8949fffUL;
   tf->codes[19847] = 0x00001ce5115a501fUL;
   tf->codes[19848] = 0x0000211aaf4d7c62UL;
   tf->codes[19849] = 0x00002314e5aa5c5bUL;
   tf->codes[19850] = 0x000027478a5a3d9dUL;
   tf->codes[19851] = 0x00002ab208316688UL;
   tf->codes[19852] = 0x00002c755878ddd1UL;
   tf->codes[19853] = 0x00002cb9f813a0adUL;
   tf->codes[19854] = 0x00002e7372551fdfUL;
   tf->codes[19855] = 0x000031188807d5afUL;
   tf->codes[19856] = 0x00003147e1ad7ffaUL;
   tf->codes[19857] = 0x000031a5aabcbd7cUL;
   tf->codes[19858] = 0x00003586a5f99305UL;
   tf->codes[19859] = 0x0000481a066919ceUL;
   tf->codes[19860] = 0x00004917796e1272UL;
   tf->codes[19861] = 0x0000491b5ced7487UL;
   tf->codes[19862] = 0x0000494c507c4735UL;
   tf->codes[19863] = 0x0000497eddf44246UL;
   tf->codes[19864] = 0x00004d14d1f1b367UL;
   tf->codes[19865] = 0x00004e74dbc162b6UL;
   tf->codes[19866] = 0x000057af1b4320a9UL;
   tf->codes[19867] = 0x00005d3276542eabUL;
   tf->codes[19868] = 0x0000617299fa6454UL;
   tf->codes[19869] = 0x00006567b6613595UL;
   tf->codes[19870] = 0x0000692159862ac2UL;
   tf->codes[19871] = 0x000072e80c0fbf33UL;
   tf->codes[19872] = 0x000076d4773bb536UL;
   tf->codes[19873] = 0x00007cd31d6de8ffUL;
   tf->codes[19874] = 0x00007e1cf70c68a9UL;
   tf->codes[19875] = 0x00007e2e59821f25UL;
   tf->codes[19876] = 0x00008141eb0cb7a4UL;
   tf->codes[19877] = 0x000086f5c48e8ccaUL;
   tf->codes[19878] = 0x0000888b1a8a7c66UL;
   tf->codes[19879] = 0x000088c2009fe516UL;
   tf->codes[19880] = 0x000089fcc15ee7f6UL;
   tf->codes[19881] = 0x00008db7894ef9fcUL;
   tf->codes[19882] = 0x000090bc01fa15b1UL;
   tf->codes[19883] = 0x000092efa2919dd1UL;
   tf->codes[19884] = 0x000099532924c1f7UL;
   tf->codes[19885] = 0x00009b2d93d97ff9UL;
   tf->codes[19886] = 0x0000a6674c91a298UL;
   tf->codes[19887] = 0x0000a87395114a5cUL;
   tf->codes[19888] = 0x0000acebc398058eUL;
   tf->codes[19889] = 0x0000aeb78a8b5250UL;
   tf->codes[19890] = 0x0000b1e4baa870ffUL;
   tf->codes[19891] = 0x0000b5b244685c1fUL;
   tf->codes[19892] = 0x0000b7dc0ef9ec28UL;
   tf->codes[19893] = 0x0000bee6cbf289d5UL;
   tf->codes[19894] = 0x0000c2bc91cf44a9UL;
   tf->codes[19895] = 0x0000c57b0b857ae4UL;
   tf->codes[19896] = 0x0000cac23da79b83UL;
   tf->codes[19897] = 0x0000d04941a905d5UL;
   tf->codes[19898] = 0x0000d159015fcc09UL;
   tf->codes[19899] = 0x0000d9a6bb343c4aUL;
   tf->codes[19900] = 0x0000db29ff0d641bUL;
   tf->codes[19901] = 0x0000dd464aa89fbdUL;
   tf->codes[19902] = 0x0000e07eeab4dee6UL;
   tf->codes[19903] = 0x0000eba77b8650ceUL;
   tf->codes[19904] = 0x0000ebfb6e8f9639UL;
   tf->codes[19905] = 0x0000edcade733f4bUL;
   tf->codes[19906] = 0x0000ee5be4a7892dUL;
   tf->codes[19907] = 0x0000fa0d3f907543UL;
   tf->codes[19908] = 0x0000fce9b0769f4dUL;
   tf->codes[19909] = 0x0000ffc70b98e06bUL;
   tf->codes[19910] = 0x000001c76f0b5c2bUL;
   tf->codes[19911] = 0x000004ce6bdbb757UL;
   tf->codes[19912] = 0x000005b9579fdca6UL;
   tf->codes[19913] = 0x000005da0d8415b1UL;
   tf->codes[19914] = 0x00000753b5e64b30UL;
   tf->codes[19915] = 0x000008f26cca2759UL;
   tf->codes[19916] = 0x00000f1d735eba6cUL;
   tf->codes[19917] = 0x00000ffbca68a268UL;
   tf->codes[19918] = 0x0000104aefb66eaaUL;
   tf->codes[19919] = 0x0000113fb1808c10UL;
   tf->codes[19920] = 0x000011a57c1d9381UL;
   tf->codes[19921] = 0x0000152d06e89927UL;
   tf->codes[19922] = 0x0000160b5df28123UL;
   tf->codes[19923] = 0x000017a581a9e9e8UL;
   tf->codes[19924] = 0x00001cc1b2c3cddbUL;
   tf->codes[19925] = 0x00001fc1d2d17bf1UL;
   tf->codes[19926] = 0x0000232c50a8a4dcUL;
   tf->codes[19927] = 0x0000258f8574dd0cUL;
   tf->codes[19928] = 0x000028aec17d9bcaUL;
   tf->codes[19929] = 0x000028ca34885022UL;
   tf->codes[19930] = 0x00002df6dddbd37dUL;
   tf->codes[19931] = 0x0000316997cfcc1cUL;
   tf->codes[19932] = 0x000031db4779ff91UL;
   tf->codes[19933] = 0x000032556dd0087fUL;
   tf->codes[19934] = 0x000041d4c796eb3fUL;
   tf->codes[19935] = 0x0000424134679a01UL;
   tf->codes[19936] = 0x00004996f89f9c16UL;
   tf->codes[19937] = 0x0000513b3278591eUL;
   tf->codes[19938] = 0x000055cdaf3eabcfUL;
   tf->codes[19939] = 0x000058a76170909dUL;
   tf->codes[19940] = 0x000059da20a1c98eUL;
   tf->codes[19941] = 0x000059fa6167f70fUL;
   tf->codes[19942] = 0x00005ff29ff5894cUL;
   tf->codes[19943] = 0x00006023ce1361bfUL;
   tf->codes[19944] = 0x000067cbeb6b80dcUL;
   tf->codes[19945] = 0x00006979f5bddf94UL;
   tf->codes[19946] = 0x000070baae8fceddUL;
   tf->codes[19947] = 0x00007324faadb9e8UL;
   tf->codes[19948] = 0x0000770f56d27bfeUL;
   tf->codes[19949] = 0x00007a7db82906feUL;
   tf->codes[19950] = 0x00007a93733c2b19UL;
   tf->codes[19951] = 0x00007a96e19d81a4UL;
   tf->codes[19952] = 0x00007b874aca316bUL;
   tf->codes[19953] = 0x00007bac594bd815UL;
   tf->codes[19954] = 0x00007bd8f43d3d24UL;
   tf->codes[19955] = 0x00008a56f77fc52bUL;
   tf->codes[19956] = 0x00008af3331429c2UL;
   tf->codes[19957] = 0x00008b9e87880b23UL;
   tf->codes[19958] = 0x00009433da3a8941UL;
   tf->codes[19959] = 0x000098c56cc4c4deUL;
   tf->codes[19960] = 0x00009a4a85161ad7UL;
   tf->codes[19961] = 0x00009f3797195a44UL;
   tf->codes[19962] = 0x00009f400dc52fbdUL;
   tf->codes[19963] = 0x00009f5ca59b00eeUL;
   tf->codes[19964] = 0x00009fc98789bb3aUL;
   tf->codes[19965] = 0x0000a7e613405308UL;
   tf->codes[19966] = 0x0000a9b2fefebca3UL;
   tf->codes[19967] = 0x0000af05a10ffdbcUL;
   tf->codes[19968] = 0x0000b157adf58535UL;
   tf->codes[19969] = 0x0000b19e5c977bfeUL;
   tf->codes[19970] = 0x0000b513d53fb9d9UL;
   tf->codes[19971] = 0x0000b57790d58d5dUL;
   tf->codes[19972] = 0x0000b6d884e153c0UL;
   tf->codes[19973] = 0x0000b79fc17df503UL;
   tf->codes[19974] = 0x0000b8998b929157UL;
   tf->codes[19975] = 0x0000b919a46f3047UL;
   tf->codes[19976] = 0x0000bd164d45bfedUL;
   tf->codes[19977] = 0x0000bfcb6614099bUL;
   tf->codes[19978] = 0x0000bfe280815054UL;
   tf->codes[19979] = 0x0000c1a8ca0c129eUL;
   tf->codes[19980] = 0x0000c46743c248d9UL;
   tf->codes[19981] = 0x0000c9ed5d879c17UL;
   tf->codes[19982] = 0x0000cade3bd25768UL;
   tf->codes[19983] = 0x0000ce278ea73bbeUL;
   tf->codes[19984] = 0x0000ce5a1c1f36cfUL;
   tf->codes[19985] = 0x0000ce6bb923f310UL;
   tf->codes[19986] = 0x0000ce760447f6b1UL;
   tf->codes[19987] = 0x0000cf3713cefc2dUL;
   tf->codes[19988] = 0x0000d1469020f4b7UL;
   tf->codes[19989] = 0x0000d23e109f5759UL;
   tf->codes[19990] = 0x0000d5a1ec42d8f3UL;
   tf->codes[19991] = 0x0000d8691733ea6cUL;
   tf->codes[19992] = 0x0000dd244b6c4017UL;
   tf->codes[19993] = 0x0000ee48fe4aa651UL;
   tf->codes[19994] = 0x0000f2bc2486e295UL;
   tf->codes[19995] = 0x0000f2d49e4e4becUL;
   tf->codes[19996] = 0x0000fc61717f2cacUL;
   tf->codes[19997] = 0x0000fd132d97af99UL;
   tf->codes[19998] = 0x0000079069f54020UL;
   tf->codes[19999] = 0x00000b2991c50207UL;
   tf->codes[20000] = 0x00000dc6e078f3adUL;
   tf->codes[20001] = 0x00000e5ec36feaa5UL;
   tf->codes[20002] = 0x000013f6b4c8ffe9UL;
   tf->codes[20003] = 0x000015e15d28578eUL;
   tf->codes[20004] = 0x00001f24fd92020eUL;
   tf->codes[20005] = 0x0000207ccb44e1a9UL;
   tf->codes[20006] = 0x000022d2811ac572UL;
   tf->codes[20007] = 0x000023c115cf4711UL;
   tf->codes[20008] = 0x000024e989dc7c61UL;
   tf->codes[20009] = 0x000025039d8d0e1bUL;
   tf->codes[20010] = 0x000026e85365cfbeUL;
   tf->codes[20011] = 0x0000281a285af19bUL;
   tf->codes[20012] = 0x000029e15c21caf9UL;
   tf->codes[20013] = 0x00002a61af8d6faeUL;
   tf->codes[20014] = 0x00002f87b6ad4bb8UL;
   tf->codes[20015] = 0x000032be0d23512fUL;
   tf->codes[20016] = 0x0000388bfa55b80fUL;
   tf->codes[20017] = 0x00003a04435dcaf0UL;
   tf->codes[20018] = 0x00003b87fc54fe4bUL;
   tf->codes[20019] = 0x000042feb1003f30UL;
   tf->codes[20020] = 0x00004371c0049543UL;
   tf->codes[20021] = 0x000043e6de101f43UL;
   tf->codes[20022] = 0x00004479b8bc974dUL;
   tf->codes[20023] = 0x0000459bffb430d6UL;
   tf->codes[20024] = 0x00004ab57219cf8dUL;
   tf->codes[20025] = 0x00004ace26703ea9UL;
   tf->codes[20026] = 0x00004b084057f81fUL;
   tf->codes[20027] = 0x00004b1e708927c4UL;
   tf->codes[20028] = 0x00004e0d68b02523UL;
   tf->codes[20029] = 0x000052e952ccb3d9UL;
   tf->codes[20030] = 0x000057a86a846b99UL;
   tf->codes[20031] = 0x0000586ef773fb8dUL;
   tf->codes[20032] = 0x00005bd67c07d977UL;
   tf->codes[20033] = 0x00005df8450b9f91UL;
   tf->codes[20034] = 0x00005f7979dd9375UL;
   tf->codes[20035] = 0x0000621f04ae54cfUL;
   tf->codes[20036] = 0x0000638ab8fc2a5dUL;
   tf->codes[20037] = 0x000066f3d77930aaUL;
   tf->codes[20038] = 0x000069b71eeae00eUL;
   tf->codes[20039] = 0x00007304203c771bUL;
   tf->codes[20040] = 0x000075c015cd6ddfUL;
   tf->codes[20041] = 0x000077718e812322UL;
   tf->codes[20042] = 0x00007d164f237b7eUL;
   tf->codes[20043] = 0x00007e80a4172e6eUL;
   tf->codes[20044] = 0x000080a9befbad28UL;
   tf->codes[20045] = 0x0000820d372cb302UL;
   tf->codes[20046] = 0x000082f31aa65963UL;
   tf->codes[20047] = 0x00008461c83779f2UL;
   tf->codes[20048] = 0x000084aa4b519ee3UL;
   tf->codes[20049] = 0x000085243718a20cUL;
   tf->codes[20050] = 0x000085b711c51a16UL;
   tf->codes[20051] = 0x000086bc8657dca9UL;
   tf->codes[20052] = 0x0000895a0f9ad414UL;
   tf->codes[20053] = 0x00008990bb2136ffUL;
   tf->codes[20054] = 0x00008ca536e7e692UL;
   tf->codes[20055] = 0x00009058acf73ff8UL;
   tf->codes[20056] = 0x000090eb1285ac78UL;
   tf->codes[20057] = 0x000097e93ac40cd2UL;
   tf->codes[20058] = 0x00009982e95d6a0dUL;
   tf->codes[20059] = 0x0000a52232238e58UL;
   tf->codes[20060] = 0x0000a53d6a9f3cebUL;
   tf->codes[20061] = 0x0000a5f04b82dcb1UL;
   tf->codes[20062] = 0x0000a7f457e5b4c1UL;
   tf->codes[20063] = 0x0000aa7165d378e6UL;
   tf->codes[20064] = 0x0000aaeadc7c7085UL;
   tf->codes[20065] = 0x0000ae30fb7f0415UL;
   tf->codes[20066] = 0x0000baaa7d40a882UL;
   tf->codes[20067] = 0x0000c2acbab7a8d1UL;
   tf->codes[20068] = 0x0000c2d7bbbfe57dUL;
   tf->codes[20069] = 0x0000c4a04ee0e179UL;
   tf->codes[20070] = 0x0000c673dcd2f265UL;
   tf->codes[20071] = 0x0000cafc0e754175UL;
   tf->codes[20072] = 0x0000cb1c4f3b6ef6UL;
   tf->codes[20073] = 0x0000cbd1eed353f8UL;
   tf->codes[20074] = 0x0000cdc12a5f1f01UL;
   tf->codes[20075] = 0x0000ce046a9fbf3fUL;
   tf->codes[20076] = 0x0000ce334f275e00UL;
   tf->codes[20077] = 0x0000d35154b9701bUL;
   tf->codes[20078] = 0x0000d6479ec1261aUL;
   tf->codes[20079] = 0x0000db247319cbe4UL;
   tf->codes[20080] = 0x0000dcb3d68f257eUL;
   tf->codes[20081] = 0x0000df900ce649c3UL;
   tf->codes[20082] = 0x0000e2ec5c1a0cf8UL;
   tf->codes[20083] = 0x0000e96687fc6c4dUL;
   tf->codes[20084] = 0x0000ee0683b91365UL;
   tf->codes[20085] = 0x0000f92ffec69c61UL;
   tf->codes[20086] = 0x000011e9d29e42d9UL;
   tf->codes[20087] = 0x00001307866968feUL;
   tf->codes[20088] = 0x000019584b2cb40aUL;
   tf->codes[20089] = 0x00001e4ce99fb1dcUL;
   tf->codes[20090] = 0x000021fcb6beaef2UL;
   tf->codes[20091] = 0x00002441f45af353UL;
   tf->codes[20092] = 0x000026e18ca51eabUL;
   tf->codes[20093] = 0x0000296c19893737UL;
   tf->codes[20094] = 0x00002b690e9a5c6cUL;
   tf->codes[20095] = 0x00002ddb5c461166UL;
   tf->codes[20096] = 0x00002ec2d9a8e02aUL;
   tf->codes[20097] = 0x00003227da177e9dUL;
   tf->codes[20098] = 0x00003a2c9bb3be63UL;
   tf->codes[20099] = 0x00003eb5427418fdUL;
   tf->codes[20100] = 0x000043b3b6ed0ee6UL;
   tf->codes[20101] = 0x00004b2dd9f9a656UL;
   tf->codes[20102] = 0x00004d2f9cc644b4UL;
   tf->codes[20103] = 0x00004ee23a4516d0UL;
   tf->codes[20104] = 0x00005523ab99df4dUL;
   tf->codes[20105] = 0x000056821b806639UL;
   tf->codes[20106] = 0x0000578ee1f3e16cUL;
   tf->codes[20107] = 0x00005897153ae93bUL;
   tf->codes[20108] = 0x00005ab485a141b6UL;
   tf->codes[20109] = 0x00006a83b4630207UL;
   tf->codes[20110] = 0x00006d63ce398861UL;
   tf->codes[20111] = 0x00006eeaf5921247UL;
   tf->codes[20112] = 0x000074fb73580816UL;
   tf->codes[20113] = 0x0000751c9e5a4cabUL;
   tf->codes[20114] = 0x00007835382f6418UL;
   tf->codes[20115] = 0x00007bba04462482UL;
   tf->codes[20116] = 0x00007bc748ad7324UL;
   tf->codes[20117] = 0x00007cd867be5bf6UL;
   tf->codes[20118] = 0x00007ed85612cc2cUL;
   tf->codes[20119] = 0x00007f131fa796f1UL;
   tf->codes[20120] = 0x00007f924e481ecdUL;
   tf->codes[20121] = 0x0000822a5a228bc0UL;
   tf->codes[20122] = 0x00008250185143b9UL;
   tf->codes[20123] = 0x00008ae480c7aac3UL;
   tf->codes[20124] = 0x00008de515f36463UL;
   tf->codes[20125] = 0x0000906557b3794eUL;
   tf->codes[20126] = 0x0000923f87d9318bUL;
   tf->codes[20127] = 0x000094f933d3ee9dUL;
   tf->codes[20128] = 0x00009653108e0225UL;
   tf->codes[20129] = 0x00009939cc982fd0UL;
   tf->codes[20130] = 0x00009a48dca1e4b5UL;
   tf->codes[20131] = 0x00009b243a6881b0UL;
   tf->codes[20132] = 0x00009ba48dd42665UL;
   tf->codes[20133] = 0x00009d13b083527eUL;
   tf->codes[20134] = 0x0000a8a121b5b4c3UL;
   tf->codes[20135] = 0x0000ad3697bf5275UL;
   tf->codes[20136] = 0x0000ad55ee4968e2UL;
   tf->codes[20137] = 0x0000b88c38a034f6UL;
   tf->codes[20138] = 0x0000bcd45dd4348eUL;
   tf->codes[20139] = 0x0000be5816cb67e9UL;
   tf->codes[20140] = 0x0000c6716eafaef1UL;
   tf->codes[20141] = 0x0000cd679560455cUL;
   tf->codes[20142] = 0x0000d04cb7814aa4UL;
   tf->codes[20143] = 0x0000d0ba83ac1c04UL;
   tf->codes[20144] = 0x0000d169468153f0UL;
   tf->codes[20145] = 0x0000d6670b4d388aUL;
   tf->codes[20146] = 0x0000e1d59b138fecUL;
   tf->codes[20147] = 0x0000e4944f58cbecUL;
   tf->codes[20148] = 0x0000e9a71f8ac352UL;
   tf->codes[20149] = 0x0000f0aee34015feUL;
   tf->codes[20150] = 0x0000f2602164c57cUL;
   tf->codes[20151] = 0x0000f7efd6a10b0cUL;
   tf->codes[20152] = 0x0000fa0afd7129d5UL;
   tf->codes[20153] = 0x0000fbef78bae5b3UL;
   tf->codes[20154] = 0x0000fd1b5b29718eUL;
   tf->codes[20155] = 0x0000020c161d0d4bUL;
   tf->codes[20156] = 0x0000032536bbc00cUL;
   tf->codes[20157] = 0x0000050d9584ddffUL;
   tf->codes[20158] = 0x00000943a89615ccUL;
   tf->codes[20159] = 0x00000d8824d9b914UL;
   tf->codes[20160] = 0x00000f79e48ac394UL;
   tf->codes[20161] = 0x00001d3ccaccdc21UL;
   tf->codes[20162] = 0x000022045930695aUL;
   tf->codes[20163] = 0x0000265cbc0f0295UL;
   tf->codes[20164] = 0x0000295eb094ded3UL;
   tf->codes[20165] = 0x00002c11ba5bf494UL;
   tf->codes[20166] = 0x00002ffbdbf1b0e5UL;
   tf->codes[20167] = 0x0000350c9d1c745eUL;
   tf->codes[20168] = 0x00003528bfd43a05UL;
   tf->codes[20169] = 0x0000435f9f56bfb9UL;
   tf->codes[20170] = 0x00004b1a7e7eb7f0UL;
   tf->codes[20171] = 0x00004d21f942e68bUL;
   tf->codes[20172] = 0x00004ebea11f8ec7UL;
   tf->codes[20173] = 0x000053c517264e9fUL;
   tf->codes[20174] = 0x00005af30e2864ceUL;
   tf->codes[20175] = 0x00005da94bc1cb55UL;
   tf->codes[20176] = 0x0000611efef90ef5UL;
   tf->codes[20177] = 0x0000645012958fb9UL;
   tf->codes[20178] = 0x00006620e1d35b69UL;
   tf->codes[20179] = 0x00006b9c3b569f7cUL;
   tf->codes[20180] = 0x00006beb60a46bbeUL;
   tf->codes[20181] = 0x00006cf9c1010f54UL;
   tf->codes[20182] = 0x0000712f5ef43b97UL;
   tf->codes[20183] = 0x0000735badab0b17UL;
   tf->codes[20184] = 0x000077bb27db572dUL;
   tf->codes[20185] = 0x00007c68dd1d5871UL;
   tf->codes[20186] = 0x000084201354f458UL;
   tf->codes[20187] = 0x000084efc69d6b14UL;
   tf->codes[20188] = 0x000087c52031e243UL;
   tf->codes[20189] = 0x00008a4adf5a81a6UL;
   tf->codes[20190] = 0x00008b4050d1b05bUL;
   tf->codes[20191] = 0x00008c68c4dee5abUL;
   tf->codes[20192] = 0x00008fac5fbc39c4UL;
   tf->codes[20193] = 0x000090ba8589d795UL;
   tf->codes[20194] = 0x000096895cf85589UL;
   tf->codes[20195] = 0x0000991c9b174953UL;
   tf->codes[20196] = 0x00009c78ea4b0c88UL;
   tf->codes[20197] = 0x00009fb1ff75573bUL;
   tf->codes[20198] = 0x0000a2bad0bde08fUL;
   tf->codes[20199] = 0x0000a5fc5c9400bbUL;
   tf->codes[20200] = 0x0000a7b85afabf64UL;
   tf->codes[20201] = 0x0000ab3893e50c6aUL;
   tf->codes[20202] = 0x0000ae604699a0a1UL;
   tf->codes[20203] = 0x0000b292010d6acfUL;
   tf->codes[20204] = 0x0000b3a7039db5b6UL;
   tf->codes[20205] = 0x0000b6b1344061a8UL;
   tf->codes[20206] = 0x0000b864816c4513UL;
   tf->codes[20207] = 0x0000bb3423092c05UL;
   tf->codes[20208] = 0x0000be87c10213fcUL;
   tf->codes[20209] = 0x0000c0d9935895b0UL;
   tf->codes[20210] = 0x0000c38301a8b91fUL;
   tf->codes[20211] = 0x0000c3dd96e5a5dbUL;
   tf->codes[20212] = 0x0000c5744c3bb815UL;
   tf->codes[20213] = 0x0000c8908f012bd2UL;
   tf->codes[20214] = 0x0000c903d89487aaUL;
   tf->codes[20215] = 0x0000c94509cdf3fbUL;
   tf->codes[20216] = 0x0000ceca39573025UL;
   tf->codes[20217] = 0x0000d01ff802dbd3UL;
   tf->codes[20218] = 0x0000d35ddae89fafUL;
   tf->codes[20219] = 0x0000d3f79257c4cfUL;
   tf->codes[20220] = 0x0000d590cbd31680UL;
   tf->codes[20221] = 0x0000d65215e921c1UL;
   tf->codes[20222] = 0x0000d7eebdc5c9fdUL;
   tf->codes[20223] = 0x0000d7f9f325e4b2UL;
   tf->codes[20224] = 0x0000deed95b13ba6UL;
   tf->codes[20225] = 0x0000def6817b1ca9UL;
   tf->codes[20226] = 0x0000e30417a95741UL;
   tf->codes[20227] = 0x0000e47b7675530eUL;
   tf->codes[20228] = 0x0000e53658e6bcc3UL;
   tf->codes[20229] = 0x0000ec302887af7eUL;
   tf->codes[20230] = 0x0000f42f322c5f07UL;
   tf->codes[20231] = 0x0000fb726f238dc7UL;
   tf->codes[20232] = 0x0000fbcc8f426ef9UL;
   tf->codes[20233] = 0x000004755371d780UL;
   tf->codes[20234] = 0x0000093d56f37043UL;
   tf->codes[20235] = 0x00000c8bb212d387UL;
   tf->codes[20236] = 0x000010a6c7376286UL;
   tf->codes[20237] = 0x000012712ed08caaUL;
   tf->codes[20238] = 0x000012a381b981f6UL;
   tf->codes[20239] = 0x000012e2a3ebba5aUL;
   tf->codes[20240] = 0x0000136a0ea911eaUL;
   tf->codes[20241] = 0x000024425aedf11eUL;
   tf->codes[20242] = 0x000025171680e6c8UL;
   tf->codes[20243] = 0x00002e04ef691db5UL;
   tf->codes[20244] = 0x000030d57b421bbbUL;
   tf->codes[20245] = 0x0000320af92799e8UL;
   tf->codes[20246] = 0x000038b94c6b1cb1UL;
   tf->codes[20247] = 0x000044f3716b82f5UL;
   tf->codes[20248] = 0x000049a001e26760UL;
   tf->codes[20249] = 0x000049c54af313cfUL;
   tf->codes[20250] = 0x00004e71db69f83aUL;
   tf->codes[20251] = 0x00004f1c0b12bcc2UL;
   tf->codes[20252] = 0x000053d7b4691df7UL;
   tf->codes[20253] = 0x00005497d9b40c5fUL;
   tf->codes[20254] = 0x000054cc01152fd3UL;
   tf->codes[20255] = 0x000054eb1d10407bUL;
   tf->codes[20256] = 0x000058063b0a975fUL;
   tf->codes[20257] = 0x000058f669a84161UL;
   tf->codes[20258] = 0x00005bf1bbfa764eUL;
   tf->codes[20259] = 0x0000639a4e70a0f5UL;
   tf->codes[20260] = 0x00006cf92755fa08UL;
   tf->codes[20261] = 0x00007176d3453fb2UL;
   tf->codes[20262] = 0x000071b8799cb78dUL;
   tf->codes[20263] = 0x00007b976b5eaf90UL;
   tf->codes[20264] = 0x00007bc391320915UL;
   tf->codes[20265] = 0x00007c64d510ec9aUL;
   tf->codes[20266] = 0x00007c842b9b0307UL;
   tf->codes[20267] = 0x00007e9b345cb9f6UL;
   tf->codes[20268] = 0x0000818c00fbe57dUL;
   tf->codes[20269] = 0x000084591e738cf8UL;
   tf->codes[20270] = 0x000084e298381875UL;
   tf->codes[20271] = 0x000088fb293767fdUL;
   tf->codes[20272] = 0x000091efa453463bUL;
   tf->codes[20273] = 0x0000952f5bb1383fUL;
   tf->codes[20274] = 0x00009a43c5cc5808UL;
   tf->codes[20275] = 0x00009e541aaed7dcUL;
   tf->codes[20276] = 0x0000a2e747223bdcUL;
   tf->codes[20277] = 0x0000a43eda4615b2UL;
   tf->codes[20278] = 0x0000a479694bdab2UL;
   tf->codes[20279] = 0x0000a4aa224ba79bUL;
   tf->codes[20280] = 0x0000a53b9d9dfd07UL;
   tf->codes[20281] = 0x0000aa2a0efb5f12UL;
   tf->codes[20282] = 0x0000af200cc87f82UL;
   tf->codes[20283] = 0x0000afa31ee86973UL;
   tf->codes[20284] = 0x0000b03eaacfbcbbUL;
   tf->codes[20285] = 0x0000b6f70ea83d60UL;
   tf->codes[20286] = 0x0000b76d8c0de9feUL;
   tf->codes[20287] = 0x0000b7772784dc50UL;
   tf->codes[20288] = 0x0000bc3345f9490fUL;
   tf->codes[20289] = 0x0000bda9456b223eUL;
   tf->codes[20290] = 0x0000bdd77a45afb0UL;
   tf->codes[20291] = 0x0000c282ab62717dUL;
   tf->codes[20292] = 0x0000c41333a2e7f0UL;
   tf->codes[20293] = 0x0000c5a6b526a964UL;
   tf->codes[20294] = 0x0000c7f60357eba1UL;
   tf->codes[20295] = 0x0000c9301469dd32UL;
   tf->codes[20296] = 0x0000ca35c38ba58aUL;
   tf->codes[20297] = 0x0000ce77811b0396UL;
   tf->codes[20298] = 0x0000cf66c57c9684UL;
   tf->codes[20299] = 0x0000d1834ba6d7ebUL;
   tf->codes[20300] = 0x0000d534b2aefd64UL;
   tf->codes[20301] = 0x0000d5c28510f680UL;
   tf->codes[20302] = 0x0000d7d56fc44595UL;
   tf->codes[20303] = 0x0000d8a3fe419f78UL;
   tf->codes[20304] = 0x0000de713bc6f509UL;
   tf->codes[20305] = 0x0000e7e769a89a9aUL;
   tf->codes[20306] = 0x0000e83c817cfcdeUL;
   tf->codes[20307] = 0x0000ed248b35bd5dUL;
   tf->codes[20308] = 0x0000ee58e4501eb1UL;
   tf->codes[20309] = 0x0000ef8af3d44653UL;
   tf->codes[20310] = 0x0000f54bd72e6456UL;
   tf->codes[20311] = 0x0000f69cc81e96dbUL;
   tf->codes[20312] = 0x0000f9263037928eUL;
   tf->codes[20313] = 0x0000fbb047fd9f90UL;
   tf->codes[20314] = 0x0000fc90e89dc13eUL;
   tf->codes[20315] = 0x000001a79c4f1ab9UL;
   tf->codes[20316] = 0x00000413f77439b1UL;
   tf->codes[20317] = 0x000004c7c293f08bUL;
   tf->codes[20318] = 0x000005d23f71320cUL;
   tf->codes[20319] = 0x00000745babdcbc4UL;
   tf->codes[20320] = 0x00000a9958b6b3bbUL;
   tf->codes[20321] = 0x00000e16985db5c0UL;
   tf->codes[20322] = 0x0000138c39e96996UL;
   tf->codes[20323] = 0x00001415ee3cfad8UL;
   tf->codes[20324] = 0x000016a80790d1c9UL;
   tf->codes[20325] = 0x00001934a37c1e42UL;
   tf->codes[20326] = 0x0000227becd62512UL;
   tf->codes[20327] = 0x0000260ac981e358UL;
   tf->codes[20328] = 0x00003232dc5f81d1UL;
   tf->codes[20329] = 0x0000325ec7a3d591UL;
   tf->codes[20330] = 0x0000422928aa1cb9UL;
   tf->codes[20331] = 0x00004274a5078cabUL;
   tf->codes[20332] = 0x000049295fefb100UL;
   tf->codes[20333] = 0x00004a148642dc14UL;
   tf->codes[20334] = 0x00004bdb7f7aafadUL;
   tf->codes[20335] = 0x00005172fbb5b967UL;
   tf->codes[20336] = 0x000053a3a309f686UL;
   tf->codes[20337] = 0x000055a10d392745UL;
   tf->codes[20338] = 0x000055c40cb39a02UL;
   tf->codes[20339] = 0x00005bd86df8f1e6UL;
   tf->codes[20340] = 0x00005db55cd2ef5fUL;
   tf->codes[20341] = 0x00005f53d927c5c3UL;
   tf->codes[20342] = 0x000065cca5b0027aUL;
   tf->codes[20343] = 0x0000680cdb01c7edUL;
   tf->codes[20344] = 0x00006f2810340502UL;
   tf->codes[20345] = 0x00006fd4c4020901UL;
   tf->codes[20346] = 0x000070054272d025UL;
   tf->codes[20347] = 0x0000763a1f0d5b4fUL;
   tf->codes[20348] = 0x000076a26dcfa237UL;
   tf->codes[20349] = 0x000080e555b67383UL;
   tf->codes[20350] = 0x000086f76d6591b5UL;
   tf->codes[20351] = 0x000088661af6b244UL;
   tf->codes[20352] = 0x00008b60487dca58UL;
   tf->codes[20353] = 0x00008b94aa6df391UL;
   tf->codes[20354] = 0x00008d1b22196c28UL;
   tf->codes[20355] = 0x00008d7ccea80bbfUL;
   tf->codes[20356] = 0x000090c44d04c1edUL;
   tf->codes[20357] = 0x00009339ce82c7adUL;
   tf->codes[20358] = 0x0000a933c94a154cUL;
   tf->codes[20359] = 0x0000ab6c722c1c5aUL;
   tf->codes[20360] = 0x0000b04fae2963b0UL;
   tf->codes[20361] = 0x0000b3e89b6a1fd2UL;
   tf->codes[20362] = 0x0000b60596b26cc3UL;
   tf->codes[20363] = 0x0000b7e8b2a20603UL;
   tf->codes[20364] = 0x0000b9221406e645UL;
   tf->codes[20365] = 0x0000bab1025e3455UL;
   tf->codes[20366] = 0x0000bb2d37bb7130UL;
   tf->codes[20367] = 0x0000be57a9244aa3UL;
   tf->codes[20368] = 0x0000c317e5a71f3cUL;
   tf->codes[20369] = 0x0000c6ef456d0273UL;
   tf->codes[20370] = 0x0000c858b0249e4fUL;
   tf->codes[20371] = 0x0000cbe03aefa3f5UL;
   tf->codes[20372] = 0x0000cd31db8ce7c9UL;
   tf->codes[20373] = 0x0000cee85c8b1bfaUL;
   tf->codes[20374] = 0x0000d6098443ef11UL;
   tf->codes[20375] = 0x0000e3306980a8ccUL;
   tf->codes[20376] = 0x0000ea8d0a7b57f7UL;
   tf->codes[20377] = 0x0000eee5e277fcbcUL;
   tf->codes[20378] = 0x0000f3158de492fdUL;
   tf->codes[20379] = 0x0000f415fa2cd6a2UL;
   tf->codes[20380] = 0x0000f9b74c6dd873UL;
   tf->codes[20381] = 0x0000fa01a4002b8cUL;
   tf->codes[20382] = 0x0000ffa15c5804faUL;
   tf->codes[20383] = 0x000006c751cc513aUL;
   tf->codes[20384] = 0x0000080287a95fa4UL;
   tf->codes[20385] = 0x000008128ac4f382UL;
   tf->codes[20386] = 0x000010450c1db530UL;
   tf->codes[20387] = 0x000014142fc6c8b3UL;
   tf->codes[20388] = 0x0000226d5f16afd5UL;
   tf->codes[20389] = 0x00002276856f969dUL;
   tf->codes[20390] = 0x0000267a0b08d359UL;
   tf->codes[20391] = 0x00002d5ff40ed021UL;
   tf->codes[20392] = 0x0000306bf929aa3bUL;
   tf->codes[20393] = 0x00003591509c74f6UL;
   tf->codes[20394] = 0x000035aa3f81e9d7UL;
   tf->codes[20395] = 0x000036d830f7a99fUL;
   tf->codes[20396] = 0x000047cc656548b5UL;
   tf->codes[20397] = 0x000048bd43b00406UL;
   tf->codes[20398] = 0x00004977eb9267f6UL;
   tf->codes[20399] = 0x00004a4171c542ebUL;
   tf->codes[20400] = 0x00004a71b5a7044aUL;
   tf->codes[20401] = 0x00004be1fd214d3cUL;
   tf->codes[20402] = 0x00005585b0306ef0UL;
   tf->codes[20403] = 0x00005681142e33a7UL;
   tf->codes[20404] = 0x00005896bd95c7f8UL;
   tf->codes[20405] = 0x00005ed570364b39UL;
   tf->codes[20406] = 0x00005fd7b0f6bd06UL;
   tf->codes[20407] = 0x000061db82ca8f51UL;
   tf->codes[20408] = 0x0000693b1d08897dUL;
   tf->codes[20409] = 0x00006c30424522a3UL;
   tf->codes[20410] = 0x000072bae6612160UL;
   tf->codes[20411] = 0x000077c2bbc203d6UL;
   tf->codes[20412] = 0x00007976b89af890UL;
   tf->codes[20413] = 0x00007ab94058bf9aUL;
   tf->codes[20414] = 0x00007b2a7ae4e785UL;
   tf->codes[20415] = 0x00007bd4aa8dac0dUL;
   tf->codes[20416] = 0x00008c3295ed7c8eUL;
   tf->codes[20417] = 0x00008f67c798652cUL;
   tf->codes[20418] = 0x000091906d5ed85cUL;
   tf->codes[20419] = 0x000093342c8d3373UL;
   tf->codes[20420] = 0x00009335c6765bd6UL;
   tf->codes[20421] = 0x000093ebdb2c4c62UL;
   tf->codes[20422] = 0x00009440b871a8e1UL;
   tf->codes[20423] = 0x000097502bedd986UL;
   tf->codes[20424] = 0x00009766d13d14b5UL;
   tf->codes[20425] = 0x00009b49a0f21866UL;
   tf->codes[20426] = 0x0000a3a9325a4aadUL;
   tf->codes[20427] = 0x0000a4b33a1980a4UL;
   tf->codes[20428] = 0x0000a5d421b6f78fUL;
   tf->codes[20429] = 0x0000a5f33db20837UL;
   tf->codes[20430] = 0x0000a6710cf86d75UL;
   tf->codes[20431] = 0x0000a96d4986b976UL;
   tf->codes[20432] = 0x0000a9d8cc1b5124UL;
   tf->codes[20433] = 0x0000ac19016d1697UL;
   tf->codes[20434] = 0x0000b102a50eff79UL;
   tf->codes[20435] = 0x0000b24dde07a1c1UL;
   tf->codes[20436] = 0x0000b2e28d2c47f3UL;
   tf->codes[20437] = 0x0000b9bf4fd95df3UL;
   tf->codes[20438] = 0x0000babe22387935UL;
   tf->codes[20439] = 0x0000c40446c7632cUL;
   tf->codes[20440] = 0x0000c83292d9d6cfUL;
   tf->codes[20441] = 0x0000c9eae8503928UL;
   tf->codes[20442] = 0x0000cd1ce628d100UL;
   tf->codes[20443] = 0x0000cfd98b66d913UL;
   tf->codes[20444] = 0x0000d188f5135a69UL;
   tf->codes[20445] = 0x0000d3c2c2c07e50UL;
   tf->codes[20446] = 0x0000d42ef502274dUL;
   tf->codes[20447] = 0x0000d6808cc9a33cUL;
   tf->codes[20448] = 0x0000de3fff1e0ed7UL;
   tf->codes[20449] = 0x0000e743588a641aUL;
   tf->codes[20450] = 0x0000e75c476fd8fbUL;
   tf->codes[20451] = 0x0000f75b0a66495cUL;
   tf->codes[20452] = 0x0000fc413fa6dbb3UL;
   tf->codes[20453] = 0x0000fe94e6758b8fUL;
   tf->codes[20454] = 0x0000ff03d76b79c8UL;
   tf->codes[20455] = 0x00000214e4d0d2d0UL;
   tf->codes[20456] = 0x0000053df6df89a5UL;
   tf->codes[20457] = 0x0000085d32e84863UL;
   tf->codes[20458] = 0x00000c976407e80aUL;
   tf->codes[20459] = 0x00000f193fb12558UL;
   tf->codes[20460] = 0x0000171d8c2f5994UL;
   tf->codes[20461] = 0x000018d4824b994fUL;
   tf->codes[20462] = 0x00002428c3d25932UL;
   tf->codes[20463] = 0x000027ea6885184eUL;
   tf->codes[20464] = 0x00002b2bb9cc32b5UL;
   tf->codes[20465] = 0x00003111aba7f762UL;
   tf->codes[20466] = 0x000037db376728beUL;
   tf->codes[20467] = 0x00003af9fe51dbf2UL;
   tf->codes[20468] = 0x00003de8815acdc7UL;
   tf->codes[20469] = 0x0000406d56475616UL;
   tf->codes[20470] = 0x000047746a4f9773UL;
   tf->codes[20471] = 0x000048996ffb7638UL;
   tf->codes[20472] = 0x00004ab162f9443bUL;
   tf->codes[20473] = 0x00004adf97d3d1adUL;
   tf->codes[20474] = 0x00004ee90ff3a46bUL;
   tf->codes[20475] = 0x00004fa551bf30beUL;
   tf->codes[20476] = 0x0000591fd83e43eeUL;
   tf->codes[20477] = 0x000059c5af499ad7UL;
   tf->codes[20478] = 0x00005c79a34cc7acUL;
   tf->codes[20479] = 0x00005cadcaadeb20UL;
   tf->codes[20480] = 0x00005e09b66f3295UL;
   tf->codes[20481] = 0x00005ff50e7b9b89UL;
   tf->codes[20482] = 0x00005ffb76203d15UL;
   tf->codes[20483] = 0x000063d7691293b0UL;
   tf->codes[20484] = 0x000063f56042877fUL;
   tf->codes[20485] = 0x0000642a71dfc207UL;
   tf->codes[20486] = 0x000073bb68ab6108UL;
   tf->codes[20487] = 0x00007ec04a554ee4UL;
   tf->codes[20488] = 0x00007ec16f206bbdUL;
   tf->codes[20489] = 0x00007eeb4b5d8b90UL;
   tf->codes[20490] = 0x0000815a9fc5f589UL;
   tf->codes[20491] = 0x000082e61fbbed0eUL;
   tf->codes[20492] = 0x00008490bbacf53bUL;
   tf->codes[20493] = 0x000084e29faf06b9UL;
   tf->codes[20494] = 0x000088149d879e91UL;
   tf->codes[20495] = 0x0000883d1a6a9bc6UL;
   tf->codes[20496] = 0x00009224bd676f07UL;
   tf->codes[20497] = 0x0000937ff97ba52dUL;
   tf->codes[20498] = 0x0000989b7ae877d1UL;
   tf->codes[20499] = 0x0000a01cb546c21cUL;
   tf->codes[20500] = 0x0000a069cb8d5a71UL;
   tf->codes[20501] = 0x0000a125d2c9e0ffUL;
   tf->codes[20502] = 0x0000a29f060e0af4UL;
   tf->codes[20503] = 0x0000a4053cf3560aUL;
   tf->codes[20504] = 0x0000a43cd2b5d009UL;
   tf->codes[20505] = 0x0000a6f29b312b06UL;
   tf->codes[20506] = 0x0000af8444f34cd4UL;
   tf->codes[20507] = 0x0000b485ed3e9383UL;
   tf->codes[20508] = 0x0000b6f3e24cdadeUL;
   tf->codes[20509] = 0x0000bdbb5f04d84dUL;
   tf->codes[20510] = 0x0000bf99ad38f864UL;
   tf->codes[20511] = 0x0000cab18b41c51fUL;
   tf->codes[20512] = 0x0000ce84ccf9407cUL;
   tf->codes[20513] = 0x0000d0288c279b93UL;
   tf->codes[20514] = 0x0000d0f5f5d9d89dUL;
   tf->codes[20515] = 0x0000d48d0ea26697UL;
   tf->codes[20516] = 0x0000de805c1d6017UL;
   tf->codes[20517] = 0x0000e4313c5bea3cUL;
   tf->codes[20518] = 0x0000ec3d1549dcddUL;
   tf->codes[20519] = 0x0000ee0c852d85efUL;
   tf->codes[20520] = 0x0000eeeaa1a86826UL;
   tf->codes[20521] = 0x0000ef5ed577db12UL;
   tf->codes[20522] = 0x0000efb5c1c46b7eUL;
   tf->codes[20523] = 0x0000fa704bdc0641UL;
   tf->codes[20524] = 0x00000da1bc581fc9UL;
   tf->codes[20525] = 0x00002071bad49f7fUL;
   tf->codes[20526] = 0x00002ec7b65235dbUL;
   tf->codes[20527] = 0x00003025016d9feeUL;
   tf->codes[20528] = 0x0000317f8dd4c4c5UL;
   tf->codes[20529] = 0x0000355e7a0a6661UL;
   tf->codes[20530] = 0x00003780430e2c7bUL;
   tf->codes[20531] = 0x00003b3f639bac20UL;
   tf->codes[20532] = 0x00003c15096ab8deUL;
   tf->codes[20533] = 0x00003f273b9b2ebfUL;
   tf->codes[20534] = 0x0000426050c57972UL;
   tf->codes[20535] = 0x000043763d91db6dUL;
   tf->codes[20536] = 0x000048c745b9f423UL;
   tf->codes[20537] = 0x00004c7def9b9e4fUL;
   tf->codes[20538] = 0x00005886e67e2c20UL;
   tf->codes[20539] = 0x00005add4c012138UL;
   tf->codes[20540] = 0x00005bf92b541935UL;
   tf->codes[20541] = 0x00005c2e02624df8UL;
   tf->codes[20542] = 0x00005ca73e7c3fd2UL;
   tf->codes[20543] = 0x00005cbcbf005e28UL;
   tf->codes[20544] = 0x00005ce0a8b6e7f9UL;
   tf->codes[20545] = 0x000064b685cb88feUL;
   tf->codes[20546] = 0x00006e635f33917aUL;
   tf->codes[20547] = 0x0000714cd9f20461UL;
   tf->codes[20548] = 0x000073cef02a4774UL;
   tf->codes[20549] = 0x00007502d4269d3eUL;
   tf->codes[20550] = 0x000076d27e994c15UL;
   tf->codes[20551] = 0x0000796a8a73b908UL;
   tf->codes[20552] = 0x00007ff5a3adc34fUL;
   tf->codes[20553] = 0x000081d048f18716UL;
   tf->codes[20554] = 0x000082d9db92b183UL;
   tf->codes[20555] = 0x0000859b13fd2cfaUL;
   tf->codes[20556] = 0x000096473a6eb2a9UL;
   tf->codes[20557] = 0x000097622f859392UL;
   tf->codes[20558] = 0x0000997554c7e86cUL;
   tf->codes[20559] = 0x00009c582d52b402UL;
   tf->codes[20560] = 0x00009d3aa26b03d8UL;
   tf->codes[20561] = 0x00009d9ab5107b0cUL;
   tf->codes[20562] = 0x0000a02800a8d8d4UL;
   tf->codes[20563] = 0x0000a59357108909UL;
   tf->codes[20564] = 0x0000ac375f300831UL;
   tf->codes[20565] = 0x0000ad10e87e7704UL;
   tf->codes[20566] = 0x0000b3eb61955352UL;
   tf->codes[20567] = 0x0000b44790bb6871UL;
   tf->codes[20568] = 0x0000c087e2d16a7cUL;
   tf->codes[20569] = 0x0000c9182d3969acUL;
   tf->codes[20570] = 0x0000cf0d37f4ab23UL;
   tf->codes[20571] = 0x0000cf2b2f249ef2UL;
   tf->codes[20572] = 0x0000d19f8bd787d9UL;
   tf->codes[20573] = 0x0000d4200826a289UL;
   tf->codes[20574] = 0x0000dfe9dcd6f7f6UL;
   tf->codes[20575] = 0x0000e2b7e48ab685UL;
   tf->codes[20576] = 0x0000e4bdc565bcbdUL;
   tf->codes[20577] = 0x0000ed6f0040fabdUL;
   tf->codes[20578] = 0x0000edbe9aacd289UL;
   tf->codes[20579] = 0x0000f5781a7aa822UL;
   tf->codes[20580] = 0x0000024f9fda8fd6UL;
   tf->codes[20581] = 0x00000bd979c82595UL;
   tf->codes[20582] = 0x00000cab76a6d603UL;
   tf->codes[20583] = 0x0000131a329a14deUL;
   tf->codes[20584] = 0x00001636755f889bUL;
   tf->codes[20585] = 0x0000245cdca86ee7UL;
   tf->codes[20586] = 0x00002c8c2a2edfcfUL;
   tf->codes[20587] = 0x00002e6ff5cb8a5eUL;
   tf->codes[20588] = 0x00002f8a00a65433UL;
   tf->codes[20589] = 0x00002fbc8e1e4f44UL;
   tf->codes[20590] = 0x000036434ebaebecUL;
   tf->codes[20591] = 0x000037ee5fc9ffa3UL;
   tf->codes[20592] = 0x00003b2cb7cdcf09UL;
   tf->codes[20593] = 0x00004127b50fa682UL;
   tf->codes[20594] = 0x000043b1ccd5b384UL;
   tf->codes[20595] = 0x000047ac66a50f3dUL;
   tf->codes[20596] = 0x000049051e9405ecUL;
   tf->codes[20597] = 0x00004a7c42d0fbf4UL;
   tf->codes[20598] = 0x00004d88f798e75dUL;
   tf->codes[20599] = 0x00004f806f41821aUL;
   tf->codes[20600] = 0x00004fdf5d1bdc75UL;
   tf->codes[20601] = 0x0000513eb73e7a75UL;
   tf->codes[20602] = 0x000052e11712b2eeUL;
   tf->codes[20603] = 0x00005b256fff36a2UL;
   tf->codes[20604] = 0x00005f855f4d8e42UL;
   tf->codes[20605] = 0x00005fde95305860UL;
   tf->codes[20606] = 0x000066d321f7c668UL;
   tf->codes[20607] = 0x00006a3981c08779UL;
   tf->codes[20608] = 0x00006ae07d96fb3bUL;
   tf->codes[20609] = 0x0000732f96c58e1aUL;
   tf->codes[20610] = 0x000075b38175ff55UL;
   tf->codes[20611] = 0x000078543e8b4786UL;
   tf->codes[20612] = 0x00007a25f8052a4aUL;
   tf->codes[20613] = 0x00007ab738c879f1UL;
   tf->codes[20614] = 0x00007b649c438f3fUL;
   tf->codes[20615] = 0x00007cd0509164cdUL;
   tf->codes[20616] = 0x00007f4ce9611d68UL;
   tf->codes[20617] = 0x0000895cceb1e819UL;
   tf->codes[20618] = 0x00009134803eb746UL;
   tf->codes[20619] = 0x0000913a38364783UL;
   tf->codes[20620] = 0x000093da459e7e65UL;
   tf->codes[20621] = 0x00009622f19c1951UL;
   tf->codes[20622] = 0x00009ae53d2621d7UL;
   tf->codes[20623] = 0x00009c8d1a62e4c8UL;
   tf->codes[20624] = 0x00009d3ab86cffdbUL;
   tf->codes[20625] = 0x00009d4b6b35a508UL;
   tf->codes[20626] = 0x00009da0f82812d6UL;
   tf->codes[20627] = 0x00009ee086a28edfUL;
   tf->codes[20628] = 0x0000a4c3f4591415UL;
   tf->codes[20629] = 0x0000ad47aa06d5f2UL;
   tf->codes[20630] = 0x0000af45143606b1UL;
   tf->codes[20631] = 0x0000b41c6b262203UL;
   tf->codes[20632] = 0x0000b6779e649044UL;
   tf->codes[20633] = 0x0000b9b2fd2514a9UL;
   tf->codes[20634] = 0x0000c3584a1d5ec0UL;
   tf->codes[20635] = 0x0000c3b64dbba207UL;
   tf->codes[20636] = 0x0000c457919a858cUL;
   tf->codes[20637] = 0x0000c8ea837ee3c7UL;
   tf->codes[20638] = 0x0000cfc203527514UL;
   tf->codes[20639] = 0x0000d2ed5ef7659bUL;
   tf->codes[20640] = 0x0000d88515c1751aUL;
   tf->codes[20641] = 0x0000dc9e566dd5f1UL;
   tf->codes[20642] = 0x0000dd25117e1c32UL;
   tf->codes[20643] = 0x0000e5ad5a585173UL;
   tf->codes[20644] = 0x0000e8f5886218f0UL;
   tf->codes[20645] = 0x0000e9aab2dbf268UL;
   tf->codes[20646] = 0x0000ea4b819cca63UL;
   tf->codes[20647] = 0x0000eff3eb2f7f0fUL;
   tf->codes[20648] = 0x0000f08cf2f192e0UL;
   tf->codes[20649] = 0x0000f28d1bd508dbUL;
   tf->codes[20650] = 0x0000f412e3d37023UL;
   tf->codes[20651] = 0x0000f64c01d382bbUL;
   tf->codes[20652] = 0x0000fc5f3e4dbdc6UL;
   tf->codes[20653] = 0x0000042c6a27838dUL;
   tf->codes[20654] = 0x000004531292529aUL;
   tf->codes[20655] = 0x00000652c657bd0bUL;
   tf->codes[20656] = 0x00000686b329dabaUL;
   tf->codes[20657] = 0x00001853fbc7dd19UL;
   tf->codes[20658] = 0x000018f53fa6c09eUL;
   tf->codes[20659] = 0x0000216b3bcf284fUL;
   tf->codes[20660] = 0x0000255b155c74ddUL;
   tf->codes[20661] = 0x0000276eafbcd541UL;
   tf->codes[20662] = 0x00002856dcccb554UL;
   tf->codes[20663] = 0x00002aa874943143UL;
   tf->codes[20664] = 0x00002c9984982a74UL;
   tf->codes[20665] = 0x00002d9b503a90b7UL;
   tf->codes[20666] = 0x000033755d092960UL;
   tf->codes[20667] = 0x000034e7ee19ac04UL;
   tf->codes[20668] = 0x0000350c125f3b9aUL;
   tf->codes[20669] = 0x00003974b2e86e78UL;
   tf->codes[20670] = 0x00003af488603fbeUL;
   tf->codes[20671] = 0x000040a827530f1fUL;
   tf->codes[20672] = 0x00004367162750e4UL;
   tf->codes[20673] = 0x000048a76b86c46dUL;
   tf->codes[20674] = 0x000048e5a37ce5bdUL;
   tf->codes[20675] = 0x00004b9d05e1691dUL;
   tf->codes[20676] = 0x00004c39f122df03UL;
   tf->codes[20677] = 0x00004d6c3b360c6aUL;
   tf->codes[20678] = 0x00004ee02ba0b1acUL;
   tf->codes[20679] = 0x00005174c919c814UL;
   tf->codes[20680] = 0x0000521313b56098UL;
   tf->codes[20681] = 0x000056b29a53fc26UL;
   tf->codes[20682] = 0x00005a576ca1e44cUL;
   tf->codes[20683] = 0x00005d8b7981b011UL;
   tf->codes[20684] = 0x000060f0b47f5449UL;
   tf->codes[20685] = 0x000061112fd4878fUL;
   tf->codes[20686] = 0x0000615f305736f8UL;
   tf->codes[20687] = 0x000064f265a062ddUL;
   tf->codes[20688] = 0x000065a83fc74da4UL;
   tf->codes[20689] = 0x000069575d39396bUL;
   tf->codes[20690] = 0x00006b40e0cd7437UL;
   tf->codes[20691] = 0x00006ce8f8993cedUL;
   tf->codes[20692] = 0x00006e1465e9bd3eUL;
   tf->codes[20693] = 0x00006ee7fcb1960fUL;
   tf->codes[20694] = 0x000072cd508bd937UL;
   tf->codes[20695] = 0x000075316f94287bUL;
   tf->codes[20696] = 0x0000786c93c5a71bUL;
   tf->codes[20697] = 0x00007f256cbc334aUL;
   tf->codes[20698] = 0x00007f35aa66ccedUL;
   tf->codes[20699] = 0x000086da1ece8fbaUL;
   tf->codes[20700] = 0x000087abe11e3a63UL;
   tf->codes[20701] = 0x0000887dddfcead1UL;
   tf->codes[20702] = 0x000089edeae82dfeUL;
   tf->codes[20703] = 0x00008d22a7750b12UL;
   tf->codes[20704] = 0x00008dac9657a219UL;
   tf->codes[20705] = 0x00008f18101671e2UL;
   tf->codes[20706] = 0x00009129265192cfUL;
   tf->codes[20707] = 0x0000936cca04aecdUL;
   tf->codes[20708] = 0x000094618bcecc33UL;
   tf->codes[20709] = 0x0000947328d38874UL;
   tf->codes[20710] = 0x000099a515009082UL;
   tf->codes[20711] = 0x0000afd45bf41e6eUL;
   tf->codes[20712] = 0x0000b087ec84cf83UL;
   tf->codes[20713] = 0x0000b18c76db7b02UL;
   tf->codes[20714] = 0x0000b932852c6632UL;
   tf->codes[20715] = 0x0000bad385a67c0dUL;
   tf->codes[20716] = 0x0000bd38c979e82aUL;
   tf->codes[20717] = 0x0000c4eaf7670523UL;
   tf->codes[20718] = 0x0000c51f1ec82897UL;
   tf->codes[20719] = 0x0000c69b4b4f9d8dUL;
   tf->codes[20720] = 0x0000c6c318858973UL;
   tf->codes[20721] = 0x0000c8444d577d57UL;
   tf->codes[20722] = 0x0000d20289353c4fUL;
   tf->codes[20723] = 0x0000e230e0605cc0UL;
   tf->codes[20724] = 0x0000e36e5fd3a4dcUL;
   tf->codes[20725] = 0x0000e5b70bd13fc8UL;
   tf->codes[20726] = 0x0000ea3aaa471b74UL;
   tf->codes[20727] = 0x0000eb60251105c3UL;
   tf->codes[20728] = 0x0000fb33ac7033b3UL;
   tf->codes[20729] = 0x0000ff0e7a976d75UL;
   tf->codes[20730] = 0x000010265e2c9097UL;
   tf->codes[20731] = 0x000010c88c478b30UL;
   tf->codes[20732] = 0x000013e802df4fb3UL;
   tf->codes[20733] = 0x000015cb595deeb8UL;
   tf->codes[20734] = 0x0000164a4d6f70cfUL;
   tf->codes[20735] = 0x0000194ec61a8c84UL;
   tf->codes[20736] = 0x00001bee5e64b7dcUL;
   tf->codes[20737] = 0x00001d85fdf6e12aUL;
   tf->codes[20738] = 0x00001f06f839cf49UL;
   tf->codes[20739] = 0x00001f1611194c13UL;
   tf->codes[20740] = 0x00001fbf1bf6f3c2UL;
   tf->codes[20741] = 0x000024bce0c2d85cUL;
   tf->codes[20742] = 0x00002543d6622462UL;
   tf->codes[20743] = 0x000027982cdde58dUL;
   tf->codes[20744] = 0x0000297d57d4b2baUL;
   tf->codes[20745] = 0x00002be470204cffUL;
   tf->codes[20746] = 0x00002cef621b9a0aUL;
   tf->codes[20747] = 0x00002f28baaab267UL;
   tf->codes[20748] = 0x0000332aa65ac6c0UL;
   tf->codes[20749] = 0x0000391bcd96a622UL;
   tf->codes[20750] = 0x00003d136e22b6daUL;
   tf->codes[20751] = 0x00003e578fc9a647UL;
   tf->codes[20752] = 0x00004415b46f7f0eUL;
   tf->codes[20753] = 0x0000441788e7ad36UL;
   tf->codes[20754] = 0x00004f57a9447161UL;
   tf->codes[20755] = 0x0000526b3acf09e0UL;
   tf->codes[20756] = 0x0000589f2d2d7df6UL;
   tf->codes[20757] = 0x00005e7c333f61a0UL;
   tf->codes[20758] = 0x00005f9e3fa7f564UL;
   tf->codes[20759] = 0x00005fc1eecf7970UL;
   tf->codes[20760] = 0x00006336f259abc1UL;
   tf->codes[20761] = 0x000066fa6b849905UL;
   tf->codes[20762] = 0x0000671c0ba4e924UL;
   tf->codes[20763] = 0x00006d64944b647cUL;
   tf->codes[20764] = 0x00006f5da5dd279cUL;
   tf->codes[20765] = 0x000072d65257b63dUL;
   tf->codes[20766] = 0x00007478b22beeb6UL;
   tf->codes[20767] = 0x00007618534be1f3UL;
   tf->codes[20768] = 0x0000767691792affUL;
   tf->codes[20769] = 0x00007a44cae6276eUL;
   tf->codes[20770] = 0x00007a9f9ab219efUL;
   tf->codes[20771] = 0x00007cf8f9785a08UL;
   tf->codes[20772] = 0x00008290b0426987UL;
   tf->codes[20773] = 0x0000855a99e7c03cUL;
   tf->codes[20774] = 0x0000859d9f995ab5UL;
   tf->codes[20775] = 0x000085b9c251205cUL;
   tf->codes[20776] = 0x00008694aaf9b1cdUL;
   tf->codes[20777] = 0x000086e9132102c2UL;
   tf->codes[20778] = 0x00008e79a0edcf9cUL;
   tf->codes[20779] = 0x000095edd173d10aUL;
   tf->codes[20780] = 0x000097a27df9d713UL;
   tf->codes[20781] = 0x000097ed4aaa35b6UL;
   tf->codes[20782] = 0x00009b30e58789cfUL;
   tf->codes[20783] = 0x00009c5c1849045bUL;
   tf->codes[20784] = 0x0000a6f2438c09c3UL;
   tf->codes[20785] = 0x0000a704903dd753UL;
   tf->codes[20786] = 0x0000a8896e002787UL;
   tf->codes[20787] = 0x0000a97e6a594ab2UL;
   tf->codes[20788] = 0x0000ae65c464f9e2UL;
   tf->codes[20789] = 0x0000b2301a52943cUL;
   tf->codes[20790] = 0x0000b26098c35b60UL;
   tf->codes[20791] = 0x0000b31379a6fb26UL;
   tf->codes[20792] = 0x0000bd182997ab22UL;
   tf->codes[20793] = 0x0000c0e8720bdb7eUL;
   tf->codes[20794] = 0x0000c293488be970UL;
   tf->codes[20795] = 0x0000c3306e5c651bUL;
   tf->codes[20796] = 0x0000c9aa9a3ec470UL;
   tf->codes[20797] = 0x0000cc3b19a972feUL;
   tf->codes[20798] = 0x0000cc6f7b999c37UL;
   tf->codes[20799] = 0x0000d1987bfcc342UL;
   tf->codes[20800] = 0x0000d2b077d0592aUL;
   tf->codes[20801] = 0x0000d2b1277d6a79UL;
   tf->codes[20802] = 0x0000d2fb4480b7cdUL;
   tf->codes[20803] = 0x0000d5c4095af1a9UL;
   tf->codes[20804] = 0x0000d68d8f8dcc9eUL;
   tf->codes[20805] = 0x0000e2f414f0922cUL;
   tf->codes[20806] = 0x0000e4d60c150e93UL;
   tf->codes[20807] = 0x0000e57c1daf6b41UL;
   tf->codes[20808] = 0x0000ee3ebb005fbdUL;
   tf->codes[20809] = 0x0000f37f857dded0UL;
   tf->codes[20810] = 0x0000f7a5957382bfUL;
   tf->codes[20811] = 0x000004112320c73bUL;
   tf->codes[20812] = 0x000006b16b1803e2UL;
   tf->codes[20813] = 0x00000aa7ac49f1fcUL;
   tf->codes[20814] = 0x00000d7eda569753UL;
   tf->codes[20815] = 0x0000104012c112caUL;
   tf->codes[20816] = 0x00001c9a3df8a0caUL;
   tf->codes[20817] = 0x00001e3ee76312f5UL;
   tf->codes[20818] = 0x0000219a4c5abf16UL;
   tf->codes[20819] = 0x000025fa011a10f1UL;
   tf->codes[20820] = 0x0000261156165d6fUL;
   tf->codes[20821] = 0x00002b5c6bb7e023UL;
   tf->codes[20822] = 0x00002ba85d335b9fUL;
   tf->codes[20823] = 0x000034fc75d6a587UL;
   tf->codes[20824] = 0x00003c8cc9146c9cUL;
   tf->codes[20825] = 0x00003dd83c9c14a9UL;
   tf->codes[20826] = 0x00003e3a5e48bfcaUL;
   tf->codes[20827] = 0x00003f442b78effcUL;
   tf->codes[20828] = 0x00004ac1d41ec428UL;
   tf->codes[20829] = 0x00004ddcf2191b0cUL;
   tf->codes[20830] = 0x000050bbac957ec8UL;
   tf->codes[20831] = 0x000054516603ea24UL;
   tf->codes[20832] = 0x00005cd9e96d252aUL;
   tf->codes[20833] = 0x00005d670c220cf7UL;
   tf->codes[20834] = 0x00005f38c59befbbUL;
   tf->codes[20835] = 0x000060df7e0d95d3UL;
   tf->codes[20836] = 0x0000651eb777b468UL;
   tf->codes[20837] = 0x00006c2c6db39d16UL;
   tf->codes[20838] = 0x00006f7bed9e1d33UL;
   tf->codes[20839] = 0x000071efd532fa90UL;
   tf->codes[20840] = 0x0000725f3b46f453UL;
   tf->codes[20841] = 0x00007405440b891cUL;
   tf->codes[20842] = 0x00007bb02017ed75UL;
   tf->codes[20843] = 0x00007c02ee561607UL;
   tf->codes[20844] = 0x00007e727d4d85c5UL;
   tf->codes[20845] = 0x000087154ef6584aUL;
   tf->codes[20846] = 0x00008fbc793c986eUL;
   tf->codes[20847] = 0x000093e3736e5371UL;
   tf->codes[20848] = 0x0000a00ce5a61488UL;
   tf->codes[20849] = 0x0000a4efe7145619UL;
   tf->codes[20850] = 0x0000a78917b9dfe5UL;
   tf->codes[20851] = 0x0000a88406999912UL;
   tf->codes[20852] = 0x0000ab0398ac9caeUL;
   tf->codes[20853] = 0x0000ab2538cceccdUL;
   tf->codes[20854] = 0x0000ab6803ef8181UL;
   tf->codes[20855] = 0x0000b1e563a4319cUL;
   tf->codes[20856] = 0x0000b5a0db4154f1UL;
   tf->codes[20857] = 0x0000b66225576032UL;
   tf->codes[20858] = 0x0000bcd91d676ec1UL;
   tf->codes[20859] = 0x0000bf05e13c49cbUL;
   tf->codes[20860] = 0x0000bfb5c8dc9e90UL;
   tf->codes[20861] = 0x0000bfd8533905c3UL;
   tf->codes[20862] = 0x0000c42371b0505cUL;
   tf->codes[20863] = 0x0000c9e997e3f312UL;
   tf->codes[20864] = 0x0000cb78fb594cacUL;
   tf->codes[20865] = 0x0000d3b9e5e479d5UL;
   tf->codes[20866] = 0x0000d6063ad27111UL;
   tf->codes[20867] = 0x0000ddd06d68ebd7UL;
   tf->codes[20868] = 0x0000e30727516d0eUL;
   tf->codes[20869] = 0x0000e57f2cf4b245UL;
   tf->codes[20870] = 0x0000e775ba6135eeUL;
   tf->codes[20871] = 0x0000edf5d8ca2b45UL;
   tf->codes[20872] = 0x0000eee089ff4acfUL;
   tf->codes[20873] = 0x0000f35584b3b53bUL;
   tf->codes[20874] = 0x0000f9829a4f7c3bUL;
   tf->codes[20875] = 0x0000fcf170c412c5UL;
   tf->codes[20876] = 0x0000fdab2e6a5fa1UL;
   tf->codes[20877] = 0x000007acaa88bed7UL;
   tf->codes[20878] = 0x00000c83c6e9d464UL;
   tf->codes[20879] = 0x00000d6dc871e29fUL;
   tf->codes[20880] = 0x00000f9ee4e42b48UL;
   tf->codes[20881] = 0x000011401fed46e8UL;
   tf->codes[20882] = 0x000011be9ee0bd75UL;
   tf->codes[20883] = 0x00001c114f541cdaUL;
   tf->codes[20884] = 0x0000201a8ce4e9d3UL;
   tf->codes[20885] = 0x0000206c3657f58cUL;
   tf->codes[20886] = 0x00002fdec0d59534UL;
   tf->codes[20887] = 0x0000300cf5b022a6UL;
   tf->codes[20888] = 0x0000302c4c3a3913UL;
   tf->codes[20889] = 0x000035266815c15dUL;
   tf->codes[20890] = 0x00003740df38ced7UL;
   tf->codes[20891] = 0x000038bcd1313e08UL;
   tf->codes[20892] = 0x0000399117a62828UL;
   tf->codes[20893] = 0x00003c35088dc11fUL;
   tf->codes[20894] = 0x00003d39585566d9UL;
   tf->codes[20895] = 0x00003def327c51a0UL;
   tf->codes[20896] = 0x00003e52ee122524UL;
   tf->codes[20897] = 0x0000454b98e7fb06UL;
   tf->codes[20898] = 0x000045f1aa8257b4UL;
   tf->codes[20899] = 0x0000554887663d3fUL;
   tf->codes[20900] = 0x000055781b9aed4fUL;
   tf->codes[20901] = 0x00005a8867a7a53eUL;
   tf->codes[20902] = 0x00005d3a12149861UL;
   tf->codes[20903] = 0x00005e47c2c42aa8UL;
   tf->codes[20904] = 0x0000614bc6513ad3UL;
   tf->codes[20905] = 0x000068fb358a1290UL;
   tf->codes[20906] = 0x00006a79aba7c138UL;
   tf->codes[20907] = 0x00006c8927f9b9c2UL;
   tf->codes[20908] = 0x00006dfb7e7b36a1UL;
   tf->codes[20909] = 0x00007c5179f8ccfdUL;
   tf->codes[20910] = 0x00007d77a46fc89bUL;
   tf->codes[20911] = 0x00007f5c5a488a3eUL;
   tf->codes[20912] = 0x000087f84f2eafadUL;
   tf->codes[20913] = 0x000092ef3cc43d98UL;
   tf->codes[20914] = 0x000095fbf18c2901UL;
   tf->codes[20915] = 0x000097dc895682caUL;
   tf->codes[20916] = 0x00009c268302b08aUL;
   tf->codes[20917] = 0x00009d1049fbb900UL;
   tf->codes[20918] = 0x00009d3349762bbdUL;
   tf->codes[20919] = 0x00009d99c3c0447dUL;
   tf->codes[20920] = 0x0000a3f71d3dccdcUL;
   tf->codes[20921] = 0x0000a70481b2c994UL;
   tf->codes[20922] = 0x0000a9c126f0d1a7UL;
   tf->codes[20923] = 0x0000aa0c68bf3bd4UL;
   tf->codes[20924] = 0x0000aa3b4d46da95UL;
   tf->codes[20925] = 0x0000ade2692afc6dUL;
   tf->codes[20926] = 0x0000b8dfbe652be4UL;
   tf->codes[20927] = 0x0000bfbde06c6482UL;
   tf->codes[20928] = 0x0000c1e6c0c1dd77UL;
   tf->codes[20929] = 0x0000c3aa110954c0UL;
   tf->codes[20930] = 0x0000c8bad2341839UL;
   tf->codes[20931] = 0x0000cfe7defa1754UL;
   tf->codes[20932] = 0x0000d51c89db649eUL;
   tf->codes[20933] = 0x0000d645e824b102UL;
   tf->codes[20934] = 0x0000d78033c5a858UL;
   tf->codes[20935] = 0x0000d89d37e3bd2eUL;
   tf->codes[20936] = 0x0000d9b533b75316UL;
   tf->codes[20937] = 0x0000dc7b746c4d7bUL;
   tf->codes[20938] = 0x0000dce681e2d99fUL;
   tf->codes[20939] = 0x0000dd9df5f2ecc9UL;
   tf->codes[20940] = 0x0000e09fea78c907UL;
   tf->codes[20941] = 0x0000f305c5bad3adUL;
   tf->codes[20942] = 0x0000f395e1b3067bUL;
   tf->codes[20943] = 0x0000f3cf867cb467UL;
   tf->codes[20944] = 0x0000f78df75d22bdUL;
   tf->codes[20945] = 0x0000f790b61167f9UL;
   tf->codes[20946] = 0x0000052a35346c3dUL;
   tf->codes[20947] = 0x00000c9c91423f83UL;
   tf->codes[20948] = 0x000015337ddde604UL;
   tf->codes[20949] = 0x00001c9bc956bb6eUL;
   tf->codes[20950] = 0x00002107d84144d7UL;
   tf->codes[20951] = 0x0000231077d0904bUL;
   tf->codes[20952] = 0x000028b9cb9f5c0bUL;
   tf->codes[20953] = 0x00002bbad5e92135UL;
   tf->codes[20954] = 0x00002c89d98486a2UL;
   tf->codes[20955] = 0x00003261d74beb5eUL;
   tf->codes[20956] = 0x000034a839b34c98UL;
   tf->codes[20957] = 0x00003b2b515f8cf0UL;
   tf->codes[20958] = 0x00004cdfe5a72033UL;
   tf->codes[20959] = 0x00005009a762e857UL;
   tf->codes[20960] = 0x0000503642544d66UL;
   tf->codes[20961] = 0x000050b486b8be2eUL;
   tf->codes[20962] = 0x00005161ea33d37cUL;
   tf->codes[20963] = 0x0000518d605a1bb2UL;
   tf->codes[20964] = 0x000051a9bda0e71eUL;
   tf->codes[20965] = 0x000052dcf1f02b99UL;
   tf->codes[20966] = 0x0000542c0e682ff6UL;
   tf->codes[20967] = 0x000055d1a20eb935UL;
   tf->codes[20968] = 0x0000582bb0820a9dUL;
   tf->codes[20969] = 0x00005eca75c80512UL;
   tf->codes[20970] = 0x00006277f950c876UL;
   tf->codes[20971] = 0x000064f5f17aa3afUL;
   tf->codes[20972] = 0x0000665f5c323f8bUL;
   tf->codes[20973] = 0x0000668972fe6523UL;
   tf->codes[20974] = 0x000068fef47c6ae3UL;
   tf->codes[20975] = 0x00006cab18ab0ba9UL;
   tf->codes[20976] = 0x0000740117721383UL;
   tf->codes[20977] = 0x00007993164492c5UL;
   tf->codes[20978] = 0x00007a7e3c97bdd9UL;
   tf->codes[20979] = 0x00007fb40c4427fcUL;
   tf->codes[20980] = 0x0000810488164ef7UL;
   tf->codes[20981] = 0x0000818c2d62ac4cUL;
   tf->codes[20982] = 0x00008193b9d26ab1UL;
   tf->codes[20983] = 0x0000824c52ad9ab4UL;
   tf->codes[20984] = 0x00008763b60c057eUL;
   tf->codes[20985] = 0x00009397e885d5c0UL;
   tf->codes[20986] = 0x0000990f9918bd83UL;
   tf->codes[20987] = 0x00009f7bd0e6bce7UL;
   tf->codes[20988] = 0x00009f835d567b4cUL;
   tf->codes[20989] = 0x0000a62fa192ca28UL;
   tf->codes[20990] = 0x0000a74a96a9ab11UL;
   tf->codes[20991] = 0x0000abdfd22442feUL;
   tf->codes[20992] = 0x0000b78f932406b1UL;
   tf->codes[20993] = 0x0000b98bd8881a97UL;
   tf->codes[20994] = 0x0000b9cc1f856fd4UL;
   tf->codes[20995] = 0x0000bda519347b6eUL;
   tf->codes[20996] = 0x0000bfebf0b9e832UL;
   tf->codes[20997] = 0x0000c160cb60a488UL;
   tf->codes[20998] = 0x0000c4b971a40b6dUL;
   tf->codes[20999] = 0x0000d1e9b7c8b1b5UL;
   tf->codes[21000] = 0x0000d4d0ae61e525UL;
   tf->codes[21001] = 0x0000dbaf80162f12UL;
   tf->codes[21002] = 0x0000dcf15826e4cdUL;
   tf->codes[21003] = 0x0000dfeb108ff157UL;
   tf->codes[21004] = 0x0000e1cccd2567f9UL;
   tf->codes[21005] = 0x0000e694d0a700bcUL;
   tf->codes[21006] = 0x0000e7a0e76d6aa0UL;
   tf->codes[21007] = 0x0000ef555ef0c14bUL;
   tf->codes[21008] = 0x0000f16b7d766126UL;
   tf->codes[21009] = 0x0000f31c467d051aUL;
   tf->codes[21010] = 0x0000fb11b4aac251UL;
   tf->codes[21011] = 0x0000013b5be532c6UL;
   tf->codes[21012] = 0x00000549dc4f8472UL;
   tf->codes[21013] = 0x000008eb05ad1048UL;
   tf->codes[21014] = 0x00000b6f2aec8748UL;
   tf->codes[21015] = 0x000011f11dcdaac7UL;
   tf->codes[21016] = 0x000012df77f326a1UL;
   tf->codes[21017] = 0x000015c49a142be9UL;
   tf->codes[21018] = 0x00001c8206372b7cUL;
   tf->codes[21019] = 0x000029e0f6546ac0UL;
   tf->codes[21020] = 0x00002c3d13cef015UL;
   tf->codes[21021] = 0x00003204d3ebbb2eUL;
   tf->codes[21022] = 0x000033f40f778637UL;
   tf->codes[21023] = 0x000039c09d4fca79UL;
   tf->codes[21024] = 0x0000449959265ed0UL;
   tf->codes[21025] = 0x000046aa6f617fbdUL;
   tf->codes[21026] = 0x00004d44dc0a0c93UL;
   tf->codes[21027] = 0x0000559136845a36UL;
   tf->codes[21028] = 0x00005686e28a8eb0UL;
   tf->codes[21029] = 0x000056be784d08afUL;
   tf->codes[21030] = 0x0000572910a58949UL;
   tf->codes[21031] = 0x00005af65fd66ea4UL;
   tf->codes[21032] = 0x00005b751958eaf6UL;
   tf->codes[21033] = 0x0000637756cfeb45UL;
   tf->codes[21034] = 0x00006e47616ba45eUL;
   tf->codes[21035] = 0x00007469b6c55c33UL;
   tf->codes[21036] = 0x00007a76510befedUL;
   tf->codes[21037] = 0x00007fd4630c5180UL;
   tf->codes[21038] = 0x000081b7b98af085UL;
   tf->codes[21039] = 0x000085abebb5aab2UL;
   tf->codes[21040] = 0x000086b8027c1496UL;
   tf->codes[21041] = 0x000087559d6a9bcbUL;
   tf->codes[21042] = 0x000091bb4a3cda0fUL;
   tf->codes[21043] = 0x000096ef4571160aUL;
   tf->codes[21044] = 0x000098cfa2ac6a0eUL;
   tf->codes[21045] = 0x000099d5173f2ca1UL;
   tf->codes[21046] = 0x00009a0ad8897878UL;
   tf->codes[21047] = 0x00009cd8309025b8UL;
   tf->codes[21048] = 0x00009d071517c479UL;
   tf->codes[21049] = 0x00009deb5ea84277UL;
   tf->codes[21050] = 0x0000a1877fbb4f5fUL;
   tf->codes[21051] = 0x0000a638ddedacf3UL;
   tf->codes[21052] = 0x0000a7c03fd53c9eUL;
   tf->codes[21053] = 0x0000a9158962dcc2UL;
   tf->codes[21054] = 0x0000ad04b3431801UL;
   tf->codes[21055] = 0x0000b595383a1cf6UL;
   tf->codes[21056] = 0x0000b63a25095ccbUL;
   tf->codes[21057] = 0x0000bb7203bcfadbUL;
   tf->codes[21058] = 0x0000bd822fbc04b4UL;
   tf->codes[21059] = 0x0000c1356b3c5855UL;
   tf->codes[21060] = 0x0000cb51aab85a94UL;
   tf->codes[21061] = 0x0000cc5a531d6dedUL;
   tf->codes[21062] = 0x0000cd182ed222a3UL;
   tf->codes[21063] = 0x0000ce29135405b0UL;
   tf->codes[21064] = 0x0000cfe33d429631UL;
   tf->codes[21065] = 0x0000d26eeef1cb96UL;
   tf->codes[21066] = 0x0000d3cfe2fd91f9UL;
   tf->codes[21067] = 0x0000f2b482dac5bfUL;
   tf->codes[21068] = 0x0000f307c636f9dbUL;
   tf->codes[21069] = 0x0000fed543d7ab98UL;
   tf->codes[21070] = 0x000001b5231f2c2dUL;
   tf->codes[21071] = 0x00000302a5ae0827UL;
   tf->codes[21072] = 0x00000886eafb2d3dUL;
   tf->codes[21073] = 0x0000096a4a4f9427UL;
   tf->codes[21074] = 0x00000bdf913e9422UL;
   tf->codes[21075] = 0x00000d79ef8502acUL;
   tf->codes[21076] = 0x00000df70f1e569bUL;
   tf->codes[21077] = 0x00000ffe4f537f71UL;
   tf->codes[21078] = 0x000014bc7ccf201dUL;
   tf->codes[21079] = 0x0000249baeac744cUL;
   tf->codes[21080] = 0x0000269485af31a7UL;
   tf->codes[21081] = 0x00002863f592dab9UL;
   tf->codes[21082] = 0x00002941d77eb72bUL;
   tf->codes[21083] = 0x00002a002851776bUL;
   tf->codes[21084] = 0x0000343ef229e0ddUL;
   tf->codes[21085] = 0x000039486173ebb6UL;
   tf->codes[21086] = 0x00003cafab78c3dbUL;
   tf->codes[21087] = 0x00003f574550b922UL;
   tf->codes[21088] = 0x000043d5a0ed101bUL;
   tf->codes[21089] = 0x0000462180bcfbcdUL;
   tf->codes[21090] = 0x000047b0e4325567UL;
   tf->codes[21091] = 0x0000496b833ef172UL;
   tf->codes[21092] = 0x00004eb205b400c2UL;
   tf->codes[21093] = 0x00005423fe4f5848UL;
   tf->codes[21094] = 0x000055281387f83dUL;
   tf->codes[21095] = 0x00005b68d52faf6bUL;
   tf->codes[21096] = 0x0000640f8a57e405UL;
   tf->codes[21097] = 0x000066d0883359b7UL;
   tf->codes[21098] = 0x00006d24bb57fb4eUL;
   tf->codes[21099] = 0x000071a6fa73b45cUL;
   tf->codes[21100] = 0x000072dc033b26ffUL;
   tf->codes[21101] = 0x00007b8368106ce8UL;
   tf->codes[21102] = 0x00008b5d1c85369fUL;
   tf->codes[21103] = 0x00009bbc2cb023f9UL;
   tf->codes[21104] = 0x00009f73c0cde539UL;
   tf->codes[21105] = 0x00009fb616d26e63UL;
   tf->codes[21106] = 0x0000ab83cf0225e5UL;
   tf->codes[21107] = 0x0000b37016d6fc54UL;
   tf->codes[21108] = 0x0000b57e6e5dd805UL;
   tf->codes[21109] = 0x0000b6c8f7a968feUL;
   tf->codes[21110] = 0x0000b84bc6648545UL;
   tf->codes[21111] = 0x0000bb9553c86f60UL;
   tf->codes[21112] = 0x0000c091098d200dUL;
   tf->codes[21113] = 0x0000c0c82a318e82UL;
   tf->codes[21114] = 0x0000c1ac393306bbUL;
   tf->codes[21115] = 0x0000c3878e23dbd1UL;
   tf->codes[21116] = 0x0000c43cf32cbb0eUL;
   tf->codes[21117] = 0x0000c4c373adfb8aUL;
   tf->codes[21118] = 0x0000c4f258359a4bUL;
   tf->codes[21119] = 0x0000c5f632df347bUL;
   tf->codes[21120] = 0x0000c73511ac9f35UL;
   tf->codes[21121] = 0x0000c83c20288a2bUL;
   tf->codes[21122] = 0x0000c88a5b3a3f59UL;
   tf->codes[21123] = 0x0000ce86f2653f35UL;
   tf->codes[21124] = 0x0000d56bf12f24e9UL;
   tf->codes[21125] = 0x0000d71da471dff1UL;
   tf->codes[21126] = 0x0000ddafd4fd9d13UL;
   tf->codes[21127] = 0x0000df98a8e4c690UL;
   tf->codes[21128] = 0x0000e53c7f4b07d8UL;
   tf->codes[21129] = 0x0000ea8c9d37097aUL;
   tf->codes[21130] = 0x0000ede9d6a6e3c3UL;
   tf->codes[21131] = 0x0000f297c677eaccUL;
   tf->codes[21132] = 0x0000f63dbd90efcbUL;
   tf->codes[21133] = 0x0000f80f3c7bcccaUL;
   tf->codes[21134] = 0x0000f8e6b6c307b0UL;
   tf->codes[21135] = 0x00000553de59748fUL;
   tf->codes[21136] = 0x000009bb1f8884cfUL;
   tf->codes[21137] = 0x00000c5ed5e11801UL;
   tf->codes[21138] = 0x00000f51ec167d3aUL;
   tf->codes[21139] = 0x000011da69f361d9UL;
   tf->codes[21140] = 0x00001a648745c542UL;
   tf->codes[21141] = 0x00001a9b6d5b2df2UL;
   tf->codes[21142] = 0x00002348ff460fa2UL;
   tf->codes[21143] = 0x000028e9674afa5fUL;
   tf->codes[21144] = 0x00002b22102d016dUL;
   tf->codes[21145] = 0x00002ecac5fa4ba8UL;
   tf->codes[21146] = 0x00003c1ce6ce47d4UL;
   tf->codes[21147] = 0x00004139c7953d16UL;
   tf->codes[21148] = 0x000042582b0d748aUL;
   tf->codes[21149] = 0x000052c6c935ea38UL;
   tf->codes[21150] = 0x00005393833b15f3UL;
   tf->codes[21151] = 0x00005b419319cb12UL;
   tf->codes[21152] = 0x00005d2524276fdcUL;
   tf->codes[21153] = 0x00005feff808dda5UL;
   tf->codes[21154] = 0x00006926197c33beUL;
   tf->codes[21155] = 0x00006de2727fa642UL;
   tf->codes[21156] = 0x00006f55039028e6UL;
   tf->codes[21157] = 0x000072973f135a61UL;
   tf->codes[21158] = 0x000075227ba4843cUL;
   tf->codes[21159] = 0x000077fd52a185e3UL;
   tf->codes[21160] = 0x00007eaccab02585UL;
   tf->codes[21161] = 0x000083e4e3f2c95aUL;
   tf->codes[21162] = 0x00008657319e7e54UL;
   tf->codes[21163] = 0x000087dbd4d1c8c3UL;
   tf->codes[21164] = 0x00008fc906e2b646UL;
   tf->codes[21165] = 0x000091373f55cb4bUL;
   tf->codes[21166] = 0x000092ce69c9e90fUL;
   tf->codes[21167] = 0x000098577cd2874eUL;
   tf->codes[21168] = 0x00009d2cff4a7478UL;
   tf->codes[21169] = 0x0000a17c765f2cb0UL;
   tf->codes[21170] = 0x0000b059dc9a1a9cUL;
   tf->codes[21171] = 0x0000b2eb0bb1da79UL;
   tf->codes[21172] = 0x0000b628ee979e55UL;
   tf->codes[21173] = 0x0000bfd72759c96fUL;
   tf->codes[21174] = 0x0000c9f366d5cbaeUL;
   tf->codes[21175] = 0x0000ca2e306a9673UL;
   tf->codes[21176] = 0x0000cba8fd97e8cbUL;
   tf->codes[21177] = 0x0000d162c9a053f3UL;
   tf->codes[21178] = 0x0000d6baae8b19bfUL;
   tf->codes[21179] = 0x0000d792d87f65f4UL;
   tf->codes[21180] = 0x0000d8119201e246UL;
   tf->codes[21181] = 0x0000d9d1ae7708c9UL;
   tf->codes[21182] = 0x0000e1832cb71473UL;
   tf->codes[21183] = 0x0000e945d2ddd0d4UL;
   tf->codes[21184] = 0x0000ef093a5d2e4eUL;
   tf->codes[21185] = 0x0000f3fa2fdfcfd0UL;
   tf->codes[21186] = 0x0000f4591dba2a2bUL;
   tf->codes[21187] = 0x0000f9065dde1fe5UL;
   tf->codes[21188] = 0x000000a2962912feUL;
   tf->codes[21189] = 0x000005504b6b1442UL;
   tf->codes[21190] = 0x000005fb9fdef5a3UL;
   tf->codes[21191] = 0x000016ee3a636c56UL;
   tf->codes[21192] = 0x000018f5057a89a2UL;
   tf->codes[21193] = 0x00001b1b271bbd5bUL;
   tf->codes[21194] = 0x00001d4700b48151UL;
   tf->codes[21195] = 0x00001de12d41b1fbUL;
   tf->codes[21196] = 0x00001e88d8c5370cUL;
   tf->codes[21197] = 0x000023368e073850UL;
   tf->codes[21198] = 0x00002cc7f4648c74UL;
   tf->codes[21199] = 0x00002f82500c5ad5UL;
   tf->codes[21200] = 0x0000386d6a404c86UL;
   tf->codes[21201] = 0x0000408e4e9451f3UL;
   tf->codes[21202] = 0x0000499dc79cd8ffUL;
   tf->codes[21203] = 0x00004be49f2245c3UL;
   tf->codes[21204] = 0x000054c2af7dee97UL;
   tf->codes[21205] = 0x00005586b8483f14UL;
   tf->codes[21206] = 0x0000569b80498436UL;
   tf->codes[21207] = 0x00005d0533f24423UL;
   tf->codes[21208] = 0x00005ee1e83d3bd7UL;
   tf->codes[21209] = 0x0000636e37edf2c1UL;
   tf->codes[21210] = 0x00006475bb87e941UL;
   tf->codes[21211] = 0x00006b1ff0bd0430UL;
   tf->codes[21212] = 0x00007ae842bc176bUL;
   tf->codes[21213] = 0x00007e2bdd996b84UL;
   tf->codes[21214] = 0x000082c571b17110UL;
   tf->codes[21215] = 0x0000846a55aae900UL;
   tf->codes[21216] = 0x00008dcd4c9ea9edUL;
   tf->codes[21217] = 0x000090aec5cf52e5UL;
   tf->codes[21218] = 0x0000970fc83d3794UL;
   tf->codes[21219] = 0x0000a74cfdb8cf0aUL;
   tf->codes[21220] = 0x0000ab01237539bfUL;
   tf->codes[21221] = 0x0000ae30d7b797e5UL;
   tf->codes[21222] = 0x0000ae4a3bbb1850UL;
   tf->codes[21223] = 0x0000af823dc5d5f4UL;
   tf->codes[21224] = 0x0000b2e395441817UL;
   tf->codes[21225] = 0x0000b452f28249f5UL;
   tf->codes[21226] = 0x0000b4b3ef63d83dUL;
   tf->codes[21227] = 0x0000b5a03a82202aUL;
   tf->codes[21228] = 0x0000b67cf7a2dfc3UL;
   tf->codes[21229] = 0x0000b6a7838d10e5UL;
   tf->codes[21230] = 0x0000bba12a4a8da5UL;
   tf->codes[21231] = 0x0000bc085441b7b4UL;
   tf->codes[21232] = 0x0000bd0676f3c1a7UL;
   tf->codes[21233] = 0x0000c01af2ba713aUL;
   tf->codes[21234] = 0x0000c126cef1d559UL;
   tf->codes[21235] = 0x0000c3a785cff5ceUL;
   tf->codes[21236] = 0x0000c52dc2ec68a0UL;
   tf->codes[21237] = 0x0000c5abccc1d3a3UL;
   tf->codes[21238] = 0x0000d2c3d3ae1659UL;
   tf->codes[21239] = 0x0000d67f10bc33e9UL;
   tf->codes[21240] = 0x0000ee069a80acfaUL;
   tf->codes[21241] = 0x0000ee879d9962feUL;
   tf->codes[21242] = 0x0000eebcaf369d86UL;
   tf->codes[21243] = 0x0000f12e87c446f6UL;
   tf->codes[21244] = 0x0000f369b4cb8d7bUL;
   tf->codes[21245] = 0x0000f6cb0c49cf9eUL;
   tf->codes[21246] = 0x0000f913f2d6704fUL;
   tf->codes[21247] = 0x0000faba70b910a2UL;
   tf->codes[21248] = 0x0000fe539888d289UL;
   tf->codes[21249] = 0x000000994b432274UL;
   tf->codes[21250] = 0x000009069630aee7UL;
   tf->codes[21251] = 0x000011e04deeea1cUL;
   tf->codes[21252] = 0x000019359d08e0a7UL;
   tf->codes[21253] = 0x00001d219316cb20UL;
   tf->codes[21254] = 0x00001ff518331427UL;
   tf->codes[21255] = 0x00002348067eeacfUL;
   tf->codes[21256] = 0x00002be93e3e94f1UL;
   tf->codes[21257] = 0x00002d49f7bb558fUL;
   tf->codes[21258] = 0x00002f6050cffb2fUL;
   tf->codes[21259] = 0x00003b74b7a1a97aUL;
   tf->codes[21260] = 0x00003cf7865cc5c1UL;
   tf->codes[21261] = 0x00003d704d58ac11UL;
   tf->codes[21262] = 0x0000472aa5b708f4UL;
   tf->codes[21263] = 0x000048d073ec97f8UL;
   tf->codes[21264] = 0x00004a8102643627UL;
   tf->codes[21265] = 0x000051b476ced6ceUL;
   tf->codes[21266] = 0x00005a6208b9b87eUL;
   tf->codes[21267] = 0x00005b6b9b5ae2ebUL;
   tf->codes[21268] = 0x00005b757160db02UL;
   tf->codes[21269] = 0x00005bc6a5b5db31UL;
   tf->codes[21270] = 0x00005d56f3674bdfUL;
   tf->codes[21271] = 0x00005f2921ff3a2dUL;
   tf->codes[21272] = 0x00005f54230776d9UL;
   tf->codes[21273] = 0x0000648315f133e6UL;
   tf->codes[21274] = 0x0000648e4b514e9bUL;
   tf->codes[21275] = 0x0000686326f1f25bUL;
   tf->codes[21276] = 0x00006cc7a96cbd5fUL;
   tf->codes[21277] = 0x00006fabe151ab93UL;
   tf->codes[21278] = 0x0000700bb9681d02UL;
   tf->codes[21279] = 0x00007287a28ac44eUL;
   tf->codes[21280] = 0x0000888cd2b22ca2UL;
   tf->codes[21281] = 0x00008e5b6f91a4d1UL;
   tf->codes[21282] = 0x000090623aa8c21dUL;
   tf->codes[21283] = 0x0000914649aa3a56UL;
   tf->codes[21284] = 0x000091a0dee72712UL;
   tf->codes[21285] = 0x000096bf1f083ef2UL;
   tf->codes[21286] = 0x000096f9e89d09b7UL;
   tf->codes[21287] = 0x0000af369cdb5c40UL;
   tf->codes[21288] = 0x0000b1811d512554UL;
   tf->codes[21289] = 0x0000b21382df91d4UL;
   tf->codes[21290] = 0x0000b8df92c402a7UL;
   tf->codes[21291] = 0x0000b8e1a1cb3694UL;
   tf->codes[21292] = 0x0000b9de65231de9UL;
   tf->codes[21293] = 0x0000bd026ee755d0UL;
   tf->codes[21294] = 0x0000bd4783a02436UL;
   tf->codes[21295] = 0x0000c8642f646a1aUL;
   tf->codes[21296] = 0x0000cd8234f67c35UL;
   tf->codes[21297] = 0x0000d33bc66fe198UL;
   tf->codes[21298] = 0x0000d5b09840d609UL;
   tf->codes[21299] = 0x0000d5b9497bb147UL;
   tf->codes[21300] = 0x0000e14177d48ed9UL;
   tf->codes[21301] = 0x0000ea1452d01cf8UL;
   tf->codes[21302] = 0x0000ed2c02691d51UL;
   tf->codes[21303] = 0x0000ef910bad83a9UL;
   tf->codes[21304] = 0x0000f330d5b0ece1UL;
   tf->codes[21305] = 0x0000fc180c657c7dUL;
   tf->codes[21306] = 0x000008585e7b7e88UL;
   tf->codes[21307] = 0x000008c8aecb8f5fUL;
   tf->codes[21308] = 0x00001a0fb1775707UL;
   tf->codes[21309] = 0x00001e88ca3a294dUL;
   tf->codes[21310] = 0x0000288c555fbc70UL;
   tf->codes[21311] = 0x00002b442ce24b5aUL;
   tf->codes[21312] = 0x00002f3feb7cc3ecUL;
   tf->codes[21313] = 0x0000357fc2e86406UL;
   tf->codes[21314] = 0x00003b96a852fb61UL;
   tf->codes[21315] = 0x00004099ea876a73UL;
   tf->codes[21316] = 0x000043ba10cc4045UL;
   tf->codes[21317] = 0x000045d2ee06255cUL;
   tf->codes[21318] = 0x000048274481e687UL;
   tf->codes[21319] = 0x000048d9b0477ac3UL;
   tf->codes[21320] = 0x0000493b9765201fUL;
   tf->codes[21321] = 0x00004a6e56965910UL;
   tf->codes[21322] = 0x00004af80ae9ea52UL;
   tf->codes[21323] = 0x00004b4a640a075aUL;
   tf->codes[21324] = 0x00004f55eb310e05UL;
   tf->codes[21325] = 0x00005251ed305441UL;
   tf->codes[21326] = 0x00005407be817723UL;
   tf->codes[21327] = 0x00005b6006deb8afUL;
   tf->codes[21328] = 0x00005b75c1f1dccaUL;
   tf->codes[21329] = 0x00005dc809666a08UL;
   tf->codes[21330] = 0x00005de58b78524dUL;
   tf->codes[21331] = 0x000060416e63d1ddUL;
   tf->codes[21332] = 0x00006b197a8d54e5UL;
   tf->codes[21333] = 0x00006bf07fb68441UL;
   tf->codes[21334] = 0x00006ccc180c2701UL;
   tf->codes[21335] = 0x00007216b88f9e2bUL;
   tf->codes[21336] = 0x00007d6d091d91fbUL;
   tf->codes[21337] = 0x00007df6f8002902UL;
   tf->codes[21338] = 0x000080d32e574d47UL;
   tf->codes[21339] = 0x00008642a2cd6556UL;
   tf->codes[21340] = 0x0000873346891ae2UL;
   tf->codes[21341] = 0x0000897a1e0e87a6UL;
   tf->codes[21342] = 0x00008fcddc151db3UL;
   tf->codes[21343] = 0x00009d0a41d5f5c4UL;
   tf->codes[21344] = 0x00009e536bc7641fUL;
   tf->codes[21345] = 0x0000a1e92535cf7bUL;
   tf->codes[21346] = 0x0000a1ed43443755UL;
   tf->codes[21347] = 0x0000a2f5eba94aaeUL;
   tf->codes[21348] = 0x0000a982d95b831dUL;
   tf->codes[21349] = 0x0000a9bd2dd24258UL;
   tf->codes[21350] = 0x0000a9cbd193b398UL;
   tf->codes[21351] = 0x0000b562de3d082fUL;
   tf->codes[21352] = 0x0000be10e545f569UL;
   tf->codes[21353] = 0x0000c5cc398bf92aUL;
   tf->codes[21354] = 0x0000e49c432125aeUL;
   tf->codes[21355] = 0x0000e5266c92c27aUL;
   tf->codes[21356] = 0x0000e90b10bff453UL;
   tf->codes[21357] = 0x0000eb23b36ad3a5UL;
   tf->codes[21358] = 0x0000eba05de61c0aUL;
   tf->codes[21359] = 0x0000ed4123d12c20UL;
   tf->codes[21360] = 0x0000f2e86898c3f3UL;
   tf->codes[21361] = 0x0000f67620796560UL;
   tf->codes[21362] = 0x00000245ad214b0aUL;
   tf->codes[21363] = 0x000002b46388337eUL;
   tf->codes[21364] = 0x000003dac88e34e1UL;
   tf->codes[21365] = 0x00000586894a59e7UL;
   tf->codes[21366] = 0x00000a73262f8dcaUL;
   tf->codes[21367] = 0x00000f971e4835e7UL;
   tf->codes[21368] = 0x0000100f702610adUL;
   tf->codes[21369] = 0x000011898da651b6UL;
   tf->codes[21370] = 0x000014d73918a3abUL;
   tf->codes[21371] = 0x00001aa2a225cb14UL;
   tf->codes[21372] = 0x00001ba25ec0fd6aUL;
   tf->codes[21373] = 0x00001caeeaa572d8UL;
   tf->codes[21374] = 0x0000203466694491UL;
   tf->codes[21375] = 0x000020c8a06fdf39UL;
   tf->codes[21376] = 0x000022c43626e1d0UL;
   tf->codes[21377] = 0x00002459c6b1d731UL;
   tf->codes[21378] = 0x000025317b8817dcUL;
   tf->codes[21379] = 0x00002e46ac882f25UL;
   tf->codes[21380] = 0x00003dc8c5035721UL;
   tf->codes[21381] = 0x0000458ba5b91947UL;
   tf->codes[21382] = 0x000046573af32829UL;
   tf->codes[21383] = 0x00004b12e449895eUL;
   tf->codes[21384] = 0x00004b353416eaccUL;
   tf->codes[21385] = 0x00004ba3755fc7b6UL;
   tf->codes[21386] = 0x00004c2bca59365aUL;
   tf->codes[21387] = 0x00004eb7417965faUL;
   tf->codes[21388] = 0x00005180f08fb6eaUL;
   tf->codes[21389] = 0x000051d6f2a03042UL;
   tf->codes[21390] = 0x0000521565255757UL;
   tf->codes[21391] = 0x00005b2812002f29UL;
   tf->codes[21392] = 0x00005c734af8d171UL;
   tf->codes[21393] = 0x0000645079ee2b16UL;
   tf->codes[21394] = 0x0000663a38116ba7UL;
   tf->codes[21395] = 0x00006e94fbbe24c5UL;
   tf->codes[21396] = 0x000077a6493ed9f9UL;
   tf->codes[21397] = 0x000077de199059bdUL;
   tf->codes[21398] = 0x00007d9b196b15abUL;
   tf->codes[21399] = 0x00007f10a3bee350UL;
   tf->codes[21400] = 0x00008010605a15a6UL;
   tf->codes[21401] = 0x0000909e8f9ba786UL;
   tf->codes[21402] = 0x000097b5a6bf7cc1UL;
   tf->codes[21403] = 0x0000981fc9f9f1d1UL;
   tf->codes[21404] = 0x00009ffd337e513bUL;
   tf->codes[21405] = 0x0000a250da4d0117UL;
   tf->codes[21406] = 0x0000a91fe374bcebUL;
   tf->codes[21407] = 0x0000b69c55a3e474UL;
   tf->codes[21408] = 0x0000b81bf08caff5UL;
   tf->codes[21409] = 0x0000c25ed8738141UL;
   tf->codes[21410] = 0x0000c3117ec81b42UL;
   tf->codes[21411] = 0x0000c576c29b875fUL;
   tf->codes[21412] = 0x0000ccd488615363UL;
   tf->codes[21413] = 0x0000ce3f17e40c18UL;
   tf->codes[21414] = 0x0000dbdb1b2c4fd3UL;
   tf->codes[21415] = 0x0000dc23d8d57a89UL;
   tf->codes[21416] = 0x0000ddc931ecfe03UL;
   tf->codes[21417] = 0x0000e374cf520375UL;
   tf->codes[21418] = 0x0000e551839cfb29UL;
   tf->codes[21419] = 0x0000eb9af67f8d95UL;
   tf->codes[21420] = 0x0000ee05429d78a0UL;
   tf->codes[21421] = 0x0000ee10b28c991aUL;
   tf->codes[21422] = 0x0000f032067253aaUL;
   tf->codes[21423] = 0x0000f4db6316e74fUL;
   tf->codes[21424] = 0x0000f5f2e9cc71adUL;
   tf->codes[21425] = 0x0000f7156b5310fbUL;
   tf->codes[21426] = 0x000006782d44228aUL;
   tf->codes[21427] = 0x0000155b8605a678UL;
   tf->codes[21428] = 0x000016f0dc019614UL;
   tf->codes[21429] = 0x00001f1f79daf5adUL;
   tf->codes[21430] = 0x000025de455817deUL;
   tf->codes[21431] = 0x00002a366da7ab54UL;
   tf->codes[21432] = 0x0000390913a08a15UL;
   tf->codes[21433] = 0x000047c1e077dce1UL;
   tf->codes[21434] = 0x000055ebf0b11f7dUL;
   tf->codes[21435] = 0x00005ba3e8415c7dUL;
   tf->codes[21436] = 0x00005fdaaaffa599UL;
   tf->codes[21437] = 0x00006317de385826UL;
   tf->codes[21438] = 0x00006344040bb1abUL;
   tf->codes[21439] = 0x000069fcdd023ddaUL;
   tf->codes[21440] = 0x00006d9c31e79b88UL;
   tf->codes[21441] = 0x00008146a3eea125UL;
   tf->codes[21442] = 0x000083482c2c39beUL;
   tf->codes[21443] = 0x0000837158bc4842UL;
   tf->codes[21444] = 0x00008e7674f53be3UL;
   tf->codes[21445] = 0x00008f28a62bca5aUL;
   tf->codes[21446] = 0x00008f70eeb6e986UL;
   tf->codes[21447] = 0x00009009bbe9f792UL;
   tf->codes[21448] = 0x000090fb0f52be6dUL;
   tf->codes[21449] = 0x000098a27cfdcc3bUL;
   tf->codes[21450] = 0x000098b78863df07UL;
   tf->codes[21451] = 0x00009ded929f4eefUL;
   tf->codes[21452] = 0x00009e56cb9dacebUL;
   tf->codes[21453] = 0x0000a009a3ab84ccUL;
   tf->codes[21454] = 0x0000a0f41a519e91UL;
   tf->codes[21455] = 0x0000a59e6132494aUL;
   tf->codes[21456] = 0x0000a6146979ea5eUL;
   tf->codes[21457] = 0x0000b3fdf826d1f8UL;
   tf->codes[21458] = 0x0000b4c200f12275UL;
   tf->codes[21459] = 0x0000bc4cd6c65f12UL;
   tf->codes[21460] = 0x0000be46d2943946UL;
   tf->codes[21461] = 0x0000c231de660cabUL;
   tf->codes[21462] = 0x0000c570ab87e79bUL;
   tf->codes[21463] = 0x0000c873152bcf63UL;
   tf->codes[21464] = 0x0000cb7c5b926441UL;
   tf->codes[21465] = 0x0000cdc99abc7291UL;
   tf->codes[21466] = 0x0000cf2252ab6940UL;
   tf->codes[21467] = 0x0000d17eaab4f45aUL;
   tf->codes[21468] = 0x0000d2c9e3ad96a2UL;
   tf->codes[21469] = 0x0000d33c4304db66UL;
   tf->codes[21470] = 0x0000d7afa3d01d6fUL;
   tf->codes[21471] = 0x0000d7d90aef31b8UL;
   tf->codes[21472] = 0x0000dd15b75e48f1UL;
   tf->codes[21473] = 0x0000df6331175d06UL;
   tf->codes[21474] = 0x0000e845d49f793eUL;
   tf->codes[21475] = 0x0000e88cf85f7b91UL;
   tf->codes[21476] = 0x0000ecd51d937b29UL;
   tf->codes[21477] = 0x0000edee78c133afUL;
   tf->codes[21478] = 0x0000ee081753b9dfUL;
   tf->codes[21479] = 0x0000f053f723a591UL;
   tf->codes[21480] = 0x0000f1224b11f9afUL;
   tf->codes[21481] = 0x0000f2d4ae01c606UL;
   tf->codes[21482] = 0x0000feb7ac269619UL;
   tf->codes[21483] = 0x0000fee61b902950UL;
   tf->codes[21484] = 0x0000019f8cfbe09dUL;
   tf->codes[21485] = 0x0000092017ad1999UL;
   tf->codes[21486] = 0x000009d7169f2139UL;
   tf->codes[21487] = 0x00000b84e6627a2cUL;
   tf->codes[21488] = 0x0000122ea6798991UL;
   tf->codes[21489] = 0x00001a68b44209a4UL;
   tf->codes[21490] = 0x00001c7412859a54UL;
   tf->codes[21491] = 0x000021ec72c59366UL;
   tf->codes[21492] = 0x00002a3b51652080UL;
   tf->codes[21493] = 0x0000344927aeb744UL;
   tf->codes[21494] = 0x000048b8c74b2a37UL;
   tf->codes[21495] = 0x0000498755c8841aUL;
   tf->codes[21496] = 0x00004ca56d0625ffUL;
   tf->codes[21497] = 0x0000506a801a3ba6UL;
   tf->codes[21498] = 0x0000576e25c12678UL;
   tf->codes[21499] = 0x000059d20a3a6ff7UL;
   tf->codes[21500] = 0x00005cf26b0e4b8eUL;
   tf->codes[21501] = 0x00005d3118227868UL;
   tf->codes[21502] = 0x000061e15189b923UL;
   tf->codes[21503] = 0x0000681125d9c55fUL;
   tf->codes[21504] = 0x000074a271b5c1d4UL;
   tf->codes[21505] = 0x000076a01673f858UL;
   tf->codes[21506] = 0x000079b4923aa7ebUL;
   tf->codes[21507] = 0x000079ccd1730b7dUL;
   tf->codes[21508] = 0x00007bdbd8a6f87dUL;
   tf->codes[21509] = 0x000081000b4ea65fUL;
   tf->codes[21510] = 0x000085402ef4dc08UL;
   tf->codes[21511] = 0x00008a145212a694UL;
   tf->codes[21512] = 0x00009267143195c3UL;
   tf->codes[21513] = 0x000097763b7330d9UL;
   tf->codes[21514] = 0x0000989673639675UL;
   tf->codes[21515] = 0x0000a66d05b19f30UL;
   tf->codes[21516] = 0x0000ae46512796c0UL;
   tf->codes[21517] = 0x0000aee376f8126bUL;
   tf->codes[21518] = 0x0000b0dfbc5c2651UL;
   tf->codes[21519] = 0x0000b301fa7df7f5UL;
   tf->codes[21520] = 0x0000b3de4280ac04UL;
   tf->codes[21521] = 0x0000b9ddd2eef6e1UL;
   tf->codes[21522] = 0x0000bbc631b814d4UL;
   tf->codes[21523] = 0x0000c2891b439edfUL;
   tf->codes[21524] = 0x0000c39cf908ccedUL;
   tf->codes[21525] = 0x0000c760acc2bff6UL;
   tf->codes[21526] = 0x0000ca7e1453508cUL;
   tf->codes[21527] = 0x0000cdb1e6a4168cUL;
   tf->codes[21528] = 0x0000d1f6d805c55eUL;
   tf->codes[21529] = 0x0000d45af70e14a2UL;
   tf->codes[21530] = 0x0000d56782f28a10UL;
   tf->codes[21531] = 0x0000e235a76a8537UL;
   tf->codes[21532] = 0x0000e83b2a5f6616UL;
   tf->codes[21533] = 0x0000edb2daf24dd9UL;
   tf->codes[21534] = 0x0000f549d063bc3fUL;
   tf->codes[21535] = 0x0000027e3496ca61UL;
   tf->codes[21536] = 0x0000139f03f5ce86UL;
   tf->codes[21537] = 0x000017957fb6c265UL;
   tf->codes[21538] = 0x00001919adcc014aUL;
   tf->codes[21539] = 0x00001a517547b929UL;
   tf->codes[21540] = 0x00001b50bcc4dff5UL;
   tf->codes[21541] = 0x00001b77da4dba8cUL;
   tf->codes[21542] = 0x000020a82c919a37UL;
   tf->codes[21543] = 0x000034d3a1b155d8UL;
   tf->codes[21544] = 0x00004feffaa82331UL;
   tf->codes[21545] = 0x000053240787eef6UL;
   tf->codes[21546] = 0x00005dd321b0693fUL;
   tf->codes[21547] = 0x000067c8b8c19c71UL;
   tf->codes[21548] = 0x000070c98e08b23dUL;
   tf->codes[21549] = 0x00007153f20954ceUL;
   tf->codes[21550] = 0x0000717223c84e62UL;
   tf->codes[21551] = 0x00007726acf734d7UL;
   tf->codes[21552] = 0x00007c2730775eadUL;
   tf->codes[21553] = 0x000086bb874235edUL;
   tf->codes[21554] = 0x00008a581d734e5fUL;
   tf->codes[21555] = 0x00008e0650a92312UL;
   tf->codes[21556] = 0x00008f6a03692eb1UL;
   tf->codes[21557] = 0x000090c7c3a2a44eUL;
   tf->codes[21558] = 0x0000938ca4fd7c15UL;
   tf->codes[21559] = 0x0000958282bcee6fUL;
   tf->codes[21560] = 0x00009adcebccf3b2UL;
   tf->codes[21561] = 0x00009c76d4f556b2UL;
   tf->codes[21562] = 0x00009dc78b568372UL;
   tf->codes[21563] = 0x0000a1e7a8c5915fUL;
   tf->codes[21564] = 0x0000a2294f1d093aUL;
   tf->codes[21565] = 0x0000a6ede43d4b72UL;
   tf->codes[21566] = 0x0000aa41bcc5392eUL;
   tf->codes[21567] = 0x0000ab7148242159UL;
   tf->codes[21568] = 0x0000ae52c154ca51UL;
   tf->codes[21569] = 0x0000af7d09da2dc9UL;
   tf->codes[21570] = 0x0000afd6b4db0371UL;
   tf->codes[21571] = 0x0000b1360efda171UL;
   tf->codes[21572] = 0x0000b269f2f9f73bUL;
   tf->codes[21573] = 0x0000b2d366875afcUL;
   tf->codes[21574] = 0x0000b524fe4ed6ebUL;
   tf->codes[21575] = 0x0000b7fe75f1b5f4UL;
   tf->codes[21576] = 0x0000ba7347c2aa65UL;
   tf->codes[21577] = 0x0000bbdb18911ddeUL;
   tf->codes[21578] = 0x0000cd96147d52adUL;
   tf->codes[21579] = 0x0000ce433d696236UL;
   tf->codes[21580] = 0x0000d582d17034a6UL;
   tf->codes[21581] = 0x0000d9bffbd31f4eUL;
   tf->codes[21582] = 0x0000db2d0f7b177aUL;
   tf->codes[21583] = 0x0000dd4af4ff7b7fUL;
   tf->codes[21584] = 0x0000df77f3635c4eUL;
   tf->codes[21585] = 0x0000ea2d00126c99UL;
   tf->codes[21586] = 0x0000eb45e6221995UL;
   tf->codes[21587] = 0x0000f07a1be55b55UL;
   tf->codes[21588] = 0x0000f1b93541cbd4UL;
   tf->codes[21589] = 0x0000f2123095902dUL;
   tf->codes[21590] = 0x0000f5a10d414e73UL;
   tf->codes[21591] = 0x0000fd0e26759d06UL;
   tf->codes[21592] = 0x0000fff88b702701UL;
   tf->codes[21593] = 0x0000022c6696b4e6UL;
   tf->codes[21594] = 0x000007de6ba05be4UL;
   tf->codes[21595] = 0x00000d59c5239ff7UL;
   tf->codes[21596] = 0x000011cd9b0ced8aUL;
   tf->codes[21597] = 0x000016221a6c24b0UL;
   tf->codes[21598] = 0x000016f033cb7309UL;
   tf->codes[21599] = 0x00001991db1cd24eUL;
   tf->codes[21600] = 0x00001abf92038c51UL;
   tf->codes[21601] = 0x000028b5b56ab13eUL;
   tf->codes[21602] = 0x0000294596d3de47UL;
   tf->codes[21603] = 0x00002da16813ce0dUL;
   tf->codes[21604] = 0x0000358364c4a0dbUL;
   tf->codes[21605] = 0x000036d8ae5240ffUL;
   tf->codes[21606] = 0x000039c2d8bdc535UL;
   tf->codes[21607] = 0x00003b31864ee5c4UL;
   tf->codes[21608] = 0x00003f31d815d1baUL;
   tf->codes[21609] = 0x000041a8b8edfa18UL;
   tf->codes[21610] = 0x00004935d8597067UL;
   tf->codes[21611] = 0x00004aa3d63d7fa7UL;
   tf->codes[21612] = 0x00004ab747ba6a10UL;
   tf->codes[21613] = 0x00004f0649b116beUL;
   tf->codes[21614] = 0x000052b31d8cc8d3UL;
   tf->codes[21615] = 0x000067d020a45114UL;
   tf->codes[21616] = 0x000068f7355763c6UL;
   tf->codes[21617] = 0x00006bdc1ce96349UL;
   tf->codes[21618] = 0x0000748ad39f61d2UL;
   tf->codes[21619] = 0x000074dd2cbf7edaUL;
   tf->codes[21620] = 0x0000767f8c93b753UL;
   tf->codes[21621] = 0x00007b83f393433eUL;
   tf->codes[21622] = 0x0000803ca3a65972UL;
   tf->codes[21623] = 0x000083ba92fa6cc6UL;
   tf->codes[21624] = 0x000083bb7d3683daUL;
   tf->codes[21625] = 0x000087099dc6e159UL;
   tf->codes[21626] = 0x00008908675034b6UL;
   tf->codes[21627] = 0x000089c9ebf545bcUL;
   tf->codes[21628] = 0x0000905c919f0e68UL;
   tf->codes[21629] = 0x0000938c80707253UL;
   tf->codes[21630] = 0x00009569a9d97591UL;
   tf->codes[21631] = 0x0000957f64ec99acUL;
   tf->codes[21632] = 0x0000986d38487a32UL;
   tf->codes[21633] = 0x0000a7ed41bc6e41UL;
   tf->codes[21634] = 0x0000b1d3fa7d2a6eUL;
   tf->codes[21635] = 0x0000b423bdcc7835UL;
   tf->codes[21636] = 0x0000b9f2cfc9fbeeUL;
   tf->codes[21637] = 0x0000bae289499a66UL;
   tf->codes[21638] = 0x0000bc03e6051cdbUL;
   tf->codes[21639] = 0x0000bcd7b75bfb71UL;
   tf->codes[21640] = 0x0000c0da182a1b54UL;
   tf->codes[21641] = 0x0000d1380389ebd5UL;
   tf->codes[21642] = 0x0000d2f108ad5f7dUL;
   tf->codes[21643] = 0x0000d32236cb37f0UL;
   tf->codes[21644] = 0x0000df5a4cc46a47UL;
   tf->codes[21645] = 0x0000e025e1fe7929UL;
   tf->codes[21646] = 0x0000e3b693226597UL;
   tf->codes[21647] = 0x0000eb08ae6a0b5cUL;
   tf->codes[21648] = 0x0000edbcdcfc3df6UL;
   tf->codes[21649] = 0x0000f0c69880de5eUL;
   tf->codes[21650] = 0x0000f8922a717bc2UL;
   tf->codes[21651] = 0x0000fc96d4d5d557UL;
   tf->codes[21652] = 0x00000516e1933ae4UL;
   tf->codes[21653] = 0x000006d8d2808f8fUL;
   tf->codes[21654] = 0x000015f9b38b237eUL;
   tf->codes[21655] = 0x000018e74c57fe3fUL;
   tf->codes[21656] = 0x000023b0ef4f15ccUL;
   tf->codes[21657] = 0x000028d3880d9b4bUL;
   tf->codes[21658] = 0x0000345acc2a61c9UL;
   tf->codes[21659] = 0x000037d6e70646f5UL;
   tf->codes[21660] = 0x00003b2f182ba250UL;
   tf->codes[21661] = 0x00004ccc5776e915UL;
   tf->codes[21662] = 0x00004d89be0d9241UL;
   tf->codes[21663] = 0x000052d2ff36e6cdUL;
   tf->codes[21664] = 0x0000537bcf8588b7UL;
   tf->codes[21665] = 0x00005dec020ad061UL;
   tf->codes[21666] = 0x000072b28df3d3c0UL;
   tf->codes[21667] = 0x00007a8a04f19d28UL;
   tf->codes[21668] = 0x00007c0f1d42f321UL;
   tf->codes[21669] = 0x00007f39541cc6cfUL;
   tf->codes[21670] = 0x00008beb1b4df68aUL;
   tf->codes[21671] = 0x00008c11fe47cb5cUL;
   tf->codes[21672] = 0x00008f0e75651d22UL;
   tf->codes[21673] = 0x0000921f0dac6aa0UL;
   tf->codes[21674] = 0x000093eca917e58aUL;
   tf->codes[21675] = 0x000095694abd660aUL;
   tf->codes[21676] = 0x000098d68748d431UL;
   tf->codes[21677] = 0x00009d8aa42f7701UL;
   tf->codes[21678] = 0x00009fb1b00cc1ceUL;
   tf->codes[21679] = 0x0000a28ed09ffd27UL;
   tf->codes[21680] = 0x0000a3e15b79580fUL;
   tf->codes[21681] = 0x0000a49944a776c3UL;
   tf->codes[21682] = 0x0000a8e8bbbc2efbUL;
   tf->codes[21683] = 0x0000ac2922c7324eUL;
   tf->codes[21684] = 0x0000afdc98d68bb4UL;
   tf->codes[21685] = 0x0000ba2329adb950UL;
   tf->codes[21686] = 0x0000c1de7df3bd11UL;
   tf->codes[21687] = 0x0000c2e7d605e1b9UL;
   tf->codes[21688] = 0x0000d57cd05e90e5UL;
   tf->codes[21689] = 0x0000d5e902a039e2UL;
   tf->codes[21690] = 0x0000ddef5e25a20bUL;
   tf->codes[21691] = 0x0000e6279775f3f6UL;
   tf->codes[21692] = 0x0000e8220861d9b4UL;
   tf->codes[21693] = 0x0000f159fe4d5df5UL;
   tf->codes[21694] = 0x0000f6182bc8fea1UL;
   tf->codes[21695] = 0x0000fe8994c4f2eeUL;
   tf->codes[21696] = 0x000006ddb63e04bbUL;
   tf->codes[21697] = 0x000009a9745b8998UL;
   tf->codes[21698] = 0x00000cb15b67fbd8UL;
   tf->codes[21699] = 0x0000125b9972deacUL;
   tf->codes[21700] = 0x000015d89e8adaecUL;
   tf->codes[21701] = 0x00001b5c6eb9f478UL;
   tf->codes[21702] = 0x00001f0524873eb3UL;
   tf->codes[21703] = 0x000020f54a4f20d0UL;
   tf->codes[21704] = 0x000024c558344b67UL;
   tf->codes[21705] = 0x0000274faa895e2eUL;
   tf->codes[21706] = 0x00002d77f269ac05UL;
   tf->codes[21707] = 0x0000327b349e1b17UL;
   tf->codes[21708] = 0x000038d2d6241339UL;
   tf->codes[21709] = 0x00003dcae2f86796UL;
   tf->codes[21710] = 0x0000459cdc8da686UL;
   tf->codes[21711] = 0x000046cb08926c13UL;
   tf->codes[21712] = 0x00004ad94e6db7faUL;
   tf->codes[21713] = 0x00004e568e14b9ffUL;
   tf->codes[21714] = 0x00004fe0aeb08ee6UL;
   tf->codes[21715] = 0x0000568825316499UL;
   tf->codes[21716] = 0x0000588d90ee5f47UL;
   tf->codes[21717] = 0x00005b83a0670f81UL;
   tf->codes[21718] = 0x000063fe2fbbea96UL;
   tf->codes[21719] = 0x00006fac91618babUL;
   tf->codes[21720] = 0x00007ddea3289836UL;
   tf->codes[21721] = 0x00007e697c474651UL;
   tf->codes[21722] = 0x00008b8ae41b7594UL;
   tf->codes[21723] = 0x00008dcb196d3b07UL;
   tf->codes[21724] = 0x0000940f497648c0UL;
   tf->codes[21725] = 0x000095d851b55046UL;
   tf->codes[21726] = 0x00009bcbc287695aUL;
   tf->codes[21727] = 0x0000ac1a1fe9b187UL;
   tf->codes[21728] = 0x0000b0eb845336d7UL;
   tf->codes[21729] = 0x0000b3cf471a1981UL;
   tf->codes[21730] = 0x0000b6a96e6a09d9UL;
   tf->codes[21731] = 0x0000c6ae5e761601UL;
   tf->codes[21732] = 0x0000ce817cd671caUL;
   tf->codes[21733] = 0x0000d0e0ce2347e5UL;
   tf->codes[21734] = 0x0000d12f7e53089dUL;
   tf->codes[21735] = 0x0000d3bc8f5c60a0UL;
   tf->codes[21736] = 0x0000d45437c451d3UL;
   tf->codes[21737] = 0x0000daac4e68557fUL;
   tf->codes[21738] = 0x0000dfdca0ac352aUL;
   tf->codes[21739] = 0x0000e75f74f3a7d8UL;
   tf->codes[21740] = 0x0000ec941fd4f522UL;
   tf->codes[21741] = 0x0000f17bb46faa17UL;
   tf->codes[21742] = 0x0000fa390ee719e0UL;
   tf->codes[21743] = 0x0000fc94b74393abUL;
   tf->codes[21744] = 0x0000fca56a0c38d8UL;
   tf->codes[21745] = 0x0000ffa6aee503c7UL;
   tf->codes[21746] = 0x0000013e4e772d15UL;
   tf->codes[21747] = 0x0000032672b14543UL;
   tf->codes[21748] = 0x00000aa2a4c510a0UL;
   tf->codes[21749] = 0x00000ebf8e61cdc7UL;
   tf->codes[21750] = 0x00001d86c46b8c0eUL;
   tf->codes[21751] = 0x0000271272d14ff5UL;
   tf->codes[21752] = 0x0000415333727a8eUL;
   tf->codes[21753] = 0x00004431b35fd885UL;
   tf->codes[21754] = 0x00004d637c35c0ffUL;
   tf->codes[21755] = 0x0000503701520a06UL;
   tf->codes[21756] = 0x000060734c918a68UL;
   tf->codes[21757] = 0x000062c225a4c11bUL;
   tf->codes[21758] = 0x0000658064cbf191UL;
   tf->codes[21759] = 0x0000688602422a1fUL;
   tf->codes[21760] = 0x0000691c4b4ff8b4UL;
   tf->codes[21761] = 0x000069ecae4580bfUL;
   tf->codes[21762] = 0x00006a495289a168UL;
   tf->codes[21763] = 0x00007106498e9571UL;
   tf->codes[21764] = 0x0000780c38cbb9f5UL;
   tf->codes[21765] = 0x00007ef6ef8d2fe6UL;
   tf->codes[21766] = 0x00007f69c4028034UL;
   tf->codes[21767] = 0x00008187e415e9feUL;
   tf->codes[21768] = 0x000083ae7ad52941UL;
   tf->codes[21769] = 0x00008513526051b9UL;
   tf->codes[21770] = 0x000089ccb220793cUL;
   tf->codes[21771] = 0x00008d42da75c866UL;
   tf->codes[21772] = 0x000092bee3a61dc8UL;
   tf->codes[21773] = 0x0000988927e82858UL;
   tf->codes[21774] = 0x00009ee34d935ff1UL;
   tf->codes[21775] = 0x00009fc5c2abafc7UL;
   tf->codes[21776] = 0x0000aeca80fe7e0fUL;
   tf->codes[21777] = 0x0000af85d88df34eUL;
   tf->codes[21778] = 0x0000b0872f124e07UL;
   tf->codes[21779] = 0x0000b6c029bb410bUL;
   tf->codes[21780] = 0x0000b70ccae3cdd6UL;
   tf->codes[21781] = 0x0000b7516a7e90b2UL;
   tf->codes[21782] = 0x0000b7575d0526b4UL;
   tf->codes[21783] = 0x0000bc8565b2ccadUL;
   tf->codes[21784] = 0x0000bdbe8c88a72aUL;
   tf->codes[21785] = 0x0000ce1909872120UL;
   tf->codes[21786] = 0x0000cfbc19086ae8UL;
   tf->codes[21787] = 0x0000e4a5a46be104UL;
   tf->codes[21788] = 0x0000e8415060e262UL;
   tf->codes[21789] = 0x0000ea2c334f3fccUL;
   tf->codes[21790] = 0x0000f18a6e33175aUL;
   tf->codes[21791] = 0x0000f1daf2db063aUL;
   tf->codes[21792] = 0x0000f92ea80bd462UL;
   tf->codes[21793] = 0x00001175e1fd3051UL;
   tf->codes[21794] = 0x000016d4a3aaa333UL;
   tf->codes[21795] = 0x0000182310759641UL;
   tf->codes[21796] = 0x000018b7850b36aeUL;
   tf->codes[21797] = 0x00001ab43f8d561eUL;
   tf->codes[21798] = 0x0000224074bcb559UL;
   tf->codes[21799] = 0x0000230d2ec1e114UL;
   tf->codes[21800] = 0x000032b2f6648d1cUL;
   tf->codes[21801] = 0x000039459c0e55c8UL;
   tf->codes[21802] = 0x00004118ba6eb191UL;
   tf->codes[21803] = 0x00004931d7c3f2d4UL;
   tf->codes[21804] = 0x000049e89c26f4afUL;
   tf->codes[21805] = 0x00005098c3e2a5a0UL;
   tf->codes[21806] = 0x00005605eec283fdUL;
   tf->codes[21807] = 0x00005676eebfa623UL;
   tf->codes[21808] = 0x000057c88f5ce9f7UL;
   tf->codes[21809] = 0x00005cf6d29995b5UL;
   tf->codes[21810] = 0x00005f1617781c58UL;
   tf->codes[21811] = 0x000061bfc057458cUL;
   tf->codes[21812] = 0x000064445ab4c816UL;
   tf->codes[21813] = 0x000067afc2c80815UL;
   tf->codes[21814] = 0x000069917f5d7eb7UL;
   tf->codes[21815] = 0x0000740f6b68208dUL;
   tf->codes[21816] = 0x000077a0cc391e4aUL;
   tf->codes[21817] = 0x0000797d45f51039UL;
   tf->codes[21818] = 0x00007f07f2e6d6dbUL;
   tf->codes[21819] = 0x000087b584d1b88bUL;
   tf->codes[21820] = 0x00008ec793ab0ed8UL;
   tf->codes[21821] = 0x00008f4aa5caf8c9UL;
   tf->codes[21822] = 0x00008f986bbea26dUL;
   tf->codes[21823] = 0x000092412a61b48dUL;
   tf->codes[21824] = 0x00009d538b01f6d0UL;
   tf->codes[21825] = 0x0000a1cd5371da65UL;
   tf->codes[21826] = 0x0000a49bd043a47eUL;
   tf->codes[21827] = 0x0000a5c7ed41361eUL;
   tf->codes[21828] = 0x0000a82619c2ef60UL;
   tf->codes[21829] = 0x0000a86ffc3736efUL;
   tf->codes[21830] = 0x0000aa22d4450ed0UL;
   tf->codes[21831] = 0x0000ad66a9b168aeUL;
   tf->codes[21832] = 0x0000b8da7c5144c3UL;
   tf->codes[21833] = 0x0000bc686ec0ebf5UL;
   tf->codes[21834] = 0x0000be6529430b65UL;
   tf->codes[21835] = 0x0000c0d4088d69d4UL;
   tf->codes[21836] = 0x0000c158b4967c28UL;
   tf->codes[21837] = 0x0000ce83b7e19dbdUL;
   tf->codes[21838] = 0x0000cf47fb3af3ffUL;
   tf->codes[21839] = 0x0000d620654a9c60UL;
   tf->codes[21840] = 0x0000d8bb2fd94e8fUL;
   tf->codes[21841] = 0x0000e5b92314ff8bUL;
   tf->codes[21842] = 0x0000f28279d18189UL;
   tf->codes[21843] = 0x0000f34941501742UL;
   tf->codes[21844] = 0x0000f64ccfbf1be3UL;
   tf->codes[21845] = 0x0000f9338bc9498eUL;
   tf->codes[21846] = 0x0000fc63400ba7b4UL;
   tf->codes[21847] = 0x00000192e2a27610UL;
   tf->codes[21848] = 0x000005db7cf48132UL;
   tf->codes[21849] = 0x00000a31211ed531UL;
   tf->codes[21850] = 0x00001a526e71acc5UL;
   tf->codes[21851] = 0x00001ba7b7ff4ce9UL;
   tf->codes[21852] = 0x00002c60e8491b75UL;
   tf->codes[21853] = 0x00002c8581acb695UL;
   tf->codes[21854] = 0x0000395edb84cc71UL;
   tf->codes[21855] = 0x0000480ad912dc25UL;
   tf->codes[21856] = 0x00004855a5c33ac8UL;
   tf->codes[21857] = 0x000055866105ec9aUL;
   tf->codes[21858] = 0x00005c1ebea74583UL;
   tf->codes[21859] = 0x00006272b73ce155UL;
   tf->codes[21860] = 0x00006453c42546a8UL;
   tf->codes[21861] = 0x0000645bc5b31097UL;
   tf->codes[21862] = 0x0000705b211eac16UL;
   tf->codes[21863] = 0x000071a44b101a71UL;
   tf->codes[21864] = 0x0000799efc175c5bUL;
   tf->codes[21865] = 0x00007a851a200881UL;
   tf->codes[21866] = 0x00007b41967a9a99UL;
   tf->codes[21867] = 0x00007eaf4824144aUL;
   tf->codes[21868] = 0x0000800924de27d2UL;
   tf->codes[21869] = 0x0000822ff62c6cdaUL;
   tf->codes[21870] = 0x000088fae145c0d4UL;
   tf->codes[21871] = 0x0000950e234c5246UL;
   tf->codes[21872] = 0x00009f2e80d6bc5fUL;
   tf->codes[21873] = 0x0000a3ecae525d0bUL;
   tf->codes[21874] = 0x0000a56865bbc677UL;
   tf->codes[21875] = 0x0000aacbf524b282UL;
   tf->codes[21876] = 0x0000ab8ed923e626UL;
   tf->codes[21877] = 0x0000af2716b790f9UL;
   tf->codes[21878] = 0x0000af3ac2c38127UL;
   tf->codes[21879] = 0x0000b6a30e3c5691UL;
   tf->codes[21880] = 0x0000bd8acbba8181UL;
   tf->codes[21881] = 0x0000bf418747bb77UL;
   tf->codes[21882] = 0x0000c1994c24d32dUL;
   tf->codes[21883] = 0x0000c4f81f7dd5d9UL;
   tf->codes[21884] = 0x0000c819dfabd40eUL;
   tf->codes[21885] = 0x0000cff4155de2b2UL;
   tf->codes[21886] = 0x0000dc685446026cUL;
   tf->codes[21887] = 0x0000ddd985fc6272UL;
   tf->codes[21888] = 0x0000eb2d40b98701UL;
   tf->codes[21889] = 0x0000efda0bbf7131UL;
   tf->codes[21890] = 0x0000f0b235b3bd66UL;
   tf->codes[21891] = 0x0000f5a0e1a02536UL;
   tf->codes[21892] = 0x0000f67946237730UL;
   tf->codes[21893] = 0x0000fc24e3887ca2UL;
   tf->codes[21894] = 0x0000fdc44a196a1aUL;
   tf->codes[21895] = 0x0000fef8ddc2d133UL;
   tf->codes[21896] = 0x000001544b904539UL;
   tf->codes[21897] = 0x000009b0e3b52c7fUL;
   tf->codes[21898] = 0x00001db6d53535ecUL;
   tf->codes[21899] = 0x00002eedd4c569b6UL;
   tf->codes[21900] = 0x0000362b59c50839UL;
   tf->codes[21901] = 0x000037fc2902d3e9UL;
   tf->codes[21902] = 0x00003e8cfa346e6dUL;
   tf->codes[21903] = 0x0000457aaa392f5fUL;
   tf->codes[21904] = 0x00004a352ec473bbUL;
   tf->codes[21905] = 0x00004af812c3a75fUL;
   tf->codes[21906] = 0x00004ccba0b5b84bUL;
   tf->codes[21907] = 0x00004fcd5aac8ec4UL;
   tf->codes[21908] = 0x000053a86362ce4bUL;
   tf->codes[21909] = 0x0000578ea1792887UL;
   tf->codes[21910] = 0x00005c79df0439ccUL;
   tf->codes[21911] = 0x00005e44469d63f0UL;
   tf->codes[21912] = 0x00005edb04c93e0fUL;
   tf->codes[21913] = 0x000060a7064b9096UL;
   tf->codes[21914] = 0x000065d50ef9368fUL;
   tf->codes[21915] = 0x00006bfb47d25079UL;
   tf->codes[21916] = 0x00006f29622b863cUL;
   tf->codes[21917] = 0x000071ff30de08f5UL;
   tf->codes[21918] = 0x000073ce6632ac42UL;
   tf->codes[21919] = 0x00008388feac6551UL;
   tf->codes[21920] = 0x00008478087ef27aUL;
   tf->codes[21921] = 0x00008bee829b2d9aUL;
   tf->codes[21922] = 0x00008f41e6050fccUL;
   tf->codes[21923] = 0x00009ab3a99db7f4UL;
   tf->codes[21924] = 0x0000aeb1d41efd37UL;
   tf->codes[21925] = 0x0000b2f2a772442fUL;
   tf->codes[21926] = 0x0000bc75a49d2cd8UL;
   tf->codes[21927] = 0x0000c2046f9d5b54UL;
   tf->codes[21928] = 0x0000c4fd3dca50caUL;
   tf->codes[21929] = 0x0000c801b6756c7fUL;
   tf->codes[21930] = 0x0000c881cf520b6fUL;
   tf->codes[21931] = 0x0000e17d498129c2UL;
   tf->codes[21932] = 0x0000e1ad1844df97UL;
   tf->codes[21933] = 0x0000f61c42c34700UL;
   tf->codes[21934] = 0x0000049836fe9b1aUL;
   tf->codes[21935] = 0x00000aa0b336c6faUL;
   tf->codes[21936] = 0x00000dc4f78a04a6UL;
   tf->codes[21937] = 0x0000178d7e8bc73fUL;
   tf->codes[21938] = 0x000029b9055712aaUL;
   tf->codes[21939] = 0x0000369a60bcf275UL;
   tf->codes[21940] = 0x000037be419db461UL;
   tf->codes[21941] = 0x00003c596f9ee250UL;
   tf->codes[21942] = 0x000046ed514bae06UL;
   tf->codes[21943] = 0x0000588b7ad30bdfUL;
   tf->codes[21944] = 0x000058fc40412840UL;
   tf->codes[21945] = 0x00005a226ab823deUL;
   tf->codes[21946] = 0x00005d2a8c539be3UL;
   tf->codes[21947] = 0x00005e87d76f05f6UL;
   tf->codes[21948] = 0x00005fb9ac6427d3UL;
   tf->codes[21949] = 0x00006be7021b4affUL;
   tf->codes[21950] = 0x00006d026c503772UL;
   tf->codes[21951] = 0x00006d089965d339UL;
   tf->codes[21952] = 0x000075cb36b6c7b5UL;
   tf->codes[21953] = 0x0000795df6e1e810UL;
   tf->codes[21954] = 0x000088ac228af25dUL;
   tf->codes[21955] = 0x0000890299b9773fUL;
   tf->codes[21956] = 0x00008d97601603a2UL;
   tf->codes[21957] = 0x000091bc10b184f3UL;
   tf->codes[21958] = 0x0000954360ed84d4UL;
   tf->codes[21959] = 0x00009833f2fdaa96UL;
   tf->codes[21960] = 0x00009ac55ca47038UL;
   tf->codes[21961] = 0x00009bbd17b1d89fUL;
   tf->codes[21962] = 0x00009d3c02ed92d1UL;
   tf->codes[21963] = 0x00009e4ef676a9cbUL;
   tf->codes[21964] = 0x0000a05dfdaa96cbUL;
   tf->codes[21965] = 0x0000a0a904e9fb33UL;
   tf->codes[21966] = 0x0000a2ccdcf4f53aUL;
   tf->codes[21967] = 0x0000a319b8ac87caUL;
   tf->codes[21968] = 0x0000a95ff7bcc970UL;
   tf->codes[21969] = 0x0000ac7aa09914caUL;
   tf->codes[21970] = 0x0000b6e4e097c672UL;
   tf->codes[21971] = 0x0000b7081aa13ef4UL;
   tf->codes[21972] = 0x0000b76ab16bf59fUL;
   tf->codes[21973] = 0x0000b7a9990f283eUL;
   tf->codes[21974] = 0x0000b8d83a31f955UL;
   tf->codes[21975] = 0x0000bd402b0e1ae4UL;
   tf->codes[21976] = 0x0000c7d7408d3760UL;
   tf->codes[21977] = 0x0000d0d9752e6fcaUL;
   tf->codes[21978] = 0x0000d7491b5dc5b9UL;
   tf->codes[21979] = 0x0000e4448a74373eUL;
   tf->codes[21980] = 0x0000e7d9cec49710UL;
   tf->codes[21981] = 0x0000edd78abab3c5UL;
   tf->codes[21982] = 0x0000f575d20cdacbUL;
   tf->codes[21983] = 0x0000f7d55de8b6abUL;
   tf->codes[21984] = 0x0000fa67ec5a9926UL;
   tf->codes[21985] = 0x0000ff2f7abe265fUL;
   tf->codes[21986] = 0x000001313d8ac4bdUL;
   tf->codes[21987] = 0x00000ca5bfd7b221UL;
   tf->codes[21988] = 0x00001aa49479b24cUL;
   tf->codes[21989] = 0x00001adacae209adUL;
   tf->codes[21990] = 0x00001b8276658ebeUL;
   tf->codes[21991] = 0x00001ed3cac83d03UL;
   tf->codes[21992] = 0x0000237f36740495UL;
   tf->codes[21993] = 0x0000329e08776497UL;
   tf->codes[21994] = 0x000033619c23a98aUL;
   tf->codes[21995] = 0x0000354e18fb2f57UL;
   tf->codes[21996] = 0x0000372eeb548ee5UL;
   tf->codes[21997] = 0x00003b0f717358e4UL;
   tf->codes[21998] = 0x0000401f82f10b0eUL;
   tf->codes[21999] = 0x000047662e499059UL;
   tf->codes[22000] = 0x0000507656ff28b4UL;
   tf->codes[22001] = 0x000053f77a258cceUL;
   tf->codes[22002] = 0x000059a4b173baa3UL;
   tf->codes[22003] = 0x00005cd21c1fdf17UL;
   tf->codes[22004] = 0x00005e2c3368f864UL;
   tf->codes[22005] = 0x000063d636e4d573UL;
   tf->codes[22006] = 0x000063f761e71a08UL;
   tf->codes[22007] = 0x000064f5849923fbUL;
   tf->codes[22008] = 0x000064fcd679dc9bUL;
   tf->codes[22009] = 0x00006a331b445248UL;
   tf->codes[22010] = 0x00006a3355d3580dUL;
   tf->codes[22011] = 0x00006d4219a27763UL;
   tf->codes[22012] = 0x0000839584db94e5UL;
   tf->codes[22013] = 0x000085338c125fbfUL;
   tf->codes[22014] = 0x0000895ac0d32087UL;
   tf->codes[22015] = 0x00008aa87df10246UL;
   tf->codes[22016] = 0x00008f25b4c23c66UL;
   tf->codes[22017] = 0x00009f35651057b9UL;
   tf->codes[22018] = 0x0000a4aa1c5ff47bUL;
   tf->codes[22019] = 0x0000a699927ac549UL;
   tf->codes[22020] = 0x0000ac2b56be3ec6UL;
   tf->codes[22021] = 0x0000ac9d0668723bUL;
   tf->codes[22022] = 0x0000ad88674aa314UL;
   tf->codes[22023] = 0x0000b1cbf9522f48UL;
   tf->codes[22024] = 0x0000b5d5ac0107cbUL;
   tf->codes[22025] = 0x0000bd0711647485UL;
   tf->codes[22026] = 0x0000c22b097d1ca2UL;
   tf->codes[22027] = 0x0000ce8ed02b9cf4UL;
   tf->codes[22028] = 0x0000d8a30e19d544UL;
   tf->codes[22029] = 0x0000db3b548347fcUL;
   tf->codes[22030] = 0x0000e1f601f20253UL;
   tf->codes[22031] = 0x0000e250d1bdf4d4UL;
   tf->codes[22032] = 0x0000e569a6221206UL;
   tf->codes[22033] = 0x0000016ba8037ffbUL;
   tf->codes[22034] = 0x00000244f6c2e909UL;
   tf->codes[22035] = 0x000002ba4f5d78ceUL;
   tf->codes[22036] = 0x000008b303091695UL;
   tf->codes[22037] = 0x000013763e5b8c96UL;
   tf->codes[22038] = 0x00001413299d027cUL;
   tf->codes[22039] = 0x00001ad7ad11b4eaUL;
   tf->codes[22040] = 0x000028e9b8a199b9UL;
   tf->codes[22041] = 0x00002a6e9663e9edUL;
   tf->codes[22042] = 0x000041292b94317eUL;
   tf->codes[22043] = 0x0000448fc5ebf854UL;
   tf->codes[22044] = 0x00004c2bfe36eb6dUL;
   tf->codes[22045] = 0x00005e7491f61393UL;
   tf->codes[22046] = 0x0000691df426fd9fUL;
   tf->codes[22047] = 0x00006d55dbb06394UL;
   tf->codes[22048] = 0x00006e4a9d7a80faUL;
   tf->codes[22049] = 0x0000737bd9fa77b9UL;
   tf->codes[22050] = 0x00007e32bb21b62cUL;
   tf->codes[22051] = 0x00008182eab94798UL;
   tf->codes[22052] = 0x000091893a1f765eUL;
   tf->codes[22053] = 0x00009275bfccc410UL;
   tf->codes[22054] = 0x000094c8f17d6862UL;
   tf->codes[22055] = 0x0000974dc669f0b1UL;
   tf->codes[22056] = 0x00009e68116016b2UL;
   tf->codes[22057] = 0x0000ac95ca89b59eUL;
   tf->codes[22058] = 0x0000ace0221c08b7UL;
   tf->codes[22059] = 0x0000b009a948cb16UL;
   tf->codes[22060] = 0x0000b7e0ab2888f4UL;
   tf->codes[22061] = 0x0000bbe51afddcc4UL;
   tf->codes[22062] = 0x0000bcf2568f6381UL;
   tf->codes[22063] = 0x0000bd0ca4cefb00UL;
   tf->codes[22064] = 0x0000bee70f83b902UL;
   tf->codes[22065] = 0x0000c5b4f3e057fdUL;
   tf->codes[22066] = 0x0000d8bbd8724063UL;
   tf->codes[22067] = 0x0000dd5f7d1f43cbUL;
   tf->codes[22068] = 0x0000dec92265e56cUL;
   tf->codes[22069] = 0x0000dfacf6d857e0UL;
   tf->codes[22070] = 0x0000e4051f27eb56UL;
   tf->codes[22071] = 0x0000e7f2af1efe32UL;
   tf->codes[22072] = 0x0000e953a32ac495UL;
   tf->codes[22073] = 0x0000ebe840a3dafdUL;
   tf->codes[22074] = 0x0000ee7b7ec2cec7UL;
   tf->codes[22075] = 0x0000f8fc9e9fc163UL;
   tf->codes[22076] = 0x0000f9873d2f69b9UL;
   tf->codes[22077] = 0x000004a8b6af28c6UL;
   tf->codes[22078] = 0x000013193afb5c66UL;
   tf->codes[22079] = 0x00001804eda47935UL;
   tf->codes[22080] = 0x000019c001cf20caUL;
   tf->codes[22081] = 0x00002210ef75e1d1UL;
   tf->codes[22082] = 0x00002b53e0327b02UL;
   tf->codes[22083] = 0x00002f2512e2c272UL;
   tf->codes[22084] = 0x0000332355a27a7bUL;
   tf->codes[22085] = 0x0000366ef20d9883UL;
   tf->codes[22086] = 0x00003c9c42386548UL;
   tf->codes[22087] = 0x00004507f33cc958UL;
   tf->codes[22088] = 0x000045fcb506e6beUL;
   tf->codes[22089] = 0x00004ac4436a73f7UL;
   tf->codes[22090] = 0x00004ac65271a7e4UL;
   tf->codes[22091] = 0x00004cde456f75e7UL;
   tf->codes[22092] = 0x00004da079c1983cUL;
   tf->codes[22093] = 0x00004fab9d762327UL;
   tf->codes[22094] = 0x0000516970550ff8UL;
   tf->codes[22095] = 0x000054cf2070bfbaUL;
   tf->codes[22096] = 0x0000573638bc59ffUL;
   tf->codes[22097] = 0x00006489f3797e8eUL;
   tf->codes[22098] = 0x00006615adfe7bd8UL;
   tf->codes[22099] = 0x000067d0127c121eUL;
   tf->codes[22100] = 0x00008610ea5522e8UL;
   tf->codes[22101] = 0x0000863dfa649381UL;
   tf->codes[22102] = 0x00008897ce48df24UL;
   tf->codes[22103] = 0x00008ca096bba093UL;
   tf->codes[22104] = 0x000093cdde10a573UL;
   tf->codes[22105] = 0x00009af98b7c81f0UL;
   tf->codes[22106] = 0x00009bdaa13aaf28UL;
   tf->codes[22107] = 0x0000aadc664a326fUL;
   tf->codes[22108] = 0x0000b195b45eca28UL;
   tf->codes[22109] = 0x0000b377ab83468fUL;
   tf->codes[22110] = 0x0000b8c2c124c943UL;
   tf->codes[22111] = 0x0000bcdb522418cbUL;
   tf->codes[22112] = 0x0000bd302f69754aUL;
   tf->codes[22113] = 0x0000c09bd20bbb0eUL;
   tf->codes[22114] = 0x0000c1fdeae29e4aUL;
   tf->codes[22115] = 0x0000c480011ae15dUL;
   tf->codes[22116] = 0x0000c5ac1e1872fdUL;
   tf->codes[22117] = 0x0000c91f87b97cebUL;
   tf->codes[22118] = 0x0000cc68da8e6141UL;
   tf->codes[22119] = 0x0000d24bd326daedUL;
   tf->codes[22120] = 0x0000dde6c34f9199UL;
   tf->codes[22121] = 0x0000e578eb0586d6UL;
   tf->codes[22122] = 0x0000f4baf7125f5aUL;
   tf->codes[22123] = 0x0000f4f635c535a9UL;
   tf->codes[22124] = 0x0000f5889b53a229UL;
   tf->codes[22125] = 0x0000f691f365c6d1UL;
   tf->codes[22126] = 0x0000f6bb9513e0dfUL;
   tf->codes[22127] = 0x000016225cd4e782UL;
   tf->codes[22128] = 0x00001a4747ff6e98UL;
   tf->codes[22129] = 0x00001aceb2bcc628UL;
   tf->codes[22130] = 0x00001b8159116029UL;
   tf->codes[22131] = 0x0000219d46c67672UL;
   tf->codes[22132] = 0x00002743a151f731UL;
   tf->codes[22133] = 0x00002959fa669cd1UL;
   tf->codes[22134] = 0x00002d728b65ec59UL;
   tf->codes[22135] = 0x00002dd228ed5803UL;
   tf->codes[22136] = 0x00002e465cbccaefUL;
   tf->codes[22137] = 0x000038cd34914dc8UL;
   tf->codes[22138] = 0x00003f693b230301UL;
   tf->codes[22139] = 0x000044459a5d9d41UL;
   tf->codes[22140] = 0x000051d5437aa96eUL;
   tf->codes[22141] = 0x00005657f7b46e06UL;
   tf->codes[22142] = 0x00005885e05465e9UL;
   tf->codes[22143] = 0x00005dc28cc37d22UL;
   tf->codes[22144] = 0x000063862ed1e061UL;
   tf->codes[22145] = 0x0000649eda528798UL;
   tf->codes[22146] = 0x00006ab007c58eb6UL;
   tf->codes[22147] = 0x00006d41716c5458UL;
   tf->codes[22148] = 0x00006dc399502735UL;
   tf->codes[22149] = 0x000070b1321d01f6UL;
   tf->codes[22150] = 0x00007674d42b6535UL;
   tf->codes[22151] = 0x00007e93345a2b2bUL;
   tf->codes[22152] = 0x000084a16889e748UL;
   tf->codes[22153] = 0x00008544bb6ffebaUL;
   tf->codes[22154] = 0x000085adb9df56f1UL;
   tf->codes[22155] = 0x00008bba5425eaabUL;
   tf->codes[22156] = 0x00008bf224776a6fUL;
   tf->codes[22157] = 0x000098af5b97baa4UL;
   tf->codes[22158] = 0x000098f644c8b732UL;
   tf->codes[22159] = 0x0000a8a9c5f0bd66UL;
   tf->codes[22160] = 0x0000b0d0d75a5e9aUL;
   tf->codes[22161] = 0x0000b626381fe4efUL;
   tf->codes[22162] = 0x0000b774df79ddc2UL;
   tf->codes[22163] = 0x0000c5b819279b04UL;
   tf->codes[22164] = 0x0000c7518d31f27aUL;
   tf->codes[22165] = 0x0000cd1395572d56UL;
   tf->codes[22166] = 0x0000cdafd0eb91edUL;
   tf->codes[22167] = 0x0000cfb2b8834d24UL;
   tf->codes[22168] = 0x0000d37c5ec3d62fUL;
   tf->codes[22169] = 0x0000d65a2f0422d7UL;
   tf->codes[22170] = 0x0000d807fec77bcaUL;
   tf->codes[22171] = 0x0000da812935dddaUL;
   tf->codes[22172] = 0x0000dbdf5e8d5f01UL;
   tf->codes[22173] = 0x0000e57c6f68d964UL;
   tf->codes[22174] = 0x0000edafdafdb226UL;
   tf->codes[22175] = 0x0000f6f1e17e3443UL;
   tf->codes[22176] = 0x0000f8f5b352068eUL;
   tf->codes[22177] = 0x0000f96344edd229UL;
   tf->codes[22178] = 0x0000fc15d996dc60UL;
   tf->codes[22179] = 0x0000fd2f6f539aabUL;
   tf->codes[22180] = 0x0000074ac49385d6UL;
   tf->codes[22181] = 0x000007c8594ae54fUL;
   tf->codes[22182] = 0x0000124052cef123UL;
   tf->codes[22183] = 0x000018da0fca6caaUL;
   tf->codes[22184] = 0x00001ea5edf59f9dUL;
   tf->codes[22185] = 0x000021a7e27b7bdbUL;
   tf->codes[22186] = 0x0000239d85abe870UL;
   tf->codes[22187] = 0x00002d48500cbcffUL;
   tf->codes[22188] = 0x00003797ccadcb9eUL;
   tf->codes[22189] = 0x00003c9ca8cb6313UL;
   tf->codes[22190] = 0x000041296d9a2587UL;
   tf->codes[22191] = 0x0000495beef2e735UL;
   tf->codes[22192] = 0x000052b2c64a7659UL;
   tf->codes[22193] = 0x00005a59f9667e62UL;
   tf->codes[22194] = 0x00005d779b8614bdUL;
   tf->codes[22195] = 0x0000615562f09980UL;
   tf->codes[22196] = 0x00006d05990e68bdUL;
   tf->codes[22197] = 0x00007122f7c9316eUL;
   tf->codes[22198] = 0x00007318d588a3c8UL;
   tf->codes[22199] = 0x0000777a994f2990UL;
   tf->codes[22200] = 0x00007c560e4dacbcUL;
   tf->codes[22201] = 0x000085cd266b6961UL;
   tf->codes[22202] = 0x00009309c6bb4737UL;
   tf->codes[22203] = 0x0000975d966d6d0eUL;
   tf->codes[22204] = 0x0000a73a7eb4878bUL;
   tf->codes[22205] = 0x0000a875b49195f5UL;
   tf->codes[22206] = 0x0000a8f6b7aa4bf9UL;
   tf->codes[22207] = 0x0000b5e72befa88eUL;
   tf->codes[22208] = 0x0000b981eda892d8UL;
   tf->codes[22209] = 0x0000bf513a351c56UL;
   tf->codes[22210] = 0x0000c6e536633fbbUL;
   tf->codes[22211] = 0x0000c7150526f590UL;
   tf->codes[22212] = 0x0000d201327a7450UL;
   tf->codes[22213] = 0x0000d606c71ae4f9UL;
   tf->codes[22214] = 0x0000debbaae67f49UL;
   tf->codes[22215] = 0x0000e2ace3cdee75UL;
   tf->codes[22216] = 0x0000e2dade197622UL;
   tf->codes[22217] = 0x0000e35036b405e7UL;
   tf->codes[22218] = 0x0000ec8eced33179UL;
   tf->codes[22219] = 0x0000f0f943d4927fUL;
   tf->codes[22220] = 0x0000f31ad24952d4UL;
   tf->codes[22221] = 0x0000f75d3f85c22fUL;
   tf->codes[22222] = 0x0000f7e768f75efbUL;
   tf->codes[22223] = 0x0000fd0c4b4c1e2cUL;
   tf->codes[22224] = 0x00000098de61a2c0UL;
   tf->codes[22225] = 0x00000c1efdb34c65UL;
   tf->codes[22226] = 0x00000e5054b49ad3UL;
   tf->codes[22227] = 0x000018dc34d39c9aUL;
   tf->codes[22228] = 0x00001b2eb6d72f9dUL;
   tf->codes[22229] = 0x000024f7ed860385UL;
   tf->codes[22230] = 0x000025a132f2b0f9UL;
   tf->codes[22231] = 0x000029ec5169fb92UL;
   tf->codes[22232] = 0x00002bbd20a7c742UL;
   tf->codes[22233] = 0x0000345f42a38878UL;
   tf->codes[22234] = 0x000037fbd8d4a0eaUL;
   tf->codes[22235] = 0x00003f963ca765dbUL;
   tf->codes[22236] = 0x00004005a2bb5f9eUL;
   tf->codes[22237] = 0x00004240cfc2a623UL;
   tf->codes[22238] = 0x000048cee23ffb6bUL;
   tf->codes[22239] = 0x00004f54b8a080ffUL;
   tf->codes[22240] = 0x000052d73b2107b7UL;
   tf->codes[22241] = 0x0000643ef3b1086aUL;
   tf->codes[22242] = 0x000064d417f3ba26UL;
   tf->codes[22243] = 0x00006603a352a251UL;
   tf->codes[22244] = 0x0000693a3457ad8dUL;
   tf->codes[22245] = 0x00006b689215b0faUL;
   tf->codes[22246] = 0x00006d2ba7ce227eUL;
   tf->codes[22247] = 0x00006dde4e22bc7fUL;
   tf->codes[22248] = 0x00007981054a3755UL;
   tf->codes[22249] = 0x00007c047adc9d06UL;
   tf->codes[22250] = 0x000081afa32396eeUL;
   tf->codes[22251] = 0x0000842ec0188f00UL;
   tf->codes[22252] = 0x00008dbd2d329823UL;
   tf->codes[22253] = 0x0000949597424084UL;
   tf->codes[22254] = 0x00009a34da7c0e68UL;
   tf->codes[22255] = 0x00009f04df8b711aUL;
   tf->codes[22256] = 0x0000a5632345108dUL;
   tf->codes[22257] = 0x0000a9796aae2663UL;
   tf->codes[22258] = 0x0000ac54f1583959UL;
   tf->codes[22259] = 0x0000b13c10d4e2c4UL;
   tf->codes[22260] = 0x0000b39d3699e707UL;
   tf->codes[22261] = 0x0000b70d6c68a02fUL;
   tf->codes[22262] = 0x0000bb33b6ed49e3UL;
   tf->codes[22263] = 0x0000bb5a99e71eb5UL;
   tf->codes[22264] = 0x0000be47bd95edecUL;
   tf->codes[22265] = 0x0000c4e97c1f3362UL;
   tf->codes[22266] = 0x0000c4f6fb1587c9UL;
   tf->codes[22267] = 0x0000c789fea575ceUL;
   tf->codes[22268] = 0x0000c8a1fa790bb6UL;
   tf->codes[22269] = 0x0000c9630a001132UL;
   tf->codes[22270] = 0x0000cf42cec63a18UL;
   tf->codes[22271] = 0x0000d1fae0d7cec7UL;
   tf->codes[22272] = 0x0000d4a7bd8948c1UL;
   tf->codes[22273] = 0x0000da3b1bb5eaa1UL;
   tf->codes[22274] = 0x0000de5c987f1b2cUL;
   tf->codes[22275] = 0x0000f319fe0f37c3UL;
   tf->codes[22276] = 0x0000f9d67ff62042UL;
   tf->codes[22277] = 0x0000fd7bc76213f2UL;
   tf->codes[22278] = 0x00000428462d6893UL;
   tf->codes[22279] = 0x00000d2fbda825b0UL;
   tf->codes[22280] = 0x000010251d73c49bUL;
   tf->codes[22281] = 0x0000108aad81c647UL;
   tf->codes[22282] = 0x000016b7c31d8d47UL;
   tf->codes[22283] = 0x000017a916865422UL;
   tf->codes[22284] = 0x0000318fb7089d89UL;
   tf->codes[22285] = 0x00003a4a183cc251UL;
   tf->codes[22286] = 0x00003bf354d3a7e0UL;
   tf->codes[22287] = 0x00004252f7e769f1UL;
   tf->codes[22288] = 0x000043c33f61b2e3UL;
   tf->codes[22289] = 0x000052c713786a17UL;
   tf->codes[22290] = 0x00005a488865ba27UL;
   tf->codes[22291] = 0x00005da3783f5abeUL;
   tf->codes[22292] = 0x00005e2fb0b82b77UL;
   tf->codes[22293] = 0x00006081830ead2bUL;
   tf->codes[22294] = 0x00006462f3698e3eUL;
   tf->codes[22295] = 0x00006b15d9d9846bUL;
   tf->codes[22296] = 0x0000751ee267a206UL;
   tf->codes[22297] = 0x000075521f8cae66UL;
   tf->codes[22298] = 0x000078e7d8fb19c2UL;
   tf->codes[22299] = 0x000079e511710ca1UL;
   tf->codes[22300] = 0x000082d8dcdfd990UL;
   tf->codes[22301] = 0x00008b1fb9f19cbbUL;
   tf->codes[22302] = 0x00008c8999c74421UL;
   tf->codes[22303] = 0x0000948a3d551c0dUL;
   tf->codes[22304] = 0x00009b5f39036de3UL;
   tf->codes[22305] = 0x00009bbffb55f666UL;
   tf->codes[22306] = 0x0000a08c5774fcc8UL;
   tf->codes[22307] = 0x0000a2c575750f60UL;
   tf->codes[22308] = 0x0000abe05e6cb6e6UL;
   tf->codes[22309] = 0x0000b08ceee39b51UL;
   tf->codes[22310] = 0x0000b45a78a38671UL;
   tf->codes[22311] = 0x0000b8ac394e785bUL;
   tf->codes[22312] = 0x0000bc577341020dUL;
   tf->codes[22313] = 0x0000be3f977b1a3bUL;
   tf->codes[22314] = 0x0000c0dbc163ef08UL;
   tf->codes[22315] = 0x0000c6d733c3d20bUL;
   tf->codes[22316] = 0x0000c8a8b2aeaf0aUL;
   tf->codes[22317] = 0x0000c9f251be28efUL;
   tf->codes[22318] = 0x0000cbee5c933710UL;
   tf->codes[22319] = 0x0000cd23655aa9b3UL;
   tf->codes[22320] = 0x0000d3fd2ec474b2UL;
   tf->codes[22321] = 0x0000dd58d3d77cffUL;
   tf->codes[22322] = 0x0000e3f80e3b82feUL;
   tf->codes[22323] = 0x0000ed7e04a9b6a8UL;
   tf->codes[22324] = 0x0000ed825d472447UL;
   tf->codes[22325] = 0x0000f8b74843cdbdUL;
   tf->codes[22326] = 0x0000f9af786f41aeUL;
   tf->codes[22327] = 0x000006a73e9556e3UL;
   tf->codes[22328] = 0x00000d4f64c33de5UL;
   tf->codes[22329] = 0x00000ff773b93eb6UL;
   tf->codes[22330] = 0x000012ebe948c68dUL;
   tf->codes[22331] = 0x000014380c7d7fe9UL;
   tf->codes[22332] = 0x0000144dc790a404UL;
   tf->codes[22333] = 0x000025cf594230acUL;
   tf->codes[22334] = 0x00002af9f38e801aUL;
   tf->codes[22335] = 0x00003426798ae3e1UL;
   tf->codes[22336] = 0x000034961a2de369UL;
   tf->codes[22337] = 0x0000366a57cd05a4UL;
   tf->codes[22338] = 0x000048f6665bd3cdUL;
   tf->codes[22339] = 0x000055989f8f7b34UL;
   tf->codes[22340] = 0x00006a7312137486UL;
   tf->codes[22341] = 0x00006aec88bc6c25UL;
   tf->codes[22342] = 0x00006e96d872dec3UL;
   tf->codes[22343] = 0x00006f2ebb69d5bbUL;
   tf->codes[22344] = 0x000078f02b19e579UL;
   tf->codes[22345] = 0x000079633a1e3b8cUL;
   tf->codes[22346] = 0x00007fa6455c2c6cUL;
   tf->codes[22347] = 0x000084d956545153UL;
   tf->codes[22348] = 0x00008909ebfcfea8UL;
   tf->codes[22349] = 0x00008ce778d87da6UL;
   tf->codes[22350] = 0x000091a481890179UL;
   tf->codes[22351] = 0x000092c1c0361c14UL;
   tf->codes[22352] = 0x00009369e0d7acafUL;
   tf->codes[22353] = 0x00009529fd4cd332UL;
   tf->codes[22354] = 0x0000a217ed6cf050UL;
   tf->codes[22355] = 0x0000ad2754c9e792UL;
   tf->codes[22356] = 0x0000adfd3527fa15UL;
   tf->codes[22357] = 0x0000b84d61761a03UL;
   tf->codes[22358] = 0x0000c4accf872cb6UL;
   tf->codes[22359] = 0x0000c5213de5a567UL;
   tf->codes[22360] = 0x0000c7f747272de5UL;
   tf->codes[22361] = 0x0000cbf932d7423eUL;
   tf->codes[22362] = 0x0000cf60424d149eUL;
   tf->codes[22363] = 0x0000d3b44c8e403aUL;
   tf->codes[22364] = 0x0000d3b8dfbab39eUL;
   tf->codes[22365] = 0x0000df31baa50ea1UL;
   tf->codes[22366] = 0x0000e0940e0af7a2UL;
   tf->codes[22367] = 0x0000f15b6cf82be4UL;
   tf->codes[22368] = 0x0000f3df57a89d1fUL;
   tf->codes[22369] = 0x0000f7d732c3b39cUL;
   tf->codes[22370] = 0x0000ff55ae6db8abUL;
   tf->codes[22371] = 0x00001032c86e1108UL;
   tf->codes[22372] = 0x000010c31ef5499bUL;
   tf->codes[22373] = 0x0000188bb7a29bfeUL;
   tf->codes[22374] = 0x000018942e4e7177UL;
   tf->codes[22375] = 0x0000189b45a02452UL;
   tf->codes[22376] = 0x00001baf86d7ce20UL;
   tf->codes[22377] = 0x00001dcc4791154cUL;
   tf->codes[22378] = 0x00001e6e3b1d0a20UL;
   tf->codes[22379] = 0x0000215b243cd392UL;
   tf->codes[22380] = 0x000024852087a17bUL;
   tf->codes[22381] = 0x000029243208317fUL;
   tf->codes[22382] = 0x00002992e86f19f3UL;
   tf->codes[22383] = 0x000040dfa89ec83fUL;
   tf->codes[22384] = 0x00004bcfb971a914UL;
   tf->codes[22385] = 0x0000502b8ab198daUL;
   tf->codes[22386] = 0x00005355fc1a724dUL;
   tf->codes[22387] = 0x0000564b5be61138UL;
   tf->codes[22388] = 0x00005699d186cc2bUL;
   tf->codes[22389] = 0x00005da578bb80ecUL;
   tf->codes[22390] = 0x00005f1eabffaae1UL;
   tf->codes[22391] = 0x00006262bbfb0a84UL;
   tf->codes[22392] = 0x000065f491ea13cbUL;
   tf->codes[22393] = 0x000069c80e3094edUL;
   tf->codes[22394] = 0x00006dec0f1f04efUL;
   tf->codes[22395] = 0x00007b50f1c2da35UL;
   tf->codes[22396] = 0x00007da373c66d38UL;
   tf->codes[22397] = 0x000080096746eaa4UL;
   tf->codes[22398] = 0x000081a4ea587607UL;
   tf->codes[22399] = 0x0000836282a85d13UL;
   tf->codes[22400] = 0x000088195e43451fUL;
   tf->codes[22401] = 0x00008a64194813f8UL;
   tf->codes[22402] = 0x00008ea1f3580fefUL;
   tf->codes[22403] = 0x000092cf1a9f66b9UL;
   tf->codes[22404] = 0x00009403392ac248UL;
   tf->codes[22405] = 0x000096186d744b0fUL;
   tf->codes[22406] = 0x000096a79f3066c9UL;
   tf->codes[22407] = 0x0000978b3913d378UL;
   tf->codes[22408] = 0x0000a1d154ccf58aUL;
   tf->codes[22409] = 0x0000a26937c3ec82UL;
   tf->codes[22410] = 0x0000a32df03b4e4eUL;
   tf->codes[22411] = 0x0000a7d3de7e8b68UL;
   tf->codes[22412] = 0x0000b0fbd14e7bcbUL;
   tf->codes[22413] = 0x0000b720703e6d52UL;
   tf->codes[22414] = 0x0000b8e8c8d06389UL;
   tf->codes[22415] = 0x0000bab9980e2f39UL;
   tf->codes[22416] = 0x0000c09120b7886bUL;
   tf->codes[22417] = 0x0000cdcd4be95ab7UL;
   tf->codes[22418] = 0x0000d161e08ca93aUL;
   tf->codes[22419] = 0x0000d43615560390UL;
   tf->codes[22420] = 0x0000d5ffcd421c65UL;
   tf->codes[22421] = 0x0000e7a7cccf7255UL;
   tf->codes[22422] = 0x0000f0560e676554UL;
   tf->codes[22423] = 0x0000f74d59e31898UL;
   tf->codes[22424] = 0x0000f7e9205971a5UL;
   tf->codes[22425] = 0x0000f97b07f40ab6UL;
   tf->codes[22426] = 0x0000fab4de76f682UL;
   tf->codes[22427] = 0x00000ad282d971c6UL;
   tf->codes[22428] = 0x0000111fd93b6647UL;
   tf->codes[22429] = 0x0000192d11837b86UL;
   tf->codes[22430] = 0x00001bb04c86db72UL;
   tf->codes[22431] = 0x00001d1090e59086UL;
   tf->codes[22432] = 0x0000260c98712d29UL;
   tf->codes[22433] = 0x00002ac005aabeaaUL;
   tf->codes[22434] = 0x000033e539c669d1UL;
   tf->codes[22435] = 0x000036453ac0513bUL;
   tf->codes[22436] = 0x00003969b9a294acUL;
   tf->codes[22437] = 0x00003b930f16192bUL;
   tf->codes[22438] = 0x00003d3150dbe9caUL;
   tf->codes[22439] = 0x0000433156684031UL;
   tf->codes[22440] = 0x000044085b916f8dUL;
   tf->codes[22441] = 0x000046c48bb16c16UL;
   tf->codes[22442] = 0x00004a02a92635b7UL;
   tf->codes[22443] = 0x00004b190b10a33cUL;
   tf->codes[22444] = 0x00004d24de723f76UL;
   tf->codes[22445] = 0x00004fb43911d12bUL;
   tf->codes[22446] = 0x000051b1a34101eaUL;
   tf->codes[22447] = 0x000057c30b430ecdUL;
   tf->codes[22448] = 0x000059ff22866c66UL;
   tf->codes[22449] = 0x00005e232374dc68UL;
   tf->codes[22450] = 0x00005e4a40fdb6ffUL;
   tf->codes[22451] = 0x00005eb04629c435UL;
   tf->codes[22452] = 0x00006603c0cb8c98UL;
   tf->codes[22453] = 0x00006bcc6b246ec5UL;
   tf->codes[22454] = 0x0000751080ac24cfUL;
   tf->codes[22455] = 0x0000844a509c2d9fUL;
   tf->codes[22456] = 0x000086578357ec77UL;
   tf->codes[22457] = 0x000094fb44c92c77UL;
   tf->codes[22458] = 0x000095970b3f8584UL;
   tf->codes[22459] = 0x000097c47ec171ddUL;
   tf->codes[22460] = 0x000099cce3c1b78cUL;
   tf->codes[22461] = 0x00009a0e14fb23ddUL;
   tf->codes[22462] = 0x0000a6a0fac048b5UL;
   tf->codes[22463] = 0x0000aa01680273c4UL;
   tf->codes[22464] = 0x0000ad127567ccccUL;
   tf->codes[22465] = 0x0000ad34ffc433ffUL;
   tf->codes[22466] = 0x0000b601731b2092UL;
   tf->codes[22467] = 0x0000b66618ed0b2aUL;
   tf->codes[22468] = 0x0000b8a096474060UL;
   tf->codes[22469] = 0x0000b99eb8f94a53UL;
   tf->codes[22470] = 0x0000c03ea30a61a1UL;
   tf->codes[22471] = 0x0000c83a3e4dba9fUL;
   tf->codes[22472] = 0x0000cac5404fdeb5UL;
   tf->codes[22473] = 0x0000cb75d79d44c9UL;
   tf->codes[22474] = 0x0000cbf4911fc11bUL;
   tf->codes[22475] = 0x0000d158d035be75UL;
   tf->codes[22476] = 0x0000e601da0cd98fUL;
   tf->codes[22477] = 0x0000f698456b3b23UL;
   tf->codes[22478] = 0x0000fd4f49e9992aUL;
   tf->codes[22479] = 0x00000b6bdb2c875fUL;
   tf->codes[22480] = 0x00003096ba19fccbUL;
   tf->codes[22481] = 0x0000395c50ae3c48UL;
   tf->codes[22482] = 0x00003a618ab1f916UL;
   tf->codes[22483] = 0x00003b3ad9716224UL;
   tf->codes[22484] = 0x000041de31e3cffdUL;
   tf->codes[22485] = 0x000043429450ecebUL;
   tf->codes[22486] = 0x000043aa33662284UL;
   tf->codes[22487] = 0x000048e66ab72e33UL;
   tf->codes[22488] = 0x00004d3a74f859cfUL;
   tf->codes[22489] = 0x0000572fd17a873cUL;
   tf->codes[22490] = 0x000058e9fb6917bdUL;
   tf->codes[22491] = 0x00005986ac1b87deUL;
   tf->codes[22492] = 0x00005b8e26dfb679UL;
   tf->codes[22493] = 0x000061a2fd4319e7UL;
   tf->codes[22494] = 0x00006a049db2801bUL;
   tf->codes[22495] = 0x00006b98cee352deUL;
   tf->codes[22496] = 0x000073bb87af8673UL;
   tf->codes[22497] = 0x0000741707288a43UL;
   tf->codes[22498] = 0x00007c06bd5eb73dUL;
   tf->codes[22499] = 0x00007fe11667e575UL;
   tf->codes[22500] = 0x000080d403b9d4b3UL;
   tf->codes[22501] = 0x000082cdc4f8a922UL;
   tf->codes[22502] = 0x000093b90d9c6735UL;
   tf->codes[22503] = 0x0000996b4d3513f8UL;
   tf->codes[22504] = 0x00009ccf63679b57UL;
   tf->codes[22505] = 0x00009f5a2adab9a8UL;
   tf->codes[22506] = 0x0000a3486a7eddd3UL;
   tf->codes[22507] = 0x0000abca4bb47188UL;
   tf->codes[22508] = 0x0000b099dba5c8b0UL;
   tf->codes[22509] = 0x0000b816484899d2UL;
   tf->codes[22510] = 0x0000bb57d41eb9feUL;
   tf->codes[22511] = 0x0000bf36fae3615fUL;
   tf->codes[22512] = 0x0000c16a9b7ae97fUL;
   tf->codes[22513] = 0x0000c81ea6b5fc85UL;
   tf->codes[22514] = 0x0000d282f42e182bUL;
   tf->codes[22515] = 0x0000df453398e74eUL;
   tf->codes[22516] = 0x0000e83e7c703eb5UL;
   tf->codes[22517] = 0x0000eb3158169e29UL;
   tf->codes[22518] = 0x0000f3a2fba1983bUL;
   tf->codes[22519] = 0x0000f4138680aed7UL;
   tf->codes[22520] = 0x0000f4167fc3f9d8UL;
   tf->codes[22521] = 0x0000019207b70a4dUL;
   tf->codes[22522] = 0x0000067543b451a3UL;
   tf->codes[22523] = 0x00000d62b92a0cd0UL;
   tf->codes[22524] = 0x00000e33913da065UL;
   tf->codes[22525] = 0x000012946ac80f19UL;
   tf->codes[22526] = 0x00001d31ad5cc75cUL;
   tf->codes[22527] = 0x000025b1ba1a2ce9UL;
   tf->codes[22528] = 0x00002649d7a029a6UL;
   tf->codes[22529] = 0x00002a6561e2c42fUL;
   tf->codes[22530] = 0x0000305ae1bc1130UL;
   tf->codes[22531] = 0x0000314ce4d1e95aUL;
   tf->codes[22532] = 0x000036088e284a8fUL;
   tf->codes[22533] = 0x00003c8b30b67f5dUL;
   tf->codes[22534] = 0x000040a1781f9533UL;
   tf->codes[22535] = 0x000047f776e69d0dUL;
   tf->codes[22536] = 0x000049e7d73d84efUL;
   tf->codes[22537] = 0x00004ce5adb4f953UL;
   tf->codes[22538] = 0x00004f71d4823a42UL;
   tf->codes[22539] = 0x00005083ddcf3a28UL;
   tf->codes[22540] = 0x00005e4ddb630590UL;
   tf->codes[22541] = 0x00005f293929a28bUL;
   tf->codes[22542] = 0x00006535d3703645UL;
   tf->codes[22543] = 0x000067cb5b2563c1UL;
   tf->codes[22544] = 0x000077d9ac195c76UL;
   tf->codes[22545] = 0x000081810818da7aUL;
   tf->codes[22546] = 0x00008db4c5749f32UL;
   tf->codes[22547] = 0x000096696eb133bdUL;
   tf->codes[22548] = 0x000096829825ae63UL;
   tf->codes[22549] = 0x000096946fb97069UL;
   tf->codes[22550] = 0x000098c6b0f6d5ebUL;
   tf->codes[22551] = 0x0000a6d463e94d1bUL;
   tf->codes[22552] = 0x0000aa1ccc821a5dUL;
   tf->codes[22553] = 0x0000ab707c26921eUL;
   tf->codes[22554] = 0x0000b12ba7891fe4UL;
   tf->codes[22555] = 0x0000b6f033d39a37UL;
   tf->codes[22556] = 0x0000bb12d567e79bUL;
   tf->codes[22557] = 0x0000bd292e7c8d3bUL;
   tf->codes[22558] = 0x0000c98234e8fe62UL;
   tf->codes[22559] = 0x0000c99b5e5d7908UL;
   tf->codes[22560] = 0x0000ca9ae069a599UL;
   tf->codes[22561] = 0x0000cdca94ac03bfUL;
   tf->codes[22562] = 0x0000cf90a3a7c044UL;
   tf->codes[22563] = 0x0000cfc62a630656UL;
   tf->codes[22564] = 0x0000d6272cd0eb05UL;
   tf->codes[22565] = 0x0000dc067c790861UL;
   tf->codes[22566] = 0x0000ea99160397aaUL;
   tf->codes[22567] = 0x0000efcee5b001cdUL;
   tf->codes[22568] = 0x00000c3886a6a55bUL;
   tf->codes[22569] = 0x000012230baedd6cUL;
   tf->codes[22570] = 0x00001da079c5abd3UL;
   tf->codes[22571] = 0x00002305dda6c606UL;
   tf->codes[22572] = 0x0000253fe5e2efb2UL;
   tf->codes[22573] = 0x000025d3703c790bUL;
   tf->codes[22574] = 0x00002c130d191360UL;
   tf->codes[22575] = 0x00002c4a2dbd81d5UL;
   tf->codes[22576] = 0x00002c56fd06c4edUL;
   tf->codes[22577] = 0x0000340aff6c100eUL;
   tf->codes[22578] = 0x0000390a23921746UL;
   tf->codes[22579] = 0x0000406a6d7d22c1UL;
   tf->codes[22580] = 0x00005ea4ddb191ffUL;
   tf->codes[22581] = 0x00005ec8c7681bd0UL;
   tf->codes[22582] = 0x000063738366d213UL;
   tf->codes[22583] = 0x0000637fdd9209a1UL;
   tf->codes[22584] = 0x00006ca3ece297efUL;
   tf->codes[22585] = 0x00006e3942de878bUL;
   tf->codes[22586] = 0x00006e6185327efbUL;
   tf->codes[22587] = 0x00007c6820d34350UL;
   tf->codes[22588] = 0x00008311e0ea52b5UL;
   tf->codes[22589] = 0x00008517c1c558edUL;
   tf->codes[22590] = 0x0000856f5dbefaa8UL;
   tf->codes[22591] = 0x00008842e2db43afUL;
   tf->codes[22592] = 0x000091897c883930UL;
   tf->codes[22593] = 0x000091f70e2404cbUL;
   tf->codes[22594] = 0x000093eb8c895487UL;
   tf->codes[22595] = 0x0000a0b299af9cd3UL;
   tf->codes[22596] = 0x0000a3a3664ec85aUL;
   tf->codes[22597] = 0x0000a74a47a3e46dUL;
   tf->codes[22598] = 0x0000a940256356c7UL;
   tf->codes[22599] = 0x0000afb758026b1bUL;
   tf->codes[22600] = 0x0000b279efc70930UL;
   tf->codes[22601] = 0x0000b5dc6c10682cUL;
   tf->codes[22602] = 0x0000cc96c6b1a9f8UL;
   tf->codes[22603] = 0x0000ce15024052dbUL;
   tf->codes[22604] = 0x0000cf2ab47daf11UL;
   tf->codes[22605] = 0x0000cf3fbfe3c1ddUL;
   tf->codes[22606] = 0x0000de69179a2b45UL;
   tf->codes[22607] = 0x0000e55617f1dae8UL;
   tf->codes[22608] = 0x0000f64c95f5b3b0UL;
   tf->codes[22609] = 0x0000f91978de5566UL;
   tf->codes[22610] = 0x000000edf698d3cdUL;
   tf->codes[22611] = 0x000005774d063fb6UL;
   tf->codes[22612] = 0x00000936e2b1cae5UL;
   tf->codes[22613] = 0x0000182e220e44c6UL;
   tf->codes[22614] = 0x000018b4dd1e8b07UL;
   tf->codes[22615] = 0x000019a162cbd8b9UL;
   tf->codes[22616] = 0x0000299f761537cbUL;
   tf->codes[22617] = 0x00002bc4385c48e6UL;
   tf->codes[22618] = 0x00002d6e99be4b4eUL;
   tf->codes[22619] = 0x0000329a1e46b1d0UL;
   tf->codes[22620] = 0x00003a24446edd1eUL;
   tf->codes[22621] = 0x00003ebcb3bbc5d1UL;
   tf->codes[22622] = 0x00004672500a3955UL;
   tf->codes[22623] = 0x00004da16bd76c5dUL;
   tf->codes[22624] = 0x0000563b1727581aUL;
   tf->codes[22625] = 0x000058e77ebac68aUL;
   tf->codes[22626] = 0x00005f0665b327d4UL;
   tf->codes[22627] = 0x00006a56140d7453UL;
   tf->codes[22628] = 0x00006da0c63c7b47UL;
   tf->codes[22629] = 0x00006eb3f4549806UL;
   tf->codes[22630] = 0x0000773b1863b06eUL;
   tf->codes[22631] = 0x00007bc4e3ef27e1UL;
   tf->codes[22632] = 0x00007ebffbb25709UL;
   tf->codes[22633] = 0x00008015f4ed087cUL;
   tf->codes[22634] = 0x000081925c038337UL;
   tf->codes[22635] = 0x0000881782b6f77cUL;
   tf->codes[22636] = 0x000089653fd4d93bUL;
   tf->codes[22637] = 0x00009de59239f15bUL;
   tf->codes[22638] = 0x0000a25ee58bc966UL;
   tf->codes[22639] = 0x0000b33179d9185dUL;
   tf->codes[22640] = 0x0000b68084a58cf0UL;
   tf->codes[22641] = 0x0000b9a3a42dadc3UL;
   tf->codes[22642] = 0x0000c6185833d907UL;
   tf->codes[22643] = 0x0000c7e78d887c54UL;
   tf->codes[22644] = 0x0000df0aac0a1092UL;
   tf->codes[22645] = 0x0000df7ea54a7db9UL;
   tf->codes[22646] = 0x0000dffd243df446UL;
   tf->codes[22647] = 0x0000e679249881c3UL;
   tf->codes[22648] = 0x0000e9ff157a5f06UL;
   tf->codes[22649] = 0x0000eec3357c95b4UL;
   tf->codes[22650] = 0x0000f1d7ebd24b0cUL;
   tf->codes[22651] = 0x0000fcef54bd0c3dUL;
   tf->codes[22652] = 0x000007098531da8fUL;
   tf->codes[22653] = 0x00000f14e901c1a6UL;
   tf->codes[22654] = 0x0000144b2dcc3753UL;
   tf->codes[22655] = 0x0000186dcf6084b7UL;
   tf->codes[22656] = 0x000021a082728445UL;
   tf->codes[22657] = 0x00002425575f0c94UL;
   tf->codes[22658] = 0x000025ffc213ca96UL;
   tf->codes[22659] = 0x0000270c888745c9UL;
   tf->codes[22660] = 0x000028189f4dafadUL;
   tf->codes[22661] = 0x00002c2dfc7aae6fUL;
   tf->codes[22662] = 0x00002e2ed50b35b9UL;
   tf->codes[22663] = 0x0000331962e935afUL;
   tf->codes[22664] = 0x0000372265eafce3UL;
   tf->codes[22665] = 0x000038894c7d5948UL;
   tf->codes[22666] = 0x000049d2d34e6067UL;
   tf->codes[22667] = 0x00005207291f503dUL;
   tf->codes[22668] = 0x00006119a0f778b1UL;
   tf->codes[22669] = 0x000063fe136b6caaUL;
   tf->codes[22670] = 0x00006ab60225e1c5UL;
   tf->codes[22671] = 0x00006c27e389531aUL;
   tf->codes[22672] = 0x000070f6142087a4UL;
   tf->codes[22673] = 0x0000825346fd7ef1UL;
   tf->codes[22674] = 0x0000836724c2acffUL;
   tf->codes[22675] = 0x000086d87f5c8300UL;
   tf->codes[22676] = 0x000089f6d1292aaaUL;
   tf->codes[22677] = 0x00008a52161328b5UL;
   tf->codes[22678] = 0x00008d117a057604UL;
   tf->codes[22679] = 0x000092662b1deb0aUL;
   tf->codes[22680] = 0x000098e942ca2b62UL;
   tf->codes[22681] = 0x0000a2a1170348ceUL;
   tf->codes[22682] = 0x0000a8af10a3ff26UL;
   tf->codes[22683] = 0x0000ab47570d71deUL;
   tf->codes[22684] = 0x0000af13bc024025UL;
   tf->codes[22685] = 0x0000b8e5695ce986UL;
   tf->codes[22686] = 0x0000bf236c505b78UL;
   tf->codes[22687] = 0x0000bf32fa4de3ccUL;
   tf->codes[22688] = 0x0000c2c1274c90c3UL;
   tf->codes[22689] = 0x0000d3d5d70f631fUL;
   tf->codes[22690] = 0x0000de5dd3af02d1UL;
   tf->codes[22691] = 0x0000eb690b52026fUL;
   tf->codes[22692] = 0x0000f1cabd6cf86dUL;
   tf->codes[22693] = 0x0000f5ecaf543482UL;
   tf->codes[22694] = 0x0000f60563aaa39eUL;
   tf->codes[22695] = 0x000002b55663a531UL;
   tf->codes[22696] = 0x000002f22effa3e3UL;
   tf->codes[22697] = 0x00000b4d67ca688bUL;
   tf->codes[22698] = 0x000018f9a8bd45e9UL;
   tf->codes[22699] = 0x0000190e799452f0UL;
   tf->codes[22700] = 0x000021517326b406UL;
   tf->codes[22701] = 0x00002706e691b18fUL;
   tf->codes[22702] = 0x000035cf7bf59274UL;
   tf->codes[22703] = 0x000042ef0f51938fUL;
   tf->codes[22704] = 0x00004f0ac803fa7aUL;
   tf->codes[22705] = 0x000053e6027377e1UL;
   tf->codes[22706] = 0x0000546b5e299b84UL;
   tf->codes[22707] = 0x000055367e459edcUL;
   tf->codes[22708] = 0x00005c4fa470a804UL;
   tf->codes[22709] = 0x00005daf39224bc9UL;
   tf->codes[22710] = 0x00005f6d46903e5fUL;
   tf->codes[22711] = 0x000060f592b3e51eUL;
   tf->codes[22712] = 0x00006133901b00a9UL;
   tf->codes[22713] = 0x00006ba8905bc17cUL;
   tf->codes[22714] = 0x00006d2706797024UL;
   tf->codes[22715] = 0x00006e0647bf6f34UL;
   tf->codes[22716] = 0x0000706e84d62652UL;
   tf->codes[22717] = 0x0000738968417771UL;
   tf->codes[22718] = 0x00007d50ca781d31UL;
   tf->codes[22719] = 0x00007db535bb0204UL;
   tf->codes[22720] = 0x000085537d0d290aUL;
   tf->codes[22721] = 0x00008a313ba1e5e8UL;
   tf->codes[22722] = 0x00008afcd0dbf4caUL;
   tf->codes[22723] = 0x00008be5387adaa2UL;
   tf->codes[22724] = 0x0000983e7976518eUL;
   tf->codes[22725] = 0x0000992a8a0593b6UL;
   tf->codes[22726] = 0x00009a89e42831b6UL;
   tf->codes[22727] = 0x00009e77741f4492UL;
   tf->codes[22728] = 0x00009e8f3e399c9aUL;
   tf->codes[22729] = 0x0000a0c0953aeb08UL;
   tf->codes[22730] = 0x0000a9f93ad38098UL;
   tf->codes[22731] = 0x0000b1489766e121UL;
   tf->codes[22732] = 0x0000b6f7a32d3d1eUL;
   tf->codes[22733] = 0x0000bd6d0154234aUL;
   tf->codes[22734] = 0x0000bed50cb19c88UL;
   tf->codes[22735] = 0x0000bfb18f43565cUL;
   tf->codes[22736] = 0x0000cb4359132640UL;
   tf->codes[22737] = 0x0000cbdc60d53a11UL;
   tf->codes[22738] = 0x0000cc6948fb1c19UL;
   tf->codes[22739] = 0x0000d211b28dd0c5UL;
   tf->codes[22740] = 0x0000d528b279bfcfUL;
   tf->codes[22741] = 0x0000de53d91c00f8UL;
   tf->codes[22742] = 0x0000e6fc9d4b697fUL;
   tf->codes[22743] = 0x0000e9ca2fe11c84UL;
   tf->codes[22744] = 0x0000efcc7f03ac9dUL;
   tf->codes[22745] = 0x0000f3dd0e753236UL;
   tf->codes[22746] = 0x00000ff5b5a5db5aUL;
   tf->codes[22747] = 0x000017115ff623f9UL;
   tf->codes[22748] = 0x000017de19fb4fb4UL;
   tf->codes[22749] = 0x00001cb02e11e653UL;
   tf->codes[22750] = 0x00001d9561de7b65UL;
   tf->codes[22751] = 0x00002338fdb5b6e8UL;
   tf->codes[22752] = 0x000028748559b148UL;
   tf->codes[22753] = 0x00003183c3d3328fUL;
   tf->codes[22754] = 0x00003712c96266d0UL;
   tf->codes[22755] = 0x000041548c7e1b43UL;
   tf->codes[22756] = 0x00004354404385b4UL;
   tf->codes[22757] = 0x000043e7ca9d0f0dUL;
   tf->codes[22758] = 0x000053d5a03bd47cUL;
   tf->codes[22759] = 0x0000567d3a13c9c3UL;
   tf->codes[22760] = 0x000058b916c82197UL;
   tf->codes[22761] = 0x000064ebaf58c976UL;
   tf->codes[22762] = 0x000068e474aff707UL;
   tf->codes[22763] = 0x0000760d2e64deeaUL;
   tf->codes[22764] = 0x000077969f53a282UL;
   tf->codes[22765] = 0x000077f30908bd66UL;
   tf->codes[22766] = 0x00007d6c8e13d351UL;
   tf->codes[22767] = 0x000088ef79932c30UL;
   tf->codes[22768] = 0x00008c2caccbdebdUL;
   tf->codes[22769] = 0x00009c8c3214d7a1UL;
   tf->codes[22770] = 0x0000a2a944950ac3UL;
   tf->codes[22771] = 0x0000a2f4c0f27ab5UL;
   tf->codes[22772] = 0x0000a572f3ab5bb3UL;
   tf->codes[22773] = 0x0000a6e3b043b02fUL;
   tf->codes[22774] = 0x0000ac3a35d4535dUL;
   tf->codes[22775] = 0x0000b685cef5ffe7UL;
   tf->codes[22776] = 0x0000c898dbf9e1fbUL;
   tf->codes[22777] = 0x0000cdccd72e1df6UL;
   tf->codes[22778] = 0x0000d0ab1c8c7628UL;
   tf->codes[22779] = 0x0000d56984971c99UL;
   tf->codes[22780] = 0x0000d9cbbd7badebUL;
   tf->codes[22781] = 0x0000db5a7143f636UL;
   tf->codes[22782] = 0x0000fe08f1f0b8ccUL;
   tf->codes[22783] = 0x00001a399dcabfbdUL;
   tf->codes[22784] = 0x0000248a04a7e570UL;
   tf->codes[22785] = 0x00002e1a463a1cbbUL;
   tf->codes[22786] = 0x0000355be9482318UL;
   tf->codes[22787] = 0x0000434abace8f65UL;
   tf->codes[22788] = 0x000044ceae54c885UL;
   tf->codes[22789] = 0x0000528e60c4904cUL;
   tf->codes[22790] = 0x000053334d93d021UL;
   tf->codes[22791] = 0x00005c55fd8a3bd1UL;
   tf->codes[22792] = 0x00005fabe5195d7aUL;
   tf->codes[22793] = 0x000060f424ceb4c1UL;
   tf->codes[22794] = 0x00006a1032917920UL;
   tf->codes[22795] = 0x00007715b23ce881UL;
   tf->codes[22796] = 0x000082c86c7ff735UL;
   tf->codes[22797] = 0x00008b1ffc5a5f8dUL;
   tf->codes[22798] = 0x00008c9d4dacf15cUL;
   tf->codes[22799] = 0x00008feedc9ea566UL;
   tf->codes[22800] = 0x0000931654c433d8UL;
   tf->codes[22801] = 0x0000941093f6dbb6UL;
   tf->codes[22802] = 0x00009534e9f5a92cUL;
   tf->codes[22803] = 0x000096fbe32d7cc5UL;
   tf->codes[22804] = 0x00009b5d31d5f703UL;
   tf->codes[22805] = 0x00009e7bf8c0aa37UL;
   tf->codes[22806] = 0x0000a1869e8161b3UL;
   tf->codes[22807] = 0x0000aea840e496bbUL;
   tf->codes[22808] = 0x0000b069bcb3dfdcUL;
   tf->codes[22809] = 0x0000b73ca95afdc5UL;
   tf->codes[22810] = 0x0000b7638c54d297UL;
   tf->codes[22811] = 0x0000b8d4be0b329dUL;
   tf->codes[22812] = 0x0000bb54158f3074UL;
   tf->codes[22813] = 0x0000caf84348b419UL;
   tf->codes[22814] = 0x0000ce1bd7eee076UL;
   tf->codes[22815] = 0x0000d0abe23b837aUL;
   tf->codes[22816] = 0x0000d556d8c93f82UL;
   tf->codes[22817] = 0x0000db3f8959496bUL;
   tf->codes[22818] = 0x000004b8f51f5ffbUL;
   tf->codes[22819] = 0x000014fa83386510UL;
   tf->codes[22820] = 0x0000180aa661a704UL;
   tf->codes[22821] = 0x000020a5015ea410UL;
   tf->codes[22822] = 0x000023bbc6bb8d55UL;
   tf->codes[22823] = 0x00002de809532372UL;
   tf->codes[22824] = 0x00003d704ee3e735UL;
   tf->codes[22825] = 0x00003e12b78de793UL;
   tf->codes[22826] = 0x0000444ac7fac383UL;
   tf->codes[22827] = 0x000046586fd48de5UL;
   tf->codes[22828] = 0x00004b17c21b4b6aUL;
   tf->codes[22829] = 0x00004ce104e958b5UL;
   tf->codes[22830] = 0x00004e0e81410cf3UL;
   tf->codes[22831] = 0x0000523665aedf0aUL;
   tf->codes[22832] = 0x0000543aaca0bcdfUL;
   tf->codes[22833] = 0x00005a0ddcaca872UL;
   tf->codes[22834] = 0x00005bb8037fa515UL;
   tf->codes[22835] = 0x0000642fd4203aeeUL;
   tf->codes[22836] = 0x0000682983b37f93UL;
   tf->codes[22837] = 0x00006d8f9741ab15UL;
   tf->codes[22838] = 0x00007d9de835a3caUL;
   tf->codes[22839] = 0x00008005759f4999UL;
   tf->codes[22840] = 0x00008678c4befbd8UL;
   tf->codes[22841] = 0x00008925a17075d2UL;
   tf->codes[22842] = 0x00009562100715c8UL;
   tf->codes[22843] = 0x000098eccea46c34UL;
   tf->codes[22844] = 0x00009dbb7459ac48UL;
   tf->codes[22845] = 0x0000a3720c8fc6aaUL;
   tf->codes[22846] = 0x0000b2f3ea7be8e1UL;
   tf->codes[22847] = 0x0000b35ef7f27505UL;
   tf->codes[22848] = 0x0000b90bf4b19d15UL;
   tf->codes[22849] = 0x0000ba2bf212fcecUL;
   tf->codes[22850] = 0x0000be07aa764dc2UL;
   tf->codes[22851] = 0x0000cd12d06dbd96UL;
   tf->codes[22852] = 0x0000d252b0af2595UL;
   tf->codes[22853] = 0x0000da5479081a5aUL;
   tf->codes[22854] = 0x0000e43036f7c197UL;
   tf->codes[22855] = 0x0000ea0625b7f266UL;
   tf->codes[22856] = 0x0000eeb8a8b56cd3UL;
   tf->codes[22857] = 0x0000fe27c4d1b5f0UL;
   tf->codes[22858] = 0x00000c8d88dbda65UL;
   tf->codes[22859] = 0x0000101acb9e7048UL;
   tf->codes[22860] = 0x0000150bc12111caUL;
   tf->codes[22861] = 0x00001a1271b6d767UL;
   tf->codes[22862] = 0x00001b09b7a63444UL;
   tf->codes[22863] = 0x0000421911dd658eUL;
   tf->codes[22864] = 0x00004b5fab8a5b0fUL;
   tf->codes[22865] = 0x00005991bd51679aUL;
   tf->codes[22866] = 0x000064b03d8ddba6UL;
   tf->codes[22867] = 0x000076cbfbcc98f8UL;
   tf->codes[22868] = 0x00007a225879c62bUL;
   tf->codes[22869] = 0x00007ea497957f39UL;
   tf->codes[22870] = 0x000086531c923fe2UL;
   tf->codes[22871] = 0x000087914bb2994dUL;
   tf->codes[22872] = 0x00008af2ddbfe135UL;
   tf->codes[22873] = 0x00008b63689ef7d1UL;
   tf->codes[22874] = 0x00008c4fee4c4583UL;
   tf->codes[22875] = 0x00008d5b8ff4a3ddUL;
   tf->codes[22876] = 0x0000968b84525e2fUL;
   tf->codes[22877] = 0x00009c7dd0595a6aUL;
   tf->codes[22878] = 0x00009ea934d412d6UL;
   tf->codes[22879] = 0x0000a6b9665f7316UL;
   tf->codes[22880] = 0x0000a9922e5540d0UL;
   tf->codes[22881] = 0x0000b69cf0da34e4UL;
   tf->codes[22882] = 0x0000b95159fb6d43UL;
   tf->codes[22883] = 0x0000ba539abbdf10UL;
   tf->codes[22884] = 0x0000c4cf3d304734UL;
   tf->codes[22885] = 0x0000d8d2aa8b112aUL;
   tf->codes[22886] = 0x0000dc055810ba51UL;
   tf->codes[22887] = 0x0000ddabd5f35aa4UL;
   tf->codes[22888] = 0x0000dfd9be935287UL;
   tf->codes[22889] = 0x0000f956b0f93268UL;
   tf->codes[22890] = 0x0000febb652d3b4cUL;
   tf->codes[22891] = 0x000008bbbc807da9UL;
   tf->codes[22892] = 0x00000b3fe1bff4a9UL;
   tf->codes[22893] = 0x00000c38fc277faeUL;
   tf->codes[22894] = 0x00001423aa132dbaUL;
   tf->codes[22895] = 0x000014fe92bbbf2bUL;
   tf->codes[22896] = 0x00002aa1a1367c5eUL;
   tf->codes[22897] = 0x00002bc8f07894d5UL;
   tf->codes[22898] = 0x00003c36def3f934UL;
   tf->codes[22899] = 0x00003d495d5f04a4UL;
   tf->codes[22900] = 0x0000432872781c3bUL;
   tf->codes[22901] = 0x00004b4cffbc7df8UL;
   tf->codes[22902] = 0x000054fc22bac026UL;
   tf->codes[22903] = 0x000059277589e8c8UL;
   tf->codes[22904] = 0x000059e58bcda343UL;
   tf->codes[22905] = 0x00005f40a48ab9d5UL;
   tf->codes[22906] = 0x00005fe347c3bff8UL;
   tf->codes[22907] = 0x000069c114ba9b22UL;
   tf->codes[22908] = 0x00007b70db46b53cUL;
   tf->codes[22909] = 0x00007d634aa4d10bUL;
   tf->codes[22910] = 0x00007fad908b945aUL;
   tf->codes[22911] = 0x0000815c851a0a26UL;
   tf->codes[22912] = 0x0000830ac9fb6ea3UL;
   tf->codes[22913] = 0x00008dcb46999f68UL;
   tf->codes[22914] = 0x0000903ef39f7700UL;
   tf->codes[22915] = 0x00009114996e83beUL;
   tf->codes[22916] = 0x000097e1938f0ba5UL;
   tf->codes[22917] = 0x00009c9af34f3328UL;
   tf->codes[22918] = 0x00009d71bde95cbfUL;
   tf->codes[22919] = 0x0000a40d14ce00a9UL;
   tf->codes[22920] = 0x0000ad35f1da0820UL;
   tf->codes[22921] = 0x0000ade31ac617a9UL;
   tf->codes[22922] = 0x0000bab05501fbbcUL;
   tf->codes[22923] = 0x0000c2009bd17359UL;
   tf->codes[22924] = 0x0000c421400a1c9aUL;
   tf->codes[22925] = 0x0000ca126745fbfcUL;
   tf->codes[22926] = 0x0000d55ee1cdf7b5UL;
   tf->codes[22927] = 0x0000d68b395a8f1aUL;
   tf->codes[22928] = 0x0000db2f8db4a3d1UL;
   tf->codes[22929] = 0x0000db533cdc27ddUL;
   tf->codes[22930] = 0x0000e8f14f2b9f85UL;
   tf->codes[22931] = 0x0000ebb83f8dab39UL;
   tf->codes[22932] = 0x0000ec41f3e13c7bUL;
   tf