/*
 * Copyright (C) 2011 Tim Mayberry <mojofunk@gmail.com>
 * Copyright (C) 2013 Paul Davis <paul@linuxaudiosystems.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <stdint.h>

namespace PBD {

typedef uint64_t rlimit_t;

enum ResourceType {
	OpenFiles
};

struct ResourceLimit
{
	rlimit_t current_limit;
	rlimit_t max_limit;
};

/**
 * @return true on success, false on error
 */
bool
get_resource_limit (ResourceType resource, ResourceLimit& limit);

/**
 * @return true on success, false on error
 */
bool
set_resource_limit (ResourceType resource, const ResourceLimit& limit);


} // namespace PBD
