/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.ant.taskdefs;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class HeaderInfo {
    public final File file;
    public final List years;
    public final int lastLine;
    public final boolean hasLicense;
    public static final String TOP = "/* *******************************************************************";
    public static final String PARC = " *               2002 Palo Alto Research Center, Incorporated (PARC).";
    public static final String PARC_ONLY = " * Copyright (c) 2002 Palo Alto Research Center, Incorporated (PARC).";
    public static final String XEROX_PREFIX = " * Copyright (c) ";
    public static final String XEROX_SUFFIX = " Xerox Corporation";

    public HeaderInfo(File file, int lastLine, List<String> years, boolean hasLicense) {
        this.lastLine = lastLine;
        this.file = file;
        this.hasLicense = hasLicense;
        ArrayList<String> newYears = new ArrayList<String>();
        newYears.addAll(years);
        Collections.sort(newYears);
        this.years = Collections.unmodifiableList(newYears);
        if (null == file || !file.canWrite()) {
            throw new IllegalArgumentException("bad file: " + this);
        }
        if (!hasLicense) {
            if (0 > lastLine || 65 < lastLine) {
                throw new IllegalArgumentException("bad last line: " + this);
            }
        } else {
            if (null == years || 1 > years.size()) {
                throw new IllegalArgumentException("no years: " + this);
            }
            if (20 > lastLine || 65 < lastLine) {
                throw new IllegalArgumentException("bad last line: " + this);
            }
        }
    }

    public String toString() {
        return this.file.getPath() + ":" + this.lastLine + " " + this.years;
    }

    public void writeHeader(PrintWriter writer) {
        if (!this.hasLicense) {
            writer.println(TOP);
            writer.println(PARC_ONLY);
            this.writeRest(writer);
        } else {
            int size = this.years.size();
            if (1 > size) {
                throw new Error("no years found in " + this.toString());
            }
            String first = (String)this.years.get(0);
            String last = (String)this.years.get(size - 1);
            boolean lastIs2002 = "2002".equals(last);
            String xlast = last;
            if (lastIs2002 && first.equals(xlast = (String)(size > 1 ? this.years.get(size - 2) : null)) && !"2001".equals(xlast)) {
                xlast = "2001";
            }
            String xyears = first + "-" + xlast;
            if (first.equals(last)) {
                xyears = first;
            }
            writer.println(TOP);
            if (!lastIs2002) {
                writer.println(XEROX_PREFIX + xyears + XEROX_SUFFIX + ". ");
            } else if (size == 1) {
                writer.println(PARC_ONLY);
            } else {
                writer.println(XEROX_PREFIX + xyears + XEROX_SUFFIX + ", ");
                writer.println(PARC);
            }
            this.writeRest(writer);
        }
    }

    void writeRest(PrintWriter writer) {
        writer.println(" * All rights reserved. ");
        writer.println(" * This program and the accompanying materials are made available ");
        writer.println(" * under the terms of the Eclipse Public License v1.0 ");
        writer.println(" * which accompanies this distribution and is available at ");
        writer.println(" * http://www.eclipse.org/legal/epl-v10.html ");
        writer.println(" *  ");
        writer.println(" * Contributors: ");
        writer.println(" *     Xerox/PARC     initial implementation ");
        writer.println(" * ******************************************************************/");
        writer.println("");
    }
}

