# -*- coding: latin -*-

# Balazar
# Copyright (C) 2003 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""A random name generator for heroic-fantasy characters,
with French accentued character .
"""

import random
import balazar.globdef    as globdef

#TABLE1 = ["a", "a", "b", "b", "c", "c", "d", "d", "e", "e", "f", "f", "g", "h", "i", "i", "j", "k", "l", "l", "m", "n", "o", "o", "p", "p", "q", "r", "r", "s", "s", "t", "t", "u", "v", "w", "x", "y", "z", "ou", "an", "en", "in", "on"]
#TABLE2 = ["b", "b", "c", "c", "d", "d", "f", "f", "g", "h", "j", "k", "l", "l", "m", "n", "p", "p", "q", "r", "r", "s", "s", "t", "t", "v", "w", "x", "y", "z"]
#TABLE3 = ["a", "a", "e", "e", "h", "i", "i", "l", "o", "o", "r", "u", "ou", "an", "en", "in", "on"]

#TABLE2 = ["b", "b", "c", "c", "d", "d", "f", "f", "g", "h", "j", "k", "l", "m", "n", "p", "p", "q", "r", "s", "s", "t", "t", "v", "w", "x", "y", "z"]
#TABLE3 = ["a", "a", "e", "e", "h", "i", "i", "l", "o", "o", "r", "u", "ou", "an", "en", "in", "on"]
#TABLE1 = TABLE2 + TABLE3

#TABLE2 = ["b", "b", "c", "c", "d", "d", "f", "f", "g", "h", "j", "k", "l", "m", "n", "n", "p", "p", "q", "r", "s", "s", "t", "t", "v", "w", "x", "y", "z"]
#TABLE3 = ["a", "a", "e", "e", "e", "i", "i", "l", "o", "o", "r", "u"]
#TABLE1 = TABLE2 + TABLE3

TABLE2M = ["b", "b", "c", "c", "d", "d", "f", "g", "h", "j", "k", "l", "m", "n", "p", "p", "q", "r", "s", "s", "t", "t", "v", "w", "x", "y", "z"]
TABLE3M = ["a", "e", "e", "e", "i", "i", "l", "o", "au", "o", "r", "u"]
TABLE4M = ["", "", "e", "o"]
TABLE1M = TABLE2M + TABLE3M

TABLE2F = ["b", "b", "c", "c", "d", "f", "f", "g", "h", "j", "l", "m", "n", "n", "p", "p", "q", "r", "s", "s", "t", "t", "v", "w", "x", "y", "z"]
TABLE3F = ["a", "a", "a", "e", "e", "i", "i", "l", "o", "u"]
TABLE4F = ["e", "a"]
TABLE1F = TABLE2F + TABLE3F

VOYELLES = ["a", "e", "i", "o", "u"]

DOUBLES = ["f", "l", "m", "n", "p", "r", "s", "t", "z"]

def randomname(sexe, minlength = 3, maxlength = 6):
  if sexe == "m":
    TABLE1 = TABLE1M
    TABLE2 = TABLE2M
    TABLE3 = TABLE3M
  else:
    TABLE1 = TABLE1F
    TABLE2 = TABLE2F
    TABLE3 = TABLE3F
    
  name = random.choice(TABLE1)
  
  for i in range(random.randint(minlength, maxlength) - 1):
    if name[-1] in VOYELLES:
      name += random.choice(TABLE2)
    else:
      if name[-1] == "q": name += "u"
      if (len(name) < 2) or (name[-2] in VOYELLES):
        name += random.choice(TABLE3)
      else:
        name += random.choice(VOYELLES)
        
  name = name.title()
  
  if not name[-1] in VOYELLES:
    if sexe == "m":
      name += random.choice(TABLE4M)
    else:
      if (name[-1] in DOUBLES) and (name[-2] in VOYELLES): name += name[-1]
      name += random.choice(TABLE4F)
  else:
    if sexe == "m":
      if name[-1] == "a": name = name[:-1] + "o"
    else:
      if name[-1] == "o": name = name[:-1] + "a"
    
    
  l = range(1, len(name) - 2)
  l.reverse()
  for i in l:
    if name[i] == "e":
      if not ((not name[i + 1] in VOYELLES) and (name[i + 1] == name[i + 2])):
        if name[i + 2] == "e":
          name = name[:i] + "" + name[i + 1:]
        else:
          name = name[:i] + "" + name[i + 1:]
          
  return name
  
if __name__ == "__main__":
  for i in range(10):
    r = randomname("m")
    if globdef.DEBUG: print r
  if globdef.DEBUG: print
  for i in range(10):
    r = randomname("f")
    if globdef.DEBUG: print r
