#line 2 "beancount/parser/lexer.c"

/* Includes. */
#include <math.h>
#include <stdlib.h>

#include "parser.h"
#include "grammar.h"

/* Build and accumulate an error on the builder object. */
void build_lexer_error(const char* string, size_t length);

/* Build and accumulate an error on the builder object using the current
 * exception state. */
void build_lexer_error_from_exception(void);

/* Callback call site with error handling. */
#define BUILD_LEX(method_name, format, ...)                                             \
    yylval->pyobj = PyObject_CallMethod(builder, method_name, format, __VA_ARGS__);     \
    /* Handle a Python exception raised by the handler {3cfb2739349a} */                \
    if (yylval->pyobj == NULL) {                                                        \
       build_lexer_error_from_exception();                                              \
       return LEX_ERROR;                                                                \
    }                                                                                   \
    /* Lexer builder methods should never return None, check for it. */                 \
    else if (yylval->pyobj == Py_None) {                                                \
        Py_DECREF(Py_None);                                                             \
        build_lexer_error("Unexpected None result from lexer", 34);                     \
        return LEX_ERROR;                                                               \
    }

/* Initialization/finalization methods. These are separate from the yylex_init()
 * and yylex_destroy() and they call them. */
void yylex_initialize(const char* filename, const char* encoding);
void yylex_finalize(void);

/* Global declarations; defined below. */
extern int yy_eof_times;
extern const char* yy_filename;
extern int yycolumn;
extern const char* yy_encoding;

/* String buffer statics. */
extern size_t strbuf_size; /* Current buffer size (not including final nul). */
extern char* strbuf;       /* Current buffer head. */
extern char* strbuf_end;   /* Current buffer sentinel (points to the final nul). */
extern char* strbuf_ptr;   /* Current insertion point in buffer. */
void strbuf_realloc(size_t num_new_chars);

/* Handle detecting the beginning of line. */
extern int yy_line_tokens; /* Number of tokens since the bol. */

#define YY_USER_ACTION  {                               \
    yy_line_tokens++;                                   \
    yylloc->first_line = yylloc->last_line = yylineno;  \
    yylloc->first_column = yycolumn;                    \
    yylloc->last_column = yycolumn+yyleng-1;            \
    yycolumn += yyleng;                                 \
  }

/* Skip the rest of the input line. */
int yy_skip_line(void);

/* Utility functions. */
int strtonl(const char* buf, size_t nchars);

/* Append characters to the static string buffer and verify. */
#define SAFE_COPY_CHAR(value)                    \
	if (strbuf_ptr >= strbuf_end) {         \
            strbuf_realloc(1);                  \
	}                                       \
        *strbuf_ptr++ = value;

#line 75 "beancount/parser/lexer.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yyget_lval
#define yyget_lval_ALREADY_DEFINED
#else
#define yyget_lval yyget_lval
#endif

#ifdef yyset_lval
#define yyset_lval_ALREADY_DEFINED
#else
#define yyset_lval yyset_lval
#endif

#ifdef yyget_lloc
#define yyget_lloc_ALREADY_DEFINED
#else
#define yyget_lloc yyget_lloc
#endif

#ifdef yyset_lloc
#define yyset_lloc_ALREADY_DEFINED
#else
#define yyset_lloc yyset_lloc
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE yylex.
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-yylineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < yyleng; ++yyl )\
                    if ( yytext[yyl] == '\n' )\
                        --yylineno;\
            }while(0)
    #define YY_LINENO_REWIND_TO(dst) \
            do {\
                const char *p;\
                for ( p = yy_cp-1; p >= (dst); --p)\
                    if ( *p == '\n' )\
                        --yylineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define yywrap() (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;
int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 61
#define YY_END_OF_BUFFER 62
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[344] =
    {   0,
        0,    0,    0,    0,    0,    0,   62,   59,    2,    1,
       21,   46,   18,   16,   17,   19,   12,   10,   13,   14,
       55,   15,   20,    5,   59,   21,   59,   21,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
        8,    3,    9,   11,   59,   59,   59,   59,   59,   59,
       59,   59,   60,   61,   54,   47,   61,    2,   56,    0,
       55,   55,   20,   20,    4,    0,    0,   45,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   45,   45,
       57,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    6,    7,

        0,    0,    0,    0,    0,    0,    0,    0,   60,   54,
       53,   51,   52,   48,   50,   49,   55,   55,   55,    0,
       45,    0,   45,   44,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   45,
       45,   58,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   27,    0,    0,    0,    0,    0,   22,    0,
        0,    0,   55,    0,   45,    0,   45,   44,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   45,   41,    0,    0,
        0,    0,    0,    0,    0,   32,   24,    0,    0,    0,

        0,    0,    0,    0,    0,    0,   55,    0,   45,    0,
       45,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   42,    0,   25,    0,    0,    0,   28,    0,
        0,    0,    0,    0,   31,    0,    0,   29,    0,    0,
       45,    0,   45,    0,    0,    0,   44,    0,    0,   30,
        0,    0,   38,   39,    0,   35,    0,    0,    0,    0,
       45,    0,   45,   44,   23,    0,    0,   40,   37,    0,
       34,   43,    0,   45,    0,   45,    0,   33,   36,    0,
       45,    0,   45,   26,    0,   45,    0,   45,    0,   45,
        0,   45,    0,   45,    0,   45,    0,   45,    0,   45,

        0,   45,    0,   45,    0,   45,    0,   45,    0,   45,
        0,   45,    0,   45,    0,   45,    0,   45,    0,   45,
        0,   45,    0,   45,    0,   45,    0,   45,    0,   45,
        0,   45,    0,   45,    0,   45,    0,   45,    0,   45,
       45,   45,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    1,    4,    4,    7,    8,
        9,   10,   11,   12,   13,   14,   15,   16,   16,   16,
       16,   16,   16,   16,   16,   16,   16,   17,   18,    1,
        1,    1,    4,   19,   20,   21,   22,   21,   23,   24,
       21,   21,   21,   21,   21,   25,   22,   21,   21,   22,
       21,   26,   27,   28,   29,   21,   21,   21,   21,   21,
        1,   30,    1,   31,   32,    1,   33,   34,   35,   36,

       37,   38,   39,   40,   41,   42,   42,   43,   44,   45,
       46,   47,   48,   49,   50,   51,   52,   53,   42,   54,
       55,   42,   56,   57,   58,   59,    1,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   61,   61,   61,   61,   61,   61,   61,
       61,   61,   61,   61,   61,   61,   61,   61,   61,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,    1,    1,   63,   63,   63,   63,   63,   63,   63,

       63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
       63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
       63,   63,   63,   64,   65,   65,   65,   65,   65,   65,
       65,   65,   65,   65,   65,   65,   66,   67,   67,   68,
       69,   69,   69,   70,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const YY_CHAR yy_meta[71] =
    {   0,
        1,    2,    3,    1,    4,    1,    5,    1,    1,    1,
        1,    1,    6,    7,    8,    9,   10,    1,    1,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    4,
        1,   11,   12,   12,   12,   12,   12,   12,   12,   12,
       12,   12,   12,   12,   12,   12,   12,   12,   12,   12,
       12,   12,   12,   12,   12,    1,    1,    1,    1,    1,
        1,    1,   10,   10,   10,   10,   10,   10,   10,   10
    } ;

static const flex_int16_t yy_base[376] =
    {   0,
        0,    0,   69,   71,   70,   71,  789, 1497,  786, 1497,
     1497, 1497,    0, 1497, 1497, 1497, 1497, 1497, 1497, 1497,
       65, 1497,  769,  760,   95,    0,  757,  736,    0,    0,
      728,   37,  714,  705,  708,  706,  704,   45,  695,  692,
      688, 1497,  685, 1497,   24,  670,   43,   32,   91,   34,
       94,  668,    0, 1497,    0, 1497,  132,  723,    0,   94,
      707,  155,    0,  704, 1497,  161,  187,    0,  204,  268,
      118,  659,  124,   38,  127,   52,  130,  646,  680,  675,
        0,  679,  155,  156,  178,  187,   90,  159,  182,  188,
      201,  204,  189,  206,  217,  226,  218,  219, 1497, 1497,

        0,  184,  187,  199,  217,  225,  241,  244,    0,    0,
     1497, 1497, 1497, 1497, 1497, 1497,  295,  679,  296,  306,
      308,  334,    0,  263,  256,  629,  263,  190,  274,  195,
      282,  630,  291,  307,  310,  313,  316,  319,  322,  662,
      665, 1497,  266,  248,  320,  348,  297,  368,  369,  225,
      370,  373,  670,  371,  372,  374,  377,  375,  669,  335,
      340,  343,  406,  418,  420,  446,    0,  376,  346,  623,
      368,  285,  375,  386,  394,  622,  403,  419,  422,  425,
      428,  431,  434,  437,  440,  443,  653,    0,  381,  421,
      460,  490,  432,  491,  492,  628,  620,  493,  494,  495,

      496,  497,  499,  498,    0,  616,  505,  517,  533,  559,
        0,  465,  494,  497,  500,  507,  516,  532,  535,  538,
      541,    0,    0,  506,  557,  516,  520,  511,  546,  534,
      572,  573,  554,  587,  528,  590,  505,  444,  593,  606,
      608,  634,    0,  550,  563,  568,    0,  597,  626,  440,
      599,  614,  434,  394,  616,  322,  618,  625,  250,  639,
      661,  687,    0,    0,  246,  619,  622,  237,  180,  648,
      165,  141,  665,  670,  713,    0,  663,  109,   73,  685,
      717,  743,    0,   70,  741,  767,  793,    0,  769,  771,
      819,    0,  779,  791,  845,    0,  817,  843,  871,    0,

      869,  895,  921,    0,  897,  899,  947,    0,  907,  919,
      973,    0,  945,  971,  999,    0,  997, 1023, 1049,    0,
     1025, 1027, 1075,    0, 1035, 1047, 1101,    0, 1073, 1099,
     1127,    0, 1125, 1151, 1177,    0,    0,    0, 1203,    0,
     1497, 1220, 1497, 1249, 1261, 1268, 1280, 1287, 1294, 1306,
     1318, 1330, 1338, 1345, 1351, 1359, 1366, 1373, 1380, 1387,
     1394, 1401, 1408, 1415, 1422, 1429, 1436, 1443, 1450, 1457,
     1464, 1471, 1478, 1485,   73
    } ;

static const flex_int16_t yy_def[376] =
    {   0,
      343,    1,  344,  344,  345,  345,  343,  343,  343,  343,
      343,  343,  346,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  347,  343,  343,   25,   25,   25,  348,  349,
      349,  349,  349,  349,  349,  349,  349,  349,  349,  349,
      343,  343,  343,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  350,  343,  351,  343,  352,  343,  346,  343,
      343,  343,  347,  347,  343,  353,   25,   67,  343,   67,
      343,  343,  343,  343,  343,  343,  343,  343,   67,   67,
      348,  349,  349,  349,  349,  349,  349,  349,  349,  349,
      349,  349,  349,  349,  349,  349,  349,  349,  343,  343,

       70,  343,  343,  343,  343,  343,  343,  343,  350,  351,
      343,  343,  343,  343,  343,  343,  343,  343,  343,  354,
      354,   70,  122,  355,  343,  343,  343,  343,  343,  343,
      343,  343,  343,  343,  343,  343,  343,  343,  343,  122,
      122,  343,  349,  349,  349,  349,  349,  349,  349,  349,
      349,  349,  349,  349,  349,  349,  349,  349,  349,  343,
      343,  343,  343,  356,  356,  122,  166,  355,  343,  343,
      343,  343,  343,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  343,  343,  343,  343,  166,  166,  349,  349,
      349,  349,  349,  349,  349,  349,  349,  349,  349,  349,

      349,  349,  349,  349,   70,  343,  343,  357,  357,   70,
      210,  343,  343,  343,  343,  343,  343,  343,  343,  343,
      343,   70,  210,  349,  349,  349,  349,  349,  349,  349,
      349,  349,  349,  349,  349,  349,  349,  349,  343,  358,
      358,  210,  242,  343,  343,  343,  168,  349,  349,  349,
      349,  349,  349,  349,  349,  349,  349,  349,  343,  359,
      359,  242,  262,  168,  349,  349,  349,  349,  349,  349,
      349,  343,  360,  360,  262,  275,  349,  349,  349,  361,
      361,  275,  282,  349,  362,  362,  282,  287,  363,  363,
      287,  291,  364,  364,  291,  295,  365,  365,  295,  299,

      366,  366,  299,  303,  367,  367,  303,  307,  368,  368,
      307,  311,  369,  369,  311,  315,  370,  370,  315,  319,
      371,  371,  319,  323,  372,  372,  323,  327,  373,  373,
      327,  331,  374,  374,  331,  335,  375,  375,  335,  339,
      343,  339,    0,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  343,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  343,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  343,  343,  343
    } ;

static const flex_int16_t yy_nxt[1568] =
    {   0,
        8,    9,   10,   11,   12,   13,    8,   14,   15,   16,
       17,   18,   19,    8,   20,   21,   22,   23,   24,   25,
       25,   26,   25,   27,   25,   26,   26,   28,   26,    8,
       29,    8,   30,   31,   32,   33,   34,   30,   30,   30,
       35,   30,   30,   30,   36,   37,   38,   39,   30,   30,
       40,   30,   30,   30,   30,   41,   42,   43,   44,    8,
        8,    8,   45,   46,   47,   48,   49,   50,   51,   52,
       54,   54,   54,   54,   56,   56,   60,   92,   61,   84,
       62,  341,   85,  101,  101,  101,  142,   93,   86,  142,
       94,  104,  104,   95,  106,  106,   96,  135,  135,   57,

       57,   66,  103,  103,  103,   60,  142,   67,   66,  117,
       68,   69,  137,  137,   68,   68,   68,   68,   68,   68,
       68,   68,   68,   68,  147,  142,   66,   70,   70,   70,
       70,   70,   70,   70,   70,   70,   70,   70,   70,   70,
       70,   70,   70,   70,   70,   70,   70,   70,   70,   70,
      105,  105,  105,  107,  107,  107,  272,   71,   72,   73,
       74,   75,   76,   77,   78,  112,   60,  120,   61,  113,
      119,  142,  142,  120,  120,  142,  114,   70,   70,   70,
      115,  142,  116,  134,  134,  134,  136,  136,  136,  138,
      138,  138,  120,  120,  142,  148,  142,  143,  142,  122,

      120,  144,  123,  142,  142,  142,  123,  123,  123,  123,
      123,  123,  123,  123,  123,  123,  149,  142,  120,  124,
      142,  145,  142,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  142,  142,  142,  146,  151,  150,  153,
      154,  142,  142,  101,  101,  101,  101,  101,  101,  179,
      179,  152,  155,  142,  158,  181,  181,  156,  101,  101,
      101,  196,  142,  159,  142,  272,  125,  126,  127,  128,
      129,  130,  131,  132,  343,  157,  101,  101,  101,   69,
       70,  343,  142,   70,  160,  160,  160,   70,   70,   70,
       70,   70,   70,   70,   70,   70,   70,  190,  189,  343,

      161,  161,  161,  162,  162,  162,   60,   60,   61,   61,
      117,  163,  164,  142,  164,  124,  124,  124,  164,  164,
      164,  164,  178,  178,  178,  169,  170,  171,  172,  173,
      174,  175,  176,  180,  180,  180,  142,  164,  142,  164,
      164,  182,  182,  182,  214,  214,  166,  164,  193,  167,
       70,   70,   70,  167,  167,  167,  167,  167,  167,  167,
      167,  167,  167,  191,  142,  164,   70,   70,   70,   70,
       70,   70,   70,   70,   70,  184,  184,  184,  185,  185,
      185,  186,  186,  186,  142,  142,  142,  142,  142,  142,
      142,  142,   69,  142,  205,  205,  205,  142,  192,  205,

      205,  205,  205,  205,  205,  168,  168,  168,  202,  199,
      142,  195,  194,  198,  197,  200,  203,   60,  206,   61,
      206,  207,  201,  204,  208,  224,  208,  213,  213,  213,
      208,  208,  208,  208,  215,  215,  215,  142,  169,  170,
      171,  172,  173,  174,  175,  176,  216,  216,  142,  208,
      142,  208,  208,  217,  217,  217,  142,  225,  210,  208,
      142,  211,  124,  124,  124,  211,  211,  211,  211,  211,
      211,  211,  211,  211,  211,  228,  142,  208,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  219,  219,  219,
      220,  220,  220,  221,  221,  221,  222,  222,  222,  222,

      222,  222,  222,  222,  222,  226,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,   60,  206,   61,  206,
      207,  142,  142,  240,  168,  168,  168,  142,  234,  240,
      240,  233,  142,  235,  232,  227,  142,  258,  231,  240,
      248,  229,  236,  230,  142,  240,  240,  251,  240,  237,
      142,  249,  238,  168,  168,  168,  168,  168,  168,  168,
      168,  168,  142,  250,  240,  240,  244,  244,  244,  252,
      142,  242,  240,  142,  243,  245,  245,  245,  243,  243,
      243,  243,  243,  243,  243,  243,  243,  243,  142,  142,
      240,  246,  246,  246,  247,  247,  247,  247,  247,  247,

      247,  247,  247,  142,  255,  259,  142,  259,  239,  264,
      264,  264,  260,  142,  260,  142,  253,  254,  260,  260,
      260,  260,  264,  264,  264,  256,  257,  264,  264,  264,
      142,  239,  142,  265,  142,  142,  142,  260,  142,  260,
      260,  142,  142,  267,  142,  273,  262,  260,  269,  263,
      268,  273,  273,  263,  263,  263,  263,  263,  263,  263,
      263,  263,  263,  271,  142,  260,  266,  273,  270,  277,
      273,  280,  278,  273,  273,  223,  280,  280,  280,  142,
      279,  218,  280,  280,  212,  142,  142,  188,  187,  183,
      177,  285,  273,  273,  118,  142,  280,  285,  285,  275,

      273,  280,  276,  141,  140,  139,  276,  276,  276,  276,
      276,  276,  276,  276,  276,  276,  285,  284,  273,  280,
      133,   64,  118,  285,   58,  282,  280,  108,  283,  285,
      285,  102,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  100,   99,  280,   98,   97,  289,  285,  285,
       91,   90,   89,  289,  289,  287,  285,   88,  288,   87,
       83,   80,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  289,  289,  285,  293,   79,  293,   65,  289,
      289,  293,  293,  293,  293,  297,   64,   58,  343,  343,
      343,  297,  297,  343,  343,  343,  343,  297,  289,  289,

      293,  343,  293,  297,  297,  291,  289,  343,  292,  343,
      297,  343,  292,  292,  292,  292,  292,  292,  292,  292,
      292,  292,  297,  301,  289,  293,  343,  343,  343,  301,
      301,  295,  293,  343,  296,  343,  343,  343,  296,  296,
      296,  296,  296,  296,  296,  296,  296,  296,  301,  301,
      293,  297,  343,  343,  343,  301,  301,  299,  297,  343,
      300,  343,  343,  343,  300,  300,  300,  300,  300,  300,
      300,  300,  300,  300,  301,  305,  297,  301,  343,  343,
      343,  305,  305,  303,  301,  343,  304,  343,  343,  343,
      304,  304,  304,  304,  304,  304,  304,  304,  304,  304,

      305,  305,  301,  309,  343,  309,  343,  305,  305,  309,
      309,  309,  309,  313,  343,  343,  343,  343,  343,  313,
      313,  343,  343,  343,  343,  313,  305,  305,  309,  343,
      309,  313,  313,  307,  305,  343,  308,  343,  313,  343,
      308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
      313,  317,  305,  309,  343,  343,  343,  317,  317,  311,
      309,  343,  312,  343,  343,  343,  312,  312,  312,  312,
      312,  312,  312,  312,  312,  312,  317,  317,  309,  313,
      343,  343,  343,  317,  317,  315,  313,  343,  316,  343,
      343,  343,  316,  316,  316,  316,  316,  316,  316,  316,

      316,  316,  317,  321,  313,  317,  343,  343,  343,  321,
      321,  319,  317,  343,  320,  343,  343,  343,  320,  320,
      320,  320,  320,  320,  320,  320,  320,  320,  321,  321,
      317,  325,  343,  325,  343,  321,  321,  325,  325,  325,
      325,  329,  343,  343,  343,  343,  343,  329,  329,  343,
      343,  343,  343,  329,  321,  321,  325,  343,  325,  329,
      329,  323,  321,  343,  324,  343,  329,  343,  324,  324,
      324,  324,  324,  324,  324,  324,  324,  324,  329,  333,
      321,  325,  343,  343,  343,  333,  333,  327,  325,  343,
      328,  343,  343,  343,  328,  328,  328,  328,  328,  328,

      328,  328,  328,  328,  333,  333,  325,  329,  343,  343,
      343,  333,  333,  331,  329,  343,  332,  343,  343,  343,
      332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
      333,  337,  329,  333,  343,  343,  343,  337,  337,  335,
      333,  343,  336,  343,  343,  343,  336,  336,  336,  336,
      336,  336,  336,  336,  336,  336,  337,  337,  333,  343,
      343,  343,  343,  337,  337,  343,  343,  343,  343,  343,
      343,  343,  343,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  337,  337,  343,  343,  343,  343,  343,  339,
      337,  343,  340,  343,  343,  343,  340,  340,  340,  340,

      340,  340,  340,  340,  340,  340,  343,  343,  337,  343,
      343,  343,  343,  343,  343,   70,  343,  343,  342,  343,
      343,  343,  342,  342,  342,  342,  342,  342,  342,  342,
      342,  342,  343,  343,  343,   70,  343,  343,  343,   70,
       70,   70,   70,   70,   70,   70,   70,   70,   70,   53,
       53,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   55,   59,   59,   59,   59,  343,   59,   59,
       63,   63,  343,   63,   63,   63,   63,   63,   63,   63,
       63,   63,   81,   81,   81,   81,  343,   81,   81,   82,

      343,  343,   82,  343,   82,   82,  109,  343,  343,  109,
      109,  109,  109,  109,  109,  109,  109,  109,  110,  110,
      110,  343,  110,  110,  110,  110,  110,  110,  110,  110,
      111,  111,  111,  111,  111,  111,  111,  111,  111,  111,
      111,  111,  121,  121,  121,  343,  121,  343,  121,  165,
      165,  165,  343,  165,  343,  165,  168,  343,  343,  168,
      168,  343,  168,  209,  209,  209,  343,  209,  343,  209,
      241,  241,  241,  343,  241,  343,  241,  261,  261,  261,
      343,  261,  343,  261,  274,  274,  274,  343,  274,  343,
      274,  281,  281,  281,  343,  281,  343,  281,  286,  286,

      286,  343,  286,  343,  286,  290,  290,  290,  343,  290,
      343,  290,  294,  294,  294,  343,  294,  343,  294,  298,
      298,  298,  343,  298,  343,  298,  302,  302,  302,  343,
      302,  343,  302,  306,  306,  306,  343,  306,  343,  306,
      310,  310,  310,  343,  310,  343,  310,  314,  314,  314,
      343,  314,  343,  314,  318,  318,  318,  343,  318,  343,
      318,  322,  322,  322,  343,  322,  343,  322,  326,  326,
      326,  343,  326,  343,  326,  330,  330,  330,  343,  330,
      343,  330,  334,  334,  334,  343,  334,  343,  334,  338,
      338,  338,  343,  338,  343,  338,    7,  343,  343,  343,

      343,  343,  343,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  343,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  343,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  343,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  343,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  343,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  343,  343,  343,  343,  343
    } ;

static const flex_int16_t yy_chk[1568] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        3,    3,    4,    4,    5,    6,   21,   38,   21,   32,
       21,  375,   32,   45,   45,   45,  284,   38,   32,  279,
       38,   48,   48,   38,   50,   50,   38,   74,   74,    5,

        6,   25,   47,   47,   47,   60,   87,   25,   25,   60,
       25,   25,   76,   76,   25,   25,   25,   25,   25,   25,
       25,   25,   25,   25,   87,  278,   25,   25,   25,   25,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       49,   49,   49,   51,   51,   51,  272,   25,   25,   25,
       25,   25,   25,   25,   25,   57,   62,   66,   62,   57,
       62,   83,   84,   66,   66,   88,   57,   71,   71,   71,
       57,  271,   57,   73,   73,   73,   75,   75,   75,   77,
       77,   77,   66,   67,   85,   88,  269,   83,   89,   67,

       67,   84,   67,   86,   90,   93,   67,   67,   67,   67,
       67,   67,   67,   67,   67,   67,   89,   91,   67,   69,
       92,   85,   94,   69,   69,   69,   69,   69,   69,   69,
       69,   69,   69,   95,   97,   98,   86,   91,   90,   92,
       93,  150,   96,  102,  102,  102,  103,  103,  103,  128,
      128,   91,   94,  268,   97,  130,  130,   95,  104,  104,
      104,  150,  265,   98,  144,  259,   69,   69,   69,   69,
       69,   69,   69,   69,   70,   96,  105,  105,  105,  124,
       70,   70,  143,   70,  106,  106,  106,   70,   70,   70,
       70,   70,   70,   70,   70,   70,   70,  144,  143,   70,

      107,  107,  107,  108,  108,  108,  117,  119,  117,  119,
      117,  119,  120,  147,  121,  125,  125,  125,  120,  120,
      121,  121,  127,  127,  127,  124,  124,  124,  124,  124,
      124,  124,  124,  129,  129,  129,  145,  120,  256,  121,
      122,  131,  131,  131,  172,  172,  122,  122,  147,  122,
      133,  133,  133,  122,  122,  122,  122,  122,  122,  122,
      122,  122,  122,  145,  146,  122,  134,  134,  134,  135,
      135,  135,  136,  136,  136,  137,  137,  137,  138,  138,
      138,  139,  139,  139,  148,  149,  151,  154,  155,  152,
      156,  158,  168,  157,  160,  160,  160,  189,  146,  161,

      161,  161,  162,  162,  162,  169,  169,  169,  156,  154,
      254,  149,  148,  152,  151,  155,  157,  163,  163,  163,
      163,  163,  155,  158,  164,  189,  165,  171,  171,  171,
      164,  164,  165,  165,  173,  173,  173,  190,  168,  168,
      168,  168,  168,  168,  168,  168,  174,  174,  193,  164,
      253,  165,  166,  175,  175,  175,  250,  190,  166,  166,
      238,  166,  177,  177,  177,  166,  166,  166,  166,  166,
      166,  166,  166,  166,  166,  193,  191,  166,  178,  178,
      178,  179,  179,  179,  180,  180,  180,  181,  181,  181,
      182,  182,  182,  183,  183,  183,  184,  184,  184,  185,

      185,  185,  186,  186,  186,  191,  192,  194,  195,  198,
      199,  200,  201,  202,  204,  203,  207,  207,  207,  207,
      207,  237,  224,  208,  212,  212,  212,  228,  201,  208,
      208,  200,  226,  202,  199,  192,  227,  237,  198,  209,
      224,  194,  203,  195,  235,  209,  209,  228,  208,  203,
      230,  226,  204,  213,  213,  213,  214,  214,  214,  215,
      215,  215,  229,  227,  209,  210,  216,  216,  216,  230,
      233,  210,  210,  225,  210,  217,  217,  217,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  231,  232,
      210,  218,  218,  218,  219,  219,  219,  220,  220,  220,

      221,  221,  221,  234,  233,  239,  236,  239,  239,  244,
      244,  244,  240,  248,  241,  251,  231,  232,  240,  240,
      241,  241,  245,  245,  245,  234,  236,  246,  246,  246,
      252,  206,  255,  248,  257,  266,  197,  240,  267,  241,
      242,  258,  249,  251,  196,  260,  242,  242,  255,  242,
      252,  260,  260,  242,  242,  242,  242,  242,  242,  242,
      242,  242,  242,  258,  270,  242,  249,  261,  257,  266,
      260,  273,  267,  261,  261,  187,  274,  273,  273,  277,
      270,  176,  274,  274,  170,  159,  153,  141,  140,  132,
      126,  280,  261,  262,  118,   82,  273,  280,  280,  262,

      262,  274,  262,   80,   79,   78,  262,  262,  262,  262,
      262,  262,  262,  262,  262,  262,  280,  277,  262,  275,
       72,   64,   61,  281,   58,  275,  275,   52,  275,  281,
      281,   46,  275,  275,  275,  275,  275,  275,  275,  275,
      275,  275,   43,   41,  275,   40,   39,  285,  281,  282,
       37,   36,   35,  285,  285,  282,  282,   34,  282,   33,
       31,   28,  282,  282,  282,  282,  282,  282,  282,  282,
      282,  282,  285,  286,  282,  289,   27,  290,   24,  286,
      286,  289,  289,  290,  290,  293,   23,    9,    7,    0,
        0,  293,  293,    0,    0,    0,    0,  294,  286,  287,

      289,    0,  290,  294,  294,  287,  287,    0,  287,    0,
      293,    0,  287,  287,  287,  287,  287,  287,  287,  287,
      287,  287,  294,  297,  287,  291,    0,    0,    0,  297,
      297,  291,  291,    0,  291,    0,    0,    0,  291,  291,
      291,  291,  291,  291,  291,  291,  291,  291,  297,  298,
      291,  295,    0,    0,    0,  298,  298,  295,  295,    0,
      295,    0,    0,    0,  295,  295,  295,  295,  295,  295,
      295,  295,  295,  295,  298,  301,  295,  299,    0,    0,
        0,  301,  301,  299,  299,    0,  299,    0,    0,    0,
      299,  299,  299,  299,  299,  299,  299,  299,  299,  299,

      301,  302,  299,  305,    0,  306,    0,  302,  302,  305,
      305,  306,  306,  309,    0,    0,    0,    0,    0,  309,
      309,    0,    0,    0,    0,  310,  302,  303,  305,    0,
      306,  310,  310,  303,  303,    0,  303,    0,  309,    0,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      310,  313,  303,  307,    0,    0,    0,  313,  313,  307,
      307,    0,  307,    0,    0,    0,  307,  307,  307,  307,
      307,  307,  307,  307,  307,  307,  313,  314,  307,  311,
        0,    0,    0,  314,  314,  311,  311,    0,  311,    0,
        0,    0,  311,  311,  311,  311,  311,  311,  311,  311,

      311,  311,  314,  317,  311,  315,    0,    0,    0,  317,
      317,  315,  315,    0,  315,    0,    0,    0,  315,  315,
      315,  315,  315,  315,  315,  315,  315,  315,  317,  318,
      315,  321,    0,  322,    0,  318,  318,  321,  321,  322,
      322,  325,    0,    0,    0,    0,    0,  325,  325,    0,
        0,    0,    0,  326,  318,  319,  321,    0,  322,  326,
      326,  319,  319,    0,  319,    0,  325,    0,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  326,  329,
      319,  323,    0,    0,    0,  329,  329,  323,  323,    0,
      323,    0,    0,    0,  323,  323,  323,  323,  323,  323,

      323,  323,  323,  323,  329,  330,  323,  327,    0,    0,
        0,  330,  330,  327,  327,    0,  327,    0,    0,    0,
      327,  327,  327,  327,  327,  327,  327,  327,  327,  327,
      330,  333,  327,  331,    0,    0,    0,  333,  333,  331,
      331,    0,  331,    0,    0,    0,  331,  331,  331,  331,
      331,  331,  331,  331,  331,  331,  333,  334,  331,    0,
        0,    0,    0,  334,  334,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  334,  335,    0,    0,    0,    0,    0,  335,
      335,    0,  335,    0,    0,    0,  335,  335,  335,  335,

      335,  335,  335,  335,  335,  335,    0,    0,  335,  339,
        0,    0,    0,    0,    0,  339,  339,    0,  339,    0,
        0,    0,  339,  339,  339,  339,  339,  339,  339,  339,
      339,  339,    0,    0,  339,  342,    0,    0,    0,  342,
      342,  342,  342,  342,  342,  342,  342,  342,  342,  344,
      344,  344,  344,  344,  344,  344,  344,  344,  344,  344,
      344,  345,  345,  345,  345,  345,  345,  345,  345,  345,
      345,  345,  345,  346,  346,  346,  346,    0,  346,  346,
      347,  347,    0,  347,  347,  347,  347,  347,  347,  347,
      347,  347,  348,  348,  348,  348,    0,  348,  348,  349,

        0,    0,  349,    0,  349,  349,  350,    0,    0,  350,
      350,  350,  350,  350,  350,  350,  350,  350,  351,  351,
      351,    0,  351,  351,  351,  351,  351,  351,  351,  351,
      352,  352,  352,  352,  352,  352,  352,  352,  352,  352,
      352,  352,  353,  353,  353,    0,  353,    0,  353,  354,
      354,  354,    0,  354,    0,  354,  355,    0,    0,  355,
      355,    0,  355,  356,  356,  356,    0,  356,    0,  356,
      357,  357,  357,    0,  357,    0,  357,  358,  358,  358,
        0,  358,    0,  358,  359,  359,  359,    0,  359,    0,
      359,  360,  360,  360,    0,  360,    0,  360,  361,  361,

      361,    0,  361,    0,  361,  362,  362,  362,    0,  362,
        0,  362,  363,  363,  363,    0,  363,    0,  363,  364,
      364,  364,    0,  364,    0,  364,  365,  365,  365,    0,
      365,    0,  365,  366,  366,  366,    0,  366,    0,  366,
      367,  367,  367,    0,  367,    0,  367,  368,  368,  368,
        0,  368,    0,  368,  369,  369,  369,    0,  369,    0,
      369,  370,  370,  370,    0,  370,    0,  370,  371,  371,
      371,    0,  371,    0,  371,  372,  372,  372,    0,  372,
        0,  372,  373,  373,  373,    0,  373,    0,  373,  374,
      374,  374,    0,  374,    0,  374,  343,  343,  343,  343,

      343,  343,  343,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  343,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  343,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  343,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  343,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  343,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  343,  343,  343,  343,  343
    } ;

/* Table of booleans, true if rule could match eol. */
static const flex_int32_t yy_rule_can_match_eol[62] =
    {   0,
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 
    0, 0,     };

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "beancount/parser/lexer.l"
/* -*- mode: c -*- */
/* A flex lexer for Beancount. */
/*--------------------------------------------------------------------------------------*/
/* Definitions */
/* Options */
/* %option nodefault */
/* %option reentrant */
/* %option debug */
/* %option stack */
/* %option 8bit */
/* Top Code. */

/* A start condition for chomping an invalid token. */

/* Exclusive start condition for parsing escape sequences in string literals. */

/*--------------------------------------------------------------------------------------*/
/* Rules */
#line 1050 "beancount/parser/lexer.c"

#define INITIAL 0
#define INVALID 1
#define STRLIT 2

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

YYSTYPE * yyget_lval ( void );

void yyset_lval ( YYSTYPE * yylval_param  );

       YYLTYPE *yyget_lloc ( void );
    
        void yyset_lloc ( YYLTYPE * yylloc_param  );
    
/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput ( int c, char *buf_ptr  );
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param );

#define YY_DECL int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param )
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
        YYSTYPE * yylval;
    
        YYLTYPE * yylloc;
    
    yylval = yylval_param;

    yylloc = yylloc_param;

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 128 "beancount/parser/lexer.l"



#line 132 "beancount/parser/lexer.l"
 /* Newlines are output as explicit tokens, because lines matter in the syntax. */
#line 1293 "beancount/parser/lexer.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 344 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 343 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < yyleng; ++yyl )
				if ( yytext[yyl] == '\n' )
					
    yylineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 133 "beancount/parser/lexer.l"
{
    yy_line_tokens = 0;
    yycolumn = 1;
    return EOL;
}
	YY_BREAK
/* Ignore whitespace, except when found at the beginning of a line
    and followed by a regular character. This is how we detect an
    initial indent and thus group postings and comments together in
    the grammar. */
case 2:
YY_RULE_SETUP
#line 143 "beancount/parser/lexer.l"
{
    if ( yy_line_tokens == 1 ) {
        /* If the next character completes the line, skip it. */
        if ( yy_hold_char == '\n' ||
             yy_hold_char == '\r' ||
             yy_hold_char == '\0' ) {
            return SKIPPED;
        }
        else {
            return INDENT;
        }
    }
}
	YY_BREAK
/* Characters with special meanings have their own tokens. */
case 3:
YY_RULE_SETUP
#line 158 "beancount/parser/lexer.l"
{ return PIPE; }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 159 "beancount/parser/lexer.l"
{ return ATAT; }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 160 "beancount/parser/lexer.l"
{ return AT; }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 161 "beancount/parser/lexer.l"
{ return LCURLCURL; }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 162 "beancount/parser/lexer.l"
{ return RCURLCURL; }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 163 "beancount/parser/lexer.l"
{ return LCURL; }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 164 "beancount/parser/lexer.l"
{ return RCURL; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 165 "beancount/parser/lexer.l"
{ return COMMA; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 166 "beancount/parser/lexer.l"
{ return TILDE; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 167 "beancount/parser/lexer.l"
{ return PLUS; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 168 "beancount/parser/lexer.l"
{ return MINUS; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 169 "beancount/parser/lexer.l"
{ return SLASH; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 170 "beancount/parser/lexer.l"
{ return COLON; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 171 "beancount/parser/lexer.l"
{ return LPAREN; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 172 "beancount/parser/lexer.l"
{ return RPAREN; }
	YY_BREAK
/* Special handling for characters beginning a line to be ignored.
  * I'd like to improve how this is handled. Needs own lexer, really. */
case 18:
YY_RULE_SETUP
#line 176 "beancount/parser/lexer.l"
{
    if ( yy_line_tokens != 1 ) {
        return HASH;
    }
    else {
        /* Allow org-mode titles. */
        yy_skip_line();
        return SKIPPED;
    }
}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 187 "beancount/parser/lexer.l"
{
    if ( yy_line_tokens != 1 ) {
        return ASTERISK;
    }
    else {
        /* Allow org-mode titles. */
        yy_skip_line();
        return SKIPPED;
    }
}
	YY_BREAK
/* Skip commented output (but not the accompanying newline). */
case 20:
YY_RULE_SETUP
#line 199 "beancount/parser/lexer.l"
{
    /* yy_skip_line(); */
    return COMMENT;
}
	YY_BREAK
/* Special characters which may be used in-lieu of a 'txn' keyword in a
    transaction declaration output as a token. Other lines are just skipped.
    This allows us to use org-mode or other separators in the input syntax.

    Note: You need to make sure to include all the values from
    beancount.core.flags, in order for round-trips between text and entries to
    be possible. {5307d8fa1e7b}
    */
case 21:
YY_RULE_SETUP
#line 212 "beancount/parser/lexer.l"
{
    if ( yy_line_tokens != 1 ) {
        yylval->character = yytext[0];
        return FLAG;
    }
    else {
        yy_skip_line();
        return SKIPPED;
    }
}
	YY_BREAK
/* Keywords. */
case 22:
YY_RULE_SETUP
#line 224 "beancount/parser/lexer.l"
{ return TXN; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 225 "beancount/parser/lexer.l"
{ return BALANCE; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 226 "beancount/parser/lexer.l"
{ return OPEN; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 227 "beancount/parser/lexer.l"
{ return CLOSE; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 228 "beancount/parser/lexer.l"
{ return COMMODITY; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 229 "beancount/parser/lexer.l"
{ return PAD; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 230 "beancount/parser/lexer.l"
{ return EVENT; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 231 "beancount/parser/lexer.l"
{ return QUERY; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 232 "beancount/parser/lexer.l"
{ return CUSTOM; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 233 "beancount/parser/lexer.l"
{ return PRICE; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 234 "beancount/parser/lexer.l"
{ return NOTE; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 235 "beancount/parser/lexer.l"
{ return DOCUMENT; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 236 "beancount/parser/lexer.l"
{ return PUSHTAG; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 237 "beancount/parser/lexer.l"
{ return POPTAG; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 238 "beancount/parser/lexer.l"
{ return PUSHMETA; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 239 "beancount/parser/lexer.l"
{ return POPMETA; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 240 "beancount/parser/lexer.l"
{ return OPTION; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 241 "beancount/parser/lexer.l"
{ return PLUGIN; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 242 "beancount/parser/lexer.l"
{ return INCLUDE; }
	YY_BREAK
/* Boolean values. */
case 41:
YY_RULE_SETUP
#line 245 "beancount/parser/lexer.l"
{
    yylval->pyobj = Py_True;
    Py_INCREF(Py_True);
    return BOOL;
}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 251 "beancount/parser/lexer.l"
{
    yylval->pyobj = Py_False;
    Py_INCREF(Py_False);
    return BOOL;
}
	YY_BREAK
/* Dates. */
case 43:
YY_RULE_SETUP
#line 258 "beancount/parser/lexer.l"
{
    const char* year_str;
    const char* month_str;
    const char* day_str;
    int year, month, day;

    /* Parse the numbers. */
    year_str = yytext;
    month_str = strpbrk(year_str, "-/");
    year = strtonl(year_str, month_str - year_str);
    month_str++;
    day_str = strpbrk(month_str, "-/");
    month = strtonl(month_str, day_str - month_str);
    day_str++;
    day = strtonl(day_str, yytext + yyleng - day_str);

    /* Attempt to create the date. */
    BUILD_LEX("DATE", "iii", year, month, day);
    return DATE;
}
	YY_BREAK
/* Account names. */
case 44:
YY_RULE_SETUP
#line 280 "beancount/parser/lexer.l"
{
    BUILD_LEX("ACCOUNT", "s", yytext);
    return ACCOUNT;
}
	YY_BREAK
/* Currencies. These are defined as uppercase only in order to disambiguate the
  * syntax. This is kept in sync with beancount.core.amount.CURRENCY_RE. */
case 45:
YY_RULE_SETUP
#line 287 "beancount/parser/lexer.l"
{
    BUILD_LEX("CURRENCY", "s", yytext);
    return CURRENCY;
}
	YY_BREAK
/* String literals. */
/* Note that we use an exclusive start condition.
    See section "Start Conditions" in the GNU Flex manual. */
case 46:
YY_RULE_SETUP
#line 295 "beancount/parser/lexer.l"
{
    strbuf_ptr = strbuf;
    BEGIN(STRLIT);
}
	YY_BREAK

/* Saw closing quote - all done. */
case 47:
YY_RULE_SETUP
#line 303 "beancount/parser/lexer.l"
{
        BEGIN(INITIAL);
        *strbuf_ptr = '\0';
        PyObject* unicode_str = PyUnicode_Decode(strbuf, strbuf_ptr - strbuf,
                                                 yy_encoding, "ignore");
        if ( unicode_str == NULL ) {
            build_lexer_error_from_exception();
            yylval->pyobj = Py_None;
            Py_INCREF(Py_None);
            return LEX_ERROR;
        }
        BUILD_LEX("STRING", "O", unicode_str);
        Py_DECREF(unicode_str);
        strbuf_ptr = NULL;
        return STRING;
    }
	YY_BREAK
/* Escape sequences. */
case 48:
YY_RULE_SETUP
#line 321 "beancount/parser/lexer.l"
SAFE_COPY_CHAR('\n');
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 322 "beancount/parser/lexer.l"
SAFE_COPY_CHAR('\t');
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 323 "beancount/parser/lexer.l"
SAFE_COPY_CHAR('\r');
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 324 "beancount/parser/lexer.l"
SAFE_COPY_CHAR('\b');
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 325 "beancount/parser/lexer.l"
SAFE_COPY_CHAR('\f');
	YY_BREAK
case 53:
/* rule 53 can match eol */
YY_RULE_SETUP
#line 326 "beancount/parser/lexer.l"
SAFE_COPY_CHAR(yytext[1]);
	YY_BREAK
/* All other characters. */
case 54:
/* rule 54 can match eol */
YY_RULE_SETUP
#line 329 "beancount/parser/lexer.l"
{
        if ( yyleng > (strbuf_end - strbuf_ptr) ) {
            strbuf_realloc(yyleng);
        }
        ssize_t i;
        for (i = 0; i < yyleng; ++i) {
            *strbuf_ptr++ = yytext[i];
        }
    }
	YY_BREAK

/* Numbers */
case 55:
YY_RULE_SETUP
#line 341 "beancount/parser/lexer.l"
{
    BUILD_LEX("NUMBER", "s", yytext);
    return NUMBER;
}
	YY_BREAK
/* Tags */
case 56:
YY_RULE_SETUP
#line 347 "beancount/parser/lexer.l"
{
    BUILD_LEX("TAG", "s", &(yytext[1]));
    return TAG;
}
	YY_BREAK
/* Links */
case 57:
YY_RULE_SETUP
#line 353 "beancount/parser/lexer.l"
{
    BUILD_LEX("LINK", "s", &(yytext[1]));
    return LINK;
}
	YY_BREAK
/* Key */
case 58:
YY_RULE_SETUP
#line 359 "beancount/parser/lexer.l"
{
    BUILD_LEX("KEY", "s#", yytext, yyleng-1);
    unput(':');
    return KEY;
}
	YY_BREAK
/* Default rule. {bf253a29a820} */
case 59:
YY_RULE_SETUP
#line 366 "beancount/parser/lexer.l"
{
    unput(*yytext);
    BEGIN(INVALID);
}
	YY_BREAK
/* Fake an EOL at the end of file, to ensure that files without a final newline
  * will process postings right. */
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(INVALID):
case YY_STATE_EOF(STRLIT):
#line 373 "beancount/parser/lexer.l"
{
  if ( yy_eof_times == 0 ) {
    yy_eof_times = 1;
    yylloc->first_line = yylineno;
    return EOL;
  }
  return 0;
}
	YY_BREAK
/* Note: We use a subparser here because if we set a default rule to chomp this
    pattern, it would take precedence over valid rules if the matched text is
    longer and thus would break the lexer. Writing our own lexer would fix
    this and more. {bba169a1d35a} */
case 60:
YY_RULE_SETUP
#line 386 "beancount/parser/lexer.l"
{
    char buffer[256];
    size_t length = snprintf(buffer, 256, "Invalid token: '%s'", yytext);
    build_lexer_error(buffer, length);
    BEGIN(INITIAL);
    return LEX_ERROR;
}
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 395 "beancount/parser/lexer.l"
ECHO;
	YY_BREAK
#line 1845 "beancount/parser/lexer.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 344 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 344 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 343);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp )
{
	char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (yy_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

    if ( c == '\n' ){
        --yylineno;
    }

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	if ( c == '\n' )
		
    yylineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    /* We do not touch yylineno unless the option is enabled. */
    yylineno =  1;
    
    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 395 "beancount/parser/lexer.l"

/*--------------------------------------------------------------------------------------*/
/* User Code */


/* Note: All these globals should be moved to an yylex_extra */

/* The number of times EOF has been hit. This is used to synthesize an EOL at
 * the end of the file. */
int yy_eof_times = 0;

/* The filename being tokenized. */
const char* yy_filename = 0;

/* Number of tokens since the beginning of the line. */
int yy_line_tokens = 0;

/* The current column we're tokenizing at. */
int yycolumn = 1;

/* The encoding to use for converting strings. */
const char* yy_encoding = NULL;

/* A buffer for parsing string literals. It is reused and its size is dynamically allocated. */
size_t strbuf_size = 0;
char* strbuf = NULL;
char* strbuf_end;
char* strbuf_ptr;

/* Initialize the globals before running the lexer. */
void yylex_initialize(const char* filename, const char* encoding)
{
    assert(filename != NULL);
    yy_eof_times = 0;
    yy_filename = filename;
    yy_line_tokens = 0;
    yycolumn = 1;
    if ( encoding == 0 ) {
        yy_encoding = "utf8";
    }
    else {
        yy_encoding = encoding;
    }

    /* Start with a decent small buffer. */
    strbuf_size = 1024;
    strbuf = realloc(strbuf, strbuf_size + 1);
    strbuf_end = strbuf + strbuf_size - 1;
    strbuf_ptr = NULL;

    /* Note: If we used a reentrant parser, this routine should eventually call
     * yylex_init(). */
}

/* Finalize the globals before running the lexer. */
void yylex_finalize(void)
{
    yy_filename = NULL;

    /* Finalize our reading buffer. */
    if ( strbuf != NULL ) {
        free(strbuf);
        strbuf = NULL;
    }

    /* Call the yylex finalization routine. */
    yylex_destroy();
}


/* Reallocate the buffer to accomodate some new characters. */
void strbuf_realloc(size_t num_new_chars)
{
    assert(strbuf_ptr != NULL);
    size_t cur_size = strbuf_ptr - strbuf;
    size_t new_size = cur_size + num_new_chars;
    while ( strbuf_size < new_size ) {
        strbuf_size <<= 1;
    }
    strbuf = realloc(strbuf, strbuf_size + 1);
    strbuf_ptr = strbuf + cur_size;
    strbuf_end = strbuf + strbuf_size - 1;
}




#define LEXEOF 0

int yy_skip_line()
{
    int num_chars = 0;
    for ( ;; ) {
        int c = input();
        num_chars++;
        if ( c == LEXEOF || c == -1 ) {
            break;
        }
        if ( c == '\n' ) {
            unput(c);
            num_chars--;
            break;
        }
    }
    return num_chars;
}

/* Convert an integer string to a number. */
int strtonl(const char* buf, size_t nchars)
{
    int result = 0;
    size_t i;
    for ( i = 0; i < nchars; ++i ) {
        result *= 10;
        result += (buf[i] - '0');
    }
    return result;
}

/* Build and accumulate an error on the builder object. */
void build_lexer_error(const char* string, size_t length)
{
    TRACE_ERROR("Invalid Token");

    /* Build and accumulate a new error object. {27d1d459c5cd} */
    PyObject* rv = PyObject_CallMethod(builder, "build_lexer_error",
                                       "s#", string, length);
    if (rv == NULL) {
        PyErr_SetString(PyExc_RuntimeError,
                        "Internal error: Building exception from default rule");
    }
    Py_XDECREF(rv);
}

void build_lexer_error_from_exception()
{
    TRACE_ERROR("Lexer Builder Exception");

    /* Get the exception context. */
    PyObject* ptype = NULL;
    PyObject* pvalue = NULL;
    PyObject* ptraceback = NULL;
    PyErr_Fetch(&ptype, &pvalue, &ptraceback);
    PyErr_NormalizeException(&ptype, &pvalue, &ptraceback);

    /* Clear the exception. */
    PyErr_Clear();

    if (pvalue != NULL) {
        /* Build and accumulate a new error object. {27d1d459c5cd} */
        PyObject* rv = PyObject_CallMethod(builder, "build_lexer_error",
                                           "OO", pvalue, ptype);
        Py_XDECREF(ptype);
        Py_XDECREF(pvalue);
        Py_XDECREF(ptraceback);

        if (rv == NULL) {
            PyErr_SetString(PyExc_RuntimeError,
                            "Internal error: While building exception");
        }
    }
    else {
        PyErr_SetString(PyExc_RuntimeError,
                        "Internal error: No exception");
    }
}

