+++
title = "Off-specular"
weight = 20
+++

## Baisc off-specular scattering example

Class reference: [OffspecSimulation](/ref/sim/class/offspec).

#### Example

Off-specular scattering from a monodisperse distribution of long boxes.

* The sample is made of very long boxes with length equal to $1000$ nm, width $20$ nm and height $10$ nm.
* The particles are distributed along a one-dimensional lattice with a lattice spacing of $100$ nm in the $x$-direction.
* The particles are rotated around the $z$-axis by $90^{\circ}$ so that their "infinite" dimension is parallel to the $y$-direction.
* The incident wavelength is equal to 0.1 nm.
* The output intensity is the result of an average over $\varphi\_i$ comprised between $-1^{\circ}$ and $1^{\circ}$ and of a scan of $\alpha\_i$ and $\alpha\_f$ between $0^{\circ}$ and $10^{\circ}$.

The two-dimensional output intensity is plotted as a function of $\alpha\_i$ and $\alpha\_f$.

{{< galleryscg >}}
{{< figscg src="/img/draw/Offspec_Setup.jpg" width="350px" caption="Real-space model">}}
{{< figscg src="/img/auto/offspec/Offspec1.png" width="350px" caption="Intensity image">}}
{{< /galleryscg >}}

{{< show-ex file="offspec/Offspec1.py" >}}
