#ifndef __AUTHNLIB_NAMESPACEPOLICY_H__
#define __AUTHNLIB_NAMESPACEPOLICY_H__

#include <iostream>
#include <string>
#include <list>

#include <openssl/ssl.h>

namespace AuthN {
  /*The implementation is according to the namespaces 
    format specification defined by eugridpma, see:
    http://www.eugridpma.org/documentation/eugridpma-namespaces-format-spec-20060113-0-1-4.pdf
   */
  class NamespacesPolicy {
  public:
    NamespacesPolicy(const X509_NAME* issuer_subject,const std::string& ca_path);
    NamespacesPolicy(const std::string& issuer_subject,const std::string& ca_path);
    ~NamespacesPolicy();
    bool Match(const X509_NAME* subject);
    bool Match(const std::string& subject);
    operator bool(void) { return (file_ != NULL); };
    bool operator!(void) { return (file_ == NULL); };
    const std::string& Error(void) { return error_; };
  private:
    void Init(const X509_NAME* issuer_subject, const std::string& ca_path);

  private:
    std::string issuer_;
    std::istream* file_;
    std::string error_;
  };
}

#endif // __AUTHNLIB_NAMESPACEPOLICY_H__
