{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetDirection: TVector3;
    procedure SetDirection(const Value: TVector3);
    function GetIntensity: Single;
    procedure SetIntensity(const Value: Single);
    function GetLocation: TVector3;
    procedure SetLocation(const Value: TVector3);
    function GetMaxBack: Single;
    procedure SetMaxBack(const Value: Single);
    function GetMaxFront: Single;
    procedure SetMaxFront(const Value: Single);
    function GetMinBack: Single;
    procedure SetMinBack(const Value: Single);
    function GetMinFront: Single;
    procedure SetMinFront(const Value: Single);
    function GetPriority: Single;
    procedure SetPriority(const Value: Single);
    function GetSource: TX3DNode;
    procedure SetSource(const Value: TX3DNode);
    function GetSpatialize: Boolean;
    procedure SetSpatialize(const Value: Boolean);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdDirection: TSFVec3f;
    { Internal wrapper for property @code(Direction). This wrapper API may change, we advise to access simpler @code(Direction) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDirection: TSFVec3f read FFdDirection;
    {  }
    property Direction: TVector3 read GetDirection write SetDirection;

    strict private FFdIntensity: TSFFloat;
    { Internal wrapper for property @code(Intensity). This wrapper API may change, we advise to access simpler @code(Intensity) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdIntensity: TSFFloat read FFdIntensity;
    {  }
    property Intensity: Single read GetIntensity write SetIntensity;

    strict private FFdLocation: TSFVec3f;
    { Internal wrapper for property @code(Location). This wrapper API may change, we advise to access simpler @code(Location) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLocation: TSFVec3f read FFdLocation;
    {  }
    property Location: TVector3 read GetLocation write SetLocation;

    strict private FFdMaxBack: TSFFloat;
    { Internal wrapper for property @code(MaxBack). This wrapper API may change, we advise to access simpler @code(MaxBack) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMaxBack: TSFFloat read FFdMaxBack;
    {  }
    property MaxBack: Single read GetMaxBack write SetMaxBack;

    strict private FFdMaxFront: TSFFloat;
    { Internal wrapper for property @code(MaxFront). This wrapper API may change, we advise to access simpler @code(MaxFront) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMaxFront: TSFFloat read FFdMaxFront;
    {  }
    property MaxFront: Single read GetMaxFront write SetMaxFront;

    strict private FFdMinBack: TSFFloat;
    { Internal wrapper for property @code(MinBack). This wrapper API may change, we advise to access simpler @code(MinBack) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMinBack: TSFFloat read FFdMinBack;
    {  }
    property MinBack: Single read GetMinBack write SetMinBack;

    strict private FFdMinFront: TSFFloat;
    { Internal wrapper for property @code(MinFront). This wrapper API may change, we advise to access simpler @code(MinFront) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMinFront: TSFFloat read FFdMinFront;
    {  }
    property MinFront: Single read GetMinFront write SetMinFront;

    strict private FFdPriority: TSFFloat;
    { Internal wrapper for property @code(Priority). This wrapper API may change, we advise to access simpler @code(Priority) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdPriority: TSFFloat read FFdPriority;
    {  }
    property Priority: Single read GetPriority write SetPriority;

    strict private FFdSource: TSFNode;
    { Internal wrapper for property @code(Source). This wrapper API may change, we advise to access simpler @code(Source) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSource: TSFNode read FFdSource;
    {  }
    property Source: TX3DNode read GetSource write SetSource;

    strict private FFdSpatialize: TSFBool;
    { Internal wrapper for property @code(Spatialize). This wrapper API may change, we advise to access simpler @code(Spatialize) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSpatialize: TSFBool read FFdSpatialize;
    {  }
    property Spatialize: Boolean read GetSpatialize write SetSpatialize;

{$endif read_interface}

{$ifdef read_implementation}

{ TSoundNode ----------------------------------------------- }

function TSoundNode.GetDirection: TVector3;
begin
  Result := FdDirection.Value;
end;

procedure TSoundNode.SetDirection(const Value: TVector3);
begin
  FdDirection.Send(Value);
end;

function TSoundNode.GetIntensity: Single;
begin
  Result := FdIntensity.Value;
end;

procedure TSoundNode.SetIntensity(const Value: Single);
begin
  FdIntensity.Send(Value);
end;

function TSoundNode.GetLocation: TVector3;
begin
  Result := FdLocation.Value;
end;

procedure TSoundNode.SetLocation(const Value: TVector3);
begin
  FdLocation.Send(Value);
end;

function TSoundNode.GetMaxBack: Single;
begin
  Result := FdMaxBack.Value;
end;

procedure TSoundNode.SetMaxBack(const Value: Single);
begin
  FdMaxBack.Send(Value);
end;

function TSoundNode.GetMaxFront: Single;
begin
  Result := FdMaxFront.Value;
end;

procedure TSoundNode.SetMaxFront(const Value: Single);
begin
  FdMaxFront.Send(Value);
end;

function TSoundNode.GetMinBack: Single;
begin
  Result := FdMinBack.Value;
end;

procedure TSoundNode.SetMinBack(const Value: Single);
begin
  FdMinBack.Send(Value);
end;

function TSoundNode.GetMinFront: Single;
begin
  Result := FdMinFront.Value;
end;

procedure TSoundNode.SetMinFront(const Value: Single);
begin
  FdMinFront.Send(Value);
end;

function TSoundNode.GetPriority: Single;
begin
  Result := FdPriority.Value;
end;

procedure TSoundNode.SetPriority(const Value: Single);
begin
  FdPriority.Send(Value);
end;

function TSoundNode.GetSource: TX3DNode;
begin
  if FdSource.Value is TX3DNode then
    Result := TX3DNode(FdSource.Value)
  else
    Result := nil;
end;

procedure TSoundNode.SetSource(const Value: TX3DNode);
begin
  FdSource.Send(Value);
end;

function TSoundNode.GetSpatialize: Boolean;
begin
  Result := FdSpatialize.Value;
end;

procedure TSoundNode.SetSpatialize(const Value: Boolean);
begin
  FdSpatialize.Send(Value);
end;

class function TSoundNode.ClassX3DType: String;
begin
  Result := 'Sound';
end;

procedure TSoundNode.CreateNode;
begin
  inherited;

  FFdDirection := TSFVec3f.Create(Self, True, 'direction', Vector3(0, 0, 1));
   FdDirection.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDirection);

  FFdIntensity := TSFFloat.Create(Self, True, 'intensity', 1);
   FdIntensity.ChangeAlways := chVisibleNonGeometry;
   FdIntensity.MustBeNonnegative := true;
  AddField(FFdIntensity);

  FFdLocation := TSFVec3f.Create(Self, True, 'location', Vector3(0, 0, 0));
   FdLocation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLocation);

  FFdMaxBack := TSFFloat.Create(Self, True, 'maxBack', 10);
   FdMaxBack.ChangeAlways := chVisibleNonGeometry;
   FdMaxBack.MustBeNonnegative := true;
  AddField(FFdMaxBack);

  FFdMaxFront := TSFFloat.Create(Self, True, 'maxFront', 10);
   FdMaxFront.ChangeAlways := chVisibleNonGeometry;
   FdMaxFront.MustBeNonnegative := true;
  AddField(FFdMaxFront);

  FFdMinBack := TSFFloat.Create(Self, True, 'minBack', 1);
   FdMinBack.ChangeAlways := chVisibleNonGeometry;
   FdMinBack.MustBeNonnegative := true;
  AddField(FFdMinBack);

  FFdMinFront := TSFFloat.Create(Self, True, 'minFront', 1);
   FdMinFront.ChangeAlways := chVisibleNonGeometry;
   FdMinFront.MustBeNonnegative := true;
  AddField(FFdMinFront);

  FFdPriority := TSFFloat.Create(Self, True, 'priority', 0);
   FdPriority.ChangeAlways := chVisibleNonGeometry;
   FdPriority.MustBeNonnegative := true;
  AddField(FFdPriority);

  FFdSource := TSFNode.Create(Self, True, 'source', [TAbstractSoundSourceNode, TMovieTextureNode]);
   FdSource.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSource);

  FFdSpatialize := TSFBool.Create(Self, False, 'spatialize', true);
   FdSpatialize.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSpatialize);
end;

{$endif read_implementation}
