{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetDescription: String;
    procedure SetDescription(const Value: String);
    function GetDirection: TVector3;
    procedure SetDirection(const Value: TVector3);
    function GetFarDistance: Single;
    procedure SetFarDistance(const Value: Single);
    function GetLocation: TVector3;
    procedure SetLocation(const Value: TVector3);
    function GetNearDistance: Single;
    procedure SetNearDistance(const Value: Single);
    function GetTexture: TAbstractTexture2DNode;
    procedure SetTexture(const Value: TAbstractTexture2DNode);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdDescription: TSFString;
    { Internal wrapper for property @code(Description). This wrapper API may change, we advise to access simpler @code(Description) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDescription: TSFString read FFdDescription;
    {  }
    property Description: String read GetDescription write SetDescription;

    strict private FFdDirection: TSFVec3f;
    { Internal wrapper for property @code(Direction). This wrapper API may change, we advise to access simpler @code(Direction) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDirection: TSFVec3f read FFdDirection;
    {  }
    property Direction: TVector3 read GetDirection write SetDirection;

    strict private FFdFarDistance: TSFFloat;
    { Internal wrapper for property @code(FarDistance). This wrapper API may change, we advise to access simpler @code(FarDistance) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFarDistance: TSFFloat read FFdFarDistance;
    {  }
    property FarDistance: Single read GetFarDistance write SetFarDistance;

    strict private FFdLocation: TSFVec3f;
    { Internal wrapper for property @code(Location). This wrapper API may change, we advise to access simpler @code(Location) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLocation: TSFVec3f read FFdLocation;
    {  }
    property Location: TVector3 read GetLocation write SetLocation;

    strict private FFdNearDistance: TSFFloat;
    { Internal wrapper for property @code(NearDistance). This wrapper API may change, we advise to access simpler @code(NearDistance) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNearDistance: TSFFloat read FFdNearDistance;
    {  }
    property NearDistance: Single read GetNearDistance write SetNearDistance;

    strict private FFdTexture: TSFNode;
    { Internal wrapper for property @code(Texture). This wrapper API may change, we advise to access simpler @code(Texture) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTexture: TSFNode read FFdTexture;
    {  }
    property Texture: TAbstractTexture2DNode read GetTexture write SetTexture;

    strict private FEventAspectRatio: TSFFloatEvent;
    {  }
    public property EventAspectRatio: TSFFloatEvent read FEventAspectRatio;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractTextureProjectorNode ----------------------------------------------- }

function TAbstractTextureProjectorNode.GetDescription: String;
begin
  Result := FdDescription.Value;
end;

procedure TAbstractTextureProjectorNode.SetDescription(const Value: String);
begin
  FdDescription.Send(Value);
end;

function TAbstractTextureProjectorNode.GetDirection: TVector3;
begin
  Result := FdDirection.Value;
end;

procedure TAbstractTextureProjectorNode.SetDirection(const Value: TVector3);
begin
  FdDirection.Send(Value);
end;

function TAbstractTextureProjectorNode.GetFarDistance: Single;
begin
  Result := FdFarDistance.Value;
end;

procedure TAbstractTextureProjectorNode.SetFarDistance(const Value: Single);
begin
  FdFarDistance.Send(Value);
end;

function TAbstractTextureProjectorNode.GetLocation: TVector3;
begin
  Result := FdLocation.Value;
end;

procedure TAbstractTextureProjectorNode.SetLocation(const Value: TVector3);
begin
  FdLocation.Send(Value);
end;

function TAbstractTextureProjectorNode.GetNearDistance: Single;
begin
  Result := FdNearDistance.Value;
end;

procedure TAbstractTextureProjectorNode.SetNearDistance(const Value: Single);
begin
  FdNearDistance.Send(Value);
end;

function TAbstractTextureProjectorNode.GetTexture: TAbstractTexture2DNode;
begin
  if FdTexture.Value is TAbstractTexture2DNode then
    Result := TAbstractTexture2DNode(FdTexture.Value)
  else
    Result := nil;
end;

procedure TAbstractTextureProjectorNode.SetTexture(const Value: TAbstractTexture2DNode);
begin
  FdTexture.Send(Value);
end;

class function TAbstractTextureProjectorNode.ClassX3DType: String;
begin
  Result := 'X3DTextureProjectorNode';
end;

procedure TAbstractTextureProjectorNode.CreateNode;
begin
  inherited;

  FFdDescription := TSFString.Create(Self, True, 'description', '');
   FdDescription.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDescription);

  FFdDirection := TSFVec3f.Create(Self, True, 'direction', Vector3(0, 0, 1));
   FdDirection.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDirection);

  FFdFarDistance := TSFFloat.Create(Self, True, 'farDistance', -1);
   FdFarDistance.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFarDistance);

  FFdLocation := TSFVec3f.Create(Self, True, 'location', Vector3(0, 0, 0));
   FdLocation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLocation);

  FFdNearDistance := TSFFloat.Create(Self, True, 'nearDistance', -1);
   FdNearDistance.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdNearDistance);

  FFdTexture := TSFNode.Create(Self, True, 'texture', [TAbstractTexture2DNode]);
   FdTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTexture);

  FEventAspectRatio := TSFFloatEvent.Create(Self, 'aspectRatio', false);
  AddEvent(FEventAspectRatio);
end;

{$endif read_implementation}
