#!/bin/sh
#
# Copyright (C) 2006  Andrea Arcangeli <andrea@cpushare.com>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation;
# only version 2.1 of the License.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

DEST=/opt/crosstool
SRCDIR=crosstool-0.43
SRC=http://kegel.com/crosstool/$SRCDIR.tar.gz
PACKAGE=`basename $SRC`

DIR=`dirname $0`
cd $DIR

echo "This script is only useful to the buyers and it will create lots data in"
echo "'$DIR/tmp', '~/downloads' and '$DEST', press C^c to stop"
echo "if you're a seller or RETURN to build the cross compilation toolchain"
echo "if you're a buyer."
echo -n 'Press RETURN to continue or C^c to interrupt: '
read

echo "Crosstool compilation started"

(touch $DEST/cpushare 2>/dev/null && rm $DEST/cpushare) || \
(echo Please type the root password to create $DEST owned by user $USER && su -c "mkdir -p $DEST && chown $USER $DEST") || \
exit 1

mkdir tmp 2>/dev/null
rm -rf tmp/$SRCDIR 2>/dev/null
#rm -rf $DEST/* 2>/dev/null

pushd tmp # stack client home

set -ex

if ! [ -f $PACKAGE ]; then
    wget $SRC
fi
tar xzf $PACKAGE

cd $SRCDIR
unset LD_LIBRARY_PATH

export TARBALLS_DIR=$HOME/downloads
export RESULT_TOP=/opt/crosstool
export GCC_LANGUAGES="c"

export BINUTILS_DIR=binutils-2.16.1
export GCC_CORE_DIR=gcc-3.3.6
export GCC_DIR=gcc-4.1.2
export GLIBC_DIR=glibc-2.3.6
export LINUX_DIR=linux-2.6.15.4
export LINUX_SANITIZED_HEADER_DIR=linux-libc-headers-2.6.12.0
export GLIBCTHREADS_FILENAME=glibc-linuxthreads-2.3.6

eval `cat powerpc-750.dat`  sh all.sh --notest
eval `cat i686.dat` sh all.sh --notest

# uncomment this if you need a x86-64 cross compiler
#eval `cat x86_64.dat` sh all.sh --notest

popd # pop client home
rm -rf tmp/$SRCDIR
