title: Ticket Authentication
toc: [Documentation, Administration, Authentication, Ticket Authentication]

# Ticket Authentication

**WAMP-Ticket Authentication** is a simple cleartext challenge scheme. A client connects to a realm under some `authid` and requests the authentication method. Crossbar will "challenge" the client, asking for a ticket. The client sends the ticket, and Crossbar.io then checks its validity.

If you want cookies to be invalidated, pass `wamp.close.logout` when calling `.leave()` on your session

There are two possibilities for the checking:

* **static**, where the ticket is stored in the Crossbar.io configuration
* **dynamic**, where an authenticator component is called which determines This

## Static

Static WAMP-Ticket is set by configuring a respective `auth` attribute on the transport:

```javascript
"auth": {
    "ticket": {
        "type": "static",
        "principals": {
            "joe": {
                "ticket": "secret!!!",
                "role": "frontend"
            }
        }
    }
}
```

The required `principals` dictionary maps the `authid` provided by the client to the secret being shared (`ticket`) and the `authrole` which is assigned to the client after successful authentication.

parameter | description
---|---
**`type`** | `"static"`
**`principals`** | A dictionary of names mapping to values being dictionaries as below.

Each principal has this associated dictionary:

attribute | description
---|---
**`ticket`** | Arbitrary text value for authenticating ticket (**required**).
**`role`** | `authrole` a client using this ticket will be authenticated under.

You can use **environment variables** to hold the secret if you do not want to add this directly to the config.

```javascript
        "principals": {
            "joe": {
                "ticket": "${MYTICKET}",
                "role": "frontend"
            }
        }
```

Here you need to set the environment variable `MYTICKET` before starting Crossbar.io.

We provide a [full working example](https://github.com/crossbario/crossbarexamples/tree/master/authentication/ticket/static) for WAMP-Ticket authentication with static configuration.

## Dynamic

With dynamic authentication, you provide the URI of an authenticator componenet which is called on each registration attempt.

```javascript
"auth": {
      "ticket": {
         "type": "dynamic",
         "authenticator": "com.example.authenticate"
      }
   }
```

The `authid` and `ticket` provided by the client attempting to authenticate are provided to this component as part of a larger set of data, which also includes information about the transport.

parameter | description
---|---
**`type`** | `"dynamic"`
**`authenticator`** | URI of custom authenticator to call.

We provide a [full working example](https://github.com/crossbario/crossbarexamples/tree/master/authentication/ticket/dynamic) for WAMP-Ticket authentication with dynamic authentication.

For more on dynamic authenticators read [this documentation page](Dynamic Authenticators).

## TOTP authentication

[TOTP](https://en.wikipedia.org/wiki/Time-based_One-time_Password_Algorithm) (Time-based One-Time Password algorithm) is a method where one-time passwords are generated by the party attempting to authenticate and the authenticating party based on a shared secret. Each password is only valid for a limited time window.

TOTP as specified in IETF [RFC6238](https://tools.ietf.org/html/rfc6238) is used by various services such as Google and GitHub as a possible 2nd factor in authentication (e.g. with the [Google Authenticator app](https://support.google.com/accounts/answer/1066447?hl=en)).

Since this is nothing more than a ticket-based authentication with generated instead of stored tickets, WAMP-Ticket can be used to implement this.

We provide a [full working example](https://github.com/crossbario/crossbarexamples/tree/master/authentication/ticket/totp) for this.
