#include "memory"

void Memory::free(void *ptr) {
    if (!ptr)
	return;

    static int lock;
    
    for (unsigned i = 0; i < s_memlog.size(); i++) {
	mutex_lock(&lock);
	MemoryEntry ent = s_memlog[i];
	mutex_unlock(&lock);
	if (ent.ptr == ptr) {
	    if (s_follow) {
		mutex_lock(&cout);
		cout << "Memory::free(" << ptr << ")\n";
		mutex_unlock(&cout);
	    }
	    ::free (ent.ptr);
	    mutex_lock(&lock);
	    s_memlog.erase(s_memlog.begin() + i);
	    mutex_unlock(&lock);
	    return;
	}
    }
    cerr << "FREE Request for non previously allocated memory\n";
}
