/*
 * Copyright (C) 2014 Svetlana Tkachenko svetlana.tkachenko@fastmail.com
 * GPL v3 or higher.
 */

// Load Services
const { classes: Cc, interfaces: Ci, utils: Cu, results: Cr } = Components;
Cu.import("resource://gre/modules/Services.jsm");

const DEFAULT_MIN = 32;
const DEFAULT_MAX = 250;

var customTabWidth = {
	_T: function(...args) {
		return args.concat("").join("\n");
	},
	makeSheet: function([minsize, maxsize]) {
		var sheet = this._T("@namespace url(http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul);");
		sheet += this._T(
		  ".tabbrowser-tab[fadein]:not([pinned]) {",
		  "  min-width: "+minsize+"px !important;",
		  "  max-width: "+maxsize+"px !important;",
		  "}"
		);
		return "data:text/css;charset=utf-8," + escape(sheet);
	},
	oldValues: [100,250],
	removeOldSheet: function() {
		let styleSheetService= Cc["@mozilla.org/content/style-sheet-service;1"]
                             .getService(Ci.nsIStyleSheetService);
    let styleSheetURI = Services.io.newURI(this.makeSheet(this.oldValues), null, null);
    // console.log("[ ] remove sheet " + this.makeSheet(this.oldValues) );
    if (styleSheetService.sheetRegistered(styleSheetURI, styleSheetService.AUTHOR_SHEET)) {
			styleSheetService.unregisterSheet(styleSheetURI, styleSheetService.AUTHOR_SHEET);
			// console.log("[x] remove sheet " + this.makeSheet(this.oldValues) );
    }
	},
	addNewSheet: function() {
    let min = DEFAULT_MIN;
    let max = DEFAULT_MAX;
    try {
  		min = Math.max(20, Services.prefs.getIntPref("browser.tabs.tabMinWidth"));
	   	max = Math.max(20, Services.prefs.getIntPref("browser.tabs.tabMaxWidth"));
    } catch (e) {}
		let styleSheetService= Cc["@mozilla.org/content/style-sheet-service;1"]
                             .getService(Ci.nsIStyleSheetService);
    let styleSheetURI = Services.io.newURI(this.makeSheet([min,max]), null, null);
    // console.log("[ ] add sheet " + this.makeSheet([min,max]));
    styleSheetService.loadAndRegisterSheet(styleSheetURI, styleSheetService.AUTHOR_SHEET);
    customTabWidth.oldValues = [min,max];
    // console.log("[X] add sheet " + this.makeSheet([min,max]));
	},
	updateSheet: function() {
		customTabWidth.removeOldSheet();
		customTabWidth.addNewSheet();
	}
};

function startup(data, reason) {
	Services.prefs.addObserver("browser.tabs.tabMinWidth", customTabWidth.updateSheet, false);
	Services.prefs.addObserver("browser.tabs.tabMaxWidth", customTabWidth.updateSheet, false);
	customTabWidth.updateSheet();
}

function shutdown(data, reason) {
	customTabWidth.removeOldSheet();
	Services.prefs.removeObserver("browser.tabs.tabMinWidth", customTabWidth.updateSheet);
	Services.prefs.removeObserver("browser.tabs.tabMaxWidth", customTabWidth.updateSheet);
}

function install(data, reason) {
	// Set prefs
	let branch = Services.prefs.getDefaultBranch("browser.tabs.");
	if (!branch.prefHasUserValue("tabMinWidth"))
  	branch.setIntPref("tabMinWidth", DEFAULT_MIN);
	if (!branch.prefHasUserValue("tabMaxWidth"))
    branch.setIntPref("tabMaxWidth", DEFAULT_MAX);
}

function uninstall(data, reason) {
}
