//
// C++ Implementation: FinishedModel
//
// Description: 
//
//
// Author: Rikard Björklind <olof@linux.nu>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "finishedmodel.h"
#include <QtCore>
#include "log.h"


QVariant FinishedModel::data ( const QModelIndex & index, int role ) const
{
    if(!index.isValid()) return QVariant();
    if(index.row() < 0 || index.row() >= itemList.size()) return QVariant();
    if(index.column() < 0 || index.column()>4) return QVariant();
    if(role == Qt::DisplayRole) {
        int i = index.row();
        switch(index.column()) {
           case 0:
			   return itemList[i]->type==0?tr("Upload"):tr("Download");
            case 1:
                return itemList[i]->target;
            case 2:
                return itemList[i]->user;
			case 3:
                return itemList[i]->hub;
        }
    }
    return QVariant();
}

QVariant FinishedModel::headerData ( int section, Qt::Orientation orientation, int role ) const
{
    if (role != Qt::DisplayRole)
        return QVariant();

    if(orientation==Qt::Horizontal) {
        
		if(section==0) return tr("Type");
		if(section==1) return tr("Target");
		if(section==2) return tr("User");
		if(section==3) return tr("Hub");
    }
    return QVariant();
}

void FinishedModel::onItemAdded( const FinishedItem& item)
{
	logger->debug("FinishedModel::onItemAdded: %d",item.id);
    items[item.id] = item;
    itemList.append( &items[item.id] );
	emit layoutChanged();
}

void FinishedModel::onItemRemoved( int id )
{
	logger->debug("FinishedModel::onItemRemoved: %d",id);
    itemList.removeAll(&items[id]);   
    items.remove(id);
	emit layoutChanged();
}

void FinishedModel::onAllRemoved(int type)
{
	logger->debug("FinishedModel::onAllRemoved: %d",type);
	QList<FinishedItem*>::iterator it = itemList.begin();
	while(it != itemList.end()) {
		FinishedItem *fi = *it;
		if(fi->type == type)
		{
			it = itemList.erase(it);
			items.remove(fi->id);
		}
		else
		  it++;
	}


}






    