# Ear Candy - Pulseaduio sound managment tool
# Copyright (C) 2008 Jason Taylor
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


import sys
import gobject
import re
import time
import gtk

from earcandy.util.Threads import threaded
from glade_window import GladeWindow
from EarCandyAppSelect import EarCandyAppSelect
from EarCandyClientProperties import EarCandyClientProperties
from Client import Client

class EarCandayPrefs(GladeWindow):
    def __init__(self, core):
        
        self.core = core

        self.vals = {"" : 0, "music" : 1, "video" : 2, "phone": 3}

        GladeWindow.__init__(self, "pulseoptions.glade", "dialog_options")

        self.treeview_pulse_clients = self.wtree.get_object("treeview_pulse_clients")
        self.label_pulse_client = self.wtree.get_object("label_pulse_client")
        self.entry_pulse_client_description = self.wtree.get_object("entry_pulse_client_description")
        self.comboboxentry_window_match = self.wtree.get_object("comboboxentry_window_match")
        self.radiobutton_do_not_mute_others = self.wtree.get_object("radiobutton_do_not_mute_others")
        self.radiobutton_mute_others_onfocus = self.wtree.get_object("radiobutton_mute_others_onfocus")
        self.radiobutton_mute_others_focus = self.wtree.get_object("radiobutton_mute_others_focus")
        self.checkbutton_mute_onblur = self.wtree.get_object("checkbutton_mute_onblur")
        self.checkbutton_do_not_mute = self.wtree.get_object("checkbutton_do_not_mute")
        self.vscale_volume = self.wtree.get_object("vscale_volume")
        self.vscale_mute = self.wtree.get_object("vscale_mute")
        self.combobox_profile = self.wtree.get_object("combobox_profile")
        self.entry_application = self.wtree.get_object("entry_application")
        self.entry_command = self.wtree.get_object("entry_command")
        self.entry_window_title = self.wtree.get_object("entry_window_title")
        self.checkbutton_channel_window = self.wtree.get_object("checkbutton_channel_window")
        self.label_client = self.wtree.get_object("label_client")
        self.hscale_fade = self.wtree.get_object("hscale_fade")
        self.hscale_mute_level = self.wtree.get_object("hscale_mute_level")
        self.checkbutton_tray = self.wtree.get_object("checkbutton_tray")
        self.checkbutton_output = self.wtree.get_object("checkbutton_output")
        self.combobox_view = self.wtree.get_object("combobox_view")
        self.checkbutton_autostart = self.wtree.get_object("checkbutton_autostart")
        self.treeview_plugins = self.wtree.get_object("treeview_plugins")
        self.checkbutton_mute_phone = self.wtree.get_object("checkbutton_mute_phone")
        self.combobox_sink = self.wtree.get_object("combobox_sink")
        self.vbox_repeater = self.wtree.get_object("vbox_repeater")
        self.table_clients = self.wtree.get_object("table_clients")
        self.treeview_outputs = self.wtree.get_object("treeview_outputs")

        signals = {
            "on_entry_pulse_client_description_changed" : self.on_entry_pulse_client_description_changed,
            "on_combobox_profile_changed" : self.on_combobox_profile_changed,
            "on_entry_application_changed" : self.on_entry_application_changed,
            "on_entry_command_changed" : self.on_entry_command_changed,
            "on_entry_window_title_changed" : self.on_entry_window_title_changed,
            #"on_vscale_volume_change_value" : self.on_vscale_volume_change_value,
            #"on_vscale_mute_change_value" : self.on_vscale_mute_change_value,
            "on_checkbutton_channel_window_toggled" : self.on_checkbutton_channel_window_toggled,

            "on_treeview_pulse_clients_cursor_changed" : self.on_treeview_pulse_clients_cursor_changed,
            "on_comboboxentry_window_match_changed" : self.on_comboboxentry_window_match_changed,
            "on_entry_pulse_client_description_changed" : self.on_entry_pulse_client_description_changed,
            "on_toolbutton_delete_clicked" : self.on_toolbutton_delete_clicked,
            "on_toolbutton_edit_clicked" : self.on_toolbutton_edit_clicked,
            
            "on_hscale_mute_level_value_changed" : self.on_hscale_mute_level_value_changed,   
            "on_hscale_fade_value_changed" : self.on_hscale_fade_value_changed,         

            "on_close_button_clicked" : self.on_close_button_clicked,
            "on_button_add_new_clicked" : self.on_button_add_new_clicked,

            "on_checkbutton_tray_toggled" : self.on_checkbutton_tray_toggled,
            "on_checkbutton_output_toggled" : self.on_checkbutton_output_toggled,

            "on_combobox_view_changed" : self.on_combobox_view_changed,
            "on_treeview_pulse_clients_row_activated" : self.on_toolbutton_edit_clicked,

            "on_button_reset_clicked" : self.on_button_reset_clicked,

            "on_checkbutton_autostart_toggled" : self.on_checkbutton_autostart_toggled,

            "on_checkbutton_mute_phone_toggled" : self.on_checkbutton_mute_phone_toggled,

            "on_combobox_sink_changed" : self.on_combobox_sink_changed,

            "on_treeview_outputs_drag_drop" : self.on_treeview_outputs_drag_drop
        }
        self.wtree.connect_signals(signals)

        #list store for cell renderer
        self.cb_model = gtk.ListStore(str)
        for key in self.core.display.keys():
            self.cb_model.append([self.core.display[key]])

        self.last_popup = None
        self.last_path = None
        #self.update_treeview()

        self.checkbutton_autostart.set_active( self.core.is_auto_start() )
        self.checkbutton_mute_phone.set_active( self.core.mute_phone )


        column_label = gtk.TreeViewColumn(('Source'))
        cell = gtk.CellRendererText()
        column_label.pack_start(cell, True)
        column_label.set_attributes(cell, markup=1)
        self.treeview_outputs.append_column(column_label)
        column_label.set_expand(True)
        self.store = gtk.ListStore(str, str, object)
        self.treeview_outputs.set_model(self.store) 

        self.clients = {}

        # fix color : Fix this for dark themes....
        style = gtk.Style()
        viewport1 = self.wtree.get_object("viewport1")
        viewport1.modify_bg(gtk.STATE_NORMAL, style.base[gtk.STATE_NORMAL])


    def on_treeview_outputs_drag_drop(self, widget, b):
        self.update_ouput_order()


    def on_combobox_sink_changed(self, widget):
        
        return

    def on_treeview_plugins_toggled(self, cell, path):
        model =  self.treeview_plugins.get_model()
        iter = model.get_iter((int(path),))
        if not iter: return

        model[path][0] = not model[path][0]
        model[path][2].enabled = model[path][0]

    def on_checkbutton_mute_phone_toggled(self, widget):
        self.core.mute_phone = not self.core.mute_phone

    def on_checkbutton_autostart_toggled(self, widget):
        self.core.set_auto_start( widget.get_active() )

    def on_button_reset_clicked(self, widget):

        md = gtk.MessageDialog(self.window, flags=0, type=gtk.MESSAGE_WARNING, buttons=gtk.BUTTONS_YES_NO, message_format="Are you sure you want to reset all your settings?") 
        result = md.run()
        md.destroy()
        if result == gtk.RESPONSE_YES:
            self.window.destroy()
            self.core.reset_all()
            self.core.pref = None
            self.core.open_preferances()

    def cell_edit_start(self,  editable, control, path):
        self.last_popup = control
        self.last_path = path

    def on_combobox_view_changed(self, widget):
        return
        #self.update_treeview()


    def on_checkbutton_tray_toggled(self, widget):
        self.core.status_icon.set_visible( widget.get_active() )

    def on_checkbutton_output_toggled(self, widget):
        self.core.follow_new_outputs = widget.get_active()

    def on_client_fade_toggled(self, cell, path):
        model =  self.treeview_pulse_clients.get_model()
        iter = model.get_iter((int(path),))
        if not iter: return

        model[path][3] = not model[path][3]

        self.selected_client = model.get_value(iter, 5)
        self.selected_client.apply_volume_meter_hack = model[path][3]
        
    def on_hscale_mute_level_value_changed(self, widget):
        self.core.mute_level = self.hscale_mute_level.get_value()
        print "Mute Level ", self.core.mute_level

    def on_hscale_fade_value_changed(self, widget):
        self.core.fade_timer_speed = self.hscale_fade.get_value()

    def on_client_role_changed(self, cell, row, newText):
        model, iter =  self.treeview_pulse_clients.get_selection().get_selected()
        if not iter: return
        self.selected_client = model.get_value(iter, 5)

        for key in self.core.display.keys():
            if self.core.display[key] == newText:
                self.selected_client.role = key
                self.store.set(iter,
                    2,  newText
                )
                break

    def on_toolbutton_delete_clicked(self, widget):
        model, iter =  self.treeview_pulse_clients.get_selection().get_selected()
        if not iter: return
        self.selected_client = model.get_value(iter, 5)
        md = gtk.MessageDialog(self.window, flags=0, type=gtk.MESSAGE_QUESTION, buttons=gtk.BUTTONS_YES_NO, message_format="Are you sure you want to delete this rule?") 
        result = md.run()
        md.destroy()
        if result == gtk.RESPONSE_YES:
            self.selected_client.role = ""
            self.selected_client.iter = None
            self.store.remove(iter)
        self.core.save()


    def on_toolbutton_edit_clicked(self, widget, a=None, b=None):
        model, iter =  self.treeview_pulse_clients.get_selection().get_selected()
        if not iter: return
        self.selected_client = model.get_value(iter, 5)
        



    def open_client_properties(self, client):
        eccp = EarCandyClientProperties(self.core, client, self.window)
        eccp.run()
        self.update_client(client)
        self.core.save()

    def on_button_add_new_clicked(self, widget):
        
        if len(self.core.get_unregistered_clients()) > 0:
        
            ecas = EarCandyAppSelect(self.core)
            client = ecas.run()
            if client:
                self.update_client( client )
        else:
            md = gtk.MessageDialog(self.window, flags=0, type=gtk.MESSAGE_QUESTION, buttons=gtk.BUTTONS_OK, message_format="There are currently no pulseaudio streams unassigned,\n\nYou will need to start your sound application playing first") 
            result = md.run()
            md.destroy()

    def on_entry_pulse_client_description_changed(self, widget):
        self.current_client.description = widget.get_text()

    def on_entry_application_changed(self, widget):
        self.current_client.rule_re_application = re.compile(widget.get_text(), re.IGNORECASE)

    def on_entry_command_changed(self, widget):
        self.current_client.rule_re_command = re.compile(widget.get_text(), re.IGNORECASE)
    
    def on_entry_window_title_changed(self, widget):
        self.current_client.rule_re_window_title = re.compile(widget.get_text(), re.IGNORECASE)        

    def on_combobox_profile_changed(self, widget):
        for key in self.vals.keys():
            if self.vals[key] == self.combobox_profile.get_active():
                self.current_client.role = key
                self.core.save()

    def on_vscale_volume_change_value(self, widget, a, b):
        self.current_client.volume_default = self.vscale_volume.get_value()
        
    def on_vscale_mute_change_value(self, widget, a, b):
        self.current_client.volume_mute = self.vscale_mute.get_value()

    def update_label(self, cvh, model, iter):
        text = cvh.name
        if cvh.description:
            text = cvh.description
        model.set_value(iter,1, text)
        
    def on_entry_pulse_client_description_changed(self, widget):       
        model, iter =  self.treeview_pulse_clients.get_selection().get_selected()
        cvh = model.get_value(iter, 5) 
        #cvh.description = self.entry_pulse_client_description.get_text()
        self.update_label(cvh, model, iter)
        
    def on_comboboxentry_window_match_changed(self, widget):
        model, iter =  self.treeview_pulse_clients.get_selection().get_selected()
        cvh = model.get_value(iter, 5) 
        cvh.window_name_rule = self.comboboxentry_window_match.get_text()
        
    def on_treeview_pulse_clients_cursor_changed(self, widget):
        model, iter =  self.treeview_pulse_clients.get_selection().get_selected()
        if not iter: return
        self.selected_client = model.get_value(iter, 5)
        self.__update_detail( self.selected_client)
    
    def on_checkbutton_channel_window_toggled(self, widget):
        self.current_client.apply_volume_meter_hack = self.checkbutton_channel_window.get_active()

    def __update_detail(self, client):
        self.current_client = client


    def on_close_button_clicked(self,widget=None):
        self.stop()
        

    def __get_title(self, client):
        text = client.name
        if client.is_active() and client.get_status():
            text = "<b>" + client.description + "</b>"
            for sink in client.sinks.values():
                text += "\n<small><i>" + sink.name + "</i></small>"
            return text

        elif not client.is_active():
            return "<i>" + client.description + "</i>"

        return client.description

    def update_treeview(self):
        for client in self.core.pa.clients.values():
            client.iter = None

        self.store = gtk.ListStore(gtk.gdk.Pixbuf, str, str, bool, int, object, str)
        self.treeview_pulse_clients.set_model(self.store) 

        icon_theme = gtk.icon_theme_get_default()
        icon = icon_theme.lookup_icon("audio-volume-medium", 32, 0).load_icon()
        for client in self.core.pa.clients.values():
            if not (client.name in self.core.ignore):
                if client.is_active() or self.combobox_view.get_active() == 1:
                    client.iter = self.store.append(([client.icon or icon, self.__get_title(client), self.core.display[client.role], client.apply_volume_meter_hack, 0, client, client.description])) 

        self.store.set_sort_column_id(6, gtk.SORT_ASCENDING)  

    def update_client(self, client):

        # load saved icon
        if not client.icon:
            if client.icon_name:
                print "load client icon", client.icon_name
                icon_theme = gtk.icon_theme_get_default()
                try:
                    client.icon = icon_theme.load_icon(client.icon_name, 32, 0)
                except:
                    client.icon = icon_theme.load_icon("audio-volume-medium", 32, 0)
            elif client.application and client.application.icon_name:
                icon_theme = gtk.icon_theme_get_default()
                try:
                    client.icon = icon_theme.load_icon(client.application.icon_name, 32, 0)
                except:
                    client.icon = icon_theme.load_icon("audio-volume-medium", 32, 0)
        
        if not self.clients.has_key(client.name):

            client_gtk = Client(client, self.core)
            self.clients[client.name] = client_gtk
            self.vbox_repeater.pack_start(client_gtk.gtk, expand=False, fill=False, padding=0)
            client_gtk.gtk.show()

            count = 0 
            for key in self.core.display.keys():
                if key == client.role: 
                    client_gtk.gtk_role_combobox.set_active(count)
                    break
                count = count + 1
        
        else:
            client_gtk = self.clients[client.name]

        client_gtk.set_status(client.is_active())

        client_gtk.gtk_progressbar_meter.set_fraction(client.get_volume() / 100)
        client_gtk.gtk_label.set_markup(self.__get_title(client))
        if client.icon: client_gtk.gtk_icon.set_from_pixbuf(client.icon)

        for key in self.core.display.keys():
            self.cb_model.append([self.core.display[key]])

        client_gtk.gtk.show()

    def update_output(self, output, priority):
        itr = self.store.get_iter_first()
        while itr:
            o = self.store.get_value(itr, 2)
            if o.name == output.name:
                if not output.index:
                    self.store.remove(itr)
                    self.update_ouput_order()
                return
            itr = self.store.iter_next(itr)

        self.store.insert(priority, ([output.name, output.description, output]))

        self.update_ouput_order()

    def update_ouput_order(self):

        itr = self.store.get_iter_first()
        count = 1
        flagCurrent = False
        while itr:
            output = self.store.get_value(itr, 2)
            output.priority = count
            if count == 1:
                self.store.set_value(itr, 1, "<b>" + output.description + "</b>")
            else:
                self.store.set_value(itr, 1, output.description)

            itr = self.store.iter_next(itr)
            
            count = count + 1

        #self.core.pa.set_default_prefered_device()

    def run(self):
        self.window.show()  
        self.hscale_mute_level.set_value(self.core.mute_level)
        self.hscale_fade.set_value(self.core.fade_timer_speed)
        self.checkbutton_tray.set_active( self.core.status_icon.get_visible() )
        self.window.present()
        self.core.pa.pa_context_get_sink_info_list()
        return self.return_value

    def stop(self):
        self.core.save()
        self.core.close_preferances()
        self.window.destroy()
    



