# Ear Candy - Pulseaduio sound managment tool
# Copyright (C) 2008 Jason Taylor
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
import gtk
import os, sys

from earcandy.earcandyconfig import getdatapath

class GladeWindow():

    def __init__(self, glade_file, window_name, parent=None):
        self.return_value = None
        self.parent = parent

        ui_filename = os.path.join(getdatapath(), 'ui', 'EarCandy.ui')
        if not os.path.exists(ui_filename):
            ui_filename = None

        self.wtree = gtk.Builder()
        self.wtree.add_from_file(ui_filename)

        self.window = self.wtree.get_object(window_name)
        self.window.connect("destroy", self.on_destroy)
        if parent: self.window.set_transient_for(parent)
        
    def run(self):
        self.window.show()   
        gtk.main()
        return self.return_value

    def stop(self):
        self.window.destroy()
        gtk.main_quit()

    def on_destroy(self, widget, data=None):
        self.stop()
