# Contributing to Eclipse Platform

Thanks for your interest in this project.

## Project description

Eclipse Platform defines the set of frameworks and common services that
collectively make up infrastructure required to support the use of Eclipse as a
component model, as a Rich Client Platform (RCP) and as a comprehensive tool
integration platform. These services and frameworks include a standard workbench
user interface model and portable native widget toolkit, a project model for
managing resources, automatic resource delta management for incremental
compilers and builders, language-independent debug infrastructure, and
infrastructure for distributed multi-user versioned resource management.

* https://projects.eclipse.org/projects/eclipse.platform

## Developer resources

Information regarding source code management, builds, coding standards, and
more.

* https://projects.eclipse.org/projects/eclipse.platform/developer

The project maintains the following source code repositories

* https://github.com/eclipse-platform/eclipse.platform.common
* https://github.com/eclipse-platform/eclipse.platform.debug
* https://github.com/eclipse-platform/eclipse.platform
* https://github.com/eclipse-platform/eclipse.platform.releng.aggregator
* https://github.com/eclipse-platform/eclipse.platform.releng.buildtools
* https://github.com/eclipse-platform/eclipse.platform.releng
* https://github.com/eclipse-platform/eclipse.platform.swt
* https://github.com/eclipse-platform/eclipse.platform.swt.binaries
* https://github.com/eclipse-platform/eclipse.platform.text
* https://github.com/eclipse-platform/eclipse.platform.ua
* https://github.com/eclipse-platform/eclipse.platform.ui
* https://github.com/eclipse-platform/eclipse.platform.ui.tools

This project uses Github to track ongoing development and issues.

```
https://github.com/issues?user=eclipse-platform
```

Be sure to search for existing bugs before you create another one. Remember that
contributions are always welcome!

## Eclipse Contributor Agreement

Before your contribution can be accepted by the project team contributors must
electronically sign the Eclipse Contributor Agreement (ECA).

* http://www.eclipse.org/legal/ECA.php

Commits that are provided by non-committers must have a Signed-off-by field in
the footer indicating that the author is aware of the terms by which the
contribution has been provided to the project. The non-committer must
additionally have an Eclipse Foundation account and must have a signed Eclipse
Contributor Agreement (ECA) on file.

For more information, please see the Eclipse Committer Handbook:
https://www.eclipse.org/projects/handbook/#resources-commit

## Contact

Contact the project developers via the project's "dev" list.

* https://dev.eclipse.org/mailman/listinfo/platform-dev