/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.SequenceI;
import jalview.util.ShiftList;
import java.util.Enumeration;
import java.util.Vector;

public class ColumnSelection {
    Vector selected = new Vector();
    Vector hiddenColumns;

    public void addElement(int col) {
        Integer column = new Integer(col);
        if (!this.selected.contains(column)) {
            this.selected.addElement(column);
        }
    }

    public void clear() {
        this.selected.removeAllElements();
    }

    public void removeElement(int col) {
        Integer colInt = new Integer(col);
        if (this.selected.contains(colInt)) {
            this.selected.removeElement(colInt);
        }
    }

    public void removeElements(int start, int end) {
        for (int i = start; i < end; ++i) {
            Integer colInt = new Integer(i);
            if (!this.selected.contains(colInt)) continue;
            this.selected.removeElement(colInt);
        }
    }

    public Vector getSelected() {
        return this.selected;
    }

    public boolean contains(int col) {
        return this.selected.contains(new Integer(col));
    }

    public int columnAt(int i) {
        return (Integer)this.selected.elementAt(i);
    }

    public int size() {
        return this.selected.size();
    }

    public int getMax() {
        int max = -1;
        for (int i = 0; i < this.selected.size(); ++i) {
            if (this.columnAt(i) <= max) continue;
            max = this.columnAt(i);
        }
        return max;
    }

    public int getMin() {
        int min = 1000000000;
        for (int i = 0; i < this.selected.size(); ++i) {
            if (this.columnAt(i) >= min) continue;
            min = this.columnAt(i);
        }
        return min;
    }

    public Vector compensateForEdit(int start, int change) {
        Vector deletedHiddenColumns = null;
        for (int i = 0; i < this.size(); ++i) {
            int temp = this.columnAt(i);
            if (temp < start) continue;
            this.selected.setElementAt(new Integer(temp - change), i);
        }
        if (this.hiddenColumns != null) {
            deletedHiddenColumns = new Vector();
            int hSize = this.hiddenColumns.size();
            for (int i = 0; i < hSize; ++i) {
                int[] region = (int[])this.hiddenColumns.elementAt(i);
                if (region[0] > start && start + change > region[1]) {
                    deletedHiddenColumns.addElement(this.hiddenColumns.elementAt(i));
                    this.hiddenColumns.removeElementAt(i);
                    --i;
                    --hSize;
                    continue;
                }
                if (region[0] > start) {
                    region[0] = region[0] - change;
                    region[1] = region[1] - change;
                }
                if (region[0] >= 0) continue;
                region[0] = 0;
            }
            this.revealHiddenColumns(0);
        }
        return deletedHiddenColumns;
    }

    private void compensateForDelEdits(int start, int change) {
        int i;
        for (i = 0; i < this.size(); ++i) {
            int temp = this.columnAt(i);
            if (temp < start) continue;
            this.selected.setElementAt(new Integer(temp - change), i);
        }
        if (this.hiddenColumns != null) {
            for (i = 0; i < this.hiddenColumns.size(); ++i) {
                int[] region = (int[])this.hiddenColumns.elementAt(i);
                if (region[0] >= start) {
                    region[0] = region[0] - change;
                }
                if (region[1] >= start) {
                    region[1] = region[1] - change;
                }
                if (region[1] < region[0]) {
                    this.hiddenColumns.removeElementAt(i--);
                }
                if (region[0] < 0) {
                    region[0] = 0;
                }
                if (region[1] >= 0) continue;
                region[1] = 0;
            }
        }
    }

    public ShiftList compensateForEdits(ShiftList shiftrecord) {
        if (shiftrecord != null) {
            Vector shifts = shiftrecord.shifts;
            if (shifts != null && shifts.size() > 0) {
                int shifted = 0;
                int j = shifts.size();
                for (int i = 0; i < j; ++i) {
                    int[] sh = (int[])shifts.elementAt(i);
                    this.compensateForDelEdits(shifted + sh[0], sh[1]);
                    shifted -= sh[1];
                }
            }
            return shiftrecord.getInverse();
        }
        return null;
    }

    private boolean pruneIntervalVector(Vector deletions, Vector intervals) {
        boolean pruned = false;
        int i = 0;
        int j = intervals.size() - 1;
        int s = 0;
        int t = deletions.size() - 1;
        int[] hr = (int[])intervals.elementAt(i);
        int[] sr = (int[])deletions.elementAt(s);
        while (i <= j && s <= t) {
            boolean trailinghc;
            boolean trailinghn;
            boolean bl = trailinghn = hr[1] >= sr[0];
            if (!trailinghn) {
                if (i < j) {
                    hr = (int[])intervals.elementAt(++i);
                    continue;
                }
                ++i;
                continue;
            }
            int endshift = sr[0] + sr[1];
            if (endshift < hr[0] || endshift < sr[0]) {
                if (s < t) {
                    sr = (int[])deletions.elementAt(++s);
                    continue;
                }
                ++s;
                continue;
            }
            boolean leadinghn = hr[0] >= sr[0];
            boolean leadinghc = hr[0] < endshift;
            boolean bl2 = trailinghc = hr[1] < endshift;
            if (leadinghn) {
                if (trailinghc) {
                    intervals.removeElementAt(i);
                    pruned = true;
                    if (i > --j) continue;
                    hr = (int[])intervals.elementAt(i);
                    continue;
                }
                if (leadinghc) {
                    hr[0] = endshift;
                    leadinghn = !leadinghn;
                    pruned = true;
                }
            }
            if (leadinghn) continue;
            if (trailinghc) {
                if (!trailinghn) continue;
                hr[1] = sr[0] - 1;
                pruned = true;
                continue;
            }
            if (s < t) {
                sr = (int[])deletions.elementAt(++s);
                continue;
            }
            ++s;
        }
        return pruned;
    }

    private boolean pruneColumnList(Vector deletion, Vector list) {
        int s = 0;
        int t = deletion.size();
        int[] sr = (int[])list.elementAt(s++);
        boolean pruned = false;
        int i = 0;
        int j = list.size();
        while (i < j && s <= t) {
            int c;
            if (sr[0] > (c = ((Integer)list.elementAt(i++)).intValue())) continue;
            if (sr[1] + sr[0] >= c) {
                list.removeElementAt(--i);
                --j;
                continue;
            }
            if (s < t) {
                sr = (int[])deletion.elementAt(s);
            }
            ++s;
        }
        return pruned;
    }

    public void pruneDeletions(ShiftList deletions) {
        Vector shifts;
        if (deletions != null && (shifts = deletions.shifts) != null && shifts.size() > 0) {
            if (this.hiddenColumns != null) {
                this.pruneIntervalVector(shifts, this.hiddenColumns);
                if (this.hiddenColumns != null && this.hiddenColumns.size() == 0) {
                    this.hiddenColumns = null;
                }
            }
            if (this.selected != null && this.selected.size() > 0) {
                this.pruneColumnList(shifts, this.selected);
                if (this.selected != null && this.selected.size() == 0) {
                    this.selected = null;
                }
            }
            this.compensateForEdits(deletions);
        }
    }

    public Vector getHiddenColumns() {
        return this.hiddenColumns;
    }

    public int adjustForHiddenColumns(int column) {
        int result = column;
        if (this.hiddenColumns != null) {
            for (int i = 0; i < this.hiddenColumns.size(); ++i) {
                int[] region = (int[])this.hiddenColumns.elementAt(i);
                if (result < region[0]) continue;
                result += region[1] - region[0] + 1;
            }
        }
        return result;
    }

    public int findColumnPosition(int hiddenColumn) {
        int result = hiddenColumn;
        if (this.hiddenColumns != null) {
            int index = 0;
            int gaps = 0;
            do {
                int[] region;
                if (hiddenColumn <= (region = (int[])this.hiddenColumns.elementAt(index))[1]) continue;
                result -= region[1] + 1 - region[0];
            } while (++index < this.hiddenColumns.size());
            result -= gaps;
        }
        return result;
    }

    public int findHiddenRegionPosition(int hiddenRegion) {
        int result = 0;
        if (this.hiddenColumns != null) {
            int index = 0;
            int gaps = 0;
            do {
                int[] region = (int[])this.hiddenColumns.elementAt(index);
                if (hiddenRegion == 0) {
                    return region[0];
                }
                gaps += region[1] + 1 - region[0];
                result = region[1] + 1;
            } while (++index < hiddenRegion + 1);
            result -= gaps;
        }
        return result;
    }

    public int getHiddenBoundaryRight(int alPos) {
        if (this.hiddenColumns != null) {
            int index = 0;
            do {
                int[] region;
                if (alPos >= (region = (int[])this.hiddenColumns.elementAt(index))[0]) continue;
                return region[0];
            } while (++index < this.hiddenColumns.size());
        }
        return alPos;
    }

    public int getHiddenBoundaryLeft(int alPos) {
        if (this.hiddenColumns != null) {
            int index = this.hiddenColumns.size() - 1;
            do {
                int[] region;
                if (alPos <= (region = (int[])this.hiddenColumns.elementAt(index))[1]) continue;
                return region[1];
            } while (--index > -1);
        }
        return alPos;
    }

    public void hideSelectedColumns() {
        while (this.size() > 0) {
            int column = (Integer)this.getSelected().firstElement();
            this.hideColumns(column);
        }
    }

    public void hideColumns(int start, int end) {
        if (this.hiddenColumns == null) {
            this.hiddenColumns = new Vector();
        }
        boolean added = false;
        boolean overlap = false;
        for (int i = 0; i < this.hiddenColumns.size(); ++i) {
            int[] region = (int[])this.hiddenColumns.elementAt(i);
            if (start <= region[1] && end >= region[0]) {
                this.hiddenColumns.removeElementAt(i);
                overlap = true;
                break;
            }
            if (end >= region[0] || start >= region[0]) continue;
            this.hiddenColumns.insertElementAt(new int[]{start, end}, i);
            added = true;
            break;
        }
        if (overlap) {
            this.hideColumns(start, end);
        } else if (!added) {
            this.hiddenColumns.addElement(new int[]{start, end});
        }
    }

    public void hideColumns(int col) {
        int min = col;
        int max = col + 1;
        while (this.contains(min)) {
            this.removeElement(min);
            --min;
        }
        while (this.contains(max)) {
            this.removeElement(max);
            ++max;
        }
        if (++min > --max) {
            min = max;
        }
        this.hideColumns(min, max);
    }

    public void revealAllHiddenColumns() {
        if (this.hiddenColumns != null) {
            for (int i = 0; i < this.hiddenColumns.size(); ++i) {
                int[] region = (int[])this.hiddenColumns.elementAt(i);
                for (int j = region[0]; j < region[1] + 1; ++j) {
                    this.addElement(j);
                }
            }
        }
        this.hiddenColumns = null;
    }

    public void revealHiddenColumns(int res) {
        for (int i = 0; i < this.hiddenColumns.size(); ++i) {
            int[] region = (int[])this.hiddenColumns.elementAt(i);
            if (res != region[0]) continue;
            for (int j = region[0]; j < region[1] + 1; ++j) {
                this.addElement(j);
            }
            this.hiddenColumns.removeElement(region);
            break;
        }
        if (this.hiddenColumns.size() == 0) {
            this.hiddenColumns = null;
        }
    }

    public boolean isVisible(int column) {
        if (this.hiddenColumns != null) {
            for (int i = 0; i < this.hiddenColumns.size(); ++i) {
                int[] region = (int[])this.hiddenColumns.elementAt(i);
                if (column < region[0] || column > region[1]) continue;
                return false;
            }
        }
        return true;
    }

    public ColumnSelection(ColumnSelection copy) {
        if (copy != null) {
            int i;
            int j;
            if (copy.selected != null) {
                this.selected = new Vector();
                j = copy.selected.size();
                for (i = 0; i < j; ++i) {
                    this.selected.addElement(copy.selected.elementAt(i));
                }
            }
            if (copy.hiddenColumns != null) {
                this.hiddenColumns = new Vector(copy.hiddenColumns.size());
                j = copy.hiddenColumns.size();
                for (i = 0; i < j; ++i) {
                    int[] rh = (int[])copy.hiddenColumns.elementAt(i);
                    if (rh == null) continue;
                    int[] cp = new int[rh.length];
                    System.arraycopy(rh, 0, cp, 0, rh.length);
                    this.hiddenColumns.addElement(cp);
                }
            }
        }
    }

    public ColumnSelection() {
    }

    public String[] getVisibleSequenceStrings(int start, int end, SequenceI[] seqs) {
        int iSize = seqs.length;
        String[] selection = new String[iSize];
        if (this.hiddenColumns != null && this.hiddenColumns.size() > 0) {
            for (int i = 0; i < iSize; ++i) {
                StringBuffer visibleSeq = new StringBuffer();
                Vector regions = this.getHiddenColumns();
                int blockStart = start;
                int blockEnd = end;
                for (int j = 0; j < regions.size(); ++j) {
                    int[] region = (int[])regions.elementAt(j);
                    int hideStart = region[0];
                    int hideEnd = region[1];
                    if (hideStart < start) continue;
                    if ((blockStart = Math.min(blockStart, hideEnd + 1)) > (blockEnd = Math.min(blockEnd, hideStart))) break;
                    visibleSeq.append(seqs[i].getSequence(blockStart, blockEnd));
                    blockStart = hideEnd + 1;
                    blockEnd = end;
                }
                if (end > blockStart) {
                    visibleSeq.append(seqs[i].getSequence(blockStart, end));
                }
                selection[i] = visibleSeq.toString();
            }
        } else {
            for (int i = 0; i < iSize; ++i) {
                selection[i] = seqs[i].getSequenceAsString(start, end);
            }
        }
        return selection;
    }

    public int[] getVisibleContigs(int start, int end) {
        if (this.hiddenColumns != null && this.hiddenColumns.size() > 0) {
            Vector<int[]> visiblecontigs = new Vector<int[]>();
            Vector regions = this.getHiddenColumns();
            int vstart = start;
            for (int j = 0; vstart < end && j < regions.size(); ++j) {
                int[] region = (int[])regions.elementAt(j);
                int hideStart = region[0];
                int hideEnd = region[1];
                if (hideEnd < vstart) continue;
                if (hideStart > vstart) {
                    visiblecontigs.addElement(new int[]{vstart, hideStart - 1});
                }
                vstart = hideEnd + 1;
            }
            if (vstart < end) {
                visiblecontigs.addElement(new int[]{vstart, end - 1});
            }
            int[] vcontigs = new int[visiblecontigs.size() * 2];
            int j = visiblecontigs.size();
            for (int i = 0; i < j; ++i) {
                int[] vc = (int[])visiblecontigs.elementAt(i);
                visiblecontigs.setElementAt(null, i);
                vcontigs[i * 2] = vc[0];
                vcontigs[i * 2 + 1] = vc[1];
            }
            visiblecontigs.removeAllElements();
            return vcontigs;
        }
        return new int[]{start, end - 1};
    }

    public void makeVisibleAnnotation(AlignmentAnnotation alignmentAnnotation) {
        this.makeVisibleAnnotation(-1, -1, alignmentAnnotation);
    }

    public void makeVisibleAnnotation(int start, int end, AlignmentAnnotation alignmentAnnotation) {
        if (alignmentAnnotation.annotations == null) {
            return;
        }
        if (start == end && end == -1) {
            start = 0;
            end = alignmentAnnotation.annotations.length;
        }
        if (this.hiddenColumns != null && this.hiddenColumns.size() > 0) {
            Vector<Annotation[]> annels = new Vector<Annotation[]>();
            Annotation[] els = null;
            Vector regions = this.getHiddenColumns();
            int blockStart = start;
            int blockEnd = end;
            int w = 0;
            for (int j = 0; j < regions.size(); ++j) {
                int[] region = (int[])regions.elementAt(j);
                int hideStart = region[0];
                int hideEnd = region[1];
                if (hideStart < start) continue;
                if ((blockStart = Math.min(blockStart, hideEnd + 1)) > (blockEnd = Math.min(blockEnd, hideStart))) break;
                els = new Annotation[blockEnd - blockStart];
                annels.addElement(els);
                System.arraycopy(alignmentAnnotation.annotations, blockStart, els, 0, els.length);
                w += els.length;
                blockStart = hideEnd + 1;
                blockEnd = end;
            }
            if (end > blockStart) {
                els = new Annotation[end - blockStart + 1];
                annels.addElement(els);
                if (els.length + blockStart <= alignmentAnnotation.annotations.length) {
                    System.arraycopy(alignmentAnnotation.annotations, blockStart, els, 0, els.length);
                } else {
                    System.arraycopy(alignmentAnnotation.annotations, blockStart, els, 0, alignmentAnnotation.annotations.length - blockStart);
                }
                w += els.length;
            }
            if (w == 0) {
                return;
            }
            Enumeration e = annels.elements();
            alignmentAnnotation.annotations = new Annotation[w];
            w = 0;
            while (e.hasMoreElements()) {
                Annotation[] chnk = (Annotation[])e.nextElement();
                System.arraycopy(chnk, 0, alignmentAnnotation.annotations, w, chnk.length);
                w += chnk.length;
            }
        } else {
            alignmentAnnotation.restrict(start, end);
        }
    }

    public void invertColumnSelection(int first, int width) {
        boolean hasHidden = this.hiddenColumns != null && this.hiddenColumns.size() > 0;
        for (int i = first; i < width; ++i) {
            if (this.contains(i)) {
                this.removeElement(i);
                continue;
            }
            if (hasHidden && !this.isVisible(i)) continue;
            this.addElement(i);
        }
    }
}

