# -*- coding: utf-8 -*-

import sys
from pkg_resources import get_distribution

project = 'extension-helpers'
copyright = '2019, The Astropy Developers'
author = 'The Astropy Developers'

# We need to get the version number from the package
version = release = get_distribution('extension-helpers').version

extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.doctest',
    'sphinx.ext.intersphinx',
    'sphinx.ext.napoleon',
    'sphinx_automodapi.automodapi'
]

intersphinx_mapping = {'https://docs.python.org/3/': None}

# The suffix(es) of source filenames.
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = 'alabaster'

html_theme_options = {
    "description": "A build time package to simplify C/Cython extensions.",
    "code_font_family": "'Fira Code', monospace",
    "github_user": "astropy",
    "github_repo": "extension-helpers",
    "sidebar_width": "300px"
}

# Enable nitpicky mode to pick reference issues
default_role = 'obj'
nitpicky = True
