/*
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GLUE_AUDIO_INTERNAL_H
#define __GLUE_AUDIO_INTERNAL_H

#include "glue-audio_format.h"
#include "glue-audio_driver.h"


#define GLUE_AUDIO_RATE           44100
#define GLUE_AUDIO_CHANNELS           2
#define GLUE_AUDIO_FORMAT   AFMT_S16_NE
#define GLUE_AUDIO_FORMAT_BYTES       2
#define GLUE_AUDIO_FORMAT_BITS       16


/* data structures used by plugins */
typedef struct ao_data_s
{
  int samplerate;
  int channels;
  int format;
  int bps;
  int outburst; 	  
  int buffersize;         
  int pts;
} ao_data_t;

typedef struct ao_control_vol_s {
	float left;
	float right;
} ao_control_vol_t;

/* prototypes */
static int   init(void);
static void  uninit(int immed);
static int   play(void* data,int len);
static int   get_space(void);
static float get_delay(void);

#define LIBAO_EXTERN(x) ao_functions_t audio_out_##x =\
{\
	&info,\
	init,\
        uninit,\
	play,\
	get_space,\
	get_delay, \
};

#endif /* __GLUE_AUDIO_INTERNAL_H */
