/*
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "glue-gui-gtk-led.h"
#include "glue-gui-gtk-fi.h"
#include "glue.h"

#include "isa_gen_ne2000_gui_gtk.h"

#define COMP "isa_gen_ne2000"

struct cpssp {
	unsigned int n_state_busy_led;
	GtkWidget *busy_led;
};

/*
 * Simulator Callbacks
 */
static void
gui_network_opt_busy_led_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;
	
	cpssp->n_state_busy_led = val;
	gui_gtk_led_set(GUI_GTK_LED(cpssp->busy_led), val);
	gui_gtk_flush();
}

/*
 * GUI Callbacks
 */

void *
isa_gen_ne2000_gui_gtk_create(
	unsigned int page,
	const char *name,
	const char *irq,
	const char *ioaddr,
	const char *mac,
	struct sig_manage *port_manage,
	struct sig_isa_conn *port_isa,
	struct sig_eth_conn *port_eth,
	struct sig_boolean *port_opt_busy_led
)
{
	static const struct sig_boolean_funcs opt_busy_led_funcs = {
		.set = gui_network_opt_busy_led_set,
	};
	struct cpssp *cpssp;
	GtkWidget *vbox;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	vbox = gtk_vbox_new(FALSE, 1);

	/* Busy LED */
	cpssp->n_state_busy_led = 0;
	cpssp->busy_led = gui_gtk_led_new("Busy");
	gtk_widget_show(cpssp->busy_led);
	gtk_box_pack_start(GTK_BOX(vbox), cpssp->busy_led, FALSE, FALSE, 1);

	gui_gtk_comp_add(page, COMP, name, vbox, FALSE, FALSE, NULL);

	/* Out */

	/* In */
	sig_boolean_connect_in(port_opt_busy_led, cpssp, &opt_busy_led_funcs);

	return cpssp;
}

void
isa_gen_ne2000_gui_gtk_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
isa_gen_ne2000_gui_gtk_suspend(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
isa_gen_ne2000_gui_gtk_resume(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	GtkWidget *savebusy_led = cpssp->busy_led;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
	
	cpssp->busy_led = savebusy_led;
	
	gui_network_opt_busy_led_set(cpssp, cpssp->n_state_busy_led);
}
