--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.GL.ARB
-- Copyright   :  (c) Sven Panne 2018
-- License     :  BSD3
--
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
-- A convenience module, combining all raw modules containing ARB extensions.
--
--------------------------------------------------------------------------------

module Graphics.GL.ARB (
  module Graphics.GL.ARB.BaseInstance,
  module Graphics.GL.ARB.BindlessTexture,
  module Graphics.GL.ARB.BlendFuncExtended,
  module Graphics.GL.ARB.BufferStorage,
  module Graphics.GL.ARB.CLEvent,
  module Graphics.GL.ARB.ClearBufferObject,
  module Graphics.GL.ARB.ClearTexture,
  module Graphics.GL.ARB.ClipControl,
  module Graphics.GL.ARB.ColorBufferFloat,
  module Graphics.GL.ARB.CompressedTexturePixelStorage,
  module Graphics.GL.ARB.ComputeShader,
  module Graphics.GL.ARB.ComputeVariableGroupSize,
  module Graphics.GL.ARB.ConditionalRenderInverted,
  module Graphics.GL.ARB.CopyBuffer,
  module Graphics.GL.ARB.CopyImage,
  module Graphics.GL.ARB.CullDistance,
  module Graphics.GL.ARB.DebugOutput,
  module Graphics.GL.ARB.DepthBufferFloat,
  module Graphics.GL.ARB.DepthClamp,
  module Graphics.GL.ARB.DepthTexture,
  module Graphics.GL.ARB.DirectStateAccess,
  module Graphics.GL.ARB.DrawBuffers,
  module Graphics.GL.ARB.DrawBuffersBlend,
  module Graphics.GL.ARB.DrawElementsBaseVertex,
  module Graphics.GL.ARB.DrawIndirect,
  module Graphics.GL.ARB.DrawInstanced,
  module Graphics.GL.ARB.ES2Compatibility,
  module Graphics.GL.ARB.ES31Compatibility,
  module Graphics.GL.ARB.ES32Compatibility,
  module Graphics.GL.ARB.ES3Compatibility,
  module Graphics.GL.ARB.EnhancedLayouts,
  module Graphics.GL.ARB.ExplicitUniformLocation,
  module Graphics.GL.ARB.FragmentProgram,
  module Graphics.GL.ARB.FragmentShader,
  module Graphics.GL.ARB.FramebufferNoAttachments,
  module Graphics.GL.ARB.FramebufferObjectCompatibility,
  module Graphics.GL.ARB.FramebufferObjectCore,
  module Graphics.GL.ARB.FramebufferSRGB,
  module Graphics.GL.ARB.GPUShader5,
  module Graphics.GL.ARB.GPUShaderFP64,
  module Graphics.GL.ARB.GPUShaderInt64,
  module Graphics.GL.ARB.GeometryShader4,
  module Graphics.GL.ARB.GetProgramBinary,
  module Graphics.GL.ARB.GetTextureSubImage,
  module Graphics.GL.ARB.GlSpirv,
  module Graphics.GL.ARB.HalfFloatPixel,
  module Graphics.GL.ARB.HalfFloatVertex,
  module Graphics.GL.ARB.ImagingCompatibility,
  module Graphics.GL.ARB.ImagingCore,
  module Graphics.GL.ARB.IndirectParameters,
  module Graphics.GL.ARB.InstancedArrays,
  module Graphics.GL.ARB.InternalformatQuery,
  module Graphics.GL.ARB.InternalformatQuery2,
  module Graphics.GL.ARB.InvalidateSubdata,
  module Graphics.GL.ARB.MapBufferAlignment,
  module Graphics.GL.ARB.MapBufferRange,
  module Graphics.GL.ARB.MatrixPalette,
  module Graphics.GL.ARB.MultiBind,
  module Graphics.GL.ARB.MultiDrawIndirect,
  module Graphics.GL.ARB.Multisample,
  module Graphics.GL.ARB.Multitexture,
  module Graphics.GL.ARB.OcclusionQuery,
  module Graphics.GL.ARB.OcclusionQuery2,
  module Graphics.GL.ARB.ParallelShaderCompile,
  module Graphics.GL.ARB.PipelineStatisticsQuery,
  module Graphics.GL.ARB.PixelBufferObject,
  module Graphics.GL.ARB.PointParameters,
  module Graphics.GL.ARB.PointSprite,
  module Graphics.GL.ARB.PolygonOffsetClamp,
  module Graphics.GL.ARB.ProgramInterfaceQuery,
  module Graphics.GL.ARB.ProvokingVertex,
  module Graphics.GL.ARB.QueryBufferObject,
  module Graphics.GL.ARB.RobustnessCompatibility,
  module Graphics.GL.ARB.RobustnessCore,
  module Graphics.GL.ARB.SampleLocations,
  module Graphics.GL.ARB.SampleShading,
  module Graphics.GL.ARB.SamplerObjects,
  module Graphics.GL.ARB.SeamlessCubeMap,
  module Graphics.GL.ARB.SeamlessCubemapPerTexture,
  module Graphics.GL.ARB.SeparateShaderObjects,
  module Graphics.GL.ARB.ShaderAtomicCounters,
  module Graphics.GL.ARB.ShaderImageLoadStore,
  module Graphics.GL.ARB.ShaderObjects,
  module Graphics.GL.ARB.ShaderStorageBufferObject,
  module Graphics.GL.ARB.ShaderSubroutine,
  module Graphics.GL.ARB.ShadingLanguage100,
  module Graphics.GL.ARB.ShadingLanguageInclude,
  module Graphics.GL.ARB.Shadow,
  module Graphics.GL.ARB.ShadowAmbient,
  module Graphics.GL.ARB.SparseBuffer,
  module Graphics.GL.ARB.SparseTexture,
  module Graphics.GL.ARB.SpirvExtensions,
  module Graphics.GL.ARB.StencilTexturing,
  module Graphics.GL.ARB.Sync,
  module Graphics.GL.ARB.TessellationShader,
  module Graphics.GL.ARB.TextureBarrier,
  module Graphics.GL.ARB.TextureBorderClamp,
  module Graphics.GL.ARB.TextureBufferObject,
  module Graphics.GL.ARB.TextureBufferObjectRGB32,
  module Graphics.GL.ARB.TextureBufferRange,
  module Graphics.GL.ARB.TextureCompression,
  module Graphics.GL.ARB.TextureCompressionBPTC,
  module Graphics.GL.ARB.TextureCompressionRGTC,
  module Graphics.GL.ARB.TextureCubeMap,
  module Graphics.GL.ARB.TextureCubeMapArray,
  module Graphics.GL.ARB.TextureEnvCombine,
  module Graphics.GL.ARB.TextureEnvDot3,
  module Graphics.GL.ARB.TextureFilterAnisotropic,
  module Graphics.GL.ARB.TextureFilterMinmax,
  module Graphics.GL.ARB.TextureFloat,
  module Graphics.GL.ARB.TextureGather,
  module Graphics.GL.ARB.TextureMirrorClampToEdge,
  module Graphics.GL.ARB.TextureMirroredRepeat,
  module Graphics.GL.ARB.TextureMultisample,
  module Graphics.GL.ARB.TextureRG,
  module Graphics.GL.ARB.TextureRGB10A2UI,
  module Graphics.GL.ARB.TextureRectangle,
  module Graphics.GL.ARB.TextureStencil8,
  module Graphics.GL.ARB.TextureStorage,
  module Graphics.GL.ARB.TextureStorageMultisample,
  module Graphics.GL.ARB.TextureSwizzle,
  module Graphics.GL.ARB.TextureView,
  module Graphics.GL.ARB.TimerQuery,
  module Graphics.GL.ARB.TransformFeedback2,
  module Graphics.GL.ARB.TransformFeedback3,
  module Graphics.GL.ARB.TransformFeedbackInstanced,
  module Graphics.GL.ARB.TransformFeedbackOverflowQuery,
  module Graphics.GL.ARB.TransposeMatrix,
  module Graphics.GL.ARB.UniformBufferObject,
  module Graphics.GL.ARB.VertexArrayBGRA,
  module Graphics.GL.ARB.VertexArrayObject,
  module Graphics.GL.ARB.VertexAttrib64Bit,
  module Graphics.GL.ARB.VertexAttribBinding,
  module Graphics.GL.ARB.VertexBlend,
  module Graphics.GL.ARB.VertexBufferObject,
  module Graphics.GL.ARB.VertexProgram,
  module Graphics.GL.ARB.VertexShader,
  module Graphics.GL.ARB.VertexType10f11f11fRev,
  module Graphics.GL.ARB.VertexType2101010RevCompatibility,
  module Graphics.GL.ARB.VertexType2101010RevCore,
  module Graphics.GL.ARB.ViewportArray,
  module Graphics.GL.ARB.WindowPos
) where

import Graphics.GL.ARB.BaseInstance
import Graphics.GL.ARB.BindlessTexture
import Graphics.GL.ARB.BlendFuncExtended
import Graphics.GL.ARB.BufferStorage
import Graphics.GL.ARB.CLEvent
import Graphics.GL.ARB.ClearBufferObject
import Graphics.GL.ARB.ClearTexture
import Graphics.GL.ARB.ClipControl
import Graphics.GL.ARB.ColorBufferFloat
import Graphics.GL.ARB.CompressedTexturePixelStorage
import Graphics.GL.ARB.ComputeShader
import Graphics.GL.ARB.ComputeVariableGroupSize
import Graphics.GL.ARB.ConditionalRenderInverted
import Graphics.GL.ARB.CopyBuffer
import Graphics.GL.ARB.CopyImage
import Graphics.GL.ARB.CullDistance
import Graphics.GL.ARB.DebugOutput
import Graphics.GL.ARB.DepthBufferFloat
import Graphics.GL.ARB.DepthClamp
import Graphics.GL.ARB.DepthTexture
import Graphics.GL.ARB.DirectStateAccess
import Graphics.GL.ARB.DrawBuffers
import Graphics.GL.ARB.DrawBuffersBlend
import Graphics.GL.ARB.DrawElementsBaseVertex
import Graphics.GL.ARB.DrawIndirect
import Graphics.GL.ARB.DrawInstanced
import Graphics.GL.ARB.ES2Compatibility
import Graphics.GL.ARB.ES31Compatibility
import Graphics.GL.ARB.ES32Compatibility
import Graphics.GL.ARB.ES3Compatibility
import Graphics.GL.ARB.EnhancedLayouts
import Graphics.GL.ARB.ExplicitUniformLocation
import Graphics.GL.ARB.FragmentProgram
import Graphics.GL.ARB.FragmentShader
import Graphics.GL.ARB.FramebufferNoAttachments
import Graphics.GL.ARB.FramebufferObjectCompatibility
import Graphics.GL.ARB.FramebufferObjectCore
import Graphics.GL.ARB.FramebufferSRGB
import Graphics.GL.ARB.GPUShader5
import Graphics.GL.ARB.GPUShaderFP64
import Graphics.GL.ARB.GPUShaderInt64
import Graphics.GL.ARB.GeometryShader4
import Graphics.GL.ARB.GetProgramBinary
import Graphics.GL.ARB.GetTextureSubImage
import Graphics.GL.ARB.GlSpirv
import Graphics.GL.ARB.HalfFloatPixel
import Graphics.GL.ARB.HalfFloatVertex
import Graphics.GL.ARB.ImagingCompatibility
import Graphics.GL.ARB.ImagingCore
import Graphics.GL.ARB.IndirectParameters
import Graphics.GL.ARB.InstancedArrays
import Graphics.GL.ARB.InternalformatQuery
import Graphics.GL.ARB.InternalformatQuery2
import Graphics.GL.ARB.InvalidateSubdata
import Graphics.GL.ARB.MapBufferAlignment
import Graphics.GL.ARB.MapBufferRange
import Graphics.GL.ARB.MatrixPalette
import Graphics.GL.ARB.MultiBind
import Graphics.GL.ARB.MultiDrawIndirect
import Graphics.GL.ARB.Multisample
import Graphics.GL.ARB.Multitexture
import Graphics.GL.ARB.OcclusionQuery
import Graphics.GL.ARB.OcclusionQuery2
import Graphics.GL.ARB.ParallelShaderCompile
import Graphics.GL.ARB.PipelineStatisticsQuery
import Graphics.GL.ARB.PixelBufferObject
import Graphics.GL.ARB.PointParameters
import Graphics.GL.ARB.PointSprite
import Graphics.GL.ARB.PolygonOffsetClamp
import Graphics.GL.ARB.ProgramInterfaceQuery
import Graphics.GL.ARB.ProvokingVertex
import Graphics.GL.ARB.QueryBufferObject
import Graphics.GL.ARB.RobustnessCompatibility
import Graphics.GL.ARB.RobustnessCore
import Graphics.GL.ARB.SampleLocations
import Graphics.GL.ARB.SampleShading
import Graphics.GL.ARB.SamplerObjects
import Graphics.GL.ARB.SeamlessCubeMap
import Graphics.GL.ARB.SeamlessCubemapPerTexture
import Graphics.GL.ARB.SeparateShaderObjects
import Graphics.GL.ARB.ShaderAtomicCounters
import Graphics.GL.ARB.ShaderImageLoadStore
import Graphics.GL.ARB.ShaderObjects
import Graphics.GL.ARB.ShaderStorageBufferObject
import Graphics.GL.ARB.ShaderSubroutine
import Graphics.GL.ARB.ShadingLanguage100
import Graphics.GL.ARB.ShadingLanguageInclude
import Graphics.GL.ARB.Shadow
import Graphics.GL.ARB.ShadowAmbient
import Graphics.GL.ARB.SparseBuffer
import Graphics.GL.ARB.SparseTexture
import Graphics.GL.ARB.SpirvExtensions
import Graphics.GL.ARB.StencilTexturing
import Graphics.GL.ARB.Sync
import Graphics.GL.ARB.TessellationShader
import Graphics.GL.ARB.TextureBarrier
import Graphics.GL.ARB.TextureBorderClamp
import Graphics.GL.ARB.TextureBufferObject
import Graphics.GL.ARB.TextureBufferObjectRGB32
import Graphics.GL.ARB.TextureBufferRange
import Graphics.GL.ARB.TextureCompression
import Graphics.GL.ARB.TextureCompressionBPTC
import Graphics.GL.ARB.TextureCompressionRGTC
import Graphics.GL.ARB.TextureCubeMap
import Graphics.GL.ARB.TextureCubeMapArray
import Graphics.GL.ARB.TextureEnvCombine
import Graphics.GL.ARB.TextureEnvDot3
import Graphics.GL.ARB.TextureFilterAnisotropic
import Graphics.GL.ARB.TextureFilterMinmax
import Graphics.GL.ARB.TextureFloat
import Graphics.GL.ARB.TextureGather
import Graphics.GL.ARB.TextureMirrorClampToEdge
import Graphics.GL.ARB.TextureMirroredRepeat
import Graphics.GL.ARB.TextureMultisample
import Graphics.GL.ARB.TextureRG
import Graphics.GL.ARB.TextureRGB10A2UI
import Graphics.GL.ARB.TextureRectangle
import Graphics.GL.ARB.TextureStencil8
import Graphics.GL.ARB.TextureStorage
import Graphics.GL.ARB.TextureStorageMultisample
import Graphics.GL.ARB.TextureSwizzle
import Graphics.GL.ARB.TextureView
import Graphics.GL.ARB.TimerQuery
import Graphics.GL.ARB.TransformFeedback2
import Graphics.GL.ARB.TransformFeedback3
import Graphics.GL.ARB.TransformFeedbackInstanced
import Graphics.GL.ARB.TransformFeedbackOverflowQuery
import Graphics.GL.ARB.TransposeMatrix
import Graphics.GL.ARB.UniformBufferObject
import Graphics.GL.ARB.VertexArrayBGRA
import Graphics.GL.ARB.VertexArrayObject
import Graphics.GL.ARB.VertexAttrib64Bit
import Graphics.GL.ARB.VertexAttribBinding
import Graphics.GL.ARB.VertexBlend
import Graphics.GL.ARB.VertexBufferObject
import Graphics.GL.ARB.VertexProgram
import Graphics.GL.ARB.VertexShader
import Graphics.GL.ARB.VertexType10f11f11fRev
import Graphics.GL.ARB.VertexType2101010RevCompatibility
import Graphics.GL.ARB.VertexType2101010RevCore
import Graphics.GL.ARB.ViewportArray
import Graphics.GL.ARB.WindowPos
