/* krcfile.c generated by valac 0.56.17, the Vala compiler
 * generated from krcfile.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2024 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <limits.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_KRC_FILE_KEY_VALUE_PAIR (krc_file_key_value_pair_get_type ())
typedef struct _KRcFileKeyValuePair KRcFileKeyValuePair;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_KRC_FILE_GROUP (krc_file_group_get_type ())
typedef struct _KRcFileGroup KRcFileGroup;

#define TYPE_KRC_FILE (krc_file_get_type ())
#define KRC_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KRC_FILE, KRcFile))
#define KRC_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KRC_FILE, KRcFileClass))
#define IS_KRC_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KRC_FILE))
#define IS_KRC_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KRC_FILE))
#define KRC_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KRC_FILE, KRcFileClass))

typedef struct _KRcFile KRcFile;
typedef struct _KRcFileClass KRcFileClass;
typedef struct _KRcFilePrivate KRcFilePrivate;
#define _krc_file_group_free0(var) ((var == NULL) ? NULL : (var = (krc_file_group_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _krc_file_key_value_pair_free0(var) ((var == NULL) ? NULL : (var = (krc_file_key_value_pair_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ParamSpecKRcFile ParamSpecKRcFile;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _KRcFileKeyValuePair {
	gchar* key;
	gchar* value;
};

struct _KRcFileGroup {
	gchar* name;
	GList* key_value_pairs;
};

struct _KRcFile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	KRcFilePrivate * priv;
};

struct _KRcFileClass {
	GTypeClass parent_class;
	void (*finalize) (KRcFile *self);
};

struct _KRcFilePrivate {
	KRcFileGroup* m_current_group;
	GList* m_groups;
};

struct _ParamSpecKRcFile {
	GParamSpec parent_instance;
};

static gint KRcFile_private_offset;
static gpointer krc_file_parent_class = NULL;

VALA_EXTERN GType krc_file_key_value_pair_get_type (void) G_GNUC_CONST ;
VALA_EXTERN KRcFileKeyValuePair* krc_file_key_value_pair_dup (const KRcFileKeyValuePair* self);
VALA_EXTERN void krc_file_key_value_pair_free (KRcFileKeyValuePair* self);
VALA_EXTERN void krc_file_key_value_pair_copy (const KRcFileKeyValuePair* self,
                                   KRcFileKeyValuePair* dest);
VALA_EXTERN void krc_file_key_value_pair_destroy (KRcFileKeyValuePair* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (KRcFileKeyValuePair, krc_file_key_value_pair_destroy)
VALA_EXTERN GType krc_file_group_get_type (void) G_GNUC_CONST ;
VALA_EXTERN KRcFileGroup* krc_file_group_dup (const KRcFileGroup* self);
VALA_EXTERN void krc_file_group_free (KRcFileGroup* self);
VALA_EXTERN void krc_file_group_copy (const KRcFileGroup* self,
                          KRcFileGroup* dest);
VALA_EXTERN void krc_file_group_destroy (KRcFileGroup* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (KRcFileGroup, krc_file_group_destroy)
VALA_EXTERN gpointer krc_file_ref (gpointer instance);
VALA_EXTERN void krc_file_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_krc_file (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
VALA_EXTERN void value_set_krc_file (GValue* value,
                         gpointer v_object);
VALA_EXTERN void value_take_krc_file (GValue* value,
                          gpointer v_object);
VALA_EXTERN gpointer value_get_krc_file (const GValue* value);
VALA_EXTERN GType krc_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (KRcFile, krc_file_unref)
static void _krc_file_group_free0_ (gpointer var);
static inline void _g_list_free__krc_file_group_free0_ (GList* self);
VALA_EXTERN KRcFile* krc_file_new (void);
VALA_EXTERN KRcFile* krc_file_construct (GType object_type);
static gboolean krc_file_is_comment (KRcFile* self,
                              const gchar* line);
static gboolean krc_file_is_group (KRcFile* self,
                            const gchar* line);
static gboolean krc_file_is_group_name (KRcFile* self,
                                 const gchar* name);
static gboolean krc_file_is_key_value_pair (KRcFile* self,
                                     const gchar* line);
static gboolean krc_file_is_key_name (KRcFile* self,
                               const gchar* line,
                               gsize length);
static gint krc_file_find_group (KRcFileGroup* group1,
                          KRcFileGroup* group2);
static GList* krc_file_get_group_node_with_name (KRcFile* self,
                                          const gchar* group_name,
                                          gboolean if_throw_error,
                                          GError** error);
static void krc_file_add_key_value_pair (KRcFile* self,
                                  KRcFileGroup* group,
                                  KRcFileKeyValuePair* pair,
                                  GList* sibling);
static void krc_file_add_key (KRcFile* self,
                       KRcFileGroup* group,
                       const gchar* key,
                       const gchar* value);
static void krc_file_parse_comment (KRcFile* self,
                             const gchar* line,
                             glong length);
static void krc_file_parse_group (KRcFile* self,
                           const gchar* line,
                           glong length,
                           GError** error);
static void krc_file_parse_key_value_pair (KRcFile* self,
                                    const gchar* line,
                                    glong length,
                                    GError** error);
static void krc_file_parse_line (KRcFile* self,
                          const gchar* line,
                          glong length,
                          GError** error);
static gboolean krc_file_parse_data (KRcFile* self,
                              const gchar* data,
                              gsize length);
VALA_EXTERN gboolean krc_file_load_from_file (KRcFile* self,
                                  const gchar* path,
                                  GKeyFileFlags flags,
                                  GError** error);
VALA_EXTERN gboolean krc_file_has_group (KRcFile* self,
                             const gchar* group_name);
VALA_EXTERN gchar** krc_file_get_keys (KRcFile* self,
                           const gchar* group_name,
                           gint* result_length1,
                           GError** error);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN gboolean krc_file_has_key (KRcFile* self,
                           const gchar* group_name,
                           const gchar* key,
                           GError** error);
VALA_EXTERN gboolean krc_file_remove_group (KRcFile* self,
                                const gchar* group_name,
                                GError** error);
VALA_EXTERN gboolean krc_file_remove_key (KRcFile* self,
                              const gchar* group_name,
                              const gchar* key,
                              GError** error);
VALA_EXTERN gchar* krc_file_to_data (KRcFile* self,
                         gssize* length);
VALA_EXTERN gboolean krc_file_save_to_file (KRcFile* self,
                                const gchar* filename,
                                GError** error);
VALA_EXTERN gchar* krc_file_get_value (KRcFile* self,
                           const gchar* group_name,
                           const gchar* key,
                           GError** error);
VALA_EXTERN void krc_file_set_value (KRcFile* self,
                         const gchar* group_name,
                         const gchar* key,
                         const gchar* value);
static void krc_file_finalize (KRcFile * obj);
static GType krc_file_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

void
krc_file_key_value_pair_copy (const KRcFileKeyValuePair* self,
                              KRcFileKeyValuePair* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).key;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).key);
	(*dest).key = _tmp1_;
	_tmp2_ = (*self).value;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).value);
	(*dest).value = _tmp3_;
}

void
krc_file_key_value_pair_destroy (KRcFileKeyValuePair* self)
{
	_g_free0 ((*self).key);
	_g_free0 ((*self).value);
}

KRcFileKeyValuePair*
krc_file_key_value_pair_dup (const KRcFileKeyValuePair* self)
{
	KRcFileKeyValuePair* dup;
	dup = g_new0 (KRcFileKeyValuePair, 1);
	krc_file_key_value_pair_copy (self, dup);
	return dup;
}

void
krc_file_key_value_pair_free (KRcFileKeyValuePair* self)
{
	krc_file_key_value_pair_destroy (self);
	g_free (self);
}

static GType
krc_file_key_value_pair_get_type_once (void)
{
	GType krc_file_key_value_pair_type_id;
	krc_file_key_value_pair_type_id = g_boxed_type_register_static ("KRcFileKeyValuePair", (GBoxedCopyFunc) krc_file_key_value_pair_dup, (GBoxedFreeFunc) krc_file_key_value_pair_free);
	return krc_file_key_value_pair_type_id;
}

GType
krc_file_key_value_pair_get_type (void)
{
	static volatile gsize krc_file_key_value_pair_type_id__once = 0;
	if (g_once_init_enter (&krc_file_key_value_pair_type_id__once)) {
		GType krc_file_key_value_pair_type_id;
		krc_file_key_value_pair_type_id = krc_file_key_value_pair_get_type_once ();
		g_once_init_leave (&krc_file_key_value_pair_type_id__once, krc_file_key_value_pair_type_id);
	}
	return krc_file_key_value_pair_type_id__once;
}

void
krc_file_group_copy (const KRcFileGroup* self,
                     KRcFileGroup* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GList* _tmp2_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).key_value_pairs;
	(*dest).key_value_pairs = _tmp2_;
}

void
krc_file_group_destroy (KRcFileGroup* self)
{
	_g_free0 ((*self).name);
}

KRcFileGroup*
krc_file_group_dup (const KRcFileGroup* self)
{
	KRcFileGroup* dup;
	dup = g_new0 (KRcFileGroup, 1);
	krc_file_group_copy (self, dup);
	return dup;
}

void
krc_file_group_free (KRcFileGroup* self)
{
	krc_file_group_destroy (self);
	g_free (self);
}

static GType
krc_file_group_get_type_once (void)
{
	GType krc_file_group_type_id;
	krc_file_group_type_id = g_boxed_type_register_static ("KRcFileGroup", (GBoxedCopyFunc) krc_file_group_dup, (GBoxedFreeFunc) krc_file_group_free);
	return krc_file_group_type_id;
}

GType
krc_file_group_get_type (void)
{
	static volatile gsize krc_file_group_type_id__once = 0;
	if (g_once_init_enter (&krc_file_group_type_id__once)) {
		GType krc_file_group_type_id;
		krc_file_group_type_id = krc_file_group_get_type_once ();
		g_once_init_leave (&krc_file_group_type_id__once, krc_file_group_type_id);
	}
	return krc_file_group_type_id__once;
}

static inline gpointer
krc_file_get_instance_private (KRcFile* self)
{
	return G_STRUCT_MEMBER_P (self, KRcFile_private_offset);
}

static void
_krc_file_group_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (krc_file_group_free (var), NULL));
}

static inline void
_g_list_free__krc_file_group_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _krc_file_group_free0_);
}

static gpointer
_krc_file_group_dup0 (gpointer self)
{
	return self ? krc_file_group_dup (self) : NULL;
}

KRcFile*
krc_file_construct (GType object_type)
{
	KRcFile* self = NULL;
	KRcFileGroup* group = NULL;
	KRcFileGroup _tmp0_ = {0};
	KRcFileGroup _tmp1_;
	KRcFileGroup* _tmp2_;
	KRcFileGroup* _tmp3_;
	KRcFileGroup* _tmp4_;
	GList* _tmp5_;
	gconstpointer _tmp6_;
	self = (KRcFile*) g_type_create_instance (object_type);
	memset (&_tmp0_, 0, sizeof (KRcFileGroup));
	_tmp1_ = _tmp0_;
	_tmp2_ = _krc_file_group_dup0 (&_tmp1_);
	_tmp3_ = _tmp2_;
	krc_file_group_destroy (&_tmp1_);
	group = _tmp3_;
	_tmp4_ = _krc_file_group_dup0 (group);
	self->priv->m_groups = g_list_prepend (self->priv->m_groups, _tmp4_);
	_tmp5_ = self->priv->m_groups;
	_tmp6_ = _tmp5_->data;
	self->priv->m_current_group = (KRcFileGroup*) ((KRcFileGroup*) _tmp6_);
	_krc_file_group_free0 (group);
	return self;
}

KRcFile*
krc_file_new (void)
{
	return krc_file_construct (TYPE_KRC_FILE);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gboolean
krc_file_is_comment (KRcFile* self,
                     const gchar* line)
{
	gunichar ch = 0U;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	ch = string_get_char (line, (glong) 0);
	if (ch == ((gunichar) '#')) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = ch == ((gunichar) '\0');
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = ch == ((gunichar) '\n');
	}
	result = _tmp0_;
	return result;
}

static gboolean
krc_file_is_group (KRcFile* self,
                   const gchar* line)
{
	gint i = 0;
	gint length = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	if (string_get_char (line, (glong) 0) != ((gunichar) '[')) {
		result = FALSE;
		return result;
	}
	i = 1;
	length = g_utf8_strlen (line, (gssize) -1);
	while (TRUE) {
		gunichar ch = 0U;
		gint _tmp0_;
		if (!(i < length)) {
			break;
		}
		ch = string_get_char (line, (glong) i);
		if (ch == ((gunichar) ']')) {
			result = TRUE;
			return result;
		}
		_tmp0_ = i;
		i = _tmp0_ + 1;
	}
	result = FALSE;
	return result;
}

static gboolean
krc_file_is_group_name (KRcFile* self,
                        const gchar* name)
{
	gint i = 0;
	gint length = 0;
	gunichar ch = 0U;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	i = 0;
	length = g_utf8_strlen (name, (gssize) -1);
	ch = (gunichar) 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gint _tmp1_;
		if (!(i < length)) {
			break;
		}
		ch = string_get_char (name, (glong) i);
		if (ch == ((gunichar) '\0')) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = g_unichar_iscntrl (ch);
		}
		if (_tmp0_) {
			break;
		}
		_tmp1_ = i;
		i = _tmp1_ + 1;
	}
	if (i != 0) {
		gboolean _tmp3_ = FALSE;
		if (i == length) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = ch == ((gunichar) '\0');
		}
		_tmp2_ = _tmp3_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gboolean
krc_file_is_key_value_pair (KRcFile* self,
                            const gchar* line)
{
	gint pos = 0;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	pos = string_index_of_char (line, (gunichar) '=', 0);
	if (pos == -1) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = pos == 0;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static const gchar*
string_offset (const gchar* self,
               glong offset)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}

static gboolean
krc_file_is_key_name (KRcFile* self,
                      const gchar* line,
                      gsize length)
{
	glong i = 0L;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	i = (glong) 0;
	_vala_assert (length < ((gsize) SSIZE_MAX), "length < Posix.Limits.SSIZE_MAX");
	while (TRUE) {
		gchar ch = '\0';
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		glong _tmp2_;
		if (!(((gsize) i) < length)) {
			break;
		}
		ch = string_get (line, i);
		if (ch == '=') {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = ch == '[';
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = ch == ']';
		}
		if (_tmp0_) {
			break;
		}
		if (ch == '\0') {
			i = (glong) length;
			break;
		}
		_tmp2_ = i;
		i = _tmp2_ + 1;
	}
	if (i == ((glong) 0)) {
		result = FALSE;
		return result;
	}
	if (string_get (line, (glong) 0) == ' ') {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = string_get (line, i - 1) == ' ';
	}
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	if (((gsize) i) < length) {
		_tmp4_ = string_get (line, i) == '[';
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		glong _tmp5_;
		glong _tmp13_;
		_tmp5_ = i;
		i = _tmp5_ + 1;
		while (TRUE) {
			gunichar ch = 0U;
			const gchar* _tmp6_;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			glong _tmp12_;
			if (!(((gsize) i) < length)) {
				break;
			}
			_vala_assert (((gsize) SSIZE_MAX) > (length - i), "Posix.Limits.SSIZE_MAX > length - i");
			_tmp6_ = string_offset (line, i);
			ch = g_utf8_get_char_validated (_tmp6_, ((gssize) length) - i);
			if (ch <= ((gunichar) 0)) {
				break;
			}
			if (!g_unichar_isalnum (ch)) {
				_tmp11_ = ch != ((gunichar) '-');
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				_tmp10_ = ch != ((gunichar) '_');
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				_tmp9_ = ch != ((gunichar) '.');
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				_tmp8_ = ch != ((gunichar) '@');
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				_tmp7_ = ch != ((gunichar) '$');
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				break;
			}
			_tmp12_ = i;
			i = _tmp12_ + 1;
		}
		if (((gsize) i) == length) {
			result = FALSE;
			return result;
		}
		if (string_get (line, i) != ']') {
			result = FALSE;
			return result;
		}
		_tmp13_ = i;
		i = _tmp13_ + 1;
	}
	if (((gsize) i) < length) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gint
krc_file_find_group (KRcFileGroup* group1,
                     KRcFileGroup* group2)
{
	KRcFileGroup _tmp0_;
	const gchar* _tmp1_;
	KRcFileGroup _tmp4_;
	const gchar* _tmp5_;
	KRcFileGroup _tmp6_;
	const gchar* _tmp7_;
	KRcFileGroup _tmp8_;
	const gchar* _tmp9_;
	gint result;
	g_return_val_if_fail (group1 != NULL, 0);
	g_return_val_if_fail (group2 != NULL, 0);
	_tmp0_ = *group1;
	_tmp1_ = _tmp0_.name;
	if (_tmp1_ == NULL) {
		KRcFileGroup _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = *group2;
		_tmp3_ = _tmp2_.name;
		if (_tmp3_ == NULL) {
			result = 0;
			return result;
		}
		result = -1;
		return result;
	}
	_tmp4_ = *group2;
	_tmp5_ = _tmp4_.name;
	if (_tmp5_ == NULL) {
		result = 1;
		return result;
	}
	_tmp6_ = *group1;
	_tmp7_ = _tmp6_.name;
	_tmp8_ = *group2;
	_tmp9_ = _tmp8_.name;
	result = g_ascii_strcasecmp (_tmp7_, _tmp9_);
	return result;
}

static GList*
krc_file_get_group_node_with_name (KRcFile* self,
                                   const gchar* group_name,
                                   gboolean if_throw_error,
                                   GError** error)
{
	KRcFileGroup tmp = {0};
	gchar* _tmp0_;
	GList* group_node = NULL;
	GList* _tmp1_;
	KRcFileGroup _tmp2_;
	GList* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GList* _tmp5_;
	GList* _tmp7_;
	GError* _inner_error0_ = NULL;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	memset (&tmp, 0, sizeof (KRcFileGroup));
	_tmp0_ = g_strdup (group_name);
	_g_free0 (tmp.name);
	tmp.name = _tmp0_;
	_tmp1_ = self->priv->m_groups;
	_tmp2_ = tmp;
	_tmp3_ = g_list_find_custom (_tmp1_, &_tmp2_, (GCompareFunc) krc_file_find_group);
	group_node = _tmp3_;
	_tmp5_ = group_node;
	if (_tmp5_ == NULL) {
		_tmp4_ = if_throw_error;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GError* _tmp6_;
		_tmp6_ = g_error_new (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND, "Key file does not have group %s", group_name);
		_inner_error0_ = _tmp6_;
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			krc_file_group_destroy (&tmp);
			return NULL;
		} else {
			krc_file_group_destroy (&tmp);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp7_ = group_node;
	result = _tmp7_;
	krc_file_group_destroy (&tmp);
	return result;
}

static gpointer
_krc_file_key_value_pair_dup0 (gpointer self)
{
	return self ? krc_file_key_value_pair_dup (self) : NULL;
}

static void
krc_file_add_key_value_pair (KRcFile* self,
                             KRcFileGroup* group,
                             KRcFileKeyValuePair* pair,
                             GList* sibling)
{
	KRcFileKeyValuePair _tmp0_;
	KRcFileKeyValuePair _tmp1_;
	KRcFileKeyValuePair* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pair != NULL);
	_tmp0_ = *pair;
	_tmp1_ = _tmp0_;
	_tmp2_ = _krc_file_key_value_pair_dup0 (&_tmp1_);
	(*group).key_value_pairs = g_list_insert_before ((*group).key_value_pairs, sibling, _tmp2_);
}

static void
krc_file_add_key (KRcFile* self,
                  KRcFileGroup* group,
                  const gchar* key,
                  const gchar* value)
{
	KRcFileKeyValuePair pair = {0};
	gchar* _tmp0_;
	gchar* _tmp1_;
	GList* lp = NULL;
	GList* _tmp2_;
	KRcFileKeyValuePair _tmp10_;
	GList* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	memset (&pair, 0, sizeof (KRcFileKeyValuePair));
	_tmp0_ = g_strdup (key);
	_g_free0 (pair.key);
	pair.key = _tmp0_;
	_tmp1_ = g_strdup (value);
	_g_free0 (pair.value);
	pair.value = _tmp1_;
	_tmp2_ = (*group).key_value_pairs;
	lp = _tmp2_;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		GList* _tmp4_;
		GList* _tmp8_;
		GList* _tmp9_;
		_tmp4_ = lp;
		if (_tmp4_ != NULL) {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			const gchar* _tmp7_;
			_tmp5_ = lp;
			_tmp6_ = _tmp5_->data;
			_tmp7_ = (*((KRcFileKeyValuePair*) _tmp6_)).key;
			_tmp3_ = _tmp7_ == NULL;
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp8_ = lp;
		_tmp9_ = _tmp8_->next;
		lp = _tmp9_;
	}
	_tmp10_ = pair;
	_tmp11_ = lp;
	krc_file_add_key_value_pair (self, group, &_tmp10_, _tmp11_);
	krc_file_key_value_pair_destroy (&pair);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
krc_file_parse_comment (KRcFile* self,
                        const gchar* line,
                        glong length)
{
	KRcFileKeyValuePair pair = {0};
	gchar* _tmp0_;
	KRcFileGroup* _tmp1_;
	KRcFileKeyValuePair _tmp2_;
	KRcFileKeyValuePair _tmp3_;
	KRcFileKeyValuePair* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	memset (&pair, 0, sizeof (KRcFileKeyValuePair));
	_g_free0 (pair.key);
	pair.key = NULL;
	_tmp0_ = string_substring (line, (glong) 0, length);
	_g_free0 (pair.value);
	pair.value = _tmp0_;
	_tmp1_ = self->priv->m_current_group;
	_tmp2_ = pair;
	_tmp3_ = _tmp2_;
	_tmp4_ = _krc_file_key_value_pair_dup0 (&_tmp3_);
	(*_tmp1_).key_value_pairs = g_list_prepend ((*_tmp1_).key_value_pairs, _tmp4_);
	krc_file_key_value_pair_destroy (&pair);
}

static gboolean
string_get_prev_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (0 < (*index)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_prev_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static void
krc_file_parse_group (KRcFile* self,
                      const gchar* line,
                      glong length,
                      GError** error)
{
	gint l = 0;
	gunichar ch = 0U;
	gchar* group_name = NULL;
	gchar* _tmp3_;
	GList* group_node = NULL;
	GList* _tmp5_;
	GList* _tmp6_;
	KRcFileGroup group = {0};
	gchar* _tmp9_;
	KRcFileGroup _tmp10_;
	KRcFileGroup _tmp11_;
	KRcFileGroup* _tmp12_;
	GList* _tmp13_;
	gconstpointer _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	l = (gint) length;
	if (l < 0) {
		GError* _tmp0_;
		_tmp0_ = g_error_new (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_PARSE, "Too long group name %s against IMT_MAX", line);
		_inner_error0_ = _tmp0_;
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_vala_assert (l > 2, "l > 2");
	while (TRUE) {
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_;
		_tmp2_ = string_get_prev_char (line, &l, &_tmp1_);
		ch = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		if (ch != ((gunichar) ']')) {
			break;
		}
	}
	_tmp3_ = string_substring (line, (glong) 1, (glong) l);
	group_name = _tmp3_;
	if (!krc_file_is_group_name (self, group_name)) {
		GError* _tmp4_;
		_tmp4_ = g_error_new (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_PARSE, "Invalid group name %s", group_name);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (group_name);
			return;
		} else {
			_g_free0 (group_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp5_ = krc_file_get_group_node_with_name (self, group_name, FALSE, &_inner_error0_);
	group_node = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (group_name);
			return;
		} else {
			_g_free0 (group_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp6_ = group_node;
	if (_tmp6_ != NULL) {
		GList* _tmp7_;
		gconstpointer _tmp8_;
		_tmp7_ = group_node;
		_tmp8_ = _tmp7_->data;
		self->priv->m_current_group = (KRcFileGroup*) ((KRcFileGroup*) _tmp8_);
		_g_free0 (group_name);
		return;
	}
	memset (&group, 0, sizeof (KRcFileGroup));
	_tmp9_ = g_strdup (group_name);
	_g_free0 (group.name);
	group.name = _tmp9_;
	_tmp10_ = group;
	_tmp11_ = _tmp10_;
	_tmp12_ = _krc_file_group_dup0 (&_tmp11_);
	self->priv->m_groups = g_list_prepend (self->priv->m_groups, _tmp12_);
	_tmp13_ = self->priv->m_groups;
	_tmp14_ = _tmp13_->data;
	self->priv->m_current_group = (KRcFileGroup*) ((KRcFileGroup*) _tmp14_);
	krc_file_group_destroy (&group);
	_g_free0 (group_name);
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static void
krc_file_parse_key_value_pair (KRcFile* self,
                               const gchar* line,
                               glong length,
                               GError** error)
{
	KRcFileGroup* _tmp0_;
	const gchar* _tmp1_;
	gint key_end = 0;
	gint value_start = 0;
	gint _tmp3_;
	gint _tmp4_;
	gchar* key = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* value = NULL;
	gint _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	KRcFileGroup* _tmp15_;
	const gchar* _tmp16_;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_;
	KRcFileKeyValuePair pair = {0};
	const gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	KRcFileGroup* _tmp26_;
	KRcFileKeyValuePair _tmp27_;
	KRcFileGroup* _tmp28_;
	GList* _tmp29_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = self->priv->m_current_group;
	_tmp1_ = (*_tmp0_).name;
	if (_tmp1_ == NULL) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND, "Key file does not start with a group");
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	key_end = string_index_of_char (line, (gunichar) '=', 0);
	value_start = key_end;
	g_warn_if_fail (key_end != -1);
	_tmp3_ = key_end;
	key_end = _tmp3_ - 1;
	_tmp4_ = value_start;
	value_start = _tmp4_ + 1;
	_tmp5_ = string_substring (line, (glong) 0, (glong) (key_end + 1));
	key = _tmp5_;
	_tmp6_ = key;
	_tmp7_ = string_chomp (_tmp6_);
	_g_free0 (key);
	key = _tmp7_;
	if (!krc_file_is_key_name (self, line, (gsize) (key_end + 1))) {
		const gchar* _tmp8_;
		GError* _tmp9_;
		_tmp8_ = key;
		_tmp9_ = g_error_new (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_PARSE, "Invalid key name: %s", _tmp8_);
		_inner_error0_ = _tmp9_;
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (key);
			return;
		} else {
			_g_free0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp10_ = strlen (line);
	_tmp11_ = _tmp10_;
	_tmp12_ = string_substring (line, (glong) value_start, (glong) (_tmp11_ - value_start));
	value = _tmp12_;
	_tmp13_ = value;
	_tmp14_ = string_chug (_tmp13_);
	_g_free0 (value);
	value = _tmp14_;
	_tmp15_ = self->priv->m_current_group;
	_tmp16_ = (*_tmp15_).name;
	_vala_assert (_tmp16_ != NULL, "m_current_group.name != null");
	_tmp18_ = key;
	if (g_strcmp0 (_tmp18_, "Encoding") == 0) {
		const gchar* _tmp19_;
		_tmp19_ = value;
		_tmp17_ = g_strcmp0 (_tmp19_, "UTF-8") != 0;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		const gchar* _tmp20_;
		GError* _tmp21_;
		_tmp20_ = value;
		_tmp21_ = g_error_new (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_UNKNOWN_ENCODING, "Key file contains unsupported encoding %s", _tmp20_);
		_inner_error0_ = _tmp21_;
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (value);
			_g_free0 (key);
			return;
		} else {
			_g_free0 (value);
			_g_free0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	memset (&pair, 0, sizeof (KRcFileKeyValuePair));
	_tmp22_ = key;
	_tmp23_ = g_strdup (_tmp22_);
	_g_free0 (pair.key);
	pair.key = _tmp23_;
	_tmp24_ = value;
	_tmp25_ = g_strdup (_tmp24_);
	_g_free0 (pair.value);
	pair.value = _tmp25_;
	_tmp26_ = self->priv->m_current_group;
	_tmp27_ = pair;
	_tmp28_ = self->priv->m_current_group;
	_tmp29_ = (*_tmp28_).key_value_pairs;
	krc_file_add_key_value_pair (self, _tmp26_, &_tmp27_, _tmp29_);
	krc_file_key_value_pair_destroy (&pair);
	_g_free0 (value);
	_g_free0 (key);
}

static void
krc_file_parse_line (KRcFile* self,
                     const gchar* line,
                     glong length,
                     GError** error)
{
	gchar* _line = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = g_strdup (line);
	_line = _tmp0_;
	_tmp1_ = _line;
	_tmp2_ = string_chug (_tmp1_);
	_g_free0 (_line);
	_line = _tmp2_;
	_tmp3_ = _line;
	if (krc_file_is_comment (self, _tmp3_)) {
		krc_file_parse_comment (self, line, length);
	}
	_tmp4_ = _line;
	if (krc_file_is_group (self, _tmp4_)) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp5_ = _line;
		_tmp6_ = _line;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		krc_file_parse_group (self, _tmp5_, length - (length - _tmp8_), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (_line);
				return;
			} else {
				_g_free0 (_line);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_tmp9_ = _line;
	if (krc_file_is_key_value_pair (self, _tmp9_)) {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp10_ = _line;
		_tmp11_ = _line;
		_tmp12_ = strlen (_tmp11_);
		_tmp13_ = _tmp12_;
		krc_file_parse_key_value_pair (self, _tmp10_, length - (length - _tmp13_), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (_line);
				return;
			} else {
				_g_free0 (_line);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_g_free0 (_line);
}

static gboolean
krc_file_parse_data (KRcFile* self,
                     const gchar* data,
                     gsize length)
{
	glong i = 0L;
	glong offset = 0L;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (data != NULL, FALSE);
	i = (glong) 0;
	offset = (glong) 0;
	while (TRUE) {
		gchar ch = '\0';
		glong _tmp20_;
		if (!(((gsize) i) < length)) {
			break;
		}
		ch = string_get (data, i);
		if (ch == '\n') {
			glong sub_length = 0L;
			gchar* sub = NULL;
			gchar* _tmp0_;
			gboolean _tmp1_ = FALSE;
			const gchar* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			sub_length = i - offset;
			_tmp0_ = string_substring (data, offset, sub_length);
			sub = _tmp0_;
			offset = i + 1;
			_tmp2_ = sub;
			_tmp3_ = strlen (_tmp2_);
			_tmp4_ = _tmp3_;
			if (_tmp4_ > 0) {
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				_tmp5_ = sub;
				_tmp6_ = sub;
				_tmp7_ = strlen (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp1_ = string_get (_tmp5_, (glong) (_tmp8_ - 1)) == '\r';
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				const gchar* _tmp9_;
				glong _tmp10_;
				gchar* _tmp11_;
				_tmp9_ = sub;
				sub_length = sub_length - 1;
				_tmp10_ = sub_length;
				_tmp11_ = string_substring (_tmp9_, (glong) 0, _tmp10_);
				_g_free0 (sub);
				sub = _tmp11_;
			}
			{
				const gchar* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				_tmp12_ = sub;
				_tmp13_ = strlen (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_ == 0) {
					krc_file_parse_comment (self, "", (glong) 0);
				} else {
					const gchar* _tmp15_;
					_tmp15_ = sub;
					krc_file_parse_line (self, _tmp15_, sub_length, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						gboolean _tmp16_ = FALSE;
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						_g_free0 (sub);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp16_;
					}
				}
			}
			goto __finally0;
			__catch0_g_key_file_error:
			{
				GError* e = NULL;
				GError* _tmp17_;
				const gchar* _tmp18_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp17_ = e;
				_tmp18_ = _tmp17_->message;
				g_warning ("krcfile.vala:279: Failed to load data: %s", _tmp18_);
				result = FALSE;
				_g_error_free0 (e);
				_g_free0 (sub);
				return result;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp19_ = FALSE;
				_g_free0 (sub);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp19_;
			}
			_g_free0 (sub);
		}
		_tmp20_ = i;
		i = _tmp20_ + 1;
	}
	result = TRUE;
	return result;
}

gboolean
krc_file_load_from_file (KRcFile* self,
                         const gchar* path,
                         GKeyFileFlags flags,
                         GError** error)
{
	gchar* contents = NULL;
	gsize length = 0UL;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_ = NULL;
	gsize _tmp5_ = 0UL;
	gboolean _tmp6_;
	const gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	if (!g_file_test (path, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_REGULAR)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_PARSE, "Not a regular file %s", path);
		_inner_error0_ = _tmp0_;
		if ((_inner_error0_->domain == G_KEY_FILE_ERROR) || (_inner_error0_->domain == G_FILE_ERROR)) {
			gboolean _tmp1_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gboolean _tmp2_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	contents = NULL;
	length = (gsize) 0;
	_tmp6_ = g_file_get_contents (path, &_tmp4_, &_tmp5_, &_inner_error0_);
	_g_free0 (contents);
	contents = _tmp4_;
	length = _tmp5_;
	_tmp3_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == G_KEY_FILE_ERROR) || (_inner_error0_->domain == G_FILE_ERROR)) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (contents);
			return _tmp7_;
		} else {
			gboolean _tmp8_ = FALSE;
			_g_free0 (contents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp8_;
		}
	}
	if (!_tmp3_) {
		g_warning ("krcfile.vala:300: Failed to load %s", path);
		result = FALSE;
		_g_free0 (contents);
		return result;
	}
	_tmp9_ = contents;
	result = krc_file_parse_data (self, _tmp9_, length);
	_g_free0 (contents);
	return result;
}

gboolean
krc_file_has_group (KRcFile* self,
                    const gchar* group_name)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group_name != NULL, FALSE);
	{
		GList* _tmp0_ = NULL;
		GList* _tmp1_;
		_tmp1_ = krc_file_get_group_node_with_name (self, group_name, FALSE, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
		if (_tmp0_ != NULL) {
			result = TRUE;
			return result;
		}
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = FALSE;
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
krc_file_get_keys (KRcFile* self,
                   const gchar* group_name,
                   gint* result_length1,
                   GError** error)
{
	gchar** keys = NULL;
	gchar** _tmp0_;
	gint keys_length1;
	gint _keys_size_;
	GList* group_node = NULL;
	GList* _tmp1_;
	GList* tmp = NULL;
	gconstpointer _tmp2_;
	GList* _tmp3_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	keys = _tmp0_;
	keys_length1 = 0;
	_keys_size_ = keys_length1;
	_tmp1_ = krc_file_get_group_node_with_name (self, group_name, TRUE, &_inner_error0_);
	group_node = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		} else {
			keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = group_node->data;
	_tmp3_ = (*((KRcFileGroup*) _tmp2_)).key_value_pairs;
	tmp = _tmp3_;
	while (TRUE) {
		GList* _tmp4_;
		KRcFileKeyValuePair pair = {0};
		GList* _tmp5_;
		gconstpointer _tmp6_;
		KRcFileKeyValuePair _tmp7_;
		KRcFileKeyValuePair _tmp8_ = {0};
		KRcFileKeyValuePair _tmp9_;
		const gchar* _tmp10_;
		GList* _tmp14_;
		GList* _tmp15_;
		_tmp4_ = tmp;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = tmp;
		_tmp6_ = _tmp5_->data;
		_tmp7_ = *((KRcFileKeyValuePair*) _tmp6_);
		krc_file_key_value_pair_copy (&_tmp7_, &_tmp8_);
		pair = _tmp8_;
		_tmp9_ = pair;
		_tmp10_ = _tmp9_.key;
		if (_tmp10_ != NULL) {
			KRcFileKeyValuePair _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp11_ = pair;
			_tmp12_ = _tmp11_.key;
			_tmp13_ = g_strdup (_tmp12_);
			_vala_array_add1 (&keys, &keys_length1, &_keys_size_, _tmp13_);
		}
		_tmp14_ = tmp;
		_tmp15_ = _tmp14_->next;
		tmp = _tmp15_;
		krc_file_key_value_pair_destroy (&pair);
	}
	_tmp16_ = keys;
	_tmp16__length1 = keys_length1;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	return result;
}

gboolean
krc_file_has_key (KRcFile* self,
                  const gchar* group_name,
                  const gchar* key,
                  GError** error)
{
	GList* group_node = NULL;
	GList* _tmp0_;
	GList* tmp = NULL;
	GList* _tmp3_;
	gconstpointer _tmp4_;
	GList* _tmp5_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group_name != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = krc_file_get_group_node_with_name (self, group_name, TRUE, &_inner_error0_);
	group_node = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			gboolean _tmp1_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gboolean _tmp2_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	_tmp3_ = group_node;
	_tmp4_ = _tmp3_->data;
	_tmp5_ = (*((KRcFileGroup*) _tmp4_)).key_value_pairs;
	tmp = _tmp5_;
	while (TRUE) {
		GList* _tmp6_;
		KRcFileKeyValuePair pair = {0};
		GList* _tmp7_;
		gconstpointer _tmp8_;
		KRcFileKeyValuePair _tmp9_;
		KRcFileKeyValuePair _tmp10_ = {0};
		KRcFileKeyValuePair _tmp11_;
		const gchar* _tmp12_;
		GList* _tmp13_;
		GList* _tmp14_;
		_tmp6_ = tmp;
		if (!(_tmp6_ != NULL)) {
			break;
		}
		_tmp7_ = tmp;
		_tmp8_ = _tmp7_->data;
		_tmp9_ = *((KRcFileKeyValuePair*) _tmp8_);
		krc_file_key_value_pair_copy (&_tmp9_, &_tmp10_);
		pair = _tmp10_;
		_tmp11_ = pair;
		_tmp12_ = _tmp11_.key;
		if (g_strcmp0 (_tmp12_, key) == 0) {
			result = TRUE;
			krc_file_key_value_pair_destroy (&pair);
			return result;
		}
		_tmp13_ = tmp;
		_tmp14_ = _tmp13_->next;
		tmp = _tmp14_;
		krc_file_key_value_pair_destroy (&pair);
	}
	result = FALSE;
	return result;
}

gboolean
krc_file_remove_group (KRcFile* self,
                       const gchar* group_name,
                       GError** error)
{
	GList* group_node = NULL;
	GList* _tmp0_;
	GList* tmp = NULL;
	gconstpointer _tmp3_;
	GList* _tmp4_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group_name != NULL, FALSE);
	_tmp0_ = krc_file_get_group_node_with_name (self, group_name, TRUE, &_inner_error0_);
	group_node = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			gboolean _tmp1_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gboolean _tmp2_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	_tmp3_ = group_node->data;
	_tmp4_ = (*((KRcFileGroup*) _tmp3_)).key_value_pairs;
	tmp = _tmp4_;
	while (TRUE) {
		GList* _tmp5_;
		GList* _tmp6_;
		GList* _tmp7_;
		_tmp5_ = tmp;
		if (!(_tmp5_ != NULL)) {
			break;
		}
		_tmp6_ = tmp;
		_krc_file_key_value_pair_free0 (_tmp6_->data);
		_tmp6_->data = NULL;
		_tmp7_ = tmp;
		tmp = g_list_delete_link (tmp, _tmp7_);
	}
	_krc_file_group_free0 (group_node->data);
	group_node->data = NULL;
	self->priv->m_groups = g_list_delete_link (self->priv->m_groups, group_node);
	result = TRUE;
	return result;
}

gboolean
krc_file_remove_key (KRcFile* self,
                     const gchar* group_name,
                     const gchar* key,
                     GError** error)
{
	GList* group_node = NULL;
	GList* _tmp0_;
	GList* tmp = NULL;
	GList* _tmp3_;
	gconstpointer _tmp4_;
	GList* _tmp5_;
	GList* _tmp14_;
	GList* _tmp18_;
	GList* _tmp19_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group_name != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = krc_file_get_group_node_with_name (self, group_name, TRUE, &_inner_error0_);
	group_node = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			gboolean _tmp1_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gboolean _tmp2_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	_tmp3_ = group_node;
	_tmp4_ = _tmp3_->data;
	_tmp5_ = (*((KRcFileGroup*) _tmp4_)).key_value_pairs;
	tmp = _tmp5_;
	while (TRUE) {
		GList* _tmp6_;
		KRcFileKeyValuePair* pair = NULL;
		GList* _tmp7_;
		gconstpointer _tmp8_;
		KRcFileKeyValuePair* _tmp9_;
		KRcFileKeyValuePair* _tmp10_;
		const gchar* _tmp11_;
		GList* _tmp12_;
		GList* _tmp13_;
		_tmp6_ = tmp;
		if (!(_tmp6_ != NULL)) {
			break;
		}
		_tmp7_ = tmp;
		_tmp8_ = _tmp7_->data;
		_tmp9_ = _krc_file_key_value_pair_dup0 ((KRcFileKeyValuePair*) _tmp8_);
		pair = _tmp9_;
		_tmp10_ = pair;
		_tmp11_ = (*_tmp10_).key;
		if (g_strcmp0 (_tmp11_, key) == 0) {
			_krc_file_key_value_pair_free0 (pair);
			break;
		}
		_tmp12_ = tmp;
		_tmp13_ = _tmp12_->next;
		tmp = _tmp13_;
		_krc_file_key_value_pair_free0 (pair);
	}
	_tmp14_ = tmp;
	if (_tmp14_ == NULL) {
		GError* _tmp15_;
		_tmp15_ = g_error_new (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND, "Key file does not have key %s in group %s", key, group_name);
		_inner_error0_ = _tmp15_;
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			gboolean _tmp16_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp16_;
		} else {
			gboolean _tmp17_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp17_;
		}
	}
	_tmp18_ = tmp;
	_krc_file_key_value_pair_free0 (_tmp18_->data);
	_tmp18_->data = NULL;
	_tmp19_ = tmp;
	tmp = g_list_delete_link (tmp, _tmp19_);
	result = TRUE;
	return result;
}

gchar*
krc_file_to_data (KRcFile* self,
                  gssize* length)
{
	gssize _vala_length = 0L;
	GString* data_string = NULL;
	GString* _tmp0_;
	GString* _tmp36_;
	GString* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	data_string = _tmp0_;
	{
		GList* group_node = NULL;
		GList* _tmp1_;
		GList* _tmp2_;
		_tmp1_ = self->priv->m_groups;
		_tmp2_ = g_list_last (_tmp1_);
		group_node = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GList* _tmp6_;
				KRcFileGroup* group = NULL;
				GList* _tmp7_;
				gconstpointer _tmp8_;
				KRcFileGroup* _tmp9_;
				KRcFileGroup* _tmp10_;
				const gchar* _tmp11_;
				if (!_tmp3_) {
					GList* _tmp4_;
					GList* _tmp5_;
					_tmp4_ = group_node;
					_tmp5_ = _tmp4_->prev;
					group_node = _tmp5_;
				}
				_tmp3_ = FALSE;
				_tmp6_ = group_node;
				if (!(_tmp6_ != NULL)) {
					break;
				}
				_tmp7_ = group_node;
				_tmp8_ = _tmp7_->data;
				_tmp9_ = _krc_file_group_dup0 ((KRcFileGroup*) _tmp8_);
				group = _tmp9_;
				_tmp10_ = group;
				_tmp11_ = (*_tmp10_).name;
				if (_tmp11_ != NULL) {
					GString* _tmp12_;
					KRcFileGroup* _tmp13_;
					const gchar* _tmp14_;
					_tmp12_ = data_string;
					_tmp13_ = group;
					_tmp14_ = (*_tmp13_).name;
					g_string_append_printf (_tmp12_, "[%s]\n", _tmp14_);
				}
				{
					GList* key_file_node = NULL;
					KRcFileGroup* _tmp15_;
					GList* _tmp16_;
					GList* _tmp17_;
					_tmp15_ = group;
					_tmp16_ = (*_tmp15_).key_value_pairs;
					_tmp17_ = g_list_last (_tmp16_);
					key_file_node = _tmp17_;
					{
						gboolean _tmp18_ = FALSE;
						_tmp18_ = TRUE;
						while (TRUE) {
							GList* _tmp21_;
							KRcFileKeyValuePair pair = {0};
							GList* _tmp22_;
							gconstpointer _tmp23_;
							KRcFileKeyValuePair _tmp24_;
							KRcFileKeyValuePair _tmp25_ = {0};
							KRcFileKeyValuePair _tmp26_;
							const gchar* _tmp27_;
							if (!_tmp18_) {
								GList* _tmp19_;
								GList* _tmp20_;
								_tmp19_ = key_file_node;
								_tmp20_ = _tmp19_->prev;
								key_file_node = _tmp20_;
							}
							_tmp18_ = FALSE;
							_tmp21_ = key_file_node;
							if (!(_tmp21_ != NULL)) {
								break;
							}
							_tmp22_ = key_file_node;
							_tmp23_ = _tmp22_->data;
							_tmp24_ = *((KRcFileKeyValuePair*) _tmp23_);
							krc_file_key_value_pair_copy (&_tmp24_, &_tmp25_);
							pair = _tmp25_;
							_tmp26_ = pair;
							_tmp27_ = _tmp26_.key;
							if (_tmp27_ != NULL) {
								GString* _tmp28_;
								KRcFileKeyValuePair _tmp29_;
								const gchar* _tmp30_;
								KRcFileKeyValuePair _tmp31_;
								const gchar* _tmp32_;
								_tmp28_ = data_string;
								_tmp29_ = pair;
								_tmp30_ = _tmp29_.key;
								_tmp31_ = pair;
								_tmp32_ = _tmp31_.value;
								g_string_append_printf (_tmp28_, "%s=%s\n", _tmp30_, _tmp32_);
							} else {
								GString* _tmp33_;
								KRcFileKeyValuePair _tmp34_;
								const gchar* _tmp35_;
								_tmp33_ = data_string;
								_tmp34_ = pair;
								_tmp35_ = _tmp34_.value;
								g_string_append_printf (_tmp33_, "%s\n", _tmp35_);
							}
							krc_file_key_value_pair_destroy (&pair);
						}
					}
				}
				_krc_file_group_free0 (group);
			}
		}
	}
	_tmp36_ = data_string;
	_vala_length = _tmp36_->len;
	_tmp37_ = data_string;
	_tmp38_ = _tmp37_->str;
	_tmp39_ = g_strdup (_tmp38_);
	result = _tmp39_;
	_g_string_free0 (data_string);
	if (length) {
		*length = _vala_length;
	}
	return result;
}

gboolean
krc_file_save_to_file (KRcFile* self,
                       const gchar* filename,
                       GError** error)
{
	gssize length = 0L;
	gchar* contents = NULL;
	gssize _tmp0_ = 0L;
	gchar* _tmp1_;
	gboolean retval = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	length = (gssize) 0;
	_tmp1_ = krc_file_to_data (self, &_tmp0_);
	length = _tmp0_;
	contents = _tmp1_;
	retval = g_file_set_contents (filename, contents, length, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_FILE_ERROR) {
			gboolean _tmp2_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (contents);
			return _tmp2_;
		} else {
			gboolean _tmp3_ = FALSE;
			_g_free0 (contents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	result = retval;
	_g_free0 (contents);
	return result;
}

gchar*
krc_file_get_value (KRcFile* self,
                    const gchar* group_name,
                    const gchar* key,
                    GError** error)
{
	GList* group_node = NULL;
	GList* _tmp0_;
	GList* tmp = NULL;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	GList* _tmp3_;
	GError* _tmp15_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = krc_file_get_group_node_with_name (self, group_name, TRUE, &_inner_error0_);
	group_node = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = group_node;
	_tmp2_ = _tmp1_->data;
	_tmp3_ = (*((KRcFileGroup*) _tmp2_)).key_value_pairs;
	tmp = _tmp3_;
	while (TRUE) {
		GList* _tmp4_;
		KRcFileKeyValuePair* pair = NULL;
		GList* _tmp5_;
		gconstpointer _tmp6_;
		KRcFileKeyValuePair* _tmp7_;
		KRcFileKeyValuePair* _tmp8_;
		const gchar* _tmp9_;
		GList* _tmp13_;
		GList* _tmp14_;
		_tmp4_ = tmp;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = tmp;
		_tmp6_ = _tmp5_->data;
		_tmp7_ = _krc_file_key_value_pair_dup0 ((KRcFileKeyValuePair*) _tmp6_);
		pair = _tmp7_;
		_tmp8_ = pair;
		_tmp9_ = (*_tmp8_).key;
		if (g_strcmp0 (_tmp9_, key) == 0) {
			KRcFileKeyValuePair* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp10_ = pair;
			_tmp11_ = (*_tmp10_).value;
			_tmp12_ = g_strdup (_tmp11_);
			result = _tmp12_;
			_krc_file_key_value_pair_free0 (pair);
			return result;
		}
		_tmp13_ = tmp;
		_tmp14_ = _tmp13_->next;
		tmp = _tmp14_;
		_krc_file_key_value_pair_free0 (pair);
	}
	_tmp15_ = g_error_new (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND, "Key file does not have key %s in group %s", key, group_name);
	_inner_error0_ = _tmp15_;
	if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

void
krc_file_set_value (KRcFile* self,
                    const gchar* group_name,
                    const gchar* key,
                    const gchar* value)
{
	gint _tmp0_;
	gint _tmp1_;
	GList* group_node = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	g_return_if_fail (krc_file_is_group_name (self, group_name));
	_tmp0_ = strlen (key);
	_tmp1_ = _tmp0_;
	g_return_if_fail (krc_file_is_key_name (self, key, (gsize) _tmp1_));
	{
		GList* _tmp2_ = NULL;
		GList* _tmp3_;
		_tmp3_ = krc_file_get_group_node_with_name (self, group_name, FALSE, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		group_node = _tmp2_;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (group_node == NULL) {
		KRcFileGroup* last_group = NULL;
		GList* _tmp4_;
		gconstpointer _tmp5_;
		KRcFileGroup* _tmp6_;
		GList* _tmp7_;
		KRcFileGroup group = {0};
		gchar* _tmp12_;
		KRcFileGroup _tmp13_;
		KRcFileGroup _tmp14_;
		KRcFileGroup* _tmp15_;
		GList* _tmp16_;
		gconstpointer _tmp17_;
		KRcFileGroup* _tmp18_;
		_tmp4_ = self->priv->m_groups;
		_tmp5_ = _tmp4_->data;
		last_group = (KRcFileGroup*) _tmp5_;
		_tmp6_ = last_group;
		_tmp7_ = (*_tmp6_).key_value_pairs;
		if (_tmp7_ != NULL) {
			KRcFileGroup* _tmp8_;
			GList* _tmp9_;
			gconstpointer _tmp10_;
			const gchar* _tmp11_;
			_tmp8_ = last_group;
			_tmp9_ = (*_tmp8_).key_value_pairs;
			_tmp10_ = _tmp9_->data;
			_tmp11_ = (*((KRcFileKeyValuePair*) _tmp10_)).key;
			if (_tmp11_ != NULL) {
				krc_file_parse_comment (self, "", (glong) 0);
			}
		}
		memset (&group, 0, sizeof (KRcFileGroup));
		_tmp12_ = g_strdup (group_name);
		_g_free0 (group.name);
		group.name = _tmp12_;
		_tmp13_ = group;
		_tmp14_ = _tmp13_;
		_tmp15_ = _krc_file_group_dup0 (&_tmp14_);
		self->priv->m_groups = g_list_prepend (self->priv->m_groups, _tmp15_);
		_tmp16_ = self->priv->m_groups;
		_tmp17_ = _tmp16_->data;
		self->priv->m_current_group = (KRcFileGroup*) ((KRcFileGroup*) _tmp17_);
		_tmp18_ = self->priv->m_current_group;
		krc_file_add_key (self, _tmp18_, key, value);
		krc_file_group_destroy (&group);
	} else {
		GList* tmp = NULL;
		gconstpointer _tmp19_;
		GList* _tmp20_;
		GList* _tmp29_;
		_tmp19_ = group_node->data;
		_tmp20_ = (*((KRcFileGroup*) _tmp19_)).key_value_pairs;
		tmp = _tmp20_;
		while (TRUE) {
			GList* _tmp21_;
			KRcFileKeyValuePair* pair = NULL;
			GList* _tmp22_;
			gconstpointer _tmp23_;
			KRcFileKeyValuePair* _tmp24_;
			KRcFileKeyValuePair* _tmp25_;
			const gchar* _tmp26_;
			GList* _tmp27_;
			GList* _tmp28_;
			_tmp21_ = tmp;
			if (!(_tmp21_ != NULL)) {
				break;
			}
			_tmp22_ = tmp;
			_tmp23_ = _tmp22_->data;
			_tmp24_ = _krc_file_key_value_pair_dup0 ((KRcFileKeyValuePair*) _tmp23_);
			pair = _tmp24_;
			_tmp25_ = pair;
			_tmp26_ = (*_tmp25_).key;
			if (g_strcmp0 (_tmp26_, key) == 0) {
				_krc_file_key_value_pair_free0 (pair);
				break;
			}
			_tmp27_ = tmp;
			_tmp28_ = _tmp27_->next;
			tmp = _tmp28_;
			_krc_file_key_value_pair_free0 (pair);
		}
		_tmp29_ = tmp;
		if (_tmp29_ != NULL) {
			GList* _tmp30_;
			gconstpointer _tmp31_;
			gchar* _tmp32_;
			_tmp30_ = tmp;
			_tmp31_ = _tmp30_->data;
			_tmp32_ = g_strdup (value);
			_g_free0 ((*((KRcFileKeyValuePair*) _tmp31_)).value);
			(*((KRcFileKeyValuePair*) _tmp31_)).value = _tmp32_;
		} else {
			gconstpointer _tmp33_;
			_tmp33_ = group_node->data;
			krc_file_add_key (self, (KRcFileGroup*) _tmp33_, key, value);
		}
	}
}

static void
value_krc_file_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_krc_file_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		krc_file_unref (value->data[0].v_pointer);
	}
}

static void
value_krc_file_copy_value (const GValue* src_value,
                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = krc_file_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_krc_file_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_krc_file_collect_value (GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		KRcFile * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = krc_file_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_krc_file_lcopy_value (const GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	KRcFile ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = krc_file_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_krc_file (const gchar* name,
                     const gchar* nick,
                     const gchar* blurb,
                     GType object_type,
                     GParamFlags flags)
{
	ParamSpecKRcFile* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_KRC_FILE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_krc_file (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_KRC_FILE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_krc_file (GValue* value,
                    gpointer v_object)
{
	KRcFile * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_KRC_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_KRC_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		krc_file_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		krc_file_unref (old);
	}
}

void
value_take_krc_file (GValue* value,
                     gpointer v_object)
{
	KRcFile * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_KRC_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_KRC_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		krc_file_unref (old);
	}
}

static void
krc_file_class_init (KRcFileClass * klass,
                     gpointer klass_data)
{
	krc_file_parent_class = g_type_class_peek_parent (klass);
	((KRcFileClass *) klass)->finalize = krc_file_finalize;
	g_type_class_adjust_private_offset (klass, &KRcFile_private_offset);
}

static void
krc_file_instance_init (KRcFile * self,
                        gpointer klass)
{
	self->priv = krc_file_get_instance_private (self);
	self->ref_count = 1;
}

static void
krc_file_finalize (KRcFile * obj)
{
	KRcFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KRC_FILE, KRcFile);
	g_signal_handlers_destroy (self);
	(self->priv->m_groups == NULL) ? NULL : (self->priv->m_groups = (_g_list_free__krc_file_group_free0_ (self->priv->m_groups), NULL));
}

static GType
krc_file_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_krc_file_init, value_krc_file_free_value, value_krc_file_copy_value, value_krc_file_peek_pointer, "p", value_krc_file_collect_value, "p", value_krc_file_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (KRcFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) krc_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KRcFile), 0, (GInstanceInitFunc) krc_file_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType krc_file_type_id;
	krc_file_type_id = g_type_register_fundamental (g_type_fundamental_next (), "KRcFile", &g_define_type_info, &g_define_type_fundamental_info, 0);
	KRcFile_private_offset = g_type_add_instance_private (krc_file_type_id, sizeof (KRcFilePrivate));
	return krc_file_type_id;
}

GType
krc_file_get_type (void)
{
	static volatile gsize krc_file_type_id__once = 0;
	if (g_once_init_enter (&krc_file_type_id__once)) {
		GType krc_file_type_id;
		krc_file_type_id = krc_file_get_type_once ();
		g_once_init_leave (&krc_file_type_id__once, krc_file_type_id);
	}
	return krc_file_type_id__once;
}

gpointer
krc_file_ref (gpointer instance)
{
	KRcFile * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
krc_file_unref (gpointer instance)
{
	KRcFile * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		KRC_FILE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

