#define XERR
#include "compiler.ih"

void Compiler::compileMods(Scan const &scan)
{
    unique_ptr<Process> 
        procPtr{ new Process{ Process::NONE, Process::NO_PATH } };

    procPtr->setBufSize(512);

    bool inform = imsg.isActive();
                                                // idx needed for to_string
    for (size_t idx = 0, end = scan.modVectSize(); idx != end; ++idx)
    {
        ModData const &data = scan.modVect(idx);

        if (data.type() == ModData::EXTERN)     // skip external modules
            continue;

        Path parent = data.source().parent_path();

        fs::current_path(parent);               // cd to the source's dir

        Path objFile;                           // .o files start with a nr.
        if (d_objDir.empty())                   // ../tmp/o subdir is not used
            objFile = data.nr();                // then prefix the file's nr
        else
            (objFile =                          // or set the path to tmp/
                parents(data.source().string()) + d_objDir) /= data.nr();

        Path filename{ data.source().filename() };
        (objFile += filename).replace_extension(".o");

        if (
            younger(filename, objFile) 
            or 
            not fs::exists("gcm.cache/" + scan.gcmName(idx)))
        {
            if (inform)
            {
                imsg << "Compiling..." << endl;
                inform = false;
            }
            compile(*procPtr, parent, filename.string(), objFile.string());
        }

        fs::current_path(scan.cwd());           // back to the cwd
    }
}

