#define XERR
#include "modules.ih"

bool Modules::circular()
{
    VectIter from = d_scan.modVect().begin();

    while (true)
    {
        VectIter next =             // put the 0-dependent modules on top
                    partition(from, d_scan.modVect().end(), 
                        [&](ModData const &data)
                        {
                            return data.imports().size() == 0;
                        }
                    );

        if (next == d_scan.modVect().end()) // all circular checks were passed
            break;

        if (from == next)                   // circ.deps: deps still exist
        {
            emsg << "can't compile module " << from->modName() << 
                    ": circular or undefined module(s)\n" << endl;
            return true;
        }

        from = removeImports(from, next);   // remove the deps fm imports
    }                                       // and continue

    //at this point the least dependent modules are on top. Modules can
    // only depend on modules earlier in d_scan.modVect()

    return false;
}
