#define XERR
#include "modules.ih"

    // called by solveunknown.cc

bool Modules::externalDirs()
{
    string name;
    if (not Arg::instance().option(&name, 'e'))     // no -e option
        return false;

    ifstream in{ Exception::factory<ifstream>(name) };

    string dir;
    while (getline(in, dir))                        // read the lines
    {                                               
                                                    // cut-off at comment
        if (size_t pos = dir.find("//"); pos != string::npos)  
            dir.resize(pos);

        dir = String::trim(dir);
        if (dir.empty())                            // ignore empty dirs
            continue;

        if (dir.back() != '/')                      // dirs end in '/'
            dir += '/';

        if (not fs::exists(dir))                   // dir: doesn't exist
        {
            wmsg << "entry " << dir << " in -external " << name <<
                    " does not exist" << endl;
            continue;
        }

        d_external.push_back( move(dir) );
    }

    return not d_external.empty();
}
