#define XERR
#include "scan.ih"

    // the name of a partition (export import :Part;) is in 
    // d_scanner.matched(): declare Module:Part in d_modVect, add it to 
    // d_currentIdx's imports

    // PARTDECL export import :Part;

void Scan::declarePartition()
{
    string matched = d_scanner.matched();

    if (matched.front() != ':' and matched.find(':') != string::npos)
    {
        emsg << d_sourcePath << 
                " specifies `" << matched <<
                "': use `:{NAME}' to declare a partition" << endl;
        return;
    }

    string name = d_modVect[d_currentIdx].modName();
    name = name.substr(0, name.find(':'));          // use the module name
    name += d_scanner.matched();            // construct ModuleName:Parition

    imsg << "       declares partition " << name << endl;

                                        // module at 'moduleIdx' imports this
                                        // partition
    size_t idx = declare(name);
    d_modVect[d_currentIdx].imports(idx);

    if (d_exportNeeded and not d_scanner.exports())
        emsg << d_sourcePath <<": `import " << d_scanner.matched() <<  
                "' must start with 'export'" << endl;
}





