
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQLocale.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QLocale>
#include <QDate>
#include <QDateTime>
#include <QTime>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QLocale

//  Constructor QLocale::QLocale()


static void _init_ctor_QLocale_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QLocale> ();
}

static void _call_ctor_QLocale_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLocale *> (new QLocale ());
}


//  Constructor QLocale::QLocale(const QString &name)


static void _init_ctor_QLocale_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QLocale> ();
}

static void _call_ctor_QLocale_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QLocale *> (new QLocale (arg1));
}


//  Constructor QLocale::QLocale(QLocale::Language language, QLocale::Country country)


static void _init_ctor_QLocale_3902 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("language");
  decl->add_arg<const qt_gsi::Converter<QLocale::Language>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("country", true, "QLocale::AnyCountry");
  decl->add_arg<const qt_gsi::Converter<QLocale::Country>::target_type & > (argspec_1);
  decl->set_return_new<QLocale> ();
}

static void _call_ctor_QLocale_3902 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::Language>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QLocale::Language>::target_type & >() (args, heap);
  const qt_gsi::Converter<QLocale::Country>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::Country>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::Country>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::Country>(heap, QLocale::AnyCountry), heap);
  ret.write<QLocale *> (new QLocale (qt_gsi::QtToCppAdaptor<QLocale::Language>(arg1).cref(), qt_gsi::QtToCppAdaptor<QLocale::Country>(arg2).cref()));
}


//  Constructor QLocale::QLocale(QLocale::Language language, QLocale::Script script, QLocale::Country country)


static void _init_ctor_QLocale_5648 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("language");
  decl->add_arg<const qt_gsi::Converter<QLocale::Language>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("script");
  decl->add_arg<const qt_gsi::Converter<QLocale::Script>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("country");
  decl->add_arg<const qt_gsi::Converter<QLocale::Country>::target_type & > (argspec_2);
  decl->set_return_new<QLocale> ();
}

static void _call_ctor_QLocale_5648 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::Language>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QLocale::Language>::target_type & >() (args, heap);
  const qt_gsi::Converter<QLocale::Script>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QLocale::Script>::target_type & >() (args, heap);
  const qt_gsi::Converter<QLocale::Country>::target_type & arg3 = gsi::arg_reader<const qt_gsi::Converter<QLocale::Country>::target_type & >() (args, heap);
  ret.write<QLocale *> (new QLocale (qt_gsi::QtToCppAdaptor<QLocale::Language>(arg1).cref(), qt_gsi::QtToCppAdaptor<QLocale::Script>(arg2).cref(), qt_gsi::QtToCppAdaptor<QLocale::Country>(arg3).cref()));
}


//  Constructor QLocale::QLocale(const QLocale &other)


static void _init_ctor_QLocale_1986 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return_new<QLocale> ();
}

static void _call_ctor_QLocale_1986 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLocale &arg1 = gsi::arg_reader<const QLocale & >() (args, heap);
  ret.write<QLocale *> (new QLocale (arg1));
}


// QString QLocale::amText()


static void _init_f_amText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_amText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QLocale *)cls)->amText ());
}


// QString QLocale::bcp47Name()


static void _init_f_bcp47Name_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_bcp47Name_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QLocale *)cls)->bcp47Name ());
}


// QLocale::Country QLocale::country()


static void _init_f_country_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QLocale::Country>::target_type > ();
}

static void _call_f_country_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QLocale::Country>::target_type > ((qt_gsi::Converter<QLocale::Country>::target_type)qt_gsi::CppToQtAdaptor<QLocale::Country>(((QLocale *)cls)->country ()));
}


// QString QLocale::createSeparatedList(const QStringList &strl)


static void _init_f_createSeparatedList_c2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("strl");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_createSeparatedList_c2437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->createSeparatedList (arg1));
}


// QString QLocale::currencySymbol(QLocale::CurrencySymbolFormat)


static void _init_f_currencySymbol_c3315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "QLocale::CurrencySymbol");
  decl->add_arg<const qt_gsi::Converter<QLocale::CurrencySymbolFormat>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_currencySymbol_c3315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::CurrencySymbolFormat>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::CurrencySymbolFormat>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::CurrencySymbolFormat>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::CurrencySymbolFormat>(heap, QLocale::CurrencySymbol), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->currencySymbol (qt_gsi::QtToCppAdaptor<QLocale::CurrencySymbolFormat>(arg1).cref()));
}


// QString QLocale::dateFormat(QLocale::FormatType format)


static void _init_f_dateFormat_c2260 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_dateFormat_c2260 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->dateFormat (qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg1).cref()));
}


// QString QLocale::dateTimeFormat(QLocale::FormatType format)


static void _init_f_dateTimeFormat_c2260 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_dateTimeFormat_c2260 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->dateTimeFormat (qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg1).cref()));
}


// QString QLocale::dayName(int, QLocale::FormatType format)


static void _init_f_dayName_c2919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_dayName_c2919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->dayName (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// QChar QLocale::decimalPoint()


static void _init_f_decimalPoint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_decimalPoint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->decimalPoint ()));
}


// QChar QLocale::exponential()


static void _init_f_exponential_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_exponential_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->exponential ()));
}


// Qt::DayOfWeek QLocale::firstDayOfWeek()


static void _init_f_firstDayOfWeek_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::DayOfWeek>::target_type > ();
}

static void _call_f_firstDayOfWeek_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::DayOfWeek>::target_type > ((qt_gsi::Converter<Qt::DayOfWeek>::target_type)qt_gsi::CppToQtAdaptor<Qt::DayOfWeek>(((QLocale *)cls)->firstDayOfWeek ()));
}


// QChar QLocale::groupSeparator()


static void _init_f_groupSeparator_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_groupSeparator_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->groupSeparator ()));
}


// QLocale::Language QLocale::language()


static void _init_f_language_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QLocale::Language>::target_type > ();
}

static void _call_f_language_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QLocale::Language>::target_type > ((qt_gsi::Converter<QLocale::Language>::target_type)qt_gsi::CppToQtAdaptor<QLocale::Language>(((QLocale *)cls)->language ()));
}


// QLocale::MeasurementSystem QLocale::measurementSystem()


static void _init_f_measurementSystem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QLocale::MeasurementSystem>::target_type > ();
}

static void _call_f_measurementSystem_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QLocale::MeasurementSystem>::target_type > ((qt_gsi::Converter<QLocale::MeasurementSystem>::target_type)qt_gsi::CppToQtAdaptor<QLocale::MeasurementSystem>(((QLocale *)cls)->measurementSystem ()));
}


// QString QLocale::monthName(int, QLocale::FormatType format)


static void _init_f_monthName_c2919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_monthName_c2919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->monthName (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// QString QLocale::name()


static void _init_f_name_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_name_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QLocale *)cls)->name ());
}


// QString QLocale::nativeCountryName()


static void _init_f_nativeCountryName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_nativeCountryName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QLocale *)cls)->nativeCountryName ());
}


// QString QLocale::nativeLanguageName()


static void _init_f_nativeLanguageName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_nativeLanguageName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QLocale *)cls)->nativeLanguageName ());
}


// QChar QLocale::negativeSign()


static void _init_f_negativeSign_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_negativeSign_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->negativeSign ()));
}


// QFlags<QLocale::NumberOption> QLocale::numberOptions()


static void _init_f_numberOptions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QLocale::NumberOption> > ();
}

static void _call_f_numberOptions_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QLocale::NumberOption> > ((QFlags<QLocale::NumberOption>)((QLocale *)cls)->numberOptions ());
}


// bool QLocale::operator!=(const QLocale &other)


static void _init_f_operator_excl__eq__c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLocale &arg1 = gsi::arg_reader<const QLocale & >() (args, heap);
  ret.write<bool > ((bool)((QLocale *)cls)->operator!= (arg1));
}


// QLocale &QLocale::operator=(const QLocale &other)


static void _init_f_operator_eq__1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return<QLocale & > ();
}

static void _call_f_operator_eq__1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLocale &arg1 = gsi::arg_reader<const QLocale & >() (args, heap);
  ret.write<QLocale & > ((QLocale &)((QLocale *)cls)->operator= (arg1));
}


// bool QLocale::operator==(const QLocale &other)


static void _init_f_operator_eq__eq__c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLocale &arg1 = gsi::arg_reader<const QLocale & >() (args, heap);
  ret.write<bool > ((bool)((QLocale *)cls)->operator== (arg1));
}


// QChar QLocale::percent()


static void _init_f_percent_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_percent_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->percent ()));
}


// QString QLocale::pmText()


static void _init_f_pmText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_pmText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QLocale *)cls)->pmText ());
}


// QChar QLocale::positiveSign()


static void _init_f_positiveSign_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_positiveSign_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->positiveSign ()));
}


// QString QLocale::quoteString(const QString &str, QLocale::QuotationStyle style)


static void _init_f_quoteString_c4635 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("str");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("style", true, "QLocale::StandardQuotation");
  decl->add_arg<const qt_gsi::Converter<QLocale::QuotationStyle>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_quoteString_c4635 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QLocale::QuotationStyle>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::QuotationStyle>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::QuotationStyle>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::QuotationStyle>(heap, QLocale::StandardQuotation), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->quoteString (arg1, qt_gsi::QtToCppAdaptor<QLocale::QuotationStyle>(arg2).cref()));
}


// QLocale::Script QLocale::script()


static void _init_f_script_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QLocale::Script>::target_type > ();
}

static void _call_f_script_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QLocale::Script>::target_type > ((qt_gsi::Converter<QLocale::Script>::target_type)qt_gsi::CppToQtAdaptor<QLocale::Script>(((QLocale *)cls)->script ()));
}


// void QLocale::setNumberOptions(QFlags<QLocale::NumberOption> options)


static void _init_f_setNumberOptions_3171 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options");
  decl->add_arg<QFlags<QLocale::NumberOption> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNumberOptions_3171 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QLocale::NumberOption> arg1 = gsi::arg_reader<QFlags<QLocale::NumberOption> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLocale *)cls)->setNumberOptions (arg1);
}


// QString QLocale::standaloneDayName(int, QLocale::FormatType format)


static void _init_f_standaloneDayName_c2919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_standaloneDayName_c2919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->standaloneDayName (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// QString QLocale::standaloneMonthName(int, QLocale::FormatType format)


static void _init_f_standaloneMonthName_c2919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_standaloneMonthName_c2919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->standaloneMonthName (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// Qt::LayoutDirection QLocale::textDirection()


static void _init_f_textDirection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ();
}

static void _call_f_textDirection_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ((qt_gsi::Converter<Qt::LayoutDirection>::target_type)qt_gsi::CppToQtAdaptor<Qt::LayoutDirection>(((QLocale *)cls)->textDirection ()));
}


// QString QLocale::timeFormat(QLocale::FormatType format)


static void _init_f_timeFormat_c2260 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_timeFormat_c2260 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->timeFormat (qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg1).cref()));
}


// QString QLocale::toCurrencyString(qlonglong, const QString &symbol)


static void _init_f_toCurrencyString_c3330 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<qlonglong > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("symbol", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toCurrencyString_c3330 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qlonglong arg1 = gsi::arg_reader<qlonglong >() (args, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toCurrencyString (arg1, arg2));
}


// QString QLocale::toCurrencyString(qulonglong, const QString &symbol)


static void _init_f_toCurrencyString_c3447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<qulonglong > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("symbol", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toCurrencyString_c3447 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qulonglong arg1 = gsi::arg_reader<qulonglong >() (args, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toCurrencyString (arg1, arg2));
}


// QString QLocale::toCurrencyString(short int, const QString &symbol)


static void _init_f_toCurrencyString_c3388 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<short int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("symbol", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toCurrencyString_c3388 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  short int arg1 = gsi::arg_reader<short int >() (args, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toCurrencyString (arg1, arg2));
}


// QString QLocale::toCurrencyString(unsigned short int, const QString &symbol)


static void _init_f_toCurrencyString_c4393 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<unsigned short int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("symbol", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toCurrencyString_c4393 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned short int arg1 = gsi::arg_reader<unsigned short int >() (args, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toCurrencyString (arg1, arg2));
}


// QString QLocale::toCurrencyString(int, const QString &symbol)


static void _init_f_toCurrencyString_c2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("symbol", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toCurrencyString_c2684 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toCurrencyString (arg1, arg2));
}


// QString QLocale::toCurrencyString(unsigned int, const QString &symbol)


static void _init_f_toCurrencyString_c3689 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("symbol", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toCurrencyString_c3689 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = gsi::arg_reader<unsigned int >() (args, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toCurrencyString (arg1, arg2));
}


// QString QLocale::toCurrencyString(double, const QString &symbol)


static void _init_f_toCurrencyString_c2988 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("symbol", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toCurrencyString_c2988 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toCurrencyString (arg1, arg2));
}


// QString QLocale::toCurrencyString(float, const QString &symbol)


static void _init_f_toCurrencyString_c2887 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<float > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("symbol", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toCurrencyString_c2887 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toCurrencyString (arg1, arg2));
}


// QDate QLocale::toDate(const QString &string, QLocale::FormatType)


static void _init_f_toDate_c4177 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QDate > ();
}

static void _call_f_toDate_c4177 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QDate > ((QDate)((QLocale *)cls)->toDate (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// QDate QLocale::toDate(const QString &string, const QString &format)


static void _init_f_toDate_c3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QDate > ();
}

static void _call_f_toDate_c3942 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QDate > ((QDate)((QLocale *)cls)->toDate (arg1, arg2));
}


// QDateTime QLocale::toDateTime(const QString &string, QLocale::FormatType format)


static void _init_f_toDateTime_c4177 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QDateTime > ();
}

static void _call_f_toDateTime_c4177 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QDateTime > ((QDateTime)((QLocale *)cls)->toDateTime (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// QDateTime QLocale::toDateTime(const QString &string, const QString &format)


static void _init_f_toDateTime_c3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QDateTime > ();
}

static void _call_f_toDateTime_c3942 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QDateTime > ((QDateTime)((QLocale *)cls)->toDateTime (arg1, arg2));
}


// double QLocale::toDouble(const QString &s, bool *ok)


static void _init_f_toDouble_c2967 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<double > ();
}

static void _call_f_toDouble_c2967 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<double > ((double)((QLocale *)cls)->toDouble (arg1, arg2));
}


// float QLocale::toFloat(const QString &s, bool *ok)


static void _init_f_toFloat_c2967 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<float > ();
}

static void _call_f_toFloat_c2967 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<float > ((float)((QLocale *)cls)->toFloat (arg1, arg2));
}


// int QLocale::toInt(const QString &s, bool *ok)


static void _init_f_toInt_c2967 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_toInt_c2967 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<int > ((int)((QLocale *)cls)->toInt (arg1, arg2));
}


// qlonglong QLocale::toLongLong(const QString &s, bool *ok)


static void _init_f_toLongLong_c2967 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<qlonglong > ();
}

static void _call_f_toLongLong_c2967 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<qlonglong > ((qlonglong)((QLocale *)cls)->toLongLong (arg1, arg2));
}


// QString QLocale::toLower(const QString &str)


static void _init_f_toLower_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("str");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toLower_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toLower (arg1));
}


// short int QLocale::toShort(const QString &s, bool *ok)


static void _init_f_toShort_c2967 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<short int > ();
}

static void _call_f_toShort_c2967 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<short int > ((short int)((QLocale *)cls)->toShort (arg1, arg2));
}


// QString QLocale::toString(qlonglong i)


static void _init_f_toString_c1413 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<qlonglong > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c1413 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qlonglong arg1 = gsi::arg_reader<qlonglong >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1));
}


// QString QLocale::toString(qulonglong i)


static void _init_f_toString_c1530 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<qulonglong > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c1530 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qulonglong arg1 = gsi::arg_reader<qulonglong >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1));
}


// QString QLocale::toString(short int i)


static void _init_f_toString_c1471 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<short int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c1471 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  short int arg1 = gsi::arg_reader<short int >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1));
}


// QString QLocale::toString(unsigned short int i)


static void _init_f_toString_c2476 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<unsigned short int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c2476 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned short int arg1 = gsi::arg_reader<unsigned short int >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1));
}


// QString QLocale::toString(int i)


static void _init_f_toString_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1));
}


// QString QLocale::toString(unsigned int i)


static void _init_f_toString_c1772 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c1772 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = gsi::arg_reader<unsigned int >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1));
}


// QString QLocale::toString(double i, char f, int prec)


static void _init_f_toString_c2472 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("f", true, "'g'");
  decl->add_arg<char > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("prec", true, "6");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_toString_c2472 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  char arg2 = args ? gsi::arg_reader<char >() (args, heap) : gsi::arg_maker<char >() ('g', heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (6, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, arg2, arg3));
}


// QString QLocale::toString(float i, char f, int prec)


static void _init_f_toString_c2371 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<float > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("f", true, "'g'");
  decl->add_arg<char > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("prec", true, "6");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_toString_c2371 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  char arg2 = args ? gsi::arg_reader<char >() (args, heap) : gsi::arg_maker<char >() ('g', heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (6, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, arg2, arg3));
}


// QString QLocale::toString(const QDate &date, const QString &formatStr)


static void _init_f_toString_c3693 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<const QDate & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("formatStr");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c3693 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDate &arg1 = gsi::arg_reader<const QDate & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, arg2));
}


// QString QLocale::toString(const QDate &date, QLocale::FormatType format)


static void _init_f_toString_c3928 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<const QDate & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c3928 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDate &arg1 = gsi::arg_reader<const QDate & >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// QString QLocale::toString(const QTime &time, const QString &formatStr)


static void _init_f_toString_c3710 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("time");
  decl->add_arg<const QTime & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("formatStr");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c3710 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTime &arg1 = gsi::arg_reader<const QTime & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, arg2));
}


// QString QLocale::toString(const QTime &time, QLocale::FormatType format)


static void _init_f_toString_c3945 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("time");
  decl->add_arg<const QTime & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c3945 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTime &arg1 = gsi::arg_reader<const QTime & >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// QString QLocale::toString(const QDateTime &dateTime, QLocale::FormatType format)


static void _init_f_toString_c4327 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dateTime");
  decl->add_arg<const QDateTime & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c4327 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDateTime &arg1 = gsi::arg_reader<const QDateTime & >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// QString QLocale::toString(const QDateTime &dateTime, const QString &format)


static void _init_f_toString_c4092 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dateTime");
  decl->add_arg<const QDateTime & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c4092 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDateTime &arg1 = gsi::arg_reader<const QDateTime & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, arg2));
}


// QTime QLocale::toTime(const QString &string, QLocale::FormatType)


static void _init_f_toTime_c4177 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QTime > ();
}

static void _call_f_toTime_c4177 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QTime > ((QTime)((QLocale *)cls)->toTime (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// QTime QLocale::toTime(const QString &string, const QString &format)


static void _init_f_toTime_c3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QTime > ();
}

static void _call_f_toTime_c3942 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QTime > ((QTime)((QLocale *)cls)->toTime (arg1, arg2));
}


// unsigned int QLocale::toUInt(const QString &s, bool *ok)


static void _init_f_toUInt_c2967 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<unsigned int > ();
}

static void _call_f_toUInt_c2967 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<unsigned int > ((unsigned int)((QLocale *)cls)->toUInt (arg1, arg2));
}


// qulonglong QLocale::toULongLong(const QString &s, bool *ok)


static void _init_f_toULongLong_c2967 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<qulonglong > ();
}

static void _call_f_toULongLong_c2967 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<qulonglong > ((qulonglong)((QLocale *)cls)->toULongLong (arg1, arg2));
}


// unsigned short int QLocale::toUShort(const QString &s, bool *ok)


static void _init_f_toUShort_c2967 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<unsigned short int > ();
}

static void _call_f_toUShort_c2967 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<unsigned short int > ((unsigned short int)((QLocale *)cls)->toUShort (arg1, arg2));
}


// QString QLocale::toUpper(const QString &str)


static void _init_f_toUpper_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("str");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toUpper_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toUpper (arg1));
}


// QStringList QLocale::uiLanguages()


static void _init_f_uiLanguages_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_uiLanguages_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QLocale *)cls)->uiLanguages ());
}


// QList<Qt::DayOfWeek> QLocale::weekdays()


static void _init_f_weekdays_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<Qt::DayOfWeek> > ();
}

static void _call_f_weekdays_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<Qt::DayOfWeek> > ((QList<Qt::DayOfWeek>)((QLocale *)cls)->weekdays ());
}


// QChar QLocale::zeroDigit()


static void _init_f_zeroDigit_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_zeroDigit_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->zeroDigit ()));
}


// static QLocale QLocale::c()


static void _init_f_c_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QLocale > ();
}

static void _call_f_c_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLocale > ((QLocale)QLocale::c ());
}


// static QList<QLocale::Country> QLocale::countriesForLanguage(QLocale::Language lang)


static void _init_f_countriesForLanguage_2029 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lang");
  decl->add_arg<const qt_gsi::Converter<QLocale::Language>::target_type & > (argspec_0);
  decl->set_return<QList<QLocale::Country> > ();
}

static void _call_f_countriesForLanguage_2029 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::Language>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QLocale::Language>::target_type & >() (args, heap);
  ret.write<QList<QLocale::Country> > ((QList<QLocale::Country>)QLocale::countriesForLanguage (qt_gsi::QtToCppAdaptor<QLocale::Language>(arg1).cref()));
}


// static QString QLocale::countryToString(QLocale::Country country)


static void _init_f_countryToString_1981 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("country");
  decl->add_arg<const qt_gsi::Converter<QLocale::Country>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_countryToString_1981 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::Country>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QLocale::Country>::target_type & >() (args, heap);
  ret.write<QString > ((QString)QLocale::countryToString (qt_gsi::QtToCppAdaptor<QLocale::Country>(arg1).cref()));
}


// static QString QLocale::languageToString(QLocale::Language language)


static void _init_f_languageToString_2029 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("language");
  decl->add_arg<const qt_gsi::Converter<QLocale::Language>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_languageToString_2029 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::Language>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QLocale::Language>::target_type & >() (args, heap);
  ret.write<QString > ((QString)QLocale::languageToString (qt_gsi::QtToCppAdaptor<QLocale::Language>(arg1).cref()));
}


// static QList<QLocale> QLocale::matchingLocales(QLocale::Language language, QLocale::Script script, QLocale::Country country)


static void _init_f_matchingLocales_5648 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("language");
  decl->add_arg<const qt_gsi::Converter<QLocale::Language>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("script");
  decl->add_arg<const qt_gsi::Converter<QLocale::Script>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("country");
  decl->add_arg<const qt_gsi::Converter<QLocale::Country>::target_type & > (argspec_2);
  decl->set_return<QList<QLocale> > ();
}

static void _call_f_matchingLocales_5648 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::Language>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QLocale::Language>::target_type & >() (args, heap);
  const qt_gsi::Converter<QLocale::Script>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QLocale::Script>::target_type & >() (args, heap);
  const qt_gsi::Converter<QLocale::Country>::target_type & arg3 = gsi::arg_reader<const qt_gsi::Converter<QLocale::Country>::target_type & >() (args, heap);
  ret.write<QList<QLocale> > ((QList<QLocale>)QLocale::matchingLocales (qt_gsi::QtToCppAdaptor<QLocale::Language>(arg1).cref(), qt_gsi::QtToCppAdaptor<QLocale::Script>(arg2).cref(), qt_gsi::QtToCppAdaptor<QLocale::Country>(arg3).cref()));
}


// static QString QLocale::scriptToString(QLocale::Script script)


static void _init_f_scriptToString_1854 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("script");
  decl->add_arg<const qt_gsi::Converter<QLocale::Script>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_scriptToString_1854 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::Script>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QLocale::Script>::target_type & >() (args, heap);
  ret.write<QString > ((QString)QLocale::scriptToString (qt_gsi::QtToCppAdaptor<QLocale::Script>(arg1).cref()));
}


// static void QLocale::setDefault(const QLocale &locale)


static void _init_f_setDefault_1986 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("locale");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefault_1986 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLocale &arg1 = gsi::arg_reader<const QLocale & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QLocale::setDefault (arg1);
}


// static QLocale QLocale::system()


static void _init_f_system_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QLocale > ();
}

static void _call_f_system_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLocale > ((QLocale)QLocale::system ());
}



namespace gsi
{

static gsi::Methods methods_QLocale () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLocale::QLocale()\nThis method creates an object of class QLocale.", &_init_ctor_QLocale_0, &_call_ctor_QLocale_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLocale::QLocale(const QString &name)\nThis method creates an object of class QLocale.", &_init_ctor_QLocale_2025, &_call_ctor_QLocale_2025);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLocale::QLocale(QLocale::Language language, QLocale::Country country)\nThis method creates an object of class QLocale.", &_init_ctor_QLocale_3902, &_call_ctor_QLocale_3902);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLocale::QLocale(QLocale::Language language, QLocale::Script script, QLocale::Country country)\nThis method creates an object of class QLocale.", &_init_ctor_QLocale_5648, &_call_ctor_QLocale_5648);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLocale::QLocale(const QLocale &other)\nThis method creates an object of class QLocale.", &_init_ctor_QLocale_1986, &_call_ctor_QLocale_1986);
  methods += new qt_gsi::GenericMethod ("amText", "@brief Method QString QLocale::amText()\n", true, &_init_f_amText_c0, &_call_f_amText_c0);
  methods += new qt_gsi::GenericMethod ("bcp47Name", "@brief Method QString QLocale::bcp47Name()\n", true, &_init_f_bcp47Name_c0, &_call_f_bcp47Name_c0);
  methods += new qt_gsi::GenericMethod ("country", "@brief Method QLocale::Country QLocale::country()\n", true, &_init_f_country_c0, &_call_f_country_c0);
  methods += new qt_gsi::GenericMethod ("createSeparatedList", "@brief Method QString QLocale::createSeparatedList(const QStringList &strl)\n", true, &_init_f_createSeparatedList_c2437, &_call_f_createSeparatedList_c2437);
  methods += new qt_gsi::GenericMethod ("currencySymbol", "@brief Method QString QLocale::currencySymbol(QLocale::CurrencySymbolFormat)\n", true, &_init_f_currencySymbol_c3315, &_call_f_currencySymbol_c3315);
  methods += new qt_gsi::GenericMethod ("dateFormat", "@brief Method QString QLocale::dateFormat(QLocale::FormatType format)\n", true, &_init_f_dateFormat_c2260, &_call_f_dateFormat_c2260);
  methods += new qt_gsi::GenericMethod ("dateTimeFormat", "@brief Method QString QLocale::dateTimeFormat(QLocale::FormatType format)\n", true, &_init_f_dateTimeFormat_c2260, &_call_f_dateTimeFormat_c2260);
  methods += new qt_gsi::GenericMethod ("dayName", "@brief Method QString QLocale::dayName(int, QLocale::FormatType format)\n", true, &_init_f_dayName_c2919, &_call_f_dayName_c2919);
  methods += new qt_gsi::GenericMethod ("decimalPoint", "@brief Method QChar QLocale::decimalPoint()\n", true, &_init_f_decimalPoint_c0, &_call_f_decimalPoint_c0);
  methods += new qt_gsi::GenericMethod ("exponential", "@brief Method QChar QLocale::exponential()\n", true, &_init_f_exponential_c0, &_call_f_exponential_c0);
  methods += new qt_gsi::GenericMethod ("firstDayOfWeek", "@brief Method Qt::DayOfWeek QLocale::firstDayOfWeek()\n", true, &_init_f_firstDayOfWeek_c0, &_call_f_firstDayOfWeek_c0);
  methods += new qt_gsi::GenericMethod ("groupSeparator", "@brief Method QChar QLocale::groupSeparator()\n", true, &_init_f_groupSeparator_c0, &_call_f_groupSeparator_c0);
  methods += new qt_gsi::GenericMethod ("language", "@brief Method QLocale::Language QLocale::language()\n", true, &_init_f_language_c0, &_call_f_language_c0);
  methods += new qt_gsi::GenericMethod ("measurementSystem", "@brief Method QLocale::MeasurementSystem QLocale::measurementSystem()\n", true, &_init_f_measurementSystem_c0, &_call_f_measurementSystem_c0);
  methods += new qt_gsi::GenericMethod ("monthName", "@brief Method QString QLocale::monthName(int, QLocale::FormatType format)\n", true, &_init_f_monthName_c2919, &_call_f_monthName_c2919);
  methods += new qt_gsi::GenericMethod ("name", "@brief Method QString QLocale::name()\n", true, &_init_f_name_c0, &_call_f_name_c0);
  methods += new qt_gsi::GenericMethod ("nativeCountryName", "@brief Method QString QLocale::nativeCountryName()\n", true, &_init_f_nativeCountryName_c0, &_call_f_nativeCountryName_c0);
  methods += new qt_gsi::GenericMethod ("nativeLanguageName", "@brief Method QString QLocale::nativeLanguageName()\n", true, &_init_f_nativeLanguageName_c0, &_call_f_nativeLanguageName_c0);
  methods += new qt_gsi::GenericMethod ("negativeSign", "@brief Method QChar QLocale::negativeSign()\n", true, &_init_f_negativeSign_c0, &_call_f_negativeSign_c0);
  methods += new qt_gsi::GenericMethod (":numberOptions", "@brief Method QFlags<QLocale::NumberOption> QLocale::numberOptions()\n", true, &_init_f_numberOptions_c0, &_call_f_numberOptions_c0);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QLocale::operator!=(const QLocale &other)\n", true, &_init_f_operator_excl__eq__c1986, &_call_f_operator_excl__eq__c1986);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QLocale &QLocale::operator=(const QLocale &other)\n", false, &_init_f_operator_eq__1986, &_call_f_operator_eq__1986);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QLocale::operator==(const QLocale &other)\n", true, &_init_f_operator_eq__eq__c1986, &_call_f_operator_eq__eq__c1986);
  methods += new qt_gsi::GenericMethod ("percent", "@brief Method QChar QLocale::percent()\n", true, &_init_f_percent_c0, &_call_f_percent_c0);
  methods += new qt_gsi::GenericMethod ("pmText", "@brief Method QString QLocale::pmText()\n", true, &_init_f_pmText_c0, &_call_f_pmText_c0);
  methods += new qt_gsi::GenericMethod ("positiveSign", "@brief Method QChar QLocale::positiveSign()\n", true, &_init_f_positiveSign_c0, &_call_f_positiveSign_c0);
  methods += new qt_gsi::GenericMethod ("quoteString", "@brief Method QString QLocale::quoteString(const QString &str, QLocale::QuotationStyle style)\n", true, &_init_f_quoteString_c4635, &_call_f_quoteString_c4635);
  methods += new qt_gsi::GenericMethod ("script", "@brief Method QLocale::Script QLocale::script()\n", true, &_init_f_script_c0, &_call_f_script_c0);
  methods += new qt_gsi::GenericMethod ("setNumberOptions|numberOptions=", "@brief Method void QLocale::setNumberOptions(QFlags<QLocale::NumberOption> options)\n", false, &_init_f_setNumberOptions_3171, &_call_f_setNumberOptions_3171);
  methods += new qt_gsi::GenericMethod ("standaloneDayName", "@brief Method QString QLocale::standaloneDayName(int, QLocale::FormatType format)\n", true, &_init_f_standaloneDayName_c2919, &_call_f_standaloneDayName_c2919);
  methods += new qt_gsi::GenericMethod ("standaloneMonthName", "@brief Method QString QLocale::standaloneMonthName(int, QLocale::FormatType format)\n", true, &_init_f_standaloneMonthName_c2919, &_call_f_standaloneMonthName_c2919);
  methods += new qt_gsi::GenericMethod ("textDirection", "@brief Method Qt::LayoutDirection QLocale::textDirection()\n", true, &_init_f_textDirection_c0, &_call_f_textDirection_c0);
  methods += new qt_gsi::GenericMethod ("timeFormat", "@brief Method QString QLocale::timeFormat(QLocale::FormatType format)\n", true, &_init_f_timeFormat_c2260, &_call_f_timeFormat_c2260);
  methods += new qt_gsi::GenericMethod ("toCurrencyString", "@brief Method QString QLocale::toCurrencyString(qlonglong, const QString &symbol)\n", true, &_init_f_toCurrencyString_c3330, &_call_f_toCurrencyString_c3330);
  methods += new qt_gsi::GenericMethod ("toCurrencyString", "@brief Method QString QLocale::toCurrencyString(qulonglong, const QString &symbol)\n", true, &_init_f_toCurrencyString_c3447, &_call_f_toCurrencyString_c3447);
  methods += new qt_gsi::GenericMethod ("toCurrencyString", "@brief Method QString QLocale::toCurrencyString(short int, const QString &symbol)\n", true, &_init_f_toCurrencyString_c3388, &_call_f_toCurrencyString_c3388);
  methods += new qt_gsi::GenericMethod ("toCurrencyString", "@brief Method QString QLocale::toCurrencyString(unsigned short int, const QString &symbol)\n", true, &_init_f_toCurrencyString_c4393, &_call_f_toCurrencyString_c4393);
  methods += new qt_gsi::GenericMethod ("toCurrencyString", "@brief Method QString QLocale::toCurrencyString(int, const QString &symbol)\n", true, &_init_f_toCurrencyString_c2684, &_call_f_toCurrencyString_c2684);
  methods += new qt_gsi::GenericMethod ("toCurrencyString", "@brief Method QString QLocale::toCurrencyString(unsigned int, const QString &symbol)\n", true, &_init_f_toCurrencyString_c3689, &_call_f_toCurrencyString_c3689);
  methods += new qt_gsi::GenericMethod ("toCurrencyString", "@brief Method QString QLocale::toCurrencyString(double, const QString &symbol)\n", true, &_init_f_toCurrencyString_c2988, &_call_f_toCurrencyString_c2988);
  methods += new qt_gsi::GenericMethod ("toCurrencyString", "@brief Method QString QLocale::toCurrencyString(float, const QString &symbol)\n", true, &_init_f_toCurrencyString_c2887, &_call_f_toCurrencyString_c2887);
  methods += new qt_gsi::GenericMethod ("toDate", "@brief Method QDate QLocale::toDate(const QString &string, QLocale::FormatType)\n", true, &_init_f_toDate_c4177, &_call_f_toDate_c4177);
  methods += new qt_gsi::GenericMethod ("toDate", "@brief Method QDate QLocale::toDate(const QString &string, const QString &format)\n", true, &_init_f_toDate_c3942, &_call_f_toDate_c3942);
  methods += new qt_gsi::GenericMethod ("toDateTime", "@brief Method QDateTime QLocale::toDateTime(const QString &string, QLocale::FormatType format)\n", true, &_init_f_toDateTime_c4177, &_call_f_toDateTime_c4177);
  methods += new qt_gsi::GenericMethod ("toDateTime", "@brief Method QDateTime QLocale::toDateTime(const QString &string, const QString &format)\n", true, &_init_f_toDateTime_c3942, &_call_f_toDateTime_c3942);
  methods += new qt_gsi::GenericMethod ("toDouble", "@brief Method double QLocale::toDouble(const QString &s, bool *ok)\n", true, &_init_f_toDouble_c2967, &_call_f_toDouble_c2967);
  methods += new qt_gsi::GenericMethod ("toFloat", "@brief Method float QLocale::toFloat(const QString &s, bool *ok)\n", true, &_init_f_toFloat_c2967, &_call_f_toFloat_c2967);
  methods += new qt_gsi::GenericMethod ("toInt", "@brief Method int QLocale::toInt(const QString &s, bool *ok)\n", true, &_init_f_toInt_c2967, &_call_f_toInt_c2967);
  methods += new qt_gsi::GenericMethod ("toLongLong", "@brief Method qlonglong QLocale::toLongLong(const QString &s, bool *ok)\n", true, &_init_f_toLongLong_c2967, &_call_f_toLongLong_c2967);
  methods += new qt_gsi::GenericMethod ("toLower", "@brief Method QString QLocale::toLower(const QString &str)\n", true, &_init_f_toLower_c2025, &_call_f_toLower_c2025);
  methods += new qt_gsi::GenericMethod ("toShort", "@brief Method short int QLocale::toShort(const QString &s, bool *ok)\n", true, &_init_f_toShort_c2967, &_call_f_toShort_c2967);
  methods += new qt_gsi::GenericMethod ("toString_ll", "@brief Method QString QLocale::toString(qlonglong i)\n", true, &_init_f_toString_c1413, &_call_f_toString_c1413);
  methods += new qt_gsi::GenericMethod ("toString_ull", "@brief Method QString QLocale::toString(qulonglong i)\n", true, &_init_f_toString_c1530, &_call_f_toString_c1530);
  methods += new qt_gsi::GenericMethod ("toString_s", "@brief Method QString QLocale::toString(short int i)\n", true, &_init_f_toString_c1471, &_call_f_toString_c1471);
  methods += new qt_gsi::GenericMethod ("toString_us", "@brief Method QString QLocale::toString(unsigned short int i)\n", true, &_init_f_toString_c2476, &_call_f_toString_c2476);
  methods += new qt_gsi::GenericMethod ("toString_i", "@brief Method QString QLocale::toString(int i)\n", true, &_init_f_toString_c767, &_call_f_toString_c767);
  methods += new qt_gsi::GenericMethod ("toString_ui", "@brief Method QString QLocale::toString(unsigned int i)\n", true, &_init_f_toString_c1772, &_call_f_toString_c1772);
  methods += new qt_gsi::GenericMethod ("toString_d", "@brief Method QString QLocale::toString(double i, char f, int prec)\n", true, &_init_f_toString_c2472, &_call_f_toString_c2472);
  methods += new qt_gsi::GenericMethod ("toString_f", "@brief Method QString QLocale::toString(float i, char f, int prec)\n", true, &_init_f_toString_c2371, &_call_f_toString_c2371);
  methods += new qt_gsi::GenericMethod ("toString", "@brief Method QString QLocale::toString(const QDate &date, const QString &formatStr)\n", true, &_init_f_toString_c3693, &_call_f_toString_c3693);
  methods += new qt_gsi::GenericMethod ("toString", "@brief Method QString QLocale::toString(const QDate &date, QLocale::FormatType format)\n", true, &_init_f_toString_c3928, &_call_f_toString_c3928);
  methods += new qt_gsi::GenericMethod ("toString", "@brief Method QString QLocale::toString(const QTime &time, const QString &formatStr)\n", true, &_init_f_toString_c3710, &_call_f_toString_c3710);
  methods += new qt_gsi::GenericMethod ("toString", "@brief Method QString QLocale::toString(const QTime &time, QLocale::FormatType format)\n", true, &_init_f_toString_c3945, &_call_f_toString_c3945);
  methods += new qt_gsi::GenericMethod ("toString", "@brief Method QString QLocale::toString(const QDateTime &dateTime, QLocale::FormatType format)\n", true, &_init_f_toString_c4327, &_call_f_toString_c4327);
  methods += new qt_gsi::GenericMethod ("toString", "@brief Method QString QLocale::toString(const QDateTime &dateTime, const QString &format)\n", true, &_init_f_toString_c4092, &_call_f_toString_c4092);
  methods += new qt_gsi::GenericMethod ("toTime", "@brief Method QTime QLocale::toTime(const QString &string, QLocale::FormatType)\n", true, &_init_f_toTime_c4177, &_call_f_toTime_c4177);
  methods += new qt_gsi::GenericMethod ("toTime", "@brief Method QTime QLocale::toTime(const QString &string, const QString &format)\n", true, &_init_f_toTime_c3942, &_call_f_toTime_c3942);
  methods += new qt_gsi::GenericMethod ("toUInt", "@brief Method unsigned int QLocale::toUInt(const QString &s, bool *ok)\n", true, &_init_f_toUInt_c2967, &_call_f_toUInt_c2967);
  methods += new qt_gsi::GenericMethod ("toULongLong", "@brief Method qulonglong QLocale::toULongLong(const QString &s, bool *ok)\n", true, &_init_f_toULongLong_c2967, &_call_f_toULongLong_c2967);
  methods += new qt_gsi::GenericMethod ("toUShort", "@brief Method unsigned short int QLocale::toUShort(const QString &s, bool *ok)\n", true, &_init_f_toUShort_c2967, &_call_f_toUShort_c2967);
  methods += new qt_gsi::GenericMethod ("toUpper", "@brief Method QString QLocale::toUpper(const QString &str)\n", true, &_init_f_toUpper_c2025, &_call_f_toUpper_c2025);
  methods += new qt_gsi::GenericMethod ("uiLanguages", "@brief Method QStringList QLocale::uiLanguages()\n", true, &_init_f_uiLanguages_c0, &_call_f_uiLanguages_c0);
  methods += new qt_gsi::GenericMethod ("weekdays", "@brief Method QList<Qt::DayOfWeek> QLocale::weekdays()\n", true, &_init_f_weekdays_c0, &_call_f_weekdays_c0);
  methods += new qt_gsi::GenericMethod ("zeroDigit", "@brief Method QChar QLocale::zeroDigit()\n", true, &_init_f_zeroDigit_c0, &_call_f_zeroDigit_c0);
  methods += new qt_gsi::GenericStaticMethod ("c", "@brief Static method QLocale QLocale::c()\nThis method is static and can be called without an instance.", &_init_f_c_0, &_call_f_c_0);
  methods += new qt_gsi::GenericStaticMethod ("countriesForLanguage", "@brief Static method QList<QLocale::Country> QLocale::countriesForLanguage(QLocale::Language lang)\nThis method is static and can be called without an instance.", &_init_f_countriesForLanguage_2029, &_call_f_countriesForLanguage_2029);
  methods += new qt_gsi::GenericStaticMethod ("countryToString", "@brief Static method QString QLocale::countryToString(QLocale::Country country)\nThis method is static and can be called without an instance.", &_init_f_countryToString_1981, &_call_f_countryToString_1981);
  methods += new qt_gsi::GenericStaticMethod ("languageToString", "@brief Static method QString QLocale::languageToString(QLocale::Language language)\nThis method is static and can be called without an instance.", &_init_f_languageToString_2029, &_call_f_languageToString_2029);
  methods += new qt_gsi::GenericStaticMethod ("matchingLocales", "@brief Static method QList<QLocale> QLocale::matchingLocales(QLocale::Language language, QLocale::Script script, QLocale::Country country)\nThis method is static and can be called without an instance.", &_init_f_matchingLocales_5648, &_call_f_matchingLocales_5648);
  methods += new qt_gsi::GenericStaticMethod ("scriptToString", "@brief Static method QString QLocale::scriptToString(QLocale::Script script)\nThis method is static and can be called without an instance.", &_init_f_scriptToString_1854, &_call_f_scriptToString_1854);
  methods += new qt_gsi::GenericStaticMethod ("setDefault", "@brief Static method void QLocale::setDefault(const QLocale &locale)\nThis method is static and can be called without an instance.", &_init_f_setDefault_1986, &_call_f_setDefault_1986);
  methods += new qt_gsi::GenericStaticMethod ("system", "@brief Static method QLocale QLocale::system()\nThis method is static and can be called without an instance.", &_init_f_system_0, &_call_f_system_0);
  return methods;
}

gsi::Class<QLocale> decl_QLocale ("QtCore", "QLocale",
  methods_QLocale (),
  "@qt\n@brief Binding of QLocale");


GSI_QTCORE_PUBLIC gsi::Class<QLocale> &qtdecl_QLocale () { return decl_QLocale; }

}


//  Implementation of the enum wrapper class for QLocale::Country
namespace qt_gsi
{

static gsi::Enum<QLocale::Country> decl_QLocale_Country_Enum ("QtCore", "QLocale_Country",
    gsi::enum_const ("AnyCountry", QLocale::AnyCountry, "@brief Enum constant QLocale::AnyCountry") +
    gsi::enum_const ("Afghanistan", QLocale::Afghanistan, "@brief Enum constant QLocale::Afghanistan") +
    gsi::enum_const ("Albania", QLocale::Albania, "@brief Enum constant QLocale::Albania") +
    gsi::enum_const ("Algeria", QLocale::Algeria, "@brief Enum constant QLocale::Algeria") +
    gsi::enum_const ("AmericanSamoa", QLocale::AmericanSamoa, "@brief Enum constant QLocale::AmericanSamoa") +
    gsi::enum_const ("Andorra", QLocale::Andorra, "@brief Enum constant QLocale::Andorra") +
    gsi::enum_const ("Angola", QLocale::Angola, "@brief Enum constant QLocale::Angola") +
    gsi::enum_const ("Anguilla", QLocale::Anguilla, "@brief Enum constant QLocale::Anguilla") +
    gsi::enum_const ("Antarctica", QLocale::Antarctica, "@brief Enum constant QLocale::Antarctica") +
    gsi::enum_const ("AntiguaAndBarbuda", QLocale::AntiguaAndBarbuda, "@brief Enum constant QLocale::AntiguaAndBarbuda") +
    gsi::enum_const ("Argentina", QLocale::Argentina, "@brief Enum constant QLocale::Argentina") +
    gsi::enum_const ("Armenia", QLocale::Armenia, "@brief Enum constant QLocale::Armenia") +
    gsi::enum_const ("Aruba", QLocale::Aruba, "@brief Enum constant QLocale::Aruba") +
    gsi::enum_const ("Australia", QLocale::Australia, "@brief Enum constant QLocale::Australia") +
    gsi::enum_const ("Austria", QLocale::Austria, "@brief Enum constant QLocale::Austria") +
    gsi::enum_const ("Azerbaijan", QLocale::Azerbaijan, "@brief Enum constant QLocale::Azerbaijan") +
    gsi::enum_const ("Bahamas", QLocale::Bahamas, "@brief Enum constant QLocale::Bahamas") +
    gsi::enum_const ("Bahrain", QLocale::Bahrain, "@brief Enum constant QLocale::Bahrain") +
    gsi::enum_const ("Bangladesh", QLocale::Bangladesh, "@brief Enum constant QLocale::Bangladesh") +
    gsi::enum_const ("Barbados", QLocale::Barbados, "@brief Enum constant QLocale::Barbados") +
    gsi::enum_const ("Belarus", QLocale::Belarus, "@brief Enum constant QLocale::Belarus") +
    gsi::enum_const ("Belgium", QLocale::Belgium, "@brief Enum constant QLocale::Belgium") +
    gsi::enum_const ("Belize", QLocale::Belize, "@brief Enum constant QLocale::Belize") +
    gsi::enum_const ("Benin", QLocale::Benin, "@brief Enum constant QLocale::Benin") +
    gsi::enum_const ("Bermuda", QLocale::Bermuda, "@brief Enum constant QLocale::Bermuda") +
    gsi::enum_const ("Bhutan", QLocale::Bhutan, "@brief Enum constant QLocale::Bhutan") +
    gsi::enum_const ("Bolivia", QLocale::Bolivia, "@brief Enum constant QLocale::Bolivia") +
    gsi::enum_const ("BosniaAndHerzegowina", QLocale::BosniaAndHerzegowina, "@brief Enum constant QLocale::BosniaAndHerzegowina") +
    gsi::enum_const ("Botswana", QLocale::Botswana, "@brief Enum constant QLocale::Botswana") +
    gsi::enum_const ("BouvetIsland", QLocale::BouvetIsland, "@brief Enum constant QLocale::BouvetIsland") +
    gsi::enum_const ("Brazil", QLocale::Brazil, "@brief Enum constant QLocale::Brazil") +
    gsi::enum_const ("BritishIndianOceanTerritory", QLocale::BritishIndianOceanTerritory, "@brief Enum constant QLocale::BritishIndianOceanTerritory") +
    gsi::enum_const ("Brunei", QLocale::Brunei, "@brief Enum constant QLocale::Brunei") +
    gsi::enum_const ("Bulgaria", QLocale::Bulgaria, "@brief Enum constant QLocale::Bulgaria") +
    gsi::enum_const ("BurkinaFaso", QLocale::BurkinaFaso, "@brief Enum constant QLocale::BurkinaFaso") +
    gsi::enum_const ("Burundi", QLocale::Burundi, "@brief Enum constant QLocale::Burundi") +
    gsi::enum_const ("Cambodia", QLocale::Cambodia, "@brief Enum constant QLocale::Cambodia") +
    gsi::enum_const ("Cameroon", QLocale::Cameroon, "@brief Enum constant QLocale::Cameroon") +
    gsi::enum_const ("Canada", QLocale::Canada, "@brief Enum constant QLocale::Canada") +
    gsi::enum_const ("CapeVerde", QLocale::CapeVerde, "@brief Enum constant QLocale::CapeVerde") +
    gsi::enum_const ("CaymanIslands", QLocale::CaymanIslands, "@brief Enum constant QLocale::CaymanIslands") +
    gsi::enum_const ("CentralAfricanRepublic", QLocale::CentralAfricanRepublic, "@brief Enum constant QLocale::CentralAfricanRepublic") +
    gsi::enum_const ("Chad", QLocale::Chad, "@brief Enum constant QLocale::Chad") +
    gsi::enum_const ("Chile", QLocale::Chile, "@brief Enum constant QLocale::Chile") +
    gsi::enum_const ("China", QLocale::China, "@brief Enum constant QLocale::China") +
    gsi::enum_const ("ChristmasIsland", QLocale::ChristmasIsland, "@brief Enum constant QLocale::ChristmasIsland") +
    gsi::enum_const ("CocosIslands", QLocale::CocosIslands, "@brief Enum constant QLocale::CocosIslands") +
    gsi::enum_const ("Colombia", QLocale::Colombia, "@brief Enum constant QLocale::Colombia") +
    gsi::enum_const ("Comoros", QLocale::Comoros, "@brief Enum constant QLocale::Comoros") +
    gsi::enum_const ("CongoKinshasa", QLocale::CongoKinshasa, "@brief Enum constant QLocale::CongoKinshasa") +
    gsi::enum_const ("CongoBrazzaville", QLocale::CongoBrazzaville, "@brief Enum constant QLocale::CongoBrazzaville") +
    gsi::enum_const ("CookIslands", QLocale::CookIslands, "@brief Enum constant QLocale::CookIslands") +
    gsi::enum_const ("CostaRica", QLocale::CostaRica, "@brief Enum constant QLocale::CostaRica") +
    gsi::enum_const ("IvoryCoast", QLocale::IvoryCoast, "@brief Enum constant QLocale::IvoryCoast") +
    gsi::enum_const ("Croatia", QLocale::Croatia, "@brief Enum constant QLocale::Croatia") +
    gsi::enum_const ("Cuba", QLocale::Cuba, "@brief Enum constant QLocale::Cuba") +
    gsi::enum_const ("Cyprus", QLocale::Cyprus, "@brief Enum constant QLocale::Cyprus") +
    gsi::enum_const ("CzechRepublic", QLocale::CzechRepublic, "@brief Enum constant QLocale::CzechRepublic") +
    gsi::enum_const ("Denmark", QLocale::Denmark, "@brief Enum constant QLocale::Denmark") +
    gsi::enum_const ("Djibouti", QLocale::Djibouti, "@brief Enum constant QLocale::Djibouti") +
    gsi::enum_const ("Dominica", QLocale::Dominica, "@brief Enum constant QLocale::Dominica") +
    gsi::enum_const ("DominicanRepublic", QLocale::DominicanRepublic, "@brief Enum constant QLocale::DominicanRepublic") +
    gsi::enum_const ("EastTimor", QLocale::EastTimor, "@brief Enum constant QLocale::EastTimor") +
    gsi::enum_const ("Ecuador", QLocale::Ecuador, "@brief Enum constant QLocale::Ecuador") +
    gsi::enum_const ("Egypt", QLocale::Egypt, "@brief Enum constant QLocale::Egypt") +
    gsi::enum_const ("ElSalvador", QLocale::ElSalvador, "@brief Enum constant QLocale::ElSalvador") +
    gsi::enum_const ("EquatorialGuinea", QLocale::EquatorialGuinea, "@brief Enum constant QLocale::EquatorialGuinea") +
    gsi::enum_const ("Eritrea", QLocale::Eritrea, "@brief Enum constant QLocale::Eritrea") +
    gsi::enum_const ("Estonia", QLocale::Estonia, "@brief Enum constant QLocale::Estonia") +
    gsi::enum_const ("Ethiopia", QLocale::Ethiopia, "@brief Enum constant QLocale::Ethiopia") +
    gsi::enum_const ("FalklandIslands", QLocale::FalklandIslands, "@brief Enum constant QLocale::FalklandIslands") +
    gsi::enum_const ("FaroeIslands", QLocale::FaroeIslands, "@brief Enum constant QLocale::FaroeIslands") +
    gsi::enum_const ("Fiji", QLocale::Fiji, "@brief Enum constant QLocale::Fiji") +
    gsi::enum_const ("Finland", QLocale::Finland, "@brief Enum constant QLocale::Finland") +
    gsi::enum_const ("France", QLocale::France, "@brief Enum constant QLocale::France") +
    gsi::enum_const ("Guernsey", QLocale::Guernsey, "@brief Enum constant QLocale::Guernsey") +
    gsi::enum_const ("FrenchGuiana", QLocale::FrenchGuiana, "@brief Enum constant QLocale::FrenchGuiana") +
    gsi::enum_const ("FrenchPolynesia", QLocale::FrenchPolynesia, "@brief Enum constant QLocale::FrenchPolynesia") +
    gsi::enum_const ("FrenchSouthernTerritories", QLocale::FrenchSouthernTerritories, "@brief Enum constant QLocale::FrenchSouthernTerritories") +
    gsi::enum_const ("Gabon", QLocale::Gabon, "@brief Enum constant QLocale::Gabon") +
    gsi::enum_const ("Gambia", QLocale::Gambia, "@brief Enum constant QLocale::Gambia") +
    gsi::enum_const ("Georgia", QLocale::Georgia, "@brief Enum constant QLocale::Georgia") +
    gsi::enum_const ("Germany", QLocale::Germany, "@brief Enum constant QLocale::Germany") +
    gsi::enum_const ("Ghana", QLocale::Ghana, "@brief Enum constant QLocale::Ghana") +
    gsi::enum_const ("Gibraltar", QLocale::Gibraltar, "@brief Enum constant QLocale::Gibraltar") +
    gsi::enum_const ("Greece", QLocale::Greece, "@brief Enum constant QLocale::Greece") +
    gsi::enum_const ("Greenland", QLocale::Greenland, "@brief Enum constant QLocale::Greenland") +
    gsi::enum_const ("Grenada", QLocale::Grenada, "@brief Enum constant QLocale::Grenada") +
    gsi::enum_const ("Guadeloupe", QLocale::Guadeloupe, "@brief Enum constant QLocale::Guadeloupe") +
    gsi::enum_const ("Guam", QLocale::Guam, "@brief Enum constant QLocale::Guam") +
    gsi::enum_const ("Guatemala", QLocale::Guatemala, "@brief Enum constant QLocale::Guatemala") +
    gsi::enum_const ("Guinea", QLocale::Guinea, "@brief Enum constant QLocale::Guinea") +
    gsi::enum_const ("GuineaBissau", QLocale::GuineaBissau, "@brief Enum constant QLocale::GuineaBissau") +
    gsi::enum_const ("Guyana", QLocale::Guyana, "@brief Enum constant QLocale::Guyana") +
    gsi::enum_const ("Haiti", QLocale::Haiti, "@brief Enum constant QLocale::Haiti") +
    gsi::enum_const ("HeardAndMcDonaldIslands", QLocale::HeardAndMcDonaldIslands, "@brief Enum constant QLocale::HeardAndMcDonaldIslands") +
    gsi::enum_const ("Honduras", QLocale::Honduras, "@brief Enum constant QLocale::Honduras") +
    gsi::enum_const ("HongKong", QLocale::HongKong, "@brief Enum constant QLocale::HongKong") +
    gsi::enum_const ("Hungary", QLocale::Hungary, "@brief Enum constant QLocale::Hungary") +
    gsi::enum_const ("Iceland", QLocale::Iceland, "@brief Enum constant QLocale::Iceland") +
    gsi::enum_const ("India", QLocale::India, "@brief Enum constant QLocale::India") +
    gsi::enum_const ("Indonesia", QLocale::Indonesia, "@brief Enum constant QLocale::Indonesia") +
    gsi::enum_const ("Iran", QLocale::Iran, "@brief Enum constant QLocale::Iran") +
    gsi::enum_const ("Iraq", QLocale::Iraq, "@brief Enum constant QLocale::Iraq") +
    gsi::enum_const ("Ireland", QLocale::Ireland, "@brief Enum constant QLocale::Ireland") +
    gsi::enum_const ("Israel", QLocale::Israel, "@brief Enum constant QLocale::Israel") +
    gsi::enum_const ("Italy", QLocale::Italy, "@brief Enum constant QLocale::Italy") +
    gsi::enum_const ("Jamaica", QLocale::Jamaica, "@brief Enum constant QLocale::Jamaica") +
    gsi::enum_const ("Japan", QLocale::Japan, "@brief Enum constant QLocale::Japan") +
    gsi::enum_const ("Jordan", QLocale::Jordan, "@brief Enum constant QLocale::Jordan") +
    gsi::enum_const ("Kazakhstan", QLocale::Kazakhstan, "@brief Enum constant QLocale::Kazakhstan") +
    gsi::enum_const ("Kenya", QLocale::Kenya, "@brief Enum constant QLocale::Kenya") +
    gsi::enum_const ("Kiribati", QLocale::Kiribati, "@brief Enum constant QLocale::Kiribati") +
    gsi::enum_const ("NorthKorea", QLocale::NorthKorea, "@brief Enum constant QLocale::NorthKorea") +
    gsi::enum_const ("SouthKorea", QLocale::SouthKorea, "@brief Enum constant QLocale::SouthKorea") +
    gsi::enum_const ("Kuwait", QLocale::Kuwait, "@brief Enum constant QLocale::Kuwait") +
    gsi::enum_const ("Kyrgyzstan", QLocale::Kyrgyzstan, "@brief Enum constant QLocale::Kyrgyzstan") +
    gsi::enum_const ("Laos", QLocale::Laos, "@brief Enum constant QLocale::Laos") +
    gsi::enum_const ("Latvia", QLocale::Latvia, "@brief Enum constant QLocale::Latvia") +
    gsi::enum_const ("Lebanon", QLocale::Lebanon, "@brief Enum constant QLocale::Lebanon") +
    gsi::enum_const ("Lesotho", QLocale::Lesotho, "@brief Enum constant QLocale::Lesotho") +
    gsi::enum_const ("Liberia", QLocale::Liberia, "@brief Enum constant QLocale::Liberia") +
    gsi::enum_const ("Libya", QLocale::Libya, "@brief Enum constant QLocale::Libya") +
    gsi::enum_const ("Liechtenstein", QLocale::Liechtenstein, "@brief Enum constant QLocale::Liechtenstein") +
    gsi::enum_const ("Lithuania", QLocale::Lithuania, "@brief Enum constant QLocale::Lithuania") +
    gsi::enum_const ("Luxembourg", QLocale::Luxembourg, "@brief Enum constant QLocale::Luxembourg") +
    gsi::enum_const ("Macau", QLocale::Macau, "@brief Enum constant QLocale::Macau") +
    gsi::enum_const ("Macedonia", QLocale::Macedonia, "@brief Enum constant QLocale::Macedonia") +
    gsi::enum_const ("Madagascar", QLocale::Madagascar, "@brief Enum constant QLocale::Madagascar") +
    gsi::enum_const ("Malawi", QLocale::Malawi, "@brief Enum constant QLocale::Malawi") +
    gsi::enum_const ("Malaysia", QLocale::Malaysia, "@brief Enum constant QLocale::Malaysia") +
    gsi::enum_const ("Maldives", QLocale::Maldives, "@brief Enum constant QLocale::Maldives") +
    gsi::enum_const ("Mali", QLocale::Mali, "@brief Enum constant QLocale::Mali") +
    gsi::enum_const ("Malta", QLocale::Malta, "@brief Enum constant QLocale::Malta") +
    gsi::enum_const ("MarshallIslands", QLocale::MarshallIslands, "@brief Enum constant QLocale::MarshallIslands") +
    gsi::enum_const ("Martinique", QLocale::Martinique, "@brief Enum constant QLocale::Martinique") +
    gsi::enum_const ("Mauritania", QLocale::Mauritania, "@brief Enum constant QLocale::Mauritania") +
    gsi::enum_const ("Mauritius", QLocale::Mauritius, "@brief Enum constant QLocale::Mauritius") +
    gsi::enum_const ("Mayotte", QLocale::Mayotte, "@brief Enum constant QLocale::Mayotte") +
    gsi::enum_const ("Mexico", QLocale::Mexico, "@brief Enum constant QLocale::Mexico") +
    gsi::enum_const ("Micronesia", QLocale::Micronesia, "@brief Enum constant QLocale::Micronesia") +
    gsi::enum_const ("Moldova", QLocale::Moldova, "@brief Enum constant QLocale::Moldova") +
    gsi::enum_const ("Monaco", QLocale::Monaco, "@brief Enum constant QLocale::Monaco") +
    gsi::enum_const ("Mongolia", QLocale::Mongolia, "@brief Enum constant QLocale::Mongolia") +
    gsi::enum_const ("Montserrat", QLocale::Montserrat, "@brief Enum constant QLocale::Montserrat") +
    gsi::enum_const ("Morocco", QLocale::Morocco, "@brief Enum constant QLocale::Morocco") +
    gsi::enum_const ("Mozambique", QLocale::Mozambique, "@brief Enum constant QLocale::Mozambique") +
    gsi::enum_const ("Myanmar", QLocale::Myanmar, "@brief Enum constant QLocale::Myanmar") +
    gsi::enum_const ("Namibia", QLocale::Namibia, "@brief Enum constant QLocale::Namibia") +
    gsi::enum_const ("NauruCountry", QLocale::NauruCountry, "@brief Enum constant QLocale::NauruCountry") +
    gsi::enum_const ("Nepal", QLocale::Nepal, "@brief Enum constant QLocale::Nepal") +
    gsi::enum_const ("Netherlands", QLocale::Netherlands, "@brief Enum constant QLocale::Netherlands") +
    gsi::enum_const ("CuraSao", QLocale::CuraSao, "@brief Enum constant QLocale::CuraSao") +
    gsi::enum_const ("NewCaledonia", QLocale::NewCaledonia, "@brief Enum constant QLocale::NewCaledonia") +
    gsi::enum_const ("NewZealand", QLocale::NewZealand, "@brief Enum constant QLocale::NewZealand") +
    gsi::enum_const ("Nicaragua", QLocale::Nicaragua, "@brief Enum constant QLocale::Nicaragua") +
    gsi::enum_const ("Niger", QLocale::Niger, "@brief Enum constant QLocale::Niger") +
    gsi::enum_const ("Nigeria", QLocale::Nigeria, "@brief Enum constant QLocale::Nigeria") +
    gsi::enum_const ("Niue", QLocale::Niue, "@brief Enum constant QLocale::Niue") +
    gsi::enum_const ("NorfolkIsland", QLocale::NorfolkIsland, "@brief Enum constant QLocale::NorfolkIsland") +
    gsi::enum_const ("NorthernMarianaIslands", QLocale::NorthernMarianaIslands, "@brief Enum constant QLocale::NorthernMarianaIslands") +
    gsi::enum_const ("Norway", QLocale::Norway, "@brief Enum constant QLocale::Norway") +
    gsi::enum_const ("Oman", QLocale::Oman, "@brief Enum constant QLocale::Oman") +
    gsi::enum_const ("Pakistan", QLocale::Pakistan, "@brief Enum constant QLocale::Pakistan") +
    gsi::enum_const ("Palau", QLocale::Palau, "@brief Enum constant QLocale::Palau") +
    gsi::enum_const ("PalestinianTerritories", QLocale::PalestinianTerritories, "@brief Enum constant QLocale::PalestinianTerritories") +
    gsi::enum_const ("Panama", QLocale::Panama, "@brief Enum constant QLocale::Panama") +
    gsi::enum_const ("PapuaNewGuinea", QLocale::PapuaNewGuinea, "@brief Enum constant QLocale::PapuaNewGuinea") +
    gsi::enum_const ("Paraguay", QLocale::Paraguay, "@brief Enum constant QLocale::Paraguay") +
    gsi::enum_const ("Peru", QLocale::Peru, "@brief Enum constant QLocale::Peru") +
    gsi::enum_const ("Philippines", QLocale::Philippines, "@brief Enum constant QLocale::Philippines") +
    gsi::enum_const ("Pitcairn", QLocale::Pitcairn, "@brief Enum constant QLocale::Pitcairn") +
    gsi::enum_const ("Poland", QLocale::Poland, "@brief Enum constant QLocale::Poland") +
    gsi::enum_const ("Portugal", QLocale::Portugal, "@brief Enum constant QLocale::Portugal") +
    gsi::enum_const ("PuertoRico", QLocale::PuertoRico, "@brief Enum constant QLocale::PuertoRico") +
    gsi::enum_const ("Qatar", QLocale::Qatar, "@brief Enum constant QLocale::Qatar") +
    gsi::enum_const ("Reunion", QLocale::Reunion, "@brief Enum constant QLocale::Reunion") +
    gsi::enum_const ("Romania", QLocale::Romania, "@brief Enum constant QLocale::Romania") +
    gsi::enum_const ("Russia", QLocale::Russia, "@brief Enum constant QLocale::Russia") +
    gsi::enum_const ("Rwanda", QLocale::Rwanda, "@brief Enum constant QLocale::Rwanda") +
    gsi::enum_const ("SaintKittsAndNevis", QLocale::SaintKittsAndNevis, "@brief Enum constant QLocale::SaintKittsAndNevis") +
    gsi::enum_const ("SaintLucia", QLocale::SaintLucia, "@brief Enum constant QLocale::SaintLucia") +
    gsi::enum_const ("SaintVincentAndTheGrenadines", QLocale::SaintVincentAndTheGrenadines, "@brief Enum constant QLocale::SaintVincentAndTheGrenadines") +
    gsi::enum_const ("Samoa", QLocale::Samoa, "@brief Enum constant QLocale::Samoa") +
    gsi::enum_const ("SanMarino", QLocale::SanMarino, "@brief Enum constant QLocale::SanMarino") +
    gsi::enum_const ("SaoTomeAndPrincipe", QLocale::SaoTomeAndPrincipe, "@brief Enum constant QLocale::SaoTomeAndPrincipe") +
    gsi::enum_const ("SaudiArabia", QLocale::SaudiArabia, "@brief Enum constant QLocale::SaudiArabia") +
    gsi::enum_const ("Senegal", QLocale::Senegal, "@brief Enum constant QLocale::Senegal") +
    gsi::enum_const ("Seychelles", QLocale::Seychelles, "@brief Enum constant QLocale::Seychelles") +
    gsi::enum_const ("SierraLeone", QLocale::SierraLeone, "@brief Enum constant QLocale::SierraLeone") +
    gsi::enum_const ("Singapore", QLocale::Singapore, "@brief Enum constant QLocale::Singapore") +
    gsi::enum_const ("Slovakia", QLocale::Slovakia, "@brief Enum constant QLocale::Slovakia") +
    gsi::enum_const ("Slovenia", QLocale::Slovenia, "@brief Enum constant QLocale::Slovenia") +
    gsi::enum_const ("SolomonIslands", QLocale::SolomonIslands, "@brief Enum constant QLocale::SolomonIslands") +
    gsi::enum_const ("Somalia", QLocale::Somalia, "@brief Enum constant QLocale::Somalia") +
    gsi::enum_const ("SouthAfrica", QLocale::SouthAfrica, "@brief Enum constant QLocale::SouthAfrica") +
    gsi::enum_const ("SouthGeorgiaAndTheSouthSandwichIslands", QLocale::SouthGeorgiaAndTheSouthSandwichIslands, "@brief Enum constant QLocale::SouthGeorgiaAndTheSouthSandwichIslands") +
    gsi::enum_const ("Spain", QLocale::Spain, "@brief Enum constant QLocale::Spain") +
    gsi::enum_const ("SriLanka", QLocale::SriLanka, "@brief Enum constant QLocale::SriLanka") +
    gsi::enum_const ("SaintHelena", QLocale::SaintHelena, "@brief Enum constant QLocale::SaintHelena") +
    gsi::enum_const ("SaintPierreAndMiquelon", QLocale::SaintPierreAndMiquelon, "@brief Enum constant QLocale::SaintPierreAndMiquelon") +
    gsi::enum_const ("Sudan", QLocale::Sudan, "@brief Enum constant QLocale::Sudan") +
    gsi::enum_const ("Suriname", QLocale::Suriname, "@brief Enum constant QLocale::Suriname") +
    gsi::enum_const ("SvalbardAndJanMayenIslands", QLocale::SvalbardAndJanMayenIslands, "@brief Enum constant QLocale::SvalbardAndJanMayenIslands") +
    gsi::enum_const ("Swaziland", QLocale::Swaziland, "@brief Enum constant QLocale::Swaziland") +
    gsi::enum_const ("Sweden", QLocale::Sweden, "@brief Enum constant QLocale::Sweden") +
    gsi::enum_const ("Switzerland", QLocale::Switzerland, "@brief Enum constant QLocale::Switzerland") +
    gsi::enum_const ("Syria", QLocale::Syria, "@brief Enum constant QLocale::Syria") +
    gsi::enum_const ("Taiwan", QLocale::Taiwan, "@brief Enum constant QLocale::Taiwan") +
    gsi::enum_const ("Tajikistan", QLocale::Tajikistan, "@brief Enum constant QLocale::Tajikistan") +
    gsi::enum_const ("Tanzania", QLocale::Tanzania, "@brief Enum constant QLocale::Tanzania") +
    gsi::enum_const ("Thailand", QLocale::Thailand, "@brief Enum constant QLocale::Thailand") +
    gsi::enum_const ("Togo", QLocale::Togo, "@brief Enum constant QLocale::Togo") +
    gsi::enum_const ("Tokelau", QLocale::Tokelau, "@brief Enum constant QLocale::Tokelau") +
    gsi::enum_const ("Tonga", QLocale::Tonga, "@brief Enum constant QLocale::Tonga") +
    gsi::enum_const ("TrinidadAndTobago", QLocale::TrinidadAndTobago, "@brief Enum constant QLocale::TrinidadAndTobago") +
    gsi::enum_const ("Tunisia", QLocale::Tunisia, "@brief Enum constant QLocale::Tunisia") +
    gsi::enum_const ("Turkey", QLocale::Turkey, "@brief Enum constant QLocale::Turkey") +
    gsi::enum_const ("Turkmenistan", QLocale::Turkmenistan, "@brief Enum constant QLocale::Turkmenistan") +
    gsi::enum_const ("TurksAndCaicosIslands", QLocale::TurksAndCaicosIslands, "@brief Enum constant QLocale::TurksAndCaicosIslands") +
    gsi::enum_const ("Tuvalu", QLocale::Tuvalu, "@brief Enum constant QLocale::Tuvalu") +
    gsi::enum_const ("Uganda", QLocale::Uganda, "@brief Enum constant QLocale::Uganda") +
    gsi::enum_const ("Ukraine", QLocale::Ukraine, "@brief Enum constant QLocale::Ukraine") +
    gsi::enum_const ("UnitedArabEmirates", QLocale::UnitedArabEmirates, "@brief Enum constant QLocale::UnitedArabEmirates") +
    gsi::enum_const ("UnitedKingdom", QLocale::UnitedKingdom, "@brief Enum constant QLocale::UnitedKingdom") +
    gsi::enum_const ("UnitedStates", QLocale::UnitedStates, "@brief Enum constant QLocale::UnitedStates") +
    gsi::enum_const ("UnitedStatesMinorOutlyingIslands", QLocale::UnitedStatesMinorOutlyingIslands, "@brief Enum constant QLocale::UnitedStatesMinorOutlyingIslands") +
    gsi::enum_const ("Uruguay", QLocale::Uruguay, "@brief Enum constant QLocale::Uruguay") +
    gsi::enum_const ("Uzbekistan", QLocale::Uzbekistan, "@brief Enum constant QLocale::Uzbekistan") +
    gsi::enum_const ("Vanuatu", QLocale::Vanuatu, "@brief Enum constant QLocale::Vanuatu") +
    gsi::enum_const ("VaticanCityState", QLocale::VaticanCityState, "@brief Enum constant QLocale::VaticanCityState") +
    gsi::enum_const ("Venezuela", QLocale::Venezuela, "@brief Enum constant QLocale::Venezuela") +
    gsi::enum_const ("Vietnam", QLocale::Vietnam, "@brief Enum constant QLocale::Vietnam") +
    gsi::enum_const ("BritishVirginIslands", QLocale::BritishVirginIslands, "@brief Enum constant QLocale::BritishVirginIslands") +
    gsi::enum_const ("UnitedStatesVirginIslands", QLocale::UnitedStatesVirginIslands, "@brief Enum constant QLocale::UnitedStatesVirginIslands") +
    gsi::enum_const ("WallisAndFutunaIslands", QLocale::WallisAndFutunaIslands, "@brief Enum constant QLocale::WallisAndFutunaIslands") +
    gsi::enum_const ("WesternSahara", QLocale::WesternSahara, "@brief Enum constant QLocale::WesternSahara") +
    gsi::enum_const ("Yemen", QLocale::Yemen, "@brief Enum constant QLocale::Yemen") +
    gsi::enum_const ("CanaryIslands", QLocale::CanaryIslands, "@brief Enum constant QLocale::CanaryIslands") +
    gsi::enum_const ("Zambia", QLocale::Zambia, "@brief Enum constant QLocale::Zambia") +
    gsi::enum_const ("Zimbabwe", QLocale::Zimbabwe, "@brief Enum constant QLocale::Zimbabwe") +
    gsi::enum_const ("ClippertonIsland", QLocale::ClippertonIsland, "@brief Enum constant QLocale::ClippertonIsland") +
    gsi::enum_const ("Montenegro", QLocale::Montenegro, "@brief Enum constant QLocale::Montenegro") +
    gsi::enum_const ("Serbia", QLocale::Serbia, "@brief Enum constant QLocale::Serbia") +
    gsi::enum_const ("SaintBarthelemy", QLocale::SaintBarthelemy, "@brief Enum constant QLocale::SaintBarthelemy") +
    gsi::enum_const ("SaintMartin", QLocale::SaintMartin, "@brief Enum constant QLocale::SaintMartin") +
    gsi::enum_const ("LatinAmericaAndTheCaribbean", QLocale::LatinAmericaAndTheCaribbean, "@brief Enum constant QLocale::LatinAmericaAndTheCaribbean") +
    gsi::enum_const ("AscensionIsland", QLocale::AscensionIsland, "@brief Enum constant QLocale::AscensionIsland") +
    gsi::enum_const ("AlandIslands", QLocale::AlandIslands, "@brief Enum constant QLocale::AlandIslands") +
    gsi::enum_const ("DiegoGarcia", QLocale::DiegoGarcia, "@brief Enum constant QLocale::DiegoGarcia") +
    gsi::enum_const ("CeutaAndMelilla", QLocale::CeutaAndMelilla, "@brief Enum constant QLocale::CeutaAndMelilla") +
    gsi::enum_const ("IsleOfMan", QLocale::IsleOfMan, "@brief Enum constant QLocale::IsleOfMan") +
    gsi::enum_const ("Jersey", QLocale::Jersey, "@brief Enum constant QLocale::Jersey") +
    gsi::enum_const ("TristanDaCunha", QLocale::TristanDaCunha, "@brief Enum constant QLocale::TristanDaCunha") +
    gsi::enum_const ("SouthSudan", QLocale::SouthSudan, "@brief Enum constant QLocale::SouthSudan") +
    gsi::enum_const ("Bonaire", QLocale::Bonaire, "@brief Enum constant QLocale::Bonaire") +
    gsi::enum_const ("SintMaarten", QLocale::SintMaarten, "@brief Enum constant QLocale::SintMaarten") +
    gsi::enum_const ("Kosovo", QLocale::Kosovo, "@brief Enum constant QLocale::Kosovo") +
    gsi::enum_const ("DemocraticRepublicOfCongo", QLocale::DemocraticRepublicOfCongo, "@brief Enum constant QLocale::DemocraticRepublicOfCongo") +
    gsi::enum_const ("PeoplesRepublicOfCongo", QLocale::PeoplesRepublicOfCongo, "@brief Enum constant QLocale::PeoplesRepublicOfCongo") +
    gsi::enum_const ("DemocraticRepublicOfKorea", QLocale::DemocraticRepublicOfKorea, "@brief Enum constant QLocale::DemocraticRepublicOfKorea") +
    gsi::enum_const ("RepublicOfKorea", QLocale::RepublicOfKorea, "@brief Enum constant QLocale::RepublicOfKorea") +
    gsi::enum_const ("RussianFederation", QLocale::RussianFederation, "@brief Enum constant QLocale::RussianFederation") +
    gsi::enum_const ("SyrianArabRepublic", QLocale::SyrianArabRepublic, "@brief Enum constant QLocale::SyrianArabRepublic") +
    gsi::enum_const ("LastCountry", QLocale::LastCountry, "@brief Enum constant QLocale::LastCountry"),
  "@qt\n@brief This class represents the QLocale::Country enum");

static gsi::QFlagsClass<QLocale::Country > decl_QLocale_Country_Enums ("QtCore", "QLocale_QFlags_Country",
  "@qt\n@brief This class represents the QFlags<QLocale::Country> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocale> inject_QLocale_Country_Enum_in_parent (decl_QLocale_Country_Enum.defs ());
static gsi::ClassExt<QLocale> decl_QLocale_Country_Enum_as_child (decl_QLocale_Country_Enum, "Country");
static gsi::ClassExt<QLocale> decl_QLocale_Country_Enums_as_child (decl_QLocale_Country_Enums, "QFlags_Country");

}


//  Implementation of the enum wrapper class for QLocale::CurrencySymbolFormat
namespace qt_gsi
{

static gsi::Enum<QLocale::CurrencySymbolFormat> decl_QLocale_CurrencySymbolFormat_Enum ("QtCore", "QLocale_CurrencySymbolFormat",
    gsi::enum_const ("CurrencyIsoCode", QLocale::CurrencyIsoCode, "@brief Enum constant QLocale::CurrencyIsoCode") +
    gsi::enum_const ("CurrencySymbol", QLocale::CurrencySymbol, "@brief Enum constant QLocale::CurrencySymbol") +
    gsi::enum_const ("CurrencyDisplayName", QLocale::CurrencyDisplayName, "@brief Enum constant QLocale::CurrencyDisplayName"),
  "@qt\n@brief This class represents the QLocale::CurrencySymbolFormat enum");

static gsi::QFlagsClass<QLocale::CurrencySymbolFormat > decl_QLocale_CurrencySymbolFormat_Enums ("QtCore", "QLocale_QFlags_CurrencySymbolFormat",
  "@qt\n@brief This class represents the QFlags<QLocale::CurrencySymbolFormat> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocale> inject_QLocale_CurrencySymbolFormat_Enum_in_parent (decl_QLocale_CurrencySymbolFormat_Enum.defs ());
static gsi::ClassExt<QLocale> decl_QLocale_CurrencySymbolFormat_Enum_as_child (decl_QLocale_CurrencySymbolFormat_Enum, "CurrencySymbolFormat");
static gsi::ClassExt<QLocale> decl_QLocale_CurrencySymbolFormat_Enums_as_child (decl_QLocale_CurrencySymbolFormat_Enums, "QFlags_CurrencySymbolFormat");

}


//  Implementation of the enum wrapper class for QLocale::FormatType
namespace qt_gsi
{

static gsi::Enum<QLocale::FormatType> decl_QLocale_FormatType_Enum ("QtCore", "QLocale_FormatType",
    gsi::enum_const ("LongFormat", QLocale::LongFormat, "@brief Enum constant QLocale::LongFormat") +
    gsi::enum_const ("ShortFormat", QLocale::ShortFormat, "@brief Enum constant QLocale::ShortFormat") +
    gsi::enum_const ("NarrowFormat", QLocale::NarrowFormat, "@brief Enum constant QLocale::NarrowFormat"),
  "@qt\n@brief This class represents the QLocale::FormatType enum");

static gsi::QFlagsClass<QLocale::FormatType > decl_QLocale_FormatType_Enums ("QtCore", "QLocale_QFlags_FormatType",
  "@qt\n@brief This class represents the QFlags<QLocale::FormatType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocale> inject_QLocale_FormatType_Enum_in_parent (decl_QLocale_FormatType_Enum.defs ());
static gsi::ClassExt<QLocale> decl_QLocale_FormatType_Enum_as_child (decl_QLocale_FormatType_Enum, "FormatType");
static gsi::ClassExt<QLocale> decl_QLocale_FormatType_Enums_as_child (decl_QLocale_FormatType_Enums, "QFlags_FormatType");

}


//  Implementation of the enum wrapper class for QLocale::Language
namespace qt_gsi
{

static gsi::Enum<QLocale::Language> decl_QLocale_Language_Enum ("QtCore", "QLocale_Language",
    gsi::enum_const ("AnyLanguage", QLocale::AnyLanguage, "@brief Enum constant QLocale::AnyLanguage") +
    gsi::enum_const ("C", QLocale::C, "@brief Enum constant QLocale::C") +
    gsi::enum_const ("Abkhazian", QLocale::Abkhazian, "@brief Enum constant QLocale::Abkhazian") +
    gsi::enum_const ("Oromo", QLocale::Oromo, "@brief Enum constant QLocale::Oromo") +
    gsi::enum_const ("Afar", QLocale::Afar, "@brief Enum constant QLocale::Afar") +
    gsi::enum_const ("Afrikaans", QLocale::Afrikaans, "@brief Enum constant QLocale::Afrikaans") +
    gsi::enum_const ("Albanian", QLocale::Albanian, "@brief Enum constant QLocale::Albanian") +
    gsi::enum_const ("Amharic", QLocale::Amharic, "@brief Enum constant QLocale::Amharic") +
    gsi::enum_const ("Arabic", QLocale::Arabic, "@brief Enum constant QLocale::Arabic") +
    gsi::enum_const ("Armenian", QLocale::Armenian, "@brief Enum constant QLocale::Armenian") +
    gsi::enum_const ("Assamese", QLocale::Assamese, "@brief Enum constant QLocale::Assamese") +
    gsi::enum_const ("Aymara", QLocale::Aymara, "@brief Enum constant QLocale::Aymara") +
    gsi::enum_const ("Azerbaijani", QLocale::Azerbaijani, "@brief Enum constant QLocale::Azerbaijani") +
    gsi::enum_const ("Bashkir", QLocale::Bashkir, "@brief Enum constant QLocale::Bashkir") +
    gsi::enum_const ("Basque", QLocale::Basque, "@brief Enum constant QLocale::Basque") +
    gsi::enum_const ("Bengali", QLocale::Bengali, "@brief Enum constant QLocale::Bengali") +
    gsi::enum_const ("Dzongkha", QLocale::Dzongkha, "@brief Enum constant QLocale::Dzongkha") +
    gsi::enum_const ("Bihari", QLocale::Bihari, "@brief Enum constant QLocale::Bihari") +
    gsi::enum_const ("Bislama", QLocale::Bislama, "@brief Enum constant QLocale::Bislama") +
    gsi::enum_const ("Breton", QLocale::Breton, "@brief Enum constant QLocale::Breton") +
    gsi::enum_const ("Bulgarian", QLocale::Bulgarian, "@brief Enum constant QLocale::Bulgarian") +
    gsi::enum_const ("Burmese", QLocale::Burmese, "@brief Enum constant QLocale::Burmese") +
    gsi::enum_const ("Belarusian", QLocale::Belarusian, "@brief Enum constant QLocale::Belarusian") +
    gsi::enum_const ("Khmer", QLocale::Khmer, "@brief Enum constant QLocale::Khmer") +
    gsi::enum_const ("Catalan", QLocale::Catalan, "@brief Enum constant QLocale::Catalan") +
    gsi::enum_const ("Chinese", QLocale::Chinese, "@brief Enum constant QLocale::Chinese") +
    gsi::enum_const ("Corsican", QLocale::Corsican, "@brief Enum constant QLocale::Corsican") +
    gsi::enum_const ("Croatian", QLocale::Croatian, "@brief Enum constant QLocale::Croatian") +
    gsi::enum_const ("Czech", QLocale::Czech, "@brief Enum constant QLocale::Czech") +
    gsi::enum_const ("Danish", QLocale::Danish, "@brief Enum constant QLocale::Danish") +
    gsi::enum_const ("Dutch", QLocale::Dutch, "@brief Enum constant QLocale::Dutch") +
    gsi::enum_const ("English", QLocale::English, "@brief Enum constant QLocale::English") +
    gsi::enum_const ("Esperanto", QLocale::Esperanto, "@brief Enum constant QLocale::Esperanto") +
    gsi::enum_const ("Estonian", QLocale::Estonian, "@brief Enum constant QLocale::Estonian") +
    gsi::enum_const ("Faroese", QLocale::Faroese, "@brief Enum constant QLocale::Faroese") +
    gsi::enum_const ("Fijian", QLocale::Fijian, "@brief Enum constant QLocale::Fijian") +
    gsi::enum_const ("Finnish", QLocale::Finnish, "@brief Enum constant QLocale::Finnish") +
    gsi::enum_const ("French", QLocale::French, "@brief Enum constant QLocale::French") +
    gsi::enum_const ("WesternFrisian", QLocale::WesternFrisian, "@brief Enum constant QLocale::WesternFrisian") +
    gsi::enum_const ("Gaelic", QLocale::Gaelic, "@brief Enum constant QLocale::Gaelic") +
    gsi::enum_const ("Galician", QLocale::Galician, "@brief Enum constant QLocale::Galician") +
    gsi::enum_const ("Georgian", QLocale::Georgian, "@brief Enum constant QLocale::Georgian") +
    gsi::enum_const ("German", QLocale::German, "@brief Enum constant QLocale::German") +
    gsi::enum_const ("Greek", QLocale::Greek, "@brief Enum constant QLocale::Greek") +
    gsi::enum_const ("Greenlandic", QLocale::Greenlandic, "@brief Enum constant QLocale::Greenlandic") +
    gsi::enum_const ("Guarani", QLocale::Guarani, "@brief Enum constant QLocale::Guarani") +
    gsi::enum_const ("Gujarati", QLocale::Gujarati, "@brief Enum constant QLocale::Gujarati") +
    gsi::enum_const ("Hausa", QLocale::Hausa, "@brief Enum constant QLocale::Hausa") +
    gsi::enum_const ("Hebrew", QLocale::Hebrew, "@brief Enum constant QLocale::Hebrew") +
    gsi::enum_const ("Hindi", QLocale::Hindi, "@brief Enum constant QLocale::Hindi") +
    gsi::enum_const ("Hungarian", QLocale::Hungarian, "@brief Enum constant QLocale::Hungarian") +
    gsi::enum_const ("Icelandic", QLocale::Icelandic, "@brief Enum constant QLocale::Icelandic") +
    gsi::enum_const ("Indonesian", QLocale::Indonesian, "@brief Enum constant QLocale::Indonesian") +
    gsi::enum_const ("Interlingua", QLocale::Interlingua, "@brief Enum constant QLocale::Interlingua") +
    gsi::enum_const ("Interlingue", QLocale::Interlingue, "@brief Enum constant QLocale::Interlingue") +
    gsi::enum_const ("Inuktitut", QLocale::Inuktitut, "@brief Enum constant QLocale::Inuktitut") +
    gsi::enum_const ("Inupiak", QLocale::Inupiak, "@brief Enum constant QLocale::Inupiak") +
    gsi::enum_const ("Irish", QLocale::Irish, "@brief Enum constant QLocale::Irish") +
    gsi::enum_const ("Italian", QLocale::Italian, "@brief Enum constant QLocale::Italian") +
    gsi::enum_const ("Japanese", QLocale::Japanese, "@brief Enum constant QLocale::Japanese") +
    gsi::enum_const ("Javanese", QLocale::Javanese, "@brief Enum constant QLocale::Javanese") +
    gsi::enum_const ("Kannada", QLocale::Kannada, "@brief Enum constant QLocale::Kannada") +
    gsi::enum_const ("Kashmiri", QLocale::Kashmiri, "@brief Enum constant QLocale::Kashmiri") +
    gsi::enum_const ("Kazakh", QLocale::Kazakh, "@brief Enum constant QLocale::Kazakh") +
    gsi::enum_const ("Kinyarwanda", QLocale::Kinyarwanda, "@brief Enum constant QLocale::Kinyarwanda") +
    gsi::enum_const ("Kirghiz", QLocale::Kirghiz, "@brief Enum constant QLocale::Kirghiz") +
    gsi::enum_const ("Korean", QLocale::Korean, "@brief Enum constant QLocale::Korean") +
    gsi::enum_const ("Kurdish", QLocale::Kurdish, "@brief Enum constant QLocale::Kurdish") +
    gsi::enum_const ("Rundi", QLocale::Rundi, "@brief Enum constant QLocale::Rundi") +
    gsi::enum_const ("Lao", QLocale::Lao, "@brief Enum constant QLocale::Lao") +
    gsi::enum_const ("Latin", QLocale::Latin, "@brief Enum constant QLocale::Latin") +
    gsi::enum_const ("Latvian", QLocale::Latvian, "@brief Enum constant QLocale::Latvian") +
    gsi::enum_const ("Lingala", QLocale::Lingala, "@brief Enum constant QLocale::Lingala") +
    gsi::enum_const ("Lithuanian", QLocale::Lithuanian, "@brief Enum constant QLocale::Lithuanian") +
    gsi::enum_const ("Macedonian", QLocale::Macedonian, "@brief Enum constant QLocale::Macedonian") +
    gsi::enum_const ("Malagasy", QLocale::Malagasy, "@brief Enum constant QLocale::Malagasy") +
    gsi::enum_const ("Malay", QLocale::Malay, "@brief Enum constant QLocale::Malay") +
    gsi::enum_const ("Malayalam", QLocale::Malayalam, "@brief Enum constant QLocale::Malayalam") +
    gsi::enum_const ("Maltese", QLocale::Maltese, "@brief Enum constant QLocale::Maltese") +
    gsi::enum_const ("Maori", QLocale::Maori, "@brief Enum constant QLocale::Maori") +
    gsi::enum_const ("Marathi", QLocale::Marathi, "@brief Enum constant QLocale::Marathi") +
    gsi::enum_const ("Marshallese", QLocale::Marshallese, "@brief Enum constant QLocale::Marshallese") +
    gsi::enum_const ("Mongolian", QLocale::Mongolian, "@brief Enum constant QLocale::Mongolian") +
    gsi::enum_const ("NauruLanguage", QLocale::NauruLanguage, "@brief Enum constant QLocale::NauruLanguage") +
    gsi::enum_const ("Nepali", QLocale::Nepali, "@brief Enum constant QLocale::Nepali") +
    gsi::enum_const ("NorwegianBokmal", QLocale::NorwegianBokmal, "@brief Enum constant QLocale::NorwegianBokmal") +
    gsi::enum_const ("Occitan", QLocale::Occitan, "@brief Enum constant QLocale::Occitan") +
    gsi::enum_const ("Oriya", QLocale::Oriya, "@brief Enum constant QLocale::Oriya") +
    gsi::enum_const ("Pashto", QLocale::Pashto, "@brief Enum constant QLocale::Pashto") +
    gsi::enum_const ("Persian", QLocale::Persian, "@brief Enum constant QLocale::Persian") +
    gsi::enum_const ("Polish", QLocale::Polish, "@brief Enum constant QLocale::Polish") +
    gsi::enum_const ("Portuguese", QLocale::Portuguese, "@brief Enum constant QLocale::Portuguese") +
    gsi::enum_const ("Punjabi", QLocale::Punjabi, "@brief Enum constant QLocale::Punjabi") +
    gsi::enum_const ("Quechua", QLocale::Quechua, "@brief Enum constant QLocale::Quechua") +
    gsi::enum_const ("Romansh", QLocale::Romansh, "@brief Enum constant QLocale::Romansh") +
    gsi::enum_const ("Romanian", QLocale::Romanian, "@brief Enum constant QLocale::Romanian") +
    gsi::enum_const ("Russian", QLocale::Russian, "@brief Enum constant QLocale::Russian") +
    gsi::enum_const ("Samoan", QLocale::Samoan, "@brief Enum constant QLocale::Samoan") +
    gsi::enum_const ("Sango", QLocale::Sango, "@brief Enum constant QLocale::Sango") +
    gsi::enum_const ("Sanskrit", QLocale::Sanskrit, "@brief Enum constant QLocale::Sanskrit") +
    gsi::enum_const ("Serbian", QLocale::Serbian, "@brief Enum constant QLocale::Serbian") +
    gsi::enum_const ("Ossetic", QLocale::Ossetic, "@brief Enum constant QLocale::Ossetic") +
    gsi::enum_const ("SouthernSotho", QLocale::SouthernSotho, "@brief Enum constant QLocale::SouthernSotho") +
    gsi::enum_const ("Tswana", QLocale::Tswana, "@brief Enum constant QLocale::Tswana") +
    gsi::enum_const ("Shona", QLocale::Shona, "@brief Enum constant QLocale::Shona") +
    gsi::enum_const ("Sindhi", QLocale::Sindhi, "@brief Enum constant QLocale::Sindhi") +
    gsi::enum_const ("Sinhala", QLocale::Sinhala, "@brief Enum constant QLocale::Sinhala") +
    gsi::enum_const ("Swati", QLocale::Swati, "@brief Enum constant QLocale::Swati") +
    gsi::enum_const ("Slovak", QLocale::Slovak, "@brief Enum constant QLocale::Slovak") +
    gsi::enum_const ("Slovenian", QLocale::Slovenian, "@brief Enum constant QLocale::Slovenian") +
    gsi::enum_const ("Somali", QLocale::Somali, "@brief Enum constant QLocale::Somali") +
    gsi::enum_const ("Spanish", QLocale::Spanish, "@brief Enum constant QLocale::Spanish") +
    gsi::enum_const ("Sundanese", QLocale::Sundanese, "@brief Enum constant QLocale::Sundanese") +
    gsi::enum_const ("Swahili", QLocale::Swahili, "@brief Enum constant QLocale::Swahili") +
    gsi::enum_const ("Swedish", QLocale::Swedish, "@brief Enum constant QLocale::Swedish") +
    gsi::enum_const ("Sardinian", QLocale::Sardinian, "@brief Enum constant QLocale::Sardinian") +
    gsi::enum_const ("Tajik", QLocale::Tajik, "@brief Enum constant QLocale::Tajik") +
    gsi::enum_const ("Tamil", QLocale::Tamil, "@brief Enum constant QLocale::Tamil") +
    gsi::enum_const ("Tatar", QLocale::Tatar, "@brief Enum constant QLocale::Tatar") +
    gsi::enum_const ("Telugu", QLocale::Telugu, "@brief Enum constant QLocale::Telugu") +
    gsi::enum_const ("Thai", QLocale::Thai, "@brief Enum constant QLocale::Thai") +
    gsi::enum_const ("Tibetan", QLocale::Tibetan, "@brief Enum constant QLocale::Tibetan") +
    gsi::enum_const ("Tigrinya", QLocale::Tigrinya, "@brief Enum constant QLocale::Tigrinya") +
    gsi::enum_const ("Tongan", QLocale::Tongan, "@brief Enum constant QLocale::Tongan") +
    gsi::enum_const ("Tsonga", QLocale::Tsonga, "@brief Enum constant QLocale::Tsonga") +
    gsi::enum_const ("Turkish", QLocale::Turkish, "@brief Enum constant QLocale::Turkish") +
    gsi::enum_const ("Turkmen", QLocale::Turkmen, "@brief Enum constant QLocale::Turkmen") +
    gsi::enum_const ("Tahitian", QLocale::Tahitian, "@brief Enum constant QLocale::Tahitian") +
    gsi::enum_const ("Uighur", QLocale::Uighur, "@brief Enum constant QLocale::Uighur") +
    gsi::enum_const ("Ukrainian", QLocale::Ukrainian, "@brief Enum constant QLocale::Ukrainian") +
    gsi::enum_const ("Urdu", QLocale::Urdu, "@brief Enum constant QLocale::Urdu") +
    gsi::enum_const ("Uzbek", QLocale::Uzbek, "@brief Enum constant QLocale::Uzbek") +
    gsi::enum_const ("Vietnamese", QLocale::Vietnamese, "@brief Enum constant QLocale::Vietnamese") +
    gsi::enum_const ("Volapuk", QLocale::Volapuk, "@brief Enum constant QLocale::Volapuk") +
    gsi::enum_const ("Welsh", QLocale::Welsh, "@brief Enum constant QLocale::Welsh") +
    gsi::enum_const ("Wolof", QLocale::Wolof, "@brief Enum constant QLocale::Wolof") +
    gsi::enum_const ("Xhosa", QLocale::Xhosa, "@brief Enum constant QLocale::Xhosa") +
    gsi::enum_const ("Yiddish", QLocale::Yiddish, "@brief Enum constant QLocale::Yiddish") +
    gsi::enum_const ("Yoruba", QLocale::Yoruba, "@brief Enum constant QLocale::Yoruba") +
    gsi::enum_const ("Zhuang", QLocale::Zhuang, "@brief Enum constant QLocale::Zhuang") +
    gsi::enum_const ("Zulu", QLocale::Zulu, "@brief Enum constant QLocale::Zulu") +
    gsi::enum_const ("NorwegianNynorsk", QLocale::NorwegianNynorsk, "@brief Enum constant QLocale::NorwegianNynorsk") +
    gsi::enum_const ("Bosnian", QLocale::Bosnian, "@brief Enum constant QLocale::Bosnian") +
    gsi::enum_const ("Divehi", QLocale::Divehi, "@brief Enum constant QLocale::Divehi") +
    gsi::enum_const ("Manx", QLocale::Manx, "@brief Enum constant QLocale::Manx") +
    gsi::enum_const ("Cornish", QLocale::Cornish, "@brief Enum constant QLocale::Cornish") +
    gsi::enum_const ("Akan", QLocale::Akan, "@brief Enum constant QLocale::Akan") +
    gsi::enum_const ("Konkani", QLocale::Konkani, "@brief Enum constant QLocale::Konkani") +
    gsi::enum_const ("Ga", QLocale::Ga, "@brief Enum constant QLocale::Ga") +
    gsi::enum_const ("Igbo", QLocale::Igbo, "@brief Enum constant QLocale::Igbo") +
    gsi::enum_const ("Kamba", QLocale::Kamba, "@brief Enum constant QLocale::Kamba") +
    gsi::enum_const ("Syriac", QLocale::Syriac, "@brief Enum constant QLocale::Syriac") +
    gsi::enum_const ("Blin", QLocale::Blin, "@brief Enum constant QLocale::Blin") +
    gsi::enum_const ("Geez", QLocale::Geez, "@brief Enum constant QLocale::Geez") +
    gsi::enum_const ("Koro", QLocale::Koro, "@brief Enum constant QLocale::Koro") +
    gsi::enum_const ("Sidamo", QLocale::Sidamo, "@brief Enum constant QLocale::Sidamo") +
    gsi::enum_const ("Atsam", QLocale::Atsam, "@brief Enum constant QLocale::Atsam") +
    gsi::enum_const ("Tigre", QLocale::Tigre, "@brief Enum constant QLocale::Tigre") +
    gsi::enum_const ("Jju", QLocale::Jju, "@brief Enum constant QLocale::Jju") +
    gsi::enum_const ("Friulian", QLocale::Friulian, "@brief Enum constant QLocale::Friulian") +
    gsi::enum_const ("Venda", QLocale::Venda, "@brief Enum constant QLocale::Venda") +
    gsi::enum_const ("Ewe", QLocale::Ewe, "@brief Enum constant QLocale::Ewe") +
    gsi::enum_const ("Walamo", QLocale::Walamo, "@brief Enum constant QLocale::Walamo") +
    gsi::enum_const ("Hawaiian", QLocale::Hawaiian, "@brief Enum constant QLocale::Hawaiian") +
    gsi::enum_const ("Tyap", QLocale::Tyap, "@brief Enum constant QLocale::Tyap") +
    gsi::enum_const ("Nyanja", QLocale::Nyanja, "@brief Enum constant QLocale::Nyanja") +
    gsi::enum_const ("Filipino", QLocale::Filipino, "@brief Enum constant QLocale::Filipino") +
    gsi::enum_const ("SwissGerman", QLocale::SwissGerman, "@brief Enum constant QLocale::SwissGerman") +
    gsi::enum_const ("SichuanYi", QLocale::SichuanYi, "@brief Enum constant QLocale::SichuanYi") +
    gsi::enum_const ("Kpelle", QLocale::Kpelle, "@brief Enum constant QLocale::Kpelle") +
    gsi::enum_const ("LowGerman", QLocale::LowGerman, "@brief Enum constant QLocale::LowGerman") +
    gsi::enum_const ("SouthNdebele", QLocale::SouthNdebele, "@brief Enum constant QLocale::SouthNdebele") +
    gsi::enum_const ("NorthernSotho", QLocale::NorthernSotho, "@brief Enum constant QLocale::NorthernSotho") +
    gsi::enum_const ("NorthernSami", QLocale::NorthernSami, "@brief Enum constant QLocale::NorthernSami") +
    gsi::enum_const ("Taroko", QLocale::Taroko, "@brief Enum constant QLocale::Taroko") +
    gsi::enum_const ("Gusii", QLocale::Gusii, "@brief Enum constant QLocale::Gusii") +
    gsi::enum_const ("Taita", QLocale::Taita, "@brief Enum constant QLocale::Taita") +
    gsi::enum_const ("Fulah", QLocale::Fulah, "@brief Enum constant QLocale::Fulah") +
    gsi::enum_const ("Kikuyu", QLocale::Kikuyu, "@brief Enum constant QLocale::Kikuyu") +
    gsi::enum_const ("Samburu", QLocale::Samburu, "@brief Enum constant QLocale::Samburu") +
    gsi::enum_const ("Sena", QLocale::Sena, "@brief Enum constant QLocale::Sena") +
    gsi::enum_const ("NorthNdebele", QLocale::NorthNdebele, "@brief Enum constant QLocale::NorthNdebele") +
    gsi::enum_const ("Rombo", QLocale::Rombo, "@brief Enum constant QLocale::Rombo") +
    gsi::enum_const ("Tachelhit", QLocale::Tachelhit, "@brief Enum constant QLocale::Tachelhit") +
    gsi::enum_const ("Kabyle", QLocale::Kabyle, "@brief Enum constant QLocale::Kabyle") +
    gsi::enum_const ("Nyankole", QLocale::Nyankole, "@brief Enum constant QLocale::Nyankole") +
    gsi::enum_const ("Bena", QLocale::Bena, "@brief Enum constant QLocale::Bena") +
    gsi::enum_const ("Vunjo", QLocale::Vunjo, "@brief Enum constant QLocale::Vunjo") +
    gsi::enum_const ("Bambara", QLocale::Bambara, "@brief Enum constant QLocale::Bambara") +
    gsi::enum_const ("Embu", QLocale::Embu, "@brief Enum constant QLocale::Embu") +
    gsi::enum_const ("Cherokee", QLocale::Cherokee, "@brief Enum constant QLocale::Cherokee") +
    gsi::enum_const ("Morisyen", QLocale::Morisyen, "@brief Enum constant QLocale::Morisyen") +
    gsi::enum_const ("Makonde", QLocale::Makonde, "@brief Enum constant QLocale::Makonde") +
    gsi::enum_const ("Langi", QLocale::Langi, "@brief Enum constant QLocale::Langi") +
    gsi::enum_const ("Ganda", QLocale::Ganda, "@brief Enum constant QLocale::Ganda") +
    gsi::enum_const ("Bemba", QLocale::Bemba, "@brief Enum constant QLocale::Bemba") +
    gsi::enum_const ("Kabuverdianu", QLocale::Kabuverdianu, "@brief Enum constant QLocale::Kabuverdianu") +
    gsi::enum_const ("Meru", QLocale::Meru, "@brief Enum constant QLocale::Meru") +
    gsi::enum_const ("Kalenjin", QLocale::Kalenjin, "@brief Enum constant QLocale::Kalenjin") +
    gsi::enum_const ("Nama", QLocale::Nama, "@brief Enum constant QLocale::Nama") +
    gsi::enum_const ("Machame", QLocale::Machame, "@brief Enum constant QLocale::Machame") +
    gsi::enum_const ("Colognian", QLocale::Colognian, "@brief Enum constant QLocale::Colognian") +
    gsi::enum_const ("Masai", QLocale::Masai, "@brief Enum constant QLocale::Masai") +
    gsi::enum_const ("Soga", QLocale::Soga, "@brief Enum constant QLocale::Soga") +
    gsi::enum_const ("Luyia", QLocale::Luyia, "@brief Enum constant QLocale::Luyia") +
    gsi::enum_const ("Asu", QLocale::Asu, "@brief Enum constant QLocale::Asu") +
    gsi::enum_const ("Teso", QLocale::Teso, "@brief Enum constant QLocale::Teso") +
    gsi::enum_const ("Saho", QLocale::Saho, "@brief Enum constant QLocale::Saho") +
    gsi::enum_const ("KoyraChiini", QLocale::KoyraChiini, "@brief Enum constant QLocale::KoyraChiini") +
    gsi::enum_const ("Rwa", QLocale::Rwa, "@brief Enum constant QLocale::Rwa") +
    gsi::enum_const ("Luo", QLocale::Luo, "@brief Enum constant QLocale::Luo") +
    gsi::enum_const ("Chiga", QLocale::Chiga, "@brief Enum constant QLocale::Chiga") +
    gsi::enum_const ("CentralMoroccoTamazight", QLocale::CentralMoroccoTamazight, "@brief Enum constant QLocale::CentralMoroccoTamazight") +
    gsi::enum_const ("KoyraboroSenni", QLocale::KoyraboroSenni, "@brief Enum constant QLocale::KoyraboroSenni") +
    gsi::enum_const ("Shambala", QLocale::Shambala, "@brief Enum constant QLocale::Shambala") +
    gsi::enum_const ("Bodo", QLocale::Bodo, "@brief Enum constant QLocale::Bodo") +
    gsi::enum_const ("Avaric", QLocale::Avaric, "@brief Enum constant QLocale::Avaric") +
    gsi::enum_const ("Chamorro", QLocale::Chamorro, "@brief Enum constant QLocale::Chamorro") +
    gsi::enum_const ("Chechen", QLocale::Chechen, "@brief Enum constant QLocale::Chechen") +
    gsi::enum_const ("Church", QLocale::Church, "@brief Enum constant QLocale::Church") +
    gsi::enum_const ("Chuvash", QLocale::Chuvash, "@brief Enum constant QLocale::Chuvash") +
    gsi::enum_const ("Cree", QLocale::Cree, "@brief Enum constant QLocale::Cree") +
    gsi::enum_const ("Haitian", QLocale::Haitian, "@brief Enum constant QLocale::Haitian") +
    gsi::enum_const ("Herero", QLocale::Herero, "@brief Enum constant QLocale::Herero") +
    gsi::enum_const ("HiriMotu", QLocale::HiriMotu, "@brief Enum constant QLocale::HiriMotu") +
    gsi::enum_const ("Kanuri", QLocale::Kanuri, "@brief Enum constant QLocale::Kanuri") +
    gsi::enum_const ("Komi", QLocale::Komi, "@brief Enum constant QLocale::Komi") +
    gsi::enum_const ("Kongo", QLocale::Kongo, "@brief Enum constant QLocale::Kongo") +
    gsi::enum_const ("Kwanyama", QLocale::Kwanyama, "@brief Enum constant QLocale::Kwanyama") +
    gsi::enum_const ("Limburgish", QLocale::Limburgish, "@brief Enum constant QLocale::Limburgish") +
    gsi::enum_const ("LubaKatanga", QLocale::LubaKatanga, "@brief Enum constant QLocale::LubaKatanga") +
    gsi::enum_const ("Luxembourgish", QLocale::Luxembourgish, "@brief Enum constant QLocale::Luxembourgish") +
    gsi::enum_const ("Navaho", QLocale::Navaho, "@brief Enum constant QLocale::Navaho") +
    gsi::enum_const ("Ndonga", QLocale::Ndonga, "@brief Enum constant QLocale::Ndonga") +
    gsi::enum_const ("Ojibwa", QLocale::Ojibwa, "@brief Enum constant QLocale::Ojibwa") +
    gsi::enum_const ("Pali", QLocale::Pali, "@brief Enum constant QLocale::Pali") +
    gsi::enum_const ("Walloon", QLocale::Walloon, "@brief Enum constant QLocale::Walloon") +
    gsi::enum_const ("Aghem", QLocale::Aghem, "@brief Enum constant QLocale::Aghem") +
    gsi::enum_const ("Basaa", QLocale::Basaa, "@brief Enum constant QLocale::Basaa") +
    gsi::enum_const ("Zarma", QLocale::Zarma, "@brief Enum constant QLocale::Zarma") +
    gsi::enum_const ("Duala", QLocale::Duala, "@brief Enum constant QLocale::Duala") +
    gsi::enum_const ("JolaFonyi", QLocale::JolaFonyi, "@brief Enum constant QLocale::JolaFonyi") +
    gsi::enum_const ("Ewondo", QLocale::Ewondo, "@brief Enum constant QLocale::Ewondo") +
    gsi::enum_const ("Bafia", QLocale::Bafia, "@brief Enum constant QLocale::Bafia") +
    gsi::enum_const ("MakhuwaMeetto", QLocale::MakhuwaMeetto, "@brief Enum constant QLocale::MakhuwaMeetto") +
    gsi::enum_const ("Mundang", QLocale::Mundang, "@brief Enum constant QLocale::Mundang") +
    gsi::enum_const ("Kwasio", QLocale::Kwasio, "@brief Enum constant QLocale::Kwasio") +
    gsi::enum_const ("Nuer", QLocale::Nuer, "@brief Enum constant QLocale::Nuer") +
    gsi::enum_const ("Sakha", QLocale::Sakha, "@brief Enum constant QLocale::Sakha") +
    gsi::enum_const ("Sangu", QLocale::Sangu, "@brief Enum constant QLocale::Sangu") +
    gsi::enum_const ("CongoSwahili", QLocale::CongoSwahili, "@brief Enum constant QLocale::CongoSwahili") +
    gsi::enum_const ("Tasawaq", QLocale::Tasawaq, "@brief Enum constant QLocale::Tasawaq") +
    gsi::enum_const ("Vai", QLocale::Vai, "@brief Enum constant QLocale::Vai") +
    gsi::enum_const ("Walser", QLocale::Walser, "@brief Enum constant QLocale::Walser") +
    gsi::enum_const ("Yangben", QLocale::Yangben, "@brief Enum constant QLocale::Yangben") +
    gsi::enum_const ("Avestan", QLocale::Avestan, "@brief Enum constant QLocale::Avestan") +
    gsi::enum_const ("Asturian", QLocale::Asturian, "@brief Enum constant QLocale::Asturian") +
    gsi::enum_const ("Ngomba", QLocale::Ngomba, "@brief Enum constant QLocale::Ngomba") +
    gsi::enum_const ("Kako", QLocale::Kako, "@brief Enum constant QLocale::Kako") +
    gsi::enum_const ("Meta", QLocale::Meta, "@brief Enum constant QLocale::Meta") +
    gsi::enum_const ("Ngiemboon", QLocale::Ngiemboon, "@brief Enum constant QLocale::Ngiemboon") +
    gsi::enum_const ("Aragonese", QLocale::Aragonese, "@brief Enum constant QLocale::Aragonese") +
    gsi::enum_const ("Akkadian", QLocale::Akkadian, "@brief Enum constant QLocale::Akkadian") +
    gsi::enum_const ("AncientEgyptian", QLocale::AncientEgyptian, "@brief Enum constant QLocale::AncientEgyptian") +
    gsi::enum_const ("AncientGreek", QLocale::AncientGreek, "@brief Enum constant QLocale::AncientGreek") +
    gsi::enum_const ("Aramaic", QLocale::Aramaic, "@brief Enum constant QLocale::Aramaic") +
    gsi::enum_const ("Balinese", QLocale::Balinese, "@brief Enum constant QLocale::Balinese") +
    gsi::enum_const ("Bamun", QLocale::Bamun, "@brief Enum constant QLocale::Bamun") +
    gsi::enum_const ("BatakToba", QLocale::BatakToba, "@brief Enum constant QLocale::BatakToba") +
    gsi::enum_const ("Buginese", QLocale::Buginese, "@brief Enum constant QLocale::Buginese") +
    gsi::enum_const ("Buhid", QLocale::Buhid, "@brief Enum constant QLocale::Buhid") +
    gsi::enum_const ("Carian", QLocale::Carian, "@brief Enum constant QLocale::Carian") +
    gsi::enum_const ("Chakma", QLocale::Chakma, "@brief Enum constant QLocale::Chakma") +
    gsi::enum_const ("ClassicalMandaic", QLocale::ClassicalMandaic, "@brief Enum constant QLocale::ClassicalMandaic") +
    gsi::enum_const ("Coptic", QLocale::Coptic, "@brief Enum constant QLocale::Coptic") +
    gsi::enum_const ("Dogri", QLocale::Dogri, "@brief Enum constant QLocale::Dogri") +
    gsi::enum_const ("EasternCham", QLocale::EasternCham, "@brief Enum constant QLocale::EasternCham") +
    gsi::enum_const ("EasternKayah", QLocale::EasternKayah, "@brief Enum constant QLocale::EasternKayah") +
    gsi::enum_const ("Etruscan", QLocale::Etruscan, "@brief Enum constant QLocale::Etruscan") +
    gsi::enum_const ("Gothic", QLocale::Gothic, "@brief Enum constant QLocale::Gothic") +
    gsi::enum_const ("Hanunoo", QLocale::Hanunoo, "@brief Enum constant QLocale::Hanunoo") +
    gsi::enum_const ("Ingush", QLocale::Ingush, "@brief Enum constant QLocale::Ingush") +
    gsi::enum_const ("LargeFloweryMiao", QLocale::LargeFloweryMiao, "@brief Enum constant QLocale::LargeFloweryMiao") +
    gsi::enum_const ("Lepcha", QLocale::Lepcha, "@brief Enum constant QLocale::Lepcha") +
    gsi::enum_const ("Limbu", QLocale::Limbu, "@brief Enum constant QLocale::Limbu") +
    gsi::enum_const ("Lisu", QLocale::Lisu, "@brief Enum constant QLocale::Lisu") +
    gsi::enum_const ("Lu", QLocale::Lu, "@brief Enum constant QLocale::Lu") +
    gsi::enum_const ("Lycian", QLocale::Lycian, "@brief Enum constant QLocale::Lycian") +
    gsi::enum_const ("Lydian", QLocale::Lydian, "@brief Enum constant QLocale::Lydian") +
    gsi::enum_const ("Mandingo", QLocale::Mandingo, "@brief Enum constant QLocale::Mandingo") +
    gsi::enum_const ("Manipuri", QLocale::Manipuri, "@brief Enum constant QLocale::Manipuri") +
    gsi::enum_const ("Meroitic", QLocale::Meroitic, "@brief Enum constant QLocale::Meroitic") +
    gsi::enum_const ("NorthernThai", QLocale::NorthernThai, "@brief Enum constant QLocale::NorthernThai") +
    gsi::enum_const ("OldIrish", QLocale::OldIrish, "@brief Enum constant QLocale::OldIrish") +
    gsi::enum_const ("OldNorse", QLocale::OldNorse, "@brief Enum constant QLocale::OldNorse") +
    gsi::enum_const ("OldPersian", QLocale::OldPersian, "@brief Enum constant QLocale::OldPersian") +
    gsi::enum_const ("OldTurkish", QLocale::OldTurkish, "@brief Enum constant QLocale::OldTurkish") +
    gsi::enum_const ("Pahlavi", QLocale::Pahlavi, "@brief Enum constant QLocale::Pahlavi") +
    gsi::enum_const ("Parthian", QLocale::Parthian, "@brief Enum constant QLocale::Parthian") +
    gsi::enum_const ("Phoenician", QLocale::Phoenician, "@brief Enum constant QLocale::Phoenician") +
    gsi::enum_const ("PrakritLanguage", QLocale::PrakritLanguage, "@brief Enum constant QLocale::PrakritLanguage") +
    gsi::enum_const ("Rejang", QLocale::Rejang, "@brief Enum constant QLocale::Rejang") +
    gsi::enum_const ("Sabaean", QLocale::Sabaean, "@brief Enum constant QLocale::Sabaean") +
    gsi::enum_const ("Samaritan", QLocale::Samaritan, "@brief Enum constant QLocale::Samaritan") +
    gsi::enum_const ("Santali", QLocale::Santali, "@brief Enum constant QLocale::Santali") +
    gsi::enum_const ("Saurashtra", QLocale::Saurashtra, "@brief Enum constant QLocale::Saurashtra") +
    gsi::enum_const ("Sora", QLocale::Sora, "@brief Enum constant QLocale::Sora") +
    gsi::enum_const ("Sylheti", QLocale::Sylheti, "@brief Enum constant QLocale::Sylheti") +
    gsi::enum_const ("Tagbanwa", QLocale::Tagbanwa, "@brief Enum constant QLocale::Tagbanwa") +
    gsi::enum_const ("TaiDam", QLocale::TaiDam, "@brief Enum constant QLocale::TaiDam") +
    gsi::enum_const ("TaiNua", QLocale::TaiNua, "@brief Enum constant QLocale::TaiNua") +
    gsi::enum_const ("Ugaritic", QLocale::Ugaritic, "@brief Enum constant QLocale::Ugaritic") +
    gsi::enum_const ("Akoose", QLocale::Akoose, "@brief Enum constant QLocale::Akoose") +
    gsi::enum_const ("Lakota", QLocale::Lakota, "@brief Enum constant QLocale::Lakota") +
    gsi::enum_const ("StandardMoroccanTamazight", QLocale::StandardMoroccanTamazight, "@brief Enum constant QLocale::StandardMoroccanTamazight") +
    gsi::enum_const ("Mapuche", QLocale::Mapuche, "@brief Enum constant QLocale::Mapuche") +
    gsi::enum_const ("CentralKurdish", QLocale::CentralKurdish, "@brief Enum constant QLocale::CentralKurdish") +
    gsi::enum_const ("LowerSorbian", QLocale::LowerSorbian, "@brief Enum constant QLocale::LowerSorbian") +
    gsi::enum_const ("UpperSorbian", QLocale::UpperSorbian, "@brief Enum constant QLocale::UpperSorbian") +
    gsi::enum_const ("Kenyang", QLocale::Kenyang, "@brief Enum constant QLocale::Kenyang") +
    gsi::enum_const ("Mohawk", QLocale::Mohawk, "@brief Enum constant QLocale::Mohawk") +
    gsi::enum_const ("Nko", QLocale::Nko, "@brief Enum constant QLocale::Nko") +
    gsi::enum_const ("Prussian", QLocale::Prussian, "@brief Enum constant QLocale::Prussian") +
    gsi::enum_const ("Kiche", QLocale::Kiche, "@brief Enum constant QLocale::Kiche") +
    gsi::enum_const ("SouthernSami", QLocale::SouthernSami, "@brief Enum constant QLocale::SouthernSami") +
    gsi::enum_const ("LuleSami", QLocale::LuleSami, "@brief Enum constant QLocale::LuleSami") +
    gsi::enum_const ("InariSami", QLocale::InariSami, "@brief Enum constant QLocale::InariSami") +
    gsi::enum_const ("SkoltSami", QLocale::SkoltSami, "@brief Enum constant QLocale::SkoltSami") +
    gsi::enum_const ("Warlpiri", QLocale::Warlpiri, "@brief Enum constant QLocale::Warlpiri") +
    gsi::enum_const ("ManichaeanMiddlePersian", QLocale::ManichaeanMiddlePersian, "@brief Enum constant QLocale::ManichaeanMiddlePersian") +
    gsi::enum_const ("Mende", QLocale::Mende, "@brief Enum constant QLocale::Mende") +
    gsi::enum_const ("AncientNorthArabian", QLocale::AncientNorthArabian, "@brief Enum constant QLocale::AncientNorthArabian") +
    gsi::enum_const ("LinearA", QLocale::LinearA, "@brief Enum constant QLocale::LinearA") +
    gsi::enum_const ("HmongNjua", QLocale::HmongNjua, "@brief Enum constant QLocale::HmongNjua") +
    gsi::enum_const ("Ho", QLocale::Ho, "@brief Enum constant QLocale::Ho") +
    gsi::enum_const ("Lezghian", QLocale::Lezghian, "@brief Enum constant QLocale::Lezghian") +
    gsi::enum_const ("Bassa", QLocale::Bassa, "@brief Enum constant QLocale::Bassa") +
    gsi::enum_const ("Mono", QLocale::Mono, "@brief Enum constant QLocale::Mono") +
    gsi::enum_const ("TedimChin", QLocale::TedimChin, "@brief Enum constant QLocale::TedimChin") +
    gsi::enum_const ("Maithili", QLocale::Maithili, "@brief Enum constant QLocale::Maithili") +
    gsi::enum_const ("Norwegian", QLocale::Norwegian, "@brief Enum constant QLocale::Norwegian") +
    gsi::enum_const ("Moldavian", QLocale::Moldavian, "@brief Enum constant QLocale::Moldavian") +
    gsi::enum_const ("SerboCroatian", QLocale::SerboCroatian, "@brief Enum constant QLocale::SerboCroatian") +
    gsi::enum_const ("Tagalog", QLocale::Tagalog, "@brief Enum constant QLocale::Tagalog") +
    gsi::enum_const ("Twi", QLocale::Twi, "@brief Enum constant QLocale::Twi") +
    gsi::enum_const ("Afan", QLocale::Afan, "@brief Enum constant QLocale::Afan") +
    gsi::enum_const ("Byelorussian", QLocale::Byelorussian, "@brief Enum constant QLocale::Byelorussian") +
    gsi::enum_const ("Bhutani", QLocale::Bhutani, "@brief Enum constant QLocale::Bhutani") +
    gsi::enum_const ("Cambodian", QLocale::Cambodian, "@brief Enum constant QLocale::Cambodian") +
    gsi::enum_const ("Kurundi", QLocale::Kurundi, "@brief Enum constant QLocale::Kurundi") +
    gsi::enum_const ("RhaetoRomance", QLocale::RhaetoRomance, "@brief Enum constant QLocale::RhaetoRomance") +
    gsi::enum_const ("Chewa", QLocale::Chewa, "@brief Enum constant QLocale::Chewa") +
    gsi::enum_const ("Frisian", QLocale::Frisian, "@brief Enum constant QLocale::Frisian") +
    gsi::enum_const ("Uigur", QLocale::Uigur, "@brief Enum constant QLocale::Uigur") +
    gsi::enum_const ("LastLanguage", QLocale::LastLanguage, "@brief Enum constant QLocale::LastLanguage"),
  "@qt\n@brief This class represents the QLocale::Language enum");

static gsi::QFlagsClass<QLocale::Language > decl_QLocale_Language_Enums ("QtCore", "QLocale_QFlags_Language",
  "@qt\n@brief This class represents the QFlags<QLocale::Language> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocale> inject_QLocale_Language_Enum_in_parent (decl_QLocale_Language_Enum.defs ());
static gsi::ClassExt<QLocale> decl_QLocale_Language_Enum_as_child (decl_QLocale_Language_Enum, "Language");
static gsi::ClassExt<QLocale> decl_QLocale_Language_Enums_as_child (decl_QLocale_Language_Enums, "QFlags_Language");

}


//  Implementation of the enum wrapper class for QLocale::MeasurementSystem
namespace qt_gsi
{

static gsi::Enum<QLocale::MeasurementSystem> decl_QLocale_MeasurementSystem_Enum ("QtCore", "QLocale_MeasurementSystem",
    gsi::enum_const ("MetricSystem", QLocale::MetricSystem, "@brief Enum constant QLocale::MetricSystem") +
    gsi::enum_const ("ImperialUSSystem", QLocale::ImperialUSSystem, "@brief Enum constant QLocale::ImperialUSSystem") +
    gsi::enum_const ("ImperialUKSystem", QLocale::ImperialUKSystem, "@brief Enum constant QLocale::ImperialUKSystem") +
    gsi::enum_const ("ImperialSystem", QLocale::ImperialSystem, "@brief Enum constant QLocale::ImperialSystem"),
  "@qt\n@brief This class represents the QLocale::MeasurementSystem enum");

static gsi::QFlagsClass<QLocale::MeasurementSystem > decl_QLocale_MeasurementSystem_Enums ("QtCore", "QLocale_QFlags_MeasurementSystem",
  "@qt\n@brief This class represents the QFlags<QLocale::MeasurementSystem> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocale> inject_QLocale_MeasurementSystem_Enum_in_parent (decl_QLocale_MeasurementSystem_Enum.defs ());
static gsi::ClassExt<QLocale> decl_QLocale_MeasurementSystem_Enum_as_child (decl_QLocale_MeasurementSystem_Enum, "MeasurementSystem");
static gsi::ClassExt<QLocale> decl_QLocale_MeasurementSystem_Enums_as_child (decl_QLocale_MeasurementSystem_Enums, "QFlags_MeasurementSystem");

}


//  Implementation of the enum wrapper class for QLocale::NumberOption
namespace qt_gsi
{

static gsi::Enum<QLocale::NumberOption> decl_QLocale_NumberOption_Enum ("QtCore", "QLocale_NumberOption",
    gsi::enum_const ("OmitGroupSeparator", QLocale::OmitGroupSeparator, "@brief Enum constant QLocale::OmitGroupSeparator") +
    gsi::enum_const ("RejectGroupSeparator", QLocale::RejectGroupSeparator, "@brief Enum constant QLocale::RejectGroupSeparator"),
  "@qt\n@brief This class represents the QLocale::NumberOption enum");

static gsi::QFlagsClass<QLocale::NumberOption > decl_QLocale_NumberOption_Enums ("QtCore", "QLocale_QFlags_NumberOption",
  "@qt\n@brief This class represents the QFlags<QLocale::NumberOption> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocale> inject_QLocale_NumberOption_Enum_in_parent (decl_QLocale_NumberOption_Enum.defs ());
static gsi::ClassExt<QLocale> decl_QLocale_NumberOption_Enum_as_child (decl_QLocale_NumberOption_Enum, "NumberOption");
static gsi::ClassExt<QLocale> decl_QLocale_NumberOption_Enums_as_child (decl_QLocale_NumberOption_Enums, "QFlags_NumberOption");

}


//  Implementation of the enum wrapper class for QLocale::QuotationStyle
namespace qt_gsi
{

static gsi::Enum<QLocale::QuotationStyle> decl_QLocale_QuotationStyle_Enum ("QtCore", "QLocale_QuotationStyle",
    gsi::enum_const ("StandardQuotation", QLocale::StandardQuotation, "@brief Enum constant QLocale::StandardQuotation") +
    gsi::enum_const ("AlternateQuotation", QLocale::AlternateQuotation, "@brief Enum constant QLocale::AlternateQuotation"),
  "@qt\n@brief This class represents the QLocale::QuotationStyle enum");

static gsi::QFlagsClass<QLocale::QuotationStyle > decl_QLocale_QuotationStyle_Enums ("QtCore", "QLocale_QFlags_QuotationStyle",
  "@qt\n@brief This class represents the QFlags<QLocale::QuotationStyle> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocale> inject_QLocale_QuotationStyle_Enum_in_parent (decl_QLocale_QuotationStyle_Enum.defs ());
static gsi::ClassExt<QLocale> decl_QLocale_QuotationStyle_Enum_as_child (decl_QLocale_QuotationStyle_Enum, "QuotationStyle");
static gsi::ClassExt<QLocale> decl_QLocale_QuotationStyle_Enums_as_child (decl_QLocale_QuotationStyle_Enums, "QFlags_QuotationStyle");

}


//  Implementation of the enum wrapper class for QLocale::Script
namespace qt_gsi
{

static gsi::Enum<QLocale::Script> decl_QLocale_Script_Enum ("QtCore", "QLocale_Script",
    gsi::enum_const ("AnyScript", QLocale::AnyScript, "@brief Enum constant QLocale::AnyScript") +
    gsi::enum_const ("ArabicScript", QLocale::ArabicScript, "@brief Enum constant QLocale::ArabicScript") +
    gsi::enum_const ("CyrillicScript", QLocale::CyrillicScript, "@brief Enum constant QLocale::CyrillicScript") +
    gsi::enum_const ("DeseretScript", QLocale::DeseretScript, "@brief Enum constant QLocale::DeseretScript") +
    gsi::enum_const ("GurmukhiScript", QLocale::GurmukhiScript, "@brief Enum constant QLocale::GurmukhiScript") +
    gsi::enum_const ("SimplifiedHanScript", QLocale::SimplifiedHanScript, "@brief Enum constant QLocale::SimplifiedHanScript") +
    gsi::enum_const ("TraditionalHanScript", QLocale::TraditionalHanScript, "@brief Enum constant QLocale::TraditionalHanScript") +
    gsi::enum_const ("LatinScript", QLocale::LatinScript, "@brief Enum constant QLocale::LatinScript") +
    gsi::enum_const ("MongolianScript", QLocale::MongolianScript, "@brief Enum constant QLocale::MongolianScript") +
    gsi::enum_const ("TifinaghScript", QLocale::TifinaghScript, "@brief Enum constant QLocale::TifinaghScript") +
    gsi::enum_const ("ArmenianScript", QLocale::ArmenianScript, "@brief Enum constant QLocale::ArmenianScript") +
    gsi::enum_const ("BengaliScript", QLocale::BengaliScript, "@brief Enum constant QLocale::BengaliScript") +
    gsi::enum_const ("CherokeeScript", QLocale::CherokeeScript, "@brief Enum constant QLocale::CherokeeScript") +
    gsi::enum_const ("DevanagariScript", QLocale::DevanagariScript, "@brief Enum constant QLocale::DevanagariScript") +
    gsi::enum_const ("EthiopicScript", QLocale::EthiopicScript, "@brief Enum constant QLocale::EthiopicScript") +
    gsi::enum_const ("GeorgianScript", QLocale::GeorgianScript, "@brief Enum constant QLocale::GeorgianScript") +
    gsi::enum_const ("GreekScript", QLocale::GreekScript, "@brief Enum constant QLocale::GreekScript") +
    gsi::enum_const ("GujaratiScript", QLocale::GujaratiScript, "@brief Enum constant QLocale::GujaratiScript") +
    gsi::enum_const ("HebrewScript", QLocale::HebrewScript, "@brief Enum constant QLocale::HebrewScript") +
    gsi::enum_const ("JapaneseScript", QLocale::JapaneseScript, "@brief Enum constant QLocale::JapaneseScript") +
    gsi::enum_const ("KhmerScript", QLocale::KhmerScript, "@brief Enum constant QLocale::KhmerScript") +
    gsi::enum_const ("KannadaScript", QLocale::KannadaScript, "@brief Enum constant QLocale::KannadaScript") +
    gsi::enum_const ("KoreanScript", QLocale::KoreanScript, "@brief Enum constant QLocale::KoreanScript") +
    gsi::enum_const ("LaoScript", QLocale::LaoScript, "@brief Enum constant QLocale::LaoScript") +
    gsi::enum_const ("MalayalamScript", QLocale::MalayalamScript, "@brief Enum constant QLocale::MalayalamScript") +
    gsi::enum_const ("MyanmarScript", QLocale::MyanmarScript, "@brief Enum constant QLocale::MyanmarScript") +
    gsi::enum_const ("OriyaScript", QLocale::OriyaScript, "@brief Enum constant QLocale::OriyaScript") +
    gsi::enum_const ("TamilScript", QLocale::TamilScript, "@brief Enum constant QLocale::TamilScript") +
    gsi::enum_const ("TeluguScript", QLocale::TeluguScript, "@brief Enum constant QLocale::TeluguScript") +
    gsi::enum_const ("ThaanaScript", QLocale::ThaanaScript, "@brief Enum constant QLocale::ThaanaScript") +
    gsi::enum_const ("ThaiScript", QLocale::ThaiScript, "@brief Enum constant QLocale::ThaiScript") +
    gsi::enum_const ("TibetanScript", QLocale::TibetanScript, "@brief Enum constant QLocale::TibetanScript") +
    gsi::enum_const ("SinhalaScript", QLocale::SinhalaScript, "@brief Enum constant QLocale::SinhalaScript") +
    gsi::enum_const ("SyriacScript", QLocale::SyriacScript, "@brief Enum constant QLocale::SyriacScript") +
    gsi::enum_const ("YiScript", QLocale::YiScript, "@brief Enum constant QLocale::YiScript") +
    gsi::enum_const ("VaiScript", QLocale::VaiScript, "@brief Enum constant QLocale::VaiScript") +
    gsi::enum_const ("AvestanScript", QLocale::AvestanScript, "@brief Enum constant QLocale::AvestanScript") +
    gsi::enum_const ("BalineseScript", QLocale::BalineseScript, "@brief Enum constant QLocale::BalineseScript") +
    gsi::enum_const ("BamumScript", QLocale::BamumScript, "@brief Enum constant QLocale::BamumScript") +
    gsi::enum_const ("BatakScript", QLocale::BatakScript, "@brief Enum constant QLocale::BatakScript") +
    gsi::enum_const ("BopomofoScript", QLocale::BopomofoScript, "@brief Enum constant QLocale::BopomofoScript") +
    gsi::enum_const ("BrahmiScript", QLocale::BrahmiScript, "@brief Enum constant QLocale::BrahmiScript") +
    gsi::enum_const ("BugineseScript", QLocale::BugineseScript, "@brief Enum constant QLocale::BugineseScript") +
    gsi::enum_const ("BuhidScript", QLocale::BuhidScript, "@brief Enum constant QLocale::BuhidScript") +
    gsi::enum_const ("CanadianAboriginalScript", QLocale::CanadianAboriginalScript, "@brief Enum constant QLocale::CanadianAboriginalScript") +
    gsi::enum_const ("CarianScript", QLocale::CarianScript, "@brief Enum constant QLocale::CarianScript") +
    gsi::enum_const ("ChakmaScript", QLocale::ChakmaScript, "@brief Enum constant QLocale::ChakmaScript") +
    gsi::enum_const ("ChamScript", QLocale::ChamScript, "@brief Enum constant QLocale::ChamScript") +
    gsi::enum_const ("CopticScript", QLocale::CopticScript, "@brief Enum constant QLocale::CopticScript") +
    gsi::enum_const ("CypriotScript", QLocale::CypriotScript, "@brief Enum constant QLocale::CypriotScript") +
    gsi::enum_const ("EgyptianHieroglyphsScript", QLocale::EgyptianHieroglyphsScript, "@brief Enum constant QLocale::EgyptianHieroglyphsScript") +
    gsi::enum_const ("FraserScript", QLocale::FraserScript, "@brief Enum constant QLocale::FraserScript") +
    gsi::enum_const ("GlagoliticScript", QLocale::GlagoliticScript, "@brief Enum constant QLocale::GlagoliticScript") +
    gsi::enum_const ("GothicScript", QLocale::GothicScript, "@brief Enum constant QLocale::GothicScript") +
    gsi::enum_const ("HanScript", QLocale::HanScript, "@brief Enum constant QLocale::HanScript") +
    gsi::enum_const ("HangulScript", QLocale::HangulScript, "@brief Enum constant QLocale::HangulScript") +
    gsi::enum_const ("HanunooScript", QLocale::HanunooScript, "@brief Enum constant QLocale::HanunooScript") +
    gsi::enum_const ("ImperialAramaicScript", QLocale::ImperialAramaicScript, "@brief Enum constant QLocale::ImperialAramaicScript") +
    gsi::enum_const ("InscriptionalPahlaviScript", QLocale::InscriptionalPahlaviScript, "@brief Enum constant QLocale::InscriptionalPahlaviScript") +
    gsi::enum_const ("InscriptionalParthianScript", QLocale::InscriptionalParthianScript, "@brief Enum constant QLocale::InscriptionalParthianScript") +
    gsi::enum_const ("JavaneseScript", QLocale::JavaneseScript, "@brief Enum constant QLocale::JavaneseScript") +
    gsi::enum_const ("KaithiScript", QLocale::KaithiScript, "@brief Enum constant QLocale::KaithiScript") +
    gsi::enum_const ("KatakanaScript", QLocale::KatakanaScript, "@brief Enum constant QLocale::KatakanaScript") +
    gsi::enum_const ("KayahLiScript", QLocale::KayahLiScript, "@brief Enum constant QLocale::KayahLiScript") +
    gsi::enum_const ("KharoshthiScript", QLocale::KharoshthiScript, "@brief Enum constant QLocale::KharoshthiScript") +
    gsi::enum_const ("LannaScript", QLocale::LannaScript, "@brief Enum constant QLocale::LannaScript") +
    gsi::enum_const ("LepchaScript", QLocale::LepchaScript, "@brief Enum constant QLocale::LepchaScript") +
    gsi::enum_const ("LimbuScript", QLocale::LimbuScript, "@brief Enum constant QLocale::LimbuScript") +
    gsi::enum_const ("LinearBScript", QLocale::LinearBScript, "@brief Enum constant QLocale::LinearBScript") +
    gsi::enum_const ("LycianScript", QLocale::LycianScript, "@brief Enum constant QLocale::LycianScript") +
    gsi::enum_const ("LydianScript", QLocale::LydianScript, "@brief Enum constant QLocale::LydianScript") +
    gsi::enum_const ("MandaeanScript", QLocale::MandaeanScript, "@brief Enum constant QLocale::MandaeanScript") +
    gsi::enum_const ("MeiteiMayekScript", QLocale::MeiteiMayekScript, "@brief Enum constant QLocale::MeiteiMayekScript") +
    gsi::enum_const ("MeroiticScript", QLocale::MeroiticScript, "@brief Enum constant QLocale::MeroiticScript") +
    gsi::enum_const ("MeroiticCursiveScript", QLocale::MeroiticCursiveScript, "@brief Enum constant QLocale::MeroiticCursiveScript") +
    gsi::enum_const ("NkoScript", QLocale::NkoScript, "@brief Enum constant QLocale::NkoScript") +
    gsi::enum_const ("NewTaiLueScript", QLocale::NewTaiLueScript, "@brief Enum constant QLocale::NewTaiLueScript") +
    gsi::enum_const ("OghamScript", QLocale::OghamScript, "@brief Enum constant QLocale::OghamScript") +
    gsi::enum_const ("OlChikiScript", QLocale::OlChikiScript, "@brief Enum constant QLocale::OlChikiScript") +
    gsi::enum_const ("OldItalicScript", QLocale::OldItalicScript, "@brief Enum constant QLocale::OldItalicScript") +
    gsi::enum_const ("OldPersianScript", QLocale::OldPersianScript, "@brief Enum constant QLocale::OldPersianScript") +
    gsi::enum_const ("OldSouthArabianScript", QLocale::OldSouthArabianScript, "@brief Enum constant QLocale::OldSouthArabianScript") +
    gsi::enum_const ("OrkhonScript", QLocale::OrkhonScript, "@brief Enum constant QLocale::OrkhonScript") +
    gsi::enum_const ("OsmanyaScript", QLocale::OsmanyaScript, "@brief Enum constant QLocale::OsmanyaScript") +
    gsi::enum_const ("PhagsPaScript", QLocale::PhagsPaScript, "@brief Enum constant QLocale::PhagsPaScript") +
    gsi::enum_const ("PhoenicianScript", QLocale::PhoenicianScript, "@brief Enum constant QLocale::PhoenicianScript") +
    gsi::enum_const ("PollardPhoneticScript", QLocale::PollardPhoneticScript, "@brief Enum constant QLocale::PollardPhoneticScript") +
    gsi::enum_const ("RejangScript", QLocale::RejangScript, "@brief Enum constant QLocale::RejangScript") +
    gsi::enum_const ("RunicScript", QLocale::RunicScript, "@brief Enum constant QLocale::RunicScript") +
    gsi::enum_const ("SamaritanScript", QLocale::SamaritanScript, "@brief Enum constant QLocale::SamaritanScript") +
    gsi::enum_const ("SaurashtraScript", QLocale::SaurashtraScript, "@brief Enum constant QLocale::SaurashtraScript") +
    gsi::enum_const ("SharadaScript", QLocale::SharadaScript, "@brief Enum constant QLocale::SharadaScript") +
    gsi::enum_const ("ShavianScript", QLocale::ShavianScript, "@brief Enum constant QLocale::ShavianScript") +
    gsi::enum_const ("SoraSompengScript", QLocale::SoraSompengScript, "@brief Enum constant QLocale::SoraSompengScript") +
    gsi::enum_const ("CuneiformScript", QLocale::CuneiformScript, "@brief Enum constant QLocale::CuneiformScript") +
    gsi::enum_const ("SundaneseScript", QLocale::SundaneseScript, "@brief Enum constant QLocale::SundaneseScript") +
    gsi::enum_const ("SylotiNagriScript", QLocale::SylotiNagriScript, "@brief Enum constant QLocale::SylotiNagriScript") +
    gsi::enum_const ("TagalogScript", QLocale::TagalogScript, "@brief Enum constant QLocale::TagalogScript") +
    gsi::enum_const ("TagbanwaScript", QLocale::TagbanwaScript, "@brief Enum constant QLocale::TagbanwaScript") +
    gsi::enum_const ("TaiLeScript", QLocale::TaiLeScript, "@brief Enum constant QLocale::TaiLeScript") +
    gsi::enum_const ("TaiVietScript", QLocale::TaiVietScript, "@brief Enum constant QLocale::TaiVietScript") +
    gsi::enum_const ("TakriScript", QLocale::TakriScript, "@brief Enum constant QLocale::TakriScript") +
    gsi::enum_const ("UgariticScript", QLocale::UgariticScript, "@brief Enum constant QLocale::UgariticScript") +
    gsi::enum_const ("BrailleScript", QLocale::BrailleScript, "@brief Enum constant QLocale::BrailleScript") +
    gsi::enum_const ("HiraganaScript", QLocale::HiraganaScript, "@brief Enum constant QLocale::HiraganaScript") +
    gsi::enum_const ("CaucasianAlbanianScript", QLocale::CaucasianAlbanianScript, "@brief Enum constant QLocale::CaucasianAlbanianScript") +
    gsi::enum_const ("BassaVahScript", QLocale::BassaVahScript, "@brief Enum constant QLocale::BassaVahScript") +
    gsi::enum_const ("DuployanScript", QLocale::DuployanScript, "@brief Enum constant QLocale::DuployanScript") +
    gsi::enum_const ("ElbasanScript", QLocale::ElbasanScript, "@brief Enum constant QLocale::ElbasanScript") +
    gsi::enum_const ("GranthaScript", QLocale::GranthaScript, "@brief Enum constant QLocale::GranthaScript") +
    gsi::enum_const ("PahawhHmongScript", QLocale::PahawhHmongScript, "@brief Enum constant QLocale::PahawhHmongScript") +
    gsi::enum_const ("KhojkiScript", QLocale::KhojkiScript, "@brief Enum constant QLocale::KhojkiScript") +
    gsi::enum_const ("LinearAScript", QLocale::LinearAScript, "@brief Enum constant QLocale::LinearAScript") +
    gsi::enum_const ("MahajaniScript", QLocale::MahajaniScript, "@brief Enum constant QLocale::MahajaniScript") +
    gsi::enum_const ("ManichaeanScript", QLocale::ManichaeanScript, "@brief Enum constant QLocale::ManichaeanScript") +
    gsi::enum_const ("MendeKikakuiScript", QLocale::MendeKikakuiScript, "@brief Enum constant QLocale::MendeKikakuiScript") +
    gsi::enum_const ("ModiScript", QLocale::ModiScript, "@brief Enum constant QLocale::ModiScript") +
    gsi::enum_const ("MroScript", QLocale::MroScript, "@brief Enum constant QLocale::MroScript") +
    gsi::enum_const ("OldNorthArabianScript", QLocale::OldNorthArabianScript, "@brief Enum constant QLocale::OldNorthArabianScript") +
    gsi::enum_const ("NabataeanScript", QLocale::NabataeanScript, "@brief Enum constant QLocale::NabataeanScript") +
    gsi::enum_const ("PalmyreneScript", QLocale::PalmyreneScript, "@brief Enum constant QLocale::PalmyreneScript") +
    gsi::enum_const ("PauCinHauScript", QLocale::PauCinHauScript, "@brief Enum constant QLocale::PauCinHauScript") +
    gsi::enum_const ("OldPermicScript", QLocale::OldPermicScript, "@brief Enum constant QLocale::OldPermicScript") +
    gsi::enum_const ("PsalterPahlaviScript", QLocale::PsalterPahlaviScript, "@brief Enum constant QLocale::PsalterPahlaviScript") +
    gsi::enum_const ("SiddhamScript", QLocale::SiddhamScript, "@brief Enum constant QLocale::SiddhamScript") +
    gsi::enum_const ("KhudawadiScript", QLocale::KhudawadiScript, "@brief Enum constant QLocale::KhudawadiScript") +
    gsi::enum_const ("TirhutaScript", QLocale::TirhutaScript, "@brief Enum constant QLocale::TirhutaScript") +
    gsi::enum_const ("VarangKshitiScript", QLocale::VarangKshitiScript, "@brief Enum constant QLocale::VarangKshitiScript") +
    gsi::enum_const ("SimplifiedChineseScript", QLocale::SimplifiedChineseScript, "@brief Enum constant QLocale::SimplifiedChineseScript") +
    gsi::enum_const ("TraditionalChineseScript", QLocale::TraditionalChineseScript, "@brief Enum constant QLocale::TraditionalChineseScript") +
    gsi::enum_const ("LastScript", QLocale::LastScript, "@brief Enum constant QLocale::LastScript"),
  "@qt\n@brief This class represents the QLocale::Script enum");

static gsi::QFlagsClass<QLocale::Script > decl_QLocale_Script_Enums ("QtCore", "QLocale_QFlags_Script",
  "@qt\n@brief This class represents the QFlags<QLocale::Script> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocale> inject_QLocale_Script_Enum_in_parent (decl_QLocale_Script_Enum.defs ());
static gsi::ClassExt<QLocale> decl_QLocale_Script_Enum_as_child (decl_QLocale_Script_Enum, "Script");
static gsi::ClassExt<QLocale> decl_QLocale_Script_Enums_as_child (decl_QLocale_Script_Enums, "QFlags_Script");

}

