; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --prefix-filecheck-ir-name abc
; RUN: opt -dse -S < %s | FileCheck %s

; Make sure invokes are not removed as dead stores.
define void @test_nounwind_invoke() personality i8* bitcast (i32 (...)*  @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @test_nounwind_invoke(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP:%.*]] = alloca i32, align 4
; CHECK-NEXT:    invoke void @foo(i32* [[TMP]])
; CHECK-NEXT:    to label [[BB1:%.*]] unwind label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    call void @llvm.lifetime.end.p0i32(i64 4, i32* [[TMP]])
; CHECK-NEXT:    ret void
; CHECK:       bb2:
; CHECK-NEXT:    [[ABCTMP1:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    resume { i8*, i32 } [[ABCTMP1]]
;
bb:
  %tmp = alloca i32, align 4
  ; 'foo' is 'argmemonly', meaning it can only write to memory pointed by %tmp.
  ; And this def is killed by 'call @llvm.lifetime.end.p0i32' in bb1 without
  ; being used elsewhere, becoming a dead store. But we shouldn't remove this
  ; because invokes are terminators and thus cannot be removed.
  invoke void @foo(i32* %tmp)
  to label %bb1 unwind label %bb2

bb1:                                              ; preds = %bb
  call void @llvm.lifetime.end.p0i32(i64 4, i32* %tmp)
  ret void

bb2:                                              ; preds = %bb
  %tmp1 = landingpad { i8*, i32 }
  cleanup
  resume { i8*, i32 } %tmp1
}

; Function Attrs: argmemonly nocallback nofree nosync nounwind willreturn
declare void @llvm.lifetime.end.p0i32(i64 immarg, i32* nocapture) #0
; Function Attrs: argmemonly nounwind willreturn
declare void @foo(i32*) #1
declare i32 @__gxx_personality_v0(...)

attributes #0 = { argmemonly nocallback nofree nosync nounwind willreturn }
attributes #1 = { argmemonly nounwind willreturn }
