; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=x86_64-pc-linux-gnu -mcpu=generic -passes=slp-vectorizer -pass-remarks-output=%t < %s | FileCheck %s
; RUN: FileCheck --input-file=%t --check-prefix=YAML %s

; YAML-LABEL: --- !Passed
; YAML-NEXT:  Pass:            slp-vectorizer
; YAML-NEXT:  Name:            VectorizedList
; YAML-NEXT:  Function:        build_vec_v2i64
; YAML-NEXT:  Args:
; YAML-NEXT:    - String:          'SLP vectorized with cost '
; YAML-NEXT:    - Cost:            '-10'
; YAML-NEXT:    - String:          ' and with tree size '
; YAML-NEXT:    - TreeSize:        '8'

define <2 x i64> @build_vec_v2i64(<2 x i64> %v0, <2 x i64> %v1) {
; CHECK-LABEL: @build_vec_v2i64(
; CHECK-NEXT:    [[TMP1:%.*]] = add <2 x i64> [[V0:%.*]], [[V1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = sub <2 x i64> [[V0]], [[V1]]
; CHECK-NEXT:    [[TMP3:%.*]] = shufflevector <2 x i64> [[TMP1]], <2 x i64> [[TMP2]], <2 x i32> <i32 1, i32 2>
; CHECK-NEXT:    [[TMP4:%.*]] = shufflevector <2 x i64> [[TMP1]], <2 x i64> [[TMP2]], <2 x i32> <i32 0, i32 3>
; CHECK-NEXT:    [[TMP5:%.*]] = add <2 x i64> [[TMP4]], [[TMP3]]
; CHECK-NEXT:    ret <2 x i64> [[TMP5]]
;
  %v0.0 = extractelement <2 x i64> %v0, i32 0
  %v0.1 = extractelement <2 x i64> %v0, i32 1
  %v1.0 = extractelement <2 x i64> %v1, i32 0
  %v1.1 = extractelement <2 x i64> %v1, i32 1
  %tmp0.0 = add i64 %v0.0, %v1.0
  %tmp0.1 = add i64 %v0.1, %v1.1
  %tmp1.0 = sub i64 %v0.0, %v1.0
  %tmp1.1 = sub i64 %v0.1, %v1.1
  %tmp2.0 = add i64 %tmp0.0, %tmp0.1
  %tmp2.1 = add i64 %tmp1.0, %tmp1.1
  %tmp3.0 = insertelement <2 x i64> undef, i64 %tmp2.0, i32 0
  %tmp3.1 = insertelement <2 x i64> %tmp3.0, i64 %tmp2.1, i32 1
  ret <2 x i64> %tmp3.1
}
