; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc --mtriple=loongarch64 --target-abi=lp64s < %s | FileCheck %s

;; This file contains specific tests for the lp64s ABI.

define i64 @callee_float_in_regs(i64 %a, float %b) nounwind {
; CHECK-LABEL: callee_float_in_regs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $fp, $sp, 0 # 8-byte Folded Spill
; CHECK-NEXT:    move $fp, $a0
; CHECK-NEXT:    move $a0, $a1
; CHECK-NEXT:    bl %plt(__fixsfdi)
; CHECK-NEXT:    add.d $a0, $fp, $a0
; CHECK-NEXT:    ld.d $fp, $sp, 0 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
  %b_fptosi = fptosi float %b to i64
  %1 = add i64 %a, %b_fptosi
  ret i64 %1
}

define i64 @caller_float_in_regs() nounwind {
; CHECK-LABEL: caller_float_in_regs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    lu12i.w $a1, 262144
; CHECK-NEXT:    ori $a0, $zero, 1
; CHECK-NEXT:    bl %plt(callee_float_in_regs)
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
  %1 = call i64 @callee_float_in_regs(i64 1, float 2.0)
  ret i64 %1
}

define i64 @callee_float_on_stack(i128 %a, i128 %b, i128 %c, i128 %d, float %e) nounwind {
; CHECK-LABEL: callee_float_on_stack:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ld.w $a0, $sp, 0
; CHECK-NEXT:    ret
  %1 = trunc i128 %d to i64
  %2 = bitcast float %e to i32
  %3 = sext i32 %2 to i64
  %4 = add i64 %1, %3
  ret i64 %3
}

define i64 @caller_float_on_stack() nounwind {
; CHECK-LABEL: caller_float_on_stack:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    lu12i.w $a1, 264704
; CHECK-NEXT:    ori $a0, $zero, 1
; CHECK-NEXT:    ori $a2, $zero, 2
; CHECK-NEXT:    ori $a4, $zero, 3
; CHECK-NEXT:    ori $a6, $zero, 4
; CHECK-NEXT:    st.d $a1, $sp, 0
; CHECK-NEXT:    move $a1, $zero
; CHECK-NEXT:    move $a3, $zero
; CHECK-NEXT:    move $a5, $zero
; CHECK-NEXT:    move $a7, $zero
; CHECK-NEXT:    bl %plt(callee_float_on_stack)
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
  %1 = call i64 @callee_float_on_stack(i128 1, i128 2, i128 3, i128 4, float 5.0)
  ret i64 %1
}

define float @callee_tiny_scalar_ret() nounwind {
; CHECK-LABEL: callee_tiny_scalar_ret:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lu12i.w $a0, 260096
; CHECK-NEXT:    ret
  ret float 1.0
}

define i64 @caller_tiny_scalar_ret() nounwind {
; CHECK-LABEL: caller_tiny_scalar_ret:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    bl %plt(callee_tiny_scalar_ret)
; CHECK-NEXT:    addi.w $a0, $a0, 0
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
  %1 = call float @callee_tiny_scalar_ret()
  %2 = bitcast float %1 to i32
  %3 = sext i32 %2 to i64
  ret i64 %3
}
