; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 -mattr=+d --relocation-model=pic < %s | FileCheck %s --check-prefix=LA32PIC
; RUN: llc --mtriple=loongarch64 -mattr=+d --relocation-model=pic < %s | FileCheck %s --check-prefix=LA64PIC
; RUN: llc --mtriple=loongarch64 -mattr=+d --code-model=large --relocation-model=pic < %s | FileCheck %s --check-prefix=LA64LARGEPIC
; RUN: llc --mtriple=loongarch32 -mattr=+d < %s | FileCheck %s --check-prefix=LA32NOPIC
; RUN: llc --mtriple=loongarch64 -mattr=+d < %s | FileCheck %s --check-prefix=LA64NOPIC
; RUN: llc --mtriple=loongarch64 -mattr=+d --code-model=large < %s | FileCheck %s --check-prefix=LA64LARGENOPIC
; RUN: llc --mtriple=loongarch32 -mattr=+d --relocation-model=pic --enable-tlsdesc < %s \
; RUN:     | FileCheck %s --check-prefix=LA32DESC
; RUN: llc --mtriple=loongarch64 -mattr=+d --relocation-model=pic --enable-tlsdesc < %s \
; RUN:     | FileCheck %s --check-prefix=LA64DESC
; RUN: llc --mtriple=loongarch64 -mattr=+d --relocation-model=pic --enable-tlsdesc \
; RUN:     --code-model=large < %s | FileCheck %s --check-prefix=DESC64

;; Check that TLS symbols are lowered correctly based on the specified
;; model. Make sure they're external to avoid them all being optimised to Local
;; Exec for the executable.

@unspecified = external thread_local global i32
@ld = external thread_local(localdynamic) global i32
@ie = external thread_local(initialexec) global i32
@le = external thread_local(localexec) global i32

;; No model specified (global dynamic)

define ptr @f1() nounwind {
; LA32PIC-LABEL: f1:
; LA32PIC:       # %bb.0: # %entry
; LA32PIC-NEXT:    addi.w $sp, $sp, -16
; LA32PIC-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32PIC-NEXT:    pcalau12i $a0, %gd_pc_hi20(unspecified)
; LA32PIC-NEXT:    addi.w $a0, $a0, %got_pc_lo12(unspecified)
; LA32PIC-NEXT:    bl %plt(__tls_get_addr)
; LA32PIC-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32PIC-NEXT:    addi.w $sp, $sp, 16
; LA32PIC-NEXT:    ret
;
; LA64PIC-LABEL: f1:
; LA64PIC:       # %bb.0: # %entry
; LA64PIC-NEXT:    addi.d $sp, $sp, -16
; LA64PIC-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64PIC-NEXT:    pcalau12i $a0, %gd_pc_hi20(unspecified)
; LA64PIC-NEXT:    addi.d $a0, $a0, %got_pc_lo12(unspecified)
; LA64PIC-NEXT:    bl %plt(__tls_get_addr)
; LA64PIC-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64PIC-NEXT:    addi.d $sp, $sp, 16
; LA64PIC-NEXT:    ret
;
; LA64LARGEPIC-LABEL: f1:
; LA64LARGEPIC:       # %bb.0: # %entry
; LA64LARGEPIC-NEXT:    addi.d $sp, $sp, -16
; LA64LARGEPIC-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64LARGEPIC-NEXT:    pcalau12i $a0, %gd_pc_hi20(unspecified)
; LA64LARGEPIC-NEXT:    addi.d $t8, $zero, %got_pc_lo12(unspecified)
; LA64LARGEPIC-NEXT:    lu32i.d $t8, %got64_pc_lo20(unspecified)
; LA64LARGEPIC-NEXT:    lu52i.d $t8, $t8, %got64_pc_hi12(unspecified)
; LA64LARGEPIC-NEXT:    add.d $a0, $t8, $a0
; LA64LARGEPIC-NEXT:    pcalau12i $ra, %pc_hi20(__tls_get_addr)
; LA64LARGEPIC-NEXT:    addi.d $t8, $zero, %pc_lo12(__tls_get_addr)
; LA64LARGEPIC-NEXT:    lu32i.d $t8, %pc64_lo20(__tls_get_addr)
; LA64LARGEPIC-NEXT:    lu52i.d $t8, $t8, %pc64_hi12(__tls_get_addr)
; LA64LARGEPIC-NEXT:    add.d $ra, $t8, $ra
; LA64LARGEPIC-NEXT:    jirl $ra, $ra, 0
; LA64LARGEPIC-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64LARGEPIC-NEXT:    addi.d $sp, $sp, 16
; LA64LARGEPIC-NEXT:    ret
;
; LA32NOPIC-LABEL: f1:
; LA32NOPIC:       # %bb.0: # %entry
; LA32NOPIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(unspecified)
; LA32NOPIC-NEXT:    ld.w $a0, $a0, %ie_pc_lo12(unspecified)
; LA32NOPIC-NEXT:    add.w $a0, $a0, $tp
; LA32NOPIC-NEXT:    ret
;
; LA64NOPIC-LABEL: f1:
; LA64NOPIC:       # %bb.0: # %entry
; LA64NOPIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(unspecified)
; LA64NOPIC-NEXT:    ld.d $a0, $a0, %ie_pc_lo12(unspecified)
; LA64NOPIC-NEXT:    add.d $a0, $a0, $tp
; LA64NOPIC-NEXT:    ret
;
; LA64LARGENOPIC-LABEL: f1:
; LA64LARGENOPIC:       # %bb.0: # %entry
; LA64LARGENOPIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(unspecified)
; LA64LARGENOPIC-NEXT:    addi.d $t8, $zero, %ie_pc_lo12(unspecified)
; LA64LARGENOPIC-NEXT:    lu32i.d $t8, %ie64_pc_lo20(unspecified)
; LA64LARGENOPIC-NEXT:    lu52i.d $t8, $t8, %ie64_pc_hi12(unspecified)
; LA64LARGENOPIC-NEXT:    ldx.d $a0, $t8, $a0
; LA64LARGENOPIC-NEXT:    add.d $a0, $a0, $tp
; LA64LARGENOPIC-NEXT:    ret
;
; LA32DESC-LABEL: f1:
; LA32DESC:       # %bb.0: # %entry
; LA32DESC-NEXT:    addi.w $sp, $sp, -16
; LA32DESC-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32DESC-NEXT:    pcalau12i $a0, %desc_pc_hi20(unspecified)
; LA32DESC-NEXT:    addi.w $a0, $a0, %desc_pc_lo12(unspecified)
; LA32DESC-NEXT:    ld.w $ra, $a0, %desc_ld(unspecified)
; LA32DESC-NEXT:    jirl $ra, $ra, %desc_call(unspecified)
; LA32DESC-NEXT:    add.w $a0, $a0, $tp
; LA32DESC-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32DESC-NEXT:    addi.w $sp, $sp, 16
; LA32DESC-NEXT:    ret
;
; LA64DESC-LABEL: f1:
; LA64DESC:       # %bb.0: # %entry
; LA64DESC-NEXT:    addi.d $sp, $sp, -16
; LA64DESC-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64DESC-NEXT:    pcalau12i $a0, %desc_pc_hi20(unspecified)
; LA64DESC-NEXT:    addi.d $a0, $a0, %desc_pc_lo12(unspecified)
; LA64DESC-NEXT:    ld.d $ra, $a0, %desc_ld(unspecified)
; LA64DESC-NEXT:    jirl $ra, $ra, %desc_call(unspecified)
; LA64DESC-NEXT:    add.d $a0, $a0, $tp
; LA64DESC-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64DESC-NEXT:    addi.d $sp, $sp, 16
; LA64DESC-NEXT:    ret
;
; DESC64-LABEL: f1:
; DESC64:       # %bb.0: # %entry
; DESC64-NEXT:    addi.d $sp, $sp, -16
; DESC64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; DESC64-NEXT:    pcalau12i $a0, %desc_pc_hi20(unspecified)
; DESC64-NEXT:    addi.d $t8, $zero, %desc_pc_lo12(unspecified)
; DESC64-NEXT:    lu32i.d $t8, %desc64_pc_lo20(unspecified)
; DESC64-NEXT:    lu52i.d $t8, $t8, %desc64_pc_hi12(unspecified)
; DESC64-NEXT:    add.d $a0, $t8, $a0
; DESC64-NEXT:    ld.d $ra, $a0, %desc_ld(unspecified)
; DESC64-NEXT:    jirl $ra, $ra, %desc_call(unspecified)
; DESC64-NEXT:    add.d $a1, $a0, $tp
; DESC64-NEXT:    move $a0, $a1
; DESC64-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; DESC64-NEXT:    addi.d $sp, $sp, 16
; DESC64-NEXT:    ret
entry:
  ret ptr @unspecified
}

;; localdynamic specified

define ptr @f2() nounwind {
; LA32PIC-LABEL: f2:
; LA32PIC:       # %bb.0: # %entry
; LA32PIC-NEXT:    addi.w $sp, $sp, -16
; LA32PIC-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32PIC-NEXT:    pcalau12i $a0, %ld_pc_hi20(ld)
; LA32PIC-NEXT:    addi.w $a0, $a0, %got_pc_lo12(ld)
; LA32PIC-NEXT:    bl %plt(__tls_get_addr)
; LA32PIC-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32PIC-NEXT:    addi.w $sp, $sp, 16
; LA32PIC-NEXT:    ret
;
; LA64PIC-LABEL: f2:
; LA64PIC:       # %bb.0: # %entry
; LA64PIC-NEXT:    addi.d $sp, $sp, -16
; LA64PIC-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64PIC-NEXT:    pcalau12i $a0, %ld_pc_hi20(ld)
; LA64PIC-NEXT:    addi.d $a0, $a0, %got_pc_lo12(ld)
; LA64PIC-NEXT:    bl %plt(__tls_get_addr)
; LA64PIC-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64PIC-NEXT:    addi.d $sp, $sp, 16
; LA64PIC-NEXT:    ret
;
; LA64LARGEPIC-LABEL: f2:
; LA64LARGEPIC:       # %bb.0: # %entry
; LA64LARGEPIC-NEXT:    addi.d $sp, $sp, -16
; LA64LARGEPIC-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64LARGEPIC-NEXT:    pcalau12i $a0, %ld_pc_hi20(ld)
; LA64LARGEPIC-NEXT:    addi.d $t8, $zero, %got_pc_lo12(ld)
; LA64LARGEPIC-NEXT:    lu32i.d $t8, %got64_pc_lo20(ld)
; LA64LARGEPIC-NEXT:    lu52i.d $t8, $t8, %got64_pc_hi12(ld)
; LA64LARGEPIC-NEXT:    add.d $a0, $t8, $a0
; LA64LARGEPIC-NEXT:    pcalau12i $ra, %pc_hi20(__tls_get_addr)
; LA64LARGEPIC-NEXT:    addi.d $t8, $zero, %pc_lo12(__tls_get_addr)
; LA64LARGEPIC-NEXT:    lu32i.d $t8, %pc64_lo20(__tls_get_addr)
; LA64LARGEPIC-NEXT:    lu52i.d $t8, $t8, %pc64_hi12(__tls_get_addr)
; LA64LARGEPIC-NEXT:    add.d $ra, $t8, $ra
; LA64LARGEPIC-NEXT:    jirl $ra, $ra, 0
; LA64LARGEPIC-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64LARGEPIC-NEXT:    addi.d $sp, $sp, 16
; LA64LARGEPIC-NEXT:    ret
;
; LA32NOPIC-LABEL: f2:
; LA32NOPIC:       # %bb.0: # %entry
; LA32NOPIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(ld)
; LA32NOPIC-NEXT:    ld.w $a0, $a0, %ie_pc_lo12(ld)
; LA32NOPIC-NEXT:    add.w $a0, $a0, $tp
; LA32NOPIC-NEXT:    ret
;
; LA64NOPIC-LABEL: f2:
; LA64NOPIC:       # %bb.0: # %entry
; LA64NOPIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(ld)
; LA64NOPIC-NEXT:    ld.d $a0, $a0, %ie_pc_lo12(ld)
; LA64NOPIC-NEXT:    add.d $a0, $a0, $tp
; LA64NOPIC-NEXT:    ret
;
; LA64LARGENOPIC-LABEL: f2:
; LA64LARGENOPIC:       # %bb.0: # %entry
; LA64LARGENOPIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(ld)
; LA64LARGENOPIC-NEXT:    addi.d $t8, $zero, %ie_pc_lo12(ld)
; LA64LARGENOPIC-NEXT:    lu32i.d $t8, %ie64_pc_lo20(ld)
; LA64LARGENOPIC-NEXT:    lu52i.d $t8, $t8, %ie64_pc_hi12(ld)
; LA64LARGENOPIC-NEXT:    ldx.d $a0, $t8, $a0
; LA64LARGENOPIC-NEXT:    add.d $a0, $a0, $tp
; LA64LARGENOPIC-NEXT:    ret
;
; LA32DESC-LABEL: f2:
; LA32DESC:       # %bb.0: # %entry
; LA32DESC-NEXT:    addi.w $sp, $sp, -16
; LA32DESC-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32DESC-NEXT:    pcalau12i $a0, %desc_pc_hi20(ld)
; LA32DESC-NEXT:    addi.w $a0, $a0, %desc_pc_lo12(ld)
; LA32DESC-NEXT:    ld.w $ra, $a0, %desc_ld(ld)
; LA32DESC-NEXT:    jirl $ra, $ra, %desc_call(ld)
; LA32DESC-NEXT:    add.w $a0, $a0, $tp
; LA32DESC-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32DESC-NEXT:    addi.w $sp, $sp, 16
; LA32DESC-NEXT:    ret
;
; LA64DESC-LABEL: f2:
; LA64DESC:       # %bb.0: # %entry
; LA64DESC-NEXT:    addi.d $sp, $sp, -16
; LA64DESC-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64DESC-NEXT:    pcalau12i $a0, %desc_pc_hi20(ld)
; LA64DESC-NEXT:    addi.d $a0, $a0, %desc_pc_lo12(ld)
; LA64DESC-NEXT:    ld.d $ra, $a0, %desc_ld(ld)
; LA64DESC-NEXT:    jirl $ra, $ra, %desc_call(ld)
; LA64DESC-NEXT:    add.d $a0, $a0, $tp
; LA64DESC-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64DESC-NEXT:    addi.d $sp, $sp, 16
; LA64DESC-NEXT:    ret
;
; DESC64-LABEL: f2:
; DESC64:       # %bb.0: # %entry
; DESC64-NEXT:    addi.d $sp, $sp, -16
; DESC64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; DESC64-NEXT:    pcalau12i $a0, %desc_pc_hi20(ld)
; DESC64-NEXT:    addi.d $t8, $zero, %desc_pc_lo12(ld)
; DESC64-NEXT:    lu32i.d $t8, %desc64_pc_lo20(ld)
; DESC64-NEXT:    lu52i.d $t8, $t8, %desc64_pc_hi12(ld)
; DESC64-NEXT:    add.d $a0, $t8, $a0
; DESC64-NEXT:    ld.d $ra, $a0, %desc_ld(ld)
; DESC64-NEXT:    jirl $ra, $ra, %desc_call(ld)
; DESC64-NEXT:    add.d $a1, $a0, $tp
; DESC64-NEXT:    move $a0, $a1
; DESC64-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; DESC64-NEXT:    addi.d $sp, $sp, 16
; DESC64-NEXT:    ret
entry:
  ret ptr @ld
}

;; initialexec specified

define ptr @f3() nounwind {
; LA32PIC-LABEL: f3:
; LA32PIC:       # %bb.0: # %entry
; LA32PIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(ie)
; LA32PIC-NEXT:    ld.w $a0, $a0, %ie_pc_lo12(ie)
; LA32PIC-NEXT:    add.w $a0, $a0, $tp
; LA32PIC-NEXT:    ret
;
; LA64PIC-LABEL: f3:
; LA64PIC:       # %bb.0: # %entry
; LA64PIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(ie)
; LA64PIC-NEXT:    ld.d $a0, $a0, %ie_pc_lo12(ie)
; LA64PIC-NEXT:    add.d $a0, $a0, $tp
; LA64PIC-NEXT:    ret
;
; LA64LARGEPIC-LABEL: f3:
; LA64LARGEPIC:       # %bb.0: # %entry
; LA64LARGEPIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(ie)
; LA64LARGEPIC-NEXT:    addi.d $t8, $zero, %ie_pc_lo12(ie)
; LA64LARGEPIC-NEXT:    lu32i.d $t8, %ie64_pc_lo20(ie)
; LA64LARGEPIC-NEXT:    lu52i.d $t8, $t8, %ie64_pc_hi12(ie)
; LA64LARGEPIC-NEXT:    ldx.d $a0, $t8, $a0
; LA64LARGEPIC-NEXT:    add.d $a0, $a0, $tp
; LA64LARGEPIC-NEXT:    ret
;
; LA32NOPIC-LABEL: f3:
; LA32NOPIC:       # %bb.0: # %entry
; LA32NOPIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(ie)
; LA32NOPIC-NEXT:    ld.w $a0, $a0, %ie_pc_lo12(ie)
; LA32NOPIC-NEXT:    add.w $a0, $a0, $tp
; LA32NOPIC-NEXT:    ret
;
; LA64NOPIC-LABEL: f3:
; LA64NOPIC:       # %bb.0: # %entry
; LA64NOPIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(ie)
; LA64NOPIC-NEXT:    ld.d $a0, $a0, %ie_pc_lo12(ie)
; LA64NOPIC-NEXT:    add.d $a0, $a0, $tp
; LA64NOPIC-NEXT:    ret
;
; LA64LARGENOPIC-LABEL: f3:
; LA64LARGENOPIC:       # %bb.0: # %entry
; LA64LARGENOPIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(ie)
; LA64LARGENOPIC-NEXT:    addi.d $t8, $zero, %ie_pc_lo12(ie)
; LA64LARGENOPIC-NEXT:    lu32i.d $t8, %ie64_pc_lo20(ie)
; LA64LARGENOPIC-NEXT:    lu52i.d $t8, $t8, %ie64_pc_hi12(ie)
; LA64LARGENOPIC-NEXT:    ldx.d $a0, $t8, $a0
; LA64LARGENOPIC-NEXT:    add.d $a0, $a0, $tp
; LA64LARGENOPIC-NEXT:    ret
;
; LA32DESC-LABEL: f3:
; LA32DESC:       # %bb.0: # %entry
; LA32DESC-NEXT:    pcalau12i $a0, %ie_pc_hi20(ie)
; LA32DESC-NEXT:    ld.w $a0, $a0, %ie_pc_lo12(ie)
; LA32DESC-NEXT:    add.w $a0, $a0, $tp
; LA32DESC-NEXT:    ret
;
; LA64DESC-LABEL: f3:
; LA64DESC:       # %bb.0: # %entry
; LA64DESC-NEXT:    pcalau12i $a0, %ie_pc_hi20(ie)
; LA64DESC-NEXT:    ld.d $a0, $a0, %ie_pc_lo12(ie)
; LA64DESC-NEXT:    add.d $a0, $a0, $tp
; LA64DESC-NEXT:    ret
;
; DESC64-LABEL: f3:
; DESC64:       # %bb.0: # %entry
; DESC64-NEXT:    pcalau12i $a0, %ie_pc_hi20(ie)
; DESC64-NEXT:    addi.d $t8, $zero, %ie_pc_lo12(ie)
; DESC64-NEXT:    lu32i.d $t8, %ie64_pc_lo20(ie)
; DESC64-NEXT:    lu52i.d $t8, $t8, %ie64_pc_hi12(ie)
; DESC64-NEXT:    ldx.d $a0, $t8, $a0
; DESC64-NEXT:    add.d $a0, $a0, $tp
; DESC64-NEXT:    ret
entry:
  ret ptr @ie
}

;; localexec specified

define ptr @f4() nounwind {
; LA32PIC-LABEL: f4:
; LA32PIC:       # %bb.0: # %entry
; LA32PIC-NEXT:    lu12i.w $a0, %le_hi20(le)
; LA32PIC-NEXT:    ori $a0, $a0, %le_lo12(le)
; LA32PIC-NEXT:    add.w $a0, $a0, $tp
; LA32PIC-NEXT:    ret
;
; LA64PIC-LABEL: f4:
; LA64PIC:       # %bb.0: # %entry
; LA64PIC-NEXT:    lu12i.w $a0, %le_hi20(le)
; LA64PIC-NEXT:    ori $a0, $a0, %le_lo12(le)
; LA64PIC-NEXT:    add.d $a0, $a0, $tp
; LA64PIC-NEXT:    ret
;
; LA64LARGEPIC-LABEL: f4:
; LA64LARGEPIC:       # %bb.0: # %entry
; LA64LARGEPIC-NEXT:    lu12i.w $a0, %le_hi20(le)
; LA64LARGEPIC-NEXT:    ori $a0, $a0, %le_lo12(le)
; LA64LARGEPIC-NEXT:    lu32i.d $a0, %le64_lo20(le)
; LA64LARGEPIC-NEXT:    lu52i.d $a0, $a0, %le64_hi12(le)
; LA64LARGEPIC-NEXT:    add.d $a0, $a0, $tp
; LA64LARGEPIC-NEXT:    ret
;
; LA32NOPIC-LABEL: f4:
; LA32NOPIC:       # %bb.0: # %entry
; LA32NOPIC-NEXT:    lu12i.w $a0, %le_hi20(le)
; LA32NOPIC-NEXT:    ori $a0, $a0, %le_lo12(le)
; LA32NOPIC-NEXT:    add.w $a0, $a0, $tp
; LA32NOPIC-NEXT:    ret
;
; LA64NOPIC-LABEL: f4:
; LA64NOPIC:       # %bb.0: # %entry
; LA64NOPIC-NEXT:    lu12i.w $a0, %le_hi20(le)
; LA64NOPIC-NEXT:    ori $a0, $a0, %le_lo12(le)
; LA64NOPIC-NEXT:    add.d $a0, $a0, $tp
; LA64NOPIC-NEXT:    ret
;
; LA64LARGENOPIC-LABEL: f4:
; LA64LARGENOPIC:       # %bb.0: # %entry
; LA64LARGENOPIC-NEXT:    lu12i.w $a0, %le_hi20(le)
; LA64LARGENOPIC-NEXT:    ori $a0, $a0, %le_lo12(le)
; LA64LARGENOPIC-NEXT:    lu32i.d $a0, %le64_lo20(le)
; LA64LARGENOPIC-NEXT:    lu52i.d $a0, $a0, %le64_hi12(le)
; LA64LARGENOPIC-NEXT:    add.d $a0, $a0, $tp
; LA64LARGENOPIC-NEXT:    ret
;
; LA32DESC-LABEL: f4:
; LA32DESC:       # %bb.0: # %entry
; LA32DESC-NEXT:    lu12i.w $a0, %le_hi20(le)
; LA32DESC-NEXT:    ori $a0, $a0, %le_lo12(le)
; LA32DESC-NEXT:    add.w $a0, $a0, $tp
; LA32DESC-NEXT:    ret
;
; LA64DESC-LABEL: f4:
; LA64DESC:       # %bb.0: # %entry
; LA64DESC-NEXT:    lu12i.w $a0, %le_hi20(le)
; LA64DESC-NEXT:    ori $a0, $a0, %le_lo12(le)
; LA64DESC-NEXT:    add.d $a0, $a0, $tp
; LA64DESC-NEXT:    ret
;
; DESC64-LABEL: f4:
; DESC64:       # %bb.0: # %entry
; DESC64-NEXT:    lu12i.w $a0, %le_hi20(le)
; DESC64-NEXT:    ori $a0, $a0, %le_lo12(le)
; DESC64-NEXT:    lu32i.d $a0, %le64_lo20(le)
; DESC64-NEXT:    lu52i.d $a0, $a0, %le64_hi12(le)
; DESC64-NEXT:    add.d $a0, $a0, $tp
; DESC64-NEXT:    ret
entry:
  ret ptr @le
}
