; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=riscv32 -mattr=+v,+zfh,+zvfh | FileCheck %s
; RUN: llc < %s -mtriple=riscv64 -mattr=+v,+zfh,+zvfh | FileCheck %s

; Integers

define void @vector_interleave_store_v32i1_v16i1(<16 x i1> %a, <16 x i1> %b, ptr %p) {
; CHECK-LABEL: vector_interleave_store_v32i1_v16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vslideup.vi v0, v8, 2
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 16, e8, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v10, v8, 16
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vwaddu.vv v12, v8, v10
; CHECK-NEXT:    li a2, -1
; CHECK-NEXT:    vwmaccu.vx v12, a2, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vmsne.vi v8, v12, 0
; CHECK-NEXT:    vsm.v v8, (a0)
; CHECK-NEXT:    ret
  %res = call <32 x i1> @llvm.vector.interleave2.v32i1(<16 x i1> %a, <16 x i1> %b)
  store <32 x i1> %res, ptr %p
  ret void
}

; Shouldn't be lowered to vsseg because it's unaligned
define void @vector_interleave_store_v16i16_v8i16_align1(<8 x i16> %a, <8 x i16> %b, ptr %p) {
; CHECK-LABEL: vector_interleave_store_v16i16_v8i16_align1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vwaddu.vv v10, v8, v9
; CHECK-NEXT:    li a1, -1
; CHECK-NEXT:    vwmaccu.vx v10, a1, v9
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vse8.v v10, (a0)
; CHECK-NEXT:    ret
  %res = call <16 x i16> @llvm.vector.interleave2.v16i16(<8 x i16> %a, <8 x i16> %b)
  store <16 x i16> %res, ptr %p, align 1
  ret void
}

define void @vector_interleave_store_v16i16_v8i16(<8 x i16> %a, <8 x i16> %b, ptr %p) {
; CHECK-LABEL: vector_interleave_store_v16i16_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vsseg2e16.v v8, (a0)
; CHECK-NEXT:    ret
  %res = call <16 x i16> @llvm.vector.interleave2.v16i16(<8 x i16> %a, <8 x i16> %b)
  store <16 x i16> %res, ptr %p
  ret void
}

define void @vector_interleave_store_v8i32_v4i32(<4 x i32> %a, <4 x i32> %b, ptr %p) {
; CHECK-LABEL: vector_interleave_store_v8i32_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vsseg2e32.v v8, (a0)
; CHECK-NEXT:    ret
  %res = call <8 x i32> @llvm.vector.interleave2.v8i32(<4 x i32> %a, <4 x i32> %b)
  store <8 x i32> %res, ptr %p
  ret void
}

define void @vector_interleave_store_v4i64_v2i64(<2 x i64> %a, <2 x i64> %b, ptr %p) {
; CHECK-LABEL: vector_interleave_store_v4i64_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vsseg2e64.v v8, (a0)
; CHECK-NEXT:    ret
  %res = call <4 x i64> @llvm.vector.interleave2.v4i64(<2 x i64> %a, <2 x i64> %b)
  store <4 x i64> %res, ptr %p
  ret void
}

declare <32 x i1> @llvm.vector.interleave2.v32i1(<16 x i1>, <16 x i1>)
declare <16 x i16> @llvm.vector.interleave2.v16i16(<8 x i16>, <8 x i16>)
declare <8 x i32> @llvm.vector.interleave2.v8i32(<4 x i32>, <4 x i32>)
declare <4 x i64> @llvm.vector.interleave2.v4i64(<2 x i64>, <2 x i64>)

; Floats

define void @vector_interleave_store_v4f16_v2f16(<2 x half> %a, <2 x half> %b, ptr %p) {
; CHECK-LABEL: vector_interleave_store_v4f16_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vsseg2e16.v v8, (a0)
; CHECK-NEXT:    ret
  %res = call <4 x half> @llvm.vector.interleave2.v4f16(<2 x half> %a, <2 x half> %b)
  store <4 x half> %res, ptr %p
  ret void
}

define void @vector_interleave_store_v8f16_v4f16(<4 x half> %a, <4 x half> %b, ptr %p) {
; CHECK-LABEL: vector_interleave_store_v8f16_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vsseg2e16.v v8, (a0)
; CHECK-NEXT:    ret
  %res = call <8 x half> @llvm.vector.interleave2.v8f16(<4 x half> %a, <4 x half> %b)
  store <8 x half> %res, ptr %p
  ret void
}

define void @vector_interleave_store_v4f32_v2f32(<2 x float> %a, <2 x float> %b, ptr %p) {
; CHECK-LABEL: vector_interleave_store_v4f32_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vsseg2e32.v v8, (a0)
; CHECK-NEXT:    ret
  %res = call <4 x float> @llvm.vector.interleave2.v4f32(<2 x float> %a, <2 x float> %b)
  store <4 x float> %res, ptr %p
  ret void
}

define void @vector_interleave_store_v16f16_v8f16(<8 x half> %a, <8 x half> %b, ptr %p) {
; CHECK-LABEL: vector_interleave_store_v16f16_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vsseg2e16.v v8, (a0)
; CHECK-NEXT:    ret
  %res = call <16 x half> @llvm.vector.interleave2.v16f16(<8 x half> %a, <8 x half> %b)
  store <16 x half> %res, ptr %p
  ret void
}

define void @vector_interleave_store_v8f32_v4f32(<4 x float> %a, <4 x float> %b, ptr %p) {
; CHECK-LABEL: vector_interleave_store_v8f32_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vsseg2e32.v v8, (a0)
; CHECK-NEXT:    ret
  %res = call <8 x float> @llvm.vector.interleave2.v8f32(<4 x float> %a, <4 x float> %b)
  store <8 x float> %res, ptr %p
  ret void
}

define void @vector_interleave_store_v4f64_v2f64(<2 x double> %a, <2 x double> %b, ptr %p) {
; CHECK-LABEL: vector_interleave_store_v4f64_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vsseg2e64.v v8, (a0)
; CHECK-NEXT:    ret
  %res = call <4 x double> @llvm.vector.interleave2.v4f64(<2 x double> %a, <2 x double> %b)
  store <4 x double> %res, ptr %p
  ret void
}


declare <4 x half> @llvm.vector.interleave2.v4f16(<2 x half>, <2 x half>)
declare <8 x half> @llvm.vector.interleave2.v8f16(<4 x half>, <4 x half>)
declare <4 x float> @llvm.vector.interleave2.v4f32(<2 x float>, <2 x float>)
declare <16 x half> @llvm.vector.interleave2.v16f16(<8 x half>, <8 x half>)
declare <8 x float> @llvm.vector.interleave2.v8f32(<4 x float>, <4 x float>)
declare <4 x double> @llvm.vector.interleave2.v4f64(<2 x double>, <2 x double>)
