; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=mipsel-linux-gnu -mcpu=mips32r2 -O2 -relocation-model=pic \
; RUN:          -fast-isel -fast-isel-abort=1 | FileCheck %s

; FIXME: The first xor instruction is redundant.
define i1 @sel_i1(i1 %j, i1 %k, i1 %l) {
; CHECK-LABEL: sel_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor $1, $4, $zero
; CHECK-NEXT:    sltu $1, $zero, $1
; CHECK-NEXT:    andi $1, $1, 1
; CHECK-NEXT:    movn $6, $5, $1
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $6
entry:
  %cond = icmp ne i1 %j, 0
  %res = select i1 %cond, i1 %k, i1 %l
  ret i1 %res
}

; FIXME: The seb $X, $zero and xor .., .., $x   instructions are redundant.
define i8 @sel_i8(i8 %j, i8 %k, i8 %l) {
; CHECK-LABEL: sel_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    seb $1, $4
; CHECK-NEXT:    seb $2, $zero
; CHECK-NEXT:    xor $1, $1, $2
; CHECK-NEXT:    sltu $1, $zero, $1
; CHECK-NEXT:    andi $1, $1, 1
; CHECK-NEXT:    movn $6, $5, $1
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $6
entry:
  %cond = icmp ne i8 %j, 0
  %res = select i1 %cond, i8 %k, i8 %l
  ret i8 %res
}

; FIXME: The seh $X, $zero and xor .., .., $x   instructions are redundant.
define i16 @sel_i16(i16 %j, i16 %k, i16 %l) {
; CHECK-LABEL: sel_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    seh $1, $4
; CHECK-NEXT:    seh $2, $zero
; CHECK-NEXT:    xor $1, $1, $2
; CHECK-NEXT:    sltu $1, $zero, $1
; CHECK-NEXT:    andi $1, $1, 1
; CHECK-NEXT:    movn $6, $5, $1
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $6
entry:
  %cond = icmp ne i16 %j, 0
  %res = select i1 %cond, i16 %k, i16 %l
  ret i16 %res
}

; FIXME: The first xor instruction is redundant.
define i32 @sel_i32(i32 %j, i32 %k, i32 %l) {
; CHECK-LABEL: sel_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor $1, $4, $zero
; CHECK-NEXT:    sltu $1, $zero, $1
; CHECK-NEXT:    andi $1, $1, 1
; CHECK-NEXT:    movn $6, $5, $1
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $6
entry:
  %cond = icmp ne i32 %j, 0
  %res = select i1 %cond, i32 %k, i32 %l
  ret i32 %res
}

define float @sel_float(i32 %j, float %k, float %l) {
; CHECK-LABEL: sel_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtc1 $6, $f0
; CHECK-NEXT:    mtc1 $5, $f1
; CHECK-NEXT:    xor $1, $4, $zero
; CHECK-NEXT:    sltu $1, $zero, $1
; CHECK-NEXT:    andi $1, $1, 1
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    movn.s $f0, $f1, $1
entry:
  %cond = icmp ne i32 %j, 0
  %res = select i1 %cond, float %k, float %l
  ret float %res
}

define float @sel_float2(float %k, float %l, i32 %j) {
; CHECK-LABEL: sel_float2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mov.s $f0, $f14
; CHECK-NEXT:    xor $1, $6, $zero
; CHECK-NEXT:    sltu $1, $zero, $1
; CHECK-NEXT:    andi $1, $1, 1
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    movn.s $f0, $f12, $1
entry:
  %cond = icmp ne i32 %j, 0
  %res = select i1 %cond, float %k, float %l
  ret float %res
}

define double @sel_double(i32 %j, double %k, double %l) {
; CHECK-LABEL: sel_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtc1 $6, $f2
; CHECK-NEXT:    mthc1 $7, $f2
; CHECK-NEXT:    ldc1 $f0, 16($sp)
; CHECK-NEXT:    xor $1, $4, $zero
; CHECK-NEXT:    sltu $1, $zero, $1
; CHECK-NEXT:    andi $1, $1, 1
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    movn.d $f0, $f2, $1
entry:
  %cond = icmp ne i32 %j, 0
  %res = select i1 %cond, double %k, double %l
  ret double %res
}

define double @sel_double2(double %k, double %l, i32 %j) {
; CHECK-LABEL: sel_double2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mov.d $f0, $f14
; CHECK-NEXT:    lw $1, 16($sp)
; CHECK-NEXT:    xor $1, $1, $zero
; CHECK-NEXT:    sltu $1, $zero, $1
; CHECK-NEXT:    andi $1, $1, 1
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    movn.d $f0, $f12, $1
entry:
  %cond = icmp ne i32 %j, 0
  %res = select i1 %cond, double %k, double %l
  ret double %res
}
