; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -fast-isel -mtriple=i386-unknown-unknown -mattr=+avx512f,+avx512vl | FileCheck %s --check-prefix=ALL --check-prefix=X32
; RUN: llc < %s -fast-isel -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl | FileCheck %s --check-prefix=ALL --check-prefix=X64

; NOTE: This should use IR equivalent to what is generated by clang/test/CodeGen/avx512vl-builtins.c

define <4 x float> @test_mm_mask_cvtepi32_ps(<4 x float> %__W, i8 zeroext %__U, <2 x i64> %__A) {
; X32-LABEL: test_mm_mask_cvtepi32_ps:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtdq2ps %xmm1, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtepi32_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtdq2ps %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = tail call <4 x float> @llvm.x86.sse2.cvtdq2ps(<4 x i32> %0) #8
  %2 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = select <4 x i1> %extract.i, <4 x float> %1, <4 x float> %__W
  ret <4 x float> %3
}

define <4 x float> @test_mm_maskz_cvtepi32_ps(i16 zeroext %__U, <2 x i64> %__A) {
; X32-LABEL: test_mm_maskz_cvtepi32_ps:
; X32:       # %bb.0: # %entry
; X32-NEXT:    kmovw {{[0-9]+}}(%esp), %k1
; X32-NEXT:    vcvtdq2ps %xmm0, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtepi32_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtdq2ps %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %conv.i = trunc i16 %__U to i8
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = tail call <4 x float> @llvm.x86.sse2.cvtdq2ps(<4 x i32> %0) #8
  %2 = bitcast i8 %conv.i to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = select <4 x i1> %extract.i, <4 x float> %1, <4 x float> zeroinitializer
  ret <4 x float> %3
}

define <8 x float> @test_mm256_mask_cvtepi32_ps(<8 x float> %__W, i8 zeroext %__U, <4 x i64> %__A) {
; X32-LABEL: test_mm256_mask_cvtepi32_ps:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtdq2ps %ymm1, %ymm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtepi32_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtdq2ps %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = tail call <8 x float> @llvm.x86.avx.cvtdq2.ps.256(<8 x i32> %0) #8
  %2 = bitcast i8 %__U to <8 x i1>
  %3 = select <8 x i1> %2, <8 x float> %1, <8 x float> %__W
  ret <8 x float> %3
}

define <8 x float> @test_mm256_maskz_cvtepi32_ps(i16 zeroext %__U, <4 x i64> %__A) {
; X32-LABEL: test_mm256_maskz_cvtepi32_ps:
; X32:       # %bb.0: # %entry
; X32-NEXT:    kmovw {{[0-9]+}}(%esp), %k1
; X32-NEXT:    vcvtdq2ps %ymm0, %ymm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtepi32_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtdq2ps %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %conv.i = trunc i16 %__U to i8
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = tail call <8 x float> @llvm.x86.avx.cvtdq2.ps.256(<8 x i32> %0) #8
  %2 = bitcast i8 %conv.i to <8 x i1>
  %3 = select <8 x i1> %2, <8 x float> %1, <8 x float> zeroinitializer
  ret <8 x float> %3
}

define <2 x i64> @test_mm_mask_cvtpd_epi32(<2 x i64> %__W, i8 zeroext %__U, <2 x double> %__A) {
; X32-LABEL: test_mm_mask_cvtpd_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtpd2dq %xmm1, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtpd_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2dq %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__W to <4 x i32>
  %1 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtpd2dq.128(<2 x double> %__A, <4 x i32> %0, i8 %__U) #8
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_cvtpd_epi32(i8 zeroext %__U, <2 x double> %__A) {
; X32-LABEL: test_mm_maskz_cvtpd_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtpd2dq %xmm0, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtpd_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2dq %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtpd2dq.128(<2 x double> %__A, <4 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm256_mask_cvtpd_epi32(<2 x i64> %__W, i8 zeroext %__U, <4 x double> %__A) {
; X32-LABEL: test_mm256_mask_cvtpd_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtpd2dq %ymm1, %xmm0 {%k1}
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtpd_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2dq %ymm1, %xmm0 {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx.cvt.pd2dq.256(<4 x double> %__A) #8
  %1 = bitcast <2 x i64> %__W to <4 x i32>
  %2 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = select <4 x i1> %extract.i, <4 x i32> %0, <4 x i32> %1
  %4 = bitcast <4 x i32> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @test_mm256_maskz_cvtpd_epi32(i8 zeroext %__U, <4 x double> %__A) {
; X32-LABEL: test_mm256_maskz_cvtpd_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtpd2dq %ymm0, %xmm0 {%k1} {z}
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtpd_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2dq %ymm0, %xmm0 {%k1} {z}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx.cvt.pd2dq.256(<4 x double> %__A) #8
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i32> %0, <4 x i32> zeroinitializer
  %3 = bitcast <4 x i32> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <4 x float> @test_mm_mask_cvtpd_ps(<4 x float> %__W, i8 zeroext %__U, <2 x double> %__A) {
; X32-LABEL: test_mm_mask_cvtpd_ps:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtpd2ps %xmm1, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtpd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2ps %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x float> @llvm.x86.avx512.mask.cvtpd2ps(<2 x double> %__A, <4 x float> %__W, i8 %__U) #8
  ret <4 x float> %0
}

define <4 x float> @test_mm_maskz_cvtpd_ps(i8 zeroext %__U, <2 x double> %__A) {
; X32-LABEL: test_mm_maskz_cvtpd_ps:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtpd2ps %xmm0, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtpd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2ps %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x float> @llvm.x86.avx512.mask.cvtpd2ps(<2 x double> %__A, <4 x float> zeroinitializer, i8 %__U) #8
  ret <4 x float> %0
}

define <4 x float> @test_mm256_mask_cvtpd_ps(<4 x float> %__W, i8 zeroext %__U, <4 x double> %__A) {
; X32-LABEL: test_mm256_mask_cvtpd_ps:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtpd2ps %ymm1, %xmm0 {%k1}
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtpd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2ps %ymm1, %xmm0 {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x float> @llvm.x86.avx.cvt.pd2.ps.256(<4 x double> %__A) #8
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %0, <4 x float> %__W
  ret <4 x float> %2
}

define <4 x float> @test_mm256_maskz_cvtpd_ps(i8 zeroext %__U, <4 x double> %__A) {
; X32-LABEL: test_mm256_maskz_cvtpd_ps:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtpd2ps %ymm0, %xmm0 {%k1} {z}
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtpd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2ps %ymm0, %xmm0 {%k1} {z}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x float> @llvm.x86.avx.cvt.pd2.ps.256(<4 x double> %__A) #8
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x float> %0, <4 x float> zeroinitializer
  ret <4 x float> %2
}

define <2 x i64> @test_mm_cvtpd_epu32(<2 x double> %__A) {
; X32-LABEL: test_mm_cvtpd_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vcvtpd2udq %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cvtpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vcvtpd2udq %xmm0, %xmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtpd2udq.128(<2 x double> %__A, <4 x i32> zeroinitializer, i8 -1) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_mask_cvtpd_epu32(<2 x i64> %__W, i8 zeroext %__U, <2 x double> %__A) {
; X32-LABEL: test_mm_mask_cvtpd_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtpd2udq %xmm1, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2udq %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__W to <4 x i32>
  %1 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtpd2udq.128(<2 x double> %__A, <4 x i32> %0, i8 %__U) #8
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_cvtpd_epu32(i8 zeroext %__U, <2 x double> %__A) {
; X32-LABEL: test_mm_maskz_cvtpd_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtpd2udq %xmm0, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2udq %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtpd2udq.128(<2 x double> %__A, <4 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm256_cvtpd_epu32(<4 x double> %__A) {
; X32-LABEL: test_mm256_cvtpd_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vcvtpd2udq %ymm0, %xmm0
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_cvtpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vcvtpd2udq %ymm0, %xmm0
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtpd2udq.256(<4 x double> %__A, <4 x i32> zeroinitializer, i8 -1) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm256_mask_cvtpd_epu32(<2 x i64> %__W, i8 zeroext %__U, <4 x double> %__A) {
; X32-LABEL: test_mm256_mask_cvtpd_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtpd2udq %ymm1, %xmm0 {%k1}
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2udq %ymm1, %xmm0 {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__W to <4 x i32>
  %1 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtpd2udq.256(<4 x double> %__A, <4 x i32> %0, i8 %__U) #8
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm256_maskz_cvtpd_epu32(i8 zeroext %__U, <4 x double> %__A) {
; X32-LABEL: test_mm256_maskz_cvtpd_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtpd2udq %ymm0, %xmm0 {%k1} {z}
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtpd2udq %ymm0, %xmm0 {%k1} {z}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtpd2udq.256(<4 x double> %__A, <4 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_mask_cvtps_epi32(<2 x i64> %__W, i8 zeroext %__U, <4 x float> %__A) {
; X32-LABEL: test_mm_mask_cvtps_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtps2dq %xmm1, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtps_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2dq %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.sse2.cvtps2dq(<4 x float> %__A) #8
  %1 = bitcast <2 x i64> %__W to <4 x i32>
  %2 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = select <4 x i1> %extract.i, <4 x i32> %0, <4 x i32> %1
  %4 = bitcast <4 x i32> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @test_mm_maskz_cvtps_epi32(i8 zeroext %__U, <4 x float> %__A) {
; X32-LABEL: test_mm_maskz_cvtps_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtps2dq %xmm0, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtps_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2dq %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.sse2.cvtps2dq(<4 x float> %__A) #8
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i32> %0, <4 x i32> zeroinitializer
  %3 = bitcast <4 x i32> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <4 x i64> @test_mm256_mask_cvtps_epi32(<4 x i64> %__W, i8 zeroext %__U, <8 x float> %__A) {
; X32-LABEL: test_mm256_mask_cvtps_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtps2dq %ymm1, %ymm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtps_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2dq %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i32> @llvm.x86.avx.cvt.ps2dq.256(<8 x float> %__A) #8
  %1 = bitcast <4 x i64> %__W to <8 x i32>
  %2 = bitcast i8 %__U to <8 x i1>
  %3 = select <8 x i1> %2, <8 x i32> %0, <8 x i32> %1
  %4 = bitcast <8 x i32> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @test_mm256_maskz_cvtps_epi32(i8 zeroext %__U, <8 x float> %__A) {
; X32-LABEL: test_mm256_maskz_cvtps_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtps2dq %ymm0, %ymm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtps_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2dq %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i32> @llvm.x86.avx.cvt.ps2dq.256(<8 x float> %__A) #8
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i32> %0, <8 x i32> zeroinitializer
  %3 = bitcast <8 x i32> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <2 x double> @test_mm_mask_cvtps_pd(<2 x double> %__W, i8 zeroext %__U, <4 x float> %__A) local_unnamed_addr #0 {
; X32-LABEL: test_mm_mask_cvtps_pd:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtps2pd %xmm1, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtps_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2pd %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <4 x float> %__A, <4 x float> undef, <2 x i32> <i32 0, i32 1>
  %conv.i.i = fpext <2 x float> %shuffle.i.i to <2 x double>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = select <2 x i1> %extract.i, <2 x double> %conv.i.i, <2 x double> %__W
  ret <2 x double> %1
}

define <2 x double> @test_mm_maskz_cvtps_pd(i8 zeroext %__U, <4 x float> %__A) local_unnamed_addr #0 {
; X32-LABEL: test_mm_maskz_cvtps_pd:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtps2pd %xmm0, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtps_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2pd %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <4 x float> %__A, <4 x float> undef, <2 x i32> <i32 0, i32 1>
  %conv.i.i = fpext <2 x float> %shuffle.i.i to <2 x double>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = select <2 x i1> %extract.i, <2 x double> %conv.i.i, <2 x double> zeroinitializer
  ret <2 x double> %1
}

define <4 x double> @test_mm256_mask_cvtps_pd(<4 x double> %__W, i8 zeroext %__U, <4 x float> %__A) local_unnamed_addr #0 {
; X32-LABEL: test_mm256_mask_cvtps_pd:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtps2pd %xmm1, %ymm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtps_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2pd %xmm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %conv.i.i = fpext <4 x float> %__A to <4 x double>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x double> %conv.i.i, <4 x double> %__W
  ret <4 x double> %1
}

define <4 x double> @test_mm256_maskz_cvtps_pd(i8 zeroext %__U, <4 x float> %__A) local_unnamed_addr #0 {
; X32-LABEL: test_mm256_maskz_cvtps_pd:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtps2pd %xmm0, %ymm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtps_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2pd %xmm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %conv.i.i = fpext <4 x float> %__A to <4 x double>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x double> %conv.i.i, <4 x double> zeroinitializer
  ret <4 x double> %1
}

define <2 x i64> @test_mm_cvtps_epu32(<4 x float> %__A) {
; X32-LABEL: test_mm_cvtps_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vcvtps2udq %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cvtps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vcvtps2udq %xmm0, %xmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtps2udq.128(<4 x float> %__A, <4 x i32> zeroinitializer, i8 -1) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_mask_cvtps_epu32(<2 x i64> %__W, i8 zeroext %__U, <4 x float> %__A) {
; X32-LABEL: test_mm_mask_cvtps_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtps2udq %xmm1, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2udq %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__W to <4 x i32>
  %1 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtps2udq.128(<4 x float> %__A, <4 x i32> %0, i8 %__U) #8
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_cvtps_epu32(i8 zeroext %__U, <4 x float> %__A) {
; X32-LABEL: test_mm_maskz_cvtps_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtps2udq %xmm0, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2udq %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvtps2udq.128(<4 x float> %__A, <4 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <4 x i64> @test_mm256_cvtps_epu32(<8 x float> %__A) {
; X32-LABEL: test_mm256_cvtps_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vcvtps2udq %ymm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_cvtps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vcvtps2udq %ymm0, %ymm0
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i32> @llvm.x86.avx512.mask.cvtps2udq.256(<8 x float> %__A, <8 x i32> zeroinitializer, i8 -1) #8
  %1 = bitcast <8 x i32> %0 to <4 x i64>
  ret <4 x i64> %1
}

define <4 x i64> @test_mm256_mask_cvtps_epu32(<4 x i64> %__W, i8 zeroext %__U, <8 x float> %__A) {
; X32-LABEL: test_mm256_mask_cvtps_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtps2udq %ymm1, %ymm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2udq %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__W to <8 x i32>
  %1 = tail call <8 x i32> @llvm.x86.avx512.mask.cvtps2udq.256(<8 x float> %__A, <8 x i32> %0, i8 %__U) #8
  %2 = bitcast <8 x i32> %1 to <4 x i64>
  ret <4 x i64> %2
}

define <4 x i64> @test_mm256_maskz_cvtps_epu32(i8 zeroext %__U, <8 x float> %__A) {
; X32-LABEL: test_mm256_maskz_cvtps_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtps2udq %ymm0, %ymm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2udq %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i32> @llvm.x86.avx512.mask.cvtps2udq.256(<8 x float> %__A, <8 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <8 x i32> %0 to <4 x i64>
  ret <4 x i64> %1
}

define <2 x i64> @test_mm_mask_cvttpd_epi32(<2 x i64> %__W, i8 zeroext %__U, <2 x double> %__A) {
; X32-LABEL: test_mm_mask_cvttpd_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvttpd2dq %xmm1, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvttpd_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttpd2dq %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__W to <4 x i32>
  %1 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttpd2dq.128(<2 x double> %__A, <4 x i32> %0, i8 %__U) #8
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_cvttpd_epi32(i8 zeroext %__U, <2 x double> %__A) {
; X32-LABEL: test_mm_maskz_cvttpd_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvttpd2dq %xmm0, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvttpd_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttpd2dq %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttpd2dq.128(<2 x double> %__A, <4 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm256_mask_cvttpd_epi32(<2 x i64> %__W, i8 zeroext %__U, <4 x double> %__A) {
; X32-LABEL: test_mm256_mask_cvttpd_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvttpd2dq %ymm1, %xmm0 {%k1}
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvttpd_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttpd2dq %ymm1, %xmm0 {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx.cvtt.pd2dq.256(<4 x double> %__A) #8
  %1 = bitcast <2 x i64> %__W to <4 x i32>
  %2 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = select <4 x i1> %extract.i, <4 x i32> %0, <4 x i32> %1
  %4 = bitcast <4 x i32> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @test_mm256_maskz_cvttpd_epi32(i8 zeroext %__U, <4 x double> %__A) {
; X32-LABEL: test_mm256_maskz_cvttpd_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvttpd2dq %ymm0, %xmm0 {%k1} {z}
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvttpd_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttpd2dq %ymm0, %xmm0 {%k1} {z}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx.cvtt.pd2dq.256(<4 x double> %__A) #8
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i32> %0, <4 x i32> zeroinitializer
  %3 = bitcast <4 x i32> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <2 x i64> @test_mm_cvttpd_epu32(<2 x double> %__A) {
; X32-LABEL: test_mm_cvttpd_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vcvttpd2udq %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cvttpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vcvttpd2udq %xmm0, %xmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttpd2udq.128(<2 x double> %__A, <4 x i32> zeroinitializer, i8 -1) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_mask_cvttpd_epu32(<2 x i64> %__W, i8 zeroext %__U, <2 x double> %__A) {
; X32-LABEL: test_mm_mask_cvttpd_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvttpd2udq %xmm1, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvttpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttpd2udq %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__W to <4 x i32>
  %1 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttpd2udq.128(<2 x double> %__A, <4 x i32> %0, i8 %__U) #8
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_cvttpd_epu32(i8 zeroext %__U, <2 x double> %__A) {
; X32-LABEL: test_mm_maskz_cvttpd_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvttpd2udq %xmm0, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvttpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttpd2udq %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttpd2udq.128(<2 x double> %__A, <4 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm256_cvttpd_epu32(<4 x double> %__A) {
; X32-LABEL: test_mm256_cvttpd_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vcvttpd2udq %ymm0, %xmm0
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_cvttpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vcvttpd2udq %ymm0, %xmm0
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttpd2udq.256(<4 x double> %__A, <4 x i32> zeroinitializer, i8 -1) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm256_mask_cvttpd_epu32(<2 x i64> %__W, i8 zeroext %__U, <4 x double> %__A) {
; X32-LABEL: test_mm256_mask_cvttpd_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvttpd2udq %ymm1, %xmm0 {%k1}
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvttpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttpd2udq %ymm1, %xmm0 {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__W to <4 x i32>
  %1 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttpd2udq.256(<4 x double> %__A, <4 x i32> %0, i8 %__U) #8
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm256_maskz_cvttpd_epu32(i8 zeroext %__U, <4 x double> %__A) {
; X32-LABEL: test_mm256_maskz_cvttpd_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvttpd2udq %ymm0, %xmm0 {%k1} {z}
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvttpd_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttpd2udq %ymm0, %xmm0 {%k1} {z}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttpd2udq.256(<4 x double> %__A, <4 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_mask_cvttps_epi32(<2 x i64> %__W, i8 zeroext %__U, <4 x float> %__A) {
; X32-LABEL: test_mm_mask_cvttps_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvttps2dq %xmm1, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvttps_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttps2dq %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.sse2.cvttps2dq(<4 x float> %__A) #8
  %1 = bitcast <2 x i64> %__W to <4 x i32>
  %2 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = select <4 x i1> %extract.i, <4 x i32> %0, <4 x i32> %1
  %4 = bitcast <4 x i32> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @test_mm_maskz_cvttps_epi32(i8 zeroext %__U, <4 x float> %__A) {
; X32-LABEL: test_mm_maskz_cvttps_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvttps2dq %xmm0, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvttps_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttps2dq %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.sse2.cvttps2dq(<4 x float> %__A) #8
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i32> %0, <4 x i32> zeroinitializer
  %3 = bitcast <4 x i32> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <4 x i64> @test_mm256_mask_cvttps_epi32(<4 x i64> %__W, i8 zeroext %__U, <8 x float> %__A) {
; X32-LABEL: test_mm256_mask_cvttps_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvttps2dq %ymm1, %ymm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvttps_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttps2dq %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i32> @llvm.x86.avx.cvtt.ps2dq.256(<8 x float> %__A) #8
  %1 = bitcast <4 x i64> %__W to <8 x i32>
  %2 = bitcast i8 %__U to <8 x i1>
  %3 = select <8 x i1> %2, <8 x i32> %0, <8 x i32> %1
  %4 = bitcast <8 x i32> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @test_mm256_maskz_cvttps_epi32(i8 zeroext %__U, <8 x float> %__A) {
; X32-LABEL: test_mm256_maskz_cvttps_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvttps2dq %ymm0, %ymm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvttps_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttps2dq %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i32> @llvm.x86.avx.cvtt.ps2dq.256(<8 x float> %__A) #8
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i32> %0, <8 x i32> zeroinitializer
  %3 = bitcast <8 x i32> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <2 x i64> @test_mm_cvttps_epu32(<4 x float> %__A) {
; X32-LABEL: test_mm_cvttps_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vcvttps2udq %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cvttps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vcvttps2udq %xmm0, %xmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttps2udq.128(<4 x float> %__A, <4 x i32> zeroinitializer, i8 -1) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_mask_cvttps_epu32(<2 x i64> %__W, i8 zeroext %__U, <4 x float> %__A) {
; X32-LABEL: test_mm_mask_cvttps_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvttps2udq %xmm1, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvttps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttps2udq %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__W to <4 x i32>
  %1 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttps2udq.128(<4 x float> %__A, <4 x i32> %0, i8 %__U) #8
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_cvttps_epu32(i8 zeroext %__U, <4 x float> %__A) {
; X32-LABEL: test_mm_maskz_cvttps_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvttps2udq %xmm0, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvttps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttps2udq %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx512.mask.cvttps2udq.128(<4 x float> %__A, <4 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <4 x i64> @test_mm256_cvttps_epu32(<8 x float> %__A) {
; X32-LABEL: test_mm256_cvttps_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vcvttps2udq %ymm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_cvttps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vcvttps2udq %ymm0, %ymm0
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i32> @llvm.x86.avx512.mask.cvttps2udq.256(<8 x float> %__A, <8 x i32> zeroinitializer, i8 -1) #8
  %1 = bitcast <8 x i32> %0 to <4 x i64>
  ret <4 x i64> %1
}

define <4 x i64> @test_mm256_mask_cvttps_epu32(<4 x i64> %__W, i8 zeroext %__U, <8 x float> %__A) {
; X32-LABEL: test_mm256_mask_cvttps_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvttps2udq %ymm1, %ymm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvttps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttps2udq %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__W to <8 x i32>
  %1 = tail call <8 x i32> @llvm.x86.avx512.mask.cvttps2udq.256(<8 x float> %__A, <8 x i32> %0, i8 %__U) #8
  %2 = bitcast <8 x i32> %1 to <4 x i64>
  ret <4 x i64> %2
}

define <4 x i64> @test_mm256_maskz_cvttps_epu32(i8 zeroext %__U, <8 x float> %__A) {
; X32-LABEL: test_mm256_maskz_cvttps_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvttps2udq %ymm0, %ymm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvttps_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvttps2udq %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i32> @llvm.x86.avx512.mask.cvttps2udq.256(<8 x float> %__A, <8 x i32> zeroinitializer, i8 %__U) #8
  %1 = bitcast <8 x i32> %0 to <4 x i64>
  ret <4 x i64> %1
}

define <2 x double> @test_mm_cvtepu32_pd(<2 x i64> %__A) local_unnamed_addr #0 {
; X32-LABEL: test_mm_cvtepu32_pd:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vcvtudq2pd %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cvtepu32_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vcvtudq2pd %xmm0, %xmm0
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %shuffle.i = shufflevector <4 x i32> %0, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %conv.i = uitofp <2 x i32> %shuffle.i to <2 x double>
  ret <2 x double> %conv.i
}

define <2 x double> @test_mm_mask_cvtepu32_pd(<2 x double> %__W, i8 zeroext %__U, <2 x i64> %__A) local_unnamed_addr #0 {
; X32-LABEL: test_mm_mask_cvtepu32_pd:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtudq2pd %xmm1, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtepu32_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtudq2pd %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %shuffle.i.i = shufflevector <4 x i32> %0, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %conv.i.i = uitofp <2 x i32> %shuffle.i.i to <2 x double>
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %conv.i.i, <2 x double> %__W
  ret <2 x double> %2
}

define <2 x double> @test_mm_maskz_cvtepu32_pd(i8 zeroext %__U, <2 x i64> %__A) local_unnamed_addr #0 {
; X32-LABEL: test_mm_maskz_cvtepu32_pd:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtudq2pd %xmm0, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtepu32_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtudq2pd %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %shuffle.i.i = shufflevector <4 x i32> %0, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %conv.i.i = uitofp <2 x i32> %shuffle.i.i to <2 x double>
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x double> %conv.i.i, <2 x double> zeroinitializer
  ret <2 x double> %2
}

define <4 x double> @test_mm256_cvtepu32_pd(<2 x i64> %__A) local_unnamed_addr #0 {
; X32-LABEL: test_mm256_cvtepu32_pd:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vcvtudq2pd %xmm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_cvtepu32_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vcvtudq2pd %xmm0, %ymm0
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %conv.i = uitofp <4 x i32> %0 to <4 x double>
  ret <4 x double> %conv.i
}

define <4 x double> @test_mm256_mask_cvtepu32_pd(<4 x double> %__W, i8 zeroext %__U, <2 x i64> %__A) local_unnamed_addr #0 {
; X32-LABEL: test_mm256_mask_cvtepu32_pd:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtudq2pd %xmm1, %ymm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtepu32_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtudq2pd %xmm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %conv.i.i = uitofp <4 x i32> %0 to <4 x double>
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %conv.i.i, <4 x double> %__W
  ret <4 x double> %2
}

define <4 x double> @test_mm256_maskz_cvtepu32_pd(i8 zeroext %__U, <2 x i64> %__A) local_unnamed_addr #0 {
; X32-LABEL: test_mm256_maskz_cvtepu32_pd:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtudq2pd %xmm0, %ymm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtepu32_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtudq2pd %xmm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %conv.i.i = uitofp <4 x i32> %0 to <4 x double>
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x double> %conv.i.i, <4 x double> zeroinitializer
  ret <4 x double> %2
}

define <4 x float> @test_mm_cvtepu32_ps(<2 x i64> %__A) {
; X32-LABEL: test_mm_cvtepu32_ps:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vcvtudq2ps %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cvtepu32_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vcvtudq2ps %xmm0, %xmm0
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = tail call <4 x float> @llvm.x86.avx512.mask.cvtudq2ps.128(<4 x i32> %0, <4 x float> zeroinitializer, i8 -1) #8
  ret <4 x float> %1
}

define <4 x float> @test_mm_mask_cvtepu32_ps(<4 x float> %__W, i8 zeroext %__U, <2 x i64> %__A) {
; X32-LABEL: test_mm_mask_cvtepu32_ps:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtudq2ps %xmm1, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtepu32_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtudq2ps %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = tail call <4 x float> @llvm.x86.avx512.mask.cvtudq2ps.128(<4 x i32> %0, <4 x float> %__W, i8 %__U) #8
  ret <4 x float> %1
}

define <4 x float> @test_mm_maskz_cvtepu32_ps(i8 zeroext %__U, <2 x i64> %__A) {
; X32-LABEL: test_mm_maskz_cvtepu32_ps:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtudq2ps %xmm0, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtepu32_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtudq2ps %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__A to <4 x i32>
  %1 = tail call <4 x float> @llvm.x86.avx512.mask.cvtudq2ps.128(<4 x i32> %0, <4 x float> zeroinitializer, i8 %__U) #8
  ret <4 x float> %1
}

define <8 x float> @test_mm256_cvtepu32_ps(<4 x i64> %__A) {
; X32-LABEL: test_mm256_cvtepu32_ps:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vcvtudq2ps %ymm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_cvtepu32_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vcvtudq2ps %ymm0, %ymm0
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = tail call <8 x float> @llvm.x86.avx512.mask.cvtudq2ps.256(<8 x i32> %0, <8 x float> zeroinitializer, i8 -1) #8
  ret <8 x float> %1
}

define <8 x float> @test_mm256_mask_cvtepu32_ps(<8 x float> %__W, i8 zeroext %__U, <4 x i64> %__A) {
; X32-LABEL: test_mm256_mask_cvtepu32_ps:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtudq2ps %ymm1, %ymm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtepu32_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtudq2ps %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = tail call <8 x float> @llvm.x86.avx512.mask.cvtudq2ps.256(<8 x i32> %0, <8 x float> %__W, i8 %__U) #8
  ret <8 x float> %1
}

define <8 x float> @test_mm256_maskz_cvtepu32_ps(i8 zeroext %__U, <4 x i64> %__A) {
; X32-LABEL: test_mm256_maskz_cvtepu32_ps:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vcvtudq2ps %ymm0, %ymm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtepu32_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtudq2ps %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <8 x i32>
  %1 = tail call <8 x float> @llvm.x86.avx512.mask.cvtudq2ps.256(<8 x i32> %0, <8 x float> zeroinitializer, i8 %__U) #8
  ret <8 x float> %1
}

define <8 x float> @test_mm256_shuffle_f32x4(<8 x float> %__A, <8 x float> %__B) {
; X32-LABEL: test_mm256_shuffle_f32x4:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_shuffle_f32x4:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <8 x float> %__A, <8 x float> %__B, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 12, i32 13, i32 14, i32 15>
  ret <8 x float> %shuffle
}

define <8 x float> @test_mm256_mask_shuffle_f32x4(<8 x float> %__W, i8 zeroext %__U, <8 x float> %__A, <8 x float> %__B) {
; X32-LABEL: test_mm256_mask_shuffle_f32x4:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vshuff32x4 {{.*#+}} ymm0 {%k1} = ymm1[4,5,6,7],ymm2[4,5,6,7]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_shuffle_f32x4:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshuff32x4 {{.*#+}} ymm0 {%k1} = ymm1[4,5,6,7],ymm2[4,5,6,7]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <8 x float> %__A, <8 x float> %__B, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 12, i32 13, i32 14, i32 15>
  %0 = bitcast i8 %__U to <8 x i1>
  %1 = select <8 x i1> %0, <8 x float> %shuffle, <8 x float> %__W
  ret <8 x float> %1
}

define <8 x float> @test_mm256_maskz_shuffle_f32x4(i8 zeroext %__U, <8 x float> %__A, <8 x float> %__B) {
; X32-LABEL: test_mm256_maskz_shuffle_f32x4:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vshuff32x4 {{.*#+}} ymm0 {%k1} {z} = ymm0[4,5,6,7],ymm1[4,5,6,7]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_shuffle_f32x4:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshuff32x4 {{.*#+}} ymm0 {%k1} {z} = ymm0[4,5,6,7],ymm1[4,5,6,7]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <8 x float> %__A, <8 x float> %__B, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 12, i32 13, i32 14, i32 15>
  %0 = bitcast i8 %__U to <8 x i1>
  %1 = select <8 x i1> %0, <8 x float> %shuffle, <8 x float> zeroinitializer
  ret <8 x float> %1
}

define <4 x double> @test_mm256_shuffle_f64x2(<4 x double> %__A, <4 x double> %__B) {
; X32-LABEL: test_mm256_shuffle_f64x2:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_shuffle_f64x2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <4 x double> %__A, <4 x double> %__B, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  ret <4 x double> %shuffle
}

define <4 x double> @test_mm256_mask_shuffle_f64x2(<4 x double> %__W, i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B) {
; X32-LABEL: test_mm256_mask_shuffle_f64x2:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vshuff64x2 {{.*#+}} ymm0 {%k1} = ymm1[2,3],ymm2[2,3]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_shuffle_f64x2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshuff64x2 {{.*#+}} ymm0 {%k1} = ymm1[2,3],ymm2[2,3]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <4 x double> %__A, <4 x double> %__B, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract, <4 x double> %shuffle, <4 x double> %__W
  ret <4 x double> %1
}

define <4 x double> @test_mm256_maskz_shuffle_f64x2(i8 zeroext %__U, <4 x double> %__A, <4 x double> %__B) {
; X32-LABEL: test_mm256_maskz_shuffle_f64x2:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vshuff64x2 {{.*#+}} ymm0 {%k1} {z} = ymm0[2,3],ymm1[2,3]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_shuffle_f64x2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshuff64x2 {{.*#+}} ymm0 {%k1} {z} = ymm0[2,3],ymm1[2,3]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <4 x double> %__A, <4 x double> %__B, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract, <4 x double> %shuffle, <4 x double> zeroinitializer
  ret <4 x double> %1
}

define <4 x i64> @test_mm256_shuffle_i32x4(<4 x i64> %__A, <4 x i64> %__B) {
; X32-LABEL: test_mm256_shuffle_i32x4:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_shuffle_i32x4:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <4 x i64> %__A, <4 x i64> %__B, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  ret <4 x i64> %shuffle
}

define <4 x i64> @test_mm256_mask_shuffle_i32x4(<4 x i64> %__W, i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X32-LABEL: test_mm256_mask_shuffle_i32x4:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vshufi32x4 {{.*#+}} ymm0 {%k1} = ymm1[4,5,6,7],ymm2[4,5,6,7]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_shuffle_i32x4:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufi32x4 {{.*#+}} ymm0 {%k1} = ymm1[4,5,6,7],ymm2[4,5,6,7]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <4 x i64> %__A, <4 x i64> %__B, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  %0 = bitcast <4 x i64> %shuffle to <8 x i32>
  %1 = bitcast <4 x i64> %__W to <8 x i32>
  %2 = bitcast i8 %__U to <8 x i1>
  %3 = select <8 x i1> %2, <8 x i32> %0, <8 x i32> %1
  %4 = bitcast <8 x i32> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @test_mm256_maskz_shuffle_i32x4(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X32-LABEL: test_mm256_maskz_shuffle_i32x4:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vshufi32x4 {{.*#+}} ymm0 {%k1} {z} = ymm0[4,5,6,7],ymm1[4,5,6,7]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_shuffle_i32x4:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufi32x4 {{.*#+}} ymm0 {%k1} {z} = ymm0[4,5,6,7],ymm1[4,5,6,7]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <4 x i64> %__A, <4 x i64> %__B, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  %0 = bitcast <4 x i64> %shuffle to <8 x i32>
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i32> %0, <8 x i32> zeroinitializer
  %3 = bitcast <8 x i32> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <4 x i64> @test_mm256_shuffle_i64x2(<4 x i64> %__A, <4 x i64> %__B) {
; X32-LABEL: test_mm256_shuffle_i64x2:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_shuffle_i64x2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <4 x i64> %__A, <4 x i64> %__B, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  ret <4 x i64> %shuffle
}

define <4 x i64> @test_mm256_mask_shuffle_i64x2(<4 x i64> %__W, i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X32-LABEL: test_mm256_mask_shuffle_i64x2:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vshufi64x2 {{.*#+}} ymm0 {%k1} = ymm1[2,3],ymm2[2,3]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_shuffle_i64x2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufi64x2 {{.*#+}} ymm0 {%k1} = ymm1[2,3],ymm2[2,3]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <4 x i64> %__A, <4 x i64> %__B, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract, <4 x i64> %shuffle, <4 x i64> %__W
  ret <4 x i64> %1
}

define <4 x i64> @test_mm256_maskz_shuffle_i64x2(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X32-LABEL: test_mm256_maskz_shuffle_i64x2:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vshufi64x2 {{.*#+}} ymm0 {%k1} {z} = ymm0[2,3],ymm1[2,3]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_shuffle_i64x2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufi64x2 {{.*#+}} ymm0 {%k1} {z} = ymm0[2,3],ymm1[2,3]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <4 x i64> %__A, <4 x i64> %__B, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract, <4 x i64> %shuffle, <4 x i64> zeroinitializer
  ret <4 x i64> %1
}

define zeroext i8 @test_mm_test_epi32_mask(<2 x i64> %__A, <2 x i64> %__B) {
; X32-LABEL: test_mm_test_epi32_mask:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vptestmd %xmm0, %xmm1, %k0
; X32-NEXT:    kmovw %k0, %eax
; X32-NEXT:    movzbl %al, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_test_epi32_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vptestmd %xmm0, %xmm1, %k0
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    retq
entry:
  %and.i.i = and <2 x i64> %__B, %__A
  %0 = bitcast <2 x i64> %and.i.i to <4 x i32>
  %1 = icmp ne <4 x i32> %0, zeroinitializer
  %2 = shufflevector <4 x i1> %1, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = bitcast <8 x i1> %2 to i8
  ret i8 %3
}

define zeroext i8 @test_mm_mask_test_epi32_mask(i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__B) {
; X32-LABEL: test_mm_mask_test_epi32_mask:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vptestmd %xmm0, %xmm1, %k0 {%k1}
; X32-NEXT:    kmovw %k0, %eax
; X32-NEXT:    movzbl %al, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_test_epi32_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestmd %xmm0, %xmm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    retq
entry:
  %and.i.i = and <2 x i64> %__B, %__A
  %0 = bitcast <2 x i64> %and.i.i to <4 x i32>
  %1 = icmp ne <4 x i32> %0, zeroinitializer
  %2 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = and <4 x i1> %1, %extract.i
  %4 = shufflevector <4 x i1> %3, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %5 = bitcast <8 x i1> %4 to i8
  ret i8 %5
}

define zeroext i8 @test_mm256_test_epi32_mask(<4 x i64> %__A, <4 x i64> %__B) {
; X32-LABEL: test_mm256_test_epi32_mask:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vptestmd %ymm0, %ymm1, %k0
; X32-NEXT:    kmovw %k0, %eax
; X32-NEXT:    movzbl %al, %eax
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_test_epi32_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vptestmd %ymm0, %ymm1, %k0
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %and.i.i = and <4 x i64> %__B, %__A
  %0 = bitcast <4 x i64> %and.i.i to <8 x i32>
  %1 = icmp ne <8 x i32> %0, zeroinitializer
  %2 = bitcast <8 x i1> %1 to i8
  ret i8 %2
}

define zeroext i8 @test_mm256_mask_test_epi32_mask(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X32-LABEL: test_mm256_mask_test_epi32_mask:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vptestmd %ymm0, %ymm1, %k0 {%k1}
; X32-NEXT:    kmovw %k0, %eax
; X32-NEXT:    movzbl %al, %eax
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_test_epi32_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestmd %ymm0, %ymm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %and.i.i = and <4 x i64> %__B, %__A
  %0 = bitcast <4 x i64> %and.i.i to <8 x i32>
  %1 = icmp ne <8 x i32> %0, zeroinitializer
  %2 = bitcast i8 %__U to <8 x i1>
  %3 = and <8 x i1> %1, %2
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_mm_test_epi64_mask(<2 x i64> %__A, <2 x i64> %__B) {
; X32-LABEL: test_mm_test_epi64_mask:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vptestmq %xmm0, %xmm1, %k0
; X32-NEXT:    kmovw %k0, %eax
; X32-NEXT:    movzbl %al, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_test_epi64_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vptestmq %xmm0, %xmm1, %k0
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    retq
entry:
  %and.i.i = and <2 x i64> %__B, %__A
  %0 = icmp ne <2 x i64> %and.i.i, zeroinitializer
  %1 = shufflevector <2 x i1> %0, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %2 = bitcast <8 x i1> %1 to i8
  ret i8 %2
}

define zeroext i8 @test_mm_mask_test_epi64_mask(i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__B) {
; X32-LABEL: test_mm_mask_test_epi64_mask:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vptestmq %xmm0, %xmm1, %k0 {%k1}
; X32-NEXT:    kmovw %k0, %eax
; X32-NEXT:    movzbl %al, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_test_epi64_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestmq %xmm0, %xmm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    retq
entry:
  %and.i.i = and <2 x i64> %__B, %__A
  %0 = icmp ne <2 x i64> %and.i.i, zeroinitializer
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = and <2 x i1> %0, %extract.i
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_mm256_test_epi64_mask(<4 x i64> %__A, <4 x i64> %__B) {
; X32-LABEL: test_mm256_test_epi64_mask:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vptestmq %ymm0, %ymm1, %k0
; X32-NEXT:    kmovw %k0, %eax
; X32-NEXT:    movzbl %al, %eax
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_test_epi64_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vptestmq %ymm0, %ymm1, %k0
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %and.i.i = and <4 x i64> %__B, %__A
  %0 = icmp ne <4 x i64> %and.i.i, zeroinitializer
  %1 = shufflevector <4 x i1> %0, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = bitcast <8 x i1> %1 to i8
  ret i8 %2
}

define zeroext i8 @test_mm256_mask_test_epi64_mask(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X32-LABEL: test_mm256_mask_test_epi64_mask:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vptestmq %ymm0, %ymm1, %k0 {%k1}
; X32-NEXT:    kmovw %k0, %eax
; X32-NEXT:    movzbl %al, %eax
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_test_epi64_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestmq %ymm0, %ymm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %and.i.i = and <4 x i64> %__B, %__A
  %0 = icmp ne <4 x i64> %and.i.i, zeroinitializer
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = and <4 x i1> %0, %extract.i
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_mm_testn_epi32_mask(<2 x i64> %__A, <2 x i64> %__B) {
; X32-LABEL: test_mm_testn_epi32_mask:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vptestnmd %xmm0, %xmm1, %k0
; X32-NEXT:    kmovw %k0, %eax
; X32-NEXT:    movzbl %al, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_testn_epi32_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vptestnmd %xmm0, %xmm1, %k0
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    retq
entry:
  %and.i.i = and <2 x i64> %__B, %__A
  %0 = bitcast <2 x i64> %and.i.i to <4 x i32>
  %1 = icmp eq <4 x i32> %0, zeroinitializer
  %2 = shufflevector <4 x i1> %1, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = bitcast <8 x i1> %2 to i8
  ret i8 %3
}

define zeroext i8 @test_mm_mask_testn_epi32_mask(i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__B) {
; X32-LABEL: test_mm_mask_testn_epi32_mask:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vptestnmd %xmm0, %xmm1, %k0 {%k1}
; X32-NEXT:    kmovw %k0, %eax
; X32-NEXT:    movzbl %al, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_testn_epi32_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestnmd %xmm0, %xmm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    retq
entry:
  %and.i.i = and <2 x i64> %__B, %__A
  %0 = bitcast <2 x i64> %and.i.i to <4 x i32>
  %1 = icmp eq <4 x i32> %0, zeroinitializer
  %2 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = and <4 x i1> %1, %extract.i
  %4 = shufflevector <4 x i1> %3, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %5 = bitcast <8 x i1> %4 to i8
  ret i8 %5
}

define zeroext i8 @test_mm256_testn_epi32_mask(<4 x i64> %__A, <4 x i64> %__B) {
; X32-LABEL: test_mm256_testn_epi32_mask:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vptestnmd %ymm0, %ymm1, %k0
; X32-NEXT:    kmovw %k0, %eax
; X32-NEXT:    movzbl %al, %eax
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_testn_epi32_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vptestnmd %ymm0, %ymm1, %k0
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %and.i.i = and <4 x i64> %__B, %__A
  %0 = bitcast <4 x i64> %and.i.i to <8 x i32>
  %1 = icmp eq <8 x i32> %0, zeroinitializer
  %2 = bitcast <8 x i1> %1 to i8
  ret i8 %2
}

define zeroext i8 @test_mm256_mask_testn_epi32_mask(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X32-LABEL: test_mm256_mask_testn_epi32_mask:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vptestnmd %ymm0, %ymm1, %k0 {%k1}
; X32-NEXT:    kmovw %k0, %eax
; X32-NEXT:    movzbl %al, %eax
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_testn_epi32_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestnmd %ymm0, %ymm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %and.i.i = and <4 x i64> %__B, %__A
  %0 = bitcast <4 x i64> %and.i.i to <8 x i32>
  %1 = icmp eq <8 x i32> %0, zeroinitializer
  %2 = bitcast i8 %__U to <8 x i1>
  %3 = and <8 x i1> %1, %2
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_mm_testn_epi64_mask(<2 x i64> %__A, <2 x i64> %__B) {
; X32-LABEL: test_mm_testn_epi64_mask:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vptestnmq %xmm0, %xmm1, %k0
; X32-NEXT:    kmovw %k0, %eax
; X32-NEXT:    movzbl %al, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_testn_epi64_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vptestnmq %xmm0, %xmm1, %k0
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    retq
entry:
  %and.i.i = and <2 x i64> %__B, %__A
  %0 = icmp eq <2 x i64> %and.i.i, zeroinitializer
  %1 = shufflevector <2 x i1> %0, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %2 = bitcast <8 x i1> %1 to i8
  ret i8 %2
}

define zeroext i8 @test_mm_mask_testn_epi64_mask(i8 zeroext %__U, <2 x i64> %__A, <2 x i64> %__B) {
; X32-LABEL: test_mm_mask_testn_epi64_mask:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vptestnmq %xmm0, %xmm1, %k0 {%k1}
; X32-NEXT:    kmovw %k0, %eax
; X32-NEXT:    movzbl %al, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_testn_epi64_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestnmq %xmm0, %xmm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    retq
entry:
  %and.i.i = and <2 x i64> %__B, %__A
  %0 = icmp eq <2 x i64> %and.i.i, zeroinitializer
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = and <2 x i1> %0, %extract.i
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_mm256_testn_epi64_mask(<4 x i64> %__A, <4 x i64> %__B) {
; X32-LABEL: test_mm256_testn_epi64_mask:
; X32:       # %bb.0: # %entry
; X32-NEXT:    vptestnmq %ymm0, %ymm1, %k0
; X32-NEXT:    kmovw %k0, %eax
; X32-NEXT:    movzbl %al, %eax
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_testn_epi64_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vptestnmq %ymm0, %ymm1, %k0
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %and.i.i = and <4 x i64> %__B, %__A
  %0 = icmp eq <4 x i64> %and.i.i, zeroinitializer
  %1 = shufflevector <4 x i1> %0, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = bitcast <8 x i1> %1 to i8
  ret i8 %2
}

define zeroext i8 @test_mm256_mask_testn_epi64_mask(i8 zeroext %__U, <4 x i64> %__A, <4 x i64> %__B) {
; X32-LABEL: test_mm256_mask_testn_epi64_mask:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vptestnmq %ymm0, %ymm1, %k0 {%k1}
; X32-NEXT:    kmovw %k0, %eax
; X32-NEXT:    movzbl %al, %eax
; X32-NEXT:    vzeroupper
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_testn_epi64_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestnmq %ymm0, %ymm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %and.i.i = and <4 x i64> %__B, %__A
  %0 = icmp eq <4 x i64> %and.i.i, zeroinitializer
  %1 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = and <4 x i1> %0, %extract.i
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define <2 x i64> @test_mm_mask_set1_epi32(<2 x i64> %__O, i8 zeroext %__M)  {
; X32-LABEL: test_mm_mask_set1_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastd {{\.LCPI.*}}, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_set1_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd {{.*}}(%rip), %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__O to <4 x i32>
  %1 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i32> <i32 5, i32 5, i32 5, i32 5>, <4 x i32> %0
  %3 = bitcast <4 x i32> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <2 x i64> @test_mm_maskz_set1_epi32(i8 zeroext %__M) {
; X32-LABEL: test_mm_maskz_set1_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastd {{\.LCPI.*}}, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_set1_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd {{.*}}(%rip), %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x i32> <i32 5, i32 5, i32 5, i32 5>, <4 x i32> zeroinitializer
  %2 = bitcast <4 x i32> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <4 x i64> @test_mm256_mask_set1_epi32(<4 x i64> %__O, i8 zeroext %__M)  {
; X32-LABEL: test_mm256_mask_set1_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastd {{\.LCPI.*}}, %ymm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_set1_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd {{.*}}(%rip), %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__O to <8 x i32>
  %1 = bitcast i8 %__M to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i32> <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>, <8 x i32> %0
  %3 = bitcast <8 x i32> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <4 x i64> @test_mm256_maskz_set1_epi32(i8 zeroext %__M)  {
; X32-LABEL: test_mm256_maskz_set1_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastd {{\.LCPI.*}}, %ymm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_set1_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd {{.*}}(%rip), %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__M to <8 x i1>
  %1 = select <8 x i1> %0, <8 x i32> <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>, <8 x i32> zeroinitializer
  %2 = bitcast <8 x i32> %1 to <4 x i64>
  ret <4 x i64> %2
}

define <2 x i64> @test_mm_mask_set1_epi64(<2 x i64> %__O, i8 zeroext %__M, i64 %__A)  {
; X32-LABEL: test_mm_mask_set1_epi64:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X32-NEXT:    vmovd %eax, %xmm1
; X32-NEXT:    vpbroadcastb %xmm1, %xmm1
; X32-NEXT:    kmovw %ecx, %k1
; X32-NEXT:    vmovdqa64 %xmm1, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_set1_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vmovd %esi, %xmm1
; X64-NEXT:    vpbroadcastb %xmm1, %xmm1
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovdqa64 %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %conv.i = trunc i64 %__A to i8
  %vecinit.i.i = insertelement <16 x i8> undef, i8 %conv.i, i32 0
  %vecinit15.i.i = shufflevector <16 x i8> %vecinit.i.i, <16 x i8> undef, <16 x i32> zeroinitializer
  %0 = bitcast <16 x i8> %vecinit15.i.i to <2 x i64>
  %1 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x i64> %0, <2 x i64> %__O
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_set1_epi64(i8 zeroext %__M, i64 %__A)  {
; X32-LABEL: test_mm_maskz_set1_epi64:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X32-NEXT:    vmovd %eax, %xmm0
; X32-NEXT:    vpbroadcastb %xmm0, %xmm0
; X32-NEXT:    kmovw %ecx, %k1
; X32-NEXT:    vmovdqa64 %xmm0, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_set1_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vmovd %esi, %xmm0
; X64-NEXT:    vpbroadcastb %xmm0, %xmm0
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovdqa64 %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %conv.i = trunc i64 %__A to i8
  %vecinit.i.i = insertelement <16 x i8> undef, i8 %conv.i, i32 0
  %vecinit15.i.i = shufflevector <16 x i8> %vecinit.i.i, <16 x i8> undef, <16 x i32> zeroinitializer
  %0 = bitcast <16 x i8> %vecinit15.i.i to <2 x i64>
  %1 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x i64> %0, <2 x i64> zeroinitializer
  ret <2 x i64> %2
}


define <4 x i64> @test_mm256_mask_set1_epi64(<4 x i64> %__O, i8 zeroext %__M, i64 %__A) {
; X32-LABEL: test_mm256_mask_set1_epi64:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm1, %xmm1
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastq %xmm1, %ymm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_set1_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq %rsi, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %vecinit.i.i = insertelement <4 x i64> undef, i64 %__A, i32 0
  %vecinit3.i.i = shufflevector <4 x i64> %vecinit.i.i, <4 x i64> undef, <4 x i32> zeroinitializer
  %0 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x i64> %vecinit3.i.i, <4 x i64> %__O
  ret <4 x i64> %1
}

define <4 x i64> @test_mm256_maskz_set1_epi64(i8 zeroext %__M, i64 %__A)  {
; X32-LABEL: test_mm256_maskz_set1_epi64:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastq %xmm0, %ymm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_set1_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq %rsi, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %vecinit.i.i = insertelement <4 x i64> undef, i64 %__A, i32 0
  %vecinit3.i.i = shufflevector <4 x i64> %vecinit.i.i, <4 x i64> undef, <4 x i32> zeroinitializer
  %0 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x i64> %vecinit3.i.i, <4 x i64> zeroinitializer
  ret <4 x i64> %1
}

define <2 x i64> @test_mm_broadcastd_epi32(<2 x i64> %a0) {
; X32-LABEL: test_mm_broadcastd_epi32:
; X32:       # %bb.0:
; X32-NEXT:    vbroadcastss %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_broadcastd_epi32:
; X64:       # %bb.0:
; X64-NEXT:    vbroadcastss %xmm0, %xmm0
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %res0 = shufflevector <4 x i32> %arg0, <4 x i32> undef, <4 x i32> zeroinitializer
  %res1 = bitcast <4 x i32> %res0 to <2 x i64>
  ret <2 x i64> %res1
}

define <2 x i64> @test_mm_mask_broadcastd_epi32(<2 x i64> %a0, i8 %a1, <2 x i64> %a2) {
; X32-LABEL: test_mm_mask_broadcastd_epi32:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastd %xmm1, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_broadcastd_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
  %trn1 = trunc i8 %a1 to i4
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %arg1 = bitcast i4 %trn1 to <4 x i1>
  %arg2 = bitcast <2 x i64> %a2 to <4 x i32>
  %res0 = shufflevector <4 x i32> %arg2, <4 x i32> undef, <4 x i32> zeroinitializer
  %res1 = select <4 x i1> %arg1, <4 x i32> %res0, <4 x i32> %arg0
  %res2 = bitcast <4 x i32> %res1 to <2 x i64>
  ret <2 x i64> %res2
}

define <2 x i64> @test_mm_maskz_broadcastd_epi32(i8 %a0, <2 x i64> %a1) {
; X32-LABEL: test_mm_maskz_broadcastd_epi32:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastd %xmm0, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_broadcastd_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
  %trn0 = trunc i8 %a0 to i4
  %arg0 = bitcast i4 %trn0 to <4 x i1>
  %arg1 = bitcast <2 x i64> %a1 to <4 x i32>
  %res0 = shufflevector <4 x i32> %arg1, <4 x i32> undef, <4 x i32> zeroinitializer
  %res1 = select <4 x i1> %arg0, <4 x i32> %res0, <4 x i32> zeroinitializer
  %res2 = bitcast <4 x i32> %res1 to <2 x i64>
  ret <2 x i64> %res2
}

define <4 x i64> @test_mm256_broadcastd_epi32(<2 x i64> %a0) {
; X32-LABEL: test_mm256_broadcastd_epi32:
; X32:       # %bb.0:
; X32-NEXT:    vbroadcastss %xmm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_broadcastd_epi32:
; X64:       # %bb.0:
; X64-NEXT:    vbroadcastss %xmm0, %ymm0
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %res0 = shufflevector <4 x i32> %arg0, <4 x i32> undef, <8 x i32> zeroinitializer
  %res1 = bitcast <8 x i32> %res0 to <4 x i64>
  ret <4 x i64> %res1
}

define <4 x i64> @test_mm256_mask_broadcastd_epi32(<4 x i64> %a0, i8 %a1, <2 x i64> %a2) {
; X32-LABEL: test_mm256_mask_broadcastd_epi32:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastd %xmm1, %ymm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_broadcastd_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd %xmm1, %ymm0 {%k1}
; X64-NEXT:    retq
  %arg0 = bitcast <4 x i64> %a0 to <8 x i32>
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %arg2 = bitcast <2 x i64> %a2 to <4 x i32>
  %res0 = shufflevector <4 x i32> %arg2, <4 x i32> undef, <8 x i32> zeroinitializer
  %res1 = select <8 x i1> %arg1, <8 x i32> %res0, <8 x i32> %arg0
  %res2 = bitcast <8 x i32> %res1 to <4 x i64>
  ret <4 x i64> %res2
}

define <4 x i64> @test_mm256_maskz_broadcastd_epi32(i8 %a0, <2 x i64> %a1) {
; X32-LABEL: test_mm256_maskz_broadcastd_epi32:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastd %xmm0, %ymm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_broadcastd_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd %xmm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %arg1 = bitcast <2 x i64> %a1 to <4 x i32>
  %res0 = shufflevector <4 x i32> %arg1, <4 x i32> undef, <8 x i32> zeroinitializer
  %res1 = select <8 x i1> %arg0, <8 x i32> %res0, <8 x i32> zeroinitializer
  %res2 = bitcast <8 x i32> %res1 to <4 x i64>
  ret <4 x i64> %res2
}

define <2 x i64> @test_mm_broadcastq_epi64(<2 x i64> %a0) {
; X32-LABEL: test_mm_broadcastq_epi64:
; X32:       # %bb.0:
; X32-NEXT:    vpbroadcastq %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_broadcastq_epi64:
; X64:       # %bb.0:
; X64-NEXT:    vpbroadcastq %xmm0, %xmm0
; X64-NEXT:    retq
  %res = shufflevector <2 x i64> %a0, <2 x i64> undef, <2 x i32> zeroinitializer
  ret <2 x i64> %res
}

define <2 x i64> @test_mm_mask_broadcastq_epi64(<2 x i64> %a0, i8 %a1, <2 x i64> %a2) {
; X32-LABEL: test_mm_mask_broadcastq_epi64:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastq %xmm1, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_broadcastq_epi64:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
  %trn1 = trunc i8 %a1 to i2
  %arg1 = bitcast i2 %trn1 to <2 x i1>
  %res0 = shufflevector <2 x i64> %a2, <2 x i64> undef, <2 x i32> zeroinitializer
  %res1 = select <2 x i1> %arg1, <2 x i64> %res0, <2 x i64> %a0
  ret <2 x i64> %res1
}

define <2 x i64> @test_mm_maskz_broadcastq_epi64(i8 %a0, <2 x i64> %a1) {
; X32-LABEL: test_mm_maskz_broadcastq_epi64:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastq %xmm0, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_broadcastq_epi64:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
  %trn0 = trunc i8 %a0 to i2
  %arg0 = bitcast i2 %trn0 to <2 x i1>
  %res0 = shufflevector <2 x i64> %a1, <2 x i64> undef, <2 x i32> zeroinitializer
  %res1 = select <2 x i1> %arg0, <2 x i64> %res0, <2 x i64> zeroinitializer
  ret <2 x i64> %res1
}

define <4 x i64> @test_mm256_broadcastq_epi64(<2 x i64> %a0) {
; X32-LABEL: test_mm256_broadcastq_epi64:
; X32:       # %bb.0:
; X32-NEXT:    vbroadcastsd %xmm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_broadcastq_epi64:
; X64:       # %bb.0:
; X64-NEXT:    vbroadcastsd %xmm0, %ymm0
; X64-NEXT:    retq
  %res = shufflevector <2 x i64> %a0, <2 x i64> undef, <4 x i32> zeroinitializer
  ret <4 x i64> %res
}

define <4 x i64> @test_mm256_mask_broadcastq_epi64(<4 x i64> %a0, i8 %a1, <2 x i64> %a2) {
; X32-LABEL: test_mm256_mask_broadcastq_epi64:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastq %xmm1, %ymm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_broadcastq_epi64:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq %xmm1, %ymm0 {%k1}
; X64-NEXT:    retq
  %trn1 = trunc i8 %a1 to i4
  %arg1 = bitcast i4 %trn1 to <4 x i1>
  %res0 = shufflevector <2 x i64> %a2, <2 x i64> undef, <4 x i32> zeroinitializer
  %res1 = select <4 x i1> %arg1, <4 x i64> %res0, <4 x i64> %a0
  ret <4 x i64> %res1
}

define <4 x i64> @test_mm256_maskz_broadcastq_epi64(i8 %a0, <2 x i64> %a1) {
; X32-LABEL: test_mm256_maskz_broadcastq_epi64:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastq %xmm0, %ymm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_broadcastq_epi64:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq %xmm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
  %trn0 = trunc i8 %a0 to i4
  %arg0 = bitcast i4 %trn0 to <4 x i1>
  %res0 = shufflevector <2 x i64> %a1, <2 x i64> undef, <4 x i32> zeroinitializer
  %res1 = select <4 x i1> %arg0, <4 x i64> %res0, <4 x i64> zeroinitializer
  ret <4 x i64> %res1
}

define <2 x double> @test_mm_broadcastsd_pd(<2 x double> %a0) {
; X32-LABEL: test_mm_broadcastsd_pd:
; X32:       # %bb.0:
; X32-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_broadcastsd_pd:
; X64:       # %bb.0:
; X64-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; X64-NEXT:    retq
  %res = shufflevector <2 x double> %a0, <2 x double> undef, <2 x i32> zeroinitializer
  ret <2 x double> %res
}

define <2 x double> @test_mm_mask_broadcastsd_pd(<2 x double> %a0, i8 %a1, <2 x double> %a2) {
; X32-LABEL: test_mm_mask_broadcastsd_pd:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vmovddup {{.*#+}} xmm0 {%k1} = xmm1[0,0]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_broadcastsd_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovddup {{.*#+}} xmm0 {%k1} = xmm1[0,0]
; X64-NEXT:    retq
  %trn1 = trunc i8 %a1 to i2
  %arg1 = bitcast i2 %trn1 to <2 x i1>
  %res0 = shufflevector <2 x double> %a2, <2 x double> undef, <2 x i32> zeroinitializer
  %res1 = select <2 x i1> %arg1, <2 x double> %res0, <2 x double> %a0
  ret <2 x double> %res1
}

define <2 x double> @test_mm_maskz_broadcastsd_pd(i8 %a0, <2 x double> %a1) {
; X32-LABEL: test_mm_maskz_broadcastsd_pd:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vmovddup {{.*#+}} xmm0 {%k1} {z} = xmm0[0,0]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_broadcastsd_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovddup {{.*#+}} xmm0 {%k1} {z} = xmm0[0,0]
; X64-NEXT:    retq
  %trn0 = trunc i8 %a0 to i2
  %arg0 = bitcast i2 %trn0 to <2 x i1>
  %res0 = shufflevector <2 x double> %a1, <2 x double> undef, <2 x i32> zeroinitializer
  %res1 = select <2 x i1> %arg0, <2 x double> %res0, <2 x double> zeroinitializer
  ret <2 x double> %res1
}

define <4 x double> @test_mm256_broadcastsd_pd(<2 x double> %a0) {
; X32-LABEL: test_mm256_broadcastsd_pd:
; X32:       # %bb.0:
; X32-NEXT:    vbroadcastsd %xmm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_broadcastsd_pd:
; X64:       # %bb.0:
; X64-NEXT:    vbroadcastsd %xmm0, %ymm0
; X64-NEXT:    retq
  %res = shufflevector <2 x double> %a0, <2 x double> undef, <4 x i32> zeroinitializer
  ret <4 x double> %res
}

define <4 x double> @test_mm256_mask_broadcastsd_pd(<4 x double> %a0, i8 %a1, <2 x double> %a2) {
; X32-LABEL: test_mm256_mask_broadcastsd_pd:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vbroadcastsd %xmm1, %ymm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_broadcastsd_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastsd %xmm1, %ymm0 {%k1}
; X64-NEXT:    retq
  %trn1 = trunc i8 %a1 to i4
  %arg1 = bitcast i4 %trn1 to <4 x i1>
  %res0 = shufflevector <2 x double> %a2, <2 x double> undef, <4 x i32> zeroinitializer
  %res1 = select <4 x i1> %arg1, <4 x double> %res0, <4 x double> %a0
  ret <4 x double> %res1
}

define <4 x double> @test_mm256_maskz_broadcastsd_pd(i8 %a0, <2 x double> %a1) {
; X32-LABEL: test_mm256_maskz_broadcastsd_pd:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vbroadcastsd %xmm0, %ymm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_broadcastsd_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastsd %xmm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
  %trn0 = trunc i8 %a0 to i4
  %arg0 = bitcast i4 %trn0 to <4 x i1>
  %res0 = shufflevector <2 x double> %a1, <2 x double> undef, <4 x i32> zeroinitializer
  %res1 = select <4 x i1> %arg0, <4 x double> %res0, <4 x double> zeroinitializer
  ret <4 x double> %res1
}

define <4 x float> @test_mm_broadcastss_ps(<4 x float> %a0) {
; X32-LABEL: test_mm_broadcastss_ps:
; X32:       # %bb.0:
; X32-NEXT:    vbroadcastss %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_broadcastss_ps:
; X64:       # %bb.0:
; X64-NEXT:    vbroadcastss %xmm0, %xmm0
; X64-NEXT:    retq
  %res = shufflevector <4 x float> %a0, <4 x float> undef, <4 x i32> zeroinitializer
  ret <4 x float> %res
}

define <4 x float> @test_mm_mask_broadcastss_ps(<4 x float> %a0, i8 %a1, <4 x float> %a2) {
; X32-LABEL: test_mm_mask_broadcastss_ps:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vbroadcastss %xmm1, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_broadcastss_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastss %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
  %trn1 = trunc i8 %a1 to i4
  %arg1 = bitcast i4 %trn1 to <4 x i1>
  %res0 = shufflevector <4 x float> %a2, <4 x float> undef, <4 x i32> zeroinitializer
  %res1 = select <4 x i1> %arg1, <4 x float> %res0, <4 x float> %a0
  ret <4 x float> %res1
}

define <4 x float> @test_mm_maskz_broadcastss_ps(i8 %a0, <4 x float> %a1) {
; X32-LABEL: test_mm_maskz_broadcastss_ps:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vbroadcastss %xmm0, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_broadcastss_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastss %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
  %trn0 = trunc i8 %a0 to i4
  %arg0 = bitcast i4 %trn0 to <4 x i1>
  %res0 = shufflevector <4 x float> %a1, <4 x float> undef, <4 x i32> zeroinitializer
  %res1 = select <4 x i1> %arg0, <4 x float> %res0, <4 x float> zeroinitializer
  ret <4 x float> %res1
}

define <8 x float> @test_mm256_broadcastss_ps(<4 x float> %a0) {
; X32-LABEL: test_mm256_broadcastss_ps:
; X32:       # %bb.0:
; X32-NEXT:    vbroadcastss %xmm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_broadcastss_ps:
; X64:       # %bb.0:
; X64-NEXT:    vbroadcastss %xmm0, %ymm0
; X64-NEXT:    retq
  %res = shufflevector <4 x float> %a0, <4 x float> undef, <8 x i32> zeroinitializer
  ret <8 x float> %res
}

define <8 x float> @test_mm256_mask_broadcastss_ps(<8 x float> %a0, i8 %a1, <4 x float> %a2) {
; X32-LABEL: test_mm256_mask_broadcastss_ps:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vbroadcastss %xmm1, %ymm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_broadcastss_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastss %xmm1, %ymm0 {%k1}
; X64-NEXT:    retq
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %res0 = shufflevector <4 x float> %a2, <4 x float> undef, <8 x i32> zeroinitializer
  %res1 = select <8 x i1> %arg1, <8 x float> %res0, <8 x float> %a0
  ret <8 x float> %res1
}

define <8 x float> @test_mm256_maskz_broadcastss_ps(i8 %a0, <4 x float> %a1) {
; X32-LABEL: test_mm256_maskz_broadcastss_ps:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vbroadcastss %xmm0, %ymm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_broadcastss_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastss %xmm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %res0 = shufflevector <4 x float> %a1, <4 x float> undef, <8 x i32> zeroinitializer
  %res1 = select <8 x i1> %arg0, <8 x float> %res0, <8 x float> zeroinitializer
  ret <8 x float> %res1
}

define <2 x double> @test_mm_movddup_pd(<2 x double> %a0) {
; X32-LABEL: test_mm_movddup_pd:
; X32:       # %bb.0:
; X32-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_movddup_pd:
; X64:       # %bb.0:
; X64-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; X64-NEXT:    retq
  %res = shufflevector <2 x double> %a0, <2 x double> undef, <2 x i32> zeroinitializer
  ret <2 x double> %res
}

define <2 x double> @test_mm_mask_movddup_pd(<2 x double> %a0, i8 %a1, <2 x double> %a2) {
; X32-LABEL: test_mm_mask_movddup_pd:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vmovddup {{.*#+}} xmm0 {%k1} = xmm1[0,0]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_movddup_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovddup {{.*#+}} xmm0 {%k1} = xmm1[0,0]
; X64-NEXT:    retq
  %trn1 = trunc i8 %a1 to i2
  %arg1 = bitcast i2 %trn1 to <2 x i1>
  %res0 = shufflevector <2 x double> %a2, <2 x double> undef, <2 x i32> zeroinitializer
  %res1 = select <2 x i1> %arg1, <2 x double> %res0, <2 x double> %a0
  ret <2 x double> %res1
}

define <2 x double> @test_mm_maskz_movddup_pd(i8 %a0, <2 x double> %a1) {
; X32-LABEL: test_mm_maskz_movddup_pd:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vmovddup {{.*#+}} xmm0 {%k1} {z} = xmm0[0,0]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_movddup_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovddup {{.*#+}} xmm0 {%k1} {z} = xmm0[0,0]
; X64-NEXT:    retq
  %trn1 = trunc i8 %a0 to i2
  %arg0 = bitcast i2 %trn1 to <2 x i1>
  %res0 = shufflevector <2 x double> %a1, <2 x double> undef, <2 x i32> zeroinitializer
  %res1 = select <2 x i1> %arg0, <2 x double> %res0, <2 x double> zeroinitializer
  ret <2 x double> %res1
}

define <4 x double> @test_mm256_movddup_pd(<4 x double> %a0) {
; X32-LABEL: test_mm256_movddup_pd:
; X32:       # %bb.0:
; X32-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_movddup_pd:
; X64:       # %bb.0:
; X64-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2]
; X64-NEXT:    retq
  %res = shufflevector <4 x double> %a0, <4 x double> undef, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  ret <4 x double> %res
}

define <4 x double> @test_mm256_mask_movddup_pd(<4 x double> %a0, i8 %a1, <4 x double> %a2) {
; X32-LABEL: test_mm256_mask_movddup_pd:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vmovddup {{.*#+}} ymm0 {%k1} = ymm1[0,0,2,2]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_movddup_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovddup {{.*#+}} ymm0 {%k1} = ymm1[0,0,2,2]
; X64-NEXT:    retq
  %trn1 = trunc i8 %a1 to i4
  %arg1 = bitcast i4 %trn1 to <4 x i1>
  %res0 = shufflevector <4 x double> %a2, <4 x double> undef, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  %res1 = select <4 x i1> %arg1, <4 x double> %res0, <4 x double> %a0
  ret <4 x double> %res1
}

define <4 x double> @test_mm256_maskz_movddup_pd(i8 %a0, <4 x double> %a1) {
; X32-LABEL: test_mm256_maskz_movddup_pd:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vmovddup {{.*#+}} ymm0 {%k1} {z} = ymm0[0,0,2,2]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_movddup_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovddup {{.*#+}} ymm0 {%k1} {z} = ymm0[0,0,2,2]
; X64-NEXT:    retq
  %trn1 = trunc i8 %a0 to i4
  %arg0 = bitcast i4 %trn1 to <4 x i1>
  %res0 = shufflevector <4 x double> %a1, <4 x double> undef, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  %res1 = select <4 x i1> %arg0, <4 x double> %res0, <4 x double> zeroinitializer
  ret <4 x double> %res1
}

define <4 x float> @test_mm_movehdup_ps(<4 x float> %a0) {
; X32-LABEL: test_mm_movehdup_ps:
; X32:       # %bb.0:
; X32-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_movehdup_ps:
; X64:       # %bb.0:
; X64-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; X64-NEXT:    retq
  %res = shufflevector <4 x float> %a0, <4 x float> undef, <4 x i32> <i32 1, i32 1, i32 3, i32 3>
  ret <4 x float> %res
}

define <4 x float> @test_mm_mask_movehdup_ps(<4 x float> %a0, i8 %a1, <4 x float> %a2) {
; X32-LABEL: test_mm_mask_movehdup_ps:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vmovshdup {{.*#+}} xmm0 {%k1} = xmm1[1,1,3,3]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_movehdup_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovshdup {{.*#+}} xmm0 {%k1} = xmm1[1,1,3,3]
; X64-NEXT:    retq
  %trn1 = trunc i8 %a1 to i4
  %arg1 = bitcast i4 %trn1 to <4 x i1>
  %res0 = shufflevector <4 x float> %a2, <4 x float> undef, <4 x i32> <i32 1, i32 1, i32 3, i32 3>
  %res1 = select <4 x i1> %arg1, <4 x float> %res0, <4 x float> %a0
  ret <4 x float> %res1
}

define <4 x float> @test_mm_maskz_movehdup_ps(i8 %a0, <4 x float> %a1) {
; X32-LABEL: test_mm_maskz_movehdup_ps:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vmovshdup {{.*#+}} xmm0 {%k1} {z} = xmm0[1,1,3,3]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_movehdup_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovshdup {{.*#+}} xmm0 {%k1} {z} = xmm0[1,1,3,3]
; X64-NEXT:    retq
  %trn0 = trunc i8 %a0 to i4
  %arg0 = bitcast i4 %trn0 to <4 x i1>
  %res0 = shufflevector <4 x float> %a1, <4 x float> undef, <4 x i32> <i32 1, i32 1, i32 3, i32 3>
  %res1 = select <4 x i1> %arg0, <4 x float> %res0, <4 x float> zeroinitializer
  ret <4 x float> %res1
}

define <8 x float> @test_mm256_movehdup_ps(<8 x float> %a0) {
; X32-LABEL: test_mm256_movehdup_ps:
; X32:       # %bb.0:
; X32-NEXT:    vmovshdup {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_movehdup_ps:
; X64:       # %bb.0:
; X64-NEXT:    vmovshdup {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7]
; X64-NEXT:    retq
  %res = shufflevector <8 x float> %a0, <8 x float> undef, <8 x i32> <i32 1, i32 1, i32 3, i32 3, i32 5, i32 5, i32 7, i32 7>
  ret <8 x float> %res
}

define <8 x float> @test_mm256_mask_movehdup_ps(<8 x float> %a0, i8 %a1, <8 x float> %a2) {
; X32-LABEL: test_mm256_mask_movehdup_ps:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vmovshdup {{.*#+}} ymm0 {%k1} = ymm1[1,1,3,3,5,5,7,7]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_movehdup_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovshdup {{.*#+}} ymm0 {%k1} = ymm1[1,1,3,3,5,5,7,7]
; X64-NEXT:    retq
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %res0 = shufflevector <8 x float> %a2, <8 x float> undef, <8 x i32> <i32 1, i32 1, i32 3, i32 3, i32 5, i32 5, i32 7, i32 7>
  %res1 = select <8 x i1> %arg1, <8 x float> %res0, <8 x float> %a0
  ret <8 x float> %res1
}

define <8 x float> @test_mm256_maskz_movehdup_ps(i8 %a0, <8 x float> %a1) {
; X32-LABEL: test_mm256_maskz_movehdup_ps:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vmovshdup {{.*#+}} ymm0 {%k1} {z} = ymm0[1,1,3,3,5,5,7,7]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_movehdup_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovshdup {{.*#+}} ymm0 {%k1} {z} = ymm0[1,1,3,3,5,5,7,7]
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %res0 = shufflevector <8 x float> %a1, <8 x float> undef, <8 x i32> <i32 1, i32 1, i32 3, i32 3, i32 5, i32 5, i32 7, i32 7>
  %res1 = select <8 x i1> %arg0, <8 x float> %res0, <8 x float> zeroinitializer
  ret <8 x float> %res1
}

define <4 x float> @test_mm_moveldup_ps(<4 x float> %a0) {
; X32-LABEL: test_mm_moveldup_ps:
; X32:       # %bb.0:
; X32-NEXT:    vmovsldup {{.*#+}} xmm0 = xmm0[0,0,2,2]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_moveldup_ps:
; X64:       # %bb.0:
; X64-NEXT:    vmovsldup {{.*#+}} xmm0 = xmm0[0,0,2,2]
; X64-NEXT:    retq
  %res = shufflevector <4 x float> %a0, <4 x float> undef, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  ret <4 x float> %res
}

define <4 x float> @test_mm_mask_moveldup_ps(<4 x float> %a0, i8 %a1, <4 x float> %a2) {
; X32-LABEL: test_mm_mask_moveldup_ps:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vmovsldup {{.*#+}} xmm0 {%k1} = xmm1[0,0,2,2]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_moveldup_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovsldup {{.*#+}} xmm0 {%k1} = xmm1[0,0,2,2]
; X64-NEXT:    retq
  %trn1 = trunc i8 %a1 to i4
  %arg1 = bitcast i4 %trn1 to <4 x i1>
  %res0 = shufflevector <4 x float> %a2, <4 x float> undef, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  %res1 = select <4 x i1> %arg1, <4 x float> %res0, <4 x float> %a0
  ret <4 x float> %res1
}

define <4 x float> @test_mm_maskz_moveldup_ps(i8 %a0, <4 x float> %a1) {
; X32-LABEL: test_mm_maskz_moveldup_ps:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vmovsldup {{.*#+}} xmm0 {%k1} {z} = xmm0[0,0,2,2]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_moveldup_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovsldup {{.*#+}} xmm0 {%k1} {z} = xmm0[0,0,2,2]
; X64-NEXT:    retq
  %trn0 = trunc i8 %a0 to i4
  %arg0 = bitcast i4 %trn0 to <4 x i1>
  %res0 = shufflevector <4 x float> %a1, <4 x float> undef, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  %res1 = select <4 x i1> %arg0, <4 x float> %res0, <4 x float> zeroinitializer
  ret <4 x float> %res1
}

define <8 x float> @test_mm256_moveldup_ps(<8 x float> %a0) {
; X32-LABEL: test_mm256_moveldup_ps:
; X32:       # %bb.0:
; X32-NEXT:    vmovsldup {{.*#+}} ymm0 = ymm0[0,0,2,2,4,4,6,6]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_moveldup_ps:
; X64:       # %bb.0:
; X64-NEXT:    vmovsldup {{.*#+}} ymm0 = ymm0[0,0,2,2,4,4,6,6]
; X64-NEXT:    retq
  %res = shufflevector <8 x float> %a0, <8 x float> undef, <8 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6>
  ret <8 x float> %res
}

define <8 x float> @test_mm256_mask_moveldup_ps(<8 x float> %a0, i8 %a1, <8 x float> %a2) {
; X32-LABEL: test_mm256_mask_moveldup_ps:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vmovsldup {{.*#+}} ymm0 {%k1} = ymm1[0,0,2,2,4,4,6,6]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_moveldup_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovsldup {{.*#+}} ymm0 {%k1} = ymm1[0,0,2,2,4,4,6,6]
; X64-NEXT:    retq
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %res0 = shufflevector <8 x float> %a2, <8 x float> undef, <8 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6>
  %res1 = select <8 x i1> %arg1, <8 x float> %res0, <8 x float> %a0
  ret <8 x float> %res1
}

define <8 x float> @test_mm256_maskz_moveldup_ps(i8 %a0, <8 x float> %a1) {
; X32-LABEL: test_mm256_maskz_moveldup_ps:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vmovsldup {{.*#+}} ymm0 {%k1} {z} = ymm0[0,0,2,2,4,4,6,6]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_moveldup_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovsldup {{.*#+}} ymm0 {%k1} {z} = ymm0[0,0,2,2,4,4,6,6]
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %res0 = shufflevector <8 x float> %a1, <8 x float> undef, <8 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6>
  %res1 = select <8 x i1> %arg0, <8 x float> %res0, <8 x float> zeroinitializer
  ret <8 x float> %res1
}

define <4 x i64> @test_mm256_permutex_epi64(<4 x i64> %a0) {
; X32-LABEL: test_mm256_permutex_epi64:
; X32:       # %bb.0:
; X32-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,0,0,0]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_permutex_epi64:
; X64:       # %bb.0:
; X64-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,0,0,0]
; X64-NEXT:    retq
  %res = shufflevector <4 x i64> %a0, <4 x i64> undef, <4 x i32> <i32 3, i32 0, i32 0, i32 0>
  ret <4 x i64> %res
}

define <4 x i64> @test_mm256_mask_permutex_epi64(<4 x i64> %a0, i8 %a1, <4 x i64> %a2) {
; X32-LABEL: test_mm256_mask_permutex_epi64:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpermq {{.*#+}} ymm0 {%k1} = ymm1[1,0,0,0]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_permutex_epi64:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermq {{.*#+}} ymm0 {%k1} = ymm1[1,0,0,0]
; X64-NEXT:    retq
  %trn1 = trunc i8 %a1 to i4
  %arg1 = bitcast i4 %trn1 to <4 x i1>
  %res0 = shufflevector <4 x i64> %a2, <4 x i64> undef, <4 x i32> <i32 1, i32 0, i32 0, i32 0>
  %res1 = select <4 x i1> %arg1, <4 x i64> %res0, <4 x i64> %a0
  ret <4 x i64> %res1
}

define <4 x i64> @test_mm256_maskz_permutex_epi64(i8 %a0, <4 x i64> %a1) {
; X32-LABEL: test_mm256_maskz_permutex_epi64:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpermq {{.*#+}} ymm0 {%k1} {z} = ymm0[1,0,0,0]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_permutex_epi64:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermq {{.*#+}} ymm0 {%k1} {z} = ymm0[1,0,0,0]
; X64-NEXT:    retq
  %trn1 = trunc i8 %a0 to i4
  %arg0 = bitcast i4 %trn1 to <4 x i1>
  %res0 = shufflevector <4 x i64> %a1, <4 x i64> undef, <4 x i32> <i32 1, i32 0, i32 0, i32 0>
  %res1 = select <4 x i1> %arg0, <4 x i64> %res0, <4 x i64> zeroinitializer
  ret <4 x i64> %res1
}

define <4 x double> @test_mm256_permutex_pd(<4 x double> %a0) {
; X32-LABEL: test_mm256_permutex_pd:
; X32:       # %bb.0:
; X32-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,0,0,0]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_permutex_pd:
; X64:       # %bb.0:
; X64-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,0,0,0]
; X64-NEXT:    retq
  %res = shufflevector <4 x double> %a0, <4 x double> undef, <4 x i32> <i32 3, i32 0, i32 0, i32 0>
  ret <4 x double> %res
}

define <4 x double> @test_mm256_mask_permutex_pd(<4 x double> %a0, i8 %a1, <4 x double> %a2) {
; X32-LABEL: test_mm256_mask_permutex_pd:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpermpd {{.*#+}} ymm0 {%k1} = ymm1[1,0,0,0]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_permutex_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermpd {{.*#+}} ymm0 {%k1} = ymm1[1,0,0,0]
; X64-NEXT:    retq
  %trn1 = trunc i8 %a1 to i4
  %arg1 = bitcast i4 %trn1 to <4 x i1>
  %res0 = shufflevector <4 x double> %a2, <4 x double> undef, <4 x i32> <i32 1, i32 0, i32 0, i32 0>
  %res1 = select <4 x i1> %arg1, <4 x double> %res0, <4 x double> %a0
  ret <4 x double> %res1
}

define <4 x double> @test_mm256_maskz_permutex_pd(i8 %a0, <4 x double> %a1) {
; X32-LABEL: test_mm256_maskz_permutex_pd:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpermpd {{.*#+}} ymm0 {%k1} {z} = ymm0[1,0,0,0]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_permutex_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermpd {{.*#+}} ymm0 {%k1} {z} = ymm0[1,0,0,0]
; X64-NEXT:    retq
  %trn1 = trunc i8 %a0 to i4
  %arg0 = bitcast i4 %trn1 to <4 x i1>
  %res0 = shufflevector <4 x double> %a1, <4 x double> undef, <4 x i32> <i32 1, i32 0, i32 0, i32 0>
  %res1 = select <4 x i1> %arg0, <4 x double> %res0, <4 x double> zeroinitializer
  ret <4 x double> %res1
}

define <2 x double> @test_mm_shuffle_pd(<2 x double> %a0, <2 x double> %a1) {
; X32-LABEL: test_mm_shuffle_pd:
; X32:       # %bb.0:
; X32-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_shuffle_pd:
; X64:       # %bb.0:
; X64-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; X64-NEXT:    retq
  %res = shufflevector <2 x double> %a0, <2 x double> %a1, <2 x i32> <i32 1, i32 3>
  ret <2 x double> %res
}

define <2 x double> @test_mm_mask_shuffle_pd(<2 x double> %a0, i8 %a1, <2 x double> %a2, <2 x double> %a3) {
; X32-LABEL: test_mm_mask_shuffle_pd:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vunpckhpd {{.*#+}} xmm0 {%k1} = xmm1[1],xmm2[1]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_shuffle_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vunpckhpd {{.*#+}} xmm0 {%k1} = xmm1[1],xmm2[1]
; X64-NEXT:    retq
  %trn1 = trunc i8 %a1 to i2
  %arg1 = bitcast i2 %trn1 to <2 x i1>
  %res0 = shufflevector <2 x double> %a2, <2 x double> %a3, <2 x i32> <i32 1, i32 3>
  %res1 = select <2 x i1> %arg1, <2 x double> %res0, <2 x double> %a0
  ret <2 x double> %res1
}

define <2 x double> @test_mm_maskz_shuffle_pd(i8 %a0, <2 x double> %a1, <2 x double> %a2) {
; X32-LABEL: test_mm_maskz_shuffle_pd:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vunpckhpd {{.*#+}} xmm0 {%k1} {z} = xmm0[1],xmm1[1]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_shuffle_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vunpckhpd {{.*#+}} xmm0 {%k1} {z} = xmm0[1],xmm1[1]
; X64-NEXT:    retq
  %trn1 = trunc i8 %a0 to i2
  %arg0 = bitcast i2 %trn1 to <2 x i1>
  %res0 = shufflevector <2 x double> %a1, <2 x double> %a2, <2 x i32> <i32 1, i32 3>
  %res1 = select <2 x i1> %arg0, <2 x double> %res0, <2 x double> zeroinitializer
  ret <2 x double> %res1
}

define <4 x double> @test_mm256_shuffle_pd(<4 x double> %a0, <4 x double> %a1) {
; X32-LABEL: test_mm256_shuffle_pd:
; X32:       # %bb.0:
; X32-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[2],ymm1[2]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_shuffle_pd:
; X64:       # %bb.0:
; X64-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[2],ymm1[2]
; X64-NEXT:    retq
  %res = shufflevector <4 x double> %a0, <4 x double> %a1, <4 x i32> <i32 1, i32 5, i32 2, i32 6>
  ret <4 x double> %res
}

define <4 x double> @test_mm256_mask_shuffle_pd(<4 x double> %a0, i8 %a1, <4 x double> %a2, <4 x double> %a3) {
; X32-LABEL: test_mm256_mask_shuffle_pd:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vshufpd {{.*#+}} ymm0 {%k1} = ymm1[1],ymm2[1],ymm1[2],ymm2[2]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_shuffle_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufpd {{.*#+}} ymm0 {%k1} = ymm1[1],ymm2[1],ymm1[2],ymm2[2]
; X64-NEXT:    retq
  %trn1 = trunc i8 %a1 to i4
  %arg1 = bitcast i4 %trn1 to <4 x i1>
  %res0 = shufflevector <4 x double> %a2, <4 x double> %a3, <4 x i32> <i32 1, i32 5, i32 2, i32 6>
  %res1 = select <4 x i1> %arg1, <4 x double> %res0, <4 x double> %a0
  ret <4 x double> %res1
}

define <4 x double> @test_mm256_maskz_shuffle_pd(i8 %a0, <4 x double> %a1, <4 x double> %a2) {
; X32-LABEL: test_mm256_maskz_shuffle_pd:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vshufpd {{.*#+}} ymm0 {%k1} {z} = ymm0[1],ymm1[1],ymm0[2],ymm1[2]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_shuffle_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufpd {{.*#+}} ymm0 {%k1} {z} = ymm0[1],ymm1[1],ymm0[2],ymm1[2]
; X64-NEXT:    retq
  %trn1 = trunc i8 %a0 to i4
  %arg0 = bitcast i4 %trn1 to <4 x i1>
  %res0 = shufflevector <4 x double> %a1, <4 x double> %a2, <4 x i32> <i32 1, i32 5, i32 2, i32 6>
  %res1 = select <4 x i1> %arg0, <4 x double> %res0, <4 x double> zeroinitializer
  ret <4 x double> %res1
}

define <4 x float> @test_mm_shuffle_ps(<4 x float> %a0, <4 x float> %a1) {
; X32-LABEL: test_mm_shuffle_ps:
; X32:       # %bb.0:
; X32-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0,0]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_shuffle_ps:
; X64:       # %bb.0:
; X64-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0,0]
; X64-NEXT:    retq
  %res = shufflevector <4 x float> %a0, <4 x float> %a1, <4 x i32> <i32 0, i32 1, i32 4, i32 4>
  ret <4 x float> %res
}

define <4 x float> @test_mm_mask_shuffle_ps(<4 x float> %a0, i8 %a1, <4 x float> %a2, <4 x float> %a3) {
; X32-LABEL: test_mm_mask_shuffle_ps:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vshufps {{.*#+}} xmm0 {%k1} = xmm1[0,1],xmm2[0,0]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_shuffle_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufps {{.*#+}} xmm0 {%k1} = xmm1[0,1],xmm2[0,0]
; X64-NEXT:    retq
  %trn1 = trunc i8 %a1 to i4
  %arg1 = bitcast i4 %trn1 to <4 x i1>
  %res0 = shufflevector <4 x float> %a2, <4 x float> %a3, <4 x i32> <i32 0, i32 1, i32 4, i32 4>
  %res1 = select <4 x i1> %arg1, <4 x float> %res0, <4 x float> %a0
  ret <4 x float> %res1
}

define <4 x float> @test_mm_maskz_shuffle_ps(i8 %a0, <4 x float> %a1, <4 x float> %a2) {
; X32-LABEL: test_mm_maskz_shuffle_ps:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vshufps {{.*#+}} xmm0 {%k1} {z} = xmm0[0,1],xmm1[0,0]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_shuffle_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufps {{.*#+}} xmm0 {%k1} {z} = xmm0[0,1],xmm1[0,0]
; X64-NEXT:    retq
  %trn0 = trunc i8 %a0 to i4
  %arg0 = bitcast i4 %trn0 to <4 x i1>
  %res0 = shufflevector <4 x float> %a1, <4 x float> %a2, <4 x i32> <i32 0, i32 1, i32 4, i32 4>
  %res1 = select <4 x i1> %arg0, <4 x float> %res0, <4 x float> zeroinitializer
  ret <4 x float> %res1
}

define <8 x float> @test_mm256_shuffle_ps(<8 x float> %a0, <8 x float> %a1) {
; X32-LABEL: test_mm256_shuffle_ps:
; X32:       # %bb.0:
; X32-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,1],ymm1[0,0],ymm0[4,5],ymm1[4,4]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_shuffle_ps:
; X64:       # %bb.0:
; X64-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,1],ymm1[0,0],ymm0[4,5],ymm1[4,4]
; X64-NEXT:    retq
  %res = shufflevector <8 x float> %a0, <8 x float> %a1, <8 x i32> <i32 0, i32 1, i32 8, i32 8, i32 4, i32 5, i32 12, i32 12>
  ret <8 x float> %res
}

define <8 x float> @test_mm256_mask_shuffle_ps(<8 x float> %a0, i8 %a1, <8 x float> %a2, <8 x float> %a3) {
; X32-LABEL: test_mm256_mask_shuffle_ps:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vshufps {{.*#+}} ymm0 {%k1} = ymm1[0,1],ymm2[0,0],ymm1[4,5],ymm2[4,4]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_shuffle_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufps {{.*#+}} ymm0 {%k1} = ymm1[0,1],ymm2[0,0],ymm1[4,5],ymm2[4,4]
; X64-NEXT:    retq
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %res0 = shufflevector <8 x float> %a2, <8 x float> %a3, <8 x i32> <i32 0, i32 1, i32 8, i32 8, i32 4, i32 5, i32 12, i32 12>
  %res1 = select <8 x i1> %arg1, <8 x float> %res0, <8 x float> %a0
  ret <8 x float> %res1
}

define <8 x float> @test_mm256_maskz_shuffle_ps(i8 %a0, <8 x float> %a1, <8 x float> %a2) {
; X32-LABEL: test_mm256_maskz_shuffle_ps:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vshufps {{.*#+}} ymm0 {%k1} {z} = ymm0[0,1],ymm1[0,0],ymm0[4,5],ymm1[4,4]
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_shuffle_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufps {{.*#+}} ymm0 {%k1} {z} = ymm0[0,1],ymm1[0,0],ymm0[4,5],ymm1[4,4]
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %res0 = shufflevector <8 x float> %a1, <8 x float> %a2, <8 x i32> <i32 0, i32 1, i32 8, i32 8, i32 4, i32 5, i32 12, i32 12>
  %res1 = select <8 x i1> %arg0, <8 x float> %res0, <8 x float> zeroinitializer
  ret <8 x float> %res1
}

define <4 x i64> @test_mm256_mask_mul_epi32(<4 x i64> %__W, i8 zeroext %__M, <4 x i64> %__X, <4 x i64> %__Y) nounwind {
; X32-LABEL: test_mm256_mask_mul_epi32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpmuldq %ymm1, %ymm2, %ymm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_mul_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuldq %ymm1, %ymm2, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %tmp = shl <4 x i64> %__X, <i64 32, i64 32, i64 32, i64 32>
  %tmp1 = ashr exact <4 x i64> %tmp, <i64 32, i64 32, i64 32, i64 32>
  %tmp2 = shl <4 x i64> %__Y, <i64 32, i64 32, i64 32, i64 32>
  %tmp3 = ashr exact <4 x i64> %tmp2, <i64 32, i64 32, i64 32, i64 32>
  %tmp4 = mul nsw <4 x i64> %tmp3, %tmp1
  %tmp5 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %tmp5, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %tmp6 = select <4 x i1> %extract.i, <4 x i64> %tmp4, <4 x i64> %__W
  ret <4 x i64> %tmp6
}

define <4 x i64> @test_mm256_maskz_mul_epi32(i8 zeroext %__M, <4 x i64> %__X, <4 x i64> %__Y) nounwind {
; X32-LABEL: test_mm256_maskz_mul_epi32:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpmuldq %ymm0, %ymm1, %ymm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_mul_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuldq %ymm0, %ymm1, %ymm0 {%k1} {z}
; X64-NEXT:    retq
  %tmp = shl <4 x i64> %__X, <i64 32, i64 32, i64 32, i64 32>
  %tmp1 = ashr exact <4 x i64> %tmp, <i64 32, i64 32, i64 32, i64 32>
  %tmp2 = shl <4 x i64> %__Y, <i64 32, i64 32, i64 32, i64 32>
  %tmp3 = ashr exact <4 x i64> %tmp2, <i64 32, i64 32, i64 32, i64 32>
  %tmp4 = mul nsw <4 x i64> %tmp3, %tmp1
  %tmp5 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %tmp5, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %tmp6 = select <4 x i1> %extract.i, <4 x i64> %tmp4, <4 x i64> zeroinitializer
  ret <4 x i64> %tmp6
}

define <2 x i64> @test_mm_mask_mul_epi32(<2 x i64> %__W, i8 zeroext %__M, <2 x i64> %__X, <2 x i64> %__Y) nounwind {
; X32-LABEL: test_mm_mask_mul_epi32:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpmuldq %xmm1, %xmm2, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_mul_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuldq %xmm1, %xmm2, %xmm0 {%k1}
; X64-NEXT:    retq
  %tmp = shl <2 x i64> %__X, <i64 32, i64 32>
  %tmp1 = ashr exact <2 x i64> %tmp, <i64 32, i64 32>
  %tmp2 = shl <2 x i64> %__Y, <i64 32, i64 32>
  %tmp3 = ashr exact <2 x i64> %tmp2, <i64 32, i64 32>
  %tmp4 = mul nsw <2 x i64> %tmp3, %tmp1
  %tmp5 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %tmp5, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %tmp6 = select <2 x i1> %extract.i, <2 x i64> %tmp4, <2 x i64> %__W
  ret <2 x i64> %tmp6
}

define <2 x i64> @test_mm_maskz_mul_epi32(i8 zeroext %__M, <2 x i64> %__X, <2 x i64> %__Y) nounwind {
; X32-LABEL: test_mm_maskz_mul_epi32:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpmuldq %xmm0, %xmm1, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_mul_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuldq %xmm0, %xmm1, %xmm0 {%k1} {z}
; X64-NEXT:    retq
  %tmp = shl <2 x i64> %__X, <i64 32, i64 32>
  %tmp1 = ashr exact <2 x i64> %tmp, <i64 32, i64 32>
  %tmp2 = shl <2 x i64> %__Y, <i64 32, i64 32>
  %tmp3 = ashr exact <2 x i64> %tmp2, <i64 32, i64 32>
  %tmp4 = mul nsw <2 x i64> %tmp3, %tmp1
  %tmp5 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %tmp5, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %tmp6 = select <2 x i1> %extract.i, <2 x i64> %tmp4, <2 x i64> zeroinitializer
  ret <2 x i64> %tmp6
}

define <4 x i64> @test_mm256_mask_mul_epu32(<4 x i64> %__W, i8 zeroext %__M, <4 x i64> %__X, <4 x i64> %__Y) nounwind {
; X32-LABEL: test_mm256_mask_mul_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpmuludq %ymm1, %ymm2, %ymm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_mul_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuludq %ymm1, %ymm2, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %tmp = and <4 x i64> %__X, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %tmp1 = and <4 x i64> %__Y, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %tmp2 = mul nuw <4 x i64> %tmp1, %tmp
  %tmp3 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %tmp3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %tmp4 = select <4 x i1> %extract.i, <4 x i64> %tmp2, <4 x i64> %__W
  ret <4 x i64> %tmp4
}

define <4 x i64> @test_mm256_maskz_mul_epu32(i8 zeroext %__M, <4 x i64> %__X, <4 x i64> %__Y) nounwind {
; X32-LABEL: test_mm256_maskz_mul_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpmuludq %ymm0, %ymm1, %ymm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_mul_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuludq %ymm0, %ymm1, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %tmp = and <4 x i64> %__X, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %tmp1 = and <4 x i64> %__Y, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %tmp2 = mul nuw <4 x i64> %tmp1, %tmp
  %tmp3 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %tmp3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %tmp4 = select <4 x i1> %extract.i, <4 x i64> %tmp2, <4 x i64> zeroinitializer
  ret <4 x i64> %tmp4
}

define <2 x i64> @test_mm_mask_mul_epu32(<2 x i64> %__W, i8 zeroext %__M, <2 x i64> %__X, <2 x i64> %__Y) nounwind {
; X32-LABEL: test_mm_mask_mul_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpmuludq %xmm1, %xmm2, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_mul_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuludq %xmm1, %xmm2, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %tmp = and <2 x i64> %__X, <i64 4294967295, i64 4294967295>
  %tmp1 = and <2 x i64> %__Y, <i64 4294967295, i64 4294967295>
  %tmp2 = mul nuw <2 x i64> %tmp1, %tmp
  %tmp3 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %tmp3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %tmp4 = select <2 x i1> %extract.i, <2 x i64> %tmp2, <2 x i64> %__W
  ret <2 x i64> %tmp4
}

define <2 x i64> @test_mm_maskz_mul_epu32(i8 zeroext %__M, <2 x i64> %__X, <2 x i64> %__Y) nounwind {
; X32-LABEL: test_mm_maskz_mul_epu32:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpmuludq %xmm0, %xmm1, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_mul_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuludq %xmm0, %xmm1, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %tmp = and <2 x i64> %__X, <i64 4294967295, i64 4294967295>
  %tmp1 = and <2 x i64> %__Y, <i64 4294967295, i64 4294967295>
  %tmp2 = mul nuw <2 x i64> %tmp1, %tmp
  %tmp3 = bitcast i8 %__M to <8 x i1>
  %extract.i = shufflevector <8 x i1> %tmp3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %tmp4 = select <2 x i1> %extract.i, <2 x i64> %tmp2, <2 x i64> zeroinitializer
  ret <2 x i64> %tmp4
}

declare <4 x float> @llvm.x86.sse2.cvtdq2ps(<4 x i32>)
declare <8 x float> @llvm.x86.avx.cvtdq2.ps.256(<8 x i32>)
declare <4 x i32> @llvm.x86.avx512.mask.cvtpd2dq.128(<2 x double>, <4 x i32>, i8)
declare <4 x i32> @llvm.x86.avx.cvt.pd2dq.256(<4 x double>)
declare <4 x float> @llvm.x86.avx512.mask.cvtpd2ps(<2 x double>, <4 x float>, i8)
declare <4 x float> @llvm.x86.avx.cvt.pd2.ps.256(<4 x double>)
declare <4 x i32> @llvm.x86.avx512.mask.cvtpd2udq.128(<2 x double>, <4 x i32>, i8)
declare <4 x i32> @llvm.x86.avx512.mask.cvtpd2udq.256(<4 x double>, <4 x i32>, i8)
declare <4 x i32> @llvm.x86.sse2.cvtps2dq(<4 x float>)
declare <8 x i32> @llvm.x86.avx.cvt.ps2dq.256(<8 x float>)
declare <4 x i32> @llvm.x86.avx512.mask.cvtps2udq.128(<4 x float>, <4 x i32>, i8)
declare <8 x i32> @llvm.x86.avx512.mask.cvtps2udq.256(<8 x float>, <8 x i32>, i8)
declare <4 x i32> @llvm.x86.avx512.mask.cvttpd2dq.128(<2 x double>, <4 x i32>, i8)
declare <4 x i32> @llvm.x86.avx.cvtt.pd2dq.256(<4 x double>)
declare <4 x i32> @llvm.x86.avx512.mask.cvttpd2udq.128(<2 x double>, <4 x i32>, i8)
declare <4 x i32> @llvm.x86.avx512.mask.cvttpd2udq.256(<4 x double>, <4 x i32>, i8)
declare <4 x i32> @llvm.x86.sse2.cvttps2dq(<4 x float>)
declare <8 x i32> @llvm.x86.avx.cvtt.ps2dq.256(<8 x float>)
declare <4 x i32> @llvm.x86.avx512.mask.cvttps2udq.128(<4 x float>, <4 x i32>, i8)
declare <8 x i32> @llvm.x86.avx512.mask.cvttps2udq.256(<8 x float>, <8 x i32>, i8)
declare <4 x float> @llvm.x86.avx512.mask.cvtudq2ps.128(<4 x i32>, <4 x float>, i8)
declare <8 x float> @llvm.x86.avx512.mask.cvtudq2ps.256(<8 x i32>, <8 x float>, i8)

!0 = !{i32 1}
