// RUN: llvm-mc -triple i386-unknown-unknown --show-encoding %s | FileCheck %s

// CHECK: vaddpd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x58,0x54,0x02,0x40]      
vaddpd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vaddpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x58,0x54,0x02,0x40]     
vaddpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vaddpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x58,0x54,0x02,0x40]    
vaddpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddpd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x58,0x15,0xf0,0x1c,0xf0,0x1c]      
vaddpd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vaddpd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x58,0x15,0xf0,0x1c,0xf0,0x1c]     
vaddpd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vaddpd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x58,0x15,0xf0,0x1c,0xf0,0x1c]    
vaddpd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddpd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x58,0x92,0xf0,0x1c,0xf0,0x1c]      
vaddpd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vaddpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x58,0x92,0xf0,0x1c,0xf0,0x1c]     
vaddpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vaddpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x58,0x92,0xf0,0x1c,0xf0,0x1c]    
vaddpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x58,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vaddpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vaddpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x58,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vaddpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vaddpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x58,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vaddpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vaddpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x58,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vaddpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vaddpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x58,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vaddpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x58,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vaddpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddpd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x58,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vaddpd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vaddpd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x58,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vaddpd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vaddpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x58,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vaddpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vaddpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x58,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vaddpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vaddpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x58,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vaddpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x58,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vaddpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddpd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x58,0x92,0xf0,0x1c,0xf0,0x1c]      
vaddpd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vaddpd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x58,0x92,0xf0,0x1c,0xf0,0x1c]     
vaddpd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vaddpd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x58,0x92,0xf0,0x1c,0xf0,0x1c]    
vaddpd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddpd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x58,0x15,0xf0,0x1c,0xf0,0x1c]      
vaddpd 485498096, %zmm2, %zmm2 

// CHECK: vaddpd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x58,0x15,0xf0,0x1c,0xf0,0x1c]     
vaddpd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vaddpd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x58,0x15,0xf0,0x1c,0xf0,0x1c]    
vaddpd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x58,0x54,0x02,0x40]      
vaddpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vaddpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x58,0x54,0x02,0x40]     
vaddpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vaddpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x58,0x54,0x02,0x40]    
vaddpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddpd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x58,0x12]      
vaddpd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vaddpd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x58,0x12]     
vaddpd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vaddpd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x58,0x12]    
vaddpd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddpd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x58,0x12]      
vaddpd (%edx), %zmm2, %zmm2 

// CHECK: vaddpd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x58,0x12]     
vaddpd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vaddpd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x58,0x12]    
vaddpd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddpd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x38,0x58,0xd2]     
vaddpd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vaddpd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x3a,0x58,0xd2]    
vaddpd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vaddpd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xba,0x58,0xd2]   
vaddpd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddpd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x18,0x58,0xd2]     
vaddpd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vaddpd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x1a,0x58,0xd2]    
vaddpd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vaddpd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0x9a,0x58,0xd2]   
vaddpd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddpd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x58,0xd2]     
vaddpd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vaddpd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x58,0xd2]    
vaddpd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vaddpd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x58,0xd2]   
vaddpd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddpd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x78,0x58,0xd2]     
vaddpd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vaddpd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x7a,0x58,0xd2]    
vaddpd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vaddpd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xfa,0x58,0xd2]   
vaddpd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddpd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x58,0xd2]      
vaddpd %zmm2, %zmm2, %zmm2 

// CHECK: vaddpd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x58,0xd2]     
vaddpd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vaddpd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x58,0xd2]    
vaddpd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x58,0x54,0x02,0x40]      
vaddps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vaddps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x58,0x54,0x02,0x40]     
vaddps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vaddps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x58,0x54,0x02,0x40]    
vaddps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x58,0x54,0x02,0x40]      
vaddps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vaddps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x58,0x54,0x02,0x40]     
vaddps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vaddps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x58,0x54,0x02,0x40]    
vaddps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x58,0x15,0xf0,0x1c,0xf0,0x1c]      
vaddps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vaddps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x58,0x15,0xf0,0x1c,0xf0,0x1c]     
vaddps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vaddps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x58,0x15,0xf0,0x1c,0xf0,0x1c]    
vaddps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x58,0x92,0xf0,0x1c,0xf0,0x1c]      
vaddps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vaddps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x58,0x92,0xf0,0x1c,0xf0,0x1c]     
vaddps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vaddps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x58,0x92,0xf0,0x1c,0xf0,0x1c]    
vaddps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x58,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vaddps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vaddps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x58,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vaddps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vaddps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x58,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vaddps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vaddps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x58,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vaddps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vaddps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x58,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vaddps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x58,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vaddps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x58,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vaddps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vaddps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x58,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vaddps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vaddps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x58,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vaddps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vaddps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x58,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vaddps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vaddps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x58,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vaddps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x58,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vaddps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x58,0x92,0xf0,0x1c,0xf0,0x1c]      
vaddps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vaddps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x58,0x92,0xf0,0x1c,0xf0,0x1c]     
vaddps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vaddps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x58,0x92,0xf0,0x1c,0xf0,0x1c]    
vaddps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x58,0x15,0xf0,0x1c,0xf0,0x1c]      
vaddps 485498096, %zmm2, %zmm2 

// CHECK: vaddps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x58,0x15,0xf0,0x1c,0xf0,0x1c]     
vaddps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vaddps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x58,0x15,0xf0,0x1c,0xf0,0x1c]    
vaddps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x58,0x12]      
vaddps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vaddps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x58,0x12]     
vaddps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vaddps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x58,0x12]    
vaddps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x58,0x12]      
vaddps (%edx), %zmm2, %zmm2 

// CHECK: vaddps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x58,0x12]     
vaddps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vaddps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x58,0x12]    
vaddps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x38,0x58,0xd2]     
vaddps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vaddps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x3a,0x58,0xd2]    
vaddps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vaddps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xba,0x58,0xd2]   
vaddps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x18,0x58,0xd2]     
vaddps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vaddps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x1a,0x58,0xd2]    
vaddps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vaddps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x9a,0x58,0xd2]   
vaddps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x58,0xd2]     
vaddps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vaddps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x58,0xd2]    
vaddps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vaddps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x58,0xd2]   
vaddps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x78,0x58,0xd2]     
vaddps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vaddps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x7a,0x58,0xd2]    
vaddps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vaddps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xfa,0x58,0xd2]   
vaddps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vaddps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x58,0xd2]      
vaddps %zmm2, %zmm2, %zmm2 

// CHECK: vaddps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x58,0xd2]     
vaddps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vaddps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x58,0xd2]    
vaddps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignd $0, 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x58,0x03,0x54,0x02,0x40,0x00]     
valignd $0, 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: valignd $0, 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x5a,0x03,0x54,0x02,0x40,0x00]    
valignd $0, 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: valignd $0, 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xda,0x03,0x54,0x02,0x40,0x00]   
valignd $0, 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignd $0, 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x03,0x54,0x02,0x40,0x00]     
valignd $0, 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: valignd $0, 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x03,0x54,0x02,0x40,0x00]    
valignd $0, 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: valignd $0, 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x03,0x54,0x02,0x40,0x00]   
valignd $0, 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignd $0, 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x58,0x03,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
valignd $0, 485498096{1to16}, %zmm2, %zmm2 

// CHECK: valignd $0, 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x5a,0x03,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
valignd $0, 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: valignd $0, 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xda,0x03,0x15,0xf0,0x1c,0xf0,0x1c,0x00]   
valignd $0, 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignd $0, 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x58,0x03,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
valignd $0, 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: valignd $0, 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x5a,0x03,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
valignd $0, 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: valignd $0, 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xda,0x03,0x92,0xf0,0x1c,0xf0,0x1c,0x00]   
valignd $0, 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignd $0, -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x58,0x03,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
valignd $0, -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: valignd $0, 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x58,0x03,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
valignd $0, 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: valignd $0, -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x5a,0x03,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
valignd $0, -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: valignd $0, 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x5a,0x03,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
valignd $0, 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: valignd $0, -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xda,0x03,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]   
valignd $0, -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignd $0, 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xda,0x03,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]   
valignd $0, 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignd $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x03,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
valignd $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: valignd $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x03,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
valignd $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: valignd $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x03,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
valignd $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: valignd $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x03,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
valignd $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: valignd $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x03,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]   
valignd $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignd $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x03,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]   
valignd $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignd $0, 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x03,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
valignd $0, 485498096(%edx), %zmm2, %zmm2 

// CHECK: valignd $0, 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x03,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
valignd $0, 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: valignd $0, 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x03,0x92,0xf0,0x1c,0xf0,0x1c,0x00]   
valignd $0, 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignd $0, 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x03,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
valignd $0, 485498096, %zmm2, %zmm2 

// CHECK: valignd $0, 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x03,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
valignd $0, 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: valignd $0, 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x03,0x15,0xf0,0x1c,0xf0,0x1c,0x00]   
valignd $0, 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignd $0, (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x58,0x03,0x12,0x00]     
valignd $0, (%edx){1to16}, %zmm2, %zmm2 

// CHECK: valignd $0, (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x5a,0x03,0x12,0x00]    
valignd $0, (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: valignd $0, (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xda,0x03,0x12,0x00]   
valignd $0, (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignd $0, (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x03,0x12,0x00]     
valignd $0, (%edx), %zmm2, %zmm2 

// CHECK: valignd $0, (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x03,0x12,0x00]    
valignd $0, (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: valignd $0, (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x03,0x12,0x00]   
valignd $0, (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignd $0, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x03,0xd2,0x00]     
valignd $0, %zmm2, %zmm2, %zmm2 

// CHECK: valignd $0, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x03,0xd2,0x00]    
valignd $0, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: valignd $0, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x03,0xd2,0x00]   
valignd $0, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignq $0, 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x03,0x54,0x02,0x40,0x00]     
valignq $0, 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: valignq $0, 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x03,0x54,0x02,0x40,0x00]    
valignq $0, 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: valignq $0, 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xca,0x03,0x54,0x02,0x40,0x00]   
valignq $0, 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignq $0, 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x58,0x03,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
valignq $0, 485498096{1to8}, %zmm2, %zmm2 

// CHECK: valignq $0, 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x5a,0x03,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
valignq $0, 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: valignq $0, 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xda,0x03,0x15,0xf0,0x1c,0xf0,0x1c,0x00]   
valignq $0, 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignq $0, 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x58,0x03,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
valignq $0, 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: valignq $0, 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x5a,0x03,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
valignq $0, 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: valignq $0, 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xda,0x03,0x92,0xf0,0x1c,0xf0,0x1c,0x00]   
valignq $0, 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignq $0, -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x58,0x03,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
valignq $0, -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: valignq $0, 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x58,0x03,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
valignq $0, 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: valignq $0, -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x5a,0x03,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
valignq $0, -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: valignq $0, 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x5a,0x03,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
valignq $0, 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: valignq $0, -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xda,0x03,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]   
valignq $0, -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignq $0, 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xda,0x03,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]   
valignq $0, 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignq $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x03,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
valignq $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: valignq $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x03,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
valignq $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: valignq $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x03,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
valignq $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: valignq $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x03,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
valignq $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: valignq $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xca,0x03,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]   
valignq $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignq $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xca,0x03,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]   
valignq $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignq $0, 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x03,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
valignq $0, 485498096(%edx), %zmm2, %zmm2 

// CHECK: valignq $0, 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x03,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
valignq $0, 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: valignq $0, 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xca,0x03,0x92,0xf0,0x1c,0xf0,0x1c,0x00]   
valignq $0, 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignq $0, 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x03,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
valignq $0, 485498096, %zmm2, %zmm2 

// CHECK: valignq $0, 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x03,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
valignq $0, 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: valignq $0, 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xca,0x03,0x15,0xf0,0x1c,0xf0,0x1c,0x00]   
valignq $0, 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignq $0, 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x58,0x03,0x54,0x02,0x40,0x00]     
valignq $0, 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: valignq $0, 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x5a,0x03,0x54,0x02,0x40,0x00]    
valignq $0, 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: valignq $0, 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xda,0x03,0x54,0x02,0x40,0x00]   
valignq $0, 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignq $0, (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x58,0x03,0x12,0x00]     
valignq $0, (%edx){1to8}, %zmm2, %zmm2 

// CHECK: valignq $0, (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x5a,0x03,0x12,0x00]    
valignq $0, (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: valignq $0, (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xda,0x03,0x12,0x00]   
valignq $0, (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignq $0, (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x03,0x12,0x00]     
valignq $0, (%edx), %zmm2, %zmm2 

// CHECK: valignq $0, (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x03,0x12,0x00]    
valignq $0, (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: valignq $0, (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xca,0x03,0x12,0x00]   
valignq $0, (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: valignq $0, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x03,0xd2,0x00]     
valignq $0, %zmm2, %zmm2, %zmm2 

// CHECK: valignq $0, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x03,0xd2,0x00]    
valignq $0, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: valignq $0, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xca,0x03,0xd2,0x00]   
valignq $0, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vblendmpd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x65,0x54,0x02,0x40]      
vblendmpd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vblendmpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x65,0x54,0x02,0x40]     
vblendmpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vblendmpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x65,0x54,0x02,0x40]    
vblendmpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vblendmpd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x65,0x15,0xf0,0x1c,0xf0,0x1c]      
vblendmpd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vblendmpd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x65,0x15,0xf0,0x1c,0xf0,0x1c]     
vblendmpd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vblendmpd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x65,0x15,0xf0,0x1c,0xf0,0x1c]     
vblendmpd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vblendmpd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x65,0x92,0xf0,0x1c,0xf0,0x1c]      
vblendmpd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vblendmpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x65,0x92,0xf0,0x1c,0xf0,0x1c]     
vblendmpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vblendmpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x65,0x92,0xf0,0x1c,0xf0,0x1c]     
vblendmpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vblendmpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x65,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vblendmpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vblendmpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x65,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vblendmpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vblendmpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x65,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vblendmpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vblendmpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x65,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vblendmpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vblendmpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x65,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vblendmpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vblendmpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x65,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vblendmpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vblendmpd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x65,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vblendmpd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vblendmpd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x65,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vblendmpd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vblendmpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x65,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vblendmpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vblendmpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x65,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vblendmpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vblendmpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x65,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vblendmpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vblendmpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x65,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vblendmpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vblendmpd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x65,0x92,0xf0,0x1c,0xf0,0x1c]      
vblendmpd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vblendmpd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x65,0x92,0xf0,0x1c,0xf0,0x1c]     
vblendmpd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vblendmpd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x65,0x92,0xf0,0x1c,0xf0,0x1c]    
vblendmpd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vblendmpd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x65,0x15,0xf0,0x1c,0xf0,0x1c]      
vblendmpd 485498096, %zmm2, %zmm2 

// CHECK: vblendmpd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x65,0x15,0xf0,0x1c,0xf0,0x1c]     
vblendmpd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vblendmpd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x65,0x15,0xf0,0x1c,0xf0,0x1c]    
vblendmpd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vblendmpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x65,0x54,0x02,0x40]      
vblendmpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vblendmpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x65,0x54,0x02,0x40]     
vblendmpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vblendmpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x65,0x54,0x02,0x40]     
vblendmpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vblendmpd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x65,0x12]      
vblendmpd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vblendmpd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x65,0x12]     
vblendmpd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vblendmpd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x65,0x12]     
vblendmpd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vblendmpd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x65,0x12]      
vblendmpd (%edx), %zmm2, %zmm2 

// CHECK: vblendmpd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x65,0x12]     
vblendmpd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vblendmpd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x65,0x12]    
vblendmpd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vblendmpd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x65,0xd2]      
vblendmpd %zmm2, %zmm2, %zmm2 

// CHECK: vblendmpd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x65,0xd2]     
vblendmpd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vblendmpd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x65,0xd2]    
vblendmpd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vblendmps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x65,0x54,0x02,0x40]      
vblendmps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vblendmps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x65,0x54,0x02,0x40]     
vblendmps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vblendmps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x65,0x54,0x02,0x40]     
vblendmps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vblendmps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x65,0x54,0x02,0x40]      
vblendmps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vblendmps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x65,0x54,0x02,0x40]     
vblendmps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vblendmps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x65,0x54,0x02,0x40]    
vblendmps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vblendmps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x65,0x15,0xf0,0x1c,0xf0,0x1c]      
vblendmps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vblendmps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x65,0x15,0xf0,0x1c,0xf0,0x1c]     
vblendmps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vblendmps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x65,0x15,0xf0,0x1c,0xf0,0x1c]     
vblendmps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vblendmps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x65,0x92,0xf0,0x1c,0xf0,0x1c]      
vblendmps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vblendmps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x65,0x92,0xf0,0x1c,0xf0,0x1c]     
vblendmps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vblendmps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x65,0x92,0xf0,0x1c,0xf0,0x1c]     
vblendmps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vblendmps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x65,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vblendmps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vblendmps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x65,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vblendmps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vblendmps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x65,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vblendmps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vblendmps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x65,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vblendmps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vblendmps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x65,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vblendmps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vblendmps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x65,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vblendmps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vblendmps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x65,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vblendmps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vblendmps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x65,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vblendmps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vblendmps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x65,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vblendmps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vblendmps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x65,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vblendmps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vblendmps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x65,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vblendmps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vblendmps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x65,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vblendmps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vblendmps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x65,0x92,0xf0,0x1c,0xf0,0x1c]      
vblendmps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vblendmps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x65,0x92,0xf0,0x1c,0xf0,0x1c]     
vblendmps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vblendmps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x65,0x92,0xf0,0x1c,0xf0,0x1c]    
vblendmps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vblendmps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x65,0x15,0xf0,0x1c,0xf0,0x1c]      
vblendmps 485498096, %zmm2, %zmm2 

// CHECK: vblendmps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x65,0x15,0xf0,0x1c,0xf0,0x1c]     
vblendmps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vblendmps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x65,0x15,0xf0,0x1c,0xf0,0x1c]    
vblendmps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vblendmps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x65,0x12]      
vblendmps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vblendmps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x65,0x12]     
vblendmps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vblendmps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x65,0x12]     
vblendmps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vblendmps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x65,0x12]      
vblendmps (%edx), %zmm2, %zmm2 

// CHECK: vblendmps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x65,0x12]     
vblendmps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vblendmps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x65,0x12]    
vblendmps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vblendmps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x65,0xd2]      
vblendmps %zmm2, %zmm2, %zmm2 

// CHECK: vblendmps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x65,0xd2]     
vblendmps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vblendmps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x65,0xd2]    
vblendmps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vbroadcastf32x4 1024(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x1a,0x54,0x02,0x40]       
vbroadcastf32x4 1024(%edx,%eax), %zmm2 

// CHECK: vbroadcastf32x4 1024(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x1a,0x54,0x02,0x40]      
vbroadcastf32x4 1024(%edx,%eax), %zmm2 {%k2} 

// CHECK: vbroadcastf32x4 1024(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x1a,0x54,0x02,0x40]     
vbroadcastf32x4 1024(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vbroadcastf32x4 -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x1a,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vbroadcastf32x4 -485498096(%edx,%eax,4), %zmm2 

// CHECK: vbroadcastf32x4 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x1a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vbroadcastf32x4 485498096(%edx,%eax,4), %zmm2 

// CHECK: vbroadcastf32x4 -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x1a,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vbroadcastf32x4 -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vbroadcastf32x4 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x1a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vbroadcastf32x4 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vbroadcastf32x4 -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x1a,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vbroadcastf32x4 -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vbroadcastf32x4 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x1a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vbroadcastf32x4 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vbroadcastf32x4 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x1a,0x92,0xf0,0x1c,0xf0,0x1c]       
vbroadcastf32x4 485498096(%edx), %zmm2 

// CHECK: vbroadcastf32x4 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x1a,0x92,0xf0,0x1c,0xf0,0x1c]      
vbroadcastf32x4 485498096(%edx), %zmm2 {%k2} 

// CHECK: vbroadcastf32x4 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x1a,0x92,0xf0,0x1c,0xf0,0x1c]     
vbroadcastf32x4 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vbroadcastf32x4 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x1a,0x15,0xf0,0x1c,0xf0,0x1c]       
vbroadcastf32x4 485498096, %zmm2 

// CHECK: vbroadcastf32x4 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x1a,0x15,0xf0,0x1c,0xf0,0x1c]      
vbroadcastf32x4 485498096, %zmm2 {%k2} 

// CHECK: vbroadcastf32x4 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x1a,0x15,0xf0,0x1c,0xf0,0x1c]     
vbroadcastf32x4 485498096, %zmm2 {%k2} {z} 

// CHECK: vbroadcastf32x4 (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x1a,0x12]       
vbroadcastf32x4 (%edx), %zmm2 

// CHECK: vbroadcastf32x4 (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x1a,0x12]      
vbroadcastf32x4 (%edx), %zmm2 {%k2} 

// CHECK: vbroadcastf32x4 (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x1a,0x12]     
vbroadcastf32x4 (%edx), %zmm2 {%k2} {z} 

// CHECK: vbroadcastf32x8 2048(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x1b,0x54,0x02,0x40]       
vbroadcastf32x8 2048(%edx,%eax), %zmm2 

// CHECK: vbroadcastf32x8 2048(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x1b,0x54,0x02,0x40]      
vbroadcastf32x8 2048(%edx,%eax), %zmm2 {%k2} 

// CHECK: vbroadcastf32x8 2048(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x1b,0x54,0x02,0x40]     
vbroadcastf32x8 2048(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vbroadcastf32x8 -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x1b,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vbroadcastf32x8 -485498096(%edx,%eax,4), %zmm2 

// CHECK: vbroadcastf32x8 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x1b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vbroadcastf32x8 485498096(%edx,%eax,4), %zmm2 

// CHECK: vbroadcastf32x8 -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x1b,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vbroadcastf32x8 -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vbroadcastf32x8 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x1b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vbroadcastf32x8 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vbroadcastf32x8 -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x1b,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vbroadcastf32x8 -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vbroadcastf32x8 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x1b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vbroadcastf32x8 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vbroadcastf32x8 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x1b,0x92,0xf0,0x1c,0xf0,0x1c]       
vbroadcastf32x8 485498096(%edx), %zmm2 

// CHECK: vbroadcastf32x8 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x1b,0x92,0xf0,0x1c,0xf0,0x1c]      
vbroadcastf32x8 485498096(%edx), %zmm2 {%k2} 

// CHECK: vbroadcastf32x8 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x1b,0x92,0xf0,0x1c,0xf0,0x1c]     
vbroadcastf32x8 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vbroadcastf32x8 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x1b,0x15,0xf0,0x1c,0xf0,0x1c]       
vbroadcastf32x8 485498096, %zmm2 

// CHECK: vbroadcastf32x8 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x1b,0x15,0xf0,0x1c,0xf0,0x1c]      
vbroadcastf32x8 485498096, %zmm2 {%k2} 

// CHECK: vbroadcastf32x8 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x1b,0x15,0xf0,0x1c,0xf0,0x1c]     
vbroadcastf32x8 485498096, %zmm2 {%k2} {z} 

// CHECK: vbroadcastf32x8 (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x1b,0x12]       
vbroadcastf32x8 (%edx), %zmm2 

// CHECK: vbroadcastf32x8 (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x1b,0x12]      
vbroadcastf32x8 (%edx), %zmm2 {%k2} 

// CHECK: vbroadcastf32x8 (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x1b,0x12]     
vbroadcastf32x8 (%edx), %zmm2 {%k2} {z} 

// CHECK: vbroadcasti32x4 1024(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x5a,0x54,0x02,0x40]       
vbroadcasti32x4 1024(%edx,%eax), %zmm2 

// CHECK: vbroadcasti32x4 1024(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x5a,0x54,0x02,0x40]      
vbroadcasti32x4 1024(%edx,%eax), %zmm2 {%k2} 

// CHECK: vbroadcasti32x4 1024(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x5a,0x54,0x02,0x40]     
vbroadcasti32x4 1024(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vbroadcasti32x4 -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x5a,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vbroadcasti32x4 -485498096(%edx,%eax,4), %zmm2 

// CHECK: vbroadcasti32x4 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x5a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vbroadcasti32x4 485498096(%edx,%eax,4), %zmm2 

// CHECK: vbroadcasti32x4 -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x5a,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vbroadcasti32x4 -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vbroadcasti32x4 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x5a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vbroadcasti32x4 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vbroadcasti32x4 -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x5a,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vbroadcasti32x4 -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vbroadcasti32x4 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x5a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vbroadcasti32x4 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vbroadcasti32x4 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x5a,0x92,0xf0,0x1c,0xf0,0x1c]       
vbroadcasti32x4 485498096(%edx), %zmm2 

// CHECK: vbroadcasti32x4 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x5a,0x92,0xf0,0x1c,0xf0,0x1c]      
vbroadcasti32x4 485498096(%edx), %zmm2 {%k2} 

// CHECK: vbroadcasti32x4 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x5a,0x92,0xf0,0x1c,0xf0,0x1c]     
vbroadcasti32x4 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vbroadcasti32x4 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x5a,0x15,0xf0,0x1c,0xf0,0x1c]       
vbroadcasti32x4 485498096, %zmm2 

// CHECK: vbroadcasti32x4 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x5a,0x15,0xf0,0x1c,0xf0,0x1c]      
vbroadcasti32x4 485498096, %zmm2 {%k2} 

// CHECK: vbroadcasti32x4 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x5a,0x15,0xf0,0x1c,0xf0,0x1c]     
vbroadcasti32x4 485498096, %zmm2 {%k2} {z} 

// CHECK: vbroadcasti32x4 (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x5a,0x12]       
vbroadcasti32x4 (%edx), %zmm2 

// CHECK: vbroadcasti32x4 (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x5a,0x12]      
vbroadcasti32x4 (%edx), %zmm2 {%k2} 

// CHECK: vbroadcasti32x4 (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x5a,0x12]     
vbroadcasti32x4 (%edx), %zmm2 {%k2} {z} 

// CHECK: vbroadcasti32x8 2048(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x5b,0x54,0x02,0x40]       
vbroadcasti32x8 2048(%edx,%eax), %zmm2 

// CHECK: vbroadcasti32x8 2048(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x5b,0x54,0x02,0x40]      
vbroadcasti32x8 2048(%edx,%eax), %zmm2 {%k2} 

// CHECK: vbroadcasti32x8 2048(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x5b,0x54,0x02,0x40]     
vbroadcasti32x8 2048(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vbroadcasti32x8 -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vbroadcasti32x8 -485498096(%edx,%eax,4), %zmm2 

// CHECK: vbroadcasti32x8 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vbroadcasti32x8 485498096(%edx,%eax,4), %zmm2 

// CHECK: vbroadcasti32x8 -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vbroadcasti32x8 -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vbroadcasti32x8 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vbroadcasti32x8 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vbroadcasti32x8 -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vbroadcasti32x8 -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vbroadcasti32x8 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vbroadcasti32x8 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vbroadcasti32x8 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]       
vbroadcasti32x8 485498096(%edx), %zmm2 

// CHECK: vbroadcasti32x8 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]      
vbroadcasti32x8 485498096(%edx), %zmm2 {%k2} 

// CHECK: vbroadcasti32x8 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]     
vbroadcasti32x8 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vbroadcasti32x8 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]       
vbroadcasti32x8 485498096, %zmm2 

// CHECK: vbroadcasti32x8 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]      
vbroadcasti32x8 485498096, %zmm2 {%k2} 

// CHECK: vbroadcasti32x8 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]     
vbroadcasti32x8 485498096, %zmm2 {%k2} {z} 

// CHECK: vbroadcasti32x8 (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x5b,0x12]       
vbroadcasti32x8 (%edx), %zmm2 

// CHECK: vbroadcasti32x8 (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x5b,0x12]      
vbroadcasti32x8 (%edx), %zmm2 {%k2} 

// CHECK: vbroadcasti32x8 (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x5b,0x12]     
vbroadcasti32x8 (%edx), %zmm2 {%k2} {z} 

// CHECK: vbroadcastsd -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x19,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vbroadcastsd -485498096(%edx,%eax,4), %zmm2 

// CHECK: vbroadcastsd 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x19,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vbroadcastsd 485498096(%edx,%eax,4), %zmm2 

// CHECK: vbroadcastsd -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x19,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vbroadcastsd -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vbroadcastsd 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x19,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vbroadcastsd 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vbroadcastsd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x19,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vbroadcastsd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vbroadcastsd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x19,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vbroadcastsd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vbroadcastsd 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x19,0x92,0xf0,0x1c,0xf0,0x1c]       
vbroadcastsd 485498096(%edx), %zmm2 

// CHECK: vbroadcastsd 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x19,0x92,0xf0,0x1c,0xf0,0x1c]      
vbroadcastsd 485498096(%edx), %zmm2 {%k2} 

// CHECK: vbroadcastsd 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x19,0x92,0xf0,0x1c,0xf0,0x1c]     
vbroadcastsd 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vbroadcastsd 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x19,0x15,0xf0,0x1c,0xf0,0x1c]       
vbroadcastsd 485498096, %zmm2 

// CHECK: vbroadcastsd 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x19,0x15,0xf0,0x1c,0xf0,0x1c]      
vbroadcastsd 485498096, %zmm2 {%k2} 

// CHECK: vbroadcastsd 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x19,0x15,0xf0,0x1c,0xf0,0x1c]     
vbroadcastsd 485498096, %zmm2 {%k2} {z} 

// CHECK: vbroadcastsd 512(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x19,0x54,0x02,0x40]       
vbroadcastsd 512(%edx,%eax), %zmm2 

// CHECK: vbroadcastsd 512(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x19,0x54,0x02,0x40]      
vbroadcastsd 512(%edx,%eax), %zmm2 {%k2} 

// CHECK: vbroadcastsd 512(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x19,0x54,0x02,0x40]     
vbroadcastsd 512(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vbroadcastsd (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x19,0x12]       
vbroadcastsd (%edx), %zmm2 

// CHECK: vbroadcastsd (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x19,0x12]      
vbroadcastsd (%edx), %zmm2 {%k2} 

// CHECK: vbroadcastsd (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x19,0x12]     
vbroadcastsd (%edx), %zmm2 {%k2} {z} 

// CHECK: vbroadcastsd %xmm1, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x19,0xd1]       
vbroadcastsd %xmm1, %zmm2 

// CHECK: vbroadcastsd %xmm1, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x19,0xd1]      
vbroadcastsd %xmm1, %zmm2 {%k2} 

// CHECK: vbroadcastsd %xmm1, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x19,0xd1]     
vbroadcastsd %xmm1, %zmm2 {%k2} {z} 

// CHECK: vbroadcastss 256(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x18,0x54,0x02,0x40]       
vbroadcastss 256(%edx,%eax), %zmm2 

// CHECK: vbroadcastss 256(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x18,0x54,0x02,0x40]      
vbroadcastss 256(%edx,%eax), %zmm2 {%k2} 

// CHECK: vbroadcastss 256(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x18,0x54,0x02,0x40]     
vbroadcastss 256(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vbroadcastss -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x18,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vbroadcastss -485498096(%edx,%eax,4), %zmm2 

// CHECK: vbroadcastss 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x18,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vbroadcastss 485498096(%edx,%eax,4), %zmm2 

// CHECK: vbroadcastss -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x18,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vbroadcastss -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vbroadcastss 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x18,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vbroadcastss 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vbroadcastss -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x18,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vbroadcastss -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vbroadcastss 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x18,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vbroadcastss 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vbroadcastss 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x18,0x92,0xf0,0x1c,0xf0,0x1c]       
vbroadcastss 485498096(%edx), %zmm2 

// CHECK: vbroadcastss 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x18,0x92,0xf0,0x1c,0xf0,0x1c]      
vbroadcastss 485498096(%edx), %zmm2 {%k2} 

// CHECK: vbroadcastss 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x18,0x92,0xf0,0x1c,0xf0,0x1c]     
vbroadcastss 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vbroadcastss 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x18,0x15,0xf0,0x1c,0xf0,0x1c]       
vbroadcastss 485498096, %zmm2 

// CHECK: vbroadcastss 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x18,0x15,0xf0,0x1c,0xf0,0x1c]      
vbroadcastss 485498096, %zmm2 {%k2} 

// CHECK: vbroadcastss 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x18,0x15,0xf0,0x1c,0xf0,0x1c]     
vbroadcastss 485498096, %zmm2 {%k2} {z} 

// CHECK: vbroadcastss (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x18,0x12]       
vbroadcastss (%edx), %zmm2 

// CHECK: vbroadcastss (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x18,0x12]      
vbroadcastss (%edx), %zmm2 {%k2} 

// CHECK: vbroadcastss (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x18,0x12]     
vbroadcastss (%edx), %zmm2 {%k2} {z} 

// CHECK: vbroadcastss %xmm1, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x18,0xd1]       
vbroadcastss %xmm1, %zmm2 

// CHECK: vbroadcastss %xmm1, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x18,0xd1]      
vbroadcastss %xmm1, %zmm2 {%k2} 

// CHECK: vbroadcastss %xmm1, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x18,0xd1]     
vbroadcastss %xmm1, %zmm2 {%k2} {z} 

// CHECK: vcmpeqpd 4096(%edx,%eax), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xc2,0x54,0x02,0x40,0x00]      
vcmpeqpd 4096(%edx,%eax), %zmm2, %k2 

// CHECK: vcmpeqpd 4096(%edx,%eax), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xc2,0x54,0x02,0x40,0x00]     
vcmpeqpd 4096(%edx,%eax), %zmm2, %k2 {%k2} 

// CHECK: vcmpeqpd 485498096{1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xc2,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vcmpeqpd 485498096{1to8}, %zmm2, %k2 

// CHECK: vcmpeqpd 485498096{1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xc2,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vcmpeqpd 485498096{1to8}, %zmm2, %k2 {%k2} 

// CHECK: vcmpeqpd 485498096(%edx){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xc2,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vcmpeqpd 485498096(%edx){1to8}, %zmm2, %k2 

// CHECK: vcmpeqpd 485498096(%edx){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xc2,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vcmpeqpd 485498096(%edx){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vcmpeqpd -485498096(%edx,%eax,4){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xc2,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vcmpeqpd -485498096(%edx,%eax,4){1to8}, %zmm2, %k2 

// CHECK: vcmpeqpd 485498096(%edx,%eax,4){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xc2,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vcmpeqpd 485498096(%edx,%eax,4){1to8}, %zmm2, %k2 

// CHECK: vcmpeqpd -485498096(%edx,%eax,4){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xc2,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vcmpeqpd -485498096(%edx,%eax,4){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vcmpeqpd 485498096(%edx,%eax,4){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xc2,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vcmpeqpd 485498096(%edx,%eax,4){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vcmpeqpd -485498096(%edx,%eax,4), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xc2,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vcmpeqpd -485498096(%edx,%eax,4), %zmm2, %k2 

// CHECK: vcmpeqpd 485498096(%edx,%eax,4), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xc2,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vcmpeqpd 485498096(%edx,%eax,4), %zmm2, %k2 

// CHECK: vcmpeqpd -485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xc2,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vcmpeqpd -485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 

// CHECK: vcmpeqpd 485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xc2,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vcmpeqpd 485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 

// CHECK: vcmpeqpd 485498096(%edx), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xc2,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vcmpeqpd 485498096(%edx), %zmm2, %k2 

// CHECK: vcmpeqpd 485498096(%edx), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xc2,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vcmpeqpd 485498096(%edx), %zmm2, %k2 {%k2} 

// CHECK: vcmpeqpd 485498096, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xc2,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vcmpeqpd 485498096, %zmm2, %k2 

// CHECK: vcmpeqpd 485498096, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xc2,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vcmpeqpd 485498096, %zmm2, %k2 {%k2} 

// CHECK: vcmpeqpd 512(%edx,%eax){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xc2,0x54,0x02,0x40,0x00]      
vcmpeqpd 512(%edx,%eax){1to8}, %zmm2, %k2 

// CHECK: vcmpeqpd 512(%edx,%eax){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xc2,0x54,0x02,0x40,0x00]     
vcmpeqpd 512(%edx,%eax){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vcmpeqpd (%edx){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xc2,0x12,0x00]      
vcmpeqpd (%edx){1to8}, %zmm2, %k2 

// CHECK: vcmpeqpd (%edx){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xc2,0x12,0x00]     
vcmpeqpd (%edx){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vcmpeqpd (%edx), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xc2,0x12,0x00]      
vcmpeqpd (%edx), %zmm2, %k2 

// CHECK: vcmpeqpd (%edx), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xc2,0x12,0x00]     
vcmpeqpd (%edx), %zmm2, %k2 {%k2} 

// CHECK: vcmpeqpd {sae}, %zmm2, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0xed,0x18,0xc2,0xd2,0x00]     
vcmpeqpd {sae}, %zmm2, %zmm2, %k2 

// CHECK: vcmpeqpd {sae}, %zmm2, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x1a,0xc2,0xd2,0x00]    
vcmpeqpd {sae}, %zmm2, %zmm2, %k2 {%k2} 

// CHECK: vcmpeqpd %zmm2, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xc2,0xd2,0x00]      
vcmpeqpd %zmm2, %zmm2, %k2 

// CHECK: vcmpeqpd %zmm2, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xc2,0xd2,0x00]     
vcmpeqpd %zmm2, %zmm2, %k2 {%k2} 

// CHECK: vcmpeqps 256(%edx,%eax){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0xc2,0x54,0x02,0x40,0x00]      
vcmpeqps 256(%edx,%eax){1to16}, %zmm2, %k2 

// CHECK: vcmpeqps 256(%edx,%eax){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0xc2,0x54,0x02,0x40,0x00]     
vcmpeqps 256(%edx,%eax){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vcmpeqps 4096(%edx,%eax), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0xc2,0x54,0x02,0x40,0x00]      
vcmpeqps 4096(%edx,%eax), %zmm2, %k2 

// CHECK: vcmpeqps 4096(%edx,%eax), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0xc2,0x54,0x02,0x40,0x00]     
vcmpeqps 4096(%edx,%eax), %zmm2, %k2 {%k2} 

// CHECK: vcmpeqps 485498096{1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0xc2,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vcmpeqps 485498096{1to16}, %zmm2, %k2 

// CHECK: vcmpeqps 485498096{1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0xc2,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vcmpeqps 485498096{1to16}, %zmm2, %k2 {%k2} 

// CHECK: vcmpeqps 485498096(%edx){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0xc2,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vcmpeqps 485498096(%edx){1to16}, %zmm2, %k2 

// CHECK: vcmpeqps 485498096(%edx){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0xc2,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vcmpeqps 485498096(%edx){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vcmpeqps -485498096(%edx,%eax,4){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0xc2,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vcmpeqps -485498096(%edx,%eax,4){1to16}, %zmm2, %k2 

// CHECK: vcmpeqps 485498096(%edx,%eax,4){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0xc2,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vcmpeqps 485498096(%edx,%eax,4){1to16}, %zmm2, %k2 

// CHECK: vcmpeqps -485498096(%edx,%eax,4){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0xc2,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vcmpeqps -485498096(%edx,%eax,4){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vcmpeqps 485498096(%edx,%eax,4){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0xc2,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vcmpeqps 485498096(%edx,%eax,4){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vcmpeqps -485498096(%edx,%eax,4), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0xc2,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vcmpeqps -485498096(%edx,%eax,4), %zmm2, %k2 

// CHECK: vcmpeqps 485498096(%edx,%eax,4), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0xc2,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vcmpeqps 485498096(%edx,%eax,4), %zmm2, %k2 

// CHECK: vcmpeqps -485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0xc2,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vcmpeqps -485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 

// CHECK: vcmpeqps 485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0xc2,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vcmpeqps 485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 

// CHECK: vcmpeqps 485498096(%edx), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0xc2,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vcmpeqps 485498096(%edx), %zmm2, %k2 

// CHECK: vcmpeqps 485498096(%edx), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0xc2,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vcmpeqps 485498096(%edx), %zmm2, %k2 {%k2} 

// CHECK: vcmpeqps 485498096, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0xc2,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vcmpeqps 485498096, %zmm2, %k2 

// CHECK: vcmpeqps 485498096, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0xc2,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vcmpeqps 485498096, %zmm2, %k2 {%k2} 

// CHECK: vcmpeqps (%edx){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0xc2,0x12,0x00]      
vcmpeqps (%edx){1to16}, %zmm2, %k2 

// CHECK: vcmpeqps (%edx){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0xc2,0x12,0x00]     
vcmpeqps (%edx){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vcmpeqps (%edx), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0xc2,0x12,0x00]      
vcmpeqps (%edx), %zmm2, %k2 

// CHECK: vcmpeqps (%edx), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0xc2,0x12,0x00]     
vcmpeqps (%edx), %zmm2, %k2 {%k2} 

// CHECK: vcmpeqps {sae}, %zmm2, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x18,0xc2,0xd2,0x00]     
vcmpeqps {sae}, %zmm2, %zmm2, %k2 

// CHECK: vcmpeqps {sae}, %zmm2, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x1a,0xc2,0xd2,0x00]    
vcmpeqps {sae}, %zmm2, %zmm2, %k2 {%k2} 

// CHECK: vcmpeqps %zmm2, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0xc2,0xd2,0x00]      
vcmpeqps %zmm2, %zmm2, %k2 

// CHECK: vcmpeqps %zmm2, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0xc2,0xd2,0x00]     
vcmpeqps %zmm2, %zmm2, %k2 {%k2} 

// CHECK: vcompresspd %zmm2, -485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x8a,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcompresspd %zmm2, -485498096(%edx,%eax,4) 

// CHECK: vcompresspd %zmm2, 485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x8a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcompresspd %zmm2, 485498096(%edx,%eax,4) 

// CHECK: vcompresspd %zmm2, -485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x8a,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcompresspd %zmm2, -485498096(%edx,%eax,4) {%k2} 

// CHECK: vcompresspd %zmm2, 485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x8a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcompresspd %zmm2, 485498096(%edx,%eax,4) {%k2} 

// CHECK: vcompresspd %zmm2, 485498096(%edx) 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x8a,0x92,0xf0,0x1c,0xf0,0x1c]       
vcompresspd %zmm2, 485498096(%edx) 

// CHECK: vcompresspd %zmm2, 485498096(%edx) {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x8a,0x92,0xf0,0x1c,0xf0,0x1c]      
vcompresspd %zmm2, 485498096(%edx) {%k2} 

// CHECK: vcompresspd %zmm2, 485498096 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x8a,0x15,0xf0,0x1c,0xf0,0x1c]       
vcompresspd %zmm2, 485498096 

// CHECK: vcompresspd %zmm2, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x8a,0x15,0xf0,0x1c,0xf0,0x1c]      
vcompresspd %zmm2, 485498096 {%k2} 

// CHECK: vcompresspd %zmm2, 512(%edx,%eax) 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x8a,0x54,0x02,0x40]       
vcompresspd %zmm2, 512(%edx,%eax) 

// CHECK: vcompresspd %zmm2, 512(%edx,%eax) {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x8a,0x54,0x02,0x40]      
vcompresspd %zmm2, 512(%edx,%eax) {%k2} 

// CHECK: vcompresspd %zmm2, (%edx) 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x8a,0x12]       
vcompresspd %zmm2, (%edx) 

// CHECK: vcompresspd %zmm2, (%edx) {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x8a,0x12]      
vcompresspd %zmm2, (%edx) {%k2} 

// CHECK: vcompresspd %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x8a,0xd2]       
vcompresspd %zmm2, %zmm2 

// CHECK: vcompresspd %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x8a,0xd2]      
vcompresspd %zmm2, %zmm2 {%k2} 

// CHECK: vcompresspd %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x8a,0xd2]     
vcompresspd %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcompressps %zmm2, 256(%edx,%eax) 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x8a,0x54,0x02,0x40]       
vcompressps %zmm2, 256(%edx,%eax) 

// CHECK: vcompressps %zmm2, 256(%edx,%eax) {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x8a,0x54,0x02,0x40]      
vcompressps %zmm2, 256(%edx,%eax) {%k2} 

// CHECK: vcompressps %zmm2, -485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x8a,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcompressps %zmm2, -485498096(%edx,%eax,4) 

// CHECK: vcompressps %zmm2, 485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x8a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcompressps %zmm2, 485498096(%edx,%eax,4) 

// CHECK: vcompressps %zmm2, -485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x8a,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcompressps %zmm2, -485498096(%edx,%eax,4) {%k2} 

// CHECK: vcompressps %zmm2, 485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x8a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcompressps %zmm2, 485498096(%edx,%eax,4) {%k2} 

// CHECK: vcompressps %zmm2, 485498096(%edx) 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x8a,0x92,0xf0,0x1c,0xf0,0x1c]       
vcompressps %zmm2, 485498096(%edx) 

// CHECK: vcompressps %zmm2, 485498096(%edx) {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x8a,0x92,0xf0,0x1c,0xf0,0x1c]      
vcompressps %zmm2, 485498096(%edx) {%k2} 

// CHECK: vcompressps %zmm2, 485498096 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x8a,0x15,0xf0,0x1c,0xf0,0x1c]       
vcompressps %zmm2, 485498096 

// CHECK: vcompressps %zmm2, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x8a,0x15,0xf0,0x1c,0xf0,0x1c]      
vcompressps %zmm2, 485498096 {%k2} 

// CHECK: vcompressps %zmm2, (%edx) 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x8a,0x12]       
vcompressps %zmm2, (%edx) 

// CHECK: vcompressps %zmm2, (%edx) {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x8a,0x12]      
vcompressps %zmm2, (%edx) {%k2} 

// CHECK: vcompressps %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x8a,0xd2]       
vcompressps %zmm2, %zmm2 

// CHECK: vcompressps %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x8a,0xd2]      
vcompressps %zmm2, %zmm2 {%k2} 

// CHECK: vcompressps %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x8a,0xd2]     
vcompressps %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2pd 2048(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0xe6,0x54,0x02,0x40]       
vcvtdq2pd 2048(%edx,%eax), %zmm2 

// CHECK: vcvtdq2pd 2048(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0xe6,0x54,0x02,0x40]      
vcvtdq2pd 2048(%edx,%eax), %zmm2 {%k2} 

// CHECK: vcvtdq2pd 2048(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0xe6,0x54,0x02,0x40]     
vcvtdq2pd 2048(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vcvtdq2pd 256(%edx,%eax){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x58,0xe6,0x54,0x02,0x40]       
vcvtdq2pd 256(%edx,%eax){1to8}, %zmm2 

// CHECK: vcvtdq2pd 256(%edx,%eax){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x5a,0xe6,0x54,0x02,0x40]      
vcvtdq2pd 256(%edx,%eax){1to8}, %zmm2 {%k2} 

// CHECK: vcvtdq2pd 256(%edx,%eax){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xda,0xe6,0x54,0x02,0x40]     
vcvtdq2pd 256(%edx,%eax){1to8}, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2pd 485498096{1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x58,0xe6,0x15,0xf0,0x1c,0xf0,0x1c]       
vcvtdq2pd 485498096{1to8}, %zmm2 

// CHECK: vcvtdq2pd 485498096{1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x5a,0xe6,0x15,0xf0,0x1c,0xf0,0x1c]      
vcvtdq2pd 485498096{1to8}, %zmm2 {%k2} 

// CHECK: vcvtdq2pd 485498096{1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xda,0xe6,0x15,0xf0,0x1c,0xf0,0x1c]     
vcvtdq2pd 485498096{1to8}, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2pd 485498096(%edx){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x58,0xe6,0x92,0xf0,0x1c,0xf0,0x1c]       
vcvtdq2pd 485498096(%edx){1to8}, %zmm2 

// CHECK: vcvtdq2pd 485498096(%edx){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x5a,0xe6,0x92,0xf0,0x1c,0xf0,0x1c]      
vcvtdq2pd 485498096(%edx){1to8}, %zmm2 {%k2} 

// CHECK: vcvtdq2pd 485498096(%edx){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xda,0xe6,0x92,0xf0,0x1c,0xf0,0x1c]     
vcvtdq2pd 485498096(%edx){1to8}, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2pd -485498096(%edx,%eax,4){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x58,0xe6,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtdq2pd -485498096(%edx,%eax,4){1to8}, %zmm2 

// CHECK: vcvtdq2pd 485498096(%edx,%eax,4){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x58,0xe6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtdq2pd 485498096(%edx,%eax,4){1to8}, %zmm2 

// CHECK: vcvtdq2pd -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x5a,0xe6,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtdq2pd -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 

// CHECK: vcvtdq2pd 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x5a,0xe6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtdq2pd 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 

// CHECK: vcvtdq2pd -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xda,0xe6,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtdq2pd -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2pd 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xda,0xe6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtdq2pd 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2pd -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0xe6,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtdq2pd -485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvtdq2pd 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0xe6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtdq2pd 485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvtdq2pd -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0xe6,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtdq2pd -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvtdq2pd 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0xe6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtdq2pd 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvtdq2pd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0xe6,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtdq2pd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvtdq2pd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0xe6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtdq2pd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvtdq2pd 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0xe6,0x92,0xf0,0x1c,0xf0,0x1c]       
vcvtdq2pd 485498096(%edx), %zmm2 

// CHECK: vcvtdq2pd 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0xe6,0x92,0xf0,0x1c,0xf0,0x1c]      
vcvtdq2pd 485498096(%edx), %zmm2 {%k2} 

// CHECK: vcvtdq2pd 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0xe6,0x92,0xf0,0x1c,0xf0,0x1c]     
vcvtdq2pd 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vcvtdq2pd 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0xe6,0x15,0xf0,0x1c,0xf0,0x1c]       
vcvtdq2pd 485498096, %zmm2 

// CHECK: vcvtdq2pd 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0xe6,0x15,0xf0,0x1c,0xf0,0x1c]      
vcvtdq2pd 485498096, %zmm2 {%k2} 

// CHECK: vcvtdq2pd 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0xe6,0x15,0xf0,0x1c,0xf0,0x1c]     
vcvtdq2pd 485498096, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2pd (%edx){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x58,0xe6,0x12]       
vcvtdq2pd (%edx){1to8}, %zmm2 

// CHECK: vcvtdq2pd (%edx){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x5a,0xe6,0x12]      
vcvtdq2pd (%edx){1to8}, %zmm2 {%k2} 

// CHECK: vcvtdq2pd (%edx){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xda,0xe6,0x12]     
vcvtdq2pd (%edx){1to8}, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2pd (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0xe6,0x12]       
vcvtdq2pd (%edx), %zmm2 

// CHECK: vcvtdq2pd (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0xe6,0x12]      
vcvtdq2pd (%edx), %zmm2 {%k2} 

// CHECK: vcvtdq2pd (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0xe6,0x12]     
vcvtdq2pd (%edx), %zmm2 {%k2} {z} 

// CHECK: vcvtdq2pd %ymm4, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0xe6,0xd4]       
vcvtdq2pd %ymm4, %zmm2 

// CHECK: vcvtdq2pd %ymm4, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0xe6,0xd4]      
vcvtdq2pd %ymm4, %zmm2 {%k2} 

// CHECK: vcvtdq2pd %ymm4, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0xe6,0xd4]     
vcvtdq2pd %ymm4, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2ps 256(%edx,%eax){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x5b,0x54,0x02,0x40]       
vcvtdq2ps 256(%edx,%eax){1to16}, %zmm2 

// CHECK: vcvtdq2ps 256(%edx,%eax){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x5b,0x54,0x02,0x40]      
vcvtdq2ps 256(%edx,%eax){1to16}, %zmm2 {%k2} 

// CHECK: vcvtdq2ps 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x5b,0x54,0x02,0x40]     
vcvtdq2ps 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2ps 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x5b,0x54,0x02,0x40]       
vcvtdq2ps 4096(%edx,%eax), %zmm2 

// CHECK: vcvtdq2ps 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x5b,0x54,0x02,0x40]      
vcvtdq2ps 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vcvtdq2ps 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x5b,0x54,0x02,0x40]     
vcvtdq2ps 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vcvtdq2ps 485498096{1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]       
vcvtdq2ps 485498096{1to16}, %zmm2 

// CHECK: vcvtdq2ps 485498096{1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]      
vcvtdq2ps 485498096{1to16}, %zmm2 {%k2} 

// CHECK: vcvtdq2ps 485498096{1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]     
vcvtdq2ps 485498096{1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2ps 485498096(%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]       
vcvtdq2ps 485498096(%edx){1to16}, %zmm2 

// CHECK: vcvtdq2ps 485498096(%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]      
vcvtdq2ps 485498096(%edx){1to16}, %zmm2 {%k2} 

// CHECK: vcvtdq2ps 485498096(%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]     
vcvtdq2ps 485498096(%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2ps -485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtdq2ps -485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vcvtdq2ps 485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtdq2ps 485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vcvtdq2ps -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtdq2ps -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vcvtdq2ps 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtdq2ps 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vcvtdq2ps -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtdq2ps -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2ps 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtdq2ps 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2ps -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtdq2ps -485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvtdq2ps 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtdq2ps 485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvtdq2ps -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtdq2ps -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvtdq2ps 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtdq2ps 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvtdq2ps -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtdq2ps -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvtdq2ps 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtdq2ps 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvtdq2ps 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]       
vcvtdq2ps 485498096(%edx), %zmm2 

// CHECK: vcvtdq2ps 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]      
vcvtdq2ps 485498096(%edx), %zmm2 {%k2} 

// CHECK: vcvtdq2ps 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]     
vcvtdq2ps 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vcvtdq2ps 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]       
vcvtdq2ps 485498096, %zmm2 

// CHECK: vcvtdq2ps 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]      
vcvtdq2ps 485498096, %zmm2 {%k2} 

// CHECK: vcvtdq2ps 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]     
vcvtdq2ps 485498096, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2ps (%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x5b,0x12]       
vcvtdq2ps (%edx){1to16}, %zmm2 

// CHECK: vcvtdq2ps (%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x5b,0x12]      
vcvtdq2ps (%edx){1to16}, %zmm2 {%k2} 

// CHECK: vcvtdq2ps (%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x5b,0x12]     
vcvtdq2ps (%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2ps (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x5b,0x12]       
vcvtdq2ps (%edx), %zmm2 

// CHECK: vcvtdq2ps (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x5b,0x12]      
vcvtdq2ps (%edx), %zmm2 {%k2} 

// CHECK: vcvtdq2ps (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x5b,0x12]     
vcvtdq2ps (%edx), %zmm2 {%k2} {z} 

// CHECK: vcvtdq2ps {rd-sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x38,0x5b,0xd2]      
vcvtdq2ps {rd-sae}, %zmm2, %zmm2 

// CHECK: vcvtdq2ps {rd-sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x3a,0x5b,0xd2]     
vcvtdq2ps {rd-sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vcvtdq2ps {rd-sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xba,0x5b,0xd2]    
vcvtdq2ps {rd-sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2ps {rn-sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x18,0x5b,0xd2]      
vcvtdq2ps {rn-sae}, %zmm2, %zmm2 

// CHECK: vcvtdq2ps {rn-sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x1a,0x5b,0xd2]     
vcvtdq2ps {rn-sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vcvtdq2ps {rn-sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x9a,0x5b,0xd2]    
vcvtdq2ps {rn-sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2ps {ru-sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x5b,0xd2]      
vcvtdq2ps {ru-sae}, %zmm2, %zmm2 

// CHECK: vcvtdq2ps {ru-sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x5b,0xd2]     
vcvtdq2ps {ru-sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vcvtdq2ps {ru-sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x5b,0xd2]    
vcvtdq2ps {ru-sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2ps {rz-sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x78,0x5b,0xd2]      
vcvtdq2ps {rz-sae}, %zmm2, %zmm2 

// CHECK: vcvtdq2ps {rz-sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x7a,0x5b,0xd2]     
vcvtdq2ps {rz-sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vcvtdq2ps {rz-sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xfa,0x5b,0xd2]    
vcvtdq2ps {rz-sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtdq2ps %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x5b,0xd2]       
vcvtdq2ps %zmm2, %zmm2 

// CHECK: vcvtdq2ps %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x5b,0xd2]      
vcvtdq2ps %zmm2, %zmm2 {%k2} 

// CHECK: vcvtdq2ps %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x5b,0xd2]     
vcvtdq2ps %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtpd2dq 4096(%edx,%eax), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xff,0x48,0xe6,0x64,0x02,0x40]       
vcvtpd2dq 4096(%edx,%eax), %ymm4 

// CHECK: vcvtpd2dq 4096(%edx,%eax), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x4a,0xe6,0x64,0x02,0x40]      
vcvtpd2dq 4096(%edx,%eax), %ymm4 {%k2} 

// CHECK: vcvtpd2dq 4096(%edx,%eax), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xca,0xe6,0x64,0x02,0x40]     
vcvtpd2dq 4096(%edx,%eax), %ymm4 {%k2} {z} 

// CHECK: vcvtpd2dq 485498096{1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xff,0x58,0xe6,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2dq 485498096{1to8}, %ymm4 

// CHECK: vcvtpd2dq 485498096{1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x5a,0xe6,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2dq 485498096{1to8}, %ymm4 {%k2} 

// CHECK: vcvtpd2dq 485498096{1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xda,0xe6,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2dq 485498096{1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2dq 485498096(%edx){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xff,0x58,0xe6,0xa2,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2dq 485498096(%edx){1to8}, %ymm4 

// CHECK: vcvtpd2dq 485498096(%edx){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x5a,0xe6,0xa2,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2dq 485498096(%edx){1to8}, %ymm4 {%k2} 

// CHECK: vcvtpd2dq 485498096(%edx){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xda,0xe6,0xa2,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2dq 485498096(%edx){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2dq -485498096(%edx,%eax,4){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xff,0x58,0xe6,0xa4,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtpd2dq -485498096(%edx,%eax,4){1to8}, %ymm4 

// CHECK: vcvtpd2dq 485498096(%edx,%eax,4){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xff,0x58,0xe6,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2dq 485498096(%edx,%eax,4){1to8}, %ymm4 

// CHECK: vcvtpd2dq -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x5a,0xe6,0xa4,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtpd2dq -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 

// CHECK: vcvtpd2dq 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x5a,0xe6,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2dq 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 

// CHECK: vcvtpd2dq -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xda,0xe6,0xa4,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtpd2dq -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2dq 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xda,0xe6,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2dq 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2dq -485498096(%edx,%eax,4), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xff,0x48,0xe6,0xa4,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtpd2dq -485498096(%edx,%eax,4), %ymm4 

// CHECK: vcvtpd2dq 485498096(%edx,%eax,4), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xff,0x48,0xe6,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2dq 485498096(%edx,%eax,4), %ymm4 

// CHECK: vcvtpd2dq -485498096(%edx,%eax,4), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x4a,0xe6,0xa4,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtpd2dq -485498096(%edx,%eax,4), %ymm4 {%k2} 

// CHECK: vcvtpd2dq 485498096(%edx,%eax,4), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x4a,0xe6,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2dq 485498096(%edx,%eax,4), %ymm4 {%k2} 

// CHECK: vcvtpd2dq -485498096(%edx,%eax,4), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xca,0xe6,0xa4,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtpd2dq -485498096(%edx,%eax,4), %ymm4 {%k2} {z} 

// CHECK: vcvtpd2dq 485498096(%edx,%eax,4), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xca,0xe6,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2dq 485498096(%edx,%eax,4), %ymm4 {%k2} {z} 

// CHECK: vcvtpd2dq 485498096(%edx), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xff,0x48,0xe6,0xa2,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2dq 485498096(%edx), %ymm4 

// CHECK: vcvtpd2dq 485498096(%edx), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x4a,0xe6,0xa2,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2dq 485498096(%edx), %ymm4 {%k2} 

// CHECK: vcvtpd2dq 485498096(%edx), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xca,0xe6,0xa2,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2dq 485498096(%edx), %ymm4 {%k2} {z} 

// CHECK: vcvtpd2dq 485498096, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xff,0x48,0xe6,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2dq 485498096, %ymm4 

// CHECK: vcvtpd2dq 485498096, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x4a,0xe6,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2dq 485498096, %ymm4 {%k2} 

// CHECK: vcvtpd2dq 485498096, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xca,0xe6,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2dq 485498096, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2dq 512(%edx,%eax){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xff,0x58,0xe6,0x64,0x02,0x40]       
vcvtpd2dq 512(%edx,%eax){1to8}, %ymm4 

// CHECK: vcvtpd2dq 512(%edx,%eax){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x5a,0xe6,0x64,0x02,0x40]      
vcvtpd2dq 512(%edx,%eax){1to8}, %ymm4 {%k2} 

// CHECK: vcvtpd2dq 512(%edx,%eax){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xda,0xe6,0x64,0x02,0x40]     
vcvtpd2dq 512(%edx,%eax){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2dq (%edx){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xff,0x58,0xe6,0x22]       
vcvtpd2dq (%edx){1to8}, %ymm4 

// CHECK: vcvtpd2dq (%edx){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x5a,0xe6,0x22]      
vcvtpd2dq (%edx){1to8}, %ymm4 {%k2} 

// CHECK: vcvtpd2dq (%edx){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xda,0xe6,0x22]     
vcvtpd2dq (%edx){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2dq (%edx), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xff,0x48,0xe6,0x22]       
vcvtpd2dq (%edx), %ymm4 

// CHECK: vcvtpd2dq (%edx), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x4a,0xe6,0x22]      
vcvtpd2dq (%edx), %ymm4 {%k2} 

// CHECK: vcvtpd2dq (%edx), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xca,0xe6,0x22]     
vcvtpd2dq (%edx), %ymm4 {%k2} {z} 

// CHECK: vcvtpd2dq {rd-sae}, %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xff,0x38,0xe6,0xe2]      
vcvtpd2dq {rd-sae}, %zmm2, %ymm4 

// CHECK: vcvtpd2dq {rd-sae}, %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x3a,0xe6,0xe2]     
vcvtpd2dq {rd-sae}, %zmm2, %ymm4 {%k2} 

// CHECK: vcvtpd2dq {rd-sae}, %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xba,0xe6,0xe2]    
vcvtpd2dq {rd-sae}, %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2dq {rn-sae}, %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xff,0x18,0xe6,0xe2]      
vcvtpd2dq {rn-sae}, %zmm2, %ymm4 

// CHECK: vcvtpd2dq {rn-sae}, %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x1a,0xe6,0xe2]     
vcvtpd2dq {rn-sae}, %zmm2, %ymm4 {%k2} 

// CHECK: vcvtpd2dq {rn-sae}, %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0x9a,0xe6,0xe2]    
vcvtpd2dq {rn-sae}, %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2dq {ru-sae}, %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xff,0x58,0xe6,0xe2]      
vcvtpd2dq {ru-sae}, %zmm2, %ymm4 

// CHECK: vcvtpd2dq {ru-sae}, %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x5a,0xe6,0xe2]     
vcvtpd2dq {ru-sae}, %zmm2, %ymm4 {%k2} 

// CHECK: vcvtpd2dq {ru-sae}, %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xda,0xe6,0xe2]    
vcvtpd2dq {ru-sae}, %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2dq {rz-sae}, %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xff,0x78,0xe6,0xe2]      
vcvtpd2dq {rz-sae}, %zmm2, %ymm4 

// CHECK: vcvtpd2dq {rz-sae}, %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x7a,0xe6,0xe2]     
vcvtpd2dq {rz-sae}, %zmm2, %ymm4 {%k2} 

// CHECK: vcvtpd2dq {rz-sae}, %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xfa,0xe6,0xe2]    
vcvtpd2dq {rz-sae}, %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2dq %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xff,0x48,0xe6,0xe2]       
vcvtpd2dq %zmm2, %ymm4 

// CHECK: vcvtpd2dq %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x4a,0xe6,0xe2]      
vcvtpd2dq %zmm2, %ymm4 {%k2} 

// CHECK: vcvtpd2dq %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xca,0xe6,0xe2]     
vcvtpd2dq %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2ps 4096(%edx,%eax), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x5a,0x64,0x02,0x40]       
vcvtpd2ps 4096(%edx,%eax), %ymm4 

// CHECK: vcvtpd2ps 4096(%edx,%eax), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x5a,0x64,0x02,0x40]      
vcvtpd2ps 4096(%edx,%eax), %ymm4 {%k2} 

// CHECK: vcvtpd2ps 4096(%edx,%eax), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x5a,0x64,0x02,0x40]     
vcvtpd2ps 4096(%edx,%eax), %ymm4 {%k2} {z} 

// CHECK: vcvtpd2ps 485498096{1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x58,0x5a,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2ps 485498096{1to8}, %ymm4 

// CHECK: vcvtpd2ps 485498096{1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x5a,0x5a,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2ps 485498096{1to8}, %ymm4 {%k2} 

// CHECK: vcvtpd2ps 485498096{1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xda,0x5a,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2ps 485498096{1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2ps 485498096(%edx){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x58,0x5a,0xa2,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2ps 485498096(%edx){1to8}, %ymm4 

// CHECK: vcvtpd2ps 485498096(%edx){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x5a,0x5a,0xa2,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2ps 485498096(%edx){1to8}, %ymm4 {%k2} 

// CHECK: vcvtpd2ps 485498096(%edx){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xda,0x5a,0xa2,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2ps 485498096(%edx){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2ps -485498096(%edx,%eax,4){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x58,0x5a,0xa4,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtpd2ps -485498096(%edx,%eax,4){1to8}, %ymm4 

// CHECK: vcvtpd2ps 485498096(%edx,%eax,4){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x58,0x5a,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2ps 485498096(%edx,%eax,4){1to8}, %ymm4 

// CHECK: vcvtpd2ps -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x5a,0x5a,0xa4,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtpd2ps -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 

// CHECK: vcvtpd2ps 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x5a,0x5a,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2ps 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 

// CHECK: vcvtpd2ps -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xda,0x5a,0xa4,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtpd2ps -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2ps 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xda,0x5a,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2ps 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2ps -485498096(%edx,%eax,4), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x5a,0xa4,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtpd2ps -485498096(%edx,%eax,4), %ymm4 

// CHECK: vcvtpd2ps 485498096(%edx,%eax,4), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x5a,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2ps 485498096(%edx,%eax,4), %ymm4 

// CHECK: vcvtpd2ps -485498096(%edx,%eax,4), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x5a,0xa4,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtpd2ps -485498096(%edx,%eax,4), %ymm4 {%k2} 

// CHECK: vcvtpd2ps 485498096(%edx,%eax,4), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x5a,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2ps 485498096(%edx,%eax,4), %ymm4 {%k2} 

// CHECK: vcvtpd2ps -485498096(%edx,%eax,4), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x5a,0xa4,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtpd2ps -485498096(%edx,%eax,4), %ymm4 {%k2} {z} 

// CHECK: vcvtpd2ps 485498096(%edx,%eax,4), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x5a,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2ps 485498096(%edx,%eax,4), %ymm4 {%k2} {z} 

// CHECK: vcvtpd2ps 485498096(%edx), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x5a,0xa2,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2ps 485498096(%edx), %ymm4 

// CHECK: vcvtpd2ps 485498096(%edx), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x5a,0xa2,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2ps 485498096(%edx), %ymm4 {%k2} 

// CHECK: vcvtpd2ps 485498096(%edx), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x5a,0xa2,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2ps 485498096(%edx), %ymm4 {%k2} {z} 

// CHECK: vcvtpd2ps 485498096, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x5a,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2ps 485498096, %ymm4 

// CHECK: vcvtpd2ps 485498096, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x5a,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2ps 485498096, %ymm4 {%k2} 

// CHECK: vcvtpd2ps 485498096, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x5a,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2ps 485498096, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2ps 512(%edx,%eax){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x58,0x5a,0x64,0x02,0x40]       
vcvtpd2ps 512(%edx,%eax){1to8}, %ymm4 

// CHECK: vcvtpd2ps 512(%edx,%eax){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x5a,0x5a,0x64,0x02,0x40]      
vcvtpd2ps 512(%edx,%eax){1to8}, %ymm4 {%k2} 

// CHECK: vcvtpd2ps 512(%edx,%eax){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xda,0x5a,0x64,0x02,0x40]     
vcvtpd2ps 512(%edx,%eax){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2ps (%edx){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x58,0x5a,0x22]       
vcvtpd2ps (%edx){1to8}, %ymm4 

// CHECK: vcvtpd2ps (%edx){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x5a,0x5a,0x22]      
vcvtpd2ps (%edx){1to8}, %ymm4 {%k2} 

// CHECK: vcvtpd2ps (%edx){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xda,0x5a,0x22]     
vcvtpd2ps (%edx){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2ps (%edx), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x5a,0x22]       
vcvtpd2ps (%edx), %ymm4 

// CHECK: vcvtpd2ps (%edx), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x5a,0x22]      
vcvtpd2ps (%edx), %ymm4 {%k2} 

// CHECK: vcvtpd2ps (%edx), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x5a,0x22]     
vcvtpd2ps (%edx), %ymm4 {%k2} {z} 

// CHECK: vcvtpd2ps {rd-sae}, %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x38,0x5a,0xe2]      
vcvtpd2ps {rd-sae}, %zmm2, %ymm4 

// CHECK: vcvtpd2ps {rd-sae}, %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x3a,0x5a,0xe2]     
vcvtpd2ps {rd-sae}, %zmm2, %ymm4 {%k2} 

// CHECK: vcvtpd2ps {rd-sae}, %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xba,0x5a,0xe2]    
vcvtpd2ps {rd-sae}, %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2ps {rn-sae}, %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x18,0x5a,0xe2]      
vcvtpd2ps {rn-sae}, %zmm2, %ymm4 

// CHECK: vcvtpd2ps {rn-sae}, %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x1a,0x5a,0xe2]     
vcvtpd2ps {rn-sae}, %zmm2, %ymm4 {%k2} 

// CHECK: vcvtpd2ps {rn-sae}, %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x9a,0x5a,0xe2]    
vcvtpd2ps {rn-sae}, %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2ps {ru-sae}, %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x58,0x5a,0xe2]      
vcvtpd2ps {ru-sae}, %zmm2, %ymm4 

// CHECK: vcvtpd2ps {ru-sae}, %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x5a,0x5a,0xe2]     
vcvtpd2ps {ru-sae}, %zmm2, %ymm4 {%k2} 

// CHECK: vcvtpd2ps {ru-sae}, %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xda,0x5a,0xe2]    
vcvtpd2ps {ru-sae}, %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2ps {rz-sae}, %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x78,0x5a,0xe2]      
vcvtpd2ps {rz-sae}, %zmm2, %ymm4 

// CHECK: vcvtpd2ps {rz-sae}, %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x7a,0x5a,0xe2]     
vcvtpd2ps {rz-sae}, %zmm2, %ymm4 {%k2} 

// CHECK: vcvtpd2ps {rz-sae}, %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xfa,0x5a,0xe2]    
vcvtpd2ps {rz-sae}, %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2ps %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x5a,0xe2]       
vcvtpd2ps %zmm2, %ymm4 

// CHECK: vcvtpd2ps %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x5a,0xe2]      
vcvtpd2ps %zmm2, %ymm4 {%k2} 

// CHECK: vcvtpd2ps %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x5a,0xe2]     
vcvtpd2ps %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2udq 4096(%edx,%eax), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x48,0x79,0x64,0x02,0x40]       
vcvtpd2udq 4096(%edx,%eax), %ymm4 

// CHECK: vcvtpd2udq 4096(%edx,%eax), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x4a,0x79,0x64,0x02,0x40]      
vcvtpd2udq 4096(%edx,%eax), %ymm4 {%k2} 

// CHECK: vcvtpd2udq 4096(%edx,%eax), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xca,0x79,0x64,0x02,0x40]     
vcvtpd2udq 4096(%edx,%eax), %ymm4 {%k2} {z} 

// CHECK: vcvtpd2udq 485498096{1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x58,0x79,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2udq 485498096{1to8}, %ymm4 

// CHECK: vcvtpd2udq 485498096{1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x5a,0x79,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2udq 485498096{1to8}, %ymm4 {%k2} 

// CHECK: vcvtpd2udq 485498096{1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xda,0x79,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2udq 485498096{1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2udq 485498096(%edx){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x58,0x79,0xa2,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2udq 485498096(%edx){1to8}, %ymm4 

// CHECK: vcvtpd2udq 485498096(%edx){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x5a,0x79,0xa2,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2udq 485498096(%edx){1to8}, %ymm4 {%k2} 

// CHECK: vcvtpd2udq 485498096(%edx){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xda,0x79,0xa2,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2udq 485498096(%edx){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2udq -485498096(%edx,%eax,4){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x58,0x79,0xa4,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtpd2udq -485498096(%edx,%eax,4){1to8}, %ymm4 

// CHECK: vcvtpd2udq 485498096(%edx,%eax,4){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x58,0x79,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2udq 485498096(%edx,%eax,4){1to8}, %ymm4 

// CHECK: vcvtpd2udq -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x5a,0x79,0xa4,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtpd2udq -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 

// CHECK: vcvtpd2udq 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x5a,0x79,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2udq 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 

// CHECK: vcvtpd2udq -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xda,0x79,0xa4,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtpd2udq -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2udq 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xda,0x79,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2udq 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2udq -485498096(%edx,%eax,4), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x48,0x79,0xa4,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtpd2udq -485498096(%edx,%eax,4), %ymm4 

// CHECK: vcvtpd2udq 485498096(%edx,%eax,4), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x48,0x79,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2udq 485498096(%edx,%eax,4), %ymm4 

// CHECK: vcvtpd2udq -485498096(%edx,%eax,4), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x4a,0x79,0xa4,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtpd2udq -485498096(%edx,%eax,4), %ymm4 {%k2} 

// CHECK: vcvtpd2udq 485498096(%edx,%eax,4), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x4a,0x79,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2udq 485498096(%edx,%eax,4), %ymm4 {%k2} 

// CHECK: vcvtpd2udq -485498096(%edx,%eax,4), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xca,0x79,0xa4,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtpd2udq -485498096(%edx,%eax,4), %ymm4 {%k2} {z} 

// CHECK: vcvtpd2udq 485498096(%edx,%eax,4), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xca,0x79,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2udq 485498096(%edx,%eax,4), %ymm4 {%k2} {z} 

// CHECK: vcvtpd2udq 485498096(%edx), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x48,0x79,0xa2,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2udq 485498096(%edx), %ymm4 

// CHECK: vcvtpd2udq 485498096(%edx), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x4a,0x79,0xa2,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2udq 485498096(%edx), %ymm4 {%k2} 

// CHECK: vcvtpd2udq 485498096(%edx), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xca,0x79,0xa2,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2udq 485498096(%edx), %ymm4 {%k2} {z} 

// CHECK: vcvtpd2udq 485498096, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x48,0x79,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvtpd2udq 485498096, %ymm4 

// CHECK: vcvtpd2udq 485498096, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x4a,0x79,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvtpd2udq 485498096, %ymm4 {%k2} 

// CHECK: vcvtpd2udq 485498096, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xca,0x79,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvtpd2udq 485498096, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2udq 512(%edx,%eax){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x58,0x79,0x64,0x02,0x40]       
vcvtpd2udq 512(%edx,%eax){1to8}, %ymm4 

// CHECK: vcvtpd2udq 512(%edx,%eax){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x5a,0x79,0x64,0x02,0x40]      
vcvtpd2udq 512(%edx,%eax){1to8}, %ymm4 {%k2} 

// CHECK: vcvtpd2udq 512(%edx,%eax){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xda,0x79,0x64,0x02,0x40]     
vcvtpd2udq 512(%edx,%eax){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2udq (%edx){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x58,0x79,0x22]       
vcvtpd2udq (%edx){1to8}, %ymm4 

// CHECK: vcvtpd2udq (%edx){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x5a,0x79,0x22]      
vcvtpd2udq (%edx){1to8}, %ymm4 {%k2} 

// CHECK: vcvtpd2udq (%edx){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xda,0x79,0x22]     
vcvtpd2udq (%edx){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2udq (%edx), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x48,0x79,0x22]       
vcvtpd2udq (%edx), %ymm4 

// CHECK: vcvtpd2udq (%edx), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x4a,0x79,0x22]      
vcvtpd2udq (%edx), %ymm4 {%k2} 

// CHECK: vcvtpd2udq (%edx), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xca,0x79,0x22]     
vcvtpd2udq (%edx), %ymm4 {%k2} {z} 

// CHECK: vcvtpd2udq {rd-sae}, %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x38,0x79,0xe2]      
vcvtpd2udq {rd-sae}, %zmm2, %ymm4 

// CHECK: vcvtpd2udq {rd-sae}, %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x3a,0x79,0xe2]     
vcvtpd2udq {rd-sae}, %zmm2, %ymm4 {%k2} 

// CHECK: vcvtpd2udq {rd-sae}, %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xba,0x79,0xe2]    
vcvtpd2udq {rd-sae}, %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2udq {rn-sae}, %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x18,0x79,0xe2]      
vcvtpd2udq {rn-sae}, %zmm2, %ymm4 

// CHECK: vcvtpd2udq {rn-sae}, %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x1a,0x79,0xe2]     
vcvtpd2udq {rn-sae}, %zmm2, %ymm4 {%k2} 

// CHECK: vcvtpd2udq {rn-sae}, %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x9a,0x79,0xe2]    
vcvtpd2udq {rn-sae}, %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2udq {ru-sae}, %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x58,0x79,0xe2]      
vcvtpd2udq {ru-sae}, %zmm2, %ymm4 

// CHECK: vcvtpd2udq {ru-sae}, %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x5a,0x79,0xe2]     
vcvtpd2udq {ru-sae}, %zmm2, %ymm4 {%k2} 

// CHECK: vcvtpd2udq {ru-sae}, %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xda,0x79,0xe2]    
vcvtpd2udq {ru-sae}, %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2udq {rz-sae}, %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x78,0x79,0xe2]      
vcvtpd2udq {rz-sae}, %zmm2, %ymm4 

// CHECK: vcvtpd2udq {rz-sae}, %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x7a,0x79,0xe2]     
vcvtpd2udq {rz-sae}, %zmm2, %ymm4 {%k2} 

// CHECK: vcvtpd2udq {rz-sae}, %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xfa,0x79,0xe2]    
vcvtpd2udq {rz-sae}, %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvtpd2udq %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x48,0x79,0xe2]       
vcvtpd2udq %zmm2, %ymm4 

// CHECK: vcvtpd2udq %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x4a,0x79,0xe2]      
vcvtpd2udq %zmm2, %ymm4 {%k2} 

// CHECK: vcvtpd2udq %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xca,0x79,0xe2]     
vcvtpd2udq %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvtph2ps 2048(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x13,0x54,0x02,0x40]       
vcvtph2ps 2048(%edx,%eax), %zmm2 

// CHECK: vcvtph2ps 2048(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x13,0x54,0x02,0x40]      
vcvtph2ps 2048(%edx,%eax), %zmm2 {%k2} 

// CHECK: vcvtph2ps 2048(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x13,0x54,0x02,0x40]     
vcvtph2ps 2048(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vcvtph2ps -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x13,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtph2ps -485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvtph2ps 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x13,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtph2ps 485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvtph2ps -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x13,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtph2ps -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvtph2ps 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x13,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtph2ps 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvtph2ps -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x13,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtph2ps -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvtph2ps 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x13,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtph2ps 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvtph2ps 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x13,0x92,0xf0,0x1c,0xf0,0x1c]       
vcvtph2ps 485498096(%edx), %zmm2 

// CHECK: vcvtph2ps 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x13,0x92,0xf0,0x1c,0xf0,0x1c]      
vcvtph2ps 485498096(%edx), %zmm2 {%k2} 

// CHECK: vcvtph2ps 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x13,0x92,0xf0,0x1c,0xf0,0x1c]     
vcvtph2ps 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vcvtph2ps 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x13,0x15,0xf0,0x1c,0xf0,0x1c]       
vcvtph2ps 485498096, %zmm2 

// CHECK: vcvtph2ps 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x13,0x15,0xf0,0x1c,0xf0,0x1c]      
vcvtph2ps 485498096, %zmm2 {%k2} 

// CHECK: vcvtph2ps 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x13,0x15,0xf0,0x1c,0xf0,0x1c]     
vcvtph2ps 485498096, %zmm2 {%k2} {z} 

// CHECK: vcvtph2ps (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x13,0x12]       
vcvtph2ps (%edx), %zmm2 

// CHECK: vcvtph2ps (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x13,0x12]      
vcvtph2ps (%edx), %zmm2 {%k2} 

// CHECK: vcvtph2ps (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x13,0x12]     
vcvtph2ps (%edx), %zmm2 {%k2} {z} 

// CHECK: vcvtph2ps {sae}, %ymm4, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x18,0x13,0xd4]      
vcvtph2ps {sae}, %ymm4, %zmm2 

// CHECK: vcvtph2ps {sae}, %ymm4, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x1a,0x13,0xd4]     
vcvtph2ps {sae}, %ymm4, %zmm2 {%k2} 

// CHECK: vcvtph2ps {sae}, %ymm4, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x9a,0x13,0xd4]    
vcvtph2ps {sae}, %ymm4, %zmm2 {%k2} {z} 

// CHECK: vcvtph2ps %ymm4, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x13,0xd4]       
vcvtph2ps %ymm4, %zmm2 

// CHECK: vcvtph2ps %ymm4, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x13,0xd4]      
vcvtph2ps %ymm4, %zmm2 {%k2} 

// CHECK: vcvtph2ps %ymm4, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x13,0xd4]     
vcvtph2ps %ymm4, %zmm2 {%k2} {z} 

// CHECK: vcvtps2dq 256(%edx,%eax){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x58,0x5b,0x54,0x02,0x40]       
vcvtps2dq 256(%edx,%eax){1to16}, %zmm2 

// CHECK: vcvtps2dq 256(%edx,%eax){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x5a,0x5b,0x54,0x02,0x40]      
vcvtps2dq 256(%edx,%eax){1to16}, %zmm2 {%k2} 

// CHECK: vcvtps2dq 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xda,0x5b,0x54,0x02,0x40]     
vcvtps2dq 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtps2dq 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x5b,0x54,0x02,0x40]       
vcvtps2dq 4096(%edx,%eax), %zmm2 

// CHECK: vcvtps2dq 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x5b,0x54,0x02,0x40]      
vcvtps2dq 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vcvtps2dq 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xca,0x5b,0x54,0x02,0x40]     
vcvtps2dq 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vcvtps2dq 485498096{1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x58,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]       
vcvtps2dq 485498096{1to16}, %zmm2 

// CHECK: vcvtps2dq 485498096{1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x5a,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]      
vcvtps2dq 485498096{1to16}, %zmm2 {%k2} 

// CHECK: vcvtps2dq 485498096{1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xda,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]     
vcvtps2dq 485498096{1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtps2dq 485498096(%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x58,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]       
vcvtps2dq 485498096(%edx){1to16}, %zmm2 

// CHECK: vcvtps2dq 485498096(%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x5a,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]      
vcvtps2dq 485498096(%edx){1to16}, %zmm2 {%k2} 

// CHECK: vcvtps2dq 485498096(%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xda,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]     
vcvtps2dq 485498096(%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtps2dq -485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x58,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtps2dq -485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vcvtps2dq 485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x58,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtps2dq 485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vcvtps2dq -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x5a,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtps2dq -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vcvtps2dq 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x5a,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtps2dq 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vcvtps2dq -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xda,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtps2dq -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtps2dq 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xda,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtps2dq 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtps2dq -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtps2dq -485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvtps2dq 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtps2dq 485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvtps2dq -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtps2dq -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvtps2dq 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtps2dq 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvtps2dq -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xca,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtps2dq -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvtps2dq 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xca,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtps2dq 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvtps2dq 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]       
vcvtps2dq 485498096(%edx), %zmm2 

// CHECK: vcvtps2dq 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]      
vcvtps2dq 485498096(%edx), %zmm2 {%k2} 

// CHECK: vcvtps2dq 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xca,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]     
vcvtps2dq 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vcvtps2dq 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]       
vcvtps2dq 485498096, %zmm2 

// CHECK: vcvtps2dq 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]      
vcvtps2dq 485498096, %zmm2 {%k2} 

// CHECK: vcvtps2dq 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xca,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]     
vcvtps2dq 485498096, %zmm2 {%k2} {z} 

// CHECK: vcvtps2dq (%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x58,0x5b,0x12]       
vcvtps2dq (%edx){1to16}, %zmm2 

// CHECK: vcvtps2dq (%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x5a,0x5b,0x12]      
vcvtps2dq (%edx){1to16}, %zmm2 {%k2} 

// CHECK: vcvtps2dq (%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xda,0x5b,0x12]     
vcvtps2dq (%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtps2dq (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x5b,0x12]       
vcvtps2dq (%edx), %zmm2 

// CHECK: vcvtps2dq (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x5b,0x12]      
vcvtps2dq (%edx), %zmm2 {%k2} 

// CHECK: vcvtps2dq (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xca,0x5b,0x12]     
vcvtps2dq (%edx), %zmm2 {%k2} {z} 

// CHECK: vcvtps2dq {rd-sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x38,0x5b,0xd2]      
vcvtps2dq {rd-sae}, %zmm2, %zmm2 

// CHECK: vcvtps2dq {rd-sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x3a,0x5b,0xd2]     
vcvtps2dq {rd-sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vcvtps2dq {rd-sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xba,0x5b,0xd2]    
vcvtps2dq {rd-sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtps2dq {rn-sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x18,0x5b,0xd2]      
vcvtps2dq {rn-sae}, %zmm2, %zmm2 

// CHECK: vcvtps2dq {rn-sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x1a,0x5b,0xd2]     
vcvtps2dq {rn-sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vcvtps2dq {rn-sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x9a,0x5b,0xd2]    
vcvtps2dq {rn-sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtps2dq {ru-sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x58,0x5b,0xd2]      
vcvtps2dq {ru-sae}, %zmm2, %zmm2 

// CHECK: vcvtps2dq {ru-sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x5a,0x5b,0xd2]     
vcvtps2dq {ru-sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vcvtps2dq {ru-sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xda,0x5b,0xd2]    
vcvtps2dq {ru-sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtps2dq {rz-sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x78,0x5b,0xd2]      
vcvtps2dq {rz-sae}, %zmm2, %zmm2 

// CHECK: vcvtps2dq {rz-sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x7a,0x5b,0xd2]     
vcvtps2dq {rz-sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vcvtps2dq {rz-sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xfa,0x5b,0xd2]    
vcvtps2dq {rz-sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtps2dq %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x5b,0xd2]       
vcvtps2dq %zmm2, %zmm2 

// CHECK: vcvtps2dq %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x5b,0xd2]      
vcvtps2dq %zmm2, %zmm2 {%k2} 

// CHECK: vcvtps2dq %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xca,0x5b,0xd2]     
vcvtps2dq %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtps2pd 2048(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x5a,0x54,0x02,0x40]       
vcvtps2pd 2048(%edx,%eax), %zmm2 

// CHECK: vcvtps2pd 2048(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x5a,0x54,0x02,0x40]      
vcvtps2pd 2048(%edx,%eax), %zmm2 {%k2} 

// CHECK: vcvtps2pd 2048(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x5a,0x54,0x02,0x40]     
vcvtps2pd 2048(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vcvtps2pd 256(%edx,%eax){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x5a,0x54,0x02,0x40]       
vcvtps2pd 256(%edx,%eax){1to8}, %zmm2 

// CHECK: vcvtps2pd 256(%edx,%eax){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x5a,0x54,0x02,0x40]      
vcvtps2pd 256(%edx,%eax){1to8}, %zmm2 {%k2} 

// CHECK: vcvtps2pd 256(%edx,%eax){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x5a,0x54,0x02,0x40]     
vcvtps2pd 256(%edx,%eax){1to8}, %zmm2 {%k2} {z} 

// CHECK: vcvtps2pd 485498096{1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x5a,0x15,0xf0,0x1c,0xf0,0x1c]       
vcvtps2pd 485498096{1to8}, %zmm2 

// CHECK: vcvtps2pd 485498096{1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x5a,0x15,0xf0,0x1c,0xf0,0x1c]      
vcvtps2pd 485498096{1to8}, %zmm2 {%k2} 

// CHECK: vcvtps2pd 485498096{1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x5a,0x15,0xf0,0x1c,0xf0,0x1c]     
vcvtps2pd 485498096{1to8}, %zmm2 {%k2} {z} 

// CHECK: vcvtps2pd 485498096(%edx){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x5a,0x92,0xf0,0x1c,0xf0,0x1c]       
vcvtps2pd 485498096(%edx){1to8}, %zmm2 

// CHECK: vcvtps2pd 485498096(%edx){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x5a,0x92,0xf0,0x1c,0xf0,0x1c]      
vcvtps2pd 485498096(%edx){1to8}, %zmm2 {%k2} 

// CHECK: vcvtps2pd 485498096(%edx){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x5a,0x92,0xf0,0x1c,0xf0,0x1c]     
vcvtps2pd 485498096(%edx){1to8}, %zmm2 {%k2} {z} 

// CHECK: vcvtps2pd -485498096(%edx,%eax,4){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x5a,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtps2pd -485498096(%edx,%eax,4){1to8}, %zmm2 

// CHECK: vcvtps2pd 485498096(%edx,%eax,4){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x5a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtps2pd 485498096(%edx,%eax,4){1to8}, %zmm2 

// CHECK: vcvtps2pd -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x5a,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtps2pd -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 

// CHECK: vcvtps2pd 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x5a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtps2pd 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 

// CHECK: vcvtps2pd -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x5a,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtps2pd -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 

// CHECK: vcvtps2pd 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x5a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtps2pd 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 

// CHECK: vcvtps2pd -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x5a,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtps2pd -485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvtps2pd 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x5a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtps2pd 485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvtps2pd -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x5a,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtps2pd -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvtps2pd 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x5a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtps2pd 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvtps2pd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x5a,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtps2pd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvtps2pd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x5a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtps2pd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvtps2pd 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x5a,0x92,0xf0,0x1c,0xf0,0x1c]       
vcvtps2pd 485498096(%edx), %zmm2 

// CHECK: vcvtps2pd 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x5a,0x92,0xf0,0x1c,0xf0,0x1c]      
vcvtps2pd 485498096(%edx), %zmm2 {%k2} 

// CHECK: vcvtps2pd 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x5a,0x92,0xf0,0x1c,0xf0,0x1c]     
vcvtps2pd 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vcvtps2pd 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x5a,0x15,0xf0,0x1c,0xf0,0x1c]       
vcvtps2pd 485498096, %zmm2 

// CHECK: vcvtps2pd 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x5a,0x15,0xf0,0x1c,0xf0,0x1c]      
vcvtps2pd 485498096, %zmm2 {%k2} 

// CHECK: vcvtps2pd 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x5a,0x15,0xf0,0x1c,0xf0,0x1c]     
vcvtps2pd 485498096, %zmm2 {%k2} {z} 

// CHECK: vcvtps2pd (%edx){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x5a,0x12]       
vcvtps2pd (%edx){1to8}, %zmm2 

// CHECK: vcvtps2pd (%edx){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x5a,0x12]      
vcvtps2pd (%edx){1to8}, %zmm2 {%k2} 

// CHECK: vcvtps2pd (%edx){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x5a,0x12]     
vcvtps2pd (%edx){1to8}, %zmm2 {%k2} {z} 

// CHECK: vcvtps2pd (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x5a,0x12]       
vcvtps2pd (%edx), %zmm2 

// CHECK: vcvtps2pd (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x5a,0x12]      
vcvtps2pd (%edx), %zmm2 {%k2} 

// CHECK: vcvtps2pd (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x5a,0x12]     
vcvtps2pd (%edx), %zmm2 {%k2} {z} 

// CHECK: vcvtps2pd {sae}, %ymm4, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x18,0x5a,0xd4]      
vcvtps2pd {sae}, %ymm4, %zmm2 

// CHECK: vcvtps2pd {sae}, %ymm4, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x1a,0x5a,0xd4]     
vcvtps2pd {sae}, %ymm4, %zmm2 {%k2} 

// CHECK: vcvtps2pd {sae}, %ymm4, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x9a,0x5a,0xd4]    
vcvtps2pd {sae}, %ymm4, %zmm2 {%k2} {z} 

// CHECK: vcvtps2pd %ymm4, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x5a,0xd4]       
vcvtps2pd %ymm4, %zmm2 

// CHECK: vcvtps2pd %ymm4, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x5a,0xd4]      
vcvtps2pd %ymm4, %zmm2 {%k2} 

// CHECK: vcvtps2pd %ymm4, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x5a,0xd4]     
vcvtps2pd %ymm4, %zmm2 {%k2} {z} 

// CHECK: vcvtps2ph $0, {sae}, %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf3,0x7d,0x18,0x1d,0xd4,0x00]     
vcvtps2ph $0, {sae}, %zmm2, %ymm4 

// CHECK: vcvtps2ph $0, {sae}, %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x1a,0x1d,0xd4,0x00]    
vcvtps2ph $0, {sae}, %zmm2, %ymm4 {%k2} 

// CHECK: vcvtps2ph $0, {sae}, %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x9a,0x1d,0xd4,0x00]   
vcvtps2ph $0, {sae}, %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvtps2ph $0, %zmm2, 2048(%edx,%eax) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x1d,0x54,0x02,0x40,0x00]      
vcvtps2ph $0, %zmm2, 2048(%edx,%eax) 

// CHECK: vcvtps2ph $0, %zmm2, 2048(%edx,%eax) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x1d,0x54,0x02,0x40,0x00]     
vcvtps2ph $0, %zmm2, 2048(%edx,%eax) {%k2} 

// CHECK: vcvtps2ph $0, %zmm2, -485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x1d,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vcvtps2ph $0, %zmm2, -485498096(%edx,%eax,4) 

// CHECK: vcvtps2ph $0, %zmm2, 485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x1d,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vcvtps2ph $0, %zmm2, 485498096(%edx,%eax,4) 

// CHECK: vcvtps2ph $0, %zmm2, -485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x1d,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vcvtps2ph $0, %zmm2, -485498096(%edx,%eax,4) {%k2} 

// CHECK: vcvtps2ph $0, %zmm2, 485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x1d,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vcvtps2ph $0, %zmm2, 485498096(%edx,%eax,4) {%k2} 

// CHECK: vcvtps2ph $0, %zmm2, 485498096(%edx) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x1d,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vcvtps2ph $0, %zmm2, 485498096(%edx) 

// CHECK: vcvtps2ph $0, %zmm2, 485498096(%edx) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x1d,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vcvtps2ph $0, %zmm2, 485498096(%edx) {%k2} 

// CHECK: vcvtps2ph $0, %zmm2, 485498096 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x1d,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vcvtps2ph $0, %zmm2, 485498096 

// CHECK: vcvtps2ph $0, %zmm2, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x1d,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vcvtps2ph $0, %zmm2, 485498096 {%k2} 

// CHECK: vcvtps2ph $0, %zmm2, (%edx) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x1d,0x12,0x00]      
vcvtps2ph $0, %zmm2, (%edx) 

// CHECK: vcvtps2ph $0, %zmm2, (%edx) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x1d,0x12,0x00]     
vcvtps2ph $0, %zmm2, (%edx) {%k2} 

// CHECK: vcvtps2ph $0, %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x1d,0xd4,0x00]      
vcvtps2ph $0, %zmm2, %ymm4 

// CHECK: vcvtps2ph $0, %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x1d,0xd4,0x00]     
vcvtps2ph $0, %zmm2, %ymm4 {%k2} 

// CHECK: vcvtps2ph $0, %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xca,0x1d,0xd4,0x00]    
vcvtps2ph $0, %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvtps2udq 256(%edx,%eax){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x79,0x54,0x02,0x40]       
vcvtps2udq 256(%edx,%eax){1to16}, %zmm2 

// CHECK: vcvtps2udq 256(%edx,%eax){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x79,0x54,0x02,0x40]      
vcvtps2udq 256(%edx,%eax){1to16}, %zmm2 {%k2} 

// CHECK: vcvtps2udq 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x79,0x54,0x02,0x40]     
vcvtps2udq 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtps2udq 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x79,0x54,0x02,0x40]       
vcvtps2udq 4096(%edx,%eax), %zmm2 

// CHECK: vcvtps2udq 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x79,0x54,0x02,0x40]      
vcvtps2udq 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vcvtps2udq 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x79,0x54,0x02,0x40]     
vcvtps2udq 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vcvtps2udq 485498096{1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x79,0x15,0xf0,0x1c,0xf0,0x1c]       
vcvtps2udq 485498096{1to16}, %zmm2 

// CHECK: vcvtps2udq 485498096{1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x79,0x15,0xf0,0x1c,0xf0,0x1c]      
vcvtps2udq 485498096{1to16}, %zmm2 {%k2} 

// CHECK: vcvtps2udq 485498096{1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x79,0x15,0xf0,0x1c,0xf0,0x1c]     
vcvtps2udq 485498096{1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtps2udq 485498096(%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x79,0x92,0xf0,0x1c,0xf0,0x1c]       
vcvtps2udq 485498096(%edx){1to16}, %zmm2 

// CHECK: vcvtps2udq 485498096(%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x79,0x92,0xf0,0x1c,0xf0,0x1c]      
vcvtps2udq 485498096(%edx){1to16}, %zmm2 {%k2} 

// CHECK: vcvtps2udq 485498096(%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x79,0x92,0xf0,0x1c,0xf0,0x1c]     
vcvtps2udq 485498096(%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtps2udq -485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x79,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtps2udq -485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vcvtps2udq 485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x79,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtps2udq 485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vcvtps2udq -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x79,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtps2udq -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vcvtps2udq 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x79,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtps2udq 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vcvtps2udq -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x79,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtps2udq -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtps2udq 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x79,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtps2udq 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtps2udq -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x79,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtps2udq -485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvtps2udq 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x79,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtps2udq 485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvtps2udq -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x79,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtps2udq -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvtps2udq 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x79,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtps2udq 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvtps2udq -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x79,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtps2udq -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvtps2udq 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x79,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtps2udq 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvtps2udq 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x79,0x92,0xf0,0x1c,0xf0,0x1c]       
vcvtps2udq 485498096(%edx), %zmm2 

// CHECK: vcvtps2udq 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x79,0x92,0xf0,0x1c,0xf0,0x1c]      
vcvtps2udq 485498096(%edx), %zmm2 {%k2} 

// CHECK: vcvtps2udq 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x79,0x92,0xf0,0x1c,0xf0,0x1c]     
vcvtps2udq 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vcvtps2udq 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x79,0x15,0xf0,0x1c,0xf0,0x1c]       
vcvtps2udq 485498096, %zmm2 

// CHECK: vcvtps2udq 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x79,0x15,0xf0,0x1c,0xf0,0x1c]      
vcvtps2udq 485498096, %zmm2 {%k2} 

// CHECK: vcvtps2udq 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x79,0x15,0xf0,0x1c,0xf0,0x1c]     
vcvtps2udq 485498096, %zmm2 {%k2} {z} 

// CHECK: vcvtps2udq (%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x79,0x12]       
vcvtps2udq (%edx){1to16}, %zmm2 

// CHECK: vcvtps2udq (%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x79,0x12]      
vcvtps2udq (%edx){1to16}, %zmm2 {%k2} 

// CHECK: vcvtps2udq (%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x79,0x12]     
vcvtps2udq (%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtps2udq (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x79,0x12]       
vcvtps2udq (%edx), %zmm2 

// CHECK: vcvtps2udq (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x79,0x12]      
vcvtps2udq (%edx), %zmm2 {%k2} 

// CHECK: vcvtps2udq (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x79,0x12]     
vcvtps2udq (%edx), %zmm2 {%k2} {z} 

// CHECK: vcvtps2udq {rd-sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x38,0x79,0xd2]      
vcvtps2udq {rd-sae}, %zmm2, %zmm2 

// CHECK: vcvtps2udq {rd-sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x3a,0x79,0xd2]     
vcvtps2udq {rd-sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vcvtps2udq {rd-sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xba,0x79,0xd2]    
vcvtps2udq {rd-sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtps2udq {rn-sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x18,0x79,0xd2]      
vcvtps2udq {rn-sae}, %zmm2, %zmm2 

// CHECK: vcvtps2udq {rn-sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x1a,0x79,0xd2]     
vcvtps2udq {rn-sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vcvtps2udq {rn-sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x9a,0x79,0xd2]    
vcvtps2udq {rn-sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtps2udq {ru-sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x79,0xd2]      
vcvtps2udq {ru-sae}, %zmm2, %zmm2 

// CHECK: vcvtps2udq {ru-sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x79,0xd2]     
vcvtps2udq {ru-sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vcvtps2udq {ru-sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x79,0xd2]    
vcvtps2udq {ru-sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtps2udq {rz-sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x78,0x79,0xd2]      
vcvtps2udq {rz-sae}, %zmm2, %zmm2 

// CHECK: vcvtps2udq {rz-sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x7a,0x79,0xd2]     
vcvtps2udq {rz-sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vcvtps2udq {rz-sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xfa,0x79,0xd2]    
vcvtps2udq {rz-sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtps2udq %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x79,0xd2]       
vcvtps2udq %zmm2, %zmm2 

// CHECK: vcvtps2udq %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x79,0xd2]      
vcvtps2udq %zmm2, %zmm2 {%k2} 

// CHECK: vcvtps2udq %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x79,0xd2]     
vcvtps2udq %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvttpd2dq 4096(%edx,%eax), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0xe6,0x64,0x02,0x40]       
vcvttpd2dq 4096(%edx,%eax), %ymm4 

// CHECK: vcvttpd2dq 4096(%edx,%eax), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0xe6,0x64,0x02,0x40]      
vcvttpd2dq 4096(%edx,%eax), %ymm4 {%k2} 

// CHECK: vcvttpd2dq 4096(%edx,%eax), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0xe6,0x64,0x02,0x40]     
vcvttpd2dq 4096(%edx,%eax), %ymm4 {%k2} {z} 

// CHECK: vcvttpd2dq 485498096{1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x58,0xe6,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvttpd2dq 485498096{1to8}, %ymm4 

// CHECK: vcvttpd2dq 485498096{1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x5a,0xe6,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvttpd2dq 485498096{1to8}, %ymm4 {%k2} 

// CHECK: vcvttpd2dq 485498096{1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xda,0xe6,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvttpd2dq 485498096{1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvttpd2dq 485498096(%edx){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x58,0xe6,0xa2,0xf0,0x1c,0xf0,0x1c]       
vcvttpd2dq 485498096(%edx){1to8}, %ymm4 

// CHECK: vcvttpd2dq 485498096(%edx){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x5a,0xe6,0xa2,0xf0,0x1c,0xf0,0x1c]      
vcvttpd2dq 485498096(%edx){1to8}, %ymm4 {%k2} 

// CHECK: vcvttpd2dq 485498096(%edx){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xda,0xe6,0xa2,0xf0,0x1c,0xf0,0x1c]     
vcvttpd2dq 485498096(%edx){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvttpd2dq -485498096(%edx,%eax,4){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x58,0xe6,0xa4,0x82,0x10,0xe3,0x0f,0xe3]       
vcvttpd2dq -485498096(%edx,%eax,4){1to8}, %ymm4 

// CHECK: vcvttpd2dq 485498096(%edx,%eax,4){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x58,0xe6,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvttpd2dq 485498096(%edx,%eax,4){1to8}, %ymm4 

// CHECK: vcvttpd2dq -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x5a,0xe6,0xa4,0x82,0x10,0xe3,0x0f,0xe3]      
vcvttpd2dq -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 

// CHECK: vcvttpd2dq 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x5a,0xe6,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvttpd2dq 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 

// CHECK: vcvttpd2dq -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xda,0xe6,0xa4,0x82,0x10,0xe3,0x0f,0xe3]     
vcvttpd2dq -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvttpd2dq 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xda,0xe6,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvttpd2dq 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvttpd2dq -485498096(%edx,%eax,4), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0xe6,0xa4,0x82,0x10,0xe3,0x0f,0xe3]       
vcvttpd2dq -485498096(%edx,%eax,4), %ymm4 

// CHECK: vcvttpd2dq 485498096(%edx,%eax,4), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0xe6,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvttpd2dq 485498096(%edx,%eax,4), %ymm4 

// CHECK: vcvttpd2dq -485498096(%edx,%eax,4), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0xe6,0xa4,0x82,0x10,0xe3,0x0f,0xe3]      
vcvttpd2dq -485498096(%edx,%eax,4), %ymm4 {%k2} 

// CHECK: vcvttpd2dq 485498096(%edx,%eax,4), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0xe6,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvttpd2dq 485498096(%edx,%eax,4), %ymm4 {%k2} 

// CHECK: vcvttpd2dq -485498096(%edx,%eax,4), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0xe6,0xa4,0x82,0x10,0xe3,0x0f,0xe3]     
vcvttpd2dq -485498096(%edx,%eax,4), %ymm4 {%k2} {z} 

// CHECK: vcvttpd2dq 485498096(%edx,%eax,4), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0xe6,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvttpd2dq 485498096(%edx,%eax,4), %ymm4 {%k2} {z} 

// CHECK: vcvttpd2dq 485498096(%edx), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0xe6,0xa2,0xf0,0x1c,0xf0,0x1c]       
vcvttpd2dq 485498096(%edx), %ymm4 

// CHECK: vcvttpd2dq 485498096(%edx), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0xe6,0xa2,0xf0,0x1c,0xf0,0x1c]      
vcvttpd2dq 485498096(%edx), %ymm4 {%k2} 

// CHECK: vcvttpd2dq 485498096(%edx), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0xe6,0xa2,0xf0,0x1c,0xf0,0x1c]     
vcvttpd2dq 485498096(%edx), %ymm4 {%k2} {z} 

// CHECK: vcvttpd2dq 485498096, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0xe6,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvttpd2dq 485498096, %ymm4 

// CHECK: vcvttpd2dq 485498096, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0xe6,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvttpd2dq 485498096, %ymm4 {%k2} 

// CHECK: vcvttpd2dq 485498096, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0xe6,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvttpd2dq 485498096, %ymm4 {%k2} {z} 

// CHECK: vcvttpd2dq 512(%edx,%eax){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x58,0xe6,0x64,0x02,0x40]       
vcvttpd2dq 512(%edx,%eax){1to8}, %ymm4 

// CHECK: vcvttpd2dq 512(%edx,%eax){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x5a,0xe6,0x64,0x02,0x40]      
vcvttpd2dq 512(%edx,%eax){1to8}, %ymm4 {%k2} 

// CHECK: vcvttpd2dq 512(%edx,%eax){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xda,0xe6,0x64,0x02,0x40]     
vcvttpd2dq 512(%edx,%eax){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvttpd2dq (%edx){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x58,0xe6,0x22]       
vcvttpd2dq (%edx){1to8}, %ymm4 

// CHECK: vcvttpd2dq (%edx){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x5a,0xe6,0x22]      
vcvttpd2dq (%edx){1to8}, %ymm4 {%k2} 

// CHECK: vcvttpd2dq (%edx){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xda,0xe6,0x22]     
vcvttpd2dq (%edx){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvttpd2dq (%edx), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0xe6,0x22]       
vcvttpd2dq (%edx), %ymm4 

// CHECK: vcvttpd2dq (%edx), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0xe6,0x22]      
vcvttpd2dq (%edx), %ymm4 {%k2} 

// CHECK: vcvttpd2dq (%edx), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0xe6,0x22]     
vcvttpd2dq (%edx), %ymm4 {%k2} {z} 

// CHECK: vcvttpd2dq {sae}, %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x18,0xe6,0xe2]      
vcvttpd2dq {sae}, %zmm2, %ymm4 

// CHECK: vcvttpd2dq {sae}, %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x1a,0xe6,0xe2]     
vcvttpd2dq {sae}, %zmm2, %ymm4 {%k2} 

// CHECK: vcvttpd2dq {sae}, %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x9a,0xe6,0xe2]    
vcvttpd2dq {sae}, %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvttpd2dq %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0xe6,0xe2]       
vcvttpd2dq %zmm2, %ymm4 

// CHECK: vcvttpd2dq %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0xe6,0xe2]      
vcvttpd2dq %zmm2, %ymm4 {%k2} 

// CHECK: vcvttpd2dq %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0xe6,0xe2]     
vcvttpd2dq %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvttpd2udq 4096(%edx,%eax), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x48,0x78,0x64,0x02,0x40]       
vcvttpd2udq 4096(%edx,%eax), %ymm4 

// CHECK: vcvttpd2udq 4096(%edx,%eax), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x4a,0x78,0x64,0x02,0x40]      
vcvttpd2udq 4096(%edx,%eax), %ymm4 {%k2} 

// CHECK: vcvttpd2udq 4096(%edx,%eax), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xca,0x78,0x64,0x02,0x40]     
vcvttpd2udq 4096(%edx,%eax), %ymm4 {%k2} {z} 

// CHECK: vcvttpd2udq 485498096{1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x58,0x78,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvttpd2udq 485498096{1to8}, %ymm4 

// CHECK: vcvttpd2udq 485498096{1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x5a,0x78,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvttpd2udq 485498096{1to8}, %ymm4 {%k2} 

// CHECK: vcvttpd2udq 485498096{1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xda,0x78,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvttpd2udq 485498096{1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvttpd2udq 485498096(%edx){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x58,0x78,0xa2,0xf0,0x1c,0xf0,0x1c]       
vcvttpd2udq 485498096(%edx){1to8}, %ymm4 

// CHECK: vcvttpd2udq 485498096(%edx){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x5a,0x78,0xa2,0xf0,0x1c,0xf0,0x1c]      
vcvttpd2udq 485498096(%edx){1to8}, %ymm4 {%k2} 

// CHECK: vcvttpd2udq 485498096(%edx){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xda,0x78,0xa2,0xf0,0x1c,0xf0,0x1c]     
vcvttpd2udq 485498096(%edx){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvttpd2udq -485498096(%edx,%eax,4){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x58,0x78,0xa4,0x82,0x10,0xe3,0x0f,0xe3]       
vcvttpd2udq -485498096(%edx,%eax,4){1to8}, %ymm4 

// CHECK: vcvttpd2udq 485498096(%edx,%eax,4){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x58,0x78,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvttpd2udq 485498096(%edx,%eax,4){1to8}, %ymm4 

// CHECK: vcvttpd2udq -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x5a,0x78,0xa4,0x82,0x10,0xe3,0x0f,0xe3]      
vcvttpd2udq -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 

// CHECK: vcvttpd2udq 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x5a,0x78,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvttpd2udq 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} 

// CHECK: vcvttpd2udq -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xda,0x78,0xa4,0x82,0x10,0xe3,0x0f,0xe3]     
vcvttpd2udq -485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvttpd2udq 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xda,0x78,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvttpd2udq 485498096(%edx,%eax,4){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvttpd2udq -485498096(%edx,%eax,4), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x48,0x78,0xa4,0x82,0x10,0xe3,0x0f,0xe3]       
vcvttpd2udq -485498096(%edx,%eax,4), %ymm4 

// CHECK: vcvttpd2udq 485498096(%edx,%eax,4), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x48,0x78,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvttpd2udq 485498096(%edx,%eax,4), %ymm4 

// CHECK: vcvttpd2udq -485498096(%edx,%eax,4), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x4a,0x78,0xa4,0x82,0x10,0xe3,0x0f,0xe3]      
vcvttpd2udq -485498096(%edx,%eax,4), %ymm4 {%k2} 

// CHECK: vcvttpd2udq 485498096(%edx,%eax,4), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x4a,0x78,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvttpd2udq 485498096(%edx,%eax,4), %ymm4 {%k2} 

// CHECK: vcvttpd2udq -485498096(%edx,%eax,4), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xca,0x78,0xa4,0x82,0x10,0xe3,0x0f,0xe3]     
vcvttpd2udq -485498096(%edx,%eax,4), %ymm4 {%k2} {z} 

// CHECK: vcvttpd2udq 485498096(%edx,%eax,4), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xca,0x78,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvttpd2udq 485498096(%edx,%eax,4), %ymm4 {%k2} {z} 

// CHECK: vcvttpd2udq 485498096(%edx), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x48,0x78,0xa2,0xf0,0x1c,0xf0,0x1c]       
vcvttpd2udq 485498096(%edx), %ymm4 

// CHECK: vcvttpd2udq 485498096(%edx), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x4a,0x78,0xa2,0xf0,0x1c,0xf0,0x1c]      
vcvttpd2udq 485498096(%edx), %ymm4 {%k2} 

// CHECK: vcvttpd2udq 485498096(%edx), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xca,0x78,0xa2,0xf0,0x1c,0xf0,0x1c]     
vcvttpd2udq 485498096(%edx), %ymm4 {%k2} {z} 

// CHECK: vcvttpd2udq 485498096, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x48,0x78,0x25,0xf0,0x1c,0xf0,0x1c]       
vcvttpd2udq 485498096, %ymm4 

// CHECK: vcvttpd2udq 485498096, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x4a,0x78,0x25,0xf0,0x1c,0xf0,0x1c]      
vcvttpd2udq 485498096, %ymm4 {%k2} 

// CHECK: vcvttpd2udq 485498096, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xca,0x78,0x25,0xf0,0x1c,0xf0,0x1c]     
vcvttpd2udq 485498096, %ymm4 {%k2} {z} 

// CHECK: vcvttpd2udq 512(%edx,%eax){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x58,0x78,0x64,0x02,0x40]       
vcvttpd2udq 512(%edx,%eax){1to8}, %ymm4 

// CHECK: vcvttpd2udq 512(%edx,%eax){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x5a,0x78,0x64,0x02,0x40]      
vcvttpd2udq 512(%edx,%eax){1to8}, %ymm4 {%k2} 

// CHECK: vcvttpd2udq 512(%edx,%eax){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xda,0x78,0x64,0x02,0x40]     
vcvttpd2udq 512(%edx,%eax){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvttpd2udq (%edx){1to8}, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x58,0x78,0x22]       
vcvttpd2udq (%edx){1to8}, %ymm4 

// CHECK: vcvttpd2udq (%edx){1to8}, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x5a,0x78,0x22]      
vcvttpd2udq (%edx){1to8}, %ymm4 {%k2} 

// CHECK: vcvttpd2udq (%edx){1to8}, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xda,0x78,0x22]     
vcvttpd2udq (%edx){1to8}, %ymm4 {%k2} {z} 

// CHECK: vcvttpd2udq (%edx), %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x48,0x78,0x22]       
vcvttpd2udq (%edx), %ymm4 

// CHECK: vcvttpd2udq (%edx), %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x4a,0x78,0x22]      
vcvttpd2udq (%edx), %ymm4 {%k2} 

// CHECK: vcvttpd2udq (%edx), %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xca,0x78,0x22]     
vcvttpd2udq (%edx), %ymm4 {%k2} {z} 

// CHECK: vcvttpd2udq {sae}, %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x18,0x78,0xe2]      
vcvttpd2udq {sae}, %zmm2, %ymm4 

// CHECK: vcvttpd2udq {sae}, %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x1a,0x78,0xe2]     
vcvttpd2udq {sae}, %zmm2, %ymm4 {%k2} 

// CHECK: vcvttpd2udq {sae}, %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x9a,0x78,0xe2]    
vcvttpd2udq {sae}, %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvttpd2udq %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf1,0xfc,0x48,0x78,0xe2]       
vcvttpd2udq %zmm2, %ymm4 

// CHECK: vcvttpd2udq %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfc,0x4a,0x78,0xe2]      
vcvttpd2udq %zmm2, %ymm4 {%k2} 

// CHECK: vcvttpd2udq %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfc,0xca,0x78,0xe2]     
vcvttpd2udq %zmm2, %ymm4 {%k2} {z} 

// CHECK: vcvttps2dq 256(%edx,%eax){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x58,0x5b,0x54,0x02,0x40]       
vcvttps2dq 256(%edx,%eax){1to16}, %zmm2 

// CHECK: vcvttps2dq 256(%edx,%eax){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x5a,0x5b,0x54,0x02,0x40]      
vcvttps2dq 256(%edx,%eax){1to16}, %zmm2 {%k2} 

// CHECK: vcvttps2dq 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xda,0x5b,0x54,0x02,0x40]     
vcvttps2dq 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvttps2dq 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x5b,0x54,0x02,0x40]       
vcvttps2dq 4096(%edx,%eax), %zmm2 

// CHECK: vcvttps2dq 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x5b,0x54,0x02,0x40]      
vcvttps2dq 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vcvttps2dq 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x5b,0x54,0x02,0x40]     
vcvttps2dq 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vcvttps2dq 485498096{1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x58,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]       
vcvttps2dq 485498096{1to16}, %zmm2 

// CHECK: vcvttps2dq 485498096{1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x5a,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]      
vcvttps2dq 485498096{1to16}, %zmm2 {%k2} 

// CHECK: vcvttps2dq 485498096{1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xda,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]     
vcvttps2dq 485498096{1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvttps2dq 485498096(%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x58,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]       
vcvttps2dq 485498096(%edx){1to16}, %zmm2 

// CHECK: vcvttps2dq 485498096(%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x5a,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]      
vcvttps2dq 485498096(%edx){1to16}, %zmm2 {%k2} 

// CHECK: vcvttps2dq 485498096(%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xda,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]     
vcvttps2dq 485498096(%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvttps2dq -485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x58,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcvttps2dq -485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vcvttps2dq 485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x58,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvttps2dq 485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vcvttps2dq -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x5a,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcvttps2dq -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vcvttps2dq 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x5a,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvttps2dq 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vcvttps2dq -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xda,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vcvttps2dq -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvttps2dq 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xda,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvttps2dq 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvttps2dq -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcvttps2dq -485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvttps2dq 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvttps2dq 485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvttps2dq -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcvttps2dq -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvttps2dq 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvttps2dq 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvttps2dq -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x5b,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vcvttps2dq -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvttps2dq 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x5b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvttps2dq 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvttps2dq 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]       
vcvttps2dq 485498096(%edx), %zmm2 

// CHECK: vcvttps2dq 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]      
vcvttps2dq 485498096(%edx), %zmm2 {%k2} 

// CHECK: vcvttps2dq 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x5b,0x92,0xf0,0x1c,0xf0,0x1c]     
vcvttps2dq 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vcvttps2dq 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]       
vcvttps2dq 485498096, %zmm2 

// CHECK: vcvttps2dq 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]      
vcvttps2dq 485498096, %zmm2 {%k2} 

// CHECK: vcvttps2dq 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x5b,0x15,0xf0,0x1c,0xf0,0x1c]     
vcvttps2dq 485498096, %zmm2 {%k2} {z} 

// CHECK: vcvttps2dq (%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x58,0x5b,0x12]       
vcvttps2dq (%edx){1to16}, %zmm2 

// CHECK: vcvttps2dq (%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x5a,0x5b,0x12]      
vcvttps2dq (%edx){1to16}, %zmm2 {%k2} 

// CHECK: vcvttps2dq (%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xda,0x5b,0x12]     
vcvttps2dq (%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvttps2dq (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x5b,0x12]       
vcvttps2dq (%edx), %zmm2 

// CHECK: vcvttps2dq (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x5b,0x12]      
vcvttps2dq (%edx), %zmm2 {%k2} 

// CHECK: vcvttps2dq (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x5b,0x12]     
vcvttps2dq (%edx), %zmm2 {%k2} {z} 

// CHECK: vcvttps2dq {sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x18,0x5b,0xd2]      
vcvttps2dq {sae}, %zmm2, %zmm2 

// CHECK: vcvttps2dq {sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x1a,0x5b,0xd2]     
vcvttps2dq {sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vcvttps2dq {sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x9a,0x5b,0xd2]    
vcvttps2dq {sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvttps2dq %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x5b,0xd2]       
vcvttps2dq %zmm2, %zmm2 

// CHECK: vcvttps2dq %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x5b,0xd2]      
vcvttps2dq %zmm2, %zmm2 {%k2} 

// CHECK: vcvttps2dq %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x5b,0xd2]     
vcvttps2dq %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvttps2udq 256(%edx,%eax){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x78,0x54,0x02,0x40]       
vcvttps2udq 256(%edx,%eax){1to16}, %zmm2 

// CHECK: vcvttps2udq 256(%edx,%eax){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x78,0x54,0x02,0x40]      
vcvttps2udq 256(%edx,%eax){1to16}, %zmm2 {%k2} 

// CHECK: vcvttps2udq 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x78,0x54,0x02,0x40]     
vcvttps2udq 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvttps2udq 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x78,0x54,0x02,0x40]       
vcvttps2udq 4096(%edx,%eax), %zmm2 

// CHECK: vcvttps2udq 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x78,0x54,0x02,0x40]      
vcvttps2udq 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vcvttps2udq 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x78,0x54,0x02,0x40]     
vcvttps2udq 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vcvttps2udq 485498096{1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x78,0x15,0xf0,0x1c,0xf0,0x1c]       
vcvttps2udq 485498096{1to16}, %zmm2 

// CHECK: vcvttps2udq 485498096{1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x78,0x15,0xf0,0x1c,0xf0,0x1c]      
vcvttps2udq 485498096{1to16}, %zmm2 {%k2} 

// CHECK: vcvttps2udq 485498096{1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x78,0x15,0xf0,0x1c,0xf0,0x1c]     
vcvttps2udq 485498096{1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvttps2udq 485498096(%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x78,0x92,0xf0,0x1c,0xf0,0x1c]       
vcvttps2udq 485498096(%edx){1to16}, %zmm2 

// CHECK: vcvttps2udq 485498096(%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x78,0x92,0xf0,0x1c,0xf0,0x1c]      
vcvttps2udq 485498096(%edx){1to16}, %zmm2 {%k2} 

// CHECK: vcvttps2udq 485498096(%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x78,0x92,0xf0,0x1c,0xf0,0x1c]     
vcvttps2udq 485498096(%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvttps2udq -485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x78,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcvttps2udq -485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vcvttps2udq 485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x78,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvttps2udq 485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vcvttps2udq -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x78,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcvttps2udq -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vcvttps2udq 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x78,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvttps2udq 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vcvttps2udq -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x78,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vcvttps2udq -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvttps2udq 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x78,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvttps2udq 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvttps2udq -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x78,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcvttps2udq -485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvttps2udq 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x78,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvttps2udq 485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvttps2udq -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x78,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcvttps2udq -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvttps2udq 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x78,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvttps2udq 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvttps2udq -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x78,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vcvttps2udq -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvttps2udq 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x78,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvttps2udq 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvttps2udq 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x78,0x92,0xf0,0x1c,0xf0,0x1c]       
vcvttps2udq 485498096(%edx), %zmm2 

// CHECK: vcvttps2udq 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x78,0x92,0xf0,0x1c,0xf0,0x1c]      
vcvttps2udq 485498096(%edx), %zmm2 {%k2} 

// CHECK: vcvttps2udq 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x78,0x92,0xf0,0x1c,0xf0,0x1c]     
vcvttps2udq 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vcvttps2udq 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x78,0x15,0xf0,0x1c,0xf0,0x1c]       
vcvttps2udq 485498096, %zmm2 

// CHECK: vcvttps2udq 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x78,0x15,0xf0,0x1c,0xf0,0x1c]      
vcvttps2udq 485498096, %zmm2 {%k2} 

// CHECK: vcvttps2udq 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x78,0x15,0xf0,0x1c,0xf0,0x1c]     
vcvttps2udq 485498096, %zmm2 {%k2} {z} 

// CHECK: vcvttps2udq (%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x58,0x78,0x12]       
vcvttps2udq (%edx){1to16}, %zmm2 

// CHECK: vcvttps2udq (%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x5a,0x78,0x12]      
vcvttps2udq (%edx){1to16}, %zmm2 {%k2} 

// CHECK: vcvttps2udq (%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xda,0x78,0x12]     
vcvttps2udq (%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvttps2udq (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x78,0x12]       
vcvttps2udq (%edx), %zmm2 

// CHECK: vcvttps2udq (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x78,0x12]      
vcvttps2udq (%edx), %zmm2 {%k2} 

// CHECK: vcvttps2udq (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x78,0x12]     
vcvttps2udq (%edx), %zmm2 {%k2} {z} 

// CHECK: vcvttps2udq {sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x18,0x78,0xd2]      
vcvttps2udq {sae}, %zmm2, %zmm2 

// CHECK: vcvttps2udq {sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x1a,0x78,0xd2]     
vcvttps2udq {sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vcvttps2udq {sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x9a,0x78,0xd2]    
vcvttps2udq {sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvttps2udq %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x78,0xd2]       
vcvttps2udq %zmm2, %zmm2 

// CHECK: vcvttps2udq %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x78,0xd2]      
vcvttps2udq %zmm2, %zmm2 {%k2} 

// CHECK: vcvttps2udq %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x78,0xd2]     
vcvttps2udq %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2pd 2048(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x7a,0x54,0x02,0x40]       
vcvtudq2pd 2048(%edx,%eax), %zmm2 

// CHECK: vcvtudq2pd 2048(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x7a,0x54,0x02,0x40]      
vcvtudq2pd 2048(%edx,%eax), %zmm2 {%k2} 

// CHECK: vcvtudq2pd 2048(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x7a,0x54,0x02,0x40]     
vcvtudq2pd 2048(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vcvtudq2pd 256(%edx,%eax){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x58,0x7a,0x54,0x02,0x40]       
vcvtudq2pd 256(%edx,%eax){1to8}, %zmm2 

// CHECK: vcvtudq2pd 256(%edx,%eax){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x5a,0x7a,0x54,0x02,0x40]      
vcvtudq2pd 256(%edx,%eax){1to8}, %zmm2 {%k2} 

// CHECK: vcvtudq2pd 256(%edx,%eax){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xda,0x7a,0x54,0x02,0x40]     
vcvtudq2pd 256(%edx,%eax){1to8}, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2pd 485498096{1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x58,0x7a,0x15,0xf0,0x1c,0xf0,0x1c]       
vcvtudq2pd 485498096{1to8}, %zmm2 

// CHECK: vcvtudq2pd 485498096{1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x5a,0x7a,0x15,0xf0,0x1c,0xf0,0x1c]      
vcvtudq2pd 485498096{1to8}, %zmm2 {%k2} 

// CHECK: vcvtudq2pd 485498096{1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xda,0x7a,0x15,0xf0,0x1c,0xf0,0x1c]     
vcvtudq2pd 485498096{1to8}, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2pd 485498096(%edx){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x58,0x7a,0x92,0xf0,0x1c,0xf0,0x1c]       
vcvtudq2pd 485498096(%edx){1to8}, %zmm2 

// CHECK: vcvtudq2pd 485498096(%edx){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x5a,0x7a,0x92,0xf0,0x1c,0xf0,0x1c]      
vcvtudq2pd 485498096(%edx){1to8}, %zmm2 {%k2} 

// CHECK: vcvtudq2pd 485498096(%edx){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xda,0x7a,0x92,0xf0,0x1c,0xf0,0x1c]     
vcvtudq2pd 485498096(%edx){1to8}, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2pd -485498096(%edx,%eax,4){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x58,0x7a,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtudq2pd -485498096(%edx,%eax,4){1to8}, %zmm2 

// CHECK: vcvtudq2pd 485498096(%edx,%eax,4){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x58,0x7a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtudq2pd 485498096(%edx,%eax,4){1to8}, %zmm2 

// CHECK: vcvtudq2pd -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x5a,0x7a,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtudq2pd -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 

// CHECK: vcvtudq2pd 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x5a,0x7a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtudq2pd 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 

// CHECK: vcvtudq2pd -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xda,0x7a,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtudq2pd -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2pd 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xda,0x7a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtudq2pd 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2pd -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x7a,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtudq2pd -485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvtudq2pd 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x7a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtudq2pd 485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvtudq2pd -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x7a,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtudq2pd -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvtudq2pd 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x7a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtudq2pd 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvtudq2pd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x7a,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtudq2pd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvtudq2pd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x7a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtudq2pd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvtudq2pd 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x7a,0x92,0xf0,0x1c,0xf0,0x1c]       
vcvtudq2pd 485498096(%edx), %zmm2 

// CHECK: vcvtudq2pd 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x7a,0x92,0xf0,0x1c,0xf0,0x1c]      
vcvtudq2pd 485498096(%edx), %zmm2 {%k2} 

// CHECK: vcvtudq2pd 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x7a,0x92,0xf0,0x1c,0xf0,0x1c]     
vcvtudq2pd 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vcvtudq2pd 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x7a,0x15,0xf0,0x1c,0xf0,0x1c]       
vcvtudq2pd 485498096, %zmm2 

// CHECK: vcvtudq2pd 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x7a,0x15,0xf0,0x1c,0xf0,0x1c]      
vcvtudq2pd 485498096, %zmm2 {%k2} 

// CHECK: vcvtudq2pd 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x7a,0x15,0xf0,0x1c,0xf0,0x1c]     
vcvtudq2pd 485498096, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2pd (%edx){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x58,0x7a,0x12]       
vcvtudq2pd (%edx){1to8}, %zmm2 

// CHECK: vcvtudq2pd (%edx){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x5a,0x7a,0x12]      
vcvtudq2pd (%edx){1to8}, %zmm2 {%k2} 

// CHECK: vcvtudq2pd (%edx){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xda,0x7a,0x12]     
vcvtudq2pd (%edx){1to8}, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2pd (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x7a,0x12]       
vcvtudq2pd (%edx), %zmm2 

// CHECK: vcvtudq2pd (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x7a,0x12]      
vcvtudq2pd (%edx), %zmm2 {%k2} 

// CHECK: vcvtudq2pd (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x7a,0x12]     
vcvtudq2pd (%edx), %zmm2 {%k2} {z} 

// CHECK: vcvtudq2pd %ymm4, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x7a,0xd4]       
vcvtudq2pd %ymm4, %zmm2 

// CHECK: vcvtudq2pd %ymm4, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x7a,0xd4]      
vcvtudq2pd %ymm4, %zmm2 {%k2} 

// CHECK: vcvtudq2pd %ymm4, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x7a,0xd4]     
vcvtudq2pd %ymm4, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2ps 256(%edx,%eax){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7f,0x58,0x7a,0x54,0x02,0x40]       
vcvtudq2ps 256(%edx,%eax){1to16}, %zmm2 

// CHECK: vcvtudq2ps 256(%edx,%eax){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7f,0x5a,0x7a,0x54,0x02,0x40]      
vcvtudq2ps 256(%edx,%eax){1to16}, %zmm2 {%k2} 

// CHECK: vcvtudq2ps 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7f,0xda,0x7a,0x54,0x02,0x40]     
vcvtudq2ps 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2ps 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7f,0x48,0x7a,0x54,0x02,0x40]       
vcvtudq2ps 4096(%edx,%eax), %zmm2 

// CHECK: vcvtudq2ps 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7f,0x4a,0x7a,0x54,0x02,0x40]      
vcvtudq2ps 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vcvtudq2ps 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7f,0xca,0x7a,0x54,0x02,0x40]     
vcvtudq2ps 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vcvtudq2ps 485498096{1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7f,0x58,0x7a,0x15,0xf0,0x1c,0xf0,0x1c]       
vcvtudq2ps 485498096{1to16}, %zmm2 

// CHECK: vcvtudq2ps 485498096{1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7f,0x5a,0x7a,0x15,0xf0,0x1c,0xf0,0x1c]      
vcvtudq2ps 485498096{1to16}, %zmm2 {%k2} 

// CHECK: vcvtudq2ps 485498096{1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7f,0xda,0x7a,0x15,0xf0,0x1c,0xf0,0x1c]     
vcvtudq2ps 485498096{1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2ps 485498096(%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7f,0x58,0x7a,0x92,0xf0,0x1c,0xf0,0x1c]       
vcvtudq2ps 485498096(%edx){1to16}, %zmm2 

// CHECK: vcvtudq2ps 485498096(%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7f,0x5a,0x7a,0x92,0xf0,0x1c,0xf0,0x1c]      
vcvtudq2ps 485498096(%edx){1to16}, %zmm2 {%k2} 

// CHECK: vcvtudq2ps 485498096(%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7f,0xda,0x7a,0x92,0xf0,0x1c,0xf0,0x1c]     
vcvtudq2ps 485498096(%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2ps -485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7f,0x58,0x7a,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtudq2ps -485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vcvtudq2ps 485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7f,0x58,0x7a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtudq2ps 485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vcvtudq2ps -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7f,0x5a,0x7a,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtudq2ps -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vcvtudq2ps 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7f,0x5a,0x7a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtudq2ps 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vcvtudq2ps -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7f,0xda,0x7a,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtudq2ps -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2ps 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7f,0xda,0x7a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtudq2ps 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2ps -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7f,0x48,0x7a,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vcvtudq2ps -485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvtudq2ps 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7f,0x48,0x7a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vcvtudq2ps 485498096(%edx,%eax,4), %zmm2 

// CHECK: vcvtudq2ps -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7f,0x4a,0x7a,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vcvtudq2ps -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvtudq2ps 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7f,0x4a,0x7a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vcvtudq2ps 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vcvtudq2ps -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7f,0xca,0x7a,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vcvtudq2ps -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvtudq2ps 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7f,0xca,0x7a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vcvtudq2ps 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vcvtudq2ps 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7f,0x48,0x7a,0x92,0xf0,0x1c,0xf0,0x1c]       
vcvtudq2ps 485498096(%edx), %zmm2 

// CHECK: vcvtudq2ps 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7f,0x4a,0x7a,0x92,0xf0,0x1c,0xf0,0x1c]      
vcvtudq2ps 485498096(%edx), %zmm2 {%k2} 

// CHECK: vcvtudq2ps 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7f,0xca,0x7a,0x92,0xf0,0x1c,0xf0,0x1c]     
vcvtudq2ps 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vcvtudq2ps 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7f,0x48,0x7a,0x15,0xf0,0x1c,0xf0,0x1c]       
vcvtudq2ps 485498096, %zmm2 

// CHECK: vcvtudq2ps 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7f,0x4a,0x7a,0x15,0xf0,0x1c,0xf0,0x1c]      
vcvtudq2ps 485498096, %zmm2 {%k2} 

// CHECK: vcvtudq2ps 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7f,0xca,0x7a,0x15,0xf0,0x1c,0xf0,0x1c]     
vcvtudq2ps 485498096, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2ps (%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7f,0x58,0x7a,0x12]       
vcvtudq2ps (%edx){1to16}, %zmm2 

// CHECK: vcvtudq2ps (%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7f,0x5a,0x7a,0x12]      
vcvtudq2ps (%edx){1to16}, %zmm2 {%k2} 

// CHECK: vcvtudq2ps (%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7f,0xda,0x7a,0x12]     
vcvtudq2ps (%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2ps (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7f,0x48,0x7a,0x12]       
vcvtudq2ps (%edx), %zmm2 

// CHECK: vcvtudq2ps (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7f,0x4a,0x7a,0x12]      
vcvtudq2ps (%edx), %zmm2 {%k2} 

// CHECK: vcvtudq2ps (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7f,0xca,0x7a,0x12]     
vcvtudq2ps (%edx), %zmm2 {%k2} {z} 

// CHECK: vcvtudq2ps {rd-sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7f,0x38,0x7a,0xd2]      
vcvtudq2ps {rd-sae}, %zmm2, %zmm2 

// CHECK: vcvtudq2ps {rd-sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7f,0x3a,0x7a,0xd2]     
vcvtudq2ps {rd-sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vcvtudq2ps {rd-sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7f,0xba,0x7a,0xd2]    
vcvtudq2ps {rd-sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2ps {rn-sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7f,0x18,0x7a,0xd2]      
vcvtudq2ps {rn-sae}, %zmm2, %zmm2 

// CHECK: vcvtudq2ps {rn-sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7f,0x1a,0x7a,0xd2]     
vcvtudq2ps {rn-sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vcvtudq2ps {rn-sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7f,0x9a,0x7a,0xd2]    
vcvtudq2ps {rn-sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2ps {ru-sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7f,0x58,0x7a,0xd2]      
vcvtudq2ps {ru-sae}, %zmm2, %zmm2 

// CHECK: vcvtudq2ps {ru-sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7f,0x5a,0x7a,0xd2]     
vcvtudq2ps {ru-sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vcvtudq2ps {ru-sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7f,0xda,0x7a,0xd2]    
vcvtudq2ps {ru-sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2ps {rz-sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7f,0x78,0x7a,0xd2]      
vcvtudq2ps {rz-sae}, %zmm2, %zmm2 

// CHECK: vcvtudq2ps {rz-sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7f,0x7a,0x7a,0xd2]     
vcvtudq2ps {rz-sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vcvtudq2ps {rz-sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7f,0xfa,0x7a,0xd2]    
vcvtudq2ps {rz-sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vcvtudq2ps %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7f,0x48,0x7a,0xd2]       
vcvtudq2ps %zmm2, %zmm2 

// CHECK: vcvtudq2ps %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7f,0x4a,0x7a,0xd2]      
vcvtudq2ps %zmm2, %zmm2 {%k2} 

// CHECK: vcvtudq2ps %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7f,0xca,0x7a,0xd2]     
vcvtudq2ps %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivpd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5e,0x54,0x02,0x40]      
vdivpd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vdivpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5e,0x54,0x02,0x40]     
vdivpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vdivpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5e,0x54,0x02,0x40]    
vdivpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivpd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x5e,0x15,0xf0,0x1c,0xf0,0x1c]      
vdivpd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vdivpd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x5e,0x15,0xf0,0x1c,0xf0,0x1c]     
vdivpd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vdivpd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x5e,0x15,0xf0,0x1c,0xf0,0x1c]    
vdivpd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivpd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x5e,0x92,0xf0,0x1c,0xf0,0x1c]      
vdivpd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vdivpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x5e,0x92,0xf0,0x1c,0xf0,0x1c]     
vdivpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vdivpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x5e,0x92,0xf0,0x1c,0xf0,0x1c]    
vdivpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x5e,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vdivpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vdivpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x5e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vdivpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vdivpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x5e,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vdivpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vdivpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x5e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vdivpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vdivpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x5e,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vdivpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x5e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vdivpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivpd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5e,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vdivpd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vdivpd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vdivpd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vdivpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5e,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vdivpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vdivpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vdivpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vdivpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5e,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vdivpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vdivpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivpd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5e,0x92,0xf0,0x1c,0xf0,0x1c]      
vdivpd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vdivpd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5e,0x92,0xf0,0x1c,0xf0,0x1c]     
vdivpd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vdivpd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5e,0x92,0xf0,0x1c,0xf0,0x1c]    
vdivpd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivpd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5e,0x15,0xf0,0x1c,0xf0,0x1c]      
vdivpd 485498096, %zmm2, %zmm2 

// CHECK: vdivpd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5e,0x15,0xf0,0x1c,0xf0,0x1c]     
vdivpd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vdivpd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5e,0x15,0xf0,0x1c,0xf0,0x1c]    
vdivpd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x5e,0x54,0x02,0x40]      
vdivpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vdivpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x5e,0x54,0x02,0x40]     
vdivpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vdivpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x5e,0x54,0x02,0x40]    
vdivpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivpd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x5e,0x12]      
vdivpd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vdivpd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x5e,0x12]     
vdivpd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vdivpd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x5e,0x12]    
vdivpd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivpd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5e,0x12]      
vdivpd (%edx), %zmm2, %zmm2 

// CHECK: vdivpd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5e,0x12]     
vdivpd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vdivpd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5e,0x12]    
vdivpd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivpd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x38,0x5e,0xd2]     
vdivpd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vdivpd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x3a,0x5e,0xd2]    
vdivpd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vdivpd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xba,0x5e,0xd2]   
vdivpd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivpd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x18,0x5e,0xd2]     
vdivpd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vdivpd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x1a,0x5e,0xd2]    
vdivpd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vdivpd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0x9a,0x5e,0xd2]   
vdivpd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivpd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x5e,0xd2]     
vdivpd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vdivpd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x5e,0xd2]    
vdivpd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vdivpd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x5e,0xd2]   
vdivpd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivpd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x78,0x5e,0xd2]     
vdivpd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vdivpd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x7a,0x5e,0xd2]    
vdivpd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vdivpd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xfa,0x5e,0xd2]   
vdivpd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivpd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5e,0xd2]      
vdivpd %zmm2, %zmm2, %zmm2 

// CHECK: vdivpd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5e,0xd2]     
vdivpd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vdivpd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5e,0xd2]    
vdivpd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x5e,0x54,0x02,0x40]      
vdivps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vdivps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x5e,0x54,0x02,0x40]     
vdivps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vdivps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x5e,0x54,0x02,0x40]    
vdivps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5e,0x54,0x02,0x40]      
vdivps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vdivps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5e,0x54,0x02,0x40]     
vdivps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vdivps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5e,0x54,0x02,0x40]    
vdivps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x5e,0x15,0xf0,0x1c,0xf0,0x1c]      
vdivps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vdivps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x5e,0x15,0xf0,0x1c,0xf0,0x1c]     
vdivps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vdivps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x5e,0x15,0xf0,0x1c,0xf0,0x1c]    
vdivps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x5e,0x92,0xf0,0x1c,0xf0,0x1c]      
vdivps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vdivps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x5e,0x92,0xf0,0x1c,0xf0,0x1c]     
vdivps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vdivps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x5e,0x92,0xf0,0x1c,0xf0,0x1c]    
vdivps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x5e,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vdivps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vdivps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x5e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vdivps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vdivps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x5e,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vdivps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vdivps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x5e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vdivps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vdivps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x5e,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vdivps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x5e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vdivps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5e,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vdivps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vdivps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vdivps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vdivps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5e,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vdivps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vdivps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vdivps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vdivps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5e,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vdivps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vdivps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5e,0x92,0xf0,0x1c,0xf0,0x1c]      
vdivps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vdivps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5e,0x92,0xf0,0x1c,0xf0,0x1c]     
vdivps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vdivps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5e,0x92,0xf0,0x1c,0xf0,0x1c]    
vdivps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5e,0x15,0xf0,0x1c,0xf0,0x1c]      
vdivps 485498096, %zmm2, %zmm2 

// CHECK: vdivps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5e,0x15,0xf0,0x1c,0xf0,0x1c]     
vdivps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vdivps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5e,0x15,0xf0,0x1c,0xf0,0x1c]    
vdivps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x5e,0x12]      
vdivps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vdivps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x5e,0x12]     
vdivps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vdivps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x5e,0x12]    
vdivps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5e,0x12]      
vdivps (%edx), %zmm2, %zmm2 

// CHECK: vdivps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5e,0x12]     
vdivps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vdivps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5e,0x12]    
vdivps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x38,0x5e,0xd2]     
vdivps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vdivps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x3a,0x5e,0xd2]    
vdivps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vdivps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xba,0x5e,0xd2]   
vdivps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x18,0x5e,0xd2]     
vdivps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vdivps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x1a,0x5e,0xd2]    
vdivps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vdivps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x9a,0x5e,0xd2]   
vdivps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x5e,0xd2]     
vdivps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vdivps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x5e,0xd2]    
vdivps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vdivps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x5e,0xd2]   
vdivps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x78,0x5e,0xd2]     
vdivps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vdivps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x7a,0x5e,0xd2]    
vdivps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vdivps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xfa,0x5e,0xd2]   
vdivps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vdivps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5e,0xd2]      
vdivps %zmm2, %zmm2, %zmm2 

// CHECK: vdivps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5e,0xd2]     
vdivps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vdivps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5e,0xd2]    
vdivps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vexpandpd -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x88,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vexpandpd -485498096(%edx,%eax,4), %zmm2 

// CHECK: vexpandpd 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x88,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vexpandpd 485498096(%edx,%eax,4), %zmm2 

// CHECK: vexpandpd -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x88,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vexpandpd -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vexpandpd 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x88,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vexpandpd 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vexpandpd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x88,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vexpandpd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vexpandpd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x88,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vexpandpd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vexpandpd 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x88,0x92,0xf0,0x1c,0xf0,0x1c]       
vexpandpd 485498096(%edx), %zmm2 

// CHECK: vexpandpd 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x88,0x92,0xf0,0x1c,0xf0,0x1c]      
vexpandpd 485498096(%edx), %zmm2 {%k2} 

// CHECK: vexpandpd 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x88,0x92,0xf0,0x1c,0xf0,0x1c]     
vexpandpd 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vexpandpd 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x88,0x15,0xf0,0x1c,0xf0,0x1c]       
vexpandpd 485498096, %zmm2 

// CHECK: vexpandpd 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x88,0x15,0xf0,0x1c,0xf0,0x1c]      
vexpandpd 485498096, %zmm2 {%k2} 

// CHECK: vexpandpd 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x88,0x15,0xf0,0x1c,0xf0,0x1c]     
vexpandpd 485498096, %zmm2 {%k2} {z} 

// CHECK: vexpandpd 512(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x88,0x54,0x02,0x40]       
vexpandpd 512(%edx,%eax), %zmm2 

// CHECK: vexpandpd 512(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x88,0x54,0x02,0x40]      
vexpandpd 512(%edx,%eax), %zmm2 {%k2} 

// CHECK: vexpandpd 512(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x88,0x54,0x02,0x40]     
vexpandpd 512(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vexpandpd (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x88,0x12]       
vexpandpd (%edx), %zmm2 

// CHECK: vexpandpd (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x88,0x12]      
vexpandpd (%edx), %zmm2 {%k2} 

// CHECK: vexpandpd (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x88,0x12]     
vexpandpd (%edx), %zmm2 {%k2} {z} 

// CHECK: vexpandpd %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x88,0xd2]       
vexpandpd %zmm2, %zmm2 

// CHECK: vexpandpd %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x88,0xd2]      
vexpandpd %zmm2, %zmm2 {%k2} 

// CHECK: vexpandpd %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x88,0xd2]     
vexpandpd %zmm2, %zmm2 {%k2} {z} 

// CHECK: vexpandps 256(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x88,0x54,0x02,0x40]       
vexpandps 256(%edx,%eax), %zmm2 

// CHECK: vexpandps 256(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x88,0x54,0x02,0x40]      
vexpandps 256(%edx,%eax), %zmm2 {%k2} 

// CHECK: vexpandps 256(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x88,0x54,0x02,0x40]     
vexpandps 256(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vexpandps -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x88,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vexpandps -485498096(%edx,%eax,4), %zmm2 

// CHECK: vexpandps 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x88,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vexpandps 485498096(%edx,%eax,4), %zmm2 

// CHECK: vexpandps -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x88,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vexpandps -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vexpandps 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x88,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vexpandps 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vexpandps -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x88,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vexpandps -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vexpandps 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x88,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vexpandps 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vexpandps 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x88,0x92,0xf0,0x1c,0xf0,0x1c]       
vexpandps 485498096(%edx), %zmm2 

// CHECK: vexpandps 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x88,0x92,0xf0,0x1c,0xf0,0x1c]      
vexpandps 485498096(%edx), %zmm2 {%k2} 

// CHECK: vexpandps 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x88,0x92,0xf0,0x1c,0xf0,0x1c]     
vexpandps 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vexpandps 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x88,0x15,0xf0,0x1c,0xf0,0x1c]       
vexpandps 485498096, %zmm2 

// CHECK: vexpandps 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x88,0x15,0xf0,0x1c,0xf0,0x1c]      
vexpandps 485498096, %zmm2 {%k2} 

// CHECK: vexpandps 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x88,0x15,0xf0,0x1c,0xf0,0x1c]     
vexpandps 485498096, %zmm2 {%k2} {z} 

// CHECK: vexpandps (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x88,0x12]       
vexpandps (%edx), %zmm2 

// CHECK: vexpandps (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x88,0x12]      
vexpandps (%edx), %zmm2 {%k2} 

// CHECK: vexpandps (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x88,0x12]     
vexpandps (%edx), %zmm2 {%k2} {z} 

// CHECK: vexpandps %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x88,0xd2]       
vexpandps %zmm2, %zmm2 

// CHECK: vexpandps %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x88,0xd2]      
vexpandps %zmm2, %zmm2 {%k2} 

// CHECK: vexpandps %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x88,0xd2]     
vexpandps %zmm2, %zmm2 {%k2} {z} 

// CHECK: vextractf32x4 $0, %zmm2, 1024(%edx,%eax) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x19,0x54,0x02,0x40,0x00]      
vextractf32x4 $0, %zmm2, 1024(%edx,%eax) 

// CHECK: vextractf32x4 $0, %zmm2, 1024(%edx,%eax) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x19,0x54,0x02,0x40,0x00]     
vextractf32x4 $0, %zmm2, 1024(%edx,%eax) {%k2} 

// CHECK: vextractf32x4 $0, %zmm2, -485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x19,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vextractf32x4 $0, %zmm2, -485498096(%edx,%eax,4) 

// CHECK: vextractf32x4 $0, %zmm2, 485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x19,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vextractf32x4 $0, %zmm2, 485498096(%edx,%eax,4) 

// CHECK: vextractf32x4 $0, %zmm2, -485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x19,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vextractf32x4 $0, %zmm2, -485498096(%edx,%eax,4) {%k2} 

// CHECK: vextractf32x4 $0, %zmm2, 485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x19,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vextractf32x4 $0, %zmm2, 485498096(%edx,%eax,4) {%k2} 

// CHECK: vextractf32x4 $0, %zmm2, 485498096(%edx) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x19,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vextractf32x4 $0, %zmm2, 485498096(%edx) 

// CHECK: vextractf32x4 $0, %zmm2, 485498096(%edx) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x19,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vextractf32x4 $0, %zmm2, 485498096(%edx) {%k2} 

// CHECK: vextractf32x4 $0, %zmm2, 485498096 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x19,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vextractf32x4 $0, %zmm2, 485498096 

// CHECK: vextractf32x4 $0, %zmm2, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x19,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vextractf32x4 $0, %zmm2, 485498096 {%k2} 

// CHECK: vextractf32x4 $0, %zmm2, (%edx) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x19,0x12,0x00]      
vextractf32x4 $0, %zmm2, (%edx) 

// CHECK: vextractf32x4 $0, %zmm2, (%edx) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x19,0x12,0x00]     
vextractf32x4 $0, %zmm2, (%edx) {%k2} 

// CHECK: vextractf32x4 $0, %zmm2, %xmm1 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x19,0xd1,0x00]      
vextractf32x4 $0, %zmm2, %xmm1 

// CHECK: vextractf32x4 $0, %zmm2, %xmm1 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x19,0xd1,0x00]     
vextractf32x4 $0, %zmm2, %xmm1 {%k2} 

// CHECK: vextractf32x4 $0, %zmm2, %xmm1 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xca,0x19,0xd1,0x00]    
vextractf32x4 $0, %zmm2, %xmm1 {%k2} {z} 

// CHECK: vextractf32x8 $0, %zmm2, 2048(%edx,%eax) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x1b,0x54,0x02,0x40,0x00]      
vextractf32x8 $0, %zmm2, 2048(%edx,%eax) 

// CHECK: vextractf32x8 $0, %zmm2, 2048(%edx,%eax) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x1b,0x54,0x02,0x40,0x00]     
vextractf32x8 $0, %zmm2, 2048(%edx,%eax) {%k2} 

// CHECK: vextractf32x8 $0, %zmm2, -485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x1b,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vextractf32x8 $0, %zmm2, -485498096(%edx,%eax,4) 

// CHECK: vextractf32x8 $0, %zmm2, 485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x1b,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vextractf32x8 $0, %zmm2, 485498096(%edx,%eax,4) 

// CHECK: vextractf32x8 $0, %zmm2, -485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x1b,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vextractf32x8 $0, %zmm2, -485498096(%edx,%eax,4) {%k2} 

// CHECK: vextractf32x8 $0, %zmm2, 485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x1b,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vextractf32x8 $0, %zmm2, 485498096(%edx,%eax,4) {%k2} 

// CHECK: vextractf32x8 $0, %zmm2, 485498096(%edx) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x1b,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vextractf32x8 $0, %zmm2, 485498096(%edx) 

// CHECK: vextractf32x8 $0, %zmm2, 485498096(%edx) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x1b,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vextractf32x8 $0, %zmm2, 485498096(%edx) {%k2} 

// CHECK: vextractf32x8 $0, %zmm2, 485498096 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x1b,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vextractf32x8 $0, %zmm2, 485498096 

// CHECK: vextractf32x8 $0, %zmm2, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x1b,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vextractf32x8 $0, %zmm2, 485498096 {%k2} 

// CHECK: vextractf32x8 $0, %zmm2, (%edx) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x1b,0x12,0x00]      
vextractf32x8 $0, %zmm2, (%edx) 

// CHECK: vextractf32x8 $0, %zmm2, (%edx) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x1b,0x12,0x00]     
vextractf32x8 $0, %zmm2, (%edx) {%k2} 

// CHECK: vextractf32x8 $0, %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x1b,0xd4,0x00]      
vextractf32x8 $0, %zmm2, %ymm4 

// CHECK: vextractf32x8 $0, %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x1b,0xd4,0x00]     
vextractf32x8 $0, %zmm2, %ymm4 {%k2} 

// CHECK: vextractf32x8 $0, %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xca,0x1b,0xd4,0x00]    
vextractf32x8 $0, %zmm2, %ymm4 {%k2} {z} 

// CHECK: vextracti32x4 $0, %zmm2, 1024(%edx,%eax) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x39,0x54,0x02,0x40,0x00]      
vextracti32x4 $0, %zmm2, 1024(%edx,%eax) 

// CHECK: vextracti32x4 $0, %zmm2, 1024(%edx,%eax) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x39,0x54,0x02,0x40,0x00]     
vextracti32x4 $0, %zmm2, 1024(%edx,%eax) {%k2} 

// CHECK: vextracti32x4 $0, %zmm2, -485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x39,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vextracti32x4 $0, %zmm2, -485498096(%edx,%eax,4) 

// CHECK: vextracti32x4 $0, %zmm2, 485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x39,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vextracti32x4 $0, %zmm2, 485498096(%edx,%eax,4) 

// CHECK: vextracti32x4 $0, %zmm2, -485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x39,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vextracti32x4 $0, %zmm2, -485498096(%edx,%eax,4) {%k2} 

// CHECK: vextracti32x4 $0, %zmm2, 485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x39,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vextracti32x4 $0, %zmm2, 485498096(%edx,%eax,4) {%k2} 

// CHECK: vextracti32x4 $0, %zmm2, 485498096(%edx) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x39,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vextracti32x4 $0, %zmm2, 485498096(%edx) 

// CHECK: vextracti32x4 $0, %zmm2, 485498096(%edx) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x39,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vextracti32x4 $0, %zmm2, 485498096(%edx) {%k2} 

// CHECK: vextracti32x4 $0, %zmm2, 485498096 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x39,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vextracti32x4 $0, %zmm2, 485498096 

// CHECK: vextracti32x4 $0, %zmm2, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x39,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vextracti32x4 $0, %zmm2, 485498096 {%k2} 

// CHECK: vextracti32x4 $0, %zmm2, (%edx) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x39,0x12,0x00]      
vextracti32x4 $0, %zmm2, (%edx) 

// CHECK: vextracti32x4 $0, %zmm2, (%edx) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x39,0x12,0x00]     
vextracti32x4 $0, %zmm2, (%edx) {%k2} 

// CHECK: vextracti32x4 $0, %zmm2, %xmm1 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x39,0xd1,0x00]      
vextracti32x4 $0, %zmm2, %xmm1 

// CHECK: vextracti32x4 $0, %zmm2, %xmm1 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x39,0xd1,0x00]     
vextracti32x4 $0, %zmm2, %xmm1 {%k2} 

// CHECK: vextracti32x4 $0, %zmm2, %xmm1 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xca,0x39,0xd1,0x00]    
vextracti32x4 $0, %zmm2, %xmm1 {%k2} {z} 

// CHECK: vextracti32x8 $0, %zmm2, 2048(%edx,%eax) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x3b,0x54,0x02,0x40,0x00]      
vextracti32x8 $0, %zmm2, 2048(%edx,%eax) 

// CHECK: vextracti32x8 $0, %zmm2, 2048(%edx,%eax) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x3b,0x54,0x02,0x40,0x00]     
vextracti32x8 $0, %zmm2, 2048(%edx,%eax) {%k2} 

// CHECK: vextracti32x8 $0, %zmm2, -485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x3b,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vextracti32x8 $0, %zmm2, -485498096(%edx,%eax,4) 

// CHECK: vextracti32x8 $0, %zmm2, 485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x3b,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vextracti32x8 $0, %zmm2, 485498096(%edx,%eax,4) 

// CHECK: vextracti32x8 $0, %zmm2, -485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x3b,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vextracti32x8 $0, %zmm2, -485498096(%edx,%eax,4) {%k2} 

// CHECK: vextracti32x8 $0, %zmm2, 485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x3b,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vextracti32x8 $0, %zmm2, 485498096(%edx,%eax,4) {%k2} 

// CHECK: vextracti32x8 $0, %zmm2, 485498096(%edx) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x3b,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vextracti32x8 $0, %zmm2, 485498096(%edx) 

// CHECK: vextracti32x8 $0, %zmm2, 485498096(%edx) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x3b,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vextracti32x8 $0, %zmm2, 485498096(%edx) {%k2} 

// CHECK: vextracti32x8 $0, %zmm2, 485498096 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x3b,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vextracti32x8 $0, %zmm2, 485498096 

// CHECK: vextracti32x8 $0, %zmm2, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x3b,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vextracti32x8 $0, %zmm2, 485498096 {%k2} 

// CHECK: vextracti32x8 $0, %zmm2, (%edx) 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x3b,0x12,0x00]      
vextracti32x8 $0, %zmm2, (%edx) 

// CHECK: vextracti32x8 $0, %zmm2, (%edx) {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x3b,0x12,0x00]     
vextracti32x8 $0, %zmm2, (%edx) {%k2} 

// CHECK: vextracti32x8 $0, %zmm2, %ymm4 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x3b,0xd4,0x00]      
vextracti32x8 $0, %zmm2, %ymm4 

// CHECK: vextracti32x8 $0, %zmm2, %ymm4 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x3b,0xd4,0x00]     
vextracti32x8 $0, %zmm2, %ymm4 {%k2} 

// CHECK: vextracti32x8 $0, %zmm2, %ymm4 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xca,0x3b,0xd4,0x00]    
vextracti32x8 $0, %zmm2, %ymm4 {%k2} {z} 

// CHECK: vfixupimmpd $0, 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x54,0x54,0x02,0x40,0x00]     
vfixupimmpd $0, 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfixupimmpd $0, 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x54,0x54,0x02,0x40,0x00]    
vfixupimmpd $0, 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmpd $0, 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xca,0x54,0x54,0x02,0x40,0x00]   
vfixupimmpd $0, 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmpd $0, 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x58,0x54,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vfixupimmpd $0, 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vfixupimmpd $0, 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x5a,0x54,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vfixupimmpd $0, 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmpd $0, 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xda,0x54,0x15,0xf0,0x1c,0xf0,0x1c,0x00]   
vfixupimmpd $0, 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmpd $0, 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x58,0x54,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vfixupimmpd $0, 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfixupimmpd $0, 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x5a,0x54,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vfixupimmpd $0, 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmpd $0, 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xda,0x54,0x92,0xf0,0x1c,0xf0,0x1c,0x00]   
vfixupimmpd $0, 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x58,0x54,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vfixupimmpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfixupimmpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x58,0x54,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vfixupimmpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfixupimmpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x5a,0x54,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vfixupimmpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x5a,0x54,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vfixupimmpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xda,0x54,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]   
vfixupimmpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xda,0x54,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]   
vfixupimmpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmpd $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x54,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vfixupimmpd $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfixupimmpd $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x54,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vfixupimmpd $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfixupimmpd $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x54,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vfixupimmpd $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmpd $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x54,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vfixupimmpd $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmpd $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xca,0x54,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]   
vfixupimmpd $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmpd $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xca,0x54,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]   
vfixupimmpd $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmpd $0, 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x54,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vfixupimmpd $0, 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfixupimmpd $0, 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x54,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vfixupimmpd $0, 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmpd $0, 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xca,0x54,0x92,0xf0,0x1c,0xf0,0x1c,0x00]   
vfixupimmpd $0, 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmpd $0, 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x54,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vfixupimmpd $0, 485498096, %zmm2, %zmm2 

// CHECK: vfixupimmpd $0, 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x54,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vfixupimmpd $0, 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmpd $0, 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xca,0x54,0x15,0xf0,0x1c,0xf0,0x1c,0x00]   
vfixupimmpd $0, 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmpd $0, 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x58,0x54,0x54,0x02,0x40,0x00]     
vfixupimmpd $0, 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vfixupimmpd $0, 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x5a,0x54,0x54,0x02,0x40,0x00]    
vfixupimmpd $0, 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmpd $0, 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xda,0x54,0x54,0x02,0x40,0x00]   
vfixupimmpd $0, 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmpd $0, (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x58,0x54,0x12,0x00]     
vfixupimmpd $0, (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfixupimmpd $0, (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x5a,0x54,0x12,0x00]    
vfixupimmpd $0, (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmpd $0, (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xda,0x54,0x12,0x00]   
vfixupimmpd $0, (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmpd $0, (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x54,0x12,0x00]     
vfixupimmpd $0, (%edx), %zmm2, %zmm2 

// CHECK: vfixupimmpd $0, (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x54,0x12,0x00]    
vfixupimmpd $0, (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmpd $0, (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xca,0x54,0x12,0x00]   
vfixupimmpd $0, (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmpd $0, {sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x18,0x54,0xd2,0x00]    
vfixupimmpd $0, {sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfixupimmpd $0, {sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x1a,0x54,0xd2,0x00]   
vfixupimmpd $0, {sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmpd $0, {sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0x9a,0x54,0xd2,0x00]  
vfixupimmpd $0, {sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmpd $0, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x54,0xd2,0x00]     
vfixupimmpd $0, %zmm2, %zmm2, %zmm2 

// CHECK: vfixupimmpd $0, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x54,0xd2,0x00]    
vfixupimmpd $0, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmpd $0, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xed,0xca,0x54,0xd2,0x00]   
vfixupimmpd $0, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmps $0, 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x58,0x54,0x54,0x02,0x40,0x00]     
vfixupimmps $0, 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vfixupimmps $0, 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x5a,0x54,0x54,0x02,0x40,0x00]    
vfixupimmps $0, 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmps $0, 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xda,0x54,0x54,0x02,0x40,0x00]   
vfixupimmps $0, 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmps $0, 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x54,0x54,0x02,0x40,0x00]     
vfixupimmps $0, 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfixupimmps $0, 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x54,0x54,0x02,0x40,0x00]    
vfixupimmps $0, 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmps $0, 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x54,0x54,0x02,0x40,0x00]   
vfixupimmps $0, 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmps $0, 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x58,0x54,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vfixupimmps $0, 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vfixupimmps $0, 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x5a,0x54,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vfixupimmps $0, 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmps $0, 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xda,0x54,0x15,0xf0,0x1c,0xf0,0x1c,0x00]   
vfixupimmps $0, 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmps $0, 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x58,0x54,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vfixupimmps $0, 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfixupimmps $0, 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x5a,0x54,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vfixupimmps $0, 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmps $0, 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xda,0x54,0x92,0xf0,0x1c,0xf0,0x1c,0x00]   
vfixupimmps $0, 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmps $0, -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x58,0x54,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vfixupimmps $0, -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfixupimmps $0, 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x58,0x54,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vfixupimmps $0, 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfixupimmps $0, -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x5a,0x54,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vfixupimmps $0, -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmps $0, 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x5a,0x54,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vfixupimmps $0, 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmps $0, -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xda,0x54,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]   
vfixupimmps $0, -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmps $0, 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xda,0x54,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]   
vfixupimmps $0, 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmps $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x54,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vfixupimmps $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfixupimmps $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x54,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vfixupimmps $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfixupimmps $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x54,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vfixupimmps $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmps $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x54,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vfixupimmps $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmps $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x54,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]   
vfixupimmps $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmps $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x54,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]   
vfixupimmps $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmps $0, 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x54,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vfixupimmps $0, 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfixupimmps $0, 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x54,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vfixupimmps $0, 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmps $0, 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x54,0x92,0xf0,0x1c,0xf0,0x1c,0x00]   
vfixupimmps $0, 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmps $0, 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x54,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vfixupimmps $0, 485498096, %zmm2, %zmm2 

// CHECK: vfixupimmps $0, 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x54,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vfixupimmps $0, 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmps $0, 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x54,0x15,0xf0,0x1c,0xf0,0x1c,0x00]   
vfixupimmps $0, 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmps $0, (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x58,0x54,0x12,0x00]     
vfixupimmps $0, (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfixupimmps $0, (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x5a,0x54,0x12,0x00]    
vfixupimmps $0, (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmps $0, (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xda,0x54,0x12,0x00]   
vfixupimmps $0, (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmps $0, (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x54,0x12,0x00]     
vfixupimmps $0, (%edx), %zmm2, %zmm2 

// CHECK: vfixupimmps $0, (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x54,0x12,0x00]    
vfixupimmps $0, (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmps $0, (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x54,0x12,0x00]   
vfixupimmps $0, (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmps $0, {sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x18,0x54,0xd2,0x00]    
vfixupimmps $0, {sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfixupimmps $0, {sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x1a,0x54,0xd2,0x00]   
vfixupimmps $0, {sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmps $0, {sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x9a,0x54,0xd2,0x00]  
vfixupimmps $0, {sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfixupimmps $0, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x54,0xd2,0x00]     
vfixupimmps $0, %zmm2, %zmm2, %zmm2 

// CHECK: vfixupimmps $0, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x54,0xd2,0x00]    
vfixupimmps $0, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfixupimmps $0, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x54,0xd2,0x00]   
vfixupimmps $0, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x98,0x54,0x02,0x40]      
vfmadd132pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmadd132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x98,0x54,0x02,0x40]     
vfmadd132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x98,0x54,0x02,0x40]    
vfmadd132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x98,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmadd132pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vfmadd132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x98,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmadd132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x98,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmadd132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x98,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmadd132pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmadd132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x98,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmadd132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x98,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmadd132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x98,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmadd132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmadd132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x98,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmadd132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmadd132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x98,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmadd132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x98,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmadd132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x98,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmadd132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x98,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmadd132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x98,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmadd132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmadd132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x98,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmadd132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmadd132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x98,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmadd132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x98,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmadd132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x98,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmadd132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x98,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmadd132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x98,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmadd132pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmadd132pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x98,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmadd132pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x98,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmadd132pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x98,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmadd132pd 485498096, %zmm2, %zmm2 

// CHECK: vfmadd132pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x98,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmadd132pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x98,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmadd132pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x98,0x54,0x02,0x40]      
vfmadd132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vfmadd132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x98,0x54,0x02,0x40]     
vfmadd132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x98,0x54,0x02,0x40]    
vfmadd132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x98,0x12]      
vfmadd132pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmadd132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x98,0x12]     
vfmadd132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x98,0x12]    
vfmadd132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x98,0x12]      
vfmadd132pd (%edx), %zmm2, %zmm2 

// CHECK: vfmadd132pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x98,0x12]     
vfmadd132pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x98,0x12]    
vfmadd132pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132pd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x38,0x98,0xd2]     
vfmadd132pd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x3a,0x98,0xd2]    
vfmadd132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xba,0x98,0xd2]   
vfmadd132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132pd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x18,0x98,0xd2]     
vfmadd132pd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x1a,0x98,0xd2]    
vfmadd132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0x9a,0x98,0xd2]   
vfmadd132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132pd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x98,0xd2]     
vfmadd132pd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x98,0xd2]    
vfmadd132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x98,0xd2]   
vfmadd132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132pd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x78,0x98,0xd2]     
vfmadd132pd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x7a,0x98,0xd2]    
vfmadd132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xfa,0x98,0xd2]   
vfmadd132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x98,0xd2]      
vfmadd132pd %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd132pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x98,0xd2]     
vfmadd132pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x98,0xd2]    
vfmadd132pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x98,0x54,0x02,0x40]      
vfmadd132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vfmadd132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x98,0x54,0x02,0x40]     
vfmadd132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x98,0x54,0x02,0x40]    
vfmadd132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x98,0x54,0x02,0x40]      
vfmadd132ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmadd132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x98,0x54,0x02,0x40]     
vfmadd132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x98,0x54,0x02,0x40]    
vfmadd132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x98,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmadd132ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vfmadd132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x98,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmadd132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x98,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmadd132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x98,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmadd132ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmadd132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x98,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmadd132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x98,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmadd132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x98,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmadd132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmadd132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x98,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmadd132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmadd132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x98,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmadd132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x98,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmadd132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x98,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmadd132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x98,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmadd132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x98,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmadd132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmadd132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x98,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmadd132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmadd132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x98,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmadd132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x98,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmadd132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x98,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmadd132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x98,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmadd132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x98,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmadd132ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmadd132ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x98,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmadd132ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x98,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmadd132ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x98,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmadd132ps 485498096, %zmm2, %zmm2 

// CHECK: vfmadd132ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x98,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmadd132ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x98,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmadd132ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x98,0x12]      
vfmadd132ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmadd132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x98,0x12]     
vfmadd132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x98,0x12]    
vfmadd132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x98,0x12]      
vfmadd132ps (%edx), %zmm2, %zmm2 

// CHECK: vfmadd132ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x98,0x12]     
vfmadd132ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x98,0x12]    
vfmadd132ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132ps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x38,0x98,0xd2]     
vfmadd132ps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x3a,0x98,0xd2]    
vfmadd132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xba,0x98,0xd2]   
vfmadd132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132ps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x18,0x98,0xd2]     
vfmadd132ps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x1a,0x98,0xd2]    
vfmadd132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x9a,0x98,0xd2]   
vfmadd132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132ps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x98,0xd2]     
vfmadd132ps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x98,0xd2]    
vfmadd132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x98,0xd2]   
vfmadd132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132ps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x78,0x98,0xd2]     
vfmadd132ps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x7a,0x98,0xd2]    
vfmadd132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xfa,0x98,0xd2]   
vfmadd132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd132ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x98,0xd2]      
vfmadd132ps %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd132ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x98,0xd2]     
vfmadd132ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd132ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x98,0xd2]    
vfmadd132ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa8,0x54,0x02,0x40]      
vfmadd213pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmadd213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa8,0x54,0x02,0x40]     
vfmadd213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa8,0x54,0x02,0x40]    
vfmadd213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa8,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmadd213pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vfmadd213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa8,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmadd213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa8,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmadd213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa8,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmadd213pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmadd213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa8,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmadd213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa8,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmadd213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa8,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmadd213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmadd213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmadd213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmadd213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa8,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmadd213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmadd213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa8,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmadd213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmadd213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa8,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmadd213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmadd213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmadd213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmadd213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa8,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmadd213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmadd213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa8,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmadd213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmadd213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa8,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmadd213pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmadd213pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa8,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmadd213pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa8,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmadd213pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa8,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmadd213pd 485498096, %zmm2, %zmm2 

// CHECK: vfmadd213pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa8,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmadd213pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa8,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmadd213pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa8,0x54,0x02,0x40]      
vfmadd213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vfmadd213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa8,0x54,0x02,0x40]     
vfmadd213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa8,0x54,0x02,0x40]    
vfmadd213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa8,0x12]      
vfmadd213pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmadd213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa8,0x12]     
vfmadd213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa8,0x12]    
vfmadd213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa8,0x12]      
vfmadd213pd (%edx), %zmm2, %zmm2 

// CHECK: vfmadd213pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa8,0x12]     
vfmadd213pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa8,0x12]    
vfmadd213pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213pd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x38,0xa8,0xd2]     
vfmadd213pd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x3a,0xa8,0xd2]    
vfmadd213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xba,0xa8,0xd2]   
vfmadd213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213pd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x18,0xa8,0xd2]     
vfmadd213pd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x1a,0xa8,0xd2]    
vfmadd213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0x9a,0xa8,0xd2]   
vfmadd213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213pd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa8,0xd2]     
vfmadd213pd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa8,0xd2]    
vfmadd213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa8,0xd2]   
vfmadd213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213pd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x78,0xa8,0xd2]     
vfmadd213pd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x7a,0xa8,0xd2]    
vfmadd213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xfa,0xa8,0xd2]   
vfmadd213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa8,0xd2]      
vfmadd213pd %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd213pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa8,0xd2]     
vfmadd213pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa8,0xd2]    
vfmadd213pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa8,0x54,0x02,0x40]      
vfmadd213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vfmadd213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa8,0x54,0x02,0x40]     
vfmadd213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa8,0x54,0x02,0x40]    
vfmadd213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa8,0x54,0x02,0x40]      
vfmadd213ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmadd213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa8,0x54,0x02,0x40]     
vfmadd213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa8,0x54,0x02,0x40]    
vfmadd213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa8,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmadd213ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vfmadd213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa8,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmadd213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa8,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmadd213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa8,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmadd213ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmadd213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa8,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmadd213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa8,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmadd213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa8,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmadd213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmadd213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmadd213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmadd213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa8,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmadd213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmadd213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa8,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmadd213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmadd213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa8,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmadd213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmadd213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmadd213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmadd213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa8,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmadd213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmadd213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa8,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmadd213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmadd213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa8,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmadd213ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmadd213ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa8,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmadd213ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa8,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmadd213ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa8,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmadd213ps 485498096, %zmm2, %zmm2 

// CHECK: vfmadd213ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa8,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmadd213ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa8,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmadd213ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa8,0x12]      
vfmadd213ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmadd213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa8,0x12]     
vfmadd213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa8,0x12]    
vfmadd213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa8,0x12]      
vfmadd213ps (%edx), %zmm2, %zmm2 

// CHECK: vfmadd213ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa8,0x12]     
vfmadd213ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa8,0x12]    
vfmadd213ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213ps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x38,0xa8,0xd2]     
vfmadd213ps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x3a,0xa8,0xd2]    
vfmadd213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xba,0xa8,0xd2]   
vfmadd213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213ps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x18,0xa8,0xd2]     
vfmadd213ps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x1a,0xa8,0xd2]    
vfmadd213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x9a,0xa8,0xd2]   
vfmadd213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213ps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa8,0xd2]     
vfmadd213ps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa8,0xd2]    
vfmadd213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa8,0xd2]   
vfmadd213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213ps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x78,0xa8,0xd2]     
vfmadd213ps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x7a,0xa8,0xd2]    
vfmadd213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xfa,0xa8,0xd2]   
vfmadd213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd213ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa8,0xd2]      
vfmadd213ps %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd213ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa8,0xd2]     
vfmadd213ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd213ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa8,0xd2]    
vfmadd213ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb8,0x54,0x02,0x40]      
vfmadd231pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmadd231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb8,0x54,0x02,0x40]     
vfmadd231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb8,0x54,0x02,0x40]    
vfmadd231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb8,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmadd231pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vfmadd231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb8,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmadd231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb8,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmadd231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb8,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmadd231pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmadd231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb8,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmadd231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb8,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmadd231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb8,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmadd231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmadd231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmadd231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmadd231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb8,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmadd231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmadd231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb8,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmadd231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmadd231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb8,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmadd231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmadd231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmadd231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmadd231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb8,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmadd231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmadd231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb8,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmadd231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmadd231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb8,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmadd231pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmadd231pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb8,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmadd231pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb8,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmadd231pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb8,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmadd231pd 485498096, %zmm2, %zmm2 

// CHECK: vfmadd231pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb8,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmadd231pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb8,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmadd231pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb8,0x54,0x02,0x40]      
vfmadd231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vfmadd231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb8,0x54,0x02,0x40]     
vfmadd231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb8,0x54,0x02,0x40]    
vfmadd231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb8,0x12]      
vfmadd231pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmadd231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb8,0x12]     
vfmadd231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb8,0x12]    
vfmadd231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb8,0x12]      
vfmadd231pd (%edx), %zmm2, %zmm2 

// CHECK: vfmadd231pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb8,0x12]     
vfmadd231pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb8,0x12]    
vfmadd231pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231pd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x38,0xb8,0xd2]     
vfmadd231pd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x3a,0xb8,0xd2]    
vfmadd231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xba,0xb8,0xd2]   
vfmadd231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231pd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x18,0xb8,0xd2]     
vfmadd231pd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x1a,0xb8,0xd2]    
vfmadd231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0x9a,0xb8,0xd2]   
vfmadd231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231pd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb8,0xd2]     
vfmadd231pd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb8,0xd2]    
vfmadd231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb8,0xd2]   
vfmadd231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231pd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x78,0xb8,0xd2]     
vfmadd231pd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x7a,0xb8,0xd2]    
vfmadd231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xfa,0xb8,0xd2]   
vfmadd231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb8,0xd2]      
vfmadd231pd %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd231pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb8,0xd2]     
vfmadd231pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb8,0xd2]    
vfmadd231pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb8,0x54,0x02,0x40]      
vfmadd231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vfmadd231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb8,0x54,0x02,0x40]     
vfmadd231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb8,0x54,0x02,0x40]    
vfmadd231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb8,0x54,0x02,0x40]      
vfmadd231ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmadd231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb8,0x54,0x02,0x40]     
vfmadd231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb8,0x54,0x02,0x40]    
vfmadd231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb8,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmadd231ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vfmadd231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb8,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmadd231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb8,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmadd231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb8,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmadd231ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmadd231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb8,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmadd231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb8,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmadd231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb8,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmadd231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmadd231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmadd231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmadd231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb8,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmadd231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmadd231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb8,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmadd231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmadd231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb8,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmadd231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmadd231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmadd231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmadd231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb8,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmadd231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmadd231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb8,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmadd231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb8,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmadd231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb8,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmadd231ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmadd231ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb8,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmadd231ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb8,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmadd231ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb8,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmadd231ps 485498096, %zmm2, %zmm2 

// CHECK: vfmadd231ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb8,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmadd231ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb8,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmadd231ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb8,0x12]      
vfmadd231ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmadd231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb8,0x12]     
vfmadd231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb8,0x12]    
vfmadd231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb8,0x12]      
vfmadd231ps (%edx), %zmm2, %zmm2 

// CHECK: vfmadd231ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb8,0x12]     
vfmadd231ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb8,0x12]    
vfmadd231ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231ps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x38,0xb8,0xd2]     
vfmadd231ps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x3a,0xb8,0xd2]    
vfmadd231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xba,0xb8,0xd2]   
vfmadd231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231ps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x18,0xb8,0xd2]     
vfmadd231ps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x1a,0xb8,0xd2]    
vfmadd231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x9a,0xb8,0xd2]   
vfmadd231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231ps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb8,0xd2]     
vfmadd231ps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb8,0xd2]    
vfmadd231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb8,0xd2]   
vfmadd231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231ps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x78,0xb8,0xd2]     
vfmadd231ps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x7a,0xb8,0xd2]    
vfmadd231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xfa,0xb8,0xd2]   
vfmadd231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmadd231ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb8,0xd2]      
vfmadd231ps %zmm2, %zmm2, %zmm2 

// CHECK: vfmadd231ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb8,0xd2]     
vfmadd231ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmadd231ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb8,0xd2]    
vfmadd231ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x96,0x54,0x02,0x40]      
vfmaddsub132pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmaddsub132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x96,0x54,0x02,0x40]     
vfmaddsub132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x96,0x54,0x02,0x40]    
vfmaddsub132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x96,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub132pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vfmaddsub132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x96,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x96,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x96,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub132pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmaddsub132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x96,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x96,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x96,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmaddsub132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmaddsub132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x96,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmaddsub132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x96,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmaddsub132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x96,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x96,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmaddsub132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x96,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x96,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmaddsub132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmaddsub132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x96,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmaddsub132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x96,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmaddsub132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x96,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x96,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmaddsub132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x96,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x96,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub132pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmaddsub132pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x96,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub132pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x96,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub132pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x96,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub132pd 485498096, %zmm2, %zmm2 

// CHECK: vfmaddsub132pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x96,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub132pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x96,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub132pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x96,0x54,0x02,0x40]      
vfmaddsub132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vfmaddsub132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x96,0x54,0x02,0x40]     
vfmaddsub132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x96,0x54,0x02,0x40]    
vfmaddsub132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x96,0x12]      
vfmaddsub132pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmaddsub132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x96,0x12]     
vfmaddsub132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x96,0x12]    
vfmaddsub132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x96,0x12]      
vfmaddsub132pd (%edx), %zmm2, %zmm2 

// CHECK: vfmaddsub132pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x96,0x12]     
vfmaddsub132pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x96,0x12]    
vfmaddsub132pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132pd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x38,0x96,0xd2]     
vfmaddsub132pd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x3a,0x96,0xd2]    
vfmaddsub132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xba,0x96,0xd2]   
vfmaddsub132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132pd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x18,0x96,0xd2]     
vfmaddsub132pd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x1a,0x96,0xd2]    
vfmaddsub132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0x9a,0x96,0xd2]   
vfmaddsub132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132pd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x96,0xd2]     
vfmaddsub132pd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x96,0xd2]    
vfmaddsub132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x96,0xd2]   
vfmaddsub132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132pd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x78,0x96,0xd2]     
vfmaddsub132pd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x7a,0x96,0xd2]    
vfmaddsub132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xfa,0x96,0xd2]   
vfmaddsub132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x96,0xd2]      
vfmaddsub132pd %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub132pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x96,0xd2]     
vfmaddsub132pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x96,0xd2]    
vfmaddsub132pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x96,0x54,0x02,0x40]      
vfmaddsub132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vfmaddsub132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x96,0x54,0x02,0x40]     
vfmaddsub132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x96,0x54,0x02,0x40]    
vfmaddsub132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x96,0x54,0x02,0x40]      
vfmaddsub132ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmaddsub132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x96,0x54,0x02,0x40]     
vfmaddsub132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x96,0x54,0x02,0x40]    
vfmaddsub132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x96,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub132ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vfmaddsub132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x96,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x96,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x96,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub132ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmaddsub132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x96,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x96,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x96,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmaddsub132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmaddsub132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x96,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmaddsub132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x96,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmaddsub132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x96,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x96,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmaddsub132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x96,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x96,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmaddsub132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmaddsub132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x96,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmaddsub132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x96,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmaddsub132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x96,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x96,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmaddsub132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x96,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x96,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub132ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmaddsub132ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x96,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub132ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x96,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub132ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x96,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub132ps 485498096, %zmm2, %zmm2 

// CHECK: vfmaddsub132ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x96,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub132ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x96,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub132ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x96,0x12]      
vfmaddsub132ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmaddsub132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x96,0x12]     
vfmaddsub132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x96,0x12]    
vfmaddsub132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x96,0x12]      
vfmaddsub132ps (%edx), %zmm2, %zmm2 

// CHECK: vfmaddsub132ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x96,0x12]     
vfmaddsub132ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x96,0x12]    
vfmaddsub132ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132ps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x38,0x96,0xd2]     
vfmaddsub132ps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x3a,0x96,0xd2]    
vfmaddsub132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xba,0x96,0xd2]   
vfmaddsub132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132ps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x18,0x96,0xd2]     
vfmaddsub132ps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x1a,0x96,0xd2]    
vfmaddsub132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x9a,0x96,0xd2]   
vfmaddsub132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132ps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x96,0xd2]     
vfmaddsub132ps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x96,0xd2]    
vfmaddsub132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x96,0xd2]   
vfmaddsub132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132ps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x78,0x96,0xd2]     
vfmaddsub132ps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x7a,0x96,0xd2]    
vfmaddsub132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xfa,0x96,0xd2]   
vfmaddsub132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub132ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x96,0xd2]      
vfmaddsub132ps %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub132ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x96,0xd2]     
vfmaddsub132ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub132ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x96,0xd2]    
vfmaddsub132ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa6,0x54,0x02,0x40]      
vfmaddsub213pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmaddsub213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa6,0x54,0x02,0x40]     
vfmaddsub213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa6,0x54,0x02,0x40]    
vfmaddsub213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa6,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub213pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vfmaddsub213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa6,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa6,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa6,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub213pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmaddsub213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa6,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa6,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa6,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmaddsub213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmaddsub213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmaddsub213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa6,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmaddsub213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa6,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmaddsub213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa6,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmaddsub213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmaddsub213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmaddsub213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa6,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmaddsub213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa6,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmaddsub213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa6,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub213pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmaddsub213pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa6,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub213pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa6,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub213pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa6,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub213pd 485498096, %zmm2, %zmm2 

// CHECK: vfmaddsub213pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa6,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub213pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa6,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub213pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa6,0x54,0x02,0x40]      
vfmaddsub213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vfmaddsub213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa6,0x54,0x02,0x40]     
vfmaddsub213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa6,0x54,0x02,0x40]    
vfmaddsub213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa6,0x12]      
vfmaddsub213pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmaddsub213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa6,0x12]     
vfmaddsub213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa6,0x12]    
vfmaddsub213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa6,0x12]      
vfmaddsub213pd (%edx), %zmm2, %zmm2 

// CHECK: vfmaddsub213pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa6,0x12]     
vfmaddsub213pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa6,0x12]    
vfmaddsub213pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213pd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x38,0xa6,0xd2]     
vfmaddsub213pd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x3a,0xa6,0xd2]    
vfmaddsub213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xba,0xa6,0xd2]   
vfmaddsub213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213pd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x18,0xa6,0xd2]     
vfmaddsub213pd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x1a,0xa6,0xd2]    
vfmaddsub213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0x9a,0xa6,0xd2]   
vfmaddsub213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213pd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa6,0xd2]     
vfmaddsub213pd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa6,0xd2]    
vfmaddsub213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa6,0xd2]   
vfmaddsub213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213pd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x78,0xa6,0xd2]     
vfmaddsub213pd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x7a,0xa6,0xd2]    
vfmaddsub213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xfa,0xa6,0xd2]   
vfmaddsub213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa6,0xd2]      
vfmaddsub213pd %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub213pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa6,0xd2]     
vfmaddsub213pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa6,0xd2]    
vfmaddsub213pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa6,0x54,0x02,0x40]      
vfmaddsub213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vfmaddsub213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa6,0x54,0x02,0x40]     
vfmaddsub213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa6,0x54,0x02,0x40]    
vfmaddsub213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa6,0x54,0x02,0x40]      
vfmaddsub213ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmaddsub213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa6,0x54,0x02,0x40]     
vfmaddsub213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa6,0x54,0x02,0x40]    
vfmaddsub213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa6,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub213ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vfmaddsub213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa6,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa6,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa6,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub213ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmaddsub213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa6,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa6,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa6,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmaddsub213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmaddsub213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmaddsub213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa6,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmaddsub213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa6,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmaddsub213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa6,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmaddsub213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmaddsub213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmaddsub213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa6,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmaddsub213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa6,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmaddsub213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa6,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub213ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmaddsub213ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa6,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub213ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa6,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub213ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa6,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub213ps 485498096, %zmm2, %zmm2 

// CHECK: vfmaddsub213ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa6,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub213ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa6,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub213ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa6,0x12]      
vfmaddsub213ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmaddsub213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa6,0x12]     
vfmaddsub213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa6,0x12]    
vfmaddsub213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa6,0x12]      
vfmaddsub213ps (%edx), %zmm2, %zmm2 

// CHECK: vfmaddsub213ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa6,0x12]     
vfmaddsub213ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa6,0x12]    
vfmaddsub213ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213ps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x38,0xa6,0xd2]     
vfmaddsub213ps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x3a,0xa6,0xd2]    
vfmaddsub213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xba,0xa6,0xd2]   
vfmaddsub213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213ps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x18,0xa6,0xd2]     
vfmaddsub213ps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x1a,0xa6,0xd2]    
vfmaddsub213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x9a,0xa6,0xd2]   
vfmaddsub213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213ps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa6,0xd2]     
vfmaddsub213ps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa6,0xd2]    
vfmaddsub213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa6,0xd2]   
vfmaddsub213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213ps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x78,0xa6,0xd2]     
vfmaddsub213ps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x7a,0xa6,0xd2]    
vfmaddsub213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xfa,0xa6,0xd2]   
vfmaddsub213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub213ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa6,0xd2]      
vfmaddsub213ps %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub213ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa6,0xd2]     
vfmaddsub213ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub213ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa6,0xd2]    
vfmaddsub213ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb6,0x54,0x02,0x40]      
vfmaddsub231pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmaddsub231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb6,0x54,0x02,0x40]     
vfmaddsub231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb6,0x54,0x02,0x40]    
vfmaddsub231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb6,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub231pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vfmaddsub231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb6,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb6,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb6,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub231pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmaddsub231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb6,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb6,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb6,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmaddsub231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmaddsub231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmaddsub231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb6,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmaddsub231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb6,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmaddsub231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb6,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmaddsub231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmaddsub231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmaddsub231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb6,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmaddsub231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb6,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmaddsub231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb6,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub231pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmaddsub231pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb6,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub231pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb6,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub231pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb6,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub231pd 485498096, %zmm2, %zmm2 

// CHECK: vfmaddsub231pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb6,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub231pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb6,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub231pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb6,0x54,0x02,0x40]      
vfmaddsub231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vfmaddsub231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb6,0x54,0x02,0x40]     
vfmaddsub231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb6,0x54,0x02,0x40]    
vfmaddsub231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb6,0x12]      
vfmaddsub231pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmaddsub231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb6,0x12]     
vfmaddsub231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb6,0x12]    
vfmaddsub231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb6,0x12]      
vfmaddsub231pd (%edx), %zmm2, %zmm2 

// CHECK: vfmaddsub231pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb6,0x12]     
vfmaddsub231pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb6,0x12]    
vfmaddsub231pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231pd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x38,0xb6,0xd2]     
vfmaddsub231pd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x3a,0xb6,0xd2]    
vfmaddsub231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xba,0xb6,0xd2]   
vfmaddsub231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231pd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x18,0xb6,0xd2]     
vfmaddsub231pd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x1a,0xb6,0xd2]    
vfmaddsub231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0x9a,0xb6,0xd2]   
vfmaddsub231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231pd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb6,0xd2]     
vfmaddsub231pd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb6,0xd2]    
vfmaddsub231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb6,0xd2]   
vfmaddsub231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231pd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x78,0xb6,0xd2]     
vfmaddsub231pd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x7a,0xb6,0xd2]    
vfmaddsub231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xfa,0xb6,0xd2]   
vfmaddsub231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb6,0xd2]      
vfmaddsub231pd %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub231pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb6,0xd2]     
vfmaddsub231pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb6,0xd2]    
vfmaddsub231pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb6,0x54,0x02,0x40]      
vfmaddsub231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vfmaddsub231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb6,0x54,0x02,0x40]     
vfmaddsub231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb6,0x54,0x02,0x40]    
vfmaddsub231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb6,0x54,0x02,0x40]      
vfmaddsub231ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmaddsub231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb6,0x54,0x02,0x40]     
vfmaddsub231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb6,0x54,0x02,0x40]    
vfmaddsub231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb6,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub231ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vfmaddsub231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb6,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb6,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb6,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub231ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmaddsub231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb6,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb6,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb6,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmaddsub231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmaddsub231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmaddsub231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb6,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmaddsub231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb6,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmaddsub231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb6,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmaddsub231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmaddsub231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmaddsub231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb6,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmaddsub231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb6,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmaddsub231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb6,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb6,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub231ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmaddsub231ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb6,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub231ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb6,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub231ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb6,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmaddsub231ps 485498096, %zmm2, %zmm2 

// CHECK: vfmaddsub231ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb6,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmaddsub231ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb6,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmaddsub231ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb6,0x12]      
vfmaddsub231ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmaddsub231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb6,0x12]     
vfmaddsub231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb6,0x12]    
vfmaddsub231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb6,0x12]      
vfmaddsub231ps (%edx), %zmm2, %zmm2 

// CHECK: vfmaddsub231ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb6,0x12]     
vfmaddsub231ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb6,0x12]    
vfmaddsub231ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231ps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x38,0xb6,0xd2]     
vfmaddsub231ps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x3a,0xb6,0xd2]    
vfmaddsub231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xba,0xb6,0xd2]   
vfmaddsub231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231ps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x18,0xb6,0xd2]     
vfmaddsub231ps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x1a,0xb6,0xd2]    
vfmaddsub231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x9a,0xb6,0xd2]   
vfmaddsub231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231ps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb6,0xd2]     
vfmaddsub231ps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb6,0xd2]    
vfmaddsub231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb6,0xd2]   
vfmaddsub231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231ps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x78,0xb6,0xd2]     
vfmaddsub231ps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x7a,0xb6,0xd2]    
vfmaddsub231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xfa,0xb6,0xd2]   
vfmaddsub231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmaddsub231ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb6,0xd2]      
vfmaddsub231ps %zmm2, %zmm2, %zmm2 

// CHECK: vfmaddsub231ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb6,0xd2]     
vfmaddsub231ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmaddsub231ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb6,0xd2]    
vfmaddsub231ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9a,0x54,0x02,0x40]      
vfmsub132pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmsub132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9a,0x54,0x02,0x40]     
vfmsub132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9a,0x54,0x02,0x40]    
vfmsub132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9a,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsub132pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vfmsub132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9a,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsub132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9a,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsub132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9a,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsub132pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmsub132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9a,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsub132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9a,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsub132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9a,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsub132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmsub132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsub132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmsub132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9a,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsub132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsub132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9a,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsub132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsub132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9a,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsub132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsub132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsub132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsub132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9a,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsub132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsub132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9a,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsub132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsub132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9a,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsub132pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmsub132pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9a,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsub132pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9a,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsub132pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9a,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsub132pd 485498096, %zmm2, %zmm2 

// CHECK: vfmsub132pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9a,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsub132pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9a,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsub132pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9a,0x54,0x02,0x40]      
vfmsub132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vfmsub132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9a,0x54,0x02,0x40]     
vfmsub132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9a,0x54,0x02,0x40]    
vfmsub132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9a,0x12]      
vfmsub132pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmsub132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9a,0x12]     
vfmsub132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9a,0x12]    
vfmsub132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9a,0x12]      
vfmsub132pd (%edx), %zmm2, %zmm2 

// CHECK: vfmsub132pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9a,0x12]     
vfmsub132pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9a,0x12]    
vfmsub132pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132pd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x38,0x9a,0xd2]     
vfmsub132pd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x3a,0x9a,0xd2]    
vfmsub132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xba,0x9a,0xd2]   
vfmsub132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132pd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x18,0x9a,0xd2]     
vfmsub132pd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x1a,0x9a,0xd2]    
vfmsub132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0x9a,0x9a,0xd2]   
vfmsub132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132pd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9a,0xd2]     
vfmsub132pd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9a,0xd2]    
vfmsub132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9a,0xd2]   
vfmsub132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132pd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x78,0x9a,0xd2]     
vfmsub132pd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x7a,0x9a,0xd2]    
vfmsub132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xfa,0x9a,0xd2]   
vfmsub132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9a,0xd2]      
vfmsub132pd %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub132pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9a,0xd2]     
vfmsub132pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9a,0xd2]    
vfmsub132pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9a,0x54,0x02,0x40]      
vfmsub132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vfmsub132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9a,0x54,0x02,0x40]     
vfmsub132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9a,0x54,0x02,0x40]    
vfmsub132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9a,0x54,0x02,0x40]      
vfmsub132ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmsub132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9a,0x54,0x02,0x40]     
vfmsub132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9a,0x54,0x02,0x40]    
vfmsub132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9a,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsub132ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vfmsub132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9a,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsub132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9a,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsub132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9a,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsub132ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmsub132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9a,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsub132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9a,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsub132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9a,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsub132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmsub132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsub132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmsub132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9a,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsub132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsub132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9a,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsub132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsub132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9a,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsub132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsub132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsub132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsub132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9a,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsub132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsub132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9a,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsub132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsub132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9a,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsub132ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmsub132ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9a,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsub132ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9a,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsub132ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9a,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsub132ps 485498096, %zmm2, %zmm2 

// CHECK: vfmsub132ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9a,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsub132ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9a,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsub132ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9a,0x12]      
vfmsub132ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmsub132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9a,0x12]     
vfmsub132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9a,0x12]    
vfmsub132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9a,0x12]      
vfmsub132ps (%edx), %zmm2, %zmm2 

// CHECK: vfmsub132ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9a,0x12]     
vfmsub132ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9a,0x12]    
vfmsub132ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132ps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x38,0x9a,0xd2]     
vfmsub132ps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x3a,0x9a,0xd2]    
vfmsub132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xba,0x9a,0xd2]   
vfmsub132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132ps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x18,0x9a,0xd2]     
vfmsub132ps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x1a,0x9a,0xd2]    
vfmsub132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x9a,0x9a,0xd2]   
vfmsub132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132ps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9a,0xd2]     
vfmsub132ps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9a,0xd2]    
vfmsub132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9a,0xd2]   
vfmsub132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132ps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x78,0x9a,0xd2]     
vfmsub132ps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x7a,0x9a,0xd2]    
vfmsub132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xfa,0x9a,0xd2]   
vfmsub132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub132ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9a,0xd2]      
vfmsub132ps %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub132ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9a,0xd2]     
vfmsub132ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub132ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9a,0xd2]    
vfmsub132ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xaa,0x54,0x02,0x40]      
vfmsub213pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmsub213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xaa,0x54,0x02,0x40]     
vfmsub213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xaa,0x54,0x02,0x40]    
vfmsub213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xaa,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsub213pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vfmsub213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xaa,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsub213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xaa,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsub213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xaa,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsub213pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmsub213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xaa,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsub213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xaa,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsub213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xaa,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsub213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmsub213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xaa,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsub213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmsub213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xaa,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsub213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xaa,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsub213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xaa,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsub213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xaa,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsub213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xaa,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsub213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsub213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xaa,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsub213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsub213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xaa,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsub213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xaa,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsub213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xaa,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsub213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xaa,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsub213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xaa,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsub213pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmsub213pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xaa,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsub213pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xaa,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsub213pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xaa,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsub213pd 485498096, %zmm2, %zmm2 

// CHECK: vfmsub213pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xaa,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsub213pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xaa,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsub213pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xaa,0x54,0x02,0x40]      
vfmsub213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vfmsub213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xaa,0x54,0x02,0x40]     
vfmsub213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xaa,0x54,0x02,0x40]    
vfmsub213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xaa,0x12]      
vfmsub213pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmsub213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xaa,0x12]     
vfmsub213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xaa,0x12]    
vfmsub213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xaa,0x12]      
vfmsub213pd (%edx), %zmm2, %zmm2 

// CHECK: vfmsub213pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xaa,0x12]     
vfmsub213pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xaa,0x12]    
vfmsub213pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213pd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x38,0xaa,0xd2]     
vfmsub213pd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x3a,0xaa,0xd2]    
vfmsub213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xba,0xaa,0xd2]   
vfmsub213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213pd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x18,0xaa,0xd2]     
vfmsub213pd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x1a,0xaa,0xd2]    
vfmsub213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0x9a,0xaa,0xd2]   
vfmsub213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213pd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xaa,0xd2]     
vfmsub213pd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xaa,0xd2]    
vfmsub213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xaa,0xd2]   
vfmsub213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213pd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x78,0xaa,0xd2]     
vfmsub213pd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x7a,0xaa,0xd2]    
vfmsub213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xfa,0xaa,0xd2]   
vfmsub213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xaa,0xd2]      
vfmsub213pd %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub213pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xaa,0xd2]     
vfmsub213pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xaa,0xd2]    
vfmsub213pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xaa,0x54,0x02,0x40]      
vfmsub213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vfmsub213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xaa,0x54,0x02,0x40]     
vfmsub213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xaa,0x54,0x02,0x40]    
vfmsub213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xaa,0x54,0x02,0x40]      
vfmsub213ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmsub213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xaa,0x54,0x02,0x40]     
vfmsub213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xaa,0x54,0x02,0x40]    
vfmsub213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xaa,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsub213ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vfmsub213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xaa,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsub213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xaa,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsub213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xaa,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsub213ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmsub213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xaa,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsub213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xaa,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsub213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xaa,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsub213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmsub213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xaa,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsub213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmsub213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xaa,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsub213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xaa,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsub213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xaa,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsub213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xaa,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsub213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xaa,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsub213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsub213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xaa,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsub213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsub213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xaa,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsub213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xaa,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsub213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xaa,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsub213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xaa,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsub213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xaa,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsub213ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmsub213ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xaa,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsub213ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xaa,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsub213ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xaa,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsub213ps 485498096, %zmm2, %zmm2 

// CHECK: vfmsub213ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xaa,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsub213ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xaa,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsub213ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xaa,0x12]      
vfmsub213ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmsub213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xaa,0x12]     
vfmsub213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xaa,0x12]    
vfmsub213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xaa,0x12]      
vfmsub213ps (%edx), %zmm2, %zmm2 

// CHECK: vfmsub213ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xaa,0x12]     
vfmsub213ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xaa,0x12]    
vfmsub213ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213ps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x38,0xaa,0xd2]     
vfmsub213ps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x3a,0xaa,0xd2]    
vfmsub213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xba,0xaa,0xd2]   
vfmsub213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213ps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x18,0xaa,0xd2]     
vfmsub213ps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x1a,0xaa,0xd2]    
vfmsub213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x9a,0xaa,0xd2]   
vfmsub213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213ps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xaa,0xd2]     
vfmsub213ps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xaa,0xd2]    
vfmsub213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xaa,0xd2]   
vfmsub213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213ps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x78,0xaa,0xd2]     
vfmsub213ps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x7a,0xaa,0xd2]    
vfmsub213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xfa,0xaa,0xd2]   
vfmsub213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub213ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xaa,0xd2]      
vfmsub213ps %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub213ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xaa,0xd2]     
vfmsub213ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub213ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xaa,0xd2]    
vfmsub213ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xba,0x54,0x02,0x40]      
vfmsub231pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmsub231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xba,0x54,0x02,0x40]     
vfmsub231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xba,0x54,0x02,0x40]    
vfmsub231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xba,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsub231pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vfmsub231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xba,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsub231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xba,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsub231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xba,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsub231pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmsub231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xba,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsub231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xba,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsub231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xba,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsub231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmsub231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xba,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsub231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmsub231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xba,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsub231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xba,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsub231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xba,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsub231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xba,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsub231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xba,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsub231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsub231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xba,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsub231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsub231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xba,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsub231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xba,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsub231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xba,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsub231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xba,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsub231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xba,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsub231pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmsub231pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xba,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsub231pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xba,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsub231pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xba,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsub231pd 485498096, %zmm2, %zmm2 

// CHECK: vfmsub231pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xba,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsub231pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xba,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsub231pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xba,0x54,0x02,0x40]      
vfmsub231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vfmsub231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xba,0x54,0x02,0x40]     
vfmsub231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xba,0x54,0x02,0x40]    
vfmsub231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xba,0x12]      
vfmsub231pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmsub231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xba,0x12]     
vfmsub231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xba,0x12]    
vfmsub231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xba,0x12]      
vfmsub231pd (%edx), %zmm2, %zmm2 

// CHECK: vfmsub231pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xba,0x12]     
vfmsub231pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xba,0x12]    
vfmsub231pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231pd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x38,0xba,0xd2]     
vfmsub231pd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x3a,0xba,0xd2]    
vfmsub231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xba,0xba,0xd2]   
vfmsub231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231pd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x18,0xba,0xd2]     
vfmsub231pd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x1a,0xba,0xd2]    
vfmsub231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0x9a,0xba,0xd2]   
vfmsub231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231pd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xba,0xd2]     
vfmsub231pd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xba,0xd2]    
vfmsub231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xba,0xd2]   
vfmsub231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231pd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x78,0xba,0xd2]     
vfmsub231pd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x7a,0xba,0xd2]    
vfmsub231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xfa,0xba,0xd2]   
vfmsub231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xba,0xd2]      
vfmsub231pd %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub231pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xba,0xd2]     
vfmsub231pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xba,0xd2]    
vfmsub231pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xba,0x54,0x02,0x40]      
vfmsub231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vfmsub231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xba,0x54,0x02,0x40]     
vfmsub231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xba,0x54,0x02,0x40]    
vfmsub231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xba,0x54,0x02,0x40]      
vfmsub231ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmsub231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xba,0x54,0x02,0x40]     
vfmsub231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xba,0x54,0x02,0x40]    
vfmsub231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xba,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsub231ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vfmsub231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xba,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsub231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xba,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsub231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xba,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsub231ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmsub231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xba,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsub231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xba,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsub231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xba,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsub231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmsub231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xba,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsub231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmsub231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xba,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsub231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xba,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsub231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xba,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsub231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xba,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsub231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xba,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsub231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsub231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xba,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsub231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsub231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xba,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsub231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xba,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsub231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xba,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsub231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xba,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsub231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xba,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsub231ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmsub231ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xba,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsub231ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xba,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsub231ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xba,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsub231ps 485498096, %zmm2, %zmm2 

// CHECK: vfmsub231ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xba,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsub231ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xba,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsub231ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xba,0x12]      
vfmsub231ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmsub231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xba,0x12]     
vfmsub231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xba,0x12]    
vfmsub231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xba,0x12]      
vfmsub231ps (%edx), %zmm2, %zmm2 

// CHECK: vfmsub231ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xba,0x12]     
vfmsub231ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xba,0x12]    
vfmsub231ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231ps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x38,0xba,0xd2]     
vfmsub231ps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x3a,0xba,0xd2]    
vfmsub231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xba,0xba,0xd2]   
vfmsub231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231ps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x18,0xba,0xd2]     
vfmsub231ps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x1a,0xba,0xd2]    
vfmsub231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x9a,0xba,0xd2]   
vfmsub231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231ps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xba,0xd2]     
vfmsub231ps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xba,0xd2]    
vfmsub231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xba,0xd2]   
vfmsub231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231ps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x78,0xba,0xd2]     
vfmsub231ps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x7a,0xba,0xd2]    
vfmsub231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xfa,0xba,0xd2]   
vfmsub231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsub231ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xba,0xd2]      
vfmsub231ps %zmm2, %zmm2, %zmm2 

// CHECK: vfmsub231ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xba,0xd2]     
vfmsub231ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsub231ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xba,0xd2]    
vfmsub231ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x97,0x54,0x02,0x40]      
vfmsubadd132pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmsubadd132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x97,0x54,0x02,0x40]     
vfmsubadd132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x97,0x54,0x02,0x40]    
vfmsubadd132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x97,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd132pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vfmsubadd132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x97,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x97,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x97,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd132pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmsubadd132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x97,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x97,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x97,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsubadd132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmsubadd132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x97,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmsubadd132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x97,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsubadd132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x97,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x97,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsubadd132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x97,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x97,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsubadd132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsubadd132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x97,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsubadd132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x97,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsubadd132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x97,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x97,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsubadd132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x97,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x97,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd132pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmsubadd132pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x97,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd132pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x97,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd132pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x97,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd132pd 485498096, %zmm2, %zmm2 

// CHECK: vfmsubadd132pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x97,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd132pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x97,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd132pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x97,0x54,0x02,0x40]      
vfmsubadd132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vfmsubadd132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x97,0x54,0x02,0x40]     
vfmsubadd132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x97,0x54,0x02,0x40]    
vfmsubadd132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x97,0x12]      
vfmsubadd132pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmsubadd132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x97,0x12]     
vfmsubadd132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x97,0x12]    
vfmsubadd132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x97,0x12]      
vfmsubadd132pd (%edx), %zmm2, %zmm2 

// CHECK: vfmsubadd132pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x97,0x12]     
vfmsubadd132pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x97,0x12]    
vfmsubadd132pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132pd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x38,0x97,0xd2]     
vfmsubadd132pd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x3a,0x97,0xd2]    
vfmsubadd132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xba,0x97,0xd2]   
vfmsubadd132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132pd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x18,0x97,0xd2]     
vfmsubadd132pd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x1a,0x97,0xd2]    
vfmsubadd132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0x9a,0x97,0xd2]   
vfmsubadd132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132pd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x97,0xd2]     
vfmsubadd132pd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x97,0xd2]    
vfmsubadd132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x97,0xd2]   
vfmsubadd132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132pd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x78,0x97,0xd2]     
vfmsubadd132pd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x7a,0x97,0xd2]    
vfmsubadd132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xfa,0x97,0xd2]   
vfmsubadd132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x97,0xd2]      
vfmsubadd132pd %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd132pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x97,0xd2]     
vfmsubadd132pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x97,0xd2]    
vfmsubadd132pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x97,0x54,0x02,0x40]      
vfmsubadd132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vfmsubadd132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x97,0x54,0x02,0x40]     
vfmsubadd132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x97,0x54,0x02,0x40]    
vfmsubadd132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x97,0x54,0x02,0x40]      
vfmsubadd132ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmsubadd132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x97,0x54,0x02,0x40]     
vfmsubadd132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x97,0x54,0x02,0x40]    
vfmsubadd132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x97,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd132ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vfmsubadd132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x97,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x97,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x97,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd132ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmsubadd132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x97,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x97,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x97,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsubadd132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmsubadd132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x97,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmsubadd132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x97,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsubadd132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x97,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x97,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsubadd132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x97,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x97,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsubadd132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsubadd132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x97,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsubadd132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x97,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsubadd132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x97,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x97,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsubadd132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x97,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x97,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd132ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmsubadd132ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x97,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd132ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x97,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd132ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x97,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd132ps 485498096, %zmm2, %zmm2 

// CHECK: vfmsubadd132ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x97,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd132ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x97,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd132ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x97,0x12]      
vfmsubadd132ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmsubadd132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x97,0x12]     
vfmsubadd132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x97,0x12]    
vfmsubadd132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x97,0x12]      
vfmsubadd132ps (%edx), %zmm2, %zmm2 

// CHECK: vfmsubadd132ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x97,0x12]     
vfmsubadd132ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x97,0x12]    
vfmsubadd132ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132ps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x38,0x97,0xd2]     
vfmsubadd132ps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x3a,0x97,0xd2]    
vfmsubadd132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xba,0x97,0xd2]   
vfmsubadd132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132ps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x18,0x97,0xd2]     
vfmsubadd132ps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x1a,0x97,0xd2]    
vfmsubadd132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x9a,0x97,0xd2]   
vfmsubadd132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132ps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x97,0xd2]     
vfmsubadd132ps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x97,0xd2]    
vfmsubadd132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x97,0xd2]   
vfmsubadd132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132ps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x78,0x97,0xd2]     
vfmsubadd132ps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x7a,0x97,0xd2]    
vfmsubadd132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xfa,0x97,0xd2]   
vfmsubadd132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd132ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x97,0xd2]      
vfmsubadd132ps %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd132ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x97,0xd2]     
vfmsubadd132ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd132ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x97,0xd2]    
vfmsubadd132ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa7,0x54,0x02,0x40]      
vfmsubadd213pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmsubadd213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa7,0x54,0x02,0x40]     
vfmsubadd213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa7,0x54,0x02,0x40]    
vfmsubadd213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa7,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd213pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vfmsubadd213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa7,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa7,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa7,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd213pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmsubadd213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa7,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa7,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa7,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsubadd213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmsubadd213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmsubadd213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa7,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsubadd213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa7,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsubadd213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa7,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsubadd213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsubadd213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsubadd213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa7,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsubadd213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa7,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsubadd213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa7,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd213pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmsubadd213pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa7,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd213pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa7,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd213pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa7,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd213pd 485498096, %zmm2, %zmm2 

// CHECK: vfmsubadd213pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa7,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd213pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa7,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd213pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa7,0x54,0x02,0x40]      
vfmsubadd213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vfmsubadd213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa7,0x54,0x02,0x40]     
vfmsubadd213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa7,0x54,0x02,0x40]    
vfmsubadd213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa7,0x12]      
vfmsubadd213pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmsubadd213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa7,0x12]     
vfmsubadd213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa7,0x12]    
vfmsubadd213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa7,0x12]      
vfmsubadd213pd (%edx), %zmm2, %zmm2 

// CHECK: vfmsubadd213pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa7,0x12]     
vfmsubadd213pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa7,0x12]    
vfmsubadd213pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213pd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x38,0xa7,0xd2]     
vfmsubadd213pd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x3a,0xa7,0xd2]    
vfmsubadd213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xba,0xa7,0xd2]   
vfmsubadd213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213pd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x18,0xa7,0xd2]     
vfmsubadd213pd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x1a,0xa7,0xd2]    
vfmsubadd213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0x9a,0xa7,0xd2]   
vfmsubadd213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213pd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xa7,0xd2]     
vfmsubadd213pd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xa7,0xd2]    
vfmsubadd213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xa7,0xd2]   
vfmsubadd213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213pd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x78,0xa7,0xd2]     
vfmsubadd213pd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x7a,0xa7,0xd2]    
vfmsubadd213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xfa,0xa7,0xd2]   
vfmsubadd213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xa7,0xd2]      
vfmsubadd213pd %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd213pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xa7,0xd2]     
vfmsubadd213pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xa7,0xd2]    
vfmsubadd213pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa7,0x54,0x02,0x40]      
vfmsubadd213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vfmsubadd213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa7,0x54,0x02,0x40]     
vfmsubadd213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa7,0x54,0x02,0x40]    
vfmsubadd213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa7,0x54,0x02,0x40]      
vfmsubadd213ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmsubadd213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa7,0x54,0x02,0x40]     
vfmsubadd213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa7,0x54,0x02,0x40]    
vfmsubadd213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa7,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd213ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vfmsubadd213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa7,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa7,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa7,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd213ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmsubadd213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa7,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa7,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa7,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsubadd213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmsubadd213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmsubadd213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa7,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsubadd213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa7,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsubadd213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa7,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsubadd213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsubadd213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsubadd213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa7,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsubadd213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa7,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsubadd213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa7,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd213ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmsubadd213ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa7,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd213ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa7,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd213ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa7,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd213ps 485498096, %zmm2, %zmm2 

// CHECK: vfmsubadd213ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa7,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd213ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa7,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd213ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa7,0x12]      
vfmsubadd213ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmsubadd213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa7,0x12]     
vfmsubadd213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa7,0x12]    
vfmsubadd213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa7,0x12]      
vfmsubadd213ps (%edx), %zmm2, %zmm2 

// CHECK: vfmsubadd213ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa7,0x12]     
vfmsubadd213ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa7,0x12]    
vfmsubadd213ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213ps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x38,0xa7,0xd2]     
vfmsubadd213ps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x3a,0xa7,0xd2]    
vfmsubadd213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xba,0xa7,0xd2]   
vfmsubadd213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213ps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x18,0xa7,0xd2]     
vfmsubadd213ps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x1a,0xa7,0xd2]    
vfmsubadd213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x9a,0xa7,0xd2]   
vfmsubadd213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213ps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xa7,0xd2]     
vfmsubadd213ps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xa7,0xd2]    
vfmsubadd213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xa7,0xd2]   
vfmsubadd213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213ps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x78,0xa7,0xd2]     
vfmsubadd213ps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x7a,0xa7,0xd2]    
vfmsubadd213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xfa,0xa7,0xd2]   
vfmsubadd213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd213ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xa7,0xd2]      
vfmsubadd213ps %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd213ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xa7,0xd2]     
vfmsubadd213ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd213ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xa7,0xd2]    
vfmsubadd213ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb7,0x54,0x02,0x40]      
vfmsubadd231pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmsubadd231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb7,0x54,0x02,0x40]     
vfmsubadd231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb7,0x54,0x02,0x40]    
vfmsubadd231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb7,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd231pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vfmsubadd231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb7,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb7,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb7,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd231pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmsubadd231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb7,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb7,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb7,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsubadd231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmsubadd231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfmsubadd231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb7,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsubadd231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb7,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsubadd231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb7,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsubadd231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsubadd231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsubadd231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb7,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsubadd231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb7,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsubadd231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb7,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd231pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmsubadd231pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb7,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd231pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb7,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd231pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb7,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd231pd 485498096, %zmm2, %zmm2 

// CHECK: vfmsubadd231pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb7,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd231pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb7,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd231pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb7,0x54,0x02,0x40]      
vfmsubadd231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vfmsubadd231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb7,0x54,0x02,0x40]     
vfmsubadd231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb7,0x54,0x02,0x40]    
vfmsubadd231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb7,0x12]      
vfmsubadd231pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfmsubadd231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb7,0x12]     
vfmsubadd231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb7,0x12]    
vfmsubadd231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb7,0x12]      
vfmsubadd231pd (%edx), %zmm2, %zmm2 

// CHECK: vfmsubadd231pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb7,0x12]     
vfmsubadd231pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb7,0x12]    
vfmsubadd231pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231pd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x38,0xb7,0xd2]     
vfmsubadd231pd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x3a,0xb7,0xd2]    
vfmsubadd231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xba,0xb7,0xd2]   
vfmsubadd231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231pd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x18,0xb7,0xd2]     
vfmsubadd231pd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x1a,0xb7,0xd2]    
vfmsubadd231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0x9a,0xb7,0xd2]   
vfmsubadd231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231pd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xb7,0xd2]     
vfmsubadd231pd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xb7,0xd2]    
vfmsubadd231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xb7,0xd2]   
vfmsubadd231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231pd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x78,0xb7,0xd2]     
vfmsubadd231pd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x7a,0xb7,0xd2]    
vfmsubadd231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xfa,0xb7,0xd2]   
vfmsubadd231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xb7,0xd2]      
vfmsubadd231pd %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd231pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xb7,0xd2]     
vfmsubadd231pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xb7,0xd2]    
vfmsubadd231pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb7,0x54,0x02,0x40]      
vfmsubadd231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vfmsubadd231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb7,0x54,0x02,0x40]     
vfmsubadd231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb7,0x54,0x02,0x40]    
vfmsubadd231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb7,0x54,0x02,0x40]      
vfmsubadd231ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfmsubadd231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb7,0x54,0x02,0x40]     
vfmsubadd231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb7,0x54,0x02,0x40]    
vfmsubadd231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb7,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd231ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vfmsubadd231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb7,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb7,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb7,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd231ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmsubadd231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb7,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb7,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb7,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsubadd231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmsubadd231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfmsubadd231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb7,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsubadd231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb7,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsubadd231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb7,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfmsubadd231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsubadd231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfmsubadd231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb7,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfmsubadd231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb7,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfmsubadd231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb7,0x92,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd231ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfmsubadd231ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb7,0x92,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd231ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb7,0x92,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd231ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb7,0x15,0xf0,0x1c,0xf0,0x1c]      
vfmsubadd231ps 485498096, %zmm2, %zmm2 

// CHECK: vfmsubadd231ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb7,0x15,0xf0,0x1c,0xf0,0x1c]     
vfmsubadd231ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb7,0x15,0xf0,0x1c,0xf0,0x1c]    
vfmsubadd231ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb7,0x12]      
vfmsubadd231ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfmsubadd231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb7,0x12]     
vfmsubadd231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb7,0x12]    
vfmsubadd231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb7,0x12]      
vfmsubadd231ps (%edx), %zmm2, %zmm2 

// CHECK: vfmsubadd231ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb7,0x12]     
vfmsubadd231ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb7,0x12]    
vfmsubadd231ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231ps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x38,0xb7,0xd2]     
vfmsubadd231ps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x3a,0xb7,0xd2]    
vfmsubadd231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xba,0xb7,0xd2]   
vfmsubadd231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231ps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x18,0xb7,0xd2]     
vfmsubadd231ps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x1a,0xb7,0xd2]    
vfmsubadd231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x9a,0xb7,0xd2]   
vfmsubadd231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231ps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xb7,0xd2]     
vfmsubadd231ps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xb7,0xd2]    
vfmsubadd231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xb7,0xd2]   
vfmsubadd231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231ps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x78,0xb7,0xd2]     
vfmsubadd231ps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x7a,0xb7,0xd2]    
vfmsubadd231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xfa,0xb7,0xd2]   
vfmsubadd231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfmsubadd231ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xb7,0xd2]      
vfmsubadd231ps %zmm2, %zmm2, %zmm2 

// CHECK: vfmsubadd231ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xb7,0xd2]     
vfmsubadd231ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfmsubadd231ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xb7,0xd2]    
vfmsubadd231ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9c,0x54,0x02,0x40]      
vfnmadd132pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfnmadd132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9c,0x54,0x02,0x40]     
vfnmadd132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9c,0x54,0x02,0x40]    
vfnmadd132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9c,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmadd132pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vfnmadd132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9c,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmadd132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9c,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmadd132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9c,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmadd132pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfnmadd132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9c,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmadd132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9c,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmadd132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9c,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmadd132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfnmadd132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9c,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmadd132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfnmadd132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9c,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmadd132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9c,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmadd132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9c,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmadd132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9c,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmadd132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9c,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmadd132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmadd132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9c,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmadd132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmadd132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9c,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmadd132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9c,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmadd132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9c,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmadd132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9c,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmadd132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9c,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmadd132pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfnmadd132pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9c,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmadd132pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9c,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmadd132pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9c,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmadd132pd 485498096, %zmm2, %zmm2 

// CHECK: vfnmadd132pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9c,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmadd132pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9c,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmadd132pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9c,0x54,0x02,0x40]      
vfnmadd132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vfnmadd132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9c,0x54,0x02,0x40]     
vfnmadd132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9c,0x54,0x02,0x40]    
vfnmadd132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9c,0x12]      
vfnmadd132pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfnmadd132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9c,0x12]     
vfnmadd132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9c,0x12]    
vfnmadd132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9c,0x12]      
vfnmadd132pd (%edx), %zmm2, %zmm2 

// CHECK: vfnmadd132pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9c,0x12]     
vfnmadd132pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9c,0x12]    
vfnmadd132pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132pd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x38,0x9c,0xd2]     
vfnmadd132pd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x3a,0x9c,0xd2]    
vfnmadd132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xba,0x9c,0xd2]   
vfnmadd132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132pd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x18,0x9c,0xd2]     
vfnmadd132pd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x1a,0x9c,0xd2]    
vfnmadd132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0x9a,0x9c,0xd2]   
vfnmadd132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132pd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9c,0xd2]     
vfnmadd132pd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9c,0xd2]    
vfnmadd132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9c,0xd2]   
vfnmadd132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132pd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x78,0x9c,0xd2]     
vfnmadd132pd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x7a,0x9c,0xd2]    
vfnmadd132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xfa,0x9c,0xd2]   
vfnmadd132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9c,0xd2]      
vfnmadd132pd %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd132pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9c,0xd2]     
vfnmadd132pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9c,0xd2]    
vfnmadd132pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9c,0x54,0x02,0x40]      
vfnmadd132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vfnmadd132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9c,0x54,0x02,0x40]     
vfnmadd132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9c,0x54,0x02,0x40]    
vfnmadd132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9c,0x54,0x02,0x40]      
vfnmadd132ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfnmadd132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9c,0x54,0x02,0x40]     
vfnmadd132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9c,0x54,0x02,0x40]    
vfnmadd132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9c,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmadd132ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vfnmadd132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9c,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmadd132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9c,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmadd132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9c,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmadd132ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfnmadd132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9c,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmadd132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9c,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmadd132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9c,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmadd132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfnmadd132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9c,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmadd132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfnmadd132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9c,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmadd132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9c,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmadd132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9c,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmadd132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9c,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmadd132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmadd132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9c,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmadd132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmadd132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9c,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmadd132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9c,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmadd132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9c,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmadd132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9c,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmadd132ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfnmadd132ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9c,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmadd132ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9c,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmadd132ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9c,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmadd132ps 485498096, %zmm2, %zmm2 

// CHECK: vfnmadd132ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9c,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmadd132ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9c,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmadd132ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9c,0x12]      
vfnmadd132ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfnmadd132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9c,0x12]     
vfnmadd132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9c,0x12]    
vfnmadd132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9c,0x12]      
vfnmadd132ps (%edx), %zmm2, %zmm2 

// CHECK: vfnmadd132ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9c,0x12]     
vfnmadd132ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9c,0x12]    
vfnmadd132ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132ps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x38,0x9c,0xd2]     
vfnmadd132ps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x3a,0x9c,0xd2]    
vfnmadd132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xba,0x9c,0xd2]   
vfnmadd132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132ps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x18,0x9c,0xd2]     
vfnmadd132ps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x1a,0x9c,0xd2]    
vfnmadd132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x9a,0x9c,0xd2]   
vfnmadd132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132ps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9c,0xd2]     
vfnmadd132ps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9c,0xd2]    
vfnmadd132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9c,0xd2]   
vfnmadd132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132ps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x78,0x9c,0xd2]     
vfnmadd132ps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x7a,0x9c,0xd2]    
vfnmadd132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xfa,0x9c,0xd2]   
vfnmadd132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd132ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9c,0xd2]      
vfnmadd132ps %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd132ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9c,0xd2]     
vfnmadd132ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd132ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9c,0xd2]    
vfnmadd132ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xac,0x54,0x02,0x40]      
vfnmadd213pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfnmadd213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xac,0x54,0x02,0x40]     
vfnmadd213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xac,0x54,0x02,0x40]    
vfnmadd213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xac,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmadd213pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vfnmadd213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xac,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmadd213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xac,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmadd213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xac,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmadd213pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfnmadd213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xac,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmadd213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xac,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmadd213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xac,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmadd213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfnmadd213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xac,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmadd213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfnmadd213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xac,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmadd213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xac,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmadd213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xac,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmadd213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xac,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmadd213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xac,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmadd213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmadd213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xac,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmadd213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmadd213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xac,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmadd213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xac,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmadd213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xac,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmadd213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xac,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmadd213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xac,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmadd213pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfnmadd213pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xac,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmadd213pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xac,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmadd213pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xac,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmadd213pd 485498096, %zmm2, %zmm2 

// CHECK: vfnmadd213pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xac,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmadd213pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xac,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmadd213pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xac,0x54,0x02,0x40]      
vfnmadd213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vfnmadd213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xac,0x54,0x02,0x40]     
vfnmadd213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xac,0x54,0x02,0x40]    
vfnmadd213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xac,0x12]      
vfnmadd213pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfnmadd213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xac,0x12]     
vfnmadd213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xac,0x12]    
vfnmadd213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xac,0x12]      
vfnmadd213pd (%edx), %zmm2, %zmm2 

// CHECK: vfnmadd213pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xac,0x12]     
vfnmadd213pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xac,0x12]    
vfnmadd213pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213pd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x38,0xac,0xd2]     
vfnmadd213pd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x3a,0xac,0xd2]    
vfnmadd213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xba,0xac,0xd2]   
vfnmadd213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213pd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x18,0xac,0xd2]     
vfnmadd213pd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x1a,0xac,0xd2]    
vfnmadd213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0x9a,0xac,0xd2]   
vfnmadd213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213pd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xac,0xd2]     
vfnmadd213pd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xac,0xd2]    
vfnmadd213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xac,0xd2]   
vfnmadd213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213pd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x78,0xac,0xd2]     
vfnmadd213pd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x7a,0xac,0xd2]    
vfnmadd213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xfa,0xac,0xd2]   
vfnmadd213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xac,0xd2]      
vfnmadd213pd %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd213pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xac,0xd2]     
vfnmadd213pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xac,0xd2]    
vfnmadd213pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xac,0x54,0x02,0x40]      
vfnmadd213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vfnmadd213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xac,0x54,0x02,0x40]     
vfnmadd213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xac,0x54,0x02,0x40]    
vfnmadd213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xac,0x54,0x02,0x40]      
vfnmadd213ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfnmadd213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xac,0x54,0x02,0x40]     
vfnmadd213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xac,0x54,0x02,0x40]    
vfnmadd213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xac,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmadd213ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vfnmadd213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xac,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmadd213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xac,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmadd213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xac,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmadd213ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfnmadd213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xac,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmadd213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xac,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmadd213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xac,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmadd213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfnmadd213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xac,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmadd213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfnmadd213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xac,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmadd213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xac,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmadd213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xac,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmadd213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xac,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmadd213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xac,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmadd213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmadd213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xac,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmadd213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmadd213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xac,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmadd213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xac,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmadd213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xac,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmadd213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xac,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmadd213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xac,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmadd213ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfnmadd213ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xac,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmadd213ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xac,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmadd213ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xac,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmadd213ps 485498096, %zmm2, %zmm2 

// CHECK: vfnmadd213ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xac,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmadd213ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xac,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmadd213ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xac,0x12]      
vfnmadd213ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfnmadd213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xac,0x12]     
vfnmadd213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xac,0x12]    
vfnmadd213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xac,0x12]      
vfnmadd213ps (%edx), %zmm2, %zmm2 

// CHECK: vfnmadd213ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xac,0x12]     
vfnmadd213ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xac,0x12]    
vfnmadd213ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213ps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x38,0xac,0xd2]     
vfnmadd213ps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x3a,0xac,0xd2]    
vfnmadd213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xba,0xac,0xd2]   
vfnmadd213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213ps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x18,0xac,0xd2]     
vfnmadd213ps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x1a,0xac,0xd2]    
vfnmadd213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x9a,0xac,0xd2]   
vfnmadd213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213ps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xac,0xd2]     
vfnmadd213ps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xac,0xd2]    
vfnmadd213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xac,0xd2]   
vfnmadd213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213ps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x78,0xac,0xd2]     
vfnmadd213ps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x7a,0xac,0xd2]    
vfnmadd213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xfa,0xac,0xd2]   
vfnmadd213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd213ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xac,0xd2]      
vfnmadd213ps %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd213ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xac,0xd2]     
vfnmadd213ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd213ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xac,0xd2]    
vfnmadd213ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xbc,0x54,0x02,0x40]      
vfnmadd231pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfnmadd231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xbc,0x54,0x02,0x40]     
vfnmadd231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xbc,0x54,0x02,0x40]    
vfnmadd231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xbc,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmadd231pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vfnmadd231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xbc,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmadd231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xbc,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmadd231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xbc,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmadd231pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfnmadd231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xbc,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmadd231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xbc,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmadd231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xbc,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmadd231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfnmadd231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xbc,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmadd231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfnmadd231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xbc,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmadd231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xbc,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmadd231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xbc,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmadd231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xbc,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmadd231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xbc,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmadd231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmadd231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xbc,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmadd231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmadd231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xbc,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmadd231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xbc,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmadd231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xbc,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmadd231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xbc,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmadd231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xbc,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmadd231pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfnmadd231pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xbc,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmadd231pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xbc,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmadd231pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xbc,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmadd231pd 485498096, %zmm2, %zmm2 

// CHECK: vfnmadd231pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xbc,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmadd231pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xbc,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmadd231pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xbc,0x54,0x02,0x40]      
vfnmadd231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vfnmadd231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xbc,0x54,0x02,0x40]     
vfnmadd231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xbc,0x54,0x02,0x40]    
vfnmadd231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xbc,0x12]      
vfnmadd231pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfnmadd231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xbc,0x12]     
vfnmadd231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xbc,0x12]    
vfnmadd231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xbc,0x12]      
vfnmadd231pd (%edx), %zmm2, %zmm2 

// CHECK: vfnmadd231pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xbc,0x12]     
vfnmadd231pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xbc,0x12]    
vfnmadd231pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231pd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x38,0xbc,0xd2]     
vfnmadd231pd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x3a,0xbc,0xd2]    
vfnmadd231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xba,0xbc,0xd2]   
vfnmadd231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231pd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x18,0xbc,0xd2]     
vfnmadd231pd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x1a,0xbc,0xd2]    
vfnmadd231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0x9a,0xbc,0xd2]   
vfnmadd231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231pd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xbc,0xd2]     
vfnmadd231pd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xbc,0xd2]    
vfnmadd231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xbc,0xd2]   
vfnmadd231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231pd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x78,0xbc,0xd2]     
vfnmadd231pd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x7a,0xbc,0xd2]    
vfnmadd231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xfa,0xbc,0xd2]   
vfnmadd231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xbc,0xd2]      
vfnmadd231pd %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd231pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xbc,0xd2]     
vfnmadd231pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xbc,0xd2]    
vfnmadd231pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xbc,0x54,0x02,0x40]      
vfnmadd231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vfnmadd231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xbc,0x54,0x02,0x40]     
vfnmadd231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xbc,0x54,0x02,0x40]    
vfnmadd231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xbc,0x54,0x02,0x40]      
vfnmadd231ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfnmadd231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xbc,0x54,0x02,0x40]     
vfnmadd231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xbc,0x54,0x02,0x40]    
vfnmadd231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xbc,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmadd231ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vfnmadd231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xbc,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmadd231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xbc,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmadd231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xbc,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmadd231ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfnmadd231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xbc,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmadd231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xbc,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmadd231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xbc,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmadd231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfnmadd231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xbc,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmadd231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfnmadd231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xbc,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmadd231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xbc,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmadd231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xbc,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmadd231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xbc,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmadd231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xbc,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmadd231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmadd231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xbc,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmadd231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmadd231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xbc,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmadd231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xbc,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmadd231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xbc,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmadd231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xbc,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmadd231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xbc,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmadd231ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfnmadd231ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xbc,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmadd231ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xbc,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmadd231ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xbc,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmadd231ps 485498096, %zmm2, %zmm2 

// CHECK: vfnmadd231ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xbc,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmadd231ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xbc,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmadd231ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xbc,0x12]      
vfnmadd231ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfnmadd231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xbc,0x12]     
vfnmadd231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xbc,0x12]    
vfnmadd231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xbc,0x12]      
vfnmadd231ps (%edx), %zmm2, %zmm2 

// CHECK: vfnmadd231ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xbc,0x12]     
vfnmadd231ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xbc,0x12]    
vfnmadd231ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231ps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x38,0xbc,0xd2]     
vfnmadd231ps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x3a,0xbc,0xd2]    
vfnmadd231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xba,0xbc,0xd2]   
vfnmadd231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231ps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x18,0xbc,0xd2]     
vfnmadd231ps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x1a,0xbc,0xd2]    
vfnmadd231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x9a,0xbc,0xd2]   
vfnmadd231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231ps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xbc,0xd2]     
vfnmadd231ps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xbc,0xd2]    
vfnmadd231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xbc,0xd2]   
vfnmadd231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231ps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x78,0xbc,0xd2]     
vfnmadd231ps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x7a,0xbc,0xd2]    
vfnmadd231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xfa,0xbc,0xd2]   
vfnmadd231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmadd231ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xbc,0xd2]      
vfnmadd231ps %zmm2, %zmm2, %zmm2 

// CHECK: vfnmadd231ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xbc,0xd2]     
vfnmadd231ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmadd231ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xbc,0xd2]    
vfnmadd231ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9e,0x54,0x02,0x40]      
vfnmsub132pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfnmsub132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9e,0x54,0x02,0x40]     
vfnmsub132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9e,0x54,0x02,0x40]    
vfnmsub132pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9e,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmsub132pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vfnmsub132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9e,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmsub132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9e,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmsub132pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9e,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmsub132pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfnmsub132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9e,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmsub132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9e,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmsub132pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9e,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmsub132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfnmsub132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmsub132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfnmsub132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9e,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmsub132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmsub132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9e,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmsub132pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmsub132pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9e,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmsub132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmsub132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmsub132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmsub132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9e,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmsub132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmsub132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9e,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmsub132pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmsub132pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9e,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmsub132pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfnmsub132pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9e,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmsub132pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9e,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmsub132pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9e,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmsub132pd 485498096, %zmm2, %zmm2 

// CHECK: vfnmsub132pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9e,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmsub132pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9e,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmsub132pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9e,0x54,0x02,0x40]      
vfnmsub132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vfnmsub132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9e,0x54,0x02,0x40]     
vfnmsub132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9e,0x54,0x02,0x40]    
vfnmsub132pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9e,0x12]      
vfnmsub132pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfnmsub132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9e,0x12]     
vfnmsub132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9e,0x12]    
vfnmsub132pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9e,0x12]      
vfnmsub132pd (%edx), %zmm2, %zmm2 

// CHECK: vfnmsub132pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9e,0x12]     
vfnmsub132pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9e,0x12]    
vfnmsub132pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132pd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x38,0x9e,0xd2]     
vfnmsub132pd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x3a,0x9e,0xd2]    
vfnmsub132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xba,0x9e,0xd2]   
vfnmsub132pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132pd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x18,0x9e,0xd2]     
vfnmsub132pd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x1a,0x9e,0xd2]    
vfnmsub132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0x9a,0x9e,0xd2]   
vfnmsub132pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132pd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x9e,0xd2]     
vfnmsub132pd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x9e,0xd2]    
vfnmsub132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x9e,0xd2]   
vfnmsub132pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132pd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x78,0x9e,0xd2]     
vfnmsub132pd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x7a,0x9e,0xd2]    
vfnmsub132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xfa,0x9e,0xd2]   
vfnmsub132pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x9e,0xd2]      
vfnmsub132pd %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub132pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x9e,0xd2]     
vfnmsub132pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x9e,0xd2]    
vfnmsub132pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9e,0x54,0x02,0x40]      
vfnmsub132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vfnmsub132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9e,0x54,0x02,0x40]     
vfnmsub132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9e,0x54,0x02,0x40]    
vfnmsub132ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9e,0x54,0x02,0x40]      
vfnmsub132ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfnmsub132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9e,0x54,0x02,0x40]     
vfnmsub132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9e,0x54,0x02,0x40]    
vfnmsub132ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9e,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmsub132ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vfnmsub132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9e,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmsub132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9e,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmsub132ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9e,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmsub132ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfnmsub132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9e,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmsub132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9e,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmsub132ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9e,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmsub132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfnmsub132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmsub132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfnmsub132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9e,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmsub132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmsub132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9e,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmsub132ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmsub132ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9e,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmsub132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmsub132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmsub132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmsub132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9e,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmsub132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmsub132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9e,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmsub132ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmsub132ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9e,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmsub132ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfnmsub132ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9e,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmsub132ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9e,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmsub132ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9e,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmsub132ps 485498096, %zmm2, %zmm2 

// CHECK: vfnmsub132ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9e,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmsub132ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9e,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmsub132ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9e,0x12]      
vfnmsub132ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfnmsub132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9e,0x12]     
vfnmsub132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9e,0x12]    
vfnmsub132ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9e,0x12]      
vfnmsub132ps (%edx), %zmm2, %zmm2 

// CHECK: vfnmsub132ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9e,0x12]     
vfnmsub132ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9e,0x12]    
vfnmsub132ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132ps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x38,0x9e,0xd2]     
vfnmsub132ps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x3a,0x9e,0xd2]    
vfnmsub132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xba,0x9e,0xd2]   
vfnmsub132ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132ps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x18,0x9e,0xd2]     
vfnmsub132ps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x1a,0x9e,0xd2]    
vfnmsub132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x9a,0x9e,0xd2]   
vfnmsub132ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132ps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x9e,0xd2]     
vfnmsub132ps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x9e,0xd2]    
vfnmsub132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x9e,0xd2]   
vfnmsub132ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132ps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x78,0x9e,0xd2]     
vfnmsub132ps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x7a,0x9e,0xd2]    
vfnmsub132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xfa,0x9e,0xd2]   
vfnmsub132ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub132ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x9e,0xd2]      
vfnmsub132ps %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub132ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x9e,0xd2]     
vfnmsub132ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub132ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x9e,0xd2]    
vfnmsub132ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xae,0x54,0x02,0x40]      
vfnmsub213pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfnmsub213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xae,0x54,0x02,0x40]     
vfnmsub213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xae,0x54,0x02,0x40]    
vfnmsub213pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xae,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmsub213pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vfnmsub213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xae,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmsub213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xae,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmsub213pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xae,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmsub213pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfnmsub213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xae,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmsub213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xae,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmsub213pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xae,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmsub213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfnmsub213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xae,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmsub213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfnmsub213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xae,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmsub213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xae,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmsub213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xae,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmsub213pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xae,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmsub213pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xae,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmsub213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmsub213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xae,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmsub213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmsub213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xae,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmsub213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xae,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmsub213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xae,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmsub213pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xae,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmsub213pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xae,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmsub213pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfnmsub213pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xae,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmsub213pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xae,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmsub213pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xae,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmsub213pd 485498096, %zmm2, %zmm2 

// CHECK: vfnmsub213pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xae,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmsub213pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xae,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmsub213pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xae,0x54,0x02,0x40]      
vfnmsub213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vfnmsub213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xae,0x54,0x02,0x40]     
vfnmsub213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xae,0x54,0x02,0x40]    
vfnmsub213pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xae,0x12]      
vfnmsub213pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfnmsub213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xae,0x12]     
vfnmsub213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xae,0x12]    
vfnmsub213pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xae,0x12]      
vfnmsub213pd (%edx), %zmm2, %zmm2 

// CHECK: vfnmsub213pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xae,0x12]     
vfnmsub213pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xae,0x12]    
vfnmsub213pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213pd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x38,0xae,0xd2]     
vfnmsub213pd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x3a,0xae,0xd2]    
vfnmsub213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xba,0xae,0xd2]   
vfnmsub213pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213pd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x18,0xae,0xd2]     
vfnmsub213pd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x1a,0xae,0xd2]    
vfnmsub213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0x9a,0xae,0xd2]   
vfnmsub213pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213pd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xae,0xd2]     
vfnmsub213pd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xae,0xd2]    
vfnmsub213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xae,0xd2]   
vfnmsub213pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213pd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x78,0xae,0xd2]     
vfnmsub213pd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x7a,0xae,0xd2]    
vfnmsub213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xfa,0xae,0xd2]   
vfnmsub213pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xae,0xd2]      
vfnmsub213pd %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub213pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xae,0xd2]     
vfnmsub213pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xae,0xd2]    
vfnmsub213pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xae,0x54,0x02,0x40]      
vfnmsub213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vfnmsub213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xae,0x54,0x02,0x40]     
vfnmsub213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xae,0x54,0x02,0x40]    
vfnmsub213ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xae,0x54,0x02,0x40]      
vfnmsub213ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfnmsub213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xae,0x54,0x02,0x40]     
vfnmsub213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xae,0x54,0x02,0x40]    
vfnmsub213ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xae,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmsub213ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vfnmsub213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xae,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmsub213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xae,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmsub213ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xae,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmsub213ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfnmsub213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xae,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmsub213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xae,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmsub213ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xae,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmsub213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfnmsub213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xae,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmsub213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfnmsub213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xae,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmsub213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xae,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmsub213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xae,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmsub213ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xae,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmsub213ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xae,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmsub213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmsub213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xae,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmsub213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmsub213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xae,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmsub213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xae,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmsub213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xae,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmsub213ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xae,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmsub213ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xae,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmsub213ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfnmsub213ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xae,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmsub213ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xae,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmsub213ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xae,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmsub213ps 485498096, %zmm2, %zmm2 

// CHECK: vfnmsub213ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xae,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmsub213ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xae,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmsub213ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xae,0x12]      
vfnmsub213ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfnmsub213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xae,0x12]     
vfnmsub213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xae,0x12]    
vfnmsub213ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xae,0x12]      
vfnmsub213ps (%edx), %zmm2, %zmm2 

// CHECK: vfnmsub213ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xae,0x12]     
vfnmsub213ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xae,0x12]    
vfnmsub213ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213ps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x38,0xae,0xd2]     
vfnmsub213ps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x3a,0xae,0xd2]    
vfnmsub213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xba,0xae,0xd2]   
vfnmsub213ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213ps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x18,0xae,0xd2]     
vfnmsub213ps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x1a,0xae,0xd2]    
vfnmsub213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x9a,0xae,0xd2]   
vfnmsub213ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213ps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xae,0xd2]     
vfnmsub213ps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xae,0xd2]    
vfnmsub213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xae,0xd2]   
vfnmsub213ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213ps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x78,0xae,0xd2]     
vfnmsub213ps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x7a,0xae,0xd2]    
vfnmsub213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xfa,0xae,0xd2]   
vfnmsub213ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub213ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xae,0xd2]      
vfnmsub213ps %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub213ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xae,0xd2]     
vfnmsub213ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub213ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xae,0xd2]    
vfnmsub213ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xbe,0x54,0x02,0x40]      
vfnmsub231pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfnmsub231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xbe,0x54,0x02,0x40]     
vfnmsub231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xbe,0x54,0x02,0x40]    
vfnmsub231pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xbe,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmsub231pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vfnmsub231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xbe,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmsub231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xbe,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmsub231pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xbe,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmsub231pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfnmsub231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xbe,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmsub231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xbe,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmsub231pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xbe,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmsub231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfnmsub231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xbe,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmsub231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vfnmsub231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xbe,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmsub231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xbe,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmsub231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xbe,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmsub231pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xbe,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmsub231pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xbe,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmsub231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmsub231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xbe,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmsub231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmsub231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xbe,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmsub231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xbe,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmsub231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xbe,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmsub231pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xbe,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmsub231pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xbe,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmsub231pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfnmsub231pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xbe,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmsub231pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xbe,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmsub231pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xbe,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmsub231pd 485498096, %zmm2, %zmm2 

// CHECK: vfnmsub231pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xbe,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmsub231pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xbe,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmsub231pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xbe,0x54,0x02,0x40]      
vfnmsub231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vfnmsub231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xbe,0x54,0x02,0x40]     
vfnmsub231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xbe,0x54,0x02,0x40]    
vfnmsub231pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xbe,0x12]      
vfnmsub231pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vfnmsub231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xbe,0x12]     
vfnmsub231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xbe,0x12]    
vfnmsub231pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xbe,0x12]      
vfnmsub231pd (%edx), %zmm2, %zmm2 

// CHECK: vfnmsub231pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xbe,0x12]     
vfnmsub231pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xbe,0x12]    
vfnmsub231pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231pd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x38,0xbe,0xd2]     
vfnmsub231pd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x3a,0xbe,0xd2]    
vfnmsub231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xba,0xbe,0xd2]   
vfnmsub231pd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231pd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x18,0xbe,0xd2]     
vfnmsub231pd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x1a,0xbe,0xd2]    
vfnmsub231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0x9a,0xbe,0xd2]   
vfnmsub231pd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231pd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0xbe,0xd2]     
vfnmsub231pd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0xbe,0xd2]    
vfnmsub231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0xbe,0xd2]   
vfnmsub231pd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231pd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x78,0xbe,0xd2]     
vfnmsub231pd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x7a,0xbe,0xd2]    
vfnmsub231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xfa,0xbe,0xd2]   
vfnmsub231pd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0xbe,0xd2]      
vfnmsub231pd %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub231pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0xbe,0xd2]     
vfnmsub231pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0xbe,0xd2]    
vfnmsub231pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xbe,0x54,0x02,0x40]      
vfnmsub231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vfnmsub231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xbe,0x54,0x02,0x40]     
vfnmsub231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xbe,0x54,0x02,0x40]    
vfnmsub231ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xbe,0x54,0x02,0x40]      
vfnmsub231ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vfnmsub231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xbe,0x54,0x02,0x40]     
vfnmsub231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xbe,0x54,0x02,0x40]    
vfnmsub231ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xbe,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmsub231ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vfnmsub231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xbe,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmsub231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xbe,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmsub231ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xbe,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmsub231ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfnmsub231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xbe,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmsub231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xbe,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmsub231ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xbe,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmsub231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfnmsub231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xbe,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmsub231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vfnmsub231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xbe,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmsub231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xbe,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmsub231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xbe,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmsub231ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xbe,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmsub231ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xbe,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vfnmsub231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmsub231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xbe,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vfnmsub231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vfnmsub231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xbe,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vfnmsub231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xbe,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vfnmsub231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xbe,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vfnmsub231ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xbe,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vfnmsub231ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xbe,0x92,0xf0,0x1c,0xf0,0x1c]      
vfnmsub231ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vfnmsub231ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xbe,0x92,0xf0,0x1c,0xf0,0x1c]     
vfnmsub231ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xbe,0x92,0xf0,0x1c,0xf0,0x1c]    
vfnmsub231ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xbe,0x15,0xf0,0x1c,0xf0,0x1c]      
vfnmsub231ps 485498096, %zmm2, %zmm2 

// CHECK: vfnmsub231ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xbe,0x15,0xf0,0x1c,0xf0,0x1c]     
vfnmsub231ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xbe,0x15,0xf0,0x1c,0xf0,0x1c]    
vfnmsub231ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xbe,0x12]      
vfnmsub231ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vfnmsub231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xbe,0x12]     
vfnmsub231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xbe,0x12]    
vfnmsub231ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xbe,0x12]      
vfnmsub231ps (%edx), %zmm2, %zmm2 

// CHECK: vfnmsub231ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xbe,0x12]     
vfnmsub231ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xbe,0x12]    
vfnmsub231ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231ps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x38,0xbe,0xd2]     
vfnmsub231ps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x3a,0xbe,0xd2]    
vfnmsub231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xba,0xbe,0xd2]   
vfnmsub231ps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231ps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x18,0xbe,0xd2]     
vfnmsub231ps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x1a,0xbe,0xd2]    
vfnmsub231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x9a,0xbe,0xd2]   
vfnmsub231ps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231ps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0xbe,0xd2]     
vfnmsub231ps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0xbe,0xd2]    
vfnmsub231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0xbe,0xd2]   
vfnmsub231ps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231ps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x78,0xbe,0xd2]     
vfnmsub231ps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x7a,0xbe,0xd2]    
vfnmsub231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xfa,0xbe,0xd2]   
vfnmsub231ps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vfnmsub231ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0xbe,0xd2]      
vfnmsub231ps %zmm2, %zmm2, %zmm2 

// CHECK: vfnmsub231ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0xbe,0xd2]     
vfnmsub231ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vfnmsub231ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0xbe,0xd2]    
vfnmsub231ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vgatherdpd -485498096(%edx,%ymm3,4), %zmm2 {%k3} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4b,0x92,0x94,0x9a,0x10,0xe3,0x0f,0xe3]      
vgatherdpd -485498096(%edx,%ymm3,4), %zmm2 {%k3} 

// CHECK: vgatherdpd 485498096(%edx,%ymm3,4), %zmm2 {%k3} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4b,0x92,0x94,0x9a,0xf0,0x1c,0xf0,0x1c]      
vgatherdpd 485498096(%edx,%ymm3,4), %zmm2 {%k3} 

// CHECK: vgatherdpd 512(%edx,%ymm3), %zmm2 {%k3} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4b,0x92,0x54,0x1a,0x40]      
vgatherdpd 512(%edx,%ymm3), %zmm2 {%k3} 

// CHECK: vgatherdps 256(%edx,%zmm3), %zmm2 {%k3} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4b,0x92,0x54,0x1a,0x40]      
vgatherdps 256(%edx,%zmm3), %zmm2 {%k3} 

// CHECK: vgatherdps -485498096(%edx,%zmm3,4), %zmm2 {%k3} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4b,0x92,0x94,0x9a,0x10,0xe3,0x0f,0xe3]      
vgatherdps -485498096(%edx,%zmm3,4), %zmm2 {%k3} 

// CHECK: vgatherdps 485498096(%edx,%zmm3,4), %zmm2 {%k3} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4b,0x92,0x94,0x9a,0xf0,0x1c,0xf0,0x1c]      
vgatherdps 485498096(%edx,%zmm3,4), %zmm2 {%k3} 

// CHECK: vgatherqpd -485498096(%edx,%zmm3,4), %zmm2 {%k3} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4b,0x93,0x94,0x9a,0x10,0xe3,0x0f,0xe3]      
vgatherqpd -485498096(%edx,%zmm3,4), %zmm2 {%k3} 

// CHECK: vgatherqpd 485498096(%edx,%zmm3,4), %zmm2 {%k3} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4b,0x93,0x94,0x9a,0xf0,0x1c,0xf0,0x1c]      
vgatherqpd 485498096(%edx,%zmm3,4), %zmm2 {%k3} 

// CHECK: vgatherqpd 512(%edx,%zmm3), %zmm2 {%k3} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4b,0x93,0x54,0x1a,0x40]      
vgatherqpd 512(%edx,%zmm3), %zmm2 {%k3} 

// CHECK: vgatherqps 256(%edx,%zmm3), %ymm4 {%k3} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4b,0x93,0x64,0x1a,0x40]      
vgatherqps 256(%edx,%zmm3), %ymm4 {%k3} 

// CHECK: vgatherqps -485498096(%edx,%zmm3,4), %ymm4 {%k3} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4b,0x93,0xa4,0x9a,0x10,0xe3,0x0f,0xe3]      
vgatherqps -485498096(%edx,%zmm3,4), %ymm4 {%k3} 

// CHECK: vgatherqps 485498096(%edx,%zmm3,4), %ymm4 {%k3} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4b,0x93,0xa4,0x9a,0xf0,0x1c,0xf0,0x1c]      
vgatherqps 485498096(%edx,%zmm3,4), %ymm4 {%k3} 

// CHECK: vgetexppd 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x42,0x54,0x02,0x40]       
vgetexppd 4096(%edx,%eax), %zmm2 

// CHECK: vgetexppd 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x42,0x54,0x02,0x40]      
vgetexppd 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vgetexppd 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x42,0x54,0x02,0x40]     
vgetexppd 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vgetexppd 485498096{1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x58,0x42,0x15,0xf0,0x1c,0xf0,0x1c]       
vgetexppd 485498096{1to8}, %zmm2 

// CHECK: vgetexppd 485498096{1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x5a,0x42,0x15,0xf0,0x1c,0xf0,0x1c]      
vgetexppd 485498096{1to8}, %zmm2 {%k2} 

// CHECK: vgetexppd 485498096{1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xda,0x42,0x15,0xf0,0x1c,0xf0,0x1c]     
vgetexppd 485498096{1to8}, %zmm2 {%k2} {z} 

// CHECK: vgetexppd 485498096(%edx){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x58,0x42,0x92,0xf0,0x1c,0xf0,0x1c]       
vgetexppd 485498096(%edx){1to8}, %zmm2 

// CHECK: vgetexppd 485498096(%edx){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x5a,0x42,0x92,0xf0,0x1c,0xf0,0x1c]      
vgetexppd 485498096(%edx){1to8}, %zmm2 {%k2} 

// CHECK: vgetexppd 485498096(%edx){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xda,0x42,0x92,0xf0,0x1c,0xf0,0x1c]     
vgetexppd 485498096(%edx){1to8}, %zmm2 {%k2} {z} 

// CHECK: vgetexppd -485498096(%edx,%eax,4){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x58,0x42,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vgetexppd -485498096(%edx,%eax,4){1to8}, %zmm2 

// CHECK: vgetexppd 485498096(%edx,%eax,4){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x58,0x42,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vgetexppd 485498096(%edx,%eax,4){1to8}, %zmm2 

// CHECK: vgetexppd -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x5a,0x42,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vgetexppd -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 

// CHECK: vgetexppd 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x5a,0x42,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vgetexppd 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 

// CHECK: vgetexppd -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xda,0x42,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vgetexppd -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 

// CHECK: vgetexppd 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xda,0x42,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vgetexppd 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 

// CHECK: vgetexppd -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x42,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vgetexppd -485498096(%edx,%eax,4), %zmm2 

// CHECK: vgetexppd 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x42,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vgetexppd 485498096(%edx,%eax,4), %zmm2 

// CHECK: vgetexppd -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x42,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vgetexppd -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vgetexppd 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x42,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vgetexppd 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vgetexppd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x42,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vgetexppd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vgetexppd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x42,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vgetexppd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vgetexppd 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x42,0x92,0xf0,0x1c,0xf0,0x1c]       
vgetexppd 485498096(%edx), %zmm2 

// CHECK: vgetexppd 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x42,0x92,0xf0,0x1c,0xf0,0x1c]      
vgetexppd 485498096(%edx), %zmm2 {%k2} 

// CHECK: vgetexppd 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x42,0x92,0xf0,0x1c,0xf0,0x1c]     
vgetexppd 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vgetexppd 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x42,0x15,0xf0,0x1c,0xf0,0x1c]       
vgetexppd 485498096, %zmm2 

// CHECK: vgetexppd 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x42,0x15,0xf0,0x1c,0xf0,0x1c]      
vgetexppd 485498096, %zmm2 {%k2} 

// CHECK: vgetexppd 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x42,0x15,0xf0,0x1c,0xf0,0x1c]     
vgetexppd 485498096, %zmm2 {%k2} {z} 

// CHECK: vgetexppd 512(%edx,%eax){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x58,0x42,0x54,0x02,0x40]       
vgetexppd 512(%edx,%eax){1to8}, %zmm2 

// CHECK: vgetexppd 512(%edx,%eax){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x5a,0x42,0x54,0x02,0x40]      
vgetexppd 512(%edx,%eax){1to8}, %zmm2 {%k2} 

// CHECK: vgetexppd 512(%edx,%eax){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xda,0x42,0x54,0x02,0x40]     
vgetexppd 512(%edx,%eax){1to8}, %zmm2 {%k2} {z} 

// CHECK: vgetexppd (%edx){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x58,0x42,0x12]       
vgetexppd (%edx){1to8}, %zmm2 

// CHECK: vgetexppd (%edx){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x5a,0x42,0x12]      
vgetexppd (%edx){1to8}, %zmm2 {%k2} 

// CHECK: vgetexppd (%edx){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xda,0x42,0x12]     
vgetexppd (%edx){1to8}, %zmm2 {%k2} {z} 

// CHECK: vgetexppd (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x42,0x12]       
vgetexppd (%edx), %zmm2 

// CHECK: vgetexppd (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x42,0x12]      
vgetexppd (%edx), %zmm2 {%k2} 

// CHECK: vgetexppd (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x42,0x12]     
vgetexppd (%edx), %zmm2 {%k2} {z} 

// CHECK: vgetexppd {sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x18,0x42,0xd2]      
vgetexppd {sae}, %zmm2, %zmm2 

// CHECK: vgetexppd {sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x1a,0x42,0xd2]     
vgetexppd {sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vgetexppd {sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x9a,0x42,0xd2]    
vgetexppd {sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vgetexppd %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x42,0xd2]       
vgetexppd %zmm2, %zmm2 

// CHECK: vgetexppd %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x42,0xd2]      
vgetexppd %zmm2, %zmm2 {%k2} 

// CHECK: vgetexppd %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x42,0xd2]     
vgetexppd %zmm2, %zmm2 {%k2} {z} 

// CHECK: vgetexpps 256(%edx,%eax){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x58,0x42,0x54,0x02,0x40]       
vgetexpps 256(%edx,%eax){1to16}, %zmm2 

// CHECK: vgetexpps 256(%edx,%eax){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x5a,0x42,0x54,0x02,0x40]      
vgetexpps 256(%edx,%eax){1to16}, %zmm2 {%k2} 

// CHECK: vgetexpps 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xda,0x42,0x54,0x02,0x40]     
vgetexpps 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 

// CHECK: vgetexpps 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x42,0x54,0x02,0x40]       
vgetexpps 4096(%edx,%eax), %zmm2 

// CHECK: vgetexpps 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x42,0x54,0x02,0x40]      
vgetexpps 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vgetexpps 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x42,0x54,0x02,0x40]     
vgetexpps 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vgetexpps 485498096{1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x58,0x42,0x15,0xf0,0x1c,0xf0,0x1c]       
vgetexpps 485498096{1to16}, %zmm2 

// CHECK: vgetexpps 485498096{1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x5a,0x42,0x15,0xf0,0x1c,0xf0,0x1c]      
vgetexpps 485498096{1to16}, %zmm2 {%k2} 

// CHECK: vgetexpps 485498096{1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xda,0x42,0x15,0xf0,0x1c,0xf0,0x1c]     
vgetexpps 485498096{1to16}, %zmm2 {%k2} {z} 

// CHECK: vgetexpps 485498096(%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x58,0x42,0x92,0xf0,0x1c,0xf0,0x1c]       
vgetexpps 485498096(%edx){1to16}, %zmm2 

// CHECK: vgetexpps 485498096(%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x5a,0x42,0x92,0xf0,0x1c,0xf0,0x1c]      
vgetexpps 485498096(%edx){1to16}, %zmm2 {%k2} 

// CHECK: vgetexpps 485498096(%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xda,0x42,0x92,0xf0,0x1c,0xf0,0x1c]     
vgetexpps 485498096(%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vgetexpps -485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x58,0x42,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vgetexpps -485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vgetexpps 485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x58,0x42,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vgetexpps 485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vgetexpps -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x5a,0x42,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vgetexpps -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vgetexpps 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x5a,0x42,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vgetexpps 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vgetexpps -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xda,0x42,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vgetexpps -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vgetexpps 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xda,0x42,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vgetexpps 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vgetexpps -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x42,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vgetexpps -485498096(%edx,%eax,4), %zmm2 

// CHECK: vgetexpps 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x42,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vgetexpps 485498096(%edx,%eax,4), %zmm2 

// CHECK: vgetexpps -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x42,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vgetexpps -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vgetexpps 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x42,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vgetexpps 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vgetexpps -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x42,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vgetexpps -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vgetexpps 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x42,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vgetexpps 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vgetexpps 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x42,0x92,0xf0,0x1c,0xf0,0x1c]       
vgetexpps 485498096(%edx), %zmm2 

// CHECK: vgetexpps 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x42,0x92,0xf0,0x1c,0xf0,0x1c]      
vgetexpps 485498096(%edx), %zmm2 {%k2} 

// CHECK: vgetexpps 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x42,0x92,0xf0,0x1c,0xf0,0x1c]     
vgetexpps 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vgetexpps 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x42,0x15,0xf0,0x1c,0xf0,0x1c]       
vgetexpps 485498096, %zmm2 

// CHECK: vgetexpps 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x42,0x15,0xf0,0x1c,0xf0,0x1c]      
vgetexpps 485498096, %zmm2 {%k2} 

// CHECK: vgetexpps 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x42,0x15,0xf0,0x1c,0xf0,0x1c]     
vgetexpps 485498096, %zmm2 {%k2} {z} 

// CHECK: vgetexpps (%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x58,0x42,0x12]       
vgetexpps (%edx){1to16}, %zmm2 

// CHECK: vgetexpps (%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x5a,0x42,0x12]      
vgetexpps (%edx){1to16}, %zmm2 {%k2} 

// CHECK: vgetexpps (%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xda,0x42,0x12]     
vgetexpps (%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vgetexpps (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x42,0x12]       
vgetexpps (%edx), %zmm2 

// CHECK: vgetexpps (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x42,0x12]      
vgetexpps (%edx), %zmm2 {%k2} 

// CHECK: vgetexpps (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x42,0x12]     
vgetexpps (%edx), %zmm2 {%k2} {z} 

// CHECK: vgetexpps {sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x18,0x42,0xd2]      
vgetexpps {sae}, %zmm2, %zmm2 

// CHECK: vgetexpps {sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x1a,0x42,0xd2]     
vgetexpps {sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vgetexpps {sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x9a,0x42,0xd2]    
vgetexpps {sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vgetexpps %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x42,0xd2]       
vgetexpps %zmm2, %zmm2 

// CHECK: vgetexpps %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x42,0xd2]      
vgetexpps %zmm2, %zmm2 {%k2} 

// CHECK: vgetexpps %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x42,0xd2]     
vgetexpps %zmm2, %zmm2 {%k2} {z} 

// CHECK: vgetmantpd $0, 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x26,0x54,0x02,0x40,0x00]      
vgetmantpd $0, 4096(%edx,%eax), %zmm2 

// CHECK: vgetmantpd $0, 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x26,0x54,0x02,0x40,0x00]     
vgetmantpd $0, 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vgetmantpd $0, 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x26,0x54,0x02,0x40,0x00]    
vgetmantpd $0, 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vgetmantpd $0, 485498096{1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x26,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vgetmantpd $0, 485498096{1to8}, %zmm2 

// CHECK: vgetmantpd $0, 485498096{1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x26,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vgetmantpd $0, 485498096{1to8}, %zmm2 {%k2} 

// CHECK: vgetmantpd $0, 485498096{1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x26,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vgetmantpd $0, 485498096{1to8}, %zmm2 {%k2} {z} 

// CHECK: vgetmantpd $0, 485498096(%edx){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x26,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vgetmantpd $0, 485498096(%edx){1to8}, %zmm2 

// CHECK: vgetmantpd $0, 485498096(%edx){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x26,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vgetmantpd $0, 485498096(%edx){1to8}, %zmm2 {%k2} 

// CHECK: vgetmantpd $0, 485498096(%edx){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x26,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vgetmantpd $0, 485498096(%edx){1to8}, %zmm2 {%k2} {z} 

// CHECK: vgetmantpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x26,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vgetmantpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2 

// CHECK: vgetmantpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x26,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vgetmantpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2 

// CHECK: vgetmantpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x26,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vgetmantpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 

// CHECK: vgetmantpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x26,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vgetmantpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 

// CHECK: vgetmantpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x26,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vgetmantpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 

// CHECK: vgetmantpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x26,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vgetmantpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 

// CHECK: vgetmantpd $0, -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x26,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vgetmantpd $0, -485498096(%edx,%eax,4), %zmm2 

// CHECK: vgetmantpd $0, 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x26,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vgetmantpd $0, 485498096(%edx,%eax,4), %zmm2 

// CHECK: vgetmantpd $0, -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x26,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vgetmantpd $0, -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vgetmantpd $0, 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x26,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vgetmantpd $0, 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vgetmantpd $0, -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x26,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vgetmantpd $0, -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vgetmantpd $0, 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x26,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vgetmantpd $0, 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vgetmantpd $0, 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x26,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vgetmantpd $0, 485498096(%edx), %zmm2 

// CHECK: vgetmantpd $0, 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x26,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vgetmantpd $0, 485498096(%edx), %zmm2 {%k2} 

// CHECK: vgetmantpd $0, 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x26,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vgetmantpd $0, 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vgetmantpd $0, 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x26,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vgetmantpd $0, 485498096, %zmm2 

// CHECK: vgetmantpd $0, 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x26,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vgetmantpd $0, 485498096, %zmm2 {%k2} 

// CHECK: vgetmantpd $0, 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x26,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vgetmantpd $0, 485498096, %zmm2 {%k2} {z} 

// CHECK: vgetmantpd $0, 512(%edx,%eax){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x26,0x54,0x02,0x40,0x00]      
vgetmantpd $0, 512(%edx,%eax){1to8}, %zmm2 

// CHECK: vgetmantpd $0, 512(%edx,%eax){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x26,0x54,0x02,0x40,0x00]     
vgetmantpd $0, 512(%edx,%eax){1to8}, %zmm2 {%k2} 

// CHECK: vgetmantpd $0, 512(%edx,%eax){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x26,0x54,0x02,0x40,0x00]    
vgetmantpd $0, 512(%edx,%eax){1to8}, %zmm2 {%k2} {z} 

// CHECK: vgetmantpd $0, (%edx){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x26,0x12,0x00]      
vgetmantpd $0, (%edx){1to8}, %zmm2 

// CHECK: vgetmantpd $0, (%edx){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x26,0x12,0x00]     
vgetmantpd $0, (%edx){1to8}, %zmm2 {%k2} 

// CHECK: vgetmantpd $0, (%edx){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x26,0x12,0x00]    
vgetmantpd $0, (%edx){1to8}, %zmm2 {%k2} {z} 

// CHECK: vgetmantpd $0, (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x26,0x12,0x00]      
vgetmantpd $0, (%edx), %zmm2 

// CHECK: vgetmantpd $0, (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x26,0x12,0x00]     
vgetmantpd $0, (%edx), %zmm2 {%k2} 

// CHECK: vgetmantpd $0, (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x26,0x12,0x00]    
vgetmantpd $0, (%edx), %zmm2 {%k2} {z} 

// CHECK: vgetmantpd $0, {sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x18,0x26,0xd2,0x00]     
vgetmantpd $0, {sae}, %zmm2, %zmm2 

// CHECK: vgetmantpd $0, {sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x1a,0x26,0xd2,0x00]    
vgetmantpd $0, {sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vgetmantpd $0, {sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x9a,0x26,0xd2,0x00]   
vgetmantpd $0, {sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vgetmantpd $0, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x26,0xd2,0x00]      
vgetmantpd $0, %zmm2, %zmm2 

// CHECK: vgetmantpd $0, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x26,0xd2,0x00]     
vgetmantpd $0, %zmm2, %zmm2 {%k2} 

// CHECK: vgetmantpd $0, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x26,0xd2,0x00]    
vgetmantpd $0, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vgetmantps $0, 256(%edx,%eax){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x58,0x26,0x54,0x02,0x40,0x00]      
vgetmantps $0, 256(%edx,%eax){1to16}, %zmm2 

// CHECK: vgetmantps $0, 256(%edx,%eax){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x5a,0x26,0x54,0x02,0x40,0x00]     
vgetmantps $0, 256(%edx,%eax){1to16}, %zmm2 {%k2} 

// CHECK: vgetmantps $0, 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xda,0x26,0x54,0x02,0x40,0x00]    
vgetmantps $0, 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 

// CHECK: vgetmantps $0, 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x26,0x54,0x02,0x40,0x00]      
vgetmantps $0, 4096(%edx,%eax), %zmm2 

// CHECK: vgetmantps $0, 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x26,0x54,0x02,0x40,0x00]     
vgetmantps $0, 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vgetmantps $0, 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xca,0x26,0x54,0x02,0x40,0x00]    
vgetmantps $0, 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vgetmantps $0, 485498096{1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x58,0x26,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vgetmantps $0, 485498096{1to16}, %zmm2 

// CHECK: vgetmantps $0, 485498096{1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x5a,0x26,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vgetmantps $0, 485498096{1to16}, %zmm2 {%k2} 

// CHECK: vgetmantps $0, 485498096{1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xda,0x26,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vgetmantps $0, 485498096{1to16}, %zmm2 {%k2} {z} 

// CHECK: vgetmantps $0, 485498096(%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x58,0x26,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vgetmantps $0, 485498096(%edx){1to16}, %zmm2 

// CHECK: vgetmantps $0, 485498096(%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x5a,0x26,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vgetmantps $0, 485498096(%edx){1to16}, %zmm2 {%k2} 

// CHECK: vgetmantps $0, 485498096(%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xda,0x26,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vgetmantps $0, 485498096(%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vgetmantps $0, -485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x58,0x26,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vgetmantps $0, -485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vgetmantps $0, 485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x58,0x26,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vgetmantps $0, 485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vgetmantps $0, -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x5a,0x26,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vgetmantps $0, -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vgetmantps $0, 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x5a,0x26,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vgetmantps $0, 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vgetmantps $0, -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xda,0x26,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vgetmantps $0, -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vgetmantps $0, 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xda,0x26,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vgetmantps $0, 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vgetmantps $0, -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x26,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vgetmantps $0, -485498096(%edx,%eax,4), %zmm2 

// CHECK: vgetmantps $0, 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x26,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vgetmantps $0, 485498096(%edx,%eax,4), %zmm2 

// CHECK: vgetmantps $0, -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x26,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vgetmantps $0, -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vgetmantps $0, 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x26,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vgetmantps $0, 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vgetmantps $0, -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xca,0x26,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vgetmantps $0, -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vgetmantps $0, 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xca,0x26,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vgetmantps $0, 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vgetmantps $0, 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x26,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vgetmantps $0, 485498096(%edx), %zmm2 

// CHECK: vgetmantps $0, 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x26,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vgetmantps $0, 485498096(%edx), %zmm2 {%k2} 

// CHECK: vgetmantps $0, 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xca,0x26,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vgetmantps $0, 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vgetmantps $0, 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x26,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vgetmantps $0, 485498096, %zmm2 

// CHECK: vgetmantps $0, 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x26,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vgetmantps $0, 485498096, %zmm2 {%k2} 

// CHECK: vgetmantps $0, 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xca,0x26,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vgetmantps $0, 485498096, %zmm2 {%k2} {z} 

// CHECK: vgetmantps $0, (%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x58,0x26,0x12,0x00]      
vgetmantps $0, (%edx){1to16}, %zmm2 

// CHECK: vgetmantps $0, (%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x5a,0x26,0x12,0x00]     
vgetmantps $0, (%edx){1to16}, %zmm2 {%k2} 

// CHECK: vgetmantps $0, (%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xda,0x26,0x12,0x00]    
vgetmantps $0, (%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vgetmantps $0, (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x26,0x12,0x00]      
vgetmantps $0, (%edx), %zmm2 

// CHECK: vgetmantps $0, (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x26,0x12,0x00]     
vgetmantps $0, (%edx), %zmm2 {%k2} 

// CHECK: vgetmantps $0, (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xca,0x26,0x12,0x00]    
vgetmantps $0, (%edx), %zmm2 {%k2} {z} 

// CHECK: vgetmantps $0, {sae}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x18,0x26,0xd2,0x00]     
vgetmantps $0, {sae}, %zmm2, %zmm2 

// CHECK: vgetmantps $0, {sae}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x1a,0x26,0xd2,0x00]    
vgetmantps $0, {sae}, %zmm2, %zmm2 {%k2} 

// CHECK: vgetmantps $0, {sae}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x9a,0x26,0xd2,0x00]   
vgetmantps $0, {sae}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vgetmantps $0, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x26,0xd2,0x00]      
vgetmantps $0, %zmm2, %zmm2 

// CHECK: vgetmantps $0, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x26,0xd2,0x00]     
vgetmantps $0, %zmm2, %zmm2 {%k2} 

// CHECK: vgetmantps $0, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xca,0x26,0xd2,0x00]    
vgetmantps $0, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinsertf32x4 $0, 1024(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x18,0x54,0x02,0x40,0x00]     
vinsertf32x4 $0, 1024(%edx,%eax), %zmm2, %zmm2 

// CHECK: vinsertf32x4 $0, 1024(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x18,0x54,0x02,0x40,0x00]    
vinsertf32x4 $0, 1024(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vinsertf32x4 $0, 1024(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x18,0x54,0x02,0x40,0x00]   
vinsertf32x4 $0, 1024(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinsertf32x4 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x18,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vinsertf32x4 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vinsertf32x4 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x18,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vinsertf32x4 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vinsertf32x4 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x18,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vinsertf32x4 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vinsertf32x4 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x18,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vinsertf32x4 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vinsertf32x4 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x18,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]   
vinsertf32x4 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinsertf32x4 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x18,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]   
vinsertf32x4 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinsertf32x4 $0, 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x18,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vinsertf32x4 $0, 485498096(%edx), %zmm2, %zmm2 

// CHECK: vinsertf32x4 $0, 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x18,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vinsertf32x4 $0, 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vinsertf32x4 $0, 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x18,0x92,0xf0,0x1c,0xf0,0x1c,0x00]   
vinsertf32x4 $0, 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinsertf32x4 $0, 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x18,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vinsertf32x4 $0, 485498096, %zmm2, %zmm2 

// CHECK: vinsertf32x4 $0, 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x18,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vinsertf32x4 $0, 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vinsertf32x4 $0, 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x18,0x15,0xf0,0x1c,0xf0,0x1c,0x00]   
vinsertf32x4 $0, 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinsertf32x4 $0, (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x18,0x12,0x00]     
vinsertf32x4 $0, (%edx), %zmm2, %zmm2 

// CHECK: vinsertf32x4 $0, (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x18,0x12,0x00]    
vinsertf32x4 $0, (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vinsertf32x4 $0, (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x18,0x12,0x00]   
vinsertf32x4 $0, (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinsertf32x4 $0, %xmm1, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x18,0xd1,0x00]     
vinsertf32x4 $0, %xmm1, %zmm2, %zmm2 

// CHECK: vinsertf32x4 $0, %xmm1, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x18,0xd1,0x00]    
vinsertf32x4 $0, %xmm1, %zmm2, %zmm2 {%k2} 

// CHECK: vinsertf32x4 $0, %xmm1, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x18,0xd1,0x00]   
vinsertf32x4 $0, %xmm1, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinsertf32x8 $0, 2048(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x1a,0x54,0x02,0x40,0x00]     
vinsertf32x8 $0, 2048(%edx,%eax), %zmm2, %zmm2 

// CHECK: vinsertf32x8 $0, 2048(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x1a,0x54,0x02,0x40,0x00]    
vinsertf32x8 $0, 2048(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vinsertf32x8 $0, 2048(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x1a,0x54,0x02,0x40,0x00]   
vinsertf32x8 $0, 2048(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinsertf32x8 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x1a,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vinsertf32x8 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vinsertf32x8 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x1a,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vinsertf32x8 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vinsertf32x8 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x1a,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vinsertf32x8 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vinsertf32x8 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x1a,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vinsertf32x8 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vinsertf32x8 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x1a,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]   
vinsertf32x8 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinsertf32x8 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x1a,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]   
vinsertf32x8 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinsertf32x8 $0, 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x1a,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vinsertf32x8 $0, 485498096(%edx), %zmm2, %zmm2 

// CHECK: vinsertf32x8 $0, 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x1a,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vinsertf32x8 $0, 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vinsertf32x8 $0, 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x1a,0x92,0xf0,0x1c,0xf0,0x1c,0x00]   
vinsertf32x8 $0, 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinsertf32x8 $0, 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x1a,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vinsertf32x8 $0, 485498096, %zmm2, %zmm2 

// CHECK: vinsertf32x8 $0, 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x1a,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vinsertf32x8 $0, 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vinsertf32x8 $0, 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x1a,0x15,0xf0,0x1c,0xf0,0x1c,0x00]   
vinsertf32x8 $0, 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinsertf32x8 $0, (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x1a,0x12,0x00]     
vinsertf32x8 $0, (%edx), %zmm2, %zmm2 

// CHECK: vinsertf32x8 $0, (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x1a,0x12,0x00]    
vinsertf32x8 $0, (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vinsertf32x8 $0, (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x1a,0x12,0x00]   
vinsertf32x8 $0, (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinsertf32x8 $0, %ymm4, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x1a,0xd4,0x00]     
vinsertf32x8 $0, %ymm4, %zmm2, %zmm2 

// CHECK: vinsertf32x8 $0, %ymm4, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x1a,0xd4,0x00]    
vinsertf32x8 $0, %ymm4, %zmm2, %zmm2 {%k2} 

// CHECK: vinsertf32x8 $0, %ymm4, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x1a,0xd4,0x00]   
vinsertf32x8 $0, %ymm4, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinserti32x4 $0, 1024(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x38,0x54,0x02,0x40,0x00]     
vinserti32x4 $0, 1024(%edx,%eax), %zmm2, %zmm2 

// CHECK: vinserti32x4 $0, 1024(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x38,0x54,0x02,0x40,0x00]    
vinserti32x4 $0, 1024(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vinserti32x4 $0, 1024(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x38,0x54,0x02,0x40,0x00]   
vinserti32x4 $0, 1024(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinserti32x4 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x38,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vinserti32x4 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vinserti32x4 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x38,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vinserti32x4 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vinserti32x4 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x38,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vinserti32x4 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vinserti32x4 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x38,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vinserti32x4 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vinserti32x4 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x38,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]   
vinserti32x4 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinserti32x4 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x38,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]   
vinserti32x4 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinserti32x4 $0, 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x38,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vinserti32x4 $0, 485498096(%edx), %zmm2, %zmm2 

// CHECK: vinserti32x4 $0, 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x38,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vinserti32x4 $0, 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vinserti32x4 $0, 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x38,0x92,0xf0,0x1c,0xf0,0x1c,0x00]   
vinserti32x4 $0, 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinserti32x4 $0, 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x38,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vinserti32x4 $0, 485498096, %zmm2, %zmm2 

// CHECK: vinserti32x4 $0, 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x38,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vinserti32x4 $0, 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vinserti32x4 $0, 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x38,0x15,0xf0,0x1c,0xf0,0x1c,0x00]   
vinserti32x4 $0, 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinserti32x4 $0, (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x38,0x12,0x00]     
vinserti32x4 $0, (%edx), %zmm2, %zmm2 

// CHECK: vinserti32x4 $0, (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x38,0x12,0x00]    
vinserti32x4 $0, (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vinserti32x4 $0, (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x38,0x12,0x00]   
vinserti32x4 $0, (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinserti32x4 $0, %xmm1, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x38,0xd1,0x00]     
vinserti32x4 $0, %xmm1, %zmm2, %zmm2 

// CHECK: vinserti32x4 $0, %xmm1, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x38,0xd1,0x00]    
vinserti32x4 $0, %xmm1, %zmm2, %zmm2 {%k2} 

// CHECK: vinserti32x4 $0, %xmm1, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x38,0xd1,0x00]   
vinserti32x4 $0, %xmm1, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinserti32x8 $0, 2048(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x3a,0x54,0x02,0x40,0x00]     
vinserti32x8 $0, 2048(%edx,%eax), %zmm2, %zmm2 

// CHECK: vinserti32x8 $0, 2048(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x3a,0x54,0x02,0x40,0x00]    
vinserti32x8 $0, 2048(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vinserti32x8 $0, 2048(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x3a,0x54,0x02,0x40,0x00]   
vinserti32x8 $0, 2048(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinserti32x8 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x3a,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vinserti32x8 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vinserti32x8 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x3a,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vinserti32x8 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vinserti32x8 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x3a,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vinserti32x8 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vinserti32x8 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x3a,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vinserti32x8 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vinserti32x8 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x3a,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]   
vinserti32x8 $0, -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinserti32x8 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x3a,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]   
vinserti32x8 $0, 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinserti32x8 $0, 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x3a,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vinserti32x8 $0, 485498096(%edx), %zmm2, %zmm2 

// CHECK: vinserti32x8 $0, 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x3a,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vinserti32x8 $0, 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vinserti32x8 $0, 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x3a,0x92,0xf0,0x1c,0xf0,0x1c,0x00]   
vinserti32x8 $0, 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinserti32x8 $0, 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x3a,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vinserti32x8 $0, 485498096, %zmm2, %zmm2 

// CHECK: vinserti32x8 $0, 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x3a,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vinserti32x8 $0, 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vinserti32x8 $0, 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x3a,0x15,0xf0,0x1c,0xf0,0x1c,0x00]   
vinserti32x8 $0, 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinserti32x8 $0, (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x3a,0x12,0x00]     
vinserti32x8 $0, (%edx), %zmm2, %zmm2 

// CHECK: vinserti32x8 $0, (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x3a,0x12,0x00]    
vinserti32x8 $0, (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vinserti32x8 $0, (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x3a,0x12,0x00]   
vinserti32x8 $0, (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vinserti32x8 $0, %ymm4, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x3a,0xd4,0x00]     
vinserti32x8 $0, %ymm4, %zmm2, %zmm2 

// CHECK: vinserti32x8 $0, %ymm4, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x3a,0xd4,0x00]    
vinserti32x8 $0, %ymm4, %zmm2, %zmm2 {%k2} 

// CHECK: vinserti32x8 $0, %ymm4, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x6d,0xca,0x3a,0xd4,0x00]   
vinserti32x8 $0, %ymm4, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxpd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5f,0x54,0x02,0x40]      
vmaxpd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vmaxpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5f,0x54,0x02,0x40]     
vmaxpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vmaxpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5f,0x54,0x02,0x40]    
vmaxpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxpd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x5f,0x15,0xf0,0x1c,0xf0,0x1c]      
vmaxpd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vmaxpd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x5f,0x15,0xf0,0x1c,0xf0,0x1c]     
vmaxpd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vmaxpd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x5f,0x15,0xf0,0x1c,0xf0,0x1c]    
vmaxpd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxpd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x5f,0x92,0xf0,0x1c,0xf0,0x1c]      
vmaxpd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vmaxpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x5f,0x92,0xf0,0x1c,0xf0,0x1c]     
vmaxpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vmaxpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x5f,0x92,0xf0,0x1c,0xf0,0x1c]    
vmaxpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x5f,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmaxpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vmaxpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x5f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmaxpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vmaxpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x5f,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vmaxpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vmaxpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x5f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vmaxpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vmaxpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x5f,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vmaxpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x5f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vmaxpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxpd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5f,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmaxpd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vmaxpd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmaxpd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vmaxpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5f,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vmaxpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vmaxpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vmaxpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vmaxpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5f,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vmaxpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vmaxpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxpd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5f,0x92,0xf0,0x1c,0xf0,0x1c]      
vmaxpd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vmaxpd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5f,0x92,0xf0,0x1c,0xf0,0x1c]     
vmaxpd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vmaxpd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5f,0x92,0xf0,0x1c,0xf0,0x1c]    
vmaxpd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxpd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5f,0x15,0xf0,0x1c,0xf0,0x1c]      
vmaxpd 485498096, %zmm2, %zmm2 

// CHECK: vmaxpd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5f,0x15,0xf0,0x1c,0xf0,0x1c]     
vmaxpd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vmaxpd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5f,0x15,0xf0,0x1c,0xf0,0x1c]    
vmaxpd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x5f,0x54,0x02,0x40]      
vmaxpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vmaxpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x5f,0x54,0x02,0x40]     
vmaxpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vmaxpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x5f,0x54,0x02,0x40]    
vmaxpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxpd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x5f,0x12]      
vmaxpd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vmaxpd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x5f,0x12]     
vmaxpd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vmaxpd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x5f,0x12]    
vmaxpd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxpd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5f,0x12]      
vmaxpd (%edx), %zmm2, %zmm2 

// CHECK: vmaxpd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5f,0x12]     
vmaxpd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vmaxpd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5f,0x12]    
vmaxpd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxpd {sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x18,0x5f,0xd2]     
vmaxpd {sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vmaxpd {sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x1a,0x5f,0xd2]    
vmaxpd {sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vmaxpd {sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0x9a,0x5f,0xd2]   
vmaxpd {sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxpd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5f,0xd2]      
vmaxpd %zmm2, %zmm2, %zmm2 

// CHECK: vmaxpd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5f,0xd2]     
vmaxpd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vmaxpd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5f,0xd2]    
vmaxpd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x5f,0x54,0x02,0x40]      
vmaxps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vmaxps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x5f,0x54,0x02,0x40]     
vmaxps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vmaxps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x5f,0x54,0x02,0x40]    
vmaxps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5f,0x54,0x02,0x40]      
vmaxps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vmaxps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5f,0x54,0x02,0x40]     
vmaxps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vmaxps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5f,0x54,0x02,0x40]    
vmaxps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x5f,0x15,0xf0,0x1c,0xf0,0x1c]      
vmaxps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vmaxps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x5f,0x15,0xf0,0x1c,0xf0,0x1c]     
vmaxps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vmaxps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x5f,0x15,0xf0,0x1c,0xf0,0x1c]    
vmaxps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x5f,0x92,0xf0,0x1c,0xf0,0x1c]      
vmaxps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vmaxps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x5f,0x92,0xf0,0x1c,0xf0,0x1c]     
vmaxps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vmaxps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x5f,0x92,0xf0,0x1c,0xf0,0x1c]    
vmaxps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x5f,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmaxps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vmaxps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x5f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmaxps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vmaxps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x5f,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vmaxps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vmaxps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x5f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vmaxps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vmaxps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x5f,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vmaxps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x5f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vmaxps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5f,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmaxps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vmaxps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmaxps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vmaxps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5f,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vmaxps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vmaxps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vmaxps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vmaxps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5f,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vmaxps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vmaxps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5f,0x92,0xf0,0x1c,0xf0,0x1c]      
vmaxps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vmaxps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5f,0x92,0xf0,0x1c,0xf0,0x1c]     
vmaxps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vmaxps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5f,0x92,0xf0,0x1c,0xf0,0x1c]    
vmaxps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5f,0x15,0xf0,0x1c,0xf0,0x1c]      
vmaxps 485498096, %zmm2, %zmm2 

// CHECK: vmaxps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5f,0x15,0xf0,0x1c,0xf0,0x1c]     
vmaxps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vmaxps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5f,0x15,0xf0,0x1c,0xf0,0x1c]    
vmaxps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x5f,0x12]      
vmaxps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vmaxps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x5f,0x12]     
vmaxps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vmaxps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x5f,0x12]    
vmaxps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5f,0x12]      
vmaxps (%edx), %zmm2, %zmm2 

// CHECK: vmaxps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5f,0x12]     
vmaxps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vmaxps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5f,0x12]    
vmaxps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxps {sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x18,0x5f,0xd2]     
vmaxps {sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vmaxps {sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x1a,0x5f,0xd2]    
vmaxps {sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vmaxps {sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x9a,0x5f,0xd2]   
vmaxps {sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmaxps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5f,0xd2]      
vmaxps %zmm2, %zmm2, %zmm2 

// CHECK: vmaxps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5f,0xd2]     
vmaxps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vmaxps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5f,0xd2]    
vmaxps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminpd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5d,0x54,0x02,0x40]      
vminpd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vminpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5d,0x54,0x02,0x40]     
vminpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vminpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5d,0x54,0x02,0x40]    
vminpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminpd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x5d,0x15,0xf0,0x1c,0xf0,0x1c]      
vminpd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vminpd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x5d,0x15,0xf0,0x1c,0xf0,0x1c]     
vminpd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vminpd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x5d,0x15,0xf0,0x1c,0xf0,0x1c]    
vminpd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminpd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x5d,0x92,0xf0,0x1c,0xf0,0x1c]      
vminpd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vminpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x5d,0x92,0xf0,0x1c,0xf0,0x1c]     
vminpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vminpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x5d,0x92,0xf0,0x1c,0xf0,0x1c]    
vminpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x5d,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vminpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vminpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x5d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vminpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vminpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x5d,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vminpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vminpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x5d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vminpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vminpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x5d,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vminpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x5d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vminpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminpd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5d,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vminpd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vminpd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vminpd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vminpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5d,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vminpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vminpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vminpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vminpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5d,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vminpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vminpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminpd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5d,0x92,0xf0,0x1c,0xf0,0x1c]      
vminpd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vminpd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5d,0x92,0xf0,0x1c,0xf0,0x1c]     
vminpd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vminpd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5d,0x92,0xf0,0x1c,0xf0,0x1c]    
vminpd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminpd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5d,0x15,0xf0,0x1c,0xf0,0x1c]      
vminpd 485498096, %zmm2, %zmm2 

// CHECK: vminpd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5d,0x15,0xf0,0x1c,0xf0,0x1c]     
vminpd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vminpd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5d,0x15,0xf0,0x1c,0xf0,0x1c]    
vminpd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x5d,0x54,0x02,0x40]      
vminpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vminpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x5d,0x54,0x02,0x40]     
vminpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vminpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x5d,0x54,0x02,0x40]    
vminpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminpd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x5d,0x12]      
vminpd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vminpd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x5d,0x12]     
vminpd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vminpd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x5d,0x12]    
vminpd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminpd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5d,0x12]      
vminpd (%edx), %zmm2, %zmm2 

// CHECK: vminpd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5d,0x12]     
vminpd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vminpd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5d,0x12]    
vminpd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminpd {sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x18,0x5d,0xd2]     
vminpd {sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vminpd {sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x1a,0x5d,0xd2]    
vminpd {sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vminpd {sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0x9a,0x5d,0xd2]   
vminpd {sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminpd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x5d,0xd2]      
vminpd %zmm2, %zmm2, %zmm2 

// CHECK: vminpd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x5d,0xd2]     
vminpd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vminpd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x5d,0xd2]    
vminpd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x5d,0x54,0x02,0x40]      
vminps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vminps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x5d,0x54,0x02,0x40]     
vminps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vminps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x5d,0x54,0x02,0x40]    
vminps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5d,0x54,0x02,0x40]      
vminps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vminps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5d,0x54,0x02,0x40]     
vminps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vminps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5d,0x54,0x02,0x40]    
vminps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x5d,0x15,0xf0,0x1c,0xf0,0x1c]      
vminps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vminps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x5d,0x15,0xf0,0x1c,0xf0,0x1c]     
vminps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vminps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x5d,0x15,0xf0,0x1c,0xf0,0x1c]    
vminps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x5d,0x92,0xf0,0x1c,0xf0,0x1c]      
vminps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vminps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x5d,0x92,0xf0,0x1c,0xf0,0x1c]     
vminps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vminps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x5d,0x92,0xf0,0x1c,0xf0,0x1c]    
vminps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x5d,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vminps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vminps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x5d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vminps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vminps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x5d,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vminps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vminps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x5d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vminps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vminps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x5d,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vminps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x5d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vminps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5d,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vminps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vminps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vminps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vminps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5d,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vminps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vminps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vminps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vminps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5d,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vminps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vminps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5d,0x92,0xf0,0x1c,0xf0,0x1c]      
vminps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vminps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5d,0x92,0xf0,0x1c,0xf0,0x1c]     
vminps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vminps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5d,0x92,0xf0,0x1c,0xf0,0x1c]    
vminps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5d,0x15,0xf0,0x1c,0xf0,0x1c]      
vminps 485498096, %zmm2, %zmm2 

// CHECK: vminps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5d,0x15,0xf0,0x1c,0xf0,0x1c]     
vminps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vminps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5d,0x15,0xf0,0x1c,0xf0,0x1c]    
vminps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x5d,0x12]      
vminps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vminps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x5d,0x12]     
vminps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vminps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x5d,0x12]    
vminps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5d,0x12]      
vminps (%edx), %zmm2, %zmm2 

// CHECK: vminps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5d,0x12]     
vminps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vminps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5d,0x12]    
vminps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminps {sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x18,0x5d,0xd2]     
vminps {sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vminps {sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x1a,0x5d,0xd2]    
vminps {sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vminps {sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x9a,0x5d,0xd2]   
vminps {sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vminps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x5d,0xd2]      
vminps %zmm2, %zmm2, %zmm2 

// CHECK: vminps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x5d,0xd2]     
vminps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vminps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x5d,0xd2]    
vminps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmovapd 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x28,0x54,0x02,0x40]       
vmovapd 4096(%edx,%eax), %zmm2 

// CHECK: vmovapd 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x28,0x54,0x02,0x40]      
vmovapd 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vmovapd 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x28,0x54,0x02,0x40]     
vmovapd 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vmovapd -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x28,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vmovapd -485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovapd 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x28,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vmovapd 485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovapd -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x28,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmovapd -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vmovapd 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x28,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmovapd 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vmovapd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x28,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vmovapd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vmovapd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x28,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vmovapd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vmovapd 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x28,0x92,0xf0,0x1c,0xf0,0x1c]       
vmovapd 485498096(%edx), %zmm2 

// CHECK: vmovapd 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x28,0x92,0xf0,0x1c,0xf0,0x1c]      
vmovapd 485498096(%edx), %zmm2 {%k2} 

// CHECK: vmovapd 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x28,0x92,0xf0,0x1c,0xf0,0x1c]     
vmovapd 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vmovapd 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x28,0x15,0xf0,0x1c,0xf0,0x1c]       
vmovapd 485498096, %zmm2 

// CHECK: vmovapd 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x28,0x15,0xf0,0x1c,0xf0,0x1c]      
vmovapd 485498096, %zmm2 {%k2} 

// CHECK: vmovapd 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x28,0x15,0xf0,0x1c,0xf0,0x1c]     
vmovapd 485498096, %zmm2 {%k2} {z} 

// CHECK: vmovapd (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x28,0x12]       
vmovapd (%edx), %zmm2 

// CHECK: vmovapd (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x28,0x12]      
vmovapd (%edx), %zmm2 {%k2} 

// CHECK: vmovapd (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x28,0x12]     
vmovapd (%edx), %zmm2 {%k2} {z} 

// CHECK: vmovapd.s %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x29,0xd2]       
vmovapd.s %zmm2, %zmm2 

// CHECK: vmovapd.s %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x29,0xd2]      
vmovapd.s %zmm2, %zmm2 {%k2} 

// CHECK: vmovapd.s %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x29,0xd2]     
vmovapd.s %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmovapd %zmm2, 4096(%edx,%eax) 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x29,0x54,0x02,0x40]       
vmovapd %zmm2, 4096(%edx,%eax) 

// CHECK: vmovapd %zmm2, 4096(%edx,%eax) {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x29,0x54,0x02,0x40]      
vmovapd %zmm2, 4096(%edx,%eax) {%k2} 

// CHECK: vmovapd %zmm2, -485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x29,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vmovapd %zmm2, -485498096(%edx,%eax,4) 

// CHECK: vmovapd %zmm2, 485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x29,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vmovapd %zmm2, 485498096(%edx,%eax,4) 

// CHECK: vmovapd %zmm2, -485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x29,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmovapd %zmm2, -485498096(%edx,%eax,4) {%k2} 

// CHECK: vmovapd %zmm2, 485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x29,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmovapd %zmm2, 485498096(%edx,%eax,4) {%k2} 

// CHECK: vmovapd %zmm2, 485498096(%edx) 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x29,0x92,0xf0,0x1c,0xf0,0x1c]       
vmovapd %zmm2, 485498096(%edx) 

// CHECK: vmovapd %zmm2, 485498096(%edx) {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x29,0x92,0xf0,0x1c,0xf0,0x1c]      
vmovapd %zmm2, 485498096(%edx) {%k2} 

// CHECK: vmovapd %zmm2, 485498096 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x29,0x15,0xf0,0x1c,0xf0,0x1c]       
vmovapd %zmm2, 485498096 

// CHECK: vmovapd %zmm2, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x29,0x15,0xf0,0x1c,0xf0,0x1c]      
vmovapd %zmm2, 485498096 {%k2} 

// CHECK: vmovapd %zmm2, (%edx) 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x29,0x12]       
vmovapd %zmm2, (%edx) 

// CHECK: vmovapd %zmm2, (%edx) {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x29,0x12]      
vmovapd %zmm2, (%edx) {%k2} 

// CHECK: vmovapd %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x28,0xd2]       
vmovapd %zmm2, %zmm2 

// CHECK: vmovapd %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x28,0xd2]      
vmovapd %zmm2, %zmm2 {%k2} 

// CHECK: vmovapd %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x28,0xd2]     
vmovapd %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmovaps 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x28,0x54,0x02,0x40]       
vmovaps 4096(%edx,%eax), %zmm2 

// CHECK: vmovaps 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x28,0x54,0x02,0x40]      
vmovaps 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vmovaps 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x28,0x54,0x02,0x40]     
vmovaps 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vmovaps -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x28,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vmovaps -485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovaps 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x28,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vmovaps 485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovaps -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x28,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmovaps -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vmovaps 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x28,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmovaps 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vmovaps -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x28,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vmovaps -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vmovaps 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x28,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vmovaps 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vmovaps 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x28,0x92,0xf0,0x1c,0xf0,0x1c]       
vmovaps 485498096(%edx), %zmm2 

// CHECK: vmovaps 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x28,0x92,0xf0,0x1c,0xf0,0x1c]      
vmovaps 485498096(%edx), %zmm2 {%k2} 

// CHECK: vmovaps 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x28,0x92,0xf0,0x1c,0xf0,0x1c]     
vmovaps 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vmovaps 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x28,0x15,0xf0,0x1c,0xf0,0x1c]       
vmovaps 485498096, %zmm2 

// CHECK: vmovaps 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x28,0x15,0xf0,0x1c,0xf0,0x1c]      
vmovaps 485498096, %zmm2 {%k2} 

// CHECK: vmovaps 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x28,0x15,0xf0,0x1c,0xf0,0x1c]     
vmovaps 485498096, %zmm2 {%k2} {z} 

// CHECK: vmovaps (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x28,0x12]       
vmovaps (%edx), %zmm2 

// CHECK: vmovaps (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x28,0x12]      
vmovaps (%edx), %zmm2 {%k2} 

// CHECK: vmovaps (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x28,0x12]     
vmovaps (%edx), %zmm2 {%k2} {z} 

// CHECK: vmovaps.s %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x29,0xd2]       
vmovaps.s %zmm2, %zmm2 

// CHECK: vmovaps.s %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x29,0xd2]      
vmovaps.s %zmm2, %zmm2 {%k2} 

// CHECK: vmovaps.s %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x29,0xd2]     
vmovaps.s %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmovaps %zmm2, 4096(%edx,%eax) 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x29,0x54,0x02,0x40]       
vmovaps %zmm2, 4096(%edx,%eax) 

// CHECK: vmovaps %zmm2, 4096(%edx,%eax) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x29,0x54,0x02,0x40]      
vmovaps %zmm2, 4096(%edx,%eax) {%k2} 

// CHECK: vmovaps %zmm2, -485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x29,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vmovaps %zmm2, -485498096(%edx,%eax,4) 

// CHECK: vmovaps %zmm2, 485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x29,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vmovaps %zmm2, 485498096(%edx,%eax,4) 

// CHECK: vmovaps %zmm2, -485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x29,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmovaps %zmm2, -485498096(%edx,%eax,4) {%k2} 

// CHECK: vmovaps %zmm2, 485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x29,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmovaps %zmm2, 485498096(%edx,%eax,4) {%k2} 

// CHECK: vmovaps %zmm2, 485498096(%edx) 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x29,0x92,0xf0,0x1c,0xf0,0x1c]       
vmovaps %zmm2, 485498096(%edx) 

// CHECK: vmovaps %zmm2, 485498096(%edx) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x29,0x92,0xf0,0x1c,0xf0,0x1c]      
vmovaps %zmm2, 485498096(%edx) {%k2} 

// CHECK: vmovaps %zmm2, 485498096 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x29,0x15,0xf0,0x1c,0xf0,0x1c]       
vmovaps %zmm2, 485498096 

// CHECK: vmovaps %zmm2, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x29,0x15,0xf0,0x1c,0xf0,0x1c]      
vmovaps %zmm2, 485498096 {%k2} 

// CHECK: vmovaps %zmm2, (%edx) 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x29,0x12]       
vmovaps %zmm2, (%edx) 

// CHECK: vmovaps %zmm2, (%edx) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x29,0x12]      
vmovaps %zmm2, (%edx) {%k2} 

// CHECK: vmovaps %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x28,0xd2]       
vmovaps %zmm2, %zmm2 

// CHECK: vmovaps %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x28,0xd2]      
vmovaps %zmm2, %zmm2 {%k2} 

// CHECK: vmovaps %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x28,0xd2]     
vmovaps %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmovddup 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf1,0xff,0x48,0x12,0x54,0x02,0x40]       
vmovddup 4096(%edx,%eax), %zmm2 

// CHECK: vmovddup 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x4a,0x12,0x54,0x02,0x40]      
vmovddup 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vmovddup 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xca,0x12,0x54,0x02,0x40]     
vmovddup 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vmovddup -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0xff,0x48,0x12,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vmovddup -485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovddup 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0xff,0x48,0x12,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vmovddup 485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovddup -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x4a,0x12,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmovddup -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vmovddup 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x4a,0x12,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmovddup 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vmovddup -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xca,0x12,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vmovddup -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vmovddup 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xca,0x12,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vmovddup 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vmovddup 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0xff,0x48,0x12,0x92,0xf0,0x1c,0xf0,0x1c]       
vmovddup 485498096(%edx), %zmm2 

// CHECK: vmovddup 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x4a,0x12,0x92,0xf0,0x1c,0xf0,0x1c]      
vmovddup 485498096(%edx), %zmm2 {%k2} 

// CHECK: vmovddup 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xca,0x12,0x92,0xf0,0x1c,0xf0,0x1c]     
vmovddup 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vmovddup 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xff,0x48,0x12,0x15,0xf0,0x1c,0xf0,0x1c]       
vmovddup 485498096, %zmm2 

// CHECK: vmovddup 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x4a,0x12,0x15,0xf0,0x1c,0xf0,0x1c]      
vmovddup 485498096, %zmm2 {%k2} 

// CHECK: vmovddup 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xca,0x12,0x15,0xf0,0x1c,0xf0,0x1c]     
vmovddup 485498096, %zmm2 {%k2} {z} 

// CHECK: vmovddup (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0xff,0x48,0x12,0x12]       
vmovddup (%edx), %zmm2 

// CHECK: vmovddup (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x4a,0x12,0x12]      
vmovddup (%edx), %zmm2 {%k2} 

// CHECK: vmovddup (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xca,0x12,0x12]     
vmovddup (%edx), %zmm2 {%k2} {z} 

// CHECK: vmovddup %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xff,0x48,0x12,0xd2]       
vmovddup %zmm2, %zmm2 

// CHECK: vmovddup %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xff,0x4a,0x12,0xd2]      
vmovddup %zmm2, %zmm2 {%k2} 

// CHECK: vmovddup %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xff,0xca,0x12,0xd2]     
vmovddup %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmovdqa32 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x6f,0x54,0x02,0x40]       
vmovdqa32 4096(%edx,%eax), %zmm2 

// CHECK: vmovdqa32 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x6f,0x54,0x02,0x40]      
vmovdqa32 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vmovdqa32 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xca,0x6f,0x54,0x02,0x40]     
vmovdqa32 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vmovdqa32 -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x6f,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vmovdqa32 -485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovdqa32 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x6f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vmovdqa32 485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovdqa32 -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x6f,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmovdqa32 -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vmovdqa32 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x6f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmovdqa32 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vmovdqa32 -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xca,0x6f,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vmovdqa32 -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vmovdqa32 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xca,0x6f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vmovdqa32 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vmovdqa32 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x6f,0x92,0xf0,0x1c,0xf0,0x1c]       
vmovdqa32 485498096(%edx), %zmm2 

// CHECK: vmovdqa32 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x6f,0x92,0xf0,0x1c,0xf0,0x1c]      
vmovdqa32 485498096(%edx), %zmm2 {%k2} 

// CHECK: vmovdqa32 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xca,0x6f,0x92,0xf0,0x1c,0xf0,0x1c]     
vmovdqa32 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vmovdqa32 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x6f,0x15,0xf0,0x1c,0xf0,0x1c]       
vmovdqa32 485498096, %zmm2 

// CHECK: vmovdqa32 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x6f,0x15,0xf0,0x1c,0xf0,0x1c]      
vmovdqa32 485498096, %zmm2 {%k2} 

// CHECK: vmovdqa32 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xca,0x6f,0x15,0xf0,0x1c,0xf0,0x1c]     
vmovdqa32 485498096, %zmm2 {%k2} {z} 

// CHECK: vmovdqa32 (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x6f,0x12]       
vmovdqa32 (%edx), %zmm2 

// CHECK: vmovdqa32 (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x6f,0x12]      
vmovdqa32 (%edx), %zmm2 {%k2} 

// CHECK: vmovdqa32 (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xca,0x6f,0x12]     
vmovdqa32 (%edx), %zmm2 {%k2} {z} 

// CHECK: vmovdqa32.s %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x7f,0xd2]       
vmovdqa32.s %zmm2, %zmm2 

// CHECK: vmovdqa32.s %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x7f,0xd2]      
vmovdqa32.s %zmm2, %zmm2 {%k2} 

// CHECK: vmovdqa32.s %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xca,0x7f,0xd2]     
vmovdqa32.s %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmovdqa32 %zmm2, 4096(%edx,%eax) 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x7f,0x54,0x02,0x40]       
vmovdqa32 %zmm2, 4096(%edx,%eax) 

// CHECK: vmovdqa32 %zmm2, 4096(%edx,%eax) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x7f,0x54,0x02,0x40]      
vmovdqa32 %zmm2, 4096(%edx,%eax) {%k2} 

// CHECK: vmovdqa32 %zmm2, -485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x7f,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vmovdqa32 %zmm2, -485498096(%edx,%eax,4) 

// CHECK: vmovdqa32 %zmm2, 485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x7f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vmovdqa32 %zmm2, 485498096(%edx,%eax,4) 

// CHECK: vmovdqa32 %zmm2, -485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x7f,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmovdqa32 %zmm2, -485498096(%edx,%eax,4) {%k2} 

// CHECK: vmovdqa32 %zmm2, 485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x7f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmovdqa32 %zmm2, 485498096(%edx,%eax,4) {%k2} 

// CHECK: vmovdqa32 %zmm2, 485498096(%edx) 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x7f,0x92,0xf0,0x1c,0xf0,0x1c]       
vmovdqa32 %zmm2, 485498096(%edx) 

// CHECK: vmovdqa32 %zmm2, 485498096(%edx) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x7f,0x92,0xf0,0x1c,0xf0,0x1c]      
vmovdqa32 %zmm2, 485498096(%edx) {%k2} 

// CHECK: vmovdqa32 %zmm2, 485498096 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x7f,0x15,0xf0,0x1c,0xf0,0x1c]       
vmovdqa32 %zmm2, 485498096 

// CHECK: vmovdqa32 %zmm2, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x7f,0x15,0xf0,0x1c,0xf0,0x1c]      
vmovdqa32 %zmm2, 485498096 {%k2} 

// CHECK: vmovdqa32 %zmm2, (%edx) 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x7f,0x12]       
vmovdqa32 %zmm2, (%edx) 

// CHECK: vmovdqa32 %zmm2, (%edx) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x7f,0x12]      
vmovdqa32 %zmm2, (%edx) {%k2} 

// CHECK: vmovdqa32 %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0x6f,0xd2]       
vmovdqa32 %zmm2, %zmm2 

// CHECK: vmovdqa32 %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7d,0x4a,0x6f,0xd2]      
vmovdqa32 %zmm2, %zmm2 {%k2} 

// CHECK: vmovdqa32 %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7d,0xca,0x6f,0xd2]     
vmovdqa32 %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmovdqu32 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x6f,0x54,0x02,0x40]       
vmovdqu32 4096(%edx,%eax), %zmm2 

// CHECK: vmovdqu32 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x6f,0x54,0x02,0x40]      
vmovdqu32 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vmovdqu32 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x6f,0x54,0x02,0x40]     
vmovdqu32 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vmovdqu32 -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x6f,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vmovdqu32 -485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovdqu32 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x6f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vmovdqu32 485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovdqu32 -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x6f,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmovdqu32 -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vmovdqu32 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x6f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmovdqu32 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vmovdqu32 -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x6f,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vmovdqu32 -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vmovdqu32 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x6f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vmovdqu32 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vmovdqu32 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x6f,0x92,0xf0,0x1c,0xf0,0x1c]       
vmovdqu32 485498096(%edx), %zmm2 

// CHECK: vmovdqu32 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x6f,0x92,0xf0,0x1c,0xf0,0x1c]      
vmovdqu32 485498096(%edx), %zmm2 {%k2} 

// CHECK: vmovdqu32 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x6f,0x92,0xf0,0x1c,0xf0,0x1c]     
vmovdqu32 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vmovdqu32 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x6f,0x15,0xf0,0x1c,0xf0,0x1c]       
vmovdqu32 485498096, %zmm2 

// CHECK: vmovdqu32 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x6f,0x15,0xf0,0x1c,0xf0,0x1c]      
vmovdqu32 485498096, %zmm2 {%k2} 

// CHECK: vmovdqu32 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x6f,0x15,0xf0,0x1c,0xf0,0x1c]     
vmovdqu32 485498096, %zmm2 {%k2} {z} 

// CHECK: vmovdqu32 (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x6f,0x12]       
vmovdqu32 (%edx), %zmm2 

// CHECK: vmovdqu32 (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x6f,0x12]      
vmovdqu32 (%edx), %zmm2 {%k2} 

// CHECK: vmovdqu32 (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x6f,0x12]     
vmovdqu32 (%edx), %zmm2 {%k2} {z} 

// CHECK: vmovdqu32.s %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x7f,0xd2]       
vmovdqu32.s %zmm2, %zmm2 

// CHECK: vmovdqu32.s %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x7f,0xd2]      
vmovdqu32.s %zmm2, %zmm2 {%k2} 

// CHECK: vmovdqu32.s %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x7f,0xd2]     
vmovdqu32.s %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmovdqu32 %zmm2, 4096(%edx,%eax) 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x7f,0x54,0x02,0x40]       
vmovdqu32 %zmm2, 4096(%edx,%eax) 

// CHECK: vmovdqu32 %zmm2, 4096(%edx,%eax) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x7f,0x54,0x02,0x40]      
vmovdqu32 %zmm2, 4096(%edx,%eax) {%k2} 

// CHECK: vmovdqu32 %zmm2, -485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x7f,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vmovdqu32 %zmm2, -485498096(%edx,%eax,4) 

// CHECK: vmovdqu32 %zmm2, 485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x7f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vmovdqu32 %zmm2, 485498096(%edx,%eax,4) 

// CHECK: vmovdqu32 %zmm2, -485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x7f,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmovdqu32 %zmm2, -485498096(%edx,%eax,4) {%k2} 

// CHECK: vmovdqu32 %zmm2, 485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x7f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmovdqu32 %zmm2, 485498096(%edx,%eax,4) {%k2} 

// CHECK: vmovdqu32 %zmm2, 485498096(%edx) 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x7f,0x92,0xf0,0x1c,0xf0,0x1c]       
vmovdqu32 %zmm2, 485498096(%edx) 

// CHECK: vmovdqu32 %zmm2, 485498096(%edx) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x7f,0x92,0xf0,0x1c,0xf0,0x1c]      
vmovdqu32 %zmm2, 485498096(%edx) {%k2} 

// CHECK: vmovdqu32 %zmm2, 485498096 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x7f,0x15,0xf0,0x1c,0xf0,0x1c]       
vmovdqu32 %zmm2, 485498096 

// CHECK: vmovdqu32 %zmm2, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x7f,0x15,0xf0,0x1c,0xf0,0x1c]      
vmovdqu32 %zmm2, 485498096 {%k2} 

// CHECK: vmovdqu32 %zmm2, (%edx) 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x7f,0x12]       
vmovdqu32 %zmm2, (%edx) 

// CHECK: vmovdqu32 %zmm2, (%edx) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x7f,0x12]      
vmovdqu32 %zmm2, (%edx) {%k2} 

// CHECK: vmovdqu32 %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x6f,0xd2]       
vmovdqu32 %zmm2, %zmm2 

// CHECK: vmovdqu32 %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x6f,0xd2]      
vmovdqu32 %zmm2, %zmm2 {%k2} 

// CHECK: vmovdqu32 %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x6f,0xd2]     
vmovdqu32 %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmovntdqa 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x2a,0x54,0x02,0x40]       
vmovntdqa 4096(%edx,%eax), %zmm2 

// CHECK: vmovntdqa -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x2a,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vmovntdqa -485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovntdqa 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x2a,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vmovntdqa 485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovntdqa 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x2a,0x92,0xf0,0x1c,0xf0,0x1c]       
vmovntdqa 485498096(%edx), %zmm2 

// CHECK: vmovntdqa 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x2a,0x15,0xf0,0x1c,0xf0,0x1c]       
vmovntdqa 485498096, %zmm2 

// CHECK: vmovntdqa (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x2a,0x12]       
vmovntdqa (%edx), %zmm2 

// CHECK: vmovntdq %zmm2, 4096(%edx,%eax) 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0xe7,0x54,0x02,0x40]       
vmovntdq %zmm2, 4096(%edx,%eax) 

// CHECK: vmovntdq %zmm2, -485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0xe7,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vmovntdq %zmm2, -485498096(%edx,%eax,4) 

// CHECK: vmovntdq %zmm2, 485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0xe7,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vmovntdq %zmm2, 485498096(%edx,%eax,4) 

// CHECK: vmovntdq %zmm2, 485498096(%edx) 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0xe7,0x92,0xf0,0x1c,0xf0,0x1c]       
vmovntdq %zmm2, 485498096(%edx) 

// CHECK: vmovntdq %zmm2, 485498096 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0xe7,0x15,0xf0,0x1c,0xf0,0x1c]       
vmovntdq %zmm2, 485498096 

// CHECK: vmovntdq %zmm2, (%edx) 
// CHECK: encoding: [0x62,0xf1,0x7d,0x48,0xe7,0x12]       
vmovntdq %zmm2, (%edx) 

// CHECK: vmovntpd %zmm2, 4096(%edx,%eax) 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x2b,0x54,0x02,0x40]       
vmovntpd %zmm2, 4096(%edx,%eax) 

// CHECK: vmovntpd %zmm2, -485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x2b,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vmovntpd %zmm2, -485498096(%edx,%eax,4) 

// CHECK: vmovntpd %zmm2, 485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x2b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vmovntpd %zmm2, 485498096(%edx,%eax,4) 

// CHECK: vmovntpd %zmm2, 485498096(%edx) 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x2b,0x92,0xf0,0x1c,0xf0,0x1c]       
vmovntpd %zmm2, 485498096(%edx) 

// CHECK: vmovntpd %zmm2, 485498096 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x2b,0x15,0xf0,0x1c,0xf0,0x1c]       
vmovntpd %zmm2, 485498096 

// CHECK: vmovntpd %zmm2, (%edx) 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x2b,0x12]       
vmovntpd %zmm2, (%edx) 

// CHECK: vmovntps %zmm2, 4096(%edx,%eax) 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x2b,0x54,0x02,0x40]       
vmovntps %zmm2, 4096(%edx,%eax) 

// CHECK: vmovntps %zmm2, -485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x2b,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vmovntps %zmm2, -485498096(%edx,%eax,4) 

// CHECK: vmovntps %zmm2, 485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x2b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vmovntps %zmm2, 485498096(%edx,%eax,4) 

// CHECK: vmovntps %zmm2, 485498096(%edx) 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x2b,0x92,0xf0,0x1c,0xf0,0x1c]       
vmovntps %zmm2, 485498096(%edx) 

// CHECK: vmovntps %zmm2, 485498096 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x2b,0x15,0xf0,0x1c,0xf0,0x1c]       
vmovntps %zmm2, 485498096 

// CHECK: vmovntps %zmm2, (%edx) 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x2b,0x12]       
vmovntps %zmm2, (%edx) 

// CHECK: vmovshdup 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x16,0x54,0x02,0x40]       
vmovshdup 4096(%edx,%eax), %zmm2 

// CHECK: vmovshdup 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x16,0x54,0x02,0x40]      
vmovshdup 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vmovshdup 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x16,0x54,0x02,0x40]     
vmovshdup 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vmovshdup -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x16,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vmovshdup -485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovshdup 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x16,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vmovshdup 485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovshdup -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x16,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmovshdup -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vmovshdup 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x16,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmovshdup 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vmovshdup -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x16,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vmovshdup -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vmovshdup 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x16,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vmovshdup 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vmovshdup 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x16,0x92,0xf0,0x1c,0xf0,0x1c]       
vmovshdup 485498096(%edx), %zmm2 

// CHECK: vmovshdup 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x16,0x92,0xf0,0x1c,0xf0,0x1c]      
vmovshdup 485498096(%edx), %zmm2 {%k2} 

// CHECK: vmovshdup 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x16,0x92,0xf0,0x1c,0xf0,0x1c]     
vmovshdup 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vmovshdup 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x16,0x15,0xf0,0x1c,0xf0,0x1c]       
vmovshdup 485498096, %zmm2 

// CHECK: vmovshdup 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x16,0x15,0xf0,0x1c,0xf0,0x1c]      
vmovshdup 485498096, %zmm2 {%k2} 

// CHECK: vmovshdup 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x16,0x15,0xf0,0x1c,0xf0,0x1c]     
vmovshdup 485498096, %zmm2 {%k2} {z} 

// CHECK: vmovshdup (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x16,0x12]       
vmovshdup (%edx), %zmm2 

// CHECK: vmovshdup (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x16,0x12]      
vmovshdup (%edx), %zmm2 {%k2} 

// CHECK: vmovshdup (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x16,0x12]     
vmovshdup (%edx), %zmm2 {%k2} {z} 

// CHECK: vmovshdup %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x16,0xd2]       
vmovshdup %zmm2, %zmm2 

// CHECK: vmovshdup %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x16,0xd2]      
vmovshdup %zmm2, %zmm2 {%k2} 

// CHECK: vmovshdup %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x16,0xd2]     
vmovshdup %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmovsldup 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x12,0x54,0x02,0x40]       
vmovsldup 4096(%edx,%eax), %zmm2 

// CHECK: vmovsldup 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x12,0x54,0x02,0x40]      
vmovsldup 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vmovsldup 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x12,0x54,0x02,0x40]     
vmovsldup 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vmovsldup -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x12,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vmovsldup -485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovsldup 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x12,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vmovsldup 485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovsldup -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x12,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmovsldup -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vmovsldup 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x12,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmovsldup 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vmovsldup -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x12,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vmovsldup -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vmovsldup 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x12,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vmovsldup 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vmovsldup 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x12,0x92,0xf0,0x1c,0xf0,0x1c]       
vmovsldup 485498096(%edx), %zmm2 

// CHECK: vmovsldup 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x12,0x92,0xf0,0x1c,0xf0,0x1c]      
vmovsldup 485498096(%edx), %zmm2 {%k2} 

// CHECK: vmovsldup 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x12,0x92,0xf0,0x1c,0xf0,0x1c]     
vmovsldup 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vmovsldup 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x12,0x15,0xf0,0x1c,0xf0,0x1c]       
vmovsldup 485498096, %zmm2 

// CHECK: vmovsldup 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x12,0x15,0xf0,0x1c,0xf0,0x1c]      
vmovsldup 485498096, %zmm2 {%k2} 

// CHECK: vmovsldup 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x12,0x15,0xf0,0x1c,0xf0,0x1c]     
vmovsldup 485498096, %zmm2 {%k2} {z} 

// CHECK: vmovsldup (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x12,0x12]       
vmovsldup (%edx), %zmm2 

// CHECK: vmovsldup (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x12,0x12]      
vmovsldup (%edx), %zmm2 {%k2} 

// CHECK: vmovsldup (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x12,0x12]     
vmovsldup (%edx), %zmm2 {%k2} {z} 

// CHECK: vmovsldup %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7e,0x48,0x12,0xd2]       
vmovsldup %zmm2, %zmm2 

// CHECK: vmovsldup %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7e,0x4a,0x12,0xd2]      
vmovsldup %zmm2, %zmm2 {%k2} 

// CHECK: vmovsldup %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7e,0xca,0x12,0xd2]     
vmovsldup %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmovupd 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x10,0x54,0x02,0x40]       
vmovupd 4096(%edx,%eax), %zmm2 

// CHECK: vmovupd 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x10,0x54,0x02,0x40]      
vmovupd 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vmovupd 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x10,0x54,0x02,0x40]     
vmovupd 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vmovupd -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x10,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vmovupd -485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovupd 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x10,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vmovupd 485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovupd -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x10,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmovupd -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vmovupd 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x10,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmovupd 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vmovupd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x10,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vmovupd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vmovupd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x10,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vmovupd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vmovupd 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x10,0x92,0xf0,0x1c,0xf0,0x1c]       
vmovupd 485498096(%edx), %zmm2 

// CHECK: vmovupd 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x10,0x92,0xf0,0x1c,0xf0,0x1c]      
vmovupd 485498096(%edx), %zmm2 {%k2} 

// CHECK: vmovupd 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x10,0x92,0xf0,0x1c,0xf0,0x1c]     
vmovupd 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vmovupd 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x10,0x15,0xf0,0x1c,0xf0,0x1c]       
vmovupd 485498096, %zmm2 

// CHECK: vmovupd 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x10,0x15,0xf0,0x1c,0xf0,0x1c]      
vmovupd 485498096, %zmm2 {%k2} 

// CHECK: vmovupd 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x10,0x15,0xf0,0x1c,0xf0,0x1c]     
vmovupd 485498096, %zmm2 {%k2} {z} 

// CHECK: vmovupd (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x10,0x12]       
vmovupd (%edx), %zmm2 

// CHECK: vmovupd (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x10,0x12]      
vmovupd (%edx), %zmm2 {%k2} 

// CHECK: vmovupd (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x10,0x12]     
vmovupd (%edx), %zmm2 {%k2} {z} 

// CHECK: vmovupd.s %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x11,0xd2]       
vmovupd.s %zmm2, %zmm2 

// CHECK: vmovupd.s %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x11,0xd2]      
vmovupd.s %zmm2, %zmm2 {%k2} 

// CHECK: vmovupd.s %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x11,0xd2]     
vmovupd.s %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmovupd %zmm2, 4096(%edx,%eax) 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x11,0x54,0x02,0x40]       
vmovupd %zmm2, 4096(%edx,%eax) 

// CHECK: vmovupd %zmm2, 4096(%edx,%eax) {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x11,0x54,0x02,0x40]      
vmovupd %zmm2, 4096(%edx,%eax) {%k2} 

// CHECK: vmovupd %zmm2, -485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x11,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vmovupd %zmm2, -485498096(%edx,%eax,4) 

// CHECK: vmovupd %zmm2, 485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x11,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vmovupd %zmm2, 485498096(%edx,%eax,4) 

// CHECK: vmovupd %zmm2, -485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x11,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmovupd %zmm2, -485498096(%edx,%eax,4) {%k2} 

// CHECK: vmovupd %zmm2, 485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x11,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmovupd %zmm2, 485498096(%edx,%eax,4) {%k2} 

// CHECK: vmovupd %zmm2, 485498096(%edx) 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x11,0x92,0xf0,0x1c,0xf0,0x1c]       
vmovupd %zmm2, 485498096(%edx) 

// CHECK: vmovupd %zmm2, 485498096(%edx) {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x11,0x92,0xf0,0x1c,0xf0,0x1c]      
vmovupd %zmm2, 485498096(%edx) {%k2} 

// CHECK: vmovupd %zmm2, 485498096 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x11,0x15,0xf0,0x1c,0xf0,0x1c]       
vmovupd %zmm2, 485498096 

// CHECK: vmovupd %zmm2, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x11,0x15,0xf0,0x1c,0xf0,0x1c]      
vmovupd %zmm2, 485498096 {%k2} 

// CHECK: vmovupd %zmm2, (%edx) 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x11,0x12]       
vmovupd %zmm2, (%edx) 

// CHECK: vmovupd %zmm2, (%edx) {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x11,0x12]      
vmovupd %zmm2, (%edx) {%k2} 

// CHECK: vmovupd %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xfd,0x48,0x10,0xd2]       
vmovupd %zmm2, %zmm2 

// CHECK: vmovupd %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xfd,0x4a,0x10,0xd2]      
vmovupd %zmm2, %zmm2 {%k2} 

// CHECK: vmovupd %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xfd,0xca,0x10,0xd2]     
vmovupd %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmovups 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x10,0x54,0x02,0x40]       
vmovups 4096(%edx,%eax), %zmm2 

// CHECK: vmovups 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x10,0x54,0x02,0x40]      
vmovups 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vmovups 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x10,0x54,0x02,0x40]     
vmovups 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vmovups -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x10,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vmovups -485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovups 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x10,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vmovups 485498096(%edx,%eax,4), %zmm2 

// CHECK: vmovups -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x10,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmovups -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vmovups 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x10,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmovups 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vmovups -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x10,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vmovups -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vmovups 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x10,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vmovups 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vmovups 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x10,0x92,0xf0,0x1c,0xf0,0x1c]       
vmovups 485498096(%edx), %zmm2 

// CHECK: vmovups 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x10,0x92,0xf0,0x1c,0xf0,0x1c]      
vmovups 485498096(%edx), %zmm2 {%k2} 

// CHECK: vmovups 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x10,0x92,0xf0,0x1c,0xf0,0x1c]     
vmovups 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vmovups 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x10,0x15,0xf0,0x1c,0xf0,0x1c]       
vmovups 485498096, %zmm2 

// CHECK: vmovups 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x10,0x15,0xf0,0x1c,0xf0,0x1c]      
vmovups 485498096, %zmm2 {%k2} 

// CHECK: vmovups 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x10,0x15,0xf0,0x1c,0xf0,0x1c]     
vmovups 485498096, %zmm2 {%k2} {z} 

// CHECK: vmovups (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x10,0x12]       
vmovups (%edx), %zmm2 

// CHECK: vmovups (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x10,0x12]      
vmovups (%edx), %zmm2 {%k2} 

// CHECK: vmovups (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x10,0x12]     
vmovups (%edx), %zmm2 {%k2} {z} 

// CHECK: vmovups.s %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x11,0xd2]       
vmovups.s %zmm2, %zmm2 

// CHECK: vmovups.s %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x11,0xd2]      
vmovups.s %zmm2, %zmm2 {%k2} 

// CHECK: vmovups.s %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x11,0xd2]     
vmovups.s %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmovups %zmm2, 4096(%edx,%eax) 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x11,0x54,0x02,0x40]       
vmovups %zmm2, 4096(%edx,%eax) 

// CHECK: vmovups %zmm2, 4096(%edx,%eax) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x11,0x54,0x02,0x40]      
vmovups %zmm2, 4096(%edx,%eax) {%k2} 

// CHECK: vmovups %zmm2, -485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x11,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vmovups %zmm2, -485498096(%edx,%eax,4) 

// CHECK: vmovups %zmm2, 485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x11,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vmovups %zmm2, 485498096(%edx,%eax,4) 

// CHECK: vmovups %zmm2, -485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x11,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmovups %zmm2, -485498096(%edx,%eax,4) {%k2} 

// CHECK: vmovups %zmm2, 485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x11,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmovups %zmm2, 485498096(%edx,%eax,4) {%k2} 

// CHECK: vmovups %zmm2, 485498096(%edx) 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x11,0x92,0xf0,0x1c,0xf0,0x1c]       
vmovups %zmm2, 485498096(%edx) 

// CHECK: vmovups %zmm2, 485498096(%edx) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x11,0x92,0xf0,0x1c,0xf0,0x1c]      
vmovups %zmm2, 485498096(%edx) {%k2} 

// CHECK: vmovups %zmm2, 485498096 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x11,0x15,0xf0,0x1c,0xf0,0x1c]       
vmovups %zmm2, 485498096 

// CHECK: vmovups %zmm2, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x11,0x15,0xf0,0x1c,0xf0,0x1c]      
vmovups %zmm2, 485498096 {%k2} 

// CHECK: vmovups %zmm2, (%edx) 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x11,0x12]       
vmovups %zmm2, (%edx) 

// CHECK: vmovups %zmm2, (%edx) {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x11,0x12]      
vmovups %zmm2, (%edx) {%k2} 

// CHECK: vmovups %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x7c,0x48,0x10,0xd2]       
vmovups %zmm2, %zmm2 

// CHECK: vmovups %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x7c,0x4a,0x10,0xd2]      
vmovups %zmm2, %zmm2 {%k2} 

// CHECK: vmovups %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x7c,0xca,0x10,0xd2]     
vmovups %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulpd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x59,0x54,0x02,0x40]      
vmulpd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vmulpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x59,0x54,0x02,0x40]     
vmulpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vmulpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x59,0x54,0x02,0x40]    
vmulpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulpd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x59,0x15,0xf0,0x1c,0xf0,0x1c]      
vmulpd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vmulpd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x59,0x15,0xf0,0x1c,0xf0,0x1c]     
vmulpd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vmulpd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x59,0x15,0xf0,0x1c,0xf0,0x1c]    
vmulpd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulpd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x59,0x92,0xf0,0x1c,0xf0,0x1c]      
vmulpd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vmulpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x59,0x92,0xf0,0x1c,0xf0,0x1c]     
vmulpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vmulpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x59,0x92,0xf0,0x1c,0xf0,0x1c]    
vmulpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x59,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmulpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vmulpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x59,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmulpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vmulpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x59,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vmulpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vmulpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x59,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vmulpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vmulpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x59,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vmulpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x59,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vmulpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulpd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x59,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmulpd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vmulpd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x59,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmulpd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vmulpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x59,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vmulpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vmulpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x59,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vmulpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vmulpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x59,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vmulpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x59,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vmulpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulpd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x59,0x92,0xf0,0x1c,0xf0,0x1c]      
vmulpd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vmulpd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x59,0x92,0xf0,0x1c,0xf0,0x1c]     
vmulpd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vmulpd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x59,0x92,0xf0,0x1c,0xf0,0x1c]    
vmulpd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulpd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x59,0x15,0xf0,0x1c,0xf0,0x1c]      
vmulpd 485498096, %zmm2, %zmm2 

// CHECK: vmulpd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x59,0x15,0xf0,0x1c,0xf0,0x1c]     
vmulpd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vmulpd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x59,0x15,0xf0,0x1c,0xf0,0x1c]    
vmulpd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x59,0x54,0x02,0x40]      
vmulpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vmulpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x59,0x54,0x02,0x40]     
vmulpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vmulpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x59,0x54,0x02,0x40]    
vmulpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulpd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x59,0x12]      
vmulpd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vmulpd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x59,0x12]     
vmulpd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vmulpd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x59,0x12]    
vmulpd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulpd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x59,0x12]      
vmulpd (%edx), %zmm2, %zmm2 

// CHECK: vmulpd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x59,0x12]     
vmulpd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vmulpd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x59,0x12]    
vmulpd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulpd {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x38,0x59,0xd2]     
vmulpd {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vmulpd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x3a,0x59,0xd2]    
vmulpd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vmulpd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xba,0x59,0xd2]   
vmulpd {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulpd {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x18,0x59,0xd2]     
vmulpd {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vmulpd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x1a,0x59,0xd2]    
vmulpd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vmulpd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0x9a,0x59,0xd2]   
vmulpd {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulpd {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0x59,0xd2]     
vmulpd {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vmulpd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0x59,0xd2]    
vmulpd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vmulpd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0x59,0xd2]   
vmulpd {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulpd {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x78,0x59,0xd2]     
vmulpd {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vmulpd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x7a,0x59,0xd2]    
vmulpd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vmulpd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xfa,0x59,0xd2]   
vmulpd {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulpd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0x59,0xd2]      
vmulpd %zmm2, %zmm2, %zmm2 

// CHECK: vmulpd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0x59,0xd2]     
vmulpd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vmulpd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0x59,0xd2]    
vmulpd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x59,0x54,0x02,0x40]      
vmulps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vmulps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x59,0x54,0x02,0x40]     
vmulps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vmulps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x59,0x54,0x02,0x40]    
vmulps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x59,0x54,0x02,0x40]      
vmulps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vmulps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x59,0x54,0x02,0x40]     
vmulps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vmulps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x59,0x54,0x02,0x40]    
vmulps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x59,0x15,0xf0,0x1c,0xf0,0x1c]      
vmulps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vmulps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x59,0x15,0xf0,0x1c,0xf0,0x1c]     
vmulps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vmulps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x59,0x15,0xf0,0x1c,0xf0,0x1c]    
vmulps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x59,0x92,0xf0,0x1c,0xf0,0x1c]      
vmulps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vmulps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x59,0x92,0xf0,0x1c,0xf0,0x1c]     
vmulps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vmulps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x59,0x92,0xf0,0x1c,0xf0,0x1c]    
vmulps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x59,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmulps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vmulps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x59,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmulps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vmulps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x59,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vmulps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vmulps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x59,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vmulps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vmulps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x59,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vmulps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x59,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vmulps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x59,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vmulps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vmulps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x59,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vmulps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vmulps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x59,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vmulps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vmulps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x59,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vmulps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vmulps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x59,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vmulps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x59,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vmulps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x59,0x92,0xf0,0x1c,0xf0,0x1c]      
vmulps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vmulps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x59,0x92,0xf0,0x1c,0xf0,0x1c]     
vmulps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vmulps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x59,0x92,0xf0,0x1c,0xf0,0x1c]    
vmulps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x59,0x15,0xf0,0x1c,0xf0,0x1c]      
vmulps 485498096, %zmm2, %zmm2 

// CHECK: vmulps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x59,0x15,0xf0,0x1c,0xf0,0x1c]     
vmulps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vmulps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x59,0x15,0xf0,0x1c,0xf0,0x1c]    
vmulps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x59,0x12]      
vmulps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vmulps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x59,0x12]     
vmulps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vmulps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x59,0x12]    
vmulps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x59,0x12]      
vmulps (%edx), %zmm2, %zmm2 

// CHECK: vmulps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x59,0x12]     
vmulps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vmulps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x59,0x12]    
vmulps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulps {rd-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x38,0x59,0xd2]     
vmulps {rd-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vmulps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x3a,0x59,0xd2]    
vmulps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vmulps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xba,0x59,0xd2]   
vmulps {rd-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulps {rn-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x18,0x59,0xd2]     
vmulps {rn-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vmulps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x1a,0x59,0xd2]    
vmulps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vmulps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x9a,0x59,0xd2]   
vmulps {rn-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulps {ru-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x58,0x59,0xd2]     
vmulps {ru-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vmulps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x5a,0x59,0xd2]    
vmulps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vmulps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xda,0x59,0xd2]   
vmulps {ru-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulps {rz-sae}, %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x78,0x59,0xd2]     
vmulps {rz-sae}, %zmm2, %zmm2, %zmm2 

// CHECK: vmulps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x7a,0x59,0xd2]    
vmulps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vmulps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xfa,0x59,0xd2]   
vmulps {rz-sae}, %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vmulps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6c,0x48,0x59,0xd2]      
vmulps %zmm2, %zmm2, %zmm2 

// CHECK: vmulps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6c,0x4a,0x59,0xd2]     
vmulps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vmulps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6c,0xca,0x59,0xd2]    
vmulps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpabsd 256(%edx,%eax){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x58,0x1e,0x54,0x02,0x40]       
vpabsd 256(%edx,%eax){1to16}, %zmm2 

// CHECK: vpabsd 256(%edx,%eax){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x5a,0x1e,0x54,0x02,0x40]      
vpabsd 256(%edx,%eax){1to16}, %zmm2 {%k2} 

// CHECK: vpabsd 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xda,0x1e,0x54,0x02,0x40]     
vpabsd 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 

// CHECK: vpabsd 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x1e,0x54,0x02,0x40]       
vpabsd 4096(%edx,%eax), %zmm2 

// CHECK: vpabsd 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x1e,0x54,0x02,0x40]      
vpabsd 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vpabsd 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x1e,0x54,0x02,0x40]     
vpabsd 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vpabsd 485498096{1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x58,0x1e,0x15,0xf0,0x1c,0xf0,0x1c]       
vpabsd 485498096{1to16}, %zmm2 

// CHECK: vpabsd 485498096{1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x5a,0x1e,0x15,0xf0,0x1c,0xf0,0x1c]      
vpabsd 485498096{1to16}, %zmm2 {%k2} 

// CHECK: vpabsd 485498096{1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xda,0x1e,0x15,0xf0,0x1c,0xf0,0x1c]     
vpabsd 485498096{1to16}, %zmm2 {%k2} {z} 

// CHECK: vpabsd 485498096(%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x58,0x1e,0x92,0xf0,0x1c,0xf0,0x1c]       
vpabsd 485498096(%edx){1to16}, %zmm2 

// CHECK: vpabsd 485498096(%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x5a,0x1e,0x92,0xf0,0x1c,0xf0,0x1c]      
vpabsd 485498096(%edx){1to16}, %zmm2 {%k2} 

// CHECK: vpabsd 485498096(%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xda,0x1e,0x92,0xf0,0x1c,0xf0,0x1c]     
vpabsd 485498096(%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vpabsd -485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x58,0x1e,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vpabsd -485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vpabsd 485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x58,0x1e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vpabsd 485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vpabsd -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x5a,0x1e,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpabsd -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vpabsd 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x5a,0x1e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpabsd 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vpabsd -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xda,0x1e,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpabsd -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vpabsd 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xda,0x1e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpabsd 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vpabsd -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x1e,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vpabsd -485498096(%edx,%eax,4), %zmm2 

// CHECK: vpabsd 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x1e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vpabsd 485498096(%edx,%eax,4), %zmm2 

// CHECK: vpabsd -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x1e,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpabsd -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpabsd 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x1e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpabsd 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpabsd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x1e,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpabsd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpabsd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x1e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpabsd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpabsd 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x1e,0x92,0xf0,0x1c,0xf0,0x1c]       
vpabsd 485498096(%edx), %zmm2 

// CHECK: vpabsd 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x1e,0x92,0xf0,0x1c,0xf0,0x1c]      
vpabsd 485498096(%edx), %zmm2 {%k2} 

// CHECK: vpabsd 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x1e,0x92,0xf0,0x1c,0xf0,0x1c]     
vpabsd 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vpabsd 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x1e,0x15,0xf0,0x1c,0xf0,0x1c]       
vpabsd 485498096, %zmm2 

// CHECK: vpabsd 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x1e,0x15,0xf0,0x1c,0xf0,0x1c]      
vpabsd 485498096, %zmm2 {%k2} 

// CHECK: vpabsd 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x1e,0x15,0xf0,0x1c,0xf0,0x1c]     
vpabsd 485498096, %zmm2 {%k2} {z} 

// CHECK: vpabsd (%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x58,0x1e,0x12]       
vpabsd (%edx){1to16}, %zmm2 

// CHECK: vpabsd (%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x5a,0x1e,0x12]      
vpabsd (%edx){1to16}, %zmm2 {%k2} 

// CHECK: vpabsd (%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xda,0x1e,0x12]     
vpabsd (%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vpabsd (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x1e,0x12]       
vpabsd (%edx), %zmm2 

// CHECK: vpabsd (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x1e,0x12]      
vpabsd (%edx), %zmm2 {%k2} 

// CHECK: vpabsd (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x1e,0x12]     
vpabsd (%edx), %zmm2 {%k2} {z} 

// CHECK: vpabsd %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x1e,0xd2]       
vpabsd %zmm2, %zmm2 

// CHECK: vpabsd %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x1e,0xd2]      
vpabsd %zmm2, %zmm2 {%k2} 

// CHECK: vpabsd %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x1e,0xd2]     
vpabsd %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpabsq 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x1f,0x54,0x02,0x40]       
vpabsq 4096(%edx,%eax), %zmm2 

// CHECK: vpabsq 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x1f,0x54,0x02,0x40]      
vpabsq 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vpabsq 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x1f,0x54,0x02,0x40]     
vpabsq 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vpabsq 485498096{1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x58,0x1f,0x15,0xf0,0x1c,0xf0,0x1c]       
vpabsq 485498096{1to8}, %zmm2 

// CHECK: vpabsq 485498096{1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x5a,0x1f,0x15,0xf0,0x1c,0xf0,0x1c]      
vpabsq 485498096{1to8}, %zmm2 {%k2} 

// CHECK: vpabsq 485498096{1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xda,0x1f,0x15,0xf0,0x1c,0xf0,0x1c]     
vpabsq 485498096{1to8}, %zmm2 {%k2} {z} 

// CHECK: vpabsq 485498096(%edx){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x58,0x1f,0x92,0xf0,0x1c,0xf0,0x1c]       
vpabsq 485498096(%edx){1to8}, %zmm2 

// CHECK: vpabsq 485498096(%edx){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x5a,0x1f,0x92,0xf0,0x1c,0xf0,0x1c]      
vpabsq 485498096(%edx){1to8}, %zmm2 {%k2} 

// CHECK: vpabsq 485498096(%edx){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xda,0x1f,0x92,0xf0,0x1c,0xf0,0x1c]     
vpabsq 485498096(%edx){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpabsq -485498096(%edx,%eax,4){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x58,0x1f,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vpabsq -485498096(%edx,%eax,4){1to8}, %zmm2 

// CHECK: vpabsq 485498096(%edx,%eax,4){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x58,0x1f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vpabsq 485498096(%edx,%eax,4){1to8}, %zmm2 

// CHECK: vpabsq -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x5a,0x1f,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpabsq -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 

// CHECK: vpabsq 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x5a,0x1f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpabsq 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 

// CHECK: vpabsq -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xda,0x1f,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpabsq -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpabsq 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xda,0x1f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpabsq 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpabsq -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x1f,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vpabsq -485498096(%edx,%eax,4), %zmm2 

// CHECK: vpabsq 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x1f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vpabsq 485498096(%edx,%eax,4), %zmm2 

// CHECK: vpabsq -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x1f,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpabsq -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpabsq 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x1f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpabsq 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpabsq -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x1f,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpabsq -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpabsq 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x1f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpabsq 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpabsq 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x1f,0x92,0xf0,0x1c,0xf0,0x1c]       
vpabsq 485498096(%edx), %zmm2 

// CHECK: vpabsq 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x1f,0x92,0xf0,0x1c,0xf0,0x1c]      
vpabsq 485498096(%edx), %zmm2 {%k2} 

// CHECK: vpabsq 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x1f,0x92,0xf0,0x1c,0xf0,0x1c]     
vpabsq 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vpabsq 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x1f,0x15,0xf0,0x1c,0xf0,0x1c]       
vpabsq 485498096, %zmm2 

// CHECK: vpabsq 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x1f,0x15,0xf0,0x1c,0xf0,0x1c]      
vpabsq 485498096, %zmm2 {%k2} 

// CHECK: vpabsq 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x1f,0x15,0xf0,0x1c,0xf0,0x1c]     
vpabsq 485498096, %zmm2 {%k2} {z} 

// CHECK: vpabsq 512(%edx,%eax){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x58,0x1f,0x54,0x02,0x40]       
vpabsq 512(%edx,%eax){1to8}, %zmm2 

// CHECK: vpabsq 512(%edx,%eax){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x5a,0x1f,0x54,0x02,0x40]      
vpabsq 512(%edx,%eax){1to8}, %zmm2 {%k2} 

// CHECK: vpabsq 512(%edx,%eax){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xda,0x1f,0x54,0x02,0x40]     
vpabsq 512(%edx,%eax){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpabsq (%edx){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x58,0x1f,0x12]       
vpabsq (%edx){1to8}, %zmm2 

// CHECK: vpabsq (%edx){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x5a,0x1f,0x12]      
vpabsq (%edx){1to8}, %zmm2 {%k2} 

// CHECK: vpabsq (%edx){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xda,0x1f,0x12]     
vpabsq (%edx){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpabsq (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x1f,0x12]       
vpabsq (%edx), %zmm2 

// CHECK: vpabsq (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x1f,0x12]      
vpabsq (%edx), %zmm2 {%k2} 

// CHECK: vpabsq (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x1f,0x12]     
vpabsq (%edx), %zmm2 {%k2} {z} 

// CHECK: vpabsq %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x1f,0xd2]       
vpabsq %zmm2, %zmm2 

// CHECK: vpabsq %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x1f,0xd2]      
vpabsq %zmm2, %zmm2 {%k2} 

// CHECK: vpabsq %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x1f,0xd2]     
vpabsq %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddd 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0xfe,0x54,0x02,0x40]      
vpaddd 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vpaddd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0xfe,0x54,0x02,0x40]     
vpaddd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpaddd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xda,0xfe,0x54,0x02,0x40]    
vpaddd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xfe,0x54,0x02,0x40]      
vpaddd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpaddd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xfe,0x54,0x02,0x40]     
vpaddd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpaddd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xfe,0x54,0x02,0x40]    
vpaddd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddd 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0xfe,0x15,0xf0,0x1c,0xf0,0x1c]      
vpaddd 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vpaddd 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0xfe,0x15,0xf0,0x1c,0xf0,0x1c]     
vpaddd 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpaddd 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xda,0xfe,0x15,0xf0,0x1c,0xf0,0x1c]    
vpaddd 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddd 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0xfe,0x92,0xf0,0x1c,0xf0,0x1c]      
vpaddd 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpaddd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0xfe,0x92,0xf0,0x1c,0xf0,0x1c]     
vpaddd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpaddd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xda,0xfe,0x92,0xf0,0x1c,0xf0,0x1c]    
vpaddd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0xfe,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpaddd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpaddd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0xfe,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpaddd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpaddd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0xfe,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpaddd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpaddd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0xfe,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpaddd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpaddd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xda,0xfe,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpaddd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xda,0xfe,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpaddd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xfe,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpaddd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpaddd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xfe,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpaddd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpaddd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xfe,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpaddd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpaddd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xfe,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpaddd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpaddd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xfe,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpaddd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xfe,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpaddd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xfe,0x92,0xf0,0x1c,0xf0,0x1c]      
vpaddd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpaddd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xfe,0x92,0xf0,0x1c,0xf0,0x1c]     
vpaddd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpaddd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xfe,0x92,0xf0,0x1c,0xf0,0x1c]    
vpaddd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xfe,0x15,0xf0,0x1c,0xf0,0x1c]      
vpaddd 485498096, %zmm2, %zmm2 

// CHECK: vpaddd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xfe,0x15,0xf0,0x1c,0xf0,0x1c]     
vpaddd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpaddd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xfe,0x15,0xf0,0x1c,0xf0,0x1c]    
vpaddd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddd (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0xfe,0x12]      
vpaddd (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpaddd (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0xfe,0x12]     
vpaddd (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpaddd (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xda,0xfe,0x12]    
vpaddd (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xfe,0x12]      
vpaddd (%edx), %zmm2, %zmm2 

// CHECK: vpaddd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xfe,0x12]     
vpaddd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpaddd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xfe,0x12]    
vpaddd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xfe,0xd2]      
vpaddd %zmm2, %zmm2, %zmm2 

// CHECK: vpaddd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xfe,0xd2]     
vpaddd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpaddd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xfe,0xd2]    
vpaddd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddq 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xd4,0x54,0x02,0x40]      
vpaddq 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpaddq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xd4,0x54,0x02,0x40]     
vpaddq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpaddq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xd4,0x54,0x02,0x40]    
vpaddq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddq 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xd4,0x15,0xf0,0x1c,0xf0,0x1c]      
vpaddq 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vpaddq 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xd4,0x15,0xf0,0x1c,0xf0,0x1c]     
vpaddq 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpaddq 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0xd4,0x15,0xf0,0x1c,0xf0,0x1c]    
vpaddq 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddq 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xd4,0x92,0xf0,0x1c,0xf0,0x1c]      
vpaddq 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpaddq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xd4,0x92,0xf0,0x1c,0xf0,0x1c]     
vpaddq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpaddq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0xd4,0x92,0xf0,0x1c,0xf0,0x1c]    
vpaddq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xd4,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpaddq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpaddq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xd4,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpaddq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpaddq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xd4,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpaddq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpaddq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xd4,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpaddq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpaddq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0xd4,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpaddq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0xd4,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpaddq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddq -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xd4,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpaddq -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpaddq 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xd4,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpaddq 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpaddq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xd4,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpaddq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpaddq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xd4,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpaddq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpaddq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xd4,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpaddq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xd4,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpaddq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddq 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xd4,0x92,0xf0,0x1c,0xf0,0x1c]      
vpaddq 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpaddq 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xd4,0x92,0xf0,0x1c,0xf0,0x1c]     
vpaddq 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpaddq 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xd4,0x92,0xf0,0x1c,0xf0,0x1c]    
vpaddq 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddq 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xd4,0x15,0xf0,0x1c,0xf0,0x1c]      
vpaddq 485498096, %zmm2, %zmm2 

// CHECK: vpaddq 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xd4,0x15,0xf0,0x1c,0xf0,0x1c]     
vpaddq 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpaddq 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xd4,0x15,0xf0,0x1c,0xf0,0x1c]    
vpaddq 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddq 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xd4,0x54,0x02,0x40]      
vpaddq 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vpaddq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xd4,0x54,0x02,0x40]     
vpaddq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpaddq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0xd4,0x54,0x02,0x40]    
vpaddq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddq (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xd4,0x12]      
vpaddq (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpaddq (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xd4,0x12]     
vpaddq (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpaddq (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0xd4,0x12]    
vpaddq (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddq (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xd4,0x12]      
vpaddq (%edx), %zmm2, %zmm2 

// CHECK: vpaddq (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xd4,0x12]     
vpaddq (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpaddq (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xd4,0x12]    
vpaddq (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpaddq %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xd4,0xd2]      
vpaddq %zmm2, %zmm2, %zmm2 

// CHECK: vpaddq %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xd4,0xd2]     
vpaddq %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpaddq %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xd4,0xd2]    
vpaddq %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandd 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0xdb,0x54,0x02,0x40]      
vpandd 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vpandd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0xdb,0x54,0x02,0x40]     
vpandd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xda,0xdb,0x54,0x02,0x40]    
vpandd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xdb,0x54,0x02,0x40]      
vpandd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpandd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xdb,0x54,0x02,0x40]     
vpandd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpandd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xdb,0x54,0x02,0x40]    
vpandd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandd 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0xdb,0x15,0xf0,0x1c,0xf0,0x1c]      
vpandd 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vpandd 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0xdb,0x15,0xf0,0x1c,0xf0,0x1c]     
vpandd 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandd 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xda,0xdb,0x15,0xf0,0x1c,0xf0,0x1c]    
vpandd 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandd 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0xdb,0x92,0xf0,0x1c,0xf0,0x1c]      
vpandd 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpandd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0xdb,0x92,0xf0,0x1c,0xf0,0x1c]     
vpandd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xda,0xdb,0x92,0xf0,0x1c,0xf0,0x1c]    
vpandd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0xdb,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpandd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpandd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0xdb,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpandd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpandd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0xdb,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpandd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0xdb,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpandd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xda,0xdb,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpandd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xda,0xdb,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpandd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xdb,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpandd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpandd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xdb,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpandd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpandd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xdb,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpandd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpandd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xdb,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpandd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpandd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xdb,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpandd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xdb,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpandd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xdb,0x92,0xf0,0x1c,0xf0,0x1c]      
vpandd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpandd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xdb,0x92,0xf0,0x1c,0xf0,0x1c]     
vpandd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpandd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xdb,0x92,0xf0,0x1c,0xf0,0x1c]    
vpandd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xdb,0x15,0xf0,0x1c,0xf0,0x1c]      
vpandd 485498096, %zmm2, %zmm2 

// CHECK: vpandd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xdb,0x15,0xf0,0x1c,0xf0,0x1c]     
vpandd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpandd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xdb,0x15,0xf0,0x1c,0xf0,0x1c]    
vpandd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandd (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0xdb,0x12]      
vpandd (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpandd (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0xdb,0x12]     
vpandd (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandd (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xda,0xdb,0x12]    
vpandd (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xdb,0x12]      
vpandd (%edx), %zmm2, %zmm2 

// CHECK: vpandd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xdb,0x12]     
vpandd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpandd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xdb,0x12]    
vpandd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xdb,0xd2]      
vpandd %zmm2, %zmm2, %zmm2 

// CHECK: vpandd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xdb,0xd2]     
vpandd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpandd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xdb,0xd2]    
vpandd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnd 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0xdf,0x54,0x02,0x40]      
vpandnd 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vpandnd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0xdf,0x54,0x02,0x40]     
vpandnd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandnd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xda,0xdf,0x54,0x02,0x40]    
vpandnd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xdf,0x54,0x02,0x40]      
vpandnd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpandnd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xdf,0x54,0x02,0x40]     
vpandnd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpandnd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xdf,0x54,0x02,0x40]    
vpandnd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnd 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0xdf,0x15,0xf0,0x1c,0xf0,0x1c]      
vpandnd 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vpandnd 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0xdf,0x15,0xf0,0x1c,0xf0,0x1c]     
vpandnd 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandnd 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xda,0xdf,0x15,0xf0,0x1c,0xf0,0x1c]    
vpandnd 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnd 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0xdf,0x92,0xf0,0x1c,0xf0,0x1c]      
vpandnd 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpandnd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0xdf,0x92,0xf0,0x1c,0xf0,0x1c]     
vpandnd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandnd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xda,0xdf,0x92,0xf0,0x1c,0xf0,0x1c]    
vpandnd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0xdf,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpandnd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpandnd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0xdf,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpandnd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpandnd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0xdf,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpandnd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandnd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0xdf,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpandnd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandnd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xda,0xdf,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpandnd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xda,0xdf,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpandnd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xdf,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpandnd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpandnd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xdf,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpandnd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpandnd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xdf,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpandnd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpandnd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xdf,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpandnd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpandnd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xdf,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpandnd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xdf,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpandnd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xdf,0x92,0xf0,0x1c,0xf0,0x1c]      
vpandnd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpandnd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xdf,0x92,0xf0,0x1c,0xf0,0x1c]     
vpandnd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpandnd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xdf,0x92,0xf0,0x1c,0xf0,0x1c]    
vpandnd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xdf,0x15,0xf0,0x1c,0xf0,0x1c]      
vpandnd 485498096, %zmm2, %zmm2 

// CHECK: vpandnd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xdf,0x15,0xf0,0x1c,0xf0,0x1c]     
vpandnd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpandnd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xdf,0x15,0xf0,0x1c,0xf0,0x1c]    
vpandnd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnd (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0xdf,0x12]      
vpandnd (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpandnd (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0xdf,0x12]     
vpandnd (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandnd (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xda,0xdf,0x12]    
vpandnd (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xdf,0x12]      
vpandnd (%edx), %zmm2, %zmm2 

// CHECK: vpandnd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xdf,0x12]     
vpandnd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpandnd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xdf,0x12]    
vpandnd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0xdf,0xd2]      
vpandnd %zmm2, %zmm2, %zmm2 

// CHECK: vpandnd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0xdf,0xd2]     
vpandnd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpandnd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0x6d,0xca,0xdf,0xd2]    
vpandnd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnq 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xdf,0x54,0x02,0x40]      
vpandnq 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpandnq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xdf,0x54,0x02,0x40]     
vpandnq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpandnq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xdf,0x54,0x02,0x40]    
vpandnq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnq 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xdf,0x15,0xf0,0x1c,0xf0,0x1c]      
vpandnq 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vpandnq 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xdf,0x15,0xf0,0x1c,0xf0,0x1c]     
vpandnq 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandnq 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0xdf,0x15,0xf0,0x1c,0xf0,0x1c]    
vpandnq 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnq 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xdf,0x92,0xf0,0x1c,0xf0,0x1c]      
vpandnq 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpandnq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xdf,0x92,0xf0,0x1c,0xf0,0x1c]     
vpandnq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandnq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0xdf,0x92,0xf0,0x1c,0xf0,0x1c]    
vpandnq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xdf,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpandnq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpandnq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xdf,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpandnq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpandnq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xdf,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpandnq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandnq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xdf,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpandnq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandnq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0xdf,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpandnq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0xdf,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpandnq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnq -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xdf,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpandnq -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpandnq 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xdf,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpandnq 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpandnq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xdf,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpandnq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpandnq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xdf,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpandnq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpandnq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xdf,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpandnq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xdf,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpandnq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnq 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xdf,0x92,0xf0,0x1c,0xf0,0x1c]      
vpandnq 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpandnq 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xdf,0x92,0xf0,0x1c,0xf0,0x1c]     
vpandnq 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpandnq 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xdf,0x92,0xf0,0x1c,0xf0,0x1c]    
vpandnq 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnq 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xdf,0x15,0xf0,0x1c,0xf0,0x1c]      
vpandnq 485498096, %zmm2, %zmm2 

// CHECK: vpandnq 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xdf,0x15,0xf0,0x1c,0xf0,0x1c]     
vpandnq 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpandnq 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xdf,0x15,0xf0,0x1c,0xf0,0x1c]    
vpandnq 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnq 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xdf,0x54,0x02,0x40]      
vpandnq 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vpandnq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xdf,0x54,0x02,0x40]     
vpandnq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandnq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0xdf,0x54,0x02,0x40]    
vpandnq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnq (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xdf,0x12]      
vpandnq (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpandnq (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xdf,0x12]     
vpandnq (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandnq (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0xdf,0x12]    
vpandnq (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnq (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xdf,0x12]      
vpandnq (%edx), %zmm2, %zmm2 

// CHECK: vpandnq (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xdf,0x12]     
vpandnq (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpandnq (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xdf,0x12]    
vpandnq (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandnq %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xdf,0xd2]      
vpandnq %zmm2, %zmm2, %zmm2 

// CHECK: vpandnq %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xdf,0xd2]     
vpandnq %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpandnq %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xdf,0xd2]    
vpandnq %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandq 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xdb,0x54,0x02,0x40]      
vpandq 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpandq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xdb,0x54,0x02,0x40]     
vpandq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpandq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xdb,0x54,0x02,0x40]    
vpandq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandq 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xdb,0x15,0xf0,0x1c,0xf0,0x1c]      
vpandq 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vpandq 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xdb,0x15,0xf0,0x1c,0xf0,0x1c]     
vpandq 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandq 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0xdb,0x15,0xf0,0x1c,0xf0,0x1c]    
vpandq 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandq 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xdb,0x92,0xf0,0x1c,0xf0,0x1c]      
vpandq 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpandq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xdb,0x92,0xf0,0x1c,0xf0,0x1c]     
vpandq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0xdb,0x92,0xf0,0x1c,0xf0,0x1c]    
vpandq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xdb,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpandq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpandq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xdb,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpandq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpandq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xdb,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpandq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xdb,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpandq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0xdb,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpandq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0xdb,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpandq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandq -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xdb,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpandq -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpandq 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xdb,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpandq 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpandq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xdb,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpandq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpandq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xdb,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpandq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpandq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xdb,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpandq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xdb,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpandq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandq 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xdb,0x92,0xf0,0x1c,0xf0,0x1c]      
vpandq 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpandq 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xdb,0x92,0xf0,0x1c,0xf0,0x1c]     
vpandq 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpandq 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xdb,0x92,0xf0,0x1c,0xf0,0x1c]    
vpandq 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandq 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xdb,0x15,0xf0,0x1c,0xf0,0x1c]      
vpandq 485498096, %zmm2, %zmm2 

// CHECK: vpandq 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xdb,0x15,0xf0,0x1c,0xf0,0x1c]     
vpandq 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpandq 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xdb,0x15,0xf0,0x1c,0xf0,0x1c]    
vpandq 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandq 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xdb,0x54,0x02,0x40]      
vpandq 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vpandq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xdb,0x54,0x02,0x40]     
vpandq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0xdb,0x54,0x02,0x40]    
vpandq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandq (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x58,0xdb,0x12]      
vpandq (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpandq (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x5a,0xdb,0x12]     
vpandq (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpandq (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xda,0xdb,0x12]    
vpandq (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandq (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xdb,0x12]      
vpandq (%edx), %zmm2, %zmm2 

// CHECK: vpandq (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xdb,0x12]     
vpandq (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpandq (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xdb,0x12]    
vpandq (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpandq %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf1,0xed,0x48,0xdb,0xd2]      
vpandq %zmm2, %zmm2, %zmm2 

// CHECK: vpandq %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0xed,0x4a,0xdb,0xd2]     
vpandq %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpandq %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf1,0xed,0xca,0xdb,0xd2]    
vpandq %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpblendmd 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x64,0x54,0x02,0x40]      
vpblendmd 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vpblendmd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x64,0x54,0x02,0x40]     
vpblendmd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x64,0x54,0x02,0x40]     
vpblendmd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vpblendmd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x64,0x54,0x02,0x40]      
vpblendmd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpblendmd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x64,0x54,0x02,0x40]     
vpblendmd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x64,0x54,0x02,0x40]    
vpblendmd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpblendmd 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x64,0x15,0xf0,0x1c,0xf0,0x1c]      
vpblendmd 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vpblendmd 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x64,0x15,0xf0,0x1c,0xf0,0x1c]     
vpblendmd 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmd 485498096{1to16}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x64,0x15,0xf0,0x1c,0xf0,0x1c]     
vpblendmd 485498096{1to16}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vpblendmd 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x64,0x92,0xf0,0x1c,0xf0,0x1c]      
vpblendmd 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpblendmd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x64,0x92,0xf0,0x1c,0xf0,0x1c]     
vpblendmd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x64,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpblendmd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpblendmd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x64,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpblendmd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpblendmd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x64,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpblendmd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x64,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpblendmd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vpblendmd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x64,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpblendmd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x64,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpblendmd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vpblendmd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x64,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpblendmd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpblendmd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x64,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpblendmd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpblendmd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x64,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpblendmd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x64,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpblendmd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x64,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpblendmd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpblendmd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x64,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpblendmd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpblendmd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x64,0x92,0xf0,0x1c,0xf0,0x1c]      
vpblendmd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpblendmd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x64,0x92,0xf0,0x1c,0xf0,0x1c]     
vpblendmd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x64,0x92,0xf0,0x1c,0xf0,0x1c]    
vpblendmd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpblendmd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x64,0x15,0xf0,0x1c,0xf0,0x1c]      
vpblendmd 485498096, %zmm2, %zmm2 

// CHECK: vpblendmd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x64,0x15,0xf0,0x1c,0xf0,0x1c]     
vpblendmd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x64,0x15,0xf0,0x1c,0xf0,0x1c]    
vpblendmd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpblendmd (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x64,0x12]      
vpblendmd (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpblendmd (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x64,0x12]     
vpblendmd (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmd (%edx){1to16}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x64,0x12]     
vpblendmd (%edx){1to16}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vpblendmd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x64,0x12]      
vpblendmd (%edx), %zmm2, %zmm2 

// CHECK: vpblendmd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x64,0x12]     
vpblendmd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x64,0x12]    
vpblendmd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpblendmd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x64,0xd2]      
vpblendmd %zmm2, %zmm2, %zmm2 

// CHECK: vpblendmd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x64,0xd2]     
vpblendmd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x64,0xd2]    
vpblendmd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpblendmq 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x64,0x54,0x02,0x40]      
vpblendmq 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpblendmq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x64,0x54,0x02,0x40]     
vpblendmq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x64,0x54,0x02,0x40]    
vpblendmq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpblendmq 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x64,0x15,0xf0,0x1c,0xf0,0x1c]      
vpblendmq 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vpblendmq 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x64,0x15,0xf0,0x1c,0xf0,0x1c]     
vpblendmq 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmq 485498096{1to8}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x64,0x15,0xf0,0x1c,0xf0,0x1c]     
vpblendmq 485498096{1to8}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vpblendmq 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x64,0x92,0xf0,0x1c,0xf0,0x1c]      
vpblendmq 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpblendmq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x64,0x92,0xf0,0x1c,0xf0,0x1c]     
vpblendmq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x64,0x92,0xf0,0x1c,0xf0,0x1c]     
vpblendmq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vpblendmq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x64,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpblendmq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpblendmq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x64,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpblendmq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpblendmq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x64,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpblendmq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x64,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpblendmq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vpblendmq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x64,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpblendmq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x64,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpblendmq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vpblendmq -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x64,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpblendmq -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpblendmq 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x64,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpblendmq 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpblendmq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x64,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpblendmq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x64,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpblendmq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x64,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpblendmq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpblendmq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x64,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpblendmq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpblendmq 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x64,0x92,0xf0,0x1c,0xf0,0x1c]      
vpblendmq 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpblendmq 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x64,0x92,0xf0,0x1c,0xf0,0x1c]     
vpblendmq 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmq 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x64,0x92,0xf0,0x1c,0xf0,0x1c]    
vpblendmq 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpblendmq 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x64,0x15,0xf0,0x1c,0xf0,0x1c]      
vpblendmq 485498096, %zmm2, %zmm2 

// CHECK: vpblendmq 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x64,0x15,0xf0,0x1c,0xf0,0x1c]     
vpblendmq 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmq 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x64,0x15,0xf0,0x1c,0xf0,0x1c]    
vpblendmq 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpblendmq 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x64,0x54,0x02,0x40]      
vpblendmq 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vpblendmq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x64,0x54,0x02,0x40]     
vpblendmq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x64,0x54,0x02,0x40]     
vpblendmq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vpblendmq (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x64,0x12]      
vpblendmq (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpblendmq (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x64,0x12]     
vpblendmq (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmq (%edx){1to8}, %zmm2, %zmm2 {%k2} {z}
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x64,0x12]     
vpblendmq (%edx){1to8}, %zmm2, %zmm2 {%k2} {z}

// CHECK: vpblendmq (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x64,0x12]      
vpblendmq (%edx), %zmm2, %zmm2 

// CHECK: vpblendmq (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x64,0x12]     
vpblendmq (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmq (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x64,0x12]    
vpblendmq (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpblendmq %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x64,0xd2]      
vpblendmq %zmm2, %zmm2, %zmm2 

// CHECK: vpblendmq %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x64,0xd2]     
vpblendmq %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpblendmq %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x64,0xd2]    
vpblendmq %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpbroadcastd 256(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x58,0x54,0x02,0x40]       
vpbroadcastd 256(%edx,%eax), %zmm2 

// CHECK: vpbroadcastd 256(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x58,0x54,0x02,0x40]      
vpbroadcastd 256(%edx,%eax), %zmm2 {%k2} 

// CHECK: vpbroadcastd 256(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x58,0x54,0x02,0x40]     
vpbroadcastd 256(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vpbroadcastd -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x58,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vpbroadcastd -485498096(%edx,%eax,4), %zmm2 

// CHECK: vpbroadcastd 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x58,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vpbroadcastd 485498096(%edx,%eax,4), %zmm2 

// CHECK: vpbroadcastd -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x58,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpbroadcastd -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpbroadcastd 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x58,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpbroadcastd 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpbroadcastd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x58,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpbroadcastd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpbroadcastd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x58,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpbroadcastd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpbroadcastd 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x58,0x92,0xf0,0x1c,0xf0,0x1c]       
vpbroadcastd 485498096(%edx), %zmm2 

// CHECK: vpbroadcastd 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x58,0x92,0xf0,0x1c,0xf0,0x1c]      
vpbroadcastd 485498096(%edx), %zmm2 {%k2} 

// CHECK: vpbroadcastd 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x58,0x92,0xf0,0x1c,0xf0,0x1c]     
vpbroadcastd 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vpbroadcastd 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x58,0x15,0xf0,0x1c,0xf0,0x1c]       
vpbroadcastd 485498096, %zmm2 

// CHECK: vpbroadcastd 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x58,0x15,0xf0,0x1c,0xf0,0x1c]      
vpbroadcastd 485498096, %zmm2 {%k2} 

// CHECK: vpbroadcastd 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x58,0x15,0xf0,0x1c,0xf0,0x1c]     
vpbroadcastd 485498096, %zmm2 {%k2} {z} 

// CHECK: vpbroadcastd (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x58,0x12]       
vpbroadcastd (%edx), %zmm2 

// CHECK: vpbroadcastd (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x58,0x12]      
vpbroadcastd (%edx), %zmm2 {%k2} 

// CHECK: vpbroadcastd (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x58,0x12]     
vpbroadcastd (%edx), %zmm2 {%k2} {z} 

// CHECK: vpbroadcastd %xmm1, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x58,0xd1]       
vpbroadcastd %xmm1, %zmm2 

// CHECK: vpbroadcastd %xmm1, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x58,0xd1]      
vpbroadcastd %xmm1, %zmm2 {%k2} 

// CHECK: vpbroadcastd %xmm1, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x58,0xd1]     
vpbroadcastd %xmm1, %zmm2 {%k2} {z} 

// CHECK: vpbroadcastq -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x59,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vpbroadcastq -485498096(%edx,%eax,4), %zmm2 

// CHECK: vpbroadcastq 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x59,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vpbroadcastq 485498096(%edx,%eax,4), %zmm2 

// CHECK: vpbroadcastq -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x59,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpbroadcastq -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpbroadcastq 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x59,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpbroadcastq 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpbroadcastq -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x59,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpbroadcastq -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpbroadcastq 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x59,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpbroadcastq 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpbroadcastq 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x59,0x92,0xf0,0x1c,0xf0,0x1c]       
vpbroadcastq 485498096(%edx), %zmm2 

// CHECK: vpbroadcastq 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x59,0x92,0xf0,0x1c,0xf0,0x1c]      
vpbroadcastq 485498096(%edx), %zmm2 {%k2} 

// CHECK: vpbroadcastq 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x59,0x92,0xf0,0x1c,0xf0,0x1c]     
vpbroadcastq 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vpbroadcastq 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x59,0x15,0xf0,0x1c,0xf0,0x1c]       
vpbroadcastq 485498096, %zmm2 

// CHECK: vpbroadcastq 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x59,0x15,0xf0,0x1c,0xf0,0x1c]      
vpbroadcastq 485498096, %zmm2 {%k2} 

// CHECK: vpbroadcastq 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x59,0x15,0xf0,0x1c,0xf0,0x1c]     
vpbroadcastq 485498096, %zmm2 {%k2} {z} 

// CHECK: vpbroadcastq 512(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x59,0x54,0x02,0x40]       
vpbroadcastq 512(%edx,%eax), %zmm2 

// CHECK: vpbroadcastq 512(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x59,0x54,0x02,0x40]      
vpbroadcastq 512(%edx,%eax), %zmm2 {%k2} 

// CHECK: vpbroadcastq 512(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x59,0x54,0x02,0x40]     
vpbroadcastq 512(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vpbroadcastq (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x59,0x12]       
vpbroadcastq (%edx), %zmm2 

// CHECK: vpbroadcastq (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x59,0x12]      
vpbroadcastq (%edx), %zmm2 {%k2} 

// CHECK: vpbroadcastq (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x59,0x12]     
vpbroadcastq (%edx), %zmm2 {%k2} {z} 

// CHECK: vpbroadcastq %xmm1, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x59,0xd1]       
vpbroadcastq %xmm1, %zmm2 

// CHECK: vpbroadcastq %xmm1, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x59,0xd1]      
vpbroadcastq %xmm1, %zmm2 {%k2} 

// CHECK: vpbroadcastq %xmm1, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x59,0xd1]     
vpbroadcastq %xmm1, %zmm2 {%k2} {z} 

// CHECK: vpcmpeqd 256(%edx,%eax){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0x76,0x54,0x02,0x40]      
vpcmpeqd 256(%edx,%eax){1to16}, %zmm2, %k2 

// CHECK: vpcmpeqd 256(%edx,%eax){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0x76,0x54,0x02,0x40]     
vpcmpeqd 256(%edx,%eax){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqd 4096(%edx,%eax), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0x76,0x54,0x02,0x40]      
vpcmpeqd 4096(%edx,%eax), %zmm2, %k2 

// CHECK: vpcmpeqd 4096(%edx,%eax), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0x76,0x54,0x02,0x40]     
vpcmpeqd 4096(%edx,%eax), %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqd 485498096{1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0x76,0x15,0xf0,0x1c,0xf0,0x1c]      
vpcmpeqd 485498096{1to16}, %zmm2, %k2 

// CHECK: vpcmpeqd 485498096{1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0x76,0x15,0xf0,0x1c,0xf0,0x1c]     
vpcmpeqd 485498096{1to16}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqd 485498096(%edx){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0x76,0x92,0xf0,0x1c,0xf0,0x1c]      
vpcmpeqd 485498096(%edx){1to16}, %zmm2, %k2 

// CHECK: vpcmpeqd 485498096(%edx){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0x76,0x92,0xf0,0x1c,0xf0,0x1c]     
vpcmpeqd 485498096(%edx){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqd -485498096(%edx,%eax,4){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0x76,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpcmpeqd -485498096(%edx,%eax,4){1to16}, %zmm2, %k2 

// CHECK: vpcmpeqd 485498096(%edx,%eax,4){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0x76,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpcmpeqd 485498096(%edx,%eax,4){1to16}, %zmm2, %k2 

// CHECK: vpcmpeqd -485498096(%edx,%eax,4){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0x76,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpcmpeqd -485498096(%edx,%eax,4){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqd 485498096(%edx,%eax,4){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0x76,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpcmpeqd 485498096(%edx,%eax,4){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqd -485498096(%edx,%eax,4), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0x76,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpcmpeqd -485498096(%edx,%eax,4), %zmm2, %k2 

// CHECK: vpcmpeqd 485498096(%edx,%eax,4), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0x76,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpcmpeqd 485498096(%edx,%eax,4), %zmm2, %k2 

// CHECK: vpcmpeqd -485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0x76,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpcmpeqd -485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqd 485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0x76,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpcmpeqd 485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqd 485498096(%edx), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0x76,0x92,0xf0,0x1c,0xf0,0x1c]      
vpcmpeqd 485498096(%edx), %zmm2, %k2 

// CHECK: vpcmpeqd 485498096(%edx), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0x76,0x92,0xf0,0x1c,0xf0,0x1c]     
vpcmpeqd 485498096(%edx), %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqd 485498096, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0x76,0x15,0xf0,0x1c,0xf0,0x1c]      
vpcmpeqd 485498096, %zmm2, %k2 

// CHECK: vpcmpeqd 485498096, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0x76,0x15,0xf0,0x1c,0xf0,0x1c]     
vpcmpeqd 485498096, %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqd (%edx){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0x76,0x12]      
vpcmpeqd (%edx){1to16}, %zmm2, %k2 

// CHECK: vpcmpeqd (%edx){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0x76,0x12]     
vpcmpeqd (%edx){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqd (%edx), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0x76,0x12]      
vpcmpeqd (%edx), %zmm2, %k2 

// CHECK: vpcmpeqd (%edx), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0x76,0x12]     
vpcmpeqd (%edx), %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqd %zmm2, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0x76,0xd2]      
vpcmpeqd %zmm2, %zmm2, %k2 

// CHECK: vpcmpeqd %zmm2, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0x76,0xd2]     
vpcmpeqd %zmm2, %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqq 4096(%edx,%eax), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x29,0x54,0x02,0x40]      
vpcmpeqq 4096(%edx,%eax), %zmm2, %k2 

// CHECK: vpcmpeqq 4096(%edx,%eax), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x29,0x54,0x02,0x40]     
vpcmpeqq 4096(%edx,%eax), %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqq 485498096{1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x29,0x15,0xf0,0x1c,0xf0,0x1c]      
vpcmpeqq 485498096{1to8}, %zmm2, %k2 

// CHECK: vpcmpeqq 485498096{1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x29,0x15,0xf0,0x1c,0xf0,0x1c]     
vpcmpeqq 485498096{1to8}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqq 485498096(%edx){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x29,0x92,0xf0,0x1c,0xf0,0x1c]      
vpcmpeqq 485498096(%edx){1to8}, %zmm2, %k2 

// CHECK: vpcmpeqq 485498096(%edx){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x29,0x92,0xf0,0x1c,0xf0,0x1c]     
vpcmpeqq 485498096(%edx){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqq -485498096(%edx,%eax,4){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x29,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpcmpeqq -485498096(%edx,%eax,4){1to8}, %zmm2, %k2 

// CHECK: vpcmpeqq 485498096(%edx,%eax,4){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x29,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpcmpeqq 485498096(%edx,%eax,4){1to8}, %zmm2, %k2 

// CHECK: vpcmpeqq -485498096(%edx,%eax,4){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x29,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpcmpeqq -485498096(%edx,%eax,4){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqq 485498096(%edx,%eax,4){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x29,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpcmpeqq 485498096(%edx,%eax,4){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqq -485498096(%edx,%eax,4), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x29,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpcmpeqq -485498096(%edx,%eax,4), %zmm2, %k2 

// CHECK: vpcmpeqq 485498096(%edx,%eax,4), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x29,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpcmpeqq 485498096(%edx,%eax,4), %zmm2, %k2 

// CHECK: vpcmpeqq -485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x29,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpcmpeqq -485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqq 485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x29,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpcmpeqq 485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqq 485498096(%edx), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x29,0x92,0xf0,0x1c,0xf0,0x1c]      
vpcmpeqq 485498096(%edx), %zmm2, %k2 

// CHECK: vpcmpeqq 485498096(%edx), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x29,0x92,0xf0,0x1c,0xf0,0x1c]     
vpcmpeqq 485498096(%edx), %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqq 485498096, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x29,0x15,0xf0,0x1c,0xf0,0x1c]      
vpcmpeqq 485498096, %zmm2, %k2 

// CHECK: vpcmpeqq 485498096, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x29,0x15,0xf0,0x1c,0xf0,0x1c]     
vpcmpeqq 485498096, %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqq 512(%edx,%eax){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x29,0x54,0x02,0x40]      
vpcmpeqq 512(%edx,%eax){1to8}, %zmm2, %k2 

// CHECK: vpcmpeqq 512(%edx,%eax){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x29,0x54,0x02,0x40]     
vpcmpeqq 512(%edx,%eax){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqq (%edx){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x29,0x12]      
vpcmpeqq (%edx){1to8}, %zmm2, %k2 

// CHECK: vpcmpeqq (%edx){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x29,0x12]     
vpcmpeqq (%edx){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqq (%edx), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x29,0x12]      
vpcmpeqq (%edx), %zmm2, %k2 

// CHECK: vpcmpeqq (%edx), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x29,0x12]     
vpcmpeqq (%edx), %zmm2, %k2 {%k2} 

// CHECK: vpcmpeqq %zmm2, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x29,0xd2]      
vpcmpeqq %zmm2, %zmm2, %k2 

// CHECK: vpcmpeqq %zmm2, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x29,0xd2]     
vpcmpeqq %zmm2, %zmm2, %k2 {%k2} 

// CHECK: vpcmpequd 256(%edx,%eax){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x58,0x1e,0x54,0x02,0x40,0x00]      
vpcmpequd 256(%edx,%eax){1to16}, %zmm2, %k2 

// CHECK: vpcmpequd 256(%edx,%eax){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x5a,0x1e,0x54,0x02,0x40,0x00]     
vpcmpequd 256(%edx,%eax){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpequd 4096(%edx,%eax), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x1e,0x54,0x02,0x40,0x00]      
vpcmpequd 4096(%edx,%eax), %zmm2, %k2 

// CHECK: vpcmpequd 4096(%edx,%eax), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x1e,0x54,0x02,0x40,0x00]     
vpcmpequd 4096(%edx,%eax), %zmm2, %k2 {%k2} 

// CHECK: vpcmpequd 485498096{1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x58,0x1e,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vpcmpequd 485498096{1to16}, %zmm2, %k2 

// CHECK: vpcmpequd 485498096{1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x5a,0x1e,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vpcmpequd 485498096{1to16}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpequd 485498096(%edx){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x58,0x1e,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vpcmpequd 485498096(%edx){1to16}, %zmm2, %k2 

// CHECK: vpcmpequd 485498096(%edx){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x5a,0x1e,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vpcmpequd 485498096(%edx){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpequd -485498096(%edx,%eax,4){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x58,0x1e,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vpcmpequd -485498096(%edx,%eax,4){1to16}, %zmm2, %k2 

// CHECK: vpcmpequd 485498096(%edx,%eax,4){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x58,0x1e,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vpcmpequd 485498096(%edx,%eax,4){1to16}, %zmm2, %k2 

// CHECK: vpcmpequd -485498096(%edx,%eax,4){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x5a,0x1e,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vpcmpequd -485498096(%edx,%eax,4){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpequd 485498096(%edx,%eax,4){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x5a,0x1e,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vpcmpequd 485498096(%edx,%eax,4){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpequd -485498096(%edx,%eax,4), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x1e,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vpcmpequd -485498096(%edx,%eax,4), %zmm2, %k2 

// CHECK: vpcmpequd 485498096(%edx,%eax,4), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x1e,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vpcmpequd 485498096(%edx,%eax,4), %zmm2, %k2 

// CHECK: vpcmpequd -485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x1e,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vpcmpequd -485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 

// CHECK: vpcmpequd 485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x1e,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vpcmpequd 485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 

// CHECK: vpcmpequd 485498096(%edx), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x1e,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vpcmpequd 485498096(%edx), %zmm2, %k2 

// CHECK: vpcmpequd 485498096(%edx), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x1e,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vpcmpequd 485498096(%edx), %zmm2, %k2 {%k2} 

// CHECK: vpcmpequd 485498096, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x1e,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vpcmpequd 485498096, %zmm2, %k2 

// CHECK: vpcmpequd 485498096, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x1e,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vpcmpequd 485498096, %zmm2, %k2 {%k2} 

// CHECK: vpcmpequd (%edx){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x58,0x1e,0x12,0x00]      
vpcmpequd (%edx){1to16}, %zmm2, %k2 

// CHECK: vpcmpequd (%edx){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x5a,0x1e,0x12,0x00]     
vpcmpequd (%edx){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpequd (%edx), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x1e,0x12,0x00]      
vpcmpequd (%edx), %zmm2, %k2 

// CHECK: vpcmpequd (%edx), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x1e,0x12,0x00]     
vpcmpequd (%edx), %zmm2, %k2 {%k2} 

// CHECK: vpcmpequd %zmm2, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0x6d,0x48,0x1e,0xd2,0x00]      
vpcmpequd %zmm2, %zmm2, %k2 

// CHECK: vpcmpequd %zmm2, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x6d,0x4a,0x1e,0xd2,0x00]     
vpcmpequd %zmm2, %zmm2, %k2 {%k2} 

// CHECK: vpcmpequq 4096(%edx,%eax), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x1e,0x54,0x02,0x40,0x00]      
vpcmpequq 4096(%edx,%eax), %zmm2, %k2 

// CHECK: vpcmpequq 4096(%edx,%eax), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x1e,0x54,0x02,0x40,0x00]     
vpcmpequq 4096(%edx,%eax), %zmm2, %k2 {%k2} 

// CHECK: vpcmpequq 485498096{1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0xed,0x58,0x1e,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vpcmpequq 485498096{1to8}, %zmm2, %k2 

// CHECK: vpcmpequq 485498096{1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x5a,0x1e,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vpcmpequq 485498096{1to8}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpequq 485498096(%edx){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0xed,0x58,0x1e,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vpcmpequq 485498096(%edx){1to8}, %zmm2, %k2 

// CHECK: vpcmpequq 485498096(%edx){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x5a,0x1e,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vpcmpequq 485498096(%edx){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpequq -485498096(%edx,%eax,4){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0xed,0x58,0x1e,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vpcmpequq -485498096(%edx,%eax,4){1to8}, %zmm2, %k2 

// CHECK: vpcmpequq 485498096(%edx,%eax,4){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0xed,0x58,0x1e,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vpcmpequq 485498096(%edx,%eax,4){1to8}, %zmm2, %k2 

// CHECK: vpcmpequq -485498096(%edx,%eax,4){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x5a,0x1e,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vpcmpequq -485498096(%edx,%eax,4){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpequq 485498096(%edx,%eax,4){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x5a,0x1e,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vpcmpequq 485498096(%edx,%eax,4){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpequq -485498096(%edx,%eax,4), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x1e,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vpcmpequq -485498096(%edx,%eax,4), %zmm2, %k2 

// CHECK: vpcmpequq 485498096(%edx,%eax,4), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x1e,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vpcmpequq 485498096(%edx,%eax,4), %zmm2, %k2 

// CHECK: vpcmpequq -485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x1e,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vpcmpequq -485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 

// CHECK: vpcmpequq 485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x1e,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vpcmpequq 485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 

// CHECK: vpcmpequq 485498096(%edx), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x1e,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vpcmpequq 485498096(%edx), %zmm2, %k2 

// CHECK: vpcmpequq 485498096(%edx), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x1e,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vpcmpequq 485498096(%edx), %zmm2, %k2 {%k2} 

// CHECK: vpcmpequq 485498096, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x1e,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vpcmpequq 485498096, %zmm2, %k2 

// CHECK: vpcmpequq 485498096, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x1e,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vpcmpequq 485498096, %zmm2, %k2 {%k2} 

// CHECK: vpcmpequq 512(%edx,%eax){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0xed,0x58,0x1e,0x54,0x02,0x40,0x00]      
vpcmpequq 512(%edx,%eax){1to8}, %zmm2, %k2 

// CHECK: vpcmpequq 512(%edx,%eax){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x5a,0x1e,0x54,0x02,0x40,0x00]     
vpcmpequq 512(%edx,%eax){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpequq (%edx){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0xed,0x58,0x1e,0x12,0x00]      
vpcmpequq (%edx){1to8}, %zmm2, %k2 

// CHECK: vpcmpequq (%edx){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x5a,0x1e,0x12,0x00]     
vpcmpequq (%edx){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpequq (%edx), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x1e,0x12,0x00]      
vpcmpequq (%edx), %zmm2, %k2 

// CHECK: vpcmpequq (%edx), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x1e,0x12,0x00]     
vpcmpequq (%edx), %zmm2, %k2 {%k2} 

// CHECK: vpcmpequq %zmm2, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x1e,0xd2,0x00]      
vpcmpequq %zmm2, %zmm2, %k2 

// CHECK: vpcmpequq %zmm2, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xed,0x4a,0x1e,0xd2,0x00]     
vpcmpequq %zmm2, %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtd 256(%edx,%eax){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0x66,0x54,0x02,0x40]      
vpcmpgtd 256(%edx,%eax){1to16}, %zmm2, %k2 

// CHECK: vpcmpgtd 256(%edx,%eax){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0x66,0x54,0x02,0x40]     
vpcmpgtd 256(%edx,%eax){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtd 4096(%edx,%eax), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0x66,0x54,0x02,0x40]      
vpcmpgtd 4096(%edx,%eax), %zmm2, %k2 

// CHECK: vpcmpgtd 4096(%edx,%eax), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0x66,0x54,0x02,0x40]     
vpcmpgtd 4096(%edx,%eax), %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtd 485498096{1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0x66,0x15,0xf0,0x1c,0xf0,0x1c]      
vpcmpgtd 485498096{1to16}, %zmm2, %k2 

// CHECK: vpcmpgtd 485498096{1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0x66,0x15,0xf0,0x1c,0xf0,0x1c]     
vpcmpgtd 485498096{1to16}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtd 485498096(%edx){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0x66,0x92,0xf0,0x1c,0xf0,0x1c]      
vpcmpgtd 485498096(%edx){1to16}, %zmm2, %k2 

// CHECK: vpcmpgtd 485498096(%edx){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0x66,0x92,0xf0,0x1c,0xf0,0x1c]     
vpcmpgtd 485498096(%edx){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtd -485498096(%edx,%eax,4){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0x66,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpcmpgtd -485498096(%edx,%eax,4){1to16}, %zmm2, %k2 

// CHECK: vpcmpgtd 485498096(%edx,%eax,4){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0x66,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpcmpgtd 485498096(%edx,%eax,4){1to16}, %zmm2, %k2 

// CHECK: vpcmpgtd -485498096(%edx,%eax,4){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0x66,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpcmpgtd -485498096(%edx,%eax,4){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtd 485498096(%edx,%eax,4){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0x66,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpcmpgtd 485498096(%edx,%eax,4){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtd -485498096(%edx,%eax,4), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0x66,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpcmpgtd -485498096(%edx,%eax,4), %zmm2, %k2 

// CHECK: vpcmpgtd 485498096(%edx,%eax,4), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0x66,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpcmpgtd 485498096(%edx,%eax,4), %zmm2, %k2 

// CHECK: vpcmpgtd -485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0x66,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpcmpgtd -485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtd 485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0x66,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpcmpgtd 485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtd 485498096(%edx), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0x66,0x92,0xf0,0x1c,0xf0,0x1c]      
vpcmpgtd 485498096(%edx), %zmm2, %k2 

// CHECK: vpcmpgtd 485498096(%edx), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0x66,0x92,0xf0,0x1c,0xf0,0x1c]     
vpcmpgtd 485498096(%edx), %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtd 485498096, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0x66,0x15,0xf0,0x1c,0xf0,0x1c]      
vpcmpgtd 485498096, %zmm2, %k2 

// CHECK: vpcmpgtd 485498096, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0x66,0x15,0xf0,0x1c,0xf0,0x1c]     
vpcmpgtd 485498096, %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtd (%edx){1to16}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x58,0x66,0x12]      
vpcmpgtd (%edx){1to16}, %zmm2, %k2 

// CHECK: vpcmpgtd (%edx){1to16}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x5a,0x66,0x12]     
vpcmpgtd (%edx){1to16}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtd (%edx), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0x66,0x12]      
vpcmpgtd (%edx), %zmm2, %k2 

// CHECK: vpcmpgtd (%edx), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0x66,0x12]     
vpcmpgtd (%edx), %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtd %zmm2, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf1,0x6d,0x48,0x66,0xd2]      
vpcmpgtd %zmm2, %zmm2, %k2 

// CHECK: vpcmpgtd %zmm2, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf1,0x6d,0x4a,0x66,0xd2]     
vpcmpgtd %zmm2, %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtq 4096(%edx,%eax), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x37,0x54,0x02,0x40]      
vpcmpgtq 4096(%edx,%eax), %zmm2, %k2 

// CHECK: vpcmpgtq 4096(%edx,%eax), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x37,0x54,0x02,0x40]     
vpcmpgtq 4096(%edx,%eax), %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtq 485498096{1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x37,0x15,0xf0,0x1c,0xf0,0x1c]      
vpcmpgtq 485498096{1to8}, %zmm2, %k2 

// CHECK: vpcmpgtq 485498096{1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x37,0x15,0xf0,0x1c,0xf0,0x1c]     
vpcmpgtq 485498096{1to8}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtq 485498096(%edx){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x37,0x92,0xf0,0x1c,0xf0,0x1c]      
vpcmpgtq 485498096(%edx){1to8}, %zmm2, %k2 

// CHECK: vpcmpgtq 485498096(%edx){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x37,0x92,0xf0,0x1c,0xf0,0x1c]     
vpcmpgtq 485498096(%edx){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtq -485498096(%edx,%eax,4){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x37,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpcmpgtq -485498096(%edx,%eax,4){1to8}, %zmm2, %k2 

// CHECK: vpcmpgtq 485498096(%edx,%eax,4){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x37,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpcmpgtq 485498096(%edx,%eax,4){1to8}, %zmm2, %k2 

// CHECK: vpcmpgtq -485498096(%edx,%eax,4){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x37,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpcmpgtq -485498096(%edx,%eax,4){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtq 485498096(%edx,%eax,4){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x37,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpcmpgtq 485498096(%edx,%eax,4){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtq -485498096(%edx,%eax,4), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x37,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpcmpgtq -485498096(%edx,%eax,4), %zmm2, %k2 

// CHECK: vpcmpgtq 485498096(%edx,%eax,4), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x37,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpcmpgtq 485498096(%edx,%eax,4), %zmm2, %k2 

// CHECK: vpcmpgtq -485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x37,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpcmpgtq -485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtq 485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x37,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpcmpgtq 485498096(%edx,%eax,4), %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtq 485498096(%edx), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x37,0x92,0xf0,0x1c,0xf0,0x1c]      
vpcmpgtq 485498096(%edx), %zmm2, %k2 

// CHECK: vpcmpgtq 485498096(%edx), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x37,0x92,0xf0,0x1c,0xf0,0x1c]     
vpcmpgtq 485498096(%edx), %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtq 485498096, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x37,0x15,0xf0,0x1c,0xf0,0x1c]      
vpcmpgtq 485498096, %zmm2, %k2 

// CHECK: vpcmpgtq 485498096, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x37,0x15,0xf0,0x1c,0xf0,0x1c]     
vpcmpgtq 485498096, %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtq 512(%edx,%eax){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x37,0x54,0x02,0x40]      
vpcmpgtq 512(%edx,%eax){1to8}, %zmm2, %k2 

// CHECK: vpcmpgtq 512(%edx,%eax){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x37,0x54,0x02,0x40]     
vpcmpgtq 512(%edx,%eax){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtq (%edx){1to8}, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x37,0x12]      
vpcmpgtq (%edx){1to8}, %zmm2, %k2 

// CHECK: vpcmpgtq (%edx){1to8}, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x37,0x12]     
vpcmpgtq (%edx){1to8}, %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtq (%edx), %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x37,0x12]      
vpcmpgtq (%edx), %zmm2, %k2 

// CHECK: vpcmpgtq (%edx), %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x37,0x12]     
vpcmpgtq (%edx), %zmm2, %k2 {%k2} 

// CHECK: vpcmpgtq %zmm2, %zmm2, %k2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x37,0xd2]      
vpcmpgtq %zmm2, %zmm2, %k2 

// CHECK: vpcmpgtq %zmm2, %zmm2, %k2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x37,0xd2]     
vpcmpgtq %zmm2, %zmm2, %k2 {%k2} 

// CHECK: vpcompressd %zmm2, 256(%edx,%eax) 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x8b,0x54,0x02,0x40]       
vpcompressd %zmm2, 256(%edx,%eax) 

// CHECK: vpcompressd %zmm2, 256(%edx,%eax) {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x8b,0x54,0x02,0x40]      
vpcompressd %zmm2, 256(%edx,%eax) {%k2} 

// CHECK: vpcompressd %zmm2, -485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x8b,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vpcompressd %zmm2, -485498096(%edx,%eax,4) 

// CHECK: vpcompressd %zmm2, 485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x8b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vpcompressd %zmm2, 485498096(%edx,%eax,4) 

// CHECK: vpcompressd %zmm2, -485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x8b,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpcompressd %zmm2, -485498096(%edx,%eax,4) {%k2} 

// CHECK: vpcompressd %zmm2, 485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x8b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpcompressd %zmm2, 485498096(%edx,%eax,4) {%k2} 

// CHECK: vpcompressd %zmm2, 485498096(%edx) 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x8b,0x92,0xf0,0x1c,0xf0,0x1c]       
vpcompressd %zmm2, 485498096(%edx) 

// CHECK: vpcompressd %zmm2, 485498096(%edx) {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x8b,0x92,0xf0,0x1c,0xf0,0x1c]      
vpcompressd %zmm2, 485498096(%edx) {%k2} 

// CHECK: vpcompressd %zmm2, 485498096 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x8b,0x15,0xf0,0x1c,0xf0,0x1c]       
vpcompressd %zmm2, 485498096 

// CHECK: vpcompressd %zmm2, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x8b,0x15,0xf0,0x1c,0xf0,0x1c]      
vpcompressd %zmm2, 485498096 {%k2} 

// CHECK: vpcompressd %zmm2, (%edx) 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x8b,0x12]       
vpcompressd %zmm2, (%edx) 

// CHECK: vpcompressd %zmm2, (%edx) {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x8b,0x12]      
vpcompressd %zmm2, (%edx) {%k2} 

// CHECK: vpcompressd %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x8b,0xd2]       
vpcompressd %zmm2, %zmm2 

// CHECK: vpcompressd %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x8b,0xd2]      
vpcompressd %zmm2, %zmm2 {%k2} 

// CHECK: vpcompressd %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x8b,0xd2]     
vpcompressd %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpcompressq %zmm2, -485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x8b,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vpcompressq %zmm2, -485498096(%edx,%eax,4) 

// CHECK: vpcompressq %zmm2, 485498096(%edx,%eax,4) 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x8b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vpcompressq %zmm2, 485498096(%edx,%eax,4) 

// CHECK: vpcompressq %zmm2, -485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x8b,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpcompressq %zmm2, -485498096(%edx,%eax,4) {%k2} 

// CHECK: vpcompressq %zmm2, 485498096(%edx,%eax,4) {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x8b,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpcompressq %zmm2, 485498096(%edx,%eax,4) {%k2} 

// CHECK: vpcompressq %zmm2, 485498096(%edx) 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x8b,0x92,0xf0,0x1c,0xf0,0x1c]       
vpcompressq %zmm2, 485498096(%edx) 

// CHECK: vpcompressq %zmm2, 485498096(%edx) {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x8b,0x92,0xf0,0x1c,0xf0,0x1c]      
vpcompressq %zmm2, 485498096(%edx) {%k2} 

// CHECK: vpcompressq %zmm2, 485498096 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x8b,0x15,0xf0,0x1c,0xf0,0x1c]       
vpcompressq %zmm2, 485498096 

// CHECK: vpcompressq %zmm2, 485498096 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x8b,0x15,0xf0,0x1c,0xf0,0x1c]      
vpcompressq %zmm2, 485498096 {%k2} 

// CHECK: vpcompressq %zmm2, 512(%edx,%eax) 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x8b,0x54,0x02,0x40]       
vpcompressq %zmm2, 512(%edx,%eax) 

// CHECK: vpcompressq %zmm2, 512(%edx,%eax) {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x8b,0x54,0x02,0x40]      
vpcompressq %zmm2, 512(%edx,%eax) {%k2} 

// CHECK: vpcompressq %zmm2, (%edx) 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x8b,0x12]       
vpcompressq %zmm2, (%edx) 

// CHECK: vpcompressq %zmm2, (%edx) {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x8b,0x12]      
vpcompressq %zmm2, (%edx) {%k2} 

// CHECK: vpcompressq %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x8b,0xd2]       
vpcompressq %zmm2, %zmm2 

// CHECK: vpcompressq %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x8b,0xd2]      
vpcompressq %zmm2, %zmm2 {%k2} 

// CHECK: vpcompressq %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x8b,0xd2]     
vpcompressq %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermd 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x36,0x54,0x02,0x40]      
vpermd 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vpermd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x36,0x54,0x02,0x40]     
vpermd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x36,0x54,0x02,0x40]    
vpermd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x36,0x54,0x02,0x40]      
vpermd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpermd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x36,0x54,0x02,0x40]     
vpermd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpermd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x36,0x54,0x02,0x40]    
vpermd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermd 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x36,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermd 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vpermd 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x36,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermd 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermd 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x36,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermd 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermd 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x36,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermd 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpermd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x36,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x36,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x36,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpermd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x36,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpermd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x36,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x36,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x36,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x36,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x36,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x36,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x36,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x36,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x36,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x36,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x36,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpermd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x36,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x36,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x36,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermd 485498096, %zmm2, %zmm2 

// CHECK: vpermd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x36,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpermd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x36,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermd (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x36,0x12]      
vpermd (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpermd (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x36,0x12]     
vpermd (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermd (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x36,0x12]    
vpermd (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x36,0x12]      
vpermd (%edx), %zmm2, %zmm2 

// CHECK: vpermd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x36,0x12]     
vpermd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x36,0x12]    
vpermd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x36,0xd2]      
vpermd %zmm2, %zmm2, %zmm2 

// CHECK: vpermd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x36,0xd2]     
vpermd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpermd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x36,0xd2]    
vpermd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2d 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x76,0x54,0x02,0x40]      
vpermi2d 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vpermi2d 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x76,0x54,0x02,0x40]     
vpermi2d 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2d 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x76,0x54,0x02,0x40]    
vpermi2d 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2d 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x76,0x54,0x02,0x40]      
vpermi2d 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpermi2d 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x76,0x54,0x02,0x40]     
vpermi2d 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2d 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x76,0x54,0x02,0x40]    
vpermi2d 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2d 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x76,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermi2d 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vpermi2d 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x76,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermi2d 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2d 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x76,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermi2d 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2d 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x76,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermi2d 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpermi2d 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x76,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermi2d 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2d 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x76,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermi2d 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2d -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x76,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermi2d -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpermi2d 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x76,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermi2d 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpermi2d -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x76,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermi2d -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2d 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x76,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermi2d 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2d -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x76,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermi2d -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2d 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x76,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermi2d 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2d -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x76,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermi2d -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermi2d 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x76,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermi2d 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermi2d -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x76,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermi2d -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2d 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x76,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermi2d 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2d -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x76,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermi2d -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2d 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x76,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermi2d 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2d 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x76,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermi2d 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpermi2d 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x76,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermi2d 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2d 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x76,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermi2d 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2d 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x76,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermi2d 485498096, %zmm2, %zmm2 

// CHECK: vpermi2d 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x76,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermi2d 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2d 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x76,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermi2d 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2d (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x76,0x12]      
vpermi2d (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpermi2d (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x76,0x12]     
vpermi2d (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2d (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x76,0x12]    
vpermi2d (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2d (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x76,0x12]      
vpermi2d (%edx), %zmm2, %zmm2 

// CHECK: vpermi2d (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x76,0x12]     
vpermi2d (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2d (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x76,0x12]    
vpermi2d (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2d %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x76,0xd2]      
vpermi2d %zmm2, %zmm2, %zmm2 

// CHECK: vpermi2d %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x76,0xd2]     
vpermi2d %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2d %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x76,0xd2]    
vpermi2d %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x77,0x54,0x02,0x40]      
vpermi2pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpermi2pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x77,0x54,0x02,0x40]     
vpermi2pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x77,0x54,0x02,0x40]    
vpermi2pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x77,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermi2pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vpermi2pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x77,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermi2pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x77,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermi2pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x77,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermi2pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpermi2pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x77,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermi2pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x77,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermi2pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x77,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermi2pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpermi2pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x77,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermi2pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpermi2pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x77,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermi2pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x77,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermi2pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x77,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermi2pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x77,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermi2pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x77,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermi2pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermi2pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x77,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermi2pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermi2pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x77,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermi2pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x77,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermi2pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x77,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermi2pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x77,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermi2pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x77,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermi2pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpermi2pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x77,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermi2pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x77,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermi2pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x77,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermi2pd 485498096, %zmm2, %zmm2 

// CHECK: vpermi2pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x77,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermi2pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x77,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermi2pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x77,0x54,0x02,0x40]      
vpermi2pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vpermi2pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x77,0x54,0x02,0x40]     
vpermi2pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x77,0x54,0x02,0x40]    
vpermi2pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x77,0x12]      
vpermi2pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpermi2pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x77,0x12]     
vpermi2pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x77,0x12]    
vpermi2pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x77,0x12]      
vpermi2pd (%edx), %zmm2, %zmm2 

// CHECK: vpermi2pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x77,0x12]     
vpermi2pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x77,0x12]    
vpermi2pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x77,0xd2]      
vpermi2pd %zmm2, %zmm2, %zmm2 

// CHECK: vpermi2pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x77,0xd2]     
vpermi2pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x77,0xd2]    
vpermi2pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x77,0x54,0x02,0x40]      
vpermi2ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vpermi2ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x77,0x54,0x02,0x40]     
vpermi2ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x77,0x54,0x02,0x40]    
vpermi2ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x77,0x54,0x02,0x40]      
vpermi2ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpermi2ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x77,0x54,0x02,0x40]     
vpermi2ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x77,0x54,0x02,0x40]    
vpermi2ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x77,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermi2ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vpermi2ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x77,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermi2ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x77,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermi2ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x77,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermi2ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpermi2ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x77,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermi2ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x77,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermi2ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x77,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermi2ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpermi2ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x77,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermi2ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpermi2ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x77,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermi2ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x77,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermi2ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x77,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermi2ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x77,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermi2ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x77,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermi2ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermi2ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x77,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermi2ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermi2ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x77,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermi2ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x77,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermi2ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x77,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermi2ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x77,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermi2ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x77,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermi2ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpermi2ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x77,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermi2ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x77,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermi2ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x77,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermi2ps 485498096, %zmm2, %zmm2 

// CHECK: vpermi2ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x77,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermi2ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x77,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermi2ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x77,0x12]      
vpermi2ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpermi2ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x77,0x12]     
vpermi2ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x77,0x12]    
vpermi2ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x77,0x12]      
vpermi2ps (%edx), %zmm2, %zmm2 

// CHECK: vpermi2ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x77,0x12]     
vpermi2ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x77,0x12]    
vpermi2ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x77,0xd2]      
vpermi2ps %zmm2, %zmm2, %zmm2 

// CHECK: vpermi2ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x77,0xd2]     
vpermi2ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x77,0xd2]    
vpermi2ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2q 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x76,0x54,0x02,0x40]      
vpermi2q 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpermi2q 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x76,0x54,0x02,0x40]     
vpermi2q 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2q 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x76,0x54,0x02,0x40]    
vpermi2q 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2q 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x76,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermi2q 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vpermi2q 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x76,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermi2q 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2q 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x76,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermi2q 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2q 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x76,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermi2q 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpermi2q 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x76,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermi2q 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2q 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x76,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermi2q 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2q -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x76,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermi2q -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpermi2q 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x76,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermi2q 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpermi2q -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x76,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermi2q -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2q 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x76,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermi2q 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2q -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x76,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermi2q -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2q 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x76,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermi2q 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2q -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x76,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermi2q -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermi2q 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x76,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermi2q 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermi2q -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x76,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermi2q -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2q 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x76,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermi2q 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2q -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x76,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermi2q -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2q 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x76,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermi2q 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2q 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x76,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermi2q 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpermi2q 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x76,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermi2q 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2q 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x76,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermi2q 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2q 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x76,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermi2q 485498096, %zmm2, %zmm2 

// CHECK: vpermi2q 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x76,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermi2q 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2q 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x76,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermi2q 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2q 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x76,0x54,0x02,0x40]      
vpermi2q 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vpermi2q 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x76,0x54,0x02,0x40]     
vpermi2q 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2q 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x76,0x54,0x02,0x40]    
vpermi2q 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2q (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x76,0x12]      
vpermi2q (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpermi2q (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x76,0x12]     
vpermi2q (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2q (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x76,0x12]    
vpermi2q (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2q (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x76,0x12]      
vpermi2q (%edx), %zmm2, %zmm2 

// CHECK: vpermi2q (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x76,0x12]     
vpermi2q (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2q (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x76,0x12]    
vpermi2q (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermi2q %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x76,0xd2]      
vpermi2q %zmm2, %zmm2, %zmm2 

// CHECK: vpermi2q %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x76,0xd2]     
vpermi2q %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpermi2q %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x76,0xd2]    
vpermi2q %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilpd $0, 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x05,0x54,0x02,0x40,0x00]      
vpermilpd $0, 4096(%edx,%eax), %zmm2 

// CHECK: vpermilpd $0, 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x05,0x54,0x02,0x40,0x00]     
vpermilpd $0, 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vpermilpd $0, 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x05,0x54,0x02,0x40,0x00]    
vpermilpd $0, 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vpermilpd $0, 485498096{1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x05,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermilpd $0, 485498096{1to8}, %zmm2 

// CHECK: vpermilpd $0, 485498096{1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x05,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermilpd $0, 485498096{1to8}, %zmm2 {%k2} 

// CHECK: vpermilpd $0, 485498096{1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x05,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermilpd $0, 485498096{1to8}, %zmm2 {%k2} {z} 

// CHECK: vpermilpd $0, 485498096(%edx){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x05,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermilpd $0, 485498096(%edx){1to8}, %zmm2 

// CHECK: vpermilpd $0, 485498096(%edx){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x05,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermilpd $0, 485498096(%edx){1to8}, %zmm2 {%k2} 

// CHECK: vpermilpd $0, 485498096(%edx){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x05,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermilpd $0, 485498096(%edx){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpermilpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x05,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vpermilpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2 

// CHECK: vpermilpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x05,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermilpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2 

// CHECK: vpermilpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x05,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vpermilpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 

// CHECK: vpermilpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x05,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermilpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 

// CHECK: vpermilpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x05,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vpermilpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpermilpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x05,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermilpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpermilpd $0, -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x05,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vpermilpd $0, -485498096(%edx,%eax,4), %zmm2 

// CHECK: vpermilpd $0, 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x05,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermilpd $0, 485498096(%edx,%eax,4), %zmm2 

// CHECK: vpermilpd $0, -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x05,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vpermilpd $0, -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpermilpd $0, 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x05,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermilpd $0, 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpermilpd $0, -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x05,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vpermilpd $0, -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpermilpd $0, 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x05,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermilpd $0, 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpermilpd $0, 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x05,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermilpd $0, 485498096(%edx), %zmm2 

// CHECK: vpermilpd $0, 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x05,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermilpd $0, 485498096(%edx), %zmm2 {%k2} 

// CHECK: vpermilpd $0, 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x05,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermilpd $0, 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vpermilpd $0, 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x05,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermilpd $0, 485498096, %zmm2 

// CHECK: vpermilpd $0, 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x05,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermilpd $0, 485498096, %zmm2 {%k2} 

// CHECK: vpermilpd $0, 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x05,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermilpd $0, 485498096, %zmm2 {%k2} {z} 

// CHECK: vpermilpd $0, 512(%edx,%eax){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x05,0x54,0x02,0x40,0x00]      
vpermilpd $0, 512(%edx,%eax){1to8}, %zmm2 

// CHECK: vpermilpd $0, 512(%edx,%eax){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x05,0x54,0x02,0x40,0x00]     
vpermilpd $0, 512(%edx,%eax){1to8}, %zmm2 {%k2} 

// CHECK: vpermilpd $0, 512(%edx,%eax){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x05,0x54,0x02,0x40,0x00]    
vpermilpd $0, 512(%edx,%eax){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpermilpd $0, (%edx){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x05,0x12,0x00]      
vpermilpd $0, (%edx){1to8}, %zmm2 

// CHECK: vpermilpd $0, (%edx){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x05,0x12,0x00]     
vpermilpd $0, (%edx){1to8}, %zmm2 {%k2} 

// CHECK: vpermilpd $0, (%edx){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x05,0x12,0x00]    
vpermilpd $0, (%edx){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpermilpd $0, (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x05,0x12,0x00]      
vpermilpd $0, (%edx), %zmm2 

// CHECK: vpermilpd $0, (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x05,0x12,0x00]     
vpermilpd $0, (%edx), %zmm2 {%k2} 

// CHECK: vpermilpd $0, (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x05,0x12,0x00]    
vpermilpd $0, (%edx), %zmm2 {%k2} {z} 

// CHECK: vpermilpd $0, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x05,0xd2,0x00]      
vpermilpd $0, %zmm2, %zmm2 

// CHECK: vpermilpd $0, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x05,0xd2,0x00]     
vpermilpd $0, %zmm2, %zmm2 {%k2} 

// CHECK: vpermilpd $0, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x05,0xd2,0x00]    
vpermilpd $0, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilpd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x0d,0x54,0x02,0x40]      
vpermilpd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpermilpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x0d,0x54,0x02,0x40]     
vpermilpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpermilpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x0d,0x54,0x02,0x40]    
vpermilpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilpd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x0d,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermilpd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vpermilpd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x0d,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermilpd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermilpd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x0d,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermilpd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilpd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x0d,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermilpd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpermilpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x0d,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermilpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermilpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x0d,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermilpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x0d,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermilpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpermilpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x0d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermilpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpermilpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x0d,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermilpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermilpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x0d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermilpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermilpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x0d,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermilpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x0d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermilpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilpd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x0d,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermilpd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermilpd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x0d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermilpd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermilpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x0d,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermilpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermilpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x0d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermilpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermilpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x0d,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermilpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x0d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermilpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilpd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x0d,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermilpd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpermilpd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x0d,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermilpd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermilpd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x0d,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermilpd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilpd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x0d,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermilpd 485498096, %zmm2, %zmm2 

// CHECK: vpermilpd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x0d,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermilpd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpermilpd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x0d,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermilpd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x0d,0x54,0x02,0x40]      
vpermilpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vpermilpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x0d,0x54,0x02,0x40]     
vpermilpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermilpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x0d,0x54,0x02,0x40]    
vpermilpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilpd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x0d,0x12]      
vpermilpd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpermilpd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x0d,0x12]     
vpermilpd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermilpd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x0d,0x12]    
vpermilpd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilpd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x0d,0x12]      
vpermilpd (%edx), %zmm2, %zmm2 

// CHECK: vpermilpd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x0d,0x12]     
vpermilpd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermilpd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x0d,0x12]    
vpermilpd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilpd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x0d,0xd2]      
vpermilpd %zmm2, %zmm2, %zmm2 

// CHECK: vpermilpd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x0d,0xd2]     
vpermilpd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpermilpd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x0d,0xd2]    
vpermilpd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilps $0, 256(%edx,%eax){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x58,0x04,0x54,0x02,0x40,0x00]      
vpermilps $0, 256(%edx,%eax){1to16}, %zmm2 

// CHECK: vpermilps $0, 256(%edx,%eax){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x5a,0x04,0x54,0x02,0x40,0x00]     
vpermilps $0, 256(%edx,%eax){1to16}, %zmm2 {%k2} 

// CHECK: vpermilps $0, 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xda,0x04,0x54,0x02,0x40,0x00]    
vpermilps $0, 256(%edx,%eax){1to16}, %zmm2 {%k2} {z} 

// CHECK: vpermilps $0, 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x04,0x54,0x02,0x40,0x00]      
vpermilps $0, 4096(%edx,%eax), %zmm2 

// CHECK: vpermilps $0, 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x04,0x54,0x02,0x40,0x00]     
vpermilps $0, 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vpermilps $0, 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xca,0x04,0x54,0x02,0x40,0x00]    
vpermilps $0, 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vpermilps $0, 485498096{1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x58,0x04,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermilps $0, 485498096{1to16}, %zmm2 

// CHECK: vpermilps $0, 485498096{1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x5a,0x04,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermilps $0, 485498096{1to16}, %zmm2 {%k2} 

// CHECK: vpermilps $0, 485498096{1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xda,0x04,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermilps $0, 485498096{1to16}, %zmm2 {%k2} {z} 

// CHECK: vpermilps $0, 485498096(%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x58,0x04,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermilps $0, 485498096(%edx){1to16}, %zmm2 

// CHECK: vpermilps $0, 485498096(%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x5a,0x04,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermilps $0, 485498096(%edx){1to16}, %zmm2 {%k2} 

// CHECK: vpermilps $0, 485498096(%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xda,0x04,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermilps $0, 485498096(%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vpermilps $0, -485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x58,0x04,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vpermilps $0, -485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vpermilps $0, 485498096(%edx,%eax,4){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x58,0x04,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermilps $0, 485498096(%edx,%eax,4){1to16}, %zmm2 

// CHECK: vpermilps $0, -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x5a,0x04,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vpermilps $0, -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vpermilps $0, 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x5a,0x04,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermilps $0, 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} 

// CHECK: vpermilps $0, -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xda,0x04,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vpermilps $0, -485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vpermilps $0, 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xda,0x04,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermilps $0, 485498096(%edx,%eax,4){1to16}, %zmm2 {%k2} {z} 

// CHECK: vpermilps $0, -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x04,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vpermilps $0, -485498096(%edx,%eax,4), %zmm2 

// CHECK: vpermilps $0, 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x04,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermilps $0, 485498096(%edx,%eax,4), %zmm2 

// CHECK: vpermilps $0, -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x04,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vpermilps $0, -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpermilps $0, 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x04,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermilps $0, 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpermilps $0, -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xca,0x04,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vpermilps $0, -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpermilps $0, 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xca,0x04,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermilps $0, 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpermilps $0, 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x04,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermilps $0, 485498096(%edx), %zmm2 

// CHECK: vpermilps $0, 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x04,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermilps $0, 485498096(%edx), %zmm2 {%k2} 

// CHECK: vpermilps $0, 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xca,0x04,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermilps $0, 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vpermilps $0, 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x04,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermilps $0, 485498096, %zmm2 

// CHECK: vpermilps $0, 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x04,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermilps $0, 485498096, %zmm2 {%k2} 

// CHECK: vpermilps $0, 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xca,0x04,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermilps $0, 485498096, %zmm2 {%k2} {z} 

// CHECK: vpermilps $0, (%edx){1to16}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x58,0x04,0x12,0x00]      
vpermilps $0, (%edx){1to16}, %zmm2 

// CHECK: vpermilps $0, (%edx){1to16}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x5a,0x04,0x12,0x00]     
vpermilps $0, (%edx){1to16}, %zmm2 {%k2} 

// CHECK: vpermilps $0, (%edx){1to16}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xda,0x04,0x12,0x00]    
vpermilps $0, (%edx){1to16}, %zmm2 {%k2} {z} 

// CHECK: vpermilps $0, (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x04,0x12,0x00]      
vpermilps $0, (%edx), %zmm2 

// CHECK: vpermilps $0, (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x04,0x12,0x00]     
vpermilps $0, (%edx), %zmm2 {%k2} 

// CHECK: vpermilps $0, (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xca,0x04,0x12,0x00]    
vpermilps $0, (%edx), %zmm2 {%k2} {z} 

// CHECK: vpermilps $0, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0x7d,0x48,0x04,0xd2,0x00]      
vpermilps $0, %zmm2, %zmm2 

// CHECK: vpermilps $0, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0x7d,0x4a,0x04,0xd2,0x00]     
vpermilps $0, %zmm2, %zmm2 {%k2} 

// CHECK: vpermilps $0, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0x7d,0xca,0x04,0xd2,0x00]    
vpermilps $0, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x0c,0x54,0x02,0x40]      
vpermilps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vpermilps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x0c,0x54,0x02,0x40]     
vpermilps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermilps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x0c,0x54,0x02,0x40]    
vpermilps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x0c,0x54,0x02,0x40]      
vpermilps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpermilps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x0c,0x54,0x02,0x40]     
vpermilps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpermilps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x0c,0x54,0x02,0x40]    
vpermilps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x0c,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermilps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vpermilps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x0c,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermilps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermilps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x0c,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermilps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x0c,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermilps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpermilps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x0c,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermilps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermilps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x0c,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermilps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x0c,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermilps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpermilps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x0c,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermilps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpermilps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x0c,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermilps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermilps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x0c,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermilps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermilps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x0c,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermilps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x0c,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermilps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x0c,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermilps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermilps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x0c,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermilps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermilps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x0c,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermilps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermilps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x0c,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermilps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermilps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x0c,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermilps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x0c,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermilps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x0c,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermilps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpermilps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x0c,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermilps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermilps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x0c,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermilps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x0c,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermilps 485498096, %zmm2, %zmm2 

// CHECK: vpermilps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x0c,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermilps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpermilps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x0c,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermilps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x0c,0x12]      
vpermilps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpermilps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x0c,0x12]     
vpermilps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermilps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x0c,0x12]    
vpermilps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x0c,0x12]      
vpermilps (%edx), %zmm2, %zmm2 

// CHECK: vpermilps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x0c,0x12]     
vpermilps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermilps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x0c,0x12]    
vpermilps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermilps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x0c,0xd2]      
vpermilps %zmm2, %zmm2, %zmm2 

// CHECK: vpermilps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x0c,0xd2]     
vpermilps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpermilps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x0c,0xd2]    
vpermilps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermpd $0, 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x01,0x54,0x02,0x40,0x00]      
vpermpd $0, 4096(%edx,%eax), %zmm2 

// CHECK: vpermpd $0, 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x01,0x54,0x02,0x40,0x00]     
vpermpd $0, 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vpermpd $0, 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x01,0x54,0x02,0x40,0x00]    
vpermpd $0, 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vpermpd $0, 485498096{1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x01,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermpd $0, 485498096{1to8}, %zmm2 

// CHECK: vpermpd $0, 485498096{1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x01,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermpd $0, 485498096{1to8}, %zmm2 {%k2} 

// CHECK: vpermpd $0, 485498096{1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x01,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermpd $0, 485498096{1to8}, %zmm2 {%k2} {z} 

// CHECK: vpermpd $0, 485498096(%edx){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x01,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermpd $0, 485498096(%edx){1to8}, %zmm2 

// CHECK: vpermpd $0, 485498096(%edx){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x01,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermpd $0, 485498096(%edx){1to8}, %zmm2 {%k2} 

// CHECK: vpermpd $0, 485498096(%edx){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x01,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermpd $0, 485498096(%edx){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpermpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x01,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vpermpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2 

// CHECK: vpermpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x01,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2 

// CHECK: vpermpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x01,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vpermpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 

// CHECK: vpermpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x01,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 

// CHECK: vpermpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x01,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vpermpd $0, -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpermpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x01,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermpd $0, 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpermpd $0, -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x01,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vpermpd $0, -485498096(%edx,%eax,4), %zmm2 

// CHECK: vpermpd $0, 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x01,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermpd $0, 485498096(%edx,%eax,4), %zmm2 

// CHECK: vpermpd $0, -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x01,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vpermpd $0, -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpermpd $0, 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x01,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermpd $0, 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpermpd $0, -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x01,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vpermpd $0, -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpermpd $0, 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x01,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermpd $0, 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpermpd $0, 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x01,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermpd $0, 485498096(%edx), %zmm2 

// CHECK: vpermpd $0, 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x01,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermpd $0, 485498096(%edx), %zmm2 {%k2} 

// CHECK: vpermpd $0, 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x01,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermpd $0, 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vpermpd $0, 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x01,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermpd $0, 485498096, %zmm2 

// CHECK: vpermpd $0, 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x01,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermpd $0, 485498096, %zmm2 {%k2} 

// CHECK: vpermpd $0, 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x01,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermpd $0, 485498096, %zmm2 {%k2} {z} 

// CHECK: vpermpd $0, 512(%edx,%eax){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x01,0x54,0x02,0x40,0x00]      
vpermpd $0, 512(%edx,%eax){1to8}, %zmm2 

// CHECK: vpermpd $0, 512(%edx,%eax){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x01,0x54,0x02,0x40,0x00]     
vpermpd $0, 512(%edx,%eax){1to8}, %zmm2 {%k2} 

// CHECK: vpermpd $0, 512(%edx,%eax){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x01,0x54,0x02,0x40,0x00]    
vpermpd $0, 512(%edx,%eax){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpermpd $0, (%edx){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x01,0x12,0x00]      
vpermpd $0, (%edx){1to8}, %zmm2 

// CHECK: vpermpd $0, (%edx){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x01,0x12,0x00]     
vpermpd $0, (%edx){1to8}, %zmm2 {%k2} 

// CHECK: vpermpd $0, (%edx){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x01,0x12,0x00]    
vpermpd $0, (%edx){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpermpd $0, (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x01,0x12,0x00]      
vpermpd $0, (%edx), %zmm2 

// CHECK: vpermpd $0, (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x01,0x12,0x00]     
vpermpd $0, (%edx), %zmm2 {%k2} 

// CHECK: vpermpd $0, (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x01,0x12,0x00]    
vpermpd $0, (%edx), %zmm2 {%k2} {z} 

// CHECK: vpermpd $0, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x01,0xd2,0x00]      
vpermpd $0, %zmm2, %zmm2 

// CHECK: vpermpd $0, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x01,0xd2,0x00]     
vpermpd $0, %zmm2, %zmm2 {%k2} 

// CHECK: vpermpd $0, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x01,0xd2,0x00]    
vpermpd $0, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermpd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x16,0x54,0x02,0x40]      
vpermpd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpermpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x16,0x54,0x02,0x40]     
vpermpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpermpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x16,0x54,0x02,0x40]    
vpermpd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermpd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x16,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermpd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vpermpd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x16,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermpd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermpd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x16,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermpd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermpd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x16,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermpd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpermpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x16,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x16,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermpd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x16,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpermpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x16,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpermpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x16,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x16,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x16,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermpd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x16,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermpd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermpd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x16,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermpd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermpd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x16,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermpd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x16,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x16,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x16,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermpd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x16,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermpd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermpd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x16,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermpd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpermpd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x16,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermpd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermpd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x16,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermpd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermpd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x16,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermpd 485498096, %zmm2, %zmm2 

// CHECK: vpermpd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x16,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermpd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpermpd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x16,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermpd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x16,0x54,0x02,0x40]      
vpermpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vpermpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x16,0x54,0x02,0x40]     
vpermpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x16,0x54,0x02,0x40]    
vpermpd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermpd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x16,0x12]      
vpermpd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpermpd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x16,0x12]     
vpermpd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermpd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x16,0x12]    
vpermpd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermpd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x16,0x12]      
vpermpd (%edx), %zmm2, %zmm2 

// CHECK: vpermpd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x16,0x12]     
vpermpd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermpd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x16,0x12]    
vpermpd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermpd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x16,0xd2]      
vpermpd %zmm2, %zmm2, %zmm2 

// CHECK: vpermpd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x16,0xd2]     
vpermpd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpermpd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x16,0xd2]    
vpermpd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x16,0x54,0x02,0x40]      
vpermps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vpermps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x16,0x54,0x02,0x40]     
vpermps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x16,0x54,0x02,0x40]    
vpermps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x16,0x54,0x02,0x40]      
vpermps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpermps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x16,0x54,0x02,0x40]     
vpermps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpermps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x16,0x54,0x02,0x40]    
vpermps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x16,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vpermps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x16,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x16,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x16,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpermps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x16,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x16,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x16,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpermps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x16,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpermps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x16,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x16,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x16,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x16,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x16,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x16,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x16,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x16,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x16,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x16,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x16,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpermps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x16,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x16,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x16,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermps 485498096, %zmm2, %zmm2 

// CHECK: vpermps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x16,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpermps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x16,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x16,0x12]      
vpermps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpermps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x16,0x12]     
vpermps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x16,0x12]    
vpermps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x16,0x12]      
vpermps (%edx), %zmm2, %zmm2 

// CHECK: vpermps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x16,0x12]     
vpermps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x16,0x12]    
vpermps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x16,0xd2]      
vpermps %zmm2, %zmm2, %zmm2 

// CHECK: vpermps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x16,0xd2]     
vpermps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpermps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x16,0xd2]    
vpermps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermq $0, 4096(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x00,0x54,0x02,0x40,0x00]      
vpermq $0, 4096(%edx,%eax), %zmm2 

// CHECK: vpermq $0, 4096(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x00,0x54,0x02,0x40,0x00]     
vpermq $0, 4096(%edx,%eax), %zmm2 {%k2} 

// CHECK: vpermq $0, 4096(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x00,0x54,0x02,0x40,0x00]    
vpermq $0, 4096(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vpermq $0, 485498096{1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x00,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermq $0, 485498096{1to8}, %zmm2 

// CHECK: vpermq $0, 485498096{1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x00,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermq $0, 485498096{1to8}, %zmm2 {%k2} 

// CHECK: vpermq $0, 485498096{1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x00,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermq $0, 485498096{1to8}, %zmm2 {%k2} {z} 

// CHECK: vpermq $0, 485498096(%edx){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x00,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermq $0, 485498096(%edx){1to8}, %zmm2 

// CHECK: vpermq $0, 485498096(%edx){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x00,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermq $0, 485498096(%edx){1to8}, %zmm2 {%k2} 

// CHECK: vpermq $0, 485498096(%edx){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x00,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermq $0, 485498096(%edx){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpermq $0, -485498096(%edx,%eax,4){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x00,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vpermq $0, -485498096(%edx,%eax,4){1to8}, %zmm2 

// CHECK: vpermq $0, 485498096(%edx,%eax,4){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x00,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermq $0, 485498096(%edx,%eax,4){1to8}, %zmm2 

// CHECK: vpermq $0, -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x00,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vpermq $0, -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 

// CHECK: vpermq $0, 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x00,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermq $0, 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} 

// CHECK: vpermq $0, -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x00,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vpermq $0, -485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpermq $0, 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x00,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermq $0, 485498096(%edx,%eax,4){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpermq $0, -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x00,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]      
vpermq $0, -485498096(%edx,%eax,4), %zmm2 

// CHECK: vpermq $0, 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x00,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermq $0, 485498096(%edx,%eax,4), %zmm2 

// CHECK: vpermq $0, -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x00,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]     
vpermq $0, -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpermq $0, 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x00,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermq $0, 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpermq $0, -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x00,0x94,0x82,0x10,0xe3,0x0f,0xe3,0x00]    
vpermq $0, -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpermq $0, 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x00,0x94,0x82,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermq $0, 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpermq $0, 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x00,0x92,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermq $0, 485498096(%edx), %zmm2 

// CHECK: vpermq $0, 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x00,0x92,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermq $0, 485498096(%edx), %zmm2 {%k2} 

// CHECK: vpermq $0, 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x00,0x92,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermq $0, 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vpermq $0, 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x00,0x15,0xf0,0x1c,0xf0,0x1c,0x00]      
vpermq $0, 485498096, %zmm2 

// CHECK: vpermq $0, 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x00,0x15,0xf0,0x1c,0xf0,0x1c,0x00]     
vpermq $0, 485498096, %zmm2 {%k2} 

// CHECK: vpermq $0, 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x00,0x15,0xf0,0x1c,0xf0,0x1c,0x00]    
vpermq $0, 485498096, %zmm2 {%k2} {z} 

// CHECK: vpermq $0, 512(%edx,%eax){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x00,0x54,0x02,0x40,0x00]      
vpermq $0, 512(%edx,%eax){1to8}, %zmm2 

// CHECK: vpermq $0, 512(%edx,%eax){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x00,0x54,0x02,0x40,0x00]     
vpermq $0, 512(%edx,%eax){1to8}, %zmm2 {%k2} 

// CHECK: vpermq $0, 512(%edx,%eax){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x00,0x54,0x02,0x40,0x00]    
vpermq $0, 512(%edx,%eax){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpermq $0, (%edx){1to8}, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x58,0x00,0x12,0x00]      
vpermq $0, (%edx){1to8}, %zmm2 

// CHECK: vpermq $0, (%edx){1to8}, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x5a,0x00,0x12,0x00]     
vpermq $0, (%edx){1to8}, %zmm2 {%k2} 

// CHECK: vpermq $0, (%edx){1to8}, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xda,0x00,0x12,0x00]    
vpermq $0, (%edx){1to8}, %zmm2 {%k2} {z} 

// CHECK: vpermq $0, (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x00,0x12,0x00]      
vpermq $0, (%edx), %zmm2 

// CHECK: vpermq $0, (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x00,0x12,0x00]     
vpermq $0, (%edx), %zmm2 {%k2} 

// CHECK: vpermq $0, (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x00,0x12,0x00]    
vpermq $0, (%edx), %zmm2 {%k2} {z} 

// CHECK: vpermq $0, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf3,0xfd,0x48,0x00,0xd2,0x00]      
vpermq $0, %zmm2, %zmm2 

// CHECK: vpermq $0, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf3,0xfd,0x4a,0x00,0xd2,0x00]     
vpermq $0, %zmm2, %zmm2 {%k2} 

// CHECK: vpermq $0, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf3,0xfd,0xca,0x00,0xd2,0x00]    
vpermq $0, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermq 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x36,0x54,0x02,0x40]      
vpermq 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpermq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x36,0x54,0x02,0x40]     
vpermq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpermq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x36,0x54,0x02,0x40]    
vpermq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermq 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x36,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermq 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vpermq 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x36,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermq 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermq 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x36,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermq 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermq 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x36,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermq 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpermq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x36,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x36,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x36,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpermq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x36,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpermq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x36,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x36,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x36,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x36,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermq -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x36,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermq -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermq 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x36,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermq 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x36,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x36,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x36,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x36,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermq 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x36,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermq 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpermq 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x36,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermq 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermq 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x36,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermq 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermq 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x36,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermq 485498096, %zmm2, %zmm2 

// CHECK: vpermq 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x36,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermq 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpermq 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x36,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermq 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermq 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x36,0x54,0x02,0x40]      
vpermq 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vpermq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x36,0x54,0x02,0x40]     
vpermq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x36,0x54,0x02,0x40]    
vpermq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermq (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x36,0x12]      
vpermq (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpermq (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x36,0x12]     
vpermq (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermq (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x36,0x12]    
vpermq (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermq (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x36,0x12]      
vpermq (%edx), %zmm2, %zmm2 

// CHECK: vpermq (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x36,0x12]     
vpermq (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermq (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x36,0x12]    
vpermq (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermq %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x36,0xd2]      
vpermq %zmm2, %zmm2, %zmm2 

// CHECK: vpermq %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x36,0xd2]     
vpermq %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpermq %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x36,0xd2]    
vpermq %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2d 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x7e,0x54,0x02,0x40]      
vpermt2d 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vpermt2d 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x7e,0x54,0x02,0x40]     
vpermt2d 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2d 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x7e,0x54,0x02,0x40]    
vpermt2d 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2d 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x7e,0x54,0x02,0x40]      
vpermt2d 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpermt2d 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x7e,0x54,0x02,0x40]     
vpermt2d 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2d 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x7e,0x54,0x02,0x40]    
vpermt2d 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2d 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x7e,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermt2d 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vpermt2d 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x7e,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermt2d 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2d 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x7e,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermt2d 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2d 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x7e,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermt2d 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpermt2d 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x7e,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermt2d 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2d 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x7e,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermt2d 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2d -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x7e,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermt2d -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpermt2d 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x7e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermt2d 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpermt2d -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x7e,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermt2d -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2d 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x7e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermt2d 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2d -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x7e,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermt2d -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2d 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x7e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermt2d 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2d -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x7e,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermt2d -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermt2d 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x7e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermt2d 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermt2d -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x7e,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermt2d -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2d 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x7e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermt2d 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2d -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x7e,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermt2d -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2d 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x7e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermt2d 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2d 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x7e,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermt2d 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpermt2d 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x7e,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermt2d 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2d 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x7e,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermt2d 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2d 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x7e,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermt2d 485498096, %zmm2, %zmm2 

// CHECK: vpermt2d 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x7e,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermt2d 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2d 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x7e,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermt2d 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2d (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x7e,0x12]      
vpermt2d (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpermt2d (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x7e,0x12]     
vpermt2d (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2d (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x7e,0x12]    
vpermt2d (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2d (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x7e,0x12]      
vpermt2d (%edx), %zmm2, %zmm2 

// CHECK: vpermt2d (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x7e,0x12]     
vpermt2d (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2d (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x7e,0x12]    
vpermt2d (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2d %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x7e,0xd2]      
vpermt2d %zmm2, %zmm2, %zmm2 

// CHECK: vpermt2d %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x7e,0xd2]     
vpermt2d %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2d %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x7e,0xd2]    
vpermt2d %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2pd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x7f,0x54,0x02,0x40]      
vpermt2pd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpermt2pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x7f,0x54,0x02,0x40]     
vpermt2pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x7f,0x54,0x02,0x40]    
vpermt2pd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2pd 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x7f,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermt2pd 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vpermt2pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x7f,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermt2pd 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x7f,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermt2pd 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2pd 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x7f,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermt2pd 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpermt2pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x7f,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermt2pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x7f,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermt2pd 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x7f,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermt2pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpermt2pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x7f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermt2pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpermt2pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x7f,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermt2pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x7f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermt2pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x7f,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermt2pd -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x7f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermt2pd 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2pd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x7f,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermt2pd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermt2pd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x7f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermt2pd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermt2pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x7f,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermt2pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x7f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermt2pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x7f,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermt2pd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x7f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermt2pd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2pd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x7f,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermt2pd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpermt2pd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x7f,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermt2pd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x7f,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermt2pd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2pd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x7f,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermt2pd 485498096, %zmm2, %zmm2 

// CHECK: vpermt2pd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x7f,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermt2pd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2pd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x7f,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermt2pd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x7f,0x54,0x02,0x40]      
vpermt2pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vpermt2pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x7f,0x54,0x02,0x40]     
vpermt2pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x7f,0x54,0x02,0x40]    
vpermt2pd 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2pd (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x7f,0x12]      
vpermt2pd (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpermt2pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x7f,0x12]     
vpermt2pd (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x7f,0x12]    
vpermt2pd (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2pd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x7f,0x12]      
vpermt2pd (%edx), %zmm2, %zmm2 

// CHECK: vpermt2pd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x7f,0x12]     
vpermt2pd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2pd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x7f,0x12]    
vpermt2pd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2pd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x7f,0xd2]      
vpermt2pd %zmm2, %zmm2, %zmm2 

// CHECK: vpermt2pd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x7f,0xd2]     
vpermt2pd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2pd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x7f,0xd2]    
vpermt2pd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x7f,0x54,0x02,0x40]      
vpermt2ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vpermt2ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x7f,0x54,0x02,0x40]     
vpermt2ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x7f,0x54,0x02,0x40]    
vpermt2ps 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2ps 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x7f,0x54,0x02,0x40]      
vpermt2ps 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpermt2ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x7f,0x54,0x02,0x40]     
vpermt2ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x7f,0x54,0x02,0x40]    
vpermt2ps 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2ps 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x7f,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermt2ps 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vpermt2ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x7f,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermt2ps 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x7f,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermt2ps 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2ps 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x7f,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermt2ps 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpermt2ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x7f,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermt2ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x7f,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermt2ps 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x7f,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermt2ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpermt2ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x7f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermt2ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpermt2ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x7f,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermt2ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x7f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermt2ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x7f,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermt2ps -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x7f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermt2ps 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2ps -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x7f,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermt2ps -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermt2ps 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x7f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermt2ps 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermt2ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x7f,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermt2ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x7f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermt2ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x7f,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermt2ps -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x7f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermt2ps 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2ps 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x7f,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermt2ps 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpermt2ps 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x7f,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermt2ps 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x7f,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermt2ps 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2ps 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x7f,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermt2ps 485498096, %zmm2, %zmm2 

// CHECK: vpermt2ps 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x7f,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermt2ps 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2ps 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x7f,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermt2ps 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2ps (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x7f,0x12]      
vpermt2ps (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpermt2ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x7f,0x12]     
vpermt2ps (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x7f,0x12]    
vpermt2ps (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2ps (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x7f,0x12]      
vpermt2ps (%edx), %zmm2, %zmm2 

// CHECK: vpermt2ps (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x7f,0x12]     
vpermt2ps (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2ps (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x7f,0x12]    
vpermt2ps (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2ps %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x7f,0xd2]      
vpermt2ps %zmm2, %zmm2, %zmm2 

// CHECK: vpermt2ps %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x7f,0xd2]     
vpermt2ps %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2ps %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x7f,0xd2]    
vpermt2ps %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2q 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x7e,0x54,0x02,0x40]      
vpermt2q 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpermt2q 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x7e,0x54,0x02,0x40]     
vpermt2q 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2q 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x7e,0x54,0x02,0x40]    
vpermt2q 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2q 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x7e,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermt2q 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vpermt2q 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x7e,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermt2q 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2q 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x7e,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermt2q 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2q 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x7e,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermt2q 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpermt2q 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x7e,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermt2q 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2q 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x7e,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermt2q 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2q -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x7e,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermt2q -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpermt2q 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x7e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermt2q 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpermt2q -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x7e,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermt2q -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2q 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x7e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermt2q 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2q -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x7e,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermt2q -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2q 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x7e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermt2q 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2q -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x7e,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpermt2q -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermt2q 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x7e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpermt2q 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpermt2q -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x7e,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpermt2q -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2q 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x7e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpermt2q 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2q -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x7e,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpermt2q -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2q 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x7e,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpermt2q 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2q 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x7e,0x92,0xf0,0x1c,0xf0,0x1c]      
vpermt2q 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpermt2q 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x7e,0x92,0xf0,0x1c,0xf0,0x1c]     
vpermt2q 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2q 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x7e,0x92,0xf0,0x1c,0xf0,0x1c]    
vpermt2q 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2q 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x7e,0x15,0xf0,0x1c,0xf0,0x1c]      
vpermt2q 485498096, %zmm2, %zmm2 

// CHECK: vpermt2q 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x7e,0x15,0xf0,0x1c,0xf0,0x1c]     
vpermt2q 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2q 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x7e,0x15,0xf0,0x1c,0xf0,0x1c]    
vpermt2q 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2q 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x7e,0x54,0x02,0x40]      
vpermt2q 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vpermt2q 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x7e,0x54,0x02,0x40]     
vpermt2q 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2q 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x7e,0x54,0x02,0x40]    
vpermt2q 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2q (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x7e,0x12]      
vpermt2q (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpermt2q (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x7e,0x12]     
vpermt2q (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2q (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x7e,0x12]    
vpermt2q (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2q (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x7e,0x12]      
vpermt2q (%edx), %zmm2, %zmm2 

// CHECK: vpermt2q (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x7e,0x12]     
vpermt2q (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2q (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x7e,0x12]    
vpermt2q (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpermt2q %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x7e,0xd2]      
vpermt2q %zmm2, %zmm2, %zmm2 

// CHECK: vpermt2q %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x7e,0xd2]     
vpermt2q %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpermt2q %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x7e,0xd2]    
vpermt2q %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpexpandd 256(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x89,0x54,0x02,0x40]       
vpexpandd 256(%edx,%eax), %zmm2 

// CHECK: vpexpandd 256(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x89,0x54,0x02,0x40]      
vpexpandd 256(%edx,%eax), %zmm2 {%k2} 

// CHECK: vpexpandd 256(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x89,0x54,0x02,0x40]     
vpexpandd 256(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vpexpandd -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x89,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vpexpandd -485498096(%edx,%eax,4), %zmm2 

// CHECK: vpexpandd 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x89,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vpexpandd 485498096(%edx,%eax,4), %zmm2 

// CHECK: vpexpandd -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x89,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpexpandd -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpexpandd 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x89,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpexpandd 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpexpandd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x89,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpexpandd -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpexpandd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x89,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpexpandd 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpexpandd 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x89,0x92,0xf0,0x1c,0xf0,0x1c]       
vpexpandd 485498096(%edx), %zmm2 

// CHECK: vpexpandd 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x89,0x92,0xf0,0x1c,0xf0,0x1c]      
vpexpandd 485498096(%edx), %zmm2 {%k2} 

// CHECK: vpexpandd 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x89,0x92,0xf0,0x1c,0xf0,0x1c]     
vpexpandd 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vpexpandd 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x89,0x15,0xf0,0x1c,0xf0,0x1c]       
vpexpandd 485498096, %zmm2 

// CHECK: vpexpandd 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x89,0x15,0xf0,0x1c,0xf0,0x1c]      
vpexpandd 485498096, %zmm2 {%k2} 

// CHECK: vpexpandd 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x89,0x15,0xf0,0x1c,0xf0,0x1c]     
vpexpandd 485498096, %zmm2 {%k2} {z} 

// CHECK: vpexpandd (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x89,0x12]       
vpexpandd (%edx), %zmm2 

// CHECK: vpexpandd (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x89,0x12]      
vpexpandd (%edx), %zmm2 {%k2} 

// CHECK: vpexpandd (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x89,0x12]     
vpexpandd (%edx), %zmm2 {%k2} {z} 

// CHECK: vpexpandd %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x89,0xd2]       
vpexpandd %zmm2, %zmm2 

// CHECK: vpexpandd %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x89,0xd2]      
vpexpandd %zmm2, %zmm2 {%k2} 

// CHECK: vpexpandd %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x7d,0xca,0x89,0xd2]     
vpexpandd %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpexpandq -485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x89,0x94,0x82,0x10,0xe3,0x0f,0xe3]       
vpexpandq -485498096(%edx,%eax,4), %zmm2 

// CHECK: vpexpandq 485498096(%edx,%eax,4), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x89,0x94,0x82,0xf0,0x1c,0xf0,0x1c]       
vpexpandq 485498096(%edx,%eax,4), %zmm2 

// CHECK: vpexpandq -485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x89,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpexpandq -485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpexpandq 485498096(%edx,%eax,4), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x89,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpexpandq 485498096(%edx,%eax,4), %zmm2 {%k2} 

// CHECK: vpexpandq -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x89,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpexpandq -485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpexpandq 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x89,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpexpandq 485498096(%edx,%eax,4), %zmm2 {%k2} {z} 

// CHECK: vpexpandq 485498096(%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x89,0x92,0xf0,0x1c,0xf0,0x1c]       
vpexpandq 485498096(%edx), %zmm2 

// CHECK: vpexpandq 485498096(%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x89,0x92,0xf0,0x1c,0xf0,0x1c]      
vpexpandq 485498096(%edx), %zmm2 {%k2} 

// CHECK: vpexpandq 485498096(%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x89,0x92,0xf0,0x1c,0xf0,0x1c]     
vpexpandq 485498096(%edx), %zmm2 {%k2} {z} 

// CHECK: vpexpandq 485498096, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x89,0x15,0xf0,0x1c,0xf0,0x1c]       
vpexpandq 485498096, %zmm2 

// CHECK: vpexpandq 485498096, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x89,0x15,0xf0,0x1c,0xf0,0x1c]      
vpexpandq 485498096, %zmm2 {%k2} 

// CHECK: vpexpandq 485498096, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x89,0x15,0xf0,0x1c,0xf0,0x1c]     
vpexpandq 485498096, %zmm2 {%k2} {z} 

// CHECK: vpexpandq 512(%edx,%eax), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x89,0x54,0x02,0x40]       
vpexpandq 512(%edx,%eax), %zmm2 

// CHECK: vpexpandq 512(%edx,%eax), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x89,0x54,0x02,0x40]      
vpexpandq 512(%edx,%eax), %zmm2 {%k2} 

// CHECK: vpexpandq 512(%edx,%eax), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x89,0x54,0x02,0x40]     
vpexpandq 512(%edx,%eax), %zmm2 {%k2} {z} 

// CHECK: vpexpandq (%edx), %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x89,0x12]       
vpexpandq (%edx), %zmm2 

// CHECK: vpexpandq (%edx), %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x89,0x12]      
vpexpandq (%edx), %zmm2 {%k2} 

// CHECK: vpexpandq (%edx), %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x89,0x12]     
vpexpandq (%edx), %zmm2 {%k2} {z} 

// CHECK: vpexpandq %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x89,0xd2]       
vpexpandq %zmm2, %zmm2 

// CHECK: vpexpandq %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x89,0xd2]      
vpexpandq %zmm2, %zmm2 {%k2} 

// CHECK: vpexpandq %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xfd,0xca,0x89,0xd2]     
vpexpandq %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpgatherdd 256(%edx,%zmm3), %zmm2 {%k3} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4b,0x90,0x54,0x1a,0x40]      
vpgatherdd 256(%edx,%zmm3), %zmm2 {%k3} 

// CHECK: vpgatherdd -485498096(%edx,%zmm3,4), %zmm2 {%k3} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4b,0x90,0x94,0x9a,0x10,0xe3,0x0f,0xe3]      
vpgatherdd -485498096(%edx,%zmm3,4), %zmm2 {%k3} 

// CHECK: vpgatherdd 485498096(%edx,%zmm3,4), %zmm2 {%k3} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4b,0x90,0x94,0x9a,0xf0,0x1c,0xf0,0x1c]      
vpgatherdd 485498096(%edx,%zmm3,4), %zmm2 {%k3} 

// CHECK: vpgatherdq -485498096(%edx,%ymm3,4), %zmm2 {%k3} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4b,0x90,0x94,0x9a,0x10,0xe3,0x0f,0xe3]      
vpgatherdq -485498096(%edx,%ymm3,4), %zmm2 {%k3} 

// CHECK: vpgatherdq 485498096(%edx,%ymm3,4), %zmm2 {%k3} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4b,0x90,0x94,0x9a,0xf0,0x1c,0xf0,0x1c]      
vpgatherdq 485498096(%edx,%ymm3,4), %zmm2 {%k3} 

// CHECK: vpgatherdq 512(%edx,%ymm3), %zmm2 {%k3} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4b,0x90,0x54,0x1a,0x40]      
vpgatherdq 512(%edx,%ymm3), %zmm2 {%k3} 

// CHECK: vpgatherqd 256(%edx,%zmm3), %ymm4 {%k3} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4b,0x91,0x64,0x1a,0x40]      
vpgatherqd 256(%edx,%zmm3), %ymm4 {%k3} 

// CHECK: vpgatherqd -485498096(%edx,%zmm3,4), %ymm4 {%k3} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4b,0x91,0xa4,0x9a,0x10,0xe3,0x0f,0xe3]      
vpgatherqd -485498096(%edx,%zmm3,4), %ymm4 {%k3} 

// CHECK: vpgatherqd 485498096(%edx,%zmm3,4), %ymm4 {%k3} 
// CHECK: encoding: [0x62,0xf2,0x7d,0x4b,0x91,0xa4,0x9a,0xf0,0x1c,0xf0,0x1c]      
vpgatherqd 485498096(%edx,%zmm3,4), %ymm4 {%k3} 

// CHECK: vpgatherqq -485498096(%edx,%zmm3,4), %zmm2 {%k3} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4b,0x91,0x94,0x9a,0x10,0xe3,0x0f,0xe3]      
vpgatherqq -485498096(%edx,%zmm3,4), %zmm2 {%k3} 

// CHECK: vpgatherqq 485498096(%edx,%zmm3,4), %zmm2 {%k3} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4b,0x91,0x94,0x9a,0xf0,0x1c,0xf0,0x1c]      
vpgatherqq 485498096(%edx,%zmm3,4), %zmm2 {%k3} 

// CHECK: vpgatherqq 512(%edx,%zmm3), %zmm2 {%k3} 
// CHECK: encoding: [0x62,0xf2,0xfd,0x4b,0x91,0x54,0x1a,0x40]      
vpgatherqq 512(%edx,%zmm3), %zmm2 {%k3} 

// CHECK: vpmaxsd 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x3d,0x54,0x02,0x40]      
vpmaxsd 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vpmaxsd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x3d,0x54,0x02,0x40]     
vpmaxsd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x3d,0x54,0x02,0x40]    
vpmaxsd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x3d,0x54,0x02,0x40]      
vpmaxsd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpmaxsd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x3d,0x54,0x02,0x40]     
vpmaxsd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x3d,0x54,0x02,0x40]    
vpmaxsd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsd 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x3d,0x15,0xf0,0x1c,0xf0,0x1c]      
vpmaxsd 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vpmaxsd 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x3d,0x15,0xf0,0x1c,0xf0,0x1c]     
vpmaxsd 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsd 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x3d,0x15,0xf0,0x1c,0xf0,0x1c]    
vpmaxsd 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsd 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x3d,0x92,0xf0,0x1c,0xf0,0x1c]      
vpmaxsd 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpmaxsd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x3d,0x92,0xf0,0x1c,0xf0,0x1c]     
vpmaxsd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x3d,0x92,0xf0,0x1c,0xf0,0x1c]    
vpmaxsd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x3d,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpmaxsd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpmaxsd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x3d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpmaxsd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpmaxsd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x3d,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpmaxsd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x3d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpmaxsd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x3d,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpmaxsd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x3d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpmaxsd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x3d,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpmaxsd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpmaxsd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x3d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpmaxsd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpmaxsd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x3d,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpmaxsd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x3d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpmaxsd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x3d,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpmaxsd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x3d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpmaxsd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x3d,0x92,0xf0,0x1c,0xf0,0x1c]      
vpmaxsd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpmaxsd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x3d,0x92,0xf0,0x1c,0xf0,0x1c]     
vpmaxsd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x3d,0x92,0xf0,0x1c,0xf0,0x1c]    
vpmaxsd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x3d,0x15,0xf0,0x1c,0xf0,0x1c]      
vpmaxsd 485498096, %zmm2, %zmm2 

// CHECK: vpmaxsd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x3d,0x15,0xf0,0x1c,0xf0,0x1c]     
vpmaxsd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x3d,0x15,0xf0,0x1c,0xf0,0x1c]    
vpmaxsd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsd (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x3d,0x12]      
vpmaxsd (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpmaxsd (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x3d,0x12]     
vpmaxsd (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsd (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x3d,0x12]    
vpmaxsd (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x3d,0x12]      
vpmaxsd (%edx), %zmm2, %zmm2 

// CHECK: vpmaxsd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x3d,0x12]     
vpmaxsd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x3d,0x12]    
vpmaxsd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x3d,0xd2]      
vpmaxsd %zmm2, %zmm2, %zmm2 

// CHECK: vpmaxsd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x3d,0xd2]     
vpmaxsd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x3d,0xd2]    
vpmaxsd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsq 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x3d,0x54,0x02,0x40]      
vpmaxsq 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpmaxsq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x3d,0x54,0x02,0x40]     
vpmaxsq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x3d,0x54,0x02,0x40]    
vpmaxsq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsq 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x3d,0x15,0xf0,0x1c,0xf0,0x1c]      
vpmaxsq 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vpmaxsq 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x3d,0x15,0xf0,0x1c,0xf0,0x1c]     
vpmaxsq 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsq 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x3d,0x15,0xf0,0x1c,0xf0,0x1c]    
vpmaxsq 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsq 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x3d,0x92,0xf0,0x1c,0xf0,0x1c]      
vpmaxsq 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpmaxsq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x3d,0x92,0xf0,0x1c,0xf0,0x1c]     
vpmaxsq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x3d,0x92,0xf0,0x1c,0xf0,0x1c]    
vpmaxsq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x3d,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpmaxsq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpmaxsq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x3d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpmaxsq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpmaxsq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x3d,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpmaxsq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x3d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpmaxsq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x3d,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpmaxsq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x3d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpmaxsq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsq -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x3d,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpmaxsq -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpmaxsq 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x3d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpmaxsq 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpmaxsq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x3d,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpmaxsq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x3d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpmaxsq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x3d,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpmaxsq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x3d,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpmaxsq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsq 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x3d,0x92,0xf0,0x1c,0xf0,0x1c]      
vpmaxsq 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpmaxsq 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x3d,0x92,0xf0,0x1c,0xf0,0x1c]     
vpmaxsq 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsq 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x3d,0x92,0xf0,0x1c,0xf0,0x1c]    
vpmaxsq 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsq 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x3d,0x15,0xf0,0x1c,0xf0,0x1c]      
vpmaxsq 485498096, %zmm2, %zmm2 

// CHECK: vpmaxsq 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x3d,0x15,0xf0,0x1c,0xf0,0x1c]     
vpmaxsq 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsq 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x3d,0x15,0xf0,0x1c,0xf0,0x1c]    
vpmaxsq 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsq 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x3d,0x54,0x02,0x40]      
vpmaxsq 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vpmaxsq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x3d,0x54,0x02,0x40]     
vpmaxsq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x3d,0x54,0x02,0x40]    
vpmaxsq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsq (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x3d,0x12]      
vpmaxsq (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpmaxsq (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x3d,0x12]     
vpmaxsq (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsq (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x3d,0x12]    
vpmaxsq (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsq (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x3d,0x12]      
vpmaxsq (%edx), %zmm2, %zmm2 

// CHECK: vpmaxsq (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x3d,0x12]     
vpmaxsq (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsq (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x3d,0x12]    
vpmaxsq (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxsq %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x3d,0xd2]      
vpmaxsq %zmm2, %zmm2, %zmm2 

// CHECK: vpmaxsq %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x3d,0xd2]     
vpmaxsq %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxsq %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x3d,0xd2]    
vpmaxsq %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxud 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x3f,0x54,0x02,0x40]      
vpmaxud 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vpmaxud 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x3f,0x54,0x02,0x40]     
vpmaxud 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxud 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x3f,0x54,0x02,0x40]    
vpmaxud 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxud 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x3f,0x54,0x02,0x40]      
vpmaxud 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpmaxud 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x3f,0x54,0x02,0x40]     
vpmaxud 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxud 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x3f,0x54,0x02,0x40]    
vpmaxud 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxud 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x3f,0x15,0xf0,0x1c,0xf0,0x1c]      
vpmaxud 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vpmaxud 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x3f,0x15,0xf0,0x1c,0xf0,0x1c]     
vpmaxud 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxud 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x3f,0x15,0xf0,0x1c,0xf0,0x1c]    
vpmaxud 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxud 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x3f,0x92,0xf0,0x1c,0xf0,0x1c]      
vpmaxud 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpmaxud 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x3f,0x92,0xf0,0x1c,0xf0,0x1c]     
vpmaxud 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxud 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x3f,0x92,0xf0,0x1c,0xf0,0x1c]    
vpmaxud 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxud -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x3f,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpmaxud -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpmaxud 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x3f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpmaxud 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpmaxud -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x3f,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpmaxud -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxud 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x3f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpmaxud 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxud -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x3f,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpmaxud -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxud 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x3f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpmaxud 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxud -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x3f,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpmaxud -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpmaxud 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x3f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpmaxud 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpmaxud -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x3f,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpmaxud -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxud 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x3f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpmaxud 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxud -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x3f,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpmaxud -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxud 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x3f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpmaxud 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxud 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x3f,0x92,0xf0,0x1c,0xf0,0x1c]      
vpmaxud 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpmaxud 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x3f,0x92,0xf0,0x1c,0xf0,0x1c]     
vpmaxud 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxud 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x3f,0x92,0xf0,0x1c,0xf0,0x1c]    
vpmaxud 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxud 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x3f,0x15,0xf0,0x1c,0xf0,0x1c]      
vpmaxud 485498096, %zmm2, %zmm2 

// CHECK: vpmaxud 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x3f,0x15,0xf0,0x1c,0xf0,0x1c]     
vpmaxud 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxud 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x3f,0x15,0xf0,0x1c,0xf0,0x1c]    
vpmaxud 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxud (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x3f,0x12]      
vpmaxud (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpmaxud (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x3f,0x12]     
vpmaxud (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxud (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x3f,0x12]    
vpmaxud (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxud (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x3f,0x12]      
vpmaxud (%edx), %zmm2, %zmm2 

// CHECK: vpmaxud (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x3f,0x12]     
vpmaxud (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxud (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x3f,0x12]    
vpmaxud (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxud %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x3f,0xd2]      
vpmaxud %zmm2, %zmm2, %zmm2 

// CHECK: vpmaxud %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x3f,0xd2]     
vpmaxud %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxud %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x3f,0xd2]    
vpmaxud %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxuq 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x3f,0x54,0x02,0x40]      
vpmaxuq 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpmaxuq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x3f,0x54,0x02,0x40]     
vpmaxuq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxuq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x3f,0x54,0x02,0x40]    
vpmaxuq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxuq 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x3f,0x15,0xf0,0x1c,0xf0,0x1c]      
vpmaxuq 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vpmaxuq 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x3f,0x15,0xf0,0x1c,0xf0,0x1c]     
vpmaxuq 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxuq 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x3f,0x15,0xf0,0x1c,0xf0,0x1c]    
vpmaxuq 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxuq 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x3f,0x92,0xf0,0x1c,0xf0,0x1c]      
vpmaxuq 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpmaxuq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x3f,0x92,0xf0,0x1c,0xf0,0x1c]     
vpmaxuq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxuq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x3f,0x92,0xf0,0x1c,0xf0,0x1c]    
vpmaxuq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxuq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x3f,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpmaxuq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpmaxuq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x3f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpmaxuq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpmaxuq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x3f,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpmaxuq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxuq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x3f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpmaxuq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxuq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x3f,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpmaxuq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxuq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x3f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpmaxuq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxuq -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x3f,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpmaxuq -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpmaxuq 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x3f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpmaxuq 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpmaxuq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x3f,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpmaxuq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxuq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x3f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpmaxuq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxuq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x3f,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpmaxuq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxuq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x3f,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpmaxuq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxuq 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x3f,0x92,0xf0,0x1c,0xf0,0x1c]      
vpmaxuq 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpmaxuq 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x3f,0x92,0xf0,0x1c,0xf0,0x1c]     
vpmaxuq 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxuq 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x3f,0x92,0xf0,0x1c,0xf0,0x1c]    
vpmaxuq 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxuq 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x3f,0x15,0xf0,0x1c,0xf0,0x1c]      
vpmaxuq 485498096, %zmm2, %zmm2 

// CHECK: vpmaxuq 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x3f,0x15,0xf0,0x1c,0xf0,0x1c]     
vpmaxuq 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxuq 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x3f,0x15,0xf0,0x1c,0xf0,0x1c]    
vpmaxuq 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxuq 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x3f,0x54,0x02,0x40]      
vpmaxuq 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vpmaxuq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x3f,0x54,0x02,0x40]     
vpmaxuq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxuq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x3f,0x54,0x02,0x40]    
vpmaxuq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxuq (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x3f,0x12]      
vpmaxuq (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpmaxuq (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x3f,0x12]     
vpmaxuq (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxuq (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x3f,0x12]    
vpmaxuq (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxuq (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x3f,0x12]      
vpmaxuq (%edx), %zmm2, %zmm2 

// CHECK: vpmaxuq (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x3f,0x12]     
vpmaxuq (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxuq (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x3f,0x12]    
vpmaxuq (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpmaxuq %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x3f,0xd2]      
vpmaxuq %zmm2, %zmm2, %zmm2 

// CHECK: vpmaxuq %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x3f,0xd2]     
vpmaxuq %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpmaxuq %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x3f,0xd2]    
vpmaxuq %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsd 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x39,0x54,0x02,0x40]      
vpminsd 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vpminsd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x39,0x54,0x02,0x40]     
vpminsd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpminsd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x39,0x54,0x02,0x40]    
vpminsd 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsd 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x39,0x54,0x02,0x40]      
vpminsd 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpminsd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x39,0x54,0x02,0x40]     
vpminsd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpminsd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x39,0x54,0x02,0x40]    
vpminsd 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsd 485498096{1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x39,0x15,0xf0,0x1c,0xf0,0x1c]      
vpminsd 485498096{1to16}, %zmm2, %zmm2 

// CHECK: vpminsd 485498096{1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x39,0x15,0xf0,0x1c,0xf0,0x1c]     
vpminsd 485498096{1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpminsd 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x39,0x15,0xf0,0x1c,0xf0,0x1c]    
vpminsd 485498096{1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsd 485498096(%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x39,0x92,0xf0,0x1c,0xf0,0x1c]      
vpminsd 485498096(%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpminsd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x39,0x92,0xf0,0x1c,0xf0,0x1c]     
vpminsd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpminsd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x39,0x92,0xf0,0x1c,0xf0,0x1c]    
vpminsd 485498096(%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x39,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpminsd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpminsd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x39,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpminsd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 

// CHECK: vpminsd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x39,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpminsd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpminsd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x39,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpminsd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpminsd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x39,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpminsd -485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x39,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpminsd 485498096(%edx,%eax,4){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsd -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x39,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpminsd -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpminsd 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x39,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpminsd 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpminsd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x39,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpminsd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpminsd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x39,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpminsd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpminsd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x39,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpminsd -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x39,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpminsd 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsd 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x39,0x92,0xf0,0x1c,0xf0,0x1c]      
vpminsd 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpminsd 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x39,0x92,0xf0,0x1c,0xf0,0x1c]     
vpminsd 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpminsd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x39,0x92,0xf0,0x1c,0xf0,0x1c]    
vpminsd 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsd 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x39,0x15,0xf0,0x1c,0xf0,0x1c]      
vpminsd 485498096, %zmm2, %zmm2 

// CHECK: vpminsd 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x39,0x15,0xf0,0x1c,0xf0,0x1c]     
vpminsd 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpminsd 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x39,0x15,0xf0,0x1c,0xf0,0x1c]    
vpminsd 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsd (%edx){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x39,0x12]      
vpminsd (%edx){1to16}, %zmm2, %zmm2 

// CHECK: vpminsd (%edx){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x39,0x12]     
vpminsd (%edx){1to16}, %zmm2, %zmm2 {%k2} 

// CHECK: vpminsd (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xda,0x39,0x12]    
vpminsd (%edx){1to16}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsd (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x39,0x12]      
vpminsd (%edx), %zmm2, %zmm2 

// CHECK: vpminsd (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x39,0x12]     
vpminsd (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpminsd (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x39,0x12]    
vpminsd (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsd %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x48,0x39,0xd2]      
vpminsd %zmm2, %zmm2, %zmm2 

// CHECK: vpminsd %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x4a,0x39,0xd2]     
vpminsd %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpminsd %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0x6d,0xca,0x39,0xd2]    
vpminsd %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsq 4096(%edx,%eax), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x39,0x54,0x02,0x40]      
vpminsq 4096(%edx,%eax), %zmm2, %zmm2 

// CHECK: vpminsq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x39,0x54,0x02,0x40]     
vpminsq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} 

// CHECK: vpminsq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x39,0x54,0x02,0x40]    
vpminsq 4096(%edx,%eax), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsq 485498096{1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x39,0x15,0xf0,0x1c,0xf0,0x1c]      
vpminsq 485498096{1to8}, %zmm2, %zmm2 

// CHECK: vpminsq 485498096{1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x39,0x15,0xf0,0x1c,0xf0,0x1c]     
vpminsq 485498096{1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpminsq 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x39,0x15,0xf0,0x1c,0xf0,0x1c]    
vpminsq 485498096{1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsq 485498096(%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x39,0x92,0xf0,0x1c,0xf0,0x1c]      
vpminsq 485498096(%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpminsq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x39,0x92,0xf0,0x1c,0xf0,0x1c]     
vpminsq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpminsq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x39,0x92,0xf0,0x1c,0xf0,0x1c]    
vpminsq 485498096(%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x39,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpminsq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpminsq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x39,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpminsq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 

// CHECK: vpminsq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x39,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpminsq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpminsq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x39,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpminsq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpminsq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x39,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpminsq -485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x39,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpminsq 485498096(%edx,%eax,4){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsq -485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x39,0x94,0x82,0x10,0xe3,0x0f,0xe3]      
vpminsq -485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpminsq 485498096(%edx,%eax,4), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x39,0x94,0x82,0xf0,0x1c,0xf0,0x1c]      
vpminsq 485498096(%edx,%eax,4), %zmm2, %zmm2 

// CHECK: vpminsq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x39,0x94,0x82,0x10,0xe3,0x0f,0xe3]     
vpminsq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpminsq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x39,0x94,0x82,0xf0,0x1c,0xf0,0x1c]     
vpminsq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} 

// CHECK: vpminsq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x39,0x94,0x82,0x10,0xe3,0x0f,0xe3]    
vpminsq -485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x39,0x94,0x82,0xf0,0x1c,0xf0,0x1c]    
vpminsq 485498096(%edx,%eax,4), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsq 485498096(%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x39,0x92,0xf0,0x1c,0xf0,0x1c]      
vpminsq 485498096(%edx), %zmm2, %zmm2 

// CHECK: vpminsq 485498096(%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x39,0x92,0xf0,0x1c,0xf0,0x1c]     
vpminsq 485498096(%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpminsq 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x39,0x92,0xf0,0x1c,0xf0,0x1c]    
vpminsq 485498096(%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsq 485498096, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x39,0x15,0xf0,0x1c,0xf0,0x1c]      
vpminsq 485498096, %zmm2, %zmm2 

// CHECK: vpminsq 485498096, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x39,0x15,0xf0,0x1c,0xf0,0x1c]     
vpminsq 485498096, %zmm2, %zmm2 {%k2} 

// CHECK: vpminsq 485498096, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x39,0x15,0xf0,0x1c,0xf0,0x1c]    
vpminsq 485498096, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsq 512(%edx,%eax){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x39,0x54,0x02,0x40]      
vpminsq 512(%edx,%eax){1to8}, %zmm2, %zmm2 

// CHECK: vpminsq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x39,0x54,0x02,0x40]     
vpminsq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpminsq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x39,0x54,0x02,0x40]    
vpminsq 512(%edx,%eax){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsq (%edx){1to8}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x58,0x39,0x12]      
vpminsq (%edx){1to8}, %zmm2, %zmm2 

// CHECK: vpminsq (%edx){1to8}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x5a,0x39,0x12]     
vpminsq (%edx){1to8}, %zmm2, %zmm2 {%k2} 

// CHECK: vpminsq (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xda,0x39,0x12]    
vpminsq (%edx){1to8}, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsq (%edx), %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x39,0x12]      
vpminsq (%edx), %zmm2, %zmm2 

// CHECK: vpminsq (%edx), %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x39,0x12]     
vpminsq (%edx), %zmm2, %zmm2 {%k2} 

// CHECK: vpminsq (%edx), %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x39,0x12]    
vpminsq (%edx), %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminsq %zmm2, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0xed,0x48,0x39,0xd2]      
vpminsq %zmm2, %zmm2, %zmm2 

// CHECK: vpminsq %zmm2, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0xed,0x4a,0x39,0xd2]     
vpminsq %zmm2, %zmm2, %zmm2 {%k2} 

// CHECK: vpminsq %zmm2, %zmm2, %zmm2 {%k2} {z} 
// CHECK: encoding: [0x62,0xf2,0xed,0xca,0x39,0xd2]    
vpminsq %zmm2, %zmm2, %zmm2 {%k2} {z} 

// CHECK: vpminud 256(%edx,%eax){1to16}, %zmm2, %zmm2 
// CHECK: encoding: [0x62,0xf2,0x6d,0x58,0x3b,0x54,0x02,0x40]      
vpminud 256(%edx,%eax){1to16}, %zmm2, %zmm2 

// CHECK: vpminud 256(%edx,%eax){1to16}, %zmm2, %zmm2 {%k2} 
// CHECK: encoding: [0x62,0xf2,0x6d,0x5a,0x3b,0x54,0x02,0x40]     
vpminud 256(%edx,%eax){1to16}, %zmm2