/*--------------------------------------------------------------------------+
$Id: FilenameFilter.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.filesystem;

import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/**
 * This is a file filter that accepts only filenames out of a list of filenames
 * 
 * @author Elmar Juergens
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 7DA7526D19E61401397E1515B6135BD1
 */
public class FilenameFilter implements FileFilter {

	/** List of file names */
	private final Set<String> filenames;

	/** Constructor */
	public FilenameFilter(Collection<String> filenames) {
		this.filenames = new HashSet<String>(filenames);
	}

	/** {@inheritDoc} */
	public boolean accept(File file) {
		return filenames.contains(file.getName());
	}

}