/*--------------------------------------------------------------------------+
$Id: FlatTreeMapRenderer.java 26931 2010-03-17 14:53:13Z besenreu $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.treemap;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;


/**
 * A very simple tree map renderer just drawing "flat" rectangles.
 * 
 * @author Benjamin Hummel
 * @author $Author: besenreu $
 * @version $Rev: 26931 $
 * @levd.rating GREEN Hash: B52F73980DF98FACCD4B858A5872C409
 */
public class FlatTreeMapRenderer implements ITreeMapRenderer {

	/** {@inheritDoc} */
	public <T> void renderTreeMap(ITreeMapNode<T> node, Graphics2D graphics) {
		if (node.getChildren().isEmpty()) {
			Rectangle2D rect = node.getLayoutRectangle();
			graphics.setColor(node.getColor());
			graphics.fill(rect);

			if (node.getDrawingPattern() != null) {
				drawPattern(graphics, rect, node);
			}

			graphics.setColor(Color.BLACK);
			graphics.draw(rect);
		} else {
			for (ITreeMapNode<T> child : node.getChildren()) {
				renderTreeMap(child, graphics);
			}
		}
	}

	/** Draws the pattern. */
	private <T> void drawPattern(Graphics2D graphics, Rectangle2D rect,
			ITreeMapNode<T> node) {
		IDrawingPattern drawingPattern = node.getDrawingPattern();
		graphics.setColor(node.getPatternColor());
		for (int x = (int) rect.getMinX(); x <= rect.getMaxX(); ++x) {
			for (int y = (int) rect.getMinY(); y <= rect.getMaxY(); ++y) {
				if (drawingPattern.isForeground(x, y)) {
					graphics.fill(new Rectangle(x, y, 1, 1));
				}
			}
		}
	}

}