/*--------------------------------------------------------------------------+
$Id: AssessmentTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.assessment;

import static edu.tum.cs.commons.assessment.ETrafficLightColor.GREEN;
import static edu.tum.cs.commons.assessment.ETrafficLightColor.RED;
import static edu.tum.cs.commons.assessment.ETrafficLightColor.UNKNOWN;
import static edu.tum.cs.commons.assessment.ETrafficLightColor.YELLOW;
import junit.framework.TestCase;

/**
 * Test the Assessment class.
 * 
 * @author Benjamin Hummel
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 8335E833079ACE75F91CFCA1F493925D
 */
public class AssessmentTest extends TestCase {

	/** Test getDominantColor. */
	public void testDominantColor() {
		Assessment a1 = new Assessment();

		assertEquals(a1.getDominantColor(), UNKNOWN);

		a1.add(GREEN);
		a1.add(UNKNOWN);
		assertEquals(a1.getDominantColor(), GREEN);

		a1.add(YELLOW);
		assertEquals(a1.getDominantColor(), YELLOW);

		a1.add(RED);
		assertEquals(a1.getDominantColor(), RED);
	}

	/** Test getMostFrequentColor. */
	public void testMostFrequentColor() {
		Assessment a1 = new Assessment();

		assertEquals(a1.getMostFrequentColor(), UNKNOWN);

		a1.add(UNKNOWN);
		a1.add(GREEN);
		a1.add(YELLOW);
		a1.add(RED);

		a1.add(UNKNOWN);
		assertEquals(a1.getMostFrequentColor(), UNKNOWN);

		a1.add(GREEN);
		assertEquals(a1.getMostFrequentColor(), GREEN);

		a1.add(YELLOW);
		assertEquals(a1.getMostFrequentColor(), YELLOW);

		a1.add(RED);
		assertEquals(a1.getMostFrequentColor(), RED);

	}

}