/*--------------------------------------------------------------------------+
$Id: DateUtilsTest.java 29589 2010-08-09 15:38:43Z hummelb $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.date;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import edu.tum.cs.commons.collections.CollectionUtils;
import edu.tum.cs.commons.test.CCSMTestCaseBase;

/**
 * Test case for {@link DateUtils}
 * 
 * @author ladmin
 * @author $Author: hummelb $
 * @version $Rev: 29589 $
 * @levd.rating GREEN Hash: 380AEB3FFACAFF1783C8F1A83A6B3850
 */
public class DateUtilsTest extends CCSMTestCaseBase {

	/** Earliest date */
	private final Date date1 = new Date(1281102981328L);

	/** Intermediate date */
	private final Date date2 = new Date(1281102981329L);

	/** Latest date */
	private final Date date3 = new Date(1281102981528L);

	/** {@link DateUtils#getEarliest(java.util.Collection)} */
	public void testGetEarliest() {
		assertNull(DateUtils.getEarliest(new ArrayList<Date>()));
		assertSame(date1, DateUtils.getEarliest(dates()));
		assertSame(date1, DateUtils.getEarliest(CollectionUtils
				.reverse(dates())));
	}

	/** Test case for {@link DateUtils#getLatest(java.util.Collection)} */
	public void testGetLatest() {
		assertNull(DateUtils.getLatest(new ArrayList<Date>()));
		assertSame(date3, DateUtils.getLatest(dates()));
		assertSame(date3, DateUtils.getLatest(CollectionUtils.reverse(dates())));
	}

	/** Create array of test date objects */
	private List<Date> dates() {
		return Arrays.asList(new Date[] { date1, date2, date3 });
	}

	/** Test case for {@link DateUtils#min(Date, Date)} */
	public void testGetMin() {
		// test null parameters
		assertEquals(null, DateUtils.min(null, date1));
		assertEquals(null, DateUtils.min(date1, null));
		assertEquals(null, DateUtils.min(null, null));

		// test same date
		assertEquals(date1, DateUtils.min(date1, date1));

		// test different dates
		assertEquals(date1, DateUtils.min(date2, date1));
		assertEquals(date1, DateUtils.min(date1, date2));
		assertEquals(date1, DateUtils.min(date1, date3));
		assertEquals(date1, DateUtils.min(date3, date1));
	}

	/** Test case for {@link DateUtils#min(Date, Date)} */
	public void testGetMax() {
		// test null parameters
		assertEquals(null, DateUtils.max(null, date3));
		assertEquals(null, DateUtils.max(date3, null));
		assertEquals(null, DateUtils.max(null, null));

		// test same date
		assertEquals(date3, DateUtils.min(date3, date3));

		// test different dates
		assertEquals(date3, DateUtils.max(date2, date3));
		assertEquals(date3, DateUtils.max(date3, date2));
		assertEquals(date3, DateUtils.max(date1, date3));
		assertEquals(date3, DateUtils.max(date3, date1));
	}

}
