/*--------------------------------------------------------------------------+
$Id: FormalParameterTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import junit.framework.TestCase;
import edu.tum.cs.commons.string.StringUtils;

/**
 * Tests for <code>FormalParameter</code>
 * 
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: DBF2D094E1FD0E1F12CF8253BA8A3C4D
 */
public class FormalParameterTest extends TestCase {

    /** Formal parameter with a type <code>String</code>. */
    private FormalParameter referenceTypeParameter;

    /** Formal parameter with a type <code>int</code>. */
    private FormalParameter primitiveTypeParameter;

    /** Formal parameter with a type <code>String[]</code>. */
    private FormalParameter referenceArrayTypeParameter;

    /** Formal parameter with a type <code>char[]</code>. */
    private FormalParameter primitiveArrayTypeParameter;

    /** Formal parameter with annotations. */
    private FormalParameter annotatedParameter;

    /** Create test parmeters. */
    @Override
	protected void setUp() throws Exception {
        super.setUp();

        Class<?>[] parameters0 = { String.class };
        Method method0 = String.class.getMethod("compareTo", parameters0);
        referenceTypeParameter = new FormalParameter(method0, 0);

        Class<?>[] parameters1 = { int.class };
        Method method1 = String.class.getMethod("charAt", parameters1);
        primitiveTypeParameter = new FormalParameter(method1, 0);

        Class<?>[] parameters2 = { char[].class, int.class, int.class };
        Method method2 = String.class.getMethod("copyValueOf", parameters2);
        primitiveArrayTypeParameter = new FormalParameter(method2, 0);

        Class<?>[] parameters3 = { String[].class, String[].class };
        Method method3 = StringUtils.class.getMethod("concat", parameters3);
        referenceArrayTypeParameter = new FormalParameter(method3, 1);

        Class<?>[] parameters4 = { String.class };
        Method method4 = TestClass.class.getMethod("testMethod", parameters4);
        annotatedParameter = new FormalParameter(method4, 0);

    }

    /**
     * Test method for 'edu.tum.cs.commons.reflect.FormalParameter.getType()'
     */
    public void testGetType() {
        assertEquals(String.class, referenceTypeParameter.getType());
        assertEquals(int.class, primitiveTypeParameter.getType());
        assertEquals(String[].class, referenceArrayTypeParameter.getType());
        assertEquals(char[].class, primitiveArrayTypeParameter.getType());
        assertEquals(String.class, annotatedParameter.getType());
    }

    /**
     * Test method for
     * 'edu.tum.cs.commons.reflect.FormalParameter.getAnnotations()'
     */
    public void testGetAnnotations() {
        assertEquals(0, referenceTypeParameter.getAnnotations().length);

        Annotation[] annotations = annotatedParameter.getAnnotations();
        assertEquals(2, annotations.length);

        assertEquals(ATestParameterAnnotation1.class, annotations[0].annotationType());
        assertEquals(ATestParameterAnnotation2.class, annotations[1].annotationType());
    }
    
    /**
     * Test method for
     * 'edu.tum.cs.commons.reflect.FormalParameter.getAnnotation()'
     */
    public void testGetAnnotation() {

        ATestParameterAnnotation1 annotation1 = annotatedParameter
                .getAnnotation(ATestParameterAnnotation1.class);
        assertNotNull(annotation1);

        assertEquals(ATestParameterAnnotation1.class, annotation1.annotationType());

        ATestParameterAnnotation2 annotation2 = annotatedParameter
                .getAnnotation(ATestParameterAnnotation2.class);
        assertNotNull(annotation2);

        assertEquals(ATestParameterAnnotation2.class, annotation2.annotationType());

        Annotation annotation = annotatedParameter
                .getAnnotation(SuppressWarnings.class);
        assertNull(annotation);
    }
    
    /**
     * Test method for
     * 'edu.tum.cs.commons.reflect.FormalParameter.isAnnotationPresent()'
     */
    public void testIsAnnotationPresent() {
        assertTrue(annotatedParameter
                .isAnnotationPresent(ATestParameterAnnotation1.class));
        assertTrue(annotatedParameter
                .isAnnotationPresent(ATestParameterAnnotation2.class));
        assertFalse(annotatedParameter
                .isAnnotationPresent(SuppressWarnings.class));
    }

    /**
     * Test method for 'edu.tum.cs.commons.reflect.FormalParameter.hashCode()'
     */
    public void testHashCode() throws SecurityException, NoSuchMethodException {
        Class<?>[] parameters0 = { String.class };
        Method method0 = String.class.getMethod("compareTo", parameters0);
        FormalParameter parameter = new FormalParameter(method0, 0);

        assertEquals(parameter.hashCode(), referenceTypeParameter.hashCode());
    }

    /**
     * Test method for
     * 'edu.tum.cs.commons.reflect.FormalParameter.equals(Object)'
     */
    public void testEqualsObject() throws SecurityException,
            NoSuchMethodException {
        assertFalse(primitiveTypeParameter.equals(referenceTypeParameter));

        Class<?>[] parameters0 = { String.class };
        Method method0 = String.class.getMethod("compareTo", parameters0);
        FormalParameter parameter = new FormalParameter(method0, 0);

        assertEquals(parameter, referenceTypeParameter);
    }

}