/*--------------------------------------------------------------------------+
$Id: CollectingExceptionHandler.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.error;

import java.util.ArrayList;
import java.util.List;

import edu.tum.cs.commons.collections.CollectionUtils;
import edu.tum.cs.commons.collections.UnmodifiableList;

/**
 * An exception handler that collects exceptions for later use.
 * 
 * @author hummelb
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 7696FFE0F017E8EE1D6F8B382A43B3B3
 */
public class CollectingExceptionHandler<X extends Exception> implements
		IExceptionHandler<X, NeverThrownRuntimeException> {

	/** The exceptions stored. */
	private final List<X> exceptions = new ArrayList<X>();

	/** {@inheritDoc} */
	public void handleException(X exception) throws NeverThrownRuntimeException {
		exceptions.add(exception);
	}

	/** Returns the list of exception caught so far. */
	public UnmodifiableList<X> getExceptions() {
		return CollectionUtils.asUnmodifiable(exceptions);
	}

	/** Clears the list of exceptions. */
	public void clearExceptions() {
		exceptions.clear();
	}
}