/*--------------------------------------------------------------------------+
$Id: ArrayUtilsTest.java 29696 2010-08-13 10:31:31Z deissenb $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.collections;

import edu.tum.cs.commons.test.CCSMTestCaseBase;

/**
 * Tests for {@link ArrayUtils}.
 * 
 * @author hummelb
 * @author $Author: deissenb $
 * @version $Rev: 29696 $
 * @levd.rating GREEN Hash: 288E701EE864F985AADA6636598568F5
 */
public class ArrayUtilsTest extends CCSMTestCaseBase {

	/** Tests the {@link ArrayUtils#isPrefix(byte[], byte[])} method. */
	public void testPrefix() {
		assertTrue(ArrayUtils.isPrefix(new byte[] { 1, 2, 3, 4 }, new byte[] {
				1, 2, 3, 4, 5 }));
		assertTrue(ArrayUtils.isPrefix(new byte[] { 1, 2, 3, 4 }, new byte[] {
				1, 2, 3, 4 }));
		assertFalse(ArrayUtils.isPrefix(new byte[] { 1, 2, 3, 4 }, new byte[] {
				1, 2, 3 }));
		assertFalse(ArrayUtils.isPrefix(new byte[] { 1, 2, 3, 4 }, new byte[] {
				1, 2, 3, 5, 6, 7 }));

		// empty prefix
		assertTrue(ArrayUtils.isPrefix(new byte[] {}, new byte[] { 5, 6 }));
		assertTrue(ArrayUtils.isPrefix(new byte[] {}, new byte[] {}));
	}

}
