/******************************************************************
 *  $Id: ex4.c,v 1.1 2004/06/02 11:20:50 snowdrop Exp $
 *
 * CSOAP Project:  A SOAP client/server library in C
 * Copyright (C) 2003  Ferhat Ayaz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 * 
 * Email: ayaz@jprogrammet.net
 ******************************************************************/

/* This header will be generated by xsd2c */
#include "Person_xsd.h"

 /* For stdout writers */
#include "../utils.h"

#include <libxml/parser.h>


struct Person* LoadFromFile(const char* filename)
{
  struct Person* person; /* object created by xsd2c */

	xmlDocPtr doc;
	xmlNodePtr cur;

	doc = xmlParseFile(filename);
	
	if (doc == NULL ) {
		fprintf(stderr,"Document not parsed successfully. \n");
		return NULL;
	}
	
	cur = xmlDocGetRootElement(doc);
	
	if (cur == NULL) {
		fprintf(stderr,"empty document\n");
		xmlFreeDoc(doc);
		return NULL;
	}
  
  printf("Deserialize ...\n");
  person = Person_Deserialize(cur);
  printf("Deserialize complete\n");
	
	xmlFreeDoc(doc);
  
  return person;
}

int main(int argc, char *argv[])
{
  struct Person* person; /* object created by xsd2c */

  if (argc < 2) {
    fprintf(stderr, "usage: %s <xml file>\n", argv[0]);
    return 1;
  }

  person = LoadFromFile(argv[1]);

  if (person == NULL) {
    fprintf(stderr, "Can not deserialize Person\n");
    return 1;
  }

  /* Serialize the Person object. (Just for test) 
    The 3 sax callback functions 
    will just print the data to stdout
  */
  Person_Sax_Serialize(person, "Employee", 
    Writer_StartElement, 
    Writer_Characters,
    Writer_EndElement, 0);

  /* Free the Person */
  Person_Free(person);

	return 0;
}
