/***************************************************************************
        cstring-find.cpp  -  Some tests for the CString Find functions
                             -------------------
    begin                : Thu Sep 11 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <dclib/core/cstring.h>

#include <stdio.h>

#define TESTS 43

int main( int, char*[] )
{
	long expected[TESTS];
	
	const CString empty;
	
	const CString fruits("apple orange banana grapefruit melon orange again");
	
	const CString orange("orange");
	
	const CString spanner("spanner");
	
	long r[TESTS];
	
	expected[0] = -1;
	expected[1] = 0;
	expected[2] = 8;
	expected[3] = -1;
	expected[4] = -1;
	r[0] = empty.Find( 'a' );
	r[1] = fruits.Find( 'a' );
	r[2] = fruits.Find( 'a', r[1]+1 );
	r[3] = fruits.Find( 'a', fruits.Length() + 2000 );
	r[4] = fruits.Find( 'q' );
	
	/* yes an empty string matches / starts with an empty string */
	expected[5] = 0;
	expected[6] = -1;
	expected[7] = 6;
	expected[8] = 37;
	expected[9] = -1;
	expected[10] = -1;
	r[5] = empty.Find( empty.Data() );
	r[6] = empty.Find( "apple" );
	r[7] = fruits.Find( "orange" );
	r[8] = fruits.Find( "orange", r[7]+1 );
	r[9] = fruits.Find( "spanner" );
	r[10] = fruits.Find( "orange", r[8]+1 );
	
	expected[11] = 0;
	expected[12] = -1;
	expected[13] = 6;
	expected[14] = 37;
	expected[15] = -1;
	expected[16] = -1;
	r[11] = empty.Find( empty );
	r[12] = empty.Find( orange );
	r[13] = fruits.Find( orange );
	r[14] = fruits.Find( orange, r[13]+1 );
	r[15] = fruits.Find( spanner );
	r[16] = fruits.Find( orange, r[14]+1 );
	
	expected[17] = 0;
	expected[18] = -1;
	expected[19] = 6;
	expected[20] = 37;
	expected[21] = -1;
	expected[22] = -1;
	r[17] = empty.FindCase( 0 );
	r[18] = empty.FindCase( "apple" );
	r[19] = fruits.FindCase( "orange" );
	r[20] = fruits.FindCase( "orange", r[19]+1 );
	r[21] = fruits.FindCase( "spanner" );
	r[22] = fruits.FindCase( "orange", r[20]+1 );
	
	expected[23] = 0;
	expected[24] = -1;
	expected[25] = 6;
	expected[26] = 37;
	expected[27] = -1;
	expected[28] = -1;
	r[23] = empty.FindCase( empty );
	r[24] = empty.FindCase( orange );
	r[25] = fruits.FindCase( orange );
	r[26] = fruits.FindCase( orange, r[25]+1 );
	r[27] = fruits.FindCase( spanner );
	r[28] = fruits.FindCase( orange, r[26]+1 );
	
	expected[29] = -1;
	expected[30] = -1;
	r[29] = empty.FindRev( 'a' );
	r[30] = empty.FindRev( 'a', 50 );
	
	expected[31] = -1;
	expected[32] = 37;
	expected[33] = 34;
	expected[34] = -1;
	r[31] = fruits.FindRev( 'q' );
	r[32] = fruits.FindRev( 'o' );
	r[33] = fruits.FindRev( 'o', r[32]-1 );
	r[34] = fruits.FindRev( 'b', 5 );
	
	expected[35] = 0;
	expected[36] = -1;
	r[35] = empty.FindRev( empty );
	r[36] = empty.FindRev( spanner );
	
	expected[37] = 37;
	expected[38] = -1;
	r[37] = fruits.FindRev( orange );
	r[38] = fruits.FindRev( spanner );
	
	expected[39] = 0;
	expected[40] = 48;
	r[39] = fruits.FindRev( 'a', 2 );
	r[40] = fruits.FindRev( 'n' );
	
	expected[41] = 0;
	expected[42] = 44;
	r[41] = fruits.FindRev( "apple" );
	r[42] = fruits.FindRev( "again" );
	
	int ret = 0;
	
	for ( int i = 0; i < TESTS; ++i )
	{
		if ( expected[i] != r[i] )
		{
			printf("CString Find test %d failed expected %ld got %ld\n",i,expected[i],r[i]);
			ret = 100;
		}
	}
	
	return ret;
}
