/*
 * @(#)Main1.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.compiler.testcode;

import net.sourceforge.groboutils.autodoc.v1.AutoDoc;


/**
 * Simple class to be recompiled.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:27 $
 * @since     December 20, 2002
 */
public class Main1
{
    private static final Class THIS_CLASS = Main1.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public static void main( String[] args )
    {
        System.out.println( THIS_CLASS );
        DOC.getLog().info( "Inside Main1" );
        cover( "test", (short)0, Short.MAX_VALUE, Short.MIN_VALUE );
        
        Passed.passed( "Main1" );
    }
    
    public static void cover( String classSig,
            short methodIndex, short channel, short markIndex )
    {
        System.out.println( "Main1.cover: "+classSig );
        DOC.getLog().info( "!!cover!!" );
    }
}

